QUIGLINE 1
;-------------------------------------------------------------------------------------------------
QUIGLINE 2
;
QUIGLINE 3
; Quigs 1.01 Application for Symbos 3.1
QUIGLINE 4
;
QUIGLINE 5
; Name:		SePlayer
QUIGLINE 6
; Coder:	Tmtlogic
QUIGLINE 7
; Date / 	Version:	23-01-2025
QUIGLINE 8
;
QUIGLINE 9
;-------------------------------------------------------------------------------------------------
QUIGLINE 10
; === var IO R/SF3 TNC-MSX
QUIGLINE 11

QUIGLINE 12
Var ioA_0:Int
QUIGLINE 13
Var ioA_1:Int
QUIGLINE 14
Var ioA_2:Int
QUIGLINE 15
Var ioA_3:Int
QUIGLINE 16
Var ioA_4:Int
QUIGLINE 17
Var ioA_5:Int
QUIGLINE 18
Var ioA_6:Int
QUIGLINE 19
Var ioA_7:Int
QUIGLINE 20
Var ioA_8:Int
QUIGLINE 21
Var ioA_9:Int
QUIGLINE 22
Var ioA_A:Int
QUIGLINE 23
Var ioA_B:Int
QUIGLINE 24
Var ioA_C:Int
QUIGLINE 25
Var ioA_D:Int
QUIGLINE 26
Var ioA_E:Int
QUIGLINE 27
Var ioA_F:Int
QUIGLINE 28

QUIGLINE 29
Var iResp:Int =0						// response value of the SF3
QUIGLINE 30
Var bWifiErr:Int
QUIGLINE 31

QUIGLINE 32
;-------------------------------------------------------------------------------------------------
QUIGLINE 33
; === Defines  ===
QUIGLINE 34

QUIGLINE 35
Var defNetStatusBitTx:Byte		= 128	//=1 Tx Buffer is full
QUIGLINE 36
Var defNetStatusBitRx:Byte		= 64	//=1 Data to read
QUIGLINE 37
Var defNetStatusBitError:Byte	= 32	//=0 then no Errors
QUIGLINE 38
Var defNetStatusBitVoip:Byte	= 16	//'=0 then voip not active
QUIGLINE 39
Var defNetStatusBitUser:Byte	=  8	//'=0 then no user changes online/offline
QUIGLINE 40
Var defNetStatusBitShMem:Byte	=  4	//'=0 then no memory share changes
QUIGLINE 41
Var defNetStatusBitMsg:Byte		=  2	//'=0 then no new messages
QUIGLINE 42
Var defNetStatusBitSys:Byte		=  1	//'=0 then no system response data
QUIGLINE 43

QUIGLINE 44
var defVoipIdle:int				=0		// rust
QUIGLINE 45
var defVoipOutgoingCall:int		=1		// je hoort dat het overgaat
QUIGLINE 46
var defVoipOtherBusy:int		=2		// je hoort dat de lijn bezet is
QUIGLINE 47
var defVoipOtherOffline:int		=3		// je hoort dat de persoon waarmee je wil bellen niet online is
QUIGLINE 48
var defVoipIncommingCall:int	=4		// iemand beld je dus de ringtone moet overgaan
QUIGLINE 49
var defVoipActiveCall:int		=5		// Bellen actief ,Mic is running
QUIGLINE 50

QUIGLINE 51
;-------------------------------------------------------------------------------------------------
QUIGLINE 52
; === var system ===
QUIGLINE 53

QUIGLINE 54
Var bMainActive:Int = 0
QUIGLINE 55
Var sHardware:String 					// RSF3 SF3 TNC
QUIGLINE 56
Var bSeoneType:int = 0	 				// 1 = real SEONE
QUIGLINE 57

QUIGLINE 58
Var sCPU:String	 						// EP CPC MSX
QUIGLINE 59
Var sFirmware:String = "20230715"		// ARM Firmware  needed
QUIGLINE 60

QUIGLINE 61
Var sText:String
QUIGLINE 62

QUIGLINE 63
Var iStpStartup:Int=0
QUIGLINE 64

QUIGLINE 65
Var iDelay:Int=2
QUIGLINE 66
Var iDelayCt:Int=0
QUIGLINE 67

QUIGLINE 68
Var sDb:String
QUIGLINE 69
var dbStp:int
QUIGLINE 70
var iDbL:int
QUIGLINE 71
var iDbT:int
QUIGLINE 72
var iDbC:int
QUIGLINE 73

QUIGLINE 74
var iAppExit:int=0
QUIGLINE 75

QUIGLINE 76
var iTimeOut:int = 0
QUIGLINE 77

QUIGLINE 78
var fc:int
QUIGLINE 79
var fn:int
QUIGLINE 80
var fx:int
QUIGLINE 81
var fy:int
QUIGLINE 82
var fsw:int
QUIGLINE 83

QUIGLINE 84
Var u8In1:Int
QUIGLINE 85
Var u8In2:Int
QUIGLINE 86

QUIGLINE 87
Var u8Out1:Int
QUIGLINE 88
Var u8Out2:Int
QUIGLINE 89
Var u8Out3:Int
QUIGLINE 90
Var u8Out4:Int
QUIGLINE 91
Var u8Out5:Int
QUIGLINE 92

QUIGLINE 93
Var u16In1:Int
QUIGLINE 94

QUIGLINE 95
Var u16Out1:Int
QUIGLINE 96
Var u16Out2:Int
QUIGLINE 97
Var u16Out3:Int
QUIGLINE 98
Var u16Out4:Int
QUIGLINE 99
Var u16Out5:Int
QUIGLINE 100
Var u16Out6:Int
QUIGLINE 101
Var u16Out7:Int
QUIGLINE 102
Var u16Out8:Int
QUIGLINE 103

QUIGLINE 104
Var sIn1:String
QUIGLINE 105

QUIGLINE 106
Var sOut1:String
QUIGLINE 107
Var sOut2:String
QUIGLINE 108
Var sOut3:String
QUIGLINE 109
Var sOut4:String
QUIGLINE 110

QUIGLINE 111

QUIGLINE 112
;-------------------------------------------------------------------------------------------------
QUIGLINE 113
; === Tmtnet ===
QUIGLINE 114

QUIGLINE 115
Var sAppname		:String
QUIGLINE 116
Var u16MyUserID		:Int = 0
QUIGLINE 117
Var sUserPass		:String
QUIGLINE 118

QUIGLINE 119
Var u16UserOnline(10)	:int
QUIGLINE 120
Var	iUserOnlineTotal	:int
QUIGLINE 121

QUIGLINE 122
Var	u8NetStatus:int
QUIGLINE 123

QUIGLINE 124
Var u8h:int
QUIGLINE 125
Var u8l:int
QUIGLINE 126
Var u8d:int
QUIGLINE 127

QUIGLINE 128
Var w:int
QUIGLINE 129

QUIGLINE 130
var iUserOnlineTimer :int = 0
QUIGLINE 131

QUIGLINE 132
;-------------------------------------------------------------------------------------------------
QUIGLINE 133
; === var diverse ===
QUIGLINE 134

QUIGLINE 135
Var sPanMode:string="TIME"
QUIGLINE 136
var u8CharTable(100):byte			// charTable(ascii 65) = tile 0
QUIGLINE 137

QUIGLINE 138
Var ImgIds(33):Int
QUIGLINE 139

QUIGLINE 140
var sDisplay1:string
QUIGLINE 141
var sDisplay2:string
QUIGLINE 142

QUIGLINE 143
var bDisplayScroll:byte = 0
QUIGLINE 144
var iDisplayScrollLen:int
QUIGLINE 145
var iDisplayScrollPos:int
QUIGLINE 146
var iDisplCt:int
QUIGLINE 147

QUIGLINE 148
var iVuCt:int
QUIGLINE 149

QUIGLINE 150
var sTrim:string
QUIGLINE 151
var sTrimOut:string
QUIGLINE 152

QUIGLINE 153
;-------------------------------------------------------------------------------------------------
QUIGLINE 154
var a:int
QUIGLINE 155
var c:int
QUIGLINE 156
var l:int
QUIGLINE 157
var s:int
QUIGLINE 158
var t:int
QUIGLINE 159
var x:int
QUIGLINE 160
var y:int
QUIGLINE 161

QUIGLINE 162

QUIGLINE 163
;-------------------------------------------------------------------------------------------------
QUIGLINE 164
//	=== Files system ===
QUIGLINE 165

QUIGLINE 166
var fDiskWeb:file
QUIGLINE 167
var fDiskRc:file
QUIGLINE 168

QUIGLINE 169

QUIGLINE 170
;-------------------------------------------------------------------------------------------------
QUIGLINE 171
//	=== Sheets ===
QUIGLINE 172

QUIGLINE 173
Var shSe_char:Sheet			//..  16x22
QUIGLINE 174
Var shSe_voip:Sheet			//..  20z20
QUIGLINE 175
Var shSe_vu:Sheet			//..  47x 4
QUIGLINE 176
Var shSe_hor:Sheet			//.. 130x 4
QUIGLINE 177
Var shSe_vert:Sheet			//..  1 single
QUIGLINE 178

QUIGLINE 179
;-------------------------------------------------------------------------------------------------
QUIGLINE 180
; === TIME varables
QUIGLINE 181

QUIGLINE 182
var iTimeCt:int
QUIGLINE 183
;-------------------------------------------------------------------------------------------------
QUIGLINE 184
// === var Socket  ===
QUIGLINE 185

QUIGLINE 186
Var iSock:Int = 0
QUIGLINE 187

QUIGLINE 188
Var iIp(5):int
QUIGLINE 189
Var iPortHigh:Int
QUIGLINE 190
Var iPortlow:Int
QUIGLINE 191
Var sGet:String
QUIGLINE 192
Var sStationName:string
QUIGLINE 193
Var sUrlSend:string
QUIGLINE 194

QUIGLINE 195

QUIGLINE 196

QUIGLINE 197
;-------------------------------------------------------------------------------------------------
QUIGLINE 198
; === WEBRADIO varables
QUIGLINE 199

QUIGLINE 200
Var sWebDiplayMode:string						// "FILES" "STATIONS"
QUIGLINE 201

QUIGLINE 202
Var sWebWrcList(10):string						// List with founded WRC files
QUIGLINE 203
Var iWebWrcActive:int
QUIGLINE 204
Var iWebWrcMax:int
QUIGLINE 205

QUIGLINE 206
Var sWebStation(20):string
QUIGLINE 207
Var iWebStationActive:int
QUIGLINE 208
Var iWebStationMax:int
QUIGLINE 209
var iWebStreamStatus:int=0						// 0 off 1 on, 2 pauze, 3 stop,  255 err,
QUIGLINE 210

QUIGLINE 211
;-------------------------------------------------------------------------------------------------
QUIGLINE 212
; === var SEONE
QUIGLINE 213

QUIGLINE 214
var sAtCmd:string
QUIGLINE 215
var sAtResp:string
QUIGLINE 216
var sAtData:string
QUIGLINE 217

QUIGLINE 218
var sSePath:string
QUIGLINE 219
var sSePathCompr:string
QUIGLINE 220
var sMp3bFileList(50):string
QUIGLINE 221
var iMp3bFileListMax:int
QUIGLINE 222
var sMsdFile:string
QUIGLINE 223
var iMp3bFileListActive:int
QUIGLINE 224
var bMp3bAudioStreamActive:int
QUIGLINE 225

QUIGLINE 226
;-------------------------------------------------------------------------------------------------
QUIGLINE 227
; === var VOIP
QUIGLINE 228

QUIGLINE 229
var iVoipStatus:int
QUIGLINE 230
var iVoipStatusOld:int
QUIGLINE 231
var u16OtherUserId:int
QUIGLINE 232
var iVoipSoundSelect:int=0
QUIGLINE 233
var iVoipSoundCt:int
QUIGLINE 234
var iVoipSoundSeq:int
QUIGLINE 235
var iUserOnlinePointer:int
QUIGLINE 236

QUIGLINE 237

QUIGLINE 238
;-------------------------------------------------------------------------------------------------
QUIGLINE 239
; === var RC
QUIGLINE 240

QUIGLINE 241
Var iRcCt:Int
QUIGLINE 242
Var iRcContent:Int
QUIGLINE 243
Var sRcCode:String
QUIGLINE 244
Var sRcCodeList(12):String
QUIGLINE 245
Var bRcCodeReceived:Int
QUIGLINE 246
Var iRcItems:Int = 10
QUIGLINE 247
Var bRcLearnActive:Int=0
QUIGLINE 248

QUIGLINE 249
;-------------------------------------------------------------------------------------------------
QUIGLINE 250
; ---	FORM 1 field play field
QUIGLINE 251

QUIGLINE 252
Function Form1.Open.Event:Void()
QUIGLINE 253
	Initialize
QUIGLINE 254
EndF
QUIGLINE 255

QUIGLINE 256
Function Form1.Close.Event:Void()
QUIGLINE 257
	iAppExit = 1
QUIGLINE 258
EndF
QUIGLINE 259

QUIGLINE 260
;---	FORM 1 buttons
QUIGLINE 261

QUIGLINE 262

QUIGLINE 263

QUIGLINE 264
Function Button4.Event:Void()
QUIGLINE 265
	;=== But up
QUIGLINE 266
	if(sPanMode = "WEBRADIO") then
QUIGLINE 267
	WebWrcInc //WebStationInc
QUIGLINE 268
	endif
QUIGLINE 269
	
QUIGLINE 270
	if(sPanMode = "MP3-B") then
QUIGLINE 271
	Mp3bPathUp
QUIGLINE 272
	endif
QUIGLINE 273
	
QUIGLINE 274
	endf
QUIGLINE 275
	
QUIGLINE 276
	Function Button5.Event:Void()
QUIGLINE 277
	;=== But down
QUIGLINE 278
	if(sPanMode = "WEBRADIO") then
QUIGLINE 279
	WebWrcDec   //WebStationDec
QUIGLINE 280
	endif
QUIGLINE 281
	
QUIGLINE 282
	if(sPanMode = "MP3-B") then
QUIGLINE 283
	Mp3bPathDown
QUIGLINE 284
	endif
QUIGLINE 285
	
QUIGLINE 286
	endf
QUIGLINE 287
	
QUIGLINE 288
	
QUIGLINE 289
	Function Button6.Event:Void()
QUIGLINE 290
	;=== But <<
QUIGLINE 291
	if(sPanMode="WEBRADIO") then
QUIGLINE 292
	WebStationDec //WebWrcDec
QUIGLINE 293
	endif
QUIGLINE 294
	
QUIGLINE 295
	if(sPanMode="FM") then
QUIGLINE 296
	FmFreqDown
QUIGLINE 297
	endif
QUIGLINE 298
	
QUIGLINE 299
	if(sPanMode="MP3-B") then
QUIGLINE 300
	Mp3bFilePrev
QUIGLINE 301
	endif
QUIGLINE 302
	
QUIGLINE 303
	if(sPanMode="VOIP") then
QUIGLINE 304
	VoipUserDec
QUIGLINE 305
	endif
QUIGLINE 306
	
QUIGLINE 307
	endf
QUIGLINE 308
	
QUIGLINE 309
	Function Button7.Event:Void()
QUIGLINE 310
	;=== But >>
QUIGLINE 311
	if(sPanMode="WEBRADIO") then
QUIGLINE 312
	WebStationInc//WebWrcInc
QUIGLINE 313
	endif
QUIGLINE 314
	
QUIGLINE 315
	if(sPanMode="FM") then
QUIGLINE 316
	FmFreqUp
QUIGLINE 317
	endif
QUIGLINE 318
	
QUIGLINE 319
	if(sPanMode="MP3-B") then
QUIGLINE 320
	Mp3bFileNext
QUIGLINE 321
	endif
QUIGLINE 322
	
QUIGLINE 323
	if(sPanMode="VOIP") then
QUIGLINE 324
	VoipUserInc
QUIGLINE 325
	endif
QUIGLINE 326
	
QUIGLINE 327
	
QUIGLINE 328
	endf
QUIGLINE 329
	
QUIGLINE 330
	Function Button8.Event:Void()
QUIGLINE 331
	; === But Play
QUIGLINE 332
	
QUIGLINE 333
	if (sPanMode = "WEBRADIO") then
QUIGLINE 334
	if (iWebStreamStatus = 0) then
QUIGLINE 335
	WebStreamPlay
QUIGLINE 336
	endif
QUIGLINE 337
	endif
QUIGLINE 338
	
QUIGLINE 339
	if (sPanMode = "MP3-B") then
QUIGLINE 340
	if (bMp3bAudioStreamActive  = 0) then
QUIGLINE 341
	Mp3bFilePlay
QUIGLINE 342
	endif
QUIGLINE 343
	endif
QUIGLINE 344
	
QUIGLINE 345
	endf
QUIGLINE 346
	
QUIGLINE 347
	Function Button9.Event:Void()
QUIGLINE 348
	; === But Pause
QUIGLINE 349
	
QUIGLINE 350
	//sDb= " Form1 state: "+str(Form1.state):sysDebug
QUIGLINE 351
	//sDb= " Form2 state: "+str(Form2.state):sysDebug
QUIGLINE 352
	
QUIGLINE 353
	iVoipSoundSelect = 2
QUIGLINE 354
EndF
QUIGLINE 355

QUIGLINE 356
Function Button10.Event:Void()
QUIGLINE 357
	; === But Stop
QUIGLINE 358
	If (sPanMode = "WEBRADIO") Then
QUIGLINE 359
		If (iWebStreamStatus > 0) Then
QUIGLINE 360
			WebStreamStop
QUIGLINE 361
		EndIf
QUIGLINE 362
	EndIf
QUIGLINE 363
	
QUIGLINE 364
	If (sPanMode = "MP3-B") Then
QUIGLINE 365
		If (bMp3bAudioStreamActive  = 1) Then
QUIGLINE 366
			Mp3bFileStop
QUIGLINE 367
		EndIf
QUIGLINE 368
	EndIf
QUIGLINE 369
EndF
QUIGLINE 370

QUIGLINE 371
;--- 	FORM1 Events
QUIGLINE 372

QUIGLINE 373
Function Label1.Event:Void()
QUIGLINE 374
	If(sPanMode <> "WEBRADIO") Then
QUIGLINE 375
		Web_init
QUIGLINE 376
	EndIf
QUIGLINE 377
EndF
QUIGLINE 378

QUIGLINE 379
Function Label2.Event:Void()
QUIGLINE 380
	If(sPanMode <> "MP3_B") Then
QUIGLINE 381
		Mp3b_init
QUIGLINE 382
	EndIf
QUIGLINE 383
EndF
QUIGLINE 384

QUIGLINE 385
Function Label3.Event:Void()
QUIGLINE 386
	If(sPanMode <> "FM") Then
QUIGLINE 387
		FM_init
QUIGLINE 388
	EndIf
QUIGLINE 389
EndF
QUIGLINE 390

QUIGLINE 391
Function Label4.Event:Void()
QUIGLINE 392
	if (bRcLearnActive = 0) then
QUIGLINE 393
	RcLearn_init
QUIGLINE 394
	endif
QUIGLINE 395
	endf
QUIGLINE 396
	
QUIGLINE 397
	
QUIGLINE 398
	Function Label5.Event:Void()
QUIGLINE 399
	if(sPanMode <> "VOIP") then
QUIGLINE 400
	Voip_init
QUIGLINE 401
	endif
QUIGLINE 402
	endf
QUIGLINE 403
	
QUIGLINE 404
	
QUIGLINE 405
	Function Label6.Event:Void()
QUIGLINE 406
	
QUIGLINE 407
	sPanMode =  "MIDI"
QUIGLINE 408
	
QUIGLINE 409
	sDisplay1 = "              " + "HELLO DIT IS EEN SCROLL TEST OM TE KIJKEN OF HET EEN BEETJE WERKT"+ "              "
QUIGLINE 410
	bDisplayScroll = 1
QUIGLINE 411
	iDisplayScrollLen = len(sDisplay1)
QUIGLINE 412
	iDisplayScrollPos = 1
QUIGLINE 413
	endf
QUIGLINE 414
	
QUIGLINE 415
	Function image13.Event:Void()
QUIGLINE 416
	; === But voip Green
QUIGLINE 417
	
QUIGLINE 418
	if(sPanMode = "VOIP") then
QUIGLINE 419
	VoipGreenButton
QUIGLINE 420
	endif
QUIGLINE 421
	endf
QUIGLINE 422
	
QUIGLINE 423
	Function image14.Event:Void()
QUIGLINE 424
	; === But voip Red
QUIGLINE 425
	
QUIGLINE 426
	if(sPanMode = "VOIP") then
QUIGLINE 427
	VoipRedButton
QUIGLINE 428
	endif
QUIGLINE 429
	endf
QUIGLINE 430
	
QUIGLINE 431
	;-------------------------------------------------------------------------------------------------
QUIGLINE 432
	; ---	FORM 2 RC learn
QUIGLINE 433
	
QUIGLINE 434
	Function Form2.Open.Event:Void()
QUIGLINE 435
	
QUIGLINE 436
EndF
QUIGLINE 437

QUIGLINE 438
Function Form2.Close.Event:Void()
QUIGLINE 439
	bRcLearnActive = 0
QUIGLINE 440
	RcSaveList
QUIGLINE 441
	Form2.close
QUIGLINE 442
EndF
QUIGLINE 443

QUIGLINE 444
;-------------------------------------------------------------------------------------------------
QUIGLINE 445
; ---	FORM 2 Events
QUIGLINE 446

QUIGLINE 447
Function Label30.Event:Void()
QUIGLINE 448
	Label30.text.set sRcCode:Label30.refresh
QUIGLINE 449
	sRcCodeList(0) = sRcCode
QUIGLINE 450
	endf
QUIGLINE 451
	
QUIGLINE 452
	Function Label31.Event:Void()
QUIGLINE 453
	Label31.text.set sRcCode:Label31.refresh
QUIGLINE 454
	sRcCodeList(1) = sRcCode
QUIGLINE 455
	endf
QUIGLINE 456
	
QUIGLINE 457
	Function Label32.Event:Void()
QUIGLINE 458
	Label32.text.set sRcCode:Label32.refresh
QUIGLINE 459
	sRcCodeList(2) = sRcCode
QUIGLINE 460
	endf
QUIGLINE 461
	
QUIGLINE 462
	Function Label33.Event:Void()
QUIGLINE 463
	Label33.text.set sRcCode:Label33.refresh
QUIGLINE 464
	sRcCodeList(3) = sRcCode
QUIGLINE 465
	endf
QUIGLINE 466
	
QUIGLINE 467
	Function Label34.Event:Void()
QUIGLINE 468
	Label34.text.set sRcCode:Label34.refresh
QUIGLINE 469
	sRcCodeList(4) = sRcCode
QUIGLINE 470
	endf
QUIGLINE 471
	
QUIGLINE 472
	Function Label35.Event:Void()
QUIGLINE 473
	Label35.text.set sRcCode:Label35.refresh
QUIGLINE 474
	sRcCodeList(5) = sRcCode
QUIGLINE 475
	endf
QUIGLINE 476
	
QUIGLINE 477
	Function Label36.Event:Void()
QUIGLINE 478
	Label36.text.set sRcCode:Label36.refresh
QUIGLINE 479
	sRcCodeList(6) = sRcCode
QUIGLINE 480
	endf
QUIGLINE 481
	
QUIGLINE 482
	Function Label37.Event:Void()
QUIGLINE 483
	Label37.text.set sRcCode:Label37.refresh
QUIGLINE 484
	sRcCodeList(7) = sRcCode
QUIGLINE 485
	endf
QUIGLINE 486
	
QUIGLINE 487
	Function Label38.Event:Void()
QUIGLINE 488
	Label38.text.set sRcCode:Label38.refresh
QUIGLINE 489
	sRcCodeList(8) = sRcCode
QUIGLINE 490
	endf
QUIGLINE 491
	
QUIGLINE 492
	;-------------------------------------------------------------------------------------------------
QUIGLINE 493
	
QUIGLINE 494
	
QUIGLINE 495
	Function symAppExit:void()
QUIGLINE 496
	
QUIGLINE 497
	sDb = "App Exit":sysDebug
QUIGLINE 498
	
QUIGLINE 499
	if iAppExit = 1 then
QUIGLINE 500
	iAppExit = 2
QUIGLINE 501
	
QUIGLINE 502
	Form1.open
QUIGLINE 503
	return
QUIGLINE 504
	endif
QUIGLINE 505
	
QUIGLINE 506
	if iAppExit = 2 then
QUIGLINE 507
	iAppExit = 3
QUIGLINE 508
	
QUIGLINE 509
	PanDeInit
QUIGLINE 510
	shSe_char.free
QUIGLINE 511
	App.exit
QUIGLINE 512
	endif
QUIGLINE 513
	endf
QUIGLINE 514
	
QUIGLINE 515
	;-------------------------------------------------------------------------------------------------
QUIGLINE 516
	Function Initialize:Void()
QUIGLINE 517
	
QUIGLINE 518
	sys_IO_init
QUIGLINE 519
	
QUIGLINE 520
	sAtCmd = "AT+SEMODE=MP3B
QUIGLINE 521
	ATCmd
QUIGLINE 522
	
QUIGLINE 523
	
QUIGLINE 524
	LoadImgCtrls
QUIGLINE 525
	loadCharTable
QUIGLINE 526
	
QUIGLINE 527
	WebMakeWrcList
QUIGLINE 528
	
QUIGLINE 529
	shSe_char.Load(App.Path+"se_char.qs2")
QUIGLINE 530
	shSe_voip.Load(App.Path+"se_voip.qs2")
QUIGLINE 531
	shSe_vu.Load(App.Path+"se_vu.qs2")
QUIGLINE 532
	
QUIGLINE 533
	image13.tile.set shSe_voip,0 :image13.refresh
QUIGLINE 534
	image14.tile.set shSe_voip,1 :image14.refresh
QUIGLINE 535
	
QUIGLINE 536
	imageVuL.tile.set shSe_vu,1 :imageVuL.refresh
QUIGLINE 537
	imageVuR.tile.set shSe_vu,1 :imageVuR.refresh
QUIGLINE 538
	
QUIGLINE 539
	
QUIGLINE 540
	sDisplay1 = "             " :PanSetDisplay1
QUIGLINE 541
	sDisplay2 = "             " :PanSetDisplay2
QUIGLINE 542
	
QUIGLINE 543
	Time_init
QUIGLINE 544
	
QUIGLINE 545
	u8In1 = 0
QUIGLINE 546
	F72_26
QUIGLINE 547
	sHardware = sOut1
QUIGLINE 548
	
QUIGLINE 549
	RcChkFile
QUIGLINE 550
	
QUIGLINE 551
	If Sound.Init = 0 Then
QUIGLINE 552
		a = Execute("c:\soundd.exe")			// Start netd local if not open
QUIGLINE 553
		a = Sound.Init
QUIGLINE 554
		
QUIGLINE 555
		sDb="Sound.Init":sysDebug
QUIGLINE 556
	EndIf
QUIGLINE 557
	
QUIGLINE 558
	endf
QUIGLINE 559
	;-------------------------------------------------------------------------------------------------
QUIGLINE 560
	; === MAIN
QUIGLINE 561
	
QUIGLINE 562
	Function Main:Void()
QUIGLINE 563
	if iAppExit > 0 then
QUIGLINE 564
	symAppExit
QUIGLINE 565
	endif
QUIGLINE 566
	
QUIGLINE 567
	if (iWebStreamStatus = 1) then
QUIGLINE 568
	Wifi_stream_toSeone
QUIGLINE 569
	return
QUIGLINE 570
	elseif (iWebStreamStatus = 2) then
QUIGLINE 571
	F90_21
QUIGLINE 572
	PanVuUpdate
QUIGLINE 573
	endif
QUIGLINE 574
	
QUIGLINE 575
	
QUIGLINE 576
	if (sPanMode = "TIME") then
QUIGLINE 577
	TimeShow
QUIGLINE 578
	endif
QUIGLINE 579
	
QUIGLINE 580
	if (sPanMode = "VOIP") then
QUIGLINE 581
	
QUIGLINE 582
	if (iStpStartup > 0) then
QUIGLINE 583
	stpStartup
QUIGLINE 584
	else
QUIGLINE 585
	VoipHandler
QUIGLINE 586
	endif
QUIGLINE 587
	
QUIGLINE 588
	VoipSoundHandler
QUIGLINE 589
	endif
QUIGLINE 590
	
QUIGLINE 591
	if (sHardware = "RSF3") then
QUIGLINE 592
	RcGetCode
QUIGLINE 593
	If (bRcCodeReceived = 1) Then
QUIGLINE 594
		bRcCodeReceived = 0
QUIGLINE 595
		
QUIGLINE 596
		
QUIGLINE 597
		if (form2.state = 1 ) then
QUIGLINE 598
		sText = "Rc code: "+ sRcCode
QUIGLINE 599
		Form2.status.text.set sText:
QUIGLINE 600
		Form2.status.refresh
QUIGLINE 601
		else
QUIGLINE 602
		
QUIGLINE 603
		RcCodeHandler
QUIGLINE 604
		endif
QUIGLINE 605
		
QUIGLINE 606
		
QUIGLINE 607
		endif
QUIGLINE 608
		endif
QUIGLINE 609
		
QUIGLINE 610
		if (sPanMode = "MP3-B") then
QUIGLINE 611
		PanVuUpdate
QUIGLINE 612
		
QUIGLINE 613
		if ((IO.In(#FF23) and 8) > 0) then
QUIGLINE 614
		Mp3bFileStop
QUIGLINE 615
		endif
QUIGLINE 616
		endif
QUIGLINE 617
		
QUIGLINE 618
		
QUIGLINE 619
		if (bDisplayScroll = 1) then
QUIGLINE 620
		PanDisplayScroll1
QUIGLINE 621
		endif
QUIGLINE 622
		
QUIGLINE 623
		//.. todo   status bit voip => set "VOIP"
QUIGLINE 624
EndF
QUIGLINE 625

QUIGLINE 626

QUIGLINE 627

QUIGLINE 628
;-------------------------------------------------------------------------------------------------
QUIGLINE 629
; === Panel Functions
QUIGLINE 630

QUIGLINE 631
Function PanSetDisplay1:Void()
QUIGLINE 632
	
QUIGLINE 633
	sText = ucase(sDisplay1) + "              "
QUIGLINE 634
	For  x = 1 To  14
QUIGLINE 635
		c = Asc(Mid(sText,x,1))
QUIGLINE 636
		y = u8CharTable(c)
QUIGLINE 637
		Ctrl.Image.Tile.Set ImgIds(x),shSe_char,y :Ctrl.Refresh ImgIds(x)
QUIGLINE 638
	Next
QUIGLINE 639
	endf
QUIGLINE 640
	
QUIGLINE 641
	Function PanSetDisplay2:Void()
QUIGLINE 642
	
QUIGLINE 643
	sText = ucase(sDisplay2) + "              "
QUIGLINE 644
	For  x = 1 To  14
QUIGLINE 645
		c = Asc(Mid(sText,x,1))
QUIGLINE 646
		y = u8CharTable(c)
QUIGLINE 647
		Ctrl.Image.Tile.Set ImgIds(x+14),shSe_char,y :Ctrl.Refresh ImgIds(x+14)
QUIGLINE 648
	Next
QUIGLINE 649
	endf
QUIGLINE 650
	
QUIGLINE 651
	Function PanDisplayScroll1:Void()
QUIGLINE 652
	
QUIGLINE 653
	if (iDisplayScrollPos > iDisplayScrollLen) then
QUIGLINE 654
	bDisplayScroll = 0
QUIGLINE 655
	return
QUIGLINE 656
	endif
QUIGLINE 657
	
QUIGLINE 658
	iDisplCt = iDisplCt + 1
QUIGLINE 659
	if (iDisplCt < 3) then
QUIGLINE 660
	return
QUIGLINE 661
	endif
QUIGLINE 662
	iDisplCt = 0
QUIGLINE 663
	
QUIGLINE 664
	sText = Mid(sDisplay1,iDisplayScrollPos,15)
QUIGLINE 665
	
QUIGLINE 666
	iDisplayScrollPos = iDisplayScrollPos + 1
QUIGLINE 667
	
QUIGLINE 668
	
QUIGLINE 669
	For  x = 1 To  14
QUIGLINE 670
		c = Asc(Mid(sText,x,1))
QUIGLINE 671
		y = u8CharTable(c)
QUIGLINE 672
		Ctrl.Image.Tile.Set ImgIds(x),shSe_char,y :Ctrl.Refresh ImgIds(x)
QUIGLINE 673
	Next
QUIGLINE 674
	endf
QUIGLINE 675
	
QUIGLINE 676
	
QUIGLINE 677
	Function PanDeInit:Void()
QUIGLINE 678
	sPanMode =""
QUIGLINE 679
	if (iWebStreamStatus > 0) then
QUIGLINE 680
	iWebStreamStatus = 0
QUIGLINE 681
	F90_10
QUIGLINE 682
	endif
QUIGLINE 683
	
QUIGLINE 684
	bMp3bAudioStreamActive = 0
QUIGLINE 685
	
QUIGLINE 686
	sAtCmd = "AT+SEMODE=MP3A":ATCmd
QUIGLINE 687
	
QUIGLINE 688
	//SkyBlue
QUIGLINE 689
	label1.Colour.Set Colour.SkyBlue,colour.darkBlue,1 :Label1.refresh
QUIGLINE 690
	label2.Colour.Set Colour.SkyBlue,colour.darkBlue,1 :Label2.refresh
QUIGLINE 691
	label3.Colour.Set Colour.SkyBlue,colour.darkBlue,1 :Label3.refresh
QUIGLINE 692
	label4.Colour.Set Colour.White,colour.Magenta,1 :Label4.refresh // IR
QUIGLINE 693
	label5.Colour.Set Colour.Skyblue,colour.darkBlue,1 :Label5.refresh
QUIGLINE 694
	
QUIGLINE 695
	
QUIGLINE 696
	endf
QUIGLINE 697
	
QUIGLINE 698
	Function PanVuUpdate:Void()
QUIGLINE 699
	
QUIGLINE 700
	iVuCt = iVuCt + 1
QUIGLINE 701
	if (iVuCt < 5) then
QUIGLINE 702
	return
QUIGLINE 703
	endif
QUIGLINE 704
	iVuCt = 0
QUIGLINE 705
	
QUIGLINE 706
	
QUIGLINE 707
	x = IO.In(#FF26)
QUIGLINE 708
	imageVuL.tile.set shSe_vu,x :imageVuL.refresh
QUIGLINE 709
	x = IO.In(#FF27)
QUIGLINE 710
	imageVuR.tile.set shSe_vu,x :imageVuR.refresh
QUIGLINE 711
	endf
QUIGLINE 712
	;-------------------------------------------------------------------------------------------------
QUIGLINE 713
	; === TIME functions
QUIGLINE 714
	
QUIGLINE 715
	Function Time_init:Void()
QUIGLINE 716
	PanDeInit
QUIGLINE 717
	
QUIGLINE 718
	sPanMode ="TIME"
QUIGLINE 719
	
QUIGLINE 720
	sDisplay1 = "   CLOCK      " :PanSetDisplay1
QUIGLINE 721
	sDisplay2 = "              " :PanSetDisplay2
QUIGLINE 722
	
QUIGLINE 723
	endf
QUIGLINE 724
	
QUIGLINE 725
	Function TimeShow:Void()
QUIGLINE 726
	iTimeCt = iTimeCt + 1
QUIGLINE 727
	if (iTimeCt > 10) then
QUIGLINE 728
	iTimeCt = 0
QUIGLINE 729
	
QUIGLINE 730
	sDisplay1 = "   "
QUIGLINE 731
	sText = "0"+str(Time.Hour.Get)
QUIGLINE 732
	sDisplay1 = sDisplay1 + right(sText,2) + ":"
QUIGLINE 733
	
QUIGLINE 734
	sText = "0"+str(Time.Minute.Get)
QUIGLINE 735
	sDisplay1 = sDisplay1 + right(sText,2) + ":"
QUIGLINE 736
	
QUIGLINE 737
	sText = "0"+str(Time.Second.Get)
QUIGLINE 738
	sDisplay1 = sDisplay1 + right(sText,2) + "  "
QUIGLINE 739
	
QUIGLINE 740
	PanSetDisplay1
QUIGLINE 741
	
QUIGLINE 742
	sDisplay2 = "   "
QUIGLINE 743
	sText = "0"+str(Time.Day.Get)
QUIGLINE 744
	sDisplay2 = sDisplay2 + right(sText,2) + "/"
QUIGLINE 745
	
QUIGLINE 746
	sText = "0"+str(Time.Month.Get)
QUIGLINE 747
	sDisplay2 = sDisplay2 + right(sText,2) + "/"
QUIGLINE 748
	
QUIGLINE 749
	sText = "0"+str(Time.Year.Get)
QUIGLINE 750
	sDisplay2 = sDisplay2 + right(sText,2) + "  "
QUIGLINE 751
	
QUIGLINE 752
	PanSetDisplay2
QUIGLINE 753
	
QUIGLINE 754
	
QUIGLINE 755
	endif
QUIGLINE 756
	endf
QUIGLINE 757
	
QUIGLINE 758
	
QUIGLINE 759
	
QUIGLINE 760
	;-------------------------------------------------------------------------------------------------
QUIGLINE 761
	; === web Functions
QUIGLINE 762
	
QUIGLINE 763
	; Todo app.paht wrc files
QUIGLINE 764
	
QUIGLINE 765
	Function Web_init:Void()
QUIGLINE 766
	PanDeInit
QUIGLINE 767
	label1.Colour.Set colour.darkBlue,Colour.SkyBlue,1 :Label1.refresh
QUIGLINE 768
	
QUIGLINE 769
	sPanMode ="WEBRADIO"
QUIGLINE 770
	
QUIGLINE 771
	WebMakeWrcList
QUIGLINE 772
	
QUIGLINE 773
	sDisplay1 = " - WEBRADIO -":PanSetDisplay1
QUIGLINE 774
	sDisplay2 = "             ":PanSetDisplay2
QUIGLINE 775
	
QUIGLINE 776
	WebMakeStationList
QUIGLINE 777
	
QUIGLINE 778
	WebMakeUrl
QUIGLINE 779
	
QUIGLINE 780
	sAtCmd = "AT+SEMODE=MP3B":ATCmd
QUIGLINE 781
	endf
QUIGLINE 782
	
QUIGLINE 783
	
QUIGLINE 784
	Function WebWrcInc:Void()
QUIGLINE 785
	
QUIGLINE 786
	sDisplay2 = "            " :PanSetDisplay2
QUIGLINE 787
	
QUIGLINE 788
	if (iWebWrcMax = 0) then
QUIGLINE 789
	sDisplay1 = "No WRC found" :PanSetDisplay1
QUIGLINE 790
	return
QUIGLINE 791
	endif
QUIGLINE 792
	
QUIGLINE 793
	iWebWrcActive = iWebWrcActive + 1
QUIGLINE 794
	if (iWebWrcActive > iWebWrcMax) then
QUIGLINE 795
	iWebWrcActive = 1
QUIGLINE 796
	endif
QUIGLINE 797
	
QUIGLINE 798
	sDisplay1 = sWebWrcList(iWebWrcActive) :PanSetDisplay1
QUIGLINE 799
	
QUIGLINE 800
	WebMakeStationList
QUIGLINE 801
	
QUIGLINE 802
	endf
QUIGLINE 803
	
QUIGLINE 804
	Function WebWrcDec:Void()
QUIGLINE 805
	
QUIGLINE 806
	sDisplay2 = "            " :PanSetDisplay2
QUIGLINE 807
	
QUIGLINE 808
	if (iWebWrcMax = 0) then
QUIGLINE 809
	sDisplay1 = "No WRC found" :PanSetDisplay1
QUIGLINE 810
	return
QUIGLINE 811
	endif
QUIGLINE 812
	
QUIGLINE 813
	if (iWebWrcActive > 1) then
QUIGLINE 814
	iWebWrcActive = iWebWrcActive - 1
QUIGLINE 815
	else
QUIGLINE 816
	iWebWrcActive = iWebWrcMax
QUIGLINE 817
	endif
QUIGLINE 818
	
QUIGLINE 819
	sDisplay1 = sWebWrcList(iWebWrcActive) :PanSetDisplay1
QUIGLINE 820
	
QUIGLINE 821
	WebMakeStationList
QUIGLINE 822
	endf
QUIGLINE 823
	
QUIGLINE 824
	Function WebStationInc:Void()
QUIGLINE 825
	iWebStationActive = iWebStationActive + 1
QUIGLINE 826
	if (iWebStationActive > iWebStationMax) then
QUIGLINE 827
	iWebStationActive = 1
QUIGLINE 828
	endif
QUIGLINE 829
	
QUIGLINE 830
	WebMakeUrl
QUIGLINE 831
	
QUIGLINE 832
	sDisplay2 = sStationName :PanSetDisplay2
QUIGLINE 833
	endf
QUIGLINE 834
	
QUIGLINE 835
	Function WebStationDec:Void()
QUIGLINE 836
	if (iWebStationActive > 1) then
QUIGLINE 837
	iWebStationActive = iWebStationActive - 1
QUIGLINE 838
	else
QUIGLINE 839
	iWebStationActive = iWebStationMax
QUIGLINE 840
	endif
QUIGLINE 841
	
QUIGLINE 842
	WebMakeUrl
QUIGLINE 843
	
QUIGLINE 844
	sDisplay2 = sStationName :PanSetDisplay2
QUIGLINE 845
	
QUIGLINE 846
	endf
QUIGLINE 847
	
QUIGLINE 848
	Function WebStationShow:Void()
QUIGLINE 849
	
QUIGLINE 850
	sDisplay1 = sWebWrcList(iWebWrcActive) :PanSetDisplay1
QUIGLINE 851
	sDisplay2 = sStationName :PanSetDisplay2
QUIGLINE 852
	endf
QUIGLINE 853
	
QUIGLINE 854
	Function WebStreamPlay:Void()
QUIGLINE 855
	
QUIGLINE 856
	//If (strList1Mode  = "STATIONS" ) And (u8ListMax  > 0)  And  (bStreamActive = 0) And (StationSelect < u8ListMax)  Then
QUIGLINE 857
	
QUIGLINE 858
	
QUIGLINE 859
	F90_10	// close socket
QUIGLINE 860
	F90_5	// open socket
QUIGLINE 861
	
QUIGLINE 862
	sIn1 = sUrlSend
QUIGLINE 863
	F90_8	// send url get
QUIGLINE 864
	
QUIGLINE 865
	if (sHardware ="SF3" or sHardware ="RSF3") then
QUIGLINE 866
	iWebStreamStatus = 2
QUIGLINE 867
	sDb ="Stream = 2 R/SF3":sysDebug
QUIGLINE 868
	else
QUIGLINE 869
	iWebStreamStatus = 1
QUIGLINE 870
	sDb ="Stream = 1 TNC-MSX":sysDebug
QUIGLINE 871
	endif
QUIGLINE 872
	
QUIGLINE 873
	Wifi_stream_clear
QUIGLINE 874
	
QUIGLINE 875
	sDisplay1 = "PLAYING..." :PanSetDisplay1
QUIGLINE 876
EndF
QUIGLINE 877

QUIGLINE 878
Function WebStreamStop:Void()
QUIGLINE 879
	
QUIGLINE 880
	F90_10	// close socket
QUIGLINE 881
	
QUIGLINE 882
	iWebStreamStatus = 0
QUIGLINE 883
	
QUIGLINE 884
	WebStationShow
QUIGLINE 885
	endf
QUIGLINE 886
	
QUIGLINE 887
	Function WebMakeWrcList:Void()
QUIGLINE 888
	
QUIGLINE 889
	Garbage
QUIGLINE 890
	
QUIGLINE 891
	sText = App.Path + "*.WRC"
QUIGLINE 892
	Dir.Read sText,8
QUIGLINE 893
	
QUIGLINE 894
	x = 0
QUIGLINE 895
	for t = 1 to 30
QUIGLINE 896
	
QUIGLINE 897
	If (Right(Dir.Read.Name,3) = "WRC") and (x < 9) Then
QUIGLINE 898
		x=x+1
QUIGLINE 899
		sWebWrcList(x) = Dir.Read.Name
QUIGLINE 900
		endif
QUIGLINE 901
		
QUIGLINE 902
		Dir.Read.next
QUIGLINE 903
		next
QUIGLINE 904
		
QUIGLINE 905
		iWebWrcMax = x
QUIGLINE 906
		
QUIGLINE 907
		//.. todo als 0 dan error -> not found
QUIGLINE 908
		
QUIGLINE 909
		iWebWrcActive = 0
QUIGLINE 910
		
QUIGLINE 911
		Garbage
QUIGLINE 912
		endf
QUIGLINE 913
		
QUIGLINE 914
		Function WebMakeStationList:Void()
QUIGLINE 915
	
QUIGLINE 916
	sText = App.path + sWebWrcList(iWebWrcActive)
QUIGLINE 917
	fDiskWeb.open sText
QUIGLINE 918
	
QUIGLINE 919
	x=0
QUIGLINE 920
	for t = 1 to 19  //40
QUIGLINE 921
	if (fDiskWeb.eof = 0) then
QUIGLINE 922
	sText  =  fDiskWeb.ReadString()
QUIGLINE 923
	c = asc(left(sText,1))
QUIGLINE 924
	if (c >= asc("0")) and (c <= asc("9"))  then
QUIGLINE 925
	x=x+1
QUIGLINE 926
	sWebStation(x) = sText
QUIGLINE 927
	
QUIGLINE 928
	sDb  = sWebStation(x) :sysDebug
QUIGLINE 929
	
QUIGLINE 930
	endif
QUIGLINE 931
	endif
QUIGLINE 932
	next
QUIGLINE 933
	
QUIGLINE 934
	iWebStationMax = x
QUIGLINE 935
	
QUIGLINE 936
	fDiskWeb.close
QUIGLINE 937
	
QUIGLINE 938
	sDb  = "EXIT list" :sysDebug
QUIGLINE 939
	
QUIGLINE 940
	Garbage
QUIGLINE 941
	
QUIGLINE 942
	iWebStationActive = 1
QUIGLINE 943
	endf
QUIGLINE 944
	
QUIGLINE 945
	Function WebMakeUrl:Void()
QUIGLINE 946
	
QUIGLINE 947
	//sDb = "WebMakeUrl":sysDebug
QUIGLINE 948
	
QUIGLINE 949
	sText = sWebStation(iWebStationActive)
QUIGLINE 950
	l = len(sText)
QUIGLINE 951
	
QUIGLINE 952
	//.. get iPortHigh
QUIGLINE 953
	
QUIGLINE 954
	iIp(0) = cint(Mid(sText,1,3))
QUIGLINE 955
	iIp(1) = cint(Mid(sText,5,3))
QUIGLINE 956
	iIp(2) = cint(Mid(sText,9,3))
QUIGLINE 957
	iIp(3) = cint(Mid(sText,13,3))
QUIGLINE 958
	
QUIGLINE 959
	sDb = str(iIp(0)) + " " +str(iIp(1)) + " " + str(iIp(2))+ " " +str(iIp(3)):sysDebug
QUIGLINE 960
	
QUIGLINE 961
	x = 0
QUIGLINE 962
	for t = 15 to l
QUIGLINE 963
	c = asc(Mid(sText,t,1))
QUIGLINE 964
	
QUIGLINE 965
	if (c = asc("|")) then
QUIGLINE 966
	x=x+1
QUIGLINE 967
	t=t+1
QUIGLINE 968
	
QUIGLINE 969
	if (x = 1) then
QUIGLINE 970
	;Port
QUIGLINE 971
	
QUIGLINE 972
	y = cint(Mid(sText,t,4))
QUIGLINE 973
	iPortHigh = shr8(y)
QUIGLINE 974
	iPortLow = y and 255
QUIGLINE 975
	endif
QUIGLINE 976
	
QUIGLINE 977
	if (x = 2) then
QUIGLINE 978
	;Get
QUIGLINE 979
	
QUIGLINE 980
	sTrim = Right(sText,l - t + 1)
QUIGLINE 981
	Trim
QUIGLINE 982
	sGet = sTrimOut
QUIGLINE 983
	endif
QUIGLINE 984
	
QUIGLINE 985
	if (x = 3) then
QUIGLINE 986
	;Station name
QUIGLINE 987
	
QUIGLINE 988
	sTrim = Right(sText,l - t + 1)
QUIGLINE 989
	Trim
QUIGLINE 990
	sStationName = sTrimOut
QUIGLINE 991
	endif
QUIGLINE 992
	
QUIGLINE 993
	endif
QUIGLINE 994
	next
QUIGLINE 995
	
QUIGLINE 996
	//sDb = "IP   " + str(iIp(0)) + " " +str(iIp(1)) + " " + str(iIp(2))+ " " +str(iIp(3)):sysDebug
QUIGLINE 997
	//sDb = "PORT " +str(iPortHigh)  + " " +str(iPortlow) :sysDebug
QUIGLINE 998
	//sDb = "GET  " + sGet:sysDebug
QUIGLINE 999
	//sDb = "Name " + sStationName:sysDebug
QUIGLINE 1000
	
QUIGLINE 1001
	sUrlSend  = "GET "+ sGet +" HTTP/1.1"+Chr(13)+Chr(10)+Chr(13)+Chr(10)
QUIGLINE 1002
	
QUIGLINE 1003
	endf
QUIGLINE 1004
	
QUIGLINE 1005
	Function Wifi_stream_clear:Void()
QUIGLINE 1006
	
QUIGLINE 1007
	F90_18
QUIGLINE 1008
	if (u16Out1 > 0) then
QUIGLINE 1009
	for t = 1 to u16Out1
QUIGLINE 1010
	x = IO.In(ioA_5)		//.. socket 0 #45
QUIGLINE 1011
	next
QUIGLINE 1012
	endif
QUIGLINE 1013
	endf
QUIGLINE 1014
	
QUIGLINE 1015
	Function Wifi_stream_toSeone:Void()
QUIGLINE 1016
	
QUIGLINE 1017
	for t = 1 to 5
QUIGLINE 1018
	F90_18
QUIGLINE 1019
	
QUIGLINE 1020
	if (u16Out1 > 0) then
QUIGLINE 1021
	Asm
QUIGLINE 1022
	
QUIGLINE 1023
	Ld hl,(var_wrd_u16Out1)
QUIGLINE 1024
	Ld de,(var_wrd_ioA_5)
QUIGLINE 1025
	
QUIGLINE 1026
	.LOOP1:
QUIGLINE 1027
	
QUIGLINE 1028
	;Ld bc,#FD45
QUIGLINE 1029
	
QUIGLINE 1030
	ld b,d
QUIGLINE 1031
	ld c,e
QUIGLINE 1032
	
QUIGLINE 1033
	in a,(c)
QUIGLINE 1034
	
QUIGLINE 1035
	Ld bc,#FF22
QUIGLINE 1036
	Out (c),a
QUIGLINE 1037
	
QUIGLINE 1038
	dec hl
QUIGLINE 1039
	ld a,h
QUIGLINE 1040
	or l
QUIGLINE 1041
	
QUIGLINE 1042
	jp nz, loop1
QUIGLINE 1043
	
QUIGLINE 1044
	Quigs
QUIGLINE 1045
	endif
QUIGLINE 1046
	next
QUIGLINE 1047
	endf
QUIGLINE 1048
	
QUIGLINE 1049
	;-------------------------------------------------------------------------------------------------
QUIGLINE 1050
	; === MP3_B Functions
QUIGLINE 1051
	
QUIGLINE 1052
	Function Mp3b_init:Void()
QUIGLINE 1053
	PanDeInit
QUIGLINE 1054
	label2.Colour.Set colour.darkBlue,Colour.SkyBlue,1 :Label2.refresh
QUIGLINE 1055
	
QUIGLINE 1056
	
QUIGLINE 1057
	sPanMode ="MP3-B"
QUIGLINE 1058
	
QUIGLINE 1059
	sDisplay1 = " - MP3 USB  -" :PanSetDisplay1
QUIGLINE 1060
	sDisplay2 = " "             :PanSetDisplay2
QUIGLINE 1061
	
QUIGLINE 1062
	
QUIGLINE 1063
	
QUIGLINE 1064
	sAtCmd = "AT+SEMODE=MP3B":ATCmd
QUIGLINE 1065
	sAtCmd = "AT+USBINIT":ATCmd
QUIGLINE 1066
	
QUIGLINE 1067
	u8in1 = 0 // hardware info
QUIGLINE 1068
	F72_26
QUIGLINE 1069
	if (sOut1 = "TNC" ) then 	// todo rsf3 enable seone = off
QUIGLINE 1070
	sAtCmd = "AT+MSDPATH=0:/" :ATCmd
QUIGLINE 1071
	sSePath = "0:"
QUIGLINE 1072
	else
QUIGLINE 1073
	sAtCmd = "AT+MSDPATH=1:/" :ATCmd
QUIGLINE 1074
	sSePath = "1:"
QUIGLINE 1075
	endif
QUIGLINE 1076
	
QUIGLINE 1077
	sSePathCompr = sSePath
QUIGLINE 1078
	
QUIGLINE 1079
	Mp3bMakeFilelist
QUIGLINE 1080
	
QUIGLINE 1081
	
QUIGLINE 1082
	endf
QUIGLINE 1083
	
QUIGLINE 1084
	
QUIGLINE 1085
	Function Mp3bMakeFilelist:void()
QUIGLINE 1086
	sAtCmd = "AT+MSDFILES":ATCmd
QUIGLINE 1087
	
QUIGLINE 1088
	//if sSePath <> "/" then
QUIGLINE 1089
	// display long path
QUIGLINE 1090
	
QUIGLINE 1091
	
QUIGLINE 1092
	sText = ""
QUIGLINE 1093
	y = 0
QUIGLINE 1094
	iMp3bFileListMax = 0
QUIGLINE 1095
	
QUIGLINE 1096
	c = IO.In(#FF25)
QUIGLINE 1097
	
QUIGLINE 1098
	while (c<>0)
QUIGLINE 1099
	
QUIGLINE 1100
	if (c = 9) and (y < 49) then
QUIGLINE 1101
	
QUIGLINE 1102
	sTrim = sText :TrimSpc
QUIGLINE 1103
	
QUIGLINE 1104
	sMp3bFileList(y) = sTrimOut
QUIGLINE 1105
	sText = ""
QUIGLINE 1106
	
QUIGLINE 1107
	sDb = sMp3bFileList(y):sysDebug
QUIGLINE 1108
	y = y + 1
QUIGLINE 1109
	iMp3bFileListMax = iMp3bFileListMax + 1
QUIGLINE 1110
	else
QUIGLINE 1111
	sText = sText + chr(c)
QUIGLINE 1112
	endif
QUIGLINE 1113
	
QUIGLINE 1114
	c = IO.In(#FF25)
QUIGLINE 1115
	wend
QUIGLINE 1116
	
QUIGLINE 1117
	sMp3bFileList(y) = "_END_"
QUIGLINE 1118
	
QUIGLINE 1119
	iMp3bFileListActive = 0
QUIGLINE 1120
	endf
QUIGLINE 1121
	
QUIGLINE 1122
	Function Mp3bFileNext:Void()
QUIGLINE 1123
	
QUIGLINE 1124
	if (iMp3bFileListMax = 0) then
QUIGLINE 1125
	return
QUIGLINE 1126
	endif
QUIGLINE 1127
	
QUIGLINE 1128
	if (iMp3bFileListActive < (iMp3bFileListMax - 1)) then
QUIGLINE 1129
	iMp3bFileListActive = iMp3bFileListActive + 1
QUIGLINE 1130
	endif
QUIGLINE 1131
	
QUIGLINE 1132
	sMsdFile = sMp3bFileList(iMp3bFileListActive)
QUIGLINE 1133
	Mp3bFileShow
QUIGLINE 1134
	
QUIGLINE 1135
	endf
QUIGLINE 1136
	
QUIGLINE 1137
	Function Mp3bFilePrev:Void()
QUIGLINE 1138
	if (iMp3bFileListActive > 0) then
QUIGLINE 1139
	iMp3bFileListActive = iMp3bFileListActive - 1
QUIGLINE 1140
	endif
QUIGLINE 1141
	
QUIGLINE 1142
	sMsdFile = sMp3bFileList(iMp3bFileListActive)
QUIGLINE 1143
	Mp3bFileShow
QUIGLINE 1144
	endf
QUIGLINE 1145
	
QUIGLINE 1146
	Function Mp3bPathUp:Void()
QUIGLINE 1147
	
QUIGLINE 1148
	if ( Left(sMsdFile,1) <> "/") then
QUIGLINE 1149
	return
QUIGLINE 1150
	endif
QUIGLINE 1151
	
QUIGLINE 1152
	sSePath = sSePath + sMsdFile
QUIGLINE 1153
	sAtCmd = "AT+MSDPATH=" + sSePath :ATCmd
QUIGLINE 1154
	Mp3bMakeFilelist
QUIGLINE 1155
	
QUIGLINE 1156
	sMsdFile = sMp3bFileList(iMp3bFileListActive)
QUIGLINE 1157
	
QUIGLINE 1158
	Mp3bPathCompress
QUIGLINE 1159
	Mp3bFileShow
QUIGLINE 1160
	endf
QUIGLINE 1161
	
QUIGLINE 1162
	Function Mp3bPathDown:Void()
QUIGLINE 1163
	
QUIGLINE 1164
	Mp3bPathDownTrim
QUIGLINE 1165
	
QUIGLINE 1166
	sAtCmd = "AT+MSDPATH=" + sSePath :ATCmd
QUIGLINE 1167
	Mp3bMakeFilelist
QUIGLINE 1168
	
QUIGLINE 1169
	sMsdFile = sMp3bFileList(iMp3bFileListActive)
QUIGLINE 1170
	
QUIGLINE 1171
	Mp3bPathCompress
QUIGLINE 1172
	Mp3bFileShow
QUIGLINE 1173
	endf
QUIGLINE 1174
	
QUIGLINE 1175
	Function Mp3bFilePlay:Void()
QUIGLINE 1176
	
QUIGLINE 1177
	if ( Left(sMsdFile,1) = "/") then
QUIGLINE 1178
	return
QUIGLINE 1179
	endif
QUIGLINE 1180
	
QUIGLINE 1181
	sAtCmd = "AT+MSDPLAY=" + sMsdFile :	ATCmd
QUIGLINE 1182
	
QUIGLINE 1183
	bMp3bAudioStreamActive = 1
QUIGLINE 1184
	
QUIGLINE 1185
	sDisplay1 = "PLAYING..." :PanSetDisplay1
QUIGLINE 1186
	endf
QUIGLINE 1187
	
QUIGLINE 1188
	Function Mp3bFileStop:Void()
QUIGLINE 1189
	sAtCmd = "AT+MSDSTOP" :ATCmd
QUIGLINE 1190
	
QUIGLINE 1191
	bMp3bAudioStreamActive = 0
QUIGLINE 1192
	
QUIGLINE 1193
	Mp3bFileShow
QUIGLINE 1194
	endf
QUIGLINE 1195
	
QUIGLINE 1196
	Function Mp3bFileShow:Void()
QUIGLINE 1197
	sDisplay1 = sSePathCompr  :PanSetDisplay1
QUIGLINE 1198
	sDisplay2 = sMsdFile :PanSetDisplay2
QUIGLINE 1199
	endf
QUIGLINE 1200
	
QUIGLINE 1201
	Function Mp3bPathDownTrim:Void()
QUIGLINE 1202
	
QUIGLINE 1203
	;  input :   "1:/test/hello"
QUIGLINE 1204
	;  output:   "1:/test"
QUIGLINE 1205
	
QUIGLINE 1206
	fn = 3
QUIGLINE 1207
	fy = len(sSePath)
QUIGLINE 1208
	
QUIGLINE 1209
	for fx = fy to 3 step -1
QUIGLINE 1210
	
QUIGLINE 1211
	fc = asc(mid(sSePath,fx,1))
QUIGLINE 1212
	
QUIGLINE 1213
	if (fc  = 47) then
QUIGLINE 1214
	fn = fx - 1
QUIGLINE 1215
	fx = 0
QUIGLINE 1216
	endif
QUIGLINE 1217
	
QUIGLINE 1218
	next
QUIGLINE 1219
	
QUIGLINE 1220
	sSePath = left(sSePath,fn)
QUIGLINE 1221
	
QUIGLINE 1222
	sDb = "Na Path down :>" + sSePath + "<":sysDebug
QUIGLINE 1223
	
QUIGLINE 1224
	
QUIGLINE 1225
	endf
QUIGLINE 1226
	
QUIGLINE 1227
	Function Mp3bPathCompress:Void()
QUIGLINE 1228
	
QUIGLINE 1229
	;  input :   "1:/test"
QUIGLINE 1230
	;  output:   "1:/test"
QUIGLINE 1231
	
QUIGLINE 1232
	;  input :   "1:/test/hello"
QUIGLINE 1233
	;  output:   "//hello"
QUIGLINE 1234
	
QUIGLINE 1235
	fn = 0
QUIGLINE 1236
	
QUIGLINE 1237
	fy = len(sSePath)
QUIGLINE 1238
	x = 0
QUIGLINE 1239
	for fx = 1 to fy
QUIGLINE 1240
	fc = asc(mid(sSePath,fx,1))
QUIGLINE 1241
	if (fc  = 47) then
QUIGLINE 1242
	fn = fn + 1
QUIGLINE 1243
	x = fx
QUIGLINE 1244
	endif
QUIGLINE 1245
	next
QUIGLINE 1246
	
QUIGLINE 1247
	
QUIGLINE 1248
	if (fn > 1) then
QUIGLINE 1249
	sText = right(sSePath,fy - x)
QUIGLINE 1250
	sDb = "laatst path deel :" + sText:sysDebug
QUIGLINE 1251
	
QUIGLINE 1252
	sSePathCompr = "//" + sText
QUIGLINE 1253
	else
QUIGLINE 1254
	sSePathCompr = sSePath
QUIGLINE 1255
	endif
QUIGLINE 1256
	
QUIGLINE 1257
	sDb = "Na compr:"+sSePathCompr :sysDebug
QUIGLINE 1258
	
QUIGLINE 1259
	endf
QUIGLINE 1260
	
QUIGLINE 1261
	
QUIGLINE 1262
	;-------------------------------------------------------------------------------------------------
QUIGLINE 1263
	; === FM Functions
QUIGLINE 1264
	
QUIGLINE 1265
	Function FM_init:Void()
QUIGLINE 1266
	PanDeInit
QUIGLINE 1267
	label3.Colour.Set colour.darkBlue,Colour.SkyBlue,1 :Label3.refresh
QUIGLINE 1268
	
QUIGLINE 1269
	sPanMode ="FM"
QUIGLINE 1270
	
QUIGLINE 1271
	sDisplay1 = " - FM RADIO -":PanSetDisplay1
QUIGLINE 1272
	sDisplay2 = "             ":PanSetDisplay2
QUIGLINE 1273
	
QUIGLINE 1274
	sAtCmd = "AT+SEMODE=FM":ATCmd
QUIGLINE 1275
	
QUIGLINE 1276
	sAtCmd = "AT+SEFREQ=101":ATCmd
QUIGLINE 1277
	
QUIGLINE 1278
	
QUIGLINE 1279
	endf
QUIGLINE 1280
	
QUIGLINE 1281
	Function FmFreqUp:Void()
QUIGLINE 1282
	sAtCmd = "AT+FMSCANUP":ATCmd
QUIGLINE 1283
	
QUIGLINE 1284
	sAtCmd = "AT+FMFREQ?":ATCmd
QUIGLINE 1285
	sDisplay1 = "  FM  " + sAtData + "  ":PanSetDisplay1
QUIGLINE 1286
	endf
QUIGLINE 1287
	
QUIGLINE 1288
	Function FmFreqDown:Void()
QUIGLINE 1289
	sAtCmd = "AT+FMSCANDOWN":ATCmd
QUIGLINE 1290
	
QUIGLINE 1291
	sAtCmd = "AT+FMFREQ?":ATCmd
QUIGLINE 1292
	sDisplay1 = "  FM  " + sAtData + "  ":PanSetDisplay1
QUIGLINE 1293
	endf
QUIGLINE 1294
	
QUIGLINE 1295
	
QUIGLINE 1296
	;-------------------------------------------------------------------------------------------------
QUIGLINE 1297
	; === VOIP Functions
QUIGLINE 1298
	
QUIGLINE 1299
	Function Voip_init:Void()
QUIGLINE 1300
	
QUIGLINE 1301
	PanDeInit
QUIGLINE 1302
	label5.Colour.Set colour.darkBlue,Colour.SkyBlue,1 :Label5.refresh
QUIGLINE 1303
	
QUIGLINE 1304
	sPanMode ="VOIP"
QUIGLINE 1305
	
QUIGLINE 1306
	sDisplay1 = "  - PHONE - ":PanSetDisplay1
QUIGLINE 1307
	sDisplay2 = "            ":PanSetDisplay2
QUIGLINE 1308
	
QUIGLINE 1309
	sAtCmd = "AT+SEMODE=VOICE":ATCmd
QUIGLINE 1310
	
QUIGLINE 1311
	iStpStartup = 10
QUIGLINE 1312
	
QUIGLINE 1313
	iVoipStatusOld = 255
QUIGLINE 1314
	endf
QUIGLINE 1315
	
QUIGLINE 1316
	Function VoipHandler:Void()
QUIGLINE 1317
	
QUIGLINE 1318
	iDelayCt = iDelayCt + 1
QUIGLINE 1319
	If iDelayCt < iDelay Then
QUIGLINE 1320
		Return
QUIGLINE 1321
	EndIf
QUIGLINE 1322
	iDelayCt = 0
QUIGLINE 1323
	
QUIGLINE 1324
	VoipSeStatus
QUIGLINE 1325
	
QUIGLINE 1326
	VoipChkNewUsers
QUIGLINE 1327
	endf
QUIGLINE 1328
	
QUIGLINE 1329
	Function VoipGreenButton:Void()
QUIGLINE 1330
	
QUIGLINE 1331
	sDb="green  button":sysDebug
QUIGLINE 1332
	
QUIGLINE 1333
	if (iVoipStatus = defVoipIdle) then
QUIGLINE 1334
	VoipCallUser
QUIGLINE 1335
	endif
QUIGLINE 1336
	
QUIGLINE 1337
	if (iVoipStatus = defVoipIncommingCall) then
QUIGLINE 1338
	VoipCallAccept
QUIGLINE 1339
	endif
QUIGLINE 1340
	
QUIGLINE 1341
	endf
QUIGLINE 1342
	
QUIGLINE 1343
	Function VoipRedButton:Void()
QUIGLINE 1344
	sDb="red button":sysDebug
QUIGLINE 1345
	VoipCallBreak
QUIGLINE 1346
	endf
QUIGLINE 1347
	
QUIGLINE 1348
	Function VoipUserInc:Void()
QUIGLINE 1349
	
QUIGLINE 1350
	iUserOnlinePointer = iUserOnlinePointer + 1
QUIGLINE 1351
	
QUIGLINE 1352
	if (iUserOnlinePointer > iUserOnlineTotal ) then
QUIGLINE 1353
	iUserOnlinePointer = 1
QUIGLINE 1354
	endif
QUIGLINE 1355
	
QUIGLINE 1356
	u16OtherUserId = u16UserOnline(iUserOnlinePointer - 1)
QUIGLINE 1357
	
QUIGLINE 1358
	u16in1 = u16OtherUserId :F131_7
QUIGLINE 1359
	sDisplay1 = "USERID: "+ str(u16OtherUserId) :PanSetDisplay1
QUIGLINE 1360
	sDisplay2 = sOut2 :PanSetDisplay2
QUIGLINE 1361
	endf
QUIGLINE 1362
	
QUIGLINE 1363
	Function VoipUserDec:Void()
QUIGLINE 1364
	iUserOnlinePointer = iUserOnlinePointer - 1
QUIGLINE 1365
	
QUIGLINE 1366
	if (iUserOnlinePointer = 0 ) then
QUIGLINE 1367
	iUserOnlinePointer = iUserOnlineTotal
QUIGLINE 1368
	endif
QUIGLINE 1369
	
QUIGLINE 1370
	u16OtherUserId = u16UserOnline(iUserOnlinePointer - 1)
QUIGLINE 1371
	
QUIGLINE 1372
	u16in1 = u16OtherUserId
QUIGLINE 1373
	F131_7
QUIGLINE 1374
	sDisplay1 = "USERID: "+ str(u16OtherUserId) :PanSetDisplay1
QUIGLINE 1375
	sDisplay2 = sOut2 :PanSetDisplay2
QUIGLINE 1376
	endf
QUIGLINE 1377
	
QUIGLINE 1378
	
QUIGLINE 1379
	
QUIGLINE 1380
	Function VoipCallUser:Void()
QUIGLINE 1381
	u16in1 = u16OtherUserId
QUIGLINE 1382
	F131_10
QUIGLINE 1383
	endf
QUIGLINE 1384
	
QUIGLINE 1385
	Function VoipCallAccept:Void()
QUIGLINE 1386
	F131_11
QUIGLINE 1387
	endf
QUIGLINE 1388
	
QUIGLINE 1389
	Function VoipCallBreak:Void()
QUIGLINE 1390
	F131_12
QUIGLINE 1391
	endf
QUIGLINE 1392
	
QUIGLINE 1393
	Function VoipChkNewUsers:Void()
QUIGLINE 1394
	s = IO.In(ioA_A)
QUIGLINE 1395
	
QUIGLINE 1396
	if ((s and defNetStatusBitUser) > 0) then
QUIGLINE 1397
	F131_3					//.. read userOnline table
QUIGLINE 1398
	
QUIGLINE 1399
	if (iVoipSoundSelect <> 5) then
QUIGLINE 1400
	sDisplay2 = "LIST CHANGED" :PanSetDisplay2
QUIGLINE 1401
	Sound.FX.Play 0,sound.fx.sys.Beep1 -1 ,255
QUIGLINE 1402
	endif
QUIGLINE 1403
	endif
QUIGLINE 1404
	endf
QUIGLINE 1405
	
QUIGLINE 1406
	Function VoipSeStatus:Void()
QUIGLINE 1407
	iVoipStatus = IO.In(#FF21)
QUIGLINE 1408
	
QUIGLINE 1409
	if (iVoipStatus <> iVoipStatusOld) then
QUIGLINE 1410
	
QUIGLINE 1411
	iVoipStatusOld = iVoipStatus
QUIGLINE 1412
	
QUIGLINE 1413
	sDb = "voip status:" + str(iVoipStatus):sysDebug
QUIGLINE 1414
	sDb = "voip defVoipIdle" + str(defVoipIdle):sysDebug
QUIGLINE 1415
	
QUIGLINE 1416
	if (iVoipStatus = defVoipIdle) then
QUIGLINE 1417
	sDisplay1 = "  - PHONE -" :PanSetDisplay1
QUIGLINE 1418
	sDisplay2 = "IDLE" :PanSetDisplay2
QUIGLINE 1419
	iVoipSoundSelect = 0
QUIGLINE 1420
	endif
QUIGLINE 1421
	
QUIGLINE 1422
	if (iVoipStatus = defVoipOutgoingCall) then
QUIGLINE 1423
	u16in1 = u16OtherUserId :F131_7
QUIGLINE 1424
	sDisplay1 = sOut2 :PanSetDisplay1
QUIGLINE 1425
	sDisplay2 = "OUTGOING CALL " :PanSetDisplay2
QUIGLINE 1426
	iVoipSoundSelect = 1
QUIGLINE 1427
	endif
QUIGLINE 1428
	
QUIGLINE 1429
	if (iVoipStatus = defVoipOtherBusy) then
QUIGLINE 1430
	u16in1 = u16OtherUserId :F131_7
QUIGLINE 1431
	sDisplay1 = sOut2 :PanSetDisplay1
QUIGLINE 1432
	sDisplay2 = "IS BUSY" :PanSetDisplay2
QUIGLINE 1433
	iVoipSoundSelect = 2
QUIGLINE 1434
	endif
QUIGLINE 1435
	
QUIGLINE 1436
	if (iVoipStatus = defVoipOtherOffline) then
QUIGLINE 1437
	u16in1 = u16OtherUserId :F131_7
QUIGLINE 1438
	sDisplay1 = sOut2 :PanSetDisplay1
QUIGLINE 1439
	sDisplay2 = "OFFLINE !" :PanSetDisplay2
QUIGLINE 1440
	iVoipSoundSelect = 3
QUIGLINE 1441
	endif
QUIGLINE 1442
	
QUIGLINE 1443
	if (iVoipStatus = defVoipIncommingCall) then
QUIGLINE 1444
	VoipGetConnectedWith
QUIGLINE 1445
	u16in1 = u16OtherUserId :F131_7
QUIGLINE 1446
	sDisplay1 = sOut2 :PanSetDisplay1
QUIGLINE 1447
	sDisplay2 = "INCOMMING CALL" :PanSetDisplay2
QUIGLINE 1448
	iVoipSoundSelect = 4
QUIGLINE 1449
	
QUIGLINE 1450
	endif
QUIGLINE 1451
	
QUIGLINE 1452
	if (iVoipStatus = defVoipActiveCall) then
QUIGLINE 1453
	VoipGetConnectedWith
QUIGLINE 1454
	u16in1 = u16OtherUserId :F131_7
QUIGLINE 1455
	sDisplay1 = sOut2 :PanSetDisplay1
QUIGLINE 1456
	sDisplay2 = "CALLING..." :PanSetDisplay2
QUIGLINE 1457
	iVoipSoundSelect = 5
QUIGLINE 1458
	endif
QUIGLINE 1459
	
QUIGLINE 1460
	endif
QUIGLINE 1461
	endf
QUIGLINE 1462
	
QUIGLINE 1463
	
QUIGLINE 1464
	Function VoipSoundHandler:Void()
QUIGLINE 1465
	
QUIGLINE 1466
	iVoipSoundCt = iVoipSoundCt + 1
QUIGLINE 1467
	if (iVoipSoundCt < 5) then
QUIGLINE 1468
	return
QUIGLINE 1469
	endif
QUIGLINE 1470
	iVoipSoundCt = 0
QUIGLINE 1471
	
QUIGLINE 1472
	iVoipSoundSeq = iVoipSoundSeq  + 1
QUIGLINE 1473
	
QUIGLINE 1474
	if (iVoipSoundSeq > 5000) then
QUIGLINE 1475
	iVoipSoundSeq = 0
QUIGLINE 1476
	endif
QUIGLINE 1477
	
QUIGLINE 1478
	if (iVoipSoundSelect = 0) then
QUIGLINE 1479
	iVoipSoundSeq = 0
QUIGLINE 1480
	return
QUIGLINE 1481
	elseif (iVoipSoundSelect = 1) then // soundPlayCallUser
QUIGLINE 1482
	
QUIGLINE 1483
	if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 12) or (iVoipSoundSeq = 15)  then
QUIGLINE 1484
	Sound.FX.Play 0,sound.fx.sys.Ring2-1,255
QUIGLINE 1485
	endif
QUIGLINE 1486
	
QUIGLINE 1487
	if (iVoipSoundSeq > 30) then
QUIGLINE 1488
	iVoipSoundSeq = 0
QUIGLINE 1489
	endif
QUIGLINE 1490
	
QUIGLINE 1491
	elseif (iVoipSoundSelect = 2) then // soundPlayBusy
QUIGLINE 1492
	
QUIGLINE 1493
	if (iVoipSoundSeq = 1)  then
QUIGLINE 1494
	Sound.FX.Play 0,sound.fx.sys.Click1 -1 ,255
QUIGLINE 1495
	endif
QUIGLINE 1496
	
QUIGLINE 1497
	if (iVoipSoundSeq > 10) then
QUIGLINE 1498
	iVoipSoundSeq = 0
QUIGLINE 1499
	endif
QUIGLINE 1500
	
QUIGLINE 1501
	elseif (iVoipSoundSelect = 3) then // soundPlayOffline
QUIGLINE 1502
	
QUIGLINE 1503
	if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 7) then
QUIGLINE 1504
	Sound.FX.Play 0,sound.fx.sys.Click1-1,255
QUIGLINE 1505
	endif
QUIGLINE 1506
	
QUIGLINE 1507
	if (iVoipSoundSeq > 20) then
QUIGLINE 1508
	iVoipSoundSeq = 0
QUIGLINE 1509
	endif
QUIGLINE 1510
	
QUIGLINE 1511
	elseif (iVoipSoundSelect = 4) then // soundPlayBeCalled
QUIGLINE 1512
	
QUIGLINE 1513
	if (iVoipSoundSeq = 1)  then
QUIGLINE 1514
	Sound.FX.Play 0,sound.fx.sys.Win-1,255
QUIGLINE 1515
	endif
QUIGLINE 1516
	
QUIGLINE 1517
	if (iVoipSoundSeq > 55) then
QUIGLINE 1518
	iVoipSoundSeq = 0
QUIGLINE 1519
	endif
QUIGLINE 1520
	
QUIGLINE 1521
	endif
QUIGLINE 1522
	// iVoipSoundSelect = 5 CALLING
QUIGLINE 1523
	
QUIGLINE 1524
	
QUIGLINE 1525
	
QUIGLINE 1526
	endf
QUIGLINE 1527
	
QUIGLINE 1528
	Function VoipGetConnectedWith:Void()
QUIGLINE 1529
	
QUIGLINE 1530
	;	Get VOIP connected userID
QUIGLINE 1531
	;
QUIGLINE 1532
	; 	out:	u16OtherUserId
QUIGLINE 1533
	;
QUIGLINE 1534
	
QUIGLINE 1535
	u16OtherUserId = (256 * IO.In(#FF22)) + IO.In(#FF23)
QUIGLINE 1536
	sDb = "Voip connected with :" + str(u16OtherUserId):sysDebug
QUIGLINE 1537
	endf
QUIGLINE 1538
	
QUIGLINE 1539
	;-------------------------------------------------------------------------------------------------
QUIGLINE 1540
	
QUIGLINE 1541
	Function RcLearn_init:Void()
QUIGLINE 1542
	
QUIGLINE 1543
	bRcLearnActive = 1
QUIGLINE 1544
	
QUIGLINE 1545
	PanDeInit
QUIGLINE 1546
	label4.Colour.Set Colour.SkyBlue,colour.darkBlue,1 :Label4.refresh
QUIGLINE 1547
	
QUIGLINE 1548
	sDisplay1 = " - IR LEARN -":PanSetDisplay1
QUIGLINE 1549
	sDisplay2 = "             ":PanSetDisplay2
QUIGLINE 1550
	
QUIGLINE 1551
	Form2.open
QUIGLINE 1552
	Image15.Tile.Set shSe_char,17: Image15.Refresh
QUIGLINE 1553
	Image16.Tile.Set shSe_char,2:  Image16.Refresh
QUIGLINE 1554
	
QUIGLINE 1555
	RcLoadList
QUIGLINE 1556
	
QUIGLINE 1557
	Label30.text.set sRcCodeList(0):Label30.refresh
QUIGLINE 1558
	Label31.text.set sRcCodeList(1):Label31.refresh
QUIGLINE 1559
	Label32.text.set sRcCodeList(2):Label32.refresh
QUIGLINE 1560
	Label33.text.set sRcCodeList(3):Label33.refresh
QUIGLINE 1561
	Label34.text.set sRcCodeList(4):Label34.refresh
QUIGLINE 1562
	Label35.text.set sRcCodeList(5):Label35.refresh
QUIGLINE 1563
	Label36.text.set sRcCodeList(6):Label36.refresh
QUIGLINE 1564
	Label37.text.set sRcCodeList(7):Label37.refresh
QUIGLINE 1565
	Label38.text.set sRcCodeList(8):Label38.refresh
QUIGLINE 1566
	
QUIGLINE 1567
	endf
QUIGLINE 1568
	
QUIGLINE 1569
	Function RcChkFile:Void()
QUIGLINE 1570
	; new empty Rc file
QUIGLINE 1571
	
QUIGLINE 1572
	
QUIGLINE 1573
	sText = App.path + "SEPLAY.RCD"
QUIGLINE 1574
	fDiskRc.open sText
QUIGLINE 1575
	x = fDiskRc.status
QUIGLINE 1576
	fDiskRc.closeReadFile
QUIGLINE 1577
	
QUIGLINE 1578
	if (x = 0) then
QUIGLINE 1579
	sDb="Rc file not found":sysDebug
QUIGLINE 1580
	
QUIGLINE 1581
	sText = App.path + "SEPLAY.RCD"
QUIGLINE 1582
	
QUIGLINE 1583
	fDiskRc.new sText
QUIGLINE 1584
	fDiskRc.writeString "EMPTY"
QUIGLINE 1585
	fDiskRc.close
QUIGLINE 1586
	
QUIGLINE 1587
	For  t = 0  To iRcItems
QUIGLINE 1588
		sRcCodeList(t) = "00000000"
QUIGLINE 1589
	Next
QUIGLINE 1590
	
QUIGLINE 1591
	RcSaveList
QUIGLINE 1592
	
QUIGLINE 1593
	else
QUIGLINE 1594
	sDb="Rc file is found":sysDebug
QUIGLINE 1595
	endif
QUIGLINE 1596
	
QUIGLINE 1597
	Garbage
QUIGLINE 1598
	endf
QUIGLINE 1599
	
QUIGLINE 1600
	Function RcLoadList:Void()
QUIGLINE 1601
	
QUIGLINE 1602
	; check if present
QUIGLINE 1603
	
QUIGLINE 1604
	sText = App.path + "SEPLAY.RCD"
QUIGLINE 1605
	fDiskRc.open sText
QUIGLINE 1606
	
QUIGLINE 1607
	
QUIGLINE 1608
	if (fDiskRc.status > 0) then
QUIGLINE 1609
	
QUIGLINE 1610
	for t = 0 to iRcItems
QUIGLINE 1611
	
QUIGLINE 1612
	sText  =  fDiskRc.ReadString()
QUIGLINE 1613
	sRcCodeList(t) = sText
QUIGLINE 1614
	
QUIGLINE 1615
	sDb = str(t)+" read code: " + sRcCodeList(t):sysDebug
QUIGLINE 1616
	next
QUIGLINE 1617
	endif
QUIGLINE 1618
	
QUIGLINE 1619
	
QUIGLINE 1620
	fDiskRc.closeReadFile
QUIGLINE 1621
	
QUIGLINE 1622
	
QUIGLINE 1623
	sDb  = "EXIT load list" :sysDebug
QUIGLINE 1624
	
QUIGLINE 1625
	Garbage
QUIGLINE 1626
	endf
QUIGLINE 1627
	
QUIGLINE 1628
	Function RcSaveList:Void()
QUIGLINE 1629
	
QUIGLINE 1630
	sText = App.path + "SEPLAY.RCD"
QUIGLINE 1631
	fDiskRc.open sText
QUIGLINE 1632
	
QUIGLINE 1633
	for t = 0 to iRcItems
QUIGLINE 1634
	fDiskRc.writeString sRcCodeList(t)
QUIGLINE 1635
	sDb = str(t)+" write code: " + sRcCodeList(t):sysDebug
QUIGLINE 1636
	next
QUIGLINE 1637
	
QUIGLINE 1638
	fDiskRc.writeString "END"
QUIGLINE 1639
	
QUIGLINE 1640
	fDiskRc.close
QUIGLINE 1641
	
QUIGLINE 1642
	sDb = "RC data is saved":sysDebug
QUIGLINE 1643
	Garbage
QUIGLINE 1644
	endf
QUIGLINE 1645
	
QUIGLINE 1646
	Function RcGetCode:Void()
QUIGLINE 1647
	// Get RC code from rc received buffer
QUIGLINE 1648
	
QUIGLINE 1649
	F245_0
QUIGLINE 1650
	
QUIGLINE 1651
	If (iRcContent > 0) Then
QUIGLINE 1652
		F245_1
QUIGLINE 1653
		bRcCodeReceived = 1
QUIGLINE 1654
	EndIf
QUIGLINE 1655
EndF
QUIGLINE 1656

QUIGLINE 1657
Function RcCodeHandler:Void()
QUIGLINE 1658
	
QUIGLINE 1659
	y  = 255
QUIGLINE 1660
	For x= 0 To iRcItems
QUIGLINE 1661
		If (sRcCode  = sRcCodeList(x)) Then
QUIGLINE 1662
			y = x
QUIGLINE 1663
			x=100
QUIGLINE 1664
		EndIf
QUIGLINE 1665
	Next
QUIGLINE 1666
	
QUIGLINE 1667
	sDb = "rc "+str(y):sysDebug
QUIGLINE 1668
	
QUIGLINE 1669
	;volume up
QUIGLINE 1670
	If (y = 7) Then
QUIGLINE 1671
		sAtCmd = "AT+DSPVOLUP":ATCmd
QUIGLINE 1672
	EndIf
QUIGLINE 1673
	
QUIGLINE 1674
	;volume down
QUIGLINE 1675
	If (y = 8) Then
QUIGLINE 1676
		sAtCmd = "AT+DSPVOLDOWN":ATCmd
QUIGLINE 1677
	EndIf
QUIGLINE 1678
EndF
QUIGLINE 1679

QUIGLINE 1680

QUIGLINE 1681
;-------------------------------------------------------------------------------------------------
QUIGLINE 1682

QUIGLINE 1683
Function  Trim:void()
QUIGLINE 1684
	
QUIGLINE 1685
	sTrimOut = ""
QUIGLINE 1686
	
QUIGLINE 1687
	fn = 0
QUIGLINE 1688
	fy = len(sTrim)
QUIGLINE 1689
	for fx = 1 to fy
QUIGLINE 1690
	fc = asc(mid(sTrim,fx,1))
QUIGLINE 1691
	
QUIGLINE 1692
	if ((fn = 0) and (fc > 32)) then
QUIGLINE 1693
	fn = 1
QUIGLINE 1694
	endif
QUIGLINE 1695
	
QUIGLINE 1696
	if ((fn = 1) and (fc < 32)) then
QUIGLINE 1697
	fn = 2
QUIGLINE 1698
	endif
QUIGLINE 1699
	
QUIGLINE 1700
	if (fn = 1) then
QUIGLINE 1701
	sTrimOut = sTrimOut + chr(fc)
QUIGLINE 1702
	endif
QUIGLINE 1703
	
QUIGLINE 1704
	next
QUIGLINE 1705
	
QUIGLINE 1706
	endf
QUIGLINE 1707
	
QUIGLINE 1708
	Function  TrimSpc:void()
QUIGLINE 1709
	
QUIGLINE 1710
	;  input :   "hello   "
QUIGLINE 1711
	;  output:   "hello"
QUIGLINE 1712
	
QUIGLINE 1713
	sTrimOut = ""
QUIGLINE 1714
	
QUIGLINE 1715
	fn = 0
QUIGLINE 1716
	fy = len(sTrim)
QUIGLINE 1717
	
QUIGLINE 1718
	for fx = fy to 1 step -1
QUIGLINE 1719
	
QUIGLINE 1720
	fc = asc(mid(sTrim,fx,1))
QUIGLINE 1721
	
QUIGLINE 1722
	if (fc  > 32) then
QUIGLINE 1723
	fn = fx
QUIGLINE 1724
	fx = 0
QUIGLINE 1725
	endif
QUIGLINE 1726
	
QUIGLINE 1727
	next
QUIGLINE 1728
	
QUIGLINE 1729
	sTrimOut = left(sTrim,fn)
QUIGLINE 1730
	endf
QUIGLINE 1731
	
QUIGLINE 1732
	
QUIGLINE 1733
	
QUIGLINE 1734
	
QUIGLINE 1735
	Function loadCharTable:void()
QUIGLINE 1736
	
QUIGLINE 1737
	Data.Set CharTable
QUIGLINE 1738
	
QUIGLINE 1739
	for t = 0 to 100
QUIGLINE 1740
	a = Data.Byte
QUIGLINE 1741
	u8CharTable(t) = a
QUIGLINE 1742
	next
QUIGLINE 1743
	
QUIGLINE 1744
	Asm
QUIGLINE 1745
	
QUIGLINE 1746
	.CharTable:
QUIGLINE 1747
	
QUIGLINE 1748
	;0
QUIGLINE 1749
	Db  00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
QUIGLINE 1750
	;16
QUIGLINE 1751
	Db  00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
QUIGLINE 1752
	;32
QUIGLINE 1753
	Db  38,00,00,00,00,00,00,00,00,00,00,40,00,39,26,43
QUIGLINE 1754
	;48
QUIGLINE 1755
	Db  37,28,29,30,31,32,33,34,35,36,27,00,00,00,00,00
QUIGLINE 1756
	;64
QUIGLINE 1757
	Db  00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,14
QUIGLINE 1758
	;80
QUIGLINE 1759
	Db  15,16,17,18,19,20,21,22,23,24,25,00,44,00,00,00
QUIGLINE 1760
	;96
QUIGLINE 1761
	Db  00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
QUIGLINE 1762
	;102
QUIGLINE 1763
	Db  00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
QUIGLINE 1764
	
QUIGLINE 1765
	Quigs
QUIGLINE 1766
	endf
QUIGLINE 1767
	
QUIGLINE 1768
	Function LoadImgCtrls:void()
QUIGLINE 1769
	
QUIGLINE 1770
	ImgIds( 1)=Ctrl.GetID(Form1,Image1.Display)
QUIGLINE 1771
	ImgIds( 2)=Ctrl.GetID(Form1,Image2.Display)
QUIGLINE 1772
	ImgIds( 3)=Ctrl.GetID(Form1,Image3.Display)
QUIGLINE 1773
	ImgIds( 4)=Ctrl.GetID(Form1,Image4.Display)
QUIGLINE 1774
	ImgIds( 5)=Ctrl.GetID(Form1,Image5.Display)
QUIGLINE 1775
	ImgIds( 6)=Ctrl.GetID(Form1,Image6.Display)
QUIGLINE 1776
	ImgIds( 7)=Ctrl.GetID(Form1,Image7.Display)
QUIGLINE 1777
	ImgIds( 8)=Ctrl.GetID(Form1,Image8.Display)
QUIGLINE 1778
	ImgIds( 9)=Ctrl.GetID(Form1,Image9.Display)
QUIGLINE 1779
	ImgIds(10)=Ctrl.GetID(Form1,Image10.Display)
QUIGLINE 1780
	ImgIds(11)=Ctrl.GetID(Form1,Image11.Display)
QUIGLINE 1781
	ImgIds(12)=Ctrl.GetID(Form1,Image12.Display)
QUIGLINE 1782
	ImgIds(13)=Ctrl.GetID(Form1,Image17.Display)
QUIGLINE 1783
	ImgIds(14)=Ctrl.GetID(Form1,Image18.Display)
QUIGLINE 1784
	
QUIGLINE 1785
	ImgIds(15)=Ctrl.GetID(Form1,Image19.Display)
QUIGLINE 1786
	ImgIds(16)=Ctrl.GetID(Form1,Image20.Display)
QUIGLINE 1787
	ImgIds(17)=Ctrl.GetID(Form1,Image21.Display)
QUIGLINE 1788
	ImgIds(18)=Ctrl.GetID(Form1,Image22.Display)
QUIGLINE 1789
	ImgIds(19)=Ctrl.GetID(Form1,Image23.Display)
QUIGLINE 1790
	ImgIds(20)=Ctrl.GetID(Form1,Image24.Display)
QUIGLINE 1791
	ImgIds(21)=Ctrl.GetID(Form1,Image25.Display)
QUIGLINE 1792
	ImgIds(22)=Ctrl.GetID(Form1,Image26.Display)
QUIGLINE 1793
	ImgIds(23)=Ctrl.GetID(Form1,Image27.Display)
QUIGLINE 1794
	ImgIds(24)=Ctrl.GetID(Form1,Image28.Display)
QUIGLINE 1795
	ImgIds(25)=Ctrl.GetID(Form1,Image29.Display)
QUIGLINE 1796
	ImgIds(26)=Ctrl.GetID(Form1,Image30.Display)
QUIGLINE 1797
	ImgIds(27)=Ctrl.GetID(Form1,Image31.Display)
QUIGLINE 1798
	ImgIds(28)=Ctrl.GetID(Form1,Image32.Display)
QUIGLINE 1799
	
QUIGLINE 1800
	Garbage
QUIGLINE 1801
	endf
QUIGLINE 1802
	
QUIGLINE 1803
	;-------------------------------------------------------------------------------------------------
QUIGLINE 1804
	; === STP PROGRAMS ===
QUIGLINE 1805
	
QUIGLINE 1806
	Function   stpStartup:Void()
QUIGLINE 1807
	
QUIGLINE 1808
	iDelayCt = iDelayCt + 1
QUIGLINE 1809
	If iDelayCt < iDelay Then
QUIGLINE 1810
		Return
QUIGLINE 1811
	EndIf
QUIGLINE 1812
	iDelayCt = 0
QUIGLINE 1813
	
QUIGLINE 1814
	
QUIGLINE 1815
	If iStpStartup = 10 Then		//.. start
QUIGLINE 1816
		
QUIGLINE 1817
		sDisplay2 = "FIRMWARE CHECK":PanSetDisplay2
QUIGLINE 1818
		
QUIGLINE 1819
		sIn1 =  sFirmware
QUIGLINE 1820
		F72_25	//.. check firmware
QUIGLINE 1821
		If  u8Out1 > 0  Then
QUIGLINE 1822
			c = MsgBox("Firmware  out of  date !","Needed: ",sFirmware ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
QUIGLINE 1823
		EndIf
QUIGLINE 1824
		
QUIGLINE 1825
		F131_1	//.. get tmtnet status
QUIGLINE 1826
		If u8Out1 = 3 Then
QUIGLINE 1827
			iStpStartup  = 30
QUIGLINE 1828
		Else
QUIGLINE 1829
			sDisplay2 = "LOGIN":PanSetDisplay2
QUIGLINE 1830
			F131_0						//.. login tmtnet
QUIGLINE 1831
			iStpStartup = 20
QUIGLINE 1832
		EndIf
QUIGLINE 1833
		return
QUIGLINE 1834
	EndIf
QUIGLINE 1835
	
QUIGLINE 1836
	If iStpStartup = 20 Then	//.. Wait for connection
QUIGLINE 1837
		F131_1	//.. get status
QUIGLINE 1838
		If u8Out1 = 0 Then
QUIGLINE 1839
			c = MsgBox("Wifi OFFLINE !","Not connected: ","" ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
QUIGLINE 1840
			iAppExit = 1
QUIGLINE 1841
		EndIf
QUIGLINE 1842
		
QUIGLINE 1843
		If u8Out1 = 3 Then
QUIGLINE 1844
			iStpStartup  = 30
QUIGLINE 1845
		EndIf
QUIGLINE 1846
		return
QUIGLINE 1847
	EndIf
QUIGLINE 1848
	
QUIGLINE 1849
	If iStpStartup = 30 Then		//.. Login ready
QUIGLINE 1850
		
QUIGLINE 1851
		sIn1 = "SE_PLAY"
QUIGLINE 1852
		F131_32						//.. set Appname
QUIGLINE 1853
		
QUIGLINE 1854
		sDisplay2 = " TMTNET RDY ":PanSetDisplay2
QUIGLINE 1855
		
QUIGLINE 1856
		F131_2					//.. clear userOnline table
QUIGLINE 1857
		
QUIGLINE 1858
		iDelay = 25			//.. 500ms
QUIGLINE 1859
		iDelayCt = 0
QUIGLINE 1860
		iStpStartup = 110
QUIGLINE 1861
		
QUIGLINE 1862
		sDb = "Stp end 110 ":sysDebug
QUIGLINE 1863
		return
QUIGLINE 1864
	EndIf
QUIGLINE 1865
	
QUIGLINE 1866
	If iStpStartup = 110 Then	//.. Read online users
QUIGLINE 1867
		
QUIGLINE 1868
		F131_3					//.. read userOnline table
QUIGLINE 1869
		
QUIGLINE 1870
		iStpStartup = 0
QUIGLINE 1871
		iDelay = 10		//200ms
QUIGLINE 1872
		
QUIGLINE 1873
		sDb = "Stp EXIT":sysDebug
QUIGLINE 1874
		endif
QUIGLINE 1875
EndF
QUIGLINE 1876

QUIGLINE 1877

QUIGLINE 1878

QUIGLINE 1879

QUIGLINE 1880
;-------------------------------------------------------------------------------------------------
QUIGLINE 1881
Function sys_IO_init:Void()
QUIGLINE 1882
	
QUIGLINE 1883
	If  (Machine = 7)  Or  (Machine = 8)  Or  (Machine = 9) Or  (Machine = 10) Then
QUIGLINE 1884
		ioA_0 = #40f0 : ioA_1 = #41f0 : ioA_2 = #42f0 : ioA_3 = #43f0
QUIGLINE 1885
		ioA_4 = #44f0 : ioA_5 = #45f0 : ioA_6 = #46f0 : ioA_7 = #47f0
QUIGLINE 1886
		ioA_8 = #48f0 : ioA_9 = #49f0 : ioA_A = #4af0 : ioA_B = #4bf0
QUIGLINE 1887
		ioA_C = #4cf0 : ioA_D = #4df0 : ioA_E = #4ef0 : ioA_F = #4ff0
QUIGLINE 1888
		
QUIGLINE 1889
		sCPU = "MSX"
QUIGLINE 1890
	EndIf
QUIGLINE 1891
	
QUIGLINE 1892
	If  (Machine = 6)  Then
QUIGLINE 1893
		ioA_0 = #40 : ioA_1 = #41 : ioA_2 = #42 : ioA_3 = #43
QUIGLINE 1894
		ioA_4 = #44 : ioA_5 = #45 : ioA_6 = #46 : ioA_7 = #47
QUIGLINE 1895
		ioA_8 = #48 : ioA_9 = #49 : ioA_A = #4a : ioA_B = #4b
QUIGLINE 1896
		ioA_C = #4c : ioA_D = #4d : ioA_E = #4e : ioA_F = #4f
QUIGLINE 1897
		
QUIGLINE 1898
		sCPU = "EP"
QUIGLINE 1899
	EndIf
QUIGLINE 1900
	
QUIGLINE 1901
	If  (Machine = Machine.Pcw8xxx)  or  (Machine = Machine.Pcw9xxx) or (Machine = Machine.Pcw16) Then
QUIGLINE 1902
		ioA_0 = #40B0 : ioA_1 = #41B0 : ioA_2 = #42B0 : ioA_3 = #43B0
QUIGLINE 1903
		ioA_4 = #44B0 : ioA_5 = #45B0 : ioA_6 = #46B0 : ioA_7 = #47B0
QUIGLINE 1904
		ioA_8 = #48B0 : ioA_9 = #49B0 : ioA_A = #4aB0 : ioA_B = #4bB0
QUIGLINE 1905
		ioA_C = #4cB0 : ioA_D = #4dB0 : ioA_E = #4eB0 : ioA_F = #4fB0
QUIGLINE 1906
		
QUIGLINE 1907
		sCPU = "PCW"
QUIGLINE 1908
	EndIf
QUIGLINE 1909
	
QUIGLINE 1910
	If  (Machine < 5)  Then
QUIGLINE 1911
		ioA_0 = #fd40 : ioA_1 = #fd41 : ioA_2 = #fd42 : ioA_3 = #fd43
QUIGLINE 1912
		ioA_4 = #fd44 : ioA_5 = #fd45 : ioA_6 = #fd46 : ioA_7 = #fd47
QUIGLINE 1913
		ioA_8 = #fd48 : ioA_9 = #fd49 : ioA_A = #fd4a : ioA_B = #fd4b
QUIGLINE 1914
		ioA_C = #fd4c : ioA_D = #fd4d : ioA_E = #fd4e : ioA_F = #fd4f
QUIGLINE 1915
		
QUIGLINE 1916
		sCPU = "CPC"
QUIGLINE 1917
	EndIf
QUIGLINE 1918
	
QUIGLINE 1919
	sDb = sCPU:sysDebug
QUIGLINE 1920
EndF
QUIGLINE 1921

QUIGLINE 1922
;-------------------------------------------------------------------------------------------------
QUIGLINE 1923
Function sysDebug:void()
QUIGLINE 1924
	//	'------ debug tool  send to FTDI port in sDb
QUIGLINE 1925
	
QUIGLINE 1926
	iDbL = Len(sDb)
QUIGLINE 1927
	For iDbT = 1 To iDbL
QUIGLINE 1928
		iDbC = Asc(Mid(sDb,iDbT,1))
QUIGLINE 1929
		IO.Out ioA_0,iDbC
QUIGLINE 1930
	Next
QUIGLINE 1931
	IO.Out ioA_0,13
QUIGLINE 1932
	IO.Out ioA_0,10
QUIGLINE 1933
	
QUIGLINE 1934
EndF
QUIGLINE 1935

QUIGLINE 1936
;-------------------------------------------------------------------------------------------------
QUIGLINE 1937
; === SF3 functions
QUIGLINE 1938

QUIGLINE 1939
Function ArmResponse:Int()
QUIGLINE 1940
	
QUIGLINE 1941
	;	------ wait for ARM progress
QUIGLINE 1942
	;
QUIGLINE 1943
	;	return 0 = ready
QUIGLINE 1944
	;	       2 = error
QUIGLINE 1945
	
QUIGLINE 1946
	iResp = 1
QUIGLINE 1947
	
QUIGLINE 1948
	While (iResp = 1)
QUIGLINE 1949
		iResp = IO.In(ioA_1)
QUIGLINE 1950
	Wend
QUIGLINE 1951
	
QUIGLINE 1952
	If  iResp = 2 Then
QUIGLINE 1953
		F72_4
QUIGLINE 1954
	EndIf
QUIGLINE 1955
	
QUIGLINE 1956
	Return(iResp)
QUIGLINE 1957
EndF
QUIGLINE 1958

QUIGLINE 1959
Function WifiResponse:Int()
QUIGLINE 1960
	
QUIGLINE 1961
	;	------ wait for Wifi background progress
QUIGLINE 1962
	;
QUIGLINE 1963
	;	return 0 = ready
QUIGLINE 1964
	;	       2 = error
QUIGLINE 1965
	
QUIGLINE 1966
	iResp = 1
QUIGLINE 1967
	
QUIGLINE 1968
	While (iResp = 1)
QUIGLINE 1969
		iResp = IO.In(ioA_E)
QUIGLINE 1970
	Wend
QUIGLINE 1971
	
QUIGLINE 1972
	Return(iResp)
QUIGLINE 1973
EndF
QUIGLINE 1974

QUIGLINE 1975

QUIGLINE 1976
Function F40:Void()
QUIGLINE 1977
	// todo TIJDELIJK
QUIGLINE 1978
	//Set  SEONE in Audiostream mode
QUIGLINE 1979
	
QUIGLINE 1980
	Lock.On
QUIGLINE 1981
	
QUIGLINE 1982
	IO.Out ioA_1,0
QUIGLINE 1983
	IO.Out ioA_2,u8in1
QUIGLINE 1984
	IO.Out ioA_1,40
QUIGLINE 1985
	
QUIGLINE 1986
	If ArmResponse =2 Then
QUIGLINE 1987
		//nop
QUIGLINE 1988
	EndIf
QUIGLINE 1989
	
QUIGLINE 1990
	Lock.Off
QUIGLINE 1991
EndF
QUIGLINE 1992

QUIGLINE 1993
Function	F72_4:Void()
QUIGLINE 1994
	
QUIGLINE 1995
	;	------ Error handler
QUIGLINE 1996
	;
QUIGLINE 1997
	
QUIGLINE 1998
	Lock.On
QUIGLINE 1999
	
QUIGLINE 2000
	sDb = "ARM ERROR":sysDebug
QUIGLINE 2001
	
QUIGLINE 2002
	Lock.Off
QUIGLINE 2003
EndF
QUIGLINE 2004

QUIGLINE 2005
Function F72_25:Void()
QUIGLINE 2006
	
QUIGLINE 2007
	;	------ Check Firmware version
QUIGLINE 2008
	
QUIGLINE 2009
	Lock.On
QUIGLINE 2010
	IO.Out ioA_1,0
QUIGLINE 2011
	IO.Out ioA_2,25
QUIGLINE 2012
	
QUIGLINE 2013
	For  x = 1 To  8
QUIGLINE 2014
		IO.Out ioA_2,Asc(Mid(sIn1,x,1))
QUIGLINE 2015
	Next
QUIGLINE 2016
	
QUIGLINE 2017
	IO.Out ioA_1,72
QUIGLINE 2018
	
QUIGLINE 2019
	If ArmResponse =2 Then
QUIGLINE 2020
		//nop
QUIGLINE 2021
	EndIf
QUIGLINE 2022
	
QUIGLINE 2023
	u8Out1    = IO.In(ioA_2)
QUIGLINE 2024
	
QUIGLINE 2025
	Lock.Off
QUIGLINE 2026
EndF
QUIGLINE 2027

QUIGLINE 2028
Function F72_26:Void()
QUIGLINE 2029
	
QUIGLINE 2030
	;	------ Get seperate system  info
QUIGLINE 2031
	;
QUIGLINE 2032
	;	0 = Hardware	RSF3/ RSF3-LITE/ SF3/ TNC
QUIGLINE 2033
	;	1 = Version		1.0  /	v2d1 /2.0
QUIGLINE 2034
	;	2 = CPU			CPC / EP / PCW / MSX / SC3K /
QUIGLINE 2035
	;	3 = Firmware	202312310
QUIGLINE 2036
	
QUIGLINE 2037
	Lock.On
QUIGLINE 2038
	IO.Out ioA_1,0
QUIGLINE 2039
	IO.Out ioA_2,26
QUIGLINE 2040
	IO.Out ioA_2,u8in1
QUIGLINE 2041
	
QUIGLINE 2042
	IO.Out ioA_1,72
QUIGLINE 2043
	
QUIGLINE 2044
	If ArmResponse =2 Then
QUIGLINE 2045
		//nop
QUIGLINE 2046
	EndIf
QUIGLINE 2047
	
QUIGLINE 2048
	c = 1
QUIGLINE 2049
	sOut1 = ""
QUIGLINE 2050
	While (c  > 0)
QUIGLINE 2051
		c = IO.In(ioA_2)
QUIGLINE 2052
		If  c > 0 Then
QUIGLINE 2053
			sOut1= sOut1 + Chr(c)
QUIGLINE 2054
		EndIf
QUIGLINE 2055
	Wend
QUIGLINE 2056
	
QUIGLINE 2057
	Lock.Off
QUIGLINE 2058
	
QUIGLINE 2059
	
QUIGLINE 2060
EndF
QUIGLINE 2061

QUIGLINE 2062

QUIGLINE 2063
Function F90_5: Void()
QUIGLINE 2064
	
QUIGLINE 2065
	;	------ Open socket
QUIGLINE 2066
	;
QUIGLINE 2067
	;	in:   iSock ,ip1,ip2,ip3,ip4,portHigh,portlow
QUIGLINE 2068
	;
QUIGLINE 2069
	
QUIGLINE 2070
	bWifiErr = 0
QUIGLINE 2071
	
QUIGLINE 2072
	Lock.On
QUIGLINE 2073
	
QUIGLINE 2074
	IO.Out ioA_1,7
QUIGLINE 2075
	IO.Out ioA_9,5
QUIGLINE 2076
	
QUIGLINE 2077
	IO.Out ioA_9,iIp(0)
QUIGLINE 2078
	IO.Out ioA_9,iIp(1)
QUIGLINE 2079
	IO.Out ioA_9,iIp(2)
QUIGLINE 2080
	IO.Out ioA_9,iIp(3)
QUIGLINE 2081
	
QUIGLINE 2082
	IO.Out ioA_9,iPortHigh
QUIGLINE 2083
	IO.Out ioA_9,iPortlow
QUIGLINE 2084
	
QUIGLINE 2085
	IO.Out ioA_9,iSock
QUIGLINE 2086
	
QUIGLINE 2087
	IO.Out ioA_1,90
QUIGLINE 2088
	
QUIGLINE 2089
	If ArmResponse = 2 Then
QUIGLINE 2090
		//nop
QUIGLINE 2091
	EndIf
QUIGLINE 2092
	
QUIGLINE 2093
	Lock.Off
QUIGLINE 2094
	
QUIGLINE 2095
	If WifiResponse = 2 Then
QUIGLINE 2096
		bWifiErr = 1
QUIGLINE 2097
	EndIf
QUIGLINE 2098
	
QUIGLINE 2099
EndF
QUIGLINE 2100

QUIGLINE 2101

QUIGLINE 2102
Function F90_8:Void()
QUIGLINE 2103
	
QUIGLINE 2104
	;	------ Send data to socket
QUIGLINE 2105
	;
QUIGLINE 2106
	;	in: sIn1 :urlSend
QUIGLINE 2107
	
QUIGLINE 2108
	bWifiErr = 0
QUIGLINE 2109
	
QUIGLINE 2110
	Lock.On
QUIGLINE 2111
	
QUIGLINE 2112
	IO.Out ioA_1,7
QUIGLINE 2113
	
QUIGLINE 2114
	IO.Out ioA_9,8
QUIGLINE 2115
	IO.Out ioA_9,iSock
QUIGLINE 2116
	
QUIGLINE 2117
	l = Len(sIn1)
QUIGLINE 2118
	
QUIGLINE 2119
	For t = 1 To l
QUIGLINE 2120
		c = Asc(Mid(sIn1,t,1))
QUIGLINE 2121
		IO.Out ioA_9,c
QUIGLINE 2122
	Next
QUIGLINE 2123
	
QUIGLINE 2124
	IO.Out ioA_1,90
QUIGLINE 2125
	
QUIGLINE 2126
	If ArmResponse = 2 Then
QUIGLINE 2127
		//nop
QUIGLINE 2128
	EndIf
QUIGLINE 2129
	
QUIGLINE 2130
	Lock.Off
QUIGLINE 2131
	
QUIGLINE 2132
	If WifiResponse = 2 Then
QUIGLINE 2133
		bWifiErr = 1
QUIGLINE 2134
	EndIf
QUIGLINE 2135
	
QUIGLINE 2136
EndF
QUIGLINE 2137

QUIGLINE 2138
Function 	F90_10:Void()
QUIGLINE 2139
	
QUIGLINE 2140
	;	------ Close socket
QUIGLINE 2141
	;
QUIGLINE 2142
	;	in: sock nr
QUIGLINE 2143
	
QUIGLINE 2144
	bWifiErr = 0
QUIGLINE 2145
	
QUIGLINE 2146
	Lock.On
QUIGLINE 2147
	
QUIGLINE 2148
	IO.Out ioA_1,7
QUIGLINE 2149
	
QUIGLINE 2150
	IO.Out ioA_9,10
QUIGLINE 2151
	IO.Out ioA_9,iSock
QUIGLINE 2152
	
QUIGLINE 2153
	IO.Out ioA_1,90
QUIGLINE 2154
	
QUIGLINE 2155
	If ArmResponse = 2 Then
QUIGLINE 2156
		// nop
QUIGLINE 2157
	EndIf
QUIGLINE 2158
	
QUIGLINE 2159
	Lock.Off
QUIGLINE 2160
	
QUIGLINE 2161
	If WifiResponse = 2 Then
QUIGLINE 2162
		bWifiErr = 1
QUIGLINE 2163
	EndIf
QUIGLINE 2164
	
QUIGLINE 2165
EndF
QUIGLINE 2166

QUIGLINE 2167

QUIGLINE 2168
Function 	F90_18:Void()
QUIGLINE 2169
	
QUIGLINE 2170
	;	------ read socket data buffer content
QUIGLINE 2171
	;
QUIGLINE 2172
	;	in:  sock nr
QUIGLINE 2173
	;   out: buffer content
QUIGLINE 2174
	
QUIGLINE 2175
	bWifiErr = 0
QUIGLINE 2176
	
QUIGLINE 2177
	Lock.On
QUIGLINE 2178
	
QUIGLINE 2179
	IO.Out ioA_1,7
QUIGLINE 2180
	
QUIGLINE 2181
	IO.Out ioA_9,18
QUIGLINE 2182
	IO.Out ioA_9,iSock
QUIGLINE 2183
	
QUIGLINE 2184
	IO.Out ioA_1,90
QUIGLINE 2185
	
QUIGLINE 2186
	If ArmResponse = 2 Then
QUIGLINE 2187
		// nop
QUIGLINE 2188
	EndIf
QUIGLINE 2189
	
QUIGLINE 2190
	Lock.Off
QUIGLINE 2191
	
QUIGLINE 2192
	If WifiResponse = 2 Then
QUIGLINE 2193
		bWifiErr = 1
QUIGLINE 2194
	EndIf
QUIGLINE 2195
	
QUIGLINE 2196
	u16Out1 = (256 * IO.In(ioA_9)) + IO.In(ioA_9)
QUIGLINE 2197
	
QUIGLINE 2198
EndF
QUIGLINE 2199

QUIGLINE 2200
Function F90_21:void()
QUIGLINE 2201
	
QUIGLINE 2202
	; ------ Copy wifi to audiostream
QUIGLINE 2203
	
QUIGLINE 2204
	Lock.On
QUIGLINE 2205
	IO.Out ioA_1,7
QUIGLINE 2206
	IO.Out ioA_9,21
QUIGLINE 2207
	IO.Out ioA_1,90
QUIGLINE 2208
	
QUIGLINE 2209
	If ArmResponse =2 Then
QUIGLINE 2210
		//nop
QUIGLINE 2211
	EndIf
QUIGLINE 2212
	
QUIGLINE 2213
	Lock.Off
QUIGLINE 2214
EndF
QUIGLINE 2215

QUIGLINE 2216

QUIGLINE 2217

QUIGLINE 2218
Function F131_0:Void()
QUIGLINE 2219
	
QUIGLINE 2220
	; ------ Tmtnet connect
QUIGLINE 2221
	
QUIGLINE 2222
	Lock.On
QUIGLINE 2223
	IO.Out ioA_1,0
QUIGLINE 2224
	IO.Out ioA_2,0
QUIGLINE 2225
	IO.Out ioA_1,131
QUIGLINE 2226
	
QUIGLINE 2227
	If ArmResponse =2 Then
QUIGLINE 2228
		//nop
QUIGLINE 2229
	EndIf
QUIGLINE 2230
	
QUIGLINE 2231
	Lock.Off
QUIGLINE 2232
	
QUIGLINE 2233
EndF
QUIGLINE 2234

QUIGLINE 2235
Function F131_1:void()
QUIGLINE 2236
	
QUIGLINE 2237
	; ------  Get stutus
QUIGLINE 2238
	;
QUIGLINE 2239
	; 0 = Server logoff
QUIGLINE 2240
	; 1 = Server online, user logoff
QUIGLINE 2241
	; 2 = User login waiting for access
QUIGLINE 2242
	; 3 = User login connected
QUIGLINE 2243
	; 4 = Error
QUIGLINE 2244
	
QUIGLINE 2245
	
QUIGLINE 2246
	Lock.On
QUIGLINE 2247
	IO.Out ioA_1,0
QUIGLINE 2248
	IO.Out ioA_2,1
QUIGLINE 2249
	IO.Out ioA_1,131
QUIGLINE 2250
	
QUIGLINE 2251
	If ArmResponse =2 Then
QUIGLINE 2252
		//nop
QUIGLINE 2253
	EndIf
QUIGLINE 2254
	
QUIGLINE 2255
	u8Out1    = IO.In(ioA_2)
QUIGLINE 2256
	
QUIGLINE 2257
	Lock.Off
QUIGLINE 2258
	Endf
QUIGLINE 2259
	
QUIGLINE 2260
	Function F131_2:void()
QUIGLINE 2261
	
QUIGLINE 2262
	; ------ Reset userOnline array
QUIGLINE 2263
	
QUIGLINE 2264
	Lock.On
QUIGLINE 2265
	
QUIGLINE 2266
	IO.Out ioA_1,0
QUIGLINE 2267
	IO.Out ioA_2,2
QUIGLINE 2268
	IO.Out ioA_1,131
QUIGLINE 2269
	
QUIGLINE 2270
	If ArmResponse =2 Then
QUIGLINE 2271
		//nop
QUIGLINE 2272
	EndIf
QUIGLINE 2273
	
QUIGLINE 2274
	for fc = 0 to 9
QUIGLINE 2275
	u16UserOnline(fc) = 0
QUIGLINE 2276
	next
QUIGLINE 2277
	iUserOnlineTotal = 0
QUIGLINE 2278
	
QUIGLINE 2279
	Lock.Off
QUIGLINE 2280
EndF
QUIGLINE 2281

QUIGLINE 2282
Function F131_3:void()
QUIGLINE 2283
	
QUIGLINE 2284
	//	------ F131,3 Read online status all users
QUIGLINE 2285
	
QUIGLINE 2286
	
QUIGLINE 2287
	
QUIGLINE 2288
	Lock.On
QUIGLINE 2289
	
QUIGLINE 2290
	IO.Out ioA_1,0
QUIGLINE 2291
	IO.Out ioA_2,3
QUIGLINE 2292
	IO.Out ioA_1,131
QUIGLINE 2293
	
QUIGLINE 2294
	If ArmResponse =2 Then
QUIGLINE 2295
		//nop
QUIGLINE 2296
	EndIf
QUIGLINE 2297
	
QUIGLINE 2298
	iUserOnlineTotal = 0
QUIGLINE 2299
	
QUIGLINE 2300
	for fx = 0 to 20
QUIGLINE 2301
	fy =(IO.In(ioA_2) *256) + IO.In(ioA_2)
QUIGLINE 2302
	if (fy > 0) then
QUIGLINE 2303
	u16UserOnline(iUserOnlineTotal) = fy
QUIGLINE 2304
	iUserOnlineTotal = iUserOnlineTotal + 1
QUIGLINE 2305
	endif
QUIGLINE 2306
	next
QUIGLINE 2307
	
QUIGLINE 2308
	sDb = "F131_3 users online:"  + str(iUserOnlineTotal):sysDebug
QUIGLINE 2309
	
QUIGLINE 2310
	Lock.Off
QUIGLINE 2311
	
QUIGLINE 2312
EndF
QUIGLINE 2313

QUIGLINE 2314
Function F131_7:Void()
QUIGLINE 2315
	
QUIGLINE 2316
	//	' new21 Get user info
QUIGLINE 2317
	//	'  #3003,Hans,NL,CPC,
QUIGLINE 2318
	
QUIGLINE 2319
	
QUIGLINE 2320
	sDb = "131_7 in "+str(u16in1):sysDebug
QUIGLINE 2321
	
QUIGLINE 2322
	Lock.On
QUIGLINE 2323
	IO.Out ioA_1,0
QUIGLINE 2324
	IO.Out ioA_2,7
QUIGLINE 2325
	IO.Out ioA_2,(u16in1 / 256)
QUIGLINE 2326
	IO.Out ioA_2,(u16in1 And 255)
QUIGLINE 2327
	IO.Out ioA_1,131
QUIGLINE 2328
	
QUIGLINE 2329
	If ArmResponse =2 Then
QUIGLINE 2330
		//nop
QUIGLINE 2331
	EndIf
QUIGLINE 2332
	
QUIGLINE 2333
	fsw = 0
QUIGLINE 2334
	fx = 1
QUIGLINE 2335
	
QUIGLINE 2336
	sOut1 = "" 	//.. 3000
QUIGLINE 2337
	sOut2 = ""	//.. Hans
QUIGLINE 2338
	sOut3 = ""	//.. NL
QUIGLINE 2339
	sOut4 = ""	//.. CPC
QUIGLINE 2340
	
QUIGLINE 2341
	For fn = 1 To 50
QUIGLINE 2342
		fc =IO.In(ioA_2)
QUIGLINE 2343
		
QUIGLINE 2344
		If fc = 0 Then
QUIGLINE 2345
			fsw = 1
QUIGLINE 2346
		EndIf
QUIGLINE 2347
		
QUIGLINE 2348
		If  fc =35 Then
QUIGLINE 2349
			fx  = 1
QUIGLINE 2350
		EndIf
QUIGLINE 2351
		
QUIGLINE 2352
		If (fc = 35) Or (fc = 44) Then
QUIGLINE 2353
			fx = fx + 1
QUIGLINE 2354
		Else
QUIGLINE 2355
			If fsw = 0 Then
QUIGLINE 2356
				If (fc <> 32) And  (fc <> 9) Then
QUIGLINE 2357
					If fx = 2 Then
QUIGLINE 2358
						sOut1 = sOut1 + Chr(fc)
QUIGLINE 2359
					EndIf
QUIGLINE 2360
					If fx =3 Then
QUIGLINE 2361
						sOut2 = sOut2 + Chr(fc)
QUIGLINE 2362
					EndIf
QUIGLINE 2363
					If fx =4 Then
QUIGLINE 2364
						sOut3 = sOut3 + Chr(fc)			// NL
QUIGLINE 2365
					EndIf
QUIGLINE 2366
					If fx = 5 Then
QUIGLINE 2367
						sOut4 = sOut4 + Chr(fc)
QUIGLINE 2368
					EndIf
QUIGLINE 2369
				EndIf
QUIGLINE 2370
			EndIf
QUIGLINE 2371
		EndIf
QUIGLINE 2372
	Next
QUIGLINE 2373
	
QUIGLINE 2374
	
QUIGLINE 2375
	
QUIGLINE 2376
	Lock.Off
QUIGLINE 2377
EndF
QUIGLINE 2378

QUIGLINE 2379

QUIGLINE 2380

QUIGLINE 2381
Function F131_8:void()
QUIGLINE 2382
	
QUIGLINE 2383
	//	------ 8 get userId and password
QUIGLINE 2384
	
QUIGLINE 2385
	Lock.On
QUIGLINE 2386
	IO.Out ioA_1,0
QUIGLINE 2387
	IO.Out ioA_2,8
QUIGLINE 2388
	IO.Out ioA_1,131
QUIGLINE 2389
	
QUIGLINE 2390
	If ArmResponse =2 Then
QUIGLINE 2391
		//nop
QUIGLINE 2392
	EndIf
QUIGLINE 2393
	
QUIGLINE 2394
	u16MyUserID = (IO.In(ioA_2) *256) + IO.In(ioA_2)
QUIGLINE 2395
	
QUIGLINE 2396
	sUserPass = ""
QUIGLINE 2397
	fc = 1
QUIGLINE 2398
	While (fc  > 0)
QUIGLINE 2399
		fc=  IO.In(ioA_2)
QUIGLINE 2400
		If  fc > 0 Then
QUIGLINE 2401
			sUserPass= sUserPass + Chr(fc)
QUIGLINE 2402
		EndIf
QUIGLINE 2403
	Wend
QUIGLINE 2404
	
QUIGLINE 2405
	Lock.Off
QUIGLINE 2406
EndF
QUIGLINE 2407

QUIGLINE 2408
Function F131_10:void()
QUIGLINE 2409
	
QUIGLINE 2410
	; ------ Voip call userID
QUIGLINE 2411
	
QUIGLINE 2412
	Lock.On
QUIGLINE 2413
	IO.Out ioA_1,0
QUIGLINE 2414
	IO.Out ioA_2,10
QUIGLINE 2415
	IO.Out ioA_2,(u16in1 / 256)
QUIGLINE 2416
	IO.Out ioA_2,(u16in1 And 255)
QUIGLINE 2417
	IO.Out ioA_1,131
QUIGLINE 2418
	
QUIGLINE 2419
	If ArmResponse =2 Then
QUIGLINE 2420
		//nop
QUIGLINE 2421
	EndIf
QUIGLINE 2422
	
QUIGLINE 2423
	Lock.Off
QUIGLINE 2424
EndF
QUIGLINE 2425

QUIGLINE 2426
Function F131_11:void()
QUIGLINE 2427
	
QUIGLINE 2428
	; ------ Voip call accept
QUIGLINE 2429
	
QUIGLINE 2430
	Lock.On
QUIGLINE 2431
	IO.Out ioA_1,0
QUIGLINE 2432
	IO.Out ioA_2,11
QUIGLINE 2433
	IO.Out ioA_1,131
QUIGLINE 2434
	
QUIGLINE 2435
	If ArmResponse =2 Then
QUIGLINE 2436
		//nop
QUIGLINE 2437
	EndIf
QUIGLINE 2438
	
QUIGLINE 2439
	Lock.Off
QUIGLINE 2440
EndF
QUIGLINE 2441

QUIGLINE 2442
Function F131_12:void()
QUIGLINE 2443
	
QUIGLINE 2444
	; ------ Voip Break call
QUIGLINE 2445
	
QUIGLINE 2446
	Lock.On
QUIGLINE 2447
	IO.Out ioA_1,0
QUIGLINE 2448
	IO.Out ioA_2,12
QUIGLINE 2449
	IO.Out ioA_1,131
QUIGLINE 2450
	
QUIGLINE 2451
	If ArmResponse =2 Then
QUIGLINE 2452
		//nop
QUIGLINE 2453
	EndIf
QUIGLINE 2454
	
QUIGLINE 2455
	Lock.Off
QUIGLINE 2456
EndF
QUIGLINE 2457

QUIGLINE 2458

QUIGLINE 2459
Function F131_32:void()
QUIGLINE 2460
	
QUIGLINE 2461
	; ------ Set your appname
QUIGLINE 2462
	
QUIGLINE 2463
	Lock.On
QUIGLINE 2464
	IO.Out ioA_1,0
QUIGLINE 2465
	IO.Out ioA_2,32
QUIGLINE 2466
	
QUIGLINE 2467
	l = Len(sIn1)
QUIGLINE 2468
	For t = 1 To l
QUIGLINE 2469
		c = Asc(Mid(sIn1,t,1))
QUIGLINE 2470
		IO.Out ioA_2,c
QUIGLINE 2471
	Next
QUIGLINE 2472
	IO.Out ioA_2,0
QUIGLINE 2473
	
QUIGLINE 2474
	IO.Out ioA_1,131
QUIGLINE 2475
	
QUIGLINE 2476
	If ArmResponse =2 Then
QUIGLINE 2477
		//nop
QUIGLINE 2478
	EndIf
QUIGLINE 2479
	
QUIGLINE 2480
	Lock.Off
QUIGLINE 2481
EndF
QUIGLINE 2482

QUIGLINE 2483
Function F131_33:void()
QUIGLINE 2484
	
QUIGLINE 2485
	; ------ Send query appname
QUIGLINE 2486
	
QUIGLINE 2487
	Lock.On
QUIGLINE 2488
	IO.Out ioA_1,0
QUIGLINE 2489
	IO.Out ioA_2,33
QUIGLINE 2490
	
QUIGLINE 2491
	c =  (u16in1 / 256)
QUIGLINE 2492
	IO.Out ioA_2,c
QUIGLINE 2493
	c =  (u16in1 and 255)
QUIGLINE 2494
	IO.Out ioA_2,c
QUIGLINE 2495
	
QUIGLINE 2496
	IO.Out ioA_1,131
QUIGLINE 2497
	
QUIGLINE 2498
	If ArmResponse =2 Then
QUIGLINE 2499
		//nop
QUIGLINE 2500
	EndIf
QUIGLINE 2501
	
QUIGLINE 2502
	Lock.Off
QUIGLINE 2503
EndF
QUIGLINE 2504

QUIGLINE 2505
Function F131_34:void()
QUIGLINE 2506
	
QUIGLINE 2507
	; ------  Read other user app
QUIGLINE 2508
	
QUIGLINE 2509
	IO.Out ioA_1,0
QUIGLINE 2510
	IO.Out ioA_2,34
QUIGLINE 2511
	IO.Out ioA_1,131
QUIGLINE 2512
	
QUIGLINE 2513
	If ArmResponse =2 Then
QUIGLINE 2514
		//nop
QUIGLINE 2515
	EndIf
QUIGLINE 2516
	
QUIGLINE 2517
	fx = 1
QUIGLINE 2518
	sOut1 = ""
QUIGLINE 2519
	while((fx > 0) and (len(sOut1) < 14))
QUIGLINE 2520
	fx = IO.In(ioA_2)
QUIGLINE 2521
	if fx > 30 then
QUIGLINE 2522
	sOut1 = sOut1 + chr(fx)
QUIGLINE 2523
	endif
QUIGLINE 2524
	wend
QUIGLINE 2525
	Endf
QUIGLINE 2526
	
QUIGLINE 2527
	
QUIGLINE 2528
	Function	F245_0:Void()
QUIGLINE 2529
	
QUIGLINE 2530
	; ------  Read content of  the RC buffer
QUIGLINE 2531
	
QUIGLINE 2532
	Lock.On
QUIGLINE 2533
	
QUIGLINE 2534
	IO.Out ioA_1,0
QUIGLINE 2535
	IO.Out ioA_2,0
QUIGLINE 2536
	IO.Out ioA_1,245
QUIGLINE 2537
	
QUIGLINE 2538
	If ArmResponse =2 Then
QUIGLINE 2539
		//nop
QUIGLINE 2540
	EndIf
QUIGLINE 2541
	
QUIGLINE 2542
	iRcContent   = IO.In(ioA_2)
QUIGLINE 2543
	
QUIGLINE 2544
	Lock.Off
QUIGLINE 2545
	
QUIGLINE 2546
EndF
QUIGLINE 2547

QUIGLINE 2548
Function F245_1:Void()
QUIGLINE 2549
	//RC read	buffer
QUIGLINE 2550
	
QUIGLINE 2551
	Lock.On
QUIGLINE 2552
	
QUIGLINE 2553
	IO.Out ioA_1,0
QUIGLINE 2554
	IO.Out ioA_2,1
QUIGLINE 2555
	IO.Out ioA_1,245
QUIGLINE 2556
	
QUIGLINE 2557
	If ArmResponse =2 Then
QUIGLINE 2558
		//nop
QUIGLINE 2559
	EndIf
QUIGLINE 2560
	
QUIGLINE 2561
	sRcCode = ""
QUIGLINE 2562
	
QUIGLINE 2563
	sText = Hex(IO.In(ioA_2)	)
QUIGLINE 2564
	sRcCode = sRcCode + Mid(sText,3,2)
QUIGLINE 2565
	
QUIGLINE 2566
	sText = Hex(IO.In(ioA_2)	)
QUIGLINE 2567
	sRcCode = sRcCode + Mid(sText,3,2)
QUIGLINE 2568
	
QUIGLINE 2569
	sText = Hex(IO.In(ioA_2)	)
QUIGLINE 2570
	sRcCode = sRcCode + Mid(sText,3,2)
QUIGLINE 2571
	
QUIGLINE 2572
	sText = Hex(IO.In(ioA_2)	)
QUIGLINE 2573
	sRcCode = sRcCode + Mid(sText,3,2)
QUIGLINE 2574
	
QUIGLINE 2575
	Lock.Off
QUIGLINE 2576
EndF
QUIGLINE 2577

QUIGLINE 2578

QUIGLINE 2579

QUIGLINE 2580

QUIGLINE 2581

QUIGLINE 2582
;-------------------------------------------------------------------------------------------------
QUIGLINE 2583
; === SEONE
QUIGLINE 2584

QUIGLINE 2585
Function ATCmd:Void()
QUIGLINE 2586
	
QUIGLINE 2587
	sDb = sAtCmd:sysDebug
QUIGLINE 2588
	
QUIGLINE 2589
	l = Len(sAtCmd)
QUIGLINE 2590
	
QUIGLINE 2591
	For t = 1 to l
QUIGLINE 2592
		c = Asc(Mid(sAtCmd,t,1))
QUIGLINE 2593
		if (c <> 32) then
QUIGLINE 2594
		IO.Out #FF20,c
QUIGLINE 2595
		endif
QUIGLINE 2596
	Next
QUIGLINE 2597
	IO.Out  #FF20,13
QUIGLINE 2598
	
QUIGLINE 2599
	AtResponsStr
QUIGLINE 2600
EndF
QUIGLINE 2601

QUIGLINE 2602
Function AtResponsStr:Void()
QUIGLINE 2603
	//.. OK    AT+SEMODE=FM
QUIGLINE 2604
	
QUIGLINE 2605
	sAtResp = ""
QUIGLINE 2606
	sAtData = ""
QUIGLINE 2607
	
QUIGLINE 2608
	x = 0
QUIGLINE 2609
	y = 0	// switch '='
QUIGLINE 2610
	a = 0
QUIGLINE 2611
	iTimeOut = 0
QUIGLINE 2612
	
QUIGLINE 2613
	while( a = 0)
QUIGLINE 2614
	
QUIGLINE 2615
	c = IO.In(#FF20)
QUIGLINE 2616
	
QUIGLINE 2617
	if ((c > 31) and (x < 50)) then
QUIGLINE 2618
	sAtResp = sAtResp  + chr(c)
QUIGLINE 2619
	
QUIGLINE 2620
	if (y=1) then
QUIGLINE 2621
	sAtData = sAtData  + chr(c)
QUIGLINE 2622
	endif
QUIGLINE 2623
	
QUIGLINE 2624
	if (c = 61) then
QUIGLINE 2625
	y=1
QUIGLINE 2626
	endif
QUIGLINE 2627
	
QUIGLINE 2628
	
QUIGLINE 2629
	x = x + 1
QUIGLINE 2630
	endif
QUIGLINE 2631
	
QUIGLINE 2632
	if ((c = 13) or (c = 10)  ) then
QUIGLINE 2633
	a = 1
QUIGLINE 2634
	endif
QUIGLINE 2635
	
QUIGLINE 2636
	if (x > 50) then
QUIGLINE 2637
	a = 1
QUIGLINE 2638
	endif
QUIGLINE 2639
	
QUIGLINE 2640
	if (iTimeOut > 10000) then
QUIGLINE 2641
	a = 1
QUIGLINE 2642
	endif
QUIGLINE 2643
	
QUIGLINE 2644
	iTimeOut = iTimeOut + 1
QUIGLINE 2645
	wend
QUIGLINE 2646
	
QUIGLINE 2647
	sDb = "AT resp:" + sAtResp:sysDebug
QUIGLINE 2648
	
QUIGLINE 2649
EndF
QUIGLINE 2650

