; Quigs 1.01 Application for Symbos
; Name: Dot Box
; Coder:TMTLOGIC
; Date / Version: v2

;----------------------------------------------------------------------------------------------------------

// === var IO R/Sf3 ===

Var ioA_0:int
Var ioA_1:int
Var ioA_2:int
Var ioA_3:int
Var ioA_4:int
Var ioA_5:int
Var ioA_6:int
Var ioA_7:int
Var ioA_8:int
Var ioA_9:int
Var ioA_A:int
Var ioA_B:int
Var ioA_C:int
Var ioA_D:int
Var ioA_E:int
Var ioA_F:int

Var resp				:Int =0					// response value of the SF3



//------------------------------------------------------------------------------------------------------------
// === Defines ===


Var defNetStatusBitTx:byte		= 128	//=1 Tx Buffer is full
Var defNetStatusBitRx:byte		= 64	//=1 Data to read

Var defNetStatusBitError:byte	= 32	//=0 then no Errors 
Var defNetStatusBitVoip:byte	= 16	//'=0 then voip not active 
Var defNetStatusBitUser:byte	=  8	//'=0 then no user changes online/offline 
Var defNetStatusBitShMem:byte	=  4	//'=0 then no memory share changes 
Var defNetStatusBitMsg:byte		=  2	//'=0 then no new messages 
Var defNetStatusBitSys:byte		=  1	//'=0 then no system response data

Var defTileEmpty:int = 0
Var defTileHori:int  = 1
Var defTileVert:int  = 2
Var defTileBox:int   = 3
Var defTileDot:int   = 4

var defVoipIdle:int				=0		// rust
var defVoipOutgoingCall:int		=1		// je hoort dat het overgaat
var defVoipOtherBusy:int		=2		// je hoort dat de lijn bezet is
var defVoipOtherOffline:int		=3		// je hoort dat de persoon waarmee je wil bellen niet online is
var defVoipIncommingCall:int	=4		// iemand beld je dus de ringtone moet overgaan
var defVoipActiveCall:int		=5		// Bellen actief ,Mic is running

//------------------------------------------------------------------------------------------------------------
// === var system ===

Var strHardware:string = "NONE" 			// RSF3/SF3
Var strCPU:string		 					// EP CPC MSX
Var strFirmware:String = "20250121"			// ARM Firmware  needed
Var sText:String

Var iStpStartup:Int=0

Var intDelay:Int=2
Var intDelayCt:Int=0

Var sDb:String
var dbStp:int
var iDbL:int
var iDbT:int
var iDbC:int

var iAppExit:int=0

var iTimeOut:int = 0

var fc:int
var fn:int
var fx:int
var fy:int
var fsw:int

Var u8In1:Int
Var u8In2:Int

Var u8Out1:Int
Var u8Out2:Int
Var u8Out3:Int
Var u8Out4:Int
Var u8Out5:Int

Var u16In1:Int

Var u16Out1:Int
Var u16Out2:Int
Var u16Out3:Int
Var u16Out4:Int
Var u16Out5:Int
Var u16Out6:Int
Var u16Out7:Int
Var u16Out8:Int

Var strIn1:String

Var strOut1:String
Var strOut2:String
Var strOut3:String
Var strOut4:String
//------------------------------------------------------------------------------------------------------------
//	=== var Diverse ===

Var a:int
Var	t       :int
Var c		:Int
Var y		:Int = 0
Var x		:Int = 0
Var l		:int
var v:int
Var lt :int
Var lv :int
Var u16Ur:int
Var lc:int
Var li:Int

Var bSw:Int




;------------------------------------------------------------------------------------------------------------
;	=== Chat ===

Var strChatText(4):String	// 'row 1-4 text	histort old..
Var strChatInp:String		// 'input field

Var u8FifoIn:Int
Var u8FifoOut:Int
Var u8FifoContent:Byte
Var u16Fd(13):Int			//destination ID
Var strFm(13):String		//string Message 
Var strTm:String
Var strMs:String

Var u16Du:Int
Var u8Key:Int

;-------------------------------------------------------------------------------------------------
//	=== Sheets ===

Var shDD_dot:Sheet
Var shDD_hori:Sheet
Var shDD_vert:Sheet
Var shDD_fill:Sheet
Var shDD_start:Sheet
Var shDD_digi:Sheet
Var shDD_voip:Sheet

Var ImgIds(123):Int
Var ImgTile(132):Int
Var ImgTileCom(150):Int


//------------------------------------------------------------------------------------------------------------
//	=== GAME var ===



var iButChoise:int
var iSelImg:int

Var iGameMode:int = 0
var iWinner:int
var iPlayer:int	
var iPlayerActive:int
var bRestart:int = 0
var bExit:int = 0
Var iRecPointer:int=0

Var	u16PlayerList(3):int

Var u16OtherID:int

var iScore(3):int

var bNew_field:int=0
var bAgain:int = 0
var bReSend:int = 0
var iFlash:int
var iFlashCt:int=0

//------------------------------------------------------------------------------------------------------------
// === TMT-NET21 ===

Var strAppname		:String
Var u16MyUserID		:Int = 0
Var strUserPass		:String
Var strPlayerName(3):string

Var u16UserOnline(20)	:int
Var	iUserOnlineTotal	:int

Var	u8NetStatus:int

Var u8h:int
Var u8l:int
Var u8d:int

Var w:int

var iUserOnlineTimer :int = 0

;-------------------------------------------------------------------------------------------------
; === var SEONE

var sAtCmd:string
var sAtResp:string
var sAtData:string

;-------------------------------------------------------------------------------------------------
; === var VOIP

var iVoipChgCt:int
var iVoipStatus:int
var iVoipStatusOld:int
var u16OtherUserId:int
var iVoipSoundSelect:int=0
var iVoipSoundCt:int
var iVoipSoundSeq:int
var iUserOnlinePointer:int
var iDelayVoipCt:int
;------------------------------------------------------------------------------------------------------------


;---	FORM 1 field play field

Function Form1.Open.Event:Void()
EndF

Function Form1.Close.Event:Void()
	iAppExit = 1
EndF

;---	FORM 1 buttons

;--- 	FORM1 Events

Function Label14.Event:Void()
	bRestart = 1
Endf

Function Label15.Event:Void()
	iFlash = #23
endf

Function Image.Event:Void()
	if (iPlayer = iPlayerActive) then 
		CrtlEventToImg
	endif
Endf

Function ImageVoipRed.Event:Void()
	VoipRedButton
endf

Function ImageVoipGreen.Event:Void()
	VoipGreenButton
endf

;---	FORM 2 field  Choice user

Function Form2.Open.Event:Void()
endf

Function Form2.Close.Event:Void()
	iAppExit = 1
EndF

;---	FORM 2 buttons
;---	FORM 2 Events 

Function label21.Event:Void()
	iButChoise = 1
	if (iStpStartup = 120) and (iUserOnlineTotal > 0) then 
		Label21.Colour.Set Colour.Black,colour.Yellow,1
		Label21.refresh
		intDelay = 20
		intDelayCt = 0
	endif
	
endf

Function label22.Event:Void()
	iButChoise = 2
	if (iStpStartup = 120) and (iUserOnlineTotal > 1) then 
		Label22.Colour.Set Colour.Black,colour.Yellow,1
		Label22.refresh
		intDelay = 20
		intDelayCt = 0
	endif
endf

Function label23.Event:Void()
	iButChoise = 3

	if (iStpStartup = 120) and (iUserOnlineTotal > 2) then 
		Label23.Colour.Set Colour.Black,colour.Yellow,1
		Label23.refresh
		intDelay = 20
		intDelayCt = 0
	endif

endf

Function label24.Event:Void()
	iButChoise = 4
	if (iStpStartup = 120) and (iUserOnlineTotal > 3) then 
		Label24.Colour.Set Colour.Black,colour.Yellow,1
		Label24.refresh
		intDelay = 20
		intDelayCt = 0
	endif

endf

Function label25.Event:Void()
	iButChoise = 5
	if (iStpStartup = 120) and (iUserOnlineTotal > 4) then 
		Label25.Colour.Set Colour.Black,colour.Yellow,1
		Label25.refresh
		intDelay = 20
		intDelayCt = 0
	endif

endf


;---	FORM 3 Not used

;---	FORM 4 field Start ---

Function Form4.Open.Event:Void()
		Initialize
endf

Function Form4.Close.Event:Void()
	iAppExit = 1
EndF

;---	FORM 4 buttons

Function Button41.Event:Void()
	iStpStartup = 10
endf




Function Initialize:Void()

	sys_IO_init
	
	u8In1 = 0
	F72_26
	strHardware = strOut1
	
	//if (strHardware = "RSF3")  then 
		
	sAtCmd = "AT+SEMODE=VOICE":ATCmd
	//endif
	
	F131_39
	
	strAppname = "DOTBOX"
	
	shDD_start.Load(App.Path+"dd_start.qs1")
	Image410.Tile.Set shDD_start,0
	Image410.Refresh

	Button41.text.set "Loading..0%"
	Button41.refresh


	sText = " " + strCPU + " " + strHardware + " [" + App.Date + "]"
	Form4.status.text.set sText
	Form4.status.refresh


	shDD_dot.Load(App.Path+"dd_dot.qs2")
	Button41.text.set "Loading..10%" :Button41.refresh

	shDD_hori.Load(App.Path+"dd_hori.qs2")
	Button41.text.set "Loading..30%" :Button41.refresh

	shDD_vert.Load(App.Path+"dd_vert.qs2")
	Button41.text.set "Loading..50%" :Button41.refresh

	shDD_fill.Load(App.Path+"dd_fill.qs2")
	Button41.text.set "Loading..60%" :Button41.refresh

	shDD_digi.Load(App.Path+"dd_digi.qs2")
	Button41.text.set "Loading..80%" :Button41.refresh

	shDD_voip.Load(App.Path+"dd_voip.qs2")
	Button41.text.set "Loading..100%" :Button41.refresh

	Button41.text.set "START" :Button41.refresh
	
	Randomize ((Time.Hour.Get * 360) + (Time.Minute.Get * 60) + (Time.Second.Get))
	
	iGameMode = 0
	
		If Sound.Init = 0 Then
			sText = left(App.Path,1) + ":\soundd.exe"
			a = Execute(sText)			// Start netd local if not open
			a = Sound.Init
		
			sDb="Sound.Init" :sysDebug
	EndIf
EndF



;------------------------------------------------------------------------------------------------------------
;	=== Main

Function Main:Void()
	
	intDelayCt = intDelayCt + 1
	If intDelayCt < intDelay Then
		Return
	EndIf
	intDelayCt = 0
	
	if iAppExit > 0 then 
		symAppExit
	endif
	
	If  iGameMode = 1 Then
		
		chat_handler
		
		net21_rec_loop
	
		if (iSelImg > 0) and (iPlayer = iPlayerActive)  then 
			game_press_select
		endif
		
		if (bNew_field = 1) then 
			game_new_field
		endif

		if (bRestart = 1) then 
			game_replay
		endif
		
		if (iWinner > 0 ) then 
			iFlash = shl4(iWinner) or  3
			
			if (iWinner = iPlayer) then 
				label6.text.set "--- You are Winner !!!! ---"
				label6.refresh
			else
				label6.text.set "--- You lost !!!! ---"
				label6.refresh
			endif
			iWinner = 0
		endif
		
		if (iFlash > 0 ) then 
			iFlashCt = iFlashCt + 1
			if (iFlashCt = 21) then 
				iFlashCt = 1
			endif
			
			if (iFlashCt = 10) or (iFlashCt = 20)then 
				flashing
			endif
		endif
		
		VoipHandler
		VoipSoundHandler
		
		return
	endif
	
	stpStartup
EndF


Function symAppExit:void()

		sDb = "App exit":sysDebug 
		
		if iAppExit = 1 then 
			Form1.open
			F131_39
			iAppExit = 2
		endif	

		if iAppExit = 2 then 
			shDD_dot.free
			shDD_hori.free
			shDD_vert.free
			shDD_start.free
			shDD_digi.free
			shDD_voip.free
			App.exit
			iAppExit = 3
		endif	
endf

//*****************************************************************************************
							
Function chat_init:void()
endf

Function chat_handler:void()
	
	u8NetStatus = IO.In(ioA_A)
		if ((u8NetStatus and defNetStatusBitMsg) > 0)	then 
		chat_recvTxt
	endif
	
	If Event.Type = 16 Then
		u8Key = Event.KeyPressed

		if (u8Key = 8) then 						//BS
			se1_PlayTick
			chat_del
		Endif

		if (u8Key = 13) then 						//Enter  
			se1_PlayTick
			chat_send
		Endif

		if ((u8Key > 31) and (u8Key < 126)) then 	//AscII 
			se1_PlayTick
			chat_printChar
			
		Endif
	Endif
	
	chat_sendMsg
endf


Function chat_scroll:void()
	
	//	'scroll without input field
	
	strChatText(5) = strChatText(4)
	strChatText(4) = strChatText(3)
	strChatText(3) = strChatText(2)
	
	Label5.Text.Set	strChatText(5)
	Label5.Refresh	
	
	Label4.Text.Set	strChatText(4)
	Label4.Refresh	
	
	Label3.Text.Set	strChatText(3)
	Label3.Refresh	

EndF
	

Function chat_recvTxt:void()

//	'------ Print recv text message 

	chat_scroll
	
	F131_22
				
	strChatText(2) = strTm
	Label2.Text.Set	strChatText(2)
	Label2.Refresh
	
	se1_PlayBell
EndF

Function chat_del:void()
	
//	'DEL  key

	
	if len (strMs) = 0 then 
		sDb = "Input string empty"
		sysDebug
		return
	Endif
	

	l = Len(strMs) - 1
	strMs = Left(strMs,l)
	
	strChatInp =  strMs
	Label1.Text.Set  strChatInp
	Label1.Refresh
EndF


Function chat_printChar:void()

	if len(strMs) > 50 then 
		sDb = "Input string too  long > 50"
		sysDebug
		return
	EndIf

	strMs = strMs + Chr(u8Key)
	
	strChatInp =  strMs
	Label1.Text.Set  strChatInp
	Label1.Refresh

	//Label4.Text.Set  str(u8Key)
	//Label4.Refresh
	
EndF

Function chat_ClearInput:void()

//	'Clear input string 
	
	strMs = ""
	strChatInp =  strMs
	Label1.Text.Set  strChatInp
	Label1.Refresh
EndF

Function chat_send:void()

	chat_scroll
							
	strChatText(2) = str(u16MyUserID) + " "+strMs
	Label2.Text.Set	strChatText(2)
	Label2.Refresh
		
	strMs = strMs + Chr(13)
	
	u16Du = u16OtherID
	chat_fifo_in
	
	chat_ClearInput
EndF
							

Function chat_sendMsg:void()
	
	F131_21
	
	//	'if (r = 0) and (fc > 0 ) then gosub chat_sendMsg
	
	if (u8Out1 > 0) or (u8FifoContent = 0 ) then 
		return
	EndIf
	
	chat_fifo_out
	
	If u16Du = u16MyUserID then
		return
	EndIf
	
	F131_20
	
EndF

							
Function chat_fifo_in:void()

	if u8FifoContent = 12  then 
		sDb = "Fifo Full":sysDebug
		return 
	EndIf
		
	u16Fd(u8FifoIn) = u16Du
	
	strFm(u8FifoIn) = strMs
	
	u8FifoIn = u8FifoIn + 1
	
	//sDb = "fifo in: "+strFm(u8FifoIn)+" pos: "+str(u8FifoIn):sysDebug
	
	
	if u8FifoIn = 13 then 
		u8FifoIn = 0
	Endif
		
	u8FifoContent = u8FifoContent + 1
EndF

Function chat_fifo_out:void()

	if u8FifoContent = 0  then 
		//sDb = "fifo out , Fifo is empty":sysDebug
	endif	
	
	strIn1 = strFm(u8FifoOut)
	
	u16Du = u16Fd(u8FifoOut)
	
	u8FifoOut = u8FifoOut + 1
	
	if u8FifoOut = 13 then 
		u8FifoOut = 0
	endif
	
	u8FifoContent = u8FifoContent - 1
	
EndF

Function game_begin:void()
	
	intDelay = 2
	
	imageVoipGreen.tile.set shDD_voip,0 :imageVoipGreen.refresh
	imageVoipRed.tile.set shDD_voip,1 	:imageVoipRed.Refresh
	labelVoip.text.set "" :labelVoip.refresh
	
	sText ="Version: "+app.date
	Label5.Text.Set	sText
	Label5.Refresh	
	
	if (u16MyUserID < u16OtherID) then
		iPlayer = 1
		u16PlayerList(1) = u16MyUserID
		u16PlayerList(2) = u16OtherID
		
	else	
		iPlayer = 2 
		u16PlayerList(1) = u16OtherID
		u16PlayerList(2) = u16MyUserID
	endif

	
	
	Label7.Text.Set	Str(u16PlayerList(1))
	Label7.Refresh	
	Label8.Text.Set	Str(u16PlayerList(2))
	Label8.Refresh	
	
	u16in1 = u16PlayerList(1)
	F131_7
	label10.text.set strOut2
	label10.refresh
	label12.text.set strOut2
	label12.refresh
	
	
	u16in1 = u16PlayerList(2)
	F131_7
	label11.text.set strOut2
	label11.refresh
	label13.text.set strOut2
	label13.refresh
		
	iFlash = 0
	iWinner =0
	bAgain = 0
	iPlayerActive = 0
	iScore(1) = 0
	iScore(2) = 0
	
	
	game_resetField
	game_score_refresh
	
	if (iPlayer = 2) then 
		iGameMode = 1
		return
	endif
	
	
	iPlayerActive = 2
	net21_send
	
	game_showTurn
	
	iGameMode = 1
EndF

Function game_replay:void()
	bRestart = 0

	iFlash = 0
	iWinner =0
	bAgain = 0
	iScore(1) = 0
	iScore(2) = 0
	iPlayerActive = 2
	
	x = Rnd(2) 
	if (x = 0 ) then 
		x = 2
	EndIf

	iPlayerActive = x
	
	game_resetField
	game_score_refresh

	net21_send
	game_showTurn
	
	strMs = "RePlay game"
	chat_send
endf
						
Function game_showTurn:void()
	if (iPlayerActive = 0) then 
		sDb = "iPlayerActive = 0":sysDebug

		Label7.Colour.Set Colour.Black,colour.Orange,1 
		Label8.Colour.Set Colour.Black,colour.Orange,1 
		Label6.Text.Set	"Wait...."
		
		label6.refresh
		label7.refresh
		label8.refresh
		return
	endif
	
	if (iPlayerActive = 1) then 
		Label7.Colour.Set Colour.Black,colour.Orange,1 
		Label8.Colour.Set colour.Orange,Colour.Black,1 
	else
		Label7.Colour.Set colour.Orange,Colour.Black,1 
		Label8.Colour.Set Colour.Black,colour.Orange,1 
	Endif
	
	if (iPlayer = iPlayerActive) then 
		Label6.Text.Set	"Your turn"
	else
		Label6.Text.Set	"Other player"
	Endif
	
	
	label6.refresh
	label7.refresh
	label8.refresh
EndF
	
Function game_press_select:void()
	sDb="iSelect :"+str(iSelImg):sysDebug

	if (ImgTile(iSelImg) < 10)then 

		sDb="ImgTile(iSelImg)= " +str(ImgTile(iSelImg))+ "  defTileHori= " +str(defTileHori):sysDebug
		
		
		if (ImgTile(iSelImg)  = defTileHori) then 
			
			//sDb="hori ":sysDebug
			
			Ctrl.Image.Tile.Set ImgIds(iSelImg),shDD_hori,iPlayer
			ctrl.Refresh ImgIds(iSelImg)
			ImgTile(iSelImg) = ImgTile(iSelImg)  or (shl4(iPlayer))
			
		endif
		
		if (ImgTile(iSelImg)  = defTileVert) then 
			Ctrl.Image.Tile.Set ImgIds(iSelImg),shDD_vert,iPlayer
			ctrl.Refresh ImgIds(iSelImg)
			ImgTile(iSelImg) = ImgTile(iSelImg)  or (shl4(iPlayer))
		endif
		
		game_check_box
		game_check_score
		game_score_refresh
		game_next_player
		
	endif
	iSelImg = 0

endf

Function game_next_player:void()
	if (bAgain = 0) then
		iPlayerActive = 3 - iPlayer
	else
		iPlayerActive = iPlayer
	endif
	
	iSelImg = 0
	net21_send
	game_showTurn
	
endf


Function game_check_box:void()

; fill box when round is complete

	Data.Set BoxData
	for t = 1 to 25
		a = Data.Byte
		if (ImgTile(a) < 10) then 
			if (ImgTile(a - 11) > 10) and (ImgTile(a + 1) > 10) and (ImgTile(a + 11) > 10) and (ImgTile(a - 1) > 10) then 
				
				Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,iPlayer
				Ctrl.Refresh ImgIds(a)
				ImgTile(a) = ImgTile(a) or shl4(iPlayer)
			endif
		endif
	next
endf

Function game_check_score:void()
; calculate score boxes

	x = 0
	y = 0
	
	Data.Set BoxData 
	for t = 1 to 25
		a = Data.Byte

		if (Shr4(ImgTile(a)) = 1) then
			x = x + 1
		endif
		
		if (Shr4(ImgTile(a)) = 2) then
			y = y + 1
		endif
	next
	
	
	bAgain = 0
	if ((x+y) > (iScore(1) + iScore(2))) then 
		bAgain = 1
	endif
	
	iScore(1) = x
	iScore(2) = y
	

endf

Function game_score_refresh:void()
		
	;Player 1
	
	x = (iScore(1) / 10) and 15
	
	Image122.Tile.Set shDD_digi,(x+10)
	Image122.Refresh
	
	y = iScore(1) - (x*10)
	
	Image123.Tile.Set shDD_digi,(y+10)
	Image123.Refresh
	
	;Player 2

	x = (iScore(2) / 10) and 15
	
	Image126.Tile.Set shDD_digi,(x+0)
	Image126.Refresh
	
	y = iScore(2) - (x*10)
	
	Image127.Tile.Set shDD_digi,(y+0)
	Image127.Refresh
	
	iWinner = 0
	if ((iScore(1) + iScore(2))=25) then
		if (iScore(1) > iScore(2)) then 
			iWinner = 1
		else
			iWinner = 2
		endif
	endif
endf

Function game_new_field:void()
	// received field
	
	bNew_field = 0
	iSelImg = 0
	
	iPlayerActive = ImgTileCom(1)
	iScore(1) = ImgTileCom(2)
	iScore(2) = ImgTileCom(3)
	
	sDb ="Active player "+str(iPlayerActive):sysDebug
	
	For t=1 to 122
		if (ImgTileCom(t+4) <> ImgTile(t)) then 
			ImgTile(t) = ImgTileCom(t+4)
			
			sDb = "newField img"+str(t):sysDebug
			
			x = shr4(ImgTile(t))	//.. player color
			y = ImgTile(t) and 15	//.. tile type hor vert
			
			if (y = defTileHori) then 
				Ctrl.Image.Tile.Set ImgIds(t),shDD_hori,x
				Ctrl.Refresh ImgIds(t)
			endif

			if (y = defTileVert) then 
				Ctrl.Image.Tile.Set ImgIds(t),shDD_vert,x
				Ctrl.Refresh ImgIds(t)
			endif

			if (y = defTileBox) then 
				Ctrl.Image.Tile.Set ImgIds(t),shDD_fill,x
				Ctrl.Refresh ImgIds(t)
			endif
			
		endif
	next
	
	game_score_refresh
	game_showTurn
EndF

Function CrtlEventToImg:void()
	x = Ctrl.GetID(Form1,Event.Control)
	iSelImg = 0
	
	for t = 1 to 122
		y = ImgIds(t)
		if (x = y) then 
			iSelImg  = t
			t=123
		endif
	next
endf

Function game_resetField:void()	

	LoadImgCtrls
	
	for t =  1 to 121
		ImgTile(t) = 0
	next

	if (defTileEmpty <> 0) then 
		sDb="?? empty is niet nul !!!":sysDebug
	endif 
	
	Data.Set DotsData 
	for t = 1 to 36
		a = Data.Byte
		Ctrl.Image.Tile.Set ImgIds(a),shDD_dot,1
		Ctrl.Refresh ImgIds(a)
		ImgTile(a) = defTileDot
	next

	Data.Set HoriData 
	for t = 1 to 30
		a = Data.Byte
		Ctrl.Image.Tile.Set ImgIds(a),shDD_hori,0
		Ctrl.Refresh ImgIds(a)
		ImgTile(a) = defTileHori
	next

	Data.Set VeriData 
	for t = 1 to 30
		a = Data.Byte
		Ctrl.Image.Tile.Set ImgIds(a),shDD_vert,0
		Ctrl.Refresh ImgIds(a)
		ImgTile(a) = defTileVert
	next

	Data.Set BoxData 
	for t = 1 to 25
		a = Data.Byte
		Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,0
		Ctrl.Refresh ImgIds(a)
		ImgTile(a) = defTileBox
	next
EndF

Function flashing:void()
	
	Data.Set BoxData 
	for t = 1 to 25
		a = Data.Byte
		if (ImgTile(a) = iFlash) then 
			if (iFlashCt = 10) then	
				Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,0
				Ctrl.Refresh ImgIds(a)
			else
				Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,shr4(iFlash)
				Ctrl.Refresh ImgIds(a)
			endif
		endif
		next
endf



Function sysDebug:void()
//	'------ debug tool  send to FTDI port in sDb

	iDbL = Len(sDb)
	For iDbT = 1 To iDbL
	iDbC = Asc(Mid(sDb,iDbT,1))
		IO.Out ioA_0,iDbC
	Next
	IO.Out ioA_0,13
	IO.Out ioA_0,10
	
EndF

Function net21_rec_loop:void()
	
	u8NetStatus = IO.In(ioA_A)
	if ((u8NetStatus and DefNetStatusBitRx) = 0) then
		return
	endif
	
	for t = 1 to 500
		net21_rec
	next
endf

Function net21_rec:void()
	
	u8NetStatus = IO.In(ioA_A)
		if ((u8NetStatus and DefNetStatusBitRx) = 0) then 
		return 
	endif
	
	u16Ur = (IO.In(ioA_B) *256) + IO.In(ioA_C)
	u8d = IO.In(ioA_D)
	
	If u16Ur <> u16OtherID then
		sDb = "<> "+str(u16Ur):sysDebug
		return 
	endif
	
	if (u8d = 254) then	
		iRecPointer = 1
		return				//..start 
	endif
	
	if (u8d = 255) then  
		bNew_field = 1
		
		if ((iRecPointer-1) <> 125) then 
			bReSend = 1
			strMs = "!! Communication Error"	
			chat_send
		endif
		return				//..end
	endif
	
	if (iRecPointer > 0) and (iRecPointer < 135) then  
		ImgTileCom(iRecPointer) = u8d
		iRecPointer	= iRecPointer + 1
		return
	endif	
Endf




Function net21_send:void()
	
	//sDb="send start":sysDebug
	//x=1
	
	u8h = (u16OtherID / 256)
	u8l = (u16OtherID and 255)
	
	IO.Out ioA_B,u8h
	IO.Out ioA_C,u8L
	
	u8d = 254			:net21_sendTx 	//..start
	u8d = iPlayerActive	:net21_sendTx 	//..keer om
	u8d = iScore(1) 	:net21_sendTx 
	u8d = iScore(2) 	:net21_sendTx 
	u8d = 111  			:net21_sendTx 
	
	For t = 1 to 121 
		u8d = ImgTile(t) 
		net21_sendTx
	next 
	
	u8d = 255		:net21_sendTx 	//..end

EndF
						
	
Function net21_sendTx:void()
		
	for w = 1 to 1000
		u8NetStatus = IO.In(ioA_A)
		
		if (w > 800) then 	
			Label1.text.set "> 800"
			label1.refresh
			w = 1000
		endif
		
		if ((u8NetStatus and defNetStatusBitTx) = 0) then 
			w = 1000
		endif
	next
	
	IO.Out ioA_D,u8d
Endf

;-------------------------------------------------------------------------------------------------
; === VOIP Functions

Function VoipHandler:Void()
	
	If iDelayVoipCt < 10 Then
		iDelayVoipCt = iDelayVoipCt + 1
		Return
	EndIf
	iDelayVoipCt = 0
	
	
	if (iVoipChgCt < 20) then 
		iVoipChgCt = iVoipChgCt + 1
	endif
	if (iVoipChgCt  = 18) then 
		iVoipStatusOld = 255
		VoipSeStatus
	endif
	
	VoipSeStatus
	
	//VoipChkNewUsers
endf

Function VoipGreenButton:Void()

	sDb="green  button":sysDebug
	
	if (iVoipStatus = defVoipIdle) then 
		VoipCallUser
	endif

	if (iVoipStatus = defVoipIncommingCall) then 
		VoipCallAccept
	endif
	
endf

Function VoipRedButton:Void()
	sDb="red button" :sysDebug
	VoipCallBreak
endf

Function VoipCallUser:Void()
	u16in1 = u16OtherUserId
	F131_10
endf

Function VoipCallAccept:Void()
	F131_11
endf

Function VoipCallBreak:Void()
	F131_12
endf

Function VoipSeStatus:Void()
	iVoipStatus = IO.In(#FF21)
	
	if (iVoipStatus <> iVoipStatusOld) then	
		
		iVoipStatusOld = iVoipStatus
		
		sDb = "voip status:" + str(iVoipStatus):sysDebug
		sDb = "voip defVoipIdle" + str(defVoipIdle):sysDebug
		
		if (iVoipStatus = defVoipIdle) then 
			labelVoip.text.set "IDLE" :labelVoip.refresh
			iVoipSoundSelect = 0
		endif

		if (iVoipStatus = defVoipOutgoingCall) then 
			labelVoip.text.set "OUTGOING" :labelVoip.refresh
			iVoipSoundSelect = 1
		endif

		if (iVoipStatus = defVoipOtherBusy) then 
			labelVoip.text.set "IS BUSY" :labelVoip.refresh
			iVoipSoundSelect = 2
		endif
		
		if (iVoipStatus = defVoipOtherOffline) then 
			labelVoip.text.set "OFFLINE !" :labelVoip.refresh
			iVoipSoundSelect = 3
		endif
		
		if (iVoipStatus = defVoipIncommingCall) then 
			labelVoip.text.set "INCOMMING" :labelVoip.refresh
			iVoipSoundSelect = 4

		endif
		
		if (iVoipStatus = defVoipActiveCall) then 
			u16in1 = u16OtherUserId :F131_7
			labelVoip.text.set "CALLING..." :labelVoip.refresh
			iVoipSoundSelect = 5
		endif

	endif
endf


Function VoipSoundHandler:Void()

	iVoipSoundCt = iVoipSoundCt + 1
	if (iVoipSoundCt < 5) then 
		return
	endif
	iVoipSoundCt = 0
	
	iVoipSoundSeq = iVoipSoundSeq  + 1
	
	if (iVoipSoundSeq > 5000) then 
		iVoipSoundSeq = 0
	endif
	
	if (iVoipSoundSelect = 0) then 
		iVoipSoundSeq = 0
		return 
	elseif (iVoipSoundSelect = 1) then // soundPlayCallUser
		
		if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 12) or (iVoipSoundSeq = 15)  then 
			Sound.FX.Play 0,sound.fx.sys.Ring2-1,255
		endif
		
		if (iVoipSoundSeq > 30) then 
			iVoipSoundSeq = 0
		endif
		
	elseif (iVoipSoundSelect = 2) then // soundPlayBusy

		if (iVoipSoundSeq = 1)  then 
			Sound.FX.Play 0,sound.fx.sys.Click1 -1 ,255
		endif
		
		if (iVoipSoundSeq > 10) then 
			iVoipSoundSeq = 0
		endif
	
	elseif (iVoipSoundSelect = 3) then // soundPlayOffline
	
		if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 7) then 
			Sound.FX.Play 0,sound.fx.sys.Click1-1,255
		endif

		if (iVoipSoundSeq > 20) then 
			iVoipSoundSeq = 0
		endif
		
	elseif (iVoipSoundSelect = 4) then // soundPlayBeCalled

		if (iVoipSoundSeq = 1)  then 
			Sound.FX.Play 0,sound.fx.sys.Win-1,255
		endif
		
		if (iVoipSoundSeq > 55) then 
			iVoipSoundSeq = 0
		endif
		
	endif
	// iVoipSoundSelect = 5 CALLING

endf

Function VoipGetConnectedWith:Void()

;	Get VOIP connected userID
;		
; 	out:	u16OtherUserId
;

	u16OtherUserId = (256 * IO.In(#FF22)) + IO.In(#FF23)
	sDb = "Voip connected with :" + str(u16OtherUserId):sysDebug
endf



;------------------------------------------------------------------------------------------------------------
;	=== SOUND

Function se1_PlayBell:void()
	
endf

Function se1_PlayTick:void()
	///Sound.FX.Play 0,Sound.FX.Sys.Tic1,255 
endf






;------------------------------------------------------------------------------------------------------------
;	=== Data

Function ImgPos:Void()
	
	Asm
	
	.DotsData:
	;Dots 6x6 = 36
	Db   1,  3,  5,  7,  9, 11
	Db  23, 25, 27, 29, 31, 33
	Db  45, 47, 49, 51, 53, 55
	Db  67, 69, 71, 73, 75, 77
	Db  89, 91, 93, 95, 97, 99
	Db 111,113,115,117,119,121
	Db 0,0,0,0,0,0
	
	.HoriData:
	;Horizontal 5x6 = 30
	Db   2,  4,  6,  8, 10
	Db  24, 26, 28, 30, 32
	Db  46, 48, 50, 52, 54
	Db  68, 70, 72, 74, 76
	Db  90, 92, 94, 96, 98
	Db 112,114,116,118,120
	Db 0,0,0,0,0,0
	
	.VeriData:
	;Vertical 6x5 = 30
	Db  12, 14, 16, 18, 20, 22
	Db  34, 36, 38, 40, 42, 44
	Db  56, 58, 60, 62, 64, 66
	Db  78, 80, 82, 84, 86, 88
	Db 100,102,104,106,108,110
	
	.BoxData:
	;Vertical 5x5 = 25
	Db  13, 15, 17, 19, 21
	Db  35, 37, 39, 41, 43
	Db  57, 59, 61, 63, 65
	Db  79, 81, 83, 85, 87
	Db 101,103,105,107,109
	Db 0,0,0,0,0,0

	Quigs
EndF



Function  LoadImgCtrls:void()
	
	ImgIds( 1)=Ctrl.GetID(Form1,Image1.Display)
	
	ImgIds( 2)=Ctrl.GetID(Form1,Image2.Display)
	ImgIds( 2)=Image2
	
	sDb="->> Display image "+str(Image2.Display) :sysDebug
	
	ImgIds( 3)=Ctrl.GetID(Form1,Image3.Display)
	ImgIds( 4)=Ctrl.GetID(Form1,Image4.Display)
	ImgIds( 5)=Ctrl.GetID(Form1,Image5.Display)
	ImgIds( 6)=Ctrl.GetID(Form1,Image6.Display)
	ImgIds( 7)=Ctrl.GetID(Form1,Image7.Display)
	ImgIds( 8)=Ctrl.GetID(Form1,Image8.Display)
	ImgIds( 9)=Ctrl.GetID(Form1,Image9.Display)
	ImgIds(10)=Ctrl.GetID(Form1,Image10.Display)
	ImgIds(11)=Ctrl.GetID(Form1,Image11.Display)
	ImgIds(12)=Ctrl.GetID(Form1,Image12.Display)
	ImgIds(13)=Ctrl.GetID(Form1,Image13.Display)
	ImgIds(14)=Ctrl.GetID(Form1,Image14.Display)
	ImgIds(15)=Ctrl.GetID(Form1,Image15.Display)
	ImgIds(16)=Ctrl.GetID(Form1,Image16.Display)
	ImgIds(17)=Ctrl.GetID(Form1,Image17.Display)
	ImgIds(18)=Ctrl.GetID(Form1,Image18.Display)
	ImgIds(19)=Ctrl.GetID(Form1,Image19.Display)

	ImgIds(20)=Ctrl.GetID(Form1,Image20.Display)
	ImgIds(21)=Ctrl.GetID(Form1,Image21.Display)
	ImgIds(22)=Ctrl.GetID(Form1,Image22.Display)
	ImgIds(23)=Ctrl.GetID(Form1,Image23.Display)
	ImgIds(24)=Ctrl.GetID(Form1,Image24.Display)
	ImgIds(25)=Ctrl.GetID(Form1,Image25.Display)
	ImgIds(26)=Ctrl.GetID(Form1,Image26.Display)
	ImgIds(27)=Ctrl.GetID(Form1,Image27.Display)
	ImgIds(28)=Ctrl.GetID(Form1,Image28.Display)
	ImgIds(29)=Ctrl.GetID(Form1,Image29.Display)

	ImgIds(30)=Ctrl.GetID(Form1,Image30.Display)
	ImgIds(31)=Ctrl.GetID(Form1,Image31.Display)
	ImgIds(32)=Ctrl.GetID(Form1,Image32.Display)
	ImgIds(33)=Ctrl.GetID(Form1,Image33.Display)
	ImgIds(34)=Ctrl.GetID(Form1,Image34.Display)
	ImgIds(35)=Ctrl.GetID(Form1,Image35.Display)
	ImgIds(36)=Ctrl.GetID(Form1,Image36.Display)
	ImgIds(37)=Ctrl.GetID(Form1,Image37.Display)
	ImgIds(38)=Ctrl.GetID(Form1,Image38.Display)
	ImgIds(39)=Ctrl.GetID(Form1,Image39.Display)

	ImgIds(40)=Ctrl.GetID(Form1,Image40.Display)
	ImgIds(41)=Ctrl.GetID(Form1,Image41.Display)
	ImgIds(42)=Ctrl.GetID(Form1,Image42.Display)
	ImgIds(43)=Ctrl.GetID(Form1,Image43.Display)
	ImgIds(44)=Ctrl.GetID(Form1,Image44.Display)
	ImgIds(45)=Ctrl.GetID(Form1,Image45.Display)
	ImgIds(46)=Ctrl.GetID(Form1,Image46.Display)
	ImgIds(47)=Ctrl.GetID(Form1,Image47.Display)
	ImgIds(48)=Ctrl.GetID(Form1,Image48.Display)
	ImgIds(49)=Ctrl.GetID(Form1,Image49.Display)
	
	ImgIds(50)=Ctrl.GetID(Form1,Image50.Display)
	ImgIds(51)=Ctrl.GetID(Form1,Image51.Display)
	ImgIds(52)=Ctrl.GetID(Form1,Image52.Display)
	ImgIds(53)=Ctrl.GetID(Form1,Image53.Display)
	ImgIds(54)=Ctrl.GetID(Form1,Image54.Display)
	ImgIds(55)=Ctrl.GetID(Form1,Image55.Display)
	ImgIds(56)=Ctrl.GetID(Form1,Image56.Display)
	ImgIds(57)=Ctrl.GetID(Form1,Image57.Display)
	ImgIds(58)=Ctrl.GetID(Form1,Image58.Display)
	ImgIds(59)=Ctrl.GetID(Form1,Image59.Display)
	
	ImgIds(60)=Ctrl.GetID(Form1,Image60.Display)
	ImgIds(61)=Ctrl.GetID(Form1,Image61.Display)
	ImgIds(62)=Ctrl.GetID(Form1,Image62.Display)
	ImgIds(63)=Ctrl.GetID(Form1,Image63.Display)
	ImgIds(64)=Ctrl.GetID(Form1,Image64.Display)
	ImgIds(65)=Ctrl.GetID(Form1,Image65.Display)
	ImgIds(66)=Ctrl.GetID(Form1,Image66.Display)
	ImgIds(67)=Ctrl.GetID(Form1,Image67.Display)
	ImgIds(68)=Ctrl.GetID(Form1,Image68.Display)
	ImgIds(69)=Ctrl.GetID(Form1,Image69.Display)
	
	ImgIds(70)=Ctrl.GetID(Form1,Image70.Display)
	ImgIds(71)=Ctrl.GetID(Form1,Image71.Display)
	ImgIds(72)=Ctrl.GetID(Form1,Image72.Display)
	ImgIds(73)=Ctrl.GetID(Form1,Image73.Display)
	ImgIds(74)=Ctrl.GetID(Form1,Image74.Display)
	ImgIds(75)=Ctrl.GetID(Form1,Image75.Display)
	ImgIds(76)=Ctrl.GetID(Form1,Image76.Display)
	ImgIds(77)=Ctrl.GetID(Form1,Image77.Display)
	ImgIds(78)=Ctrl.GetID(Form1,Image78.Display)
	ImgIds(79)=Ctrl.GetID(Form1,Image79.Display)
	
	ImgIds(80)=Ctrl.GetID(Form1,Image80.Display)
	ImgIds(81)=Ctrl.GetID(Form1,Image81.Display)
	ImgIds(82)=Ctrl.GetID(Form1,Image82.Display)
	ImgIds(83)=Ctrl.GetID(Form1,Image83.Display)
	ImgIds(84)=Ctrl.GetID(Form1,Image84.Display)
	ImgIds(85)=Ctrl.GetID(Form1,Image85.Display)
	ImgIds(86)=Ctrl.GetID(Form1,Image86.Display)
	ImgIds(87)=Ctrl.GetID(Form1,Image87.Display)
	ImgIds(88)=Ctrl.GetID(Form1,Image88.Display)
	ImgIds(89)=Ctrl.GetID(Form1,Image89.Display)

	ImgIds(90)=Ctrl.GetID(Form1,Image90.Display)
	ImgIds(91)=Ctrl.GetID(Form1,Image91.Display)
	ImgIds(92)=Ctrl.GetID(Form1,Image92.Display)
	ImgIds(93)=Ctrl.GetID(Form1,Image93.Display)
	ImgIds(94)=Ctrl.GetID(Form1,Image94.Display)
	ImgIds(95)=Ctrl.GetID(Form1,Image95.Display)
	ImgIds(96)=Ctrl.GetID(Form1,Image96.Display)
	ImgIds(97)=Ctrl.GetID(Form1,Image97.Display)
	ImgIds(98)=Ctrl.GetID(Form1,Image98.Display)
	ImgIds(99)=Ctrl.GetID(Form1,Image99.Display)
	
	ImgIds(100)=Ctrl.GetID(Form1,Image100.Display)
	ImgIds(101)=Ctrl.GetID(Form1,Image101.Display)
	ImgIds(102)=Ctrl.GetID(Form1,Image102.Display)
	ImgIds(103)=Ctrl.GetID(Form1,Image103.Display)
	ImgIds(104)=Ctrl.GetID(Form1,Image104.Display)
	ImgIds(105)=Ctrl.GetID(Form1,Image105.Display)
	ImgIds(106)=Ctrl.GetID(Form1,Image106.Display)
	ImgIds(107)=Ctrl.GetID(Form1,Image107.Display)
	ImgIds(108)=Ctrl.GetID(Form1,Image108.Display)
	ImgIds(109)=Ctrl.GetID(Form1,Image109.Display)
	
	ImgIds(110)=Ctrl.GetID(Form1,Image110.Display)
	ImgIds(111)=Ctrl.GetID(Form1,Image111.Display)
	ImgIds(112)=Ctrl.GetID(Form1,Image112.Display)
	ImgIds(113)=Ctrl.GetID(Form1,Image113.Display)
	ImgIds(114)=Ctrl.GetID(Form1,Image114.Display)
	ImgIds(115)=Ctrl.GetID(Form1,Image115.Display)
	ImgIds(116)=Ctrl.GetID(Form1,Image116.Display)
	ImgIds(117)=Ctrl.GetID(Form1,Image117.Display)
	ImgIds(118)=Ctrl.GetID(Form1,Image118.Display)
	ImgIds(119)=Ctrl.GetID(Form1,Image119.Display)

	ImgIds(120)=Ctrl.GetID(Form1,Image120.Display)
	ImgIds(121)=Ctrl.GetID(Form1,Image121.Display)

endf

//------------------------------------------------------------------------------------------------------------
// === STP PROGRAMS ===


Function   stpStartup:Void()
	
	If iStpStartup = 0 Then
		return 
	EndIf
	
	if (iStpStartup <> 120) then 
		sDb = "step  is: "+str(iStpStartup) :sysDebug 
	endif
	
	If iStpStartup = 10 Then		//.. start
		
		strIn1 =  strFirmware
		F72_25	//.. check firmware
		If  u8Out1 > 0  Then
			c = MsgBox("Firmware  out of  date !","Needed: ",strFirmware ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
		EndIf

		F131_1	//.. get status
		If u8Out1 = 3 Then
			iStpStartup  = 30
		Else
			F131_0						//.. login tmtnet
			iStpStartup = 20
		EndIf
		return 
	EndIf
	
	If iStpStartup = 20 Then	//.. Wait for connection
		F131_1	//.. get status
		If u8Out1 = 0 Then
			c = MsgBox("Wifi OFFLINE !","Not connected: ","" ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
			iAppExit = 1
		EndIf
		
		If u8Out1 = 3 Then
			
			iStpStartup  = 30
		EndIf
		return 
	EndIf
	
	If iStpStartup = 30 Then	//.. Login ready
	
		
		F131_8						//.. get my userID
		
		strIn1 = strAppname
		F131_32						//.. set Appname
		
		iStpStartup = 100
		
		Form4.close
		Form2.open
		return 
	EndIf
	
	
	If iStpStartup = 100 Then	//.. Choise player
		
		F131_2					//.. clear userOnline table
		
		iButChoise = 0
		
		intDelay = 25			//.. 500ms
		intDelayCt = 0 
		iStpStartup = 110
		return 
	EndIf
	
	If iStpStartup = 110 Then	//.. Read online users
		
		F131_3					//.. read userOnline table
		
		; iUserOnlineTotal
			
		label21.text.set "..."
		label22.text.set "..."
		label23.text.set "..."
		label24.text.set "..."
		label25.text.set "..."
	
		Label21.Colour.Set Colour.White,colour.Blue,1
		Label22.Colour.Set Colour.White,colour.Blue,1
		Label23.Colour.Set Colour.White,colour.Blue,1
		Label24.Colour.Set Colour.White,colour.Blue,1
		Label25.Colour.Set Colour.White,colour.Blue,1


		if (iUserOnlineTotal > 0) then 
			u16In1 = u16UserOnline(0)
			F131_7				//.. get User info
			sText = strOut1 + "   " + strOut2
			label21.text.set sText
		endif
		
		if (iUserOnlineTotal > 1) then 
			u16In1 = u16UserOnline(1)
			F131_7				//.. get User info
			sText = strOut1 + "   " + strOut2
			label22.text.set sText
		endif
		
		if (iUserOnlineTotal > 2) then 
			u16In1 = u16UserOnline(2)
			F131_7				//.. get User info
			sText = strOut1 + "   " + strOut2
			label23.text.set sText
		endif
	
		if (iUserOnlineTotal > 3) then 
			u16In1 = u16UserOnline(2)
			F131_7				//.. get User info
			sText = strOut1 + "   " + strOut2
			label24.text.set sText
		endif

		if (iUserOnlineTotal > 4) then 
			u16In1 = u16UserOnline(2)
			F131_7				//.. get User info
			sText = strOut1 + "   " + strOut2
			label25.text.set sText
		endif

		label21.refresh
		label22.refresh
		label23.refresh
		label24.refresh
		label25.refresh
				
		intDelay = 10				// 200ms
		intDelayCt = 0
		iStpStartup = 120
		return
	EndIf
	
	If iStpStartup = 120 Then	
		
		u8NetStatus = IO.In(ioA_A)
		
		if ((u8NetStatus and defNetStatusBitUser) > 0) then 
			iStpStartup = 110
		endif
		
		if (iButChoise > 0) then 
			iStpStartup = 130
		endif
		
		return
	endif
	
	If iStpStartup = 130 Then	
	
		x = iButChoise - 1
		u16OtherID = u16UserOnline(x)
		
		u16OtherUserId = u16OtherID //voip
		
		sDb = "Other user is: "+str(u16OtherID) :sysDebug
		
		intDelay = 10			//.. 200ms
		
		if (u16OtherID = u16MyUserID ) then 
			if (iButChoise = 1) then 
				Label21.Colour.Set Colour.White,colour.Orange,1
				Label21.refresh
			endif
			if (iButChoise = 2) then 
				Label22.Colour.Set Colour.White,colour.Orange,1
				Label22.refresh
			endif
			if (iButChoise = 3) then 
				Label23.Colour.Set Colour.White,colour.Orange,1
				Label23.refresh
			endif
			if (iButChoise = 4) then 
				Label24.Colour.Set Colour.White,colour.Orange,1
				Label24.refresh
			endif
			if (iButChoise = 5) then 
				Label25.Colour.Set Colour.White,colour.Orange,1
				Label25.refresh
			endif
			
			iButChoise = 0
			intDelay = 20			//.. 400ms
			intDelayCt = 0
			iStpStartup = 110
			return
		endif
		
		iButChoise = 0
		
		u16in1 = u16OtherID
		F131_33

		iTimeOut = 0
		intDelay = 10				//.. 200ms
		intDelayCt = 0
		iStpStartup = 140
		return
	endif

	If iStpStartup = 140 Then	//.. Wait for  Appname
		
		iTimeOut = iTimeOut + 1
		if (iTimeout > 5) then 
			sDb = "Appname timeout step 140":sysDebug
			iStpStartup = 100
		endif
		
		u8NetStatus = IO.In(ioA_A)
		if ((u8NetStatus and defNetStatusBitSys) = 0) then 
			return 
		endif
		
		F131_34
		
		Label26.Text.Set "Appname: "+strOut1
		Label26.Refresh
		
		sDb="App: "+strOut1: sysDebug
		
		if (strOut1 <> strAppname) then
			iStpStartup = 100
		else
			iStpStartup = 150
		endif
		return
	endif
	
	If iStpStartup = 150 Then	//.. End

		iStpStartup = 0
		
		Form2.close
		Form1.open
		
		game_begin
	endif
EndF
	
;--------------------------------------------------------------------------	

Function sys_IO_init:Void()

	If  (Machine = 7)  Or  (Machine = 8)  Or  (Machine = 9) Or  (Machine = 10) Then
		ioA_0 = #40f0 : ioA_1 = #41f0 : ioA_2 = #42f0 : ioA_3 = #43f0
		ioA_4 = #44f0 : ioA_5 = #45f0 : ioA_6 = #46f0 : ioA_7 = #47f0
		ioA_8 = #48f0 : ioA_9 = #49f0 : ioA_A = #4af0 : ioA_B = #4bf0
		ioA_C = #4cf0 : ioA_D = #4df0 : ioA_E = #4ef0 : ioA_F = #4ff0
		
		strCPU = "MSX"
	EndIf
	
	If  (Machine = 6)  Then
		ioA_0 = #40 : ioA_1 = #41 : ioA_2 = #42 : ioA_3 = #43 
		ioA_4 = #44 : ioA_5 = #45 : ioA_6 = #46 : ioA_7 = #47
		ioA_8 = #48 : ioA_9 = #49 : ioA_A = #4a : ioA_B = #4b 
		ioA_C = #4c : ioA_D = #4d : ioA_E = #4e : ioA_F = #4f
		
		strCPU = "EP"
	EndIf
	
	If  (Machine = Machine.Pcw8xxx)  or  ( Machine = Machine.Pcw9xxx) or ( Machine = Machine.Pcw16)   Then
		ioA_0 = #40B0 : ioA_1 = #41B0 : ioA_2 = #42B0 : ioA_3 = #43B0
		ioA_4 = #44B0 : ioA_5 = #45B0 : ioA_6 = #46B0 : ioA_7 = #47B0
		ioA_8 = #48B0 : ioA_9 = #49B0 : ioA_A = #4aB0 : ioA_B = #4bB0
		ioA_C = #4cB0 : ioA_D = #4dB0 : ioA_E = #4eB0 : ioA_F = #4fB0
		
		strCPU = "PCW"
	EndIf
	
	If  (Machine < 5)  Then
		ioA_0 = #fd40 : ioA_1 = #fd41 : ioA_2 = #fd42 : ioA_3 = #fd43
		ioA_4 = #fd44 : ioA_5 = #fd45 : ioA_6 = #fd46 : ioA_7 = #fd47
		ioA_8 = #fd48 : ioA_9 = #fd49 : ioA_A = #fd4a : ioA_B = #fd4b
		ioA_C = #fd4c : ioA_D = #fd4d : ioA_E = #fd4e : ioA_F = #fd4f

		strCPU = "CPC"
	EndIf
	
	sDb = strCPU :sysDebug
EndF

;--------------------------------------------------------------------------	
;	=== SF3

Function  ArmResponse:Int()
	// wait  for ARM progress
	//
	// return 0 = ready
	// return 2 = error
	
	
	resp = 1
	
	//wacht = 1000
	
	While (resp = 1)
		resp = IO.In(ioA_1)
	Wend
	
	If  resp = 2 Then
		F72_4
	EndIf
	
	Return(resp)
EndF


;--------------------------------------------------------------------------	

Function	F72_4:Void()
	//Error
	Lock.On
	sDb = "SF3 ERROR"
	sysDebug
	Lock.Off
EndF
	
Function F72_25:Void()
	// check firmware
	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,25
	
	For  x = 1 To  8
		IO.Out ioA_2,Asc(Mid(strIn1,x,1))
	Next
	
	
	IO.Out ioA_1,72
	
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	u8Out1    = IO.In(ioA_2)
	
	Lock.Off
EndF



Function F72_26:Void()
	
	// Get seperate system  info
	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,26
	IO.Out ioA_2,0
	//in0 todo
	IO.Out ioA_1,72
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	c = 1
	strOut1 = ""
	While (c  > 0)
		c=  IO.In(ioA_2)
		If  c > 0 Then
			strOut1= strOut1	+ Chr(c)
		EndIf
	Wend
	
	Lock.Off
	
	
EndF

Function F131_0:Void()
	// net21  Tmtnet login
	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,0
	
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	u8Out1    = IO.In(ioA_2)
	Lock.Off
	
EndF
			
Function F131_1:void()

// ------  Get stutus
//
// 0 = Server logoff
// 1 = Server online, user logoff
// 2 = User login waiting for access
// 3 = User login connected
// 4 = Error

	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,1
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	u8Out1    = IO.In(ioA_2)
	
	Lock.Off
Endf

Function F131_2:void()

//	------ Reset userOnline array

	Lock.On
	
	IO.Out ioA_1,0
	IO.Out ioA_2,2
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
				
	for fc = 0 to 20			
		u16UserOnline(fc) = 0
	next 
	iUserOnlineTotal = 0
		
	Lock.Off
EndF

Function F131_3:void()

//	------ F131,3 Read online status all users

	
	
	Lock.On
	
	IO.Out ioA_1,0
	IO.Out ioA_2,3
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf

	iUserOnlineTotal = 0
	
	for fx = 0 to 20			
		fy =(IO.In(ioA_2) *256) + IO.In(ioA_2)
		if (fy > 0) then
			u16UserOnline(iUserOnlineTotal) = fy
			iUserOnlineTotal = iUserOnlineTotal + 1 
		endif
	next 

	sDb = "F131_3 users online:"  + str(iUserOnlineTotal):sysDebug
	
	Lock.Off
	
EndF

Function F131_7:Void()
	
//	' new21 Get user info
//	'  #3003,Hans,NL,CPC,
	
	
	sDb = "131_7 in "+str(u16in1):sysDebug
	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,7
	IO.Out ioA_2,(u16in1 / 256)
	IO.Out ioA_2,(u16in1 And 255)
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	fsw = 0
	fx = 1
	
	strOut1 = "" 	//.. 3000
	strOut2 = ""	//.. Hans
	strOut3 = ""	//.. NL
	strOut4 = ""	//.. CPC
	
	For fn = 1 To 50
		fc =IO.In(ioA_2)
		
		If fc = 0 Then
			fsw = 1
		EndIf
		
		If  fc =35 Then
			fx  = 1
		EndIf
		
		If (fc = 35) Or (fc = 44) Then
			fx = fx + 1
		Else
			If fsw = 0 Then
				If (fc <> 32) And  (fc <> 9) Then
					If fx = 2 Then
						strOut1 = strOut1 + Chr(fc)
					EndIf
					If fx =3 Then
						strOut2 = strOut2 + Chr(fc)
					EndIf
					If fx =4 Then
						strOut3 = strOut3 + Chr(fc)			// NL
					EndIf
					If fx = 5 Then
						strOut4 = strOut4 + Chr(fc)
					EndIf
				EndIf
			EndIf
		EndIf
	Next
	
	
	
	Lock.Off
EndF



Function F131_8:void()

//	------ 8 get userId and password

	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,8
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	u16MyUserID = (IO.In(ioA_2) *256) + IO.In(ioA_2) 		
	
	strUserPass = ""
	fc = 1
	While (fc  > 0)
		fc=  IO.In(ioA_2)
		If  fc > 0 Then
			strUserPass= strUserPass + Chr(fc)
		EndIf
	Wend
							
	Lock.Off
EndF

Function F131_10:void()

; ------ Voip call userID

	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,10
	IO.Out ioA_2,(u16in1 / 256)
	IO.Out ioA_2,(u16in1 And 255)
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
							
	Lock.Off
EndF

Function F131_11:void()

; ------ Voip call accept 

	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,11
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
							
	Lock.Off
EndF

Function F131_12:void()

; ------ Voip Break call 

	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,12
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
							
	Lock.Off
EndF

Function F131_20:void()

//	------ 20 chat send

	
	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,20
			
	c =  (u16Du / 256)
	IO.Out ioA_2,c
	c =  (u16Du and 255)
	IO.Out ioA_2,c

//	'Send message 
//?? mt
	IO.Out ioA_2,0
	
	l = Len(strIn1)
	For t = 1 To l
		c = Asc(Mid(strIn1,t,1))
		IO.Out ioA_2,c
	Next

	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	Lock.Off
EndF

Function F131_21:void()

//	'------ 21 Read chat tx status 

	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,21
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	u8Out1 = IO.In(ioA_2)			// 'was r
							
	Lock.Off
EndF


Function F131_22:void()

//	'------ 22 read Text message 

	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,22
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
						
	fy = IO.In(ioA_2)				//'Number of bytes in buffer
	fc = IO.In(ioA_2)				// @ removed
	
	strTm = ""
	For fx = 1 to fy
		fc = IO.In(ioA_2)
		if (fc=13) or (fc=10) then 
			fc = 32
		endif
		strTm = strTm + Chr(fc)
	Next 
	
	Lock.Off
EndF



Function F131_32:void()

//	'------ 32 Set your appname
	
	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,32

	l = Len(strIn1)
	For t = 1 To l
		c = Asc(Mid(strIn1,t,1))
		IO.Out ioA_2,c
		sDb = str(c):sysDebug
	Next
	IO.Out ioA_2,0
	
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	
	
	sDb = "->":sysDebug
	sDb = strIn1:sysDebug
	sDb = strAppname:sysDebug
	sDb = "<-":sysDebug
	
	Lock.Off
EndF

Function F131_33:void()

//	'------ 33 Send query appname
	
	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,33
	
	c =  (u16in1 / 256)
	IO.Out ioA_2,c
	c =  (u16in1 and 255)
	IO.Out ioA_2,c

	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	Lock.Off
EndF

Function F131_34:void()
	
//	------ Read other user app 
			
	IO.Out ioA_1,0
	IO.Out ioA_2,34
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf				 
	
	fx = 1
	strOut1 = ""
	while((fx > 0) and (len(strOut1) < 14))
		fx = IO.In(ioA_2)
		if fx > 30 then 
			strOut1 = strOut1 + chr(fx)
		endif
	wend
Endf

				
Function F131_39:void()

//	'------ 39 Set streammode Z80
// 	' also reset  appname 

	Lock.On
	IO.Out ioA_1,0
	IO.Out ioA_2,39
	IO.Out ioA_1,131
	
	If ArmResponse =2 Then
		//nop
	EndIf
	
	Lock.Off
EndF


;-------------------------------------------------------------------------------------------------
; === SEONE 

Function ATCmd:Void()

	sDb = sAtCmd:sysDebug
	
	l = Len(sAtCmd)
	
	For t = 1 to l
		c = Asc(Mid(sAtCmd,t,1))
		if (c <> 32) then 
			IO.Out #FF20,c
		endif
	Next
	IO.Out  #FF20,13
	
	AtResponsStr
EndF

Function AtResponsStr:Void()
	//.. OK    AT+SEMODE=FM
	
	sAtResp = ""
	sAtData = ""
	
	x = 0
	y = 0	// switch '='
	a = 0
	iTimeOut = 0	
	
	while( a = 0) 
		
		c = IO.In(#FF20) 
									
		if ((c > 31) and (x < 50)) then 
			sAtResp = sAtResp  + chr(c)
			
			if (y=1) then 
				sAtData = sAtData  + chr(c)
			endif
			
			if (c = 61) then  // =
				y=1
			endif
			
			
			x = x + 1
		endif
		
		if ((c = 13) or (c = 10)  ) then 
			a = 1
		endif
		
		if (x > 50) then 
			a = 1
		endif
		
		if (iTimeOut > 10000) then 
			a = 1
		endif
		
		iTimeOut = iTimeOut + 1
	wend
	
	sDb = "AT resp:" + sAtResp:sysDebug
	
EndF







