;*******************************
;**** SymBasic Code .****
;*******************************

;**** Necessary Stuff
.SyB_RamBankInfo
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0		
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
		db		0,0:dw 0,0
.SyB_RamBank_Temp:		dw	0

.SyB_Abs_Int
;****      ABS       ****
;**** Do Integer ABS ****
;****                ****
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		z
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret		

.SyB_ABS_Flo
;****     ABS      ****
;**** Do Float ABS ****
;****              ****
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		res		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret

.SyB_INT_SHR		
;**** Do Integer SHR ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)		;=8
		ld		h,(iy+8)
		ld		e,(iy+13)		;=Operand
		ld		d,(iy+14)
		
		ld		bc,SyB_INT_SHR_1
		add		hl,bc
		add		hl,bc
.SyB_INT_SHR_1
		di
.ghi	jr		ghi
		
.SyB_INT_Add		
;****      ADD       ****
;**** Do Integer Add ****
;****                ****
		ld		iy,(SyB_StackAddr)		
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de						;***** Add Integers Together
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
.SyB_FLO_Add		
;****     ADD      ****
;**** Do Float Add ****
;****              ****
		call	SyB2_STACK_2_FLO
		call 	FLO_ADD
		jp		SyB_DecStack
		
.SyB_INT_And		
;****      AND       ****
;**** Do Integer AND ****
;****                ****
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		(iy+13)
		ld		(iy+13),a
		ld		a,(iy+8)
		And		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
.SyB_ASC
;****   ASC  ****
;**** Do ASC ****
;****        ****
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)					;**** Address of Text
		ld		d,(iy+8)					;**** Address of Text
		ld		c,(iy+9)					;**** Len of text
		ld		a,(de)
		ld		(iy+7),a
		ld		(iy+8),0
		Xor		a
		ld		hl,(SyB_StrStackAddr)
		ld		b,0
		sbc		hl,bc
		ld		(syB_StrStackAddr),hl
		ret
		
.SyB_ATAN		
;****   ATAN  ****
;**** Do ATAN ****
;****         ****
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_ARC_TAN

.SyB_BankSize
;****     BANKSIZE       ****
;**** Bank Size Function ****
;****                    ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_BankSize_Error
		ld		de,4
		add		hl,de
		ld		a,(hl)
		inc		hl
		ld		(iy+7),a
		ld		a,(hl)
		ld		(iy+8),a
		ret
.SyB_BankSize_Error			
		ld		(iy+7),0
		ld		(iy+8),0
		ret
		
.SyB_Chr		
;****   CHR   ****
;**** Do CHR$ ****
;****         ****
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		ld		hl,(SyB_StrStackAddr)
		;ld		(iy+6),5
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),1
		ld		(hl),a
		inc		hl
		ld		(SyB_StrStackAddr),hl
		ret
		
.SyB_ClearBank		
;****      CLEARBANK     ****
;**** Clear Bank Command ****
;****                    ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		nz,SyB_ClearBank_3
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		ld		e,c
		ld		d,b
.SyB_ClearBank_2		
		ld		b,0
		rst		#20:	dw #812D
		dec		e
		jp		nz,SyB_ClearBank_2
		dec		d
		jp		nz,SyB_ClearBank_2		
.SyB_ClearBank_3
		ret
		
.SyB_DirDialog		
;****     DIRDIALOG      ****
;**** DirDialog function ****
;****                     ****
		ld		a,(AppBnkNum)
		set		7,a
		ld		(SyB_FileDialog_Extra),a
		jp		SyB_FileDialog

.SyB_INT_Div
;****       DIVIDE        ****
;**** Do Integer Division ****
;****                     ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),l
		ld		(iy+14),h
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

.SyB_Flo_Div		
;****      DIVIDE       ****
;**** Do Float Division ****
;****                   ****		
		call	SyB2_STACK_2_FLO
		call	FLO_DIV
		jp		SyB_DecStack
		
.SyB_Eof
;****      EOF     ****
;**** EOF Function ****
;****              ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_Eof_OK_1
		cp		174						;ReadFile
		jp		z,SyB_Eof_OK_1
		cp		175						;WriteFile
		jp		z,SyB_Eof_OK_1		
		;*** Failed
		ld		(iy+7),0
		ld		(iy+8),0
		ld		bc,0
		ld		de,288					;1 / 32
		jp		SyB_Mark_Error
.SyB_Eof_OK_1:
		push	hl
		pop		ix
		ld		e,(ix+8)
		ld		d,(ix+9)
		;Check if de=0 - If it is then EOF true
		Xor		a
		cp		e
		jp		nz,SyB_Eof_OK_2
		cp		d
		jp		z,SyB_Eof_True7
.SyB_Eof_OK_2:
		ld		l,(ix+4)
		ld		a,(ix+5)
		And		%1
		ld		h,a
		Xor		a
		sbc		hl,de
		jp		c,SyB_Eof_False
.SyB_Eof_True:
		ld		a,1		
.SyB_Eof_False:
		ld		(iy+7),a
		ld		(iy+8),0		
		ret
.SyB_Eof_True7
		di
.fjtt	jr		fjtt		

.SyB_CloseFile		
;****     CLOSEFILE      ****
;**** CloseFile Function ****
;****                    ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_CloseFile_OK_1
		cp		174						;ReadFile
		jp		z,SyB_CloseFile_OK_1
		cp		175						;WriteFile
		jp		z,SyB_CloseFile_OK_1		
		;*** Failed
		ld		de,288					;1 / 32
		jp		SyB_Mark_Error

		ret
.SyB_CloseFile_OK_1:
		push	hl
		pop		ix
		ld		a,(ix+1)
		cp		1
		jp		nz,SyB_CloseFile_OK_2
		;*** Must write file
		call	SyB_Write_512_Bytes
.SyB_CloseFile_OK_2:
		ld		(ix+0),0
		ld		a,(ix+3)
		call	SyFile_FILCLO
		ld		iy,(Syb_StackAddr)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
.SyB_CloseForm
;****     CLOSEFORM      ****
;**** CloseForm Function ****
;****                    ****		
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		call	SyB_Studio_CloseForm
		ld		a,(SyB_Studio_FormOS)
		call	SyDesktop_WINCLS
		ret		
.SyB_CreateBank		
;****      CREATEBANK      ****
;**** Create Bank Function ****
;****                      ****
		ld		iy,(SyB_StackAddr)
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,15							;Number of Banks Possible-1
		ld		de,8							;Bytes to jump (Each Bank Ref is 6 bytes)
		Xor		a								;A=0
.SyB_CreateBank_1			
		cp		(hl)
		jr		z,SyB_CreateBank_FoundSlot		;Until (hl)<>0
		add		hl,de							;Jump over next
		djnz	SyB_CreateBank_1				;Repeat until Empty bank found or 15 are used
		jp		SyB_CreateBank_Error
SyB_CreateBank_FoundSlot
		ld		c,(iy+7)
		ld		b,(iy+8)
		push	bc
		push	hl
		Xor		a
		ld		e,a
		rst		#20
		dw		#8118
		pop		de
		jp		c,SyB_CreateBank_Error		
		ex		de,hl
		ld		c,172
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(hl),c
		inc		hl
		ld		(hl),a							;Stores Bank
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		pop		bc
		ld		(hl),c
		inc		hl
		ld		(hl),b		
		ret
.SyB_CreateBank_Error
		pop		hl
		ld		(iy+7),0
		ld		(iy+8),0
		ret

.SyB_ColourDepth		
;****     COLOURDEPTH      ****		
;**** ColourDepth Function ****		
;****                      ****
		ld 		hl,#8139
		rst 	#28
		ld		a,d
		And		%1111
		ld		d,a
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
.SyB_Cos		
;****   COS  ****
;**** Do COS ****
;****        ****
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_COS
	
.SyB_Key
;****   KEY  ****
;**** Do Key ****
;****        ****
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld 		hl,#8145:rst #28		;*** KEYTST
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),e
		ld		d,0
		ld		(iy+8),d
		ret
		
.SyB_KeyStatus 
;****   KEYSTATUS  ****
;**** Do KeyStatus ****
;****              ****
		ld hl,#8148:rst #28
		ld		a,d
		rla
		rla
		rla
		or		e
		ld		a,e
		ld		d,0
		ld		iy,(SyB_StackAddr)
		ld		bc,-6
		add		iy,bc
		ld		(iy+7),e
		ld		(iy+8),d
		ld		(SyB_StackAddr),iy
		ret

.SyB_Sin
;****   SIN  ****
;**** Do SIN ****
;****        ****
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SIN

.SyB_DrawObjTile
;****      DRAWOBJTILE    ****
;**** DrawObjTile Command ****
;**** DrawObjTile destination obj id,x,y,source sheet,tile,refresh 0/1
		ld		iy,(SyB_StackAddr)	
		;Source Tile Shit
		ld		l,(iy+13)				;HL=Memory Bank Address
		ld		h,(iy+14)
		ld		a,(hl)
		cp		180
		jp		nz,SyB_DrawObjTile_Finish		
		inc		hl
		ld		a,(hl)				;A = Memory bank
		push	af					;Store Bank
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Location in Bank
		ld		l,(iy+7)			;HL = Tile
		ld		h,(iy+8)		
		inc		hl					;This adds 2 to skil Short value of Tile No
		add		hl,hl				;Tile * 2
		add		hl,de				;Tile * 2+ Memory Location = 
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		add		hl,bc
		dec		hl
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		ld		(SyB_Tile_WidthP),bc	
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		ld		(SyB_Tile_Height),bc
		ld		bc,4
		add		hl,bc
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		ld		(SyB_Tile_Garbage),bc
		inc		hl
		ld		(SyB_Tile_Data),hl
		
		;Get Destination Tile Shit
		ld		l,(iy+37)				;HL=Memory Bank Address
		ld		h,(iy+38)
		ld		a,(hl)
		cp		180
		jp		nz,SyB_DrawObjTile_Finish		
		inc		hl
		ld		a,(hl)				;A = Memory bank
		rla
		rla
		rla
		rla
		ld		b,a
		pop		af
		or		b
		ld		(SyB_889+1),a
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Location in Bank
		ld		l,(iy+31)	y		;HL = Tile
		ld		h,(iy+32)
		inc		hl
		add		hl,hl				;Tile * 2
		add		hl,de				;Tile * 2+ Memory Location = 
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		add		hl,bc
		;dec		hl
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		ld		(SyB_Tile_WidthB2),bc	
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		ld		(SyB_Tile_Height2),bc	
		ld		bc,4
		add		hl,bc
		rst 	#20:dw #8124				;*** Read Bank Word A,HL Into BC, HL=Adress+2
		ld		(SyB_Tile_Garbage2),bc
		push 	hl
		ld		a,(SyB_Tile_Height2)
		ld		e,(iy+19)
		cp		e
		jp		c,SyB_DrawObjTile_Finish	;*** If off bottom of screen then ignore
		ld		a,(SyB_Tile_WidthB2)
		ld		h,a
.Mul8b                           ; this routine performs the operation HL=H*E
		ld 		d,0                         ; clearing D and L
		ld 		l,d
		ld 		b,8                         ; we have 8 bits
.Mul8bLoop
		add 	hl,hl                      ; advancing a bit
		jr 		nc,Mul8bSkip                ; if zero, we skip the addition (jp is used for speed)
		add 	hl,de                      ; adding to the product if necessary
.Mul8bSkip
		djnz 	Mul8bLoop	
		pop		de
		add		hl,de
		ld		e,(iy+25)
		ld		d,0
		add		hl,de
		ld		(SyB_Tile_Data2),hl		
		ld		a,(SyB_Tile_WidthB)
		ld		(SyB_888+1),a
		ld		(SyB_891+1),a
		ld		a,(SyB_Tile_WidthB2)
		ld		(SyB_890+1),a
		
		ld		hl,(SyB_Tile_Data)
		ld		de,(SyB_Tile_Data2)
		
		ld		a,(SyB_Tile_Height)
		ld		b,a
		
.SyB_880			
		push	bc
		push	hl
		push	de
.SyB_888		
		
		ld		c,0
		ld		b,0
.SyB_889		
		ld		a,0
		rst 	#20:dw #8130
		pop		de
.SyB_890		
		ld		hl,0
		add		hl,de
		ex		de,hl
		pop		hl
.SyB_891
		ld		bc,0
		add		hl,bc
		pop		bc
		djnz	SyB_880
		ld		hl,(SyB_StackAddr)
		ld		bc,36
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret

.SyB_Tile_WidthP:	db	0
.SyB_Tile_WidthB:	db	0
.SyB_Tile_Height:	db 	0
.SyB_Tile_Garbage:	db	0
.SyB_Tile_Encode:	db	0
.SyB_Tile_Data:		dw	0

.SyB_Tile_WidthB2:	db	0
.SyB_Tile_WidthP2:	db	0
.SyB_Tile_Height2:	db 	0
.SyB_Tile_Garbage2:	db	0
.SyB_Tile_Encode2:	db	0
.SyB_Tile_Data2:	dw	0

.SyB_DrawObjTile_Finish
		di
.afj4	jr		afj4

.SyB_RefreshMenu
;****              ****
;**** Refresh Menu ****
;****              ****
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage
		ret		
		
.SyB_RefreshTitle		
;****               ****
;**** Refresh Title ****
;****               ****
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		SyDesktop_WINTIT

.SyB_RefreshStatus		
;**** REFRESHSTATUS  ****
;**** Refresh Status ****
;****                ****
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		SyDesktop_WINSTA

.SyB_ResolutionX
;****    RESOLUTIONX       ****		
;**** ResolutionX Function ****		
;****                      ****
		ld 		hl,#8139
		rst 	#28
		push	ix
		pop		de		
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),e
		ld		(iy+2),d
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

.SyB_ResolutionY
;****    RESOLUTIONY       ****		
;**** ResolutionY Function ****		
;****                      ****
		ld 		hl,#8139
		rst 	#28
		push	iy
		pop		de
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),e
		ld		(iy+2),d
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

.SyB_RND
;****   RND  ****
;**** Do RND ****
;****        ****
		ld		hl,(SyB_StackAddr)
		inc		hl
		call	FLO_RND
		ex		de,hl
		ld		hl,6
		add		hl,de
		call 	FLO_MULT
		ret

.SyB_ReadByte
;****     READBYTE      ****
;**** ReadByte Function ****
;****                   ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadByte_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadByte_OK_1
		;*** Failed
		di
.jhft	jr		jhft
		ret
.SyB_ReadByte_OK_1:
		push	hl
		pop		ix		
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)		
		ld		(iy+7),a
		ld		(iy+8),0
		ret

.SyB_ReadFloat
;****      READFLOAT      ****
;**** ReadFloat Function  ****
;****                     ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadFloat_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadFloat_OK_1
		;*** Failed
		di
.jhft1	jr		jhft1
		ret
.SyB_ReadFloat_OK_1:
		push	hl
		pop		ix
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+8),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+10),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+11),a				
		ret
.SyB_ReadFloat_Temp:	dw	0
					
.SyB_ReadInt		
;****     READINT      ****
;**** ReadInt Function ****
;****                  ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadInt_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadInt_OK_1
		;*** Failed
		di
.jhft2	jr		jhft2
		ret
.SyB_ReadInt_OK_1:
		push	hl
		pop		ix
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+8),a				
		ret
.SyB_ReadInt_Temp:	dw	0

.SyB_ReadLine
;****     READLINE      ****
;**** ReadLine Function  ****
;****                    ****
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadLine_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadLine_OK_1
		;*** Failed
		di
.jhft3	jr		jhft3
		ret	
.SyB_ReadLine_OK_1:
		ld		de,(SyB_StrStackAddr)
		ld		(iy+7),e
		ld		(iy+8),d
		ld		b,0
		ld		c,0
		push	hl
		pop		ix
.SyB_ReadLine_OK_2		
		push	de
		push	bc
		call	SyB_Read_BFF
		pop		bc
		pop		de
		cp		13
		jp		z,SyB_ReadLine_FinishedReading		
		cp		10
		jp		nz,SyB_ReadLine_OK_3
		ld		r,a
		Xor		a
		cp		c
		jp		nz,SyB_ReadLine_OK_3
		ld		c,1
		jp		SyB_ReadLine_OK_2		
.SyB_ReadLine_OK_3
		ld		c,1
		inc		b
		ld		(de),a
		inc		de
		ld		a,b
		cp		251
		jp		c,SyB_ReadLine_OK_2
.SyB_ReadLine_FinishedReading
		ld		(SyB_StrStackAddr),de
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),b
		ret

.SyB_Right		
;****     RIGHT$     ****
;**** Right Function ****
;****                ****
		ld		iy,(SyB_StackAddr)
		ld		c,(iy+7)				;Length Required
		ld		a,(iy+15)				;Originals stack length
		sub		c
		jp		c,SyB_Right_1
		ld		b,a
		ld		e,(iy+13)				;DE=start of text on stack
		ld		d,(iy+14)	
		ld		(iy+15),c				;Store new length
		ld		a,c
		And		a
		jp		z,SyB_Right_1
		ld		l,b
		ld		h,0
		add		hl,de					;HL = Start of text
		ld		b,0
		ldir
		ld		(SyB_StrStackAddr),hl
.SyB_Right_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;****          DEG          ****
;**** DEG - Set Degree Mode ****
;****                       ****
.SyB_Deg:
		ld		a,1
		ld		(FLO_VALUE_DEGRAD),a
		ret
;****       DIALOG       ****
;**** Dialog Box Command ****
;****                    ****
.SyB_Dialog
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		%1111
		add		a
		add		a
		add		2
		ld		(SyB_Dialog_Info_1+2),a
		ld		(SyB_Dialog_Info_2+2),a
		ld		(SyB_Dialog_Info_3+2),a				
		ld		e,(iy+21)				;Originals stack length
		ld		hl,(SyB_StrStackAddr)
		ld		d,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		ld		c,e
		
		ld		e,(iy+19)				;DE = Address of Text
		ld		d,(iy+20)		
		ld		hl,SyB_Dialog_Info_Text_1	
		
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_2
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_3
		call	SyB_Dialog_Text_Copier					
		
		ld		hl,SyB_Dialog_Info_1
		ld		a,(iy+13)
		And		%11
		ld		e,a
		push	iy
		ld		a,(appBnkNum)
		call	SySystem_SYSWRN
		
.SyB_Dialog_Control_Loop:
		call	SymStudio_App_Wait_Message	;**** See what Event has occurre
		jr		nc,SyB_Dialog_Control_Loop_0
		cp		157
		jr		nz,SyB_Dialog_Control_Loop_0
		ld		a,(Event_Form_ID)			;Position 1
		jp		SyB_Dialog_Control_Loop_2
		cp		0
		jp		nz,SyB_Dialog_Control_Loop_2
.SyB_Dialog_Control_Loop_0
		Xor		a
		ld		(V_App_In_Use),a
		jr		SyB_Dialog_Control_Loop
.SyB_Dialog_Control_Loop_2
		pop		iy
		ld		(iy+19),a
		ld		(iy+20),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;**** Copies Text from DE into HL ****
;**** C=Length left
.SyB_Dialog_Text_Copier		
		ld		b,31
.SyB_Dialog_Loop_1		
		ld		a,c
		Or		a
		jp		z,SyB_Dialog_Loop_2
		dec		c
		ld		a,(de)
		inc		de
		cp		"|"			
		jp		z,SyB_Dialog_Loop_2
		ld		(hl),a
		inc		hl
		dec		b
		djnz	SyB_Dialog_Loop_1
.SyB_Dialog_Loop_2
		Xor		a
		ld		(hl),a
		ret

;****  EXP   ****		
;**** Do EXP ****
;****        ****
.SyB_EXP
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_POT_E



;****     FOR STARTER       ****
;**** For Command (Integer) ****
;****                       ****
.SyB_ForStarter_Int
		ld		iy,(SyB_StackAddr)
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		
		ld		a,(iy+19)		
		ld		(de),a
		ld		(iy+19),e
		inc		de
		ld		a,(iy+20)
		ld		(de),a
		dec		de
		ld		(iy+20),d
		
		;**** Check What sort of step ****
		ld		a,(iy+8)
		bit		7,a
		jp		z,SyB_ForStarter_Int_2
		ld		(iy+21),1
		jp		(hl)
.SyB_ForStarter_Int_2:		
		ld		(iy+21),0
		jp		(hl)


;****         FOR           ****
;**** For Command (Integer) ****
;****                       ****
.SyB_For_Int
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(iy+21)
		And		a
		jp		z,SyB_For_Int_PositiveStep
		ex		de,hl
		Xor		a
.SyB_For_Int_PositiveStep		
		sbc		hl,de
		jp		c,SyB_ForInt_Exit		
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)
.SyB_ForInt_Exit
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy	
		jp		(hl)


;****      FILEPOS     ****
;**** FilePos Function ****
;****                  ****
.SyB_FilePos
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_FilePos_OK_1
		cp		174						;ReadFile
		jp		z,SyB_FilePos_OK_1
		cp		175						;WriteFile
		jp		z,SyB_FilePos_OK_1		
		;*** Failed
		ld		bc,0					;Stack Change
		ld		de,255					;Error Number
		jp		SyB_Mark_Error
.SyB_FilePos_OK_1:
		ld		bc,4
		add		hl,bc
		push	hl
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		pop		de
		ex		de,hl
		push	de
		ldi
		ldi
		ldi
		ldi
		pop		hl
		Xor		a
		call	FLO_KONV_LW_TO_FLO
		ret


;****     FILESIZE      ****
;**** FileSize Function ****
;****                   ****
.SyB_FileSize
		call	SyB_GetOpenAFile
		jp		c,SyB_FileSize_Fail_1
		push	af
		ld		iy,0
		ld		ix,0
		ld		c,2
		call	SyFile_FILPOI

		push	ix
		push	iy
		pop		de
		pop		bc
		ld		iy,(SyB_StackAddr)
		Xor		a
		ld		(iy+7),c
		ld		(iy+8),b
		ld		(iy+9),e
		ld		(iy+10),d
		ld		hl,(SyB_StackAddr)
		ld		bc,7		
		add		hl,bc
		call	FLO_KONV_LW_TO_FLO
		pop		af
		call	SyFile_FILCLO
		ret
.SyB_FileSize_Fail_1:
		ld		bc,0
		ld		e,a
		ld		d,1
		jp		SyB_Mark_Error
		

;****     FREEBANK      ****
;**** Free Bank Command ****
;****                   ****
.SyB_FreeBank
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		z,SyB_FreeBank_4
		cp		180					;Free Sheet
		jp		nz,SyB_FreeBank_3
	
.SyB_FreeBank_4		
		Xor		a
		ld		(hl),a
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl		
		rst 	#20:dw 	#811B
SyB_FreeBank_3
		ret		


;****          GARBAGE           ****
;**** Garbage Collection Command ****
;****                            ****
;See bottom of String Text Area

;****      GETSECOND     ****
;**** Function GetSecond ****
;****                    ****
.SyB_GetSecond
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	


;****      GETMINUTE     ****
;**** Function GetMinute ****
;****                    ****
.SyB_GetMinute
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),b
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****      GETHOUR     ****
;**** Function GetHour ****
;****                  ****
.SyB_GetHour
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),c
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret


;****      GETDAY     ****
;**** Function GetDay ****
;****                 ****
.SyB_GetDay
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****      GETMONTH     ****
;**** Function GetMonth ****
;****                   ****
.SyB_GetMonth
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),e
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy			
		ret


;****      GETYEAR      ****
;**** Function GetYear  ****
;****                   ****
.SyB_GetYear
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret



;****     GETOBJID      ****
;**** Function GetObjID ****
;****                   ****
.SyB_GetObjID
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+13)
		dec		a
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)
		ld		d,0	
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+0)
		ld		(iy+13),a
		ld		a,(ix+1)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****     GETOBJLEFT      ****
;**** Function GetObjLeft ****
;****                     ****
.SyB_GetObjLeft
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+6)
		ld		(iy+7),a
		ld		a,(ix+7)
		ld		(iy+8),a
		ret
	

;****      GETOBJTOP     ****
;**** Function GetObjTop ****
;****                    ****
.SyB_GetObjTop
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0		
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+8)
		ld		(iy+7),a
		ld		a,(ix+9)
		ld		(iy+8),a
		ret


;****      GETOBJWIDTH     ****
;**** Function GetObjWidth ****
;****                      ****
.SyB_GetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+10)
		ld		(iy+7),a
		ld		a,(ix+11)
		ld		(iy+8),a
		ret


;****      GETOBJHEIGHT     ****
;**** Function GetObjHeight ****
;****                       ****
.SyB_GetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+12)
		ld		(iy+7),a
		ld		a,(ix+13)
		ld		(iy+8),a
		ret

	
;****      GETOBJVISIBLE     ****
;**** Function GetObjVisible ****
;****                        ****
.SyB_GetObjVisible
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+2)
		And		%10000000
		jp		z,SyB_GetObjVisible_1
		Xor		a
		jp		SyB_GetObjVisible_2
.SyB_GetObjVisible_1		
		ld		a,1
.SyB_GetObjVisible_2		
		ld		(iy+7),a
		ld		(iy+8),0
		ret


;****      GETOBJTEXT     ****
;**** Function GetObjText ****
;****                     ****
.SyB_GetObjText
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		e,(ix+2)
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_GetObjText_Empty
		
		bit		7,a
		jp		z,SyB_GetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111
		jp		SyB_GetObjText_3
.SyB_GetObjText_2:
		push	ix
		pop		hl
.SyB_GetObjText_3:		
		ld		e,a
		ld		d,0
		add		hl,de	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		b,0
.SyB_GetObjText_5:			
		ld		a,(de)
		And		a
		jp		z,SyB_GetObjText_4
		ld		(hl),a
		inc		de
		inc		hl
		inc		b
		jr		SyB_GetObjText_5
.SyB_GetObjText_4:
		ld		(SyB_StrStackAddr),hl
		ld		(iy+9),b
		ret
.SyB_GetObjText_Empty:
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),0
		ret


.SyB_Obj_Text_Pointer:
		db			0					;0 - 
		db			0+128				;1 - Label
		db			0					;2 -
		db			0+128				;3 - Frame
		db			0					;4
		db			0					;5
		db			0+128				;6 - CtrLabel
		db			0					;7
		db			0					;8
		db			0					;9
		db			0					;10
		db			0					;11															
		db			0					;12
		db			0					;13
		db			0					;14
		db			0					;15
		db			4					;16 - Button
		db			2+128				;17 - Check
		db			2+128				;18 - Radio
		db			0					;19
		db			0					;20																
		db			0					;21	
		db			0					;22	
		db			0					;23	
		db			0					;24	
		db			0					;25	
		db			0					;26	
		db			0					;27	
		db			0					;28	
		db			0					;29
		db			0					;30	
		db			0					;31	
		db			0+128				;32 - Text Input										
																
;****       IF         ****
;**** Basic IF Command ****
;****                  ****
.SyB_IF
		ld		bc,7
		ld		hl,(SyB_StackAddr)
		add		hl,bc		
		Xor		a
		cp		(hl)					;7
		jr		nz,SyB_IF_2_1
		inc		hl
		cp		(hl)					;7
		jr		nz,SyB_IF_2
.SyB_IF_1								;So The result was False
		dec		hl
		dec		hl
		ld		(Syb_StackAddr),hl
		pop		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		jp		(hl)
.SyB_IF_2
		dec		hl
.SyB_IF_2_1		
		dec		hl
		ld		(Syb_StackAddr),hl
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)		
		

;****      LEFT     ****
;**** LEFT Function ****
;****               ****
.SyB_Left
		ld		ix,(SyB_StackAddr)
		ld		b,(ix+7)
		ld		a,(ix+15)				;Originals stack length
		sub		b
		ret		c
		ld		(ix+15),b
		ld		c,a
		ld		b,0
		Xor		a						;Sets no carry flag etc
		ld		hl,(SyB_StrStackAddr)
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret


;****  LEN   ****
;**** Do Len ****
;****        ****
.SyB_LEN
		ld		hl,(SyB_StackAddr)
		ld		bc,9
		add		hl,bc
		ld		c,(hl)
		dec		hl
		Xor		a
		ld		(hl),a
		dec		hl
		ld		(hl),c
		dec		hl
		ld		(hl),a
		ld		hl,(SyB_StrStackAddr)
		Xor		a
		ld		b,0
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ret
		

;****  LCASE$   ****
;**** Do LCASE$ ****
;****           ****
.SyB_LCase
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(iy+9)
		cp		0
		ret		z
		ld		b,a

.SyB_LCase_1
		ld		a,(hl)
		cp 		65
		jr		c,SyB_LCase_3
		cp		91
		jr		nc,SyB_LCase_3
		add		32
		ld		(hl),a
.SyB_LCase_3
		inc		hl
		djnz	SyB_LCase_1
		ret

;****     CREATESHEET      ****		
;**** CreateSheet Function ****		
;****
.SyB_CreateSheet:
		;Find slot in List
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,15							;Number of Banks Possible-1
		ld		de,8							;Bytes to jump (Each Bank Ref is 6 bytes)
		Xor		a								;A=0
.SyB_CreateSheetBank_1			
		cp		(hl)
		jr		z,SyB_LoadSheetBank_FoundSlot		;Until (hl)<>0		
		add		hl,de
		djnz	SyB_CreateSheetBank_1
		di
.ajf	jr		ajf		
		
;****       EXECUTE       ****		
;**** Execute External App ****		
;****
.SyB_Execute:
		ld		iy,(Syb_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(AppBnkNum)
		set		7,a
		call	SySystem_PRGRUN
		ld		iy,(Syb_StackAddr)
		ld		(iy+7),a
		xor 	a
		ld		(iy+8),a
		ret
	
;****     LOADSHEET      ****
;**** LoadSheet Function ****
;****                    ****
.SyB_LoadSheet:
		call	SyB_GetOpenAFile
		jp		c,SyB_LoadSheet_Fail_1
		ld		(SyB_LoadSheet_fileHandle),a
		;Find Length
		ld		iy,0
		ld		ix,0
		ld		c,2
		call	SyFile_FILPOI
		ld		(SyB_LoadSheet_fileLength),ix
		;Reset to Start
		ld		a,(SyB_LoadSheet_fileHandle)
		ld		ix,0
		ld		iy,0
		ld		c,0
		call	SyFile_FILPOI		
		;Find a Slot in Ram
		ld		bc,(SyB_LoadSheet_fileLength)
		Xor		a					;A = 0 - Look in any RamBank
		ld		e,1					;E = 1 - Look only in Data Areas
		rst 	#20:dw #8118
		jp		c,SyB_LoadSheet_Fail_2
		ld		(SyB_LoadSheet_fileBank),a
		ld		(SyB_LoadSheet_fileStart),hl
		;Find slot in List
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,15							;Number of Banks Possible-1
		ld		de,8							;Bytes to jump (Each Bank Ref is 6 bytes)
		Xor		a								;A=0
.SyB_LoadSheetBank_1			
		cp		(hl)
		jr		z,SyB_LoadSheetBank_FoundSlot		;Until (hl)<>0		
		add		hl,de
		djnz	SyB_LoadSheetBank_1
		jp		SyB_LoadSheet_Fail_1
.SyB_LoadSheetBank_FoundSlot
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		c,180
		ld		(hl),c					;180 Represents Sheet
		inc		hl
		ld		a,(SyB_LoadSheet_fileBank)
		ld		(hl),a					;Bank to Store
		inc		hl
		ld		de,(SyB_LoadSheet_fileStart)
		ld		(hl),e					;Where stored Low
		inc		hl
		ld		(hl),d					;Where Stored High
		inc		hl
		ld		bc,(SyB_LoadSheet_fileLength)
		ld		(hl),c					;Length
		inc		hl
		ld		(hl),b					;Length
		;Load Data into Slot
		
		push	ix
		push	iy
		ex		de,hl					;HL = Where
		ld		e,a						;E = Destination Bank
		ld		a,(SyB_LoadSheet_fileHandle)
		call	SyFile_FILINP
		;Close file
		ld		a,(SyB_LoadSheet_fileHandle)		
		call	SyFile_FILCLO
		pop		iy
		pop		ix
		
		;Get Number of Tiles
		ld		a,(SyB_LoadSheet_fileBank)
		ld		hl,(SyB_LoadSheet_fileStart)
		rst 	#20:dw #8124
		ld		(SyB_LoadSheet_fileTile),bc
		;Modify Addresses
.SyB_LoadSheetBank_MakeChanges
		Xor 	a
		cp		c
		jp		nz,SyB_LoadSheetBank_MakeChanges_2
		cp		b
		jp		z,SyB_LoadSheetBank_Finished
.SyB_LoadSheetBank_MakeChanges_2
		ld		a,(SyB_LoadSheet_fileBank)		
		push	hl
		push	hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,3					;We need Word 3/4 (Graphic Data Offset)
		add		hl,bc					;Adds 3
		push	hl						;Stores HL
		ld		bc,7					;Address we want to put in is +7 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 3/4 (Graphic Data Offset)
		rst 	#20:dw #8127			;Stores BC into (A HL)
		pop		hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,5					;We need Word 5/6 (Encode Data Byte Address)
		add		hl,bc					;Adds 5
		push	hl						;Stores HL
		ld		bc,4					;Address we want to put in is +4 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 5/6 (Encode Address)
		rst 	#20:dw #8127			;Stores BC into (A HL)		
		pop		hl
		inc		hl
		inc		hl
		ld		bc,(SyB_LoadSheet_fileTile)
		dec		bc
		ld		(SyB_LoadSheet_fileTile),bc
		jp		SyB_LoadSheetBank_MakeChanges
		;Done it
.SyB_LoadSheetBank_Finished		
		ret

.SyB_LoadSheet_Fail_1
		ld a,1
		nop
		nop
		di
.shee	jr		shee		
.SyB_LoadSheet_Fail_2				;**** Not enough Memory free
		di
.shee2	jr		shee2		

.SyB_LoadSheet_fileHandle:	db	0
.SyB_LoadSheet_fileLength:	dw	0
.SyB_LoadSheet_fileStart:	dw	0
.SyB_LoadSheet_fileBank:	db	0
.SyB_LoadSheet_fileTile:	dw	0

		

;****  LOG   ****		
;**** Do LOG ****
;****        ****
.SyB_LOG
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_NAT

		
;****  LOG10   ****		
;**** Do LOG10 ****
;****          ****
.SyB_LOG10
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_DEC


;****     MACHINE     ****
;**** Macine Function ****
;****                 ****
.SyB_Machine:
		ld 		hl,#8139
		rst 	#28
		ld		hl,SyB_Machine_TypeList
		ld		d,0
		add		hl,de
		ld		c,(hl)
		ld		hl,(SyB_StackAddr)
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),c
		inc		hl
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret
.SyB_Machine_TypeList:		db	0,1,1,2,2,2,2,2,2,2			;0=PCW 1=CPC 2=MSX


;****     MID$     ****
;**** Mid Function ****
;****              ****
.SyB_MID
		ld		ix,(SyB_StackAddr)
		ld		c,(ix+7)				;Length Required
		ld		a,(ix+13)				;From Where
		;Must check A (From Where)>0
		dec 	a
		ld		l,a
		ld		h,0
		ld		a,(ix+21)				;Originals stack length
		ld		e,(ix+19)
		ld		d,(ix+20)
		sub		l
		ld		b,a
		jp		c,SyB_MID_Empty
		add		hl,de
		Xor		a
		ld		(SyB_MidTemp),a

.SyB_MID_2	
		ld		a,(SyB_MidTemp)
		cp		b
		jr		z,SyB_MID_3
		cp		c
		jr		z,SyB_MID_3
		inc		a
		ld		(SyB_MidTemp),a
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		jr		SyB_MID_2
.SyB_MID_3	
		ld		e,(ix+19)
		ld		d,(ix+20)
		ld		l,a
		ld		h,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		jr		SyB_MID_4
.SyB_MID_Empty
		Xor		a
		ld		(ix+21),a
		ld		(SyB_StrStackAddr),de
.SyB_MID_4
		ld		(ix+21),a
		ld		hl,(SyB_StackAddr)
		ld		bc,12
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret	
.SyB_MidTemp		db	0
	

;****       MOD        ****
;**** Do Numerical MOD ****
;****                  ****
.SyB_INT_MOD:
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),e
		ld		(iy+14),d
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret



;****    MOUSEOVER       ****
;**** MouseOver Function ****
;****                    ****
.SyB_MouseOver:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		And		%1110
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		ld		bc,App_Form_List
		add		hl,bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		pop		ix
		;**** First bit		
		ld		e,(ix+4)
		ld		d,(ix+5)
		ld		l,(ix+12)
		ld		h,0
		add		hl,de
		ld		(SyB_MouseOver_X_Off),hl
		ld		e,(ix+6)
		ld		d,(ix+7)
		Xor		a
		ld		b,(ix+1)
		bit		4,b
		jp		z,SyB_MouseOver_90
		add		9
.SyB_MouseOver_90		
		bit		5,b
		jp		z,SyB_MouseOver_91
		add		9
.SyB_MouseOver_91
		ld		l,a
		ld		h,0
		add		hl,de
		ld		(SyB_MouseOver_Y_Off),hl		
		;**** Check if Item is in a Super Control
		ld		a,(iy+8)				;**** Upper Byte of ID
		And		%111
		jp		z,SyB_MouseOver_1
		;**** Do SUper control Offset gumph
		ld		l,(ix+36)
		ld		h,(ix+37)
		add		a
		add		a
		add		a
		add		a
		ld		e,a
		ld		d,0
		inc		hl
		push	hl
		add		hl,de
		ld		a,(hl)
		pop		hl
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl	
		add		hl,de
		push	hl
		pop		ix
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		hl,(SyB_MouseOver_X_Off)
		add		hl,de
		ld		(SyB_MouseOver_X_Off),hl
		ld		e,(ix+8)
		ld		d,(ix+9)
		ld		hl,(SyB_MouseOver_Y_Off)
		add		hl,de
		ld		(SyB_MouseOver_Y_Off),hl
		
;		di
;		ld		hl,(SyB_MouseOver_X_Off)
;		ld		de,(SyB_MouseOver_Y_Off)
;.drf	jr		drf		
		
			
.SyB_MouseOver_1		
		rst 	#20
		dw 		#813C
		push	hl						;Protect Y
		ld		hl,(SyB_MouseOver_X_Off)
		ex		de,hl
		Xor		a
		sbc		hl,de
		ld		(SyB_MouseOver_X_Off),hl
		pop		hl
		ld		de,(SyB_MouseOver_Y_Off)		
		Xor		a
		sbc		hl,de
		ld		(SyB_MouseOver_Y_Off),hl
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		de,(SyB_MouseOver_X_Off)
		ld		l,(ix+6)
		ld		h,(ix+7)
		push	hl
		Xor		a
		sbc		hl,de
		pop		hl
		jp		nc,SyB_MouseOver_1_Fail	
		ld		c,(ix+10)
		ld		b,(ix+11)
		add		hl,bc
		sbc		hl,de
		jp		c,SyB_MouseOver_1_Fail
		
		ld		de,(SyB_MouseOver_Y_Off)
		ld		l,(ix+8)
		ld		h,(ix+9)
		push	hl
		Xor		a
		sbc		hl,de
		pop		hl
		jp		nc,SyB_MouseOver_1_Fail	
		ld		c,(ix+12)
		ld		b,(ix+13)
		add		hl,bc
		sbc		hl,de
		jp		c,SyB_MouseOver_1_Fail			
		
		ld		(iy+7),1
		ld		(iy+8),0
		ret

.SyB_MouseOver_1_Fail:
		ld		(iy+7),0
		ld		(iy+8),0
		ret

.SyB_MouseOver_X_Off:	dw	0
.SyB_MouseOver_Y_Off:	dw	0



;****    MOUSEX       ****
;**** MouseX Function ****
;****                 ****
.SyB_MouseX:
		rst 	#20
		dw 		#813C	
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),e
		ld		(iy+2),d
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	


;****     MOUSEY      ****
;**** MouseY Function ****
;****                 ****
.SyB_MouseY:
		rst 	#20
		dw 		#813C
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	


;****     MOUSEKEY      ****
;**** MouseKey Function ****
;****                  ****
.SyB_MouseKey:
		rst 	#20
		dw 		#813F
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	


;****      MULTIPLY       ****
;**** Do Integer Multiply ****
;****                     ****
.SyB_INT_Mul
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB_INT_Mul_11		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_INT_Mul_11
		pop		de
		sbc		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

		
;****     MULTIPLY      ****
;**** Do Float Multiply ****
;****                   ****				
.SyB_FLO_Mul
		call	SyB2_STACK_2_FLO		
		call	FLO_MULT
		jp		SyB_DecStack



;****       NEG      ****
;**** Do Integer NEG ****
;****                ****
.SyB_Neg_Int
		ld		iy,(Syb_StackAddr)
.SyB_Neg_Int_10		
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret

		
;****     NEG      ****
;**** Do Float NEG ****
;****              ****
.SyB_Neg_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		Xor		128							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret


;****          NEXT              ****
;**** Command NEXT (For Integers ****
;****                            ****

.SyB_Next_INT
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		c,(iy+7)
		ld		b,(iy+8)
		ex		de,hl
		add		hl,bc
		ex		de,hl
		ld		(hl),d
		dec		hl
		ld		(hl),e	
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl		
		jp		(hl)


;****     NOT      ****
;**** NOT Function ****
;****              ****
.SyB_NOT
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)					
		And		a
		jr		nz,SyB_Not_2
		ld		a,(iy+8)
		And		a
		jr		nz,SyB_Not_2
		ld		(iy+7),1
		jr		SyB_Not_3
.SyB_Not_2		;**** Means <>0 SO Result = 0
		ld		(iy+7),0
.SyB_Not_3
		ld		(iy+8),0
		ret


;****     OPENDIALOG      ****
;**** OpenDialog function ****
;****                     ****
.SyB_OpenDialog:
		ld		a,(AppBnkNum)
		ld		(SyB_FileDialog_Extra),a
		jp		SyB_FileDialog



;****     OPENFILE      ****
;**** Openfile function ****
;****                   ****
.SyB_OpenFile:
		call	SyB_GetOpenAFile
		jp		c,SyB_OpenFile_Fail_1
.SyB_OpenFile_Ok_1
		ld		(SyB_OpenFile_Temp),a			;OS File Number
		call	SyB_FreeFileSlot		
		jp		c,SyB_OpenFile_Fail_2
.SyB_OpenFile_Ok_2
		ld		iy,(SyB_StackAddr)		
		ld		(iy+7),l
		ld		(iy+8),h
		push	hl
		pop		ix
		Xor		a
		ld		b,9
.SyB_OpenFile_Ok_20
		ld		(hl),a
		inc		hl
		djnz	SyB_OpenFile_Ok_20
		ld		(ix+0),173
		ld		a,(SyB_OpenFile_Temp)
		ld		(ix+3),a
		call	SyB_Read_512_Bytes
		ret
.SyB_OpenFile_Fail_1
		ld		e,a
		ld		d,1
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),0
		ld		(iy+8),0
		jp		SyB_Mark_Error
.SyB_OpenFile_Fail_2		
		ld		a,32
		jr		SyB_OpenFile_Fail_1
.SyB_OpenFile_Temp:		db	0		


;****     OPENFORM      ****
;**** Openform function ****
;****                   ****
.SyB_OpenForm:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		
		call	SyB_Studio_WindowOpen
		jp		c,SyB_OpenForm_2
		inc		a
.SyB_OpenForm_2
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		ld		(iy+8),0		
		ret
		

;****      OR       ****
;**** Do Integer OR ****
;****               ****
.SyB_INT_Or
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Or		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Or		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
			

;****     PEEKBYTE      ****
;**** Peek Byte Command ****
;****                   ****
.SyB_PeekByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekByte_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#812A
		ld		(iy+13),b
		ld		(iy+14),0
.SyB_PeekByte_1		
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekByte_2			
		Xor		a
		ld		(iy+7),a
		ld		(iy+8),a
		jp		SyB_PeekByte_1


;****     PEEKINT      ****
;**** Peek Int Command ****
;****                  ****
.SyB_PeekInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekInt_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
.SyB_PeekInt_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekInt_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		jp		SyB_PeekInt_1


;****     PEEKFLOAT      ****
;**** Peek Float Command ****
;****                    ****
.SyB_PeekFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekFloat_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de		
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
		rst 	#20
		dw		#8124
		ld		(iy+15),c
		ld		(iy+16),b
		rst 	#20
		dw		#812A
		ld		(iy+17),b		
.SyB_PeekFloat_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekFloat_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		ld		(iy+15),a
		ld		(iy+16),a
		ld		(iy+17),a
		jp		SyB_PeekFloat_1


;****     POKEBYTE      ****
;**** Poke Byte Command ****
;****                   ****
.SyB_PokeByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeByte_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		b,(iy+7)
		rst	 	#20
		dw 		#812D
.SyB_PokeByte_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret
		
		
;****     POKEFLOAT      ****
;**** Poke Float Command ****
;****                    ****
.SyB_PokeFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeFloat_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
		ld		c,(iy+9)
		ld		b,(iy+10)
		rst	 	#20
		dw 		#8127
		ld		b,(iy+11)		
		rst	 	#20
		dw 		#812D
.SyB_PokeFloat_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret			

		
;****     POKEINT      ****
;**** Poke Int Command ****
;****                  ****
.SyB_PokeInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeInt_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
.SyB_PokeInt_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret		


;****        RAD            ****
;**** RAD - Set Radian Mode ****
;****                       ****
.SyB_Rad:
		Xor		a
		ld		(FLO_VALUE_DEGRAD),a
		ret
	

;****     RAMFREE      ****
;**** RamFree Function ****			
;****                  ****
.SyB_RamFree
		ld hl,#8100			;SymBos Function
		rst #28
		ld		l,e
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamFree_1		
		add		hl,hl				;*2
		djnz	SyB_RamFree_1
		push	ix
		pop		de
		ld		a,d
		ld		d,0
		rra
		rra
		And		%111111
		ld		e,a
		add		hl,de
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	


;****     RAMSIZE      ****
;**** RamFree Function ****			
;****                  ****
.SyB_RamSize
		ld 		hl,#8100			;SymBos Function
		rst 	#28
		ld		l,d
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamSize_1		
		add		hl,hl				;*2
		djnz	SyB_RamSize_1
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret




;****                   ****
;**** Randomize Command ****
;****                   ****
.SyB_Randomize
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		call	FLO_RANDOMIZE
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc		
		ld		(SyB_StackAddr),hl
		ret


;****     REFRESHALL      ****
;**** Refresh All command ****
;****                     ****
.SyB_RefreshAll:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		e,255
		jp		SyDesktop_WINDIN


;****     REFRESHAREA      ****
;**** Refresh Area Command ****
;****                      ****
.SyB_RefreshArea
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		(AppMsgB+08),hl
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(AppMsgB+10),hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		(AppMsgB+6),hl
		ld		c,(iy+32)
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		l,(iy+25)
		ld		h,(iy+26)
		ld		e,(iy+31)
		ld		bc,30
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld 		c,MSC_DSK_WINPIN
        jp 		SyDesktop_SendMessage		


;****      REFRESHOBJ     ****
;**** Refresh Obj Command ****
;****                     ****

.SyB_RefreshObj
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		a,(iy+8)
		rra
		rra
		rra
		And		%111
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)		
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		SyDesktop_WINDIN

		


		

;****     SAVEDIALOG      ****
;**** SaveDialog function ****
;****                     ****
.SyB_SaveDialog:
		ld		a,(AppBnkNum)
		set		6,a
		ld		(SyB_FileDialog_Extra),a
		jp		SyB_FileDialog


;****     SCREENMODE      ****
;**** ScreenMode Function ****
;****                     ****
.SyB_ScreenMode:
		ld 		hl,#8139
		rst 	#28
		ld		hl,(SyB_StackAddr)
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret

.SyB_CreateDir

;****     SETOBJPOS     ****
;**** Command SetObjPos ****
;****                   ****
.SyB_SetObjPos
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+20)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+19)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		e,(iy+13)
		ld		d,(iy+14)
		ld		(ix+6),e
		ld		(ix+7),d
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+8),e
		ld		(ix+9),d
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;****  GETPAINTOBJPEN  ****
.SyB_GetPaintObjPen
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID	
		ld		e,(iy+7)				;**** Lower Byte of Id
		call	SyB_GrabIXDetails
	
		ld		a,(ix+2)	
		cp		0
		ret		nz
		
		ld		a,(ix+4)
		and		%1111
		ld		(iy+7),a
		xor		a
		ld		(iy+8),a
		ret
;****  SETPAINTOBJPEN  ****
.SyB_SetPaintObjPen
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)				;**** Upper Byte of ID	
		ld		e,(iy+13)				;**** Lower Byte of Id
		call	SyB_GrabIXDetails
		ld		a,(ix+2)	
		cp		0
		jr		nz,SyB_SetPaintObjPen2
		ld		iy,(Syb_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		a,%1111
		and		e
		ld		(ix+4),a
.SyB_SetPaintObjPen2
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		

.SyB_GrabIXDetails
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		d,0
		jp		SyB_ReturnFormDatainIX
		
;****     SETOBJWIDTH     ****
;**** Command SetObjWidth ****
;****                     ****
.SyB_SetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)				;**** Upper Byte of ID	
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		iy,(Syb_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+10),e
		ld		(ix+11),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****     SETOBJHEIGHT     ****
;**** Command SetObjHeight ****
;****                      ****
.SyB_SetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+12),e
		ld		(ix+13),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****     SETOBJTEXT     ****
;**** Command SetObjText ****
;****                    ****
.SyB_SetObjText:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX	
		ld		a,(ix+2)
		cp		32
		jp		z,SyB_SetObjText_Textline
		ld		e,a
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_SetObjText_Empty	
		bit		7,a
		jp		z,SyB_SetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111		
		jp		SyB_SetObjText_3
		
.SyB_SetObjText_2
		push	ix
		pop		hl
.SyB_SetObjText_3
		ld		e,a
		ld		d,0
		add		hl,de
.SyB_SetObjText_4		
		call	SyB_Str_Store_2_Ram
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
.SyB_SetObjText_Textline:		
		ld		l,(ix+4)
		ld		h,(ix+5)		
		push	hl
		pop		ix
		ld		a,(ix+10)
		ld		e,(iy+9)
		cp		e
		jp		nc,SyB_SetObjText_Textline_2
		ld		(iy+9),a
.SyB_SetObjText_Textline_2:		
		ld		a,(iy+9)
		ld		(ix+8),a
		jp		SyB_SetObjText_4
		
.SyB_SetObjText_Empty:
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret


;****     SETOBJVISIBLE     ****
;**** Command SetObjVisible ****
;****                       ****
.SyB_SetObjVisible
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+2)
		And		%111111
		ld		b,a
		ld		a,(iy+7)
		Or		a
		jp		z,SyB_SetObjVisible_1
		res		7,b
		jp		SyB_SetObjVisible_2
.SyB_SetObjVisible_1:
		set		7,b
.SyB_SetObjVisible_2	
		ld		(ix+2),b
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****     SETOBJGRAPHIC     ****
;**** SetObjGraphic Command ****
;****                       ****
.SyB_SetObjGraphic
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+20)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+19)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+2)
		ld		b,a
		and		%111111
		cp 		10
		jp		nz,SyB_SetObjGraphic_Finish			
		res		6,b
		ld		(ix+2),b

		ld		l,(iy+13)				;HL=Memory Bank Address
		ld		h,(iy+14)
		ld		a,(hl)
		cp		180
		jp		nz,SyB_SetObjGraphic_Finish		
		;**** So it is a Sheet File
		di
		inc		hl
		ld		a,(hl)
		ld		(ix+3),a				;New Bank for Extended Data
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)				;Get Tile wanted
		ld		h,(iy+8)	
		add		hl,hl					;*Multiply by two
		add		hl,de
		inc		hl
		inc		hl
		rst 	#20:dw #8124
		add		hl,bc
		ld		(ix+4),l
		ld		(ix+5),h
		ei
.SyB_SetObjGraphic_Finish
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****      SGN       ****
;**** Do Integer SGN ****
;****                ****
.SyB_Sgn_Int
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		nz
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret	


;****     SGN      ****
;**** Do Float SGN ****
;****              ****
.SyB_Sgn_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		set		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret	
	

;****      STR     ****
;**** Str Function ****
;****              ****
.SyB_Str
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		call	SyB_Str_2
		ld		ix,(SyB_StackAddr)
		ld		hl,(SyB_StrStackAddr)
		ld		(ix+6),5
		ld		(ix+7),l
		ld		(ix+8),h
		ld		(Syb_StrStackAddr),de
		ex		de,hl
		Xor		a
		sbc		hl,de
		ld		(ix+9),l
		ret
.SyB_Str_2
 		push	de
        ex		de,hl
        call 	dspget
        pop 	hl		
        jp 		dsptxt


;****      SUB       ****
;**** Do Integer Sub ****
;****                ****
.SyB_INT_Sub
		ld		iy,(SyB_StackAddr)
		Xor		a
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		sbc		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

		
;****     SUB      ****
;**** Do Float Sub ****
;****              ****
.SyB_FLO_Sub
		call	SyB2_STACK_2_FLO
		call	FLO_SUB
		jp		SyB_DecStack


;****   SQR  ****		
;**** Do SQR ****
;****        ****
.SyB_SQR
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SQR


;****   TAN  ****
;**** Do TAN ****
;****        ****
.SyB_TAN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_TAN


;****     TRIM      ****
;**** Trim Function ****
;****
.SyB_Trim 
;AFunction LTrim$($)
		ld		ix,(SyB_StackAddr)
		ld		a,(ix+9)
		Or		a
		ret		z
		ld		l,(ix+7)
		ld		h,(ix+8)
		
		ld		e,a				;This is the length
		ld		d,0
		ld		bc,0
.SyB_Trim_3		
		ld		a,(hl)
		cp		#20
		jp		nz,SyB_Trim_2
		inc		bc
		inc		hl
		inc		d
		dec		e
		jp		nz,SyB_Trim_3
.SyB_Trim_2
		ld		a,(ix+9)
		sub		d
		ld		(ix+9),a
		ld		c,a
		ld		b,0
		push	de
		ld		e,(ix+7)
		ld		d,(ix+8)
		Or		a
		jp		z,SyB_Trim_4
		ld		a,e
		cp		l
		jp		z,SyB_Trim_4
		ldir
.SyB_Trim_4		
		pop		de
		ld		c,d
		ld		b,0
		ld		hl,(SyB_StrStackAddr)
		Xor		a
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ret


;****   UCASE$  ****		
;**** Do UCASE$ ****
;****           ****
.SyB_UCase
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		b,(hl)	
		ex		de,hl
.SyB_UCase_1
		ld		a,(hl)
		cp 		97
		jr		c,SyB_UCase_3
		cp		123
		jr		nc,SyB_UCase_3
		sub		32
		ld		(hl),a
.SyB_UCase_3
		inc		hl
		djnz	SyB_UCase_1
		ret


;****     WRITEBYTE      ****
;**** WriteByte Function ****
;****                    ****
.SyB_WriteByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteByte_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteByte_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteByte_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
	

;****     WRITEFILE      ****
;**** Writefile function ****
;****                    ****
.SyB_WriteFile:
		call	SyB_GetNewFile
		jp		c,SyB_WriteFile_Fail_1
.SyB_WriteFile_Ok_1
		ld		b,a						;OS File Number
		call	SyB_FreeFileSlot		
		jp		c,SyB_WriteFile_Fail_1
.SyB_WriteFile_Ok_2
		ld		iy,(SyB_StackAddr)		
			
		ld		(iy+13),l
		ld		(iy+14),h		
		ld		a,175
		ld		(hl),a
		inc		hl
		Xor		a
		ld		(hl),a			;Set the Write to 0
		inc		hl
		ld		a,1
		ld		(hl),a			;Set Empty to 1
		inc		hl
		ld		(hl),b
		inc		hl
		Xor		a
		ld		b,6
.SyB_WriteFile_Ok_3
		ld		(hl),a
		inc		hl
		djnz	SyB_WriteFile_Ok_3
.SyB_WriteFile_Ok_4
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
.SyB_WriteFile_Fail_1
		ld		(iy+13),0
		ld		(iy+14),0
		jp		SyB_WriteFile_Ok_4



;****     WRITEFLOAT      ****
;**** WriteFloat Function ****
;****                     ****
.SyB_WriteFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteFloat_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteFloat_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteFloat_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+9)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)						
		ld		a,(iy+11)
		call	SyB_Write_Byte_To_File
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****     WRITEINT      ****
;**** WriteInt Function ****
;****                   ****
.SyB_WriteInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteInt_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteInt_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteInt_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		call	SyB_Write_Byte_To_File
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
	

;****     WRITELINE      ****
;**** WriteLine Function ****
;****                    ****
.SyB_WriteLine
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteLine_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteLine_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteLine_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		b,(iy+9)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		a,b
		And		a
		jp		z,SyB_WriteLine_OK_3	
.SyB_WriteLine_OK_2:
		ld		a,(de)	
		inc		de
		push	bc
		push	de
		call	SyB_Write_Byte_To_File
		pop		de
		pop		bc
		dec		b
		ld		a,b
		And		a
		jp		nz,SyB_WriteLine_OK_2
.SyB_WriteLine_OK_3:		
		ld		a,13
		call	SyB_Write_Byte_To_File		
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****      XOR       ****
;**** Do Integer XOR ****
;****               ****
.SyB_INT_Xor
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Xor		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Xor		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
	

;****************************************************************************************
;****************************************************************************************
;****************************************************************************************

;****                       ****
;**** 16 Bit Divide Routine ****
;****                       ****
.SyB_N_Div16:
		ex		de,hl           	; HL = DE \ HL
		ld		a,e             	; Division by zero?
		Or		d
		jr		nz,SyB_N_Div17      ; Continue of not
		ld		hl,0
		ld		de,0
		scf			            	; Set Carry to indicate an error
		ret
.SyB_N_Div17:
		ld		c,l             	; AC = HL
		ld		a,h
		ld		hl,0            	; HL = Modulus
		ld		b,16            	; 16-bit division
		Or		a               	; Start with carry reset
.SyB_N_Div18:
		rl		c               	; AC = AC * 2
		rla  	                	; (set Carry to bit 0)
		rl		l               	; HL = HL * 2
		rl		h               	; (reset Carry again (HL = 0))
		push	hl
		sbc		hl,de
		ccf                     	; Carry set when Ok
		jr		c,SyB_N_Div19       ; Modulus cannot be >= Value
		ex		(sp),hl         	; Restore Modulus
.SyB_N_Div19:
		inc		SP              	; Get Modulus from Stack
        inc		SP
		djnz 	SyB_N_Div18         ; Repeat for all bits
; Shift last Carry-bit to divider
		ex		de,hl           	; DE = Modulus
		rl		c               	; Carry to C
		ld		l,c             	; HL = AC
		rla
		ld		h,a
		Or		a               	; Reset Carry (valid result)
		ret


;**** Converts the Stack from a Float to Integer Value
;**** Depending on What Stack needs to be adjusted *****
.SyB_FLO_2_INT_Stack_1
		ld		bc,7
		jp		SyB_FLO_2_INT_BC

.SyB_FLO_2_INT_Stack_2
		ld		bc,13
		jp		SyB_FLO_2_INT_BC

.SyB_FLO_2_INT_Stack_3
		ld		bc,19
		jp		SyB_FLO_2_INT_BC

.SyB_FLO_2_INT_Stack_4
		ld		bc,25
		jp		SyB_FLO_2_INT_BC

.SyB_FLO_2_INT_Stack_5
		ld		bc,31
		jp		SyB_FLO_2_INT_BC

.SyB_FLO_2_INT_Stack_6
		ld		bc,37
		jp		SyB_FLO_2_INT_BC

.SyB_FLO_2_INT_Stack_7
		ld		bc,43
		jp		SyB_FLO_2_INT_BC		

.SyB_FLO_2_INT_Stack_8
		ld		bc,49
		jp		SyB_FLO_2_INT_BC

;**** Converts the Stack from a Float to Integer Value
.SyB_FLO_2_INT_BC
		ld		hl,(SyB_StackAddr)
		add		hl,bc
.SyB_FLO_2_INT_XTRA		
		push	hl
		call	FLO_ROUND_FLO_TO_HLA
		bit		7,a
		jr		z,SyB_FLO_2_INT_2
		ld		a,l
		Xor		255
		ld		l,a
		ld		a,h
		Xor		255
		ld		h,a
		inc		hl
.SyB_FLO_2_INT_2
		ex		de,hl
		pop		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret
		

;****                                     ****
;**** Returns HL as Start of Form & ID No ****
;****                                     ****
.SyB_ReturnFormDatainIX
		add		hl,hl
		ld		bc,ControWindowDataList
		add		hl,bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl		
		add		hl,hl			;*2
		add		hl,hl			;*4
		add		hl,hl			;*8
		add		hl,hl			;*16
		add		hl,bc
		push	hl
		pop		ix
		ret	


;****                          ****
;**** Find Empty Slot for File ****
;****                          ****
.SyB_FreeFileSlot
		Xor		a
		ld		hl,(SyB_File_Data_Buffer_1)
		cp		(hl)
		ret		z
		ld		hl,(SyB_File_Data_Buffer_2)
		cp		(hl)
		ret		z
		ld		hl,(SyB_File_Data_Buffer_3)
		cp		(hl)
		ret		z
		ld		hl,(SyB_File_Data_Buffer_4)
		cp		(hl)
		ret		z
		scf
		ret


;****                                        ****
;**** Return A file - With Carry set if Fail ****
;****                                        ****
.SyB_GetOpenAFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)					;Start of String
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		a,(iy+9)					;Length
		
		And		a							;If Length Zero
		jp		z,SyB_GetOpenAFile_Fail		;So Fail if zero
		ld		b,0	
		ld		de,(SyB_File_Name_Input)	;DE=Filename/Path		
		ld		c,a							;c=length
		ldir								;repeat
		Xor		a							;put a zero ender in the string
		ld		(de),a						;
		ld		a,(appBnkNum)
		ld		hl,(SyB_File_Name_Input)
		db		#DD,#67
		call	SyFile_FILOPN
		jr		nc,SyB_GetOpenAFile_Ok
		;**** Okay it failed ****
.SyB_GetOpenAFile_Fail:
		scf
.SyB_GetOpenAFile_Ok:		
		ret


;****                                            ****
;**** Return A New File - With Carry Set if Fail ****
;****                                            ****
.SyB_GetNewFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		(SyB_StrStackAddr),hl
		ld		a,(iy+15)
		And		a
		jp		z,SyB_GetNewFile_Fail		;So Fail if zero
		ld		b,0	
		ld		de,(SyB_File_Name_Input)	;DE=Filename/Path		
		ld		c,a						;c=length
		ldir							;repeat
		Xor		a						;put a zero ender in the string
		ld		(de),a					;
		ld		a,(appBnkNum)
		ld		hl,(SyB_File_Name_Input)
		db		#DD,#67
		ld		a,(iy+7)
		And		%100111
		call	SyFile_FILNEW		
		jr		nc,SyB_GetNewFile_Ok
		;**** Okay it failed ****
.SyB_GetNewFile_Fail:
		scf
.SyB_GetNewFile_Ok:		
		ret
		
			

;**** File Thing is
;**** 0 -
;**** 1 - Write Byte set?
;**** 2 -
;**** 3 -
;**** 4 - File Pos Addr 1
;**** 5 - File Pos Addr 2
;**** 6 - File Pos Addr 3
;**** 7 - File Pos Addr 4
;**** 8 - Segment Length 1
;**** 9 - Segment Length 2

;****                                ****
;**** Write a byte to an opened file ****
;****                                ****
.SyB_Write_Byte_To_File
		ld		(ix+1),1					;*** Set Writing Byte
		push	ix						
		pop		hl							;*** HL=IX
		ld		bc,10
		add		hl,bc						;*** HL=IX+10
		ld		e,(ix+4)
		ld		d,(ix+5)
		add		hl,de
		ld		(hl),a						;**** Has copied in proper Position
		;**** Check if 511
		ld		a,e
		cp		255
		jp		nz,SyB_Write_Byte_To_File_2
		ld		a,d
		And		%1
		jp		nz,SyB_Write_Byte_To_File_2
		;So is a save time!
		call	SyB_Write_512_Bytes
;**** Definately not saving (not 511)		
.SyB_Write_Byte_To_File_2
		push	ix
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		ix,1
		ld		iy,0
		call	SyB_Math_Add32
		pop		ix
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		;**** Check FilePos against Length
		ld		a,h
		And		%1
		ld		h,a
		ld		e,(ix+8)
		ld		d,(ix+9)
		Xor 	a
		push	hl
		sbc		hl,de
		pop		hl
		jp		nc,SyB_Write_Byte_To_File_4
		ret
.SyB_Write_Byte_To_File_4	
		ld		(ix+8),l
		ld		(ix+9),h
		ret
		


	

;****                                   ****
;**** Return a byte from an opened file ****
;****                                   ****
;Input IX = File Data 
.SyB_Read_BFF
		;**** Lets get the Byte reading ****
		ld		l,(ix+4)
		ld		a,(ix+5)
		And		%1
		ld		h,a
		
		ld		e,(ix+8)
		ld		d,(ix+9)
		push	hl
		sbc		hl,de
		pop		hl
		jp		nc,SyB_Read_Eof
		
		push	ix
		pop		de
		add		hl,de
		ld		bc,10
		add		hl,bc
		ld		a,(hl)
		ld		(SyB_Read_Byte_From_File_Byte),a
		;**** Lets add 1 to filepointer ****
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		push	ix
		ld		ix,1
		ld		iy,0				
		call	SyB_Math_Add32
		pop		ix		
			
		Xor		a
		cp		l
		jp		nz,SyB_Read_BFF_3
		ld		a,h
		And		%1
		jp		nz,SyB_Read_BFF_3
		;**** Check if we need to write the old stuff
		push	hl
		push	de
		ld		a,(ix+1)
		cp		1
		jp		nz,SyB_Read_BFF_99
		call	SyB_Write_512_Bytes
.SyB_Read_BFF_99		
		call	SyB_Read_512_Bytes
		pop		de
		pop		hl		
		
.SyB_Read_BFF_3
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		ld		a,(SyB_Read_Byte_From_File_Byte)
		ret
.SyB_Read_Byte_From_File_Byte:		db 	0

.SyB_Read_Eof
		ld		a,0	
		ret	


;IX=Address of File Data Header
.SyB_Write_512_Bytes
		;**** First must reset File Pointer 
		ld		a,(ix+5)				;Get Pointer down to last 512
		And		%11111110
		ld		b,a
		ld		c,0
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		a,(ix+3)
		push	ix
		ld		c,0						;C=0 FileBegin
		push	bc
		push	de
		pop		iy
		pop		ix
		call	SyFile_FILPOI
		pop		ix
		;**** Back to save
		push	ix
		pop		hl
		ld		bc,10
		add		hl,bc					;HL = Start of Data
		ld		(ix+1),0				;Set write Byte to Zero
		ld		a,(AppBnkNum)
		ld		e,a						;E = Ram Bank
		ld		a,(ix+3)				;A = OS Reference
		ld		c,(ix+8)				;BC = Length to write
		ld		b,(ix+9)
		push	ix
		push	bc
		push	ix
		call	SyFile_FILOUT
		pop		ix
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		pop		ix						;IX = BC
		ld		iy,0
		call	SyB_Math_Add32
		pop		ix
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		ld		(ix+8),0
		ld		(ix+9),0
		ret
	

;****                                    ****
;**** Get 512bytes (or whatever) of file ****
;****                                    ****
;IX = Start of file Data
.SyB_Read_512_Bytes
		push	ix
		pop		hl
		ld		bc,10
		add		hl,bc
		ld		a,(AppBnkNum)
		ld		e,a
		ld		a,(ix+3)
		ld		bc,512
		push	ix
		call	SyFile_FILINP
		pop		ix
		ld		(ix+1),0
		ld		(ix+8),c
		ld		(ix+9),b
		ret



;****     OPENDIALOG      ****
;**** OpenDialog function ****
;****                     ****
.SyB_FileDialog:
		ld		iy,(SyB_StackAddr)
		;**** copy "*  ",0 into file area 
		ld		hl,SyB_FileDialog_Data
		ld		bc,4
		ld		de,(SyB_File_Dialog_Pointer)
		ldir
		push	de
		;**** oopy real stuff
		ld		l,(iy+13)
		ld		h,(iy+14)		
		ld		a,(iy+15)
		And		a
		jp		z,SyB_FileDialog_1
		ld		de,(SyB_File_Dialog_Pointer)		
		cp		3
		jp		c,SyB_FileDialog_2
		ld		a,3
.SyB_FileDialog_2:
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_1:		
		pop		de
		ld		l,(iy+19)
		ld		h,(iy+20)		
		ld		a,(iy+21)
		ld		(SyB_StrStackAddr),hl			;Reset to begining
		And		a
		jp		z,SyB_FileDialog_3
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_3:
		Xor		a
		ld		(de),a
		ld		hl,(SyB_File_Dialog_Pointer)		
		ld		a,(SyB_FileDialog_Extra)
		ld		c,(iy+7)	
		
		ld		ix,128
		ld		iy,6000
;		ld		de,Form1_ControlWindow
		call	SySystem_SELOPN
		ld		iy,(SyB_StackAddr)
		And		a
		jp		nz,SyB_FileDialog_Fail
		ld		hl,(SyB_File_Dialog_Pointer)
		ld		bc,4
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		b,0
.SyB_FileDialog_4:
		ld		a,(hl)
		And		a
		jp		z,SyB_FileDialog_5
		ld		(de),a
		inc		hl
		inc		de
		inc		b
		jr		SyB_FileDialog_4
.SyB_FileDialog_5:
		ld		(iy+21),b
		ld		(SyB_StrStackAddr),de
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_FileDialog_Fail:
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		(iy+21),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret				
SyB_FileDialog_Data:	db "*  ",0
SyB_FileDialog_Extra:	db	0



.SyB_Math_Add32
;*************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				push    ix
                pop     bc
                add     hl,bc
                ex      de,hl
                push    iy
                pop     bc
                adc     hl,bc
                ex      de,hl
                ret
;************************************


;****            ****
;**** Mark Error ****
;****            ****
;DE = Error Number
.SyB_Mark_Error
		ld		(ErrorNum),de
		pop		hl						;Gets Return Stack
		ld		(ErrorPC),hl
		ld		a,d
		cp		8
		jp		c,SyB_Mark_Error_1
		di
.SyB_Mark_Error_2		
		jr		.SyB_Mark_Error_2
.SyB_Mark_Error_1
		jp		(hl)
		

;*************************************************
;*********** PUSHING VALUES TO STACK *************
;*************************************************

;****                          ****
;**** Push Var Byte onto Stack ****
;****                          ****
.SyB_Push_V_Byt
		pop		hl							;10
		ld		e,(hl)						;7
		inc		hl							;6
		ld		d,(hl)						;7
		inc		hl							;6
		ld		a,(de)						;7
		exx									;4
		ld		hl,(SyB_StackAddr)			;16
		inc		hl							;6
		ld		(hl),a						;7
		inc		hl							;6
		Xor		a							;7
		ld		(hl),a						;7
		ld		bc,-8						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		exx									;4
		jp		(hl)
		

;****                        ****
;**** Push HL INT onto Stack ****
;****                        ****
.SyB_Push_V_Int_Direct
		ex		de,hl					;4
		ld		hl,(SyB_StackAddr)		;16
		inc		hl						;6
		ld		(hl),e					;7
		inc		hl						;6
		ld		(hl),d					;7
		ld		bc,-8					;16
		add		hl,bc					;11
		ld		(SyB_StackAddr),hl		;16
		ret								;10


;****                           ****
;**** Push INT Array onto Stack ****
;****                           ****
;DE = Array Address + 2
.SyB_Push_V_Int_Array_1_Direct
		ld		ix,(SyB_StackAddr)
		ld		l,(ix+7)
		ld		h,(ix+8)
		add		hl,hl					;**** Times 2
		add		hl,de
		ld		a,(hl)
		ld		(ix+7),a
		inc		hl
		ld		a,(hl)
		ld		(ix+8),a
		ret


;****                           ****
;**** Push FLO Array onto Stack ****
;****                           ****
;DE = Array Address + 2
.SyB_Push_V_Flo_Array_1_Direct
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		push	hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ld		l,c
		ld		h,b
		add		hl,hl
		add		hl,hl
		add		hl,bc
		add		hl,de
		pop		de
		ldi
		ldi
		ldi
		ldi
		ldi
		ret
		

;****                                 ****
;**** Push Numeric Integer onto Stack ****
;****                                 ****		
.SyB_Push_N_Int
		pop		hl							;11
		ld		de,(SyB_StackAddr)			;20 ;**** Get Address of Data Stack		
		inc		de							;6	;**** Modes up Stack 1
		ldi									;16	;**** Copies (HL)-(DE)
		ldi									;16	;**** Copies (HL)-(DE)
		ex		de,hl
		ld		hl,(SyB_StackAddr)			;16
		ld		bc,-6						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		ex		de,hl						;4
		jp		(hl)						;4		
		

;****                              ****
;**** PUSH 1 Onto Stack as Integer ****
;****                              ****		
.SyB_Push_Int_1
		ld		iy,(SyB_StackAddr)
		ld		bc,-6
		add		iy,bc
		ld		(iy+7),1
		ld		(iy+8),0
		ld		(SyB_StackAddr),iy
		ret


;****                            ****
;**** PUSH 1 Onto Stack as Float ****
;****                            ****	
.SyB_Push_Flo_1
		ld		iy,(SyB_StackAddr)
		ld		bc,-6
		add		iy,bc
		ld		(iy+7),0
		ld		(iy+8),0
		ld		(iy+9),0
		ld		(iy+10),0
		ld		(iy+11),#81		
		ld		(SyB_StackAddr),iy
		ret


;****                              ****
;**** Push Null Integer onto stack ****
;****                              ****
.SyB_Push_Null_Int
		Xor		a
		ld		hl,(SyB_StackAddr)
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		ld		bc,-8						;16
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16				
		ret
		

;****                                    ****
;**** Pushes Double Int Array onto Stack ****
;****                                    ****
.SyB_Push_V_Int_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl				;HL = Start of Array
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Skip multiple
		inc		hl					;HL= Start of Array Data
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ex		de,hl	
		push	hl
		push	hl
		pop		bc
.SyB_Push_V_Int_Array_2_Mul_2
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_Push_V_Int_Array_2_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,hl				;**** Times 2
		pop		de
		add		hl,de
		pop		de
		add		hl,de
		ld		a,(hl)
		ld		(iy+13),a
		inc		hl
		ld		a,(hl)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****                                      ****
;**** Pushes Double Float Array onto Stack ****
;****                                      ****
.SyB_Push_V_Flo_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl				;HL = Start of Array
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Skip multiple
		inc		hl					;HL= Start of Array Data
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ex		de,hl	
		push	hl
		push	hl
		pop		bc
.SyB_Push_V_Flo_Array_2_Mul_2
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_Push_V_Flo_Array_2_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc				;**** Times 5
		pop		de
		add		hl,de
		pop		de
		add		hl,de
		ld		a,(hl)
		ld		(iy+13),a
		inc		hl
		ld		a,(hl)
		ld		(iy+14),a
		inc		hl
		ld		a,(hl)
		ld		(iy+15),a
		inc		hl
		ld		a,(hl)
		ld		(iy+16),a
		inc		hl
		ld		a,(hl)
		ld		(iy+17),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret






;**************************************************
;*********** TAKING VALUES FROM STACK *************
;**************************************************
;****                                  ****
;**** Function Pass from Stack to Vars ****
;****                                  ****
.SyB_Function_Pass:
		pop		hl								;Get contents after Call
		ld		b,(hl)							;Number of Parameters to pass
		inc		hl
		ld		iy,(SyB_StackAddr)
.SyB_Function_Pass_1:
		push	bc
		ld		a,(hl)							;Type
		inc		hl
		cp		5
		jp		z,SyB_Function_Pass_Str
		cp		1
		jp		z,SyB_Function_Pass_Int
		cp		3
		jp		z,SyB_Function_Pass_Float
.SyB_Function_Pass_2:
		ld		de,6
		add		iy,de
		pop		bc
		dec		b
		jp		nz,SyB_Function_Pass_1
		ld		(SyB_StackAddr),iy
		jp		(hl)
.SyB_Function_Pass_Int:
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		a,(iy+7)		
		ld		(de),a
		inc		de
		ld		a,(iy+8)
		ld		(de),a
		jp		SyB_Function_Pass_2
.SyB_Function_Pass_Float:
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		a,(iy+7)
		ld		(de),a
		inc		de
		ld		a,(iy+8)
		ld		(de),a
		inc		de
		ld		a,(iy+9)
		ld		(de),a
		inc		de
		ld		a,(iy+10)
		ld		(de),a				
		inc		de
		ld		a,(iy+11)
		ld		(de),a		
		jp		SyB_Function_Pass_2		
.SyB_Function_Pass_Str
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl
		ex		de,hl
		call	SyB_Str_Store_2_Ram
		pop		hl
		jp		SyB_Function_Pass_2


;****                         ****
;**** Store a Byte from Stack ****
;****                         ****
.SyB_Store_Byt
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		inc		hl
		ldi
		ret

.SyB_Store_Int_Direct_Adder
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push 	de
		ex		de,hl
		ld		e,(hl)	
		inc		hl
		ld		d,(hl)
		ex		de,hl
		add		hl,bc
		ex		de,hl
		pop		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret	
;****                             ****
;**** Store an Integer from Stack ****
;****                             ****
;DE=Address to Store
.SyB_Store_Int_Direct
		ld		hl,(SyB_StackAddr)						;16
		ld		bc,6									;10
		add		hl,bc									;11
		ld		(SyB_StackAddr),hl						;16
		inc		hl										;6
		ldi												;16
		ldi												;16
		ret												;10				101

;****                        ****
;**** Takes Float from Stack ****
;****                        ****
.SyB_Store_Flo
		pop		hl						;Return Address
		ld		e,(hl)								
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		inc		hl
		ldi
		ldi
		ldi
		ldi
		ldi
		ret		


;****                                     ****
;**** Takes Single Array Float from Stack ****
;****                                     ****
.SyB_Store_Flo_Array_1
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		inc		de					;Stores Dimension data Ignore
		inc		de					;
		ld		hl,(SyB_StackAddr)
		ld		bc,13
		add		hl,bc
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc
		add		hl,de
		ex		de,hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		inc		hl
		ldi
		ldi
		ldi
		ldi
		ldi
		ld		(SyB_StackAddr),hl
		ret


;****                                     ****
;**** Takes Double Array Float from Stack ****
;****                                     ****
.SyB_Store_Flo_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl				;HL = Start of Array
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Skip multiple
		inc		hl					;HL= Start of Array Data
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB_Store_Flo_Array_Mul_2	
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_Store_Flo_Array_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc				;**** Times 5
		pop		de
		add		hl,de
		pop		de
		add		hl,de	
		ld		a,(iy+7)
		ld		(hl),a
		inc		hl
		ld		a,(iy+8)
		ld		(hl),a
		inc		hl
		ld		a,(iy+9)
		ld		(hl),a
		inc		hl
		ld		a,(iy+10)
		ld		(hl),a
		inc		hl
		ld		a,(iy+11)
		ld		(hl),a
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****                                   ****
;**** Takes Single Array Int from Stack ****
;****                                   ****
;DE=Base Address of Array +2 (To Skip over word)
.SyB_Store_Int_Array_1_Direct
		ld		iy,(Syb_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,hl
		add		hl,de
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;****                                   ****
;**** Takes Double Array Int from Stack ****
;****                                   ****
.SyB_Store_Int_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB2_Store_Int_Array_Mul_2	
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB2_Store_Int_Array_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		add		hl,hl				;**** Times 2
		pop		de
		add		hl,de
		pop		de
		add		hl,de	
		ld		a,(iy+7)
		ld		(hl),a
		inc		hl
		ld		a,(iy+8)
		ld		(hl),a
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


;		ex		de,hl
;		push	hl
;		push	hl
;		pop		bc
;.SyB_INT_Mul_11		
;		add		hl,de
;		dec		bc
;		ld		a,b
;		Or		c
;		jr		nz,SyB_INT_Mul_11
;		pop		de
;		sbc		hl,de



;*************************************************
;************** STRING ROUTINES ******************
;*************************************************

;****                                           ****
;**** Push String from Memory onto String Stack ****
;****                                           ****
.SyB_Push_N_Str
		pop		hl
		ld		a,(hl)
		inc		hl
		ld		iy,(SyB_StackAddr)
		ld		de,(SyB_StrStackAddr)
		ld		(iy+1),e
		ld		(iy+2),d
		ld		(iy+3),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		And		a
		jp		z,SyB_Push_N_Str_Finish
		ld		c,a
		ld		b,0
		ldir
		ld		(SyB_StrStackAddr),de
.SyB_Push_N_Str_Finish	
		jp		(hl)


;****                                         ****
;**** Push String Var Array onto String Stack ****
;****                                         ****
.SyB_Push_V_Str_Array_1
		pop		ix							;Return Adress holds Variable Loc
		ld		l,(ix+0)
		ld		h,(ix+1)					;HL=Variable
		inc		ix
		inc		ix							;IX Skip 
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)					;DE=Array value
		ld		d,(iy+8)		
		inc		hl							;Skip HL Over 
		inc		hl
		add		hl,de
		add		hl,de						;Add together to get String Pointer Address
		ld		e,(hl)
		inc		hl
		ld		d,(hl)						
		ex		de,hl						;HL=Address of string
		
		dec		hl							;Step Back 1 to Length
		ld		c,(hl)						;Move back to start of Text
		inc		hl
		ld		de,(SyB_StrStackAddr)		;Last Piece of String on Stack
		ld		b,0							;BC=Length to loop down
		;ld		(iy+6),5
		ld		(iy+7),e					;Stack = String Stack location
		ld		(iy+8),d					;ditto
		ld		(iy+9),c					;Stack = String Length
		Xor		a
		cp		c			
		jp		z,SyB_Push_V_Str_Array_1_1	;Do nothing if zero
		ldir								;Copy info to String Stack
		ld		(SyB_StrStackAddr),de		;Update new String Stack 
.SyB_Push_V_Str_Array_1_1
		jp		(ix)


;****                                                ****
;**** Push String Var Double Array onto String Stack ****
;****                                                ****
.SyB_Push_V_Str_Array_2
		pop		ix						;**** Holds Variable
		ld		l,(ix+0)				;HL=Variable Address
		ld		h,(ix+1)
		ld		e,(hl)					;DE=Array size
		inc		hl
		ld		d,(hl)
		inc		hl		
		push	hl
		

		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)				;**** Get the Second Stacked Integer
		ld		h,(iy+8)				;				
		;****  	Multiply shit ****
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB2_Store_Str_Array_Mul_2		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB2_Store_Str_Array_Mul_2
		pop		de
		sbc		hl,de
		ex		de,hl
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,hl
		add		hl,de
		pop		de
		add		hl,de
		inc		ix
		inc		ix
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl		
		dec		hl							;Step Back 1 to Length
		ld		c,(hl)						;Move back to start of Text
		inc		hl
			
		ld		de,(SyB_StrStackAddr)		;Last Piece of String on Stack
		ld		b,0							;BC=Length to loop down
		;ld		(iy+6),5
		ld		(iy+13),e					;Stack = String Stack location
		ld		(iy+14),d					;ditto
		ld		(iy+15),c					;Stack = String Length
		Xor		a
		cp		c			
		jp		z,SyB_Push_V_Str_Array_2_1	;Do nothing if zero
		ldir								;Copy info to String Stack
		ld		(SyB_StrStackAddr),de		;Update new String Stack 
.SyB_Push_V_Str_Array_2_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)



;****                      ****
;**** Stores String to Ram ****
;****                      ****
.SyB_Store_Str
		pop		ix
		ld		iy,(SyB_StackAddr)
		ld		l,(ix+0)
		ld		h,(ix+1)
		inc		ix
		inc		ix	
		call	SyB_Str_Store_2_Ram
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)




;****                                   ****
;**** Stores Single Array String to Ram ****
;****                                   ****
.SyB_Store_Str_Array_1
		pop		ix
		ld		l,(ix+0)
		ld		h,(ix+1)
		inc		hl
		inc		hl
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+13)
		ld		d,(iy+14)
		add		hl,de
		add		hl,de
		inc		ix
		inx		ix
		call	SyB_Str_Store_2_Ram
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)


;****                                   ****
;**** Stores Double Array String to Ram ****
;****                                   ****
.SyB_Store_Str_Array_2
		pop		ix						;**** Holds Variable
		ld		l,(ix+0)				;HL=Variable Address
		ld		h,(ix+1)
		ld		e,(hl)					;DE=Array size
		inc		hl
		ld		d,(hl)
		inc		hl		
		push	hl
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)				;**** Get the Second Stacked Integer
		ld		h,(iy+14)				;
		;****  	Multiply shit ****
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB2_Store_Str_Array_Mul		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB2_Store_Str_Array_Mul
		pop		de
		sbc		hl,de
		ex		de,hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		add		hl,hl
		add		hl,de
		pop		de
		add		hl,de
		inc		ix
		inc		ix	
		call	SyB_Str_Store_2_Ram
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)		


;****                     ****
;**** SyB_Str_Store_2_Ram ****
;****                     ****
.SyB_Str_Store_2_Ram		
		ld		(SyB_Where_Pointer_2),hl	
		ld		e,(hl)					;
		inc		hl
		ld		d,(hl)
		ex		de,hl
		dec		hl
		ld		a,(hl)					;Length of Existing Text
		ld		c,(iy+9)				;Length of Text on Stack

		cp		c
		jp		c,SyB_SSN
		;Length shorter or same
		ld		(hl),c
		inc		hl
		sub		c							;A=Remainder
		ld		e,(iy+7)					;HL=Location of Stack Text
		ld		d,(iy+8)
		ld		(SyB_StrStackAddr),de		;Stores the decreased String Stack Pointer Address		
		ex		de,hl
		ld		(SyB_Store_Char_Temp),a
		Xor		a
		cp		c
		jr		z,SyB_SS2R_1
		ld		b,0
		ldir
.SyB_SS2R_1
		ld		a,(SyB_Store_Char_Temp)
		And		a
		jr		z,SyB_SS2R_2
		ld		b,a
		Xor		a
.SyB_SS2R_3
		ld		(de),a
		inc		de
		djnz	SyB_SS2R_3
.SyB_SS2R_2
		Xor		a
		ld		(de),a
		ret
		
;**** New Placement Store
.SyB_SSN
		dec		hl							;Move to High Pointer
		Xor		a							;Clear A
		ld		(hl),a						;(HL) = 0 (Or High pointer is zero)
		dec		hl							;Move to Low Pointer
		ld		a,1							;A=1
		ld		(hl),a						;(HL)= 1 - So address is 1, 0, Length

		ld		de,(SyB_StringTopAddr)		;HL = Top Of Text Address
		ld		l,c
		ld		h,0
		add		hl,de
		ld		de,SyB_StringTopMem
		Xor		a
		sbc		hl,de
		jp		c,SyB_SSN_2
		call	SyB_Garbage
.SyB_SSN_2		
		ld		b,0
		;Copy from stack to New Position		
		ld		de,(SyB_Where_Pointer_2)	;DE = Pointer Address		
		ld		hl,(SyB_StringTopAddr)		;HL = Top Of Text Address
		ld		(hl),e						;Feed Low Byte of Pointer onto Text Stack
		inc		hl
		ld		(hl),d						;Feed Hi Byte of Pointer onto Text Stack
		inc		hl
		ld		(hl),c						;Feed New Length onto Text Stack
		inc		hl
		;HL = Start of Where New Text Goes
		;DE = Pointer Address
		ex		de,hl						;Swaps For speed
		ld		(hl),e						;Pointer Address = Start of Text HL (Note +3 Not including Address & Len)
		inc		hl							;
		ld		(hl),d						;Pointer Address Hi

		ld		l,(iy+7)					;HL=Location of Stack Text
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl		;Adjust the String Stack Pointer down for next data	
		ldir								;HL -> DE Looping C times
		Xor		a							;A=0 
		ld		(de),a						;0 Terminator on string end
		inc		de							;Pad
		ld		(SyB_StringTopAddr),de		;New StringTop Value
		
		ld		hl,SyB_StringTopMem
		ld		a,d
		inc		a
		cp		h
		call	nc,SyB_Garbage
		ret
.SyB_Where_Pointer_2:		dw	0			;Actual 2 Byte Pointer to String


;****          GARBAGE           ****
;**** Garbage Collection Command ****
;****                            ****
.SyB_Garbage
		;**** Okay We need to do a Text clearout
		ld		hl,SyB_StringTopAddr+2		;HL = Where to Start
		ld		(SyB_SSN_Garbage_Last),hl
		
.SyB_SSN_Garbage_3		
		ld		bc,(SyB_StringTopAddr)	
.SyB_SSN_Garbage_1		
		ld		a,(hl)
		And		a
		jp		nz,SyB_SSN_Garbage_10
		inc		hl
.SyB_SSN_Garbage_4				
		ld		a,h
		cp		b
		jp		c,SyB_SSN_Garbage_1
		ld		a,l
		cp		c
		jp		c,SyB_SSN_Garbage_1
		;Done it
		ld		hl,(SyB_SSN_Garbage_Last)
		ld		(SyB_StringTopAddr),hl	
		ret

.SyB_SSN_Garbage_10
		dec		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		ld		e,b
		ld		d,(hl)
		dec		hl
		;Is DE = 1 - Becuase if so it is a skip
		ld		a,1
		cp		e
		jp		nz,SyB_SSN_Garbage_11
		Xor		a
		cp		d
		jp		nz,SyB_SSN_Garbage_11
		;**** This is a skipper
		inc		hl
		inc		hl				;Now Points at Length
		ld		c,(hl)
		ld		b,0
		inc		bc
		inc		bc
		add		hl,bc
		ld		bc,(SyB_StringTopAddr)
		jp		SyB_SSN_Garbage_4
				
.SyB_SSN_Garbage_11
		ld		(SyB_SSN_Garbage_HL),hl
		ld		(SyB_SSN_Garbage_Check1),bc		
		;Gets Garbage Check 1 (DE) and - 3 to Match
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		dec		bc
		dec		bc
		dec		bc
		;Check DE = BC
		ld		a,e
		cp		c
		jp		nz,SyB_SSN_Garbage_12
		ld		a,d
		cp		b
		jp		nz,SyB_SSN_Garbage_12		
		;**** Tis same so copy This text
		ld		hl,(SyB_SSN_Garbage_HL)
		jp		SyB_SSN_Garbage_CopyDown				
.SyB_SSN_Garbage_12
		;DE = Current pointer + 1
		dec		de
		ld		hl,(SyB_SSN_Garbage_Check1)			;Get Contents of pointer
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		dec		bc
		dec		bc
		dec		bc
		ld		a,e
		cp		c
		jp		nz,SyB_SSN_Garbage_13		
		ld		a,d
		cp		b
		jp		nz,SyB_SSN_Garbage_13
		ex		de,hl
		jp		SyB_SSN_Garbage_CopyDown
.SyB_SSN_Garbage_13:
		di
.SyB_SSN_Garbage_14:
		jr		SyB_SSN_Garbage_14
		db		"String Error"
	
;HL = Start of Copy	
.SyB_SSN_Garbage_CopyDown:
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl	
		ex		de,hl
		ld		de,(SyB_SSN_Garbage_Last)
		inc		de
		inc		de
		inc		de
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		de,(SyB_SSN_Garbage_Last)
		pop		hl
		ld		a,(hl)
		add		4
		dec		hl
		dec		hl
		ld		b,0
		ld		c,a
		ldir
		ld		(SyB_SSN_Garbage_Last),de
		ld		bc,(SyB_StringTopAddr)
		jp		SyB_SSN_Garbage_4
		
.SyB_SSN_Garbage_Last:		dw	0		
.SyB_SSN_Garbage_Check1:	dw	0		
.SyB_SSN_Garbage_HL:		dw	0
	


;==============================================================================
;### DISPLAY-ROUTINES #########################################################
;==============================================================================
;### DSPGET -> converts 5byte floating point value to display format
;### Input  DE=pointer to 5byte floating point value
.DspGet
		jr		dspget99
.dspvaltmp   ds 5+1
.dspvalnum   ds 10+1
.dspvallen   db 0
.dspvalsgn   db 0        ;0=positive; display no sign, -1=minus
.dspvalexp   db 0        ;exponent (signed)
.dspvaldig   equ 10      ;maximum amount of displayed mantissa digits
.dspchrflg   db 1        ;flag (input), if 1000 points should be displayed
.dspfeflg    db 0        ;flag (input), if force exponent display
.dspchrcom   db "."      ;symbol for 1000 points
.dspchrpoi   db ","      ;symbol for comma
.dspintflg   db 0        ;flag (result), if displayed number is integer
.dspget99:
		ld 		hl,0
        ld 		(dspvalsgn),hl
        ld 		hl,dspvaltmp
        call 	FLO_MOVE
        call 	FLO_PREPARE		
        ld 		a,b
        Or 		a
        jr 		z,dspget3
        And 	128
        add 	a
        sbc 	0
        ld 		(dspvalsgn),a
        ld 		a,e
        ld 		(dspvalexp),a
        ld 		ix,(dspvaltmp+0)
        ld 		de,(dspvaltmp+2)
        db 		#dd:ld a,l
        db 		#dd:Or h		
        Or 		e
        Or 		d
        jr 		z,dspget3
		ld 		iy,dspvalnum

		call 	clcn32
 
        push 	iy
		pop hl
        ld 		bc,dspvalnum-1
        Or 		a
        sbc 	hl,bc
        ld 		c,l
        ld 		a,"0"
        ld 		hl,dspvalexp

.dspget1
		cp 		(iy+0)
        jr 		nz,dspget2
        ld 		(iy+0),0
        dec 	iy
        inc 	(hl)
        dec 	c
        jr 		nz,dspget1
.dspget2
		ld 		a,c
.dspget3
		ld 		(dspvallen),a
        ret

;### DSPTXT -> converts display format value to text and displays it
.dsptxt
		Xor 	a
        ld 		(dspintflg),a
        ld 		a,(dspvalsgn)        ;*** Sign
        inc 	a
        jr 		nz,dsptxt1
        ld 		(hl),"-"
        inc 	hl
.dsptxt1
		ex 		de,hl
        ld 		a,(dspvallen)        ;*** Test, if value=0
        Or 		a
        jr 		nz,dsptxti
.dsptxty
		ld 		a,"0"                ;display only 0.
        ld 		(de),a
        inc 	de
        jr 		dsptxth
.dsptxti
		ld 		hl,dspvalnum
        ld 		a,(dspfeflg)
        Or 		a
        jr 		nz,dsptxt6           ;display exponent, if in RO mode and F-E on
        ld 		a,(dspvalexp)        ;*** Exponent
        ld 		b,a
        Or 		a
        ld 		a,(dspvallen)
        ld 		c,a
        jp 		m,dsptxta
        add	 	b                   ;*** Exponent positive -> exp display, if dspvallen + dspvalexp <= dspvaldig
        cp 		dspvaldig+1          ;a=length of complete number
        jr 		nc,dsptxt6
        ld 		b,a                  ;*** Display mantissa without comma (a,b=length of mantissa before comma)
        ld 		a,1
        ld 		(dspintflg),a
        ld 		a,b
.dsptxt2
		sub 	3
        jr 		z,dsptxtf
        jr 		nc,dsptxt2
.dsptxtf
		add 	3
        ld 		c,a                  ;c=1000 counter
.dsptxt3
		ld 		a,(hl)
        inc 	hl
        Or 		a
        jr 		nz,dsptxt4
        ld 		a,"0"
        dec 	hl
.dsptxt4
		call 	dsptxt5
        jr 		nz,dsptxt3
.dsptxth
		ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        Xor 	a
        ld 		(de),a
        ret
.dsptxt6
		ld 		a,(hl)               ;**** Display mantissa with exponent
        ld 		(de),a
        inc 	hl
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ld 		a,(dspvallen)
.dsptxt7
		dec 	a
        jr 		z,dsptxt8
        ldi
        jr 		dsptxt7
.dsptxt8
		ex 		de,hl
        ld 		(hl),"e"
        inc 	hl
        ld 		a,(dspvallen)        ;exp display = -(exp + mantissa length - 1)
        ld 		c,a
        ld 		a,(dspvalexp)
        add 	c
        dec 	a
        ld 		(hl),"+"
        jp 		p,dsptxt9
        ld 		(hl),"-"
        neg
.dsptxt9
		inc 	hl
        ex 		de,hl
        call 	clcdez
        ex 		de,hl
        ld 		(hl),e
        inc 	hl
        ld 		(hl),d
        inc 	hl
        ld 		(hl),0
        ret
.dsptxta
		add 	b                   ;*** Comma negative (a,c=len, b=comma -> a=len-neg comma)
        jr 		c,dsptxtb
        neg                     ;a=-(len+exp) [=distance between comma and first digit]
        ld 		b,a
        add 	c                   ;a=new number of digits-1
        cp 		dspvaldig+1
        jr 		nc,dsptxt6           ;too large -> display with exponent
        call 	dsptxte
        ld 		a,"0"
.dsptxtg
		ld 		(de),a
        inc 	de
        djnz 	dsptxtg
        jr 		dsptxtd
.dsptxtb
		jr 		z,dsptxtc            ;*** Display negative comma without exponent
        ld 		b,a
        call 	dsptxt2
        jr 		dsptxtd
.dsptxtc
		call 	dsptxte
.dsptxtd
		ld 		a,(hl)
        ldi
        Or 		a
        jr 		nz,dsptxtd
        ret
.dsptxte
		ld 		a,"0"
        ld 		(de),a
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ret
.dsptxt5
		ld 		(de),a               ;adds a digit (in A) and inserts a point, if needed
        inc 	de
        dec 	b
        ret 	z
        dec 	c
        ret 	nz
        ld 		a,(dspchrflg)
        dec 	a
        ret 	nz
        ld 		a,(dspchrpoi)
        ld 		(de),a
        inc 	de
        ld 		c,3+1
        dec 	c
        ret



;==============================================================================
;### SUB-ROUTINES #############################################################
;==============================================================================
;### CLCN32 -> Converts 32Bit-number (unsigned) in ASCII-String (teminated by 0)
;### Input      DE,IX=value, IY=destination address
;### Output     IY=Address of last char
;### Destroyed  AF,BC,DE,HL,IX,IY


.clcn32t
		dw 		1,0,10,0,100,0,1000,0,10000,0
        dw 		#86a0,1,#4240,#f,#9680,#98,#e100,#5f5,#ca00,#3b9a
.clcn32z
		ds 		4,0

		nop
		nop
.clcn32
		ld 		(clcn32z),ix
        ld 		(clcn32z+2),de
        ld 		ix,clcn32t+36
        ld 		b,9
        ld 		c,0
.clcn321
		ld 		a,"0"
        Or 		a
.clcn322
		ld 		e,(ix+0)
		ld 		d,(ix+1)
		ld 		hl,(clcn32z)
		sbc 	hl,de
		ld 		(clcn32z),hl
        ld 		e,(ix+2)
		ld 		d,(ix+3)
		ld 		hl,(clcn32z+2)
		sbc 	hl,de
		ld 		(clcn32z+2),hl
        jr 		c,clcn325
        inc 	c
        inc 	a
        jr 		clcn322
.clcn325
		ld 		e,(ix+0)
		ld 		d,(ix+1)
		ld 		hl,(clcn32z)
		add 	hl,de
		ld 		(clcn32z),hl
        ld 		e,(ix+2)
		ld 		d,(ix+3)
		ld 		hl,(clcn32z+2)
		adc 	hl,de
		ld 		(clcn32z+2),hl
        ld 		de,-4
        add 	ix,de
        inc 	c
        dec 	c
        jr 		z,clcn323
        ld 		(iy+0),a
        inc 	iy
clcn323
		djnz 	clcn321
        ld 		a,(clcn32z)
        add 	"0"
        ld 		(iy+0),a
        ld 		(iy+1),0
        ret
;### CLCDEZ -> Converts 8bit value into two decimal digits
;### Input      A=value
;### Output     L=10.ascii digit, H=1. ascci digit
;### Destroyed  AF
clcdez  ld l,0
clcdez1 sub 10
        jr c,clcdez2
        inc l
        jr clcdez1
clcdez2 add "0"+10
        ld h,a
        ld a,"0"
        add l
        ld l,a
        ret


		
.SyB_Push_N_Flo
		pop		hl
		push	hl
		call	SyB_PushFlo
		pop		hl
		ld		bc,5
		add		hl,bc
		jp		(hl)
		
.SyB_Push_V_Flo
		pop		hl
		push	hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		call	SyB_PushFlo
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)
.SyB_Push_Null_Flo
		ld		hl,(SyB_StackAddr)
		ld		a,1
		ld		(hl),a
		inc		hl
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a						;Strange but should be #80 but isnt		
		ld		bc,-11						;16
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16				
		ret	
;**** Push String
.SyB_Push_Null_Str
		ld		hl,(SyB_StackAddr)
		ld		a,5
		ld		(hl),a
		inc		hl
		ld		de,(SyB_StrStackAddr)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		Xor		a
		ld		(hl),a
		ld		bc,-9						;16
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16				
		ret


.SyB_Push_V_Str
		pop		hl
		push	hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		;address of text
		ld		hl,(SyB_StackAddr)
		push	de
		ld		a,5
		ld		(hl),a
		inc		hl
		dec		de
		ld		a,(de)
		ld		de,(SyB_StrStackAddr)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		ld		(hl),a
		ld		bc,-9
		add		hl,bc
		ld		(SyB_StackAddr),hl
		pop		hl
		ld		c,a
		ld		b,0
		Xor		a
		cp		c
		jr		z,SyB_Push_V_Str_2		
		ldir
.SyB_Push_V_Str_2		
		ld		(SyB_StrStackAddr),de
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)


.SyB_PushFlo:
		ld		a,1
		ld		de,(SyB_StackAddr)			;**** Get Address of Data Stack
		ld		(de),a						;**** Puts Type
		inc		de							;**** Modes up Stack 1
		ldi									;**** Copies (HL)-(DE)
		ldi									;**** Copies (HL)-(DE)
		ldi									;**** Copies (HL)-(DE)
		ldi									;**** Copies (HL)-(DE)
		ldi									;**** Copies (HL)-(DE)
		ld		de,(SyB_StackAddr)
		ld		hl,-6
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret								
											
;****                ****
;**** Decrease Stack ****
;**** Decreases the stack from HL (Which Is a stack Pos +1 hence -5 not 6)
;**** HL = (HL) Float Result		
.SyB_DecStack
		ld		hl,(SyB_StackAddr)
		ld		de,6
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret



;****                      ****		
;**** Pushes Bool result 0 ****
;****                      ****
.SyB_Push_Bool_Result_0:
		ld		(ix+13),0					;19
		ld		(ix+14),0					;19
		ld		bc,6						;10
		add		ix,bc						;15
		ld		(Syb_StackAddr),ix			;20
		ret	
;****                      ****		
;**** Pushes Bool result 1 ****
;****                      ****
.SyB_Push_Bool_Result_1:
		ld		(ix+13),1					;19
		ld		(ix+14),0					;19
		ld		bc,6						;10
		add		ix,bc						;15
		ld		(Syb_StackAddr),ix			;20
		ret 								;10

;****           ****
;**** SyB_N_VGL ****
;****           ****
.SyB_N_VGL_2
		ld		ix,(SyB_StackAddr)		
		ld		a,(ix+14)
		Xor		%10000000
		ld		h,a
		ld		a,(ix+8)
		Xor		%10000000
		cp		h
		jr		z,SyB_N_VGL_1
		jp		nc,SyB_N_VGL_GT
		ld		a,1
		ret
.SyB_N_VGL_1
		ld		a,(ix+7)
		cp		(ix+13)
		jr		z,SyB_N_VGL_EQ		
		jp		nc,SyB_N_VGL_GT
.SyB_N_VGL_LT
		ld		a,1
		ret
.SyB_N_VGL_GT
		ld		a,-1
		ret
.SyB_N_VGL_EQ
		Xor		a
		ret		

;****           ****
;**** SyB_S_VGL ****
;****           ****
.SyB_S_VGL
		ld		ix,(SyB_StackAddr)
		ld		e,(ix+7)
		ld		d,(ix+8)
		ld		c,(ix+9)
		ld		l,(ix+13)
		ld		h,(ix+14)
		ld		b,(ix+15)
.SyB_S_VGL_1
		;**** Just Check Lengths
		ld		a,b
		cp		0
		jr		nz,SyB_S_VGL_2
		cp		c
		jr		z,SyB_N_VGL_EQ
.SyB_S_VGL_2
		Xor		a
		cp		c
		jr		z,SyB_N_VGL_LT
		cp		b
		jr		z,SyB_N_VGL_GT		
		;**** Now check Chars
		ld		a,(de)
		cp		(hl)		
		jr		nz,SyB_N_VGL_LT
		jr		c,SyB_N_VGL_GT
		inc		de
		inc		hl
		dec		b
		dec		c
		jr		SyB_S_VGL_1





;****               ****
;**** Do String Add ****
;****               ****
.SyB_STR_Add:
		ld		hl,(SyB_StackAddr)
		ld		bc,9
		add		hl,bc
		ld		e,(hl)
		ld		bc,6
		add		hl,bc
		ld		a,(hl)
		add		e
		;should check not greater than 250
		ld		(hl),a
		ld		bc,-9
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret

;******************************* 67 EQ ****************************		
;****                   ****
;**** Do Integer Equals ****
;****                   ****
.SyB2_INT_EQ
		call	SyB_N_VGL_2
.SyB2_INT_EQ_10
		cp		0
		jp		z,SyB_Push_Bool_Result_1	;***** Result was Greater Than so 1 Bool Result
		jp		SyB_Push_Bool_Result_0		;***** Result was not Greater than so 0 Bool Result		
;****                 ****
;**** Do Float Equals ****
;****                 ****
.SyB2_FLO_EQ
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jr		SyB2_INT_EQ_10
;****                  ****
;**** Do String Equals ****
;****                  ****
.SyB2_STR_EQ
		call	SyB_S_VGL					;String comparison
		jr		SyB2_INT_EQ_10		
;******************************* 68 GTE ****************************		
;****                                ****
;**** Do Integer Greater Than Equals ****
;****                                ****
.SyB2_INT_GTE
		call	SyB_N_VGL_2
.SyB2_INT_GTE_10		
		cp		-1
		jp		z,SyB_Push_Bool_Result_0	;***** Result was not LessThanEqual so 0 Bool Result
		jp		SyB_Push_Bool_Result_1		;***** Result was LessThanEqual so 1 Bool Result
;****                              ****
;**** Do Float Greater Than Equals ****
;****                              ****
.SyB2_FLO_GTE
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jr		SyB2_INT_GTE_10
;****                               ****
;**** Do String Greater Than Equals ****
;****                               ****
.SyB2_STR_GTE
		call	SyB_S_VGL					;String comparison
		jr		SyB2_INT_GTE_10				
;******************************* 69 LTE ****************************		
;****                              ****
;**** Do Integer Lesser Than Equal ****
;****                              ****
.SyB2_INT_LTE
		call	SyB_N_VGL_2
.SyB2_INT_LTE_10
		cp		1
		jp		z,SyB_Push_Bool_Result_0	;***** Result was not LessThanEqual so 0 Bool Result
		jp		SyB_Push_Bool_Result_1		;***** Result was LessThanEqual so 1 Bool Result
;****                            ****
;**** Do Float Lesser Than Equal ****
;****                            ****
.SyB2_FLO_LTE
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jr		SyB2_INT_LTE_10
;****                             ****
;**** Do String Lesser Than Equal ****
;****                             ****
.SyB2_STR_LTE
		call	SyB_S_VGL					;String comparison
		jr		SyB2_INT_LTE_10	
;******************************* 70 OT ****************************		
;****                       ****
;**** Do Integer Other Than ****
;****                       ****
.SyB2_INT_OT
		call	SyB_N_VGL_2
.SyB2_INT_OT_10
		cp		0
		jp		z,SyB_Push_Bool_Result_0	;***** Result was not Other Than so 0 Bool Result
		jp		SyB_Push_Bool_Result_1		;***** Result was Other Than so 1 Bool Result
;****                     ****
;**** Do Float Other Than ****
;****                     ****
.SyB2_FLO_OT
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jr		SyB2_INT_OT_10
;****                      ****
;**** Do String Other Than ****
;****                      ****
.SyB2_STR_OT
		call	SyB_S_VGL					;String comparison
		jr		SyB2_INT_OT_10				
;******************************* 71 LT ****************************		
;****                        ****
;**** Do Integer Lesser Than ****
;****                        ****
.SyB2_INT_LT
		call	SyB_N_VGL_2
.SyB2_INT_LT_10
		cp		-1
		jp		z,SyB_Push_Bool_Result_1	;***** Result was LessThan so 1 Bool Result
		jp		SyB_Push_Bool_Result_0		;***** Result was not LessThan so 0 Bool Result
;****                      ****
;**** Do Float Lesser Than ****
;****                      ****
.SyB2_FLO_LT
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jr		SyB2_INT_LT_10
;****                       ****
;**** Do String Lesser Than ****
;****                       ****
.SyB2_STR_LT
		call	SyB_S_VGL					;String comparison
		jr		SyB2_INT_LT_10						
;******************************* 72 GT ****************************		
;****                         ****
;**** Do Integer Greater Than ****
;****                         ****
.SyB2_INT_GT
		call	SyB_N_VGL_2
.SyB2_INT_GT_10
		cp		1
		jp		z,SyB_Push_Bool_Result_1	;***** Result was Greater Than so 1 Bool Result
		jp		SyB_Push_Bool_Result_0		;***** Result was not Greater than so 0 Bool Result		
;****                       ****
;**** Do Float Greater Than ****
;****                       ****
.SyB2_FLO_GT
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jr		SyB2_INT_GT_10
;****                        ****
;**** Do String Greater Than ****
;****                        ****
.SyB2_STR_GT
		call	SyB_S_VGL					;String comparison
		jr		SyB2_INT_GT_10






.SyB2_STACK_2_FLO
		ld		hl,(SyB_StackAddr)
		inc		hl
		ld		bc,6
		add		hl,bc
		ld		e,l
		ld		d,h
		add		hl,bc
		ret		

		


;**** Converts the Stack from an Int to Float Value
;**** Dependiong on What stack part needs it
SyB_INT_2_FLO_Stack_2
		ld		bc,12
		jp		SyB_INT_2_FLO_BC
SyB_INT_2_FLO_Stack_3
		ld		bc,18
		jp		SyB_INT_2_FLO_BC
SyB_INT_2_FLO_Stack_4
		ld		bc,24
		jp		SyB_INT_2_FLO_BC
SyB_INT_2_FLO_Stack_5
		ld		bc,30
		jp		SyB_INT_2_FLO_BC
SyB_INT_2_FLO_Stack_6
		ld		bc,36
		jp		SyB_INT_2_FLO_BC
SyB_INT_2_FLO_Stack_7
		ld		bc,42
		jp		SyB_INT_2_FLO_BC
SyB_INT_2_FLO_Stack_8
		ld		bc,48
		jp		SyB_INT_2_FLO_BC		
;**** Converts the Stack from an Int to Float Value
.SyB_INT_2_FLO_Stack_1
.SyB_INT_2_FLO
		ld		bc,6
.Syb_INT_2_FLO_BC		
		ld		hl,(SyB_StackAddr)
		add		hl,bc
		ld		a,1
		ld		(hl),a
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		dec		hl	
;		Xor		a
		bit		7,d
		jr		z,Syb_INT_2_FLO_BC_99				
		ld		a,e
		Xor		255
		ld		e,a
		ld		a,d
		Xor		255
		ld		d,a
		inc		de
		ld		a,128
.Syb_INT_2_FLO_BC_99			
		ex		de,hl
		call	FLO_KONV_HLA_TO_FLO	
		ret	

.SyB_Store_Char_Temp:	db 0
.SyB_TempByte:	db	0


;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@         C P C   -   F l o a t i n g - P o i n t - R o u t i n e s          @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;--- RANDOM NUMBERS -----------------------------------------------------------
;### FLO_RANDOMIZE0 -> RND seek to 0
;### FLO_RANDOMIZE -> RND seek to (HL)
;### FLO_RND -> Gets next RND value
;### FLO_LAST_RND -> Gets current RND value

;--- OPERATIONS ---------------------------------------------------------------
;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### FLO_VGL -> Compares (HL) with (DE)

;--- FUNCTIONS ----------------------------------------------------------------
;### FLO_VZW -> Changes the sign of (HL)
;### FLO_SQR -> Extracts the root of (HL)
;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### FLO_POT_E -> (HL)=E^(HL)
;### FLO_SIN -> Calculates the sinus of (HL)
;### FLO_COS -> Calculates the cosinus of (HL)
;### FLO_TAN -> Calculates the tangent of (HL)
;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### FLO_10A -> (HL)=(HL)*10^A
;### FLO_SGN -> Tests the sign of (HL)

;--- MISCELLANEOUS ------------------------------------------------------------
;### FLO_PI -> Gets PI
;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### FLO_DEGRAD -> Set Deg/Rad

;--- CONVERSION ---------------------------------------------------------------
;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer

;--- DISPLAY-PREPARATION ------------------------------------------------------
;### FLO_PREPARE -> Prepares the display of a FLO value


;--- begin routines -----------------------------------------------------------

;### FLO_PI -> Gets PI
;### Input      (HL)=Destination
;### Output     (HL)=PI, CF=1
;### Unchanged  BC,HL,IX,IY
;.FLO_PI
 ;       ld de,FLO_CONST_PI
;        jr FLO_MOVE
.l2f7d
		ld		de,FLO_CONST_C
		jr		FLO_MOVE
.l2f87
		ex		de,hl
.l2f88
		ld hl,#b10e
		jr FLO_MOVE
.l2f8d
        ld de,#b104
.l2f90
        ex de,hl




;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### Input      (DE)=Source value, (HL)=Destination
;### Output     (HL)=Value, CF=1
;### Unchanged  BC,DE,HL,IX,IY,(DE)
.FLO_MOVE
        push hl
        push de
        push bc
        ex de,hl
        ld bc,#0005
        ldir
        pop bc
        pop de
        pop hl
        scf
        ret

;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### Input      HL=value, A[bit7]=sign, (DE)=destination
;### Output     HL=DE, (HL)=FLO value
;### Unchanged  BC,IX,IY
.FLO_KONV_HLA_TO_FLO
        push de
        push bc
        Or #7f
        ld b,a
        Xor a
        ld (de),a
        inc de
        ld (de),a
        inc de
        ld c,#90
        Or h
        jr nz,l2fbb
        ld c,a
        Or l
        jr z,l2fbf
        ld l,h
        ld c,#88
        jr l2fbb
.l2fb7
        dec c
        sla l
        adc a
.l2fbb
        jp p,l2fb7
        And b
.l2fbf
        ex de,hl
        ld (hl),e
        inc hl
        ld (hl),a
        inc hl
        ld (hl),c
        pop bc
        pop hl
        ret

;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### Input      (HL)=LW, A[bit7]=sign
;### Output     (HL)=FLO value
;### Unchanged  BC,DE,HL,IY
.FLO_KONV_LW_TO_FLO
        push bc
        ld bc,#a000
        call l2fd3
        pop bc
        ret
        ld b,#a8
.l2fd3
        push de
        call l379c
        pop de
        ret

;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### Input      (HL)=FLO value
;### Output     HL=abs((HL)), A[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  BC,DE,IY
.FLO_ROUND_FLO_TO_HLA
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr z,l2ffd
        add #90
        ret nc
        push de
        push bc
        add #10
        call l373d
        sla c
        adc hl,de
        jr z,l2ffa
        ld a,(ix+#03)
        Or a
.l2ff6
        ccf
        pop bc
        pop de
        ret
.l2ffa
        sbc a
        jr l2ff6
.l2ffd
        ld l,a
        ld h,a
        scf
        ret
;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_ROUND_FLO_TO_LW
        call FLO_FIX_FLO_TO_LW
        ret nc
        ret p
.l3006
        push hl
        ld a,c
.l3008
        inc (hl)
        jr nz,l3011
        inc hl
        dec a
        jr nz,l3008
        inc (hl)
        inc c
.l3011
        pop hl
        scf
        ret

;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_FIX_FLO_TO_LW
        push hl
        push de
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr nz,l3029
        ld b,#04
.l3021
        ld (hl),a
        inc hl
        djnz l3021
        ld c,#01
        jr l3051
.l3029
        add #a0
        jr nc,l3052
        push hl
        call l373d
        Xor a
        cp b
        adc a
        Or c
        ld c,l
        ld b,h
        pop hl
        ld (hl),c
        inc hl
        ld (hl),b
        inc hl
        ld (hl),e
        inc hl
        ld e,a
        ld a,(hl)
        ld (hl),d
        And #80
        ld b,a
        ld c,#04
        Xor a
.l3047
        Or (hl)
        jr nz,l304f
        dec hl
        dec c
        jr nz,l3047
        inc c
.l304f
        ld a,e
        Or a
.l3051
        scf
.l3052
        pop de
        pop hl
        ret

;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_INT_FLO_TO_LW
        call 	FLO_FIX_FLO_TO_LW
        ret 	nc
        ret 	z
        bit 	7,b
        ret 	z
        jr 		l3006

;### FLO_PREPARE -> Prepares the display of a FLO value
;### Input      (HL)=FLO value
;### Output     (HL)=LW normed mantissa
;###            B = sign of mantissa
;###            D = sign of exponent
;###            E = exponent/comma position
;###            C = number of significant mantissa bytes (NOT digits!)
;### Unchanged  HL
.FLO_PREPARE
        call FLO_SGN
        ld b,a
        jr z,l30b7
        call m,l3734
        push hl
        ld a,(ix+#04)
        sub #80
        ld e,a
        sbc a
        ld d,a
        ld l,e
        ld h,d
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,de
        add hl,hl
        add hl,de
        add hl,hl
        add hl,hl
        add hl,de
        ld a,h
        sub #09
        ld c,a
        pop hl
        push bc
        call nz,l30c8
.l3085
        ld de,FLO_CONST_A
        call l36e2
        jr nc,l3098
        ld de,FLO_CONST_D1
        call FLO_MULT
        pop de
        dec e
        push de
        jr l3085
.l3098
        ld de,FLO_CONST_B
        call l36e2
        jr c,l30ab
        ld de,FLO_CONST_D1
        call FLO_DIV
        pop de
        inc e
        push de
        jr l3098
.l30ab
        call FLO_ROUND_FLO_TO_LW
        ld a,c
        pop de
.l30b0
        ld b,d
        dec a
        add l
        ld l,a
        ret nc
        inc h
        ret
.l30b7
        ld e,a
        ld (hl),a
        ld c,#01
        ret

;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer
;### Input      HL=16 bit integer, B[bit7]=sign
;### Output     HL=signed 16 bit integer
;###            CF=0 Overflow
;### Unchanged  BC,DE,IX,IY
.FLO_KONV_HLB_TO_INT
        ld a,h
        Or a
        jp m,ldd42
        Or b
        jp m,ldded
        scf
        ret
.ldd42
        Xor #80
        Or l
        ret nz
        ld a,b
        scf
        adc a
        ret
.ldded
        Xor a
        sub l
        ld l,a
        sbc h
        sub l
        cp h
        ld h,a
        scf
        ret nz
        cp #01
        ret

;### FLO_10A -> (HL)=(HL)*10^A
;### Input      (HL)=value, A=potence
;### Output     (HL)=(HL)*10^A
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_10A
        cpl
        inc a
.l30c8
        Or a
        scf
        ret z
        ld c,a
        jp p,l30d1
        cpl
        inc a
.l30d1
        ld de,FLO_CONST_D2
        sub #0d
        jr z,l30ed
        jr c,l30e3
        push bc
        push af
        call l30ed
        pop af
        pop bc
        jr l30d1
.l30e3
        ld b,a
        add a
        add a
        add b
        add e
        ld e,a
        ld a,#ff
        adc d
        ld d,a
.l30ed
        ld a,c
        Or a
        jp p,FLO_DIV
        jp FLO_MULT

;### FLO_RANDOMIZE0 -> RND seek to 0
;### Unchanged  AF,BC,DE,IX,IY
.FLO_RANDOMIZE0
        ld hl,#8965
        ld (FLO_VALUE_RND+2),hl
        ld hl,#6c07
        ld (FLO_VALUE_RND),hl
        ret

;### FLO_RANDOMIZE -> RND seek to (HL)
;### Input      (HL)=value
;### Unchanged  C,IY,FLO(HL)
.FLO_RANDOMIZE
        ex de,hl
        call FLO_RANDOMIZE0
        ex de,hl
        call FLO_SGN
        ret z
        ld de,FLO_VALUE_RND
        ld b,#04
.l3151
        ld a,(de)
        Xor (hl)
        ld (de),a
        inc de
        inc hl
        djnz l3151
        ret

;### FLO_RND -> Gets next RND value
;### Input      (HL)=Destination
;### Output     (HL)=new RND
;### Unchanged  HL,IY
.FLO_RND
        push hl
        ld hl,(FLO_VALUE_RND+2)
        ld bc,#6c07
        call l319c
        push hl
        ld hl,(FLO_VALUE_RND)
        ld bc,#8965
        call l319c
        push de
        push hl
        ld hl,(FLO_VALUE_RND+2)
        call l319c
        ex (sp),hl
        add hl,bc
        ld (FLO_VALUE_RND),hl
        pop hl
        ld bc,#6c07
        adc hl,bc
        pop bc
        add hl,bc
        pop bc
        add hl,bc
        ld (FLO_VALUE_RND+2),hl
        pop hl

;### FLO_LAST_RND -> Gets current RND value
;### Input      (HL)=Destination
;### Output     (HL)=current RND
;### Unchanged  HL,IY
.FLO_LAST_RND
        push hl
        pop ix
        ld hl,(FLO_VALUE_RND)
        ld de,(FLO_VALUE_RND+2)
        ld bc,#0000
        ld (ix+#04),#80
        jp l37ac
.l319c
        ex de,hl
        ld hl,#0000
        ld a,#11
.l31a2
        dec a
        ret z
        add hl,hl
        rl e
        rl d
        jr nc,l31a2
        add hl,bc
        jr nc,l31a2
        inc de
        jr l31a2

;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG10((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_DEC
        ld de,FLO_CONST_LOGDEC
        jr l31b9

;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_NAT
        ld de,FLO_CONST_LOGNAT
.l31b9
        call FLO_SGN
        dec a
        cp #01
        ret nc
        push de
        call l36d3
        push af
        ld (ix+#04),#80
        ld de,FLO_CONST_LOG
        call FLO_VGL
        jr nc,l31d7
        inc (ix+#04)
        pop af
        dec a
        push af
.l31d7
        call l2f87
        push de
        ld de,FLO_CONST_C
        push de
        call FLO_ADD
        pop de
        ex (sp),hl
        call FLO_SUB
        pop de
        call FLO_DIV
        call l3440
        db #04
        db #4c,#4b,#57,#5e,#7f
        db #0d,#08,#9b,#13,#80
        db #23,#93,#38,#76,#80
        db #20,#3b,#aa,#38,#82

.l3203
        push de
        call FLO_MULT
        pop de
        ex (sp),hl
        ld a,h
        Or a
        jp p,l3210
        cpl
        inc a
.l3210
        ld l,a
        ld a,h
        ld h,#00
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_ADD
        pop de
        jp FLO_MULT

;### FLO_POT_E -> (HL)=E^(HL)
;### Input      (HL)=value
;### Output     (HL)=E^(HL)
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_POT_E
        ld b,#e1
        call l3492
        jp nc,l2f7d
        ld de,FLO_CONST_POTE2
        call FLO_VGL
        jp p,l37e8
        ld de,FLO_CONST_POTE3
        call FLO_VGL
        jp m,l37e2
        ld de,FLO_CONST_POTE1
        call l3469
        ld a,e
        jp p,l3255
        neg
.l3255
        push af
        call l3570
        call l2f8d
        push de
        call l3443
        db #03
        db #f4,#32,#eb,#0f,#73
        db #08,#b8,#d5,#52,#7b
.FLO_CONST_HALF                     ;=1/2
        db #00,#00,#00,#00,#80

.l3270
        ex (sp),hl
        call l3443
        db #02
        db #09,#60,#de,#01,#78
        db #f8,#17,#72,#31,#7e

.l327f
        call FLO_MULT
        pop de
        push hl
        ex de,hl
        call FLO_SUB
        ex de,hl
        pop hl
        call FLO_DIV
        ld de,FLO_CONST_HALF
        call FLO_ADD
        pop af
        scf
        adc (ix+#04)
        ld (ix+#04),a
        scf
        ret

;### FLO_SQR -> Extracts the root of (HL)
;### Input      (HL)=value
;### Output     (HL)=sqr(HL)
;###            CF=0 error, negative value
;### Unchanged  HL
.FLO_SQR
        ld de,FLO_CONST_HALF

;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)^(DE)
;###            CF=0 Error [S=1 invalid parameter -X^(z/n), P=1 Overflow]
;### Unchanged  HL,FLO(DE)
.FLO_POT
        ex de,hl
        call FLO_SGN
        ex de,hl
        jp z,l2f7d
        push af
        call FLO_SGN
        jr z,l32e2
        ld b,a
        call m,l3734
        push hl
        call l3324
        pop hl
        jr c,l32ed
        ex (sp),hl
        pop hl
        jp m,l32ea
        push bc
        push de
        call FLO_LOG_NAT
        pop de
        call c,FLO_MULT
        call c,FLO_POT_E
.l32d9
        pop bc
        ret nc
        ld a,b
        Or a
        call m,FLO_VZW
        scf
        ret
.l32e2
        pop af
        scf
        ret p
        call l37e8
        Xor a
        ret
.l32ea
        Xor a
        inc a
        ret
.l32ed
        ld c,a
        pop af
        push bc
        push af
        ld a,c
        scf
.l32f3
        adc a
        jr nc,l32f3
        ld b,a
        call l2f8d
        ex de,hl
        ld a,b
.l32fc
        add a
        jr z,l3314
        push af
        call l3570
        jr nc,l331b
        pop af
        jr nc,l32fc
        push af
        ld de,#b104
        call FLO_MULT
        jr nc,l331b
        pop af
        jr l32fc
.l3314
        pop af
        scf
        call m,l35fb
        jr l32d9
.l331b
        pop af
        pop af
        pop bc
        jp m,l37e2
        jp l37ea
.l3324
        push bc
        call l2f88
        call FLO_FIX_FLO_TO_LW
        ld a,c
        pop bc
        jr nc,l3331
        jr z,l3334
.l3331
        ld a,b
        Or a
        ret
.l3334
        ld c,a
        ld a,(hl)
        rra
        sbc a
        And b
        ld b,a
        ld a,c
        cp #02
        sbc a
        ret nc
        ld a,(hl)
        cp #27
        ret c
        Xor a
        ret


		
;### FLO_DEGRAD -> Set Deg/Rad
;### Input      A=Typ (=0 -> Rad, >0 -> Deg)
;### Unchanged  AF,BC,DE,HL,IX,IY
.FLO_DEGRAD    
        ld (FLO_VALUE_DEGRAD),a
        ret

;### FLO_COS -> Calculates the cosinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=cos(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_COS
        call FLO_SGN
        call m,l3734
        Or #01
        jr l3354

;### FLO_SIN -> Calculates the sinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=sin(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_SIN
        Xor a
.l3354
        push af
        ld de,FLO_CONST_SINA
        ld b,#f0
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        jr z,l3365
        ld de,FLO_CONST_SINB
        ld b,#f6
.l3365
        call l3492
        jr nc,l33a4
        pop af
        call l346a
        ret nc
        ld a,e
        rra
        call c,l3734
        ld b,#e8
        call l3492
        jp nc,l37e2
        inc (ix+#04)
        call l3440
        db #06
        db #1b,#2d,#1a,#e6,#6e
        db #f8,#fb,#07,#28,#74
        db #01,#89,#68,#99,#79
        db #e1,#df,#35,#23,#7d
        db #28,#e7,#5d,#a5,#80
.FLO_CONST_F
        db #a2,#da,#0f,#49,#81

.l33a1
        jp FLO_MULT
.l33a4
        pop af
        jp nz,l2f7d
        ld a,(FLO_VALUE_DEGRAD)
        cp #01
        ret c
        ld de,FLO_CONST_SINC
        jp FLO_MULT		
		



;### FLO_TAN -> Calculates the tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=tan(HL)
;###            CF=0 error [Z=1 division by zero, S=1 value too big]
;### Unchanged  HL
.FLO_TAN
        call l2f8d
        push de
        call FLO_COS
        ex (sp),hl
        call c,FLO_SIN
        pop de
        jp c,FLO_DIV
        ret

;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=atn(HL)
;### Unchanged  HL
.FLO_ARC_TAN
        call FLO_SGN
        push af
        call m,l3734
        ld b,#f0
        call l3492
        jr nc,l3430
        dec a
        push af
        call p,l35fb
        call l3440
        db #0b
        db #ff,#c1,#03,#0f,#77
        db #83,#fc,#e8,#eb,#79
        db #6f,#ca,#78,#36,#7b
        db #d5,#3e,#b0,#b5,#7c
        db #b0,#c1,#8b,#09,#7d
        db #af,#e8,#32,#b4,#7d
        db #74,#6c,#65,#62,#7d
        db #d1,#f5,#37,#92,#7e
        db #7a,#c3,#cb,#4c,#7e
        db #83,#a7,#aa,#aa,#7f
        db #fe,#ff,#ff,#7f,#80

.l3426
        call FLO_MULT
        pop af
        ld de,FLO_CONST_F
        call p,FLO_SUBX
.l3430
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        ld de,FLO_CONST_TAN
        call nz,FLO_MULT
        pop af
        call m,l3734
        scf
        ret
.l3440
        call l3570
.l3443
        call l2f87
        pop hl
        ld b,(hl)
        inc hl
        call l2f90
.l344c
        inc de
        inc de
        inc de
        inc de
        inc de
        push de
        ld de,#b109
        dec b
        ret z
        push bc
        ld de,#b10e
        call FLO_MULT
        pop bc
        pop de
        push de
        push bc
        call FLO_ADD
        pop bc
        pop de
        jr l344c
.l3469
        Xor a
.l346a
        push af
        call FLO_MULT
        pop af
        ld de,FLO_CONST_HALF
        call nz,FLO_ADD
        push hl
        call FLO_ROUND_FLO_TO_HLA
        jr nc,l348e
        pop de
        push hl
        push af
        push de
        ld de,#b109
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_SUB
        pop af
        pop de
        scf
        ret
.l348e
        pop hl
        Xor a
        inc a
        ret
.l3492
        call l36d3
        ret p
        cp b
        ret z
        ccf
        ret

;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)-(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUB
        ld a,#01
        jr l34a3

;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### Input      (DE)=first value, (HL)=second value
;### Output     (HL)=(DE)-(HL)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUBX
        ld a,#80
        jr l34a3

;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)+(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_ADD
        Xor a
.l34a3
        push hl
        pop ix
        push de
        pop iy
        ld b,(ix+#03)
        ld c,(iy+#03)
        Or a
        jr z,l34bc
        jp m,l34ba
        rrca
        Xor c
        ld c,a
        jr l34bc
.l34ba
        Xor b
        ld b,a
.l34bc
        ld a,(ix+#04)
        cp (iy+#04)
        jr nc,l34d8
        ld d,b
        ld b,c
        ld c,d
        Or a
        ld d,a
        ld a,(iy+#04)
        ld (ix+#04),a
        jr z,l3525
        sub d
        cp #21
        jr nc,l3525
        jr l34e9
.l34d8
        Xor a
        sub (iy+#04)
        jr z,l3537
        add (ix+#04)
        cp #21
        jr nc,l3537
        push hl
        pop iy
        ex de,hl
.l34e9
        ld e,a
        ld a,b
        Xor c
        push af
        push bc
        ld a,e
        call l3743
        ld a,c
        pop bc
        ld c,a
        pop af
        jp m,l353c
        ld a,(iy+#00)
        add l
        ld l,a
        ld a,(iy+#01)
        adc h
        ld h,a
        ld a,(iy+#02)
        adc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        adc d
        ld d,a
        jp nc,l37b7
        rr d
        rr e
        rr h
        rr l
        rr c
        inc (ix+#04)
        jp nz,l37b7
        jp l37ea
.l3525
        ld a,(iy+#02)
        ld (ix+#02),a
        ld a,(iy+#01)
        ld (ix+#01),a
        ld a,(iy+#00)
        ld (ix+#00),a
.l3537
        ld (ix+#03),b
        scf
        ret
.l353c
        Xor a
        sub c
        ld c,a
        ld a,(iy+#00)
        sbc l
        ld l,a
        ld a,(iy+#01)
        sbc h
        ld h,a
        ld a,(iy+#02)
        sbc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        sbc d
        ld d,a
        jr nc,l356d
        ld a,b
        cpl
        ld b,a
        Xor a
        sub c
        ld c,a
        ld a,#00
        sbc l
        ld l,a
        ld a,#00
        sbc h
        ld h,a
        ld a,#00
        sbc e
        ld e,a
        ld a,#00
        sbc d
        ld d,a
.l356d
        jp l37ac
.l3570
        ld de,#b109
        call l2f90
        ex de,hl

;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)*(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_MULT
        push de
        pop iy
        push hl
        pop ix
        ld a,(iy+#04)
        Or a
        jr z,l35ad
        dec a
        call l36af
        jr z,l35ad
        jr nc,l35aa
        push af
        push bc
        call l35b0
        ld a,c
        pop bc
        ld c,a
        pop af
        bit 7,d
        jr nz,l35a3
        dec a
        jr z,l35ad
        sla c
        adc hl,hl
        rl e
        rl d
.l35a3
        ld (ix+#04),a
        Or a
        jp nz,l37b7
.l35aa
        jp l37ea
.l35ad
        jp l37e2
.l35b0
        ld hl,#0000
        ld e,l
        ld d,h
        ld a,(iy+#00)
        call l35f3
        ld a,(iy+#01)
        call l35f3
        ld a,(iy+#02)
        call l35f3
        ld a,(iy+#03)
        Or #80
.l35cc
        ld b,#08
        rra
        ld c,a
.l35d0
        jr nc,l35e6
        ld a,l
        add (ix+#00)
        ld l,a
        ld a,h
        adc (ix+#01)
        ld h,a
        ld a,e
        adc (ix+#02)
        ld e,a
        ld a,d
        adc (ix+#03)
        ld d,a
.l35e6
        rr d
        rr e
        rr h
        rr l
        rr c
        djnz l35d0
        ret
.l35f3
        Or a
        jr nz,l35cc
        ld l,h
        ld h,e
        ld e,d
        ld d,a
        ret
.l35fb
        call l2f87
        ex de,hl
        push de
        call l2f7d
        pop de

;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)/(DE)
;###            CF=0 Overflow (and ZF=1 -> division by zero)
;### Unchanged  HL,FLO(DE)
.FLO_DIV
        push de
        pop iy
        push hl
        pop ix
        Xor a
        sub (iy+#04)
        jr z,l366a
        call l36af
        jp z,l37e2
        jr nc,l3667
        push bc
        ld c,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
        ld b,(iy+#03)
        set 7,b
        call l369d
        jr c,l3633
        ld a,c
        Or a
        jr nz,l3639
        jr l3666
.l3633
        dec c
        add hl,hl
        rl e
        rl d
.l3639
        ld (ix+#04),c
        call l3672
        ld (ix+#03),c
        call l3672
        ld (ix+#02),c
        call l3672
        ld (ix+#01),c
        call l3672
        ccf
        call c,l369d
        ccf
        sbc a
        ld l,c
        ld h,(ix+#01)
        ld e,(ix+#02)
        ld d,(ix+#03)
        pop bc
        ld c,a
        jp l37b7
.l3666
        pop bc
.l3667
        jp l37ea
.l366a
        ld b,(ix+#03)
        call l37ea
        Xor a
        ret
.l3672
        ld c,#01
.l3674
        jr c,l367e
        ld a,d
        cp b
.l3678
        call z,l36a0
        ccf
        jr nc,l3691
.l367e
        ld a,l
        sub (iy+#00)
        ld l,a
        ld a,h
        sbc (iy+#01)
        ld h,a
        ld a,e
        sbc (iy+#02)
        ld e,a
        ld a,d
        sbc b
        ld d,a
        scf
.l3691
        rl c
        sbc a
        add hl,hl
        rl e
        rl d
        inc a
        jr nz,l3674
        ret
.l369d
        ld a,d
        cp b
        ret nz
.l36a0
        ld a,e
        cp (iy+#02)
        ret nz
        ld a,h
        cp (iy+#01)
        ret nz
        ld a,l
        cp (iy+#00)
        ret
.l36af
        ld c,a
        ld a,(ix+#03)
        Xor (iy+#03)
        ld b,a
        ld a,(ix+#04)
        Or a
        ret z
        add c
        ld c,a
        rra
        Xor c
        ld a,c
        jp p,l36cf
        set 7,(ix+#03)
        sub #7f
        scf
        ret nz
        cp #01
        ret
.l36cf
        Or a
        ret m
        Xor a
        ret
.l36d3
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        sub #80
        scf
        ret

;### FLO_VGL -> Compares (HL) with (DE)
;### Input      (HL)=first value, (DE)=second value
;### Output     A=Result [-1 -> (HL)<(DE), 0 -> (HL)=(DE), 1 -> (HL)>(DE)]
;###            ZF=1 -> (HL)=(DE), CF=1 -> (HL)<(DE)
;### Unchanged  BC,DE,HL,FLO(HL),FLO(DE)
.FLO_VGL
        push hl
        pop ix
.l36e2
        push de
        pop iy
        ld a,(ix+#04)
        cp (iy+#04)
        jr c,l3719
        jr nz,l3722
        Or a
        ret z
        ld a,(ix+#03)
        Xor (iy+#03)
        jp m,l3722
        ld a,(ix+#03)
        sub (iy+#03)
        jr nz,l3719
        ld a,(ix+#02)
        sub (iy+#02)
        jr nz,l3719
        ld a,(ix+#01)
        sub (iy+#01)
        jr nz,l3719
        ld a,(ix+#00)
        sub (iy+#00)
        ret z
.l3719
        sbc a
        Xor (iy+#03)
.l371d
        add a
        sbc a
        ret c
        inc a
        ret
.l3722
        ld a,(ix+#03)
        jr l371d

;### FLO_SGN -> Tests the sign of (HL)
;### Input      (HL)=value
;### Output     A=sign [-1 -> (HL)<0, 0 -> (HL)=0, 1 -> (HL)>0]
;###            ZF=1 -> (HL)=0, CF=1 -> (HL)<0
;### Unchanged  BC,DE,HL,IY,FLO(HL)
.FLO_SGN
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        jr l3722

;### FLO_VZW -> Changes the sign of (HL)
;### Input      (HL)=value
;### Output     (HL)=-(HL)
;### Unchanged  BC,DE,HL,IY
.FLO_VZW
        push hl
        pop ix
.l3734
        ld a,(ix+#03)
        Xor #80
        ld (ix+#03),a
        ret
.l373d
        cp #21
        jr c,l3743
        ld a,#21
.l3743
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld h,(hl)
        ld l,c
        ex de,hl
        set 7,d
        ld bc,#0000
        jr l375e
.l3753
        ld c,a
        ld a,b
        Or l
        ld b,a
        ld a,c
        ld c,l
        ld l,h
        ld h,e
        ld e,d
        ld d,#00
.l375e
        sub #08
        jr nc,l3753
        add #08
        ret z
.l3765
        srl d
        rr e
        rr h
        rr l
        rr c
        dec a
        jr nz,l3765
        ret
.l3773
        jr nz,l378c
        ld d,a
        ld a,e
        Or h
        Or l
        Or c
        ret z
        ld a,d
.l377c
        sub #08
        jr c,l379a
        ret z
        ld d,e
        ld e,h
        ld h,l
        ld l,c
        ld c,#00
        inc d
        dec d
        jr z,l377c
        ret m
.l378c
        dec a
        ret z
        sla c
        adc hl,hl
        rl e
        rl d
        jp p,l378c
        ret
.l379a
        Xor a
        ret
.l379c
        push hl
        pop ix
        ld (ix+#04),b
        ld b,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
.l37ac
        ld a,(ix+#04)
        dec d
        inc d
        call p,l3773
        ld (ix+#04),a
.l37b7
        sla c
        jr nc,l37cd
        inc l
        jr nz,l37cd
        inc h
        jr nz,l37cd
        inc de
        ld a,d
        Or e
        jr nz,l37cd
        inc (ix+#04)
        jr z,l37ea
        ld d,#80
.l37cd
        ld a,b
        Or #7f
        And d
        ld (ix+#03),a
        ld (ix+#02),e
        ld (ix+#01),h
        ld (ix+#00),l
.l37dd
        push ix
        pop hl
        scf
        ret
.l37e2
        Xor a
        ld (ix+#04),a
        jr l37dd
.l37e8
        ld b,#00
.l37ea
        push ix
        pop hl
        ld a,b
        Or #7f
        ld (ix+#03),a
        Or #ff
        ld (ix+#04),a
        ld (hl),a
        ld (ix+#01),a
        ld (ix+#02),a
        ret

;--- begin variables ----------------------------------------------------------

FLO_VALUE_DEGRAD    db 0
FLO_VALUE_RND       ds 4

;--- begin constants ----------------------------------------------------------

.Pi:
.Symbasic_FLO_CONST_PI		                    ;=PI
        db #a2,#da,#0f,#49,#82,0				;**** Padded out with a Zero

.FLO_CONST_LOG
        db #34,#f3,#04,#35,#80
.FLO_CONST_LOGNAT
        db #f8,#17,#72,#31,#80
.FLO_CONST_LOGDEC
        db #85,#9a,#20,#1a,#7f

.FLO_CONST_POTE1
        db #29,#3b,#aa,#38,#81
.FLO_CONST_POTE2
        db #c7,#33,#0f,#30,#87
.FLO_CONST_POTE3
        db #f8,#17,#72,#b1,#87

.FLO_CONST_SINA
        db #6e,#83,#f9,#22,#7f
.FLO_CONST_SINB
        db #b6,#60,#0b,#36,#79
.FLO_CONST_SINC
        db #13,#35,#fa,#0e,#7b
.FLO_CONST_TAN
        db #d3,#e0,#2e,#65,#86

.FLO_CONST_A
        db #f0,#1f,#bc,#3e,#96
.FLO_CONST_B
        db #fe,#27,#6b,#6e,#9e
.FLO_CONST_C
        db #00,#00,#00,#00,#81

.FLO_CONST_D1
        db #00,#00,#00,#20,#84
        db #00,#00,#00,#48,#87
        db #00,#00,#00,#7a,#8a
        db #00,#00,#40,#1c,#8e
        db #00,#00,#50,#43,#91
        db #00,#00,#24,#74,#94
        db #00,#80,#96,#18,#98
        db #00,#20,#bc,#3e,#9b
        db #00,#28,#6b,#6e,#9e
        db #00,#f9,#02,#15,#a2
        db #40,#b7,#43,#3a,#a5
        db #10,#a5,#d4,#68,#a8
.FLO_CONST_D2
        db #2a,#e7,#84,#11,#ac
			