;*******************************
;***** Symbos Code Library *****
;*******************************

;Library SyStr_LenMax
;*********************************************
;**** Get the Maximum Length of a System String
;**** IN - HL = Start of Text
;		dec		hl
;		ld		a,(hl)
;		inc		hl
;		ret
;*********************************************
;EndLib

;Library SyStr_Len
;*********************************************
;**** Get the Length of a System String
;**** IN - HL = Address Start of Text
;**** OUT - HL = Address End of Text
;****       B = Length
;		ld		b,0
;.SyStr_Len2
;		ld		a,(hl)
;		And		a
;		ret		z
;		inc		hl
;		inc		b
;		jr		SyStr_Len2	
;*********************************************
;EndLib

Library SyStr_Copy
;*********************************************
;**** Copy a String to Another String (without exceeeding Destingation string size)
;**** IN - DE = Addr of Source String
;****      HL = Addr of Destination String
		dec		hl
		ld		a,(hl)
		And		a
		jr		z,SyStr_Copy_2
		ld		b,a
		inc		hl
.SyStr_Copy_1
		ld		a,(de)
		ld		(hl),a
		inc		hl
		inc		de
		And		a
		jr		z,SyStr_Copy_2
		djnz	SyStr_Copy
.SyStr_Copy_2
		ret
;*********************************************
EndLib

Library SyMath_RND16
;*********************************************
;**** Random number generator 16 bit
;**** IN - Nowt
;**** OUT - HL = Random
;**** Corrupts A,DE,F 
		ld		de,(SyMath_RndSeed)		; Seed is usually 0
		ld		a,d
		ld		h,e
		ld		l,253
		Or		a
		sbc		hl,de
		sbc		a,0
		sbc		hl,de
		ld		d,0
		sbc		a,d
		ld		e,a
		sbc		hl,de
		jr		nc,SyMath_Rand
		inc		hl
.SyMath_Rand
		ld		(SyMath_RndSeed),hl
		ret
EndL		
;*******************************************
Library SyMath_RndSeed
;*******************************************
;**** Just the Seeding Word 
		dw	0	
;*******************************************
EndL

;Library SyVar_Num2Str
;*******************************************
;### CLCNUM -> Converts 16Bit-number into an ASCII-string (terminated by 0)
;### Input      IX=Value, E=maximum number of digits
;### Output     IY=points to last char of the string (before 0)
;### Changed    AF,BC,DE,HL,IX,IY
;.SyVar_clcnumt
;		dw 1,10,100,1000,10000
;.SyVar_Num2Str
;		ld d,0
;       ld b,e
;      dec e
;        push ix
;        pop hl
;        ld ix,clcnumt
;        add ix,de
;        add ix,de               ;IX=erster Teiler
;        dec b
;        jr z,clcnum4
;        ld c,0
;clcnum1 ld e,(ix)
;        ld d,(ix+1)
;        dec ix
;        dec ix
;        ld a,"0"
;        Or a
;clcnum2 sbc hl,de
;        jr c,clcnum5
;        inc c
;        inc a
;        jr clcnum2
;clcnum5 add hl,de
;        inc c
;        dec c
;        jr z,clcnum3
;        ld (iy+0),a
;        inc iy
;clcnum3 djnz clcnum1
;clcnum4 ld a,"0"
;        add l
;        ld (iy+0),a
;        ld (iy+1),0
;        ret
;EndLib

Library SyMath_Mult32
;*******************************************
; In: IY/IX: eerste getal (low/high)
;     HL/BC: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				exx
                ld      hl,0
                ld      de,0
                exx
SyMath_Multi32_lp:
				srl     b
                rr      c
                rr      h
                rr      l
                jp      nc,SyMath_multi32_2
                exx
                push    iy
                pop     bc
                add     hl,bc
                ex      de,hl
                push    ix
                pop     bc
                adc     hl,bc
                ex      de,hl
                exx
SyMath_multi32_2:
				ld      a,h
                Or      l
                jp      nz,SyMath_Multi32_3
                ld      a,b
                Or      c
                jp      z,SyMath_multi32_5
SyMath_multi32_3:
				add     iy,iy
                jp      nc,SyMath_multi32_4
                add     ix,ix
                inc     ix
                jp      SyMath_multi32_lp
SyMath_multi32_4:
				add     ix,ix
                jp      SyMath_multi32_lp
SyMath_multi32_5:
				exx
                ret
;**************************************
EndLib

Library SyMath_Div32
;**************************************
; In: HL/DE: teller (low/high)
;     IX/IY: noemer (low/high)
; Uit: HL/DE: resultaat (low/high)
		        push    hl
                push    de
                push    ix
                push    iy
                pop     de
                exx
                pop     de
                pop     bc
                pop     iy
                ld      hl,0
                exx
                ld      hl,0
                ld      b,32
.SyMath_divide32_1
				exx
                add     iy,iy
                rl      c
                rl      b
                adc     hl,hl
                exx
                adc     hl,hl
                exx
                sbc     hl,de
                exx
                sbc     hl,de
                inc     iy
                jp      nc,SyMath_divide32_2
                dec     iy
                exx
                add     hl,de
                exx
                adc     hl,de
.SyMath_divide32_2
				djnz    SyMath_divide32_1
                exx
                push    bc
                exx
                pop     de
                push    iy
                pop     hl
                ret
;*************************************
EndLib

Library SyMath_Add32
;*************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				push    ix
                pop     bc
                add     hl,bc
                ex      de,hl
                push    iy
                pop     bc
                adc     hl,bc
                ex      de,hl
                ret
;************************************
EndLib

Library SyMath_Sub32
;************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				push    ix
                pop     bc
                Xor     a
                sbc     hl,bc
                ex      de,hl
                push    iy
                pop     bc
                sbc     hl,bc
                ex      de,hl
                ret
;************************************
EndLib