;*******************************
;**** SymBasic Code Library ****
;*******************************


;****      ABS       ****
;**** Do Integer ABS ****
;****                ****
Library SyB_Abs_Int
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		z
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret		
EndLib

;****     ABS      ****
;**** Do Float ABS ****
;****              ****
Library SyB_Abs_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		res		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret
EndLib

;****      ADD       ****
;**** Do Integer Add ****
;****                ****
Library SyB_INT_Add
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de						;***** Add Integers Together
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib
			
;****     ADD      ****
;**** Do Float Add ****
;****              ****
Library SyB_FLO_Add
		call	SyB2_STACK_2_FLO
		call 	FLO_ADD
		jp		SyB_DecStack
EndLib

;****      AND       ****
;**** Do Integer AND ****
;****                ****
Library SyB_INT_And
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		(iy+13)
		ld		(iy+13),a
		ld		a,(iy+8)
		And		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****   ASC  ****
;**** Do ASC ****
;****        ****
Library SyB_ASC
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)					;**** Address of Text
		ld		d,(iy+8)					;**** Address of Text
		ld		c,(iy+9)					;**** Len of text
		ld		a,(de)
		ld		(iy+7),a
		ld		(iy+8),0
		Xor		a
		ld		hl,(SyB_StrStackAddr)
		ld		b,0
		sbc		hl,bc
		ld		(syB_StrStackAddr),hl
		ret
EndLib

;****   ATAN  ****
;**** Do ATAN ****
;****         ****
Library SyB_ATAN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_ARC_TAN
EndLib

;****     BANKSIZE       ****
;**** Bank Size Function ****
;****                    ****
Library SyB_BankSize
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_BankSize_Error
		ld		de,4
		add		hl,de
		ld		a,(hl)
		inc		hl
		ld		(iy+7),a
		ld		a,(hl)
		ld		(iy+8),a
		ret
.SyB_BankSize_Error			
		ld		(iy+7),0
		ld		(iy+8),0
		ret
EndLib		

;****   CHR   ****
;**** Do CHR$ ****
;****         ****
Library SyB_Chr
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		ld		hl,(SyB_StrStackAddr)
		;ld		(iy+6),5
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),1
		ld		(hl),a
		inc		hl
		ld		(SyB_StrStackAddr),hl
		ret
EndLib

;****      CLEARBANK     ****
;**** Clear Bank Command ****
;****                    ****
Library SyB_ClearBank
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		nz,SyB_ClearBank_3
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		ld		e,c
		ld		d,b
.SyB_ClearBank_2		
		ld		b,0
		rst		#20:	dw #812D
		dec		e
		jp		nz,SyB_ClearBank_2
		dec		d
		jp		nz,SyB_ClearBank_2		
.SyB_ClearBank_3
		ret
EndLib

;****     DIRDIALOG      ****
;**** DirDialog function ****
;****                     ****
Library SyB_DirDialog:
		ld		a,(AppBnkNum)
		set		7,a
		ld		(SyB_FileDialog_Extra),a
		jp		SyB_FileDialog
EndLib

;****       DIVIDE        ****
;**** Do Integer Division ****
;****                     ****
Library SyB_INT_Div
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),l
		ld		(iy+14),h
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib		
		
;****      DIVIDE       ****
;**** Do Float Division ****
;****                   ****		
Library SyB_FLO_DIV
		call	SyB2_STACK_2_FLO
		call	FLO_DIV
		jp		SyB_DecStack
EndLib

;****      EOF     ****
;**** EOF Function ****
;****              ****
Library SyB_Eof
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_Eof_OK_1
		cp		174						;ReadFile
		jp		z,SyB_Eof_OK_1
		cp		175						;WriteFile
		jp		z,SyB_Eof_OK_1		
		;*** Failed
		ld		(iy+7),0
		ld		(iy+8),0
		ld		bc,0
		ld		de,288					;1 / 32
		jp		SyB_Mark_Error
.SyB_Eof_OK_1:
		push	hl
		pop		ix
		ld		e,(ix+8)
		ld		d,(ix+9)
		;Check if de=0 - If it is then EOF true
		Xor		a
		cp		e
		jp		nz,SyB_Eof_OK_2
		cp		d
		jp		z,SyB_Eof_True7
.SyB_Eof_OK_2:
		ld		l,(ix+4)
		ld		a,(ix+5)
		And		%1
		ld		h,a
		Xor		a
		sbc		hl,de
		jp		c,SyB_Eof_False
.SyB_Eof_True:
		ld		a,1		
.SyB_Eof_False:
		

		ld		(iy+7),a
		ld		(iy+8),0		
		ret
		
.SyB_Eof_True7
		di
.fjtt	jr		fjtt		
		
Endlib


;****     CLOSEFILE      ****
;**** CloseFile Function ****
;****                    ****
Library SyB_CloseFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_CloseFile_OK_1
		cp		174						;ReadFile
		jp		z,SyB_CloseFile_OK_1
		cp		175						;WriteFile
		jp		z,SyB_CloseFile_OK_1		
		;*** Failed
		ld		de,288					;1 / 32
		jp		SyB_Mark_Error

		ret
.SyB_CloseFile_OK_1:
		push	hl
		pop		ix
		ld		a,(ix+1)
		cp		1
		jp		nz,SyB_CloseFile_OK_2
		;*** Must write file
		call	SyB_Write_512_Bytes
.SyB_CloseFile_OK_2:
		ld		(ix+0),0
		ld		a,(ix+3)
		call	SyFile_FILCLO
		ld		iy,(Syb_StackAddr)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****     CLOSEFORM      ****
;**** CloseForm Function ****
;****                    ****		
Library SyB_CloseForm:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		call	SyB_Studio_CloseForm
		ld		a,(SyB_Studio_FormOS)
		call	SyDesktop_WINCLS
		ret
EndLib

;****      CREATEBANK      ****
;**** Create Bank Function ****
;****                      ****
Library SyB_CreateBank
		ld		iy,(SyB_StackAddr)
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,15							;Number of Banks Possible-1
		ld		de,8							;Bytes to jump (Each Bank Ref is 6 bytes)
		Xor		a								;A=0
.SyB_CreateBank_1			
		cp		(hl)
		jr		z,SyB_CreateBank_FoundSlot		;Until (hl)<>0
		add		hl,de							;Jump over next
		djnz	SyB_CreateBank_1				;Repeat until Empty bank found or 15 are used
		jp		SyB_CreateBank_Error
SyB_CreateBank_FoundSlot
		ld		c,(iy+7)
		ld		b,(iy+8)
		push	bc
		push	hl
		Xor		a
		ld		e,a
		rst		#20
		dw		#8118
		pop		de
		jp		c,SyB_CreateBank_Error		
		ex		de,hl
		ld		c,172
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(hl),c
		inc		hl
		ld		(hl),a							;Stores Bank
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		pop		bc
		ld		(hl),c
		inc		hl
		ld		(hl),b		
		ret
		
SyB_CreateBank_Error
		pop		hl
		ld		(iy+7),0
		ld		(iy+8),0
		ret
Endlib

;****     COLOURDEPTH      ****		
;**** ColourDepth Function ****		
;****                      ****
Library SyB_ColourDepth:
		ld 		hl,#8139
		rst 	#28
		ld		a,d
		And		%1111
		ld		d,a
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****   COS  ****
;**** Do COS ****
;****        ****
Library SyB_COS
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_COS
EndLib

;****          DEG          ****
;**** DEG - Set Degree Mode ****
;****                       ****
Library SyB_Deg:
		ld		a,1
		ld		(FLO_VALUE_DEGRAD),a
		ret
EndLib		

;****       DIALOG       ****
;**** Dialog Box Command ****
;****                    ****
Library SyB_Dialog
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		%1111
		add		a
		add		a
		add		2
		ld		(SyB_Dialog_Info_1+2),a
		ld		(SyB_Dialog_Info_2+2),a
		ld		(SyB_Dialog_Info_3+2),a				
		ld		e,(iy+21)				;Originals stack length
		ld		hl,(SyB_StrStackAddr)
		ld		d,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		ld		c,e
		
		ld		e,(iy+19)				;DE = Address of Text
		ld		d,(iy+20)		
		ld		hl,SyB_Dialog_Info_Text_1	
		
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_2
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_3
		call	SyB_Dialog_Text_Copier					
		
		ld		hl,SyB_Dialog_Info_1
		ld		a,(iy+13)
		And		%11
		ld		e,a
		push	iy
		ld		a,(appBnkNum)
		call	SySystem_SYSWRN
		
.SyB_Dialog_Control_Loop:
		call	SymStudio_App_Wait_Message	;**** See what Event has occurre
		jr		nc,SyB_Dialog_Control_Loop_0
		cp		157
		jr		nz,SyB_Dialog_Control_Loop_0
		ld		a,(Event_Form_ID)			;Position 1
		jp		SyB_Dialog_Control_Loop_2
		cp		0
		jp		nz,SyB_Dialog_Control_Loop_2
.SyB_Dialog_Control_Loop_0
		Xor		a
		ld		(V_App_In_Use),a
		jr		SyB_Dialog_Control_Loop
.SyB_Dialog_Control_Loop_2
		pop		iy
		ld		(iy+19),a
		ld		(iy+20),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;**** Copies Text from DE into HL ****
;**** C=Length left
.SyB_Dialog_Text_Copier		
		ld		b,31
.SyB_Dialog_Loop_1		
		ld		a,c
		Or		a
		jp		z,SyB_Dialog_Loop_2
		dec		c
		ld		a,(de)
		inc		de
		cp		"|"			
		jp		z,SyB_Dialog_Loop_2
		ld		(hl),a
		inc		hl
		dec		b
		djnz	SyB_Dialog_Loop_1
.SyB_Dialog_Loop_2
		Xor		a
		ld		(hl),a
		ret
EndLib

;****  EXP   ****		
;**** Do EXP ****
;****        ****
Library SyB_EXP
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_POT_E
EndLib


;****     FOR STARTER       ****
;**** For Command (Integer) ****
;****                       ****
Library SyB_ForStarter_Int
		ld		iy,(SyB_StackAddr)
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		
		ld		a,(iy+19)		
		ld		(de),a
		ld		(iy+19),e
		inc		de
		ld		a,(iy+20)
		ld		(de),a
		dec		de
		ld		(iy+20),d
		
		;**** Check What sort of step ****
		ld		a,(iy+8)
		bit		7,a
		jp		z,SyB_ForStarter_Int_2
		ld		(iy+21),1
		jp		(hl)
.SyB_ForStarter_Int_2:		
		ld		(iy+21),0
		jp		(hl)
Endlib

;****         FOR           ****
;**** For Command (Integer) ****
;****                       ****
Library SyB_For_Int
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(iy+21)
		And		a
		jp		z,SyB_For_Int_PositiveStep
		ex		de,hl
		Xor		a
.SyB_For_Int_PositiveStep		
		sbc		hl,de
		jp		c,SyB_ForInt_Exit		
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)
.SyB_ForInt_Exit
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy	
		jp		(hl)
endlib

;****      FILEPOS     ****
;**** FilePos Function ****
;****                  ****
Library SyB_FilePos
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_FilePos_OK_1
		cp		174						;ReadFile
		jp		z,SyB_FilePos_OK_1
		cp		175						;WriteFile
		jp		z,SyB_FilePos_OK_1		
		;*** Failed
		ld		bc,0					;Stack Change
		ld		de,255					;Error Number
		jp		SyB_Mark_Error
.SyB_FilePos_OK_1:
		ld		bc,4
		add		hl,bc
		push	hl
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		pop		de
		ex		de,hl
		push	de
		ldi
		ldi
		ldi
		ldi
		pop		hl
		Xor		a
		call	FLO_KONV_LW_TO_FLO
		ret
EndLib

;****     FILESIZE      ****
;**** FileSize Function ****
;****                   ****
Library SyB_FileSize
		call	SyB_GetOpenAFile
		jp		c,SyB_FileSize_Fail_1
		push	af
		ld		iy,0
		ld		ix,0
		ld		c,2
		call	SyFile_FILPOI

		push	ix
		push	iy
		pop		de
		pop		bc
		ld		iy,(SyB_StackAddr)
		Xor		a
		ld		(iy+7),c
		ld		(iy+8),b
		ld		(iy+9),e
		ld		(iy+10),d
		ld		hl,(SyB_StackAddr)
		ld		bc,7		
		add		hl,bc
		call	FLO_KONV_LW_TO_FLO
		pop		af
		call	SyFile_FILCLO
		ret
.SyB_FileSize_Fail_1:
		ld		bc,0
		ld		e,a
		ld		d,1
		jp		SyB_Mark_Error
EndLib		

;****     FREEBANK      ****
;**** Free Bank Command ****
;****                   ****
Library SyB_FreeBank
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		z,SyB_FreeBank_4
		cp		180					;Free Sheet
		jp		nz,SyB_FreeBank_3
.SyB_FreeBank_4		
		Xor		a
		ld		(hl),a
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl		
		rst 	#20:dw 	#811B
SyB_FreeBank_3
		ret		
EndLib

;****          GARBAGE           ****
;**** Garbage Collection Command ****
;****                            ****
;See bottom of String Text Area

;****      GETSECOND     ****
;**** Function GetSecond ****
;****                    ****
Library SyB_GetSecond
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
EndLib

;****      GETMINUTE     ****
;**** Function GetMinute ****
;****                    ****
Library SyB_GetMinute
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),b
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****      GETHOUR     ****
;**** Function GetHour ****
;****                  ****
Library SyB_GetHour
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),c
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
EndLib

;****      GETDAY     ****
;**** Function GetDay ****
;****                 ****
Library SyB_GetDay
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****      GETMONTH     ****
;**** Function GetMonth ****
;****                   ****
Library SyB_GetMonth
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),e
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy			
		ret
EndLib

;****      GETYEAR      ****
;**** Function GetYear  ****
;****                   ****
Library SyB_GetYear
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib


;****     GETOBJID      ****
;**** Function GetObjID ****
;****                   ****
Library SyB_GetObjID
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+13)
		dec		a
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)
		ld		d,0	
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+0)
		ld		(iy+13),a
		ld		a,(ix+1)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****     GETOBJLEFT      ****
;**** Function GetObjLeft ****
;****                     ****
Library SyB_GetObjLeft
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+6)
		ld		(iy+7),a
		ld		a,(ix+7)
		ld		(iy+8),a
		ret
EndLib	

;****      GETOBJTOP     ****
;**** Function GetObjTop ****
;****                    ****
Library SyB_GetObjTop
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0		
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+8)
		ld		(iy+7),a
		ld		a,(ix+9)
		ld		(iy+8),a
		ret
EndLib

;****      GETOBJWIDTH     ****
;**** Function GetObjWidth ****
;****                      ****
Library SyB_GetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+10)
		ld		(iy+7),a
		ld		a,(ix+11)
		ld		(iy+8),a
		ret
EndLib

;****      GETOBJHEIGHT     ****
;**** Function GetObjHeight ****
;****                       ****
Library SyB_GetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+12)
		ld		(iy+7),a
		ld		a,(ix+13)
		ld		(iy+8),a
		ret
EndLib
	
;****      GETOBJVISIBLE     ****
;**** Function GetObjVisible ****
;****                        ****
Library SyB_GetObjVisible
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+2)
		And		%10000000
		jp		z,SyB_GetObjVisible_1
		Xor		a
		jp		SyB_GetObjVisible_2
.SyB_GetObjVisible_1		
		ld		a,1
.SyB_GetObjVisible_2		
		ld		(iy+7),a
		ld		(iy+8),0
		ret
EndLib

;****      GETOBJTEXT     ****
;**** Function GetObjText ****
;****                     ****
Library SyB_GetObjText
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		e,(ix+2)
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_GetObjText_Empty
		
		bit		7,a
		jp		z,SyB_GetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111
		jp		SyB_GetObjText_3
.SyB_GetObjText_2:
		push	ix
		pop		hl
.SyB_GetObjText_3:		
		ld		e,a
		ld		d,0
		add		hl,de	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		b,0
.SyB_GetObjText_5:			
		ld		a,(de)
		And		a
		jp		z,SyB_GetObjText_4
		ld		(hl),a
		inc		de
		inc		hl
		inc		b
		jr		SyB_GetObjText_5
.SyB_GetObjText_4:
		ld		(SyB_StrStackAddr),hl
		ld		(iy+9),b
		ret
.SyB_GetObjText_Empty:
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),0
		ret
EndLib

.SyB_Obj_Text_Pointer:
		db			0					;0 - 
		db			0+128				;1 - Label
		db			0					;2 -
		db			0+128				;3 - Frame
		db			0					;4
		db			0					;5
		db			0+128				;6 - CtrLabel
		db			0					;7
		db			0					;8
		db			0					;9
		db			0					;10
		db			0					;11															
		db			0					;12
		db			0					;13
		db			0					;14
		db			0					;15
		db			4					;16 - Button
		db			2+128				;17 - Check
		db			2+128				;18 - Radio
		db			0					;19
		db			0					;20																
		db			0					;21	
		db			0					;22	
		db			0					;23	
		db			0					;24	
		db			0					;25	
		db			0					;26	
		db			0					;27	
		db			0					;28	
		db			0					;29
		db			0					;30	
		db			0					;31	
		db			0+128				;32 - Text Input										
																
;****       IF         ****
;**** Basic IF Command ****
;****                  ****
Library SyB_IF
		ld		bc,7
		ld		hl,(SyB_StackAddr)
		add		hl,bc		
		Xor		a
		cp		(hl)					;7
		jr		nz,SyB_IF_2_1
		inc		hl
		cp		(hl)					;7
		jr		nz,SyB_IF_2
.SyB_IF_1								;So The result was False
		dec		hl
		dec		hl
		ld		(Syb_StackAddr),hl
		pop		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		jp		(hl)
.SyB_IF_2
		dec		hl
.SyB_IF_2_1		
		dec		hl
		ld		(Syb_StackAddr),hl
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)		
EndLib		

;****      LEFT     ****
;**** LEFT Function ****
;****               ****
Library SyB_Left
		ld		ix,(SyB_StackAddr)
		ld		b,(ix+7)
		ld		a,(ix+15)				;Originals stack length
		sub		b
		ret		c
		ld		(ix+15),b
		ld		c,a
		ld		b,0
		Xor		a						;Sets no carry flag etc
		ld		hl,(SyB_StrStackAddr)
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret
EndLib

;****  LEN   ****
;**** Do Len ****
;****        ****
Library SyB_LEN
		ld		hl,(SyB_StackAddr)
		ld		bc,9
		add		hl,bc
		ld		c,(hl)
		dec		hl
		Xor		a
		ld		(hl),a
		dec		hl
		ld		(hl),c
		dec		hl
		ld		(hl),a
		ld		hl,(SyB_StrStackAddr)
		Xor		a
		ld		b,0
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ret
EndLib		

;****  LCASE$   ****
;**** Do LCASE$ ****
;****           ****
Library SyB_LCase
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(iy+9)
		cp		0
		ret		z
		ld		b,a

.SyB_LCase_1
		ld		a,(hl)
		cp 		65
		jr		c,SyB_LCase_3
		cp		91
		jr		nc,SyB_LCase_3
		add		32
		ld		(hl),a
.SyB_LCase_3
		inc		hl
		djnz	SyB_LCase_1
		ret
EndLib

;****     LOADSHEET      ****
;**** LoadSheet Function ****
;****                    ****
Library SyB_LoadSheet:
		call	SyB_GetOpenAFile
		jp		c,SyB_LoadSheet_Fail_1
		ld		(SyB_LoadSheet_fileHandle),a
		;Find Length
		ld		iy,0
		ld		ix,0
		ld		c,2
		call	SyFile_FILPOI
		ld		(SyB_LoadSheet_fileLength),ix
		;Reset to Start
		ld		a,(SyB_LoadSheet_fileHandle)
		ld		ix,0
		ld		iy,0
		ld		c,0
		call	SyFile_FILPOI		
		;Find a Slot in Ram
		ld		bc,(SyB_LoadSheet_fileLength)
		Xor		a					;A = 0 - Look in any RamBank
		ld		e,1					;E = 1 - Look only in Data Areas
		rst 	#20:dw #8118
		jp		c,SyB_LoadSheet_Fail_2
		ld		(SyB_LoadSheet_fileBank),a
		ld		(SyB_LoadSheet_fileStart),hl
		;Find slot in List
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,15							;Number of Banks Possible-1
		ld		de,8							;Bytes to jump (Each Bank Ref is 6 bytes)
		Xor		a								;A=0
.SyB_LoadSheetBank_1			
		cp		(hl)
		jr		z,SyB_LoadSheetBank_FoundSlot		;Until (hl)<>0		
		add		hl,de
		djnz	SyB_LoadSheetBank_1
		jp		SyB_LoadSheet_Fail_1
.SyB_LoadSheetBank_FoundSlot
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		c,180
		ld		(hl),c					;180 Represents Sheet
		inc		hl
		ld		a,(SyB_LoadSheet_fileBank)
		ld		(hl),a					;Bank to Store
		inc		hl
		ld		de,(SyB_LoadSheet_fileStart)
		ld		(hl),e					;Where stored Low
		inc		hl
		ld		(hl),d					;Where Stored High
		inc		hl
		ld		bc,(SyB_LoadSheet_fileLength)
		ld		(hl),c					;Length
		inc		hl
		ld		(hl),b					;Length
		;Load Data into Slot
		
		push	ix
		push	iy
		ex		de,hl					;HL = Where
		ld		e,a						;E = Destination Bank
		ld		a,(SyB_LoadSheet_fileHandle)
		call	SyFile_FILINP
		;Close file
		ld		a,(SyB_LoadSheet_fileHandle)		
		call	SyFile_FILCLO
		pop		iy
		pop		ix
		
		;Get Number of Tiles
		ld		a,(SyB_LoadSheet_fileBank)
		ld		hl,(SyB_LoadSheet_fileStart)
		rst 	#20:dw #8124
		ld		(SyB_LoadSheet_fileTile),bc
		;Modify Addresses
.SyB_LoadSheetBank_MakeChanges
		Xor 	a
		cp		c
		jp		nz,SyB_LoadSheetBank_MakeChanges_2
		cp		b
		jp		z,SyB_LoadSheetBank_Finished
.SyB_LoadSheetBank_MakeChanges_2
		ld		a,(SyB_LoadSheet_fileBank)		
		push	hl
		push	hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,3					;We need Word 3/4 (Graphic Data Offset)
		add		hl,bc					;Adds 3
		push	hl						;Stores HL
		ld		bc,7					;Address we want to put in is +7 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 3/4 (Graphic Data Offset)
		rst 	#20:dw #8127			;Stores BC into (A HL)
		pop		hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,5					;We need Word 5/6 (Encode Data Byte Address)
		add		hl,bc					;Adds 5
		push	hl						;Stores HL
		ld		bc,4					;Address we want to put in is +4 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 5/6 (Encode Address)
		rst 	#20:dw #8127			;Stores BC into (A HL)		
		pop		hl
		inc		hl
		inc		hl
		ld		bc,(SyB_LoadSheet_fileTile)
		dec		bc
		ld		(SyB_LoadSheet_fileTile),bc
		jp		SyB_LoadSheetBank_MakeChanges
		;Done it
.SyB_LoadSheetBank_Finished		
		ret

.SyB_LoadSheet_Fail_1
		nop
		nop
		nop
		di
.shee	jr		shee		
.SyB_LoadSheet_Fail_2				;**** Not enough Memory free
		di
.shee2	jr		shee2		

.SyB_LoadSheet_fileHandle:	db	0
.SyB_LoadSheet_fileLength:	dw	0
.SyB_LoadSheet_fileStart:	dw	0
.SyB_LoadSheet_fileBank:	db	0
.SyB_LoadSheet_fileTile:	dw	0

endlib		

;****  LOG   ****		
;**** Do LOG ****
;****        ****
Library SyB_LOG
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_NAT
EndLib
		
;****  LOG10   ****		
;**** Do LOG10 ****
;****          ****
Library SyB_LOG10
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_DEC
EndLib

;****     MACHINE     ****
;**** Macine Function ****
;****                 ****
Library SyB_Machine:
		ld 		hl,#8139
		rst 	#28
		ld		hl,SyB_Machine_TypeList
		ld		d,0
		add		hl,de
		ld		c,(hl)
		ld		hl,(SyB_StackAddr)
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),c
		inc		hl
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret
.SyB_Machine_TypeList:		db	0,1,1,2,2,2,2,2,2,2			;0=PCW 1=CPC 2=MSX
EndLib

;****     MID$     ****
;**** Mid Function ****
;****              ****
Library SyB_MID
		ld		ix,(SyB_StackAddr)
		ld		c,(ix+7)				;Length Required
		ld		a,(ix+13)				;From Where
		;Must check A (From Where)>0
		dec 	a
		ld		l,a
		ld		h,0
		ld		a,(ix+21)				;Originals stack length
		ld		e,(ix+19)
		ld		d,(ix+20)
		sub		l
		ld		b,a
		jp		c,SyB_MID_Empty
		add		hl,de
		Xor		a
		ld		(SyB_MidTemp),a

.SyB_MID_2	
		ld		a,(SyB_MidTemp)
		cp		b
		jr		z,SyB_MID_3
		cp		c
		jr		z,SyB_MID_3
		inc		a
		ld		(SyB_MidTemp),a
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		jr		SyB_MID_2
.SyB_MID_3	
		ld		e,(ix+19)
		ld		d,(ix+20)
		ld		l,a
		ld		h,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		jr		SyB_MID_4
.SyB_MID_Empty
		Xor		a
		ld		(ix+21),a
		ld		(SyB_StrStackAddr),de
.SyB_MID_4
		ld		(ix+21),a
		ld		hl,(SyB_StackAddr)
		ld		bc,12
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret	
.SyB_MidTemp		db	0
EndLib	

;****       MOD        ****
;**** Do Numerical MOD ****
;****                  ****
.SyB_INT_MOD:
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),e
		ld		(iy+14),d
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret



;****    MOUSEOVER       ****
;**** MouseOver Function ****
;****                    ****
Library SyB_MouseOver:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		And		%1110
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		ld		bc,App_Form_List
		add		hl,bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		pop		ix
		;**** First bit		
		ld		e,(ix+4)
		ld		d,(ix+5)
		ld		l,(ix+12)
		ld		h,0
		add		hl,de
		ld		(SyB_MouseOver_X_Off),hl
		ld		e,(ix+6)
		ld		d,(ix+7)
		Xor		a
		ld		b,(ix+1)
		bit		4,b
		jp		z,SyB_MouseOver_90
		add		9
.SyB_MouseOver_90		
		bit		5,b
		jp		z,SyB_MouseOver_91
		add		9
.SyB_MouseOver_91
		ld		l,a
		ld		h,0
		add		hl,de
		ld		(SyB_MouseOver_Y_Off),hl		
		;**** Check if Item is in a Super Control
		ld		a,(iy+8)				;**** Upper Byte of ID
		And		%111
		jp		z,SyB_MouseOver_1
		;**** Do SUper control Offset gumph
		ld		l,(ix+36)
		ld		h,(ix+37)
		add		a
		add		a
		add		a
		add		a
		ld		e,a
		ld		d,0
		inc		hl
		push	hl
		add		hl,de
		ld		a,(hl)
		pop		hl
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl	
		add		hl,de
		push	hl
		pop		ix
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		hl,(SyB_MouseOver_X_Off)
		add		hl,de
		ld		(SyB_MouseOver_X_Off),hl
		ld		e,(ix+8)
		ld		d,(ix+9)
		ld		hl,(SyB_MouseOver_Y_Off)
		add		hl,de
		ld		(SyB_MouseOver_Y_Off),hl
		
;		di
;		ld		hl,(SyB_MouseOver_X_Off)
;		ld		de,(SyB_MouseOver_Y_Off)
;.drf	jr		drf		
		
			
.SyB_MouseOver_1		
		rst 	#20
		dw 		#813C
		push	hl						;Protect Y
		ld		hl,(SyB_MouseOver_X_Off)
		ex		de,hl
		Xor		a
		sbc		hl,de
		ld		(SyB_MouseOver_X_Off),hl
		pop		hl
		ld		de,(SyB_MouseOver_Y_Off)		
		Xor		a
		sbc		hl,de
		ld		(SyB_MouseOver_Y_Off),hl
		ld		a,(iy+8)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+7)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		de,(SyB_MouseOver_X_Off)
		ld		l,(ix+6)
		ld		h,(ix+7)
		push	hl
		Xor		a
		sbc		hl,de
		pop		hl
		jp		nc,SyB_MouseOver_1_Fail	
		ld		c,(ix+10)
		ld		b,(ix+11)
		add		hl,bc
		sbc		hl,de
		jp		c,SyB_MouseOver_1_Fail
		
		ld		de,(SyB_MouseOver_Y_Off)
		ld		l,(ix+8)
		ld		h,(ix+9)
		push	hl
		Xor		a
		sbc		hl,de
		pop		hl
		jp		nc,SyB_MouseOver_1_Fail	
		ld		c,(ix+12)
		ld		b,(ix+13)
		add		hl,bc
		sbc		hl,de
		jp		c,SyB_MouseOver_1_Fail			
		
		ld		(iy+7),1
		ld		(iy+8),0
		ret

.SyB_MouseOver_1_Fail:
		ld		(iy+7),0
		ld		(iy+8),0
		ret

.SyB_MouseOver_X_Off:	dw	0
.SyB_MouseOver_Y_Off:	dw	0

EndLib

;****    MOUSEX       ****
;**** MouseX Function ****
;****                 ****
Library SyB_MouseX:
		rst 	#20
		dw 		#813C	
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),e
		ld		(iy+2),d
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
EndLib

;****     MOUSEY      ****
;**** MouseY Function ****
;****                 ****
Library SyB_MouseY:
		rst 	#20
		dw 		#813C
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
EndLib

;****     MOUSEKEY      ****
;**** MouseKey Function ****
;****                  ****
Library SyB_MouseKey:
		rst 	#20
		dw 		#813F
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
EndLib

;****      MULTIPLY       ****
;**** Do Integer Multiply ****
;****                     ****
Library SyB_INT_Mul
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB_INT_Mul_11		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_INT_Mul_11
		pop		de
		sbc		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib
		
;****     MULTIPLY      ****
;**** Do Float Multiply ****
;****                   ****				
Library SyB2_FLO_Mul
		call	SyB2_STACK_2_FLO		
		call	FLO_MULT
		jp		SyB_DecStack
EndLib


;****       NEG      ****
;**** Do Integer NEG ****
;****                ****
Library SyB_Neg_Int
		ld		iy,(Syb_StackAddr)
.SyB_Neg_Int_10		
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret
EndLib
		
;****     NEG      ****
;**** Do Float NEG ****
;****              ****
Library SyB_Neg_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		Xor		128							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret
Endlib

;****          NEXT              ****
;**** Command NEXT (For Integers ****
;****                            ****

Library SyB_Next_INT
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		c,(iy+7)
		ld		b,(iy+8)
		ex		de,hl
		add		hl,bc
		ex		de,hl
		ld		(hl),d
		dec		hl
		ld		(hl),e	
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl		
		jp		(hl)
endlib

;****     NOT      ****
;**** NOT Function ****
;****              ****
Library SyB_NOT
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)					
		And		a
		jr		nz,SyB_Not_2
		ld		a,(iy+8)
		And		a
		jr		nz,SyB_Not_2
		ld		(iy+7),1
		jr		SyB_Not_3
.SyB_Not_2		;**** Means <>0 SO Result = 0
		ld		(iy+7),0
.SyB_Not_3
		ld		(iy+8),0
		ret
EndLib

;****     OPENDIALOG      ****
;**** OpenDialog function ****
;****                     ****
Library SyB_OpenDialog:
		ld		a,(AppBnkNum)
		ld		(SyB_FileDialog_Extra),a
		jp		SyB_FileDialog
EndLib


;****     OPENFILE      ****
;**** Openfile function ****
;****                   ****
Library SyB_OpenFile:
		call	SyB_GetOpenAFile
		jp		c,SyB_OpenFile_Fail_1
.SyB_OpenFile_Ok_1
		ld		(SyB_OpenFile_Temp),a			;OS File Number
		call	SyB_FreeFileSlot		
		jp		c,SyB_OpenFile_Fail_2
.SyB_OpenFile_Ok_2
		ld		iy,(SyB_StackAddr)		
		ld		(iy+7),l
		ld		(iy+8),h
		push	hl
		pop		ix
		Xor		a
		ld		b,9
.SyB_OpenFile_Ok_20
		ld		(hl),a
		inc		hl
		djnz	SyB_OpenFile_Ok_20
		ld		(ix+0),173
		ld		a,(SyB_OpenFile_Temp)
		ld		(ix+3),a
		call	SyB_Read_512_Bytes
		ret
.SyB_OpenFile_Fail_1
		ld		e,a
		ld		d,1
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),0
		ld		(iy+8),0
		jp		SyB_Mark_Error
.SyB_OpenFile_Fail_2		
		ld		a,32
		jr		SyB_OpenFile_Fail_1
.SyB_OpenFile_Temp:		db	0		
EndLib

;****     OPENFORM      ****
;**** Openform function ****
;****                   ****
Library SyB_OpenForm:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		
		call	SyB_Studio_WindowOpen
		jp		c,SyB_OpenForm_2
		inc		a
.SyB_OpenForm_2
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		ld		(iy+8),0		
		ret
EndLib		

;****      OR       ****
;**** Do Integer OR ****
;****               ****
Library SyB_INT_Or
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Or		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Or		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib			

;****     PEEKBYTE      ****
;**** Peek Byte Command ****
;****                   ****
Library SyB_PeekByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekByte_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#812A
		ld		(iy+13),b
		ld		(iy+14),0
.SyB_PeekByte_1		
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekByte_2			
		Xor		a
		ld		(iy+7),a
		ld		(iy+8),a
		jp		SyB_PeekByte_1
EndLib

;****     PEEKINT      ****
;**** Peek Int Command ****
;****                  ****
Library SyB_PeekInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekInt_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
.SyB_PeekInt_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekInt_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		jp		SyB_PeekInt_1
EndLib

;****     PEEKFLOAT      ****
;**** Peek Float Command ****
;****                    ****
Library SyB_PeekFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekFloat_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de		
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
		rst 	#20
		dw		#8124
		ld		(iy+15),c
		ld		(iy+16),b
		rst 	#20
		dw		#812A
		ld		(iy+17),b		
.SyB_PeekFloat_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekFloat_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		ld		(iy+15),a
		ld		(iy+16),a
		ld		(iy+17),a
		jp		SyB_PeekFloat_1
EndLib

;****     POKEBYTE      ****
;**** Poke Byte Command ****
;****                   ****
Library SyB_PokeByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeByte_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		b,(iy+7)
		rst	 	#20
		dw 		#812D
.SyB_PokeByte_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret
EndLib		
		
;****     POKEFLOAT      ****
;**** Poke Float Command ****
;****                    ****
Library SyB_PokeFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeFloat_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
		ld		c,(iy+9)
		ld		b,(iy+10)
		rst	 	#20
		dw 		#8127
		ld		b,(iy+11)		
		rst	 	#20
		dw 		#812D
.SyB_PokeFloat_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret			
EndLib
		
;****     POKEINT      ****
;**** Poke Int Command ****
;****                  ****
Library SyB_PokeInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeInt_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
.SyB_PokeInt_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret		
EndLib

;****        RAD            ****
;**** RAD - Set Radian Mode ****
;****                       ****
Library SyB_Rad:
		Xor		a
		ld		(FLO_VALUE_DEGRAD),a
		ret
EndLib	

;****     RAMFREE      ****
;**** RamFree Function ****			
;****                  ****
Library SyB_RamFree
		ld hl,#8100			;SymBos Function
		rst #28
		ld		l,e
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamFree_1		
		add		hl,hl				;*2
		djnz	SyB_RamFree_1
		push	ix
		pop		de
		ld		a,d
		ld		d,0
		rra
		rra
		And		%111111
		ld		e,a
		add		hl,de
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
EndLib

;****     RAMSIZE      ****
;**** RamFree Function ****			
;****                  ****
Library SyB_RamSize
		ld 		hl,#8100			;SymBos Function
		rst 	#28
		ld		l,d
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamSize_1		
		add		hl,hl				;*2
		djnz	SyB_RamSize_1
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib



;****                   ****
;**** Randomize Command ****
;****                   ****
Library SyB_Randomize
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		call	FLO_RANDOMIZE
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc		
		ld		(SyB_StackAddr),hl
		ret
EndLib

;****     REFRESHALL      ****
;**** Refresh All command ****
;****                     ****
Library SyB_RefreshAll:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		e,255
		jp		SyDesktop_WINDIN
EndLib

;****     REFRESHAREA      ****
;**** Refresh Area Command ****
;****                      ****
Library SyB_RefreshArea
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		(AppMsgB+08),hl
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(AppMsgB+10),hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		(AppMsgB+6),hl
		ld		c,(iy+32)
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		l,(iy+25)
		ld		h,(iy+26)
		ld		e,(iy+31)
		ld		bc,30
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld 		c,MSC_DSK_WINPIN
        jp 		SyDesktop_SendMessage		
EndLib

;****      REFRESHOBJ     ****
;**** Refresh Obj Command ****
;****                     ****

Library SyB_RefreshObj
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		a,(iy+8)
		rra
		rra
		rra
		And		%111
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)		
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		SyDesktop_WINDIN
EndLib
		

;****              ****
;**** Refresh Menu ****
;****              ****
Library SyB_RefreshMenu:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage
		ret		
EndLib		
		
;****               ****
;**** Refresh Title ****
;****               ****
Library SyB_RefreshTitle:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		SyDesktop_WINTIT
EndLib
		
;**** REFRESHSTATUS  ****
;**** Refresh Status ****
;****                ****
Library SyB_RefreshStatus:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		SyDesktop_WINSTA
EndLib

;****    RESOLUTIONX       ****		
;**** ResolutionX Function ****		
;****                      ****
Library SyB_ResolutionX
		ld 		hl,#8139
		rst 	#28
		ld		hl,(SyB_StackAddr)
		Xor		a		
		ld		(hl),a
		inc		hl
		ld		(SyB_TempByte),ix
		ld		de,(SyB_TempByte)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret
EndLib

;****    RESOLUTIONY       ****		
;**** ResolutionY Function ****		
;****                      ****
Library SyB_ResolutionY:
		ld 		hl,#8139
		rst 	#28
		ld		hl,(SyB_StackAddr)
		Xor		a		
		ld		(hl),a
		inc		hl
		ld		(SyB_TempByte),iy
		ld		de,(SyB_TempByte)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret
EndLib

;****   RND  ****
;**** Do RND ****
;****        ****
Library SyB_RND
		ld		hl,(SyB_StackAddr)
		inc		hl
		call	FLO_RND
		ex		de,hl
		ld		hl,6
		add		hl,de
		call 	FLO_MULT
		ret
EndLib	


;****     READBYTE      ****
;**** ReadByte Function ****
;****                   ****
Library SyB_ReadByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadByte_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadByte_OK_1
		;*** Failed
		di
.jhft	jr		jhft
		ret
		
.SyB_ReadByte_OK_1:
		push	hl
		pop		ix		
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)		
		ld		(iy+7),a
		ld		(iy+8),0
		ret
EndLib

;****      READFLOAT      ****
;**** ReadFloat Function  ****
;****                     ****
Library SyB_ReadFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadFloat_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadFloat_OK_1
		;*** Failed
		di
.jhft1	jr		jhft1
		ret
.SyB_ReadFloat_OK_1:
		push	hl
		pop		ix
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+8),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+10),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+11),a				
		ret
.SyB_ReadFloat_Temp:	dw	0
EndLib					
		
;****     READINT      ****
;**** ReadInt Function ****
;****                  ****
Library SyB_ReadInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadInt_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadInt_OK_1
		;*** Failed
		di
.jhft2	jr		jhft2
		ret
.SyB_ReadInt_OK_1:
		push	hl
		pop		ix
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+8),a				
		ret
.SyB_ReadInt_Temp:	dw	0
EndLib

;****     READLINE      ****
;**** ReadLine Function  ****
;****                    ****
Library SyB_ReadLine
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadLine_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadLine_OK_1
		;*** Failed
		di
.jhft3	jr		jhft3
		ret	
.SyB_ReadLine_OK_1:
		ld		de,(SyB_StrStackAddr)
		ld		(iy+7),e
		ld		(iy+8),d
		ld		b,0
		ld		c,0
		push	hl
		pop		ix
.SyB_ReadLine_OK_2		
		push	de
		push	bc
		call	SyB_Read_BFF
		pop		bc
		pop		de
		cp		13
		jp		z,SyB_ReadLine_FinishedReading		
		cp		10
		jp		nz,SyB_ReadLine_OK_3
		ld		r,a
		Xor		a
		cp		c
		jp		nz,SyB_ReadLine_OK_3
		ld		c,1
		jp		SyB_ReadLine_OK_2		
.SyB_ReadLine_OK_3
		ld		c,1
		inc		b
		ld		(de),a
		inc		de
		ld		a,b
		cp		251
		jp		c,SyB_ReadLine_OK_2
.SyB_ReadLine_FinishedReading
		ld		(SyB_StrStackAddr),de
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),b
		ret	
Endlib
		
;****     RIGHT$     ****
;**** Right Function ****
;****                ****
Library SyB_Right
		ld		iy,(SyB_StackAddr)
		ld		c,(iy+7)				;Length Required
		ld		a,(iy+15)				;Originals stack length
		sub		c
		jp		c,SyB_Right_1
		ld		b,a
		ld		e,(iy+13)				;DE=start of text on stack
		ld		d,(iy+14)	
		ld		(iy+15),c				;Store new length
		ld		a,c
		And		a
		jp		z,SyB_Right_1
		ld		l,b
		ld		h,0
		add		hl,de					;HL = Start of text
		ld		b,0
		ldir
		ld		(SyB_StrStackAddr),hl
.SyB_Right_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
EndLib		

;****     SAVEDIALOG      ****
;**** SaveDialog function ****
;****                     ****
Library SyB_SaveDialog:
		ld		a,(AppBnkNum)
		set		6,a
		ld		(SyB_FileDialog_Extra),a
		jp		SyB_FileDialog
EndLib

;****     SCREENMODE      ****
;**** ScreenMode Function ****
;****                     ****
Library SyB_ScreenMode:
		ld 		hl,#8139
		rst 	#28
		ld		hl,(SyB_StackAddr)
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret
EndLib

;****     SETOBJPOS     ****
;**** Command SetObjPos ****
;****                   ****
Library SyB_SetObjPos
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+20)				;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+19)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		e,(iy+13)
		ld		d,(iy+14)
		di
		ld		(ix+6),e
		ld		(ix+7),d
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+8),e
		ld		(ix+9),d
		ei
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****     SETOBJWIDTH     ****
;**** Command SetObjWidth ****
;****                     ****
Library SyB_SetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)				;**** Upper Byte of ID	
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0


		
		call	SyB_ReturnFormDatainIX
		ld		iy,(Syb_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)

;		di		
;.asjr	jr		asjr

		ld		(ix+10),e
		ld		(ix+11),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****     SETOBJHEIGHT     ****
;**** Command SetObjHeight ****
;****                      ****
Library SyB_SetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+12),e
		ld		(ix+13),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****     SETOBJTEXT     ****
;**** Command SetObjText ****
;****                    ****
Library SyB_SetObjText:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX	
		ld		a,(ix+2)
		cp		32
		jp		z,SyB_SetObjText_Textline
		ld		e,a
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_SetObjText_Empty	
		bit		7,a
		jp		z,SyB_SetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111		
		jp		SyB_SetObjText_3
		
.SyB_SetObjText_2
		push	ix
		pop		hl
.SyB_SetObjText_3
		ld		e,a
		ld		d,0
		add		hl,de
.SyB_SetObjText_4		
		call	SyB_Str_Store_2_Ram
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
.SyB_SetObjText_Textline:		
		ld		l,(ix+4)
		ld		h,(ix+5)		
		push	hl
		pop		ix
		ld		a,(ix+10)
		ld		e,(iy+9)
		cp		e
		jp		nc,SyB_SetObjText_Textline_2
		ld		(iy+9),a
.SyB_SetObjText_Textline_2:		
		ld		a,(iy+9)
		ld		(ix+8),a
		jp		SyB_SetObjText_4
		
.SyB_SetObjText_Empty:
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
EndLib

;****     SETOBJVISIBLE     ****
;**** Command SetObjVisible ****
;****                       ****
Library SyB_SetObjVisible
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+14)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+13)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+2)
		And		%111111
		ld		b,a
		ld		a,(iy+7)
		Or		a
		jp		z,SyB_SetObjVisible_1
		res		7,b
		jp		SyB_SetObjVisible_2
.SyB_SetObjVisible_1:
		set		7,b
.SyB_SetObjVisible_2	
		ld		(ix+2),b
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****     SETOBJGRAPHIC     ****
;**** SetObjGraphic Command ****
;****                       ****
Library SyB_SetObjGraphic
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+20)			;**** Upper Byte of ID
		rra
		rra
		rra
		And		%111
		ld		l,a
		ld		h,0
		ld		e,(iy+19)				;**** Lower Byte of Id
		ld		d,0
		call	SyB_ReturnFormDatainIX
		ld		a,(ix+2)
		cp 		10
		jp		nz,SyB_SetObjGraphic_Finish
		ld		l,(iy+13)				;HL=Memory Bank Address
		ld		h,(iy+14)
		ld		a,(hl)
		cp		180
		jp		nz,SyB_SetObjGraphic_Finish		
		;**** So it is a Sheet File
		di
		inc		hl
		ld		a,(hl)
		ld		(ix+3),a				;New Bank for Extended Data
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)				;Get Tile wanted
		ld		h,(iy+8)	
		add		hl,hl					;*Multiply by two
		add		hl,de
		inc		hl
		inc		hl
		rst 	#20:dw #8124
		add		hl,bc
		ld		(ix+4),l
		ld		(ix+5),h
		ei
.SyB_SetObjGraphic_Finish
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
endlib

;****      SGN       ****
;**** Do Integer SGN ****
;****                ****
Library SyB_Sgn_Int
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		nz
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret	
endlib

;****     SGN      ****
;**** Do Float SGN ****
;****              ****
Library SyB_Sgn_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		set		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret	
EndLib		

;****   SIN  ****
;**** Do SIN ****
;****        ****
Library SyB_SIN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SIN
EndLib

;****      STR     ****
;**** Str Function ****
;****              ****
Library SyB_Str
		



		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		call	SyB_Str_2
		ld		ix,(SyB_StackAddr)
		ld		hl,(SyB_StrStackAddr)
		ld		(ix+6),5
		ld		(ix+7),l
		ld		(ix+8),h
		ld		(Syb_StrStackAddr),de
		ex		de,hl
		Xor		a
		sbc		hl,de
		ld		(ix+9),l
		ret
.SyB_Str_2
 		push	de
        ex		de,hl
        call 	dspget
        pop 	hl		
        jp 		dsptxt
EndLib

;****      SUB       ****
;**** Do Integer Sub ****
;****                ****
Library SyB_INT_Sub
		ld		iy,(SyB_StackAddr)
		Xor		a
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		sbc		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib
		
;****     SUB      ****
;**** Do Float Sub ****
;****              ****
Library SyB_FLO_Sub
		call	SyB2_STACK_2_FLO
		call	FLO_SUB
		jp		SyB_DecStack
EndLib

;****   SQR  ****		
;**** Do SQR ****
;****        ****
Library SyB_SQR
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SQR
Endlib

;****   TAN  ****
;**** Do TAN ****
;****        ****
Library SyB_TAN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_TAN
EndLib

;****     TRIM      ****
;**** Trim Function ****
;****
Library SyB_Trim 
;AFunction LTrim$($)
		ld		ix,(SyB_StackAddr)
		ld		a,(ix+9)
		Or		a
		ret		z
		ld		l,(ix+7)
		ld		h,(ix+8)
		
		ld		e,a				;This is the length
		ld		d,0
		ld		bc,0
.SyB_Trim_3		
		ld		a,(hl)
		cp		#20
		jp		nz,SyB_Trim_2
		inc		bc
		inc		hl
		inc		d
		dec		e
		jp		nz,SyB_Trim_3
.SyB_Trim_2
		ld		a,(ix+9)
		sub		d
		ld		(ix+9),a
		ld		c,a
		ld		b,0
		push	de
		ld		e,(ix+7)
		ld		d,(ix+8)
		Or		a
		jp		z,SyB_Trim_4
		ld		a,e
		cp		l
		jp		z,SyB_Trim_4
		ldir
.SyB_Trim_4		
		pop		de
		ld		c,d
		ld		b,0
		ld		hl,(SyB_StrStackAddr)
		Xor		a
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ret
EndLib

;****   UCASE$  ****		
;**** Do UCASE$ ****
;****           ****
Library SyB_UCase
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		b,(hl)	
		ex		de,hl
.SyB_UCase_1
		ld		a,(hl)
		cp 		97
		jr		c,SyB_UCase_3
		cp		123
		jr		nc,SyB_UCase_3
		sub		32
		ld		(hl),a
.SyB_UCase_3
		inc		hl
		djnz	SyB_UCase_1
		ret
EndLib

;****     WRITEBYTE      ****
;**** WriteByte Function ****
;****                    ****
Library SyB_WriteByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteByte_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteByte_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteByte_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib	

;****     WRITEFILE      ****
;**** Writefile function ****
;****                    ****
Library SyB_WriteFile:
		call	SyB_GetNewFile
		jp		c,SyB_WriteFile_Fail_1
.SyB_WriteFile_Ok_1
		ld		b,a						;OS File Number
		call	SyB_FreeFileSlot		
		jp		c,SyB_WriteFile_Fail_1
.SyB_WriteFile_Ok_2
		ld		iy,(SyB_StackAddr)		
			
		ld		(iy+13),l
		ld		(iy+14),h		
		ld		a,175
		ld		(hl),a
		inc		hl
		Xor		a
		ld		(hl),a			;Set the Write to 0
		inc		hl
		ld		a,1
		ld		(hl),a			;Set Empty to 1
		inc		hl
		ld		(hl),b
		inc		hl
		Xor		a
		ld		b,6
.SyB_WriteFile_Ok_3
		ld		(hl),a
		inc		hl
		djnz	SyB_WriteFile_Ok_3
.SyB_WriteFile_Ok_4
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
.SyB_WriteFile_Fail_1
		ld		(iy+13),0
		ld		(iy+14),0
		jp		SyB_WriteFile_Ok_4
EndLib


;****     WRITEFLOAT      ****
;**** WriteFloat Function ****
;****                     ****
Library SyB_WriteFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteFloat_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteFloat_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteFloat_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+9)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)						
		ld		a,(iy+11)
		call	SyB_Write_Byte_To_File
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****     WRITEINT      ****
;**** WriteInt Function ****
;****                   ****
Library SyB_WriteInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteInt_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteInt_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteInt_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		call	SyB_Write_Byte_To_File
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib	

;****     WRITELINE      ****
;**** WriteLine Function ****
;****                    ****
Library SyB_WriteLine
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteLine_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteLine_OK_1
		;*** Failed
		ld		de,256+16
		ld		bc,12
		ld		a,0
		jp		SyB_Mark_Error
.SyB_WriteLine_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		b,(iy+9)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		a,b
		And		a
		jp		z,SyB_WriteLine_OK_3	
.SyB_WriteLine_OK_2:
		ld		a,(de)	
		inc		de
		push	bc
		push	de
		call	SyB_Write_Byte_To_File
		pop		de
		pop		bc
		dec		b
		ld		a,b
		And		a
		jp		nz,SyB_WriteLine_OK_2
.SyB_WriteLine_OK_3:		
		ld		a,13
		call	SyB_Write_Byte_To_File		
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****      XOR       ****
;**** Do Integer XOR ****
;****               ****
Library SyB_INT_Xor
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Xor		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Xor		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib	

;****************************************************************************************
;****************************************************************************************
;****************************************************************************************

;****                       ****
;**** 16 Bit Divide Routine ****
;****                       ****
Library SyB_N_Div16:
		ex		de,hl           	; HL = DE \ HL
		ld		a,e             	; Division by zero?
		Or		d
		jr		nz,SyB_N_Div17      ; Continue of not
		ld		hl,0
		ld		de,0
		scf			            	; Set Carry to indicate an error
		ret
.SyB_N_Div17:
		ld		c,l             	; AC = HL
		ld		a,h
		ld		hl,0            	; HL = Modulus
		ld		b,16            	; 16-bit division
		Or		a               	; Start with carry reset
.SyB_N_Div18:
		rl		c               	; AC = AC * 2
		rla  	                	; (set Carry to bit 0)
		rl		l               	; HL = HL * 2
		rl		h               	; (reset Carry again (HL = 0))
		push	hl
		sbc		hl,de
		ccf                     	; Carry set when Ok
		jr		c,SyB_N_Div19       ; Modulus cannot be >= Value
		ex		(sp),hl         	; Restore Modulus
.SyB_N_Div19:
		inc		SP              	; Get Modulus from Stack
        inc		SP
		djnz 	SyB_N_Div18         ; Repeat for all bits
; Shift last Carry-bit to divider
		ex		de,hl           	; DE = Modulus
		rl		c               	; Carry to C
		ld		l,c             	; HL = AC
		rla
		ld		h,a
		Or		a               	; Reset Carry (valid result)
		ret
EndLib

;**** Converts the Stack from a Float to Integer Value
;**** Depending on What Stack needs to be adjusted *****
Library SyB_FLO_2_INT_Stack_1
		ld		bc,7
		jp		SyB_FLO_2_INT_BC
EndLib
Library SyB_FLO_2_INT_Stack_2
		ld		bc,13
		jp		SyB_FLO_2_INT_BC
EndLib
Library SyB_FLO_2_INT_Stack_3
		ld		bc,19
		jp		SyB_FLO_2_INT_BC
Endlib
Library SyB_FLO_2_INT_Stack_4
		ld		bc,25
		jp		SyB_FLO_2_INT_BC
EndLib
Library SyB_FLO_2_INT_Stack_5
		ld		bc,31
		jp		SyB_FLO_2_INT_BC
EndLib
Library SyB_FLO_2_INT_Stack_6
		ld		bc,37
		jp		SyB_FLO_2_INT_BC
EndLib
Library SyB_FLO_2_INT_Stack_7
		ld		bc,43
		jp		SyB_FLO_2_INT_BC		
EndLib
Library SyB_FLO_2_INT_Stack_8
		ld		bc,49
		jp		SyB_FLO_2_INT_BC
EndLib
;**** Converts the Stack from a Float to Integer Value
Library SyB_FLO_2_INT_BC
		ld		hl,(SyB_StackAddr)
		add		hl,bc
.SyB_FLO_2_INT_XTRA		
		push	hl
		call	FLO_ROUND_FLO_TO_HLA
		bit		7,a
		jr		z,SyB_FLO_2_INT_2
		ld		a,l
		Xor		255
		ld		l,a
		ld		a,h
		Xor		255
		ld		h,a
		inc		hl
.SyB_FLO_2_INT_2
		ex		de,hl
		pop		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret
Endlib		

;****                                     ****
;**** Returns HL as Start of Form & ID No ****
;****                                     ****
Library SyB_ReturnFormDatainIX
		add		hl,hl
		ld		bc,ControWindowDataList
		add		hl,bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl		
		add		hl,hl			;*2
		add		hl,hl			;*4
		add		hl,hl			;*8
		add		hl,hl			;*16
		add		hl,bc
		push	hl
		pop		ix
		ret	
EndLib

;****                          ****
;**** Find Empty Slot for File ****
;****                          ****
Library SyB_FreeFileSlot
		Xor		a
		ld		hl,(SyB_File_Data_Buffer_1)
		cp		(hl)
		ret		z
		ld		hl,(SyB_File_Data_Buffer_2)
		cp		(hl)
		ret		z
		ld		hl,(SyB_File_Data_Buffer_3)
		cp		(hl)
		ret		z
		ld		hl,(SyB_File_Data_Buffer_4)
		cp		(hl)
		ret		z
		scf
		ret
EndLib

;****                                        ****
;**** Return A file - With Carry set if Fail ****
;****                                        ****
Library SyB_GetOpenAFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)					;Start of String
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		a,(iy+9)					;Length		
		And		a							;If Length Zero
		jp		z,SyB_GetOpenAFile_Fail		;So Fail if zero
		ld		b,0	
		ld		de,(SyB_File_Name_Input)	;DE=Filename/Path		
		ld		c,a							;c=length
		ldir								;repeat
		Xor		a							;put a zero ender in the string
		ld		(de),a						;
		ld		a,(appBnkNum)
		ld		hl,(SyB_File_Name_Input)
		db		#DD,#67
		call	SyFile_FILOPN
		jr		nc,SyB_GetOpenAFile_Ok
		;**** Okay it failed ****
.SyB_GetOpenAFile_Fail:
		scf
.SyB_GetOpenAFile_Ok:		
		ret
EndLib

;****                                            ****
;**** Return A New File - With Carry Set if Fail ****
;****                                            ****
Library SyB_GetNewFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		(SyB_StrStackAddr),hl
		ld		a,(iy+15)
		And		a
		jp		z,SyB_GetNewFile_Fail		;So Fail if zero
		ld		b,0	
		ld		de,(SyB_File_Name_Input)	;DE=Filename/Path		
		ld		c,a						;c=length
		ldir							;repeat
		Xor		a						;put a zero ender in the string
		ld		(de),a					;
		ld		a,(appBnkNum)
		ld		hl,(SyB_File_Name_Input)
		db		#DD,#67
		ld		a,(iy+7)
		And		%100111
		call	SyFile_FILNEW		
		jr		nc,SyB_GetNewFile_Ok
		;**** Okay it failed ****
.SyB_GetNewFile_Fail:
		scf
.SyB_GetNewFile_Ok:		
		ret
EndLib		
			

;**** File Thing is
;**** 0 -
;**** 1 - Write Byte set?
;**** 2 -
;**** 3 -
;**** 4 - File Pos Addr 1
;**** 5 - File Pos Addr 2
;**** 6 - File Pos Addr 3
;**** 7 - File Pos Addr 4
;**** 8 - Segment Length 1
;**** 9 - Segment Length 2

;****                                ****
;**** Write a byte to an opened file ****
;****                                ****
Library SyB_Write_Byte_To_File
		ld		(ix+1),1					;*** Set Writing Byte
		push	ix						
		pop		hl							;*** HL=IX
		ld		bc,10
		add		hl,bc						;*** HL=IX+10
		ld		e,(ix+4)
		ld		d,(ix+5)
		add		hl,de
		ld		(hl),a						;**** Has copied in proper Position
		;**** Check if 511
		ld		a,e
		cp		255
		jp		nz,SyB_Write_Byte_To_File_2
		ld		a,d
		And		%1
		jp		nz,SyB_Write_Byte_To_File_2
		;So is a save time!
		call	SyB_Write_512_Bytes
;**** Definately not saving (not 511)		
.SyB_Write_Byte_To_File_2
		push	ix
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		ix,1
		ld		iy,0
		call	SyB_Math_Add32
		pop		ix
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		;**** Check FilePos against Length
		ld		a,h
		And		%1
		ld		h,a
		ld		e,(ix+8)
		ld		d,(ix+9)
		Xor 	a
		push	hl
		sbc		hl,de
		pop		hl
		jp		nc,SyB_Write_Byte_To_File_4
		ret
.SyB_Write_Byte_To_File_4	
		ld		(ix+8),l
		ld		(ix+9),h
		ret
EndLib		


	

;****                                   ****
;**** Return a byte from an opened file ****
;****                                   ****
;Input IX = File Data 
Library SyB_Read_BFF
		;**** Lets get the Byte reading ****
		ld		l,(ix+4)
		ld		a,(ix+5)
		And		%1
		ld		h,a
		
		ld		e,(ix+8)
		ld		d,(ix+9)
		push	hl
		sbc		hl,de
		pop		hl
		jp		nc,SyB_Read_Eof
		
		push	ix
		pop		de
		add		hl,de
		ld		bc,10
		add		hl,bc
		ld		a,(hl)
		ld		(SyB_Read_Byte_From_File_Byte),a
		;**** Lets add 1 to filepointer ****
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		push	ix
		ld		ix,1
		ld		iy,0				
		call	SyB_Math_Add32
		pop		ix		
			
		Xor		a
		cp		l
		jp		nz,SyB_Read_BFF_3
		ld		a,h
		And		%1
		jp		nz,SyB_Read_BFF_3
		;**** Check if we need to write the old stuff
		push	hl
		push	de
		ld		a,(ix+1)
		cp		1
		jp		nz,SyB_Read_BFF_99
		call	SyB_Write_512_Bytes
.SyB_Read_BFF_99		
		call	SyB_Read_512_Bytes
		pop		de
		pop		hl		
		
.SyB_Read_BFF_3
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		ld		a,(SyB_Read_Byte_From_File_Byte)
		ret
.SyB_Read_Byte_From_File_Byte:		db 	0

.SyB_Read_Eof
		ld		a,0	
		ret	
EndLib

;IX=Address of File Data Header
Library SyB_Write_512_Bytes
		;**** First must reset File Pointer 
		ld		a,(ix+5)				;Get Pointer down to last 512
		And		%11111110
		ld		b,a
		ld		c,0
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		a,(ix+3)
		push	ix
		ld		c,0						;C=0 FileBegin
		push	bc
		push	de
		pop		iy
		pop		ix
		call	SyFile_FILPOI
		pop		ix
		;**** Back to save
		push	ix
		pop		hl
		ld		bc,10
		add		hl,bc					;HL = Start of Data
		ld		(ix+1),0				;Set write Byte to Zero
		ld		a,(AppBnkNum)
		ld		e,a						;E = Ram Bank
		ld		a,(ix+3)				;A = OS Reference
		ld		c,(ix+8)				;BC = Length to write
		ld		b,(ix+9)
		push	ix
		push	bc
		push	ix
		call	SyFile_FILOUT
		pop		ix
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		pop		ix						;IX = BC
		ld		iy,0
		call	SyB_Math_Add32
		pop		ix
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		ld		(ix+8),0
		ld		(ix+9),0
		ret
EndLib	

;****                                    ****
;**** Get 512bytes (or whatever) of file ****
;****                                    ****
;IX = Start of file Data
Library SyB_Read_512_Bytes
		push	ix
		pop		hl
		ld		bc,10
		add		hl,bc
		ld		a,(AppBnkNum)
		ld		e,a
		ld		a,(ix+3)
		ld		bc,512
		push	ix
		call	SyFile_FILINP
		pop		ix
		ld		(ix+1),0
		ld		(ix+8),c
		ld		(ix+9),b
		ret
Endlib


;****     OPENDIALOG      ****
;**** OpenDialog function ****
;****                     ****
Library SyB_FileDialog:
		ld		iy,(SyB_StackAddr)
		;**** copy "*  ",0 into file area 
		ld		hl,SyB_FileDialog_Data
		ld		bc,4
		ld		de,(SyB_File_Dialog_Pointer)
		ldir
		push	de
		;**** oopy real stuff
		ld		l,(iy+13)
		ld		h,(iy+14)		
		ld		a,(iy+15)
		And		a
		jp		z,SyB_FileDialog_1
		ld		de,(SyB_File_Dialog_Pointer)		
		cp		3
		jp		c,SyB_FileDialog_2
		ld		a,3
.SyB_FileDialog_2:
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_1:		
		pop		de
		ld		l,(iy+19)
		ld		h,(iy+20)		
		ld		a,(iy+21)
		ld		(SyB_StrStackAddr),hl			;Reset to begining
		And		a
		jp		z,SyB_FileDialog_3
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_3:
		Xor		a
		ld		(de),a
		ld		hl,(SyB_File_Dialog_Pointer)		
		ld		a,(SyB_FileDialog_Extra)
		ld		c,(iy+7)	
		
		ld		ix,128
		ld		iy,6000
;		ld		de,Form1_ControlWindow
		call	SySystem_SELOPN
		ld		iy,(SyB_StackAddr)
		And		a
		jp		nz,SyB_FileDialog_Fail
		ld		hl,(SyB_File_Dialog_Pointer)
		ld		bc,4
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		b,0
.SyB_FileDialog_4:
		ld		a,(hl)
		And		a
		jp		z,SyB_FileDialog_5
		ld		(de),a
		inc		hl
		inc		de
		inc		b
		jr		SyB_FileDialog_4
.SyB_FileDialog_5:
		ld		(iy+21),b
		ld		(SyB_StrStackAddr),de
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_FileDialog_Fail:
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		(iy+21),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret				
SyB_FileDialog_Data:	db "*  ",0
SyB_FileDialog_Extra:	db	0
EndLib


Library SyB_Math_Add32
;*************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				push    ix
                pop     bc
                add     hl,bc
                ex      de,hl
                push    iy
                pop     bc
                adc     hl,bc
                ex      de,hl
                ret
;************************************
EndLib

;****            ****
;**** Mark Error ****
;****            ****
;DE = Error Number
Library SyB_Mark_Error
		ld		(ErrorNum),de
		pop		hl						;Gets Return Stack
		ld		(ErrorPC),hl
		ld		a,d
		cp		8
		jp		c,SyB_Mark_Error_1
		di
.SyB_Mark_Error_2		
		jr		.SyB_Mark_Error_2
.SyB_Mark_Error_1
		jp		(hl)
EndLib		

;*************************************************
;*********** PUSHING VALUES TO STACK *************
;*************************************************

;****                          ****
;**** Push Var Byte onto Stack ****
;****                          ****
Library SyB_Push_V_Byt
		pop		hl							;10
		ld		e,(hl)						;7
		inc		hl							;6
		ld		d,(hl)						;7
		inc		hl							;6
		ld		a,(de)						;7
		exx									;4
		ld		hl,(SyB_StackAddr)			;16
		inc		hl							;6
		ld		(hl),a						;7
		inc		hl							;6
		Xor		a							;7
		ld		(hl),a						;7
		ld		bc,-8						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		exx									;4
		jp		(hl)
endlib		

;****                        ****
;**** Push HL INT onto Stack ****
;****                        ****
Library SyB_Push_V_Int_Direct
		ex		de,hl					;4
		ld		hl,(SyB_StackAddr)		;16
		inc		hl						;6
		ld		(hl),e					;7
		inc		hl						;6
		ld		(hl),d					;7
		ld		bc,-8					;16
		add		hl,bc					;11
		ld		(SyB_StackAddr),hl		;16
		ret								;10
EndLib

;****                           ****
;**** Push INT Array onto Stack ****
;****                           ****
;DE = Array Address + 2
Library SyB_Push_V_Int_Array_1_Direct
		ld		ix,(SyB_StackAddr)
		ld		l,(ix+7)
		ld		h,(ix+8)
		add		hl,hl					;**** Times 2
		add		hl,de
		ld		a,(hl)
		ld		(ix+7),a
		inc		hl
		ld		a,(hl)
		ld		(ix+8),a
		ret
Endlib

;****                           ****
;**** Push FLO Array onto Stack ****
;****                           ****
;DE = Array Address + 2
Library SyB_Push_V_Flo_Array_1_Direct
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		push	hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ld		l,c
		ld		h,b
		add		hl,hl
		add		hl,hl
		add		hl,bc
		add		hl,de
		pop		de
		ldi
		ldi
		ldi
		ldi
		ldi
		ret
EndLib		

;****                                 ****
;**** Push Numeric Integer onto Stack ****
;****                                 ****		
Library SyB_Push_N_Int
		pop		hl							;11
		ld		de,(SyB_StackAddr)			;20 ;**** Get Address of Data Stack		
		inc		de							;6	;**** Modes up Stack 1
		ldi									;16	;**** Copies (HL)-(DE)
		ldi									;16	;**** Copies (HL)-(DE)
		ex		de,hl
		ld		hl,(SyB_StackAddr)			;16
		ld		bc,-6						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		ex		de,hl						;4
		jp		(hl)						;4		
EndLib		

;****                              ****
;**** PUSH 1 Onto Stack as Integer ****
;****                              ****		
Library SyB_Push_Int_1
		ld		iy,(SyB_StackAddr)
		ld		bc,-6
		add		iy,bc
		ld		(iy+7),1
		ld		(iy+8),0
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****                            ****
;**** PUSH 1 Onto Stack as Float ****
;****                            ****	
Library SyB_Push_Flo_1
		ld		iy,(SyB_StackAddr)
		ld		bc,-6
		add		iy,bc
		ld		(iy+7),0
		ld		(iy+8),0
		ld		(iy+9),0
		ld		(iy+10),0
		ld		(iy+11),#81		
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****                              ****
;**** Push Null Integer onto stack ****
;****                              ****
Library SyB_Push_Null_Int
		Xor		a
		ld		hl,(SyB_StackAddr)
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		ld		bc,-8						;16
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16				
		ret
Endlib		

;****                                    ****
;**** Pushes Double Int Array onto Stack ****
;****                                    ****
Library SyB_Push_V_Int_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl				;HL = Start of Array
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Skip multiple
		inc		hl					;HL= Start of Array Data
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ex		de,hl	
		push	hl
		push	hl
		pop		bc
.SyB_Push_V_Int_Array_2_Mul_2
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_Push_V_Int_Array_2_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,hl				;**** Times 2
		pop		de
		add		hl,de
		pop		de
		add		hl,de
		ld		a,(hl)
		ld		(iy+13),a
		inc		hl
		ld		a,(hl)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****                                      ****
;**** Pushes Double Float Array onto Stack ****
;****                                      ****
Library SyB_Push_V_Flo_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl				;HL = Start of Array
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Skip multiple
		inc		hl					;HL= Start of Array Data
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ex		de,hl	
		push	hl
		push	hl
		pop		bc
.SyB_Push_V_Flo_Array_2_Mul_2
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_Push_V_Flo_Array_2_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc				;**** Times 5
		pop		de
		add		hl,de
		pop		de
		add		hl,de
		ld		a,(hl)
		ld		(iy+13),a
		inc		hl
		ld		a,(hl)
		ld		(iy+14),a
		inc		hl
		ld		a,(hl)
		ld		(iy+15),a
		inc		hl
		ld		a,(hl)
		ld		(iy+16),a
		inc		hl
		ld		a,(hl)
		ld		(iy+17),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib





;**************************************************
;*********** TAKING VALUES FROM STACK *************
;**************************************************
;****                                  ****
;**** Function Pass from Stack to Vars ****
;****                                  ****
Library SyB_Function_Pass:
		pop		hl								;Get contents after Call
		ld		b,(hl)							;Number of Parameters to pass
		inc		hl
		ld		iy,(SyB_StackAddr)
.SyB_Function_Pass_1:
		push	bc
		ld		a,(hl)							;Type
		inc		hl
		cp		5
		jp		z,SyB_Function_Pass_Str
		cp		1
		jp		z,SyB_Function_Pass_Int
		cp		3
		jp		z,SyB_Function_Pass_Float
.SyB_Function_Pass_2:
		ld		de,6
		add		iy,de
		pop		bc
		dec		b
		jp		nz,SyB_Function_Pass_1
		ld		(SyB_StackAddr),iy
		jp		(hl)
.SyB_Function_Pass_Int:
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		a,(iy+7)		
		ld		(de),a
		inc		de
		ld		a,(iy+8)
		ld		(de),a
		jp		SyB_Function_Pass_2
.SyB_Function_Pass_Float:
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		a,(iy+7)
		ld		(de),a
		inc		de
		ld		a,(iy+8)
		ld		(de),a
		inc		de
		ld		a,(iy+9)
		ld		(de),a
		inc		de
		ld		a,(iy+10)
		ld		(de),a				
		inc		de
		ld		a,(iy+11)
		ld		(de),a		
		jp		SyB_Function_Pass_2		
.SyB_Function_Pass_Str
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl
		ex		de,hl
		call	SyB_Str_Store_2_Ram
		pop		hl
		jp		SyB_Function_Pass_2
EndLib

;****                         ****
;**** Store a Byte from Stack ****
;****                         ****
Library SyB_Store_Byt
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		inc		hl
		ldi
		ret
EndLib		

;****                             ****
;**** Store an Integer from Stack ****
;****                             ****
;DE=Address to Store
Library SyB_Store_Int_Direct
		ld		hl,(SyB_StackAddr)						;16
		ld		bc,6									;10
		add		hl,bc									;11
		ld		(SyB_StackAddr),hl						;16
		inc		hl										;6
		ldi												;16
		ldi												;16
		ret												;10				101
EndLib

;****                        ****
;**** Takes Float from Stack ****
;****                        ****
Library SyB_Store_Flo
		pop		hl						;Return Address
		ld		e,(hl)								
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		inc		hl
		ldi
		ldi
		ldi
		ldi
		ldi
		ret		
EndLib

;****                                     ****
;**** Takes Single Array Float from Stack ****
;****                                     ****
Library SyB_Store_Flo_Array_1
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		inc		de					;Stores Dimension data Ignore
		inc		de					;
		ld		hl,(SyB_StackAddr)
		ld		bc,13
		add		hl,bc
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc
		add		hl,de
		ex		de,hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		inc		hl
		ldi
		ldi
		ldi
		ldi
		ldi
		ld		(SyB_StackAddr),hl
		ret
EndLib

;****                                     ****
;**** Takes Double Array Float from Stack ****
;****                                     ****
Library SyB_Store_Flo_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl				;HL = Start of Array
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Skip multiple
		inc		hl					;HL= Start of Array Data
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB_Store_Flo_Array_Mul_2	
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_Store_Flo_Array_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc				;**** Times 5
		pop		de
		add		hl,de
		pop		de
		add		hl,de	
		ld		a,(iy+7)
		ld		(hl),a
		inc		hl
		ld		a,(iy+8)
		ld		(hl),a
		inc		hl
		ld		a,(iy+9)
		ld		(hl),a
		inc		hl
		ld		a,(iy+10)
		ld		(hl),a
		inc		hl
		ld		a,(iy+11)
		ld		(hl),a
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****                                   ****
;**** Takes Single Array Int from Stack ****
;****                                   ****
;DE=Base Address of Array +2 (To Skip over word)
Library SyB_Store_Int_Array_1_Direct
		ld		iy,(Syb_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,hl
		add		hl,de
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;****                                   ****
;**** Takes Double Array Int from Stack ****
;****                                   ****
Library SyB_Store_Int_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB2_Store_Int_Array_Mul_2	
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB2_Store_Int_Array_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		add		hl,hl				;**** Times 2
		pop		de
		add		hl,de
		pop		de
		add		hl,de	
		ld		a,(iy+7)
		ld		(hl),a
		inc		hl
		ld		a,(iy+8)
		ld		(hl),a
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
EndLib

;		ex		de,hl
;		push	hl
;		push	hl
;		pop		bc
;.SyB_INT_Mul_11		
;		add		hl,de
;		dec		bc
;		ld		a,b
;		Or		c
;		jr		nz,SyB_INT_Mul_11
;		pop		de
;		sbc		hl,de



;*************************************************
;************** STRING ROUTINES ******************
;*************************************************

;****                                           ****
;**** Push String from Memory onto String Stack ****
;****                                           ****
Library SyB_Push_N_Str
		pop		hl
		ld		a,(hl)
		inc		hl
		ld		iy,(SyB_StackAddr)
		ld		de,(SyB_StrStackAddr)
		ld		(iy+1),e
		ld		(iy+2),d
		ld		(iy+3),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		And		a
		jp		z,SyB_Push_N_Str_Finish
		ld		c,a
		ld		b,0
		ldir
		ld		(SyB_StrStackAddr),de
.SyB_Push_N_Str_Finish	
		jp		(hl)
EndLib

;****                                         ****
;**** Push String Var Array onto String Stack ****
;****                                         ****
Library SyB_Push_V_Str_Array_1
		pop		ix							;Return Adress holds Variable Loc
		ld		l,(ix+0)
		ld		h,(ix+1)					;HL=Variable
		inc		ix
		inc		ix							;IX Skip 
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)					;DE=Array value
		ld		d,(iy+8)		
		inc		hl							;Skip HL Over 
		inc		hl
		add		hl,de
		add		hl,de						;Add together to get String Pointer Address
		ld		e,(hl)
		inc		hl
		ld		d,(hl)						
		ex		de,hl						;HL=Address of string
		
		dec		hl							;Step Back 1 to Length
		ld		c,(hl)						;Move back to start of Text
		inc		hl
		ld		de,(SyB_StrStackAddr)		;Last Piece of String on Stack
		ld		b,0							;BC=Length to loop down
		;ld		(iy+6),5
		ld		(iy+7),e					;Stack = String Stack location
		ld		(iy+8),d					;ditto
		ld		(iy+9),c					;Stack = String Length
		Xor		a
		cp		c			
		jp		z,SyB_Push_V_Str_Array_1_1	;Do nothing if zero
		ldir								;Copy info to String Stack
		ld		(SyB_StrStackAddr),de		;Update new String Stack 
.SyB_Push_V_Str_Array_1_1
		jp		(ix)
EndLib

;****                                                ****
;**** Push String Var Double Array onto String Stack ****
;****                                                ****
Library SyB_Push_V_Str_Array_2
		pop		ix						;**** Holds Variable
		ld		l,(ix+0)				;HL=Variable Address
		ld		h,(ix+1)
		ld		e,(hl)					;DE=Array size
		inc		hl
		ld		d,(hl)
		inc		hl		
		push	hl
		

		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)				;**** Get the Second Stacked Integer
		ld		h,(iy+8)				;				
		;****  	Multiply shit ****
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB2_Store_Str_Array_Mul_2		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB2_Store_Str_Array_Mul_2
		pop		de
		sbc		hl,de
		ex		de,hl
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,hl
		add		hl,de
		pop		de
		add		hl,de
		inc		ix
		inc		ix
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl		
		dec		hl							;Step Back 1 to Length
		ld		c,(hl)						;Move back to start of Text
		inc		hl
			
		ld		de,(SyB_StrStackAddr)		;Last Piece of String on Stack
		ld		b,0							;BC=Length to loop down
		;ld		(iy+6),5
		ld		(iy+13),e					;Stack = String Stack location
		ld		(iy+14),d					;ditto
		ld		(iy+15),c					;Stack = String Length
		Xor		a
		cp		c			
		jp		z,SyB_Push_V_Str_Array_2_1	;Do nothing if zero
		ldir								;Copy info to String Stack
		ld		(SyB_StrStackAddr),de		;Update new String Stack 
.SyB_Push_V_Str_Array_2_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)
EndLib


;****                      ****
;**** Stores String to Ram ****
;****                      ****
Library SyB_Store_Str
		pop		ix
		ld		iy,(SyB_StackAddr)
		ld		l,(ix+0)
		ld		h,(ix+1)
		inc		ix
		inc		ix	
		call	SyB_Str_Store_2_Ram
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)
EndLib



;****                                   ****
;**** Stores Single Array String to Ram ****
;****                                   ****
Library SyB_Store_Str_Array_1
		pop		ix
		ld		l,(ix+0)
		ld		h,(ix+1)
		inc		hl
		inc		hl
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+13)
		ld		d,(iy+14)
		add		hl,de
		add		hl,de
		inc		ix
		inx		ix
		call	SyB_Str_Store_2_Ram
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)
EndLib

;****                                   ****
;**** Stores Double Array String to Ram ****
;****                                   ****
Library SyB_Store_Str_Array_2
		pop		ix						;**** Holds Variable
		ld		l,(ix+0)				;HL=Variable Address
		ld		h,(ix+1)
		ld		e,(hl)					;DE=Array size
		inc		hl
		ld		d,(hl)
		inc		hl		
		push	hl
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)				;**** Get the Second Stacked Integer
		ld		h,(iy+14)				;
		;****  	Multiply shit ****
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB2_Store_Str_Array_Mul		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB2_Store_Str_Array_Mul
		pop		de
		sbc		hl,de
		ex		de,hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		add		hl,hl
		add		hl,de
		pop		de
		add		hl,de
		inc		ix
		inc		ix	
		call	SyB_Str_Store_2_Ram
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)		
EndLib

;****                     ****
;**** SyB_Str_Store_2_Ram ****
;****                     ****
Library SyB_Str_Store_2_Ram		
		ld		(SyB_Where_Pointer_2),hl	
		ld		e,(hl)					;
		inc		hl
		ld		d,(hl)
		ex		de,hl
		dec		hl
		ld		a,(hl)					;Length of Existing Text
		ld		c,(iy+9)				;Length of Text on Stack

		cp		c
		jp		c,SyB_SSN
		;Length shorter or same
		ld		(hl),c
		inc		hl
		sub		c							;A=Remainder
		ld		e,(iy+7)					;HL=Location of Stack Text
		ld		d,(iy+8)
		ld		(SyB_StrStackAddr),de		;Stores the decreased String Stack Pointer Address		
		ex		de,hl
		ld		(SyB_Store_Char_Temp),a
		Xor		a
		cp		c
		jr		z,SyB_SS2R_1
		ld		b,0
		ldir
.SyB_SS2R_1
		ld		a,(SyB_Store_Char_Temp)
		And		a
		jr		z,SyB_SS2R_2
		ld		b,a
		Xor		a
.SyB_SS2R_3
		ld		(de),a
		inc		de
		djnz	SyB_SS2R_3
.SyB_SS2R_2
		Xor		a
		ld		(de),a
		ret

;**** New Placement Store
.SyB_SSN
		dec		hl							;Move to High Pointer
		Xor		a							;Clear A
		ld		(hl),a						;(HL) = 0 (Or High pointer is zero)
		dec		hl							;Move to Low Pointer
		ld		a,1							;A=1
		ld		(hl),a						;(HL)= 1 - So address is 1, 0, Length

		ld		de,(SyB_StringTopAddr)		;HL = Top Of Text Address
		ld		l,c
		ld		h,0
		add		hl,de
		ld		de,SyB_StringTopMem
		Xor		a
		sbc		hl,de
		jp		c,SyB_SSN_2
		call	SyB_Garbage
.SyB_SSN_2		
		ld		b,0
		;Copy from stack to New Position		
		ld		de,(SyB_Where_Pointer_2)	;DE = Pointer Address		
		ld		hl,(SyB_StringTopAddr)		;HL = Top Of Text Address
		ld		(hl),e						;Feed Low Byte of Pointer onto Text Stack
		inc		hl
		ld		(hl),d						;Feed Hi Byte of Pointer onto Text Stack
		inc		hl
		ld		(hl),c						;Feed New Length onto Text Stack
		inc		hl
		;HL = Start of Where New Text Goes
		;DE = Pointer Address
		ex		de,hl						;Swaps For speed
		ld		(hl),e						;Pointer Address = Start of Text HL (Note +3 Not including Address & Len)
		inc		hl							;
		ld		(hl),d						;Pointer Address Hi

		ld		l,(iy+7)					;HL=Location of Stack Text
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl		;Adjust the String Stack Pointer down for next data	
		ldir								;HL -> DE Looping C times
		Xor		a							;A=0 
		ld		(de),a						;0 Terminator on string end
		inc		de							;Pad
		ld		(SyB_StringTopAddr),de		;New StringTop Value
		ret

.SyB_Where_Pointer_2:		dw	0			;Actual 2 Byte Pointer to String
EndLib

;****          GARBAGE           ****
;**** Garbage Collection Command ****
;****                            ****
Library SyB_Garbage
		;**** Okay We need to do a Text clearout
		ld		hl,SyB_StringTopAddr+2		;HL = Where to Start
		ld		(SyB_SSN_Garbage_Last),hl
		
.SyB_SSN_Garbage_3		
		ld		bc,(SyB_StringTopAddr)	
.SyB_SSN_Garbage_1		
		ld		a,(hl)
		And		a
		jp		nz,SyB_SSN_Garbage_10
		inc		hl
.SyB_SSN_Garbage_4				
		ld		a,h
		cp		b
		jp		c,SyB_SSN_Garbage_1
		ld		a,l
		cp		c
		jp		c,SyB_SSN_Garbage_1
		;Done it
		ld		hl,(SyB_SSN_Garbage_Last)
		ld		(SyB_StringTopAddr),hl	
		ret

.SyB_SSN_Garbage_10
		dec		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		ld		e,b
		ld		d,(hl)
		dec		hl
		;Is DE = 1 - Becuase if so it is a skip
		ld		a,1
		cp		e
		jp		nz,SyB_SSN_Garbage_11
		Xor		a
		cp		d
		jp		nz,SyB_SSN_Garbage_11
		;**** This is a skipper
		inc		hl
		inc		hl				;Now Points at Length
		ld		c,(hl)
		ld		b,0
		inc		bc
		inc		bc
		add		hl,bc
		ld		bc,(SyB_StringTopAddr)
		jp		SyB_SSN_Garbage_4
				
.SyB_SSN_Garbage_11
		ld		(SyB_SSN_Garbage_HL),hl
		ld		(SyB_SSN_Garbage_Check1),bc		
		;Gets Garbage Check 1 (DE) and - 3 to Match
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		dec		bc
		dec		bc
		dec		bc
		;Check DE = BC
		ld		a,e
		cp		c
		jp		nz,SyB_SSN_Garbage_12
		ld		a,d
		cp		b
		jp		nz,SyB_SSN_Garbage_12		
		;**** Tis same so copy This text
		ld		hl,(SyB_SSN_Garbage_HL)
		jp		SyB_SSN_Garbage_CopyDown				
.SyB_SSN_Garbage_12
		;DE = Current pointer + 1
		dec		de
		ld		hl,(SyB_SSN_Garbage_Check1)			;Get Contents of pointer
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		dec		bc
		dec		bc
		dec		bc
		ld		a,e
		cp		c
		jp		nz,SyB_SSN_Garbage_13		
		ld		a,d
		cp		b
		jp		nz,SyB_SSN_Garbage_13
		ex		de,hl
		jp		SyB_SSN_Garbage_CopyDown
.SyB_SSN_Garbage_13:
		di
.SyB_SSN_Garbage_14:
		jr		SyB_SSN_Garbage_14
		db		"String Error"
	
;HL = Start of Copy	
.SyB_SSN_Garbage_CopyDown:
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		push	hl	
		ex		de,hl
		ld		de,(SyB_SSN_Garbage_Last)
		inc		de
		inc		de
		inc		de
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		de,(SyB_SSN_Garbage_Last)
		pop		hl
		ld		a,(hl)
		add		4
		dec		hl
		dec		hl
		ld		b,0
		ld		c,a
		ldir
		ld		(SyB_SSN_Garbage_Last),de
		ld		bc,(SyB_StringTopAddr)
		jp		SyB_SSN_Garbage_4
		
.SyB_SSN_Garbage_Last:		dw	0		
.SyB_SSN_Garbage_Check1:	dw	0		
.SyB_SSN_Garbage_HL:		dw	0
	
EndLib

;==============================================================================
;### DISPLAY-ROUTINES #########################################################
;==============================================================================
;### DSPGET -> converts 5byte floating point value to display format
;### Input  DE=pointer to 5byte floating point value
Library DspGet
		jr		dspget99
.dspvaltmp   ds 5+1
.dspvalnum   ds 10+1
.dspvallen   db 0
.dspvalsgn   db 0        ;0=positive; display no sign, -1=minus
.dspvalexp   db 0        ;exponent (signed)
.dspvaldig   equ 10      ;maximum amount of displayed mantissa digits
.dspchrflg   db 1        ;flag (input), if 1000 points should be displayed
.dspfeflg    db 0        ;flag (input), if force exponent display
.dspchrcom   db "."      ;symbol for 1000 points
.dspchrpoi   db ","      ;symbol for comma
.dspintflg   db 0        ;flag (result), if displayed number is integer
.dspget99:
		ld 		hl,0
        ld 		(dspvalsgn),hl
        ld 		hl,dspvaltmp
        call 	FLO_MOVE
        call 	FLO_PREPARE		
        ld 		a,b
        Or 		a
        jr 		z,dspget3
        And 	128
        add 	a
        sbc 	0
        ld 		(dspvalsgn),a
        ld 		a,e
        ld 		(dspvalexp),a
        ld 		ix,(dspvaltmp+0)
        ld 		de,(dspvaltmp+2)
        db 		#dd:ld a,l
        db 		#dd:Or h		
        Or 		e
        Or 		d
        jr 		z,dspget3
		ld 		iy,dspvalnum

		call 	clcn32
 
        push 	iy
		pop hl
        ld 		bc,dspvalnum-1
        Or 		a
        sbc 	hl,bc
        ld 		c,l
        ld 		a,"0"
        ld 		hl,dspvalexp

.dspget1
		cp 		(iy+0)
        jr 		nz,dspget2
        ld 		(iy+0),0
        dec 	iy
        inc 	(hl)
        dec 	c
        jr 		nz,dspget1
.dspget2
		ld 		a,c
.dspget3
		ld 		(dspvallen),a
        ret

;### DSPTXT -> converts display format value to text and displays it
.dsptxt
		Xor 	a
        ld 		(dspintflg),a
        ld 		a,(dspvalsgn)        ;*** Sign
        inc 	a
        jr 		nz,dsptxt1
        ld 		(hl),"-"
        inc 	hl
.dsptxt1
		ex 		de,hl
        ld 		a,(dspvallen)        ;*** Test, if value=0
        Or 		a
        jr 		nz,dsptxti
.dsptxty
		ld 		a,"0"                ;display only 0.
        ld 		(de),a
        inc 	de
        jr 		dsptxth
.dsptxti
		ld 		hl,dspvalnum
        ld 		a,(dspfeflg)
        Or 		a
        jr 		nz,dsptxt6           ;display exponent, if in RO mode and F-E on
        ld 		a,(dspvalexp)        ;*** Exponent
        ld 		b,a
        Or 		a
        ld 		a,(dspvallen)
        ld 		c,a
        jp 		m,dsptxta
        add	 	b                   ;*** Exponent positive -> exp display, if dspvallen + dspvalexp <= dspvaldig
        cp 		dspvaldig+1          ;a=length of complete number
        jr 		nc,dsptxt6
        ld 		b,a                  ;*** Display mantissa without comma (a,b=length of mantissa before comma)
        ld 		a,1
        ld 		(dspintflg),a
        ld 		a,b
.dsptxt2
		sub 	3
        jr 		z,dsptxtf
        jr 		nc,dsptxt2
.dsptxtf
		add 	3
        ld 		c,a                  ;c=1000 counter
.dsptxt3
		ld 		a,(hl)
        inc 	hl
        Or 		a
        jr 		nz,dsptxt4
        ld 		a,"0"
        dec 	hl
.dsptxt4
		call 	dsptxt5
        jr 		nz,dsptxt3
.dsptxth
		ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        Xor 	a
        ld 		(de),a
        ret
.dsptxt6
		ld 		a,(hl)               ;**** Display mantissa with exponent
        ld 		(de),a
        inc 	hl
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ld 		a,(dspvallen)
.dsptxt7
		dec 	a
        jr 		z,dsptxt8
        ldi
        jr 		dsptxt7
.dsptxt8
		ex 		de,hl
        ld 		(hl),"e"
        inc 	hl
        ld 		a,(dspvallen)        ;exp display = -(exp + mantissa length - 1)
        ld 		c,a
        ld 		a,(dspvalexp)
        add 	c
        dec 	a
        ld 		(hl),"+"
        jp 		p,dsptxt9
        ld 		(hl),"-"
        neg
.dsptxt9
		inc 	hl
        ex 		de,hl
        call 	clcdez
        ex 		de,hl
        ld 		(hl),e
        inc 	hl
        ld 		(hl),d
        inc 	hl
        ld 		(hl),0
        ret
.dsptxta
		add 	b                   ;*** Comma negative (a,c=len, b=comma -> a=len-neg comma)
        jr 		c,dsptxtb
        neg                     ;a=-(len+exp) [=distance between comma and first digit]
        ld 		b,a
        add 	c                   ;a=new number of digits-1
        cp 		dspvaldig+1
        jr 		nc,dsptxt6           ;too large -> display with exponent
        call 	dsptxte
        ld 		a,"0"
.dsptxtg
		ld 		(de),a
        inc 	de
        djnz 	dsptxtg
        jr 		dsptxtd
.dsptxtb
		jr 		z,dsptxtc            ;*** Display negative comma without exponent
        ld 		b,a
        call 	dsptxt2
        jr 		dsptxtd
.dsptxtc
		call 	dsptxte
.dsptxtd
		ld 		a,(hl)
        ldi
        Or 		a
        jr 		nz,dsptxtd
        ret
.dsptxte
		ld 		a,"0"
        ld 		(de),a
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ret
.dsptxt5
		ld 		(de),a               ;adds a digit (in A) and inserts a point, if needed
        inc 	de
        dec 	b
        ret 	z
        dec 	c
        ret 	nz
        ld 		a,(dspchrflg)
        dec 	a
        ret 	nz
        ld 		a,(dspchrpoi)
        ld 		(de),a
        inc 	de
        ld 		c,3+1
        dec 	c
        ret



;==============================================================================
;### SUB-ROUTINES #############################################################
;==============================================================================
;### CLCN32 -> Converts 32Bit-number (unsigned) in ASCII-String (teminated by 0)
;### Input      DE,IX=value, IY=destination address
;### Output     IY=Address of last char
;### Destroyed  AF,BC,DE,HL,IX,IY


.clcn32t
		dw 		1,0,10,0,100,0,1000,0,10000,0
        dw 		#86a0,1,#4240,#f,#9680,#98,#e100,#5f5,#ca00,#3b9a
.clcn32z
		ds 		4,0

		nop
		nop
.clcn32
		ld 		(clcn32z),ix
        ld 		(clcn32z+2),de
        ld 		ix,clcn32t+36
        ld 		b,9
        ld 		c,0
.clcn321
		ld 		a,"0"
        Or 		a
.clcn322
		ld 		e,(ix+0)
		ld 		d,(ix+1)
		ld 		hl,(clcn32z)
		sbc 	hl,de
		ld 		(clcn32z),hl
        ld 		e,(ix+2)
		ld 		d,(ix+3)
		ld 		hl,(clcn32z+2)
		sbc 	hl,de
		ld 		(clcn32z+2),hl
        jr 		c,clcn325
        inc 	c
        inc 	a
        jr 		clcn322
.clcn325
		ld 		e,(ix+0)
		ld 		d,(ix+1)
		ld 		hl,(clcn32z)
		add 	hl,de
		ld 		(clcn32z),hl
        ld 		e,(ix+2)
		ld 		d,(ix+3)
		ld 		hl,(clcn32z+2)
		adc 	hl,de
		ld 		(clcn32z+2),hl
        ld 		de,-4
        add 	ix,de
        inc 	c
        dec 	c
        jr 		z,clcn323
        ld 		(iy+0),a
        inc 	iy
clcn323
		djnz 	clcn321
        ld 		a,(clcn32z)
        add 	"0"
        ld 		(iy+0),a
        ld 		(iy+1),0
        ret
;### CLCDEZ -> Converts 8bit value into two decimal digits
;### Input      A=value
;### Output     L=10.ascii digit, H=1. ascci digit
;### Destroyed  AF
clcdez  ld l,0
clcdez1 sub 10
        jr c,clcdez2
        inc l
        jr clcdez1
clcdez2 add "0"+10
        ld h,a
        ld a,"0"
        add l
        ld l,a
        ret
EndLib