;Write "Fosfos.bin"
;==============================================================================
;### SOUNDTRAKKER 128 ROUTINEN ################################################
;==============================================================================
;jmp_sysinf
;Quig_Machine_Type
;### ST2INI -> Initialisiert ST2-Sound
;### Eingabe    HL=Adresse
;### Ausgabe    CF=0 -> ok, HL=Anzahl Positionen
;###            CF=1 -> nicht untersttztes Format
;### Veraendert AF,BC,DE,HL,IX,IY
st2datbeg   dw 0    ;Beginn Playlist Track 0
st2datlen   dw 0    ;Songlnge*3

st2ini  ld      (sndmem1+1),hl
        ld      (sndmem2+1),hl
        ld      (sndmem4+1),hl
        ld      (sndmem5+1),hl
        ld      (sndmem6+1),hl
        ld      (sndmem7+1),hl
        ld      de,#ff80
        add     hl,de
        ld      (sndmem3+1),hl
        call    st2sysini
        call    ayReset1    ;!!!
sndmem1 ld hl,(#0000)      ;*** Relocieren
        inc hl
        ld a,l
        or h
        jr z,st2ini1
        ld hl,-1        ;nur einmal relocieren und patchen
sndmem2 ld (#0000),hl
sndmem3 ld hl,#0000
        inc h
        call st2rel
sndmem4 ld bc,#0000        ;*** Code patchen (ld i,a/a,i -> push/pop af)
        ld ix,#18e+128
        add ix,bc
        ld (ix+#00+0),#f5
        ld (ix+#00+1),0
        ld (ix+#31+0),#f1
        ld (ix+#31+1),0
        ld a,(Quig_Machine_Type)
        and 15
        cp      #06         ;ep patch start 2-5 CPC,6 ep, >7 MSX
        jr c,st2ini2
        jr      nz,msxptch  
epptch  ld      ix,#4a6+128 ;*** EP patch
        add     ix,bc
        ld      (ix+0),#c3
        ld      de,st2ep    ;!!! st2ep
        ld      (ix+1),e
        ld      (ix+2),d
        jr      st2ini2     ;ep patch ends
msxptch ld ix,#4a6+128      ;*** Code fr MSX patchen
        add ix,bc
        ld (ix+0),#c3
        ld de,st2msx
        ld (ix+1),e
        ld (ix+2),d
        ;[...] Frequenz-Umrechnungs-Patch
st2ini2 ld ix,#104+128
        add ix,bc
        ld bc,st2ply2
        ld (ix+0),#cd
        ld (ix+1),c
        ld (ix+2),b
st2ini1 ld bc,128+0         ;*** Sound resetten
        call st2ply1
        ld hl,(st2datlen)
        dec hl:dec hl:dec hl
        or a
        ret

st2sysini
;### SYSINI -> Computer-Typ abhngige Initialisierung
        push    af
        push    bc
        push    de
        push    hl
        push    ix
        push    iy
        ld hl,jmp_sysinf        ;*** Computer-Typ holen ;2-5 CPC,6 ep, >7 MSX
        ld de,256*1+5
        ld ix,Quig_Machine_Type
        ld iy,66+2+6+8
        rst #28
        ld a,(Quig_Machine_Type)
        and 15

        cp 6
        jr      c,pt3iend         ;!!! CPC
        ld      a,st2regMSX-st2reg-2
        jr      nz,MSXcnt
        xor     a
        ld      (envelopeInterrupt),a
        ld      (ayReset),a
        ld      a,st2regEP-st2reg-2
MSXcnt  ld      (st2reg+1),a      ;st2 layer
pt3iend pop     iy
        pop     ix
        pop     hl
        pop     de
        pop     bc
        pop     af
        ret

;### ST2VOL -> Setzt die globale Lautstrke
;### Eingabe    A=Lautstrke (0-255)
;### Verndert  AF
st2vol  ;...
        ret

;### ST2MSX -> Setzt PSG-Register fr MSX
;### Eingabe    A=Index, C=Wert
st2msx  out (#a0),a
        ld a,c
        out (#a1),a
        ret
st2ep   call    ayRegisterWrite ;!!!
        ld      a,c
        ret


;### ST2PLY -> Spielt initialisierten ST2-Sound (mu mit 50Hz aufgerufen werden)
;### Ausgabe    HL=Position, CF=1 -> Ende wurde erreicht
;### Veraendert AF,BC,DE,HL,IX,IY
st2plyr db 0
st2ply  
        call    envelopeInterrupt      ;!!!
        ld bc,128+3
        call st2ply1
sndmem5 ld hl,#0000
        ld bc,128+#5cf+3
        add hl,bc
        ld e,(hl)
        inc hl
        ld d,(hl)
        ld hl,(st2datbeg)
        ex de,hl
        or a
        sbc hl,de
        ld ix,st2plyr
        ld a,(ix+0)
        ld (ix+0),0
        sub 1
        ccf
        ret

st2ply1 
sndmem6 ld hl,#0000 ;##!!##
        add hl,bc

        ld bc,st2ply3
        push bc
        di
        jp (hl)
st2ply3 ei
        ret

st2ply2 ex de,hl
        inc hl
        ld e,(hl)
        ld a,1
        ld (st2plyr),a
        ret

;### ST2STP -> Hlt ST2-Sound an
;### Veraendert AF,BC,DE,HL,IX,IY
st2stp  ld bc,128+6
        jr st2ply1

;### ST2POS -> Setzt ST2-Sound auf eine bestimmte Position
;### Eingabe    HL=Position, Sound mu initialisiert sein
;### Veraendert AF,BC,DE,HL,IX,IY
st2pos  ld a,l
        or h
        ret z
        ld bc,-3
        ld de,-2
st2pos0 inc de
        add hl,bc
        jr c,st2pos0
sndmem7 ld bc,#0000
        ld hl,128+#4c4+6
        add hl,bc
        ld (hl),1
        inc hl
        ld (hl),1
        ld l,e
        ld h,d
        add hl,hl
        add hl,de
        ex de,hl        ;DE=(Position-1) * 3
        ld ix,#5cf+3+128
        call st2pos1
        ld ix,#5fd+3+128
        call st2pos1
        ld ix,#62b+3+128
st2pos1 add ix,bc
        ld l,(ix+0)
        ld h,(ix+1)
        add hl,de
        ld (ix+0),l
        ld (ix+1),h
        ret

;### ST2CHN -> Holt Lautstrke und Frequenz eines Kanales
;### Eingabe    A=Kanal (0-2)
;### Ausgabe    A=Lautstrke (0-15), L=Frequenz (0-15)
;### Verndert  F,BC,DE,HL
st2chn  ld hl,#0800
        cp 1
        jr c,st2chn1
        ld hl,#0902
        jr z,st2chn1
        ld hl,#0a04
st2chn1 ld c,l
        di
        call st2reg
        ld c,l
        inc c
        ld l,a
        call st2reg
        ld c,h
        ld h,a          ;HL=Frq
        call st2reg
        ei
        and 15          ;A=Volume
        push af
        ld a,l
        and 7
        add a
        ld l,a
        ld a,h
        rlca
        and 1
        or l
        ld l,a
        pop af
        ret


;==============================================================================
;### SOUNDTRAKKER 128 SUB-ROUTINEN ############################################
;==============================================================================

;### ST2REG -> Liest PSG-Register aus
;### Eingabe    C=Register
;### Ausgabe    A=Wert
;### Veraendert F,BC,DE
st2reg  jr st2regCPC        ;!!!
st2regMSX
        ld a,c
        out (#a0),a
        in a,(#a2)
        ret
st2regCPC
        ld de,#82f4
        ld b,e
        out (c),c
        ld bc,#f6c0
        out (c),c
        ld c,0
        out (c),c
        inc b
        ld a,#92
        out (c),a
        set 6,c
        ld b,#f6
        out (c),c
        ld b,e
        in a,(c)
        ld bc,#f700
        out (c),d
        dec b
        out (c),c
        ret
st2regEP
        ld      a,c            ;!!!
        jp      ayRegisterRead

;### ST2REL -> Relociert geladenes Soundtrakker 128 Modul
;### Eingabe    HL=Adresse
st2relnew   dw 0    ;neue Adresse
st2reldif   dw 0    ;Differenz
st2reltab
db #81,#40,#84,#40,#87,#40,#8B,#40,#8E,#40,#91,#40,#94,#40,#97,#40,#9A,#40
db #9E,#40,#A2,#40,#D6,#40,#E9,#40,#EC,#40,#F2,#40,#F8,#40,#06,#41,#0D,#41,#14,#41
db #1B,#41,#1E,#41,#23,#41,#26,#41,#29,#41,#2D,#41,#30,#41,#33,#41,#37,#41,#3A,#41
db #3D,#41,#40,#41,#43,#41,#48,#41,#4D,#41,#52,#41,#57,#41,#5A,#41,#67,#41,#6A,#41
db #6D,#41,#70,#41,#73,#41,#A5,#41,#BD,#41,#C0,#41,#C4,#41,#D0,#41,#E1,#41,#FB,#41
db #23,#42,#4F,#42,#B6,#42,#D4,#42,#30,#43,#50,#43,#57,#43,#7F,#43,#9B,#43,#AC,#43
db #BC,#43,#C0,#43,#DD,#43,#E3,#43,#05,#44,#0C,#44,#18,#44,#29,#44,#51,#44,#58,#44
db #5E,#44,#6B,#44,#72,#44,#7C,#44,#82,#44,#85,#44,#88,#44,#8E,#44,#99,#44,#A5,#44
db #B0,#44,#B5,#44,#B8,#44,#D7,#44,#DA,#44,#E2,#44,#F6,#44,#11,#45,#50,#45,#52,#45
db #54,#45,#56,#45,#58,#45,#5A,#45,#5C,#45,#5E,#45,#60,#45,#62,#45,#64,#45,#66,#45
db #68,#45,#6A,#45,#6C,#45,#BA,#46,#BC,#46,#BE,#46
dw #46c6+#80,#46ce+#80,#46d6+#80,#46de+#80
dw 0

st2rel  ld (st2relnew),hl   ;HL=Neue Adresse
        inc hl
        ld e,(hl)
        inc hl
        ld d,(hl)           ;DE=Alte Adresse + 9
        ld bc,7
        add hl,bc           ;HL=Neue Adresse + 9
        sbc hl,de           ;HL=Differenz (neu-alt)
        ld (st2reldif),hl
        ld ix,st2reltab         ;*** Code relozieren
st2rel1 ld l,(ix+0)
        ld h,(ix+1)
        ld a,l
        or h
        jr z,st2rel2
        ld bc,-#4080
        add hl,bc
        ld bc,(st2relnew)
        add hl,bc
        ld e,(hl)
        inc hl
        ld d,(hl)
        ld bc,(st2reldif)
        ex de,hl
        add hl,bc
        ex de,hl
        ld (hl),d
        dec hl
        ld (hl),e
        inc ix
        inc ix
        jr st2rel1
st2rel2 ld ix,(st2relnew)       ;*** Daten 2 relocieren
        ld bc,#063a
        add ix,bc
        ld l,(ix+2)
        ld h,(ix+3)
        ld e,(ix+0)
        ld d,(ix+1)
        ld (st2datbeg),de
        sbc hl,de
        ld c,l
        ld b,h              ;BC=Anzahl -> len*3
        ld (st2datlen),bc
        push de
        pop ix              ;IX=Anfang
        ld de,(st2reldif)
        jr st2rel4
st2rel3 ld l,(ix+1)
        ld h,(ix+2)
        add hl,de
        ld (ix+1),l
        ld (ix+2),h
        inc ix
        inc ix
        inc ix
        dec bc
st2rel4 ld a,c
        or b
        jr nz,st2rel3
        ld ix,(st2relnew)       ;*** Daten 1 relocieren
        ld bc,#0640
        add ix,bc
        ld b,80/4
st2rel5 call st2rel6
        call st2rel6
        call st2rel6
        inc ix
        inc ix
        djnz st2rel5
        ret
st2rel6 ld l,(ix+0)
        ld h,(ix+1)
        add hl,de
        ld (ix+0),l
        ld (ix+1),h
        inc ix
        inc ix
        ret

        

; =============================================================================    ;!!!

; if enabled, channel A is played at the left, channel B at center,
; and channel C at right
ENABLE_STEREO           equ     1
; envelope sample rate = 1000 / ENV_SRATE_DIV Hz (increase this for lower
; quality and CPU usage)
ENV_SRATE_DIV           equ     1
; minimum envelope frequency value (should be at least 14 * ENV_SRATE_DIV,
; and less than 256)
MIN_ENV_FREQVAL         equ     98 * ENV_SRATE_DIV
    ; if non-zero, the envelope generator is stopped in modes 8, 10, 12, and 14
    ; when the envelope enable bits in registers 8 to 10 are changed to disabled
    ; on all channels (NOTE continuing the envelope by enabling it again in
    ; registers 8 to 10 does not work correctly, the envelope must be restarted
    ; by writing to register 13)
ENVELOPE_CPU_SAVING     equ     1
; if non-zero, the envelope emulation routine is disabled
NO_ENVELOPE_IRQ         equ     0
; DAVE channels assigned to each AY channel
ayDaveChnA              equ     0
ayDaveChnB              equ     1
ayDaveChnC              equ     2

  if NO_ENVELOPE_IRQ = 0

envelopeInterrupt:
        ret
;    if ENV_SRATE_DIV < 2
;        ld    a,33h
;        out   (0b4h), a
;    endif
        ld      a,#30
        out     (#b4), a
        push  hl
        push  bc
envelopeInterruptl1:
        ld    hl, #0000                 ; * envelope counter
;        ld    bc, 10000h - (((60000 * ENV_SRATE_DIV) + 500) / 50)      ;1000
envfreq ld      bc,#fb50    ;60000
;        ld      bc,#f74e    ;110830
        add   hl, bc
envelopeInterruptl2:
        jr    c, envelopeInterruptl19   ; * JR if envelope is stopped
envelopeInterruptl3:    
        ld    bc, #ffff                 ; * envelope frequency
envelopeInterruptl4:
        ld    a, 0                      ; * envelope state (0 to 15)
envelopeInterruptl5:
        dec   a                         ; * envelope direction (INC A or DEC A)
        add   hl, bc
        jr    nc, envelopeInterruptl5
        ld    (envelopeInterruptl1 + 1), hl
        cp    #10
envelopeInterruptl6:
        jr    nc, envelopeInterruptl21  ; * envelope mode
envelopeInterruptl7:
        ld    (envelopeInterruptl4 + 1), a
envelopeInterruptl8:
;        or    ayVolumeTable
envelopeInterruptl9:
        ld      hl,ayVolumeTable
        ld      c, a
        ld      b,#00
        add     hl,bc
        ld      a, (hl)
        pop     bc
envelopeInterruptl10:
        jr    envelopeInterruptl12     ; * envelope enable mode
envelopeInterruptl11:
        out   (#a8 + ayDaveChnA), a    ; envelope on channel A only
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl12:
        pop   hl
        ret
envelopeInterruptl13:
        out   (#a8 + ayDaveChnA), a    ; envelope on channels A and B
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl14:
    if ENABLE_STEREO = 1
        ld    l, a                      ; envelope on channel B only (Carry=0)
        rra
        scf
        adc   a, l
        rra
    endif
        out   (#a8 + ayDaveChnB), a
        out   (#ac + ayDaveChnB), a
        pop   hl
        ret
envelopeInterruptl15:
        out   (#a8 + ayDaveChnA), a    ; envelope on channels A and C
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl16:
    if ENABLE_STEREO = 0
        out   (0a8h + ayDaveChnC), a
    endif
        out   (#ac + ayDaveChnC), a    ; envelope on channel C only
        pop   hl
        ret
envelopeInterruptl17:
        out   (#a8 + ayDaveChnA), a    ; envelope on channels A, B, and C
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl18:
    if ENABLE_STEREO = 0
        out   (0a8h + ayDaveChnC), a
    endif
        out   (#ac + ayDaveChnC), a    ; envelope on channels B and C
    if ENABLE_STEREO = 1
        ld    l, a                      ; NOTE Carry is always 0 here
        rra
        scf
        adc   a, l
        rra
    endif
        out   (#a8 + ayDaveChnB), a
        out   (#ac + ayDaveChnB), a
        pop   hl
;        pop     af
;        ei
        ret
envelopeInterruptl19:
        ld    (envelopeInterruptl1 + 1), hl
        pop   bc
        pop   hl
        ret
envelopeInterruptl20:   
        ld    l,15                      ; envelope modes 11 and 13      ayVolumeTable + 15
        defb  #01                       ; = LD BC, nnnn
envelopeInterruptl21:
        ld    l, 00                     ; envelope modes 0 to 7, 9, and 15   ayVolumeTable
        ld    a, #18                    ; = JR +nn
        ld    (envelopeInterruptl2), a  ; stop envelope
        ld    a,l
        jp    envelopeInterruptl9
envelopeInterruptl22:   
        and   #0f                       ; envelope modes 8 and 12
        jp    envelopeInterruptl7
envelopeInterruptl23:   
        jp    m, envelopeInterruptl24   ; envelope modes 10 and 14
        xor   #1f
        ld    l, a
        ld    h, #3d                    ; set direction to DEC A
        ld    (envelopeInterruptl4 + 1), hl ; assume .l5 = .l4 + 2
        jp    envelopeInterruptl8
envelopeInterruptl24:
        cpl
        ld    l, a
        ld    h, #3c                    ; set direction to INC A
        ld    (envelopeInterruptl4 + 1), hl
        jp    envelopeInterruptl8

  endif
; -----------------------------------------------------------------------------

ayTablesBegin:

ayVolumeTable:
        defb   0,  1,  2,  3,  4,  5,  6,  9
        defb  12, 17, 22, 28, 36, 44, 53, 63

ayRegWriteTable:
        db  ayRegisterWritel3 - ayRegisterWritel1 - 2
        db  ayRegisterWritel3 - ayRegisterWritel1 - 2
        db  ayRegisterWritel4 - ayRegisterWritel1 - 2
        db  ayRegisterWritel4 - ayRegisterWritel1 - 2
        db  ayRegisterWritel6 - ayRegisterWritel1 - 2
        db  ayRegisterWritel6 - ayRegisterWritel1 - 2
        db  ayRegisterWritel7 - ayRegisterWritel1 - 2
        db  ayRegisterWritel5 - ayRegisterWritel1 - 2
        db  ayRegisterWritel9 - ayRegisterWritel1 - 2
        db  ayRegisterWritel10 - ayRegisterWritel1 - 2
        db  ayRegisterWritel11 - ayRegisterWritel1 - 2
        db  ayRegisterWritel12 - ayRegisterWritel1 - 2
        db  ayRegisterWritel12 - ayRegisterWritel1 - 2
        db  ayRegisterWritel15 - ayRegisterWritel1 - 2
        db  ayRegisterWritel8 - ayRegisterWritel1 - 2
        db  ayRegisterWritel8 - ayRegisterWritel1 - 2

ayRegisters:
        defb  00, 00, 00, 00, 00, 00, 00, 00
        defb  00, 00, 00, 00, 00, 00, 00, 00


    if NO_ENVELOPE_IRQ = 0

envelopeModeTable:
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl22 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl23 - envelopeInterruptl6 - 2
        db  envelopeInterruptl20 - envelopeInterruptl6 - 2
        db  envelopeInterruptl22 - envelopeInterruptl6 - 2
        db  envelopeInterruptl20 - envelopeInterruptl6 - 2
        db  envelopeInterruptl23 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2

;        assert  ($ & 000fh) = 0

envelopeEnableTable:
        db  envelopeInterruptl12 - envelopeInterruptl11
        db  envelopeInterruptl11 - envelopeInterruptl11
        db  envelopeInterruptl14 - envelopeInterruptl11
        db  envelopeInterruptl13 - envelopeInterruptl11
        db  envelopeInterruptl16 - envelopeInterruptl11
        db  envelopeInterruptl15 - envelopeInterruptl11
        db  envelopeInterruptl18 - envelopeInterruptl11
        db  envelopeInterruptl17 - envelopeInterruptl11

;        assert  ($ & 0007h) = 0

    endif

; -----------------------------------------------------------------------------

setChannelAmplitude:
        cp    #10
        jr    c, setChannelAmplitudel1
    if NO_ENVELOPE_IRQ = 0
        res   3, b
        ld    a, (envelopeInterruptl4 + 1)
    else
        xor   a
    endif
setChannelAmplitudel1:                  ; HL = ayRegWriteTable + (8 + channel)
        push    de
        ld      e,a
        ld      d,#00
        ld      hl,ayVolumeTable
        add     hl,de
    if ENABLE_STEREO = 1
        bit   0, c                      ; Z = 0 channel B, Z = 1 channel A, C
    endif
        ld    a, (hl)
    if ENABLE_STEREO = 1
        jr    z, setChannelAmplitudel2
        ld    l, a                      ; NOTE Carry is always 0 here
        rra
        scf
        adc   a, l
        rra
    endif
        out   (c), a
        set   2, c
setChannelAmplitudel2:
        out   (c), a
    if NO_ENVELOPE_IRQ = 0
setChannelAmplitudel3:
        ld      e,#00
        ld      a,e
        or      b
        cp      #08
        jr      c, setChannelAmplitudel4
        xor     b
setChannelAmplitudel4:
        cp    e
        jr    z, setChannelAmplitudel5  ; envelope enable bit has not changed ?
        ld    (setChannelAmplitudel3 + 1), a
        ld    hl, envelopeEnableTable   ; *
        ld      e,a
        add     hl,de
        ld    a, (hl)
        ld    (envelopeInterruptl10 + 1), a
      if ENVELOPE_CPU_SAVING = 1
        ld    a, (envelopeInterruptl6 + 1)     ; check envelope mode:
        cp    envelopeInterruptl22 - envelopeInterruptl6 - 2
        jr    c, setChannelAmplitudel5                    ; hold or not continue ?
        xor     a                       ;ld    a, envelopeEnableTable
        sub   e
        sbc   a, a
        and   #20
        or    #18                       ; JR +nn or JR C, +nn
        ld    (envelopeInterruptl2), a ; disable envelope if it is not used
      endif
    endif
setChannelAmplitudel5:
        pop     de
        pop   bc
        pop   hl
        ret

setChannelAFreq:
        ld    c,  ayDaveChnA * 2 + #a0
        ld    a, (ayRegisters + 7)
        ld    hl, (ayRegisters)
        bit   3, a
        jr    z, setNoiseGenFreq        ; noise generator enabled ?
        rrca
        jr    nc, setToneGenFrequency   ; tone generator enabled ?
        xor   a                         ; channel disabled
        out   (ayDaveChnA * 2 + #a0), a
        out   (ayDaveChnA * 2 + #a1), a
        ret

setChannelBFreq:
        ld    c, ayDaveChnB * 2 + #a0
        ld    a, (ayRegisters + 7)
        ld    hl, (ayRegisters + 2)
        bit   4, a
        jr    z, setNoiseGenFreq        ; noise generator enabled ?
        and   #02
        jr    z, setToneGenFrequency    ; tone generator enabled ?
        xor   a                         ; channel disabled
        out   (ayDaveChnB * 2 + #a0), a
        out   (ayDaveChnB * 2 + #a1), a
        ret

setChannelCFreq:
        ld    c, ayDaveChnC * 2 + #a0
        ld    a, (ayRegisters + 7)
        ld    hl, (ayRegisters + 4)
        bit   5, a
        jr    z, setNoiseGenFreq        ; noise generator enabled ?
        and   #04
        jr    z, setToneGenFrequency    ; tone generator enabled ?
        xor   a                         ; channel disabled
        out   (ayDaveChnC * 2 + #a0), a
        out   (ayDaveChnC * 2 + #a1), a
        ret


setToneGenFrequency:

setToneGenFrequency_:
convval  add     hl,hl
.calcfrr dec   hl
        ld      a,h
        cp    #10
        jr    nc, setToneGenFrequency_l2    ; overflow ?
setToneGenFrequency_l1:
        out   (c), l
        inc   c
        out   (c), a
        ret
setToneGenFrequency_l2:
        inc   l
        inc   a
        jr    z, setToneGenFrequency_l1
        ld    l, #ff
        ld    a, #0f
        jp    setToneGenFrequency_l1

setNoiseGenFreq:
        ld    h, #30

setNoiseGenFreq_:
        ld    a, (ayRegisters + 6)
        cp    1
        adc   a, 0
        add   a, a
        add   a, a
        dec   a
        out   (c), a
        inc   c
        out   (c), h
        ret

; -----------------------------------------------------------------------------

; reset AY-3-8912 emulation
ayReset1
        ld      a,#29       ;add hl,hl ;!!!
        ld      hl,#fb46	;60000Hz
        jr      ayReset
ayReset2
        xor     a
        ld      hl,#f74e	;110830Hz
ayReset:
        ret
;        push    af
;        push    hl
        push    bc
;        di
        ld      (convval+1),a
        ld      (envfreq+1),hl
        ld    hl, ayRegisters - 1
        ld    bc, #10af
        xor   a
ayResetl1:
        inc   hl
        out   (c), a
        ld    (hl), a
        dec   c
        djnz  ayResetl1
        res   3, l                      ; register 7
        ld    (hl), #3f
    if NO_ENVELOPE_IRQ = 0
        ld    (envelopeInterruptl4 + 1), a
        ld    a, #18                    ; = JR +nn
        ld    (envelopeInterruptl2), a
        ld    hl, MIN_ENV_FREQVAL
        ld    (envelopeInterruptl3 + 1), hl
        ld    a, envelopeInterruptl12 - envelopeInterruptl11
        ld    (envelopeInterruptl10 + 1), a
        xor     a                       ;ld    a, envelopeEnableTable
        ld    (setChannelAmplitudel3 + 1), a
    endif
        ld    a, #10                    ; use 17-bit noise generator
        out   (#a6), a
        pop     bc
        ret

; read AY-3-8912 register A, returning the value in A

ayRegisterRead:
        push    hl
        and     #0f
        ld      c,a
        ld      b,#00
        ld      hl, ayRegisters
        add     hl,bc
        ld      a, (hl)
        or      a
        pop     hl
        ret

; write C to AY-3-8912 register A
; NOTE interrupts may be enabled on return
ayRegisterWrite
    ;        push  af
        push    hl
        push    bc
        and     #0f
        ld      b,a
        ld      a,c
        ld      c,b
        ld      b,#00
        ld      hl,ayRegisters
        add     hl,bc
        ld      (hl),a
        ld      hl, ayRegWriteTable
        add     hl,bc
        ld      a,(hl)
        ld      (ayRegisterWritel1 + 1), a
ayRegisterWritel1:
        jr    ayRegisterWritel8             ; *

ayRegisterWritel3:    
        call  setChannelAFreq           ; tone generator A frequency
        pop     bc
        pop     hl
        ret
ayRegisterWritel4:
        call  setChannelBFreq           ; tone generator B frequency
        pop     bc
        pop     hl
        ret
ayRegisterWritel5:
        call  setChannelAFreq           ; mixer
        call  setChannelBFreq
ayRegisterWritel6:
        call  setChannelCFreq           ; tone generator C frequency
        pop     bc
        pop     hl
        ret
ayRegisterWritel7:
        ld    a, (ayRegisters + 7)      ; noise generator frequency
        ld    b, a
        and   #08
        call  z, setChannelAFreq
        bit   4, b
        call  z, setChannelBFreq
        bit   5, b
        call  z, setChannelCFreq
ayRegisterWritel8:
        pop   bc
        pop     hl
        ret
ayRegisterWritel9:
        ld    a, (ayRegisters + 8)      ; channel A amplitude / envelope enable
    if NO_ENVELOPE_IRQ = 0
        ld    bc, #09a8 + ayDaveChnA
    else
        ld    c, #0a8 + ayDaveChnA
    endif
        jp    setChannelAmplitude
ayRegisterWritel10:   
        ld    a, (ayRegisters + 9)      ; channel B amplitude / envelope enable
    if NO_ENVELOPE_IRQ = 0
        ld    bc, #aa8 + ayDaveChnB
    else
        ld    c, #a8 + ayDaveChnB
    endif
        jp    setChannelAmplitude
ayRegisterWritel11:
        ld    a, (ayRegisters + 10)     ; channel C amplitude / envelope enable
    if ENABLE_STEREO = 0
      if NO_ENVELOPE_IRQ = 0
        ld    bc, #ca8 + ayDaveChnC
      else
        ld    c, #a8 + ayDaveChnC
      endif
    else
      if NO_ENVELOPE_IRQ = 0
        ld    bc, #cac + ayDaveChnC
      else
        ld    c, #ac + ayDaveChnC
      endif
    endif
        jp    setChannelAmplitude
ayRegisterWritel12:
    if NO_ENVELOPE_IRQ = 0
        ld    hl, (ayRegisters + 11)    ; envelope generator frequency
        ld    a, h
        or    a
        jr    nz, ayRegisterWritel13
        ld    a, MIN_ENV_FREQVAL
        cp    l
        jr    c, ayRegisterWritel13
        ld    l, a                      ; limit envelope frequency
ayRegisterWritel13:
        ld    (envelopeInterruptl3 + 1), hl
        pop   bc
    ;        pop   af
        pop     hl
        ret
    else
        jr    ayRegisterWritel8
    endif
ayRegisterWritel15:                     ; envelope generator mode / restart
    if NO_ENVELOPE_IRQ = 0
ayRegisterWritel16:   
        ld    hl, (envelopeInterruptl3 + 1)
        ld    (envelopeInterruptl1 + 1), hl
        ld    a, #38                    ; = JR C, +nn
        ld    (envelopeInterruptl2), a ; enable envelope
        ld    a, (ayRegisters + 13)
        ld      c,a
        ld      b,#00
        ld      hl, envelopeModeTable
        add     hl,bc
        and     #04
        ld      a, (hl)
        ld      (envelopeInterruptl6 + 1), a
        ld      hl, #3c00                 ; INC A, state = 0
        ld      a, l
        jr      nz, ayRegisterWritel17    ; attack ?
        ld      hl, #3d0f                 ; DEC A, state = 15
        ld      a, #3f
ayRegisterWritel17:
        pop     bc
        ld    (envelopeInterruptl4 + 1), hl    ; assume eInt.l5 = eInt.l4 + 2
        call  ayRegisterWritel18
        pop     hl
        ret
ayRegisterWritel18:
        call  envelopeInterruptl10     ; NOTE this will pop return address
    else
        jr    ayRegisterWritel8
    endif
