;Write "Fosfos.bin"
;==============================================================================
;### PT3-ROUTINEN #############################################################
;==============================================================================
;jmp_sysinf
;Quig_Machine_Type
;### PT3INI -> Initialisiert PT3-Sound
;### Eingabe    HL=Adresse
;### Ausgabe    CF=0 -> ok, HL=Anzahl Positionen
;###            CF=1 -> nicht untersttztes Format
;### Veraendert AF,BC,DE,HL,IX,IY
.pt3inia:
		dw 0
.Sound_Init:
.pt3ini:
		call    pt3sysini
;        ld de,-128
;        add hl,de
        ld      de,#0080
        add     hl,de
        ld 		(pt3inia),hl
        push 	hl
        ld 		de,101
        add 	hl,de
        ld 		l,(hl)
        ex 		(sp),hl
        di
        ex 		af,af
        push 	af
        ex 		af,af
        call 	INIT
        ex 		af,af
        call    ayReset2       ;!!!
        pop 	af
        ex 		af,af
        ei
        pop 	hl
        ld 		h,a
        ret

.pt3sysini:
;### SYSINI -> Computer-Typ abhngige Initialisierung
        push    af
        push    bc
        push    de
        push    hl
        push    ix
        push    iy
        ld 		hl,jmp_sysinf        ;*** Computer-Typ holen ;2-5 CPC,6 ep, >7 MSX
        ld 		de,256*1+5
        ld 		ix,Quig_Machine_Type
        ld 		iy,66+2+6+8
        rst 	#28
        ld 		a,(Quig_Machine_Type)
        and 	15

        cp 		6
        jr      c,pt3iend         ;!!! CPC
        ld      a,ROUTMSX-ROUT_A0-2
        jr      nz,MSXcnt
        xor     a
        ld      (envelopeInterrupt),a
        ld      (ayReset),a
        ld      a,ROUTEP-ROUT_A0-2
.MSXcnt:  
		ld      (ROUT_A0+1),a     ;pt3 player
.pt3iend: 
		pop     iy
        pop     ix
        pop     hl
        pop     de
        pop     bc
        pop     af
        ret

;### PT3VOL -> Setzt die globale Lautstrke
;### Eingabe    A=Lautstrke (0-255)
;### Verndert  AF
.pt3vol:  
		srl 	a:srl a:srl a:srl a
        neg
        add 	15
        ld 		(ROUT+1),a
        ret

;### PT3CHN -> Holt Lautstrke und Frequenz eines Kanales
;### Eingabe    A=Kanal (0-2)
;### Ausgabe    A=Lautstrke (0-15), L=Frequenz (0-15)
;### Verndert  F,BC,E,H
.pt3chn:
		ld 		c,a
        ld 		b,0
        ld 		hl,AYREGS+8
        add 	hl,bc
        ld 		e,(hl)
        ld 		hl,AYREGS
        add 	hl,bc
        add 	hl,bc
        ld 		a,(hl)
        inc 	hl
        and 	7
        add 	a
        ld 		l,a
        ld 		a,(hl)
        rlca
        and 	1
        or 		l
        ld 		l,a
        ld 		a,e
        and 	15
        ret

;### PT3PLY -> Spielt initialisierten PT3-Sound (mu mit 50Hz aufgerufen werden)
;### Ausgabe    HL=Position, CF=1 -> Ende wurde erreicht
;### Veraendert AF,BC,DE,HL,IX,IY
.pt3plyp:
		dw 		0
.Sound_Play:
.pt3ply:
		di
        ex 		af,af
        push 	af
        ex 		af,af
        call 	PT3PLAY
        ex 		af,af
        pop 	af
        ex 		af,af
        ei
        ret

;### PT3STP -> Hlt PT3-Sound an
;### Veraendert AF,BC,DE,HL,IX,IY
.Sound_Stop:
.pt3stp:
		di
        ex 		af,af
        push 	af
        ex 		af,af
        call 	MUTE
        ex 		af,af
        pop 	af
        ex 		af,af
        ei
        ret

;### PT3POS -> Setzt PT3-Sound auf eine bestimmte Position
;### Eingabe    HL=Position, Sound mu initialisiert sein
;### Veraendert AF,BC,DE,HL,IX,IY
.pt3pos:
		ld 		bc,(pt3plyp)
        add 	hl,bc
        ld 		(CrPsPtr),hl
        ret

;==============================================================================
;### PT3-ROUTINEN (INTERN) ####################################################
;==============================================================================

;MODIFIED version by Prodatron/SymbiosiS
;removed SFX-support, compiles with WinApe and works on MSX and Amstrad CPC (with tone pitch correction)

;MODIFIED version by Kevin Thacker
;compiles with pasmo and works on Amstrad CPC

;MODIFIED version by Lee du-Caine
;compiles with ZX Spin assembler
;MODIFIED version by Kevin Thacker

;Vortex Tracker II v1.0 PT3 player for ZX Spectrum
;(c)2004 S.V.Bulba <vorobey@mail.khstu.ru> http//bulba.at.kz

;Release number
.Release:	 EQU "6"

;Features
;--------
;-Can be compiled at any address (i.e. no need rounding ORG
; address).
;-Variables (VARS) can be located at any address (not only after
;code block).
;-INIT subroutine detects module version and rightly generates
; both note and volume tables outside of code block (in VARS).
;-Two portamento (spc. command 3xxx) algorithms (depending of
; module version).
;-Any Tempo value are accepted (including Tempo=1 and Tempo=2).
;-Fully compatible with Ay_Emul PT3 player codes.
;-See also notes at the end of this source code.

;Limitations
;-----------
;-Can run in RAM only (self-modified code is used).

;Warning!!! PLAY subroutine can crash if no module are loaded
;into RAM or INIT subroutine was not called before.

;Call MUTE or INIT one more time to mute sound after stopping
;playing 

	;;ORG #8000

;Test codes (commented)
;	CALL START
;	EI
;_LP	HALT
;	CALL START+5
;	XOR A
;	IN A,(#FE)
;	CPL
;	AND 15
;	JR Z,_LP

;Entry and other points
;START initialization
;START+3 initialization with module address in HL
;START+5 play one quark
;START+8 mute
;START+10 setup and status flags
;START+11 pointer to current position value in PT3 module;
;After INIT (START+11) points to Postion0-1 (optimization)
;START+27 - INITPJMP - specify pattern to jump to in B, spot tune module in HL

.SetUp:	
		db 		0 ;set bit0 to 1, if you want to play without looping
	     ;bit7 is set each time, when loop point is passed
.CrPsPtr:
		dw 		0
		jr		InitPJmp

;Identifier
;	DB "=VTII PT3 Player r.",Release,"="
;*** REMOVED ABOVE TO SAVE BYTES

.CheckLP:	
		ld 		hl,Setup
		set 	7,(hl) ;set loop bit - this happens every time loop point is passed
		bit 	0,(HL)
		RET 	Z
		POP 	HL
		LD 		HL,DelyCnt
		INC 	(HL)
		LD 		HL,ChanA+CHNPRM_NtSkCn
		INC 	(HL)
.Mute:	
		XOR 	A	;A=0
		LD 		H,A	;H=A=0
		LD 		L,A	;L=A=0
		;now set all three AY channels to 0 amplitude
		LD 		(AYREGS+AR_AmplA),A
		LD 		(AYREGS+AR_AmplB),HL ;simple optimisation - AmplB and AmplC are adjacent bytes, so this is a simple way of loading them both with 0
		JP 		Rout

.Init:
;HL - AddressOfModule
		LD 		B,0
.InitPJmp:

		LD 		(MODADDR),HL ;store passed module address (HL)
		LD 		(MDADDR2),HL ;in MODADDR and MDADDR2
		PUSH 	HL		;put that MODADDR value on the stack too
		LD 		DE,100	;DE=100
		ADD 	HL,DE	;HL=HL+DE = 100 (0x64) bytes into the module address, after the header
		LD 		A,(HL)	;Load 1st byte from module (after header) - this is the modules default speed/rate
		LD 		(Delay),A	;Load it into Delay
		PUSH 	HL		;Push post-header module address
		POP 	IX		;Pop post-header module address onto IX
			;
		ADD 	HL,DE	;Add another 100 (stored in DE) onto address... this takes us to 200 - sequence data starts at 201. CrPsPtr=Current Pattern
	
		LD 		(pt3plyp),HL;Keep a backup of the first pattern position so we can use it for our pattern jumper
		INC 	B
.PJUMPLP:
		DEC 	B
		JR 		Z,DONEPJMP
		INC 	HL
		JR 		PJUMPLP

.DONEPJMP:
		LD 		(CrPsPtr),HL
		LD 		E,(IX+102-100);E=*post-header* module address + 2 = 102 = the loop point
		ADD 	HL,DE	;add the loop-point-pattern-pos (DE) onto 200...
		INC 	HL		;(...and add 1 because the table currently starts at 201)
		LD 		(LPosPtr),HL	;store the loop pointer in LPosPtr
		POP 	DE		;module address (MODADDR) popped onto DE
		LD 		L,(IX+103-100);retrieve the offset from the start of MODADDR to the start of pattern data
		LD 		H,(IX+104-100);we take off 100 because we are using the post-header MODADDR+100, which already has 100 added on.
		ADD 	HL,DE	;This puts the address of the pattern data into HL
		LD 		(PatsPtr),HL ;PatsPtr = Where the pattern data begins.
		LD 		HL,169	;169=where the Ornament pointers are
		ADD 	HL,DE	;HL=(modified)MODADDR+ORNAMENT POINTERS LOCATION
		LD 		(OrnPtrs),HL
		LD 		HL,105	;105=where the Sample pointers are...
		ADD 	HL,DE
		LD 		(SamPtrs),HL
		LD 		HL,SETUP	;looping bit
		RES 	7,(HL)	;unsets the "loop has been done bit" - this bit is set every time the loop point is passed

;note table data depacker
		LD 		DE,T_PACK
		LD 		BC,2*49 + T1_ - 1
.TP_0:	LD 		A,(DE)
		INC 	DE
		CP 		15*2
		JR 		NC,TP_1
		LD 		H,A
		LD 		A,(DE)
		LD 		L,A
		INC 	DE
		JR 		TP_2
.TP_1:	PUSH 	DE
		LD 		D,0
		LD 		E,A
		ADD 	HL,DE
		ADD 	HL,DE
		POP 	DE
.TP_2:	LD 		A,H
		LD 		(BC),A
		DEC 	BC
		LD 		A,L
		LD 		(BC),A
		DEC 	BC
		SUB 	#F0
		JR 		NZ,TP_0
	;NB A must now be 0, otherwise the loop would still be going on

		LD 		HL,VARS		;source
		LD 		(HL),A		;(HL) = 
		LD 		DE,VARS+1		;target
		LD 		BC,VAR0END-VARS-1 	;counter
		LDIR			;fill the VARS with 0
		INC 	A			;A=1

		LD 		(DelyCnt),A		;DelyCnt=1
		LD 		HL,#F001 ;H - CHNPRM_Volume, L - CHNPRM_NtSkCn
		LD 		(ChanA+CHNPRM_NtSkCn),HL
		LD 		(ChanB+CHNPRM_NtSkCn),HL
		LD 		(ChanC+CHNPRM_NtSkCn),HL

		LD 		HL,EMPTYSAMORN
		LD 		(AdInPtA),HL ;ptr to zero
		LD 		(ChanA+CHNPRM_OrnPtr),HL ;ornament 0 is "0,1,0"
		LD 		(ChanB+CHNPRM_OrnPtr),HL ;in all versions from
		LD 		(ChanC+CHNPRM_OrnPtr),HL ;3.xx to 3.6x and VTII

		LD 		(ChanA+CHNPRM_SamPtr),HL ;S1 There is no default
		LD 		(ChanB+CHNPRM_SamPtr),HL ;S2 sample in PT3, so, you
		LD 		(ChanC+CHNPRM_SamPtr),HL ;S3 can comment S1,2,3; see
				    ;also EMPTYSAMORN comment

		LD 		A,(IX+13-100) ;EXTRACT VERSION NUMBER
		SUB 	#30
		JR 		C,L20
		CP 		10
		JR 		C,L21
.L20:	LD 		A,6
.L21:	LD 		(Version),A
		PUSH 	AF
		CP 		4
		LD 		A,(IX+99-100) ;TONE TABLE NUMBER
		RLA
		AND 	7

;NoteTableCreator (c) Ivan Roshin
;A - NoteTableNumber*2+VersionForNoteTable
;(xx1b - 3.xx..3.4r, xx0b - 3.4x..3.6x..VTII1.0)

		LD 		HL,NT_DATA
		PUSH 	DE
		LD 		D,B
		ADD 	A,A
		LD 		E,A
		ADD 	HL,DE
		LD 		E,(HL)
		INC 	HL
		SRL 	E
		SBC 	A,A
		AND 	#A7 ;#00 (NOP) or #A7 (AND A)
		LD 		(L3),A
		EX 		DE,HL
		POP 	BC ;BC=T1_
		ADD 	HL,BC

		LD 		A,(DE)
;other variant (temporary, 1 byte longer...)
		LD 		BC,T_
		ADD 	A,C
		LD 		C,A
		ADC 	A,B

		SUB 	C
		LD 		B,A
		PUSH 	BC
		LD 		DE,NT_
		PUSH 	DE

		LD 		B,12
.L1:	PUSH 	BC
		LD 		C,(HL)
		INC 	HL
		PUSH 	HL
		LD 		B,(HL)

		PUSH 	DE
		EX 		DE,HL
		LD 		DE,23
		db 		#dd:ld h,8

.L2:	SRL 	B
		RR 		C
.L3:	DB 		#19	;AND A or NOP
		LD 		A,C
		adc 	a,d       ;;=ADC 0
		LD 		(HL),A
		INC 	HL
		LD 		A,B
		ADC 	A,D
		LD 		(HL),A
		ADD 	HL,DE
;	DEC HX
		db 		#dd:dec h

		JR 		NZ,L2
		POP 	DE
		INC 	DE
		INC 	DE
		POP 	HL
		INC 	HL
		POP 	BC
		DJNZ 	L1

		POP 	HL
		POP 	DE

		LD 		A,E
		CP 		TCOLD_1 AND 255
		JR 		NZ,CORR_1
		LD 		A,#FD
		LD 		(NT_+#2E),A

.CORR_1:LD 		A,(DE)
		AND 	A
		JR 		Z,TC_EXIT
		RRA
		PUSH 	AF
		ADD 	A,A
		LD 		C,A
		ADD 	HL,BC
		POP 	AF
		JR 		NC,CORR_2
		DEC 	(HL)
		DEC 	(HL)
.CORR_2:INC 	(HL)
		AND 	A
		SBC 	HL,BC
		INC 	DE
		JR 		CORR_1
.TC_EXIT:
		POP 	AF

;VolTableCreator (c) Ivan Roshin
;A - VersionForVolumeTable (0..4 - 3.xx..3.4x;
			   ;5.. - 3.5x..3.6x..VTII1.0)

		CP 		5
		LD 		HL,#11
		LD 		D,H
		LD 		E,H
		LD 		A,#17
		JR 		NC,M1
		DEC 	L
		LD 		E,L
		XOR 	A
.M1:    LD 		(M2),A
		LD 		IX,VT_+16
		LD 		C,#10

.INITV2:PUSH 	HL
		ADD 	HL,DE
		EX 		DE,HL
		SBC 	HL,HL

.INITV1:
		LD 		A,L
.M2:	DB 		#7D
		LD 		A,H
		ADC 	A,0
		LD 		(IX+#00),A
		INC 	IX
		ADD 	HL,DE
		INC 	C
		LD 		A,C
		AND 	15
		JR 		NZ,INITV1

		POP 	HL
		LD 		A,E
		CP 		#77
		JR 		NZ,M3
		INC 	E
.M3:    LD 		A,C
		AND 	A
		JR 		NZ,INITV2
		JP 		ROUT

;pattern decoder
.PD_OrSm:
		LD 		(IX+CHNPRM_Env_En-12),0
		CALL 	SETORN
		LD 		A,(BC)	;loads next piece of pattern data (because BC has already been incremented to point to it)
		INC 	BC		;increment BC to point to the next piece of data after that...
		RRCA

.PD_SAM:
		ADD 	A,A
.PD_SAM_:	
		LD 		E,A
		LD 		D,0
.SamPtrs:
		EQU 	$+1
		LD 		HL,#2121
		ADD 	HL,DE
		LD 		E,(HL)
		INC 	HL
		LD 		D,(HL)
.MODADDR: EQU 	$+1
		LD 		HL,#2121
		ADD 	HL,DE
		LD 		(IX+CHNPRM_SamPtr-12),L
		LD 		(IX+CHNPRM_SamPtr+1-12),H
		JR 		PD_LOOP

.PD_VOL:	
		RLCA
		RLCA
		RLCA
		RLCA
		LD 		(IX+CHNPRM_Volume-12),A
		JR 		PD_LP2
	
.PD_EOff:	
		LD 		(IX+CHNPRM_Env_En-12),A
		LD 		(IX+CHNPRM_PsInOr-12),A
		JR 		PD_LP2

.PD_SorE:
		DEC 	A
		JR 		NZ,PD_ENV
		LD 		A,(BC)
		INC 	BC
		LD 		(IX+CHNPRM_NNtSkp-12),A
		JR 		PD_LP2

.PD_ENV:
		CALL 	SETENV
		JR 		PD_LP2

PD_ORN	CALL SETORN
	JR PD_LOOP

PD_ESAM	LD (IX+CHNPRM_Env_En-12),A
	LD (IX+CHNPRM_PsInOr-12),A
	CALL NZ,SETENV
	LD A,(BC)
	INC BC
	JR PD_SAM_

	;when PTDECOD is called...
	;IX will have been set to ChanA+12,ChanB+12 or ChanC+12
	;BC will contain pointer to the relevant pattern data
PTDECOD LD A,(IX+CHNPRM_Note-12)	;A=current note
	LD (PrNote+1),A			;this alters a LD #xxxx later on
	LD L,(IX+CHNPRM_CrTnSl-12)	;loads L with low-byte of Current Tone Slide
	LD H,(IX+CHNPRM_CrTnSl+1-12)	;loads H with high-byte of Current Tone Slide
	LD (PrSlide+1),HL		;loads the Current Tone Slide into PrSlide (self-modifying LD #xxxx)




;PT3
;F0-FF - ornament number
;D0 - empty location?
;

PD_LOOP	LD DE,#2010	;DE=#2010
PD_LP2	LD A,(BC)	;Load A with the next piece of relevant pattern data (pointed to by BC)
;***			;NB INJECT DATA HERE?!
	INC BC		;increment BC - pattern ptr+1
	ADD A,E		;A+#10 ... Adds #10 onto A, which holds the piece of pattern data
	JR C,PD_OrSm	;If Carry has been set, there must be an ornament/sample on this line, so jump to relevant part...
	ADD A,D		;A+#20
	JR Z,PD_FIN	;END OF TRACK DATA
	JR C,PD_SAM
	ADD A,E		;A+#10
	JR Z,PD_REL
	JR C,PD_VOL
	ADD A,E		;A+#10
	JR Z,PD_EOff
	JR C,PD_SorE
	ADD A,96	;A+#60
	JR C,PD_NOTE
	ADD A,E		;A+#10
	JR C,PD_ORN
	ADD A,D		;A+#20
	JR C,PD_NOIS
	ADD A,E		;A+#10
	JR C,PD_ESAM
	ADD A,A		;A+A...
	LD E,A
	;LD HL,SPCCOMS+#FF20-#2000
	LD HL,SPCCOMS-#20E0; 
	ADD HL,DE
	LD E,(HL)
	INC HL
	LD D,(HL)
	PUSH DE
	JR PD_LOOP

PD_NOIS	LD (Ns_Base),A
	JR PD_LP2

PD_REL	RES 0,(IX+CHNPRM_Flags-12)
	JR PD_RES
	
PD_NOTE	LD (IX+CHNPRM_Note-12),A
	SET 0,(IX+CHNPRM_Flags-12)
	XOR A

PD_RES	LD (PDSP_+1),SP
	LD SP,IX
	LD H,A
	LD L,A
	PUSH HL
	PUSH HL
	PUSH HL
	PUSH HL
	PUSH HL
	PUSH HL
PDSP_	LD SP,#3131

PD_FIN	LD A,(IX+CHNPRM_NNtSkp-12)	;load up note skip data
	LD (IX+CHNPRM_NtSkCn-12),A
	RET

C_PORTM RES 2,(IX+CHNPRM_Flags-12)
	LD A,(BC)
	INC BC
;SKIP PRECALCULATED TONE DELTA (BECAUSE
;CANNOT BE RIGHT AFTER PT3 COMPILATION)
	INC BC
	INC BC
	LD (IX+CHNPRM_TnSlDl-12),A
	LD (IX+CHNPRM_TSlCnt-12),A
	LD DE,NT_
	LD A,(IX+CHNPRM_Note-12)
	LD (IX+CHNPRM_SlToNt-12),A
	ADD A,A
	LD L,A
	LD H,0
	ADD HL,DE
	LD A,(HL)
	INC HL
	LD H,(HL)
	LD L,A
	PUSH HL
PrNote	LD A,#3E
	LD (IX+CHNPRM_Note-12),A
	ADD A,A
	LD L,A
	LD H,0
	ADD HL,DE
	LD E,(HL)
	INC HL
	LD D,(HL)
	POP HL
	SBC HL,DE
	LD (IX+CHNPRM_TnDelt-12),L
	LD (IX+CHNPRM_TnDelt+1-12),H
	LD E,(IX+CHNPRM_CrTnSl-12)
	LD D,(IX+CHNPRM_CrTnSl+1-12)
Version EQU $+1
	LD A,#3E
	CP 6
	JR C,OLDPRTM ;Old 3xxx for PT v3.5-
PrSlide	LD DE,#1111
	LD (IX+CHNPRM_CrTnSl-12),E
	LD (IX+CHNPRM_CrTnSl+1-12),D
OLDPRTM	LD A,(BC) ;SIGNED TONE STEP
	INC BC
	EX AF,af
	LD A,(BC)
	INC BC
	AND A
	JR Z,NOSIG
	EX DE,HL
NOSIG	SBC HL,DE
	JP P,SET_STP
	CPL
	EX AF,af
	NEG
	EX AF,af
SET_STP	LD (IX+CHNPRM_TSlStp+1-12),A
	EX AF,af
	LD (IX+CHNPRM_TSlStp-12),A
	LD (IX+CHNPRM_COnOff-12),0
	RET

C_GLISS	SET 2,(IX+CHNPRM_Flags-12)
	LD A,(BC)
	INC BC
	LD (IX+CHNPRM_TnSlDl-12),A
	LD (IX+CHNPRM_TSlCnt-12),A
	LD A,(BC)
	INC BC
	EX AF,af
	LD A,(BC)
	INC BC
	JR SET_STP

C_SMPOS	LD A,(BC)
	INC BC
	LD (IX+CHNPRM_PsInSm-12),A
	RET

C_ORPOS	LD A,(BC)
	INC BC
	LD (IX+CHNPRM_PsInOr-12),A
	RET

C_VIBRT	LD A,(BC)
	INC BC
	LD (IX+CHNPRM_OnOffD-12),A
	LD (IX+CHNPRM_COnOff-12),A
	LD A,(BC)
	INC BC
	LD (IX+CHNPRM_OffOnD-12),A
	XOR A
	LD (IX+CHNPRM_TSlCnt-12),A
	LD (IX+CHNPRM_CrTnSl-12),A
	LD (IX+CHNPRM_CrTnSl+1-12),A
	RET

C_ENGLS	LD A,(BC)
	INC BC
	LD (Env_Del),A
	LD (CurEDel),A
	LD A,(BC)
	INC BC
	LD L,A
	LD A,(BC)
	INC BC
	LD H,A
	LD (ESldAdd),HL
	RET

C_DELAY	LD A,(BC)
	INC BC
	LD (Delay),A
	LD (DelyCnt),A
	RET
	
SETENV	LD (IX+CHNPRM_Env_En-12),E
	LD (AYREGS+AR_EnvTp),A
	LD A,(BC)
	INC BC
	LD H,A
	LD A,(BC)
	INC BC
	LD L,A
	LD (EnvBase),HL
	XOR A
	LD (IX+CHNPRM_PsInOr-12),A
	LD (CurEDel),A
	LD H,A
	LD L,A
	LD (CurESld),HL
C_NOP	RET

SETORN	ADD A,A	;double A... so ornament data began as 1111xxxx, where xxxx is the data, and ends up as xxxx0000
	LD E,A	;load it into E
	LD D,0	;D=0
	LD (IX+CHNPRM_PsInOr-12),D ;set Position In Ornament to 0, because we're starting to play a new ornament
OrnPtrs	EQU $+1		;self-modifying pointer
	LD HL,#2121	;...pointer to ornament data
	ADD HL,DE	;add the ornament pointer to the ornament number - now we have a pointer to the correct ornament index
	LD E,(HL)	;load the high byte of the index into E
	INC HL		;inc HL to point at low byte of index
	LD D,(HL)	;load the low byte of the index into D
MDADDR2	EQU $+1		;
	LD HL,#2121
	ADD HL,DE	;add the module pointer to the ornament offset
	LD (IX+CHNPRM_OrnPtr-12),L	;now we can load a memory pointer to the ornament into the OrnPtr struct
	LD (IX+CHNPRM_OrnPtr+1-12),H	;...
	RET

;ALL 16 ADDRESSES TO PROTECT FROM BROKEN PT3 MODULES
SPCCOMS DW C_NOP
	DW C_GLISS
	DW C_PORTM
	DW C_SMPOS
	DW C_ORPOS
	DW C_VIBRT
	DW C_NOP
	DW C_NOP
	DW C_ENGLS
	DW C_DELAY
	DW C_NOP
	DW C_NOP
	DW C_NOP
	DW C_NOP
	DW C_NOP
	DW C_NOP

CHREGS	XOR A			;A=0
	LD (Ampl),A		;Ampl=0
	BIT 0,(IX+CHNPRM_Flags)	;test bit 0 of the flags - the "enabled flag"
	PUSH HL			
	JP Z,CH_EXIT		;if channel not enabled, jump to CH_EXIT
	LD (CSP_+1),SP
	LD L,(IX+CHNPRM_OrnPtr)
	LD H,(IX+CHNPRM_OrnPtr+1)
	LD SP,HL
	POP DE
	LD H,A
	LD A,(IX+CHNPRM_PsInOr)
	LD L,A
	ADD HL,SP
	INC A
	CP D
	JR C,CH_ORPS
	LD A,E
CH_ORPS	LD (IX+CHNPRM_PsInOr),A
	LD A,(IX+CHNPRM_Note)
	ADD A,(HL)
	JP P,CH_NTP
	XOR A
CH_NTP	CP 96
	JR C,CH_NOK
	LD A,95
CH_NOK	ADD A,A
	EX AF,af
	LD L,(IX+CHNPRM_SamPtr)
	LD H,(IX+CHNPRM_SamPtr+1)
	LD SP,HL
	POP DE
	LD H,0
	LD A,(IX+CHNPRM_PsInSm)
	LD B,A
	ADD A,A
	ADD A,A
	LD L,A
	ADD HL,SP
	LD SP,HL
	LD A,B
	INC A
	CP D
	JR C,CH_SMPS
	LD A,E
CH_SMPS	LD (IX+CHNPRM_PsInSm),A
	POP BC
	POP HL
	LD E,(IX+CHNPRM_TnAcc)
	LD D,(IX+CHNPRM_TnAcc+1)
	ADD HL,DE
	BIT 6,B
	JR Z,CH_NOAC
	LD (IX+CHNPRM_TnAcc),L
	LD (IX+CHNPRM_TnAcc+1),H
CH_NOAC EX DE,HL
	EX AF,af
	LD L,A
	LD H,0
	LD SP,NT_
	ADD HL,SP
	LD SP,HL
	POP HL
	ADD HL,DE
	LD E,(IX+CHNPRM_CrTnSl)
	LD D,(IX+CHNPRM_CrTnSl+1)
	ADD HL,DE
CSP_	LD SP,#3131
	EX (SP),HL
	XOR A
	OR (IX+CHNPRM_TSlCnt)
	JR Z,CH_AMP
	DEC (IX+CHNPRM_TSlCnt)
	JR NZ,CH_AMP
	LD A,(IX+CHNPRM_TnSlDl)
	LD (IX+CHNPRM_TSlCnt),A
	LD L,(IX+CHNPRM_TSlStp)
	LD H,(IX+CHNPRM_TSlStp+1)
	LD A,H
	ADD HL,DE
	LD (IX+CHNPRM_CrTnSl),L
	LD (IX+CHNPRM_CrTnSl+1),H
	BIT 2,(IX+CHNPRM_Flags)
	JR NZ,CH_AMP
	LD E,(IX+CHNPRM_TnDelt)
	LD D,(IX+CHNPRM_TnDelt+1)
	AND A
	JR Z,CH_STPP
	EX DE,HL
CH_STPP SBC HL,DE
	JP M,CH_AMP
	LD A,(IX+CHNPRM_SlToNt)
	LD (IX+CHNPRM_Note),A
	XOR A
	LD (IX+CHNPRM_TSlCnt),A
	LD (IX+CHNPRM_CrTnSl),A
	LD (IX+CHNPRM_CrTnSl+1),A
CH_AMP	LD A,(IX+CHNPRM_CrAmSl)
	BIT 7,C
	JR Z,CH_NOAM
	BIT 6,C
	JR Z,CH_AMIN
	CP 15
	JR Z,CH_NOAM
	INC A
	JR CH_SVAM
CH_AMIN	CP -15
	JR Z,CH_NOAM
	DEC A
CH_SVAM	LD (IX+CHNPRM_CrAmSl),A
CH_NOAM	LD L,A
	LD A,B
	AND 15
	ADD A,L
	JP P,CH_APOS
	XOR A
CH_APOS	CP 16
	JR C,CH_VOL
	LD A,15
CH_VOL	OR (IX+CHNPRM_Volume)
	LD L,A
	LD H,0
	LD DE,VT_
	ADD HL,DE
	LD A,(HL)
CH_ENV	BIT 0,C
	JR NZ,CH_NOEN
	OR (IX+CHNPRM_Env_En)
CH_NOEN	LD (Ampl),A
	BIT 7,B
	LD A,C
	JR Z,NO_ENSL
	RLA
	RLA
	SRA A
	SRA A
	SRA A
	ADD A,(IX+CHNPRM_CrEnSl) ;SEE COMMENT BELOW
	BIT 5,B
	JR Z,NO_ENAC
	LD (IX+CHNPRM_CrEnSl),A
NO_ENAC	LD HL,AddToEn
	ADD A,(HL) ;BUG IN PT3 - NEED WORD HERE.
		   ;FIX IT IN NEXT VERSION?
	LD (HL),A
	JR CH_MIX
NO_ENSL RRA
	ADD A,(IX+CHNPRM_CrNsSl)
	LD (AddToNs),A
	BIT 5,B
	JR Z,CH_MIX
	LD (IX+CHNPRM_CrNsSl),A
CH_MIX	LD A,B
	RRA
	AND #48
CH_EXIT	LD HL,AYREGS+AR_Mixer 	;load up mixer settings into HL
	OR (HL)			;A would be 0 as default (channel not enabled)... so no change.
	RRCA			;???
	LD (HL),A		;load it back into AY regs mixer setting
	POP HL			;pops off the HL we pushed on at the start of CHREGS
	XOR A			;A=0
	OR (IX+CHNPRM_COnOff)	;...puts COnOff in A
	RET Z			;if COnOff is 0 then return
	DEC (IX+CHNPRM_COnOff)	;decrement the on/off value
	RET NZ			;and return if its not 0
				;...and if it is 0... (
	XOR (IX+CHNPRM_Flags)	;A = A XOR Flags = 0 XOR Flags... this toggles it? so the On/Off command just enables and disables the channel repeatedly
	LD (IX+CHNPRM_Flags),A	;put A back into the Flags... 
	RRA			;rotate A right - only affects carry flag. so if it was enabled, the carry flag is set
	LD A,(IX+CHNPRM_OnOffD)	;put the time/delay value for ONoff into A
	JR C,CH_ONDL		;if enabled, jump to CH_ONDL and store the ONoff value...
	LD A,(IX+CHNPRM_OffOnD) ;else use the OFFon delay time value.
CH_ONDL	LD (IX+CHNPRM_COnOff),A ;store it in the counter.
	RET

PT3PLAY    
        call    envelopeInterrupt      ;!!!
    XOR A 			;A=0
	LD (AddToEn),A		;(AddToEn)=0
	LD (AYREGS+AR_Mixer),A	;AYREGS.Mixer=0
	DEC A			;A=255
	LD (AYREGS+AR_EnvTp),A  ;(AYREGS.EnvTp)=255
	LD HL,DelyCnt		;...
	DEC (HL)		;DelyCnt=DelyCnt-1
	JP NZ,PL2 		;JUMP to PL2 if we are still part way through a row, and don't have a new pattern row to process yet
Delay	EQU $+1		;speed of the song in frames
	LD A,#3E
	LD (DelyCnt),A	;...since we just played a row, the counter needs resetting

	LD HL,ChanA+CHNPRM_NtSkCn ;(Note Skip Count) - for when there are no notes to play on this row, this tells us how many empty rows till the next
	DEC (HL)		  ;DEC ChanA+CHNPRM_NtSkCn
	JR NZ,PL1B		;if NtSkCn !=0, we are waiting for the next note in that row, so jump to PL1B and process channel B instead

;"Address In Pattern for Channel A"
AdInPtA	EQU $+1		;pointer to the #0101 below
	LD BC,#0101	;BC= address of pattern pointer for channel A
	LD A,(BC)	;A= next value from pattern for channel A
	AND A
	JR NZ,PL1A	;if not 0, we have a note or something... so jump to PL1A
	LD D,A		;D=A (=next value from pattern)
	LD (Ns_Base),A	;Ns_Base=A - Noise Base? For Noise column in tracker? (probably not - noise column is stored in channel B)
	LD HL,(CrPsPtr) ;HL=Current Pos Pointer?
	INC HL		;HL+1
	LD A,(HL)	;A=HL (Current Pos Ptr +1)
	INC A		;A=HL+1
	JR NZ,PLNLP
	CALL CHECKLP
LPosPtr	EQU $+1		;pointer to the #2121 below
	LD HL,#2121	;load the loop position pointer into HL
	LD A,(HL)	;load contents of pointer into A
	INC A		;increase pointer
PLNLP	LD (CrPsPtr),HL	;set the CurrentPattPositionPtr to the start of the loop
	DEC A		;dec pointer
	ADD A,A		;double it
	LD E,A		;load it into E
	RL D		;rotate D left (possibly "double it"?)
PatsPtr	EQU $+1		;pointer to the #2121 below
	LD HL,#2121	;load HL with pointer to the pattern data
	ADD HL,DE	;...
	LD DE,(MODADDR) ;...
	LD (PSP_+1),SP  ;i think this section is something to do with moving onto a new pattern in the sequence
	LD SP,HL	;...
	POP HL		;...
	ADD HL,DE	;...
	LD B,H		;...
	LD C,L		;...
	POP HL		;i think this section is something to do with moving onto a new pattern in the sequence, loading up the pointers for it, etc
	ADD HL,DE	;...
	LD (AdInPtB),HL	;...
	POP HL		;...
	ADD HL,DE	;...
	LD (AdInPtC),HL	;
PSP_	LD SP,#3131	;...
PL1A	LD IX,ChanA+12	;load the address+12 of channel A params into IX...
	CALL PTDECOD
	LD (AdInPtA),BC	;put BC in the address for PtA

;PROCESS CHANNEL B
PL1B	LD HL,ChanB+CHNPRM_NtSkCn ;Note Skip Count - the CHNPRM_NtSkCn needs adding on because we haven't checked B or C channels like we have the A one's pattern data
	DEC (HL)	;decrease it by 1
	JR NZ,PL1C	;if its still not 0, we have no note/data for this channel...
	LD IX,ChanB+12
AdInPtB	EQU $+1
	LD BC,#0101
	CALL PTDECOD
	LD (AdInPtB),BC

;PROCESS CHANNEL C
PL1C    LD HL,ChanC+CHNPRM_NtSkCn ;Note Skip Count
	DEC (HL)
	JP NZ,PL2
	LD IX,ChanC+12
AdInPtC	EQU $+1
	LD BC,#0101
	CALL PTDECOD
	LD (AdInPtC),BC


PL2		LD IX,ChanA
	LD HL,(AYREGS+AR_TonA)
	CALL CHREGS
	LD (AYREGS+AR_TonA),HL
	LD A,(Ampl)
	LD (AYREGS+AR_AmplA),A

	LD IX,ChanB
	LD HL,(AYREGS+AR_TonB)
	CALL CHREGS
	LD (AYREGS+AR_TonB),HL
	LD A,(Ampl)
	LD (AYREGS+AR_AmplB),A

	LD IX,ChanC
	LD HL,(AYREGS+AR_TonC)
	CALL CHREGS
	LD (AYREGS+AR_TonC),HL
	LD A,(Ampl)                 ;Ampl = AYREGS+AR_AmplC
	LD (AYREGS+AR_AmplC),A

	LD HL,(Ns_Base_AddToNs)
	LD A,H
	ADD A,L
	LD (AYREGS+AR_Noise),A

AddToEn EQU $+1
	LD A,#3E
	LD E,A
	ADD A,A
	SBC A,A
	LD D,A
	LD HL,(EnvBase)
	ADD HL,DE
	LD DE,(CurESld)
	ADD HL,DE
	LD (AYREGS+AR_Env),HL

	XOR A
	LD HL,CurEDel
	OR (HL)
	JR Z,ROUT
	DEC (HL)
	JR NZ,ROUT
Env_Del	EQU $+1
	LD A,#3E
	LD (HL),A
ESldAdd	EQU $+1
	LD HL,#2121
	ADD HL,DE
	LD (CurESld),HL

ROUT	ld l,0
        inc l:dec l
        jr z,ROUT_VC
        ld h,16
        ld a,(AYREGS+08):cp h:jr nc,ROUT_VA:sub l:jr nc,$+3:xor a:ld (AYREGS+08),a
ROUT_VA ld a,(AYREGS+09):cp h:jr nc,ROUT_VB:sub l:jr nc,$+3:xor a:ld (AYREGS+09),a
ROUT_VB ld a,(AYREGS+10):cp h:jr nc,ROUT_VC:sub l:jr nc,$+3:xor a:ld (AYREGS+10),a
ROUT_VC
        XOR A		;this section outputs data to the AY chip
ROUT_A0	jr ROUTCPC          ;!!!

ROUTMSX LD C,#A0            ;*** MSX SOUNDOUTPUT ***
        LD HL,AYREGS
LOUT0   OUT (C),A
        INC C
        OUTI
        DEC C
        INC A
        CP 13
        JR NZ,LOUT0
        OUT (C),A
        LD A,(HL)
        AND A
        RET M
        INC C
        OUT (C),A
        RET

ROUTEP  ld      hl,AYREGS      ;!!! 2e96
        push    af
        ld      b,a
ROUT_A1 ld      c,(hl)
        inc     hl
        call    ayRegisterWrite
        inc     b
        ld      a,b
        cp      #0d
        jr      nz,ROUT_A1
        bit     7,(hl)
        jr      nz,retregw
        ld      c,(hl)
        call    ayRegisterWrite
retregw pop     af
        ret

ROUTCPC ld hl,(AYREGS+00):ld c,l:ld b,h:add hl,hl:add hl,hl:add hl,hl:add hl,bc:srl h:rr l:srl h:rr l:srl h:rr l:srl h:rr l:ld (AYREGS+00),hl
        ld hl,(AYREGS+02):ld c,l:ld b,h:add hl,hl:add hl,hl:add hl,hl:add hl,bc:srl h:rr l:srl h:rr l:srl h:rr l:srl h:rr l:ld (AYREGS+02),hl
        ld hl,(AYREGS+04):ld c,l:ld b,h:add hl,hl:add hl,hl:add hl,hl:add hl,bc:srl h:rr l:srl h:rr l:srl h:rr l:srl h:rr l:ld (AYREGS+04),hl
        ld hl,(AYREGS+11):ld c,l:ld b,h:add hl,hl:add hl,hl:add hl,hl:add hl,bc:srl h:rr l:srl h:rr l:srl h:rr l:srl h:rr l:ld (AYREGS+11),hl

        LD HL,AYREGS        ;*** CPC SOUNDOUTPUT ***

LOUT1   call writepsghl
        inc a
        cp 13
        jr nz,LOUT1
        bit 7,(hl)
        ret nz

;; A = register
;; (HL) = value
writepsghl:
ld b,#f4                    ; [2]
out (c),A                   ; [4]
ld bc,#f6c0                 ; [3]
out (c),c                   ; [4]
defb #ed                    ; [4] 
defb #71                    ; out (c),0
ld b,#f5                    ; [2]
outi                        ; [5]
;;out (c),e                   ; [4]
ld bc,#f680                 ; [3]
out (c),c                   ; [4]
defb #ed                    ; [4] 
defb #71                    ; out (c),0
                            ; = [34]
ret

;	DB "NT_DATA"
NT_DATA	DB T_NEW_0-T1_*2
	DB TCNEW_0-T_
	DB T_OLD_0-T1_*2+1
	DB TCOLD_0-T_
	DB T_NEW_1-T1_*2+1
	DB TCNEW_1-T_
	DB T_OLD_1-T1_*2+1
	DB TCOLD_1-T_
	DB T_NEW_2-T1_*2
	DB TCNEW_2-T_
	DB T_OLD_2-T1_*2
	DB TCOLD_2-T_
	DB T_NEW_3-T1_*2
	DB TCNEW_3-T_
	DB T_OLD_3-T1_*2
	DB TCOLD_3-T_

T_

TCOLD_0	DB #00+1,#04+1,#08+1,#0A+1,#0C+1,#0E+1,#12+1,#14+1
	DB #18+1,#24+1,#3C+1,0
TCOLD_1	DB #5C+1,0
TCOLD_2	DB #30+1,#36+1,#4C+1,#52+1,#5E+1,#70+1,#82,#8C,#9C
	DB #9E,#A0,#A6,#A8,#AA,#AC,#AE,#AE,0
TCNEW_3	DB #56+1
TCOLD_3	DB #1E+1,#22+1,#24+1,#28+1,#2C+1,#2E+1,#32+1,#BE+1,0
TCNEW_0	DB #1C+1,#20+1,#22+1,#26+1,#2A+1,#2C+1,#30+1,#54+1
	DB #BC+1,#BE+1,0
TCNEW_1 EQU TCOLD_1
TCNEW_2	DB #1A+1,#20+1,#24+1,#28+1,#2A+1,#3A+1,#4C+1,#5E+1
	DB #BA+1,#BC+1,#BE+1,0

EMPTYSAMORN EQU $-1
	DB 1,0,#90 ;delete #90 if you don't need default sample

;first 12 values of tone tables (packed)

;	DB "T_PACK"

T_PACK	DB #0D,#D8         ;#06EC*2/256,#06EC*2
	DB #0755-#06EC ;#69
	DB #07C5-#0755 ;70
	DB #083B-#07C5
	DB #08B8-#083B
	DB #093D-#08B8
	DB #09CA-#093D
	DB #0A5F-#09CA
	DB #0AFC-#0A5F
	DB #0BA4-#0AFC
	DB #0C55-#0BA4
	DB #0D10-#0C55 ;BB
	DB #0C,#DA         ;#066D*2/256,#066D*2
	DB #06CF-#066D ;62
	DB #0737-#06CF
	DB #07A4-#0737
	DB #0819-#07A4
	DB #0894-#0819
	DB #0917-#0894
	DB #09A1-#0917
	DB #0A33-#09A1
	DB #0ACF-#0A33
	DB #0B73-#0ACF
	DB #0C22-#0B73
	DB #0CDA-#0C22
	DB #0E,#08         ;#0704*2/256,#0704*2
	DB #076E-#0704
	DB #07E0-#076E
	DB #0858-#07E0
	DB #08D6-#0858
	DB #095C-#08D6
	DB #09EC-#095C
	DB #0A82-#09EC
	DB #0B22-#0A82
	DB #0BCC-#0B22
	DB #0C80-#0BCC
	DB #0D3E-#0C80
	DB #0F,#C0         ;#07E0*2/256,#07E0*2
	DB #0858-#07E0
	DB #08E0-#0858
	DB #0960-#08E0
	DB #09F0-#0960
	DB #0A88-#09F0
	DB #0B28-#0A88
	DB #0BD8-#0B28
	DB #0C80-#0BD8
	DB #0D60-#0C80
	DB #0E10-#0D60
	DB #0EF8-#0E10

;vars from here can be stripped
;you can move VARS to any other address

	;resb 512
VARS
;	DB "VARS"
;ChannelsVars
;;CHNPRM struct
;reset group
CHNPRM_PsInOr	equ 0 ; (1) Position in Ornament
CHNPRM_PsInSm	equ CHNPRM_PsInOr+1 ; (1) Position in Sample
CHNPRM_CrAmSl	equ CHNPRM_PsInSm+1 ; (1) Current Amplitude (Slide?)
CHNPRM_CrNsSl	equ CHNPRM_CrAmSl+1 ; (1) Current Noise (Slide?)
CHNPRM_CrEnSl	equ CHNPRM_CrNsSl+1 ; (1) Current Envelope (Slide?)
CHNPRM_TSlCnt	equ CHNPRM_CrEnSl+1 ; (1) Tone Slide Count?
CHNPRM_CrTnSl	equ CHNPRM_TSlCnt+1 ; (2) Current Tone Slide?
CHNPRM_TnAcc	equ CHNPRM_CrTnSl+2 ; (2) Tone Accumulator
CHNPRM_COnOff	equ CHNPRM_TnAcc+2  ; (1) a counter for the OnOff command. It counts down the number of frames ON or OFF, then flips.
;reset group

CHNPRM_OnOffD	equ  CHNPRM_COnOff+1 ; (1) on/off tremolo command?

;IX for PTDECOD here (+12)
CHNPRM_OffOnD	equ CHNPRM_OnOffD+1 ;(1) on/off tremolo command?
CHNPRM_OrnPtr	equ CHNPRM_OffOnD+1 ;(2) ornament pointer
CHNPRM_SamPtr	equ CHNPRM_OrnPtr+2 ;(2) sample pointer
CHNPRM_NNtSkp	equ CHNPRM_SamPtr+2 ;(1) next note skip - empty rows till next note (or data?)
CHNPRM_Note	    equ CHNPRM_NNtSkp+1 ;(1)...
CHNPRM_SlToNt	equ CHNPRM_Note+1 ;(1)Slide To Note (- note to slide to?)
CHNPRM_Env_En	equ CHNPRM_SlToNt+1 ;(1)Envelope enabled
CHNPRM_Flags	equ CHNPRM_Env_En+1 ;(1)Enabled - 0,SimpleGliss - 2
CHNPRM_TnSlDl	equ CHNPRM_Flags+1 ;(1)Tone Slide Delay
CHNPRM_TSlStp	equ CHNPRM_TnSlDl+1 ;(2)Tone Slide Step
CHNPRM_TnDelt	equ CHNPRM_TSlStp+2 ;(2)Tone Delta - calc'ed from Delay/Step?
CHNPRM_NtSkCn	equ CHNPRM_TnDelt+2 ;(1)Note Skip Count. Number of rows until next note
CHNPRM_Volume	equ CHNPRM_NtSkCn+1 ; (1)
CHNPRM_Size	    equ CHNPRM_Volume+1
	;;endstruct

ChanA	defs CHNPRM_Size
ChanB	defs CHNPRM_Size
ChanC	defs CHNPRM_Size

;	DB "ARStruct"
;;AR struct
AR_TonA	equ 0       ;; (2)
AR_TonB	equ AR_TonA+2   ;; (2)
AR_TonC	equ AR_TonB+2   ;; (2)
AR_Noise	equ AR_TonC+2   ;; (1)
AR_Mixer	equ  AR_Noise+1   ;;(1)
AR_AmplA	equ AR_Mixer+1    ;;(1)
AR_AmplB	equ  AR_AmplA+1   ;;(1)
AR_AmplC	equ  AR_AmplB+1   ;;(1)
AR_Env	equ AR_AmplC+1      ;;(2)
AR_EnvTp	equ AR_Env+2  ;; (1)
AR_Size	equ AR_EnvTp+1      
	;;endstruct

;	DB "GlobalVars"
;GlobalVars
DelyCnt	DB 0
CurESld	DW 0
CurEDel	DB 0
Ns_Base_AddToNs
Ns_Base	DB 0
AddToNs	DB 0
PattStrt DW 0






AYREGS defs AR_Size

VT_	 defs 256   ;;resb 256 ;CreatedVolumeTableAddress

EnvBase	EQU VT_+14
T1_	EQU VT_+16 ;Tone tables data depacked here

T_OLD_1	EQU T1_
T_OLD_2	EQU T_OLD_1+24
T_OLD_3	EQU T_OLD_2+24
T_OLD_0	EQU T_OLD_3+2
T_NEW_0	EQU T_OLD_0
T_NEW_1	EQU T_OLD_1
T_NEW_2	EQU T_NEW_0+24
T_NEW_3	EQU T_OLD_3

NT_	defs 192    ;;resb 192 ;CreatedNoteTableAddress

;local var
Ampl	EQU AYREGS + AR_AmplC

VAR0END	EQU VT_+16 ;INIT zeroes from VARS to VAR0END-1

VARSEND EQU $

;;MDLADDR EQU #9000


;Release 0 steps
;11.Sep.2004 - Note tables creator
;12.Sep.2004 - Volume tables creator; INIT subroutine
;13.Sep.2004 - Play counters, position counters
;14.Sep.2004 - Patterns decoder subroutine
;15.Sep.2004 - Resting (no code)
;16.Sep.2004 - CHREGS subroutine; global debugging; 1st stable
;version was born
;17.Sep.2004 - Debugging and optimization. First release!
;Release 1 steps
;20.Sep.2004 - local vars moved to code (selfmodified code
;smaller and faster)
;22.Sep.2004 - added mute sound entry at START+8; position
;pointer moved to START+11; added setup and status byte at
;START+10 noloop mode and loop passed flags added
;Release 2 steps
;28.Sep.2004 - Optimization code around CHREGS's volume and
;vibrato faster now; zeroing PD_RES through stack; Ton and Ampl
;moved from channel vars to global ones; first position selector
;removed from INIT; optimization for packers(Ivan Roshin method)
;Release 3 steps
;2.Oct.2004 - optimization in INIT and PD_LOOP (thanks to Ivan
;Roshin)
;4.Oct.2004 - load delay from (hl) in INIT (2 bytes shorter)
;5.Oct.2004 - optimization in PD_LOOP (->PD_LP2)
;7.Oct.2004 - swaping some commands for better packing
;Release 4 steps
;9.Oct.2004 - optimization around LD HL,SPCCOMS (thanks to Ivan
;Roshin); in PTDECOD swapped BC and DE to optimize C_PORTM;
;removed sam and orn len and loop channel vars; CHREGS totally
;optimized
;Release 5 steps
;11.Oct.2004 - PD_OrSm and C_PORTM optimized; Ivan Roshin's
;volume tables creator algorithm (51 bytes shorter than mine)
;12.Oct.2004 - Ivan Roshin's note tables creator algorithm (74
;bytes shorter than mine)
;Release 6 steps
;14.Oct.2004 - loop and next position calculations moved to INIT
;15.Oct.2004 - AdInPt moved to code
;19.Oct.2004 - Env_Del moved to code
;20.Oct.2004 - Version PUSH and POP (1 byte shorter, thanks to
;Ivan Roshin)
;22.Oct.2004 - Env_En moved from Flags' bit to byte (shorter and
;faster code)
;25.Oct.2004 - SETENV optimized
;29.Oct.2004 - Optimized around AddToEn (SBC A,A, thanks to Ivan
;Roshin)
;3.Nov.2004 - Note tables data was compressed; with depacker it
;is 9 bytes shorter than uncompressed (thanks to Ivan Roshin)
;4.Nov.2004 - default sample and ornament both are fixed now
;and placed into code block (6 bytes shorter)
;7.Nov.2004 - LD A,(Ns_Base) LD L,A changed to LD HL,(Ns_Base)
;(thanks to Dima Bystrov)
;9.Nov.2004 - Ns_Base and AddToNs are merged to Ns_Base_AddToNs;
;LD A,255 changed to DEC A (at start of PLAY); added ROUT_A0
;12.Nov.2004 - NtSkCn&Volume are merged (8 bytes smaller init);
;LD BC,T1_ changed to PUSH DE...POP BC in note table creator
;19.Dec.2004 - NT_DATA reorganized (6 bytes shorter, thanks to
;Ivan Roshin); C_PORTM and C_GLISS are merged via SET_STP (48
;tacts slower, but 8 bytes smaller, thanks to Ivan Roshin)

;Tests in IMMATION TESTER V1.0 by Andy Man/POS (thanks to
;Himik's ZxZ for help)
;Module name/author	Min tacts	Max tacts	Average
;Spleen/Nik-O		1720		9256		5500
;Chuta/Miguel		1720		9496		5500
;Zhara/Macros		4536		8744		5500

;Size
;Code block #647 bytes
;Variables #21D bytes (can be stripped)
;Size in RAM #647+#21D=#864 (2148) bytes

;Not so bad for the most universal PT3 player, I think ;)

;Notes
;Pro Tracker 3.4r can not be detected by header, so PT3.4r tone
;tables realy used only for modules of 3.3 and older versions.


; =============================================================================    ;!!!

; if enabled, channel A is played at the left, channel B at center,
; and channel C at right
ENABLE_STEREO           equ     1
; envelope sample rate = 1000 / ENV_SRATE_DIV Hz (increase this for lower
; quality and CPU usage)
ENV_SRATE_DIV           equ     1
; minimum envelope frequency value (should be at least 14 * ENV_SRATE_DIV,
; and less than 256)
MIN_ENV_FREQVAL         equ     98 * ENV_SRATE_DIV
    ; if non-zero, the envelope generator is stopped in modes 8, 10, 12, and 14
    ; when the envelope enable bits in registers 8 to 10 are changed to disabled
    ; on all channels (NOTE continuing the envelope by enabling it again in
    ; registers 8 to 10 does not work correctly, the envelope must be restarted
    ; by writing to register 13)
ENVELOPE_CPU_SAVING     equ     1
; if non-zero, the envelope emulation routine is disabled
NO_ENVELOPE_IRQ         equ     0
; DAVE channels assigned to each AY channel
ayDaveChnA              equ     0
ayDaveChnB              equ     1
ayDaveChnC              equ     2

  if NO_ENVELOPE_IRQ = 0

envelopeInterrupt:
        ret
;    if ENV_SRATE_DIV < 2
;        ld    a,33h
;        out   (0b4h), a
;    endif
        ld      a,#30
        out     (#b4), a
        push  hl
        push  bc
envelopeInterruptl1:
        ld    hl, #0000                 ; * envelope counter
;        ld    bc, 10000h - (((60000 * ENV_SRATE_DIV) + 500) / 50)      ;1000
envfreq ld      bc,#fb50    ;60000
;        ld      bc,#f74e    ;110830
        add   hl, bc
envelopeInterruptl2:
        jr    c, envelopeInterruptl19   ; * JR if envelope is stopped
envelopeInterruptl3:    
        ld    bc, #ffff                 ; * envelope frequency
envelopeInterruptl4:
        ld    a, 0                      ; * envelope state (0 to 15)
envelopeInterruptl5:
        dec   a                         ; * envelope direction (INC A or DEC A)
        add   hl, bc
        jr    nc, envelopeInterruptl5
        ld    (envelopeInterruptl1 + 1), hl
        cp    #10
envelopeInterruptl6:
        jr    nc, envelopeInterruptl21  ; * envelope mode
envelopeInterruptl7:
        ld    (envelopeInterruptl4 + 1), a
envelopeInterruptl8:
;        or    ayVolumeTable
envelopeInterruptl9:
        ld      hl,ayVolumeTable
        ld      c, a
        ld      b,#00
        add     hl,bc
        ld      a, (hl)
        pop     bc
envelopeInterruptl10:
        jr    envelopeInterruptl12     ; * envelope enable mode
envelopeInterruptl11:
        out   (#a8 + ayDaveChnA), a    ; envelope on channel A only
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl12:
        pop   hl
        ret
envelopeInterruptl13:
        out   (#a8 + ayDaveChnA), a    ; envelope on channels A and B
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl14:
    if ENABLE_STEREO = 1
        ld    l, a                      ; envelope on channel B only (Carry=0)
        rra
        scf
        adc   a, l
        rra
    endif
        out   (#a8 + ayDaveChnB), a
        out   (#ac + ayDaveChnB), a
        pop   hl
        ret
envelopeInterruptl15:
        out   (#a8 + ayDaveChnA), a    ; envelope on channels A and C
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl16:
    if ENABLE_STEREO = 0
        out   (0a8h + ayDaveChnC), a
    endif
        out   (#ac + ayDaveChnC), a    ; envelope on channel C only
        pop   hl
        ret
envelopeInterruptl17:
        out   (#a8 + ayDaveChnA), a    ; envelope on channels A, B, and C
    if ENABLE_STEREO = 0
        out   (0ach + ayDaveChnA), a
    endif
envelopeInterruptl18:
    if ENABLE_STEREO = 0
        out   (0a8h + ayDaveChnC), a
    endif
        out   (#ac + ayDaveChnC), a    ; envelope on channels B and C
    if ENABLE_STEREO = 1
        ld    l, a                      ; NOTE Carry is always 0 here
        rra
        scf
        adc   a, l
        rra
    endif
        out   (#a8 + ayDaveChnB), a
        out   (#ac + ayDaveChnB), a
        pop   hl
;        pop     af
;        ei
        ret
envelopeInterruptl19:
        ld    (envelopeInterruptl1 + 1), hl
        pop   bc
        pop   hl
        ret
envelopeInterruptl20:   
        ld    l,15                      ; envelope modes 11 and 13      ayVolumeTable + 15
        defb  #01                       ; = LD BC, nnnn
envelopeInterruptl21:
        ld    l, 00                     ; envelope modes 0 to 7, 9, and 15   ayVolumeTable
        ld    a, #18                    ; = JR +nn
        ld    (envelopeInterruptl2), a  ; stop envelope
        ld    a,l
        jp    envelopeInterruptl9
envelopeInterruptl22:   
        and   #0f                       ; envelope modes 8 and 12
        jp    envelopeInterruptl7
envelopeInterruptl23:   
        jp    m, envelopeInterruptl24   ; envelope modes 10 and 14
        xor   #1f
        ld    l, a
        ld    h, #3d                    ; set direction to DEC A
        ld    (envelopeInterruptl4 + 1), hl ; assume .l5 = .l4 + 2
        jp    envelopeInterruptl8
envelopeInterruptl24:
        cpl
        ld    l, a
        ld    h, #3c                    ; set direction to INC A
        ld    (envelopeInterruptl4 + 1), hl
        jp    envelopeInterruptl8

  endif
; -----------------------------------------------------------------------------

ayTablesBegin:

ayVolumeTable:
        defb   0,  1,  2,  3,  4,  5,  6,  9
        defb  12, 17, 22, 28, 36, 44, 53, 63

ayRegWriteTable:
        db  ayRegisterWritel3 - ayRegisterWritel1 - 2
        db  ayRegisterWritel3 - ayRegisterWritel1 - 2
        db  ayRegisterWritel4 - ayRegisterWritel1 - 2
        db  ayRegisterWritel4 - ayRegisterWritel1 - 2
        db  ayRegisterWritel6 - ayRegisterWritel1 - 2
        db  ayRegisterWritel6 - ayRegisterWritel1 - 2
        db  ayRegisterWritel7 - ayRegisterWritel1 - 2
        db  ayRegisterWritel5 - ayRegisterWritel1 - 2
        db  ayRegisterWritel9 - ayRegisterWritel1 - 2
        db  ayRegisterWritel10 - ayRegisterWritel1 - 2
        db  ayRegisterWritel11 - ayRegisterWritel1 - 2
        db  ayRegisterWritel12 - ayRegisterWritel1 - 2
        db  ayRegisterWritel12 - ayRegisterWritel1 - 2
        db  ayRegisterWritel15 - ayRegisterWritel1 - 2
        db  ayRegisterWritel8 - ayRegisterWritel1 - 2
        db  ayRegisterWritel8 - ayRegisterWritel1 - 2

ayRegisters:
        defb  00, 00, 00, 00, 00, 00, 00, 00
        defb  00, 00, 00, 00, 00, 00, 00, 00


    if NO_ENVELOPE_IRQ = 0

envelopeModeTable:
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl22 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2
        db  envelopeInterruptl23 - envelopeInterruptl6 - 2
        db  envelopeInterruptl20 - envelopeInterruptl6 - 2
        db  envelopeInterruptl22 - envelopeInterruptl6 - 2
        db  envelopeInterruptl20 - envelopeInterruptl6 - 2
        db  envelopeInterruptl23 - envelopeInterruptl6 - 2
        db  envelopeInterruptl21 - envelopeInterruptl6 - 2

;        assert  ($ & 000fh) = 0

envelopeEnableTable:
        db  envelopeInterruptl12 - envelopeInterruptl11
        db  envelopeInterruptl11 - envelopeInterruptl11
        db  envelopeInterruptl14 - envelopeInterruptl11
        db  envelopeInterruptl13 - envelopeInterruptl11
        db  envelopeInterruptl16 - envelopeInterruptl11
        db  envelopeInterruptl15 - envelopeInterruptl11
        db  envelopeInterruptl18 - envelopeInterruptl11
        db  envelopeInterruptl17 - envelopeInterruptl11

;        assert  ($ & 0007h) = 0

    endif

; -----------------------------------------------------------------------------

setChannelAmplitude:
        cp    #10
        jr    c, setChannelAmplitudel1
    if NO_ENVELOPE_IRQ = 0
        res   3, b
        ld    a, (envelopeInterruptl4 + 1)
    else
        xor   a
    endif
setChannelAmplitudel1:                  ; HL = ayRegWriteTable + (8 + channel)
        push    de
        ld      e,a
        ld      d,#00
        ld      hl,ayVolumeTable
        add     hl,de
    if ENABLE_STEREO = 1
        bit   0, c                      ; Z = 0 channel B, Z = 1 channel A, C
    endif
        ld    a, (hl)
    if ENABLE_STEREO = 1
        jr    z, setChannelAmplitudel2
        ld    l, a                      ; NOTE Carry is always 0 here
        rra
        scf
        adc   a, l
        rra
    endif
        out   (c), a
        set   2, c
setChannelAmplitudel2:
        out   (c), a
    if NO_ENVELOPE_IRQ = 0
setChannelAmplitudel3:
        ld      e,#00
        ld      a,e
        or      b
        cp      #08
        jr      c, setChannelAmplitudel4
        xor     b
setChannelAmplitudel4:
        cp    e
        jr    z, setChannelAmplitudel5  ; envelope enable bit has not changed ?
        ld    (setChannelAmplitudel3 + 1), a
        ld    hl, envelopeEnableTable   ; *
        ld      e,a
        add     hl,de
        ld    a, (hl)
        ld    (envelopeInterruptl10 + 1), a
      if ENVELOPE_CPU_SAVING = 1
        ld    a, (envelopeInterruptl6 + 1)     ; check envelope mode:
        cp    envelopeInterruptl22 - envelopeInterruptl6 - 2
        jr    c, setChannelAmplitudel5                    ; hold or not continue ?
        xor     a                       ;ld    a, envelopeEnableTable
        sub   e
        sbc   a, a
        and   #20
        or    #18                       ; JR +nn or JR C, +nn
        ld    (envelopeInterruptl2), a ; disable envelope if it is not used
      endif
    endif
setChannelAmplitudel5:
        pop     de
        pop   bc
        pop   hl
        ret

setChannelAFreq:
        ld    c,  ayDaveChnA * 2 + #a0
        ld    a, (ayRegisters + 7)
        ld    hl, (ayRegisters)
        bit   3, a
        jr    z, setNoiseGenFreq        ; noise generator enabled ?
        rrca
        jr    nc, setToneGenFrequency   ; tone generator enabled ?
        xor   a                         ; channel disabled
        out   (ayDaveChnA * 2 + #a0), a
        out   (ayDaveChnA * 2 + #a1), a
        ret

setChannelBFreq:
        ld    c, ayDaveChnB * 2 + #a0
        ld    a, (ayRegisters + 7)
        ld    hl, (ayRegisters + 2)
        bit   4, a
        jr    z, setNoiseGenFreq        ; noise generator enabled ?
        and   #02
        jr    z, setToneGenFrequency    ; tone generator enabled ?
        xor   a                         ; channel disabled
        out   (ayDaveChnB * 2 + #a0), a
        out   (ayDaveChnB * 2 + #a1), a
        ret

setChannelCFreq:
        ld    c, ayDaveChnC * 2 + #a0
        ld    a, (ayRegisters + 7)
        ld    hl, (ayRegisters + 4)
        bit   5, a
        jr    z, setNoiseGenFreq        ; noise generator enabled ?
        and   #04
        jr    z, setToneGenFrequency    ; tone generator enabled ?
        xor   a                         ; channel disabled
        out   (ayDaveChnC * 2 + #a0), a
        out   (ayDaveChnC * 2 + #a1), a
        ret


setToneGenFrequency:

setToneGenFrequency_:
convval  add     hl,hl
.calcfrr dec   hl
        ld      a,h
        cp    #10
        jr    nc, setToneGenFrequency_l2    ; overflow ?
setToneGenFrequency_l1:
        out   (c), l
        inc   c
        out   (c), a
        ret
setToneGenFrequency_l2:
        inc   l
        inc   a
        jr    z, setToneGenFrequency_l1
        ld    l, #ff
        ld    a, #0f
        jp    setToneGenFrequency_l1

setNoiseGenFreq:
        ld    h, #30

setNoiseGenFreq_:
        ld    a, (ayRegisters + 6)
        cp    1
        adc   a, 0
        add   a, a
        add   a, a
        dec   a
        out   (c), a
        inc   c
        out   (c), h
        ret

; -----------------------------------------------------------------------------

; reset AY-3-8912 emulation
ayReset1
        ld      a,#29       ;add hl,hl ;!!!
        ld      hl,#fb46	;60000Hz
        jr      ayReset
ayReset2
        xor     a
        ld      hl,#f74e	;110830Hz
ayReset:
        ret
;        push    af
;        push    hl
        push    bc
;        di
        ld      (convval+1),a
        ld      (envfreq+1),hl
        ld    hl, ayRegisters - 1
        ld    bc, #10af
        xor   a
ayResetl1:
        inc   hl
        out   (c), a
        ld    (hl), a
        dec   c
        djnz  ayResetl1
        res   3, l                      ; register 7
        ld    (hl), #3f
    if NO_ENVELOPE_IRQ = 0
        ld    (envelopeInterruptl4 + 1), a
        ld    a, #18                    ; = JR +nn
        ld    (envelopeInterruptl2), a
        ld    hl, MIN_ENV_FREQVAL
        ld    (envelopeInterruptl3 + 1), hl
        ld    a, envelopeInterruptl12 - envelopeInterruptl11
        ld    (envelopeInterruptl10 + 1), a
        xor     a                       ;ld    a, envelopeEnableTable
        ld    (setChannelAmplitudel3 + 1), a
    endif
        ld    a, #10                    ; use 17-bit noise generator
        out   (#a6), a
        pop     bc
        ret

; read AY-3-8912 register A, returning the value in A

ayRegisterRead:
        push    hl
        and     #0f
        ld      c,a
        ld      b,#00
        ld      hl, ayRegisters
        add     hl,bc
        ld      a, (hl)
        or      a
        pop     hl
        ret

; write C to AY-3-8912 register A
; NOTE interrupts may be enabled on return
ayRegisterWrite
    ;        push  af
        push    hl
        push    bc
        and     #0f
        ld      b,a
        ld      a,c
        ld      c,b
        ld      b,#00
        ld      hl,ayRegisters
        add     hl,bc
        ld      (hl),a
        ld      hl, ayRegWriteTable
        add     hl,bc
        ld      a,(hl)
        ld      (ayRegisterWritel1 + 1), a
ayRegisterWritel1:
        jr    ayRegisterWritel8             ; *

ayRegisterWritel3:    
        call  setChannelAFreq           ; tone generator A frequency
        pop     bc
        pop     hl
        ret
ayRegisterWritel4:
        call  setChannelBFreq           ; tone generator B frequency
        pop     bc
        pop     hl
        ret
ayRegisterWritel5:
        call  setChannelAFreq           ; mixer
        call  setChannelBFreq
ayRegisterWritel6:
        call  setChannelCFreq           ; tone generator C frequency
        pop     bc
        pop     hl
        ret
ayRegisterWritel7:
        ld    a, (ayRegisters + 7)      ; noise generator frequency
        ld    b, a
        and   #08
        call  z, setChannelAFreq
        bit   4, b
        call  z, setChannelBFreq
        bit   5, b
        call  z, setChannelCFreq
ayRegisterWritel8:
        pop   bc
        pop     hl
        ret
ayRegisterWritel9:
        ld    a, (ayRegisters + 8)      ; channel A amplitude / envelope enable
    if NO_ENVELOPE_IRQ = 0
        ld    bc, #09a8 + ayDaveChnA
    else
        ld    c, #0a8 + ayDaveChnA
    endif
        jp    setChannelAmplitude
ayRegisterWritel10:   
        ld    a, (ayRegisters + 9)      ; channel B amplitude / envelope enable
    if NO_ENVELOPE_IRQ = 0
        ld    bc, #aa8 + ayDaveChnB
    else
        ld    c, #a8 + ayDaveChnB
    endif
        jp    setChannelAmplitude
ayRegisterWritel11:
        ld    a, (ayRegisters + 10)     ; channel C amplitude / envelope enable
    if ENABLE_STEREO = 0
      if NO_ENVELOPE_IRQ = 0
        ld    bc, #ca8 + ayDaveChnC
      else
        ld    c, #a8 + ayDaveChnC
      endif
    else
      if NO_ENVELOPE_IRQ = 0
        ld    bc, #cac + ayDaveChnC
      else
        ld    c, #ac + ayDaveChnC
      endif
    endif
        jp    setChannelAmplitude
ayRegisterWritel12:
    if NO_ENVELOPE_IRQ = 0
        ld    hl, (ayRegisters + 11)    ; envelope generator frequency
        ld    a, h
        or    a
        jr    nz, ayRegisterWritel13
        ld    a, MIN_ENV_FREQVAL
        cp    l
        jr    c, ayRegisterWritel13
        ld    l, a                      ; limit envelope frequency
ayRegisterWritel13:
        ld    (envelopeInterruptl3 + 1), hl
        pop   bc
    ;        pop   af
        pop     hl
        ret
    else
        jr    ayRegisterWritel8
    endif
ayRegisterWritel15:                     ; envelope generator mode / restart
    if NO_ENVELOPE_IRQ = 0
ayRegisterWritel16:   
        ld    hl, (envelopeInterruptl3 + 1)
        ld    (envelopeInterruptl1 + 1), hl
        ld    a, #38                    ; = JR C, +nn
        ld    (envelopeInterruptl2), a ; enable envelope
        ld    a, (ayRegisters + 13)
        ld      c,a
        ld      b,#00
        ld      hl, envelopeModeTable
        add     hl,bc
        and     #04
        ld      a, (hl)
        ld      (envelopeInterruptl6 + 1), a
        ld      hl, #3c00                 ; INC A, state = 0
        ld      a, l
        jr      nz, ayRegisterWritel17    ; attack ?
        ld      hl, #3d0f                 ; DEC A, state = 15
        ld      a, #3f
ayRegisterWritel17:
        pop     bc
        ld    (envelopeInterruptl4 + 1), hl    ; assume eInt.l5 = eInt.l4 + 2
        call  ayRegisterWritel18
        pop     hl
        ret
ayRegisterWritel18:
        call  envelopeInterruptl10     ; NOTE this will pop return address
    else
        jr    ayRegisterWritel8
    endif
