;LIBRARY QUIG.G9K.INK.SET
;************************
;IN		InkNo=ST2
;		R=ST1
;		G=DE
;		B=HL
.Quig_g9k_Ink_Set:
		pop		iy
		ld		a,l
		call	Quig_g9k_Max32
		ld		a,b
		ld		(Quig_g9k_Ink_Set_x9+1),a
		ld		a,e
		call	Quig_g9k_Max32
		ld		a,b		
		ld		(Quig_g9k_Ink_Set_x8+1),a		
		pop		de
		ld		a,e
		call	Quig_g9k_Max32
		ld		a,b
		ld		(Quig_g9k_Ink_Set_x7+1),a	
		pop		hl
		ld		e,l
		ld		d,h
		add		hl,hl
		add		hl,de
		ld		de,Quig_g9k_Ink_Data
		add		hl,de
.Quig_g9k_Ink_Set_x7:			;Red			
		ld		a,0
		ld		(hl),a
		inc		hl
.Quig_g9k_Ink_Set_x8:			;Green				
		ld		a,0
		ld		(hl),a
		inc		hl		
.Quig_g9k_Ink_Set_x9:			;Blue				
		ld		a,0
		ld		(hl),a
		inc		hl
		jp		(iy)
.Quig_g9k_Max32:
		ld		b,a
		and		%11100000
		ret		z
		and		%10000000
		jr		z,Quig_g9k_Max32_1
		ld		b,0
		ret
.Quig_g9k_Max32_1		
		ld		b,31
		ret
	
.Quig_g9k_Ink_Data
	ds	256*3
;LIBRARY QUIG.G9K.INK.GET
;************************
;IN 	HL=Ink Number
.Quig_g9k_Ink_Get_R:
		inclib	QUIG.G9K.INK.SET
		ld		bc,Quig_g9k_Ink_Data
		jr		Quig_g9k_Ink_Get
.Quig_g9k_Ink_Get_G
		ld		bc,Quig_g9k_Ink_Data+1
		jr		Quig_g9k_Ink_Get
.Quig_g9k_Ink_Get_B
		ld		bc,Quig_g9k_Ink_Data+2
.Quig_g9k_Ink_Get:
		ld		e,l
		add		hl,hl		;*2
		add		hl,de		;*3
		add		hl,bc
		ld		l,(hl)
		ld		h,0
		ret
;LIBRARY QUIG.G9K.INK.PALETTE.SET
;**********************************
;IN  	Palette  = DE 0-3
;IN		InkSet=HL			(0-255)

.Quig_G9K_Ink_Palette_Set:
		ld		a,e
		and		%11
		rla		;2
		rla		;4
		rla		;8
		rla		;16
		rla		;32
		rla		;64
		ld		e,a	
		inclib	QUIG.G9K.INK.SET
		ld		c,l
		ld		b,h
		add		hl,hl		;*32
		add		hl,bc		;*48
		ld		bc,Quig_g9k_Ink_Data
		add		hl,bc
		ld		a,g9k_PALETTE_PTR
		ld		bc,CG9K_REG_SELECT
		di
		out 	(c),a
		ld		a,e
		ld		bc,CG9K_REG_DATA
		out		(c),a		
		ld		bc,CG9K_palette
		inclib 	QUIG.G9K.48OUTI
.Quig_CPC_48_11:		
		jp		Quig_g9kCPC_48outi
;LIBRARY QUIG.G9K.64OUTI
;************************
.Quig_g9k_64outi:
		outi	:outi:outi:outi:outi:outi:outi:outi
		outi	:outi:outi:outi:outi:outi:outi:outi
.Quig_g9k_48outi:
		outi	:outi:outi:outi:outi:outi:outi:outi
		outi	:outi:outi:outi:outi:outi:outi:outi
.Quig_g9k_32outi:		
		outi	:outi:outi:outi:outi:outi:outi:outi
		outi	:outi:outi:outi
.Quig_g9k_20outi:
		outi	:outi:outi:outi:outi:outi
		outi    :outi:outi:outi:outi:outi
		outi    :outi:outi:outi
.Quig_g9k_4outi:		
		outi	:outi:outi:outi
		ei
		ret
.Quig_g9kCPC_64outi:		
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi		
.Quig_g9kCPC_48outi:	
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
.Quig_g9kCPC_32outi:		
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi
.Quig_g9kCPC_20outi:
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi
.Quig_g9kCPC_4outi:		
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi		
		ei
		ret	
		
;LIBRARY QUIG.G9K.PALETTE.PALETTETOINK
;**********************************
;IN		PaletteSet=DE			(0-3)
;		InkSet=HL		(0-15)
.Quig_G9K_Palette_PaletteToInk:
		inclib	QUIG.G9K.INK.SET
		add		hl,hl		;*2
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,hl		;*16
		ld		c,l
		ld		b,h
		add		hl,hl		;*32
		add		hl,bc		;*48
		ld		bc,Quig_g9k_Ink_Data
		add		hl,bc		
		ld		a,g9k_PALETTE_PTR
		di
		out 	(g9k_REG_SELECT),a
		ld		a,e
		out		(g9k_REG_DATA),a		
		ld		c,G9k_palette
		ld		b,48
		inir
		ei
		ret
		

;LIBRARY QUIG.G9K.PRINT.FONT
;***************************
;In HL = Font Start Pattern
		INCLIB QUIG.STRING.STACK.CLEAR
.Quig_g9k_Fore_Font:
		ld		(Quig_g9k_Fore_Font_Patt),hl
		ret
.Quig_g9k_Back_Font:
		ld		(Quig_g9k_Back_Font_Patt),hl
		ret		
.Quig_g9k_Fore_Pos:
;In HL = Y
;	DE = X
		call	Quig_g9k_Fore_Pos2
		ld		bc,#c000
		add		hl,bc
		ld		(Quig_g9k_Fore_Font_PosXY),hl
		ret
.Quig_g9k_Back_Pos:
;In HL = Y
;	DE = X
		call	Quig_g9k_Fore_Pos2
		ld		bc,#e000
		add		hl,bc
		ld		(Quig_g9k_Back_Font_PosXY),hl
		ret	
.Quig_g9k_Fore_Pos2:
		ld		a,l
		and		%00111111
		ld		l,a
		add		hl,hl	;*2
		add		hl,hl	;*4
		add		hl,hl	;*8
		add		hl,hl	;*16
		add		hl,hl	;*32
		add		hl,hl	;*64
		ld		a,e
		and		%00111111
		ld		e,a
		add		hl,de
		add		hl,hl
		ret
.Quig_g9k_Fore_String:
;In HL=String Pos
		ld		a,(hl)
		cp		0
		jp		z,Quig_g9k_Fore_String_end
		inc		hl
		push	hl
		ld		l,a
		ld		h,0
		ld		de,-32
		add		hl,de
		ld		de,(Quig_g9k_Fore_Font_Patt)
		add		hl,de
		push	hl
		ld		hl,(Quig_g9k_Fore_Font_PosXY)
		ld		e,7
		;SetVramWrite
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		inc		hl
		inc		hl
		ld		(Quig_g9k_Fore_Font_PosXY),hl
		out		(c),e
		pop		hl
		ld		bc,CG9K_VRAM
		out		(c),l
		out		(c),h
		pop		hl
		jp		Quig_g9k_Fore_String
.Quig_g9k_Fore_String_end:
		ret
.Quig_g9k_Back_String:
;In HL=String Pos
		ld		a,(hl)
		cp		0
		jp		z,Quig_g9k_Back_String_end
		inc		hl
		push	hl
		ld		l,a
		ld		h,0
		ld		de,-32
		add		hl,de
		ld		de,(Quig_g9k_Back_Font_Patt)
		add		hl,de
		push	hl
		ld		hl,(Quig_g9k_Back_Font_PosXY)
		ld		e,7
		;SetVramWrite
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		inc		hl
		inc		hl
		ld		(Quig_g9k_Back_Font_PosXY),hl
		out		(c),e
		pop		hl
		ld		bc,CG9K_VRAM
		out		(c),l
		out		(c),h
		pop		hl
		jp		Quig_g9k_Back_String
.Quig_g9k_Back_String_end:
		ret		


.Quig_g9k_Fore_Font_Patt:	dw	0
.Quig_g9k_Fore_Font_PosXY:	dw	0
.Quig_g9k_Back_Font_Patt:	dw	0
.Quig_g9k_Back_Font_PosXY:	dw	0

;LIBRARY QUIG.G9K.INK.FADE
.Quig_g9k_Ink_Fade:
;IN HL = Levl
;   DE = Ink 2
;   ST = Ink 1
		pop		iy
		ld		a,l
		ld		(Quig_g9k_Ink_Div_Level),a
		ld		c,e							;c=ink 2		
		pop		hl
		ld		b,l							;b=ink 1
		inclib	QUIG.MUL8
		ld		a,b
		sub		c
		jr		c,Quig_g9k_Ink_Div_x99	
		ld		l,a
		ld		a,(Quig_g9k_Ink_Div_Level)
		ld		e,a
		call	Quig_Mul8
		ld		de,32
		add		hl,de		
		ld		a,h	
		add		c
		ld		l,a
		ld		h,0
		jp		(iy)
.Quig_g9k_Ink_Div_x99:
		ld		a,c
		sub		b
		ld		l,a
		ld		a,(Quig_g9k_Ink_Div_Level)
		ld		e,a
		call	Quig_Mul8
		ld		de,32
		add		hl,de
		ld		a,c	
		sub 	h	
		ld		l,a
		ld		h,0
		jp		(iy)		
.Quig_g9k_Ink_Div_Level:db	0		
		
;LIBRARY QUIG.G9K.INK.R.GET
;IN 	InkNo=HL
.Quig_g9k_ink_R_Get:
		inclib	QUIG.G9K.INK.SET
		ld		e,l
		ld		d,h
		add		hl,hl
		add		hl,de
		ld		de,Quig_g9k_Ink_Data		
		add		hl,de
		ld		l,(hl)
		ld		h,0
		ret
;LIBRARY QUIG.G9K.INK.G.GET
;IN 	InkNo=HL
.Quig_g9k_ink_G_Get:
		inclib	QUIG.G9K.INK.SET
		ld		e,l
		ld		d,h
		add		hl,hl
		add		hl,de
		ld		de,Quig_g9k_Ink_Data+1
		add		hl,de
		ld		l,(hl)
		ld		h,0
		ret	
;LIBRARY QUIG.G9K.INK.B.GET
;IN 	InkNo=HL
.Quig_g9k_ink_B_Get:
		inclib	QUIG.G9K.INK.SET
		ld		e,l
		ld		d,h
		add		hl,hl
		add		hl,de
		ld		de,Quig_g9k_Ink_Data+2
		add		hl,de
		ld		l,(hl)
		ld		h,0
		ret	


		
;LIBRARY QUIG.G9K.SPRITE.SET.DISPLAY
;***********************************
;HL = Display
;DE = Sprite
.Quig_G9k_Sprite_Set_Display:
		ex		de,hl
		add		hl,hl
		add		hl,hl
		ld		bc,Quig_Sprite_Attributes+3
		add		hl,bc							;Point to strite attribute
		ld		a,(hl)
		and		%11000011
		ld		d,a
		ld		a,e
		and		%11
		rla
		rla
		rla
		rla
		or 		d
		ld		(hl),a
		ret
		
;LIBRARY QUIG.G9K.SPRITE.SET.POSITION2
;*************************************
;HL = Height
;DE = Width
;Stack1 = Y
;Stack2 = X
;Stack3 = Sprite no (0-124)	
.Quig_G9k_Sprite_Set_Position3:
		ld		a,-16
		ld		(Quig_G9k_Sprite_Set_Pos60+1),a
		jr		Quig_G9k_Sprite_Set_Position4
.Quig_G9k_Sprite_Set_Position2:
		ld		a,16
		ld		(Quig_G9k_Sprite_Set_Pos60+1),a
.Quig_G9k_Sprite_Set_Position4:
		pop		iy								;IY=Return Address
		ld		a,l
		and		%11111
		ld		(Quig_G9k_Sprite_Pos_Set_Height),a		;Store Height to draw
		ld		a,e
		and		%111111
		ld		(Quig_G9k_Sprite_Pos_Set_Width1),a		;Store Static width to draw
		ld		(Quig_G9k_Sprite_Pos_Set_Width2),a		;Store Change width to draw
		pop		hl
		ld		a,l
		ld		(Quig_G9k_Sprite_PosY),a
		pop		hl
		ld		(Quig_G9k_Sprite_PosX1),hl
		ld		(Quig_G9k_Sprite_PosX2),hl				;Store Change Pos X to draw		
		
		;Sprite Get
		pop		hl										;Get Start sprite
		ld		a,l
		and		%1111111
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		ld		bc,Quig_Sprite_Attributes		
		add		hl,bc									;Get to Start of SpriteY address
		ld		(Quig_G9K_SpriteY_Address),hl
		
.Quig_G9k_Sprite_Set_Pos33:		
		ld		hl,(Quig_G9K_SpriteY_Address)			;Sprite Address
		ld		a,(Quig_G9k_Sprite_PosY)
		ld		(hl),a									;Y
		inc		hl										;Skip Pat no		
		inc		hl
		ld		de,(Quig_G9k_Sprite_PosX2)
		ld		(hl),e									;X
		inc		hl
		ld		a,d
		and		%11
		ld		d,a
		ld		a,(hl)
		and		%11111100
		or		d
		ld		(hl),a
		inc		hl										;Set to next sprite
		ld		(Quig_G9K_SpriteY_Address),hl			;Sprite Address
		
		

		ld		a,(Quig_G9k_Sprite_Pos_Set_Width2)		;Get Width
		dec		a
		;If Width = 0 then Do the next line code
		jr		nz,Quig_G9k_Sprite_Set_Pos35
		ld		a,(Quig_G9k_Sprite_Pos_Set_Width1)		;Get Original Width
		ld		(Quig_G9k_Sprite_Pos_Set_Width2),a		;Store it
		;If Height = 0 then 
		ld		a,(Quig_G9k_Sprite_Pos_Set_Height)
		dec		a
		jr		nz,Quig_G9k_Sprite_Set_Pos34
		jp		(iy)

.Quig_G9k_Sprite_Set_Pos34:	
		ld		(Quig_G9k_Sprite_Pos_Set_Height),a		;Store new Height
		ld		hl,(Quig_G9k_Sprite_PosX1)				;Get Original X
		ld		(Quig_G9k_Sprite_PosX2),hl				;Store
		ld		a,(Quig_G9k_Sprite_PosY)
.Quig_G9k_Sprite_Set_Pos60:	
		add		16
		ld		(Quig_G9k_Sprite_PosY),a
		jp		Quig_G9k_Sprite_Set_Pos33
		
.Quig_G9k_Sprite_Set_Pos35:
		ld		(Quig_G9k_Sprite_Pos_Set_Width2),a
		ld		hl,(Quig_G9k_Sprite_PosX2)
		ld		de,16
		add		hl,de
		ld		(Quig_G9k_Sprite_PosX2),hl
		jp		Quig_G9k_Sprite_Set_Pos33

		
		
		
		
		
		
.Quig_G9k_Sprite_Pos_Set_Height:	db 			0
.Quig_G9k_Sprite_Pos_Set_Width1:	db 			0
.Quig_G9k_Sprite_Pos_Set_Width2:	db 			0
.Quig_G9k_Sprite_PosY:				db			0
.Quig_G9k_Sprite_PosX1:				dw			0
.Quig_G9k_Sprite_PosX2:				dw			0
.Quig_G9K_SpriteY_Address:			dw			0

;LIBRARY QUIG.G9K.SPRITE.NEXT
;de=Sprite Start hl=count		
.Quig_G9k_Sprite_Next_Clear:
		ld		b,l
		ex		de,hl
		ld		h,0
		add		hl,hl
		add		hl,hl							;*4
		Ld		de,Quig_Sprite_Attributes		
		add		hl,de							;Sprite Attribute Y	
		;Y
.Quig_G9K_Sprite_NC_1:
		inc		hl
		inc		hl
		inc		hl
		ld		a,(hl)
		and		%11111100
		inc		a
		ld		(hl),a
		inc		hl
		djnz	Quig_G9K_Sprite_NC_1	
		ret		

.Quig_G9K_MSprite_Display:
;DE=Palette HL=Display
		ld		a,e
		rla		
		rla
		and		%1100
		ld		e,a
		ld		a,l
		and		%11
		or		e
		rrca
		rrca
		rrca
		rrca
		and		%11110000
		ld		(Quig_G9K_Sprite_NextDisplay),a
		ld		(Quig_G9k_frog1+1),a
		
		ret
		
.Quig_G9K_MSprite_Draw:
;DE=SPR HL=PAT   (assume X and Y Set)
		ex		de,hl
		ld		h,0
		add		hl,hl
		add		hl,hl								;*4
		Ld		bc,Quig_Sprite_Attributes		
		add		hl,bc								;Sprite Attribute Y
		ld		b,h									;BC Sprite table address pointer
		ld		c,l	
		;Y
		ld		a,(Quig_G9K_Sprite_NextYPos)		;Get Y Pos
		ld		(bc),a
		inc		bc									;Move to Pattern
		;Pattern
		ld		a,e
		ld		(bc),a
		inc		bc
		;X
		ld		hl,(Quig_G9K_Sprite_NextXPos)		;XPos
		ld		a,l
		ld		(bc),a								;Store byte 3
		inc		bc									;inc pointer
		ld		a,(Quig_G9K_Sprite_NextDisplay)		;Display Status
		ld		l,a
		ld		a,h
		and		%11
		or		l
		ld		(bc),a
		ret
		
		
.Quig_G9k_Sprite_Next:
		pop		iy
		ld		bc,(Quig_G9K_Sprite_NextAddr)		;Get where to update
		;Y
		ld		a,(Quig_G9K_Sprite_NextYPos)		;Get Y Pos
		add		e									;e = Y Addition
		ld		(Quig_G9K_Sprite_NextYPos),a		;Store
		ld		(bc),a
		inc		bc									;Move to Pattern
		;Pattern
		ld		a,(Quig_G9K_Sprite_NextPattern)
		add		l
		ld		(Quig_G9K_Sprite_NextPattern),a		
		ld		(bc),a
		inc		bc
		
		;X
		ld		de,(Quig_G9K_Sprite_NextXPos)		;XPos
		pop		hl									;Get Relative X
		add		hl,de								;Add
		ld		(Quig_G9K_Sprite_NextXPos),hl		;Store
		ld		a,l
		ld		(bc),a								;Store byte 3
		inc		bc									;inc pointer
		
		ld		a,(bc)								
		and		%11111100
		ld		l,a
		ld		a,h
		and		%11
		or		l
		ld		(bc),a
		inc		bc
		ld		(Quig_G9K_Sprite_NextAddr),bc		;Get where to update		

		jp		(iy)
		
		
.Quig_G9k_Sprite_Next_Data:		
		db		0			;Pattern
		dw		0			;X		


;LIBRARY QUIG.G9K.SPRGROUP.DRAW

.Quig_G9k_SprGroup_Draw:
		ld		h,0
		add		hl,hl
		add		hl,hl								;*4
		Ld		bc,Quig_Sprite_Attributes		
		add		hl,bc								;Sprite Attribute Y
		ld		b,h									;BC Sprite table address pointer
		ld		c,l

		ex		de,hl								;Swap DE & HL
		add		hl,hl								;double
		ld		de,Quig_G9k_Group_Addresses
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		
		ld		a,(Quig_G9K_Sprite_NextYPos)		;Get Current Ypos
		ld		(Quig_G9k_gh1+1),a					;Store Current YPos
		ld		a,(de)								;Get Counter
		inc		de									;Move source Address Pointer on
		ld		hl,(Quig_G9K_Sprite_NextXPos)		;HL = Xpos
		;; So c=pattern number & b=count
.Quig_G9k_Sgd_Loop:
		ld		(Quig_G9k_frog2+1),a				;Store Counter
		;Y
		ld		a,(de)								;Get the RelativeY value
		
.Quig_G9k_gh1:		
		add		0									;Adds the Ypos+RealtiveY Together
		ld		(Quig_G9k_gh1+1),a					;Stores total as YPos
		ld		(bc),a								;Stores totalin Spprite Y Pos
		inc		de									;Increment Source Address Pointer
		inc		bc									;Increment Sprite Table Address pointer
		;Pattern
		ld		a,(de)								;Gets the Pattern number to use	
		ld		(bc),a								;Stores Pattern in Sprite Table
		inc		de									;Increment Source Address Pointer
		inc		bc									;Increment Sprite Table Address Pointer
		;X
		push 	bc
        ex 		de,hl
        ld 		c,(hl)
        inc 	hl
        ld 		b,(hl)
        inc 	hl
        ex 		de,hl
        add 	hl,bc
        pop 	bc	
		ld		a,l
		ld		(bc),a
		inc		bc		
		ld		a,h
		and		%11
.Quig_G9k_frog1:
		or		%10000000
		ld		(bc),a
		inc		bc
.Quig_G9k_frog2:		
		ld		a,0
		dec		a			
		jr		nz,Quig_G9k_Sgd_Loop
		ret	
		
.Quig_G9k_Group_Addresses:
        dw Quig_G9k_Group_1,Quig_G9k_Group_2,Quig_G9k_Group_3,Quig_G9k_Group_4,Quig_G9k_Group_5,Quig_G9k_Group_6,Quig_G9k_Group_7,Quig_G9k_Group_8,Quig_G9k_Group_9,Quig_G9k_Group_10,Quig_G9k_Group_11,Quig_G9k_Group_12
        dw Quig_G9k_Group_13,Quig_G9k_Group_14,Quig_G9k_Group_15,Quig_G9k_Group_16,Quig_G9k_Group_17,Quig_G9k_Group_18,Quig_G9k_Group_19,Quig_G9k_Group_20,Quig_G9k_Group_21,Quig_G9k_Group_22,Quig_G9k_Group_23
        dw Quig_G9k_Group_24,Quig_G9k_Group_25,Quig_G9k_Group_26,Quig_G9k_Group_27,Quig_G9k_Group_28,Quig_G9k_Group_29,Quig_G9k_Group_30,Quig_G9k_Group_31,Quig_G9k_Group_32,Quig_G9k_Group_33,Quig_G9k_Group_34
        dw Quig_G9k_Group_35,Quig_G9k_Group_36,Quig_G9k_Group_37,Quig_G9k_Group_38,Quig_G9k_Group_39,Quig_G9k_Group_40,Quig_G9k_Group_41,Quig_G9k_Group_42,Quig_G9k_Group_43,Quig_G9k_Group_44,Quig_G9k_Group_45
        dw Quig_G9k_Group_46,Quig_G9k_Group_47,Quig_G9k_Group_48,Quig_G9k_Group_49,Quig_G9k_Group_50,Quig_G9k_Group_51,Quig_G9k_Group_52,Quig_G9k_Group_53,Quig_G9k_Group_54,Quig_G9k_Group_55,Quig_G9k_Group_56

.Quig_G9k_Group_1:
        db 4:db -12,0:dw -16:db 0,1:dw 16:db 16,16:dw -16:db 0,17:dw 16:
.Quig_G9k_Group_2:
        db 4:db -12,2:dw -18:db 0,3:dw 16:db 16,18:dw -16:db 0,19:dw 16:
.Quig_G9k_Group_3:
        db 4:db -13,4:dw -19:db 0,5:dw 16:db 16,20:dw -16:db 0,21:dw 16:
.Quig_G9k_Group_4:
        db 4:db -14,6:dw -20:db 0,7:dw 16:db 16,22:dw -16:db 0,23:dw 16:
.Quig_G9k_Group_5:
        db 4:db -16,8:dw -20:db 0,9:dw 16:db 16,24:dw -16:db 0,25:dw 16:
.Quig_G9k_Group_6:
        db 4:db -18,10:dw -20:db 0,11:dw 16:db 16,26:dw -16:db 0,27:dw 16:
.Quig_G9k_Group_7:
        db 4:db -18,12:dw -19:db 0,13:dw 16:db 16,28:dw -16:db 0,29:dw 16:
.Quig_G9k_Group_8:
        db 4:db -19,14:dw -17:db 0,15:dw 16:db 16,30:dw -16:db 0,31:dw 16:
.Quig_G9k_Group_9:
        db 4:db -19,32:dw -16:db 0,33:dw 16:db 16,48:dw -16:db 0,49:dw 16:
.Quig_G9k_Group_10:
        db 4:db -19,34:dw -15:db 0,35:dw 16:db 16,50:dw -16:db 0,51:dw 16:
.Quig_G9k_Group_11:
        db 4:db -18,36:dw -14:db 0,37:dw 16:db 16,52:dw -16:db 0,53:dw 16:
.Quig_G9k_Group_12:
        db 4:db -18,38:dw -13:db 0,39:dw 15:db 16,54:dw -15:db 0,55:dw 16:
.Quig_G9k_Group_13:
        db 4:db -16,40:dw -13:db 0,41:dw 16:db 16,56:dw -16:db 0,57:dw 16:
.Quig_G9k_Group_14:
        db 4:db -14,42:dw -14:db 0,43:dw 16:db 16,58:dw -16:db 0,59:dw 16:
.Quig_G9k_Group_15:
        db 4:db -14,44:dw -14:db 0,45:dw 16:db 16,60:dw -16:db 0,61:dw 16:
.Quig_G9k_Group_16:
        db 4:db -13,46:dw -15:db 0,47:dw 16:db 16,62:dw -16:db 0,63:dw 16:
.Quig_G9k_Group_17:
        db 4:db -12,64:dw -16:db 0,65:dw 16:db 16,16:dw -16:db 0,17:dw 16:
.Quig_G9k_Group_18:
        db 4:db -12,66:dw -18:db 0,67:dw 16:db 16,18:dw -16:db 0,83:dw 16:
.Quig_G9k_Group_19:
        db 4:db -13,68:dw -19:db 0,69:dw 16:db 16,84:dw -16:db 0,85:dw 16:
.Quig_G9k_Group_20:
        db 4:db -14,70:dw -20:db 0,71:dw 16:db 16,86:dw -16:db 0,87:dw 16:
.Quig_G9k_Group_21:
        db 4:db -16,72:dw -20:db 0,73:dw 16:db 16,88:dw -16:db 0,89:dw 16:
.Quig_G9k_Group_22:
        db 4:db -18,74:dw -20:db 0,75:dw 16:db 16,90:dw -16:db 0,91:dw 16:
.Quig_G9k_Group_23:
        db 4:db -18,76:dw -19:db 0,77:dw 16:db 16,92:dw -16:db 0,93:dw 16:
.Quig_G9k_Group_24:
        db 4:db -19,78:dw -17:db 0,79:dw 16:db 16,94:dw -16:db 0,95:dw 16:
.Quig_G9k_Group_25:
        db 4:db -19,96:dw -16:db 0,97:dw 16:db 16,112:dw -16:db 0,113:dw 16:
.Quig_G9k_Group_26:
        db 4:db -19,98:dw -15:db 0,99:dw 16:db 16,114:dw -16:db 0,115:dw 16:
.Quig_G9k_Group_27:
        db 4:db -18,100:dw -14:db 0,101:dw 16:db 16,116:dw -16:db 0,117:dw 16:
.Quig_G9k_Group_28:
        db 4:db -17,102:dw -14:db 0,103:dw 16:db 16,118:dw -16:db 0,119:dw 16:
.Quig_G9k_Group_29:
        db 4:db -16,104:dw -13:db 0,105:dw 16:db 16,120:dw -16:db 0,121:dw 16:
.Quig_G9k_Group_30:
        db 4:db -15,106:dw -14:db 0,107:dw 16:db 16,122:dw -16:db 0,123:dw 16:
.Quig_G9k_Group_31:
        db 4:db -14,108:dw -14:db 0,109:dw 16:db 16,124:dw -16:db 0,125:dw 16:
.Quig_G9k_Group_32:
        db 4:db -13,110:dw -14:db 0,111:dw 16:db 16,126:dw -16:db 0,127:dw 16:
.Quig_G9k_Group_33:
        db 4:db -12,0:dw -16:db 0,1:dw 16:db 16,16:dw -16:db 0,17:dw 16:
.Quig_G9k_Group_34:
        db 4:db -14,129:dw -2:db 0,128:dw -16:db 16,144:dw 0:db 0,145:dw 16:
.Quig_G9k_Group_35:
        db 2:db -8,130:dw -17:db 0,131:dw 16:
.Quig_G9k_Group_36:
        db 1:db -8,146:dw -10:
.Quig_G9k_Group_37:
        db 1:db -8,147:dw -8:
.Quig_G9k_Group_38:
        db 1:db -7,132:dw -8:
.Quig_G9k_Group_39:
        db 1:db -7,148:dw -7:
.Quig_G9k_Group_40:
        db 1:db -7,133:dw -7:
.Quig_G9k_Group_41:
        db 1:db -8,149:dw -7:
.Quig_G9k_Group_42:
        db 1:db -8,134:dw -7:
.Quig_G9k_Group_43:
        db 1:db -8,150:dw -8:
.Quig_G9k_Group_44:
        db 1:db -8,135:dw -7:
.Quig_G9k_Group_45:
        db 1:db -8,151:dw -8:
.Quig_G9k_Group_46:
        db 4:db -13,64:dw -16:db 0,65:dw 16:db 16,80:dw -16:db 0,81:dw 16:
.Quig_G9k_Group_47:
        db 4:db -14,136:dw -18:db 0,137:dw 16:db 16,152:dw -16:db 0,153:dw 16:
.Quig_G9k_Group_48:
        db 2:db -8,138:dw -17:db 0,139:dw 16:
.Quig_G9k_Group_49:
        db 1:db -8,154:dw -9:
.Quig_G9k_Group_50:
        db 1:db -8,155:dw -8:
.Quig_G9k_Group_51:
        db 1:db -7,140:dw -9:
.Quig_G9k_Group_52:
        db 1:db -6,148:dw -7:
.Quig_G9k_Group_53:
        db 1:db -7,133:dw -7:
.Quig_G9k_Group_54:
        db 1:db -7,149:dw -7:
.Quig_G9k_Group_55:
        db 1:db -8,134:dw -7:
.Quig_G9k_Group_56:
        db 1:db -7,150:dw -8:
.Quig_G9k_Group_57:
        db 1:db -7,135:dw -8:
.Quig_G9k_Group_58:
        db 1:db -8,151:dw -8:
.Quig_G9k_Group_59:
        db 0:



;LIBRARY QUIG.G9K.SPRITE.ONSCREEEN
;HL = y, DE = x
;OUT HL 0/1 Off/On 

.Quig_G9K_Sprite_OnScreen:		
		ld		bc,16
		add		hl,bc
		ld		bc,(Quig_G9K_ScrollA_YPos)				;Get Map Y Pos	
		and		a										;Clear Flags
		sbc		hl,bc									;Ypos - MapYpos
		jr		c,Quig_G9k_Sprite_OnScreen_Fail			;If <0 Exit					
		ld		a,h
		or		a
		jr		nz,Quig_G9k_Sprite_OnScreen_Fail		;If Not 0 Exit
		ld		a,l										;A is 0, Compare to H
		cp 		228
		jr		nc,Quig_G9k_Sprite_OnScreen_Fail		;If Not 0 Exit
		sub 	16
		ld 		l,a
		;------------- X Part
		ex		de,hl									;Get XPos from DE - DE Become YPos result
.Quig_G9K_Spr
		ld		bc,16
		add		hl,bc
		ld		bc,(Quig_G9K_ScrollA_XPos)				;Get Map X Pos
		and		a										;Clear Flags
		sbc		hl,bc									;Xpos - MapYpos
		jr		c,Quig_G9k_Sprite_OnScreen_Fail			;If <0 Exit	
		bit 	7,h	
		jr		nz,Quig_G9k_Sprite_OnScreen_Fail		;If Not 0 Exit
		ld		bc,-16
		add		hl,bc
        jr 		nc,Quig_G9k_Sprite_OnScreen_Success	
        inc h
        dec h
		jr 		nz,Quig_G9k_Sprite_OnScreen_Fail		;If Not 0 Exit
.Quig_G9k_Sprite_OnScreen_Success:		
		;Set them
		ld		(Quig_G9K_Sprite_NextXPos),hl
		ld		(Quig_G9K_Sprite_NextYPos),de	
		ld		hl,1
		ret
.Quig_G9k_Sprite_OnScreen_Fail:
		ld		hl,0
		ret
		
;LIBRARY QUIG.G9K.SPRITE.SET.POSITION
;*********************************
;HL = Y
;DE = X
;Stack = Sprite number (0-124)
.Quig_G9k_Sprite_Set_Position:
		pop		iy								;IY=Return Address
.Quig_G9k_Sprite_Set_Position_X:		
		pop		bc								;BC=Sprite Number
		ld		a,l
		ld		l,c
		ld		h,0				
		add		hl,hl							;*2
		add		hl,hl							;*4
		ld		bc,Quig_Sprite_Attributes		
		add		hl,bc							;Sprite Attribute Y
		ld		(hl),a							;Y		
		inc		hl								;Skip Pat no		
		inc		hl
		ld		(hl),e							;X
		inc		hl
		ld		a,d
		and		%11
		ld		d,a
		ld		a,(hl)
		and		%11111100
		or		d
		ld		(hl),a
		jp		(iy)

;LIBRARY QUIG.G9K.SPRITE.SET.PATTERN
;*********************************	
.Quig_G9k_Sprite_Set_Pattern:
;HL = Pattern Number (0-255)
;DE = Sprite number (0-127)
.Quig_G9k_Sprite_Set_Patternccccc:
		ex		de,hl
		ld		a,l
		and		%1111111
		ld		l,a
		ld		h,0
		add		hl,hl							;*4
		add		hl,hl							;*4
		ld		bc,Quig_Sprite_Attributes+1
		add		hl,bc							;Sprite Attribute Y
		ld		(hl),e
		ret
;LIBRARY QUIG.G9K.SPRITE.SET.PALETTE
;*********************************		
;HL = Palette (0-3)
;DE = Sprite number (0-127)
.Quig_G9k_Sprite_Set_Palette:
		ex		de,hl
		ld		a,l
		and		%1111111
		ld		l,a
		ld		h,0
		add		hl,hl							;*4
		add		hl,hl							;*4
		ld		bc,Quig_Sprite_Attributes+3
		add		hl,bc							;Sprite Attribute Y
		
		ld		a,(hl)
		and		%111111
		ld		d,a
		ld		a,e
		rla
		rla
		rla
		rla
		rla
		rla
		and		%11000000
		or		d
		ld		(hl),a
		ret		
		
;LIBRARY QUIG.G9K.SPRITES.ON
;***************************
.Quig_G9k_Sprites_On:
		;g9kReadReg
		ld		a,G9K_CTRL+G9K_DIS_INC_READ
		ld		bc,CG9K_REG_SELECT
		di
		out 	(c),a
		ld		bc,CG9K_REG_DATA
		in		a,(c)
		and		255-g9k_CTRL_DIS_SPD
		out		(c),a
		ei
		ret
;LIBRARY QUIG.G9K.SPRITES.OFF		
;****************************
.Quig_G9k_Sprites_Off:
		;g9kReadReg
		ld		a,G9K_CTRL+G9K_DIS_INC_READ
		ld		bc,CG9K_REG_SELECT
		di
		out 	(c),a
		ld		bc,CG9K_REG_DATA
		in		a,(c)
		or		g9k_CTRL_DIS_SPD
		out		(c),a
		ei
		ret

;LIBRARY QUIG.G9K.SPRITE.REFRESH
;*******************************
.Quig_g9k_Sprite_Refresh:
		ld		hl,#FE00
		ld		e,3
.Quig_g9k_Sprite_Refresh_999
		xor		a					;ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		out		(c),e
		ld		hl,Quig_Sprite_Attributes
		ld 		bc,CG9K_VRAM
;Okay lets do 120 sprite copies  = 480 OUTIS		
.Quig_CPC_64_5:		
		call	Quig_g9kCPC_64outi
.Quig_CPC_64_6:
		call	Quig_g9kCPC_64outi
.Quig_CPC_64_7:		
		call	Quig_g9kCPC_64outi
.Quig_CPC_64_8:		
		call	Quig_g9kCPC_64outi
.Quig_CPC_64_9:		
		call	Quig_g9kCPC_64outi
.Quig_CPC_64_10:		
		call	Quig_g9kCPC_64outi		
.Quig_CPC_64_11:		
		call	Quig_g9kCPC_64outi	
.Quig_CPC_32_2:		
		call	Quig_g9kCPC_32outi
		ei
		ret

;LIBRARY QUIG.G9K.SPRITE.REFRESH.AMOUNT
;**************************************
;IN HL=Count, DE = Start
.Quig_g9k_Sprite_Refresh_Amount:
		ld		a,l
		rra
		rra
		rra
		inc		a
		and		%1111
		ld		(Quig_g9k_Sprite_Refresh_Amount2xxx+1),a
		ex		de,hl
		add		hl,hl
		add		hl,hl			;Amount *4
		ld		c,l
		ld		b,h
		ld		de,Quig_Sprite_Attributes
		add		hl,de
		ex		de,hl					;DE=Start of data to copy
		ld		hl,#fe00
		add		hl,bc					;HL=Start of VRAM to copy too
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		ld		a,3
		out		(c),a
.Quig_g9k_Sprite_Refresh_Amount2xxx:		
		ld		a,0						;
		ex		de,hl
		ld 		bc,CG9K_VRAM
.Quig_g9k_Sprite_Refresh_Amount2		
		call	Quig_g9k_32outi
		dec		a
		jp		nz,Quig_g9k_Sprite_Refresh_Amount2
		ei
		ret

;LIBRARY QUIG.G9K.MAPA.SET
;*************************
;IN HL=Value
;   DE=Address
.Quig_g9k_MapA_Set:
		ex		de,hl
		add		hl,hl
		;Offset = 0 so no Add
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		ld		a,7
		out		(c),a
		ld		bc,CG9K_VRAM
		ld		a,e
		out		(c),a
		ld		a,d
		out		(c),a
		ei
		ret


;LIBRARY QUIG.G9K.MAPA.GET
;**************************
;IN HL = Map Position		
;OUT HL = Met Address
.Quig_g9k_MapB_Get:
		ld		de,#1800
		add		hl,de
.Quig_g9k_MapA_Get:
		add		hl,hl
		;Offset = 0 so no Add
		ld		a,g9k_READ_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		ld		a,7
		out		(c),a
		ld		bc,CG9K_VRAM
		in		a,(c)
		ld		l,a
		in		a,(c)
		ld		h,a
		ei
		ret
		
;LIBRARY QUIG.G9K.MAPA.ATTR.GET
;***************************************
;IN HL=Y,DE=X
.Quig_g9k_MapA_Attr_Get:
		ld		a,e					
		rra:	rra:rra
		and		%11
		ld		c,a
		ld		a,l
		rra		
		and		%1100
		or		c
		add		32
		ld		(Quig_Spaxe901+1),a

		add		hl,hl:add hl,hl:add hl,hl										;Hl/32 into H (0.255)		
		ld		l,h
		ld		h,0
		
		add		hl,hl
		ld		bc,Quigs_Map_Edge
		add		hl,bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl

		add		hl,hl:add hl,hl:add hl,hl										;Hl/32 into H (0.255)		
		ld		l,h
		ld		h,0
		
		add		hl,bc		
		add		hl,hl

		
		;Offset = 0 so no Add
		ld		a,g9k_READ_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		ld		a,7
		out		(c),a
		ld		bc,CG9K_VRAM
		in		a,(c)
		ld		l,a
		in		a,(c)
		ld		h,a
.Quig_Spaxe901:		
		ld		de,0		
		add		hl,de
		
		ld		a,g9k_READ_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		ld		a,6
		out		(c),a
		ld		bc,CG9K_VRAM
		in		a,(c)
		ld		l,a
		ld		h,0	
		ei
		ret

;LIBRARY QUIG.G9K.MAPA.METACOPY
;******************************
;IN ST1 = MetaAddr
;IN DE = X
;IN HL = Y
.Quig_G9K_MapA_MetaCopy:
		ld		bc,#c000
		jr		Quig_G9K_MetaCopy
.Quig_G9K_MapB_MetaCopy:
		ld		bc,#e000
.Quig_G9K_MetaCopy:
		pop		iy							;Gets the return address
		ld		a,l							;a=y (0..63)
		and		%00111111					;mask so (0..63)
		ld		l,a							;l=a
		ld		h,0							;hl=hl mod 64
		add		hl,hl	;*2
		add		hl,hl	;*4
		add		hl,hl	;*8
		add		hl,hl	;*16
		add		hl,hl	;*32
		add		hl,hl	;*64
		add		hl,hl	;*128			;??
		ld		a,e
		and		%00111111
		ld		e,a
		ld		d,0
		add		hl,de
		add		hl,de
		add		hl,bc						;HL Address of ScreenMapto Draw (64*64)XY
		ex		de,hl						;DE = HL
		pop		hl							;HL = Address of Meta
		ld		a,g9k_READ_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,6
		out		(c),l
		out		(c),h
		out		(c),a
		ex		de,hl
		call	Quig_ZiggyZagJumpFromMetaSet
		ei
		jp		(iy)
		

;LIBRARY QUIG.G9K.MAPA.META
;*************************
;IN ST = Y
;IN DE = X
;IN HL = Addr
;Plots a 32x32pixel (16 patterns) onto the 512x512 Pattern Map at 32x32 blocks or x:0..15 y:0..15

.Quig_g9k_MapB_Meta:
		ld		a,112
		ld		(Quig_skally1+1),a
		jr		Quig_g9k_Sucker
.Quig_g9k_MapA_Meta:
		ld		a,96
		ld		(Quig_skally1+1),a
.Quig_g9k_Sucker:
		;Set the Read Addres to The Address Data in HL
		ld		a,g9k_READ_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,6
		di
		out		(c),l
		out		(c),h
		out		(c),a	
		pop		iy										;Return Address
		ld		a,e										;Get Y
		rra												;Divide by 4
		rra
		and		%1111
.Quig_skally1:
		add		0
		ld		h,a										;h = y and %1111 + 96 or 112

		pop		de
		ld		a,e										;a = x*4  
		and		%111100									;go
		ld		l,a										;l=a and %1111

		call	Quig_ZiggyZagJump
		ei
		jp		(iy)
	
;LIBRARY QUIG.G9K.META.INT.SET
;*****************************
;DE=Addr
;HL=Data		
.Quig_G9k_Meta_Int_Set:		
		ex		de,hl
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		ld		a,6
		out		(c),a
		ld		bc,CG9k_VRAM		
		ex		de,hl
		out		(c),l
		out		(c),h
		ret
		
;LIBRARY QUIG.G9K.SCROLL.A
;**************************
.Quig_G9K_SCROLL_A	
		;Y
		ld		hl,(Quig_G9K_ScrollA_YPos)
		di
		ld		a,g9k_SCROLL_LOW_Y
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		a,l
		ld		bc,CG9K_REG_DATA
		out		(c),a
		
		
		ld 		a,h
		and 	1
		
;		ld		a,2
;		rrca
;		rrca
;		or		h


		out		(c),a
		;x
		ld		hl,(Quig_G9K_ScrollA_XPos)
		ld		a,g9k_SCROLL_LOW_X
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		a,l
		and		7
		ld		bc,CG9K_REG_DATA
		out		(c),a
		ld		a,l
		srl		h
		rra
		srl		h
		rra		
		srl		h
		rra
		out		(c),a
		ei
		ret
;DE=X
;HL=Y		
.Quig_g9k_Scroll_A_Set:
		ld		(Quig_G9K_ScrollA_YPos),hl
		ld		(Quig_G9K_ScrollA_XPos),de		
		ret
.Quig_g9k_Scroll_AX_Set:
		ld		(Quig_G9K_ScrollA_XPos),hl
		ret
.Quig_g9k_Scroll_AY_Set:
		ld		(Quig_G9K_ScrollA_YPos),hl
		ret			
	
;LIBRARY QUIG.G9K.SPRITE.ONSCREEEN
;HL = y, DE = x
;OUT HL 0/1 Off/On 

.Quig_G9K_Sprite_OnScreen:
		;*** Y Part
.Quig_G9K_Sprite_OS1:
	
;LIBRARY QUIG.G9K.SCROLL.B
;**************************
;DE=X
;HL=Y
.Quig_G9k_Scroll_B	
		;Y
		ld		hl,(Quig_G9K_ScrollB_YPos)
		ld		a,g9k_SCROLL_LOW_Y_B
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		a,l
		ld		bc,CG9K_REG_DATA
		out		(c),a		
		ld 		a,h
		and		%1
		out		(c),a

		;x
		ld		hl,(Quig_G9K_ScrollB_XPos)
		ld		a,g9k_SCROLL_LOW_X_B
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		a,l
		and		7
		ld		bc,CG9K_REG_DATA
		out		(c),a
		ld		a,l
		srl		h
		rra
		srl		h
		rra		
		srl		h
		rra
		out		(c),a
		ei
		ret	
;DE=X
;HL=Y
.Quig_g9k_Scroll_B_Set:
		ld		(Quig_G9K_ScrollB_XPos),de
		ld		(Quig_G9K_ScrollB_YPos),hl
		ret	
.Quig_g9k_Scroll_BX_Set:
		ld		(Quig_G9K_ScrollB_XPos),hl
		ret
.Quig_g9k_Scroll_BY_Set:
		ld		(Quig_G9K_ScrollB_YPos),hl
		ret		
		
;LIBRARY QUIG.G9K.BACKCOLOUR.SET
;HL=Palette 0-63
.Quig_g9k_BackColour_Set:
		ld		a,CG9K_BACK_DROP_COLOR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		ei
		ret		

;LIBRARY QUIG.G9K.MAPA.DRAW
;**************************
;In hl=y, de=x
;
.Quig_g9k_MapB_Draw:
		ld		a,112
		ld		(Quig_g9k_MapA_Meta96or112+1),a
		ld		(Quig_G9K_ScrollB_YPos),hl
		add		hl,hl:add	hl,hl:add hl,hl
		ld		a,h:ld l,h:ld h,0
		ld		(Quig_G9K_ScrollB_YPosOld),a
		ex		de,hl
		
		push 	hl
		ld		(Quig_G9K_ScrollB_XPos),hl
		add		hl,hl:add	hl,hl:add hl,hl
		ld		a,h:ld l,h:ld h,0		
		ld		(Quig_G9K_ScrollB_XPosOld),a
		pop		hl
		ex		de,hl
		ld		a,l
		cp		0
		jr		z,Quig_g9k_MapB_Draw2
		dec		a
		dec		hl
.Quig_g9k_MapB_Draw2:	
		dec a
		ld		(Quig_MD_OldYdiv32),a												;This will be copied into Quig_ziggyzag1+1
		add		hl,hl																;Double Y
		ld		bc,Quigs_Map_Edge													;Get Edge Size
		add		hl,bc																;Add
		ld		a,(hl)	
		inc		hl
		ld		h,(hl)																;	
		ld		l,a																	;HL=Map Vertical Address
		ld 		a,e:srl d:rra:srl d:rra:srl d:rra
		ld		e,a
		dec		a
		dec		de
		and		%111100
		ld		(Quig_ziggyzag2+1),a
		ld		a,e
		srl d	:rra:srl d:rra:ld e,a		;DE = Xpos/32
		add		hl,de
		ld		de,#1800															;Map B Offset
		add		hl,de			
		add		hl,hl

		ld		a,#af
		cp		h
		jr		nz,jjsw2
		ld		hl,#2ffe
.jjsw2:				
		
		ld		(Quig_Map_TopCornerAddr),hl
		ld		b,16
.Quig_g9k_MapB_DrawLoop:		
		push	bc
		push	hl
		ld		(Quig_g9k_VertGetAndMap+1),hl
		ld		a,(Quig_MD_OldYdiv32)
		ld		(Quig_ziggyzag1+1),a
		di
		call	Quig_g9k_VertGetAndMap					;Draw 1
		call	Quig_g9k_VertGetAndMap					;Draw 2
		call	Quig_g9k_VertGetAndMap					;Draw 3
		call	Quig_g9k_VertGetAndMap					;Draw 4
		call	Quig_g9k_VertGetAndMap					;Draw 5
		call	Quig_g9k_VertGetAndMap					;Draw 6
		call	Quig_g9k_VertGetAndMap					;Draw 7
		call	Quig_g9k_VertGetAndMap					;Draw 8		
		call	Quig_g9k_VertGetAndMap					;Draw 9
		call	Quig_g9k_VertGetAndMap					;Draw 10
		call	Quig_g9k_VertGetAndMap					;Draw 11
		call	Quig_g9k_VertGetAndMap					;Draw 12
		call	Quig_g9k_VertGetAndMap					;Draw 13
		call	Quig_g9k_VertGetAndMap					;Draw 14
		call	Quig_g9k_VertGetAndMap					;Draw 15
		call	Quig_g9k_VertGetAndMap					;Draw 16
		ei
		ld		a,(Quig_ziggyzag2+1)
		add		4
		and		%111100
		ld		(Quig_ziggyzag2+1),a		
		pop		hl
		inc		hl
		inc		hl
		pop		bc
		djnz	Quig_g9k_MapB_DrawLoop
		ret
.Quig_g9k_MapA_Draw:
		ld		a,96
		ld		(Quig_g9k_MapA_Meta96or112+1),a
		ld		(Quig_G9K_ScrollA_YPos),hl					;Stores Y as pixel
		add		hl,hl:add	hl,hl:add hl,hl					;Multiply 8	
		ld		a,h:ld l,h:ld h,0							;a=title across
		ld		(Quig_G9K_ScrollA_YPosOld),a				;Store Old as tile
		ex		de,hl										
		
		push 	hl											;Pushes X
		ld		(Quig_G9K_ScrollA_XPos),hl					;Stores X as pixel
		add		hl,hl:add	hl,hl:add hl,hl					;Mul by 8
		ld		a,h:ld l,h:ld h,0									
		ld		(Quig_G9K_ScrollA_XPosOld),a
	
		pop		hl
		ex		de,hl					
		ld		a,l											;de=Y tile so a=tileY
		cp		0
		jr		z,Quig_g9k_MapA_Draw2
		dec		a
		dec		hl
.Quig_g9k_MapA_Draw2:
		dec		a
		ld		(Quig_MD_OldYdiv32),a												;This will be copied into Quig_ziggyzag1+1
		add		hl,hl																;Double Y
		ld		bc,Quigs_Map_Edge													;Get Edge Size
		add		hl,bc																;Add
		ld		a,(hl)	
		inc		hl
		ld		h,(hl)																;	
		ld		l,a																	;HL=Map Vertical Address
		ld 		a,e:srl d:rra:srl d:rra:srl d:rra
		ld		e,a
		dec		a
		dec		de
		and		%111100
		ld		(Quig_ziggyzag2+1),a
		ld		a,e
		srl d	:rra:srl d:rra:ld e,a		;DE = Xpos/32
		add		hl,de		
		add		hl,hl
		
		ld		a,#7f
		cp		h
		jr		nz,jjsw
		ld		hl,#fffe
.jjsw:		
		ld		(Quig_Map_TopCornerAddr),hl
		ld		b,16
.Quig_g9k_MapA_DrawLoop:		
		push	bc
		push	hl
		ld		(Quig_g9k_VertGetAndMap+1),hl
		ld		a,(Quig_MD_OldYdiv32)
		ld		(Quig_ziggyzag1+1),a
		di
		call	Quig_g9k_VertGetAndMap					;Draw 1
		call	Quig_g9k_VertGetAndMap					;Draw 2
		call	Quig_g9k_VertGetAndMap					;Draw 3
		call	Quig_g9k_VertGetAndMap					;Draw 4
		call	Quig_g9k_VertGetAndMap					;Draw 5
		call	Quig_g9k_VertGetAndMap					;Draw 6
		call	Quig_g9k_VertGetAndMap					;Draw 7
		call	Quig_g9k_VertGetAndMap					;Draw 8		
		call	Quig_g9k_VertGetAndMap					;Draw 9
		call	Quig_g9k_VertGetAndMap					;Draw 10
		call	Quig_g9k_VertGetAndMap					;Draw 11
		call	Quig_g9k_VertGetAndMap					;Draw 12
		call	Quig_g9k_VertGetAndMap					;Draw 13
		call	Quig_g9k_VertGetAndMap					;Draw 14
		call	Quig_g9k_VertGetAndMap					;Draw 15
		call	Quig_g9k_VertGetAndMap					;Draw 16
		ei
		ld		a,(Quig_ziggyzag2+1)
		add		4
		and		%111100
		ld		(Quig_ziggyzag2+1),a		
		pop		hl
		inc		hl
		inc		hl
		pop		bc
		djnz	Quig_g9k_MapA_DrawLoop
		ret
		
		
.Quig_MD_OldYdiv32:			db	0
.Quig_Map_TopCornerAddr:	dw 0

;LIBRARY QUIG.G9K.PATTERN.COPY
;

; HL = Pointer to data  (format: SourceX,SourceY,DestX,DestY,Width,height) struct G9K_COPY_XY_XY
.Quig_g9k_Pattern_Copy:

		;Cmndwait
.Quig_g9k_Pattern_Copy_x:		
		in		a,(CG9K_STATUS)
		rra
		jr		C,Quig_g9k_Pattern_Copy_x

		ld		hl,Quig_g9k_Pattern_Copy_Data		
		
		ld		a,g9k_WRITE_MASK
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,255
		out		(c),a		
		
		ld		a,g9k_sc_X
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA

		;Our 12 times
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi		
		ld		bc,CG9K_REG_SELECT
		ld		a,G9K_OPCODE
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,G9K_OPCODE_LMMM
		out		(c),a
		
		ret
.Quig_g9k_Pattern_Copy_Data:
		dw		72,176
		dw		0,0
		dw		16,64
	
;LIBRARY QUIG.G9K.FORE.PALETTE.SET
;HL = Pallete 0 - 3
.Quig_g9k_Fore_Palette_Set
		ld		a,l
		and		%11
		ld		l,a

		ld		a,(Quig_g9k_ForeBack_Palette)
		and		%1100
		or		l
		ld		(Quig_g9k_ForeBack_Palette),a
		jp		Quig_g9k_ForeBack_Palette_Set
.Quig_g9k_Back_Palette_Set
		ld		a,l
		rla
		rla	
		and		%1100
		ld		l,a
		ld		a,(Quig_g9k_ForeBack_Palette)
		and		%11
		or		l
		ld		(Quig_g9k_ForeBack_Palette),a
.Quig_g9k_ForeBack_Palette_Set
		;Set Palettes
		ld		a,g9k_PALETTE_CTRL
		ld		bc,CG9K_REG_SELECT
		out 	(c),a
		ld		a,(Quig_g9k_ForeBack_Palette)
		ld		bc,CG9K_REG_DATA
		out		(c),a
		ret
.Quig_g9k_ForeBack_Palette:	db	%0100
		
		
;LIBRARY QUIG.G9K.PALETTE.SET
;ST2 =Palette
;ST1 = R
;DE = G
;HL = B
.Quig_g9k_Palette_set
		pop		iy
		ld		a,l
		ld		(Quig_g9k_palette_set_data+2),a				;B
		ld		a,e
		ld		(Quig_g9k_palette_set_data+1),a				;G	
		pop		hl
		ld		a,l
		ld		(Quig_g9k_palette_set_data+0),a				;R	
		pop		hl
		;G9KWriteReg
		ld		a,g9k_PALETTE_PTR
		ld 		bc,CG9K_REG_SELECT
		out 	(c),a
		
		ld		a,l						;Offset
		add		a
		add		a
		ld 		bc,CG9K_REG_DATA
		out		(c),a		
		;Push the palettes
		ld		hl,Quig_g9k_palette_set_data
		ld		bc,CG9K_palette
		inc 	b:outi:inc b:outi:inc b:outi		
		jp		(iy)
.Quig_g9k_palette_set_data
		db		0,0,0,0	
;
;LIBRARY QUIG.G9K.VWAIT
;
.Quig_g9k_VWait
.Quig_g9k_Vwait_1
		ld		bc,CG9K_Status
		in		a,(c)
		and		g9k_STATUS_VR
		jr		nz,Quig_g9k_Vwait_1
.Quig_g9k_Vwait_2
		ld		bc,CG9K_Status
		in		a,(c)
		and		g9k_STATUS_VR
		jr		z,Quig_g9k_Vwait_2		
		ret		

;LIBRARY QUIG.G9K.METALOAD
;**************************
;IN HL = File address
;OUT HL = 0-Fail / 1 Success		


.Quig_g9k_MetaLoad:
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File		
		jp		c,Quig_G9K_MetaLoad_Fail
			
		ld		(Quig_MetaLoad_Handle),a		;Store our File Handle Number	
		;*** File is open and ready to read
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		bc,5							;Header,5 Bytes Pass/Count & Size
		ld		a,(Quig_MetaLoad_Handle)		
		call 	SySystem_CallFunction
		db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP	
	
		ld		hl,(Quig_String_Buffer_Pos)
		ld		a,(hl)		
		cp		180								;Read header byte
		jp		nz,Quig_G9K_MetaLoad_FailClose	;If not 180 then fail
		inc		hl
		ld		e,(hl)							;Read The MetaTile count
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		(Quig_G9k_Meta_Count),de		;Store
		ld		e,(hl)							;Read The MetaTile Size
		inc		hl
		ld		d,(hl)
		inc		hl							
		ld		(Quig_G9k_Meta_Size),de					
		;File now points at start of MetaData - Copy it to 64k VRAM at 6 00000 
		ld		(Quig_LoadSize),de
		ld		hl,0							;HL =6 00000
		ld		(Quig_MetaLoad_VAddr),hl		;Where to copy too
		ld		a,6								;VRAM HI
		ld		(Quig_g9k_MetaLoad_Copy256+1),a
		jp		Quig_g9k_MetaLoad_Loop1
		
.Quig_g9k_MapALoad:
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File		
		jp		c,Quig_G9K_MetaLoad_Fail
			
		ld		(Quig_MetaLoad_Handle),a		;Store our File Handle Number	
		;*** File is open and ready to read
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		bc,13							;Header,5 Bytes Pass/Count & Size
		ld		a,(Quig_MetaLoad_Handle)		
		call 	SySystem_CallFunction
		db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP	
	
		ld		hl,(Quig_String_Buffer_Pos)
		ld		a,(hl)		
		cp		181								;Read header byte
		jp		nz,Quig_G9K_MetaLoad_FailClose	;If not 180 then fail
		inc		hl
		ld		de,Quig_G9k_MapA_Width
		ld		bc,10
		ldir
		
		
		ld		hl,0
		ld		a,(Quig_G9k_MapA_MetaHeight)
		ld		de,Quigs_Map_Edge
.gorrrry:		
		push	af
		ld		a,l
		ld		(de),a
		inc		de
		ld		a,h
		ld		(de),a
		inc		de
		ld		bc,(Quig_G9k_MapA_MetaWidth)
		add		hl,bc
		pop		af
		dec		a
		jp		nz,gorrrry
		
		ld		de,(Quig_G9k_MapA_Size)
		;File now points at start of MetaData - Copy it to 64k VRAM at 6 00000 
		ld		(Quig_LoadSize),de
		ld		hl,0							;HL =7 0000
		ld		(Quig_MetaLoad_VAddr),hl		;Where to copy too
		ld		a,7								;VRAM HI
		ld		(Quig_g9k_MetaLoad_Copy256+1),a
		jp		Quig_g9k_MetaLoad_Loop1
		
.Quig_g9k_MapBLoad:
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File		
		jp		c,Quig_G9K_MetaLoad_Fail
			
		ld		(Quig_MetaLoad_Handle),a		;Store our File Handle Number	
		;*** File is open and ready to read
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		bc,13							;Header,5 Bytes Pass/Count & Size
		ld		a,(Quig_MetaLoad_Handle)		
		call 	SySystem_CallFunction
		db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP	
	
		ld		hl,(Quig_String_Buffer_Pos)
		ld		a,(hl)		
		cp		181								;Read header byte
		jp		nz,Quig_G9K_MetaLoad_FailClose	;If not 180 then fail
		inc		hl
		ld		de,Quig_G9k_MapB_Width
		ld		bc,10
		ldir	
		ld		de,(Quig_G9k_MapB_Size)
		;File now points at start of MetaData - Copy it to 64k VRAM at 6 00000 
		ld		(Quig_LoadSize),de
		ld		hl,#3000						;HL =7 3000
		ld		(Quig_MetaLoad_VAddr),hl		;Where to copy too
		ld		a,7								;VRAM HI
		ld		(Quig_g9k_MetaLoad_Copy256+1),a
		jp		Quig_g9k_MetaLoad_Loop1		
		
.Quig_g9k_MetaLoad_Loop1:		
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_LoadMeta_Buffer),hl		
		ld		bc,1024							;32*48
		ld		a,(Quig_MetaLoad_Handle)		
		call 	SySystem_CallFunction
		db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP
		push 	bc
		;****** Work Stuff into VDP	
		call	Quig_g9k_MetaLoad_Copy256
		call	Quig_g9k_MetaLoad_Copy256
		call	Quig_g9k_MetaLoad_Copy256
		call	Quig_g9k_MetaLoad_Copy256
		call	Quig_g9k_MetaLoad_Copy256		;
		call	Quig_g9k_MetaLoad_Copy256		;
		call	Quig_g9k_MetaLoad_Copy256		;
		call	Quig_g9k_MetaLoad_Copy256		;
		pop		bc
		ld		hl,(Quig_LoadSize)
		and		a
		sbc		hl,bc
		ld		(Quig_LoadSize),hl
		jp		c,Quig_g9k_MetaLoad_Loop2
		jp		z,Quig_g9k_MetaLoad_Loop2	
		
		jp		Quig_g9k_MetaLoad_Loop1
		
.Quig_g9k_MetaLoad_Loop2:		
		;Close & Return
		ld		a,(Quig_MetaLoad_Handle)
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO	

		;Fix the double width to update mapaddr in routines
		ld		hl,(Quig_G9k_MapA_MetaWidth)
		add		hl,hl
		ld		(Quig_g9k_UpdateMapDirection1+1),hl

		ld		hl,1
		ret
	
.Quig_g9k_MetaLoad_Copy256:
		ld		e,0
		ld		hl,(Quig_MetaLoad_VAddr)
		;SetVramWrite
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		out		(c),e
		ld		hl,(Quig_LoadMeta_Buffer)
		ld		bc,CG9k_VRAM
.Quig_CPC_64_1:		
		call	Quig_g9kCPC_64outi
.Quig_CPC_64_2:		
		call	Quig_g9kCPC_64outi
;.Quig_CPC_64_3:		
;		call	Quig_g9kCPC_64outi	
;.Quig_CPC_64_4:		
;		call	Quig_g9kCPC_64outi
		ei
		ld		(Quig_LoadMeta_Buffer),hl
		;		
		ld		hl,(Quig_MetaLoad_VAddr)
		ld		de,128
;		ld		de,256
		add		hl,de
		ld		(Quig_MetaLoad_VAddr),hl
		ret
.Quig_G9K_MetaLoad_FailClose:
		ld		a,(Quig_LoadTile_Handle)
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO
.Quig_G9K_MetaLoad_Fail:
		ld		hl,0
		ret

;LIBRARY QUIG.G9K.ANIMATE.PATTERNS
;*********************************
.Quig_g9k_Animate_Patterns_Off:
	ld		a,255
	ld		(Quig_PattAutoAnim),a
	ret
.Quig_g9k_Animate_Patterns_On:	
	xor		a
	ld		(Quig_PattAutoAnim),a
	ret

;*******************************************************************
;************************ PALETTE STUFF ****************************		
;*******************************************************************

;LIBRARY QUIG.G9K.TILELOAD
;**************************
;IN HL = Palette Offset (0 - 64)  -1=Don't import Palette
;   DE = Tile Offset
;   ST1 = File Address
;OUT HL = Tiles Loaded 
		inclib QUIG.G9K.INK.SET
.Quig_LoadPal_Offset:	db	0
.Quig_LoadTile_Offset:	dw	0
.Quig_LoadTile_Handle:	db	0
.Quig_LoadTile_Count:	dw	0
.Quig_LoadTile_Buffer:	dw	0

.Quig_G9K_TileALoad:
		pop		iy
		ld		a,l
		ld		(Quig_LoadTile_Offset),de
		jr		Quig_G9K_TileLoadX
.Quig_G9K_TileBLoad:
		pop		iy
		ld		a,l
		ld		hl,8192
		add		hl,de
		ld		(Quig_LoadTile_Offset),hl		
.Quig_G9K_TileLoadX:
		ld		l,a
		ld		h,0
		ld		c,l
		ld		b,h
		add		hl,hl		;*32
		add		hl,bc		;*48
		ld		bc,Quig_g9k_Ink_Data
		add		hl,bc	
		ld		(Quig_g9k_TileStuff),hl
		pop		hl								;Get File address
		push	iy
		di
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File
		jp		c,Quig_G9K_TileLoadFail
		ld		(Quig_LoadTile_Handle),a		;Store our File Handle Number	



		
		;*** File is open and ready to read
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		bc,60							;Header,Tile Cuunt & 16 Palettes
		ld		a,(Quig_LoadTile_Handle)		
		call 	SySystem_CallFunction
		db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP	
	
		ld		hl,(Quig_String_Buffer_Pos)
		ld		a,(hl)		
		cp		178
		
		jp		nz,Quig_G9K_TileLoadFail_Close
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		(Quig_LoadTile_Count),de
		inc		hl
		ld		de,(Quig_g9k_TileStuff)
		ld		bc,48
		ldir
		
.Quig_LoadTileLoop_N1:
		;*** File Read Tile Data
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_LoadTile_Buffer),hl		
		ld		bc,1024							;1024 Bytes of tile data
		ld		a,(Quig_LoadTile_Handle)		
		call 	SySystem_CallFunction
		db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP
	
		ld		b,32
.Quig_LoadTileLoop_N2:		
		push	bc
		;****** Work Stuff into VDP
		ld		hl,(Quig_LoadTile_Offset)
		ld		a,h
		rra		
		rra	
		rra
		and		%111
		ld		e,a
		add		hl,hl							;*2
		add		hl,hl							;*4
		add		hl,hl							;*8
		add		hl,hl							;*16
		add		hl,hl							;*32		
		;SetVramWrite
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		out		(c),e
		ld		hl,(Quig_LoadTile_Buffer)
		ld		bc,CG9k_VRAM
		INCLIB 	QUIG.G9K.32OUTI
.Quig_CPC_32_1:
		call	Quig_g9kCPC_32outi		
		ei
		ld		hl,(Quig_LoadTile_Offset)
		inc		hl
		ld		(Quig_LoadTile_Offset),hl
		ld		hl,(Quig_LoadTile_Buffer)
		ld		de,32
		add		hl,de
		ld		(Quig_LoadTile_Buffer),hl
		pop		bc
		djnz	Quig_LoadTileLoop_N2
		
		ld		hl,(Quig_LoadTile_Count)		;Tile Count
		ld		de,32
		and		a
		sbc		hl,de
		ld		(Quig_LoadTile_Count),hl
		jp		c,Quig_G9K_TileLoadFail_Close
		jp		nz,Quig_LoadTileLoop_N1
	
.Quig_G9K_TileLoadFail_Close:
		ld		a,(Quig_LoadTile_Handle)
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO	
		ld		hl,1
		ret		
.Quig_G9K_TileLoadFail:
		ld		hl,0
		ret		
.Quig_g9k_TileStuff:Dw	0
;LIBRARY QUIG.G9K.MAP.SET
; HL = Y
; DE = X
; ST1 = Pattern number in generator table (on screen patterns 0 to A=8159,B=7679)
;  A = Layer number (0=A,1=B)
.Quig_g9k_DrawTileA:
		pop		iy
		ld		bc,#c000
		jr		Quig_g9k_DrawTile
.Quig_g9k_DrawTileB:
		pop		iy
		ld		bc,#e000
.Quig_g9k_DrawTile:
		ld		a,l
		and		%00111111
		ld		l,a
		add		hl,hl	;*2
		add		hl,hl	;*4
		add		hl,hl	;*8
		add		hl,hl	;*16
		add		hl,hl	;*32
		add		hl,hl	;*64
		ld		a,e
		and		%00111111
		ld		e,a
		add		hl,de
		add		hl,hl
		add		hl,bc
			
		ld		e,7
		;SetVramWrite
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		di
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		out		(c),e
		;
		pop		de
		ld		bc,CG9K_VRAM
		out		(c),e
		out		(c),d
		ei
		jp		(iy)



;LIBRARY QUIG.G9K.COMMAND.BMXL
.Quig_g9k_Command_BMXL:


		ld 		a,#32
        ld 		bc,CG9K_REG_SELECT
        out 	(c),a
        ld 		hl,Quig_g9k_CommandBmxlList
        ;call 	vdpwait
        ld 		bc,CG9K_REG_DATA;
		;Do 21 Times
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
		inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
        inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi	
	
		ret
		

		
.Quig_g9k_CommandBmxlList:
.Quig_BMXL_32:db		#40				;SA bits 0-7
.Quig_BMXL_33:db		0				;SA NA
.Quig_BMXL_34:db		#80				;SA bits 8-15
.Quig_BMXL_35:db		#f				;SA bits 16-18
.Quig_BMXL_36:db		0				;DX bits 0-7
.Quig_BMXL_37:db		0				;DX bits 8-10
.Quig_BMXL_38:db		#80				;DY bits 0-7
.Quig_BMXL_39:db		#f				;DY bits 8-11
.Quig_BMXL_40:db		#10				;NX bits 0-7
.Quig_BMXL_41:db		#0				;NX bits 8-10
.Quig_BMXL_42:db		#0				;NY bits 0-7
.Quig_BMXL_43:db		#0				;NY bits 8-11
.Quig_BMXL_44:db		0				;DIVX DIVY
.Quig_BMXL_45:db		12				;Logical Operation
.Quig_BMXL_46:db		0				;Write Mask bits 0-7
.Quig_BMXL_47:db		255				;Write Mask bits 8-15
.Quig_BMXL_48:db		0				;
.Quig_BMXL_49:db		0				;
.Quig_BMXL_50:db		0				;
.Quig_BMXL_51:db		0				;
.Quig_BMXL_52:db		g9k_OPCODE_BMXL	;BMXL Command
		
		

;LIBRARY QUIG.G9K.COMMAND
.Quig_g9k_Command:

		ld		b,6
		ld		a,#1
.gssg
		ld		(upper1+1),a
		ld		(upper2+1),a
		ld		(upper3+1),a
		ld		(quig_36),a		
		add		16		
		push	af
		push 	bc

;.Quig_g9k_CommandWait1:		
;		in		a,(CG9K_STATUS)
;		rra
;		jr		C,Quig_g9k_CommandWait1

		ld 		a,CG9K_SC_A
        ld 		bc,CG9K_REG_SELECT
        out 	(c),a
        ld 		hl,Quig_g9k_CommandList
        ld 		bc,CG9K_REG_DATA
        inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
        inc 	b:outi  :inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
;        inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi		;
		ld 		a,g9k_OPCODE
		out 	(CG9K_REG_SELECT),a
		ld		a,#a0
		out		(CG9K_REG_DATA),a		
		
		
		ld 		a,CG9K_SC_A
        out 	(CG9K_REG_SELECT),a
        ld 		bc,CG9K_REG_DATA
		ld		a,#11
		out		(c),a
		out		(c),a
		ld		hl,#c4b
		out		(c),l
		out		(c),h
.upper1:		
		ld		a,#1
		out		(c),a
		out		(c),a
		ld		a,#81
		out		(c),a	
		ld 		a,g9k_OPCODE
       out 	(CG9K_REG_SELECT),a
		ld		a,#a0
		out		(CG9K_REG_DATA),a
		
		ld 		a,CG9K_SC_A
        out 	(CG9K_REG_SELECT),a
        ld 		bc,CG9K_REG_DATA
		ld		a,#21
		out		(c),a
		out		(c),a
		ld		hl,#c4b
		out		(c),l
		out		(c),h
.upper2:		
		ld		a,#1
		out		(c),a
		out		(c),a
		ld		a,#82
		out		(c),a	
		ld 		a,g9k_OPCODE
        out 	(CG9K_REG_SELECT),a
		ld		a,#a0
		out		(CG9K_REG_DATA),a	
		
		ld 		a,CG9K_SC_A
        out 	(CG9K_REG_SELECT),a
        ld 		bc,CG9K_REG_DATA
		ld		a,#31
		out		(c),a
		out		(c),a
		ld		hl,#c4b
		out		(c),l
		out		(c),h
.upper3:		
		ld		a,#1
		out		(c),a
		out		(c),a
		ld		a,#83
		out		(c),a	
		ld 		a,g9k_OPCODE
        out 	(CG9K_REG_SELECT),a
		ld		a,#a0
		out		(CG9K_REG_DATA),a		

		pop		bc
		pop		af
		dec		b
		
		jp   nz,gssg
		
		ret
		



;LIBRARY QUIG.GAMEOBJ.UPDATE
;***************************
.Quig_GameObj_Update:
		ld		b,64
		ld		hl,Quig_G9k_GameObjList
		ld		de,32
.Quig_GameObj_Update2:		
		ld		a,(hl)
		or		%1
		jp		nz,Quig_GameObj_Updatex
		;**** Found something
		push	bc
		push	hl
		inc		hl
		ld		e,(hl)							;7
		inc		hl								;6
		ld		d,(hl)							;7
		inc		hl								;6
		ld		(Quig_G9K_GameObjDataAddr),hl	;16
		ld		(Quig_GameObj_Update3+1),de		;20		=62
.Quig_GameObj_Update3:		
		call	0
		pop		hl	
		pop		bc
		ld		de,32
.Quig_GameObj_Updatex:
		add		hl,de
		djnz	Quig_GameObj_Update2
		ret
		
		
		




		