.PRC_ID_KERNEL   equ 95   ;kernel proces
.PRC_ID_DESKTOP  equ 2   ;desktop manager process
.PRC_ID_SYSTEM   equ 3   ;system manager process
.MSC_GEN_QUIT    equ 0   ;application is beeing asked, to quit itself
.MSC_GEN_FOCUS   equ 255 ;application is beeing asked, to focus its window
.MSC_KRL_MTADDP  equ 1   ;add process (P1/2=stack, P3=priority (7 high - 1 low), P4=ram bank (0-8))
.MSC_KRL_MTDELP  equ 2   ;delete process (P1=ID)
.MSC_KRL_MTADDT  equ 3   ;add timer (P1/2=stack, P4=ram bank (0-8))
.MSC_KRL_MTDELT  equ 4   ;delete timer (P1=ID)
.MSC_KRL_MTSLPP  equ 5   ;set process to sleep mode
.MSC_KRL_MTWAKP  equ 6   ;wake up process
.MSC_KRL_TMADDT  equ 7   ;add counter service (P1/2=address, P3=ram bank, P4=process, P5=frequency)
.MSC_KRL_TMDELT  equ 8   ;delete counter service (P1/2=address, P3=ram bank)
.MSC_KRL_TMDELP  equ 9   ;delete all counter services of one process (P1=process ID)
.MSR_KRL_MTADDP  equ 129 ;process has been added (P1=0/1->ok/failed, P2=ID)
.MSR_KRL_MTDELP  equ 130 ;process has been deleted
.MSR_KRL_MTADDT  equ 131 ;timer process has been deleted (P1=0/1->ok/failed, P2=ID)
.MSR_KRL_MTDELT  equ 132 ;timer has been removed
.MSR_KRL_MTSLPP  equ 133 ;process is sleeping now
.MSR_KRL_MTWAKP  equ 134 ;process has been waked up
.MSR_KRL_TMADDT  equ 135 ;counter service has been added (P1=0/1->ok/failed)
.MSR_KRL_TMDELT  equ 136 ;counter service has been deleted
.MSR_KRL_TMDELP  equ 137 ;all counter services of a process have been deleted
.MSC_SYS_PRGRUN  equ 16  ;load application or document (P1/2=address filename, P3=ram bank filename)
.MSC_SYS_PRGEND  equ 17  ;quit application (P1=ID)
.MSC_SYS_SYSWNX  equ 18  ;open dialogue to change current window (next) (-)
.MSC_SYS_SYSWPR  equ 19  ;open dialogue to change current window (previouse) (vorheriges) (-)
.MSC_SYS_PRGSTA  equ 20  ;open dialogue to load application or document (-)
.MSC_SYS_SYSSEC  equ 21  ;open system secuity dialogue (-)
.MSC_SYS_SYSQIT  equ 22  ;open shut shown dialogue (-)
.MSC_SYS_SYSOFF  equ 23  ;shut down (-)
.MSC_SYS_PRGSET  equ 24  ;start control panel (P1=submodul -> 0=main window, 1=display settings, 2=date/time)
.MSC_SYS_PRGTSK  equ 25  ;start taskmanager (-)
.MSC_SYS_SYSFIL  equ 26  ;call filemanager function (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
.MSC_SYS_SYSHLP  equ 27  ;start help (-)
.MSC_SYS_SYSCFG  equ 28  ;call config function (P1=number, 0=load, 1=save, 2=reload background)
.MSC_SYS_SYSWRN  equ 29  ;open message/confirm window (P1/2=adresse, P3=ram bank, P4=number of buttons)
.MSC_SYS_PRGSRV  equ 30  ;shared service function (P4=type [0=search, 1=start, 2=release], P1/2=addresse 12char ID, P3=ram bank 12char ID or P3=program ID, if type=2)
.MSC_SYS_SELOPN  equ 31  ;open fileselect dialogue (P6=filename ram bank, P8/9=filename address, P7=forbidden attributes, P10=max entries, P12=max buffer size)
.MSR_SYS_PRGRUN  equ 144 ;application has been started (P1=result -> 0=ok, 1=file doesnt exist, 2=file is not executable, 3=error while loading  [P8=filemanager error code], 4=memory full, P8=app ID, P9=process ID)
.MSR_SYS_SYSFIL  equ 154 ;filemanager function returned (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
.MSR_SYS_SYSWRN  equ 157 ;message/confirm window response (P1 -> 0=already in use, 1=opened [P2=number], 2=ok, 3=yes, 4=no, 5=cancel/close)
.MSR_SYS_PRGSRV  equ 158 ;shared service function response (P1=state [5=not found, other codes see MSR_SYS_PRGRUN], P8=app ID, P9=process ID)
.MSR_SYS_SELOPN  equ 159 ;message from fileselect dialogue (P1 -> 0=Ok, 1=cancel, 2=already in use, 3=no memory free, 4=no window free, -1=open ok, modal window has been opened [P2=number])
.MSC_DSK_WINOPN  equ 32  ;open window (P1=ram bank, P2/3=address data record)
.MSC_DSK_WINMEN  equ 33  ;redraw menu bar (P1=window ID) [only if focus]
.MSC_DSK_WININH  equ 34  ;redraw window content (P1=window ID, P2=-1/-Num/Object, P3=Object) [only if focus]
.MSC_DSK_WINTOL  equ 35  ;redraw window toolbar (P1=window ID) [only if focus]
.MSC_DSK_WINTIT  equ 36  ;redraw window title (P1=window ID) [only if focus]
.MSC_DSK_WINSTA  equ 37  ;redraw window status lien (P1=window ID) [only if focus]
.MSC_DSK_WINMVX  equ 38  ;set content x offset (P1=window ID, P2/3=XPos) [only if focus]
.MSC_DSK_WINMVY  equ 39  ;set content y offset (P1=window ID, P2/3=XPos) [only if focus]
.MSC_DSK_WINTOP  equ 40  ;takes window to the front (P1=window ID) [always]
.MSC_DSK_WINMAX  equ 41  ;maximize window (P1=window ID) [always]
.MSC_DSK_WINMIN  equ 42  ;minimize window (P1=window ID) [always]
.MSC_DSK_WINMID  equ 43  ;restore window size (P1=window ID) [always]
.MSC_DSK_WINMOV  equ 44  ;moves window to a new position (P1=window ID, P2/3=XPos, P4/5=YPos) [always]
.MSC_DSK_WINSIZ  equ 45  ;resize the window (P1=window ID, P2/3=XPos, P4/5=YPos) [always]
.MSC_DSK_WINCLS  equ 46  ;closes and removes window (P1=window ID) [always]
.MSC_DSK_WINDIN  equ 47  ;redraw window content, even if it hasnt focus (P1=window ID, P2=-1/-Num/Objekt, P3=Object) [always]
.MSC_DSK_DSKSRV  equ 48  ;desktop service request (P1=type, P2-P5=parameters)
.MSC_DSK_WINSLD  equ 49  ;redraw window scrollbars (P1=window ID) [only if focus]
.MSC_DSK_WINPIN  equ 50  ;redraw window content part (P1=window ID, P2=-1/-Num/Object, P3=Object, P4/5=Xbeg, P6/7=Ybeg, P8/9=Xlen, P10/11=Ylen) [always]
.MSC_DSK_WINSIN  equ 51  ;redraw content of a super control (P1=window ID, P2=super control ID, P3=SubObject) [always]
.MSC_DSK_MENCTX  equ 52  ;opens context menu (P1=ram bank, P2/3=address data record, P4/5=Xbeg [-1=mouse position], P6/7=Ybeg) ##!!## doc+lib
.MSC_DSK_STIADD  equ 53  ;adds systray-icon (P1=ram bank, P2/3=address, P4=ID)
.MSC_DSK_STIREM  equ 54  ;removes systray-icon (P1=number)
.MSC_DSK_STIUPD  equ 55  ;updates systray-icon (P1=number)
.MSC_DSK_CONPOS  equ 56  ;move a virtual control to a new position (P2/3=xpos, P4/5=ypos, P6/7=xlen, P8/9=ylen)
.MSC_DSK_CONSIZ  equ 57  ;resize a virtual control (P2/3=xpos, P4/5=ypos, P6/7=xlen, P8/9=ylen)
.MSR_DSK_WOPNER  equ 160 ;open window failed; the maximum of 32 windows has been reached
.MSR_DSK_WOPNOK  equ 161 ;open window successfull (P4=number)
.MSR_DSK_WCLICK  equ 162 ;window has been clicked (P1=window number, P2=action, P3=subspezification, P4/5,P6/7,P8/9=parameters)
.MSR_DSK_DSKSRV  equ 163 ;desktop service answer (P1=type, P2-P5=parameters)
.MSR_DSK_WFOCUS  equ 164 ;window got/lost focus (P1=window number, P2=type [0=blur, 1=focus])
.MSR_DSK_CFOCUS  equ 165 ;control focus changed (P1=window number, P2=control number, P3=reason [0=mouse click/wheel, 1=tab key])
.MSR_DSK_WRESIZ  equ 166 ;window has been resized (P1=window number)
.MSR_DSK_WSCROL  equ 167 ;window content has been scrolled (P1=window number)
.MSR_DSK_MENCTX  equ 168 ;menu has been clicked or canceld (P1=1 ok, P2/3=value, P4=type [0=normal, 1=check]) ##!!## doc+lib
.MSR_DSK_STIADD  equ 169 ;result of adding systray-icon (P1=1 ok, P2=number)
.MSR_DSK_STICLK  equ 170 ;systray-icon has been clicked (P1=ID)
.MSR_DSK_WMODAL  equ 171 ;Window_ModalUnclick_Response
.MSR_DSK_CONPOS  equ 172 ;virtual control has been moved or canceled (P1=1 ok, P2/3=new xpos, P4/5=new ypos)
.MSR_DSK_CONSIZ  equ 173 ;virtual control has been resized or canceled (P1=1 ok, P2/3=new xlen, P4/5=new ylen)
.MSR_DSK_EXTDSK  equ 191 ;command for extended desktop (used internally; P1=command, P2-x=parameters)
.FNC_DXT_DSKBGR  equ 001 ;background has been updated
.FNC_DXT_FILRUN  equ 002 ;file has been opened via prgrun (P2/3=address, P4=bank)
.FNC_DXT_FILBRW  equ 003 ;file has been selected via file browser (P2/3=address, P4=bank)
.FNC_DXT_MENCLK  equ 004 ;startmenu has been clicked (P2/3=value)
.FNC_DXT_DSKCLK  equ 005 ;desktop window has been clicked (P2=action, P3=subspezification, P4/5,P6/7,P8/9=parameters)
.MSC_SHL_CHRINP  equ 64  ;char is requested (P1=channel [0=standard, 1=keyboard])
.MSC_SHL_STRINP  equ 65  ;line is requested (P1=channel [0=standard, 1=keyboard], P2=ram bank, P3/4=address)
.MSC_SHL_CHROUT  equ 66  ;char should be writtten (P1=channel [0=standard, 1=screen], P2=char)
.MSC_SHL_STROUT  equ 67  ;line should be writtten (P1=channel [0=standard, 1=screen], P2=ram bank, P3/4=address, P5=length)
.MSC_SHL_EXIT    equ 68  ;application released focus or quit itself (P1 -> 0=quit, 1=blur)
.MSC_SHL_PTHADD  equ 69  ;add additional path to current one (P1=base path, P3=addition path, P5=final path, P7=ram bank)
.MSR_SHL_CHRINP  equ 192 ;char has been received (P1=EOF-flag [0=no EOF], P2=char, P3=error status)
.MSR_SHL_STRINP  equ 193 ;line has been received (P1=EOF-flag [0=no EOF], P3=error status)
.MSR_SHL_CHROUT  equ 194 ;char has been written (P3=error status)
.MSR_SHL_STROUT  equ 195 ;line has been written (P3=error status)
.MSR_SHL_PTHADD  equ 197 ;path has been combined (P1=total end address, P3=directory end address, P5=flags)
.MSC_SAV_INIT    equ 1   ;initialises the screen saver (P1=bank of config data, P2/3=address of config data [64bytes])
.MSC_SAV_START   equ 2   ;start screen saver
.MSC_SAV_CONFIG  equ 3   ;open screen savers own config window (at the end the screen saver has to send the result back to the sender)
.MSR_SAV_CONFIG  equ 4   ;returns user adjusted screen saver config data (P1=bank of config data, P2/3=address of config data [64bytes])
.DSK_ACT_CLOSE   equ 5   ;close button has been clicked or ALT+F4 has been pressed
.DSK_ACT_MENU    equ 6   ;menu entry has been clicked (P8/9=menu entry value)
.DSK_ACT_CONTENT equ 14  ;a control of the content has been clicked (P3=sub spec [see dsk_sub...], P4=key or P4/5=Xpos within the window, P6/7=Ypos, P8/9=control value)
.DSK_ACT_TOOLBAR equ 15  ;a control of the toolbar has been clicked (see DSK_ACT_CONTENT)
.DSK_ACT_KEY     equ 16  ;key has been pressed without touching/modifying a control (P4=Ascii Code)
.DSK_SUB_MLCLICK equ 0   ;left mouse button has been clicked
.DSK_SUB_MRCLICK equ 1   ;right mouse button has been clicked
.DSK_SUB_MDCLICK equ 2   ;double click with the left mouse button
.DSK_SUB_MMCLICK equ 3   ;middle mouse button has been clicked
.DSK_SUB_KEY     equ 7   ;keyboard has been clicked and did modify/click a control (P4=Ascii Code)
.DSK_SUB_MWHEEL  equ 8   ;mouse wheel has been moved (P4=Offset)
.DSK_SRV_MODGET  equ 1   ;get screen mode (output P2=mode, P3=virtual desktop)
.DSK_SRV_MODSET  equ 2   ;set screen mode (input P2=mode, P3=virtual desktop)
.DSK_SRV_COLGET  equ 3   ;get colour      (input P2=number, output P2=number, P3/4=RGB value)
.DSK_SRV_COLSET  equ 4   ;set colour      (input P2=number, P3/4=RGB value)
.DSK_SRV_DSKSTP  equ 5   ;freeze desktop  (input P2=type [0=Pen0, 1=Raster, 2=background, 255=no screen modification, switch off mouse])
.DSK_SRV_DSKCNT  equ 6   ;continue desktop
.DSK_SRV_DSKPNT  equ 7   ;clear desktop   (Eingabe P2=Typ [0=Pen0, 1=Raster, 2=background])
.DSK_SRV_DSKBGR  equ 8   ;initialize and redraw desktop background
.DSK_SRV_DSKPLT  equ 9   ;redraw the complete desktop
.DSK_SRV_DSKOPN  equ 11  ;open desktop background window
.CLPTYP_TEXT     equ 1   ;plain text
.CLPTYP_GRAPHIC  equ 2   ;graphic with extended header
.CLPTYP_ITEMS    equ 3   ;item list (*not defined yet*)
.CLPTYP_ICON     equ 4   ;desktop icon shortcut
.jmp_memsum  equ #8100 ;MEMSUM
.jmp_sysinf  equ #8103 ;SYSINF
.jmp_clcnum  equ #8106 ;CLCNUM
.jmp_mtgcnt  equ #8109 ;MTGCNT
.jmp_timget  equ #810C ;TIMGET
.jmp_timset  equ #810F ;TIMSET
.jmp_memget  equ #8118 ;MEMGET
.jmp_memfre  equ #811B ;MEMFRE
.jmp_memsiz  equ #811E ;MEMSIZ
.jmp_meminf  equ #8121 ;MEMINF
.jmp_bnkrwd  equ #8124 ;BNKRWD
.jmp_bnkwwd  equ #8127 ;BNKWWD
.jmp_bnkrbt  equ #812A ;BNKRBT
.jmp_bnkwbt  equ #812D ;BNKWBT
.jmp_bnkcop  equ #8130 ;BNKCOP
.jmp_bnkget  equ #8133 ;BNKGET
.jmp_scrset  equ #8136 ;SCRSET (cpc only)
.jmp_scrget  equ #8139 ;SCRGET
.jmp_mosget  equ #813C ;MOSGET
.jmp_moskey  equ #813F ;MOSKEY
.jmp_bnk16c  equ #8142 ;BNK16C
.jmp_keytst  equ #8145 ;KEYTST
.jmp_keysta  equ #8148 ;KEYSTA
.jmp_keyput  equ #814B ;KEYPUT
.jmp_bufput  equ #814E ;BUFPUT
.jmp_bufget  equ #8151 ;BUFGET
.jmp_bufsta  equ #8154 ;BUFSTA
.jmp_iominp  equ #8157 ;IOMINP (cpc only)
.jmp_iomout  equ #815A ;IOMOUT (cpc only)
.jmp_txtlen  equ #815D ;TXTLEN
.jmp_keymul  equ #8160 ;KEYMUL
.jmp_g9kfnc  equ #8163 ;G9KFNC (g9k only)
.jmp_bnkret  equ #ff00 ;BNKRET
.jmp_bnkcll  equ #ff03 ;BNKCLL
.jmp_bnkcpr  equ #ff06 ;BNKCPR
.jmp_bnklok  equ #ff09 ;BNKLOK
.jmp_bnkrel  equ #ff0c ;BNKREL
.FNC_FIL_STOINI  equ 000 ;Storage Init (Removes all mass storage devices)
.FNC_FIL_STONEW  equ 001 ;Storage New (Adds a new mass storage device)
.FNC_FIL_STORLD  equ 002 ;Storage Reload (Reloads a mass storage device, if its "removeable media" status is activated)
.FNC_FIL_STODEL  equ 003 ;Storage Delete (Removes an existing mass storage device)
.FNC_FIL_STOINP  equ 004 ;Storage ReadSector (Reads a sector from a mass storage device (no memory banking))
.FNC_FIL_STOOUT  equ 005 ;Storage WriteSector (Write a sector to a mass storage device (no memory banking))
.FNC_FIL_STOACT  equ 006 ;Storage Activate (Loads the format and the file system type of a mass storage device)
.FNC_FIL_STOINF  equ 007 ;Storage Information (Returns information about a mass storage device)
.FNC_FIL_STOTRN  equ 008 ;Storage DataTransfer (Reads or writes a number of sectors (512 bytes) from/to the mass storage device)
.FNC_FIL_DEVDIR  equ 013 ;
.FNC_FIL_DEVINI  equ 014 ;
.FNC_FIL_DEVSET  equ 015 ;
.FNC_FIL_FILINI  equ 016 ;File Init (Initialises the whole file manager)
.FNC_FIL_FILNEW  equ 017 ;File New (Creates a new file and opens it for read/write access)
.FNC_FIL_FILOPN  equ 018 ;File Open (Opens an existing file for read/write access)
.FNC_FIL_FILCLO  equ 019 ;File Close (Closes an opened file)
.FNC_FIL_FILINP  equ 020 ;File Input (Reads a specified amount of bytes out of an opened file)
.FNC_FIL_FILOUT  equ 021 ;File Output (Writes a specified amount of bytes into an opened file)
.FNC_FIL_FILPOI  equ 022 ;File Pointer (Moves the file pointer to another position)
.FNC_FIL_FILF2T  equ 023 ;File Decode Timestamp (Decodes the file timestamp, which is used for the file system)
.FNC_FIL_FILT2F  equ 024 ;File Encode Timestamp (Encodes the file timestamp, which is used for the file system)
.FNC_FIL_FILLIN  equ 025 ;File LineInput (Reads one text line out of an opened file)
.FNC_FIL_FILCPR  equ 026 ;File Compressed (Reads from a compressed or uncompressed part of an opened file)
.FNC_FIL_DIRDEV  equ 032 ;Directory Device (Selects the current drive)
.FNC_FIL_DIRPTH  equ 033 ;Directory Path (Selects the current path for the current or a different drive)
.FNC_FIL_DIRPRS  equ 034 ;Directory Property Set (Changes a property of a file or a directory)
.FNC_FIL_DIRPRR  equ 035 ;Directory Property Get (Reads a property of a file or a directory)
.FNC_FIL_DIRREN  equ 036 ;Directory Rename (Renames a file or a directory)
.FNC_FIL_DIRNEW  equ 037 ;Directory New (Creates a new directory)
.FNC_FIL_DIRINP  equ 038 ;Directory Input (Reads the content of a directory)
.FNC_FIL_DIRDEL  equ 039 ;Directory Delete (Deletes one or more files)
.FNC_FIL_DIRRMD  equ 040 ;Directory Delete Directory (Deletes a sub directory)
.FNC_FIL_DIRMOV  equ 041 ;Directory Move (Moves a file or sub directory into another directory of the same drive)
.FNC_FIL_DIRINF  equ 042 ;Directory Drive Information (Returns information about one drive)
.FNC_NET_CFGGET  equ 001 ;config information
.FNC_NET_CFGSET  equ 002 ;config setting
.FNC_NET_TCPOPN  equ 016 ;TCP open
.FNC_NET_TCPCLO  equ 017 ;TCP close
.FNC_NET_TCPSTA  equ 018 ;TCP status
.FNC_NET_TCPRCV  equ 019 ;TCP receive
.FNC_NET_TCPSND  equ 020 ;TCP send
.FNC_NET_TCPSKP  equ 021 ;TCP skip received data
.FNC_NET_TCPFLS  equ 022 ;TCP flush send buffer
.FNC_NET_TCPDIS  equ 023 ;TCP disconnect
.MSR_NET_TCPEVT  equ 159 ;TCP event
.FNC_NET_UDPOPN  equ 032 ;UDP open
.FNC_NET_UDPCLO  equ 033 ;UDP close
.FNC_NET_UDPSTA  equ 034 ;UDP status
.FNC_NET_UDPRCV  equ 035 ;UDP receive
.FNC_NET_UDPSND  equ 036 ;UDP send
.FNC_NET_UDPSKP  equ 037 ;UDP skip received data
.MSR_NET_UDPEVT  equ 175 ;UDP event
.FNC_NET_DNSRSV  equ 112 ;DNS resolve
.FNC_NET_DNSVFY  equ 113 ;DNS verify
.PrgDatCod     equ 0	;Code Length including 256 Header
.PrgDatDat     equ 2	;Data Length to a maximum 16k
.PrgDatTra     equ 4   ;Transfer Part Length
.PrgDatOrg     equ 6   ;Original ORG
.PrgDatRel     equ 8   ;Number of Entries in Relocation Table
.PrgDatStk     equ 10  ;Stack Length at start of Transfer
.PrgDatCrn     equ 12	;Crunched Length
.PrgDatCtp     equ 14	;Crunch Typ
.PrgDatNam     equ 15	;Program Name (Always 32 Bytes)+0 33 Byte
.PrgDatIdn     equ 48  ;SymExe10
.PrgDatRes     equ 62  ;Reserve
.PrgDatIsm     equ 90  ;Small Ico
.PrgDatIbg     equ 109 ;Big Ico
.PrgDatVer     equ 88  ;Version 3
.PrgDatLen     equ 256 ;
.PrgPstDat     equ 6   ;
.PrgPstTra     equ 8   ;
.PrgPstSpz     equ 10  ;
.PrgPstBnk     equ 14  ;
.PrgPstMem     equ 48  ;
.PrgPstNum     equ 88  ;
.PrgPstPrz     equ 89  ;
.ScanCode_E	equ 45
.CG9K_VRAM				equ	#ff60			; R/W
.g9k_PALETTE			equ	#61				; R/W
.CG9K_PALETTE			equ	#ff61				; R/W
.g9k_CMD_DATA			equ	#62				; R/W
.g9k_REG_DATA			equ	#63				; R/W
.CG9K_REG_DATA			equ	#ff63			; R/W
.CG9K_REG_SELECT		equ	#ff64			; W
.CG9K_STATUS			equ	#ff65			; R
.CG9K_INT_FLAG			equ	#ff66				; R/W
.g9k_SYS_CTRL			equ	#67				; W
.g9k_OUTPUT_CTRL		equ	#6F 		    ; R/W
.CG9K_OUTPUT_CTRL		equ	#ff6F 		    ; R/W
.g9k_SYS_CTRL_SRS		equ	2				; Power on reset state
.g9k_SYS_CTRL_MCKIN		equ	1				; Select MCKIN terminal
.g9k_SYS_CTRL_XTAL		equ	0				; Select XTAL
.g9k_WRITE_ADDR			equ	0				; W
.g9k_READ_ADDR			equ	3				; W
.g9k_SCREEN_MODE0		equ	6				; R/W
.g9k_SCREEN_MODE1		equ 7				; R/W
.g9k_CTRL				equ	8				; R/W
.g9k_INT_ENABLE         equ 9       		; R/W
.g9k_INT_V_LINE_LO		equ	10				; R/W	
.g9k_INT_V_LINE_HI		equ	11				; R/W
.g9k_INT_H_LINE			equ	12				; R/W	
.g9k_PALETTE_CTRL		equ	13				; W
.g9k_PALETTE_PTR		equ	14				; W
.g9k_BACK_DROP_COLOR 	equ 15		      	; R/W
.CG9K_BACK_DROP_COLOR 	equ 15		      	; R/W
.g9k_DISPLAY_ADJUST		equ	16				; R/W
.g9k_SCROLL_LOW_Y		equ 17 			    ; R/W
.g9k_SCROLL_HIGH_Y		equ 18      		; R/W
.g9k_SCROLL_LOW_X		equ 19      		; R/W
.g9k_SCROLL_HIGH_X		equ 20      		; R/W
.g9k_SCROLL_LOW_Y_B		equ 21 				; R/W
.g9k_SCROLL_HIGH_Y_B	equ 22      		; R/W
.g9k_SCROLL_LOW_X_B		equ 23      		; R/W
.g9k_SCROLL_HIGH_X_B	equ 24      		; R/W
.g9k_PAT_GEN_TABLE   	equ 25      		; R/W
.g9k_LCD_CTRL        	equ 26      		; R/W
.g9k_PRIORITY_CTRL  	equ 27      		; R/W
.g9k_SPR_PAL_CTRL		equ	28				; W
.g9k_SC_X				equ	32				; W
.CG9K_SC_A				equ 32				; W
.g9k_SC_Y				equ	34				; W
.g9k_DS_X				equ	36				; W
.g9k_DS_Y				equ	38				; W
.g9k_NX					equ	40				; W
.g9k_NY					equ	42				; W
.g9k_ARG				equ	44				; W
.g9k_LOP				equ	45				; W
.g9k_WRITE_MASK			equ	46				; W
.g9k_FC					equ	48				; W
.g9k_BC					equ	50				; W
.g9k_OPCODE				equ	52				; W
.g9k_DIS_INC_READ		equ	64
.g9k_DIS_INC_WRITE		equ	128
.g9k_SCR0_STANDBY		equ	192				; Stand by mode
.g9k_SCR0_BITMAP		equ	128				; Select Bit map mode
.g9k_SCR0_P2			equ	64				; Select P1 mode
.g9k_SCR0_P1			equ	0				; Select P1 mode
.g9k_SCR0_DTCLK			equ	32				; Master Dot clock not divided
.g9k_SCR0_DTCLK2		equ	16				; Master Dot clock divided by 2
.g9k_SCR0_DTCLK4		equ	0				; Master Dot clock divided by 4
.g9k_SCR0_XIM2048		equ	12				; Image size = 2048
.g9k_SCR0_XIM1024		equ	8				; Image size = 1024
.g9k_SCR0_XIM512		equ	4				; Image size = 512
.g9k_SCR0_XIM256		equ	0				; Image size = 256
.g9k_SCR0_16BIT			equ	3				; 16 bits/dot
.g9k_SCR0_8BIT			equ	2				; 8 bits/dot
.g9k_SCR0_4BIT			equ	1				; 4 bits/dot
.g9k_SCR0_2BIT			equ 0				; 2 bits/dot
.g9k_SCR1_C25M			equ	64				; Select 640*480 mode
.g9k_SCR1_SM1			equ	32				; Selection of 263 lines during non interlace , else 262
.g9k_SCR1_SM			equ	16				; Selection of horizontal frequency 1H=fsc/227.5
.g9k_SCR1_PAL			equ	8				; Select PAL, else NTSC
.g9k_SCR1_EO			equ	4				; Select of vertical resoltion of twice the non-interlace resolution
.g9k_SCR1_IL			equ	2				; Select Interlace
.g9k_SCR1_HSCN			equ	1				; Select High scan mode
.g9k_CTRL_DISP			equ	128				; Display VRAM
.g9k_CTRL_DIS_SPD		equ	64				; Disable display sprite (cursor)
.g9k_CTRL_YSE			equ	32				; /YS Enable
.g9k_CTRL_VWTE			equ	16				; VRAM Serial data bus control during digitization
.g9k_CTRL_VWM			equ	8				; VRAM write control during digitization
.g9k_CTRL_DMAE			equ	4				; Enable DMAQ output
.g9k_CTRL_VRAM512		equ	2				; VRAM=512KB
.g9k_CTRL_VRAM256		equ	1				; VRAM=256KB
.g9k_CTRL_VRAM128		equ	0				; VRAM=128KB
.g9k_INT_IECE	        equ 4       		; Command end interrupt enable control
.g9k_INT_IEH	        equ 2       		; Display position interrupt enable
.g9k_INT_IEV	        equ 1       		; Int. enable during vertical retrace line interval
.g9k_PAL_CTRL_YUV		equ	192				; YUV mode
.g9k_PAL_CTRL_YJK		equ	128				; YJK mode
.g9k_PAL_CTRL_256		equ	64				; 256 color mode
.g9k_PAL_CTRL_PAL		equ	0				; Pallete mode
.g9k_PAL_CTRL_YAE		equ	32				; Enable YUV/YJK RGB mixing mode
.g9k_LOP_TP				equ	16
.g9k_LOP_WCSC			equ	12
.g9k_LOP_WCNOTSC		equ	3
.g9k_LOP_WCANDSC		equ	8
.g9k_LOP_WCORSC			equ	14
.g9k_LOP_WCEORSC		equ	6
.g9k_ARG_MAJ			equ	1
.g9k_ARG_NEG			equ	2
.g9k_ARG_DIX			equ	4
.g9k_ARG_DIY			equ	8
.g9k_OPCODE_STOP		equ	#00				; Command being excuted is stopped 
.g9k_OPCODE_LMMC		equ	#10     		; Data is transferred from CPU to VRAM rectangle area
.g9k_OPCODE_LMMV		equ	#20     		; VRAM rectangle area is painted out
.g9k_OPCODE_LMCM		equ	#30				; VRAM rectangle area is transferred to CPU
.g9k_OPCODE_LMMM		equ	#40				; Rectangle area os transferred from VRAM to VRAM
.g9k_OPCODE_CMMC		equ	#050			; CPU character data is color-developed and transferred to VRAM rectangle area
.g9k_OPCODE_CMMK		equ	#060			; Kanji ROM data is is color-developed and transferred to VRAM rectangle area
.g9k_OPCODE_CMMM		equ	#070			; VRAM character data is color-developed and transferred to VRAM rectangle area 
.g9k_OPCODE_BMXL		equ	#080			; Data on VRAM linear address is transferred to VRAM rectangle area
.g9k_OPCODE_BMLX		equ	#090			; VRAM rectangle area is transferred to VRAM linear address 
.g9k_OPCODE_BMLL		equ	#0A0			; Data on VRAM linear address is transferred to VRAM linear address 
.g9k_OPCODE_LINE		equ	#0B0			; Straight line is drawer on X-Y co-ordinates
.g9k_OPCODE_SRCH		equ	#0C0			; Border color co-ordinates on X-Y are detected
.g9k_OPCODE_POINT		equ	#0D0			; Color code on specified point on X-Y is read out
.g9k_OPCODE_PSET		equ	#0E0			; Drawing is executed at drawing point on X-Y co-ordinates
.g9k_OPCODE_ADVN		equ	#0F0			; Drawing point on X-Y co-ordinates is shifted
.g9k_STATUS_TR          equ 128
.g9k_STATUS_VR          equ 64
.g9k_STATUS_HR          equ 32
.g9k_STATUS_BD          equ 16
.g9k_STATUS_MSC         equ 4
.g9k_STATUS_EO          equ 2
.g9k_STATUS_CE          equ 1
.g9k_MODE_P1			equ	0				; Pattern mode 0 256 212
.g9k_MODE_P2			equ	1				; Pattern mode 1 512 212
.g9k_MODE_B1			equ	2				; Bitmap mode 1 256 212
.g9k_MODE_B2			equ	3				; Bitmap mode 2 384 240
.g9k_MODE_B3			equ	4				; Bitmap mode 3 512 212
.g9k_MODE_B4			equ	5				; Bitmap mode 4 768 240
.g9k_MODE_B5			equ	6				; Bitmap mode 5 640 400 (VGA)
.g9k_MODE_B6			equ	7				; Bitmap mode 6 640 480 (VGA)
.g9k_MODE_B7			equ	8				; Bitmap mode 7 1024 212 (Undocumented v9990 mode)
.g9k_RED                 equ 32
.g9k_GREEN               equ 1024
.g9k_BLUE                equ 1
.FNC_SND_SNDINF  equ 001 ;ask for sound information
.FNC_SND_SNDCOO  equ 003 ;cooperation with SymAmp/3rd party sound players
.FNC_SND_RMTCTR  equ 005 ;remote control
.FNC_SND_RMTACT  equ 006 ;activates remote playing
.FNC_SND_RMTDCT  equ 007 ;deactivates remote playing
.FNC_SND_MUSLOD  	equ 008 	;loads and inits music data
.FNC_SND_MUSFRE  	equ 009 	;removes music data
.FNC_SND_MUSRST  	equ 010 	;restarts a music
.FNC_SND_MUSCON  	equ 011 	;continues a music
.FNC_SND_MUSSTP  	equ 012 	;pauses music and mutes device
.FNC_SND_MUSVOL  	equ 013 	;sets music volume
.FNC_SND_EFXLOD  	equ 016 	;loads and inits effect data
.FNC_SND_EFXFRE  	equ 017 	;removes effect data
.FNC_SND_EFXPLY  	equ 018 	;plays an effect
.FNC_SND_EFXSTP  	equ 019 	;stops effects
.FNC_SND_EFXEVT  	equ 023 	;play event specific effect
.MSR_SND_SNDINF  	equ 129 	;returns sound information
.MSR_SND_MUSLOD  	equ 136 	;music  loading success state
.MSR_SND_EFXLOD  	equ 144 	;effect loading success state
.SND_EVT_NHINT   	equ 0   ;Notification - hint
.SND_EVT_NWARN   	equ 1   ;Notification - warning
.SND_EVT_NMESSG  	equ 2   ;Notification - message
.SND_EVT_WOPEN   	equ 3   ;Window - open
.SND_EVT_WTOP    	equ 4   ;Window - top
.SND_EVT_WRESTO  	equ 5   ;Window - restore
.SND_EVT_WMAX    	equ 6   ;Window - maximize
.SND_EVT_WMIN    	equ 7   ;Window - minimize
.SND_EVT_WCLOSE  	equ 8   ;Window - close
.SND_EVT_MOPEN   	equ 9   ;Menu - open
.SND_EVT_MHOVER  	equ 10  ;Menu - entry hover
.SND_EVT_MCLICK  	equ 11  ;Menu - entry clicked
.SND_EVT_CBUTTN  	equ 12  ;Click - button/tab/check/radio
.SND_EVT_CBITMP  	equ 13  ;Click - bitmap
.SND_EVT_CSLIDR  	equ 14  ;Click - slider
.SND_EVT_CLIST   	equ 15  ;Click - list
.SND_EVT_CTEXT   	equ 16  ;Click - text
.SND_SYS_CLICK1  	equ 1   ;Click 1
.SND_SYS_CLICK2  	equ 2   ;Click 2
.SND_SYS_BEEP1   	equ 3   ;Beep 1
.SND_SYS_BEEP2   	equ 4   ;Beep 2
.SND_SYS_RING1   	equ 5   ;Ring 1
.SND_SYS_RING2   	equ 6   ;Ring 2
.SND_SYS_ALERT1  	equ 7   ;Alert 1
.SND_SYS_ALERT2  	equ 8   ;Alert 2
.SND_SYS_SLIDR1  	equ 9   ;Slide 1
.SND_SYS_SLIDR2  	equ 10  ;Slide 2
.SND_SYS_RAISEU  	equ 11  ;Raise up
.SND_SYS_RAISED  	equ 12  ;Raise down
.SND_SYS_POPUP   	equ 13  ;Pop up
.SND_SYS_SHRINK  	equ 14  ;Shrink
.SND_SYS_TIC1    	equ 15  ;Tic 1
.SND_SYS_TIC2    	equ 16  ;Tic 2
.SND_SYS_SHOOT   	equ 17  ;Shoot
.SND_SYS_EXPLOS  	equ 18  ;Explosion
.SND_SYS_STEP    	equ 19  ;Step
.SND_SYS_LOSE    	equ 20  ;Lose
.SND_SYS_WIN     	equ 21  ;Win
SYMBOS_ORG #100
.AppCodBeg     dw  AppDatBeg-AppCodBeg      ;Length of Cod
.AppDataSize   dw  AppTrnBeg-AppDatBeg      ;Length of Dat
.AppTrnSize    dw  AppTrnEnd-AppTrnBeg      ;Length of Transfe
.AppDatAdr     dw  #100                     ;Original Origi
.AppTrnAdr     dw  0                        ;Number of Entries In Relocation Tabl
.AppPrzLst     dw  AppStk-AppTrnBeg         ;Stack Lengt
               dw  0                        ;Length of Crunched Dat
.AppBnkNum     db  0                        ;Crunch Typ
.AppNam        db  "Dot box                 ",0
.AppIcon16     db  1
.AppIconOff    dw  Icon24_Data-AppCodBeg
.Appxxxx       db  0,0,0,0,0
.AppMemTab     db  "SymExe10"             ;File Check
.AppDataLen    equ  AppTrnBeg-AppDatBeg      ;Length of Data
.AppTrnLen     equ  AppTrnEnd-AppTrnBeg      ;Length of Transfer
.AppDataASz    equ  16000
.AppTrnLen2    equ  16000-AppTrnLen
.AppDataLen2   equ  AppDataASz-AppDataLen
.AppExtCode    dw  0
.AppExtData    dw  AppDataLen2
.AppExtTrans   dw  AppTrnLen2
               ds  26
.AppSymMinor   db  1
.AppSymMajor   db  3
.AppIcnSml    
.AppStartForm  equ 3
        db 2,8,8
      db     15,15,14,3,13,13,73,73,73,73,75,75,60,135,15,15
.AppIcnBig    
.AppIcnLrg       db 6,24,24
             db 255,255,255,255,255,255
             db 136,0,0,0,0,17
             db 136,0,16,224,0,17
             db 136,16,225,30,128,17
             db 136,33,15,15,104,17
             db 136,67,15,15,30,17
             db 136,135,30,135,30,17
             db 136,135,44,67,30,17
             db 152,15,72,33,30,17
             db 152,15,72,33,30,17
             db 152,15,72,33,30,17
             db 152,15,72,67,44,17
             db 152,15,60,135,44,17
             db 152,15,15,15,72,17
             db 136,135,15,15,192,17
             db 136,67,15,30,0,17
             db 136,48,195,15,128,17
             db 136,0,33,15,120,145
             db 136,0,16,15,15,145
             db 136,0,0,135,15,145
             db 136,0,0,67,15,145
             db 136,0,0,48,240,145
             db 136,0,0,0,0,17
             db 255,255,255,255,255,255
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3
.V_App_In_Use			db 	0
.AppPrz:
		ld		hl,AppTrnEnd+260
		ld		a,h
		ld		(Quig_String_AS_HByte),a		;Set Byte so we can check if string is in String area or String buffer
		ld		hl,jmp_sysinf        ;*** get computer type
        ld		de,256+5
        ld 		ix,Quig_Machine_Type
        ld 		iy,66+2+6+8
        rst 	#28
		ld		a,(Quig_Machine_Type)
		and		31
		ld		(Quig_Machine_Type),a
		ld		a,AppStartForm					;**** Form to Open first
		ld		l,a
		ld		h,0
		call	Quig_Form_Open					;**** Form Opener
.Quig_Control_Loop:
		ld		a,(V_App_In_Use)
		And		a
		jr		nz,Quig_Control_Loop_1
		rst		#30								;Wait for message
		ld		a,(AppPrzN)		
       	db		#dd:ld l,a
		db		#dd:ld h,-1
 		ld		iy,AppMsgB
		rst		#18
		db		#dd:dec l						;AppMsgB should be populated
		jr		nz,Quig_Control_Loop_2			;No Message so just run Main()code.	
		ld		a,(AppMsgB+0)					
		or		a
		jp		z,Quig_End
		scf
		cp		MSR_DSK_WCLICK					;**** Click on a Control
		jp		z,Quig_Control_Event
		cp		MSR_DSK_WRESIZ					;**** Resize window ?
		jp		z,Quig_Form_Event_Resize
		cp		MSR_DSK_WSCROL					;**** Scrolled Form ?
		jp		z,Quig_Form_Event_Scroll
		cp		MSR_DSK_WFOCUS					;**** Focus window change ?
		jp		z,Quig_Form_Event_Window_Focus
		cp		MSR_DSK_CFOCUS					;**** Focus change ?
		jp		z,Quig_Form_Event_Focus	
		cp		MSR_DSK_WMODAL					;**** Clicked form blocked by a Modal
		jp		z,Quig_Form_Event_PopUp
.Quig_Control_Loop_2:
		call	qfunc_main
.Quig_Control_Loop_1:
		Xor		a
		ld		(V_App_In_Use),a	
		jp		Quig_Control_Loop
.Quig_DataAddr:				dw 	0
.Quig_Math_StackPointer:	dw	Quig_Math_Stack
.Quig_Math_Stack:			ds	60
.Quig_Math_StackTop:
.Quig_Control_Event:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		a,(Event_Type)	 		
 		cp		DSK_ACT_CONTENT
 		jp		z,Quig_Content
 		cp		DSK_ACT_TOOLBAR
 		jp		z,Quig_Tool		
		cp		DSK_ACT_CLOSE
		jp		z,Quig_Form_CloseEvent
		cp		DSK_ACT_MENU
 		jp		z,Quig_Menu
		cp		DSK_ACT_KEY
		jp		z,Quig_Key
		jp		Quig_Control_Loop_2
.Quig_Form_Event_PopUp:
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch		
		ld		hl,Quig_FormClickOff
		ld		d,0
		add		hl,de
		ld		a,(hl)
		and		a
		jp		z,Quig_Control_Loop_1
		ld		l,e
		ld		h,0
		call	Quig_Form_Close		
		jp		Quig_Control_Loop_1		
.Quig_Form_Event_Window_Focus:
		ld		a,(Quig_Form_Focus)				;Focus Event Happened
		inc		a								;Inc
		ld		(Quig_Form_Focus),a				;Store 
		jp		Quig_Control_Loop_1				;Return
		ld		a,(Event_Type)
		and		a
		jr		z,Quig_Form_Event_Window_FocusLost
		call	Quig_FormSearch
		ld		a,e
		jr		Quig_Form_Event_Window_Focus2
.Quig_Form_Event_Window_FocusLost:
		ld		a,255
.Quig_Form_Event_Window_Focus2:		
		ld		(Quig_Form_Focus),a
		jp		Quig_Control_Loop_1
.Quig_Form_Focus:	db	0		
.Quig_Form_Event_Focus:
		ld		a,5
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Scroll
		ld		a,4
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Resize
		ld		a,3
.Quig_Form_Event_X:		
		ld		(Quig_Form_Event_X_1+1),a
		call	Quig_FormSearch
		ld		a,e
.Quig_Form_Event_X_1
		ld		c,0								;**** C = 3/4 etc
		call	SyB_Call_Form_Event
		jp		Quig_Control_Loop_1
.Quig_Key:
		ld		a,(AppMsgB+4)
		and		%10000000
		jp		Quig_Control_Loop_2
.Quig_Menu:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		hl,(AppMsgB+8)
		Xor		a
		cp		h
		jr		nz,Quig_Call_Set12
		cp		l
		jp		z,Quig_Control_Loop_1
.Quig_Call_Set12
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld		(Quig_Call_Set2+1),hl
.Quig_Call_Set2:
		call	0
		pop		iy
		pop		ix		
		jp		Quig_Control_Loop_1
.Quig_Tool:
		ld		hl,ControWindowDataList+2
		Jr		Quig_Content2
.Quig_Content:
		ld		hl,ControWindowDataList
.Quig_Content2:
		push	hl	
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch
		ld		l,e
		ld		h,0
		add		hl,hl
		add		hl,hl	
		pop		de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(Event_Control_ID)
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		inc		hl
		inc		hl	
		ld		a,(hl)					;Get the Type
		cp		43						;Is it MultiList (Sorting)
		jr		nz,Quig_Content6		;No Then Skip
		push	hl						;Store HL for return
		inc		hl
		inc		hl
		ld		e,(hl)					;Address of ExtData for List
		inc		hl
		ld		d,(hl)
		push	de						;Push Address min DE
		pop		ix						;Return Address in IX
		call	Quig_srtfix				;DO sort routine if necessary
		pop		hl						;Restore HL
.Quig_Content6:
		ld		de,12
		add		hl,de
		ld		e,(hl)
		inc 	hl
		ld		d,(hl)
		Xor		a
		cp		e
		jp		nz,Quig_Content_Event_1
		cp		d
		jp		nz,Quig_Content_Event_1
		jp		Quig_Control_Loop
.Quig_Content_Event_1:
		Xor		a
		ld		(V_App_In_Use),a
		ld		(Quig_Content_Event_2+1),de
.Quig_Content_Event_2
		call	0
		jp		Quig_Control_Loop_1	
.rhht:	db	0		
.Quig_End:
.Quig_End_X2:	
		ld		a,(AppPrzN)
		db		#dd:ld l,a
		ld		a,(SysPrzN)
		db		#dd:ld h,a
		ld		a,(AppCodBeg+PrgPstNum)
		ld		h,a
		ld		l,MSC_SYS_PRGEND
		ld		(AppMsgB),hl
		ld		iy,AppMsgB
		rst		#10
.Quig_End_1
 		rst		#30
		jr		Quig_End_1
.prgwin:db 0
.prgwin2:db 0
.Quig_Form_Open:
		ld		a,l
		ld		(prgwin),a
		ld		de,Quig_FormIDs					;**** 8 Forms held as Symbos Window numbers	
		add		hl,de
		ld		a,(hl)
		cp		255
		ret		nz								;If Not 255 then already open
		push	hl
.Quig_Form_Open_90:
		ld		a,(prgwin)						;**** A = SymStudio Window Number			
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	Quig_GetWindowEventAddr			;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Window Data
		ld		a,(AppBnkNum)
		call	SyDesktop_WINOPN
		pop		hl
		ret		c								;**** If Carry then hasn't Opened window
.Quig_Form_Open_91:
		ld		(hl),a							;**** Store Internal number into form list
		ld		(prgwin2),a
		ld		a,(prgwin)
		ld		c,1								;**** C = 1 = Get Open Address
		call	SyB_Call_Form_Event
		Xor		a		
		ret
.Quig_Form_Close:
		ld		a,255
		ld		de,Quig_FormIDs					;**** 8 Forms held as Symbos Window numbers
		add		hl,de							;**** Works out place
		ld		c,(hl)							;**** C = Symbos Window number
		cp		c
		ret  	z
		ld		(hl),a							;**** Blank window
		ld		a,c								;**** A= Symbos window number
		ld 		c,MSC_DSK_WINCLS				;**** Close
        jp		SyDesktop_SendMessage		
.Quig_Form_CloseEvent
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch
		ld		a,e		
		ld		c,2								;**** C = 3/4 etc
		call	SyB_Call_Form_Event
		jp		Quig_Control_Loop_1	
.SyB_Call_Form_Event:
		call	Quig_GetWindowEventAddr
		Xor		a
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		cp		e		
		jr		nz,SyB_Call_Form_Event_2	
		cp		d
		ret		z
.SyB_Call_Form_Event_2	
		ld		(SyB_Call_Form_Event_3+1),de
.SyB_Call_Form_Event_3
		call	0
		ret	
.Quig_Form_Return
		ld		hl,Quig_FormIDs					;**** Point to Start of Window List
		ld		e,a								;**** DE = A
		ld		d,0
		add		hl,de							;**** Calc Position
		ld		a,(hl)							;**** Checks if exists
		ret
.Quig_FormSearch:
		ld		a,(Event_Form_ID)
		ld		b,8
		ld		e,0
		ld		hl,Quig_FormIDs	
.Quig_FormSearch_1	
		cp		(hl)
		ret		z
		inc		e
		inc		hl
		djnz	Quig_FormSearch_1
		ret		
.Quig_srtfix:
		bit 	0,(ix+15)
        ret 	z
        ld 		(ix+15),0
        ld 		l,(ix+0)
        ld 		h,(ix+1)            ;hl=number of lines
        ld 		e,(ix+4)
        ld 		d,(ix+5)
        push 	de                 	;(sp)=cell records
        ld 		e,(ix+10)
        ld 		d,(ix+11)
        push 	de
        pop 	iy                  ;iy=column records
        ld 		b,(ix+8)            ;b=number of columns
        pop 	ix                  ;ix=cell records
.Quig_srtfix1:
		push 	bc         			;** line loop
        push 	iy
        inc 	ix
        inc 	ix
.Quig_srtfix2:
		ld 		a,(iy+0)     		;** column loop
        and 	#1c
        jr 		nz,Quig_srtfix3
        ld 		e,(ix+0)
        ld 		d,(ix+1)
        dec 	de                  ;**??** IS THAT HERE??
		dec		de
		dec		de
        ld 		a,ixh
        ld 		(de),a              ;correct address-H
        dec 	de
        ld 		a,ixl
        ld 		(de),a              ;correct address-L
.Quig_srtfix3:
		inc 	ix
        inc 	ix
        ld 		de,8
        add 	iy,de
        djnz 	Quig_srtfix2
        pop 	iy
        pop 	bc
        dec 	hl
        ld 		a,l
        or 		h
        jr 		nz,Quig_srtfix1
        ret
.SySystem_CallFunction
		ld (AppMsgB+04),bc      ;copy registers into the message buffer
        ld (AppMsgB+06),de
        ld (AppMsgB+08),hl
        ld (AppMsgB+10),ix
        ld (AppMsgB+12),iy
        push af
        pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ld (AppMsgB+00),de      ;module und funktion number
        ld a,e
        ld (SyCallN),a
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #10                 ;send message
.SyCall1 rst #30
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #18                 ;wait for answer
        db #dd:dec l
        jr nz,SyCall1
        ld a,(AppMsgB)
        sub 128
        ld e,a
        ld a,(SyCallN)
        cp e
        jr nz,SyCall1
        ld hl,(AppMsgB+02)      ;get registers out of the message buffer
        push hl
        pop af
        ld bc,(AppMsgB+04)
        ld de,(AppMsgB+06)
        ld hl,(AppMsgB+08)
        ld ix,(AppMsgB+10)
        ld iy,(AppMsgB+12)
        ret
.SyCallN db 0		
.Quig_GetWindowEventAddr
		add		a				;Times 2
		add		a				;Times 4
		add		a				;Times 8
		add		c				;Event
		add		a				;Times 16 + (Event*2)
		ld		hl,App_Form_List
		ld		e,a
		ld		d,0
		add		hl,de
		ret
.Quig_FormIDs:				db  255,255,255,255,255,255,255,255
.Quig_FormClickOff:			db  0,0,0,0,0,0,0,0
.Quig_Directory_Error_Byte:		db	0
.Quig_String_Buffer_Area_Start 	equ AppTrnEnd+260
.Quig_String_Buffer_Top			equ AppTrnEnd+260+AppTrnLen2
.Quig_String_Buffer_StackNo:	dw 0
.Quig_String_Buffer_Pos:		dw AppTrnEnd+260
.Quig_String_Buffer_Stack:		dw AppTrnEnd+260,0,0,0,0,0,0,0,0,0
.Quig_String_AS_HByte:			db 0
.Quig_String_Pos:				dw Quig_String_End_Text+4
.ErrorNum:					dw	0
.ErrorPC:					dw	0
.False:						db	0
.True:						db	1
.tcounter					dw	0
.QFunc_FORM1_OPEN_EVENT
.QLn_241		;//EndF
		ret		;// [Qc262]
.QLn_243		;//Function Form1.Close.Event:Void()
.QFunc_FORM1_CLOSE_EVENT
.QLn_244		;//iAppExit = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iAppExit),hl		;//Int variable 'var_wrd_iAppExit'=expression result [Qc219]
.QLn_245		;//EndF
		ret		;// [Qc262]
.QLn_251		;//Function Label14.Event:Void()
.QFunc_LABEL14_EVENT
.QLn_252		;//bRestart = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_bRestart),hl		;//Int variable 'var_wrd_bRestart'=expression result [Qc219]
.QLn_253		;//Endf
		ret		;// [Qc262]
.QLn_255		;//Function Label15.Event:Void()
.QFunc_LABEL15_EVENT
.QLn_256		;//iFlash = #23
		ld		hl,35		;//hl=number '35' [Qc054]
		ld		(var_wrd_iFlash),hl		;//Int variable 'var_wrd_iFlash'=expression result [Qc219]
.QLn_257		;//endf
		ret		;// [Qc262]
.QLn_259		;//Function Image.Event:Void()
.QFunc_IMAGE_EVENT
.QLn_260		;//if (iPlayer = iPlayerActive) then
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_iPlayerActive) 	;//hl=value of 'var_wrd_iPlayerActive' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf956_Exit0				;// [Qc1012]
.QLn_261		;//CrtlEventToImg
		call	QFunc_CrtlEventToImg				;//Call 'CrtlEventToImg' [Qc234]
.QLn_262		;//endif
.QIf956_Exit0:
.QIf956_EndIf:
.QLn_263		;//Endf
		ret		;// [Qc262]
.QLn_265		;//Function ImageVoipRed.Event:Void()
.QFunc_IMAGEVOIPRED_EVENT
.QLn_266		;//VoipRedButton
		call	QFunc_VoipRedButton				;//Call 'VoipRedButton' [Qc234]
.QLn_267		;//endf
		ret		;// [Qc262]
.QLn_269		;//Function ImageVoipGreen.Event:Void()
.QFunc_IMAGEVOIPGREEN_EVENT
.QLn_270		;//VoipGreenButton
		call	QFunc_VoipGreenButton				;//Call 'VoipGreenButton' [Qc234]
.QLn_271		;//endf
		ret		;// [Qc262]
.QLn_275		;//Function Form2.Open.Event:Void()
.QFunc_FORM2_OPEN_EVENT
.QLn_276		;//endf
		ret		;// [Qc262]
.QLn_278		;//Function Form2.Close.Event:Void()
.QFunc_FORM2_CLOSE_EVENT
.QLn_279		;//iAppExit = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iAppExit),hl		;//Int variable 'var_wrd_iAppExit'=expression result [Qc219]
.QLn_280		;//EndF
		ret		;// [Qc262]
.QLn_285		;//Function label21.Event:Void()
.QFunc_LABEL21_EVENT
.QLn_286		;//iButChoise = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_287		;//if (iStpStartup = 120) and (iUserOnlineTotal > 0) then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,120			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf1016_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_288		;//Label21.Colour.Set Colour.Black,colour.Yellow,1
		ld		hl,Label21_TextAppearance		;//hl=address of 'Label21_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,12			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label21.Colour.Set' [Qc234]
.QLn_289		;//Label21.refresh
		ld		hl,Label21		;//hl=address of 'Label21' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label21.Refresh' [Qc234]
.QLn_290		;//intDelay = 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_291		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_292		;//endif
.QIf1016_Exit0:
.QIf1016_EndIf:
.QLn_294		;//endf
		ret		;// [Qc262]
.QLn_296		;//Function label22.Event:Void()
.QFunc_LABEL22_EVENT
.QLn_297		;//iButChoise = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_298		;//if (iStpStartup = 120) and (iUserOnlineTotal > 1) then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,120			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,1			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf1069_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_299		;//Label22.Colour.Set Colour.Black,colour.Yellow,1
		ld		hl,Label22_TextAppearance		;//hl=address of 'Label22_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,12			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label22.Colour.Set' [Qc234]
.QLn_300		;//Label22.refresh
		ld		hl,Label22		;//hl=address of 'Label22' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label22.Refresh' [Qc234]
.QLn_301		;//intDelay = 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_302		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_303		;//endif
.QIf1069_Exit0:
.QIf1069_EndIf:
.QLn_304		;//endf
		ret		;// [Qc262]
.QLn_306		;//Function label23.Event:Void()
.QFunc_LABEL23_EVENT
.QLn_307		;//iButChoise = 3
		ld		hl,3		;//hl=number '3' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_309		;//if (iStpStartup = 120) and (iUserOnlineTotal > 2) then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,120			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,2			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf1122_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_310		;//Label23.Colour.Set Colour.Black,colour.Yellow,1
		ld		hl,Label23_TextAppearance		;//hl=address of 'Label23_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,12			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label23.Colour.Set' [Qc234]
.QLn_311		;//Label23.refresh
		ld		hl,Label23		;//hl=address of 'Label23' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label23.Refresh' [Qc234]
.QLn_312		;//intDelay = 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_313		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_314		;//endif
.QIf1122_Exit0:
.QIf1122_EndIf:
.QLn_316		;//endf
		ret		;// [Qc262]
.QLn_318		;//Function label24.Event:Void()
.QFunc_LABEL24_EVENT
.QLn_319		;//iButChoise = 4
		ld		hl,4		;//hl=number '4' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_320		;//if (iStpStartup = 120) and (iUserOnlineTotal > 3) then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,120			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,3			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf1175_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_321		;//Label24.Colour.Set Colour.Black,colour.Yellow,1
		ld		hl,Label24_TextAppearance		;//hl=address of 'Label24_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,12			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label24.Colour.Set' [Qc234]
.QLn_322		;//Label24.refresh
		ld		hl,Label24		;//hl=address of 'Label24' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label24.Refresh' [Qc234]
.QLn_323		;//intDelay = 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_324		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_325		;//endif
.QIf1175_Exit0:
.QIf1175_EndIf:
.QLn_327		;//endf
		ret		;// [Qc262]
.QLn_329		;//Function label25.Event:Void()
.QFunc_LABEL25_EVENT
.QLn_330		;//iButChoise = 5
		ld		hl,5		;//hl=number '5' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_331		;//if (iStpStartup = 120) and (iUserOnlineTotal > 4) then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,120			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,4			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf1228_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_332		;//Label25.Colour.Set Colour.Black,colour.Yellow,1
		ld		hl,Label25_TextAppearance		;//hl=address of 'Label25_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,12			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label25.Colour.Set' [Qc234]
.QLn_333		;//Label25.refresh
		ld		hl,Label25		;//hl=address of 'Label25' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label25.Refresh' [Qc234]
.QLn_334		;//intDelay = 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_335		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_336		;//endif
.QIf1228_Exit0:
.QIf1228_EndIf:
.QLn_338		;//endf
		ret		;// [Qc262]
.QLn_345		;//Function Form4.Open.Event:Void()
.QFunc_FORM4_OPEN_EVENT
.QLn_346		;//Initialize
		call	QFunc_Initialize				;//Call 'Initialize' [Qc234]
.QLn_347		;//endf
		ret		;// [Qc262]
.QLn_349		;//Function Form4.Close.Event:Void()
.QFunc_FORM4_CLOSE_EVENT
.QLn_350		;//iAppExit = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iAppExit),hl		;//Int variable 'var_wrd_iAppExit'=expression result [Qc219]
.QLn_351		;//EndF
		ret		;// [Qc262]
.QLn_355		;//Function Button41.Event:Void()
.QFunc_BUTTON41_EVENT
.QLn_356		;//iStpStartup = 10
		ld		hl,10		;//hl=number '10' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_357		;//endf
		ret		;// [Qc262]
.QLn_362		;//Function Initialize:Void()
.QFunc_INITIALIZE
.QLn_364		;//sys_IO_init
		call	QFunc_sys_IO_init				;//Call 'sys_IO_init' [Qc234]
.QLn_366		;//u8In1 = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_u8In1),hl		;//Int variable 'var_wrd_u8In1'=expression result [Qc219]
.QLn_367		;//F72_26
		call	QFunc_F72_26				;//Call 'F72_26' [Qc234]
.QLn_368		;//strHardware = strOut1
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
;**** 'var_str_strHardware$'=Expression
		ld		de,(var_str_strHardware)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strHardware'= [Qc221]
.QLn_372		;//sAtCmd = "AT+SEMODE=VOICE":ATCmd
		ld		hl,directstr_1+2		;//hl points static string [Qc055]
;**** 'var_str_sAtCmd$'=Expression
		ld		de,(var_str_sAtCmd)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sAtCmd'= [Qc221]
		call	QFunc_ATCmd				;//Call 'ATCmd' [Qc234]
.QLn_375		;//F131_39
		call	QFunc_F131_39				;//Call 'F131_39' [Qc234]
.QLn_377		;//strAppname = "DOTBOX"
		ld		hl,directstr_2+2		;//hl points static string [Qc055]
;**** 'var_str_strAppname$'=Expression
		ld		de,(var_str_strAppname)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strAppname'= [Qc221]
.QLn_379		;//shDD_start.Load(App.Path+"dd_start.qs1")
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_3+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,var_byt_shDD_start_status		;// [Qc227]
		call	Quig_SheetLoad				;//Call 'shDD_start.Load' [Qc234]
.QLn_380		;//Image410.Tile.Set shDD_start,0
		ld		hl,Image410_ExtDataBank		;//hl=address of 'Image410_ExtDataBank' [Qc223]
		push		hl		;//Store result [Qc005]
		Ld		de,var_byt_shDD_start_status			;// Optimize -9- [Qc1070]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Tile_Set				;//Call 'Image410.Tile.Set' [Qc234]
.QLn_381		;//Image410.Refresh
		ld		hl,Image410		;//hl=address of 'Image410' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Image410.Refresh' [Qc234]
.QLn_383		;//Button41.text.set "Loading..0%"
		ld		hl,directstr_4+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
.QLn_384		;//Button41.refresh
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_387		;//sText = " " + strCPU + " " + strHardware + " [" + App.Date + "]"
		ld		hl,directstr_5+2		;//hl points static string [Qc055]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strCPU)		;//hl=pointer to string 'var_str_strCPU' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_5+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strHardware)		;//hl=pointer to string 'var_str_strHardware' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_6+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,Quig_App_Date		;//hl=address of 'Quig_App_Date' [Qc011]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_7+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_388		;//Form4.status.text.set sText
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		ld		de,(Form4_Status_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Form4.Status.Text.Set' [Qc234]
.QLn_389		;//Form4.status.refresh
		ld		hl,3		;//hl=number '3' [Qc224]
		call	Quig_RefreshStatus				;//Call 'Form4.Status.Refresh' [Qc234]
.QLn_392		;//shDD_dot.Load(App.Path+"dd_dot.qs2")
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_8+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,var_byt_shDD_dot_status		;// [Qc227]
		call	Quig_SheetLoad				;//Call 'shDD_dot.Load' [Qc234]
.QLn_393		;//Button41.text.set "Loading..10%" :Button41.refresh
		ld		hl,directstr_9+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_395		;//shDD_hori.Load(App.Path+"dd_hori.qs2")
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_10+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,var_byt_shDD_hori_status		;// [Qc227]
		call	Quig_SheetLoad				;//Call 'shDD_hori.Load' [Qc234]
.QLn_396		;//Button41.text.set "Loading..30%" :Button41.refresh
		ld		hl,directstr_11+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_398		;//shDD_vert.Load(App.Path+"dd_vert.qs2")
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_12+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,var_byt_shDD_vert_status		;// [Qc227]
		call	Quig_SheetLoad				;//Call 'shDD_vert.Load' [Qc234]
.QLn_399		;//Button41.text.set "Loading..50%" :Button41.refresh
		ld		hl,directstr_13+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_401		;//shDD_fill.Load(App.Path+"dd_fill.qs2")
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_14+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,var_byt_shDD_fill_status		;// [Qc227]
		call	Quig_SheetLoad				;//Call 'shDD_fill.Load' [Qc234]
.QLn_402		;//Button41.text.set "Loading..60%" :Button41.refresh
		ld		hl,directstr_15+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_404		;//shDD_digi.Load(App.Path+"dd_digi.qs2")
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_16+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,var_byt_shDD_digi_status		;// [Qc227]
		call	Quig_SheetLoad				;//Call 'shDD_digi.Load' [Qc234]
.QLn_405		;//Button41.text.set "Loading..80%" :Button41.refresh
		ld		hl,directstr_17+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_407		;//shDD_voip.Load(App.Path+"dd_voip.qs2")
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_18+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,var_byt_shDD_voip_status		;// [Qc227]
		call	Quig_SheetLoad				;//Call 'shDD_voip.Load' [Qc234]
.QLn_408		;//Button41.text.set "Loading..100%" :Button41.refresh
		ld		hl,directstr_19+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_410		;//Button41.text.set "START" :Button41.refresh
		ld		hl,directstr_20+2		;//hl points static string [Qc055]
		ld		de,(Button41_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Button41.Text.Set' [Qc234]
		ld		hl,Button41		;//hl=address of 'Button41' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Button41.Refresh' [Qc234]
.QLn_412		;//Randomize ((Time.Hour.Get * 360) + (Time.Minute.Get * 60) + (Time.Second.Get))
		call	Quig_Time_Hour_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,360		;//hl=number '360' [Qc054]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		push		hl		;/Get result from Stack [Qc051]
		call	Quig_Time_Minute_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,60		;//hl=number '60' [Qc054]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		push		hl		;/Get result from Stack [Qc051]
		call	Quig_Time_Second_Get		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		call	Quig_IRandomize				;//Call 'Randomize' [Qc234]
.QLn_414		;//iGameMode = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iGameMode),hl		;//Int variable 'var_wrd_iGameMode'=expression result [Qc219]
.QLn_416		;//If Sound.Init = 0 Then
		call	Quig_Sound_Int		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1469_Exit0				;// [Qc1012]
.QLn_417		;//sText = left(App.Path,1) + ":\soundd.exe"
		call	Quig_App_Path		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Left		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_21+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_418		;//a = Execute(sText)			// Start netd local if not open
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		call	Quig_Execute		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_419		;//a = Sound.Init
		call	Quig_Sound_Int		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_421		;//sDb="Sound.Init" :sysDebug
		ld		hl,directstr_22+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_422		;//EndIf
.QIf1469_Exit0:
.QIf1469_EndIf:
.QLn_423		;//EndF
		ret		;// [Qc262]
.QLn_430		;//Function Main:Void()
.QFunc_MAIN
.QLn_432		;//intDelayCt = intDelayCt + 1
		ld		hl,(var_wrd_intDelayCt) 	;//hl=value of 'var_wrd_intDelayCt' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_433		;//If intDelayCt < intDelay Then
		ld		hl,(var_wrd_intDelayCt) 	;//hl=value of 'var_wrd_intDelayCt' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_intDelay) 	;//hl=value of 'var_wrd_intDelay' [Qc053]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf1512_Exit0				;// [Qc1220]
.QLn_434		;//Return
		ret		;// [Qc250]
.QLn_435		;//EndIf
.QIf1512_Exit0:
.QIf1512_EndIf:
.QLn_436		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_438		;//if iAppExit > 0 then
		Ld		de,(var_wrd_iAppExit)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf1528_Exit0				;// [Qc1220]
.QLn_439		;//symAppExit
		call	QFunc_symAppExit				;//Call 'symAppExit' [Qc234]
.QLn_440		;//endif
.QIf1528_Exit0:
.QIf1528_EndIf:
.QLn_442		;//If  iGameMode = 1 Then
		Ld		hl,(var_wrd_iGameMode)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1546_Exit0				;// [Qc1012]
.QLn_444		;//chat_handler
		call	QFunc_chat_handler				;//Call 'chat_handler' [Qc234]
.QLn_446		;//net21_rec_loop
		call	QFunc_net21_rec_loop				;//Call 'net21_rec_loop' [Qc234]
.QLn_448		;//if (iSelImg > 0) and (iPlayer = iPlayerActive)  then
		Ld		de,(var_wrd_iSelImg)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_iPlayerActive) 	;//hl=value of 'var_wrd_iPlayerActive' [Qc053]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf1575_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_449		;//game_press_select
		call	QFunc_game_press_select				;//Call 'game_press_select' [Qc234]
.QLn_450		;//endif
.QIf1575_Exit0:
.QIf1575_EndIf:
.QLn_452		;//if (bNew_field = 1) then
		Ld		hl,(var_wrd_bNew_field)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1593_Exit0				;// [Qc1012]
.QLn_453		;//game_new_field
		call	QFunc_game_new_field				;//Call 'game_new_field' [Qc234]
.QLn_454		;//endif
.QIf1593_Exit0:
.QIf1593_EndIf:
.QLn_456		;//if (bRestart = 1) then
		Ld		hl,(var_wrd_bRestart)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1611_Exit0				;// [Qc1012]
.QLn_457		;//game_replay
		call	QFunc_game_replay				;//Call 'game_replay' [Qc234]
.QLn_458		;//endif
.QIf1611_Exit0:
.QIf1611_EndIf:
.QLn_460		;//if (iWinner > 0 ) then
		Ld		de,(var_wrd_iWinner)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf1624_Exit0				;// [Qc1220]
.QLn_461		;//iFlash = shl4(iWinner) or  3
		ld		hl,(var_wrd_iWinner) 	;//hl=value of 'var_wrd_iWinner' [Qc053]
		call	Quig_Shl4		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,3		;//hl=number '3' [Qc054]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
		ld		(var_wrd_iFlash),hl		;//Int variable 'var_wrd_iFlash'=expression result [Qc219]
.QLn_463		;//if (iWinner = iPlayer) then
		ld		hl,(var_wrd_iWinner) 	;//hl=value of 'var_wrd_iWinner' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1649_Exit0				;// [Qc1012]
.QLn_464		;//label6.text.set "--- You are Winner !!!! ---"
		ld		hl,directstr_23+2		;//hl points static string [Qc055]
		ld		de,(Label6_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label6.Text.Set' [Qc234]
.QLn_465		;//label6.refresh
		ld		hl,Label6		;//hl=address of 'Label6' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label6.Refresh' [Qc234]
.QLn_466		;//else
		jp		QIf1649_EndIf		;//Jump to EndIf
.QIf1649_Exit0:
.QLn_467		;//label6.text.set "--- You lost !!!! ---"
		ld		hl,directstr_24+2		;//hl points static string [Qc055]
		ld		de,(Label6_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label6.Text.Set' [Qc234]
.QLn_468		;//label6.refresh
		ld		hl,Label6		;//hl=address of 'Label6' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label6.Refresh' [Qc234]
.QLn_469		;//endif
.QIf1649_Exit1:
.QIf1649_EndIf:
.QLn_470		;//iWinner = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iWinner),hl		;//Int variable 'var_wrd_iWinner'=expression result [Qc219]
.QLn_471		;//endif
.QIf1624_Exit0:
.QIf1624_EndIf:
.QLn_473		;//if (iFlash > 0 ) then
		Ld		de,(var_wrd_iFlash)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf1683_Exit0				;// [Qc1220]
.QLn_474		;//iFlashCt = iFlashCt + 1
		ld		hl,(var_wrd_iFlashCt) 	;//hl=value of 'var_wrd_iFlashCt' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iFlashCt),hl		;//Int variable 'var_wrd_iFlashCt'=expression result [Qc219]
.QLn_475		;//if (iFlashCt = 21) then
		Ld		hl,(var_wrd_iFlashCt)			;// Optimize -1a- [Qc1062]
		Ld		de,21			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1700_Exit0				;// [Qc1012]
.QLn_476		;//iFlashCt = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iFlashCt),hl		;//Int variable 'var_wrd_iFlashCt'=expression result [Qc219]
.QLn_477		;//endif
.QIf1700_Exit0:
.QIf1700_EndIf:
.QLn_479		;//if (iFlashCt = 10) or (iFlashCt = 20)then
		Ld		hl,(var_wrd_iFlashCt)			;// Optimize -1a- [Qc1062]
		Ld		de,10			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_iFlashCt)			;// Optimize -1a- [Qc1062]
		Ld		de,20			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf1736_Exit0			;// [Qc5062]
.QLn_480		;//flashing
		call	QFunc_flashing				;//Call 'flashing' [Qc234]
.QLn_481		;//endif
.QIf1736_Exit0:
.QIf1736_EndIf:
.QLn_482		;//endif
.QIf1683_Exit0:
.QIf1683_EndIf:
.QLn_484		;//VoipHandler
		call	QFunc_VoipHandler				;//Call 'VoipHandler' [Qc234]
.QLn_485		;//VoipSoundHandler
		call	QFunc_VoipSoundHandler				;//Call 'VoipSoundHandler' [Qc234]
.QLn_487		;//return
		ret		;// [Qc250]
.QLn_488		;//endif
.QIf1546_Exit0:
.QIf1546_EndIf:
.QLn_490		;//stpStartup
		call	QFunc_stpStartup				;//Call 'stpStartup' [Qc234]
.QLn_491		;//EndF
		ret		;// [Qc262]
.QLn_494		;//Function symAppExit:void()
.QFunc_SYMAPPEXIT
.QLn_496		;//sDb = "App exit":sysDebug
		ld		hl,directstr_25+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_498		;//if iAppExit = 1 then
		Ld		hl,(var_wrd_iAppExit)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1778_Exit0				;// [Qc1012]
.QLn_499		;//Form1.open
		ld		hl,0		;//hl=number '0' [Qc224]
		call	Quig_Form_Open				;//Call 'Form1.Open' [Qc234]
.QLn_500		;//F131_39
		call	QFunc_F131_39				;//Call 'F131_39' [Qc234]
.QLn_501		;//iAppExit = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_iAppExit),hl		;//Int variable 'var_wrd_iAppExit'=expression result [Qc219]
.QLn_502		;//endif
.QIf1778_Exit0:
.QIf1778_EndIf:
.QLn_504		;//if iAppExit = 2 then
		Ld		hl,(var_wrd_iAppExit)			;// Optimize -1a- [Qc1062]
		Ld		de,2			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1802_Exit0				;// [Qc1012]
.QLn_505		;//shDD_dot.free
		ld		hl,var_byt_shDD_dot_status		;//hl=address of 'var_byt_shDD_dot_status' [Qc223]
		call	Quig_SheetFree				;//Call 'shDD_dot.Free' [Qc234]
.QLn_506		;//shDD_hori.free
		ld		hl,var_byt_shDD_hori_status		;//hl=address of 'var_byt_shDD_hori_status' [Qc223]
		call	Quig_SheetFree				;//Call 'shDD_hori.Free' [Qc234]
.QLn_507		;//shDD_vert.free
		ld		hl,var_byt_shDD_vert_status		;//hl=address of 'var_byt_shDD_vert_status' [Qc223]
		call	Quig_SheetFree				;//Call 'shDD_vert.Free' [Qc234]
.QLn_508		;//shDD_start.free
		ld		hl,var_byt_shDD_start_status		;//hl=address of 'var_byt_shDD_start_status' [Qc223]
		call	Quig_SheetFree				;//Call 'shDD_start.Free' [Qc234]
.QLn_509		;//shDD_digi.free
		ld		hl,var_byt_shDD_digi_status		;//hl=address of 'var_byt_shDD_digi_status' [Qc223]
		call	Quig_SheetFree				;//Call 'shDD_digi.Free' [Qc234]
.QLn_510		;//shDD_voip.free
		ld		hl,var_byt_shDD_voip_status		;//hl=address of 'var_byt_shDD_voip_status' [Qc223]
		call	Quig_SheetFree				;//Call 'shDD_voip.Free' [Qc234]
.QLn_511		;//App.exit
		call	Quig_End				;//Call 'App.Exit' [Qc234]
.QLn_512		;//iAppExit = 3
		ld		hl,3		;//hl=number '3' [Qc054]
		ld		(var_wrd_iAppExit),hl		;//Int variable 'var_wrd_iAppExit'=expression result [Qc219]
.QLn_513		;//endif
.QIf1802_Exit0:
.QIf1802_EndIf:
.QLn_514		;//endf
		ret		;// [Qc262]
.QLn_518		;//Function chat_init:void()
.QFunc_CHAT_INIT
.QLn_519		;//endf
		ret		;// [Qc262]
.QLn_521		;//Function chat_handler:void()
.QFunc_CHAT_HANDLER
.QLn_523		;//u8NetStatus = IO.In(ioA_A)
		ld		hl,(var_wrd_ioA_A) 	;//hl=value of 'var_wrd_ioA_A' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8NetStatus),hl		;//Int variable 'var_wrd_u8NetStatus'=expression result [Qc219]
.QLn_524		;//if ((u8NetStatus and defNetStatusBitMsg) > 0)	then
		ld		hl,(var_wrd_u8NetStatus) 	;//hl=value of 'var_wrd_u8NetStatus' [Qc053]
		ex		de,hl 				;// Optimize 512 [Qc5055]
		Ld		hl,(var_byt_defNetStatusBitMsg)				;// [Qc5056]
		Ld		h,0					;// [Qc5057]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf1858_Exit0				;// [Qc1220]
.QLn_525		;//chat_recvTxt
		call	QFunc_chat_recvTxt				;//Call 'chat_recvTxt' [Qc234]
.QLn_526		;//endif
.QIf1858_Exit0:
.QIf1858_EndIf:
.QLn_528		;//If Event.Type = 16 Then
		ld		hl,Event_Type		;//hl=address of 'Event_Type' [Qc011]
		call	Quig_Get_Byte		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,16		;//hl=number '16' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1877_Exit0				;// [Qc1012]
.QLn_529		;//u8Key = Event.KeyPressed
		call	Quig_Get_Keypress		;/ Call Function [Qc052]
		ld		(var_wrd_u8Key),hl		;//Int variable 'var_wrd_u8Key'=expression result [Qc219]
.QLn_531		;//if (u8Key = 8) then 						//BS
		Ld		hl,(var_wrd_u8Key)			;// Optimize -1a- [Qc1062]
		Ld		de,8			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1893_Exit0				;// [Qc1012]
.QLn_532		;//se1_PlayTick
		call	QFunc_se1_PlayTick				;//Call 'se1_PlayTick' [Qc234]
.QLn_533		;//chat_del
		call	QFunc_chat_del				;//Call 'chat_del' [Qc234]
.QLn_534		;//Endif
.QIf1893_Exit0:
.QIf1893_EndIf:
.QLn_536		;//if (u8Key = 13) then 						//Enter
		Ld		hl,(var_wrd_u8Key)			;// Optimize -1a- [Qc1062]
		Ld		de,13			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf1913_Exit0				;// [Qc1012]
.QLn_537		;//se1_PlayTick
		call	QFunc_se1_PlayTick				;//Call 'se1_PlayTick' [Qc234]
.QLn_538		;//chat_send
		call	QFunc_chat_send				;//Call 'chat_send' [Qc234]
.QLn_539		;//Endif
.QIf1913_Exit0:
.QIf1913_EndIf:
.QLn_541		;//if ((u8Key > 31) and (u8Key < 126)) then 	//AscII
		Ld		de,(var_wrd_u8Key)			;// Optimize -1- [Qc1001]
		Ld		hl,31			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_u8Key)			;// Optimize -1- [Qc1001]
		Ld		hl,126			;// [Qc1002]
		call	Quig_LT_HL		;/Checks HL<DE - True HL=1 False HL=0 [Qc117]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf1940_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_542		;//se1_PlayTick
		call	QFunc_se1_PlayTick				;//Call 'se1_PlayTick' [Qc234]
.QLn_543		;//chat_printChar
		call	QFunc_chat_printChar				;//Call 'chat_printChar' [Qc234]
.QLn_545		;//Endif
.QIf1940_Exit0:
.QIf1940_EndIf:
.QLn_546		;//Endif
.QIf1877_Exit0:
.QIf1877_EndIf:
.QLn_548		;//chat_sendMsg
		call	QFunc_chat_sendMsg				;//Call 'chat_sendMsg' [Qc234]
.QLn_549		;//endf
		ret		;// [Qc262]
.QLn_552		;//Function chat_scroll:void()
.QFunc_CHAT_SCROLL
.QLn_556		;//strChatText(5) = strChatText(4)
		ld		hl,5		;//hl=number '5' [Qc054]
		ld		bc,ar1_str_strChatText+2		;//Array String [Qc129]
		add		hl,hl		;// [Qc130]
		add		hl,bc		;// [Qc131]
		ld		(Quig_Let_43+2),hl		;// [Qc710]
		Ld 		hl,(4*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
.Quig_Let_43:
		ld		de,(0)		;// Address to be filled in [Qc217]
		call	Quig_LetString				;// 'ar1_str_strChatText'= [Qc218]
.QLn_557		;//strChatText(4) = strChatText(3)
		ld		hl,4		;//hl=number '4' [Qc054]
		ld		bc,ar1_str_strChatText+2		;//Array String [Qc129]
		add		hl,hl		;// [Qc130]
		add		hl,bc		;// [Qc131]
		ld		(Quig_Let_44+2),hl		;// [Qc710]
		Ld 		hl,(3*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
.Quig_Let_44:
		ld		de,(0)		;// Address to be filled in [Qc217]
		call	Quig_LetString				;// 'ar1_str_strChatText'= [Qc218]
.QLn_558		;//strChatText(3) = strChatText(2)
		ld		hl,3		;//hl=number '3' [Qc054]
		ld		bc,ar1_str_strChatText+2		;//Array String [Qc129]
		add		hl,hl		;// [Qc130]
		add		hl,bc		;// [Qc131]
		ld		(Quig_Let_45+2),hl		;// [Qc710]
		Ld 		hl,(2*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
.Quig_Let_45:
		ld		de,(0)		;// Address to be filled in [Qc217]
		call	Quig_LetString				;// 'ar1_str_strChatText'= [Qc218]
.QLn_560		;//Label5.Text.Set	strChatText(5)
		Ld 		hl,(5*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
		ld		de,(Label5_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label5.Text.Set' [Qc234]
.QLn_561		;//Label5.Refresh
		ld		hl,Label5		;//hl=address of 'Label5' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label5.Refresh' [Qc234]
.QLn_563		;//Label4.Text.Set	strChatText(4)
		Ld 		hl,(4*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
		ld		de,(Label4_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label4.Text.Set' [Qc234]
.QLn_564		;//Label4.Refresh
		ld		hl,Label4		;//hl=address of 'Label4' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label4.Refresh' [Qc234]
.QLn_566		;//Label3.Text.Set	strChatText(3)
		Ld 		hl,(3*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
		ld		de,(Label3_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label3.Text.Set' [Qc234]
.QLn_567		;//Label3.Refresh
		ld		hl,Label3		;//hl=address of 'Label3' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label3.Refresh' [Qc234]
.QLn_569		;//EndF
		ret		;// [Qc262]
.QLn_572		;//Function chat_recvTxt:void()
.QFunc_CHAT_RECVTXT
.QLn_576		;//chat_scroll
		call	QFunc_chat_scroll				;//Call 'chat_scroll' [Qc234]
.QLn_578		;//F131_22
		call	QFunc_F131_22				;//Call 'F131_22' [Qc234]
.QLn_580		;//strChatText(2) = strTm
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_str_strChatText+2		;//Array String [Qc129]
		add		hl,hl		;// [Qc130]
		add		hl,bc		;// [Qc131]
		ld		(Quig_Let_46+2),hl		;// [Qc710]
		ld		hl,(var_str_strTm)		;//hl=pointer to string 'var_str_strTm' [Qc056]
.Quig_Let_46:
		ld		de,(0)		;// Address to be filled in [Qc217]
		call	Quig_LetString				;// 'ar1_str_strChatText'= [Qc218]
.QLn_581		;//Label2.Text.Set	strChatText(2)
		Ld 		hl,(2*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
		ld		de,(Label2_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label2.Text.Set' [Qc234]
.QLn_582		;//Label2.Refresh
		ld		hl,Label2		;//hl=address of 'Label2' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label2.Refresh' [Qc234]
.QLn_584		;//se1_PlayBell
		call	QFunc_se1_PlayBell				;//Call 'se1_PlayBell' [Qc234]
.QLn_585		;//EndF
		ret		;// [Qc262]
.QLn_587		;//Function chat_del:void()
.QFunc_CHAT_DEL
.QLn_592		;//if len (strMs) = 0 then
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2101_Exit0				;// [Qc1012]
.QLn_593		;//sDb = "Input string empty"
		ld		hl,directstr_26+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
.QLn_594		;//sysDebug
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_595		;//return
		ret		;// [Qc250]
.QLn_596		;//Endif
.QIf2101_Exit0:
.QIf2101_EndIf:
.QLn_599		;//l = Len(strMs) - 1
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		dec		hl		;//Minus 1 [Qc093]
		ld		(var_wrd_l),hl		;//Int variable 'var_wrd_l'=expression result [Qc219]
.QLn_600		;//strMs = Left(strMs,l)
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_l) 	;//hl=value of 'var_wrd_l' [Qc053]
		call	Quig_Left		;/ Call Function [Qc052]
;**** 'var_str_strMs$'=Expression
		ld		de,(var_str_strMs)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strMs'= [Qc221]
.QLn_602		;//strChatInp =  strMs
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
;**** 'var_str_strChatInp$'=Expression
		ld		de,(var_str_strChatInp)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strChatInp'= [Qc221]
.QLn_603		;//Label1.Text.Set  strChatInp
		ld		hl,(var_str_strChatInp)		;//hl=pointer to string 'var_str_strChatInp' [Qc056]
		ld		de,(Label1_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label1.Text.Set' [Qc234]
.QLn_604		;//Label1.Refresh
		ld		hl,Label1		;//hl=address of 'Label1' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label1.Refresh' [Qc234]
.QLn_605		;//EndF
		ret		;// [Qc262]
.QLn_608		;//Function chat_printChar:void()
.QFunc_CHAT_PRINTCHAR
.QLn_610		;//if len(strMs) > 50 then
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,50		;//hl=number '50' [Qc054]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf2151_Exit0				;// [Qc1220]
.QLn_611		;//sDb = "Input string too  long > 50"
		ld		hl,directstr_27+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
.QLn_612		;//sysDebug
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_613		;//return
		ret		;// [Qc250]
.QLn_614		;//EndIf
.QIf2151_Exit0:
.QIf2151_EndIf:
.QLn_616		;//strMs = strMs + Chr(u8Key)
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_u8Key) 	;//hl=value of 'var_wrd_u8Key' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strMs$'=Expression
		ld		de,(var_str_strMs)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strMs'= [Qc221]
.QLn_618		;//strChatInp =  strMs
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
;**** 'var_str_strChatInp$'=Expression
		ld		de,(var_str_strChatInp)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strChatInp'= [Qc221]
.QLn_619		;//Label1.Text.Set  strChatInp
		ld		hl,(var_str_strChatInp)		;//hl=pointer to string 'var_str_strChatInp' [Qc056]
		ld		de,(Label1_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label1.Text.Set' [Qc234]
.QLn_620		;//Label1.Refresh
		ld		hl,Label1		;//hl=address of 'Label1' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label1.Refresh' [Qc234]
.QLn_625		;//EndF
		ret		;// [Qc262]
.QLn_627		;//Function chat_ClearInput:void()
.QFunc_CHAT_CLEARINPUT
.QLn_631		;//strMs = ""
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strMs$'=Expression
		ld		de,(var_str_strMs)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strMs'= [Qc221]
.QLn_632		;//strChatInp =  strMs
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
;**** 'var_str_strChatInp$'=Expression
		ld		de,(var_str_strChatInp)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strChatInp'= [Qc221]
.QLn_633		;//Label1.Text.Set  strChatInp
		ld		hl,(var_str_strChatInp)		;//hl=pointer to string 'var_str_strChatInp' [Qc056]
		ld		de,(Label1_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label1.Text.Set' [Qc234]
.QLn_634		;//Label1.Refresh
		ld		hl,Label1		;//hl=address of 'Label1' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label1.Refresh' [Qc234]
.QLn_635		;//EndF
		ret		;// [Qc262]
.QLn_637		;//Function chat_send:void()
.QFunc_CHAT_SEND
.QLn_639		;//chat_scroll
		call	QFunc_chat_scroll				;//Call 'chat_scroll' [Qc234]
.QLn_641		;//strChatText(2) = str(u16MyUserID) + " "+strMs
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_str_strChatText+2		;//Array String [Qc129]
		add		hl,hl		;// [Qc130]
		add		hl,bc		;// [Qc131]
		ld		(Quig_Let_56+2),hl		;// [Qc710]
		ld		hl,(var_wrd_u16MyUserID) 	;//hl=value of 'var_wrd_u16MyUserID' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_5+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
.Quig_Let_56:
		ld		de,(0)		;// Address to be filled in [Qc217]
		call	Quig_LetString				;// 'ar1_str_strChatText'= [Qc218]
.QLn_642		;//Label2.Text.Set	strChatText(2)
		Ld 		hl,(2*2 + ar1_str_strChatText+2)			;// 1080 [Qc1080]
		ld		de,(Label2_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label2.Text.Set' [Qc234]
.QLn_643		;//Label2.Refresh
		ld		hl,Label2		;//hl=address of 'Label2' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label2.Refresh' [Qc234]
.QLn_645		;//strMs = strMs + Chr(13)
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
		push		hl 		;//Store result [Qc001]
		ld		hl,13		;//hl=number '13' [Qc054]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strMs$'=Expression
		ld		de,(var_str_strMs)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strMs'= [Qc221]
.QLn_647		;//u16Du = u16OtherID
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
		ld		(var_wrd_u16Du),hl		;//Int variable 'var_wrd_u16Du'=expression result [Qc219]
.QLn_648		;//chat_fifo_in
		call	QFunc_chat_fifo_in				;//Call 'chat_fifo_in' [Qc234]
.QLn_650		;//chat_ClearInput
		call	QFunc_chat_ClearInput				;//Call 'chat_ClearInput' [Qc234]
.QLn_651		;//EndF
		ret		;// [Qc262]
.QLn_654		;//Function chat_sendMsg:void()
.QFunc_CHAT_SENDMSG
.QLn_656		;//F131_21
		call	QFunc_F131_21				;//Call 'F131_21' [Qc234]
.QLn_660		;//if (u8Out1 > 0) or (u8FifoContent = 0 ) then
		Ld		de,(var_wrd_u8Out1)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		push		hl		;//Store result [Qc009]
		Ld		hl,var_byt_u8FifoContent			;// 5030-5035 [Qc5030]
		Ld		a,0			;// [Qc5031]
		sub		(hl)				;// [Qc5032]
		Ld		hl,0				;// [Qc5033]
		jr		nz,1				;// [Qc5034]
		inc		l					;// [Qc5035]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf2292_Exit0			;// [Qc5062]
.QLn_661		;//return
		ret		;// [Qc250]
.QLn_662		;//EndIf
.QIf2292_Exit0:
.QIf2292_EndIf:
.QLn_664		;//chat_fifo_out
		call	QFunc_chat_fifo_out				;//Call 'chat_fifo_out' [Qc234]
.QLn_666		;//If u16Du = u16MyUserID then
		ld		hl,(var_wrd_u16Du) 	;//hl=value of 'var_wrd_u16Du' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_u16MyUserID) 	;//hl=value of 'var_wrd_u16MyUserID' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2312_Exit0				;// [Qc1012]
.QLn_667		;//return
		ret		;// [Qc250]
.QLn_668		;//EndIf
.QIf2312_Exit0:
.QIf2312_EndIf:
.QLn_670		;//F131_20
		call	QFunc_F131_20				;//Call 'F131_20' [Qc234]
.QLn_672		;//EndF
		ret		;// [Qc262]
.QLn_675		;//Function chat_fifo_in:void()
.QFunc_CHAT_FIFO_IN
.QLn_677		;//if u8FifoContent = 12  then
		Ld		a,(var_byt_u8FifoContent)			;// Optimize 508 [Qc5040]
		cp		12					;// [Qc5041]
		jp		nz,QIf2337_Exit0			;// [Qc5042]
.QLn_678		;//sDb = "Fifo Full":sysDebug
		ld		hl,directstr_29+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_679		;//return
		ret		;// [Qc250]
.QLn_680		;//EndIf
.QIf2337_Exit0:
.QIf2337_EndIf:
.QLn_682		;//u16Fd(u8FifoIn) = u16Du
		ld		hl,(var_wrd_u8FifoIn) 	;//hl=value of 'var_wrd_u8FifoIn' [Qc053]
		ld		bc,ar1_wrd_u16Fd+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_60+1),hl		;// [Qc210]
		ld		hl,(var_wrd_u16Du) 	;//hl=value of 'var_wrd_u16Du' [Qc053]
.Quig_Let_60:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_684		;//strFm(u8FifoIn) = strMs
		ld		hl,(var_wrd_u8FifoIn) 	;//hl=value of 'var_wrd_u8FifoIn' [Qc053]
		ld		bc,ar1_str_strFm+2		;//Array String [Qc129]
		add		hl,hl		;// [Qc130]
		add		hl,bc		;// [Qc131]
		ld		(Quig_Let_61+2),hl		;// [Qc710]
		ld		hl,(var_str_strMs)		;//hl=pointer to string 'var_str_strMs' [Qc056]
.Quig_Let_61:
		ld		de,(0)		;// Address to be filled in [Qc217]
		call	Quig_LetString				;// 'ar1_str_strFm'= [Qc218]
.QLn_686		;//u8FifoIn = u8FifoIn + 1
		ld		hl,(var_wrd_u8FifoIn) 	;//hl=value of 'var_wrd_u8FifoIn' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_u8FifoIn),hl		;//Int variable 'var_wrd_u8FifoIn'=expression result [Qc219]
.QLn_691		;//if u8FifoIn = 13 then
		Ld		hl,(var_wrd_u8FifoIn)			;// Optimize -1a- [Qc1062]
		Ld		de,13			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2384_Exit0				;// [Qc1012]
.QLn_692		;//u8FifoIn = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_u8FifoIn),hl		;//Int variable 'var_wrd_u8FifoIn'=expression result [Qc219]
.QLn_693		;//Endif
.QIf2384_Exit0:
.QIf2384_EndIf:
.QLn_695		;//u8FifoContent = u8FifoContent + 1
		Ld		hl,var_byt_u8FifoContent				;// 5020-5021 [Qc5020]
		inc		(hl)					;// [Qc5021]
.QLn_696		;//EndF
		ret		;// [Qc262]
.QLn_698		;//Function chat_fifo_out:void()
.QFunc_CHAT_FIFO_OUT
.QLn_700		;//if u8FifoContent = 0  then
		Ld		a,(var_byt_u8FifoContent)			;// Optimize 508 [Qc5040]
		cp		0					;// [Qc5041]
		jp		nz,QIf2414_Exit0			;// [Qc5042]
.QLn_702		;//endif
.QIf2414_Exit0:
.QIf2414_EndIf:
.QLn_704		;//strIn1 = strFm(u8FifoOut)
		ld		hl,(var_wrd_u8FifoOut) 	;//hl=value of 'var_wrd_u8FifoOut' [Qc053]
		ld		bc,ar1_str_strFm+2		;//Array String [Qc129]
		add		hl,hl		;// [Qc130]
		add		hl,bc		;// [Qc131]
		ld		a,(hl)		;// [Qc132]
		inc		hl		;// [Qc133]
		ld		h,(hl)		;// [Qc134]
		ld		l,a		;// [Qc135]
;**** 'var_str_strIn1$'=Expression
		ld		de,(var_str_strIn1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strIn1'= [Qc221]
.QLn_706		;//u16Du = u16Fd(u8FifoOut)
		ld		hl,(var_wrd_u8FifoOut) 	;//hl=value of 'var_wrd_u8FifoOut' [Qc053]
		ld		bc,ar1_wrd_u16Fd+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16Du),hl		;//Int variable 'var_wrd_u16Du'=expression result [Qc219]
.QLn_708		;//u8FifoOut = u8FifoOut + 1
		ld		hl,(var_wrd_u8FifoOut) 	;//hl=value of 'var_wrd_u8FifoOut' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_u8FifoOut),hl		;//Int variable 'var_wrd_u8FifoOut'=expression result [Qc219]
.QLn_710		;//if u8FifoOut = 13 then
		Ld		hl,(var_wrd_u8FifoOut)			;// Optimize -1a- [Qc1062]
		Ld		de,13			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2456_Exit0				;// [Qc1012]
.QLn_711		;//u8FifoOut = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_u8FifoOut),hl		;//Int variable 'var_wrd_u8FifoOut'=expression result [Qc219]
.QLn_712		;//endif
.QIf2456_Exit0:
.QIf2456_EndIf:
.QLn_714		;//u8FifoContent = u8FifoContent - 1
		ld		hl,(var_byt_u8FifoContent)		;//l=value of 'var_byt_u8FifoContent' [Qc007]
		ld		h,0		;//h=0 [Qc052]
		dec		hl		;//Minus 1 [Qc093]
		ld		a,l		;//var_byt_u8FifoContent'=Expression [Qc212]
		ld		(var_byt_u8FifoContent),a		;//Copy Result into 'var_byt_u8FifoContent' [Qc213]
.QLn_716		;//EndF
		ret		;// [Qc262]
.QLn_718		;//Function game_begin:void()
.QFunc_GAME_BEGIN
.QLn_720		;//intDelay = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_722		;//imageVoipGreen.tile.set shDD_voip,0 :imageVoipGreen.refresh
		ld		hl,ImageVoipGreen_ExtDataBank		;//hl=address of 'ImageVoipGreen_ExtDataBank' [Qc223]
		push		hl		;//Store result [Qc005]
		Ld		de,var_byt_shDD_voip_status			;// Optimize -9- [Qc1070]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Tile_Set				;//Call 'ImageVoipGreen.Tile.Set' [Qc234]
		ld		hl,ImageVoipGreen		;//hl=address of 'ImageVoipGreen' [Qc223]
		call	Quig_Control_Refresh				;//Call 'ImageVoipGreen.Refresh' [Qc234]
.QLn_723		;//imageVoipRed.tile.set shDD_voip,1 	:imageVoipRed.Refresh
		ld		hl,ImageVoipRed_ExtDataBank		;//hl=address of 'ImageVoipRed_ExtDataBank' [Qc223]
		push		hl		;//Store result [Qc005]
		Ld		de,var_byt_shDD_voip_status			;// Optimize -9- [Qc1070]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Tile_Set				;//Call 'ImageVoipRed.Tile.Set' [Qc234]
		ld		hl,ImageVoipRed		;//hl=address of 'ImageVoipRed' [Qc223]
		call	Quig_Control_Refresh				;//Call 'ImageVoipRed.Refresh' [Qc234]
.QLn_724		;//labelVoip.text.set "" :labelVoip.refresh
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
		ld		de,(LabelVoip_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'LabelVoip.Text.Set' [Qc234]
		ld		hl,LabelVoip		;//hl=address of 'LabelVoip' [Qc223]
		call	Quig_Control_Refresh				;//Call 'LabelVoip.Refresh' [Qc234]
.QLn_726		;//sText ="Version: "+app.date
		ld		hl,directstr_30+2		;//hl points static string [Qc055]
		ex		de,hl 		;// [Qc269]
		ld		hl,Quig_App_Date		;//hl=address of 'Quig_App_Date' [Qc011]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_727		;//Label5.Text.Set	sText
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		ld		de,(Label5_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label5.Text.Set' [Qc234]
.QLn_728		;//Label5.Refresh
		ld		hl,Label5		;//hl=address of 'Label5' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label5.Refresh' [Qc234]
.QLn_730		;//if (u16MyUserID < u16OtherID) then
		ld		hl,(var_wrd_u16MyUserID) 	;//hl=value of 'var_wrd_u16MyUserID' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf2522_Exit0				;// [Qc1220]
.QLn_731		;//iPlayer = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iPlayer),hl		;//Int variable 'var_wrd_iPlayer'=expression result [Qc219]
.QLn_732		;//u16PlayerList(1) = u16MyUserID
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_73+1),hl		;// [Qc210]
		ld		hl,(var_wrd_u16MyUserID) 	;//hl=value of 'var_wrd_u16MyUserID' [Qc053]
.Quig_Let_73:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_733		;//u16PlayerList(2) = u16OtherID
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_74+1),hl		;// [Qc210]
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
.Quig_Let_74:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_735		;//else
		jp		QIf2522_EndIf		;//Jump to EndIf
.QIf2522_Exit0:
.QLn_736		;//iPlayer = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_iPlayer),hl		;//Int variable 'var_wrd_iPlayer'=expression result [Qc219]
.QLn_737		;//u16PlayerList(1) = u16OtherID
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_76+1),hl		;// [Qc210]
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
.Quig_Let_76:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_738		;//u16PlayerList(2) = u16MyUserID
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_77+1),hl		;// [Qc210]
		ld		hl,(var_wrd_u16MyUserID) 	;//hl=value of 'var_wrd_u16MyUserID' [Qc053]
.Quig_Let_77:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_739		;//endif
.QIf2522_Exit1:
.QIf2522_EndIf:
.QLn_743		;//Label7.Text.Set	Str(u16PlayerList(1))
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		ld		de,(Label7_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label7.Text.Set' [Qc234]
.QLn_744		;//Label7.Refresh
		ld		hl,Label7		;//hl=address of 'Label7' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label7.Refresh' [Qc234]
.QLn_745		;//Label8.Text.Set	Str(u16PlayerList(2))
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		ld		de,(Label8_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label8.Text.Set' [Qc234]
.QLn_746		;//Label8.Refresh
		ld		hl,Label8		;//hl=address of 'Label8' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label8.Refresh' [Qc234]
.QLn_748		;//u16in1 = u16PlayerList(1)
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_749		;//F131_7
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_750		;//label10.text.set strOut2
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		ld		de,(Label10_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label10.Text.Set' [Qc234]
.QLn_751		;//label10.refresh
		ld		hl,Label10		;//hl=address of 'Label10' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label10.Refresh' [Qc234]
.QLn_752		;//label12.text.set strOut2
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		ld		de,(Label12_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label12.Text.Set' [Qc234]
.QLn_753		;//label12.refresh
		ld		hl,Label12		;//hl=address of 'Label12' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label12.Refresh' [Qc234]
.QLn_756		;//u16in1 = u16PlayerList(2)
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_u16PlayerList+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_757		;//F131_7
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_758		;//label11.text.set strOut2
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		ld		de,(Label11_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label11.Text.Set' [Qc234]
.QLn_759		;//label11.refresh
		ld		hl,Label11		;//hl=address of 'Label11' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label11.Refresh' [Qc234]
.QLn_760		;//label13.text.set strOut2
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		ld		de,(Label13_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label13.Text.Set' [Qc234]
.QLn_761		;//label13.refresh
		ld		hl,Label13		;//hl=address of 'Label13' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label13.Refresh' [Qc234]
.QLn_763		;//iFlash = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iFlash),hl		;//Int variable 'var_wrd_iFlash'=expression result [Qc219]
.QLn_764		;//iWinner =0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iWinner),hl		;//Int variable 'var_wrd_iWinner'=expression result [Qc219]
.QLn_765		;//bAgain = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_bAgain),hl		;//Int variable 'var_wrd_bAgain'=expression result [Qc219]
.QLn_766		;//iPlayerActive = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iPlayerActive),hl		;//Int variable 'var_wrd_iPlayerActive'=expression result [Qc219]
.QLn_767		;//iScore(1) = 0
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_84+1),hl		;// [Qc210]
		ld		hl,0		;//hl=number '0' [Qc054]
.Quig_Let_84:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_768		;//iScore(2) = 0
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_85+1),hl		;// [Qc210]
		ld		hl,0		;//hl=number '0' [Qc054]
.Quig_Let_85:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_771		;//game_resetField
		call	QFunc_game_resetField				;//Call 'game_resetField' [Qc234]
.QLn_772		;//game_score_refresh
		call	QFunc_game_score_refresh				;//Call 'game_score_refresh' [Qc234]
.QLn_774		;//if (iPlayer = 2) then
		Ld		hl,(var_wrd_iPlayer)			;// Optimize -1a- [Qc1062]
		Ld		de,2			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2699_Exit0				;// [Qc1012]
.QLn_775		;//iGameMode = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iGameMode),hl		;//Int variable 'var_wrd_iGameMode'=expression result [Qc219]
.QLn_776		;//return
		ret		;// [Qc250]
.QLn_777		;//endif
.QIf2699_Exit0:
.QIf2699_EndIf:
.QLn_780		;//iPlayerActive = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_iPlayerActive),hl		;//Int variable 'var_wrd_iPlayerActive'=expression result [Qc219]
.QLn_781		;//net21_send
		call	QFunc_net21_send				;//Call 'net21_send' [Qc234]
.QLn_783		;//game_showTurn
		call	QFunc_game_showTurn				;//Call 'game_showTurn' [Qc234]
.QLn_785		;//iGameMode = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iGameMode),hl		;//Int variable 'var_wrd_iGameMode'=expression result [Qc219]
.QLn_786		;//EndF
		ret		;// [Qc262]
.QLn_788		;//Function game_replay:void()
.QFunc_GAME_REPLAY
.QLn_789		;//bRestart = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_bRestart),hl		;//Int variable 'var_wrd_bRestart'=expression result [Qc219]
.QLn_791		;//iFlash = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iFlash),hl		;//Int variable 'var_wrd_iFlash'=expression result [Qc219]
.QLn_792		;//iWinner =0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iWinner),hl		;//Int variable 'var_wrd_iWinner'=expression result [Qc219]
.QLn_793		;//bAgain = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_bAgain),hl		;//Int variable 'var_wrd_bAgain'=expression result [Qc219]
.QLn_794		;//iScore(1) = 0
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_93+1),hl		;// [Qc210]
		ld		hl,0		;//hl=number '0' [Qc054]
.Quig_Let_93:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_795		;//iScore(2) = 0
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_94+1),hl		;// [Qc210]
		ld		hl,0		;//hl=number '0' [Qc054]
.Quig_Let_94:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_796		;//iPlayerActive = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_iPlayerActive),hl		;//Int variable 'var_wrd_iPlayerActive'=expression result [Qc219]
.QLn_798		;//x = Rnd(2)
		ld		hl,2		;//hl=number '2' [Qc054]
		call	Quig_IRnd		;/ Call Function [Qc052]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_799		;//if (x = 0 ) then
		Ld		hl,(var_wrd_x)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2771_Exit0				;// [Qc1012]
.QLn_800		;//x = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_801		;//EndIf
.QIf2771_Exit0:
.QIf2771_EndIf:
.QLn_803		;//iPlayerActive = x
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		ld		(var_wrd_iPlayerActive),hl		;//Int variable 'var_wrd_iPlayerActive'=expression result [Qc219]
.QLn_805		;//game_resetField
		call	QFunc_game_resetField				;//Call 'game_resetField' [Qc234]
.QLn_806		;//game_score_refresh
		call	QFunc_game_score_refresh				;//Call 'game_score_refresh' [Qc234]
.QLn_808		;//net21_send
		call	QFunc_net21_send				;//Call 'net21_send' [Qc234]
.QLn_809		;//game_showTurn
		call	QFunc_game_showTurn				;//Call 'game_showTurn' [Qc234]
.QLn_811		;//strMs = "RePlay game"
		ld		hl,directstr_31+2		;//hl points static string [Qc055]
;**** 'var_str_strMs$'=Expression
		ld		de,(var_str_strMs)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strMs'= [Qc221]
.QLn_812		;//chat_send
		call	QFunc_chat_send				;//Call 'chat_send' [Qc234]
.QLn_813		;//endf
		ret		;// [Qc262]
.QLn_815		;//Function game_showTurn:void()
.QFunc_GAME_SHOWTURN
.QLn_816		;//if (iPlayerActive = 0) then
		Ld		hl,(var_wrd_iPlayerActive)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2812_Exit0				;// [Qc1012]
.QLn_817		;//sDb = "iPlayerActive = 0":sysDebug
		ld		hl,directstr_32+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_819		;//Label7.Colour.Set Colour.Black,colour.Orange,1
		ld		hl,Label7_TextAppearance		;//hl=address of 'Label7_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label7.Colour.Set' [Qc234]
.QLn_820		;//Label8.Colour.Set Colour.Black,colour.Orange,1
		ld		hl,Label8_TextAppearance		;//hl=address of 'Label8_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label8.Colour.Set' [Qc234]
.QLn_821		;//Label6.Text.Set	"Wait...."
		ld		hl,directstr_33+2		;//hl points static string [Qc055]
		ld		de,(Label6_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label6.Text.Set' [Qc234]
.QLn_823		;//label6.refresh
		ld		hl,Label6		;//hl=address of 'Label6' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label6.Refresh' [Qc234]
.QLn_824		;//label7.refresh
		ld		hl,Label7		;//hl=address of 'Label7' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label7.Refresh' [Qc234]
.QLn_825		;//label8.refresh
		ld		hl,Label8		;//hl=address of 'Label8' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label8.Refresh' [Qc234]
.QLn_826		;//return
		ret		;// [Qc250]
.QLn_827		;//endif
.QIf2812_Exit0:
.QIf2812_EndIf:
.QLn_829		;//if (iPlayerActive = 1) then
		Ld		hl,(var_wrd_iPlayerActive)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2867_Exit0				;// [Qc1012]
.QLn_830		;//Label7.Colour.Set Colour.Black,colour.Orange,1
		ld		hl,Label7_TextAppearance		;//hl=address of 'Label7_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label7.Colour.Set' [Qc234]
.QLn_831		;//Label8.Colour.Set colour.Orange,Colour.Black,1
		ld		hl,Label8_TextAppearance		;//hl=address of 'Label8_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,2		;//hl=number '2' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,1			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label8.Colour.Set' [Qc234]
.QLn_832		;//else
		jp		QIf2867_EndIf		;//Jump to EndIf
.QIf2867_Exit0:
.QLn_833		;//Label7.Colour.Set colour.Orange,Colour.Black,1
		ld		hl,Label7_TextAppearance		;//hl=address of 'Label7_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,2		;//hl=number '2' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,1			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label7.Colour.Set' [Qc234]
.QLn_834		;//Label8.Colour.Set Colour.Black,colour.Orange,1
		ld		hl,Label8_TextAppearance		;//hl=address of 'Label8_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label8.Colour.Set' [Qc234]
.QLn_835		;//Endif
.QIf2867_Exit1:
.QIf2867_EndIf:
.QLn_837		;//if (iPlayer = iPlayerActive) then
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_iPlayerActive) 	;//hl=value of 'var_wrd_iPlayerActive' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf2922_Exit0				;// [Qc1012]
.QLn_838		;//Label6.Text.Set	"Your turn"
		ld		hl,directstr_34+2		;//hl points static string [Qc055]
		ld		de,(Label6_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label6.Text.Set' [Qc234]
.QLn_839		;//else
		jp		QIf2922_EndIf		;//Jump to EndIf
.QIf2922_Exit0:
.QLn_840		;//Label6.Text.Set	"Other player"
		ld		hl,directstr_35+2		;//hl points static string [Qc055]
		ld		de,(Label6_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label6.Text.Set' [Qc234]
.QLn_841		;//Endif
.QIf2922_Exit1:
.QIf2922_EndIf:
.QLn_844		;//label6.refresh
		ld		hl,Label6		;//hl=address of 'Label6' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label6.Refresh' [Qc234]
.QLn_845		;//label7.refresh
		ld		hl,Label7		;//hl=address of 'Label7' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label7.Refresh' [Qc234]
.QLn_846		;//label8.refresh
		ld		hl,Label8		;//hl=address of 'Label8' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label8.Refresh' [Qc234]
.QLn_847		;//EndF
		ret		;// [Qc262]
.QLn_849		;//Function game_press_select:void()
.QFunc_GAME_PRESS_SELECT
.QLn_850		;//sDb="iSelect :"+str(iSelImg):sysDebug
		ld		hl,directstr_36+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_852		;//if (ImgTile(iSelImg) < 10)then
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf2975_Exit0				;// [Qc1220]
.QLn_854		;//sDb="ImgTile(iSelImg)= " +str(ImgTile(iSelImg))+ "  defTileHori= " +str(defTileHori):sysDebug
		ld		hl,directstr_37+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_38+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_defTileHori) 	;//hl=value of 'var_wrd_defTileHori' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_857		;//if (ImgTile(iSelImg)  = defTileHori) then
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,(var_wrd_defTileHori) 	;//hl=value of 'var_wrd_defTileHori' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3021_Exit0				;// [Qc1012]
.QLn_861		;//Ctrl.Image.Tile.Set ImgIds(iSelImg),shDD_hori,iPlayer
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_hori_status			;// Optimize -9- [Qc1070]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_862		;//ctrl.Refresh ImgIds(iSelImg)
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_863		;//ImgTile(iSelImg) = ImgTile(iSelImg)  or (shl4(iPlayer))
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_103+1),hl		;// [Qc210]
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		call	Quig_Shl4		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
.Quig_Let_103:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_865		;//endif
.QIf3021_Exit0:
.QIf3021_EndIf:
.QLn_867		;//if (ImgTile(iSelImg)  = defTileVert) then
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,(var_wrd_defTileVert) 	;//hl=value of 'var_wrd_defTileVert' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3094_Exit0				;// [Qc1012]
.QLn_868		;//Ctrl.Image.Tile.Set ImgIds(iSelImg),shDD_vert,iPlayer
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_vert_status			;// Optimize -9- [Qc1070]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_869		;//ctrl.Refresh ImgIds(iSelImg)
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_870		;//ImgTile(iSelImg) = ImgTile(iSelImg)  or (shl4(iPlayer))
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_104+1),hl		;// [Qc210]
		ld		hl,(var_wrd_iSelImg) 	;//hl=value of 'var_wrd_iSelImg' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		call	Quig_Shl4		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
.Quig_Let_104:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_871		;//endif
.QIf3094_Exit0:
.QIf3094_EndIf:
.QLn_873		;//game_check_box
		call	QFunc_game_check_box				;//Call 'game_check_box' [Qc234]
.QLn_874		;//game_check_score
		call	QFunc_game_check_score				;//Call 'game_check_score' [Qc234]
.QLn_875		;//game_score_refresh
		call	QFunc_game_score_refresh				;//Call 'game_score_refresh' [Qc234]
.QLn_876		;//game_next_player
		call	QFunc_game_next_player				;//Call 'game_next_player' [Qc234]
.QLn_878		;//endif
.QIf2975_Exit0:
.QIf2975_EndIf:
.QLn_879		;//iSelImg = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iSelImg),hl		;//Int variable 'var_wrd_iSelImg'=expression result [Qc219]
.QLn_881		;//endf
		ret		;// [Qc262]
.QLn_883		;//Function game_next_player:void()
.QFunc_GAME_NEXT_PLAYER
.QLn_884		;//if (bAgain = 0) then
		Ld		hl,(var_wrd_bAgain)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3178_Exit0				;// [Qc1012]
.QLn_885		;//iPlayerActive = 3 - iPlayer
		Ld 		de,3			;// 1040 [Qc1040]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		ex		de,hl		;//Sub Integer x-y [Qc059]
		or		a		;// [Qc060]
		sbc		hl,de		;// [Qc061]
		ld		(var_wrd_iPlayerActive),hl		;//Int variable 'var_wrd_iPlayerActive'=expression result [Qc219]
.QLn_886		;//else
		jp		QIf3178_EndIf		;//Jump to EndIf
.QIf3178_Exit0:
.QLn_887		;//iPlayerActive = iPlayer
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		ld		(var_wrd_iPlayerActive),hl		;//Int variable 'var_wrd_iPlayerActive'=expression result [Qc219]
.QLn_888		;//endif
.QIf3178_Exit1:
.QIf3178_EndIf:
.QLn_890		;//iSelImg = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iSelImg),hl		;//Int variable 'var_wrd_iSelImg'=expression result [Qc219]
.QLn_891		;//net21_send
		call	QFunc_net21_send				;//Call 'net21_send' [Qc234]
.QLn_892		;//game_showTurn
		call	QFunc_game_showTurn				;//Call 'game_showTurn' [Qc234]
.QLn_894		;//endf
		ret		;// [Qc262]
.QLn_897		;//Function game_check_box:void()
.QFunc_GAME_CHECK_BOX
.QLn_901		;//Data.Set BoxData
		LD HL,BOXDATA
		LD (Quig_DataAddr),HL
.QLn_902		;//for t = 1 to 25
		ld		hl,25		;//hl=number '25' [Qc054]
		ld 		(QFr3213_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr3213_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr3213_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr3213_Start	;// [Qc307]
		jp		nz,QFr3213_Exit	;// [Qc308]
.QFr3213_Start:
.QLn_903		;//a = Data.Byte
		call	Quig_Data_Byte		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_904		;//if (ImgTile(a) < 10) then
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf3238_Exit0				;// [Qc1220]
.QLn_905		;//if (ImgTile(a - 11) > 10) and (ImgTile(a + 1) > 10) and (ImgTile(a + 11) > 10) and (ImgTile(a - 1) > 10) then
		Ld		hl,(var_wrd_a)			;// 1064_1065 [Qc1064]
		Ld		de,11			;// [Qc1065]
		or		a		;// [Qc060]
		sbc		hl,de		;// [Qc061]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_a)			;// 1060-1061 [Qc1060]
		Ld		de,11			;// [Qc1061]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_a)			;// 1064_1065 [Qc1064]
		Ld		de,1			;// [Qc1065]
		or		a		;// [Qc060]
		sbc		hl,de		;// [Qc061]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf3324_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_907		;//Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,iPlayer
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_fill_status			;// Optimize -9- [Qc1070]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_908		;//Ctrl.Refresh ImgIds(a)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_909		;//ImgTile(a) = ImgTile(a) or shl4(iPlayer)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_110+1),hl		;// [Qc210]
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iPlayer) 	;//hl=value of 'var_wrd_iPlayer' [Qc053]
		call	Quig_Shl4		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
.Quig_Let_110:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_910		;//endif
.QIf3324_Exit0:
.QIf3324_EndIf:
.QLn_911		;//endif
.QIf3238_Exit0:
.QIf3238_EndIf:
.QLn_912		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr3213_Loop		;// [Qc340]
.QFr3213_Exit:
.QLn_913		;//endf
		ret		;// [Qc262]
.QLn_915		;//Function game_check_score:void()
.QFunc_GAME_CHECK_SCORE
.QLn_918		;//x = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_919		;//y = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_921		;//Data.Set BoxData
		LD HL,BOXDATA
		LD (Quig_DataAddr),HL
.QLn_922		;//for t = 1 to 25
		ld		hl,25		;//hl=number '25' [Qc054]
		ld 		(QFr3402_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr3402_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr3402_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr3402_Start	;// [Qc307]
		jp		nz,QFr3402_Exit	;// [Qc308]
.QFr3402_Start:
.QLn_923		;//a = Data.Byte
		call	Quig_Data_Byte		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_925		;//if (Shr4(ImgTile(a)) = 1) then
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Shr4		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,1		;//hl=number '1' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3433_Exit0				;// [Qc1012]
.QLn_926		;//x = x + 1
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_927		;//endif
.QIf3433_Exit0:
.QIf3433_EndIf:
.QLn_929		;//if (Shr4(ImgTile(a)) = 2) then
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Shr4		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3461_Exit0				;// [Qc1012]
.QLn_930		;//y = y + 1
		ld		hl,(var_wrd_y) 	;//hl=value of 'var_wrd_y' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_931		;//endif
.QIf3461_Exit0:
.QIf3461_EndIf:
.QLn_932		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr3402_Loop		;// [Qc340]
.QFr3402_Exit:
.QLn_935		;//bAgain = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_bAgain),hl		;//Int variable 'var_wrd_bAgain'=expression result [Qc219]
.QLn_936		;//if ((x+y) > (iScore(1) + iScore(2))) then
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_y) 	;//hl=value of 'var_wrd_y' [Qc053]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		push		hl 		;//Store result [Qc001]
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc001]
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		pop		de		;//Restore value from stack [Qc050]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf3506_Exit0				;// [Qc1220]
.QLn_937		;//bAgain = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_bAgain),hl		;//Int variable 'var_wrd_bAgain'=expression result [Qc219]
.QLn_938		;//endif
.QIf3506_Exit0:
.QIf3506_EndIf:
.QLn_940		;//iScore(1) = x
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_118+1),hl		;// [Qc210]
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
.Quig_Let_118:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_941		;//iScore(2) = y
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_119+1),hl		;// [Qc210]
		ld		hl,(var_wrd_y) 	;//hl=value of 'var_wrd_y' [Qc053]
.Quig_Let_119:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_944		;//endf
		ret		;// [Qc262]
.QLn_946		;//Function game_score_refresh:void()
.QFunc_GAME_SCORE_REFRESH
.QLn_950		;//x = (iScore(1) / 10) and 15
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_Div16		;//Divide HL by DE [Qc062]
		Ld		a,15	 				;// Optimize 526 [Qc5136]
		And		l							;// [Qc5137]
		Ld		l,a							;// [Qc5138]
		Ld		h,0		 					;// [Qc5139]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_952		;//Image122.Tile.Set shDD_digi,(x+10)
		ld		hl,Image122_ExtDataBank		;//hl=address of 'Image122_ExtDataBank' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,var_byt_shDD_digi_status		;//hl=address of 'var_byt_shDD_digi_status' [Qc011]
		push		hl		;// Store result [Qc225]
		Ld		hl,(var_wrd_x)			;// 1060-1061 [Qc1060]
		Ld		de,10			;// [Qc1061]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_Tile_Set				;//Call 'Image122.Tile.Set' [Qc234]
.QLn_953		;//Image122.Refresh
		ld		hl,Image122		;//hl=address of 'Image122' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Image122.Refresh' [Qc234]
.QLn_955		;//y = iScore(1) - (x*10)
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_x)			;// Optimize -1- [Qc1001]
		Ld		hl,10			;// [Qc1002]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		pop		de		;//Restore value from stack [Qc050]
		ex		de,hl		;//Sub Integer x-y [Qc059]
		or		a		;// [Qc060]
		sbc		hl,de		;// [Qc061]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_957		;//Image123.Tile.Set shDD_digi,(y+10)
		ld		hl,Image123_ExtDataBank		;//hl=address of 'Image123_ExtDataBank' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,var_byt_shDD_digi_status		;//hl=address of 'var_byt_shDD_digi_status' [Qc011]
		push		hl		;// Store result [Qc225]
		Ld		hl,(var_wrd_y)			;// 1060-1061 [Qc1060]
		Ld		de,10			;// [Qc1061]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_Tile_Set				;//Call 'Image123.Tile.Set' [Qc234]
.QLn_958		;//Image123.Refresh
		ld		hl,Image123		;//hl=address of 'Image123' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Image123.Refresh' [Qc234]
.QLn_962		;//x = (iScore(2) / 10) and 15
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_Div16		;//Divide HL by DE [Qc062]
		Ld		a,15	 				;// Optimize 526 [Qc5136]
		And		l							;// [Qc5137]
		Ld		l,a							;// [Qc5138]
		Ld		h,0		 					;// [Qc5139]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_964		;//Image126.Tile.Set shDD_digi,(x+0)
		ld		hl,Image126_ExtDataBank		;//hl=address of 'Image126_ExtDataBank' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,var_byt_shDD_digi_status		;//hl=address of 'var_byt_shDD_digi_status' [Qc011]
		push		hl		;// Store result [Qc225]
		Ld		hl,(var_wrd_x)			;// 1060-1061 [Qc1060]
		Ld		de,0			;// [Qc1061]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_Tile_Set				;//Call 'Image126.Tile.Set' [Qc234]
.QLn_965		;//Image126.Refresh
		ld		hl,Image126		;//hl=address of 'Image126' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Image126.Refresh' [Qc234]
.QLn_967		;//y = iScore(2) - (x*10)
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_x)			;// Optimize -1- [Qc1001]
		Ld		hl,10			;// [Qc1002]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		pop		de		;//Restore value from stack [Qc050]
		ex		de,hl		;//Sub Integer x-y [Qc059]
		or		a		;// [Qc060]
		sbc		hl,de		;// [Qc061]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_969		;//Image127.Tile.Set shDD_digi,(y+0)
		ld		hl,Image127_ExtDataBank		;//hl=address of 'Image127_ExtDataBank' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,var_byt_shDD_digi_status		;//hl=address of 'var_byt_shDD_digi_status' [Qc011]
		push		hl		;// Store result [Qc225]
		Ld		hl,(var_wrd_y)			;// 1060-1061 [Qc1060]
		Ld		de,0			;// [Qc1061]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_Tile_Set				;//Call 'Image127.Tile.Set' [Qc234]
.QLn_970		;//Image127.Refresh
		ld		hl,Image127		;//hl=address of 'Image127' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Image127.Refresh' [Qc234]
.QLn_972		;//iWinner = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iWinner),hl		;//Int variable 'var_wrd_iWinner'=expression result [Qc219]
.QLn_973		;//if ((iScore(1) + iScore(2))=25) then
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc001]
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ex		de,hl 		;// [Qc269]
		ld		hl,25		;//hl=number '25' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3704_Exit0				;// [Qc1012]
.QLn_974		;//if (iScore(1) > iScore(2)) then
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc001]
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		pop		de		;//Restore value from stack [Qc050]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf3727_Exit0				;// [Qc1220]
.QLn_975		;//iWinner = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iWinner),hl		;//Int variable 'var_wrd_iWinner'=expression result [Qc219]
.QLn_976		;//else
		jp		QIf3727_EndIf		;//Jump to EndIf
.QIf3727_Exit0:
.QLn_977		;//iWinner = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_iWinner),hl		;//Int variable 'var_wrd_iWinner'=expression result [Qc219]
.QLn_978		;//endif
.QIf3727_Exit1:
.QIf3727_EndIf:
.QLn_979		;//endif
.QIf3704_Exit0:
.QIf3704_EndIf:
.QLn_980		;//endf
		ret		;// [Qc262]
.QLn_982		;//Function game_new_field:void()
.QFunc_GAME_NEW_FIELD
.QLn_985		;//bNew_field = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_bNew_field),hl		;//Int variable 'var_wrd_bNew_field'=expression result [Qc219]
.QLn_986		;//iSelImg = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iSelImg),hl		;//Int variable 'var_wrd_iSelImg'=expression result [Qc219]
.QLn_988		;//iPlayerActive = ImgTileCom(1)
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_ImgTileCom+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_iPlayerActive),hl		;//Int variable 'var_wrd_iPlayerActive'=expression result [Qc219]
.QLn_989		;//iScore(1) = ImgTileCom(2)
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_130+1),hl		;// [Qc210]
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_ImgTileCom+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
.Quig_Let_130:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_990		;//iScore(2) = ImgTileCom(3)
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_131+1),hl		;// [Qc210]
		ld		hl,3		;//hl=number '3' [Qc054]
		ld		bc,ar1_wrd_ImgTileCom+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
.Quig_Let_131:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_992		;//sDb ="Active player "+str(iPlayerActive):sysDebug
		ld		hl,directstr_39+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iPlayerActive) 	;//hl=value of 'var_wrd_iPlayerActive' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_994		;//For t=1 to 122
		ld		hl,122		;//hl=number '122' [Qc054]
		ld 		(QFr3809_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr3809_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr3809_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr3809_Start	;// [Qc307]
		jp		nz,QFr3809_Exit	;// [Qc308]
.QFr3809_Start:
.QLn_995		;//if (ImgTileCom(t+4) <> ImgTile(t)) then
		Ld		hl,(var_wrd_t)			;// 1060-1061 [Qc1060]
		Ld		de,4			;// [Qc1061]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ld		bc,ar1_wrd_ImgTileCom+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		pop		de		;//Restore value from stack [Qc050]
		Xor 	a						;// Optimize -3b- [Qc1213]
		sbc		hl,de					;// [Qc1214]
		jp		z,QIf3847_Exit0				;// [Qc1215]
.QLn_996		;//ImgTile(t) = ImgTileCom(t+4)
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_133+1),hl		;// [Qc210]
		Ld		hl,(var_wrd_t)			;// 1060-1061 [Qc1060]
		Ld		de,4			;// [Qc1061]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ld		bc,ar1_wrd_ImgTileCom+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
.Quig_Let_133:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_998		;//sDb = "newField img"+str(t):sysDebug
		ld		hl,directstr_40+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1000		;//x = shr4(ImgTile(t))	//.. player color
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Shr4		;/ Call Function [Qc052]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_1001		;//y = ImgTile(t) and 15	//.. tile type hor vert
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,15		;//hl=number '15' [Qc054]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_1003		;//if (y = defTileHori) then
		ld		hl,(var_wrd_y) 	;//hl=value of 'var_wrd_y' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defTileHori) 	;//hl=value of 'var_wrd_defTileHori' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3919_Exit0				;// [Qc1012]
.QLn_1004		;//Ctrl.Image.Tile.Set ImgIds(t),shDD_hori,x
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_hori_status			;// Optimize -9- [Qc1070]
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1005		;//Ctrl.Refresh ImgIds(t)
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1006		;//endif
.QIf3919_Exit0:
.QIf3919_EndIf:
.QLn_1008		;//if (y = defTileVert) then
		ld		hl,(var_wrd_y) 	;//hl=value of 'var_wrd_y' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defTileVert) 	;//hl=value of 'var_wrd_defTileVert' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3959_Exit0				;// [Qc1012]
.QLn_1009		;//Ctrl.Image.Tile.Set ImgIds(t),shDD_vert,x
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_vert_status			;// Optimize -9- [Qc1070]
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1010		;//Ctrl.Refresh ImgIds(t)
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1011		;//endif
.QIf3959_Exit0:
.QIf3959_EndIf:
.QLn_1013		;//if (y = defTileBox) then
		ld		hl,(var_wrd_y) 	;//hl=value of 'var_wrd_y' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defTileBox) 	;//hl=value of 'var_wrd_defTileBox' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf3999_Exit0				;// [Qc1012]
.QLn_1014		;//Ctrl.Image.Tile.Set ImgIds(t),shDD_fill,x
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_fill_status			;// Optimize -9- [Qc1070]
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1015		;//Ctrl.Refresh ImgIds(t)
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1016		;//endif
.QIf3999_Exit0:
.QIf3999_EndIf:
.QLn_1018		;//endif
.QIf3847_Exit0:
.QIf3847_EndIf:
.QLn_1019		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr3809_Loop		;// [Qc340]
.QFr3809_Exit:
.QLn_1021		;//game_score_refresh
		call	QFunc_game_score_refresh				;//Call 'game_score_refresh' [Qc234]
.QLn_1022		;//game_showTurn
		call	QFunc_game_showTurn				;//Call 'game_showTurn' [Qc234]
.QLn_1023		;//EndF
		ret		;// [Qc262]
.QLn_1025		;//Function CrtlEventToImg:void()
.QFunc_CRTLEVENTTOIMG
.QLn_1026		;//x = Ctrl.GetID(Form1,Event.Control)
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,(Event_Control_ID)		;//hl=value of 'Event_Control_ID' [Qc010]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_1027		;//iSelImg = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iSelImg),hl		;//Int variable 'var_wrd_iSelImg'=expression result [Qc219]
.QLn_1029		;//for t = 1 to 122
		ld		hl,122		;//hl=number '122' [Qc054]
		ld 		(QFr4055_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4055_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4055_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4055_Start	;// [Qc307]
		jp		nz,QFr4055_Exit	;// [Qc308]
.QFr4055_Start:
.QLn_1030		;//y = ImgIds(t)
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_1031		;//if (x = y) then
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_y) 	;//hl=value of 'var_wrd_y' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4085_Exit0				;// [Qc1012]
.QLn_1032		;//iSelImg  = t
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		(var_wrd_iSelImg),hl		;//Int variable 'var_wrd_iSelImg'=expression result [Qc219]
.QLn_1033		;//t=123
		ld		hl,123		;//hl=number '123' [Qc054]
		ld		(var_wrd_t),hl		;//Int variable 'var_wrd_t'=expression result [Qc219]
.QLn_1034		;//endif
.QIf4085_Exit0:
.QIf4085_EndIf:
.QLn_1035		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4055_Loop		;// [Qc340]
.QFr4055_Exit:
.QLn_1036		;//endf
		ret		;// [Qc262]
.QLn_1038		;//Function game_resetField:void()
.QFunc_GAME_RESETFIELD
.QLn_1040		;//LoadImgCtrls
		call	QFunc_LoadImgCtrls				;//Call 'LoadImgCtrls' [Qc234]
.QLn_1042		;//for t =  1 to 121
		ld		hl,121		;//hl=number '121' [Qc054]
		ld 		(QFr4109_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4109_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4109_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4109_Start	;// [Qc307]
		jp		nz,QFr4109_Exit	;// [Qc308]
.QFr4109_Start:
.QLn_1043		;//ImgTile(t) = 0
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_142+1),hl		;// [Qc210]
		ld		hl,0		;//hl=number '0' [Qc054]
.Quig_Let_142:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1044		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4109_Loop		;// [Qc340]
.QFr4109_Exit:
.QLn_1046		;//if (defTileEmpty <> 0) then
		Ld		de,(var_wrd_defTileEmpty)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		Xor 	a						;// Optimize -3b- [Qc1213]
		sbc		hl,de					;// [Qc1214]
		jp		z,QIf4143_Exit0				;// [Qc1215]
.QLn_1047		;//sDb="?? empty is niet nul !!!":sysDebug
		ld		hl,directstr_41+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1048		;//endif
.QIf4143_Exit0:
.QIf4143_EndIf:
.QLn_1050		;//Data.Set DotsData
		LD HL,DOTSDATA
		LD (Quig_DataAddr),HL
.QLn_1051		;//for t = 1 to 36
		ld		hl,36		;//hl=number '36' [Qc054]
		ld 		(QFr4159_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4159_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4159_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4159_Start	;// [Qc307]
		jp		nz,QFr4159_Exit	;// [Qc308]
.QFr4159_Start:
.QLn_1052		;//a = Data.Byte
		call	Quig_Data_Byte		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_1053		;//Ctrl.Image.Tile.Set ImgIds(a),shDD_dot,1
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_dot_status			;// Optimize -9- [Qc1070]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1054		;//Ctrl.Refresh ImgIds(a)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1055		;//ImgTile(a) = defTileDot
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_145+1),hl		;// [Qc210]
		ld		hl,(var_wrd_defTileDot) 	;//hl=value of 'var_wrd_defTileDot' [Qc053]
.Quig_Let_145:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1056		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4159_Loop		;// [Qc340]
.QFr4159_Exit:
.QLn_1058		;//Data.Set HoriData
		LD HL,HORIDATA
		LD (Quig_DataAddr),HL
.QLn_1059		;//for t = 1 to 30
		ld		hl,30		;//hl=number '30' [Qc054]
		ld 		(QFr4214_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4214_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4214_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4214_Start	;// [Qc307]
		jp		nz,QFr4214_Exit	;// [Qc308]
.QFr4214_Start:
.QLn_1060		;//a = Data.Byte
		call	Quig_Data_Byte		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_1061		;//Ctrl.Image.Tile.Set ImgIds(a),shDD_hori,0
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_hori_status			;// Optimize -9- [Qc1070]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1062		;//Ctrl.Refresh ImgIds(a)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1063		;//ImgTile(a) = defTileHori
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_147+1),hl		;// [Qc210]
		ld		hl,(var_wrd_defTileHori) 	;//hl=value of 'var_wrd_defTileHori' [Qc053]
.Quig_Let_147:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1064		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4214_Loop		;// [Qc340]
.QFr4214_Exit:
.QLn_1066		;//Data.Set VeriData
		LD HL,VERIDATA
		LD (Quig_DataAddr),HL
.QLn_1067		;//for t = 1 to 30
		ld		hl,30		;//hl=number '30' [Qc054]
		ld 		(QFr4269_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4269_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4269_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4269_Start	;// [Qc307]
		jp		nz,QFr4269_Exit	;// [Qc308]
.QFr4269_Start:
.QLn_1068		;//a = Data.Byte
		call	Quig_Data_Byte		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_1069		;//Ctrl.Image.Tile.Set ImgIds(a),shDD_vert,0
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_vert_status			;// Optimize -9- [Qc1070]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1070		;//Ctrl.Refresh ImgIds(a)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1071		;//ImgTile(a) = defTileVert
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_149+1),hl		;// [Qc210]
		ld		hl,(var_wrd_defTileVert) 	;//hl=value of 'var_wrd_defTileVert' [Qc053]
.Quig_Let_149:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1072		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4269_Loop		;// [Qc340]
.QFr4269_Exit:
.QLn_1074		;//Data.Set BoxData
		LD HL,BOXDATA
		LD (Quig_DataAddr),HL
.QLn_1075		;//for t = 1 to 25
		ld		hl,25		;//hl=number '25' [Qc054]
		ld 		(QFr4324_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4324_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4324_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4324_Start	;// [Qc307]
		jp		nz,QFr4324_Exit	;// [Qc308]
.QFr4324_Start:
.QLn_1076		;//a = Data.Byte
		call	Quig_Data_Byte		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_1077		;//Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,0
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_fill_status			;// Optimize -9- [Qc1070]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1078		;//Ctrl.Refresh ImgIds(a)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1079		;//ImgTile(a) = defTileBox
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_151+1),hl		;// [Qc210]
		ld		hl,(var_wrd_defTileBox) 	;//hl=value of 'var_wrd_defTileBox' [Qc053]
.Quig_Let_151:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1080		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4324_Loop		;// [Qc340]
.QFr4324_Exit:
.QLn_1081		;//EndF
		ret		;// [Qc262]
.QLn_1083		;//Function flashing:void()
.QFunc_FLASHING
.QLn_1085		;//Data.Set BoxData
		LD HL,BOXDATA
		LD (Quig_DataAddr),HL
.QLn_1086		;//for t = 1 to 25
		ld		hl,25		;//hl=number '25' [Qc054]
		ld 		(QFr4383_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4383_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4383_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4383_Start	;// [Qc307]
		jp		nz,QFr4383_Exit	;// [Qc308]
.QFr4383_Start:
.QLn_1087		;//a = Data.Byte
		call	Quig_Data_Byte		;/ Call Function [Qc052]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_1088		;//if (ImgTile(a) = iFlash) then
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		Ld 		e,(hl)			;// Optimize -11- [Qc1081]
		inc 	hl			;//  [Qc1082]
		Ld 		d,(hl)			;//  [Qc1083]
		ld		hl,(var_wrd_iFlash) 	;//hl=value of 'var_wrd_iFlash' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4413_Exit0				;// [Qc1012]
.QLn_1089		;//if (iFlashCt = 10) then
		Ld		hl,(var_wrd_iFlashCt)			;// Optimize -1a- [Qc1062]
		Ld		de,10			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4426_Exit0				;// [Qc1012]
.QLn_1090		;//Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,0
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		Ld		de,var_byt_shDD_fill_status			;// Optimize -9- [Qc1070]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1091		;//Ctrl.Refresh ImgIds(a)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1092		;//else
		jp		QIf4426_EndIf		;//Jump to EndIf
.QIf4426_Exit0:
.QLn_1093		;//Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,shr4(iFlash)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		push		hl		;// Store result [Qc225]
		ld		hl,var_byt_shDD_fill_status		;//hl=address of 'var_byt_shDD_fill_status' [Qc011]
		push		hl		;// Store result [Qc225]
		ld		hl,(var_wrd_iFlash) 	;//hl=value of 'var_wrd_iFlash' [Qc053]
		call	Quig_Shr4		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_Control_Tile_Set				;//Call 'Ctrl.Image.Tile.Set' [Qc234]
.QLn_1094		;//Ctrl.Refresh ImgIds(a)
		ld		hl,(var_wrd_a) 	;//hl=value of 'var_wrd_a' [Qc053]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		call	Quig_Control_Refresh				;//Call 'Ctrl.Refresh' [Qc234]
.QLn_1095		;//endif
.QIf4426_Exit1:
.QIf4426_EndIf:
.QLn_1096		;//endif
.QIf4413_Exit0:
.QIf4413_EndIf:
.QLn_1097		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4383_Loop		;// [Qc340]
.QFr4383_Exit:
.QLn_1098		;//endf
		ret		;// [Qc262]
.QLn_1102		;//Function sysDebug:void()
.QFunc_SYSDEBUG
.QLn_1105		;//iDbL = Len(sDb)
		ld		hl,(var_str_sDb)		;//hl=pointer to string 'var_str_sDb' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		ld		(var_wrd_iDbL),hl		;//Int variable 'var_wrd_iDbL'=expression result [Qc219]
.QLn_1106		;//For iDbT = 1 To iDbL
		ld		hl,(var_wrd_iDbL) 	;//hl=value of 'var_wrd_iDbL' [Qc053]
		ld 		(QFr4502_Top+1),hl 		;/Copy Result into static'var_wrd_iDbT' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4502_Loop:ld 		(var_wrd_iDbT),hl ;/Loop Repeat Point [Qc301]
		.QFr4502_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4502_Start	;// [Qc307]
		jp		nz,QFr4502_Exit	;// [Qc308]
.QFr4502_Start:
.QLn_1107		;//iDbC = Asc(Mid(sDb,iDbT,1))
		ld		hl,(var_str_sDb)		;//hl=pointer to string 'var_str_sDb' [Qc056]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_iDbT)			;// Optimize -1- [Qc1001]
		Ld		hl,1			;// [Qc1002]
		call	Quig_Mid		;/ Call Function [Qc052]
		call	Quig_Asc		;/ Call Function [Qc052]
		ld		(var_wrd_iDbC),hl		;//Int variable 'var_wrd_iDbC'=expression result [Qc219]
.QLn_1108		;//IO.Out ioA_0,iDbC
		ld		hl,(var_wrd_ioA_0) 	;//hl=value of 'var_wrd_ioA_0' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_iDbC) 	;//hl=value of 'var_wrd_iDbC' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1109		;//Next
		ld		hl,(var_wrd_iDbT) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4502_Loop		;// [Qc340]
.QFr4502_Exit:
.QLn_1110		;//IO.Out ioA_0,13
		ld		hl,(var_wrd_ioA_0) 	;//hl=value of 'var_wrd_ioA_0' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,13		;//hl=number '13' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1111		;//IO.Out ioA_0,10
		ld		hl,(var_wrd_ioA_0) 	;//hl=value of 'var_wrd_ioA_0' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1113		;//EndF
		ret		;// [Qc262]
.QLn_1115		;//Function net21_rec_loop:void()
.QFunc_NET21_REC_LOOP
.QLn_1117		;//u8NetStatus = IO.In(ioA_A)
		ld		hl,(var_wrd_ioA_A) 	;//hl=value of 'var_wrd_ioA_A' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8NetStatus),hl		;//Int variable 'var_wrd_u8NetStatus'=expression result [Qc219]
.QLn_1118		;//if ((u8NetStatus and DefNetStatusBitRx) = 0) then
		ld		hl,(var_wrd_u8NetStatus) 	;//hl=value of 'var_wrd_u8NetStatus' [Qc053]
		ex		de,hl 				;// Optimize 512 [Qc5055]
		Ld		hl,(var_byt_defNetStatusBitRx)				;// [Qc5056]
		Ld		h,0					;// [Qc5057]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4569_Exit0				;// [Qc1012]
.QLn_1119		;//return
		ret		;// [Qc250]
.QLn_1120		;//endif
.QIf4569_Exit0:
.QIf4569_EndIf:
.QLn_1122		;//for t = 1 to 500
		ld		hl,500		;//hl=number '500' [Qc054]
		ld 		(QFr4578_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4578_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4578_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4578_Start	;// [Qc307]
		jp		nz,QFr4578_Exit	;// [Qc308]
.QFr4578_Start:
.QLn_1123		;//net21_rec
		call	QFunc_net21_rec				;//Call 'net21_rec' [Qc234]
.QLn_1124		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4578_Loop		;// [Qc340]
.QFr4578_Exit:
.QLn_1125		;//endf
		ret		;// [Qc262]
.QLn_1127		;//Function net21_rec:void()
.QFunc_NET21_REC
.QLn_1129		;//u8NetStatus = IO.In(ioA_A)
		ld		hl,(var_wrd_ioA_A) 	;//hl=value of 'var_wrd_ioA_A' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8NetStatus),hl		;//Int variable 'var_wrd_u8NetStatus'=expression result [Qc219]
.QLn_1130		;//if ((u8NetStatus and DefNetStatusBitRx) = 0) then
		ld		hl,(var_wrd_u8NetStatus) 	;//hl=value of 'var_wrd_u8NetStatus' [Qc053]
		ex		de,hl 				;// Optimize 512 [Qc5055]
		Ld		hl,(var_byt_defNetStatusBitRx)				;// [Qc5056]
		Ld		h,0					;// [Qc5057]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4623_Exit0				;// [Qc1012]
.QLn_1131		;//return
		ret		;// [Qc250]
.QLn_1132		;//endif
.QIf4623_Exit0:
.QIf4623_EndIf:
.QLn_1134		;//u16Ur = (IO.In(ioA_B) *256) + IO.In(ioA_C)
		ld		hl,(var_wrd_ioA_B) 	;//hl=value of 'var_wrd_ioA_B' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,256		;//hl=number '256' [Qc054]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_ioA_C) 	;//hl=value of 'var_wrd_ioA_C' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ld		(var_wrd_u16Ur),hl		;//Int variable 'var_wrd_u16Ur'=expression result [Qc219]
.QLn_1135		;//u8d = IO.In(ioA_D)
		ld		hl,(var_wrd_ioA_D) 	;//hl=value of 'var_wrd_ioA_D' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
.QLn_1137		;//If u16Ur <> u16OtherID then
		ld		hl,(var_wrd_u16Ur) 	;//hl=value of 'var_wrd_u16Ur' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
		Xor 	a						;// Optimize -3b- [Qc1213]
		sbc		hl,de					;// [Qc1214]
		jp		z,QIf4657_Exit0				;// [Qc1215]
.QLn_1138		;//sDb = "<> "+str(u16Ur):sysDebug
		ld		hl,directstr_42+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_u16Ur) 	;//hl=value of 'var_wrd_u16Ur' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1139		;//return
		ret		;// [Qc250]
.QLn_1140		;//endif
.QIf4657_Exit0:
.QIf4657_EndIf:
.QLn_1142		;//if (u8d = 254) then
		Ld		hl,(var_wrd_u8d)			;// Optimize -1a- [Qc1062]
		Ld		de,254			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4686_Exit0				;// [Qc1012]
.QLn_1143		;//iRecPointer = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iRecPointer),hl		;//Int variable 'var_wrd_iRecPointer'=expression result [Qc219]
.QLn_1144		;//return				//..start
		ret		;// [Qc250]
.QLn_1145		;//endif
.QIf4686_Exit0:
.QIf4686_EndIf:
.QLn_1147		;//if (u8d = 255) then
		Ld		hl,(var_wrd_u8d)			;// Optimize -1a- [Qc1062]
		Ld		de,255			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4707_Exit0				;// [Qc1012]
.QLn_1148		;//bNew_field = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_bNew_field),hl		;//Int variable 'var_wrd_bNew_field'=expression result [Qc219]
.QLn_1150		;//if ((iRecPointer-1) <> 125) then
		ld		hl,(var_wrd_iRecPointer) 	;//hl=value of 'var_wrd_iRecPointer' [Qc053]
		dec		hl		;//Minus 1 [Qc093]
		ex		de,hl 		;// [Qc269]
		ld		hl,125		;//hl=number '125' [Qc054]
		Xor 	a						;// Optimize -3b- [Qc1213]
		sbc		hl,de					;// [Qc1214]
		jp		z,QIf4724_Exit0				;// [Qc1215]
.QLn_1151		;//bReSend = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_bReSend),hl		;//Int variable 'var_wrd_bReSend'=expression result [Qc219]
.QLn_1152		;//strMs = "!! Communication Error"
		ld		hl,directstr_43+2		;//hl points static string [Qc055]
;**** 'var_str_strMs$'=Expression
		ld		de,(var_str_strMs)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strMs'= [Qc221]
.QLn_1153		;//chat_send
		call	QFunc_chat_send				;//Call 'chat_send' [Qc234]
.QLn_1154		;//endif
.QIf4724_Exit0:
.QIf4724_EndIf:
.QLn_1155		;//return				//..end
		ret		;// [Qc250]
.QLn_1156		;//endif
.QIf4707_Exit0:
.QIf4707_EndIf:
.QLn_1158		;//if (iRecPointer > 0) and (iRecPointer < 135) then
		Ld		de,(var_wrd_iRecPointer)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_iRecPointer)			;// Optimize -1- [Qc1001]
		Ld		hl,135			;// [Qc1002]
		call	Quig_LT_HL		;/Checks HL<DE - True HL=1 False HL=0 [Qc117]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf4762_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_1159		;//ImgTileCom(iRecPointer) = u8d
		ld		hl,(var_wrd_iRecPointer) 	;//hl=value of 'var_wrd_iRecPointer' [Qc053]
		ld		bc,ar1_wrd_ImgTileCom+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_164+1),hl		;// [Qc210]
		ld		hl,(var_wrd_u8d) 	;//hl=value of 'var_wrd_u8d' [Qc053]
.Quig_Let_164:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1160		;//iRecPointer	= iRecPointer + 1
		ld		hl,(var_wrd_iRecPointer) 	;//hl=value of 'var_wrd_iRecPointer' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iRecPointer),hl		;//Int variable 'var_wrd_iRecPointer'=expression result [Qc219]
.QLn_1161		;//return
		ret		;// [Qc250]
.QLn_1162		;//endif
.QIf4762_Exit0:
.QIf4762_EndIf:
.QLn_1163		;//Endf
		ret		;// [Qc262]
.QLn_1168		;//Function net21_send:void()
.QFunc_NET21_SEND
.QLn_1173		;//u8h = (u16OtherID / 256)
		Ld		de,(var_wrd_u16OtherID)			;// Optimize -1- [Qc1001]
		Ld		hl,256			;// [Qc1002]
		call	Quig_Div16		;//Divide HL by DE [Qc062]
		ld		(var_wrd_u8h),hl		;//Int variable 'var_wrd_u8h'=expression result [Qc219]
.QLn_1174		;//u8l = (u16OtherID and 255)
		Ld		de,(var_wrd_u16OtherID)			;// Optimize -1- [Qc1001]
		Ld		hl,255			;// [Qc1002]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		(var_wrd_u8l),hl		;//Int variable 'var_wrd_u8l'=expression result [Qc219]
.QLn_1176		;//IO.Out ioA_B,u8h
		ld		hl,(var_wrd_ioA_B) 	;//hl=value of 'var_wrd_ioA_B' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_u8h) 	;//hl=value of 'var_wrd_u8h' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1177		;//IO.Out ioA_C,u8L
		ld		hl,(var_wrd_ioA_C) 	;//hl=value of 'var_wrd_ioA_C' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_u8l) 	;//hl=value of 'var_wrd_u8l' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1179		;//u8d = 254			:net21_sendTx 	//..start
		ld		hl,254		;//hl=number '254' [Qc054]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
		call	QFunc_net21_sendTx				;//Call 'net21_sendTx' [Qc234]
.QLn_1180		;//u8d = iPlayerActive	:net21_sendTx 	//..keer om
		ld		hl,(var_wrd_iPlayerActive) 	;//hl=value of 'var_wrd_iPlayerActive' [Qc053]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
		call	QFunc_net21_sendTx				;//Call 'net21_sendTx' [Qc234]
.QLn_1181		;//u8d = iScore(1) 	:net21_sendTx
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
		call	QFunc_net21_sendTx				;//Call 'net21_sendTx' [Qc234]
.QLn_1182		;//u8d = iScore(2) 	:net21_sendTx
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_iScore+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
		call	QFunc_net21_sendTx				;//Call 'net21_sendTx' [Qc234]
.QLn_1183		;//u8d = 111  			:net21_sendTx
		ld		hl,111		;//hl=number '111' [Qc054]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
		call	QFunc_net21_sendTx				;//Call 'net21_sendTx' [Qc234]
.QLn_1185		;//For t = 1 to 121
		ld		hl,121		;//hl=number '121' [Qc054]
		ld 		(QFr4849_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4849_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr4849_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4849_Start	;// [Qc307]
		jp		nz,QFr4849_Exit	;// [Qc308]
.QFr4849_Start:
.QLn_1186		;//u8d = ImgTile(t)
		ld		hl,(var_wrd_t) 	;//hl=value of 'var_wrd_t' [Qc053]
		ld		bc,ar1_wrd_ImgTile+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
.QLn_1187		;//net21_sendTx
		call	QFunc_net21_sendTx				;//Call 'net21_sendTx' [Qc234]
.QLn_1188		;//next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4849_Loop		;// [Qc340]
.QFr4849_Exit:
.QLn_1190		;//u8d = 255		:net21_sendTx 	//..end
		ld		hl,255		;//hl=number '255' [Qc054]
		ld		(var_wrd_u8d),hl		;//Int variable 'var_wrd_u8d'=expression result [Qc219]
		call	QFunc_net21_sendTx				;//Call 'net21_sendTx' [Qc234]
.QLn_1192		;//EndF
		ret		;// [Qc262]
.QLn_1195		;//Function net21_sendTx:void()
.QFunc_NET21_SENDTX
.QLn_1197		;//for w = 1 to 1000
		ld		hl,1000		;//hl=number '1000' [Qc054]
		ld 		(QFr4885_Top+1),hl 		;/Copy Result into static'var_wrd_w' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr4885_Loop:ld 		(var_wrd_w),hl ;/Loop Repeat Point [Qc301]
		.QFr4885_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr4885_Start	;// [Qc307]
		jp		nz,QFr4885_Exit	;// [Qc308]
.QFr4885_Start:
.QLn_1198		;//u8NetStatus = IO.In(ioA_A)
		ld		hl,(var_wrd_ioA_A) 	;//hl=value of 'var_wrd_ioA_A' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8NetStatus),hl		;//Int variable 'var_wrd_u8NetStatus'=expression result [Qc219]
.QLn_1200		;//if (w > 800) then
		Ld		de,(var_wrd_w)			;// Optimize -1- [Qc1001]
		Ld		hl,800			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf4904_Exit0				;// [Qc1220]
.QLn_1201		;//Label1.text.set "> 800"
		ld		hl,directstr_44+2		;//hl points static string [Qc055]
		ld		de,(Label1_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label1.Text.Set' [Qc234]
.QLn_1202		;//label1.refresh
		ld		hl,Label1		;//hl=address of 'Label1' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label1.Refresh' [Qc234]
.QLn_1203		;//w = 1000
		ld		hl,1000		;//hl=number '1000' [Qc054]
		ld		(var_wrd_w),hl		;//Int variable 'var_wrd_w'=expression result [Qc219]
.QLn_1204		;//endif
.QIf4904_Exit0:
.QIf4904_EndIf:
.QLn_1206		;//if ((u8NetStatus and defNetStatusBitTx) = 0) then
		ld		hl,(var_wrd_u8NetStatus) 	;//hl=value of 'var_wrd_u8NetStatus' [Qc053]
		ex		de,hl 				;// Optimize 512 [Qc5055]
		Ld		hl,(var_byt_defNetStatusBitTx)				;// [Qc5056]
		Ld		h,0					;// [Qc5057]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf4940_Exit0				;// [Qc1012]
.QLn_1207		;//w = 1000
		ld		hl,1000		;//hl=number '1000' [Qc054]
		ld		(var_wrd_w),hl		;//Int variable 'var_wrd_w'=expression result [Qc219]
.QLn_1208		;//endif
.QIf4940_Exit0:
.QIf4940_EndIf:
.QLn_1209		;//next
		ld		hl,(var_wrd_w) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr4885_Loop		;// [Qc340]
.QFr4885_Exit:
.QLn_1211		;//IO.Out ioA_D,u8d
		ld		hl,(var_wrd_ioA_D) 	;//hl=value of 'var_wrd_ioA_D' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_u8d) 	;//hl=value of 'var_wrd_u8d' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1212		;//Endf
		ret		;// [Qc262]
.QLn_1217		;//Function VoipHandler:Void()
.QFunc_VOIPHANDLER
.QLn_1219		;//If iDelayVoipCt < 10 Then
		Ld		de,(var_wrd_iDelayVoipCt)			;// Optimize -1- [Qc1001]
		Ld		hl,10			;// [Qc1002]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf4968_Exit0				;// [Qc1220]
.QLn_1220		;//iDelayVoipCt = iDelayVoipCt + 1
		ld		hl,(var_wrd_iDelayVoipCt) 	;//hl=value of 'var_wrd_iDelayVoipCt' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iDelayVoipCt),hl		;//Int variable 'var_wrd_iDelayVoipCt'=expression result [Qc219]
.QLn_1221		;//Return
		ret		;// [Qc250]
.QLn_1222		;//EndIf
.QIf4968_Exit0:
.QIf4968_EndIf:
.QLn_1223		;//iDelayVoipCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iDelayVoipCt),hl		;//Int variable 'var_wrd_iDelayVoipCt'=expression result [Qc219]
.QLn_1226		;//if (iVoipChgCt < 20) then
		Ld		de,(var_wrd_iVoipChgCt)			;// Optimize -1- [Qc1001]
		Ld		hl,20			;// [Qc1002]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf4988_Exit0				;// [Qc1220]
.QLn_1227		;//iVoipChgCt = iVoipChgCt + 1
		ld		hl,(var_wrd_iVoipChgCt) 	;//hl=value of 'var_wrd_iVoipChgCt' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iVoipChgCt),hl		;//Int variable 'var_wrd_iVoipChgCt'=expression result [Qc219]
.QLn_1228		;//endif
.QIf4988_Exit0:
.QIf4988_EndIf:
.QLn_1229		;//if (iVoipChgCt  = 18) then
		Ld		hl,(var_wrd_iVoipChgCt)			;// Optimize -1a- [Qc1062]
		Ld		de,18			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5008_Exit0				;// [Qc1012]
.QLn_1230		;//iVoipStatusOld = 255
		ld		hl,255		;//hl=number '255' [Qc054]
		ld		(var_wrd_iVoipStatusOld),hl		;//Int variable 'var_wrd_iVoipStatusOld'=expression result [Qc219]
.QLn_1231		;//VoipSeStatus
		call	QFunc_VoipSeStatus				;//Call 'VoipSeStatus' [Qc234]
.QLn_1232		;//endif
.QIf5008_Exit0:
.QIf5008_EndIf:
.QLn_1234		;//VoipSeStatus
		call	QFunc_VoipSeStatus				;//Call 'VoipSeStatus' [Qc234]
.QLn_1237		;//endf
		ret		;// [Qc262]
.QLn_1239		;//Function VoipGreenButton:Void()
.QFunc_VOIPGREENBUTTON
.QLn_1241		;//sDb="green  button":sysDebug
		ld		hl,directstr_45+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1243		;//if (iVoipStatus = defVoipIdle) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipIdle) 	;//hl=value of 'var_wrd_defVoipIdle' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5041_Exit0				;// [Qc1012]
.QLn_1244		;//VoipCallUser
		call	QFunc_VoipCallUser				;//Call 'VoipCallUser' [Qc234]
.QLn_1245		;//endif
.QIf5041_Exit0:
.QIf5041_EndIf:
.QLn_1247		;//if (iVoipStatus = defVoipIncommingCall) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipIncommingCall) 	;//hl=value of 'var_wrd_defVoipIncommingCall' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5059_Exit0				;// [Qc1012]
.QLn_1248		;//VoipCallAccept
		call	QFunc_VoipCallAccept				;//Call 'VoipCallAccept' [Qc234]
.QLn_1249		;//endif
.QIf5059_Exit0:
.QIf5059_EndIf:
.QLn_1251		;//endf
		ret		;// [Qc262]
.QLn_1253		;//Function VoipRedButton:Void()
.QFunc_VOIPREDBUTTON
.QLn_1254		;//sDb="red button" :sysDebug
		ld		hl,directstr_46+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1255		;//VoipCallBreak
		call	QFunc_VoipCallBreak				;//Call 'VoipCallBreak' [Qc234]
.QLn_1256		;//endf
		ret		;// [Qc262]
.QLn_1258		;//Function VoipCallUser:Void()
.QFunc_VOIPCALLUSER
.QLn_1259		;//u16in1 = u16OtherUserId
		ld		hl,(var_wrd_u16OtherUserId) 	;//hl=value of 'var_wrd_u16OtherUserId' [Qc053]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_1260		;//F131_10
		call	QFunc_F131_10				;//Call 'F131_10' [Qc234]
.QLn_1261		;//endf
		ret		;// [Qc262]
.QLn_1263		;//Function VoipCallAccept:Void()
.QFunc_VOIPCALLACCEPT
.QLn_1264		;//F131_11
		call	QFunc_F131_11				;//Call 'F131_11' [Qc234]
.QLn_1265		;//endf
		ret		;// [Qc262]
.QLn_1267		;//Function VoipCallBreak:Void()
.QFunc_VOIPCALLBREAK
.QLn_1268		;//F131_12
		call	QFunc_F131_12				;//Call 'F131_12' [Qc234]
.QLn_1269		;//endf
		ret		;// [Qc262]
.QLn_1271		;//Function VoipSeStatus:Void()
.QFunc_VOIPSESTATUS
.QLn_1272		;//iVoipStatus = IO.In(#FF21)
		ld		hl,-223		;//hl=number '-223' [Qc054]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_iVoipStatus),hl		;//Int variable 'var_wrd_iVoipStatus'=expression result [Qc219]
.QLn_1274		;//if (iVoipStatus <> iVoipStatusOld) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_iVoipStatusOld) 	;//hl=value of 'var_wrd_iVoipStatusOld' [Qc053]
		Xor 	a						;// Optimize -3b- [Qc1213]
		sbc		hl,de					;// [Qc1214]
		jp		z,QIf5118_Exit0				;// [Qc1215]
.QLn_1276		;//iVoipStatusOld = iVoipStatus
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ld		(var_wrd_iVoipStatusOld),hl		;//Int variable 'var_wrd_iVoipStatusOld'=expression result [Qc219]
.QLn_1278		;//sDb = "voip status:" + str(iVoipStatus):sysDebug
		ld		hl,directstr_47+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1279		;//sDb = "voip defVoipIdle" + str(defVoipIdle):sysDebug
		ld		hl,directstr_48+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_defVoipIdle) 	;//hl=value of 'var_wrd_defVoipIdle' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1281		;//if (iVoipStatus = defVoipIdle) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipIdle) 	;//hl=value of 'var_wrd_defVoipIdle' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5156_Exit0				;// [Qc1012]
.QLn_1282		;//labelVoip.text.set "IDLE" :labelVoip.refresh
		ld		hl,directstr_49+2		;//hl points static string [Qc055]
		ld		de,(LabelVoip_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'LabelVoip.Text.Set' [Qc234]
		ld		hl,LabelVoip		;//hl=address of 'LabelVoip' [Qc223]
		call	Quig_Control_Refresh				;//Call 'LabelVoip.Refresh' [Qc234]
.QLn_1283		;//iVoipSoundSelect = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundSelect),hl		;//Int variable 'var_wrd_iVoipSoundSelect'=expression result [Qc219]
.QLn_1284		;//endif
.QIf5156_Exit0:
.QIf5156_EndIf:
.QLn_1286		;//if (iVoipStatus = defVoipOutgoingCall) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipOutgoingCall) 	;//hl=value of 'var_wrd_defVoipOutgoingCall' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5181_Exit0				;// [Qc1012]
.QLn_1287		;//labelVoip.text.set "OUTGOING" :labelVoip.refresh
		ld		hl,directstr_50+2		;//hl points static string [Qc055]
		ld		de,(LabelVoip_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'LabelVoip.Text.Set' [Qc234]
		ld		hl,LabelVoip		;//hl=address of 'LabelVoip' [Qc223]
		call	Quig_Control_Refresh				;//Call 'LabelVoip.Refresh' [Qc234]
.QLn_1288		;//iVoipSoundSelect = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iVoipSoundSelect),hl		;//Int variable 'var_wrd_iVoipSoundSelect'=expression result [Qc219]
.QLn_1289		;//endif
.QIf5181_Exit0:
.QIf5181_EndIf:
.QLn_1291		;//if (iVoipStatus = defVoipOtherBusy) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipOtherBusy) 	;//hl=value of 'var_wrd_defVoipOtherBusy' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5206_Exit0				;// [Qc1012]
.QLn_1292		;//labelVoip.text.set "IS BUSY" :labelVoip.refresh
		ld		hl,directstr_51+2		;//hl points static string [Qc055]
		ld		de,(LabelVoip_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'LabelVoip.Text.Set' [Qc234]
		ld		hl,LabelVoip		;//hl=address of 'LabelVoip' [Qc223]
		call	Quig_Control_Refresh				;//Call 'LabelVoip.Refresh' [Qc234]
.QLn_1293		;//iVoipSoundSelect = 2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		(var_wrd_iVoipSoundSelect),hl		;//Int variable 'var_wrd_iVoipSoundSelect'=expression result [Qc219]
.QLn_1294		;//endif
.QIf5206_Exit0:
.QIf5206_EndIf:
.QLn_1296		;//if (iVoipStatus = defVoipOtherOffline) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipOtherOffline) 	;//hl=value of 'var_wrd_defVoipOtherOffline' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5231_Exit0				;// [Qc1012]
.QLn_1297		;//labelVoip.text.set "OFFLINE !" :labelVoip.refresh
		ld		hl,directstr_52+2		;//hl points static string [Qc055]
		ld		de,(LabelVoip_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'LabelVoip.Text.Set' [Qc234]
		ld		hl,LabelVoip		;//hl=address of 'LabelVoip' [Qc223]
		call	Quig_Control_Refresh				;//Call 'LabelVoip.Refresh' [Qc234]
.QLn_1298		;//iVoipSoundSelect = 3
		ld		hl,3		;//hl=number '3' [Qc054]
		ld		(var_wrd_iVoipSoundSelect),hl		;//Int variable 'var_wrd_iVoipSoundSelect'=expression result [Qc219]
.QLn_1299		;//endif
.QIf5231_Exit0:
.QIf5231_EndIf:
.QLn_1301		;//if (iVoipStatus = defVoipIncommingCall) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipIncommingCall) 	;//hl=value of 'var_wrd_defVoipIncommingCall' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5256_Exit0				;// [Qc1012]
.QLn_1302		;//labelVoip.text.set "INCOMMING" :labelVoip.refresh
		ld		hl,directstr_53+2		;//hl points static string [Qc055]
		ld		de,(LabelVoip_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'LabelVoip.Text.Set' [Qc234]
		ld		hl,LabelVoip		;//hl=address of 'LabelVoip' [Qc223]
		call	Quig_Control_Refresh				;//Call 'LabelVoip.Refresh' [Qc234]
.QLn_1303		;//iVoipSoundSelect = 4
		ld		hl,4		;//hl=number '4' [Qc054]
		ld		(var_wrd_iVoipSoundSelect),hl		;//Int variable 'var_wrd_iVoipSoundSelect'=expression result [Qc219]
.QLn_1305		;//endif
.QIf5256_Exit0:
.QIf5256_EndIf:
.QLn_1307		;//if (iVoipStatus = defVoipActiveCall) then
		ld		hl,(var_wrd_iVoipStatus) 	;//hl=value of 'var_wrd_iVoipStatus' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_defVoipActiveCall) 	;//hl=value of 'var_wrd_defVoipActiveCall' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5281_Exit0				;// [Qc1012]
.QLn_1308		;//u16in1 = u16OtherUserId :F131_7
		ld		hl,(var_wrd_u16OtherUserId) 	;//hl=value of 'var_wrd_u16OtherUserId' [Qc053]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_1309		;//labelVoip.text.set "CALLING..." :labelVoip.refresh
		ld		hl,directstr_54+2		;//hl points static string [Qc055]
		ld		de,(LabelVoip_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'LabelVoip.Text.Set' [Qc234]
		ld		hl,LabelVoip		;//hl=address of 'LabelVoip' [Qc223]
		call	Quig_Control_Refresh				;//Call 'LabelVoip.Refresh' [Qc234]
.QLn_1310		;//iVoipSoundSelect = 5
		ld		hl,5		;//hl=number '5' [Qc054]
		ld		(var_wrd_iVoipSoundSelect),hl		;//Int variable 'var_wrd_iVoipSoundSelect'=expression result [Qc219]
.QLn_1311		;//endif
.QIf5281_Exit0:
.QIf5281_EndIf:
.QLn_1313		;//endif
.QIf5118_Exit0:
.QIf5118_EndIf:
.QLn_1314		;//endf
		ret		;// [Qc262]
.QLn_1317		;//Function VoipSoundHandler:Void()
.QFunc_VOIPSOUNDHANDLER
.QLn_1319		;//iVoipSoundCt = iVoipSoundCt + 1
		ld		hl,(var_wrd_iVoipSoundCt) 	;//hl=value of 'var_wrd_iVoipSoundCt' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iVoipSoundCt),hl		;//Int variable 'var_wrd_iVoipSoundCt'=expression result [Qc219]
.QLn_1320		;//if (iVoipSoundCt < 5) then
		Ld		de,(var_wrd_iVoipSoundCt)			;// Optimize -1- [Qc1001]
		Ld		hl,5			;// [Qc1002]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf5316_Exit0				;// [Qc1220]
.QLn_1321		;//return
		ret		;// [Qc250]
.QLn_1322		;//endif
.QIf5316_Exit0:
.QIf5316_EndIf:
.QLn_1323		;//iVoipSoundCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundCt),hl		;//Int variable 'var_wrd_iVoipSoundCt'=expression result [Qc219]
.QLn_1325		;//iVoipSoundSeq = iVoipSoundSeq  + 1
		ld		hl,(var_wrd_iVoipSoundSeq) 	;//hl=value of 'var_wrd_iVoipSoundSeq' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iVoipSoundSeq),hl		;//Int variable 'var_wrd_iVoipSoundSeq'=expression result [Qc219]
.QLn_1327		;//if (iVoipSoundSeq > 5000) then
		Ld		de,(var_wrd_iVoipSoundSeq)			;// Optimize -1- [Qc1001]
		Ld		hl,5000			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf5336_Exit0				;// [Qc1220]
.QLn_1328		;//iVoipSoundSeq = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundSeq),hl		;//Int variable 'var_wrd_iVoipSoundSeq'=expression result [Qc219]
.QLn_1329		;//endif
.QIf5336_Exit0:
.QIf5336_EndIf:
.QLn_1331		;//if (iVoipSoundSelect = 0) then
		Ld		hl,(var_wrd_iVoipSoundSelect)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5355_Exit0				;// [Qc1012]
.QLn_1332		;//iVoipSoundSeq = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundSeq),hl		;//Int variable 'var_wrd_iVoipSoundSeq'=expression result [Qc219]
.QLn_1333		;//return
		ret		;// [Qc250]
.QLn_1334		;//elseif (iVoipSoundSelect = 1) then // soundPlayCallUser
		jp		QIf5355_EndIf		;//Jump to EndIf
.QIf5355_Exit0:
		Ld		hl,(var_wrd_iVoipSoundSelect)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5355_Exit1				;// [Qc1012]
.QLn_1336		;//if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 12) or (iVoipSoundSeq = 15)  then
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,4			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,12			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,15			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf5439_Exit0			;// [Qc5062]
.QLn_1337		;//Sound.FX.Play 0,sound.fx.sys.Ring2-1,255
		ld		hl,0		;//hl=number '0' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,5			;// 1040 [Qc1040]
		ld		hl,255		;//hl=number '255' [Qc054]
		call	Quig_Sound_FX_Play				;//Call 'Sound.FX.Play' [Qc234]
.QLn_1338		;//endif
.QIf5439_Exit0:
.QIf5439_EndIf:
.QLn_1340		;//if (iVoipSoundSeq > 30) then
		Ld		de,(var_wrd_iVoipSoundSeq)			;// Optimize -1- [Qc1001]
		Ld		hl,30			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf5457_Exit0				;// [Qc1220]
.QLn_1341		;//iVoipSoundSeq = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundSeq),hl		;//Int variable 'var_wrd_iVoipSoundSeq'=expression result [Qc219]
.QLn_1342		;//endif
.QIf5457_Exit0:
.QIf5457_EndIf:
.QLn_1344		;//elseif (iVoipSoundSelect = 2) then // soundPlayBusy
		jp		QIf5355_EndIf		;//Jump to EndIf
.QIf5355_Exit1:
		Ld		hl,(var_wrd_iVoipSoundSelect)			;// Optimize -1a- [Qc1062]
		Ld		de,2			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5355_Exit2				;// [Qc1012]
.QLn_1346		;//if (iVoipSoundSeq = 1)  then
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5491_Exit0				;// [Qc1012]
.QLn_1347		;//Sound.FX.Play 0,sound.fx.sys.Click1 -1 ,255
		ld		hl,0		;//hl=number '0' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,255		;//hl=number '255' [Qc054]
		call	Quig_Sound_FX_Play				;//Call 'Sound.FX.Play' [Qc234]
.QLn_1348		;//endif
.QIf5491_Exit0:
.QIf5491_EndIf:
.QLn_1350		;//if (iVoipSoundSeq > 10) then
		Ld		de,(var_wrd_iVoipSoundSeq)			;// Optimize -1- [Qc1001]
		Ld		hl,10			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf5509_Exit0				;// [Qc1220]
.QLn_1351		;//iVoipSoundSeq = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundSeq),hl		;//Int variable 'var_wrd_iVoipSoundSeq'=expression result [Qc219]
.QLn_1352		;//endif
.QIf5509_Exit0:
.QIf5509_EndIf:
.QLn_1354		;//elseif (iVoipSoundSelect = 3) then // soundPlayOffline
		jp		QIf5355_EndIf		;//Jump to EndIf
.QIf5355_Exit2:
		Ld		hl,(var_wrd_iVoipSoundSelect)			;// Optimize -1a- [Qc1062]
		Ld		de,3			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5355_Exit3				;// [Qc1012]
.QLn_1356		;//if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 7) then
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,4			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,7			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf5577_Exit0			;// [Qc5062]
.QLn_1357		;//Sound.FX.Play 0,sound.fx.sys.Click1-1,255
		ld		hl,0		;//hl=number '0' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,255		;//hl=number '255' [Qc054]
		call	Quig_Sound_FX_Play				;//Call 'Sound.FX.Play' [Qc234]
.QLn_1358		;//endif
.QIf5577_Exit0:
.QIf5577_EndIf:
.QLn_1360		;//if (iVoipSoundSeq > 20) then
		Ld		de,(var_wrd_iVoipSoundSeq)			;// Optimize -1- [Qc1001]
		Ld		hl,20			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf5595_Exit0				;// [Qc1220]
.QLn_1361		;//iVoipSoundSeq = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundSeq),hl		;//Int variable 'var_wrd_iVoipSoundSeq'=expression result [Qc219]
.QLn_1362		;//endif
.QIf5595_Exit0:
.QIf5595_EndIf:
.QLn_1364		;//elseif (iVoipSoundSelect = 4) then // soundPlayBeCalled
		jp		QIf5355_EndIf		;//Jump to EndIf
.QIf5355_Exit3:
		Ld		hl,(var_wrd_iVoipSoundSelect)			;// Optimize -1a- [Qc1062]
		Ld		de,4			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5355_Exit4				;// [Qc1012]
.QLn_1366		;//if (iVoipSoundSeq = 1)  then
		Ld		hl,(var_wrd_iVoipSoundSeq)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf5629_Exit0				;// [Qc1012]
.QLn_1367		;//Sound.FX.Play 0,sound.fx.sys.Win-1,255
		ld		hl,0		;//hl=number '0' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,20			;// 1040 [Qc1040]
		ld		hl,255		;//hl=number '255' [Qc054]
		call	Quig_Sound_FX_Play				;//Call 'Sound.FX.Play' [Qc234]
.QLn_1368		;//endif
.QIf5629_Exit0:
.QIf5629_EndIf:
.QLn_1370		;//if (iVoipSoundSeq > 55) then
		Ld		de,(var_wrd_iVoipSoundSeq)			;// Optimize -1- [Qc1001]
		Ld		hl,55			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf5647_Exit0				;// [Qc1220]
.QLn_1371		;//iVoipSoundSeq = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iVoipSoundSeq),hl		;//Int variable 'var_wrd_iVoipSoundSeq'=expression result [Qc219]
.QLn_1372		;//endif
.QIf5647_Exit0:
.QIf5647_EndIf:
.QLn_1374		;//endif
.QIf5355_Exit4:
.QIf5355_EndIf:
.QLn_1377		;//endf
		ret		;// [Qc262]
.QLn_1379		;//Function VoipGetConnectedWith:Void()
.QFunc_VOIPGETCONNECTEDWITH
.QLn_1386		;//u16OtherUserId = (256 * IO.In(#FF22)) + IO.In(#FF23)
		ld		hl,256		;//hl=number '256' [Qc054]
		push		hl 		;//Store result [Qc001]
		ld		hl,-222		;//hl=number '-222' [Qc054]
		call	Quig_IO_In		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		push		hl 		;//Store result [Qc001]
		ld		hl,-221		;//hl=number '-221' [Qc054]
		call	Quig_IO_In		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ld		(var_wrd_u16OtherUserId),hl		;//Int variable 'var_wrd_u16OtherUserId'=expression result [Qc219]
.QLn_1387		;//sDb = "Voip connected with :" + str(u16OtherUserId):sysDebug
		ld		hl,directstr_55+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_u16OtherUserId) 	;//hl=value of 'var_wrd_u16OtherUserId' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1388		;//endf
		ret		;// [Qc262]
.QLn_1395		;//Function se1_PlayBell:void()
.QFunc_SE1_PLAYBELL
.QLn_1397		;//endf
		ret		;// [Qc262]
.QLn_1399		;//Function se1_PlayTick:void()
.QFunc_SE1_PLAYTICK
.QLn_1401		;//endf
		ret		;// [Qc262]
.QLn_1411		;//Function ImgPos:Void()
.QFunc_IMGPOS
.QLn_1413		;//Asm
	.DotsData:
	Db   1,  3,  5,  7,  9, 11
	Db  23, 25, 27, 29, 31, 33
	Db  45, 47, 49, 51, 53, 55
	Db  67, 69, 71, 73, 75, 77
	Db  89, 91, 93, 95, 97, 99
	Db 111,113,115,117,119,121
	Db 0,0,0,0,0,0
	.HoriData:
	Db   2,  4,  6,  8, 10
	Db  24, 26, 28, 30, 32
	Db  46, 48, 50, 52, 54
	Db  68, 70, 72, 74, 76
	Db  90, 92, 94, 96, 98
	Db 112,114,116,118,120
	Db 0,0,0,0,0,0
	.VeriData:
	Db  12, 14, 16, 18, 20, 22
	Db  34, 36, 38, 40, 42, 44
	Db  56, 58, 60, 62, 64, 66
	Db  78, 80, 82, 84, 86, 88
	Db 100,102,104,106,108,110
	.BoxData:
	Db  13, 15, 17, 19, 21
	Db  35, 37, 39, 41, 43
	Db  57, 59, 61, 63, 65
	Db  79, 81, 83, 85, 87
	Db 101,103,105,107,109
	Db 0,0,0,0,0,0
.QLn_1453		;//EndF
		ret		;// [Qc262]
.QLn_1457		;//Function  LoadImgCtrls:void()
.QFunc_LOADIMGCTRLS
.QLn_1459		;//ImgIds( 1)=Ctrl.GetID(Form1,Image1.Display)
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_207+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,13		;//hl=number '13' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_207:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1461		;//ImgIds( 2)=Ctrl.GetID(Form1,Image2.Display)
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_208+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,14		;//hl=number '14' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_208:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1462		;//ImgIds( 2)=Image2
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_209+1),hl		;// [Qc210]
		ld		hl,Image2		;//hl=address of 'Image2' [Qc011]
.Quig_Let_209:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1464		;//sDb="->> Display image "+str(Image2.Display) :sysDebug
		ld		hl,directstr_56+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc001]
		ld		hl,14		;//hl=number '14' [Qc054]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1466		;//ImgIds( 3)=Ctrl.GetID(Form1,Image3.Display)
		ld		hl,3		;//hl=number '3' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_211+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,15		;//hl=number '15' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_211:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1467		;//ImgIds( 4)=Ctrl.GetID(Form1,Image4.Display)
		ld		hl,4		;//hl=number '4' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_212+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,16		;//hl=number '16' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_212:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1468		;//ImgIds( 5)=Ctrl.GetID(Form1,Image5.Display)
		ld		hl,5		;//hl=number '5' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_213+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,17		;//hl=number '17' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_213:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1469		;//ImgIds( 6)=Ctrl.GetID(Form1,Image6.Display)
		ld		hl,6		;//hl=number '6' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_214+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,18		;//hl=number '18' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_214:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1470		;//ImgIds( 7)=Ctrl.GetID(Form1,Image7.Display)
		ld		hl,7		;//hl=number '7' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_215+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,19		;//hl=number '19' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_215:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1471		;//ImgIds( 8)=Ctrl.GetID(Form1,Image8.Display)
		ld		hl,8		;//hl=number '8' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_216+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,20		;//hl=number '20' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_216:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1472		;//ImgIds( 9)=Ctrl.GetID(Form1,Image9.Display)
		ld		hl,9		;//hl=number '9' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_217+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,2		;//hl=number '2' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_217:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1473		;//ImgIds(10)=Ctrl.GetID(Form1,Image10.Display)
		ld		hl,10		;//hl=number '10' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_218+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,21		;//hl=number '21' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_218:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1474		;//ImgIds(11)=Ctrl.GetID(Form1,Image11.Display)
		ld		hl,11		;//hl=number '11' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_219+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,22		;//hl=number '22' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_219:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1475		;//ImgIds(12)=Ctrl.GetID(Form1,Image12.Display)
		ld		hl,12		;//hl=number '12' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_220+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,23		;//hl=number '23' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_220:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1476		;//ImgIds(13)=Ctrl.GetID(Form1,Image13.Display)
		ld		hl,13		;//hl=number '13' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_221+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,24		;//hl=number '24' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_221:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1477		;//ImgIds(14)=Ctrl.GetID(Form1,Image14.Display)
		ld		hl,14		;//hl=number '14' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_222+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_222:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1478		;//ImgIds(15)=Ctrl.GetID(Form1,Image15.Display)
		ld		hl,15		;//hl=number '15' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_223+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,25		;//hl=number '25' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_223:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1479		;//ImgIds(16)=Ctrl.GetID(Form1,Image16.Display)
		ld		hl,16		;//hl=number '16' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_224+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,26		;//hl=number '26' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_224:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1480		;//ImgIds(17)=Ctrl.GetID(Form1,Image17.Display)
		ld		hl,17		;//hl=number '17' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_225+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,27		;//hl=number '27' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_225:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1481		;//ImgIds(18)=Ctrl.GetID(Form1,Image18.Display)
		ld		hl,18		;//hl=number '18' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_226+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,28		;//hl=number '28' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_226:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1482		;//ImgIds(19)=Ctrl.GetID(Form1,Image19.Display)
		ld		hl,19		;//hl=number '19' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_227+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,29		;//hl=number '29' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_227:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1484		;//ImgIds(20)=Ctrl.GetID(Form1,Image20.Display)
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_228+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,30		;//hl=number '30' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_228:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1485		;//ImgIds(21)=Ctrl.GetID(Form1,Image21.Display)
		ld		hl,21		;//hl=number '21' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_229+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,31		;//hl=number '31' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_229:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1486		;//ImgIds(22)=Ctrl.GetID(Form1,Image22.Display)
		ld		hl,22		;//hl=number '22' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_230+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,32		;//hl=number '32' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_230:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1487		;//ImgIds(23)=Ctrl.GetID(Form1,Image23.Display)
		ld		hl,23		;//hl=number '23' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_231+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,33		;//hl=number '33' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_231:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1488		;//ImgIds(24)=Ctrl.GetID(Form1,Image24.Display)
		ld		hl,24		;//hl=number '24' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_232+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,34		;//hl=number '34' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_232:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1489		;//ImgIds(25)=Ctrl.GetID(Form1,Image25.Display)
		ld		hl,25		;//hl=number '25' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_233+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,35		;//hl=number '35' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_233:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1490		;//ImgIds(26)=Ctrl.GetID(Form1,Image26.Display)
		ld		hl,26		;//hl=number '26' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_234+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,36		;//hl=number '36' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_234:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1491		;//ImgIds(27)=Ctrl.GetID(Form1,Image27.Display)
		ld		hl,27		;//hl=number '27' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_235+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,37		;//hl=number '37' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_235:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1492		;//ImgIds(28)=Ctrl.GetID(Form1,Image28.Display)
		ld		hl,28		;//hl=number '28' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_236+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,38		;//hl=number '38' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_236:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1493		;//ImgIds(29)=Ctrl.GetID(Form1,Image29.Display)
		ld		hl,29		;//hl=number '29' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_237+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,39		;//hl=number '39' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_237:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1495		;//ImgIds(30)=Ctrl.GetID(Form1,Image30.Display)
		ld		hl,30		;//hl=number '30' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_238+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,40		;//hl=number '40' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_238:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1496		;//ImgIds(31)=Ctrl.GetID(Form1,Image31.Display)
		ld		hl,31		;//hl=number '31' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_239+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,41		;//hl=number '41' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_239:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1497		;//ImgIds(32)=Ctrl.GetID(Form1,Image32.Display)
		ld		hl,32		;//hl=number '32' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_240+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,42		;//hl=number '42' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_240:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1498		;//ImgIds(33)=Ctrl.GetID(Form1,Image33.Display)
		ld		hl,33		;//hl=number '33' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_241+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,43		;//hl=number '43' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_241:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1499		;//ImgIds(34)=Ctrl.GetID(Form1,Image34.Display)
		ld		hl,34		;//hl=number '34' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_242+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,44		;//hl=number '44' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_242:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1500		;//ImgIds(35)=Ctrl.GetID(Form1,Image35.Display)
		ld		hl,35		;//hl=number '35' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_243+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,61		;//hl=number '61' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_243:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1501		;//ImgIds(36)=Ctrl.GetID(Form1,Image36.Display)
		ld		hl,36		;//hl=number '36' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_244+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,48		;//hl=number '48' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_244:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1502		;//ImgIds(37)=Ctrl.GetID(Form1,Image37.Display)
		ld		hl,37		;//hl=number '37' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_245+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,62		;//hl=number '62' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_245:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1503		;//ImgIds(38)=Ctrl.GetID(Form1,Image38.Display)
		ld		hl,38		;//hl=number '38' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_246+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,51		;//hl=number '51' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_246:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1504		;//ImgIds(39)=Ctrl.GetID(Form1,Image39.Display)
		ld		hl,39		;//hl=number '39' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_247+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,63		;//hl=number '63' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_247:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1506		;//ImgIds(40)=Ctrl.GetID(Form1,Image40.Display)
		ld		hl,40		;//hl=number '40' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_248+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,54		;//hl=number '54' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_248:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1507		;//ImgIds(41)=Ctrl.GetID(Form1,Image41.Display)
		ld		hl,41		;//hl=number '41' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_249+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,64		;//hl=number '64' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_249:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1508		;//ImgIds(42)=Ctrl.GetID(Form1,Image42.Display)
		ld		hl,42		;//hl=number '42' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_250+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,57		;//hl=number '57' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_250:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1509		;//ImgIds(43)=Ctrl.GetID(Form1,Image43.Display)
		ld		hl,43		;//hl=number '43' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_251+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,65		;//hl=number '65' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_251:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1510		;//ImgIds(44)=Ctrl.GetID(Form1,Image44.Display)
		ld		hl,44		;//hl=number '44' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_252+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,60		;//hl=number '60' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_252:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1511		;//ImgIds(45)=Ctrl.GetID(Form1,Image45.Display)
		ld		hl,45		;//hl=number '45' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_253+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,45		;//hl=number '45' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_253:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1512		;//ImgIds(46)=Ctrl.GetID(Form1,Image46.Display)
		ld		hl,46		;//hl=number '46' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_254+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,46		;//hl=number '46' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_254:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1513		;//ImgIds(47)=Ctrl.GetID(Form1,Image47.Display)
		ld		hl,47		;//hl=number '47' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_255+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,47		;//hl=number '47' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_255:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1514		;//ImgIds(48)=Ctrl.GetID(Form1,Image48.Display)
		ld		hl,48		;//hl=number '48' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_256+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,49		;//hl=number '49' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_256:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1515		;//ImgIds(49)=Ctrl.GetID(Form1,Image49.Display)
		ld		hl,49		;//hl=number '49' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_257+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,50		;//hl=number '50' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_257:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1517		;//ImgIds(50)=Ctrl.GetID(Form1,Image50.Display)
		ld		hl,50		;//hl=number '50' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_258+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,52		;//hl=number '52' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_258:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1518		;//ImgIds(51)=Ctrl.GetID(Form1,Image51.Display)
		ld		hl,51		;//hl=number '51' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_259+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,53		;//hl=number '53' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_259:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1519		;//ImgIds(52)=Ctrl.GetID(Form1,Image52.Display)
		ld		hl,52		;//hl=number '52' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_260+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,55		;//hl=number '55' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_260:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1520		;//ImgIds(53)=Ctrl.GetID(Form1,Image53.Display)
		ld		hl,53		;//hl=number '53' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_261+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,56		;//hl=number '56' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_261:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1521		;//ImgIds(54)=Ctrl.GetID(Form1,Image54.Display)
		ld		hl,54		;//hl=number '54' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_262+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,58		;//hl=number '58' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_262:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1522		;//ImgIds(55)=Ctrl.GetID(Form1,Image55.Display)
		ld		hl,55		;//hl=number '55' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_263+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,59		;//hl=number '59' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_263:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1523		;//ImgIds(56)=Ctrl.GetID(Form1,Image56.Display)
		ld		hl,56		;//hl=number '56' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_264+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,66		;//hl=number '66' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_264:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1524		;//ImgIds(57)=Ctrl.GetID(Form1,Image57.Display)
		ld		hl,57		;//hl=number '57' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_265+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,83		;//hl=number '83' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_265:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1525		;//ImgIds(58)=Ctrl.GetID(Form1,Image58.Display)
		ld		hl,58		;//hl=number '58' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_266+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,70		;//hl=number '70' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_266:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1526		;//ImgIds(59)=Ctrl.GetID(Form1,Image59.Display)
		ld		hl,59		;//hl=number '59' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_267+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,84		;//hl=number '84' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_267:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1528		;//ImgIds(60)=Ctrl.GetID(Form1,Image60.Display)
		ld		hl,60		;//hl=number '60' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_268+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,73		;//hl=number '73' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_268:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1529		;//ImgIds(61)=Ctrl.GetID(Form1,Image61.Display)
		ld		hl,61		;//hl=number '61' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_269+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,85		;//hl=number '85' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_269:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1530		;//ImgIds(62)=Ctrl.GetID(Form1,Image62.Display)
		ld		hl,62		;//hl=number '62' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_270+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,76		;//hl=number '76' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_270:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1531		;//ImgIds(63)=Ctrl.GetID(Form1,Image63.Display)
		ld		hl,63		;//hl=number '63' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_271+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,86		;//hl=number '86' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_271:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1532		;//ImgIds(64)=Ctrl.GetID(Form1,Image64.Display)
		ld		hl,64		;//hl=number '64' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_272+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,79		;//hl=number '79' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_272:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1533		;//ImgIds(65)=Ctrl.GetID(Form1,Image65.Display)
		ld		hl,65		;//hl=number '65' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_273+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,87		;//hl=number '87' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_273:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1534		;//ImgIds(66)=Ctrl.GetID(Form1,Image66.Display)
		ld		hl,66		;//hl=number '66' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_274+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,82		;//hl=number '82' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_274:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1535		;//ImgIds(67)=Ctrl.GetID(Form1,Image67.Display)
		ld		hl,67		;//hl=number '67' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_275+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,67		;//hl=number '67' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_275:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1536		;//ImgIds(68)=Ctrl.GetID(Form1,Image68.Display)
		ld		hl,68		;//hl=number '68' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_276+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,68		;//hl=number '68' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_276:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1537		;//ImgIds(69)=Ctrl.GetID(Form1,Image69.Display)
		ld		hl,69		;//hl=number '69' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_277+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,69		;//hl=number '69' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_277:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1539		;//ImgIds(70)=Ctrl.GetID(Form1,Image70.Display)
		ld		hl,70		;//hl=number '70' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_278+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,71		;//hl=number '71' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_278:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1540		;//ImgIds(71)=Ctrl.GetID(Form1,Image71.Display)
		ld		hl,71		;//hl=number '71' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_279+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,72		;//hl=number '72' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_279:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1541		;//ImgIds(72)=Ctrl.GetID(Form1,Image72.Display)
		ld		hl,72		;//hl=number '72' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_280+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,74		;//hl=number '74' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_280:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1542		;//ImgIds(73)=Ctrl.GetID(Form1,Image73.Display)
		ld		hl,73		;//hl=number '73' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_281+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,75		;//hl=number '75' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_281:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1543		;//ImgIds(74)=Ctrl.GetID(Form1,Image74.Display)
		ld		hl,74		;//hl=number '74' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_282+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,77		;//hl=number '77' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_282:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1544		;//ImgIds(75)=Ctrl.GetID(Form1,Image75.Display)
		ld		hl,75		;//hl=number '75' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_283+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,78		;//hl=number '78' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_283:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1545		;//ImgIds(76)=Ctrl.GetID(Form1,Image76.Display)
		ld		hl,76		;//hl=number '76' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_284+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,80		;//hl=number '80' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_284:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1546		;//ImgIds(77)=Ctrl.GetID(Form1,Image77.Display)
		ld		hl,77		;//hl=number '77' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_285+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,81		;//hl=number '81' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_285:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1547		;//ImgIds(78)=Ctrl.GetID(Form1,Image78.Display)
		ld		hl,78		;//hl=number '78' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_286+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,88		;//hl=number '88' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_286:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1548		;//ImgIds(79)=Ctrl.GetID(Form1,Image79.Display)
		ld		hl,79		;//hl=number '79' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_287+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,89		;//hl=number '89' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_287:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1550		;//ImgIds(80)=Ctrl.GetID(Form1,Image80.Display)
		ld		hl,80		;//hl=number '80' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_288+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,90		;//hl=number '90' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_288:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1551		;//ImgIds(81)=Ctrl.GetID(Form1,Image81.Display)
		ld		hl,81		;//hl=number '81' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_289+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,91		;//hl=number '91' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_289:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1552		;//ImgIds(82)=Ctrl.GetID(Form1,Image82.Display)
		ld		hl,82		;//hl=number '82' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_290+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,92		;//hl=number '92' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_290:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1553		;//ImgIds(83)=Ctrl.GetID(Form1,Image83.Display)
		ld		hl,83		;//hl=number '83' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_291+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,93		;//hl=number '93' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_291:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1554		;//ImgIds(84)=Ctrl.GetID(Form1,Image84.Display)
		ld		hl,84		;//hl=number '84' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_292+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,94		;//hl=number '94' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_292:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1555		;//ImgIds(85)=Ctrl.GetID(Form1,Image85.Display)
		ld		hl,85		;//hl=number '85' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_293+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,95		;//hl=number '95' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_293:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1556		;//ImgIds(86)=Ctrl.GetID(Form1,Image86.Display)
		ld		hl,86		;//hl=number '86' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_294+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,96		;//hl=number '96' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_294:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1557		;//ImgIds(87)=Ctrl.GetID(Form1,Image87.Display)
		ld		hl,87		;//hl=number '87' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_295+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,97		;//hl=number '97' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_295:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1558		;//ImgIds(88)=Ctrl.GetID(Form1,Image88.Display)
		ld		hl,88		;//hl=number '88' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_296+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,98		;//hl=number '98' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_296:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1559		;//ImgIds(89)=Ctrl.GetID(Form1,Image89.Display)
		ld		hl,89		;//hl=number '89' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_297+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,99		;//hl=number '99' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_297:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1561		;//ImgIds(90)=Ctrl.GetID(Form1,Image90.Display)
		ld		hl,90		;//hl=number '90' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_298+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,100		;//hl=number '100' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_298:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1562		;//ImgIds(91)=Ctrl.GetID(Form1,Image91.Display)
		ld		hl,91		;//hl=number '91' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_299+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,101		;//hl=number '101' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_299:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1563		;//ImgIds(92)=Ctrl.GetID(Form1,Image92.Display)
		ld		hl,92		;//hl=number '92' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_300+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,102		;//hl=number '102' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_300:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1564		;//ImgIds(93)=Ctrl.GetID(Form1,Image93.Display)
		ld		hl,93		;//hl=number '93' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_301+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,103		;//hl=number '103' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_301:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1565		;//ImgIds(94)=Ctrl.GetID(Form1,Image94.Display)
		ld		hl,94		;//hl=number '94' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_302+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,104		;//hl=number '104' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_302:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1566		;//ImgIds(95)=Ctrl.GetID(Form1,Image95.Display)
		ld		hl,95		;//hl=number '95' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_303+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,105		;//hl=number '105' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_303:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1567		;//ImgIds(96)=Ctrl.GetID(Form1,Image96.Display)
		ld		hl,96		;//hl=number '96' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_304+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,106		;//hl=number '106' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_304:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1568		;//ImgIds(97)=Ctrl.GetID(Form1,Image97.Display)
		ld		hl,97		;//hl=number '97' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_305+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,107		;//hl=number '107' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_305:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1569		;//ImgIds(98)=Ctrl.GetID(Form1,Image98.Display)
		ld		hl,98		;//hl=number '98' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_306+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,108		;//hl=number '108' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_306:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1570		;//ImgIds(99)=Ctrl.GetID(Form1,Image99.Display)
		ld		hl,99		;//hl=number '99' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_307+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,109		;//hl=number '109' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_307:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1572		;//ImgIds(100)=Ctrl.GetID(Form1,Image100.Display)
		ld		hl,100		;//hl=number '100' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_308+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,110		;//hl=number '110' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_308:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1573		;//ImgIds(101)=Ctrl.GetID(Form1,Image101.Display)
		ld		hl,101		;//hl=number '101' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_309+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,111		;//hl=number '111' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_309:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1574		;//ImgIds(102)=Ctrl.GetID(Form1,Image102.Display)
		ld		hl,102		;//hl=number '102' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_310+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,112		;//hl=number '112' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_310:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1575		;//ImgIds(103)=Ctrl.GetID(Form1,Image103.Display)
		ld		hl,103		;//hl=number '103' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_311+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,113		;//hl=number '113' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_311:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1576		;//ImgIds(104)=Ctrl.GetID(Form1,Image104.Display)
		ld		hl,104		;//hl=number '104' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_312+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,114		;//hl=number '114' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_312:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1577		;//ImgIds(105)=Ctrl.GetID(Form1,Image105.Display)
		ld		hl,105		;//hl=number '105' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_313+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,115		;//hl=number '115' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_313:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1578		;//ImgIds(106)=Ctrl.GetID(Form1,Image106.Display)
		ld		hl,106		;//hl=number '106' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_314+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,116		;//hl=number '116' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_314:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1579		;//ImgIds(107)=Ctrl.GetID(Form1,Image107.Display)
		ld		hl,107		;//hl=number '107' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_315+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,117		;//hl=number '117' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_315:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1580		;//ImgIds(108)=Ctrl.GetID(Form1,Image108.Display)
		ld		hl,108		;//hl=number '108' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_316+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,118		;//hl=number '118' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_316:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1581		;//ImgIds(109)=Ctrl.GetID(Form1,Image109.Display)
		ld		hl,109		;//hl=number '109' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_317+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,119		;//hl=number '119' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_317:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1583		;//ImgIds(110)=Ctrl.GetID(Form1,Image110.Display)
		ld		hl,110		;//hl=number '110' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_318+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,120		;//hl=number '120' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_318:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1584		;//ImgIds(111)=Ctrl.GetID(Form1,Image111.Display)
		ld		hl,111		;//hl=number '111' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_319+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,121		;//hl=number '121' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_319:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1585		;//ImgIds(112)=Ctrl.GetID(Form1,Image112.Display)
		ld		hl,112		;//hl=number '112' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_320+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,122		;//hl=number '122' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_320:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1586		;//ImgIds(113)=Ctrl.GetID(Form1,Image113.Display)
		ld		hl,113		;//hl=number '113' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_321+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,123		;//hl=number '123' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_321:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1587		;//ImgIds(114)=Ctrl.GetID(Form1,Image114.Display)
		ld		hl,114		;//hl=number '114' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_322+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,124		;//hl=number '124' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_322:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1588		;//ImgIds(115)=Ctrl.GetID(Form1,Image115.Display)
		ld		hl,115		;//hl=number '115' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_323+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,125		;//hl=number '125' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_323:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1589		;//ImgIds(116)=Ctrl.GetID(Form1,Image116.Display)
		ld		hl,116		;//hl=number '116' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_324+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,126		;//hl=number '126' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_324:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1590		;//ImgIds(117)=Ctrl.GetID(Form1,Image117.Display)
		ld		hl,117		;//hl=number '117' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_325+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,127		;//hl=number '127' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_325:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1591		;//ImgIds(118)=Ctrl.GetID(Form1,Image118.Display)
		ld		hl,118		;//hl=number '118' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_326+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,128		;//hl=number '128' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_326:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1592		;//ImgIds(119)=Ctrl.GetID(Form1,Image119.Display)
		ld		hl,119		;//hl=number '119' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_327+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,129		;//hl=number '129' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_327:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1594		;//ImgIds(120)=Ctrl.GetID(Form1,Image120.Display)
		ld		hl,120		;//hl=number '120' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_328+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,130		;//hl=number '130' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_328:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1595		;//ImgIds(121)=Ctrl.GetID(Form1,Image121.Display)
		ld		hl,121		;//hl=number '121' [Qc054]
		ld		bc,ar1_wrd_ImgIds+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_329+1),hl		;// [Qc210]
		Ld 		de,0			;// 1040 [Qc1040]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_Control_GetID		;/ Call Function [Qc052]
.Quig_Let_329:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_1597		;//endf
		ret		;// [Qc262]
.QLn_1603		;//Function   stpStartup:Void()
.QFunc_STPSTARTUP
.QLn_1605		;//If iStpStartup = 0 Then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7219_Exit0				;// [Qc1012]
.QLn_1606		;//return
		ret		;// [Qc250]
.QLn_1607		;//EndIf
.QIf7219_Exit0:
.QIf7219_EndIf:
.QLn_1609		;//if (iStpStartup <> 120) then
		Ld		de,(var_wrd_iStpStartup)			;// Optimize -1- [Qc1001]
		Ld		hl,120			;// [Qc1002]
		Xor 	a						;// Optimize -3b- [Qc1213]
		sbc		hl,de					;// [Qc1214]
		jp		z,QIf7237_Exit0				;// [Qc1215]
.QLn_1610		;//sDb = "step  is: "+str(iStpStartup) :sysDebug
		ld		hl,directstr_57+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iStpStartup) 	;//hl=value of 'var_wrd_iStpStartup' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1611		;//endif
.QIf7237_Exit0:
.QIf7237_EndIf:
.QLn_1613		;//If iStpStartup = 10 Then		//.. start
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,10			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7264_Exit0				;// [Qc1012]
.QLn_1615		;//strIn1 =  strFirmware
		ld		hl,(var_str_strFirmware)		;//hl=pointer to string 'var_str_strFirmware' [Qc056]
;**** 'var_str_strIn1$'=Expression
		ld		de,(var_str_strIn1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strIn1'= [Qc221]
.QLn_1616		;//F72_25	//.. check firmware
		call	QFunc_F72_25				;//Call 'F72_25' [Qc234]
.QLn_1617		;//If  u8Out1 > 0  Then
		Ld		de,(var_wrd_u8Out1)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7279_Exit0				;// [Qc1220]
.QLn_1618		;//c = MsgBox("Firmware  out of  date !","Needed: ",strFirmware ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
		ld		hl,directstr_58+2		;//hl points static string [Qc055]
		push		hl		;//Store result [Qc003]
		ld		hl,directstr_59+2		;//hl points static string [Qc055]
		push		hl		;//Store result [Qc004]
		ld		hl,(var_str_strFirmware)		;//hl=pointer to string 'var_str_strFirmware' [Qc056]
		push		hl 		;//Store result [Qc001]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl 		;//Store result [Qc001]
		Ld 		de,1			;// 1040 [Qc1040]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Dialog		;/ Call Function [Qc052]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_1619		;//EndIf
.QIf7279_Exit0:
.QIf7279_EndIf:
.QLn_1621		;//F131_1	//.. get status
		call	QFunc_F131_1				;//Call 'F131_1' [Qc234]
.QLn_1622		;//If u8Out1 = 3 Then
		Ld		hl,(var_wrd_u8Out1)			;// Optimize -1a- [Qc1062]
		Ld		de,3			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7311_Exit0				;// [Qc1012]
.QLn_1623		;//iStpStartup  = 30
		ld		hl,30		;//hl=number '30' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1624		;//Else
		jp		QIf7311_EndIf		;//Jump to EndIf
.QIf7311_Exit0:
.QLn_1625		;//F131_0						//.. login tmtnet
		call	QFunc_F131_0				;//Call 'F131_0' [Qc234]
.QLn_1626		;//iStpStartup = 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1627		;//EndIf
.QIf7311_Exit1:
.QIf7311_EndIf:
.QLn_1628		;//return
		ret		;// [Qc250]
.QLn_1629		;//EndIf
.QIf7264_Exit0:
.QIf7264_EndIf:
.QLn_1631		;//If iStpStartup = 20 Then	//.. Wait for connection
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,20			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7343_Exit0				;// [Qc1012]
.QLn_1632		;//F131_1	//.. get status
		call	QFunc_F131_1				;//Call 'F131_1' [Qc234]
.QLn_1633		;//If u8Out1 = 0 Then
		Ld		hl,(var_wrd_u8Out1)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7358_Exit0				;// [Qc1012]
.QLn_1634		;//c = MsgBox("Wifi OFFLINE !","Not connected: ","" ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
		ld		hl,directstr_60+2		;//hl points static string [Qc055]
		push		hl		;//Store result [Qc003]
		ld		hl,directstr_61+2		;//hl points static string [Qc055]
		push		hl		;//Store result [Qc003]
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc001]
		ld		hl,1		;//hl=number '1' [Qc054]
		push		hl 		;//Store result [Qc001]
		Ld 		de,1			;// 1040 [Qc1040]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_Dialog		;/ Call Function [Qc052]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_1635		;//iAppExit = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_iAppExit),hl		;//Int variable 'var_wrd_iAppExit'=expression result [Qc219]
.QLn_1636		;//EndIf
.QIf7358_Exit0:
.QIf7358_EndIf:
.QLn_1638		;//If u8Out1 = 3 Then
		Ld		hl,(var_wrd_u8Out1)			;// Optimize -1a- [Qc1062]
		Ld		de,3			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7391_Exit0				;// [Qc1012]
.QLn_1640		;//iStpStartup  = 30
		ld		hl,30		;//hl=number '30' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1641		;//EndIf
.QIf7391_Exit0:
.QIf7391_EndIf:
.QLn_1642		;//return
		ret		;// [Qc250]
.QLn_1643		;//EndIf
.QIf7343_Exit0:
.QIf7343_EndIf:
.QLn_1645		;//If iStpStartup = 30 Then	//.. Login ready
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,30			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7415_Exit0				;// [Qc1012]
.QLn_1648		;//F131_8						//.. get my userID
		call	QFunc_F131_8				;//Call 'F131_8' [Qc234]
.QLn_1650		;//strIn1 = strAppname
		ld		hl,(var_str_strAppname)		;//hl=pointer to string 'var_str_strAppname' [Qc056]
;**** 'var_str_strIn1$'=Expression
		ld		de,(var_str_strIn1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strIn1'= [Qc221]
.QLn_1651		;//F131_32						//.. set Appname
		call	QFunc_F131_32				;//Call 'F131_32' [Qc234]
.QLn_1653		;//iStpStartup = 100
		ld		hl,100		;//hl=number '100' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1655		;//Form4.close
		ld		hl,3		;//hl=number '3' [Qc224]
		call	Quig_Close_Form				;//Call 'Form4.Close' [Qc234]
.QLn_1656		;//Form2.open
		ld		hl,1		;//hl=number '1' [Qc224]
		call	Quig_Form_Open				;//Call 'Form2.Open' [Qc234]
.QLn_1657		;//return
		ret		;// [Qc250]
.QLn_1658		;//EndIf
.QIf7415_Exit0:
.QIf7415_EndIf:
.QLn_1661		;//If iStpStartup = 100 Then	//.. Choise player
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,100			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7451_Exit0				;// [Qc1012]
.QLn_1663		;//F131_2					//.. clear userOnline table
		call	QFunc_F131_2				;//Call 'F131_2' [Qc234]
.QLn_1665		;//iButChoise = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_1667		;//intDelay = 25			//.. 500ms
		ld		hl,25		;//hl=number '25' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_1668		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_1669		;//iStpStartup = 110
		ld		hl,110		;//hl=number '110' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1670		;//return
		ret		;// [Qc250]
.QLn_1671		;//EndIf
.QIf7451_Exit0:
.QIf7451_EndIf:
.QLn_1673		;//If iStpStartup = 110 Then	//.. Read online users
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,110			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7483_Exit0				;// [Qc1012]
.QLn_1675		;//F131_3					//.. read userOnline table
		call	QFunc_F131_3				;//Call 'F131_3' [Qc234]
.QLn_1679		;//label21.text.set "..."
		ld		hl,directstr_62+2		;//hl points static string [Qc055]
		ld		de,(Label21_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label21.Text.Set' [Qc234]
.QLn_1680		;//label22.text.set "..."
		ld		hl,directstr_62+2		;//hl points static string [Qc055]
		ld		de,(Label22_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label22.Text.Set' [Qc234]
.QLn_1681		;//label23.text.set "..."
		ld		hl,directstr_62+2		;//hl points static string [Qc055]
		ld		de,(Label23_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label23.Text.Set' [Qc234]
.QLn_1682		;//label24.text.set "..."
		ld		hl,directstr_62+2		;//hl points static string [Qc055]
		ld		de,(Label24_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label24.Text.Set' [Qc234]
.QLn_1683		;//label25.text.set "..."
		ld		hl,directstr_62+2		;//hl points static string [Qc055]
		ld		de,(Label25_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label25.Text.Set' [Qc234]
.QLn_1685		;//Label21.Colour.Set Colour.White,colour.Blue,1
		ld		hl,Label21_TextAppearance		;//hl=address of 'Label21_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,7			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label21.Colour.Set' [Qc234]
.QLn_1686		;//Label22.Colour.Set Colour.White,colour.Blue,1
		ld		hl,Label22_TextAppearance		;//hl=address of 'Label22_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,7			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label22.Colour.Set' [Qc234]
.QLn_1687		;//Label23.Colour.Set Colour.White,colour.Blue,1
		ld		hl,Label23_TextAppearance		;//hl=address of 'Label23_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,7			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label23.Colour.Set' [Qc234]
.QLn_1688		;//Label24.Colour.Set Colour.White,colour.Blue,1
		ld		hl,Label24_TextAppearance		;//hl=address of 'Label24_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,7			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label24.Colour.Set' [Qc234]
.QLn_1689		;//Label25.Colour.Set Colour.White,colour.Blue,1
		ld		hl,Label25_TextAppearance		;//hl=address of 'Label25_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,7			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label25.Colour.Set' [Qc234]
.QLn_1692		;//if (iUserOnlineTotal > 0) then
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7558_Exit0				;// [Qc1220]
.QLn_1693		;//u16In1 = u16UserOnline(0)
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_1694		;//F131_7				//.. get User info
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_1695		;//sText = strOut1 + "   " + strOut2
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_63+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_1696		;//label21.text.set sText
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		ld		de,(Label21_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label21.Text.Set' [Qc234]
.QLn_1697		;//endif
.QIf7558_Exit0:
.QIf7558_EndIf:
.QLn_1699		;//if (iUserOnlineTotal > 1) then
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,1			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7596_Exit0				;// [Qc1220]
.QLn_1700		;//u16In1 = u16UserOnline(1)
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_1701		;//F131_7				//.. get User info
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_1702		;//sText = strOut1 + "   " + strOut2
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_63+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_1703		;//label22.text.set sText
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		ld		de,(Label22_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label22.Text.Set' [Qc234]
.QLn_1704		;//endif
.QIf7596_Exit0:
.QIf7596_EndIf:
.QLn_1706		;//if (iUserOnlineTotal > 2) then
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,2			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7634_Exit0				;// [Qc1220]
.QLn_1707		;//u16In1 = u16UserOnline(2)
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_1708		;//F131_7				//.. get User info
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_1709		;//sText = strOut1 + "   " + strOut2
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_63+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_1710		;//label23.text.set sText
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		ld		de,(Label23_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label23.Text.Set' [Qc234]
.QLn_1711		;//endif
.QIf7634_Exit0:
.QIf7634_EndIf:
.QLn_1713		;//if (iUserOnlineTotal > 3) then
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,3			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7672_Exit0				;// [Qc1220]
.QLn_1714		;//u16In1 = u16UserOnline(2)
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_1715		;//F131_7				//.. get User info
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_1716		;//sText = strOut1 + "   " + strOut2
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_63+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_1717		;//label24.text.set sText
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		ld		de,(Label24_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label24.Text.Set' [Qc234]
.QLn_1718		;//endif
.QIf7672_Exit0:
.QIf7672_EndIf:
.QLn_1720		;//if (iUserOnlineTotal > 4) then
		Ld		de,(var_wrd_iUserOnlineTotal)			;// Optimize -1- [Qc1001]
		Ld		hl,4			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7710_Exit0				;// [Qc1220]
.QLn_1721		;//u16In1 = u16UserOnline(2)
		ld		hl,2		;//hl=number '2' [Qc054]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_1722		;//F131_7				//.. get User info
		call	QFunc_F131_7				;//Call 'F131_7' [Qc234]
.QLn_1723		;//sText = strOut1 + "   " + strOut2
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		ex		de,hl 		;// [Qc269]
		ld		hl,directstr_63+2		;//hl points static string [Qc055]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sText$'=Expression
		ld		de,(var_str_sText)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sText'= [Qc221]
.QLn_1724		;//label25.text.set sText
		ld		hl,(var_str_sText)		;//hl=pointer to string 'var_str_sText' [Qc056]
		ld		de,(Label25_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label25.Text.Set' [Qc234]
.QLn_1725		;//endif
.QIf7710_Exit0:
.QIf7710_EndIf:
.QLn_1727		;//label21.refresh
		ld		hl,Label21		;//hl=address of 'Label21' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label21.Refresh' [Qc234]
.QLn_1728		;//label22.refresh
		ld		hl,Label22		;//hl=address of 'Label22' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label22.Refresh' [Qc234]
.QLn_1729		;//label23.refresh
		ld		hl,Label23		;//hl=address of 'Label23' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label23.Refresh' [Qc234]
.QLn_1730		;//label24.refresh
		ld		hl,Label24		;//hl=address of 'Label24' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label24.Refresh' [Qc234]
.QLn_1731		;//label25.refresh
		ld		hl,Label25		;//hl=address of 'Label25' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label25.Refresh' [Qc234]
.QLn_1733		;//intDelay = 10				// 200ms
		ld		hl,10		;//hl=number '10' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_1734		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_1735		;//iStpStartup = 120
		ld		hl,120		;//hl=number '120' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1736		;//return
		ret		;// [Qc250]
.QLn_1737		;//EndIf
.QIf7483_Exit0:
.QIf7483_EndIf:
.QLn_1739		;//If iStpStartup = 120 Then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,120			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7782_Exit0				;// [Qc1012]
.QLn_1741		;//u8NetStatus = IO.In(ioA_A)
		ld		hl,(var_wrd_ioA_A) 	;//hl=value of 'var_wrd_ioA_A' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8NetStatus),hl		;//Int variable 'var_wrd_u8NetStatus'=expression result [Qc219]
.QLn_1743		;//if ((u8NetStatus and defNetStatusBitUser) > 0) then
		ld		hl,(var_wrd_u8NetStatus) 	;//hl=value of 'var_wrd_u8NetStatus' [Qc053]
		ex		de,hl 				;// Optimize 512 [Qc5055]
		Ld		hl,(var_byt_defNetStatusBitUser)				;// [Qc5056]
		Ld		h,0					;// [Qc5057]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7804_Exit0				;// [Qc1220]
.QLn_1744		;//iStpStartup = 110
		ld		hl,110		;//hl=number '110' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1745		;//endif
.QIf7804_Exit0:
.QIf7804_EndIf:
.QLn_1747		;//if (iButChoise > 0) then
		Ld		de,(var_wrd_iButChoise)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf7818_Exit0				;// [Qc1220]
.QLn_1748		;//iStpStartup = 130
		ld		hl,130		;//hl=number '130' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1749		;//endif
.QIf7818_Exit0:
.QIf7818_EndIf:
.QLn_1751		;//return
		ret		;// [Qc250]
.QLn_1752		;//endif
.QIf7782_Exit0:
.QIf7782_EndIf:
.QLn_1754		;//If iStpStartup = 130 Then
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,130			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7842_Exit0				;// [Qc1012]
.QLn_1756		;//x = iButChoise - 1
		ld		hl,(var_wrd_iButChoise) 	;//hl=value of 'var_wrd_iButChoise' [Qc053]
		dec		hl		;//Minus 1 [Qc093]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_1757		;//u16OtherID = u16UserOnline(x)
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		a,(hl)		;// [Qc121]
		inc		hl			;// [Qc122]
		ld		h,(hl)		;// [Qc123]
		ld		l,a			;// [Qc124]
		ld		(var_wrd_u16OtherID),hl		;//Int variable 'var_wrd_u16OtherID'=expression result [Qc219]
.QLn_1759		;//u16OtherUserId = u16OtherID //voip
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
		ld		(var_wrd_u16OtherUserId),hl		;//Int variable 'var_wrd_u16OtherUserId'=expression result [Qc219]
.QLn_1761		;//sDb = "Other user is: "+str(u16OtherID) :sysDebug
		ld		hl,directstr_64+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1763		;//intDelay = 10			//.. 200ms
		ld		hl,10		;//hl=number '10' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_1765		;//if (u16OtherID = u16MyUserID ) then
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_wrd_u16MyUserID) 	;//hl=value of 'var_wrd_u16MyUserID' [Qc053]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7886_Exit0				;// [Qc1012]
.QLn_1766		;//if (iButChoise = 1) then
		Ld		hl,(var_wrd_iButChoise)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7899_Exit0				;// [Qc1012]
.QLn_1767		;//Label21.Colour.Set Colour.White,colour.Orange,1
		ld		hl,Label21_TextAppearance		;//hl=address of 'Label21_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label21.Colour.Set' [Qc234]
.QLn_1768		;//Label21.refresh
		ld		hl,Label21		;//hl=address of 'Label21' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label21.Refresh' [Qc234]
.QLn_1769		;//endif
.QIf7899_Exit0:
.QIf7899_EndIf:
.QLn_1770		;//if (iButChoise = 2) then
		Ld		hl,(var_wrd_iButChoise)			;// Optimize -1a- [Qc1062]
		Ld		de,2			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7927_Exit0				;// [Qc1012]
.QLn_1771		;//Label22.Colour.Set Colour.White,colour.Orange,1
		ld		hl,Label22_TextAppearance		;//hl=address of 'Label22_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label22.Colour.Set' [Qc234]
.QLn_1772		;//Label22.refresh
		ld		hl,Label22		;//hl=address of 'Label22' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label22.Refresh' [Qc234]
.QLn_1773		;//endif
.QIf7927_Exit0:
.QIf7927_EndIf:
.QLn_1774		;//if (iButChoise = 3) then
		Ld		hl,(var_wrd_iButChoise)			;// Optimize -1a- [Qc1062]
		Ld		de,3			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7955_Exit0				;// [Qc1012]
.QLn_1775		;//Label23.Colour.Set Colour.White,colour.Orange,1
		ld		hl,Label23_TextAppearance		;//hl=address of 'Label23_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label23.Colour.Set' [Qc234]
.QLn_1776		;//Label23.refresh
		ld		hl,Label23		;//hl=address of 'Label23' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label23.Refresh' [Qc234]
.QLn_1777		;//endif
.QIf7955_Exit0:
.QIf7955_EndIf:
.QLn_1778		;//if (iButChoise = 4) then
		Ld		hl,(var_wrd_iButChoise)			;// Optimize -1a- [Qc1062]
		Ld		de,4			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf7983_Exit0				;// [Qc1012]
.QLn_1779		;//Label24.Colour.Set Colour.White,colour.Orange,1
		ld		hl,Label24_TextAppearance		;//hl=address of 'Label24_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label24.Colour.Set' [Qc234]
.QLn_1780		;//Label24.refresh
		ld		hl,Label24		;//hl=address of 'Label24' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label24.Refresh' [Qc234]
.QLn_1781		;//endif
.QIf7983_Exit0:
.QIf7983_EndIf:
.QLn_1782		;//if (iButChoise = 5) then
		Ld		hl,(var_wrd_iButChoise)			;// Optimize -1a- [Qc1062]
		Ld		de,5			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8011_Exit0				;// [Qc1012]
.QLn_1783		;//Label25.Colour.Set Colour.White,colour.Orange,1
		ld		hl,Label25_TextAppearance		;//hl=address of 'Label25_TextAppearance' [Qc223]
		push		hl		;//Store result [Qc005]
		ld		hl,8		;//hl=number '8' [Qc054]
		push		hl		;// Store result [Qc225]
		Ld 		de,2			;// 1040 [Qc1040]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_Label_Colour_Set				;//Call 'Label25.Colour.Set' [Qc234]
.QLn_1784		;//Label25.refresh
		ld		hl,Label25		;//hl=address of 'Label25' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label25.Refresh' [Qc234]
.QLn_1785		;//endif
.QIf8011_Exit0:
.QIf8011_EndIf:
.QLn_1787		;//iButChoise = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_1788		;//intDelay = 20			//.. 400ms
		ld		hl,20		;//hl=number '20' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_1789		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_1790		;//iStpStartup = 110
		ld		hl,110		;//hl=number '110' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1791		;//return
		ret		;// [Qc250]
.QLn_1792		;//endif
.QIf7886_Exit0:
.QIf7886_EndIf:
.QLn_1794		;//iButChoise = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iButChoise),hl		;//Int variable 'var_wrd_iButChoise'=expression result [Qc219]
.QLn_1796		;//u16in1 = u16OtherID
		ld		hl,(var_wrd_u16OtherID) 	;//hl=value of 'var_wrd_u16OtherID' [Qc053]
		ld		(var_wrd_u16In1),hl		;//Int variable 'var_wrd_u16In1'=expression result [Qc219]
.QLn_1797		;//F131_33
		call	QFunc_F131_33				;//Call 'F131_33' [Qc234]
.QLn_1799		;//iTimeOut = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iTimeOut),hl		;//Int variable 'var_wrd_iTimeOut'=expression result [Qc219]
.QLn_1800		;//intDelay = 10				//.. 200ms
		ld		hl,10		;//hl=number '10' [Qc054]
		ld		(var_wrd_intDelay),hl		;//Int variable 'var_wrd_intDelay'=expression result [Qc219]
.QLn_1801		;//intDelayCt = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_intDelayCt),hl		;//Int variable 'var_wrd_intDelayCt'=expression result [Qc219]
.QLn_1802		;//iStpStartup = 140
		ld		hl,140		;//hl=number '140' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1803		;//return
		ret		;// [Qc250]
.QLn_1804		;//endif
.QIf7842_Exit0:
.QIf7842_EndIf:
.QLn_1806		;//If iStpStartup = 140 Then	//.. Wait for  Appname
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,140			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8081_Exit0				;// [Qc1012]
.QLn_1808		;//iTimeOut = iTimeOut + 1
		ld		hl,(var_wrd_iTimeOut) 	;//hl=value of 'var_wrd_iTimeOut' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iTimeOut),hl		;//Int variable 'var_wrd_iTimeOut'=expression result [Qc219]
.QLn_1809		;//if (iTimeout > 5) then
		Ld		de,(var_wrd_iTimeOut)			;// Optimize -1- [Qc1001]
		Ld		hl,5			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf8093_Exit0				;// [Qc1220]
.QLn_1810		;//sDb = "Appname timeout step 140":sysDebug
		ld		hl,directstr_65+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1811		;//iStpStartup = 100
		ld		hl,100		;//hl=number '100' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1812		;//endif
.QIf8093_Exit0:
.QIf8093_EndIf:
.QLn_1814		;//u8NetStatus = IO.In(ioA_A)
		ld		hl,(var_wrd_ioA_A) 	;//hl=value of 'var_wrd_ioA_A' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8NetStatus),hl		;//Int variable 'var_wrd_u8NetStatus'=expression result [Qc219]
.QLn_1815		;//if ((u8NetStatus and defNetStatusBitSys) = 0) then
		ld		hl,(var_wrd_u8NetStatus) 	;//hl=value of 'var_wrd_u8NetStatus' [Qc053]
		ex		de,hl 				;// Optimize 512 [Qc5055]
		Ld		hl,(var_byt_defNetStatusBitSys)				;// [Qc5056]
		Ld		h,0					;// [Qc5057]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ex		de,hl 		;// [Qc269]
		ld		hl,0		;//hl=number '0' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8132_Exit0				;// [Qc1012]
.QLn_1816		;//return
		ret		;// [Qc250]
.QLn_1817		;//endif
.QIf8132_Exit0:
.QIf8132_EndIf:
.QLn_1819		;//F131_34
		call	QFunc_F131_34				;//Call 'F131_34' [Qc234]
.QLn_1821		;//Label26.Text.Set "Appname: "+strOut1
		ld		hl,directstr_66+2		;//hl points static string [Qc055]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
		ld		de,(Label26_Text)		;// [Qc226]
		call	Quig_LetString				;//Call 'Label26.Text.Set' [Qc234]
.QLn_1822		;//Label26.Refresh
		ld		hl,Label26		;//hl=address of 'Label26' [Qc223]
		call	Quig_Control_Refresh				;//Call 'Label26.Refresh' [Qc234]
.QLn_1824		;//sDb="App: "+strOut1: sysDebug
		ld		hl,directstr_67+2		;//hl points static string [Qc055]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1826		;//if (strOut1 <> strAppname) then
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_strAppname)		;//hl=pointer to string 'var_str_strAppname' [Qc056]
		call	Quig_Str_Ot		;/Compare strings other than HL<>DE [Qc103]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf8166_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_1827		;//iStpStartup = 100
		ld		hl,100		;//hl=number '100' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1828		;//else
		jp		QIf8166_EndIf		;//Jump to EndIf
.QIf8166_Exit0:
.QLn_1829		;//iStpStartup = 150
		ld		hl,150		;//hl=number '150' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1830		;//endif
.QIf8166_Exit1:
.QIf8166_EndIf:
.QLn_1831		;//return
		ret		;// [Qc250]
.QLn_1832		;//endif
.QIf8081_Exit0:
.QIf8081_EndIf:
.QLn_1834		;//If iStpStartup = 150 Then	//.. End
		Ld		hl,(var_wrd_iStpStartup)			;// Optimize -1a- [Qc1062]
		Ld		de,150			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8196_Exit0				;// [Qc1012]
.QLn_1836		;//iStpStartup = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iStpStartup),hl		;//Int variable 'var_wrd_iStpStartup'=expression result [Qc219]
.QLn_1838		;//Form2.close
		ld		hl,1		;//hl=number '1' [Qc224]
		call	Quig_Close_Form				;//Call 'Form2.Close' [Qc234]
.QLn_1839		;//Form1.open
		ld		hl,0		;//hl=number '0' [Qc224]
		call	Quig_Form_Open				;//Call 'Form1.Open' [Qc234]
.QLn_1841		;//game_begin
		call	QFunc_game_begin				;//Call 'game_begin' [Qc234]
.QLn_1842		;//endif
.QIf8196_Exit0:
.QIf8196_EndIf:
.QLn_1843		;//EndF
		ret		;// [Qc262]
.QLn_1847		;//Function sys_IO_init:Void()
.QFunc_SYS_IO_INIT
.QLn_1849		;//If  (Machine = 7)  Or  (Machine = 8)  Or  (Machine = 9) Or  (Machine = 10) Then
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,7		;//hl=number '7' [Qc054]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl		;/Get result from Stack [Qc051]
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,8		;//hl=number '8' [Qc054]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
		push		hl		;/Get result from Stack [Qc051]
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,9		;//hl=number '9' [Qc054]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
		push		hl		;/Get result from Stack [Qc051]
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,10		;//hl=number '10' [Qc054]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf8278_Exit0			;// [Qc5062]
.QLn_1850		;//ioA_0 = #40f0 : ioA_1 = #41f0 : ioA_2 = #42f0 : ioA_3 = #43f0
		ld		hl,16624		;//hl=number '16624' [Qc054]
		ld		(var_wrd_ioA_0),hl		;//Int variable 'var_wrd_ioA_0'=expression result [Qc219]
		ld		hl,16880		;//hl=number '16880' [Qc054]
		ld		(var_wrd_ioA_1),hl		;//Int variable 'var_wrd_ioA_1'=expression result [Qc219]
		ld		hl,17136		;//hl=number '17136' [Qc054]
		ld		(var_wrd_ioA_2),hl		;//Int variable 'var_wrd_ioA_2'=expression result [Qc219]
		ld		hl,17392		;//hl=number '17392' [Qc054]
		ld		(var_wrd_ioA_3),hl		;//Int variable 'var_wrd_ioA_3'=expression result [Qc219]
.QLn_1851		;//ioA_4 = #44f0 : ioA_5 = #45f0 : ioA_6 = #46f0 : ioA_7 = #47f0
		ld		hl,17648		;//hl=number '17648' [Qc054]
		ld		(var_wrd_ioA_4),hl		;//Int variable 'var_wrd_ioA_4'=expression result [Qc219]
		ld		hl,17904		;//hl=number '17904' [Qc054]
		ld		(var_wrd_ioA_5),hl		;//Int variable 'var_wrd_ioA_5'=expression result [Qc219]
		ld		hl,18160		;//hl=number '18160' [Qc054]
		ld		(var_wrd_ioA_6),hl		;//Int variable 'var_wrd_ioA_6'=expression result [Qc219]
		ld		hl,18416		;//hl=number '18416' [Qc054]
		ld		(var_wrd_ioA_7),hl		;//Int variable 'var_wrd_ioA_7'=expression result [Qc219]
.QLn_1852		;//ioA_8 = #48f0 : ioA_9 = #49f0 : ioA_A = #4af0 : ioA_B = #4bf0
		ld		hl,18672		;//hl=number '18672' [Qc054]
		ld		(var_wrd_ioA_8),hl		;//Int variable 'var_wrd_ioA_8'=expression result [Qc219]
		ld		hl,18928		;//hl=number '18928' [Qc054]
		ld		(var_wrd_ioA_9),hl		;//Int variable 'var_wrd_ioA_9'=expression result [Qc219]
		ld		hl,19184		;//hl=number '19184' [Qc054]
		ld		(var_wrd_ioA_A),hl		;//Int variable 'var_wrd_ioA_A'=expression result [Qc219]
		ld		hl,19440		;//hl=number '19440' [Qc054]
		ld		(var_wrd_ioA_B),hl		;//Int variable 'var_wrd_ioA_B'=expression result [Qc219]
.QLn_1853		;//ioA_C = #4cf0 : ioA_D = #4df0 : ioA_E = #4ef0 : ioA_F = #4ff0
		ld		hl,19696		;//hl=number '19696' [Qc054]
		ld		(var_wrd_ioA_C),hl		;//Int variable 'var_wrd_ioA_C'=expression result [Qc219]
		ld		hl,19952		;//hl=number '19952' [Qc054]
		ld		(var_wrd_ioA_D),hl		;//Int variable 'var_wrd_ioA_D'=expression result [Qc219]
		ld		hl,20208		;//hl=number '20208' [Qc054]
		ld		(var_wrd_ioA_E),hl		;//Int variable 'var_wrd_ioA_E'=expression result [Qc219]
		ld		hl,20464		;//hl=number '20464' [Qc054]
		ld		(var_wrd_ioA_F),hl		;//Int variable 'var_wrd_ioA_F'=expression result [Qc219]
.QLn_1855		;//strCPU = "MSX"
		ld		hl,directstr_68+2		;//hl points static string [Qc055]
;**** 'var_str_strCPU$'=Expression
		ld		de,(var_str_strCPU)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strCPU'= [Qc221]
.QLn_1856		;//EndIf
.QIf8278_Exit0:
.QIf8278_EndIf:
.QLn_1858		;//If  (Machine = 6)  Then
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,6		;//hl=number '6' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8335_Exit0				;// [Qc1012]
.QLn_1859		;//ioA_0 = #40 : ioA_1 = #41 : ioA_2 = #42 : ioA_3 = #43
		ld		hl,64		;//hl=number '64' [Qc054]
		ld		(var_wrd_ioA_0),hl		;//Int variable 'var_wrd_ioA_0'=expression result [Qc219]
		ld		hl,65		;//hl=number '65' [Qc054]
		ld		(var_wrd_ioA_1),hl		;//Int variable 'var_wrd_ioA_1'=expression result [Qc219]
		ld		hl,66		;//hl=number '66' [Qc054]
		ld		(var_wrd_ioA_2),hl		;//Int variable 'var_wrd_ioA_2'=expression result [Qc219]
		ld		hl,67		;//hl=number '67' [Qc054]
		ld		(var_wrd_ioA_3),hl		;//Int variable 'var_wrd_ioA_3'=expression result [Qc219]
.QLn_1860		;//ioA_4 = #44 : ioA_5 = #45 : ioA_6 = #46 : ioA_7 = #47
		ld		hl,68		;//hl=number '68' [Qc054]
		ld		(var_wrd_ioA_4),hl		;//Int variable 'var_wrd_ioA_4'=expression result [Qc219]
		ld		hl,69		;//hl=number '69' [Qc054]
		ld		(var_wrd_ioA_5),hl		;//Int variable 'var_wrd_ioA_5'=expression result [Qc219]
		ld		hl,70		;//hl=number '70' [Qc054]
		ld		(var_wrd_ioA_6),hl		;//Int variable 'var_wrd_ioA_6'=expression result [Qc219]
		ld		hl,71		;//hl=number '71' [Qc054]
		ld		(var_wrd_ioA_7),hl		;//Int variable 'var_wrd_ioA_7'=expression result [Qc219]
.QLn_1861		;//ioA_8 = #48 : ioA_9 = #49 : ioA_A = #4a : ioA_B = #4b
		ld		hl,72		;//hl=number '72' [Qc054]
		ld		(var_wrd_ioA_8),hl		;//Int variable 'var_wrd_ioA_8'=expression result [Qc219]
		ld		hl,73		;//hl=number '73' [Qc054]
		ld		(var_wrd_ioA_9),hl		;//Int variable 'var_wrd_ioA_9'=expression result [Qc219]
		ld		hl,74		;//hl=number '74' [Qc054]
		ld		(var_wrd_ioA_A),hl		;//Int variable 'var_wrd_ioA_A'=expression result [Qc219]
		ld		hl,75		;//hl=number '75' [Qc054]
		ld		(var_wrd_ioA_B),hl		;//Int variable 'var_wrd_ioA_B'=expression result [Qc219]
.QLn_1862		;//ioA_C = #4c : ioA_D = #4d : ioA_E = #4e : ioA_F = #4f
		ld		hl,76		;//hl=number '76' [Qc054]
		ld		(var_wrd_ioA_C),hl		;//Int variable 'var_wrd_ioA_C'=expression result [Qc219]
		ld		hl,77		;//hl=number '77' [Qc054]
		ld		(var_wrd_ioA_D),hl		;//Int variable 'var_wrd_ioA_D'=expression result [Qc219]
		ld		hl,78		;//hl=number '78' [Qc054]
		ld		(var_wrd_ioA_E),hl		;//Int variable 'var_wrd_ioA_E'=expression result [Qc219]
		ld		hl,79		;//hl=number '79' [Qc054]
		ld		(var_wrd_ioA_F),hl		;//Int variable 'var_wrd_ioA_F'=expression result [Qc219]
.QLn_1864		;//strCPU = "EP"
		ld		hl,directstr_69+2		;//hl points static string [Qc055]
;**** 'var_str_strCPU$'=Expression
		ld		de,(var_str_strCPU)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strCPU'= [Qc221]
.QLn_1865		;//EndIf
.QIf8335_Exit0:
.QIf8335_EndIf:
.QLn_1867		;//If  (Machine = Machine.Pcw8xxx)  or  ( Machine = Machine.Pcw9xxx) or ( Machine = Machine.Pcw16)   Then
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,12		;//hl=number '12' [Qc054]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl		;/Get result from Stack [Qc051]
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,13		;//hl=number '13' [Qc054]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,h		;//Or HL & DE [Qc071]
		or		d		;// [Qc072]
		ld		h,a		;// [Qc073]
		ld		a,l		;// [Qc074]
		or		e		;// [Qc075]
		ld		l,a		;// [Qc076]
		push		hl		;/Get result from Stack [Qc051]
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,14		;//hl=number '14' [Qc054]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf8426_Exit0			;// [Qc5062]
.QLn_1868		;//ioA_0 = #40B0 : ioA_1 = #41B0 : ioA_2 = #42B0 : ioA_3 = #43B0
		ld		hl,16560		;//hl=number '16560' [Qc054]
		ld		(var_wrd_ioA_0),hl		;//Int variable 'var_wrd_ioA_0'=expression result [Qc219]
		ld		hl,16816		;//hl=number '16816' [Qc054]
		ld		(var_wrd_ioA_1),hl		;//Int variable 'var_wrd_ioA_1'=expression result [Qc219]
		ld		hl,17072		;//hl=number '17072' [Qc054]
		ld		(var_wrd_ioA_2),hl		;//Int variable 'var_wrd_ioA_2'=expression result [Qc219]
		ld		hl,17328		;//hl=number '17328' [Qc054]
		ld		(var_wrd_ioA_3),hl		;//Int variable 'var_wrd_ioA_3'=expression result [Qc219]
.QLn_1869		;//ioA_4 = #44B0 : ioA_5 = #45B0 : ioA_6 = #46B0 : ioA_7 = #47B0
		ld		hl,17584		;//hl=number '17584' [Qc054]
		ld		(var_wrd_ioA_4),hl		;//Int variable 'var_wrd_ioA_4'=expression result [Qc219]
		ld		hl,17840		;//hl=number '17840' [Qc054]
		ld		(var_wrd_ioA_5),hl		;//Int variable 'var_wrd_ioA_5'=expression result [Qc219]
		ld		hl,18096		;//hl=number '18096' [Qc054]
		ld		(var_wrd_ioA_6),hl		;//Int variable 'var_wrd_ioA_6'=expression result [Qc219]
		ld		hl,18352		;//hl=number '18352' [Qc054]
		ld		(var_wrd_ioA_7),hl		;//Int variable 'var_wrd_ioA_7'=expression result [Qc219]
.QLn_1870		;//ioA_8 = #48B0 : ioA_9 = #49B0 : ioA_A = #4aB0 : ioA_B = #4bB0
		ld		hl,18608		;//hl=number '18608' [Qc054]
		ld		(var_wrd_ioA_8),hl		;//Int variable 'var_wrd_ioA_8'=expression result [Qc219]
		ld		hl,18864		;//hl=number '18864' [Qc054]
		ld		(var_wrd_ioA_9),hl		;//Int variable 'var_wrd_ioA_9'=expression result [Qc219]
		ld		hl,19120		;//hl=number '19120' [Qc054]
		ld		(var_wrd_ioA_A),hl		;//Int variable 'var_wrd_ioA_A'=expression result [Qc219]
		ld		hl,19376		;//hl=number '19376' [Qc054]
		ld		(var_wrd_ioA_B),hl		;//Int variable 'var_wrd_ioA_B'=expression result [Qc219]
.QLn_1871		;//ioA_C = #4cB0 : ioA_D = #4dB0 : ioA_E = #4eB0 : ioA_F = #4fB0
		ld		hl,19632		;//hl=number '19632' [Qc054]
		ld		(var_wrd_ioA_C),hl		;//Int variable 'var_wrd_ioA_C'=expression result [Qc219]
		ld		hl,19888		;//hl=number '19888' [Qc054]
		ld		(var_wrd_ioA_D),hl		;//Int variable 'var_wrd_ioA_D'=expression result [Qc219]
		ld		hl,20144		;//hl=number '20144' [Qc054]
		ld		(var_wrd_ioA_E),hl		;//Int variable 'var_wrd_ioA_E'=expression result [Qc219]
		ld		hl,20400		;//hl=number '20400' [Qc054]
		ld		(var_wrd_ioA_F),hl		;//Int variable 'var_wrd_ioA_F'=expression result [Qc219]
.QLn_1873		;//strCPU = "PCW"
		ld		hl,directstr_70+2		;//hl points static string [Qc055]
;**** 'var_str_strCPU$'=Expression
		ld		de,(var_str_strCPU)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strCPU'= [Qc221]
.QLn_1874		;//EndIf
.QIf8426_Exit0:
.QIf8426_EndIf:
.QLn_1876		;//If  (Machine < 5)  Then
		call	Quig_Machine_Get		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,5		;//hl=number '5' [Qc054]
		call 	Quig_LT_HL_Direct		;// Optimize -3j- [Qc1219]
		jp		z,QIf8478_Exit0				;// [Qc1220]
.QLn_1877		;//ioA_0 = #fd40 : ioA_1 = #fd41 : ioA_2 = #fd42 : ioA_3 = #fd43
		ld		hl,-704		;//hl=number '-704' [Qc054]
		ld		(var_wrd_ioA_0),hl		;//Int variable 'var_wrd_ioA_0'=expression result [Qc219]
		ld		hl,-703		;//hl=number '-703' [Qc054]
		ld		(var_wrd_ioA_1),hl		;//Int variable 'var_wrd_ioA_1'=expression result [Qc219]
		ld		hl,-702		;//hl=number '-702' [Qc054]
		ld		(var_wrd_ioA_2),hl		;//Int variable 'var_wrd_ioA_2'=expression result [Qc219]
		ld		hl,-701		;//hl=number '-701' [Qc054]
		ld		(var_wrd_ioA_3),hl		;//Int variable 'var_wrd_ioA_3'=expression result [Qc219]
.QLn_1878		;//ioA_4 = #fd44 : ioA_5 = #fd45 : ioA_6 = #fd46 : ioA_7 = #fd47
		ld		hl,-700		;//hl=number '-700' [Qc054]
		ld		(var_wrd_ioA_4),hl		;//Int variable 'var_wrd_ioA_4'=expression result [Qc219]
		ld		hl,-699		;//hl=number '-699' [Qc054]
		ld		(var_wrd_ioA_5),hl		;//Int variable 'var_wrd_ioA_5'=expression result [Qc219]
		ld		hl,-698		;//hl=number '-698' [Qc054]
		ld		(var_wrd_ioA_6),hl		;//Int variable 'var_wrd_ioA_6'=expression result [Qc219]
		ld		hl,-697		;//hl=number '-697' [Qc054]
		ld		(var_wrd_ioA_7),hl		;//Int variable 'var_wrd_ioA_7'=expression result [Qc219]
.QLn_1879		;//ioA_8 = #fd48 : ioA_9 = #fd49 : ioA_A = #fd4a : ioA_B = #fd4b
		ld		hl,-696		;//hl=number '-696' [Qc054]
		ld		(var_wrd_ioA_8),hl		;//Int variable 'var_wrd_ioA_8'=expression result [Qc219]
		ld		hl,-695		;//hl=number '-695' [Qc054]
		ld		(var_wrd_ioA_9),hl		;//Int variable 'var_wrd_ioA_9'=expression result [Qc219]
		ld		hl,-694		;//hl=number '-694' [Qc054]
		ld		(var_wrd_ioA_A),hl		;//Int variable 'var_wrd_ioA_A'=expression result [Qc219]
		ld		hl,-693		;//hl=number '-693' [Qc054]
		ld		(var_wrd_ioA_B),hl		;//Int variable 'var_wrd_ioA_B'=expression result [Qc219]
.QLn_1880		;//ioA_C = #fd4c : ioA_D = #fd4d : ioA_E = #fd4e : ioA_F = #fd4f
		ld		hl,-692		;//hl=number '-692' [Qc054]
		ld		(var_wrd_ioA_C),hl		;//Int variable 'var_wrd_ioA_C'=expression result [Qc219]
		ld		hl,-691		;//hl=number '-691' [Qc054]
		ld		(var_wrd_ioA_D),hl		;//Int variable 'var_wrd_ioA_D'=expression result [Qc219]
		ld		hl,-690		;//hl=number '-690' [Qc054]
		ld		(var_wrd_ioA_E),hl		;//Int variable 'var_wrd_ioA_E'=expression result [Qc219]
		ld		hl,-689		;//hl=number '-689' [Qc054]
		ld		(var_wrd_ioA_F),hl		;//Int variable 'var_wrd_ioA_F'=expression result [Qc219]
.QLn_1882		;//strCPU = "CPC"
		ld		hl,directstr_71+2		;//hl points static string [Qc055]
;**** 'var_str_strCPU$'=Expression
		ld		de,(var_str_strCPU)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strCPU'= [Qc221]
.QLn_1883		;//EndIf
.QIf8478_Exit0:
.QIf8478_EndIf:
.QLn_1885		;//sDb = strCPU :sysDebug
		ld		hl,(var_str_strCPU)		;//hl=pointer to string 'var_str_strCPU' [Qc056]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1886		;//EndF
		ret		;// [Qc262]
.QLn_1891		;//Function  ArmResponse:Int()
.QFunc_ARMRESPONSE
.QLn_1898		;//resp = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_resp),hl		;//Int variable 'var_wrd_resp'=expression result [Qc219]
.QLn_1902		;//While (resp = 1)
.QWh8539_Start:
		Ld		hl,(var_wrd_resp)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		ld		a,h			//;/Branch if HL=0 [Qc492]
		or		l			//; [Qc491]
		jp		z,QWh8539_Exit:	//;// [Qc490]
.QLn_1903		;//resp = IO.In(ioA_1)
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_resp),hl		;//Int variable 'var_wrd_resp'=expression result [Qc219]
.QLn_1904		;//Wend
		jp 		QWh8539_Start
.QWh8539_Exit:
.QLn_1906		;//If  resp = 2 Then
		Ld		hl,(var_wrd_resp)			;// Optimize -1a- [Qc1062]
		Ld		de,2			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8569_Exit0				;// [Qc1012]
.QLn_1907		;//F72_4
		call	QFunc_F72_4				;//Call 'F72_4' [Qc234]
.QLn_1908		;//EndIf
.QIf8569_Exit0:
.QIf8569_EndIf:
.QLn_1910		;//Return(resp)
		ld		hl,(var_wrd_resp) 	;//hl=value of 'var_wrd_resp' [Qc053]
		ret		;// [Qc250]
.QLn_1911		;//EndF
		ld		hl,0		;// Return 0 Value [Qc260]
		ret		;// [Qc262]
.QLn_1916		;//Function	F72_4:Void()
.QFunc_F72_4
.QLn_1918		;//Lock.On
		di		;// [Qc251]
.QLn_1919		;//sDb = "SF3 ERROR"
		ld		hl,directstr_72+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
.QLn_1920		;//sysDebug
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_1921		;//Lock.Off
		ei		;//	[Qc252]
.QLn_1922		;//EndF
		ret		;// [Qc262]
.QLn_1924		;//Function F72_25:Void()
.QFunc_F72_25
.QLn_1927		;//Lock.On
		di		;// [Qc251]
.QLn_1928		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1929		;//IO.Out ioA_2,25
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,25		;//hl=number '25' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1931		;//For  x = 1 To  8
		ld		hl,8		;//hl=number '8' [Qc054]
		ld 		(QFr8613_Top+1),hl 		;/Copy Result into static'var_wrd_x' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr8613_Loop:ld 		(var_wrd_x),hl ;/Loop Repeat Point [Qc301]
		.QFr8613_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr8613_Start	;// [Qc307]
		jp		nz,QFr8613_Exit	;// [Qc308]
.QFr8613_Start:
.QLn_1932		;//IO.Out ioA_2,Asc(Mid(strIn1,x,1))
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		push		hl		;// Store result [Qc225]
		ld		hl,(var_str_strIn1)		;//hl=pointer to string 'var_str_strIn1' [Qc056]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_x)			;// Optimize -1- [Qc1001]
		Ld		hl,1			;// [Qc1002]
		call	Quig_Mid		;/ Call Function [Qc052]
		call	Quig_Asc		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1933		;//Next
		ld		hl,(var_wrd_x) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr8613_Loop		;// [Qc340]
.QFr8613_Exit:
.QLn_1936		;//IO.Out ioA_1,72
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,72		;//hl=number '72' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1939		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8655_Exit0				;// [Qc1012]
.QLn_1941		;//EndIf
.QIf8655_Exit0:
.QIf8655_EndIf:
.QLn_1943		;//u8Out1    = IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8Out1),hl		;//Int variable 'var_wrd_u8Out1'=expression result [Qc219]
.QLn_1945		;//Lock.Off
		ei		;//	[Qc252]
.QLn_1946		;//EndF
		ret		;// [Qc262]
.QLn_1950		;//Function F72_26:Void()
.QFunc_F72_26
.QLn_1954		;//Lock.On
		di		;// [Qc251]
.QLn_1955		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1956		;//IO.Out ioA_2,26
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,26		;//hl=number '26' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1957		;//IO.Out ioA_2,0
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1959		;//IO.Out ioA_1,72
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,72		;//hl=number '72' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1961		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8703_Exit0				;// [Qc1012]
.QLn_1963		;//EndIf
.QIf8703_Exit0:
.QIf8703_EndIf:
.QLn_1965		;//c = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_1966		;//strOut1 = ""
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strOut1$'=Expression
		ld		de,(var_str_strOut1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut1'= [Qc221]
.QLn_1967		;//While (c  > 0)
.QWh8718_Start:
		Ld		de,(var_wrd_c)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		ld		a,h			//;/Branch if HL=0 [Qc492]
		or		l			//; [Qc491]
		jp		z,QWh8718_Exit:	//;// [Qc490]
.QLn_1968		;//c=  IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_1969		;//If  c > 0 Then
		Ld		de,(var_wrd_c)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf8735_Exit0				;// [Qc1220]
.QLn_1970		;//strOut1= strOut1	+ Chr(c)
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strOut1$'=Expression
		ld		de,(var_str_strOut1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut1'= [Qc221]
.QLn_1971		;//EndIf
.QIf8735_Exit0:
.QIf8735_EndIf:
.QLn_1972		;//Wend
		jp 		QWh8718_Start
.QWh8718_Exit:
.QLn_1974		;//Lock.Off
		ei		;//	[Qc252]
.QLn_1977		;//EndF
		ret		;// [Qc262]
.QLn_1979		;//Function F131_0:Void()
.QFunc_F131_0
.QLn_1982		;//Lock.On
		di		;// [Qc251]
.QLn_1983		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1984		;//IO.Out ioA_2,0
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1986		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_1988		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8787_Exit0				;// [Qc1012]
.QLn_1990		;//EndIf
.QIf8787_Exit0:
.QIf8787_EndIf:
.QLn_1992		;//u8Out1    = IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8Out1),hl		;//Int variable 'var_wrd_u8Out1'=expression result [Qc219]
.QLn_1993		;//Lock.Off
		ei		;//	[Qc252]
.QLn_1995		;//EndF
		ret		;// [Qc262]
.QLn_1997		;//Function F131_1:void()
.QFunc_F131_1
.QLn_2008		;//Lock.On
		di		;// [Qc251]
.QLn_2009		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2010		;//IO.Out ioA_2,1
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,1		;//hl=number '1' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2011		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2013		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8830_Exit0				;// [Qc1012]
.QLn_2015		;//EndIf
.QIf8830_Exit0:
.QIf8830_EndIf:
.QLn_2017		;//u8Out1    = IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8Out1),hl		;//Int variable 'var_wrd_u8Out1'=expression result [Qc219]
.QLn_2019		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2020		;//Endf
		ret		;// [Qc262]
.QLn_2022		;//Function F131_2:void()
.QFunc_F131_2
.QLn_2026		;//Lock.On
		di		;// [Qc251]
.QLn_2028		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2029		;//IO.Out ioA_2,2
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,2		;//hl=number '2' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2030		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2032		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8873_Exit0				;// [Qc1012]
.QLn_2034		;//EndIf
.QIf8873_Exit0:
.QIf8873_EndIf:
.QLn_2036		;//for fc = 0 to 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld 		(QFr8880_Top+1),hl 		;/Copy Result into static'var_wrd_fc' [Qc303]
		ld		hl,0		;//hl=number '0' [Qc054]
		.QFr8880_Loop:ld 		(var_wrd_fc),hl ;/Loop Repeat Point [Qc301]
		.QFr8880_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr8880_Start	;// [Qc307]
		jp		nz,QFr8880_Exit	;// [Qc308]
.QFr8880_Start:
.QLn_2037		;//u16UserOnline(fc) = 0
		ld		hl,(var_wrd_fc) 	;//hl=value of 'var_wrd_fc' [Qc053]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_462+1),hl		;// [Qc210]
		ld		hl,0		;//hl=number '0' [Qc054]
.Quig_Let_462:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_2038		;//next
		ld		hl,(var_wrd_fc) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr8880_Loop		;// [Qc340]
.QFr8880_Exit:
.QLn_2039		;//iUserOnlineTotal = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iUserOnlineTotal),hl		;//Int variable 'var_wrd_iUserOnlineTotal'=expression result [Qc219]
.QLn_2041		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2042		;//EndF
		ret		;// [Qc262]
.QLn_2044		;//Function F131_3:void()
.QFunc_F131_3
.QLn_2050		;//Lock.On
		di		;// [Qc251]
.QLn_2052		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2053		;//IO.Out ioA_2,3
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,3		;//hl=number '3' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2054		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2056		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf8940_Exit0				;// [Qc1012]
.QLn_2058		;//EndIf
.QIf8940_Exit0:
.QIf8940_EndIf:
.QLn_2060		;//iUserOnlineTotal = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iUserOnlineTotal),hl		;//Int variable 'var_wrd_iUserOnlineTotal'=expression result [Qc219]
.QLn_2062		;//for fx = 0 to 20
		ld		hl,20		;//hl=number '20' [Qc054]
		ld 		(QFr8950_Top+1),hl 		;/Copy Result into static'var_wrd_fx' [Qc303]
		ld		hl,0		;//hl=number '0' [Qc054]
		.QFr8950_Loop:ld 		(var_wrd_fx),hl ;/Loop Repeat Point [Qc301]
		.QFr8950_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr8950_Start	;// [Qc307]
		jp		nz,QFr8950_Exit	;// [Qc308]
.QFr8950_Start:
.QLn_2063		;//fy =(IO.In(ioA_2) *256) + IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,256		;//hl=number '256' [Qc054]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ld		(var_wrd_fy),hl		;//Int variable 'var_wrd_fy'=expression result [Qc219]
.QLn_2064		;//if (fy > 0) then
		Ld		de,(var_wrd_fy)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf8977_Exit0				;// [Qc1220]
.QLn_2065		;//u16UserOnline(iUserOnlineTotal) = fy
		ld		hl,(var_wrd_iUserOnlineTotal) 	;//hl=value of 'var_wrd_iUserOnlineTotal' [Qc053]
		ld		bc,ar1_wrd_u16UserOnline+2		;// Return Wrd from Array [Qc118]
		add		hl,hl		;// [Qc119]
		add		hl,bc		;// [Qc120]
		ld		(Quig_Let_466+1),hl		;// [Qc210]
		ld		hl,(var_wrd_fy) 	;//hl=value of 'var_wrd_fy' [Qc053]
.Quig_Let_466:
		ld		(0),hl		;// Address to be filled in [Qc216]
.QLn_2066		;//iUserOnlineTotal = iUserOnlineTotal + 1
		ld		hl,(var_wrd_iUserOnlineTotal) 	;//hl=value of 'var_wrd_iUserOnlineTotal' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iUserOnlineTotal),hl		;//Int variable 'var_wrd_iUserOnlineTotal'=expression result [Qc219]
.QLn_2067		;//endif
.QIf8977_Exit0:
.QIf8977_EndIf:
.QLn_2068		;//next
		ld		hl,(var_wrd_fx) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr8950_Loop		;// [Qc340]
.QFr8950_Exit:
.QLn_2070		;//sDb = "F131_3 users online:"  + str(iUserOnlineTotal):sysDebug
		ld		hl,directstr_73+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_iUserOnlineTotal) 	;//hl=value of 'var_wrd_iUserOnlineTotal' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2072		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2074		;//EndF
		ret		;// [Qc262]
.QLn_2076		;//Function F131_7:Void()
.QFunc_F131_7
.QLn_2082		;//sDb = "131_7 in "+str(u16in1):sysDebug
		ld		hl,directstr_74+2		;//hl points static string [Qc055]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_u16In1) 	;//hl=value of 'var_wrd_u16In1' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2084		;//Lock.On
		di		;// [Qc251]
.QLn_2085		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2086		;//IO.Out ioA_2,7
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,7		;//hl=number '7' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2087		;//IO.Out ioA_2,(u16in1 / 256)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		push		hl		;// Store result [Qc225]
		Ld		de,(var_wrd_u16In1)			;// Optimize -1- [Qc1001]
		Ld		hl,256			;// [Qc1002]
		call	Quig_Div16		;//Divide HL by DE [Qc062]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2088		;//IO.Out ioA_2,(u16in1 And 255)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		push		hl		;// Store result [Qc225]
		Ld		de,(var_wrd_u16In1)			;// Optimize -1- [Qc1001]
		Ld		hl,255			;// [Qc1002]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2089		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2091		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9079_Exit0				;// [Qc1012]
.QLn_2093		;//EndIf
.QIf9079_Exit0:
.QIf9079_EndIf:
.QLn_2095		;//fsw = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_fsw),hl		;//Int variable 'var_wrd_fsw'=expression result [Qc219]
.QLn_2096		;//fx = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_fx),hl		;//Int variable 'var_wrd_fx'=expression result [Qc219]
.QLn_2098		;//strOut1 = "" 	//.. 3000
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strOut1$'=Expression
		ld		de,(var_str_strOut1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut1'= [Qc221]
.QLn_2099		;//strOut2 = ""	//.. Hans
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strOut2$'=Expression
		ld		de,(var_str_strOut2)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut2'= [Qc221]
.QLn_2100		;//strOut3 = ""	//.. NL
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strOut3$'=Expression
		ld		de,(var_str_strOut3)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut3'= [Qc221]
.QLn_2101		;//strOut4 = ""	//.. CPC
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strOut4$'=Expression
		ld		de,(var_str_strOut4)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut4'= [Qc221]
.QLn_2103		;//For fn = 1 To 50
		ld		hl,50		;//hl=number '50' [Qc054]
		ld 		(QFr9112_Top+1),hl 		;/Copy Result into static'var_wrd_fn' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr9112_Loop:ld 		(var_wrd_fn),hl ;/Loop Repeat Point [Qc301]
		.QFr9112_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr9112_Start	;// [Qc307]
		jp		nz,QFr9112_Exit	;// [Qc308]
.QFr9112_Start:
.QLn_2104		;//fc =IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_fc),hl		;//Int variable 'var_wrd_fc'=expression result [Qc219]
.QLn_2106		;//If fc = 0 Then
		Ld		hl,(var_wrd_fc)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9136_Exit0				;// [Qc1012]
.QLn_2107		;//fsw = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_fsw),hl		;//Int variable 'var_wrd_fsw'=expression result [Qc219]
.QLn_2108		;//EndIf
.QIf9136_Exit0:
.QIf9136_EndIf:
.QLn_2110		;//If  fc =35 Then
		Ld		hl,(var_wrd_fc)			;// Optimize -1a- [Qc1062]
		Ld		de,35			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9155_Exit0				;// [Qc1012]
.QLn_2111		;//fx  = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_fx),hl		;//Int variable 'var_wrd_fx'=expression result [Qc219]
.QLn_2112		;//EndIf
.QIf9155_Exit0:
.QIf9155_EndIf:
.QLn_2114		;//If (fc = 35) Or (fc = 44) Then
		Ld		hl,(var_wrd_fc)			;// Optimize -1a- [Qc1062]
		Ld		de,35			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_fc)			;// Optimize -1a- [Qc1062]
		Ld		de,44			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf9191_Exit0			;// [Qc5062]
.QLn_2115		;//fx = fx + 1
		ld		hl,(var_wrd_fx) 	;//hl=value of 'var_wrd_fx' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_fx),hl		;//Int variable 'var_wrd_fx'=expression result [Qc219]
.QLn_2116		;//Else
		jp		QIf9191_EndIf		;//Jump to EndIf
.QIf9191_Exit0:
.QLn_2117		;//If fsw = 0 Then
		Ld		hl,(var_wrd_fsw)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9211_Exit0				;// [Qc1012]
.QLn_2118		;//If (fc <> 32) And  (fc <> 9) Then
		Ld		de,(var_wrd_fc)			;// Optimize -1- [Qc1001]
		Ld		hl,32			;// [Qc1002]
		xor		a		;** Integer x<>y ** [Qc104]
		sbc		hl,de		;//subract de for hl [Qc105]
		ld 		h,a			;//Make h=0 [Qc106]
		jr		z,1		;//	Skip Inc a [Qc107]
		inc		a		;//Increment a [Qc108]
		ld		l,a		;//Set l to 0 or 1 - fail success [Qc109]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_fc)			;// Optimize -1- [Qc1001]
		Ld		hl,9			;// [Qc1002]
		xor		a		;** Integer x<>y ** [Qc104]
		sbc		hl,de		;//subract de for hl [Qc105]
		ld 		h,a			;//Make h=0 [Qc106]
		jr		z,1		;//	Skip Inc a [Qc107]
		inc		a		;//Increment a [Qc108]
		ld		l,a		;//Set l to 0 or 1 - fail success [Qc109]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf9241_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_2119		;//If fx = 2 Then
		Ld		hl,(var_wrd_fx)			;// Optimize -1a- [Qc1062]
		Ld		de,2			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9254_Exit0				;// [Qc1012]
.QLn_2120		;//strOut1 = strOut1 + Chr(fc)
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_fc) 	;//hl=value of 'var_wrd_fc' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strOut1$'=Expression
		ld		de,(var_str_strOut1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut1'= [Qc221]
.QLn_2121		;//EndIf
.QIf9254_Exit0:
.QIf9254_EndIf:
.QLn_2122		;//If fx =3 Then
		Ld		hl,(var_wrd_fx)			;// Optimize -1a- [Qc1062]
		Ld		de,3			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9280_Exit0				;// [Qc1012]
.QLn_2123		;//strOut2 = strOut2 + Chr(fc)
		ld		hl,(var_str_strOut2)		;//hl=pointer to string 'var_str_strOut2' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_fc) 	;//hl=value of 'var_wrd_fc' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strOut2$'=Expression
		ld		de,(var_str_strOut2)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut2'= [Qc221]
.QLn_2124		;//EndIf
.QIf9280_Exit0:
.QIf9280_EndIf:
.QLn_2125		;//If fx =4 Then
		Ld		hl,(var_wrd_fx)			;// Optimize -1a- [Qc1062]
		Ld		de,4			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9306_Exit0				;// [Qc1012]
.QLn_2126		;//strOut3 = strOut3 + Chr(fc)			// NL
		ld		hl,(var_str_strOut3)		;//hl=pointer to string 'var_str_strOut3' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_fc) 	;//hl=value of 'var_wrd_fc' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strOut3$'=Expression
		ld		de,(var_str_strOut3)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut3'= [Qc221]
.QLn_2127		;//EndIf
.QIf9306_Exit0:
.QIf9306_EndIf:
.QLn_2128		;//If fx = 5 Then
		Ld		hl,(var_wrd_fx)			;// Optimize -1a- [Qc1062]
		Ld		de,5			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9332_Exit0				;// [Qc1012]
.QLn_2129		;//strOut4 = strOut4 + Chr(fc)
		ld		hl,(var_str_strOut4)		;//hl=pointer to string 'var_str_strOut4' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_fc) 	;//hl=value of 'var_wrd_fc' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strOut4$'=Expression
		ld		de,(var_str_strOut4)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut4'= [Qc221]
.QLn_2130		;//EndIf
.QIf9332_Exit0:
.QIf9332_EndIf:
.QLn_2131		;//EndIf
.QIf9241_Exit0:
.QIf9241_EndIf:
.QLn_2132		;//EndIf
.QIf9211_Exit0:
.QIf9211_EndIf:
.QLn_2133		;//EndIf
.QIf9191_Exit1:
.QIf9191_EndIf:
.QLn_2134		;//Next
		ld		hl,(var_wrd_fn) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr9112_Loop		;// [Qc340]
.QFr9112_Exit:
.QLn_2138		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2139		;//EndF
		ret		;// [Qc262]
.QLn_2143		;//Function F131_8:void()
.QFunc_F131_8
.QLn_2147		;//Lock.On
		di		;// [Qc251]
.QLn_2148		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2149		;//IO.Out ioA_2,8
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,8		;//hl=number '8' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2150		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2152		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9395_Exit0				;// [Qc1012]
.QLn_2154		;//EndIf
.QIf9395_Exit0:
.QIf9395_EndIf:
.QLn_2156		;//u16MyUserID = (IO.In(ioA_2) *256) + IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,256		;//hl=number '256' [Qc054]
		call	Quig_Mul16		;/Multiply HL & DE [Qc064]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		add		hl,de		;//Add Integer HL & DE Values [Qc058]
		ld		(var_wrd_u16MyUserID),hl		;//Int variable 'var_wrd_u16MyUserID'=expression result [Qc219]
.QLn_2158		;//strUserPass = ""
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strUserPass$'=Expression
		ld		de,(var_str_strUserPass)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strUserPass'= [Qc221]
.QLn_2159		;//fc = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_fc),hl		;//Int variable 'var_wrd_fc'=expression result [Qc219]
.QLn_2160		;//While (fc  > 0)
.QWh9422_Start:
		Ld		de,(var_wrd_fc)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		ld		a,h			//;/Branch if HL=0 [Qc492]
		or		l			//; [Qc491]
		jp		z,QWh9422_Exit:	//;// [Qc490]
.QLn_2161		;//fc=  IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_fc),hl		;//Int variable 'var_wrd_fc'=expression result [Qc219]
.QLn_2162		;//If  fc > 0 Then
		Ld		de,(var_wrd_fc)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf9439_Exit0				;// [Qc1220]
.QLn_2163		;//strUserPass= strUserPass + Chr(fc)
		ld		hl,(var_str_strUserPass)		;//hl=pointer to string 'var_str_strUserPass' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_fc) 	;//hl=value of 'var_wrd_fc' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strUserPass$'=Expression
		ld		de,(var_str_strUserPass)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strUserPass'= [Qc221]
.QLn_2164		;//EndIf
.QIf9439_Exit0:
.QIf9439_EndIf:
.QLn_2165		;//Wend
		jp 		QWh9422_Start
.QWh9422_Exit:
.QLn_2167		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2168		;//EndF
		ret		;// [Qc262]
.QLn_2170		;//Function F131_10:void()
.QFunc_F131_10
.QLn_2174		;//Lock.On
		di		;// [Qc251]
.QLn_2175		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2176		;//IO.Out ioA_2,10
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,10		;//hl=number '10' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2177		;//IO.Out ioA_2,(u16in1 / 256)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		push		hl		;// Store result [Qc225]
		Ld		de,(var_wrd_u16In1)			;// Optimize -1- [Qc1001]
		Ld		hl,256			;// [Qc1002]
		call	Quig_Div16		;//Divide HL by DE [Qc062]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2178		;//IO.Out ioA_2,(u16in1 And 255)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		push		hl		;// Store result [Qc225]
		Ld		de,(var_wrd_u16In1)			;// Optimize -1- [Qc1001]
		Ld		hl,255			;// [Qc1002]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		pop		de		;//Restore value from stack [Qc233]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2179		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2181		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9514_Exit0				;// [Qc1012]
.QLn_2183		;//EndIf
.QIf9514_Exit0:
.QIf9514_EndIf:
.QLn_2185		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2186		;//EndF
		ret		;// [Qc262]
.QLn_2188		;//Function F131_11:void()
.QFunc_F131_11
.QLn_2192		;//Lock.On
		di		;// [Qc251]
.QLn_2193		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2194		;//IO.Out ioA_2,11
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,11		;//hl=number '11' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2195		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2197		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9553_Exit0				;// [Qc1012]
.QLn_2199		;//EndIf
.QIf9553_Exit0:
.QIf9553_EndIf:
.QLn_2201		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2202		;//EndF
		ret		;// [Qc262]
.QLn_2204		;//Function F131_12:void()
.QFunc_F131_12
.QLn_2208		;//Lock.On
		di		;// [Qc251]
.QLn_2209		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2210		;//IO.Out ioA_2,12
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,12		;//hl=number '12' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2211		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2213		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9592_Exit0				;// [Qc1012]
.QLn_2215		;//EndIf
.QIf9592_Exit0:
.QIf9592_EndIf:
.QLn_2217		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2218		;//EndF
		ret		;// [Qc262]
.QLn_2220		;//Function F131_20:void()
.QFunc_F131_20
.QLn_2226		;//Lock.On
		di		;// [Qc251]
.QLn_2227		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2228		;//IO.Out ioA_2,20
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,20		;//hl=number '20' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2230		;//c =  (u16Du / 256)
		Ld		de,(var_wrd_u16Du)			;// Optimize -1- [Qc1001]
		Ld		hl,256			;// [Qc1002]
		call	Quig_Div16		;//Divide HL by DE [Qc062]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2231		;//IO.Out ioA_2,c
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2232		;//c =  (u16Du and 255)
		Ld		de,(var_wrd_u16Du)			;// Optimize -1- [Qc1001]
		Ld		hl,255			;// [Qc1002]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2233		;//IO.Out ioA_2,c
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2237		;//IO.Out ioA_2,0
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2239		;//l = Len(strIn1)
		ld		hl,(var_str_strIn1)		;//hl=pointer to string 'var_str_strIn1' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		ld		(var_wrd_l),hl		;//Int variable 'var_wrd_l'=expression result [Qc219]
.QLn_2240		;//For t = 1 To l
		ld		hl,(var_wrd_l) 	;//hl=value of 'var_wrd_l' [Qc053]
		ld 		(QFr9653_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr9653_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr9653_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr9653_Start	;// [Qc307]
		jp		nz,QFr9653_Exit	;// [Qc308]
.QFr9653_Start:
.QLn_2241		;//c = Asc(Mid(strIn1,t,1))
		ld		hl,(var_str_strIn1)		;//hl=pointer to string 'var_str_strIn1' [Qc056]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_t)			;// Optimize -1- [Qc1001]
		Ld		hl,1			;// [Qc1002]
		call	Quig_Mid		;/ Call Function [Qc052]
		call	Quig_Asc		;/ Call Function [Qc052]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2242		;//IO.Out ioA_2,c
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2243		;//Next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr9653_Loop		;// [Qc340]
.QFr9653_Exit:
.QLn_2245		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2247		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9697_Exit0				;// [Qc1012]
.QLn_2249		;//EndIf
.QIf9697_Exit0:
.QIf9697_EndIf:
.QLn_2251		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2252		;//EndF
		ret		;// [Qc262]
.QLn_2254		;//Function F131_21:void()
.QFunc_F131_21
.QLn_2258		;//Lock.On
		di		;// [Qc251]
.QLn_2259		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2260		;//IO.Out ioA_2,21
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,21		;//hl=number '21' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2261		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2263		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9736_Exit0				;// [Qc1012]
.QLn_2265		;//EndIf
.QIf9736_Exit0:
.QIf9736_EndIf:
.QLn_2267		;//u8Out1 = IO.In(ioA_2)			// 'was r
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_u8Out1),hl		;//Int variable 'var_wrd_u8Out1'=expression result [Qc219]
.QLn_2269		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2270		;//EndF
		ret		;// [Qc262]
.QLn_2273		;//Function F131_22:void()
.QFunc_F131_22
.QLn_2277		;//Lock.On
		di		;// [Qc251]
.QLn_2278		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2279		;//IO.Out ioA_2,22
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,22		;//hl=number '22' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2280		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2282		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9779_Exit0				;// [Qc1012]
.QLn_2284		;//EndIf
.QIf9779_Exit0:
.QIf9779_EndIf:
.QLn_2286		;//fy = IO.In(ioA_2)				//'Number of bytes in buffer
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_fy),hl		;//Int variable 'var_wrd_fy'=expression result [Qc219]
.QLn_2287		;//fc = IO.In(ioA_2)				// @ removed
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_fc),hl		;//Int variable 'var_wrd_fc'=expression result [Qc219]
.QLn_2289		;//strTm = ""
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strTm$'=Expression
		ld		de,(var_str_strTm)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strTm'= [Qc221]
.QLn_2290		;//For fx = 1 to fy
		ld		hl,(var_wrd_fy) 	;//hl=value of 'var_wrd_fy' [Qc053]
		ld 		(QFr9799_Top+1),hl 		;/Copy Result into static'var_wrd_fx' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr9799_Loop:ld 		(var_wrd_fx),hl ;/Loop Repeat Point [Qc301]
		.QFr9799_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr9799_Start	;// [Qc307]
		jp		nz,QFr9799_Exit	;// [Qc308]
.QFr9799_Start:
.QLn_2291		;//fc = IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_fc),hl		;//Int variable 'var_wrd_fc'=expression result [Qc219]
.QLn_2292		;//if (fc=13) or (fc=10) then
		Ld		hl,(var_wrd_fc)			;// Optimize -1a- [Qc1062]
		Ld		de,13			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_fc)			;// Optimize -1a- [Qc1062]
		Ld		de,10			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf9840_Exit0			;// [Qc5062]
.QLn_2293		;//fc = 32
		ld		hl,32		;//hl=number '32' [Qc054]
		ld		(var_wrd_fc),hl		;//Int variable 'var_wrd_fc'=expression result [Qc219]
.QLn_2294		;//endif
.QIf9840_Exit0:
.QIf9840_EndIf:
.QLn_2295		;//strTm = strTm + Chr(fc)
		ld		hl,(var_str_strTm)		;//hl=pointer to string 'var_str_strTm' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_fc) 	;//hl=value of 'var_wrd_fc' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strTm$'=Expression
		ld		de,(var_str_strTm)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strTm'= [Qc221]
.QLn_2296		;//Next
		ld		hl,(var_wrd_fx) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr9799_Loop		;// [Qc340]
.QFr9799_Exit:
.QLn_2298		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2299		;//EndF
		ret		;// [Qc262]
.QLn_2303		;//Function F131_32:void()
.QFunc_F131_32
.QLn_2308		;//Lock.On
		di		;// [Qc251]
.QLn_2309		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2310		;//IO.Out ioA_2,32
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,32		;//hl=number '32' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2312		;//l = Len(strIn1)
		ld		hl,(var_str_strIn1)		;//hl=pointer to string 'var_str_strIn1' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		ld		(var_wrd_l),hl		;//Int variable 'var_wrd_l'=expression result [Qc219]
.QLn_2313		;//For t = 1 To l
		ld		hl,(var_wrd_l) 	;//hl=value of 'var_wrd_l' [Qc053]
		ld 		(QFr9887_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr9887_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr9887_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr9887_Start	;// [Qc307]
		jp		nz,QFr9887_Exit	;// [Qc308]
.QFr9887_Start:
.QLn_2314		;//c = Asc(Mid(strIn1,t,1))
		ld		hl,(var_str_strIn1)		;//hl=pointer to string 'var_str_strIn1' [Qc056]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_t)			;// Optimize -1- [Qc1001]
		Ld		hl,1			;// [Qc1002]
		call	Quig_Mid		;/ Call Function [Qc052]
		call	Quig_Asc		;/ Call Function [Qc052]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2315		;//IO.Out ioA_2,c
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2316		;//sDb = str(c):sysDebug
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_Str_Str		;/ Call Function [Qc052]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2317		;//Next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr9887_Loop		;// [Qc340]
.QFr9887_Exit:
.QLn_2318		;//IO.Out ioA_2,0
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2320		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2322		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf9943_Exit0				;// [Qc1012]
.QLn_2324		;//EndIf
.QIf9943_Exit0:
.QIf9943_EndIf:
.QLn_2328		;//sDb = "->":sysDebug
		ld		hl,directstr_75+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2329		;//sDb = strIn1:sysDebug
		ld		hl,(var_str_strIn1)		;//hl=pointer to string 'var_str_strIn1' [Qc056]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2330		;//sDb = strAppname:sysDebug
		ld		hl,(var_str_strAppname)		;//hl=pointer to string 'var_str_strAppname' [Qc056]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2331		;//sDb = "<-":sysDebug
		ld		hl,directstr_76+2		;//hl points static string [Qc055]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2333		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2334		;//EndF
		ret		;// [Qc262]
.QLn_2336		;//Function F131_33:void()
.QFunc_F131_33
.QLn_2340		;//Lock.On
		di		;// [Qc251]
.QLn_2341		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2342		;//IO.Out ioA_2,33
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,33		;//hl=number '33' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2344		;//c =  (u16in1 / 256)
		Ld		de,(var_wrd_u16In1)			;// Optimize -1- [Qc1001]
		Ld		hl,256			;// [Qc1002]
		call	Quig_Div16		;//Divide HL by DE [Qc062]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2345		;//IO.Out ioA_2,c
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2346		;//c =  (u16in1 and 255)
		Ld		de,(var_wrd_u16In1)			;// Optimize -1- [Qc1001]
		Ld		hl,255			;// [Qc1002]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2347		;//IO.Out ioA_2,c
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2349		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2351		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf10033_Exit0				;// [Qc1012]
.QLn_2353		;//EndIf
.QIf10033_Exit0:
.QIf10033_EndIf:
.QLn_2355		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2356		;//EndF
		ret		;// [Qc262]
.QLn_2358		;//Function F131_34:void()
.QFunc_F131_34
.QLn_2362		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2363		;//IO.Out ioA_2,34
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,34		;//hl=number '34' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2364		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2366		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf10070_Exit0				;// [Qc1012]
.QLn_2368		;//EndIf
.QIf10070_Exit0:
.QIf10070_EndIf:
.QLn_2370		;//fx = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_fx),hl		;//Int variable 'var_wrd_fx'=expression result [Qc219]
.QLn_2371		;//strOut1 = ""
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_strOut1$'=Expression
		ld		de,(var_str_strOut1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut1'= [Qc221]
.QLn_2372		;//while((fx > 0) and (len(strOut1) < 14))
.QWh10085_Start:
		Ld		de,(var_wrd_fx)			;// Optimize -1- [Qc1001]
		Ld		hl,0			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		push		hl		;//Store result [Qc004]
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,14		;//hl=number '14' [Qc054]
		call	Quig_LT_HL		;/Checks HL<DE - True HL=1 False HL=0 [Qc117]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h			//;/Branch if HL=0 [Qc492]
		or		l			//; [Qc491]
		jp		z,QWh10085_Exit:	//;// [Qc490]
.QLn_2373		;//fx = IO.In(ioA_2)
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_fx),hl		;//Int variable 'var_wrd_fx'=expression result [Qc219]
.QLn_2374		;//if fx > 30 then
		Ld		de,(var_wrd_fx)			;// Optimize -1- [Qc1001]
		Ld		hl,30			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf10115_Exit0				;// [Qc1220]
.QLn_2375		;//strOut1 = strOut1 + chr(fx)
		ld		hl,(var_str_strOut1)		;//hl=pointer to string 'var_str_strOut1' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_fx) 	;//hl=value of 'var_wrd_fx' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_strOut1$'=Expression
		ld		de,(var_str_strOut1)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_strOut1'= [Qc221]
.QLn_2376		;//endif
.QIf10115_Exit0:
.QIf10115_EndIf:
.QLn_2377		;//wend
		jp 		QWh10085_Start
.QWh10085_Exit:
.QLn_2378		;//Endf
		ret		;// [Qc262]
.QLn_2381		;//Function F131_39:void()
.QFunc_F131_39
.QLn_2386		;//Lock.On
		di		;// [Qc251]
.QLn_2387		;//IO.Out ioA_1,0
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,0		;//hl=number '0' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2388		;//IO.Out ioA_2,39
		ld		hl,(var_wrd_ioA_2) 	;//hl=value of 'var_wrd_ioA_2' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,39		;//hl=number '39' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2389		;//IO.Out ioA_1,131
		ld		hl,(var_wrd_ioA_1) 	;//hl=value of 'var_wrd_ioA_1' [Qc053]
		ex		de,hl 		;// [Qc232]
		ld		hl,131		;//hl=number '131' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2391		;//If ArmResponse =2 Then
		call	QFunc_ArmResponse		;/ Call Function [Qc052]
		ex		de,hl 		;// [Qc269]
		ld		hl,2		;//hl=number '2' [Qc054]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf10165_Exit0				;// [Qc1012]
.QLn_2393		;//EndIf
.QIf10165_Exit0:
.QIf10165_EndIf:
.QLn_2395		;//Lock.Off
		ei		;//	[Qc252]
.QLn_2396		;//EndF
		ret		;// [Qc262]
.QLn_2402		;//Function ATCmd:Void()
.QFunc_ATCMD
.QLn_2404		;//sDb = sAtCmd:sysDebug
		ld		hl,(var_str_sAtCmd)		;//hl=pointer to string 'var_str_sAtCmd' [Qc056]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2406		;//l = Len(sAtCmd)
		ld		hl,(var_str_sAtCmd)		;//hl=pointer to string 'var_str_sAtCmd' [Qc056]
		call	Quig_Len		;/ Call Function [Qc052]
		ld		(var_wrd_l),hl		;//Int variable 'var_wrd_l'=expression result [Qc219]
.QLn_2408		;//For t = 1 to l
		ld		hl,(var_wrd_l) 	;//hl=value of 'var_wrd_l' [Qc053]
		ld 		(QFr10188_Top+1),hl 		;/Copy Result into static'var_wrd_t' [Qc303]
		ld		hl,1		;//hl=number '1' [Qc054]
		.QFr10188_Loop:ld 		(var_wrd_t),hl ;/Loop Repeat Point [Qc301]
		.QFr10188_Top:ld		de,0 		;//Compare value into DE  [Qc300]
		xor		a			;// [Qc305]
		sbc		hl,de		;//[Qc306]
		jr		c,QFr10188_Start	;// [Qc307]
		jp		nz,QFr10188_Exit	;// [Qc308]
.QFr10188_Start:
.QLn_2409		;//c = Asc(Mid(sAtCmd,t,1))
		ld		hl,(var_str_sAtCmd)		;//hl=pointer to string 'var_str_sAtCmd' [Qc056]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_t)			;// Optimize -1- [Qc1001]
		Ld		hl,1			;// [Qc1002]
		call	Quig_Mid		;/ Call Function [Qc052]
		call	Quig_Asc		;/ Call Function [Qc052]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2410		;//if (c <> 32) then
		Ld		de,(var_wrd_c)			;// Optimize -1- [Qc1001]
		Ld		hl,32			;// [Qc1002]
		Xor 	a						;// Optimize -3b- [Qc1213]
		sbc		hl,de					;// [Qc1214]
		jp		z,QIf10217_Exit0				;// [Qc1215]
.QLn_2411		;//IO.Out #FF20,c
		Ld 		de,-224			;// 1040 [Qc1040]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2412		;//endif
.QIf10217_Exit0:
.QIf10217_EndIf:
.QLn_2413		;//Next
		ld		hl,(var_wrd_t) ;// [Qc330]
		inc		hl		;// [Qc331]
		jp		QFr10188_Loop		;// [Qc340]
.QFr10188_Exit:
.QLn_2414		;//IO.Out  #FF20,13
		Ld 		de,-224			;// 1040 [Qc1040]
		ld		hl,13		;//hl=number '13' [Qc054]
		call	Quig_IO_Out				;//Call 'IO.Out' [Qc234]
.QLn_2416		;//AtResponsStr
		call	QFunc_AtResponsStr				;//Call 'AtResponsStr' [Qc234]
.QLn_2417		;//EndF
		ret		;// [Qc262]
.QLn_2419		;//Function AtResponsStr:Void()
.QFunc_ATRESPONSSTR
.QLn_2422		;//sAtResp = ""
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_sAtResp$'=Expression
		ld		de,(var_str_sAtResp)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sAtResp'= [Qc221]
.QLn_2423		;//sAtData = ""
		ld		hl,directstr_28+2		;//hl points static string [Qc055]
;**** 'var_str_sAtData$'=Expression
		ld		de,(var_str_sAtData)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sAtData'= [Qc221]
.QLn_2425		;//x = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_2426		;//y = 0	// switch '='
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_2427		;//a = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_2428		;//iTimeOut = 0
		ld		hl,0		;//hl=number '0' [Qc054]
		ld		(var_wrd_iTimeOut),hl		;//Int variable 'var_wrd_iTimeOut'=expression result [Qc219]
.QLn_2430		;//while( a = 0)
.QWh10267_Start:
		Ld		hl,(var_wrd_a)			;// Optimize -1a- [Qc1062]
		Ld		de,0			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		ld		a,h			//;/Branch if HL=0 [Qc492]
		or		l			//; [Qc491]
		jp		z,QWh10267_Exit:	//;// [Qc490]
.QLn_2432		;//c = IO.In(#FF20)
		ld		hl,-224		;//hl=number '-224' [Qc054]
		call	Quig_IO_In		;/ Call Function [Qc052]
		ld		(var_wrd_c),hl		;//Int variable 'var_wrd_c'=expression result [Qc219]
.QLn_2434		;//if ((c > 31) and (x < 50)) then
		Ld		de,(var_wrd_c)			;// Optimize -1- [Qc1001]
		Ld		hl,31			;// [Qc1002]
		call	Quig_GT_HL		;/Checks HL>DE - True HL=1 False HL=0 [Qc115]
		push		hl 		;//Store result [Qc002]
		Ld		de,(var_wrd_x)			;// Optimize -1- [Qc1001]
		Ld		hl,50			;// [Qc1002]
		call	Quig_LT_HL		;/Checks HL<DE - True HL=1 False HL=0 [Qc117]
		pop		de		;//Restore value from stack [Qc050]
		ld		a,d		;//And HL & DE [Qc065]
		and		h		;// [Qc066]
		ld		h,a		;// [Qc067]
		ld		a,e		;// [Qc068]
		and		l		;// [Qc069]
		ld		l,a		;// [Qc070]
		ld		a,h 		;//Jump if HL=0 - fails condition [Qc280]
		or		l		;// [Qc281]
		jp		z,QIf10301_Exit0		;//Jump to EndIf or Else [Qc282]
.QLn_2435		;//sAtResp = sAtResp  + chr(c)
		ld		hl,(var_str_sAtResp)		;//hl=pointer to string 'var_str_sAtResp' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sAtResp$'=Expression
		ld		de,(var_str_sAtResp)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sAtResp'= [Qc221]
.QLn_2437		;//if (y=1) then
		Ld		hl,(var_wrd_y)			;// Optimize -1a- [Qc1062]
		Ld		de,1			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf10324_Exit0				;// [Qc1012]
.QLn_2438		;//sAtData = sAtData  + chr(c)
		ld		hl,(var_str_sAtData)		;//hl=pointer to string 'var_str_sAtData' [Qc056]
		push		hl 		;//Store result [Qc002]
		ld		hl,(var_wrd_c) 	;//hl=value of 'var_wrd_c' [Qc053]
		call	Quig_Chr		;/ Call Function [Qc052]
		pop		de		;//Restore value from stack [Qc050]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sAtData$'=Expression
		ld		de,(var_str_sAtData)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sAtData'= [Qc221]
.QLn_2439		;//endif
.QIf10324_Exit0:
.QIf10324_EndIf:
.QLn_2441		;//if (c = 61) then  // =
		Ld		hl,(var_wrd_c)			;// Optimize -1a- [Qc1062]
		Ld		de,61			;// [Qc1063]
		Xor 	a						;// Optimize -3- [Qc1010]
		sbc		hl,de					;// [Qc1011]
		jp		nz,QIf10350_Exit0				;// [Qc1012]
.QLn_2442		;//y=1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_y),hl		;//Int variable 'var_wrd_y'=expression result [Qc219]
.QLn_2443		;//endif
.QIf10350_Exit0:
.QIf10350_EndIf:
.QLn_2446		;//x = x + 1
		ld		hl,(var_wrd_x) 	;//hl=value of 'var_wrd_x' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_x),hl		;//Int variable 'var_wrd_x'=expression result [Qc219]
.QLn_2447		;//endif
.QIf10301_Exit0:
.QIf10301_EndIf:
.QLn_2449		;//if ((c = 13) or (c = 10)  ) then
		Ld		hl,(var_wrd_c)			;// Optimize -1a- [Qc1062]
		Ld		de,13			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		push		hl 		;//Store result [Qc002]
		Ld		hl,(var_wrd_c)			;// Optimize -1a- [Qc1062]
		Ld		de,10			;// [Qc1063]
		xor 	a			;** Integer x=y ** [Qc097]
		sbc 	hl,de		;//Compare hl/de - n means Equal [Qc098]
		ld 		h,a			;//Make h=0 [Qc099]
		jr 		nz,1		;//Skip inc a [Qc100]
		inc 	a			;//inc a [Qc101]
		ld 		l,a         ;//l=0 Or 1 [Qc102]
		pop		de		;//Restore value from stack [Qc050]
		Ld		a,l 				;// Optimize 513 [Qc5060]
		Or		e					;// [Qc5061]
		jp		z,QIf10393_Exit0			;// [Qc5062]
.QLn_2450		;//a = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_2451		;//endif
.QIf10393_Exit0:
.QIf10393_EndIf:
.QLn_2453		;//if (x > 50) then
		Ld		de,(var_wrd_x)			;// Optimize -1- [Qc1001]
		Ld		hl,50			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf10407_Exit0				;// [Qc1220]
.QLn_2454		;//a = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_2455		;//endif
.QIf10407_Exit0:
.QIf10407_EndIf:
.QLn_2457		;//if (iTimeOut > 10000) then
		Ld		de,(var_wrd_iTimeOut)			;// Optimize -1- [Qc1001]
		Ld		hl,10000			;// [Qc1002]
		call 	Quig_GT_HL_Direct		;// Optimize -3d- [Qc1219]
		jp		z,QIf10421_Exit0				;// [Qc1220]
.QLn_2458		;//a = 1
		ld		hl,1		;//hl=number '1' [Qc054]
		ld		(var_wrd_a),hl		;//Int variable 'var_wrd_a'=expression result [Qc219]
.QLn_2459		;//endif
.QIf10421_Exit0:
.QIf10421_EndIf:
.QLn_2461		;//iTimeOut = iTimeOut + 1
		ld		hl,(var_wrd_iTimeOut) 	;//hl=value of 'var_wrd_iTimeOut' [Qc053]
		inc		hl		;//Plus 1 [Qc090]
		ld		(var_wrd_iTimeOut),hl		;//Int variable 'var_wrd_iTimeOut'=expression result [Qc219]
.QLn_2462		;//wend
		jp 		QWh10267_Start
.QWh10267_Exit:
.QLn_2464		;//sDb = "AT resp:" + sAtResp:sysDebug
		ld		hl,directstr_77+2		;//hl points static string [Qc055]
		ex		de,hl 		;// [Qc269]
		ld		hl,(var_str_sAtResp)		;//hl=pointer to string 'var_str_sAtResp' [Qc056]
		call	Quig_Str_Add		;//Compare strings equals HL=DE [Qc057]
;**** 'var_str_sDb$'=Expression
		ld		de,(var_str_sDb)		;// [Qc220]
		call	Quig_LetString				;// 'var_str_sDb'= [Qc221]
		call	QFunc_sysDebug				;//Call 'sysDebug' [Qc234]
.QLn_2466		;//EndF
		ret		;// [Qc262]
.QLn_2473		;//ASM
.SyDesktop_WINOPN:
		ld		b,a
        db 		#dd:ld l,e
        db 		#dd:ld h,d
        ld 		a,(AppPrzN)      ;register window for the application process
        ld 		(ix+3),a
        ld 		a,b
        ld 		c,MSC_DSK_WINOPN
        call 	SyDesktop_SendMessage
.SyWOpn1 
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_WOPNER
        scf
        ret 	z               ;return with set carry flag, if window couldn't be opened
        cp 		MSR_DSK_WOPNOK
        jr 		nz,SyWOpn1       ;different message than "open ok" -> continue waiting
        ld 		a,(iy+4)         ;get window ID and return with cleared carry flag
        ret
.Quig_GTE_HL
		ld		a,h
        xor		d
        jp 		m,quig_cmpgte2
        ex 		de,hl
        sbc 	hl,de
        jr 		nc,quig_cmpgte3
.quig_cmpgte1               ;false
        ld 		hl,0
        ret
.quig_cmpgte2 
		bit 	7,d
        jr 		nz,quig_cmpgte1
.quig_cmpgte3              ;true
        ld 		hl,1
        ret
.Quig_GT_HL
		ld 		a,h
        xor 	d
        jp 		m,quig_cmpgte2
        sbc 	hl,de
        jr 		c,quig_cmpgte3
        ld 		hl,0
        ret	
.Quig_GTE_HL_Direct
		ld		a,h
        xor		d
        jp 		m,quig_cmpgte2dx
        ex 		de,hl
        sbc 	hl,de
        jr 		nc,quig_cmpgte3dx
.quig_cmpgte1dx               ;false
        xor		a
        ret
.quig_cmpgte2dx 
		bit 	7,d
        jr 		nz,quig_cmpgte1dx
.quig_cmpgte3dx              ;true
        ld 		a,1
		or		a
        ret
.Quig_GT_HL_Direct
		ld 		a,h
        xor 	d
        jp 		m,quig_cmpgte2dx
        sbc 	hl,de
        jr 		c,quig_cmpgte3dx
        xor 	a
        ret	
.Quig_Label_Colour_Set:
		pop		iy					;Return Address
		pop		bc					;Pen
		ld		a,l					;Fill bit
		rrca
		and		%10000000			;mask
		ld		l,a					;l=shifted fill bit
		ld		d,c					;Pen Colour
		ld		a,e					;Paper Colour
		pop		bc					;Address of Control
		inc		bc
		ld		a,(bc)				
		and		%10000000
		jr		nz,Quig_Label_Colour_Set16
.Quig_Label_Colour_Set4:		
		ld		a,d					;a = pen colour
		rla							;rotate >>2
		rla
		and		%1100				;mask	
		ld		d,a					;store in e
		ld		a,e					;Get Paper
		and		%11					;
		or		d					;Pen colour					
		or		l					;Fill bit
		dec		bc
		ld		(bc),a				;Store
		jp		(iy)
.Quig_Label_Colour_Set16:
		ld		a,d					;a = pen colour
		rla
		rla
		rla
		rla
		and		%11110000			;mask
		ld		d,a
		ld		a,e					;Get Paper
		and		%1111
		or		d					;Pen colour
		dec		bc					;Back to original spot
		ld		(bc),a				;Store
		ld		a,l
		rra
		and		%01000000
		ld		l,a
		inc		bc
		ld		a,(bc)
		and		%10111111
		or		l					;Fill bit
		ld		(bc),a
		jp		(iy)		
.Quig_Control_RefreshSequence:
		ex		de,hl
		ld		d,(hl)						;Get Control Number
		ld		a,255		
		xor		e
		ld		e,a
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)	
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINDIN
		jp		SyDesktop_SendMessage
.Quig_Control_Refresh:
		ld		e,(hl)						;Get Control Number
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)
		bit		0,a
		jr		nz,Quig_Control_Refresh22
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINDIN
		jp		SyDesktop_SendMessage
.Quig_Control_Refresh22:		
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0							;b is empty
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINTOL
		jp		SyDesktop_SendMessage		
.Quig_LetString
		ld		(Quig_ls_scr_addr),hl
		ld		(Quig_ls_des_addr),de
		xor		a
		ld 		c,a
		ld 		b,a
		cpir
		ld 		l,a
		ld 		h,a
		scf
		sbc 	hl,bc
		inc		hl
		ld		(Quig_ls_src_len),hl 	;Stores string length in src_len
		ex		de,hl
		dec		hl
		ld		b,(hl)
		dec		hl
		ld		c,(hl)
		ex		de,hl
		scf
		sbc		hl,bc
		jp		nc,Quig_LS_source_longer
.Quig_LS_copy_source2oldspot
		ld		de,(Quig_ls_des_addr)		;Get destination
		ld		hl,(Quig_ls_scr_addr)		;Get Source
		ld		bc,(Quig_ls_src_len)
		ldir
		jr		Quig_LS_Finish	
.Quig_LS_source_longer
		ld		de,(Quig_String_Pos)	;Get the next String Position we can copy too
		ld		hl,(Quig_ls_scr_addr)
.Quig_LS_source_longer_normal
		push	de	;Pushes String Pos
		ld		bc,(Quig_ls_src_len)	
		ldir
		inc		de	;Skip the 4 header places
		inc		de
		inc		de
		inc		de
		ld		(Quig_String_Pos),de	;New top of text
		ld		hl,(Quig_ls_des_addr)		;Get Source				
		dec		hl
		dec		hl
		dec		hl
		ld		d,(hl)
		xor		a
		ld		(hl),a
		dec		hl
		ld		e,(hl)
		ld		(hl),a
		ld		bc,(Quig_ls_src_len)
		pop		hl	;Gets Old string pos
		dec		hl
		ld		(hl),b
		dec		hl
		ld		(hl),c
		dec		hl
		ld		(hl),d
		dec		hl
		ld		(hl),e
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
.Quig_LS_Finish	
		call	Quig_String_Stack_Clear
		call	Quig_LS_CheckGarbage		
		ret		nz			;Space
		call	Quig_Garbage
		call	Quig_LS_CheckGarbage		
		ret		nz			;Now is Space
		ld		hl,Quig_LS_Err1
		push	hl
		ld		hl,Quig_LS_Err2
		push	hl
		ld		de,Quig_LS_Err3
		ld		hl,1
		call	Quig_Dialog
		ret
.Quig_LS_Err1:	db	"ERROR",0
.Quig_LS_Err2:	db	"Out of String space",0
.Quig_LS_Err3:	db 	0
.Quig_LS_CheckGarbage:		
		ld		hl,(AppCodBeg+2)
		ld		de,AppDatBeg
		add		hl,de
		ld		de,(Quig_String_Pos)
		scf
		sbc		hl,de
		ld		a,h
		and		%11111100
		ret		
.Quig_ls_src_len:	dw	0
.Quig_ls_scr_addr:	dw	0
.Quig_ls_des_addr:	dw	0
.directstr_1: DW 16: DB "AT+SEMODE=VOICE",0
.directstr_2: DW 7: DB "DOTBOX",0
.directstr_3: DW 13: DB "dd_start.qs1",0
.Quig_App_Path
		ld		hl,Quig_CodeEnd
		inc		hl
		ld		de,(Quig_String_Buffer_Pos)
		ld		bc,0
.Quig_App_Path_1		
		ld		a,(hl)
		cp		"."
		jr		z,Quig_App_Path_Found
		cp		"\"
		jr		z,Quig_App_Path9
		cp		"/"
		jr		nz,Quig_App_Path_x
.Quig_App_Path9:
		ld		a,"\"
		ld		c,b
.Quig_App_Path_x:
		ld		(de),a
		inc		b
		inc		hl
		inc		de
		jr		Quig_App_Path_1
.Quig_App_Path_Found:
		ld		hl,(Quig_String_Buffer_Pos)
		ld		e,l
		ld		d,h
		ld		b,0
		add		hl,bc
		inc		hl
		xor		a
		ld		(hl),a
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
		ret
.Quig_Str_Add
		push	hl
		ex		de,hl
		ld		de,(Quig_String_Buffer_Pos)
		xor		a
.Quig_Str_Add_p1		
		cp		(hl)
		ldi
		jr		nz,Quig_Str_Add_p1
		dec		de
		pop		hl
.Quig_Str_Add_p2		
		cp		(hl)
		ldi
		jr		nz,Quig_Str_Add_p2
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret
.Quig_SheetLoad:
		ld		(Quig_SheetLoad_Where),de		
		push	hl
		ex		de,hl
		call	Quig_SheetFree
		pop		hl
		ld		a,(appBnkNum)
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN		
		ld		de,(Quig_SheetLoad_Where)
		jp		c,Quig_SheetLoad_Fail_1
		ld		(Quig_SheetLoad_Handle),a
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,Quig_SheetLoad_Type
		ld		bc,6
		ld		a,(Quig_SheetLoad_Handle)
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP
		ld		a,(Quig_SheetLoad_Type)
		and #fe                                     ;*MOD*
		cp		178                         		;*MOD*
		jp		nz,Quig_SheetLoad_Fail_2		
		ld		bc,(Quig_Sheetload_Size)
		bit		7,b
		jr		z,Quig_SheetLoad_F2
		ld		a,1
		jr		Quig_SheetLoad_F3
.Quig_SheetLoad_F2
		xor		a
.Quig_SheetLoad_F3
		ld		(Quig_SheetLoad_CD),a
		res		7,b
		ld		(Quig_Sheetload_Size),bc
		Xor		a					;A = 0 - Look in any RamBank
		ld		e,1					;E = 1 - Look only in Data Areas
		rst 	#20:dw #8118
		jp		c,Quig_SheetLoad_Fail_3
		ld		(Quig_SheetLoad_Bank),a
		ld		(Quig_SheetLoad_Addr),hl
		ld		e,a
		ld		bc,(Quig_Sheetload_Size)
		ld		a,(Quig_SheetLoad_Type)      ;*MOD*
		rra                                          ;*MOD*
		ccf                                          ;*MOD*
		ld		a,(Quig_SheetLoad_Handle)
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCPR                       ;*MOD*
		jp		c,Quig_SheetLoad_Fail_1
		ld		a,(Quig_SheetLoad_Handle)
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO		
		ld		hl,(Quig_SheetLoad_Addr)
		ld		(Quig_SheetLoad_Fill+1),hl
		inc		hl
		inc		hl
		inc		hl
		ld		a,(Quig_SheetLoad_Tiles)			;Number of Tiles
		ld		b,a
.Quig_SheetLoad_Loop
		push	bc
		ld		a,(Quig_SheetLoad_Bank)
		rst		#20:dw	#8124
		ex		de,hl
.Quig_SheetLoad_Fill
		ld		hl,0
		add		hl,bc
		ld		c,l
		ld		b,h
		ex		de,hl
		ld		e,c
		ld		d,b
		dec		de
		dec		hl
		dec		hl
		rst 	#20:dw #8127						;Write word to bank
		ld		c,e
		ld		b,d
		rst 	#20:dw #8127						;Write word to bank
		ld		bc,5
		add		hl,bc
		pop		bc
		djnz	Quig_SheetLoad_Loop
		ld		hl,Quig_SheetLoad_Status
		ld		de,(Quig_SheetLoad_Where)
		ld		bc,9
		ldir
		ret
.Quig_SheetLoad_Where:	dw		0
.Quig_SheetLoad_Handle:	db		0
.Quig_SheetLoad_Type:	db		0			;Need to be 179 (uncompressed) or 178 (compressed) ;*MOD*
.Quig_SheetLoad_Status:	db		0
.Quig_SheetLoad_SheetNo:db		0
.Quig_SheetLoad_Tiles:	db		0
.Quig_Sheetload_Size:	dw		0
.Quig_SheetLoad_Bank:	db		0
.Quig_SheetLoad_Addr:	dw		0
.Quig_SheetLoad_CD:		db		0
.Quig_SheetLoad_Fail_1:
		ld		a,0
		jr		Quig_SheetLoad_Fail
.Quig_SheetLoad_Fail_2:
		ld		a,100		
		jr		Quig_SheetLoad_Fail
.Quig_SheetLoad_Fail_3:
		ld		a,101
.Quig_SheetLoad_Fail:
		ld		hl,(Quig_SheetLoad_Where)
		ld		(hl),a
		ret
.Quig_Control_Tile_Set:
		pop		iy
		pop		bc						;Address of control
.Quig_Control_Tile_Set_ZeroHL:		
		inc		bc						;
		inc		bc						;
		ld		a,(bc)				
		cp		10						;Graphic?
		jr		nz,Quig_Tile_Set_Fail_2
		inc		bc
		push	bc
		jr		Quig_Tile_Set_2
.Quig_Tile_Set_Fail_2:
		jp		(iy)
.Quig_Tile_Set_HL0:
		pop		iy
		push	de
		ex		de,hl
		ld		hl,0
		jr		Quig_Tile_Set_2
.Quig_Tile_ObjSet:
		pop		iy
		ld		c,l
		ld		b,h
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,bc						;*9
		inc		de
		inc		de
		inc		de
		inc		de
		inc		de
		ld		a,(de)						;bank				
		ld		(Quig_Tile_Set_Bank),a
		inc		de
		ld		a,(de)
		ld		c,a
		inc		de
		ld		a,(de)
		ld		b,a
		add		hl,bc
		ld		(Quig_Tile_Set_Addr),hl
		pop		hl							;Sheet Obj Number
		ld		a,l
		ld		(Quig_TOSet_Tile),a
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,hl						;*16
		add		hl,hl						;*32
		ex		de,hl
		pop		hl							;Extra Data = store
		ld		(Quig_TOSet_ED),hl
		inc		hl							;Move to the Obj1 Address
		inc		hl
		inc		hl
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		add		hl,bc
		inc		hl
		inc		hl
		inc		hl
		ex		de,hl
		ld		hl,Quig_Tile_Set_Bank
		ldi
		ldi
		ldi
		ld		a,(Quig_Tile_Set_Bank)	
		ld		hl,(Quig_Tile_Set_Addr)
		inc		hl
		rst 	#20:dw #8124
		push	bc
		ld		a,(Quig_TOSet_Tile)
		add		a							;*2
		ld		e,a							;c=a*2
		add		a							;*4
		add		a							;*8
		add		e
		ld		e,a
		ld		d,0
		ld		hl,(Quig_TOSet_ED)
		ld		bc,14
		add		hl,bc
		add		hl,de
		pop		bc
		ld		(hl),c
		inc		hl
		ld		(hl),b
		jp		(iy)
.Quig_TOSet_Tile:	db	0		
.Quig_TOSet_ED:		dw	0		
.Quig_TileObjStore1: dw 0		
.Quig_Tile_Set:
		pop		iy
.Quig_Tile_Set_2:		
		ld		a,(de)
		cp		1
		jp		nz,Quig_Tile_Set_Fail
		inc		de
		inc		de
		ld		a,(de)
		cp		l		
		jr		c,Quig_Tile_Set_Fail		;Asking for a tile higher than Tiles in set
		jr		z,Quig_Tile_Set_Fail		;Asking for a tile higher than Tiles in set
		ld		c,l
		ld		b,h
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,bc						;*9
		inc		de
		inc		de
		inc		de
		ld		a,(de)						;bank				
		ld		(Quig_Tile_Set_Bank),a
		inc		de
		ld		a,(de)
		ld		c,a
		inc		de
		ld		a,(de)
		ld		b,a
		add		hl,bc
		ld		(Quig_Tile_Set_Addr),hl
		pop		de
		ld		hl,Quig_Tile_Set_Bank
		ldi
		ldi
		ldi
		jp		(iy)
.Quig_Tile_Set_Bank:	db		0
.Quig_Tile_Set_Addr:	dw		0
.Quig_Tile_Set_Fail:
		pop		hl
		ld		a,255
		ld		(hl),a
		inc		hl
		ld		de,Sheet_Data4
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		(iy)
.directstr_4: DW 12: DB "Loading..0%",0
.directstr_5: DW 2: DB " ",0
.directstr_6: DW 3: DB " [",0
.directstr_7: DW 2: DB "]",0
.Quig_RefreshControlAll:
		call	Quig_RefreshFormPart
		ld		e,255
		ld		c,MSC_DSK_WINDIN
		jp 		SyDesktop_SendMessage
.Quig_RefreshToolAll:
		call	Quig_RefreshFormPart
		ld		e,255
		ld		c,MSC_DSK_WINTOL
		jp 		SyDesktop_SendMessage		
.Quig_RefreshStatus:
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINSTA
        jp 		SyDesktop_SendMessage	
.Quig_RefreshTitle
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINTIT
        jp 		SyDesktop_SendMessage		
.Quig_RefreshMenu:
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage	
.Quig_RefreshFormPart
		ex		de,hl
		ld		hl,Quig_FormIDs
		add		hl,de
		ld		a,(hl)
		ret	
.directstr_8: DW 11: DB "dd_dot.qs2",0
.directstr_9: DW 13: DB "Loading..10%",0
.directstr_10: DW 12: DB "dd_hori.qs2",0
.directstr_11: DW 13: DB "Loading..30%",0
.directstr_12: DW 12: DB "dd_vert.qs2",0
.directstr_13: DW 13: DB "Loading..50%",0
.directstr_14: DW 12: DB "dd_fill.qs2",0
.directstr_15: DW 13: DB "Loading..60%",0
.directstr_16: DW 12: DB "dd_digi.qs2",0
.directstr_17: DW 13: DB "Loading..80%",0
.directstr_18: DW 12: DB "dd_voip.qs2",0
.directstr_19: DW 14: DB "Loading..100%",0
.directstr_20: DW 6: DB "START",0
.Quig_Time_Hour_Get
		rst 	#20
		dw		#810c
		ld		l,c
		ld		h,0
		ret	
.Quig_Mul16
		ld		c,l
		ld		a,h
		ld 		b,16
.Quig_INT_Mult16_Loop_DEHL:
		add		hl,hl
		sla 	c
		rla
		jr 		nc,Quig_INT_Mult16_NoAdd_DEHL
		add 	hl,de
.Quig_INT_Mult16_NoAdd_DEHL:
		djnz	Quig_INT_Mult16_Loop_DEHL
		ret	
.Quig_Time_Minute_Get
		rst 	#20
		dw		#810c
		ld		l,b
		ld		h,0
		ret
.Quig_Time_Second_Get
		rst 	#20
		dw		#810c
		ld		l,a
		ld		h,0
		ret
.Quig_IRandomize:
		ld		(Quig_RNDSeed),hl
		ret
.Quig_IRnd:
		push	hl
		ld		de,(Quig_RNDSeed)	; Seed is usually 0
		ld		a,d
		ld		h,e
		ld		l,253
		or		a
		sbc		hl,de
		sbc		a,0
		sbc		hl,de
		ld		d,0
		sbc		a,d
		ld		e,a
		sbc		hl,de
		jr		nc,Quig_IRnd2	
		inc		hl
.Quig_IRnd2	
		ld		(Quig_RNDSeed),hl
		ex		de,hl
		pop		hl
		call	Quig_Div16
		ex		de,hl
		ret
.Quig_RNDSeed:dw	100
.Quig_Sound_Int:	
        ld 		e,0
        ld 		hl,Quig_ssndmnt
        ld 		a,(AppBnkNum)
		ld 		c,MSC_SYS_PRGSRV
		call 	SySystem_SendMessage
.qgSySPSr1 
		call 	SySystem_WaitMessage
        cp 		MSR_SYS_PRGSRV
        jr 		nz,qgSySPSr1
        ld 		a,(AppMsgB+1)
        ld 		hl,(AppMsgB+8)
		or 		a
        scf
        ret 	nz
        ld 		a,h
        ld 		(Quig_Sound_PrcID),a
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_SNDINF
        call 	Quig_ssnmsg1
        call 	Quig_ssnmsgo_afbchl
        or 		a
		ld		(Quig_Sound_Hardware),a
		bit		1,a
		jr		nz,Quig_Sound_Intxx4
		ld		h,0
.Quig_Sound_Intxx4:
		ld		a,h
		ld		(Quig_Sound_OPL4_Blocks),a
		ld		a,l
		ld		(Quig_Sound_Pref_Hardware),a
		ld		a,c
		ld		(Quig_Sound_Volume_Fx),a
		ld		a,b
		ld		(Quig_Sound_Volume_Music),a		
		ld		hl,1
        ret			
.Quig_Sound_IntXX:
        ld 		e,0
        ld 		hl,Quig_ssndmnt
        ld 		a,(AppBnkNum)
		ld		c,MSC_SYS_PRGSRV
        call 	SySystem_SendMessage
.Quig_Sound_Int2:
		call 	SySystem_WaitMessage
        cp 		MSR_SYS_PRGSRV
        jr 		nz,Quig_Sound_Int2
		ld 		a,(AppMsgB+1)
        ld 		hl,(AppMsgB+8)
        or 		a
        scf
        ret	 	z						;,Quig_Sound_Int3		;We are OK
		ld		hl,0					;Sound Daemon not running
		ret								;
.Quig_Sound_RemoteInt:
		call	Quig_Sound_IntXX
		ret		nz
		call 	Quig_ssnmsgi
        db 		FNC_SND_RMTACT	
		di:halt
        call 	Quig_ssnmsg1
        call 	Quig_ssnmsgo_afbchl
        ld 		(Quig_rmtply+1),a
        ld 		(Quig_rmtply1+2),hl
        ld 		(Quig_rmtply2+2),bc		
		ret
.Quig_Sound_RemotePlay:
.Quig_rmtply:
		ld 		b,0
.Quig_rmtply1:
		ld 		ix,0
.Quig_rmtply2:
		ld 		iy,0
        call 	#ff03
        ret
.Quig_Sound_FX_Play:
		pop		bc				;Gets Return Address
		ld		h,l				;H = L or Volume
		ld		l,e				;L = E Effect
		pop		de				;Get HL
		ld		a,e				;a = l the Handle
		push	bc				;Pushes return address
		ld		de,0
		ld		b,3				;3 = play always on rotating channel
		call 	Quig_ssnmsgi_afbchl
        db 		FNC_SND_EFXPLY
        ret
.Quig_Sound_FX_PlayOPL4:
		pop		iy				;Return Address
		ex		de,hl			;DE = Pitch,HL=Volume
		ld		h,l				;H=Volume
		pop		bc
		ld		l,c				;L=Effect
		pop		bc
		ld		a,c				;A=Handle
		push	iy	
		ld		b,1
		ld		c,128
        call 	Quig_ssnmsgi_afbcdehl
        db 		FNC_SND_EFXPLY
        ret				
.Quig_Sound_FX_Stop:
		ld		a,e
		call	Quig_ssnmsgi_afhl
        db 		FNC_SND_EFXSTP
        ret
.Quig_Sound_FX_Release:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_EFXFRE
        ret
.Quig_Sound_Music_Load_OPL4:
		ld		a,2								;OPL4
		jr		Quig_Sound_Music_Load2
.Quig_Sound_Music_Load:
		ld		a,1								;PSG
.Quig_Sound_Music_Load2:		
		ld		(Quig_Sound_Music_Load_Type+1),a
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File
		jp		c,Quig_Sound_LoadFail
		ld		(Quig_SML_Handle),a		
		ld		e,0
.Quig_Sound_Music_Load_Type:		
		ld		d,1								;Set PSG/OPL4
        call 	Quig_ssnmsgi_afbcdehl	
        db 		FNC_SND_MUSLOD
.Quig_Sound_Music_Load_9:		
        call 	Quig_ssnmsg1
        call	Quig_ssnmsgo_af
		jr		c,Quig_Sound_LoadFail2		
		ld		l,a
		ld		h,0
		push	hl
		call	Quig_SML_Close
		pop		hl
		ret
.Quig_Sound_SFX_Load_OPL4:
		ld		a,2								;OPL4
		jr		Quig_Sound_SFX_Load2
.Quig_Sound_SFX_Load:
		ld		a,1								;PSG
.Quig_Sound_SFX_Load2:
		ld		(Quig_Sound_SFX_Load_Type+1),a
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File
		jp		c,Quig_Sound_LoadFail
		ld		(Quig_SML_Handle),a		
		ld		e,0
.Quig_Sound_SFX_Load_Type:		
		ld		d,1								;Set PSG/OPL4
        call 	Quig_ssnmsgi_afbcdehl	
        db 		FNC_SND_EFXLOD
		jr		Quig_Sound_Music_Load_9		
.Quig_SML_Close:
		ld		a,(Quig_SML_Handle)
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO		
		ret	
.Quig_SML_Handle:	db	0
.Quig_Sound_LoadFail2:
		call	Quig_SML_Close
.Quig_Sound_LoadFail:
		ld		hl,255
		ret
.Quig_Sound_Music_Volume:
		ld		a,e
		ld		h,l
        call 	Quig_ssnmsgi_afhl
        db 		FNC_SND_MUSVOL
        ret
.Quig_Sound_Music_Play:
		ld		a,l				;A= Handle
		ld		l,0				;L=0
        call 	Quig_ssnmsgi_afhl
        db 		FNC_SND_MUSRST
		ret
.Quig_Sound_Music_Stop:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_MUSSTP
		ret
.Quig_Sound_Music_Continue:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_MUSCON
		ret
.Quig_Sound_Music_Release:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_MUSFRE
        ret
.Quig_Sound_PrcID:		db	0
.Quig_Sound_Hardware: 	db	0
.Quig_Sound_Pref_Hardware:	db	0
.Quig_Sound_Volume_Fx:	db	0
.Quig_Sound_Volume_Music:	db	0
.Quig_Sound_OPL4_Blocks:	db	0
.Quig_ssndmnt: db 	"Sound Daemon"
.Quig_ssnmsgi_afbcdehl:
        ld 		(AppMsgB+06),de   ;store registers to message buffer
.Quig_ssnmsgi_afbchl:
        ld 		(AppMsgB+04),bc
.Quig_ssnmsgi_afhl:
        ld 		(AppMsgB+08),hl
.Quig_ssnmsgi_af:
        push 	af:pop hl
        ld 		(AppMsgB+02),hl
.Quig_ssnmsgi:		
        pop 	hl
        ld 		a,(hl)               ;set command
        inc 	hl
        push 	hl
        ld 		(AppMsgB+0),a
        ld 		(Quig_ssnmsg2+1),a
        ld 		iy,AppMsgB
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        ld 		a,(Quig_Sound_PrcID)
        db 		#dd:ld h,a
        ld 		(Quig_ssnmsg1+2),ix
        rst 	#10                 ;send message
        ret	
.Quig_ssnmsg1: 
		ld 		ix,0                 ;wait for response
        rst 	#08
        db 		#dd:dec l
        jr 		nz,Quig_ssnmsg1
        ld 		a,(AppMsgB)
        sub 	128
.Quig_ssnmsg2:
		cp 		0
        ret 	z
        ld 		a,(AppPrzN)        ;wrong response code -> put this back to the last entry in the message queue and wait for a correct one
        db 		#dd:ld h,a
        ld 		a,(Quig_Sound_PrcID)
        db 		#dd:ld l,a
        rst 	#10
        rst 	#30
        jr 		Quig_ssnmsg1
.Quig_ssnmsgo_afbcdehl:
        ld 		de,(AppMsgB+06)   ;get registers from the message buffer
.Quig_ssnmsgo_afbchl:
        ld 		bc,(AppMsgB+04)
.Quig_ssnmsgo_afhl:
        ld 		hl,(AppMsgB+02)
        push 	hl
        pop 	af
        ld 		hl,(AppMsgB+08)
        ret
.Quig_ssnmsgo_af:
        ld 		hl,(AppMsgB+02)
        push 	hl
        pop 	af
        ret		
.directstr_21: DW 13: DB ":\soundd.exe",0
.Quig_Left:
		ld		c,l
		ld		b,h
		ex		de,hl
		ld		de,(Quig_String_Buffer_Pos)	
.Quig_Left_x:
		ld		a,(hl)
		ld		(de),a
		inc		de
		inc		hl
		and		a
		jr		z,Quig_Left_2
		xor		a
		cp		c
		jr		nz,Quig_Left_3
		cp		b
		jr		z,Quig_Left_4
.Quig_Left_3:		
		dec		bc
		jr		Quig_Left_x
.Quig_Left_4:
		dec		de
		ld		(de),a
		inc		de
.Quig_Left_2:
		ld		hl,(Quig_String_Buffer_Pos)	
		ld		(Quig_String_Buffer_Pos),de		
		ret
.Quig_Execute:
		ld		a,(AppBnkNum)
		set		7,a
		call	SySystem_PRGRUN
		ld		l,a
		ld		h,0
		ret	
.directstr_22: DW 11: DB "Sound.Init",0
.Quig_LTE_HL
		ld		a,h
		xor		d
		jp 		m,Quig_cmplte2
		sbc 	hl,de
		jr		nc,Quig_cmplte3
.Quig_cmplte1                 ;false
		ld 		hl,0
		ret
.Quig_cmplte2 
		bit 	7,d
		jr 		z,Quig_cmplte1
.Quig_cmplte3                ;true
        ld 		hl,1
        ret
.Quig_LT_HL
		ld 		a,h
        xor		d
		jp 		m,quig_cmplte2
		sbc 	hl,de
		jr 		z,quig_cmplte1
		jr 		nc,quig_cmplte3
		ld 		hl,0
		ret
.Quig_LTE_HL_Direct
		ld		a,h
		xor		d
		jp 		m,Quig_cmplte2dx
		sbc 	hl,de
		jr		nc,Quig_cmplte3dx
.Quig_cmplte1dx                 ;false
		xor		a
		ret
.Quig_cmplte2dx 
		bit 	7,d
		jr 		z,Quig_cmplte1dx
.Quig_cmplte3dx                ;true
        ld		a,1
		or 		a
        ret
.Quig_LT_HL_Direct
		ld 		a,h
        xor		d
		jp 		m,quig_cmplte2dx
		sbc 	hl,de
		jr 		z,quig_cmplte1dx
		jr 		nc,quig_cmplte3dx
		xor 	a
		ret		
.Quig_Shl4:
		add		hl,hl:add hl,hl:add hl,hl:add hl,hl
		ret		
.directstr_23: DW 28: DB "--- You are Winner !!!! ---",0
.directstr_24: DW 22: DB "--- You lost !!!! ---",0
.directstr_25: DW 9: DB "App exit",0
.Quig_SheetFree:
		ld		a,(hl)
		cp		1
		ret		nz
		xor		a				;Clean the Status
		ld		(hl),a
		ld		c,(hl)
		inc		hl
		inc		hl
		inc		hl
		ld		c,(hl)
		ld		(hl),a
		inc		hl
		ld		b,(hl)
		ld		(hl),a
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,d
		ld		a,e
		rst 	#20:dw 	#811B
		ret
.Quig_Io_In:
		ld 		c,l
		ld		b,h
		in		l,(c)
		ld		h,0
		ret		
.Quig_Get_Byte:
		ld		l,(hl)
		ld		h,0
		ret
.Quig_Get_Keypress:
		ld		a,(Event_Type)
		cp		16
		jr		z,Quig_Get_Keypress2
		ld		hl,0
		ret
.Quig_Get_Keypress2:		
		ld		a,(Event_Key_ASCII)
		ld		l,a
		ld		h,0
		ret
.Quig_Len:
		xor		a
		ld 		c,a
		ld 		b,a
		cpir
		ld 		l,a
		ld 		h,a
		scf
		sbc 	hl,bc
		ret
.directstr_26: DW 19: DB "Input string empty",0
.directstr_27: DW 28: DB "Input string too  long > 50",0
.Quig_Chr
		ld		de,(Quig_String_Buffer_Pos)
		ld		a,l
		ld		(de),a
		inc		de
		xor		a
		ld		(de),a
		inc		de
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret
.directstr_28: DW 1: DB "",0
.Quig_Str_From_INT_HL
		push	de
		call	Quig_Str_Str
		pop		de
		ret
.Quig_Str_From_INT_DE
		push	hl
		ex		de,hl
		call	Quig_Str_Str
		ex		de,hl
		pop		hl
		ret		
.Quig_clcnumt dw -1,-10,-100,-1000,-10000
.Quig_Str_Str
        ld      iy,(Quig_String_Buffer_Pos)
        push    iy
        bit     7,h
        jr      z,Quig_clcnum0
        ld      (iy+0),"-"
        inc     iy
        ld      a,l
        cpl
        ld      l,a
        ld      a,h
        cpl
        ld      h,a
        inc     hl
.Quig_clcnum0 
        ld      ix,Quig_clcnumt+8
        ld      b,5
        xor     a
.Quig_clcnum1
        ld      e,(ix+0)
        ld      d,(ix+1)
        dec     ix
        dec     ix
        ld      c,"0"
.Quig_clcnum2 
        add     hl,de
        jr      nc,Quig_clcnum5
        inc     c
        inc     a
        jr      Quig_clcnum2
.Quig_clcnum5 
        sbc     hl,de
        or      a
        jr      z,quig_clcnum3
        ld      (iy+0),c
        inc     iy
.Quig_clcnum3 
        djnz    Quig_clcnum1
        or      a
        jr      nz,Quig_clcnum6
        ld      (iy+0),"0"
        inc     iy
.Quig_clcnum6   ld      (iy+0),0
		inc		iy
        ld      (Quig_String_Buffer_Pos),iy
        pop     hl
        ret	
.directstr_29: DW 10: DB "Fifo Full",0
.directstr_30: DW 10: DB "Version: ",0
.directstr_31: DW 12: DB "RePlay game",0
.directstr_32: DW 18: DB "iPlayerActive = 0",0
.directstr_33: DW 9: DB "Wait....",0
.directstr_34: DW 10: DB "Your turn",0
.directstr_35: DW 13: DB "Other player",0
.directstr_36: DW 10: DB "iSelect :",0
.directstr_37: DW 19: DB "ImgTile(iSelImg)= ",0
.directstr_38: DW 16: DB "  defTileHori= ",0
.Quig_Data_Byte:
		ld 		hl,(Quig_DataAddr)
		ld		a,(hl)
		inc		hl
		ld		(Quig_DataAddr),hl
		ld		l,a
		ld		h,0
		ret
.Quig_Shr4:
		LD A,L:SRL H:RRA:SRL H:RRA:SRL H:RRA:SRL H:RRA:LD L,A
		ret	
.Quig_Mod16:
		call	Quig_Div16
		ex		de,hl
		ret
.Quig_Div16:
		ex		de,hl           	; HL = DE \ HL
		ld		a,e             	; Division by zero?
		Or		d
		jr		nz,Quig_N_Div17      ; Continue of not
		ld		hl,0
		ld		de,0
		scf			            	; Set Carry to indicate an error
		ret
.Quig_N_Div17:
		ld		c,l             	; AC = HL
		ld		a,h
		ld		hl,0            	; HL = Modulus
		ld		b,16            	; 16-bit division
		Or		a               	; Start with carry reset
.Quig_N_Div18:
		rl		c               	; AC = AC * 2
		rla  	                	; (set Carry to bit 0)
		rl		l               	; HL = HL * 2
		rl		h               	; (reset Carry again (HL = 0))
		push	hl
		sbc		hl,de
		ccf                     	; Carry set when Ok
		jr		c,Quig_N_Div19       ; Modulus cannot be >= Value
		ex		(sp),hl         	; Restore Modulus
.Quig_N_Div19:
		inc		SP              	; Get Modulus from Stack
		inc		SP
		djnz 	Quig_N_Div18         ; Repeat for all bits
		ex		de,hl           	; DE = Modulus
		rl		c               	; Carry to C
		ld		l,c             	; HL = AC
		rla
		ld		h,a
		Or		a               	; Reset Carry (valid result)
		ret		
.directstr_39: DW 15: DB "Active player ",0
.directstr_40: DW 13: DB "newField img",0
.Quig_Control_GetID
		ex		de,hl			;Swap
		add		hl,hl			; Number *4
		add		hl,hl
		ld		bc,ControWindowDataList
		add		hl,bc			;HL = Position of ControlData
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a				;HL=Address of Control stuff
		ex		de,hl
		add		hl,hl			;*2
		add		hl,hl			;*4
		add		hl,hl			;*8
		add		hl,hl			;*16
		add		hl,de
		ret
.directstr_41: DW 25: DB "?? empty is niet nul !!!",0
.Quig_Mid
		pop		iy					;Get the Return position
		ld		c,e					;BC = Start
		ld		b,d
		ld		e,l					;DE = Len
		ld		d,h
		pop		hl					;HL = String
		xor		a					;A=0
		cpir 						;Repeat until BC=0 or 0 terminator found
		jr		z,Quig_mid_empty
		dec		hl		
		ld		c,e
		ld		b,d
		ld		de,(Quig_String_Buffer_Pos)	
.Quig_Mid_1x		
		ld 		a,(hl)
		ldi
		jp 		po,Quig_mid_3x
		or 		a
		jr 		nz,Quig_Mid_1x
.Quig_Mid_2x
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		jp		(iy)
.Quig_Mid_3x
		xor		a
		ld		(de),a
		inc		de
		jr		Quig_Mid_2x
.Quig_mid_empty
		xor		a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(hl),a
		inc		hl
		ex		de,hl
		jr		Quig_Mid_2x
.Quig_Asc:
		ld		l,(hl)
		ld		h,0
		ret
.Quig_Io_Out:
		ld 		c,e
		ld		b,d
		out		(c),l
		ret
.directstr_42: DW 4: DB "<> ",0
.directstr_43: DW 23: DB "!! Communication Error",0
.directstr_44: DW 6: DB "> 800",0
.directstr_45: DW 14: DB "green  button",0
.directstr_46: DW 11: DB "red button",0
.directstr_47: DW 13: DB "voip status:",0
.directstr_48: DW 17: DB "voip defVoipIdle",0
.directstr_49: DW 5: DB "IDLE",0
.directstr_50: DW 9: DB "OUTGOING",0
.directstr_51: DW 8: DB "IS BUSY",0
.directstr_52: DW 10: DB "OFFLINE !",0
.directstr_53: DW 10: DB "INCOMMING",0
.directstr_54: DW 11: DB "CALLING...",0
.directstr_55: DW 22: DB "Voip connected with :",0
.directstr_56: DW 19: DB "->> Display image ",0
.directstr_57: DW 11: DB "step  is: ",0
.directstr_58: DW 25: DB "Firmware  out of  date !",0
.directstr_59: DW 9: DB "Needed: ",0
.Quig_Dialog:
		pop		iy
		ld		d,%01000000
		ld		a,l
		and		a
		jr		z,Quig_Dialog_Skipit
		ld		d,%11000000
.Quig_Dialog_skipit
		pop		hl
		ld		a,l
		rla		
		rla		
		rla
		and		%111000
		ld		l,a
		ld		a,e		;button
		or		d
		or		l
		ld		(Quig_Dialog_x+1),a		
		pop		hl
		ld		de,(Quig_Dialog_3)
		call	Quig_LetString
		pop		hl
		ld		de,(Quig_Dialog_2)
		call	Quig_LetString
		pop		hl
		ld		de,(Quig_Dialog_1)
		call	Quig_LetString
		ld		hl,Icon24_Data_Data
		ld		(AppMsgB+12),hl
		push	iy
.Quig_Dialog_x		
		ld		e,0
		ld		a,(appBnkNum)
		ld		hl,Quig_Dialog_1
        ld 		c,MSC_SYS_SYSWRN
        call 	SySystem_SendMessage
.Quig_Dialog_Loop:
		call	Quig_Dialog_Wait_Message
		jr		nc,Quig_Dialog_Loop
		cp		157
		jr		nz,Quig_Dialog_Loop
		ld    	a,(AppMsgB+1)
		cp		1
		jr		z,Quig_Dialog_Loop
		ld		l,a
		ld		h,0	
		pop		iy
		jp		(iy)
.Quig_Dialog_Wait_Message:
        rst   	#30
		ld    	a,(AppPrzN)
        db    	#dd:ld l,a
        db    	#dd:ld h,-1
        ld    	iy,AppMsgB
        rst   	#18
        Or    	a
        db    	#dd:dec l
        ret    	nz
        ld    	a,(AppMsgB+0)
        Or    	a
        scf
        ret
.directstr_60: DW 15: DB "Wifi OFFLINE !",0
.directstr_61: DW 16: DB "Not connected: ",0
.Quig_Close_Form:
		ld		a,l
		ld		h,0
		call	Quig_Form_Close
		ret		
.directstr_62: DW 4: DB "...",0
.directstr_63: DW 4: DB "   ",0
.directstr_64: DW 16: DB "Other user is: ",0
.directstr_65: DW 25: DB "Appname timeout step 140",0
.directstr_66: DW 10: DB "Appname: ",0
.directstr_67: DW 6: DB "App: ",0
.Quig_Str_Ot	
		ld 		a,(de)
        cp 		(hl)
        jr 		nz,Quig_cmpsot1
        inc 	de
        inc 	hl
        or 		a
        jr 		nz,Quig_Str_Ot
        ld 		hl,0
        ret
.Quig_cmpsot1 
		ld 		hl,1
        ret		
.Quig_Machine_Get	
		ld		a,(Quig_Machine_Type)
		ld		l,a
		ld		h,0
		ret
.directstr_68: DW 4: DB "MSX",0
.directstr_69: DW 3: DB "EP",0
.directstr_70: DW 4: DB "PCW",0
.directstr_71: DW 4: DB "CPC",0
.directstr_72: DW 10: DB "SF3 ERROR",0
.directstr_73: DW 21: DB "F131_3 users online:",0
.directstr_74: DW 10: DB "131_7 in ",0
.directstr_75: DW 3: DB "->",0
.directstr_76: DW 3: DB "<-",0
.directstr_77: DW 9: DB "AT resp:",0
.SyDesktop_SendMessage:
        ld 		iy,AppMsgB
        ld 		(iy+0),c
        ld 		(iy+1),a
        ld 		(iy+2),e
        ld 		(iy+3),d
        ld 		(iy+4),l
        ld 		(iy+5),h
        db 		#dd:ld h,2       ;2 is the number of the desktop manager process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#10
        ret
.SyDesktop_WaitMessage: 
		ld 		iy,AppMsgB
.SyDWMs1:
		db 		#dd:ld h,2       ;2 is the number of the desktop manager process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#08             ;wait for a desktop manager message
        db 		#dd:dec l
        jr 		nz,SyDWMs1
        ld 		a,(iy+0)
        ret
.Quig_String_Stack_Clear:
		ld		hl,(Quig_String_Buffer_StackNo)
		ld		de,Quig_String_Buffer_Stack
		add		hl,hl
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		(Quig_String_Buffer_Pos),de
		ret
.Quig_Garbage:
		ld		hl,Quigs_String_Data_Start
		ld		ix,Quig_String_Count
		call	memgrb
		inc		de
		inc		de
		inc		de
		inc		de
		ld		(Quig_String_Pos),de
		ret
.memgrb:ld 		e,l          ;HL=source pointer, DE=destination pointer
        ld 		d,h
.memgrb1:
		db #dd:ld a,l
        db #dd:or h
        ret 	z
.memgrb2:
		ld 		c,(hl)       ;get pointer (or 0=empty-marker)
        inc 	hl
        ld 		b,(hl)
        ld 		a,c
        or 		b
        jr 		nz,memgrb3
        inc 	hl                  ;*** empty area found -> skip it
        ld 		c,(hl)
        inc 	hl
        ld 		b,(hl)       ;BC=length
        inc 	hl
        add 	hl,bc       ;HL=next entry
        jr 		memgrb2
.memgrb3:
		dec 	hl                  ;*** string found -> move and perhaps shrink it
        ldi
		ldi         ;copy pointer-link
        inc 	bc
		inc 	bc   ;restore pointer-adr
        push 	de         ;push new length adr
        inc 	de
		inc 	de
        ld 		a,e
        ld 		(bc),a
        inc 	bc
        ld 		a,d
        ld 		(bc),a       ;set pointer to new address
        ld 		c,(hl)
        inc 	hl
        ld 		b,(hl)
        inc 	hl          ;BC=old length
        push 	hl
        add 	hl,bc       ;HL=next entry
        ex 		(sp),hl
        ld 		bc,-1        ;BC=cpl(new length)
.memgrb4:
		ld 		a,(hl)       ;move string bytes
        ldi
        or 		a
        jr 		nz,memgrb4   ;until 0-terminator reached
        pop 	hl          ;get next entry
        ex 		(sp),hl      ;push next entry, HL=new length adr
        ld 		a,c          ;write new length to new length adr
        cpl
        ld 		(hl),a
        inc 	hl
        ld 		a,b
        cpl
        ld 		(hl),a
        pop 	hl          ;HL=next entry
        dec 	ix
        jr 		memgrb1		
.SySystem_SendMessage:
		ld		iy,AppMsgB
		ld 		(iy+0),c
		ld 		(iy+1),l
		ld 		(iy+2),h
		ld 		(iy+3),a
		ld		(iy+4),e
		ld		(iy+5),d
		db 		#dd:ld h,3       ;3 is the number of the system manager process
		ld 		a,(AppPrzN)
		db 		#dd:ld l,a
		rst 	#10
		ret
.SySystem_WaitMessage:
		ld		iy,AppMsgB
.SySWMs1
		db		#dd:ld h,3       ;3 is the number of the system manager process
		ld		a,(AppPrzN)
		db 		#dd:ld l,a
		rst 	#08             ;wait for a system manager message
		db 		#dd:dec l
		jr 		nz,SySWMs1
		ld 		a,(iy+0)		
		ret
.SySystem_PRGRUN 
		ld		c,MSC_SYS_PRGRUN
		call 	SySystem_SendMessage
.SySPRn1
		call 	SySystem_WaitMessage
		cp 		MSR_SYS_PRGRUN
		jr 		nz,SySPRn1
		ld 		a,(iy+1)
		ld 		l,(iy+8)
		ld 		h,(iy+9)
		ret
.Quig_CodeEnd:db 0
.AppDatBeg
.AppFormStart:    dw Form4_Begin
.AppFormLists
    dw Form1_ControlWindowData
.Form1_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
.Form2_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
.Form3_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
.Form4_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
.Icon24_Data
.Icon24_Data_WidthByte:     db 12
.Icon24_Data_WidthPixel:    db 24
.Icon24_Data_Height:        db 24
.Icon24_Data_DataAddr:      dw Icon24_Data_Data
.Icon24_Data_EncodeAddr:    dw Icon24_Data_Encode
.Icon24_Data_Size:          dw 288
.Icon24_Data_Encode:        db 5
.Icon24_Data_Data:          
             db 51,51,51,51,51,51,51,51,51,51,51,51
             db 48,0,0,0,0,0,0,0,0,0,0,3
             db 48,0,0,0,0,1,17,16,0,0,0,3
             db 48,0,0,1,17,18,34,33,16,0,0,3
             db 48,0,0,18,34,34,34,34,33,16,0,3
             db 48,0,1,34,34,34,34,34,34,33,0,3
             db 48,0,18,34,34,33,18,34,34,33,0,3
             db 48,0,18,34,34,16,1,34,34,33,0,3
             db 48,1,34,34,33,0,0,18,34,33,0,3
             db 48,1,34,34,33,0,0,18,34,33,0,3
             db 48,1,34,34,33,0,0,18,34,33,0,3
             db 48,1,34,34,33,0,1,34,34,16,0,3
             db 48,1,34,34,34,17,18,34,34,16,0,3
             db 48,1,34,34,34,34,34,34,33,0,0,3
             db 48,0,18,34,34,34,34,34,17,0,0,3
             db 48,0,1,34,34,34,34,33,0,0,0,3
             db 48,0,0,17,17,34,34,34,16,0,0,3
             db 48,0,0,0,0,18,34,34,33,17,16,3
             db 48,0,0,0,0,1,34,34,34,34,16,3
             db 48,0,0,0,0,0,18,34,34,34,16,3
             db 48,0,0,0,0,0,1,34,34,34,16,3
             db 48,0,0,0,0,0,0,17,17,17,16,3
             db 48,0,0,0,0,0,0,0,0,0,0,3
             db 51,51,51,51,51,51,51,51,51,51,51,51
.Sheet_Data4:                   
.Sheet_Data4_WidthByte:     db 2
.Sheet_Data4_WidthPixel:    db 1
.Sheet_Data4_Height:        db 1
.Sheet_Data4_DataAddr:      dw Sheet_Data4_Data
.Sheet_Data4_EncodeAddr:    dw Sheet_Data4_Encode
.Sheet_Data4_Size:          dw 1
.Sheet_Data4_Encode:        db 0
.Sheet_Data4_Data:          db 200,1
.File_Select_Text:   dw File_Select_Text_Data+4
.Dir_Select_Text:   dw Dir_Select_Text_Data+4
.var_wrd_ioA_0:   dw 0
.var_wrd_ioA_1:   dw 0
.var_wrd_ioA_2:   dw 0
.var_wrd_ioA_3:   dw 0
.var_wrd_ioA_4:   dw 0
.var_wrd_ioA_5:   dw 0
.var_wrd_ioA_6:   dw 0
.var_wrd_ioA_7:   dw 0
.var_wrd_ioA_8:   dw 0
.var_wrd_ioA_9:   dw 0
.var_wrd_ioA_A:   dw 0
.var_wrd_ioA_B:   dw 0
.var_wrd_ioA_C:   dw 0
.var_wrd_ioA_D:   dw 0
.var_wrd_ioA_E:   dw 0
.var_wrd_ioA_F:   dw 0
.var_wrd_resp:   dw 0
.var_byt_defNetStatusBitTx:   db 128
.var_byt_defNetStatusBitRx:   db 64
.var_byt_defNetStatusBitError:   db 32
.var_byt_defNetStatusBitVoip:   db 16
.var_byt_defNetStatusBitUser:   db 8
.var_byt_defNetStatusBitShMem:   db 4
.var_byt_defNetStatusBitMsg:   db 2
.var_byt_defNetStatusBitSys:   db 1
.var_wrd_defTileEmpty:   dw 0
.var_wrd_defTileHori:   dw 1
.var_wrd_defTileVert:   dw 2
.var_wrd_defTileBox:   dw 3
.var_wrd_defTileDot:   dw 4
.var_wrd_defVoipIdle:   dw 0
.var_wrd_defVoipOutgoingCall:   dw 1
.var_wrd_defVoipOtherBusy:   dw 2
.var_wrd_defVoipOtherOffline:   dw 3
.var_wrd_defVoipIncommingCall:   dw 4
.var_wrd_defVoipActiveCall:   dw 5
.var_str_strHardware:   dw var_str_strHardware_Data+4
.var_str_strCPU:   dw var_str_strCPU_Data+4
.var_str_strFirmware:   dw var_str_strFirmware_Data+4
.var_str_sText:   dw var_str_sText_Data+4
.var_wrd_iStpStartup:   dw 0
.var_wrd_intDelay:   dw 2
.var_wrd_intDelayCt:   dw 0
.var_str_sDb:   dw var_str_sDb_Data+4
.var_wrd_dbStp:   dw 0
.var_wrd_iDbL:   dw 0
.var_wrd_iDbT:   dw 0
.var_wrd_iDbC:   dw 0
.var_wrd_iAppExit:   dw 0
.var_wrd_iTimeOut:   dw 0
.var_wrd_fc:   dw 0
.var_wrd_fn:   dw 0
.var_wrd_fx:   dw 0
.var_wrd_fy:   dw 0
.var_wrd_fsw:   dw 0
.var_wrd_u8In1:   dw 0
.var_wrd_u8In2:   dw 0
.var_wrd_u8Out1:   dw 0
.var_wrd_u8Out2:   dw 0
.var_wrd_u8Out3:   dw 0
.var_wrd_u8Out4:   dw 0
.var_wrd_u8Out5:   dw 0
.var_wrd_u16In1:   dw 0
.var_wrd_u16Out1:   dw 0
.var_wrd_u16Out2:   dw 0
.var_wrd_u16Out3:   dw 0
.var_wrd_u16Out4:   dw 0
.var_wrd_u16Out5:   dw 0
.var_wrd_u16Out6:   dw 0
.var_wrd_u16Out7:   dw 0
.var_wrd_u16Out8:   dw 0
.var_str_strIn1:   dw var_str_strIn1_Data+4
.var_str_strOut1:   dw var_str_strOut1_Data+4
.var_str_strOut2:   dw var_str_strOut2_Data+4
.var_str_strOut3:   dw var_str_strOut3_Data+4
.var_str_strOut4:   dw var_str_strOut4_Data+4
.var_wrd_a:   dw 0
.var_wrd_t:   dw 0
.var_wrd_c:   dw 0
.var_wrd_y:   dw 0
.var_wrd_x:   dw 0
.var_wrd_l:   dw 0
.var_wrd_v:   dw 0
.var_wrd_lt:   dw 0
.var_wrd_lv:   dw 0
.var_wrd_u16Ur:   dw 0
.var_wrd_lc:   dw 0
.var_wrd_li:   dw 0
.var_wrd_bSw:   dw 0
.ar1_str_strChatText:   dw 0
                 dw ar1_str_strChatText_Data+4
                 dw ar1_str_strChatText_Data+9
                 dw ar1_str_strChatText_Data+14
                 dw ar1_str_strChatText_Data+19
                 dw ar1_str_strChatText_Data+24
.var_str_strChatInp:   dw var_str_strChatInp_Data+4
.var_wrd_u8FifoIn:   dw 0
.var_wrd_u8FifoOut:   dw 0
.var_byt_u8FifoContent:   db 0
.ar1_wrd_u16Fd:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0
.ar1_str_strFm:   dw 0
                 dw ar1_str_strFm_Data+4
                 dw ar1_str_strFm_Data+9
                 dw ar1_str_strFm_Data+14
                 dw ar1_str_strFm_Data+19
                 dw ar1_str_strFm_Data+24
                 dw ar1_str_strFm_Data+29
                 dw ar1_str_strFm_Data+34
                 dw ar1_str_strFm_Data+39
                 dw ar1_str_strFm_Data+44
                 dw ar1_str_strFm_Data+49
                 dw ar1_str_strFm_Data+54
                 dw ar1_str_strFm_Data+59
                 dw ar1_str_strFm_Data+64
                 dw ar1_str_strFm_Data+69
.var_str_strTm:   dw var_str_strTm_Data+4
.var_str_strMs:   dw var_str_strMs_Data+4
.var_wrd_u16Du:   dw 0
.var_wrd_u8Key:   dw 0
.var_byt_shDD_dot_status:   db 0
.var_byt_shDD_dot_sheet:   db 0
.var_byt_shDD_dot_tiles:   db 0
.var_wrd_shDD_dot_size:   dw 0
.var_byt_shDD_dot_bank:   db 0
.var_wrd_shDD_dot_addr:   dw 0
.var_byt_shDD_dot_colourdepth:   db 0
.var_byt_shDD_hori_status:   db 0
.var_byt_shDD_hori_sheet:   db 0
.var_byt_shDD_hori_tiles:   db 0
.var_wrd_shDD_hori_size:   dw 0
.var_byt_shDD_hori_bank:   db 0
.var_wrd_shDD_hori_addr:   dw 0
.var_byt_shDD_hori_colourdepth:   db 0
.var_byt_shDD_vert_status:   db 0
.var_byt_shDD_vert_sheet:   db 0
.var_byt_shDD_vert_tiles:   db 0
.var_wrd_shDD_vert_size:   dw 0
.var_byt_shDD_vert_bank:   db 0
.var_wrd_shDD_vert_addr:   dw 0
.var_byt_shDD_vert_colourdepth:   db 0
.var_byt_shDD_fill_status:   db 0
.var_byt_shDD_fill_sheet:   db 0
.var_byt_shDD_fill_tiles:   db 0
.var_wrd_shDD_fill_size:   dw 0
.var_byt_shDD_fill_bank:   db 0
.var_wrd_shDD_fill_addr:   dw 0
.var_byt_shDD_fill_colourdepth:   db 0
.var_byt_shDD_start_status:   db 0
.var_byt_shDD_start_sheet:   db 0
.var_byt_shDD_start_tiles:   db 0
.var_wrd_shDD_start_size:   dw 0
.var_byt_shDD_start_bank:   db 0
.var_wrd_shDD_start_addr:   dw 0
.var_byt_shDD_start_colourdepth:   db 0
.var_byt_shDD_digi_status:   db 0
.var_byt_shDD_digi_sheet:   db 0
.var_byt_shDD_digi_tiles:   db 0
.var_wrd_shDD_digi_size:   dw 0
.var_byt_shDD_digi_bank:   db 0
.var_wrd_shDD_digi_addr:   dw 0
.var_byt_shDD_digi_colourdepth:   db 0
.var_byt_shDD_voip_status:   db 0
.var_byt_shDD_voip_sheet:   db 0
.var_byt_shDD_voip_tiles:   db 0
.var_wrd_shDD_voip_size:   dw 0
.var_byt_shDD_voip_bank:   db 0
.var_wrd_shDD_voip_addr:   dw 0
.var_byt_shDD_voip_colourdepth:   db 0
.ar1_wrd_ImgIds:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0
.ar1_wrd_ImgTile:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0
.ar1_wrd_ImgTileCom:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0
.var_wrd_iButChoise:   dw 0
.var_wrd_iSelImg:   dw 0
.var_wrd_iGameMode:   dw 0
.var_wrd_iWinner:   dw 0
.var_wrd_iPlayer:   dw 0
.var_wrd_iPlayerActive:   dw 0
.var_wrd_bRestart:   dw 0
.var_wrd_bExit:   dw 0
.var_wrd_iRecPointer:   dw 0
.ar1_wrd_u16PlayerList:   dw 0
       dw 0,0,0
.var_wrd_u16OtherID:   dw 0
.ar1_wrd_iScore:   dw 0
       dw 0,0,0
.var_wrd_bNew_field:   dw 0
.var_wrd_bAgain:   dw 0
.var_wrd_bReSend:   dw 0
.var_wrd_iFlash:   dw 0
.var_wrd_iFlashCt:   dw 0
.var_str_strAppname:   dw var_str_strAppname_Data+4
.var_wrd_u16MyUserID:   dw 0
.var_str_strUserPass:   dw var_str_strUserPass_Data+4
.ar1_str_strPlayerName:   dw 0
                 dw ar1_str_strPlayerName_Data+4
                 dw ar1_str_strPlayerName_Data+9
                 dw ar1_str_strPlayerName_Data+14
                 dw ar1_str_strPlayerName_Data+19
.ar1_wrd_u16UserOnline:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.var_wrd_iUserOnlineTotal:   dw 0
.var_wrd_u8NetStatus:   dw 0
.var_wrd_u8h:   dw 0
.var_wrd_u8l:   dw 0
.var_wrd_u8d:   dw 0
.var_wrd_w:   dw 0
.var_wrd_iUserOnlineTimer:   dw 0
.var_str_sAtCmd:   dw var_str_sAtCmd_Data+4
.var_str_sAtResp:   dw var_str_sAtResp_Data+4
.var_str_sAtData:   dw var_str_sAtData_Data+4
.var_wrd_iVoipChgCt:   dw 0
.var_wrd_iVoipStatus:   dw 0
.var_wrd_iVoipStatusOld:   dw 0
.var_wrd_u16OtherUserId:   dw 0
.var_wrd_iVoipSoundSelect:   dw 0
.var_wrd_iVoipSoundCt:   dw 0
.var_wrd_iVoipSoundSeq:   dw 0
.var_wrd_iUserOnlinePointer:   dw 0
.var_wrd_iDelayVoipCt:   dw 0
.Quigs_String_Data_Start:
.File_Select_Text_Data:         dw File_Select_Text:dw 1:db 0
.Dir_Select_Text_Data:          dw Dir_Select_Text:dw 1:db 0
.var_str_strHardware_Data:      dw var_str_strHardware:dw 5:db "NONE",0
.var_str_strCPU_Data:           dw var_str_strCPU:dw 1:db 0
.var_str_strFirmware_Data:      dw var_str_strFirmware:dw 9:db "20250121",0
.var_str_sText_Data:            dw var_str_sText:dw 1:db 0
.var_str_sDb_Data:              dw var_str_sDb:dw 1:db 0
.var_str_strIn1_Data:           dw var_str_strIn1:dw 1:db 0
.var_str_strOut1_Data:          dw var_str_strOut1:dw 1:db 0
.var_str_strOut2_Data:          dw var_str_strOut2:dw 1:db 0
.var_str_strOut3_Data:          dw var_str_strOut3:dw 1:db 0
.var_str_strOut4_Data:          dw var_str_strOut4:dw 1:db 0
.ar1_str_strChatText_Data:      
                                dw ar1_str_strChatText+2:dw 1:db 0 
                                dw ar1_str_strChatText+4:dw 1:db 0 
                                dw ar1_str_strChatText+6:dw 1:db 0 
                                dw ar1_str_strChatText+8:dw 1:db 0 
                                dw ar1_str_strChatText+10:dw 1:db 0 
.var_str_strChatInp_Data:       dw var_str_strChatInp:dw 1:db 0
.ar1_str_strFm_Data:            
                                dw ar1_str_strFm+2:dw 1:db 0 
                                dw ar1_str_strFm+4:dw 1:db 0 
                                dw ar1_str_strFm+6:dw 1:db 0 
                                dw ar1_str_strFm+8:dw 1:db 0 
                                dw ar1_str_strFm+10:dw 1:db 0 
                                dw ar1_str_strFm+12:dw 1:db 0 
                                dw ar1_str_strFm+14:dw 1:db 0 
                                dw ar1_str_strFm+16:dw 1:db 0 
                                dw ar1_str_strFm+18:dw 1:db 0 
                                dw ar1_str_strFm+20:dw 1:db 0 
                                dw ar1_str_strFm+22:dw 1:db 0 
                                dw ar1_str_strFm+24:dw 1:db 0 
                                dw ar1_str_strFm+26:dw 1:db 0 
                                dw ar1_str_strFm+28:dw 1:db 0 
.var_str_strTm_Data:            dw var_str_strTm:dw 1:db 0
.var_str_strMs_Data:            dw var_str_strMs:dw 1:db 0
.var_str_strAppname_Data:       dw var_str_strAppname:dw 1:db 0
.var_str_strUserPass_Data:      dw var_str_strUserPass:dw 1:db 0
.ar1_str_strPlayerName_Data:    
                                dw ar1_str_strPlayerName+2:dw 1:db 0 
                                dw ar1_str_strPlayerName+4:dw 1:db 0 
                                dw ar1_str_strPlayerName+6:dw 1:db 0 
                                dw ar1_str_strPlayerName+8:dw 1:db 0 
.var_str_sAtCmd_Data:           dw var_str_sAtCmd:dw 1:db 0
.var_str_sAtResp_Data:          dw var_str_sAtResp:dw 1:db 0
.var_str_sAtData_Data:          dw var_str_sAtData:dw 1:db 0
.Quig_Dialog_1_Data:            dw Quig_Dialog_1:dw 1:db 0
.Quig_Dialog_2_Data:            dw Quig_Dialog_2:dw 1:db 0
.Quig_Dialog_3_Data:            dw Quig_Dialog_3:dw 1:db 0
.Form1_Text_Data:               dw Form1_Text:dw 8:db "Dot Box",0
.Form1_Status_Text_Data:        dw Form1_Status_Text:dw 1:db 0
.Label9_Text_Data:              dw Label9_Text:dw 7:db "TMTNET",0
.Label7_Text_Data:              dw Label7_Text:dw 5:db "....",0
.Label8_Text_Data:              dw Label8_Text:dw 5:db "....",0
.Label6_Text_Data:              dw Label6_Text:dw 8:db "Wait...",0
.Label5_Text_Data:              dw Label5_Text:dw 20:db "Version 17 jan 2025",0
.Label4_Text_Data:              dw Label4_Text:dw 39:db "Thanks to: Trebmint Edoz and Prodatron",0
.Label3_Text_Data:              dw Label3_Text:dw 1:db 0
.Label2_Text_Data:              dw Label2_Text:dw 17:db "Made by Tmtlogic",0
.Label1_Text_Data:              dw Label1_Text:dw 10:db "Chat.....",0
.Label14_Text_Data:             dw Label14_Text:dw 7:db "REPLAY",0
.Label12_Text_Data:             dw Label12_Text:dw 13:db " Score: Name",0
.Label10_Text_Data:             dw Label10_Text:dw 5:db "Name",0
.Label11_Text_Data:             dw Label11_Text:dw 5:db "Name",0
.Label13_Text_Data:             dw Label13_Text:dw 12:db " Score Name",0
.Label15_Text_Data:             dw Label15_Text:dw 5:db "HELP",0
.LabelVoip_Text_Data:           dw LabelVoip_Text:dw 10:db "INCOMMING",0
.Form2_Text_Data:               dw Form2_Text:dw 8:db "DOT BOX",0
.Form2_Status_Text_Data:        dw Form2_Status_Text:dw 1:db 0
.Label20_Text_Data:             dw Label20_Text:dw 21:db "Choose your opponent",0
.Label21_Text_Data:             dw Label21_Text:dw 5:db " ...",0
.Label23_Text_Data:             dw Label23_Text:dw 5:db " ...",0
.Label24_Text_Data:             dw Label24_Text:dw 5:db " ...",0
.Label25_Text_Data:             dw Label25_Text:dw 5:db " ...",0
.Label26_Text_Data:             dw Label26_Text:dw 6:db "App >",0
.Label22_Text_Data:             dw Label22_Text:dw 5:db " ...",0
.Form3_Text_Data:               dw Form3_Text:dw 13:db "TMTNET LOGIN",0
.Form3_Status_Text_Data:        dw Form3_Status_Text:dw 1:db 0
.Form4_Text_Data:               dw Form4_Text:dw 7:db "TMTNET",0
.Form4_Status_Text_Data:        dw Form4_Status_Text:dw 1:db 0
.Label41_Text_Data:             dw Label41_Text:dw 8:db "DOT BOX",0
.Button41_Text_Data:            dw Button41_Text:dw 4:db "---",0
.Quig_String_Count   Equ 79
.Quig_String_End_Text:   db  0,0,0,0,0
.AppTrnBeg
          ds    256
.AppStk   ds    6*2
          dw    AppPrz
.AppPrzN  db    0
.AppMsgB
.Event_Message       db 0         ;0 Message No 16
.Event_Form_ID       db 0         ;1 Event happned on which Form
.Event_Type          db 0         ;2 Type of Event
.Event_UserInput     db 0         ;3 Key or Mouse Event
.Event_Key_ASCII                  ; Key ASCII - Shared Byte with next
.Event_MouseX        dw 0         ;4 MouseX when event happens
.Event_MouseY        dw 0         ;6 MouseY when event happens
.Event_Control_ID    dw 0         ;8 Control ID No
.Event_8             db 0         ;10
.Event_9             db 0         ;11
.Event_10            db 0         ;12
.Event_11            db 0         ;13
.Quig_Machine_Type   db 0    ;0=464, 1=664, 2=6128, 3=464Plus, 4=6128Plus 6=Enterprise 64/128 7=MSX1 8=MSX2, 9=MSX2+, 10=MSX TurboR 12=PCW8xxx, 13=PCW9xxx
.Quig_Null_String    db 0
.Quig_Dialog_1:      dw Quig_Dialog_1_Data+4,6
.Quig_Dialog_2:      dw Quig_Dialog_2_Data+4,6
.Quig_Dialog_3:      dw Quig_Dialog_3_Data+4,6
.Quig_Dialog_4:      dw 0,AppIcnLrg,Icon24_Data
.Quig_App_Version:   db "",0
.Quig_App_Coder:     db "(Coder name)",0
.Quig_App_Date:   	  db "09 May 2025",0
.App_Form_List
       dw  Form1_Begin,QFunc_Form1_Open_Event,QFunc_Form1_Close_Event,0,0,0,0,Form1
       dw  Form2_Begin,QFunc_Form2_Open_Event,QFunc_Form2_Close_Event,0,0,0,0,Form2
       dw  Form3_Begin,0,0,0,0,0,0,Form3
       dw  Form4_Begin,QFunc_Form4_Open_Event,QFunc_Form4_Close_Event,0,0,0,0,Form4
.ControWindowDataList
     dw Form1_ControlWindowData
     dw 0 ;**** There is No Toolbar
     dw Form2_ControlWindowData
     dw 0 ;**** There is No Toolbar
     dw Form3_ControlWindowData
     dw 0 ;**** There is No Toolbar
     dw Form4_ControlWindowData
     dw 0 ;**** There is No Toolbar
.Form1
.Form1_Addr:                    db 0,0
.Form1_Begin:                   
.Form1_Status:                  db 128
.Form1_Display:                 db 20
.Form1_SizeAdjust:              db 20
.Form1_OwnerID:                 db 0
.Form1_Left:                    dw 0
.Form1_Top:                     dw 0
.Form1_Width:                   dw 310
.Form1_Height:                  dw 171
.Form1_OffsetWidth:             dw 1
.Form1_OffsetHeight:            dw 8
.Form1_ContentWidth:            dw 301
.Form1_ContentHeight:           dw 171
.Form1_MinWidth:                dw 0
.Form1_MinHeight:               dw 0
.Form1_MaxWidth:                dw 1024
.Form1_MaxHeight:               dw 212
.Form1_IconAddr:                dw 0
.Form1_Text:                    dw Form1_Text_Data+4
.Form1_Status_Text:             dw Form1_Status_Text_Data+4
.Form1_MenuAddr:                dw 0  ;No Menu on form
.Form1_ControlWindowAddr:       dw Form1_ControlWindow
.Form1_ControlToolAddr:         dw 0;Form1_ControlTool
.Form1_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form1_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved
.Form1_ControlWindow:           
.Form1_ControlWindowCount:      db 145
.Form1_ControlWindowOwnerID:    db 0
.Form1_ControlWindowDataAddr:   dw Form1_ControlWindowData
.Form1_ControlWindowCalcAddr:   dw 0; Form1_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form1_ControlWindowFocus:      db 0
     db 0
.Form1_ControlWindowData:       
dw 0,255*256+0,129,  0,0,1000,1000,0
.Image14_Display      Equ 1
.Image14
.Image14_ID:                    dw 1
.Image14_Type:                  db 10   ;*ImageBox
.Image14_ExtDataBank:           db 255
.Image14_GrInfoAddr:            dw Sheet_Data4
.Image14_Left:                  dw 114
.Image14_Top:                   dw 12
.Image14_Width:                 dw 3
.Image14_Height:                dw 10
.Image14_Code:                  dw QFunc_Image_Event
.Image9_Display      Equ 2
.Image9
.Image9_ID:                     dw 2
.Image9_Type:                   db 10   ;*ImageBox
.Image9_ExtDataBank:            db 255
.Image9_GrInfoAddr:             dw Sheet_Data4
.Image9_Left:                   dw 163
.Image9_Top:                    dw 5
.Image9_Width:                  dw 7
.Image9_Height:                 dw 7
.Image9_Code:                   dw 0
.Label9_Display      Equ 3
.Label9
.Label9_ID:                     dw 3
.Label9_Type:                   db 1   ;*Label
.Label9_ExtDataBank:            db 255
.Label9_ExtDataAddr:            dw Label9_ExtData
.Label9_Left:                   dw 7
.Label9_Top:                    dw 5
.Label9_Width:                  dw 40
.Label9_Height:                 dw 8
.Label9_Code:                   dw 0
.Label7_Display      Equ 4
.Label7
.Label7_ID:                     dw 4
.Label7_Type:                   db 1   ;*Label
.Label7_ExtDataBank:            db 255
.Label7_ExtDataAddr:            dw Label7_ExtData
.Label7_Left:                   dw 7
.Label7_Top:                    dw 25
.Label7_Width:                  dw 25
.Label7_Height:                 dw 8
.Label7_Code:                   dw 0
.Label8_Display      Equ 5
.Label8
.Label8_ID:                     dw 5
.Label8_Type:                   db 1   ;*Label
.Label8_ExtDataBank:            db 255
.Label8_ExtDataAddr:            dw Label8_ExtData
.Label8_Left:                   dw 7
.Label8_Top:                    dw 55
.Label8_Width:                  dw 25
.Label8_Height:                 dw 8
.Label8_Code:                   dw 0
.Label6_Display      Equ 6
.Label6
.Label6_ID:                     dw 6
.Label6_Type:                   db 1   ;*Label
.Label6_ExtDataBank:            db 255
.Label6_ExtDataAddr:            dw Label6_ExtData
.Label6_Left:                   dw 0
.Label6_Top:                    dw 104
.Label6_Width:                  dw 243
.Label6_Height:                 dw 8
.Label6_Code:                   dw 0
.Label5_Display      Equ 7
.Label5
.Label5_ID:                     dw 7
.Label5_Type:                   db 1   ;*Label
.Label5_ExtDataBank:            db 255
.Label5_ExtDataAddr:            dw Label5_ExtData
.Label5_Left:                   dw 7
.Label5_Top:                    dw 115
.Label5_Width:                  dw 233
.Label5_Height:                 dw 8
.Label5_Code:                   dw 0
.Label4_Display      Equ 8
.Label4
.Label4_ID:                     dw 8
.Label4_Type:                   db 1   ;*Label
.Label4_ExtDataBank:            db 255
.Label4_ExtDataAddr:            dw Label4_ExtData
.Label4_Left:                   dw 7
.Label4_Top:                    dw 125
.Label4_Width:                  dw 233
.Label4_Height:                 dw 8
.Label4_Code:                   dw 0
.Label3_Display      Equ 9
.Label3
.Label3_ID:                     dw 9
.Label3_Type:                   db 1   ;*Label
.Label3_ExtDataBank:            db 255
.Label3_ExtDataAddr:            dw Label3_ExtData
.Label3_Left:                   dw 7
.Label3_Top:                    dw 135
.Label3_Width:                  dw 233
.Label3_Height:                 dw 8
.Label3_Code:                   dw 0
.Label2_Display      Equ 10
.Label2
.Label2_ID:                     dw 10
.Label2_Type:                   db 1   ;*Label
.Label2_ExtDataBank:            db 255
.Label2_ExtDataAddr:            dw Label2_ExtData
.Label2_Left:                   dw 7
.Label2_Top:                    dw 145
.Label2_Width:                  dw 233
.Label2_Height:                 dw 8
.Label2_Code:                   dw 0
.Label1_Display      Equ 11
.Label1
.Label1_ID:                     dw 11
.Label1_Type:                   db 1   ;*Label
.Label1_ExtDataBank:            db 255
.Label1_ExtDataAddr:            dw Label1_ExtData
.Label1_Left:                   dw 7
.Label1_Top:                    dw 155
.Label1_Width:                  dw 233
.Label1_Height:                 dw 8
.Label1_Code:                   dw 0
.Label14_Display      Equ 12
.Label14
.Label14_ID:                    dw 12
.Label14_Type:                  db 1   ;*Label
.Label14_ExtDataBank:           db 255
.Label14_ExtDataAddr:           dw Label14_ExtData
.Label14_Left:                  dw 273
.Label14_Top:                   dw 104
.Label14_Width:                 dw 37
.Label14_Height:                dw 8
.Label14_Code:                  dw QFunc_Label14_Event
.Image1_Display      Equ 13
.Image1
.Image1_ID:                     dw 13
.Image1_Type:                   db 10   ;*ImageBox
.Image1_ExtDataBank:            db 255
.Image1_GrInfoAddr:             dw Sheet_Data4
.Image1_Left:                   dw 95
.Image1_Top:                    dw 5
.Image1_Width:                  dw 7
.Image1_Height:                 dw 7
.Image1_Code:                   dw 0
.Image2_Display      Equ 14
.Image2
.Image2_ID:                     dw 14
.Image2_Type:                   db 10   ;*ImageBox
.Image2_ExtDataBank:            db 255
.Image2_GrInfoAddr:             dw Sheet_Data4
.Image2_Left:                   dw 102
.Image2_Top:                    dw 7
.Image2_Width:                  dw 10
.Image2_Height:                 dw 3
.Image2_Code:                   dw QFunc_Image_Event
.Image3_Display      Equ 15
.Image3
.Image3_ID:                     dw 15
.Image3_Type:                   db 10   ;*ImageBox
.Image3_ExtDataBank:            db 255
.Image3_GrInfoAddr:             dw Sheet_Data4
.Image3_Left:                   dw 112
.Image3_Top:                    dw 5
.Image3_Width:                  dw 7
.Image3_Height:                 dw 7
.Image3_Code:                   dw 0
.Image4_Display      Equ 16
.Image4
.Image4_ID:                     dw 16
.Image4_Type:                   db 10   ;*ImageBox
.Image4_ExtDataBank:            db 255
.Image4_GrInfoAddr:             dw Sheet_Data4
.Image4_Left:                   dw 119
.Image4_Top:                    dw 7
.Image4_Width:                  dw 10
.Image4_Height:                 dw 3
.Image4_Code:                   dw QFunc_Image_Event
.Image5_Display      Equ 17
.Image5
.Image5_ID:                     dw 17
.Image5_Type:                   db 10   ;*ImageBox
.Image5_ExtDataBank:            db 255
.Image5_GrInfoAddr:             dw Sheet_Data4
.Image5_Left:                   dw 129
.Image5_Top:                    dw 5
.Image5_Width:                  dw 7
.Image5_Height:                 dw 7
.Image5_Code:                   dw 0
.Image6_Display      Equ 18
.Image6
.Image6_ID:                     dw 18
.Image6_Type:                   db 10   ;*ImageBox
.Image6_ExtDataBank:            db 255
.Image6_GrInfoAddr:             dw Sheet_Data4
.Image6_Left:                   dw 136
.Image6_Top:                    dw 7
.Image6_Width:                  dw 10
.Image6_Height:                 dw 3
.Image6_Code:                   dw QFunc_Image_Event
.Image7_Display      Equ 19
.Image7
.Image7_ID:                     dw 19
.Image7_Type:                   db 10   ;*ImageBox
.Image7_ExtDataBank:            db 255
.Image7_GrInfoAddr:             dw Sheet_Data4
.Image7_Left:                   dw 146
.Image7_Top:                    dw 5
.Image7_Width:                  dw 7
.Image7_Height:                 dw 7
.Image7_Code:                   dw 0
.Image8_Display      Equ 20
.Image8
.Image8_ID:                     dw 20
.Image8_Type:                   db 10   ;*ImageBox
.Image8_ExtDataBank:            db 255
.Image8_GrInfoAddr:             dw Sheet_Data4
.Image8_Left:                   dw 153
.Image8_Top:                    dw 7
.Image8_Width:                  dw 10
.Image8_Height:                 dw 3
.Image8_Code:                   dw QFunc_Image_Event
.Image10_Display      Equ 21
.Image10
.Image10_ID:                    dw 21
.Image10_Type:                  db 10   ;*ImageBox
.Image10_ExtDataBank:           db 255
.Image10_GrInfoAddr:            dw Sheet_Data4
.Image10_Left:                  dw 170
.Image10_Top:                   dw 7
.Image10_Width:                 dw 10
.Image10_Height:                dw 3
.Image10_Code:                  dw QFunc_Image_Event
.Image11_Display      Equ 22
.Image11
.Image11_ID:                    dw 22
.Image11_Type:                  db 10   ;*ImageBox
.Image11_ExtDataBank:           db 255
.Image11_GrInfoAddr:            dw Sheet_Data4
.Image11_Left:                  dw 180
.Image11_Top:                   dw 5
.Image11_Width:                 dw 7
.Image11_Height:                dw 7
.Image11_Code:                  dw 0
.Image12_Display      Equ 23
.Image12
.Image12_ID:                    dw 23
.Image12_Type:                  db 10   ;*ImageBox
.Image12_ExtDataBank:           db 255
.Image12_GrInfoAddr:            dw Sheet_Data4
.Image12_Left:                  dw 97
.Image12_Top:                   dw 12
.Image12_Width:                 dw 3
.Image12_Height:                dw 10
.Image12_Code:                  dw QFunc_Image_Event
.Image13_Display      Equ 24
.Image13
.Image13_ID:                    dw 24
.Image13_Type:                  db 10   ;*ImageBox
.Image13_ExtDataBank:           db 255
.Image13_GrInfoAddr:            dw Sheet_Data4
.Image13_Left:                  dw 101
.Image13_Top:                   dw 11
.Image13_Width:                 dw 12
.Image13_Height:                dw 12
.Image13_Code:                  dw 0
.Image15_Display      Equ 25
.Image15
.Image15_ID:                    dw 25
.Image15_Type:                  db 10   ;*ImageBox
.Image15_ExtDataBank:           db 255
.Image15_GrInfoAddr:            dw Sheet_Data4
.Image15_Left:                  dw 118
.Image15_Top:                   dw 11
.Image15_Width:                 dw 12
.Image15_Height:                dw 12
.Image15_Code:                  dw 0
.Image16_Display      Equ 26
.Image16
.Image16_ID:                    dw 26
.Image16_Type:                  db 10   ;*ImageBox
.Image16_ExtDataBank:           db 255
.Image16_GrInfoAddr:            dw Sheet_Data4
.Image16_Left:                  dw 131
.Image16_Top:                   dw 12
.Image16_Width:                 dw 3
.Image16_Height:                dw 10
.Image16_Code:                  dw QFunc_Image_Event
.Image17_Display      Equ 27
.Image17
.Image17_ID:                    dw 27
.Image17_Type:                  db 10   ;*ImageBox
.Image17_ExtDataBank:           db 255
.Image17_GrInfoAddr:            dw Sheet_Data4
.Image17_Left:                  dw 135
.Image17_Top:                   dw 11
.Image17_Width:                 dw 12
.Image17_Height:                dw 12
.Image17_Code:                  dw 0
.Image18_Display      Equ 28
.Image18
.Image18_ID:                    dw 28
.Image18_Type:                  db 10   ;*ImageBox
.Image18_ExtDataBank:           db 255
.Image18_GrInfoAddr:            dw Sheet_Data4
.Image18_Left:                  dw 148
.Image18_Top:                   dw 12
.Image18_Width:                 dw 3
.Image18_Height:                dw 10
.Image18_Code:                  dw QFunc_Image_Event
.Image19_Display      Equ 29
.Image19
.Image19_ID:                    dw 29
.Image19_Type:                  db 10   ;*ImageBox
.Image19_ExtDataBank:           db 255
.Image19_GrInfoAddr:            dw Sheet_Data4
.Image19_Left:                  dw 152
.Image19_Top:                   dw 11
.Image19_Width:                 dw 12
.Image19_Height:                dw 12
.Image19_Code:                  dw 0
.Image20_Display      Equ 30
.Image20
.Image20_ID:                    dw 30
.Image20_Type:                  db 10   ;*ImageBox
.Image20_ExtDataBank:           db 255
.Image20_GrInfoAddr:            dw Sheet_Data4
.Image20_Left:                  dw 165
.Image20_Top:                   dw 12
.Image20_Width:                 dw 3
.Image20_Height:                dw 10
.Image20_Code:                  dw QFunc_Image_Event
.Image21_Display      Equ 31
.Image21
.Image21_ID:                    dw 31
.Image21_Type:                  db 10   ;*ImageBox
.Image21_ExtDataBank:           db 255
.Image21_GrInfoAddr:            dw Sheet_Data4
.Image21_Left:                  dw 169
.Image21_Top:                   dw 11
.Image21_Width:                 dw 12
.Image21_Height:                dw 12
.Image21_Code:                  dw 0
.Image22_Display      Equ 32
.Image22
.Image22_ID:                    dw 32
.Image22_Type:                  db 10   ;*ImageBox
.Image22_ExtDataBank:           db 255
.Image22_GrInfoAddr:            dw Sheet_Data4
.Image22_Left:                  dw 182
.Image22_Top:                   dw 12
.Image22_Width:                 dw 3
.Image22_Height:                dw 10
.Image22_Code:                  dw QFunc_Image_Event
.Image23_Display      Equ 33
.Image23
.Image23_ID:                    dw 33
.Image23_Type:                  db 10   ;*ImageBox
.Image23_ExtDataBank:           db 255
.Image23_GrInfoAddr:            dw Sheet_Data4
.Image23_Left:                  dw 95
.Image23_Top:                   dw 22
.Image23_Width:                 dw 7
.Image23_Height:                dw 7
.Image23_Code:                  dw 0
.Image24_Display      Equ 34
.Image24
.Image24_ID:                    dw 34
.Image24_Type:                  db 10   ;*ImageBox
.Image24_ExtDataBank:           db 255
.Image24_GrInfoAddr:            dw Sheet_Data4
.Image24_Left:                  dw 102
.Image24_Top:                   dw 24
.Image24_Width:                 dw 10
.Image24_Height:                dw 3
.Image24_Code:                  dw QFunc_Image_Event
.Image25_Display      Equ 35
.Image25
.Image25_ID:                    dw 35
.Image25_Type:                  db 10   ;*ImageBox
.Image25_ExtDataBank:           db 255
.Image25_GrInfoAddr:            dw Sheet_Data4
.Image25_Left:                  dw 112
.Image25_Top:                   dw 22
.Image25_Width:                 dw 7
.Image25_Height:                dw 7
.Image25_Code:                  dw 0
.Image26_Display      Equ 36
.Image26
.Image26_ID:                    dw 36
.Image26_Type:                  db 10   ;*ImageBox
.Image26_ExtDataBank:           db 255
.Image26_GrInfoAddr:            dw Sheet_Data4
.Image26_Left:                  dw 119
.Image26_Top:                   dw 24
.Image26_Width:                 dw 10
.Image26_Height:                dw 3
.Image26_Code:                  dw QFunc_Image_Event
.Image27_Display      Equ 37
.Image27
.Image27_ID:                    dw 37
.Image27_Type:                  db 10   ;*ImageBox
.Image27_ExtDataBank:           db 255
.Image27_GrInfoAddr:            dw Sheet_Data4
.Image27_Left:                  dw 129
.Image27_Top:                   dw 22
.Image27_Width:                 dw 7
.Image27_Height:                dw 7
.Image27_Code:                  dw 0
.Image28_Display      Equ 38
.Image28
.Image28_ID:                    dw 38
.Image28_Type:                  db 10   ;*ImageBox
.Image28_ExtDataBank:           db 255
.Image28_GrInfoAddr:            dw Sheet_Data4
.Image28_Left:                  dw 136
.Image28_Top:                   dw 24
.Image28_Width:                 dw 10
.Image28_Height:                dw 3
.Image28_Code:                  dw QFunc_Image_Event
.Image29_Display      Equ 39
.Image29
.Image29_ID:                    dw 39
.Image29_Type:                  db 10   ;*ImageBox
.Image29_ExtDataBank:           db 255
.Image29_GrInfoAddr:            dw Sheet_Data4
.Image29_Left:                  dw 146
.Image29_Top:                   dw 22
.Image29_Width:                 dw 7
.Image29_Height:                dw 7
.Image29_Code:                  dw 0
.Image30_Display      Equ 40
.Image30
.Image30_ID:                    dw 40
.Image30_Type:                  db 10   ;*ImageBox
.Image30_ExtDataBank:           db 255
.Image30_GrInfoAddr:            dw Sheet_Data4
.Image30_Left:                  dw 153
.Image30_Top:                   dw 24
.Image30_Width:                 dw 10
.Image30_Height:                dw 3
.Image30_Code:                  dw QFunc_Image_Event
.Image31_Display      Equ 41
.Image31
.Image31_ID:                    dw 41
.Image31_Type:                  db 10   ;*ImageBox
.Image31_ExtDataBank:           db 255
.Image31_GrInfoAddr:            dw Sheet_Data4
.Image31_Left:                  dw 163
.Image31_Top:                   dw 22
.Image31_Width:                 dw 7
.Image31_Height:                dw 7
.Image31_Code:                  dw 0
.Image32_Display      Equ 42
.Image32
.Image32_ID:                    dw 42
.Image32_Type:                  db 10   ;*ImageBox
.Image32_ExtDataBank:           db 255
.Image32_GrInfoAddr:            dw Sheet_Data4
.Image32_Left:                  dw 170
.Image32_Top:                   dw 24
.Image32_Width:                 dw 10
.Image32_Height:                dw 3
.Image32_Code:                  dw QFunc_Image_Event
.Image33_Display      Equ 43
.Image33
.Image33_ID:                    dw 43
.Image33_Type:                  db 10   ;*ImageBox
.Image33_ExtDataBank:           db 255
.Image33_GrInfoAddr:            dw Sheet_Data4
.Image33_Left:                  dw 180
.Image33_Top:                   dw 22
.Image33_Width:                 dw 7
.Image33_Height:                dw 7
.Image33_Code:                  dw 0
.Image34_Display      Equ 44
.Image34
.Image34_ID:                    dw 44
.Image34_Type:                  db 10   ;*ImageBox
.Image34_ExtDataBank:           db 255
.Image34_GrInfoAddr:            dw Sheet_Data4
.Image34_Left:                  dw 97
.Image34_Top:                   dw 29
.Image34_Width:                 dw 3
.Image34_Height:                dw 10
.Image34_Code:                  dw QFunc_Image_Event
.Image45_Display      Equ 45
.Image45
.Image45_ID:                    dw 45
.Image45_Type:                  db 10   ;*ImageBox
.Image45_ExtDataBank:           db 255
.Image45_GrInfoAddr:            dw Sheet_Data4
.Image45_Left:                  dw 95
.Image45_Top:                   dw 39
.Image45_Width:                 dw 7
.Image45_Height:                dw 7
.Image45_Code:                  dw 0
.Image46_Display      Equ 46
.Image46
.Image46_ID:                    dw 46
.Image46_Type:                  db 10   ;*ImageBox
.Image46_ExtDataBank:           db 255
.Image46_GrInfoAddr:            dw Sheet_Data4
.Image46_Left:                  dw 102
.Image46_Top:                   dw 41
.Image46_Width:                 dw 10
.Image46_Height:                dw 3
.Image46_Code:                  dw QFunc_Image_Event
.Image47_Display      Equ 47
.Image47
.Image47_ID:                    dw 47
.Image47_Type:                  db 10   ;*ImageBox
.Image47_ExtDataBank:           db 255
.Image47_GrInfoAddr:            dw Sheet_Data4
.Image47_Left:                  dw 112
.Image47_Top:                   dw 39
.Image47_Width:                 dw 7
.Image47_Height:                dw 7
.Image47_Code:                  dw 0
.Image36_Display      Equ 48
.Image36
.Image36_ID:                    dw 48
.Image36_Type:                  db 10   ;*ImageBox
.Image36_ExtDataBank:           db 255
.Image36_GrInfoAddr:            dw Sheet_Data4
.Image36_Left:                  dw 114
.Image36_Top:                   dw 29
.Image36_Width:                 dw 3
.Image36_Height:                dw 10
.Image36_Code:                  dw QFunc_Image_Event
.Image48_Display      Equ 49
.Image48
.Image48_ID:                    dw 49
.Image48_Type:                  db 10   ;*ImageBox
.Image48_ExtDataBank:           db 255
.Image48_GrInfoAddr:            dw Sheet_Data4
.Image48_Left:                  dw 119
.Image48_Top:                   dw 41
.Image48_Width:                 dw 10
.Image48_Height:                dw 3
.Image48_Code:                  dw QFunc_Image_Event
.Image49_Display      Equ 50
.Image49
.Image49_ID:                    dw 50
.Image49_Type:                  db 10   ;*ImageBox
.Image49_ExtDataBank:           db 255
.Image49_GrInfoAddr:            dw Sheet_Data4
.Image49_Left:                  dw 129
.Image49_Top:                   dw 39
.Image49_Width:                 dw 7
.Image49_Height:                dw 7
.Image49_Code:                  dw 0
.Image38_Display      Equ 51
.Image38
.Image38_ID:                    dw 51
.Image38_Type:                  db 10   ;*ImageBox
.Image38_ExtDataBank:           db 255
.Image38_GrInfoAddr:            dw Sheet_Data4
.Image38_Left:                  dw 131
.Image38_Top:                   dw 29
.Image38_Width:                 dw 3
.Image38_Height:                dw 10
.Image38_Code:                  dw QFunc_Image_Event
.Image50_Display      Equ 52
.Image50
.Image50_ID:                    dw 52
.Image50_Type:                  db 10   ;*ImageBox
.Image50_ExtDataBank:           db 255
.Image50_GrInfoAddr:            dw Sheet_Data4
.Image50_Left:                  dw 136
.Image50_Top:                   dw 41
.Image50_Width:                 dw 10
.Image50_Height:                dw 3
.Image50_Code:                  dw QFunc_Image_Event
.Image51_Display      Equ 53
.Image51
.Image51_ID:                    dw 53
.Image51_Type:                  db 10   ;*ImageBox
.Image51_ExtDataBank:           db 255
.Image51_GrInfoAddr:            dw Sheet_Data4
.Image51_Left:                  dw 146
.Image51_Top:                   dw 39
.Image51_Width:                 dw 7
.Image51_Height:                dw 7
.Image51_Code:                  dw 0
.Image40_Display      Equ 54
.Image40
.Image40_ID:                    dw 54
.Image40_Type:                  db 10   ;*ImageBox
.Image40_ExtDataBank:           db 255
.Image40_GrInfoAddr:            dw Sheet_Data4
.Image40_Left:                  dw 148
.Image40_Top:                   dw 29
.Image40_Width:                 dw 3
.Image40_Height:                dw 10
.Image40_Code:                  dw QFunc_Image_Event
.Image52_Display      Equ 55
.Image52
.Image52_ID:                    dw 55
.Image52_Type:                  db 10   ;*ImageBox
.Image52_ExtDataBank:           db 255
.Image52_GrInfoAddr:            dw Sheet_Data4
.Image52_Left:                  dw 153
.Image52_Top:                   dw 41
.Image52_Width:                 dw 10
.Image52_Height:                dw 3
.Image52_Code:                  dw QFunc_Image_Event
.Image53_Display      Equ 56
.Image53
.Image53_ID:                    dw 56
.Image53_Type:                  db 10   ;*ImageBox
.Image53_ExtDataBank:           db 255
.Image53_GrInfoAddr:            dw Sheet_Data4
.Image53_Left:                  dw 163
.Image53_Top:                   dw 39
.Image53_Width:                 dw 7
.Image53_Height:                dw 7
.Image53_Code:                  dw 0
.Image42_Display      Equ 57
.Image42
.Image42_ID:                    dw 57
.Image42_Type:                  db 10   ;*ImageBox
.Image42_ExtDataBank:           db 255
.Image42_GrInfoAddr:            dw Sheet_Data4
.Image42_Left:                  dw 165
.Image42_Top:                   dw 29
.Image42_Width:                 dw 3
.Image42_Height:                dw 10
.Image42_Code:                  dw QFunc_Image_Event
.Image54_Display      Equ 58
.Image54
.Image54_ID:                    dw 58
.Image54_Type:                  db 10   ;*ImageBox
.Image54_ExtDataBank:           db 255
.Image54_GrInfoAddr:            dw Sheet_Data4
.Image54_Left:                  dw 170
.Image54_Top:                   dw 41
.Image54_Width:                 dw 10
.Image54_Height:                dw 3
.Image54_Code:                  dw QFunc_Image_Event
.Image55_Display      Equ 59
.Image55
.Image55_ID:                    dw 59
.Image55_Type:                  db 10   ;*ImageBox
.Image55_ExtDataBank:           db 255
.Image55_GrInfoAddr:            dw Sheet_Data4
.Image55_Left:                  dw 180
.Image55_Top:                   dw 39
.Image55_Width:                 dw 7
.Image55_Height:                dw 7
.Image55_Code:                  dw 0
.Image44_Display      Equ 60
.Image44
.Image44_ID:                    dw 60
.Image44_Type:                  db 10   ;*ImageBox
.Image44_ExtDataBank:           db 255
.Image44_GrInfoAddr:            dw Sheet_Data4
.Image44_Left:                  dw 182
.Image44_Top:                   dw 29
.Image44_Width:                 dw 3
.Image44_Height:                dw 10
.Image44_Code:                  dw QFunc_Image_Event
.Image35_Display      Equ 61
.Image35
.Image35_ID:                    dw 61
.Image35_Type:                  db 10   ;*ImageBox
.Image35_ExtDataBank:           db 255
.Image35_GrInfoAddr:            dw Sheet_Data4
.Image35_Left:                  dw 101
.Image35_Top:                   dw 28
.Image35_Width:                 dw 12
.Image35_Height:                dw 12
.Image35_Code:                  dw 0
.Image37_Display      Equ 62
.Image37
.Image37_ID:                    dw 62
.Image37_Type:                  db 10   ;*ImageBox
.Image37_ExtDataBank:           db 255
.Image37_GrInfoAddr:            dw Sheet_Data4
.Image37_Left:                  dw 118
.Image37_Top:                   dw 28
.Image37_Width:                 dw 12
.Image37_Height:                dw 12
.Image37_Code:                  dw 0
.Image39_Display      Equ 63
.Image39
.Image39_ID:                    dw 63
.Image39_Type:                  db 10   ;*ImageBox
.Image39_ExtDataBank:           db 255
.Image39_GrInfoAddr:            dw Sheet_Data4
.Image39_Left:                  dw 135
.Image39_Top:                   dw 28
.Image39_Width:                 dw 12
.Image39_Height:                dw 12
.Image39_Code:                  dw 0
.Image41_Display      Equ 64
.Image41
.Image41_ID:                    dw 64
.Image41_Type:                  db 10   ;*ImageBox
.Image41_ExtDataBank:           db 255
.Image41_GrInfoAddr:            dw Sheet_Data4
.Image41_Left:                  dw 152
.Image41_Top:                   dw 28
.Image41_Width:                 dw 12
.Image41_Height:                dw 12
.Image41_Code:                  dw 0
.Image43_Display      Equ 65
.Image43
.Image43_ID:                    dw 65
.Image43_Type:                  db 10   ;*ImageBox
.Image43_ExtDataBank:           db 255
.Image43_GrInfoAddr:            dw Sheet_Data4
.Image43_Left:                  dw 169
.Image43_Top:                   dw 28
.Image43_Width:                 dw 12
.Image43_Height:                dw 12
.Image43_Code:                  dw 0
.Image56_Display      Equ 66
.Image56
.Image56_ID:                    dw 66
.Image56_Type:                  db 10   ;*ImageBox
.Image56_ExtDataBank:           db 255
.Image56_GrInfoAddr:            dw Sheet_Data4
.Image56_Left:                  dw 97
.Image56_Top:                   dw 46
.Image56_Width:                 dw 3
.Image56_Height:                dw 10
.Image56_Code:                  dw QFunc_Image_Event
.Image67_Display      Equ 67
.Image67
.Image67_ID:                    dw 67
.Image67_Type:                  db 10   ;*ImageBox
.Image67_ExtDataBank:           db 255
.Image67_GrInfoAddr:            dw Sheet_Data4
.Image67_Left:                  dw 95
.Image67_Top:                   dw 56
.Image67_Width:                 dw 7
.Image67_Height:                dw 7
.Image67_Code:                  dw 0
.Image68_Display      Equ 68
.Image68
.Image68_ID:                    dw 68
.Image68_Type:                  db 10   ;*ImageBox
.Image68_ExtDataBank:           db 255
.Image68_GrInfoAddr:            dw Sheet_Data4
.Image68_Left:                  dw 102
.Image68_Top:                   dw 58
.Image68_Width:                 dw 10
.Image68_Height:                dw 3
.Image68_Code:                  dw QFunc_Image_Event
.Image69_Display      Equ 69
.Image69
.Image69_ID:                    dw 69
.Image69_Type:                  db 10   ;*ImageBox
.Image69_ExtDataBank:           db 255
.Image69_GrInfoAddr:            dw Sheet_Data4
.Image69_Left:                  dw 112
.Image69_Top:                   dw 56
.Image69_Width:                 dw 7
.Image69_Height:                dw 7
.Image69_Code:                  dw 0
.Image58_Display      Equ 70
.Image58
.Image58_ID:                    dw 70
.Image58_Type:                  db 10   ;*ImageBox
.Image58_ExtDataBank:           db 255
.Image58_GrInfoAddr:            dw Sheet_Data4
.Image58_Left:                  dw 114
.Image58_Top:                   dw 46
.Image58_Width:                 dw 3
.Image58_Height:                dw 10
.Image58_Code:                  dw QFunc_Image_Event
.Image70_Display      Equ 71
.Image70
.Image70_ID:                    dw 71
.Image70_Type:                  db 10   ;*ImageBox
.Image70_ExtDataBank:           db 255
.Image70_GrInfoAddr:            dw Sheet_Data4
.Image70_Left:                  dw 119
.Image70_Top:                   dw 58
.Image70_Width:                 dw 10
.Image70_Height:                dw 3
.Image70_Code:                  dw QFunc_Image_Event
.Image71_Display      Equ 72
.Image71
.Image71_ID:                    dw 72
.Image71_Type:                  db 10   ;*ImageBox
.Image71_ExtDataBank:           db 255
.Image71_GrInfoAddr:            dw Sheet_Data4
.Image71_Left:                  dw 129
.Image71_Top:                   dw 56
.Image71_Width:                 dw 7
.Image71_Height:                dw 7
.Image71_Code:                  dw 0
.Image60_Display      Equ 73
.Image60
.Image60_ID:                    dw 73
.Image60_Type:                  db 10   ;*ImageBox
.Image60_ExtDataBank:           db 255
.Image60_GrInfoAddr:            dw Sheet_Data4
.Image60_Left:                  dw 131
.Image60_Top:                   dw 46
.Image60_Width:                 dw 3
.Image60_Height:                dw 10
.Image60_Code:                  dw QFunc_Image_Event
.Image72_Display      Equ 74
.Image72
.Image72_ID:                    dw 74
.Image72_Type:                  db 10   ;*ImageBox
.Image72_ExtDataBank:           db 255
.Image72_GrInfoAddr:            dw Sheet_Data4
.Image72_Left:                  dw 136
.Image72_Top:                   dw 58
.Image72_Width:                 dw 10
.Image72_Height:                dw 3
.Image72_Code:                  dw QFunc_Image_Event
.Image73_Display      Equ 75
.Image73
.Image73_ID:                    dw 75
.Image73_Type:                  db 10   ;*ImageBox
.Image73_ExtDataBank:           db 255
.Image73_GrInfoAddr:            dw Sheet_Data4
.Image73_Left:                  dw 146
.Image73_Top:                   dw 56
.Image73_Width:                 dw 7
.Image73_Height:                dw 7
.Image73_Code:                  dw 0
.Image62_Display      Equ 76
.Image62
.Image62_ID:                    dw 76
.Image62_Type:                  db 10   ;*ImageBox
.Image62_ExtDataBank:           db 255
.Image62_GrInfoAddr:            dw Sheet_Data4
.Image62_Left:                  dw 148
.Image62_Top:                   dw 46
.Image62_Width:                 dw 3
.Image62_Height:                dw 10
.Image62_Code:                  dw QFunc_Image_Event
.Image74_Display      Equ 77
.Image74
.Image74_ID:                    dw 77
.Image74_Type:                  db 10   ;*ImageBox
.Image74_ExtDataBank:           db 255
.Image74_GrInfoAddr:            dw Sheet_Data4
.Image74_Left:                  dw 153
.Image74_Top:                   dw 58
.Image74_Width:                 dw 10
.Image74_Height:                dw 3
.Image74_Code:                  dw QFunc_Image_Event
.Image75_Display      Equ 78
.Image75
.Image75_ID:                    dw 78
.Image75_Type:                  db 10   ;*ImageBox
.Image75_ExtDataBank:           db 255
.Image75_GrInfoAddr:            dw Sheet_Data4
.Image75_Left:                  dw 163
.Image75_Top:                   dw 56
.Image75_Width:                 dw 7
.Image75_Height:                dw 7
.Image75_Code:                  dw 0
.Image64_Display      Equ 79
.Image64
.Image64_ID:                    dw 79
.Image64_Type:                  db 10   ;*ImageBox
.Image64_ExtDataBank:           db 255
.Image64_GrInfoAddr:            dw Sheet_Data4
.Image64_Left:                  dw 165
.Image64_Top:                   dw 46
.Image64_Width:                 dw 3
.Image64_Height:                dw 10
.Image64_Code:                  dw QFunc_Image_Event
.Image76_Display      Equ 80
.Image76
.Image76_ID:                    dw 80
.Image76_Type:                  db 10   ;*ImageBox
.Image76_ExtDataBank:           db 255
.Image76_GrInfoAddr:            dw Sheet_Data4
.Image76_Left:                  dw 170
.Image76_Top:                   dw 58
.Image76_Width:                 dw 10
.Image76_Height:                dw 3
.Image76_Code:                  dw QFunc_Image_Event
.Image77_Display      Equ 81
.Image77
.Image77_ID:                    dw 81
.Image77_Type:                  db 10   ;*ImageBox
.Image77_ExtDataBank:           db 255
.Image77_GrInfoAddr:            dw Sheet_Data4
.Image77_Left:                  dw 180
.Image77_Top:                   dw 56
.Image77_Width:                 dw 7
.Image77_Height:                dw 7
.Image77_Code:                  dw 0
.Image66_Display      Equ 82
.Image66
.Image66_ID:                    dw 82
.Image66_Type:                  db 10   ;*ImageBox
.Image66_ExtDataBank:           db 255
.Image66_GrInfoAddr:            dw Sheet_Data4
.Image66_Left:                  dw 182
.Image66_Top:                   dw 46
.Image66_Width:                 dw 3
.Image66_Height:                dw 10
.Image66_Code:                  dw QFunc_Image_Event
.Image57_Display      Equ 83
.Image57
.Image57_ID:                    dw 83
.Image57_Type:                  db 10   ;*ImageBox
.Image57_ExtDataBank:           db 255
.Image57_GrInfoAddr:            dw Sheet_Data4
.Image57_Left:                  dw 101
.Image57_Top:                   dw 45
.Image57_Width:                 dw 12
.Image57_Height:                dw 12
.Image57_Code:                  dw 0
.Image59_Display      Equ 84
.Image59
.Image59_ID:                    dw 84
.Image59_Type:                  db 10   ;*ImageBox
.Image59_ExtDataBank:           db 255
.Image59_GrInfoAddr:            dw Sheet_Data4
.Image59_Left:                  dw 118
.Image59_Top:                   dw 45
.Image59_Width:                 dw 12
.Image59_Height:                dw 12
.Image59_Code:                  dw 0
.Image61_Display      Equ 85
.Image61
.Image61_ID:                    dw 85
.Image61_Type:                  db 10   ;*ImageBox
.Image61_ExtDataBank:           db 255
.Image61_GrInfoAddr:            dw Sheet_Data4
.Image61_Left:                  dw 135
.Image61_Top:                   dw 45
.Image61_Width:                 dw 12
.Image61_Height:                dw 12
.Image61_Code:                  dw 0
.Image63_Display      Equ 86
.Image63
.Image63_ID:                    dw 86
.Image63_Type:                  db 10   ;*ImageBox
.Image63_ExtDataBank:           db 255
.Image63_GrInfoAddr:            dw Sheet_Data4
.Image63_Left:                  dw 152
.Image63_Top:                   dw 45
.Image63_Width:                 dw 12
.Image63_Height:                dw 12
.Image63_Code:                  dw 0
.Image65_Display      Equ 87
.Image65
.Image65_ID:                    dw 87
.Image65_Type:                  db 10   ;*ImageBox
.Image65_ExtDataBank:           db 255
.Image65_GrInfoAddr:            dw Sheet_Data4
.Image65_Left:                  dw 169
.Image65_Top:                   dw 45
.Image65_Width:                 dw 12
.Image65_Height:                dw 12
.Image65_Code:                  dw 0
.Image78_Display      Equ 88
.Image78
.Image78_ID:                    dw 88
.Image78_Type:                  db 10   ;*ImageBox
.Image78_ExtDataBank:           db 255
.Image78_GrInfoAddr:            dw Sheet_Data4
.Image78_Left:                  dw 97
.Image78_Top:                   dw 63
.Image78_Width:                 dw 3
.Image78_Height:                dw 10
.Image78_Code:                  dw QFunc_Image_Event
.Image79_Display      Equ 89
.Image79
.Image79_ID:                    dw 89
.Image79_Type:                  db 10   ;*ImageBox
.Image79_ExtDataBank:           db 255
.Image79_GrInfoAddr:            dw Sheet_Data4
.Image79_Left:                  dw 101
.Image79_Top:                   dw 62
.Image79_Width:                 dw 12
.Image79_Height:                dw 12
.Image79_Code:                  dw QFunc_Image_Event
.Image80_Display      Equ 90
.Image80
.Image80_ID:                    dw 90
.Image80_Type:                  db 10   ;*ImageBox
.Image80_ExtDataBank:           db 255
.Image80_GrInfoAddr:            dw Sheet_Data4
.Image80_Left:                  dw 114
.Image80_Top:                   dw 63
.Image80_Width:                 dw 3
.Image80_Height:                dw 10
.Image80_Code:                  dw QFunc_Image_Event
.Image81_Display      Equ 91
.Image81
.Image81_ID:                    dw 91
.Image81_Type:                  db 10   ;*ImageBox
.Image81_ExtDataBank:           db 255
.Image81_GrInfoAddr:            dw Sheet_Data4
.Image81_Left:                  dw 118
.Image81_Top:                   dw 62
.Image81_Width:                 dw 12
.Image81_Height:                dw 12
.Image81_Code:                  dw 0
.Image82_Display      Equ 92
.Image82
.Image82_ID:                    dw 92
.Image82_Type:                  db 10   ;*ImageBox
.Image82_ExtDataBank:           db 255
.Image82_GrInfoAddr:            dw Sheet_Data4
.Image82_Left:                  dw 131
.Image82_Top:                   dw 63
.Image82_Width:                 dw 3
.Image82_Height:                dw 10
.Image82_Code:                  dw QFunc_Image_Event
.Image83_Display      Equ 93
.Image83
.Image83_ID:                    dw 93
.Image83_Type:                  db 10   ;*ImageBox
.Image83_ExtDataBank:           db 255
.Image83_GrInfoAddr:            dw Sheet_Data4
.Image83_Left:                  dw 135
.Image83_Top:                   dw 62
.Image83_Width:                 dw 12
.Image83_Height:                dw 12
.Image83_Code:                  dw 0
.Image84_Display      Equ 94
.Image84
.Image84_ID:                    dw 94
.Image84_Type:                  db 10   ;*ImageBox
.Image84_ExtDataBank:           db 255
.Image84_GrInfoAddr:            dw Sheet_Data4
.Image84_Left:                  dw 148
.Image84_Top:                   dw 63
.Image84_Width:                 dw 3
.Image84_Height:                dw 10
.Image84_Code:                  dw QFunc_Image_Event
.Image85_Display      Equ 95
.Image85
.Image85_ID:                    dw 95
.Image85_Type:                  db 10   ;*ImageBox
.Image85_ExtDataBank:           db 255
.Image85_GrInfoAddr:            dw Sheet_Data4
.Image85_Left:                  dw 152
.Image85_Top:                   dw 62
.Image85_Width:                 dw 12
.Image85_Height:                dw 12
.Image85_Code:                  dw 0
.Image86_Display      Equ 96
.Image86
.Image86_ID:                    dw 96
.Image86_Type:                  db 10   ;*ImageBox
.Image86_ExtDataBank:           db 255
.Image86_GrInfoAddr:            dw Sheet_Data4
.Image86_Left:                  dw 165
.Image86_Top:                   dw 63
.Image86_Width:                 dw 3
.Image86_Height:                dw 10
.Image86_Code:                  dw QFunc_Image_Event
.Image87_Display      Equ 97
.Image87
.Image87_ID:                    dw 97
.Image87_Type:                  db 10   ;*ImageBox
.Image87_ExtDataBank:           db 255
.Image87_GrInfoAddr:            dw Sheet_Data4
.Image87_Left:                  dw 169
.Image87_Top:                   dw 62
.Image87_Width:                 dw 12
.Image87_Height:                dw 12
.Image87_Code:                  dw 0
.Image88_Display      Equ 98
.Image88
.Image88_ID:                    dw 98
.Image88_Type:                  db 10   ;*ImageBox
.Image88_ExtDataBank:           db 255
.Image88_GrInfoAddr:            dw Sheet_Data4
.Image88_Left:                  dw 182
.Image88_Top:                   dw 63
.Image88_Width:                 dw 3
.Image88_Height:                dw 10
.Image88_Code:                  dw QFunc_Image_Event
.Image89_Display      Equ 99
.Image89
.Image89_ID:                    dw 99
.Image89_Type:                  db 10   ;*ImageBox
.Image89_ExtDataBank:           db 255
.Image89_GrInfoAddr:            dw Sheet_Data4
.Image89_Left:                  dw 95
.Image89_Top:                   dw 73
.Image89_Width:                 dw 7
.Image89_Height:                dw 7
.Image89_Code:                  dw 0
.Image90_Display      Equ 100
.Image90
.Image90_ID:                    dw 100
.Image90_Type:                  db 10   ;*ImageBox
.Image90_ExtDataBank:           db 255
.Image90_GrInfoAddr:            dw Sheet_Data4
.Image90_Left:                  dw 102
.Image90_Top:                   dw 75
.Image90_Width:                 dw 10
.Image90_Height:                dw 3
.Image90_Code:                  dw QFunc_Image_Event
.Image91_Display      Equ 101
.Image91
.Image91_ID:                    dw 101
.Image91_Type:                  db 10   ;*ImageBox
.Image91_ExtDataBank:           db 255
.Image91_GrInfoAddr:            dw Sheet_Data4
.Image91_Left:                  dw 112
.Image91_Top:                   dw 73
.Image91_Width:                 dw 7
.Image91_Height:                dw 7
.Image91_Code:                  dw 0
.Image92_Display      Equ 102
.Image92
.Image92_ID:                    dw 102
.Image92_Type:                  db 10   ;*ImageBox
.Image92_ExtDataBank:           db 255
.Image92_GrInfoAddr:            dw Sheet_Data4
.Image92_Left:                  dw 119
.Image92_Top:                   dw 75
.Image92_Width:                 dw 10
.Image92_Height:                dw 3
.Image92_Code:                  dw QFunc_Image_Event
.Image93_Display      Equ 103
.Image93
.Image93_ID:                    dw 103
.Image93_Type:                  db 10   ;*ImageBox
.Image93_ExtDataBank:           db 255
.Image93_GrInfoAddr:            dw Sheet_Data4
.Image93_Left:                  dw 129
.Image93_Top:                   dw 73
.Image93_Width:                 dw 7
.Image93_Height:                dw 7
.Image93_Code:                  dw 0
.Image94_Display      Equ 104
.Image94
.Image94_ID:                    dw 104
.Image94_Type:                  db 10   ;*ImageBox
.Image94_ExtDataBank:           db 255
.Image94_GrInfoAddr:            dw Sheet_Data4
.Image94_Left:                  dw 136
.Image94_Top:                   dw 75
.Image94_Width:                 dw 10
.Image94_Height:                dw 3
.Image94_Code:                  dw QFunc_Image_Event
.Image95_Display      Equ 105
.Image95
.Image95_ID:                    dw 105
.Image95_Type:                  db 10   ;*ImageBox
.Image95_ExtDataBank:           db 255
.Image95_GrInfoAddr:            dw Sheet_Data4
.Image95_Left:                  dw 146
.Image95_Top:                   dw 73
.Image95_Width:                 dw 7
.Image95_Height:                dw 7
.Image95_Code:                  dw 0
.Image96_Display      Equ 106
.Image96
.Image96_ID:                    dw 106
.Image96_Type:                  db 10   ;*ImageBox
.Image96_ExtDataBank:           db 255
.Image96_GrInfoAddr:            dw Sheet_Data4
.Image96_Left:                  dw 153
.Image96_Top:                   dw 75
.Image96_Width:                 dw 10
.Image96_Height:                dw 3
.Image96_Code:                  dw QFunc_Image_Event
.Image97_Display      Equ 107
.Image97
.Image97_ID:                    dw 107
.Image97_Type:                  db 10   ;*ImageBox
.Image97_ExtDataBank:           db 255
.Image97_GrInfoAddr:            dw Sheet_Data4
.Image97_Left:                  dw 163
.Image97_Top:                   dw 73
.Image97_Width:                 dw 7
.Image97_Height:                dw 7
.Image97_Code:                  dw 0
.Image98_Display      Equ 108
.Image98
.Image98_ID:                    dw 108
.Image98_Type:                  db 10   ;*ImageBox
.Image98_ExtDataBank:           db 255
.Image98_GrInfoAddr:            dw Sheet_Data4
.Image98_Left:                  dw 170
.Image98_Top:                   dw 75
.Image98_Width:                 dw 10
.Image98_Height:                dw 3
.Image98_Code:                  dw QFunc_Image_Event
.Image99_Display      Equ 109
.Image99
.Image99_ID:                    dw 109
.Image99_Type:                  db 10   ;*ImageBox
.Image99_ExtDataBank:           db 255
.Image99_GrInfoAddr:            dw Sheet_Data4
.Image99_Left:                  dw 180
.Image99_Top:                   dw 73
.Image99_Width:                 dw 7
.Image99_Height:                dw 7
.Image99_Code:                  dw 0
.Image100_Display      Equ 110
.Image100
.Image100_ID:                   dw 110
.Image100_Type:                 db 10   ;*ImageBox
.Image100_ExtDataBank:          db 255
.Image100_GrInfoAddr:           dw Sheet_Data4
.Image100_Left:                 dw 97
.Image100_Top:                  dw 80
.Image100_Width:                dw 3
.Image100_Height:               dw 10
.Image100_Code:                 dw QFunc_Image_Event
.Image101_Display      Equ 111
.Image101
.Image101_ID:                   dw 111
.Image101_Type:                 db 10   ;*ImageBox
.Image101_ExtDataBank:          db 255
.Image101_GrInfoAddr:           dw Sheet_Data4
.Image101_Left:                 dw 101
.Image101_Top:                  dw 79
.Image101_Width:                dw 12
.Image101_Height:               dw 12
.Image101_Code:                 dw 0
.Image102_Display      Equ 112
.Image102
.Image102_ID:                   dw 112
.Image102_Type:                 db 10   ;*ImageBox
.Image102_ExtDataBank:          db 255
.Image102_GrInfoAddr:           dw Sheet_Data4
.Image102_Left:                 dw 114
.Image102_Top:                  dw 80
.Image102_Width:                dw 3
.Image102_Height:               dw 10
.Image102_Code:                 dw QFunc_Image_Event
.Image103_Display      Equ 113
.Image103
.Image103_ID:                   dw 113
.Image103_Type:                 db 10   ;*ImageBox
.Image103_ExtDataBank:          db 255
.Image103_GrInfoAddr:           dw Sheet_Data4
.Image103_Left:                 dw 118
.Image103_Top:                  dw 79
.Image103_Width:                dw 12
.Image103_Height:               dw 12
.Image103_Code:                 dw 0
.Image104_Display      Equ 114
.Image104
.Image104_ID:                   dw 114
.Image104_Type:                 db 10   ;*ImageBox
.Image104_ExtDataBank:          db 255
.Image104_GrInfoAddr:           dw Sheet_Data4
.Image104_Left:                 dw 131
.Image104_Top:                  dw 80
.Image104_Width:                dw 3
.Image104_Height:               dw 10
.Image104_Code:                 dw QFunc_Image_Event
.Image105_Display      Equ 115
.Image105
.Image105_ID:                   dw 115
.Image105_Type:                 db 10   ;*ImageBox
.Image105_ExtDataBank:          db 255
.Image105_GrInfoAddr:           dw Sheet_Data4
.Image105_Left:                 dw 135
.Image105_Top:                  dw 79
.Image105_Width:                dw 12
.Image105_Height:               dw 12
.Image105_Code:                 dw 0
.Image106_Display      Equ 116
.Image106
.Image106_ID:                   dw 116
.Image106_Type:                 db 10   ;*ImageBox
.Image106_ExtDataBank:          db 255
.Image106_GrInfoAddr:           dw Sheet_Data4
.Image106_Left:                 dw 148
.Image106_Top:                  dw 80
.Image106_Width:                dw 3
.Image106_Height:               dw 10
.Image106_Code:                 dw QFunc_Image_Event
.Image107_Display      Equ 117
.Image107
.Image107_ID:                   dw 117
.Image107_Type:                 db 10   ;*ImageBox
.Image107_ExtDataBank:          db 255
.Image107_GrInfoAddr:           dw Sheet_Data4
.Image107_Left:                 dw 152
.Image107_Top:                  dw 79
.Image107_Width:                dw 12
.Image107_Height:               dw 12
.Image107_Code:                 dw 0
.Image108_Display      Equ 118
.Image108
.Image108_ID:                   dw 118
.Image108_Type:                 db 10   ;*ImageBox
.Image108_ExtDataBank:          db 255
.Image108_GrInfoAddr:           dw Sheet_Data4
.Image108_Left:                 dw 165
.Image108_Top:                  dw 80
.Image108_Width:                dw 3
.Image108_Height:               dw 10
.Image108_Code:                 dw QFunc_Image_Event
.Image109_Display      Equ 119
.Image109
.Image109_ID:                   dw 119
.Image109_Type:                 db 10   ;*ImageBox
.Image109_ExtDataBank:          db 255
.Image109_GrInfoAddr:           dw Sheet_Data4
.Image109_Left:                 dw 169
.Image109_Top:                  dw 79
.Image109_Width:                dw 12
.Image109_Height:               dw 12
.Image109_Code:                 dw 0
.Image110_Display      Equ 120
.Image110
.Image110_ID:                   dw 120
.Image110_Type:                 db 10   ;*ImageBox
.Image110_ExtDataBank:          db 255
.Image110_GrInfoAddr:           dw Sheet_Data4
.Image110_Left:                 dw 182
.Image110_Top:                  dw 80
.Image110_Width:                dw 3
.Image110_Height:               dw 10
.Image110_Code:                 dw QFunc_Image_Event
.Image111_Display      Equ 121
.Image111
.Image111_ID:                   dw 121
.Image111_Type:                 db 10   ;*ImageBox
.Image111_ExtDataBank:          db 255
.Image111_GrInfoAddr:           dw Sheet_Data4
.Image111_Left:                 dw 95
.Image111_Top:                  dw 90
.Image111_Width:                dw 7
.Image111_Height:               dw 7
.Image111_Code:                 dw 0
.Image112_Display      Equ 122
.Image112
.Image112_ID:                   dw 122
.Image112_Type:                 db 10   ;*ImageBox
.Image112_ExtDataBank:          db 255
.Image112_GrInfoAddr:           dw Sheet_Data4
.Image112_Left:                 dw 102
.Image112_Top:                  dw 92
.Image112_Width:                dw 10
.Image112_Height:               dw 3
.Image112_Code:                 dw QFunc_Image_Event
.Image113_Display      Equ 123
.Image113
.Image113_ID:                   dw 123
.Image113_Type:                 db 10   ;*ImageBox
.Image113_ExtDataBank:          db 255
.Image113_GrInfoAddr:           dw Sheet_Data4
.Image113_Left:                 dw 112
.Image113_Top:                  dw 90
.Image113_Width:                dw 7
.Image113_Height:               dw 7
.Image113_Code:                 dw 0
.Image114_Display      Equ 124
.Image114
.Image114_ID:                   dw 124
.Image114_Type:                 db 10   ;*ImageBox
.Image114_ExtDataBank:          db 255
.Image114_GrInfoAddr:           dw Sheet_Data4
.Image114_Left:                 dw 119
.Image114_Top:                  dw 92
.Image114_Width:                dw 10
.Image114_Height:               dw 3
.Image114_Code:                 dw QFunc_Image_Event
.Image115_Display      Equ 125
.Image115
.Image115_ID:                   dw 125
.Image115_Type:                 db 10   ;*ImageBox
.Image115_ExtDataBank:          db 255
.Image115_GrInfoAddr:           dw Sheet_Data4
.Image115_Left:                 dw 129
.Image115_Top:                  dw 90
.Image115_Width:                dw 7
.Image115_Height:               dw 7
.Image115_Code:                 dw 0
.Image116_Display      Equ 126
.Image116
.Image116_ID:                   dw 126
.Image116_Type:                 db 10   ;*ImageBox
.Image116_ExtDataBank:          db 255
.Image116_GrInfoAddr:           dw Sheet_Data4
.Image116_Left:                 dw 136
.Image116_Top:                  dw 92
.Image116_Width:                dw 10
.Image116_Height:               dw 3
.Image116_Code:                 dw QFunc_Image_Event
.Image117_Display      Equ 127
.Image117
.Image117_ID:                   dw 127
.Image117_Type:                 db 10   ;*ImageBox
.Image117_ExtDataBank:          db 255
.Image117_GrInfoAddr:           dw Sheet_Data4
.Image117_Left:                 dw 146
.Image117_Top:                  dw 90
.Image117_Width:                dw 7
.Image117_Height:               dw 7
.Image117_Code:                 dw 0
.Image118_Display      Equ 128
.Image118
.Image118_ID:                   dw 128
.Image118_Type:                 db 10   ;*ImageBox
.Image118_ExtDataBank:          db 255
.Image118_GrInfoAddr:           dw Sheet_Data4
.Image118_Left:                 dw 153
.Image118_Top:                  dw 92
.Image118_Width:                dw 10
.Image118_Height:               dw 3
.Image118_Code:                 dw QFunc_Image_Event
.Image119_Display      Equ 129
.Image119
.Image119_ID:                   dw 129
.Image119_Type:                 db 10   ;*ImageBox
.Image119_ExtDataBank:          db 255
.Image119_GrInfoAddr:           dw Sheet_Data4
.Image119_Left:                 dw 163
.Image119_Top:                  dw 90
.Image119_Width:                dw 7
.Image119_Height:               dw 7
.Image119_Code:                 dw 0
.Image120_Display      Equ 130
.Image120
.Image120_ID:                   dw 130
.Image120_Type:                 db 10   ;*ImageBox
.Image120_ExtDataBank:          db 255
.Image120_GrInfoAddr:           dw Sheet_Data4
.Image120_Left:                 dw 170
.Image120_Top:                  dw 92
.Image120_Width:                dw 10
.Image120_Height:               dw 3
.Image120_Code:                 dw QFunc_Image_Event
.Image121_Display      Equ 131
.Image121
.Image121_ID:                   dw 131
.Image121_Type:                 db 10   ;*ImageBox
.Image121_ExtDataBank:          db 255
.Image121_GrInfoAddr:           dw Sheet_Data4
.Image121_Left:                 dw 180
.Image121_Top:                  dw 90
.Image121_Width:                dw 7
.Image121_Height:               dw 7
.Image121_Code:                 dw 0
.Image122_Display      Equ 132
.Image122
.Image122_ID:                   dw 132
.Image122_Type:                 db 10   ;*ImageBox
.Image122_ExtDataBank:          db 255
.Image122_GrInfoAddr:           dw Sheet_Data4
.Image122_Left:                 dw 235
.Image122_Top:                  dw 17
.Image122_Width:                dw 20
.Image122_Height:               dw 30
.Image122_Code:                 dw 0
.Image123_Display      Equ 133
.Image123
.Image123_ID:                   dw 133
.Image123_Type:                 db 10   ;*ImageBox
.Image123_ExtDataBank:          db 255
.Image123_GrInfoAddr:           dw Sheet_Data4
.Image123_Left:                 dw 265
.Image123_Top:                  dw 17
.Image123_Width:                dw 20
.Image123_Height:               dw 30
.Image123_Code:                 dw 0
.Label12_Display      Equ 134
.Label12
.Label12_ID:                    dw 134
.Label12_Type:                  db 1   ;*Label
.Label12_ExtDataBank:           db 255
.Label12_ExtDataAddr:           dw Label12_ExtData
.Label12_Left:                  dw 220
.Label12_Top:                   dw 5
.Label12_Width:                 dw 86
.Label12_Height:                dw 8
.Label12_Code:                  dw 0
.Label10_Display      Equ 135
.Label10
.Label10_ID:                    dw 135
.Label10_Type:                  db 1   ;*Label
.Label10_ExtDataBank:           db 255
.Label10_ExtDataAddr:           dw Label10_ExtData
.Label10_Left:                  dw 35
.Label10_Top:                   dw 25
.Label10_Width:                 dw 55
.Label10_Height:                dw 8
.Label10_Code:                  dw 0
.Label11_Display      Equ 136
.Label11
.Label11_ID:                    dw 136
.Label11_Type:                  db 1   ;*Label
.Label11_ExtDataBank:           db 255
.Label11_ExtDataAddr:           dw Label11_ExtData
.Label11_Left:                  dw 36
.Label11_Top:                   dw 55
.Label11_Width:                 dw 55
.Label11_Height:                dw 8
.Label11_Code:                  dw 0
.Label13_Display      Equ 137
.Label13
.Label13_ID:                    dw 137
.Label13_Type:                  db 1   ;*Label
.Label13_ExtDataBank:           db 255
.Label13_ExtDataAddr:           dw Label13_ExtData
.Label13_Left:                  dw 220
.Label13_Top:                   dw 51
.Label13_Width:                 dw 85
.Label13_Height:                dw 8
.Label13_Code:                  dw 0
.Image126_Display      Equ 138
.Image126
.Image126_ID:                   dw 138
.Image126_Type:                 db 10   ;*ImageBox
.Image126_ExtDataBank:          db 255
.Image126_GrInfoAddr:           dw Sheet_Data4
.Image126_Left:                 dw 235
.Image126_Top:                  dw 62
.Image126_Width:                dw 20
.Image126_Height:               dw 30
.Image126_Code:                 dw 0
.Image127_Display      Equ 139
.Image127
.Image127_ID:                   dw 139
.Image127_Type:                 db 10   ;*ImageBox
.Image127_ExtDataBank:          db 255
.Image127_GrInfoAddr:           dw Sheet_Data4
.Image127_Left:                 dw 265
.Image127_Top:                  dw 62
.Image127_Width:                dw 20
.Image127_Height:               dw 30
.Image127_Code:                 dw 0
.Label15_Display      Equ 140
.Label15
.Label15_ID:                    dw 140
.Label15_Type:                  db 1   ;*Label
.Label15_ExtDataBank:           db 255
.Label15_ExtDataAddr:           dw Label15_ExtData
.Label15_Left:                  dw 244
.Label15_Top:                   dw 104
.Label15_Width:                 dw 28
.Label15_Height:                dw 8
.Label15_Code:                  dw QFunc_Label15_Event
.ImageVoipRed_Display      Equ 141
.ImageVoipRed
.ImageVoipRed_ID:               dw 141
.ImageVoipRed_Type:             db 10   ;*ImageBox
.ImageVoipRed_ExtDataBank:      db 255
.ImageVoipRed_GrInfoAddr:       dw Sheet_Data4
.ImageVoipRed_Left:             dw 252
.ImageVoipRed_Top:              dw 133
.ImageVoipRed_Width:            dw 20
.ImageVoipRed_Height:           dw 20
.ImageVoipRed_Code:             dw QFunc_ImageVoipRed_Event
.ImageVoipGreen_Display      Equ 142
.ImageVoipGreen
.ImageVoipGreen_ID:             dw 142
.ImageVoipGreen_Type:           db 10   ;*ImageBox
.ImageVoipGreen_ExtDataBank:    db 255
.ImageVoipGreen_GrInfoAddr:     dw Sheet_Data4
.ImageVoipGreen_Left:           dw 281
.ImageVoipGreen_Top:            dw 133
.ImageVoipGreen_Width:          dw 20
.ImageVoipGreen_Height:         dw 20
.ImageVoipGreen_Code:           dw QFunc_ImageVoipGreen_Event
.LabelVoip_Display      Equ 143
.LabelVoip
.LabelVoip_ID:                  dw 143
.LabelVoip_Type:                db 1   ;*Label
.LabelVoip_ExtDataBank:         db 255
.LabelVoip_ExtDataAddr:         dw LabelVoip_ExtData
.LabelVoip_Left:                dw 243
.LabelVoip_Top:                 dw 115
.LabelVoip_Width:               dw 67
.LabelVoip_Height:              dw 8
.LabelVoip_Code:                dw QFunc_Label24_Event
.Paint1_Display      Equ 144
.Paint1
.Paint1_ID:                     dw 144
.Paint1_Type:                   db 0   ;*Paint
.Paint1_ExtDataBank:            db 255
.Paint1_Appearance:             db  139,0
.Paint1_Left:                   dw 244
.Paint1_Top:                    dw 162
.Paint1_Width:                  dw 67
.Paint1_Height:                 dw 1
.Paint1_Code:                   dw 0
.Label9_ExtData:                
.Label9_Text:                   dw  Label9_Text_Data+4
.Label9_TextAppearance:         db  18
.Label9_TextAlignment:          db  194
.Label7_ExtData:                
.Label7_Text:                   dw  Label7_Text_Data+4
.Label7_TextAppearance:         db  33
.Label7_TextAlignment:          db  194
.Label8_ExtData:                
.Label8_Text:                   dw  Label8_Text_Data+4
.Label8_TextAppearance:         db  33
.Label8_TextAlignment:          db  194
.Label6_ExtData:                
.Label6_Text:                   dw  Label6_Text_Data+4
.Label6_TextAppearance:         db  135
.Label6_TextAlignment:          db  192
.Label5_ExtData:                
.Label5_Text:                   dw  Label5_Text_Data+4
.Label5_TextAppearance:         db  33
.Label5_TextAlignment:          db  192
.Label4_ExtData:                
.Label4_Text:                   dw  Label4_Text_Data+4
.Label4_TextAppearance:         db  33
.Label4_TextAlignment:          db  192
.Label3_ExtData:                
.Label3_Text:                   dw  Label3_Text_Data+4
.Label3_TextAppearance:         db  33
.Label3_TextAlignment:          db  192
.Label2_ExtData:                
.Label2_Text:                   dw  Label2_Text_Data+4
.Label2_TextAppearance:         db  33
.Label2_TextAlignment:          db  192
.Label1_ExtData:                
.Label1_Text:                   dw  Label1_Text_Data+4
.Label1_TextAppearance:         db  18
.Label1_TextAlignment:          db  192
.Label14_ExtData:               
.Label14_Text:                  dw  Label14_Text_Data+4
.Label14_TextAppearance:        db  135
.Label14_TextAlignment:         db  194
.Label12_ExtData:               
.Label12_Text:                  dw  Label12_Text_Data+4
.Label12_TextAppearance:        db  18
.Label12_TextAlignment:         db  194
.Label10_ExtData:               
.Label10_Text:                  dw  Label10_Text_Data+4
.Label10_TextAppearance:        db  33
.Label10_TextAlignment:         db  192
.Label11_ExtData:               
.Label11_Text:                  dw  Label11_Text_Data+4
.Label11_TextAppearance:        db  33
.Label11_TextAlignment:         db  192
.Label13_ExtData:               
.Label13_Text:                  dw  Label13_Text_Data+4
.Label13_TextAppearance:        db  18
.Label13_TextAlignment:         db  194
.Label15_ExtData:               
.Label15_Text:                  dw  Label15_Text_Data+4
.Label15_TextAppearance:        db  135
.Label15_TextAlignment:         db  194
.LabelVoip_ExtData:             
.LabelVoip_Text:                dw  LabelVoip_Text_Data+4
.LabelVoip_TextAppearance:      db  11
.LabelVoip_TextAlignment:       db  194
.Form2
.Form2_Addr:                    db 1,0
.Form2_Begin:                   
.Form2_Status:                  db 128
.Form2_Display:                 db 21
.Form2_SizeAdjust:              db 16
.Form2_OwnerID:                 db 0
.Form2_Left:                    dw 0
.Form2_Top:                     dw 0
.Form2_Width:                   dw 134
.Form2_Height:                  dw 114
.Form2_OffsetWidth:             dw 1
.Form2_OffsetHeight:            dw 8
.Form2_ContentWidth:            dw 125
.Form2_ContentHeight:           dw 114
.Form2_MinWidth:                dw 0
.Form2_MinHeight:               dw 0
.Form2_MaxWidth:                dw 1024
.Form2_MaxHeight:               dw 212
.Form2_IconAddr:                dw Form2_Icon
.Form2_Text:                    dw Form2_Text_Data+4
.Form2_Status_Text:             dw Form2_Status_Text_Data+4
.Form2_MenuAddr:                dw 0  ;No Menu on form
.Form2_ControlWindowAddr:       dw Form2_ControlWindow
.Form2_ControlToolAddr:         dw 0;Form2_ControlTool
.Form2_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form2_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved
.Form2_ControlWindow:           
.Form2_ControlWindowCount:      db 8
.Form2_ControlWindowOwnerID:    db 0
.Form2_ControlWindowDataAddr:   dw Form2_ControlWindowData
.Form2_ControlWindowCalcAddr:   dw 0; Form2_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form2_ControlWindowFocus:      db 0
     db 0
.Form2_ControlWindowData:       
dw 0,255*256+0,129,  0,0,1000,1000,0
.Label20_Display      Equ 1
.Label20
.Label20_ID:                    dw 2049
.Label20_Type:                  db 1   ;*Label
.Label20_ExtDataBank:           db 255
.Label20_ExtDataAddr:           dw Label20_ExtData
.Label20_Left:                  dw 8
.Label20_Top:                   dw 12
.Label20_Width:                 dw 115
.Label20_Height:                dw 8
.Label20_Code:                  dw 0
.Label21_Display      Equ 2
.Label21
.Label21_ID:                    dw 2050
.Label21_Type:                  db 1   ;*Label
.Label21_ExtDataBank:           db 255
.Label21_ExtDataAddr:           dw Label21_ExtData
.Label21_Left:                  dw 8
.Label21_Top:                   dw 30
.Label21_Width:                 dw 115
.Label21_Height:                dw 8
.Label21_Code:                  dw QFunc_Label21_Event
.Label23_Display      Equ 3
.Label23
.Label23_ID:                    dw 2051
.Label23_Type:                  db 1   ;*Label
.Label23_ExtDataBank:           db 255
.Label23_ExtDataAddr:           dw Label23_ExtData
.Label23_Left:                  dw 8
.Label23_Top:                   dw 50
.Label23_Width:                 dw 115
.Label23_Height:                dw 8
.Label23_Code:                  dw QFunc_Label23_Event
.Label24_Display      Equ 4
.Label24
.Label24_ID:                    dw 2052
.Label24_Type:                  db 1   ;*Label
.Label24_ExtDataBank:           db 255
.Label24_ExtDataAddr:           dw Label24_ExtData
.Label24_Left:                  dw 8
.Label24_Top:                   dw 60
.Label24_Width:                 dw 115
.Label24_Height:                dw 8
.Label24_Code:                  dw QFunc_Label24_Event
.Label25_Display      Equ 5
.Label25
.Label25_ID:                    dw 2053
.Label25_Type:                  db 1   ;*Label
.Label25_ExtDataBank:           db 255
.Label25_ExtDataAddr:           dw Label25_ExtData
.Label25_Left:                  dw 8
.Label25_Top:                   dw 70
.Label25_Width:                 dw 115
.Label25_Height:                dw 8
.Label25_Code:                  dw QFunc_Label25_Event
.Label26_Display      Equ 6
.Label26
.Label26_ID:                    dw 2054
.Label26_Type:                  db 1   ;*Label
.Label26_ExtDataBank:           db 255
.Label26_ExtDataAddr:           dw Label26_ExtData
.Label26_Left:                  dw 8
.Label26_Top:                   dw 99
.Label26_Width:                 dw 113
.Label26_Height:                dw 8
.Label26_Code:                  dw 0
.Label22_Display      Equ 7
.Label22
.Label22_ID:                    dw 2055
.Label22_Type:                  db 1   ;*Label
.Label22_ExtDataBank:           db 255
.Label22_ExtDataAddr:           dw Label22_ExtData
.Label22_Left:                  dw 8
.Label22_Top:                   dw 40
.Label22_Width:                 dw 115
.Label22_Height:                dw 8
.Label22_Code:                  dw QFunc_Label22_Event
.Label20_ExtData:               
.Label20_Text:                  dw  Label20_Text_Data+4
.Label20_TextAppearance:        db  131
.Label20_TextAlignment:         db  194
.Label21_ExtData:               
.Label21_Text:                  dw  Label21_Text_Data+4
.Label21_TextAppearance:        db  135
.Label21_TextAlignment:         db  192
.Label23_ExtData:               
.Label23_Text:                  dw  Label23_Text_Data+4
.Label23_TextAppearance:        db  135
.Label23_TextAlignment:         db  192
.Label24_ExtData:               
.Label24_Text:                  dw  Label24_Text_Data+4
.Label24_TextAppearance:        db  135
.Label24_TextAlignment:         db  192
.Label25_ExtData:               
.Label25_Text:                  dw  Label25_Text_Data+4
.Label25_TextAppearance:        db  135
.Label25_TextAlignment:         db  192
.Label26_ExtData:               
.Label26_Text:                  dw  Label26_Text_Data+4
.Label26_TextAppearance:        db  33
.Label26_TextAlignment:         db  192
.Label22_ExtData:               
.Label22_Text:                  dw  Label22_Text_Data+4
.Label22_TextAppearance:        db  135
.Label22_TextAlignment:         db  192
.Form3
.Form3_Addr:                    db 2,0
.Form3_Begin:                   
.Form3_Status:                  db 0
.Form3_Display:                 db 85
.Form3_SizeAdjust:              db 16
.Form3_OwnerID:                 db 0
.Form3_Left:                    dw 0
.Form3_Top:                     dw 0
.Form3_Width:                   dw 94
.Form3_Height:                  dw 5
.Form3_OffsetWidth:             dw 1
.Form3_OffsetHeight:            dw 8
.Form3_ContentWidth:            dw 85
.Form3_ContentHeight:           dw 5
.Form3_MinWidth:                dw 0
.Form3_MinHeight:               dw 0
.Form3_MaxWidth:                dw 1024
.Form3_MaxHeight:               dw 212
.Form3_IconAddr:                dw Form3_Icon
.Form3_Text:                    dw Form3_Text_Data+4
.Form3_Status_Text:             dw Form3_Status_Text_Data+4
.Form3_MenuAddr:                dw 0  ;No Menu on form
.Form3_ControlWindowAddr:       dw Form3_ControlWindow
.Form3_ControlToolAddr:         dw 0;Form3_ControlTool
.Form3_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form3_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved
.Form3_ControlWindow:           
.Form3_ControlWindowCount:      db 1
.Form3_ControlWindowOwnerID:    db 0
.Form3_ControlWindowDataAddr:   dw Form3_ControlWindowData
.Form3_ControlWindowCalcAddr:   dw 0; Form3_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form3_ControlWindowFocus:      db 0
     db 0
.Form3_ControlWindowData:       
dw 0,255*256+0,129,  0,0,1000,1000,0
.Form4
.Form4_Addr:                    db 3,0
.Form4_Begin:                   
.Form4_Status:                  db 129
.Form4_Display:                 db 85
.Form4_SizeAdjust:              db 16
.Form4_OwnerID:                 db 0
.Form4_Left:                    dw 0
.Form4_Top:                     dw 0
.Form4_Width:                   dw 120
.Form4_Height:                  dw 92
.Form4_OffsetWidth:             dw 1
.Form4_OffsetHeight:            dw 8
.Form4_ContentWidth:            dw 111
.Form4_ContentHeight:           dw 92
.Form4_MinWidth:                dw 0
.Form4_MinHeight:               dw 0
.Form4_MaxWidth:                dw 1024
.Form4_MaxHeight:               dw 212
.Form4_IconAddr:                dw Form4_Icon
.Form4_Text:                    dw Form4_Text_Data+4
.Form4_Status_Text:             dw Form4_Status_Text_Data+4
.Form4_MenuAddr:                dw 0  ;No Menu on form
.Form4_ControlWindowAddr:       dw Form4_ControlWindow
.Form4_ControlToolAddr:         dw 0;Form4_ControlTool
.Form4_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form4_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved
.Form4_ControlWindow:           
.Form4_ControlWindowCount:      db 4
.Form4_ControlWindowOwnerID:    db 0
.Form4_ControlWindowDataAddr:   dw Form4_ControlWindowData
.Form4_ControlWindowCalcAddr:   dw 0; Form4_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form4_ControlWindowFocus:      db 0
     db 0
.Form4_ControlWindowData:       
dw 0,255*256+0,131,  0,0,1000,1000,0
.Label41_Display      Equ 1
.Label41
.Label41_ID:                    dw 6145
.Label41_Type:                  db 1   ;*Label
.Label41_ExtDataBank:           db 255
.Label41_ExtDataAddr:           dw Label41_ExtData
.Label41_Left:                  dw 5
.Label41_Top:                   dw 4
.Label41_Width:                 dw 104
.Label41_Height:                dw 8
.Label41_Code:                  dw 0
.Image410_Display      Equ 2
.Image410
.Image410_ID:                   dw 6146
.Image410_Type:                 db 10   ;*ImageBox
.Image410_ExtDataBank:          db 255
.Image410_GrInfoAddr:           dw Sheet_Data4
.Image410_Left:                 dw 6
.Image410_Top:                  dw 21
.Image410_Width:                dw 100
.Image410_Height:               dw 47
.Image410_Code:                 dw 0
.Button41_Display      Equ 3
.Button41
.Button41_ID:                   dw 6147
.Button41_Type:                 db 16   ;*Button
.Button41_ExtDataBank:          db 255
.Button41_Text:                 dw Button41_Text_Data+4
.Button41_Left:                 dw 24
.Button41_Top:                  dw 73
.Button41_Width:                dw 73
.Button41_Height:               dw 11
.Button41_Code:                 dw QFunc_Button41_Event
.Label41_ExtData:               
.Label41_Text:                  dw  Label41_Text_Data+4
.Label41_TextAppearance:        db  33
.Label41_TextAlignment:         db  194
.SyStud_TimerRoutines    dw 0
.Quig_File_Select_Ext          ds 4
.Quig_File_Select_File         ds 256
.AppTrnEnd
