
;*******************
;**** Code G9K *****
;*******************
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3

.V_App_In_Use			db 	0

.AppPrz:
;**** Open Primary Window ****

		ld		hl,AppTrnEnd+260
		ld		a,h
		ld		(Quig_String_AS_HByte),a		;Set Byte so we can check if string is in String area or String buffer

	#IF USETIMER	
		;**** Sets up the Timer Stack ****
		ld		hl,Quig_TimerStack
		ld		a,(AppBnkNum)
		ld		e,7
		call	SyKernel_MTADDT
  		jp      c,Quig_End
       	ld      (PrgPstSpz+AppCodBeg),a
	#ENDIF
		INCLIB	QUIG.G9K.64OUTI
		;**** Set to Full Screen
		INCLIB 	SYDESKTOP.SERVICE
		ld 		a,DSK_SRV_MODGET
        call	SyDesktop_Service
		ld		(Quig_ModeUsed),de
		ld 		a,DSK_SRV_DSKSTP
		ld 		e,1
		call 	SyDesktop_Service
;		;**** Set to G9K Mode
		INCLIB 	QUIG.G9K.SETMODE.50

		
		;G9KWriteReg
		ld		a,g9k_PALETTE_PTR
		ld		bc,CG9K_REG_SELECT
		di
		out 	(c),a
		xor		a
		ld		bc,CG9K_REG_DATA
		out		(c),a
		ld		bc,CG9K_OUTPUT_CTRL
        out  	(c),A    	   	; Set output GFX9000
		call	Quig_G9K_SETMODE_50
		ei
		
		ld		a,(Quig_Machine_Type)
		cp		8
		jp		c,Quigs_CPC
	
		ld		hl,Quig_g9k_48outi
		ld		(Quig_CPC_48_11+1),hl						
		ld		hl,Quig_g9k_32outi
		ld		(Quig_CPC_32_1+1),hl
		ld		(Quig_CPC_32_2+1),hl				
		ld		hl,Quig_g9k_64outi
		ld		(Quig_CPC_64_1+1),hl
		ld		(Quig_CPC_64_2+1),hl
;		ld		(Quig_CPC_64_3+1),hl
;		ld		(Quig_CPC_64_4+1),hl
		ld		(Quig_CPC_64_5+1),hl
		ld		(Quig_CPC_64_6+1),hl
		ld		(Quig_CPC_64_7+1),hl
		ld		(Quig_CPC_64_8+1),hl
		ld		(Quig_CPC_64_9+1),hl
		ld		(Quig_CPC_64_10+1),hl
		ld		(Quig_CPC_64_11+1),hl			
		
.Quigs_CPC:	
		;Set Back/Fore Palettes
		INCLIB 	QUIG.G9K.FORE.PALETTE.SET
		call	Quig_g9k_ForeBack_Palette_Set
		
		;Setup Interrupt system
		ld		c,0										;G9k Interrupt Info
		rst 	#20:dw #8163
		ld		(Quig_G9K_Interrupt_RetAddr+1),hl		;Places Return adress in my interrupt code		
		ld		a,(AppBnkNum)							;Ram Bank being used
		ld		hl,Quig_G9K_Interrupt_Addr
		ld		c,1
		rst 	#20:dw #8163							;Setup up Interrupt handler
		di
		ld		a,G9K_INT_ENABLE						;Set Int Enable
		out		(CG9K_REG_SELECT),a						;Set Register
		ld		a,6										;3 - IEH/IEV set
		out     (CG9K_REG_DATA),a
		ld		a,g9k_INT_V_LINE_LO
		out		(CG9K_REG_SELECT),a
		ld		a,211; 211
		out 	(CG9K_REG_DATA),a
		ei
		;**** Call Init Function
		call	qfunc_initialize			
		
		ld		a,1
		ld		(Quigs_Done_Vblank),a
		
;****************************************
;**** Main Application Control Loop *****
;****************************************
.Quig_Control_LoopX:
.Quig_Control_Loop:
		ld		a,(Quigs_Done_Vblank)
		cp		1
		jr		nz,Quig_Control_LoopX
.Quig_Control_Loop_2:
		call	Quig_G9K_Top_Screen	
		call	qfunc_main
		xor		a
		ld		(Quigs_Done_Vblank),a
.Quig_Control_Loop_1:
		jr		Quig_Control_Loop

		
.Quig_ModeUsed:	dw	0
		
#IF USENET		
;**** NET EVENTS		
.Quig_Net_Event:
;		INCLIB   QUIG.NET.TCP.FIND.FREE.HANDLE
;		INCLIB   QUIG.NET.TCP.SOCKET.COUNT
        call 	snwmsgo_afbcdehlixiy
		ld		(Quig_Event_Net_Handle),a
		ld		a,l
		ld		(Quig_Event_Net),a
		
		ld		(Quig_Net_Received_Value),bc
		
		ld		a,(Quig_Event_Net)
		cp		2					;tcpestablished
		jp		z,Quig_Found_TCP_Establish
		cp		128
		jp		z,Quig_Found_Data_Received
		cp		3
		jp		z,Quig_Found_Data_Received		
		cp		4
		jp		z,Quig_Found_Data_Received
		
		jp		Quig_Control_Loop_2

.Quig_Found_Data_Received:
		jp		Quig_Net_Event6
		
.Quig_Found_TCP_Establish:
		ld		(Quig_Event_Net_Port),de
		ld		(Quig_Event_Net_IXIY),ix
		ld		(Quig_Event_Net_IXIY+2),iy
.Quig_Net_Event6:		
		call 	QFunc_Net_Event	
.Quig_Net_Event7:
		jp		Quig_Control_Loop_2
		
.Quig_Net_Error:			dw	0
.Quig_Net_Handle:			db	255
.Quig_Net_Process:			db	255

.Quig_Net_TCP_Server:		db	0
.Quig_Net_TCP_Server_Port:	dw	0
.Quig_Net_TCP_Socket:		db 	0
.Quig_Net_TCP_Socket_Max:	db 	0

.Quig_Net_Received_Value:	dw	0
.Quig_Net_Transfered_Value:	dw 	0
.Quig_Net_Send_Wait_Value:	dw 	0

.Quig_Event_Net:			db	0
.Quig_Event_Net_Handle:		db	255
.Quig_Event_Net_Port:		dw	0
.Quig_Event_Net_IXIY:		dw	0,0

#ENDIF


.Quig_G9K_Top_Screen:

		INCLIB QUIG.G9K.SCROLL.A
		call	Quig_G9K_SCROLL_A
		INCLIB	QUIG.G9K.SCROLL.B
		call	Quig_G9K_SCROLL_B
				
		inclib 	QUIG.G9K.SPRITE.REFRESH
		call	Quig_g9k_Sprite_Refresh
	
		ld		a,(Quig_G9K_Map_Engine)
		and		a
		ret		z
		ld		a,(Quig_G9K_IntCount)
		inc		a
		and		%111
		ld		(Quig_G9K_IntCount),a
		cp		0
		jp		z,Quig_Fore_LeftRight
;		cp		1
;		jp		z,Quig_Back_LeftRight
		cp		2
		jp		z,Quig_Fore_UpDown
;		cp		3
;		jp		z,Quig_Back_UpDown

		cp		5
		jp		z,Higtert

		cp		4
		jp		z,Quig_Fore_LeftRight
		cp		6
		jp		z,Quig_Fore_UpDown	
		
.Quig_G9K_Top_Screen_9:

		ret
.Higtert:		
		inclib	QUIG.G9K.COPY.32Patterns
		ld		a,(Quig_PattAutoAnim)
		cp		255
		ret		z
		inc		a
		and		%11
		ld		(Quig_PattAutoAnim),a
		add		a
		ld		e,a
		ld		d,0
		ld		hl,ghrotates
		add		hl,de
		ld		a,(hl)
		ld		(Quig_34),a			;SA	bits 8..15
		inc		hl
		ld		a,(hl)
		ld		(Quig_35),a			;SA	bits 8..15
		ld		hl,ghdest
		ld		a,(hl)
		ld		(Quig_38),a			;SA	bits 8..15
		inc		hl
		ld		a,(hl)
		ld		(Quig_39),a			;SA	bits 8..15	
		
		ld 		a,CG9K_SC_A
        ld 		bc,CG9K_REG_SELECT
		di
        out 	(c),a
        ld 		hl,Quig_g9k_CommandList
        ld 		bc,CG9K_REG_DATA
        ld 		a,1
        inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
        inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
        inc 	b:outi:inc b:outi:inc b:outi:inc b:outi:inc b:outi
		ei		
		ret
.Quig_PattAutoAnim:	db		255
.Quig_g9k_CommandList:
.Quig_32:db		#0				;SA bits 0-7
.Quig_33:db		#0				;
.Quig_34:db		#0				;SA bits 8-15
.Quig_35:db		#0				;SA bits 16-18
.Quig_36:db		#0				;DA bits 0-7
.Quig_37:db		#0				;
.Quig_38:db		#0				;DA bits 8-15
.Quig_39:db		#0				;DA bits 16-18
.Quig_40:db		#0				;NA bits 0-7
.Quig_41:db		#0				;
.Quig_42:db		#8				;NA bits 8-15
.Quig_43:db		#0				;NA bits 16-18
.Quig_44:db		12				;DIVX DIVY
.Quig_45:db		12				;Logical Operation
.Quig_46:db		255				;Write Mask bits 0-7 deffo
.Quig_47:db		0				;Write Mask bits 8-15
.Quig_48:db		0				;
.Quig_49:db		0				;
.Quig_50:db		0				;
.Quig_51:db		0				;
.Quig_52:db		#0A0			;BMLL Command	

		
;.ghrotates:		dw #1f0,#1f8,#200,#208,#210,#218,#220,#228
;.ghdest:		dw #1e8
.ghrotates:		dw #258,#260,#268,#270,#210,#218,#220,#228
.ghdest:		dw #250

.Quig_G9K_Map_Engine:		db	0
.Quig_G9k_Meta_Count:		dw 	0
.Quig_G9k_Meta_Size:		dw	0

.Quig_MetaLoad_Handle:		db	0
.Quig_MetaLoad_VAddr:		dw	0
.Quig_LoadSize:				dw	0
.Quig_LoadMeta_Buffer:		dw	0

.Quig_G9k_MapA_Width:		dw 	0
.Quig_G9k_MapA_Height:		dw	0
.Quig_G9k_MapA_MetaWidth:	dw	0
.Quig_G9k_MapA_MetaHeight:	dw	0
.Quig_G9k_MapA_Size:		dw	0
.Quig_G9k_MapB_Width:		dw 	0
.Quig_G9k_MapB_Height:		dw	0
.Quig_G9k_MapB_MetaWidth:	dw	0
.Quig_G9k_MapB_MetaHeight:	dw	0
.Quig_G9k_MapB_Size:		dw	0
		
.Quig_G9K_IntCount:			db	0		
.Quig_G9K_ScrollA_XPos:		dw	0
.Quig_G9K_ScrollA_YPos:		dw	0
.Quig_G9K_ScrollB_XPos:		dw	0
.Quig_G9K_ScrollB_YPos:		dw	0
.Quig_G9K_ScrollA_XPosOld:	dw	0
.Quig_G9K_ScrollA_YPosOld:	dw	0
.Quig_G9K_ScrollB_XPosOld:	dw	0
.Quig_G9K_ScrollB_YPosOld:	dw	0


.Quig_G9K_Sprite_NextXPos:		dw	0
.Quig_G9K_Sprite_NextYPos:		dw	0		
.Quig_G9K_Sprite_NextPattern:	dw	0
.Quig_G9K_Sprite_NextAddr:		dw	0
.Quig_G9K_Sprite_NextDisplay:	db	0

.Quig_G9K_a:				dw	0
.Quig_G9K_y:				dw	0
.Quig_G9K_x:				dw	0

.Quig_G9K_GameObjDataAddr:	dw	0

;****                       ****		
;**** Shut down Application ****
;****                       ****		
.Quig_End:
		INCLIB 	SYDESKTOP.SERVICE
		;Disable g9k interrupt
		ld		a,G9K_INT_ENABLE		;Set Int Enable
		out		(CG9K_REG_SELECT),a		;Set Register
		ld		a,0						;3 - IEH/IEV set
		out     (CG9K_REG_DATA),a		
		ld		c,2										;G9k Interrupt Disable
		rst 	#20:dw #8163
		
		ld		de,(Quig_ModeUsed)
		ld		a,e
		or		%10000000
		ld		e,a
		ld 		a,DSK_SRV_MODSET
        call 	SyDesktop_Service
		
		ld 		a,DSK_SRV_DSKCNT
		call 	SyDesktop_Service
		ld 		a,DSK_SRV_DSKPLT
		call	SyDesktop_Service

		ld		a,(AppPrzN)
		db		#dd:ld l,a
		ld		a,(SysPrzN)
		db		#dd:ld h,a
		ld		a,(AppCodBeg+PrgPstNum)
		ld		h,a
		ld		l,MSC_SYS_PRGEND
		ld		(AppMsgB),hl
		ld		iy,AppMsgB
		rst		#10
.Quig_End_1
 		rst		#30
		jr		Quig_End_1

;******************************************************************************
;*** Name           System_CallFunction
;*** Input          ((SP+0)) = System manager command
;***                ((SP+1)) = Function ID
;***                AF,BC,DE,HL,IX,IY = Input for the function
;*** Output         AF,BC,DE,HL,IX,IY = Output from the function
;*** Destroyed      -
;*** Description    Calls a function via the system manager. This function is
;***                needed to have access to the file manager.
;******************************************************************************
.SySystem_CallFunction
		ld (AppMsgB+04),bc      ;copy registers into the message buffer
        ld (AppMsgB+06),de
        ld (AppMsgB+08),hl
        ld (AppMsgB+10),ix
        ld (AppMsgB+12),iy
        push af
        pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ld (AppMsgB+00),de      ;module und funktion number
        ld a,e
        ld (SyCallN),a
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #10                 ;send message
.SyCall1 rst #30
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #18                 ;wait for answer
        db #dd:dec l
        jr nz,SyCall1
        ld a,(AppMsgB)
        sub 128
        ld e,a
        ld a,(SyCallN)
        cp e
        jr nz,SyCall1
        ld hl,(AppMsgB+02)      ;get registers out of the message buffer
        push hl
        pop af
        ld bc,(AppMsgB+04)
        ld de,(AppMsgB+06)
        ld hl,(AppMsgB+08)
        ld ix,(AppMsgB+10)
        ld iy,(AppMsgB+12)
        ret
.SyCallN db 0		
		
.Quig_Sprite_Attributes		
		ds					512		
;.Quig_Form_No:				db	0
;.Quig_FormIDs:				db  255,255,255,255,255,255,255,255

.Quig_Directory_Error_Byte:		db	0
.Quig_String_Buffer_Area_Start 	equ AppTrnEnd+260
.Quig_String_Buffer_Top			equ AppTrnEnd+260+AppTrnLen2
.Quig_String_Buffer_StackNo:	dw 0
.Quig_String_Buffer_Pos:		dw AppTrnEnd+260
.Quig_String_Buffer_Stack:		dw AppTrnEnd+260,0,0,0,0,0,0,0,0,0
.Quig_String_AS_HByte:			db 0
.Quig_String_Pos:				dw Quig_String_End_Text+4

		
.ErrorNum:					dw	0
.ErrorPC:					dw	0
.False:						db	0
.True:						db	1
.tcounter					dw	0


#IF USETIMER
.Quig_Timer_Code:
		ld		a,(Quig_Timer_On)
		and		a
		jp		nz,feet1
		rst		#30
		jp		Quig_Timer_Code
.feet1		
		di
.feet	jr		feet	

		
.Quig_Timer_On:				db	0
.Quig_Timer_Count:			dw	0
		
#ENDIF	
#IF USENET



;### SUB ROUTINES #############################################################
.snwmsgi_afbcdehlixiy
        ld (AppMsgB+10),ix   ;store registers to message buffer
        ld (AppMsgB+12),iy
.snwmsgi_afbcdehl
        ld (AppMsgB+04),bc
.snwmsgi_afdehl
        ld (AppMsgB+06),de
.snwmsgi_afhl
        ld (AppMsgB+08),hl
.snwmsgi_af
        push af:pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld a,(hl)               ;set command
        inc hl
        push hl
        ld (AppMsgB+0),a
        ld (snwmsg2+1),a
        ld iy,AppMsgB
        ld a,(AppPrzN)	;ld a,(App_PrcID)
        db #dd:ld l,a
        ld a,(Quig_Net_Process)
        db #dd:ld h,a
        ld (snwmsg1+2),ix
        rst #10                 ;send message
.snwmsg1 ld ix,0                 ;wait for response
        rst #08
        db #dd:dec l
        jr nz,snwmsg1
        ld a,(AppMsgB)
        sub 128
.snwmsg2 cp 0
        ret z
        ld	a,(AppPrzN)			;ld a,(App_PrcID)        ;wrong response code -> re-send and wait for correct one
        db #dd:ld h,a
        ld a,(Quig_Net_Process)
        db #dd:ld l,a
        rst #10
        rst #30
        jr snwmsg1
.snwmsgo_afbcdehlixiy
        ld ix,(AppMsgB+10)   ;get registers from the message buffer
        ld iy,(AppMsgB+12)
        ld de,(AppMsgB+06)
.snwmsgo_afbchl
        ld bc,(AppMsgB+04)
.snwmsgo_afhl
        ld hl,(AppMsgB+02)
        push hl
        pop af
        ld hl,(AppMsgB+08)
        ret
#ENDIF	

;*****************************
.Quig_Fore_UpDown:
		ld		a,(Quig_G9K_ScrollA_YPosOld)
		ld		b,a
		ld		hl,(Quig_G9K_ScrollA_YPos)
		add		hl,hl:add hl,hl:add hl,hl:ld a,h									;Hl/32 into H (0.255)
		sub 	b
		ret		z
		ld		de,7
		jr		nc,Quig_Fore_UpDown_a
		ld		de,-1
.Quig_Fore_UpDown_a:
		ld		l,h:ld h,0
		ld		a,l																	;a=l
		ld		(Quig_G9K_ScrollA_YPosOld),a										;Store New location in Old
		add		hl,de																;This is the Y line to draw
		ld		a,l	
		and		%1111
		add		96
		ld		(Quig_ziggyzag3+1),a												;Store
		bit		7,h																	;If Gone negative don't draw - Line minus 1
		ret		nz																	;Store
		ex		de,hl																;swap Y into de		

		ld		a,(Quig_G9K_ScrollA_XPosOld)										;A = Xpos/32
		and 	a
		jr		z,Quig_Fore_UpDown_b
		dec		a
.Quig_Fore_UpDown_b:	
		ld		l,a:ld	h,0
		rla		
		rla
		and		%111100
		ld		(Quig_ziggyzag4+1),a												;Store
		ex		de,hl
	
		add		hl,hl																;Double Y
		ld		bc,Quigs_Map_Edge													;Get Edge Size
		add		hl,bc																;Add
		ld		a,(hl)	
		inc		hl
		ld		h,(hl)																;	
		ld		l,a																	;HL=Map Vertical Address
		add		hl,de																;Add the X to address
		add		hl,hl																;Double to give correct addr	
		ld		(Quig_g9k_HoriGetAndMap+1),hl		
		jp		Quig_Draw_HorizontalMetaStrip
;*****************************
.Quig_Back_UpDown:
		ld		a,(Quig_G9K_ScrollB_YPosOld)
		ld		b,a
		ld		hl,(Quig_G9K_ScrollB_YPos)
		add		hl,hl:add hl,hl:add hl,hl:ld a,h									;Hl/32 into H (0.255)
		sub 	b
		ret		z
		ld		de,7
		jr		nc,Quig_Back_UpDown_a
		ld		de,-1
.Quig_Back_UpDown_a:
		ld		l,h:ld h,0
		ld		a,l																	;a=l
		ld		(Quig_G9K_ScrollB_YPosOld),a										;Store New location in Old
		add		hl,de																;This is the Y line to draw
		ld		a,l	
		and		%1111
		add		112
		ld		(Quig_ziggyzag3+1),a												;Store
		bit		7,h																	;If Gone negative don't draw - Line minus 1
		ret		nz																	;Store
		ex		de,hl																;swap Y into de		

		ld		a,(Quig_G9K_ScrollB_XPosOld)										;A = Xpos/32
		and 	a
		jr		z,Quig_Back_UpDown_b
		dec		a
.Quig_Back_UpDown_b:	
		ld		l,a:ld	h,0
		rla		
		rla
		and		%111100
		ld		(Quig_ziggyzag4+1),a												;Store
		ex		de,hl	
		add		hl,hl																;Double Y
		ld		bc,Quigs_Map_Edge													;Get Edge Size
		add		hl,bc																;Add
		ld		a,(hl)	
		inc		hl
		ld		h,(hl)																;	
		ld		l,a																	;HL=Map Vertical Address
		add		hl,de																;Add the X to address
		ld		de,#1800															;Map B Offset
		add		hl,de			
		add		hl,hl																;Double to give correct addr	
		ld		(Quig_g9k_HoriGetAndMap+1),hl		
		jp		Quig_Draw_HorizontalMetaStrip
;***********************
.Quig_Back_LeftRight:
		ld		a,(Quig_G9K_ScrollB_XPosOld)										;Old is Div 32
		ld		b,a																	;B = Old
		ld		hl,(Quig_G9K_ScrollB_XPos)											;HL = Xpos
		add		hl,hl:add hl,hl:add hl,hl:ld a,h									;Hl/32 into H (0.255)
		sub 	b																	;Check against old
		ret 	z 																	;If Same Exit Back
		ld		de,9																;DE=9 Which is Draw on Right
		jr		nc,Quig_Back_LeftRight_a											;If Pos stay as 9
		ld		de,-1																;DE=-1 which is draw too left
.Quig_Back_LeftRight_a:
		ld		a,112																;This is Layer B Area
		ld		(Quig_g9k_MapA_Meta96or112+1),a					
		ld		l,h:ld h,0
		ld		a,l																	;a=l
		ld		(Quig_G9K_ScrollB_XPosOld),a										;Store New location in Old
		add		hl,de																;Add HL with DE. Xpos strip to draw
		;Put the X into the strip draw
		ld		a,l																	;a = x (0-255)
		rla																			;multiply by 4
		rla																			;
		and		%111100																;Store 
		ld		(Quig_ziggyzag2+1),a
		ex		de,hl																;swap X into de
		
		ld		a,(Quig_G9K_ScrollB_YPosOld)
		and		a
		jr		z,Quig_Back_LeftRight_b
		dec		a
.Quig_Back_LeftRight_b:
		ld		l,a:ld h,0
		dec		a
		ld		(Quig_ziggyzag1+1),a
		add		hl,hl																;Double Y
		ld		bc,Quigs_Map_Edge													;Get Edge Size
		add		hl,bc																;Add
		ld		a,(hl)	
		inc		hl
		ld		h,(hl)																;	
		ld		l,a																	;HL=Map Vertical Address
		add		hl,de																;Add the X to address
		ld		de,#1800															;Map B Offset
		add		hl,de			
		add		hl,hl																;Double to give correct addr
		ld		(Quig_g9k_VertGetAndMap+1),hl
		jp		Quig_Draw_VerticalMetaStrip		
;******************************
.Quig_Fore_LeftRight:
		ld		a,(Quig_G9K_ScrollA_XPosOld)										;Old is Div 32
		ld		b,a																	;B = Old
		ld		hl,(Quig_G9K_ScrollA_XPos)											;HL = Xpos
		add		hl,hl:add hl,hl:add hl,hl:ld a,h									;Hl/32 into H (0.255)
		sub 	b																	;Check against old
		ret 	z 																	;If Same Exit Back
		ld		de,9																;DE=9 Which is Draw on Right
		jr		nc,Quig_Fore_LeftRight_a											;If Pos stay as 9
		ld		de,-1																;DE=-1 which is draw too left
.Quig_Fore_LeftRight_a:
		ld		a,96																;This is Layer A Area
		ld		(Quig_g9k_MapA_Meta96or112+1),a					
		ld		l,h:ld h,0
		ld		a,l																	;a=l
		ld		(Quig_G9K_ScrollA_XPosOld),a										;Store New location in Old
		add		hl,de																;Add HL with DE. Xpos strip to draw
		;Put the X into the strip draw
		ld		a,l																	;a = x (0-255)
		rla																			;multiply by 4
		rla																			;
		and		%111100																;Store 
		ld		(Quig_ziggyzag2+1),a
		ex		de,hl																;swap X into de
		
		ld		a,(Quig_G9K_ScrollA_YPosOld)
		and		a
		jr		z,Quig_Fore_LeftRight_b
		dec		a

.Quig_Fore_LeftRight_b:
		ld		l,a:ld h,0
		dec		a
		ld		(Quig_ziggyzag1+1),a
		add		hl,hl																;Double Y
		ld		bc,Quigs_Map_Edge													;Get Edge Size
		add		hl,bc																;Add
		ld		a,(hl)	
		inc		hl
		ld		h,(hl)																;	
		ld		l,a																	;HL=Map Vertical Address
		add		hl,de																;Add the X to address
		add		hl,hl																;Double to give correct addr
		ld		(Quig_g9k_VertGetAndMap+1),hl
		
;		jp		Quig_Draw_VerticalMetaStrip

;**************************
.Quig_Draw_VerticalMetaStrip:
		di
		call	Quig_g9k_VertGetAndMap					;Draw 1
		call	Quig_g9k_VertGetAndMap					;Draw 2
		call	Quig_g9k_VertGetAndMap					;Draw 3
		call	Quig_g9k_VertGetAndMap					;Draw 4
		call	Quig_g9k_VertGetAndMap					;Draw 5
		call	Quig_g9k_VertGetAndMap					;Draw 6
		call	Quig_g9k_VertGetAndMap					;Draw 7
		call	Quig_g9k_VertGetAndMap					;Draw 8		
		call	Quig_g9k_VertGetAndMap					;Draw 9
		ei
		ret
.Quig_Draw_HorizontalMetaStrip:
		di
		call	Quig_g9k_HoriGetAndMap					;Draw 1
		call	Quig_g9k_HoriGetAndMap					;Draw 2
		call	Quig_g9k_HoriGetAndMap					;Draw 3
		call	Quig_g9k_HoriGetAndMap					;Draw 4
		call	Quig_g9k_HoriGetAndMap					;Draw 5
		call	Quig_g9k_HoriGetAndMap					;Draw 6
		call	Quig_g9k_HoriGetAndMap					;Draw 7
		call	Quig_g9k_HoriGetAndMap					;Draw 8		
		call	Quig_g9k_HoriGetAndMap					;Draw 9
		call	Quig_g9k_HoriGetAndMap					;Draw 10
		call	Quig_g9k_HoriGetAndMap					;Draw 11	
		ei
		ret	


		
;**** Draw Vertical Strip		
.Quig_g9k_VertGetAndMap:
		ld		hl,0									;This is the exact address of foremap data
		ld		a,g9k_READ_ADDR							;Setup a read of foremap data at #70000  
		ld		bc,CG9K_REG_SELECT						;Select
		out		(c),a
		ld		bc,CG9K_REG_DATA						;Do Read
		out		(c),l									;Set low
		out		(c),h									;Set high
		ld		a,7										;a=#07
		out		(c),a									;Set Ultra high	
.Quig_g9k_UpdateMapDirection1:							;either 2 or 2*mapmetawidth		
		ld		de,00									;
		add		hl,de									;Add to existing address
		ld		(Quig_g9k_VertGetAndMap+1),hl			;Store
		ld		bc,CG9K_VRAM							;Now just read the word
		in		l,(c)							
		in		h,(c)									;hl=address of the metatile... so 48 bytes of which we read first 32		
		ld		a,g9k_READ_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,6
		out		(c),l
		out		(c),h
		out		(c),a
.Quig_ziggyzag1:		
		ld		a,0										;StartPos+1
		inc		a
		and		%1111
		ld		(Quig_ziggyzag1+1),a
.Quig_g9k_MapA_Meta96or112:
		add		96      								;96 or 112 Draw to Map B)
		ld		h,a										;h=y
.Quig_ziggyzag2:		
		ld		l,0
		jp		Quig_ZiggyZagJump
		
;**** Horizontal Strip Draw
.Quig_g9k_HoriGetAndMap:
		ld		hl,0									;This is the exact address of foremap data 
		ld		a,g9k_READ_ADDR							;Setup a read of foremap data at #70000  
		ld		bc,CG9K_REG_SELECT						;Select
		out		(c),a
		ld		bc,CG9K_REG_DATA						;Do Read
		ld		a,7										;a=#07		
		out		(c),l									;Set low
		out		(c),h									;Set high
		out		(c),a									;Set Ultra high	
		inc		hl										;Add 2 too HL & Store
		inc		hl
		ld		(Quig_g9k_HoriGetAndMap+1),hl			;Store
		ld		bc,CG9K_VRAM							;Now just read the word
		in		l,(c)							
		in		h,(c)									;hl=address of the metatile... so 48 bytes of which we read first 32

		ld		a,g9k_READ_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,6
		out		(c),l
		out		(c),h
		out		(c),a	
;Put Value 
.Quig_ziggyzag3:		
		ld		h,0										;h = y and %1111 + 96 or 112
.Quig_ziggyzag4:		
		ld		a,0										;a = x*4  
		and		%111100									;go
		ld		l,a										;l=a and %1111
		add		4
		ld		(Quig_ziggyzag4+1),a
.Quig_ZiggyZagJump:		
		add		hl,hl									;hl=hl*2 (or 32)
.Quig_ZiggyZagJumpFromMetaSet:		
		ld		de,128	
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA	
		ld		a,7
		out		(c),l
		out		(c),h
		out		(c),a
		ld		bc,CG9K_VRAM
		in		a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a
		add		hl,de
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,7
		out		(c),l
		out		(c),h
		out		(c),a
		ld		bc,CG9K_VRAM
		in		a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a
		add		hl,de
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,7
		out		(c),l
		out		(c),h
		out		(c),a
		ld		bc,CG9K_VRAM
		in		a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a
		add		hl,de
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		ld		a,7
		out		(c),l
		out		(c),h
		out		(c),a
		ld		bc,CG9K_VRAM
		in		a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a:in a,(c):out(c),a
		ret		