

;LIBRARY SYB.INT.ADD
;*******************
.SyB_INT_Add
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de						;***** Add Integers Together
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FLO.ADD		
;*******************
.SyB_FLO_Add
		call	SyB2_STACK_2_FLO
		call 	FLO_ADD
		jp		SyB_DecStack
;LIBRARY SYB.INT.AND
;*******************
.SyB_INT_And
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		(iy+13)
		ld		(iy+13),a
		ld		a,(iy+8)
		And		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
;LIBRARY SYB.INT.DIV
;*******************
.SyB_INT_Div
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),l
		ld		(iy+14),h
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FLO.DIV		
;*******************
.SyB_FLO_DIV
		call	SyB2_STACK_2_FLO
		call	FLO_DIV
		jp		SyB_DecStack
;LIBRARY SYB.INT.MOD
;*******************
.SyB_INT_MOD:
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),e
		ld		(iy+14),d
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.INT.MUL 	
;*******************
.SyB_INT_Mul
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB_INT_Mul_11		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_INT_Mul_11
		pop		de
		sbc		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FLO.MUL
;********************				
.SyB_FLO_Mul
		call	SyB2_STACK_2_FLO		
		call	FLO_MULT
		jp		SyB_DecStack
;LIBRARY SYB.INT.OR		
;******************
.SyB_INT_Or
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Or		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Or		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.INT.SUB		
;*******************
.SyB_INT_Sub
		ld		iy,(SyB_StackAddr)
		Xor		a
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		sbc		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		
;LIBRARY SYB.FLO.SUB		
;*******************
.SyB_FLO_Sub
		call	SyB2_STACK_2_FLO
		call	FLO_SUB
		jp		SyB_DecStack
;LIBRARY SYB.INT.XOR
;*******************
.SyB_INT_Xor
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Xor		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Xor		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.CLOSE.FILE
;**********************
.SyB_CloseFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_CloseFile_OK_1
		cp		174						;ReadFile
		jp		z,SyB_CloseFile_OK_1
		cp		175						;WriteFile
		jp		z,SyB_CloseFile_OK_1		
		;*** Failed
		ld		de,288					;1 / 32
		jp		SyB_Mark_Error
.SyB_CloseFile_OK_1:
		push	hl
		pop		ix
		ld		a,(ix+1)
		cp		1
		jp		nz,SyB_CloseFile_OK_2
		;*** Must write file
		call	SyB_Write_512_Bytes
.SyB_CloseFile_OK_2:
		ld		(ix+0),0
		ld		a,(ix+3)
		call	SyFile_FILCLO
		ld		iy,(Syb_StackAddr)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.CLOSE.FORM
;***********************
.SyB_CloseForm:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		call	SyB_Studio_CloseForm
		ld		a,(SyB_Studio_FormOS)
		call	SyDesktop_WINCLS
		ret		

;LIBRARY SYB.EVENT.CONTROL
;*************************
.SyB_Event_Control
		ld		bc,(Event_Control_ID)
		ld		a,b
		ld		de,ControWindowDataList
		rra
		and		%11100
		ld		l,a
		ld		h,0
		add		hl,de
		bit		0,b
		jr		z,SyB_Event_Control_2
		inc		hl						;Was a Tool so add 2 to HL
		inc		hl
.SyB_Event_Control_2		
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,c
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
;LIBRARY SYB.EVENT.DISPLAY
.SyB_Event_Display
		ld		hl,(Event_Control_ID)
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),l
		xor		a
		ld		(iy+2),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
		
;LIBRARY SYB.CONTROL.TEXT.SET
;****************************
.SyB_SetObjText:
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		push	hl
		pop		ix
		ld		a,(ix+2)
		cp		32
		jp		z,SyB_SetObjText_Textline
		ld		e,a
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_SetObjText_Empty	
		bit		7,a
		jp		z,SyB_SetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111		
		jp		SyB_SetObjText_3
		
.SyB_SetObjText_2
		push	ix
		pop		hl
.SyB_SetObjText_3
		ld		e,a
		ld		d,0
		add		hl,de
.SyB_SetObjText_4		
		call	SyB_Str_Store_2_Ram
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
.SyB_SetObjText_Textline:		
		ld		l,(ix+4)
		ld		h,(ix+5)		
		push	hl
		pop		ix
		ld		a,(ix+10)
		ld		e,(iy+9)
		cp		e
		jp		nc,SyB_SetObjText_Textline_2
		ld		(iy+9),a
.SyB_SetObjText_Textline_2:		
		ld		a,(iy+9)
		ld		(ix+8),a
		jp		SyB_SetObjText_4
.SyB_SetObjText_Empty:
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret		

;LIBRARY SYB.MATH.RAD
;********************
.SyB_Rad:
		Xor		a
		ld		(FLO_VALUE_DEGRAD),a
		ret

;LIBRARY SYB.MATH.RND
;********************
.SyB_RND
		ld		hl,(SyB_StackAddr)
		inc		hl
		call	FLO_RND
		ex		de,hl
		ld		hl,6
		add		hl,de
		call 	FLO_MULT
		ret

;LIBRARY SYB.MATH.LEN
;********************
.SyB_LEN
		ld		hl,(SyB_StackAddr)
		ld		bc,9
		add		hl,bc
		ld		c,(hl)
		dec		hl
		Xor		a
		ld		(hl),a
		dec		hl
		ld		(hl),c
		dec		hl
		ld		(hl),a
		ld		hl,(SyB_StrStackAddr)
		Xor		a
		ld		b,0
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ret
		
;LIBRARY SYB.MATH.SQR
;********************
.SyB_SQR
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SQR

;LIBRARY SYB.MATH.TAN
;********************
.SyB_TAN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_TAN
		
;LIBRARY SYB.MATH.ATAN
;*********************
.SyB_ATAN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_ARC_TAN
		
;LIBRARY SYB.MATH.ABS
;********************
.SyB_Abs_Int
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		z
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret
.SyB_Abs_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		res		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret		

;LIBRARY SYB.MATH.SGN
;********************
.SyB_Sgn_Int
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		nz
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret	
;**** Do Float SGN ****
.SyB_Sgn_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		set		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret			
		
;LIBRARY SYB.MATH.NEG
;********************
.SyB_Neg_Int
		ld		iy,(Syb_StackAddr)
.SyB_Neg_Int_10		
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret
;**** Do Float NEG ****
.SyB_Neg_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		Xor		128							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret		
		
;LIBRARY SYB.MATH.SIN
;*********************
.SyB_SIN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SIN
		
;LIBRARY SYB.MATH.COS
;********************
.SyB_COS
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_COS
		
;LIBRARY SYB.MATH.DEG
;*********************
.SyB_Deg
		ld		a,1
		ld		(FLO_VALUE_DEGRAD),a
		ret	
		
;LIBRARY SYB.MATH.LOG		
;********************
.SyB_LOG
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_NAT

;LIBRARY SYB.MATH.LOG10	
;**********************
.SyB_LOG10
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_DEC
		
;LIBRARY SYB.MATH.NOT
;********************
.SyB_NOT
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)					
		And		a
		jr		nz,SyB_Not_2
		ld		a,(iy+8)
		And		a
		jr		nz,SyB_Not_2
		ld		(iy+7),1
		jr		SyB_Not_3
.SyB_Not_2		;**** Means <>0 SO Result = 0
		ld		(iy+7),0
.SyB_Not_3
		ld		(iy+8),0
		ret		

;LIBRARY SYB.MATH.RANDOMIZE
;**************************
.SyB_Randomize
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		call	FLO_RANDOMIZE
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc		
		ld		(SyB_StackAddr),hl
		ret
		
;LIBRARY SYB.MATH.ASC
;*********************
.SyB_ASC
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)					;**** Address of Text
		ld		d,(iy+8)					;**** Address of Text
		ld		c,(iy+9)					;**** Len of text
		ld		a,(de)
		ld		(iy+7),a
		ld		(iy+8),0
		Xor		a
		ld		hl,(SyB_StrStackAddr)
		ld		b,0
		sbc		hl,bc
		ld		(syB_StrStackAddr),hl
		ret
		
;LIBRARY SYB.MATH.EXP
;********************
.SyB_EXP
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_POT_E


;LIBRARY SYB.APP.EXECUTE
;************************
.SyB_Execute:
		ld		iy,(Syb_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(AppBnkNum)
		set		7,a
		call	SySystem_PRGRUN
		ld		iy,(Syb_StackAddr)
		ld		(iy+7),a
		xor 	a
		ld		(iy+8),a
		ret		

;LIBRARY SYB.APP.BANKSIZE
;*************************
.SyB_BankSize
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_BankSize_Error
		ld		de,4
		add		hl,de
		ld		a,(hl)
		inc		hl
		ld		(iy+7),a
		ld		a,(hl)
		ld		(iy+8),a
		ret
.SyB_BankSize_Error			
		ld		(iy+7),0
		ld		(iy+8),0
		ret
		
;LIBRARY SYB.APP.BANK.EMPTYSLOT		

;LIBRARY SYB.APP.CREATEBANK 
;**************************
.SyB_CreateBank
		ld		iy,(SyB_StackAddr)
		;**** File a memory Slot
		inclib	SYB.APP.MEMSLOT.AVAILABLE
		call	SyB_Mem_Slot_Available
		jp		nz,SyB_CreateBank_Error
SyB_CreateBank_FoundSlot
		ld		c,(iy+7)
		ld		b,(iy+8)
		push	bc
		push	hl
		Xor		a
		ld		e,a
		rst		#20
		dw		#8118
		pop		de
		jp		c,SyB_CreateBank_Error		
		ex		de,hl
		ld		c,172
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(hl),c
		inc		hl
		ld		(hl),a							;Stores Bank
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		pop		bc
		ld		(hl),c
		inc		hl
		ld		(hl),b		
		ret
SyB_CreateBank_Error
		pop		hl
		ld		(iy+7),0
		ld		(iy+8),0
		ret
		
		
;LIBRARY SYB.APP.CLEARBANK
;*************************
.SyB_ClearBank
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		nz,SyB_ClearBank_3
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		ld		e,c
		ld		d,b
.SyB_ClearBank_2		
		ld		b,0
		rst		#20:	dw #812D
		dec		e
		jp		nz,SyB_ClearBank_2
		dec		d
		jp		nz,SyB_ClearBank_2		
.SyB_ClearBank_3
		ret		
		
;LIBRARY SYB.APP.FREEBANK
;*************************
.SyB_FreeBank
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		z,SyB_FreeBank_4
		cp		180					;Free Sheet
		jp		nz,SyB_FreeBank_3
.SyB_FreeBank_4		
		Xor		a
		ld		(hl),a
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl		
		rst 	#20:dw 	#811B
SyB_FreeBank_3
		ret
		

		
;LIBRARY SYB.APP.LOADSHEET
;*************************
.SyB_LoadSheet:
		call	SyB_GetOpenAFile
		jp		c,SyB_LoadSheet_Fail_11
		ld		(SyB_LoadSheet_fileHandle),a
		;Find Length
		ld		iy,0
		ld		ix,0
		ld		c,2
		call	SyFile_FILPOI
		ld		(SyB_LoadSheet_fileLength),ix
		;Reset to Start
		ld		a,(SyB_LoadSheet_fileHandle)
		ld		ix,0
		ld		iy,0
		ld		c,0
		call	SyFile_FILPOI		
		;Find a Slot in Ram
		ld		bc,(SyB_LoadSheet_fileLength)
		Xor		a					;A = 0 - Look in any RamBank
		ld		e,1					;E = 1 - Look only in Data Areas
		rst 	#20:dw #8118
		jp		c,SyB_LoadSheet_Fail_2
		ld		(SyB_LoadSheet_fileBank),a
		ld		(SyB_LoadSheet_fileStart),hl
		;Find slot in List
		inclib	SYB.APP.MEMSLOT.AVAILABLE
		call	SyB_Mem_Slot_Available
		jp		nz,SyB_LoadSheet_Fail_1
.SyB_LoadSheetBank_FoundSlot
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		c,180
		ld		(hl),c					;180 Represents Sheet
		inc		hl
		ld		a,(SyB_LoadSheet_fileBank)
		ld		(hl),a					;Bank to Store
		inc		hl
		ld		de,(SyB_LoadSheet_fileStart)
		ld		(hl),e					;Where stored Low
		inc		hl
		ld		(hl),d					;Where Stored High
		inc		hl
		ld		bc,(SyB_LoadSheet_fileLength)
		ld		(hl),c					;Length
		inc		hl
		ld		(hl),b					;Length
		;Load Data into Slot
		
		push	ix
		push	iy
		ex		de,hl					;HL = Where
		ld		e,a						;E = Destination Bank
		ld		a,(SyB_LoadSheet_fileHandle)
		call	SyFile_FILINP
		;Close file
		ld		a,(SyB_LoadSheet_fileHandle)		
		call	SyFile_FILCLO
		pop		iy
		pop		ix
		
		;Get Number of Tiles
		ld		a,(SyB_LoadSheet_fileBank)
		ld		hl,(SyB_LoadSheet_fileStart)
		rst 	#20:dw #8124
		ld		(SyB_LoadSheet_fileTile),bc
		;Modify Addresses
.SyB_LoadSheetBank_MakeChanges
		Xor 	a
		cp		c
		jp		nz,SyB_LoadSheetBank_MakeChanges_2
		cp		b
		jp		z,SyB_LoadSheetBank_Finished
.SyB_LoadSheetBank_MakeChanges_2
		ld		a,(SyB_LoadSheet_fileBank)		
		push	hl
		push	hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,3					;We need Word 3/4 (Graphic Data Offset)
		add		hl,bc					;Adds 3
		push	hl						;Stores HL
		ld		bc,9					;Address we want to put in is +9 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 3/4 (Graphic Data Offset)
		rst 	#20:dw #8127			;Stores BC into (A HL)
		pop		hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,5					;We need Word 5/6 (Encode Data Byte Address)
		add		hl,bc					;Adds 5
		push	hl						;Stores HL
		ld		bc,4					;Address we want to put in is +4 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 5/6 (Encode Address)
		rst 	#20:dw #8127			;Stores BC into (A HL)		
		pop		hl
		inc		hl
		inc		hl
		ld		bc,(SyB_LoadSheet_fileTile)
		dec		bc
		ld		(SyB_LoadSheet_fileTile),bc
		jp		SyB_LoadSheetBank_MakeChanges
		;Done it
.SyB_LoadSheetBank_Finished		
		ret
		
.SyB_LoadSheet_Fail_11
		ld a,1
		nop
		nop
		di
.shee11	jr		shee11		

.SyB_LoadSheet_Fail_1
		ld a,1
		nop
		nop
		di
.shee	jr		shee		
.SyB_LoadSheet_Fail_2				;**** Not enough Memory free
		di
.shee2	jr		shee2		

.SyB_LoadSheet_fileHandle:	db	0
.SyB_LoadSheet_fileLength:	dw	0
.SyB_LoadSheet_fileStart:	dw	0
.SyB_LoadSheet_fileBank:	db	0
.SyB_LoadSheet_fileTile:	dw	0


;LIBRARY SYB.APP.MEMSLOT.AVAILABLE
;*********************************
;OUT HL - Address of memslot
;OUT NZ - Failed
.SyB_Mem_Slot_Available
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,23							;Number of Banks Possible-1
		ld		de,6							;Bytes to jump (Each Bank Ref is 6 bytes)
		Xor		a								;A=0
.SyB_Mem_Slot_Available_1			
		cp		(hl)
		ret		z	
		add		hl,de
		djnz	SyB_Mem_Slot_Available_1
		ret

;LIBRARY SYB.IF
;***************
.SyB_IF
		ld		bc,6
		ld		hl,(SyB_StackAddr)
		add		hl,bc
		ld		(Syb_StackAddr),hl		
		Xor		a
		inc		hl
		cp		(hl)					;7
		jr		nz,SyB_IF_2_1
		inc		hl
		cp		(hl)					;7
		jr		nz,SyB_IF_2_1
.SyB_IF_1								;So The result was False
		pop		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		jp		(hl)
.SyB_IF_2_1		
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)				
;LIBRARY SYB.FILE.OPEN		
;********************
.SyB_OpenFile:
		inclib	SYB.FREE.SLOT
		inclib	SYB.GETOPENAFILE
		call	SyB_GetOpenAFile
		jp		c,SyB_OpenFile_Fail_1
.SyB_OpenFile_Ok_1
		ld		(SyB_OpenFile_Temp),a			;OS File Number
		call	SyB_FreeFileSlot		
		jp		c,SyB_OpenFile_Fail_2
.SyB_OpenFile_Ok_2
		ld		iy,(SyB_StackAddr)		
		ld		(iy+7),l
		ld		(iy+8),h
		push	hl
		pop		ix
		Xor		a
		ld		b,9
.SyB_OpenFile_Ok_20
		ld		(hl),a
		inc		hl
		djnz	SyB_OpenFile_Ok_20
		ld		(ix+0),173
		ld		a,(SyB_OpenFile_Temp)
		ld		(ix+3),a
		inclib	SYB.READ.512
		call	SyB_Read_512_Bytes
		ret
.SyB_OpenFile_Fail_1
		ld		e,a
		ld		d,11
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),0
		ld		(iy+8),0
		jp		SyB_Mark_Error
.SyB_OpenFile_Fail_2		
		ld		e,32
		jr		SyB_OpenFile_Fail_1
.SyB_OpenFile_Temp:		db	0
;LIBRARY SYB.GETOPENAFILE
;************************
.SyB_GetOpenAFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)					;Start of String
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		a,(iy+9)					;Length		
		And		a							;If Length Zero
		jp		z,SyB_GetOpenAFile_Fail		;So Fail if zero
		ld		b,0	
		ld		de,(SyB_File_Name_Input)	;DE=Filename/Path		
		ld		c,a							;c=length
		ldir								;repeat
		Xor		a							;put a zero ender in the string
		ld		(de),a						;
		ld		a,(appBnkNum)
		ld		hl,(SyB_File_Name_Input)
		db		#DD,#67
		call	SyFile_FILOPN
		jr		nc,SyB_GetOpenAFile_Ok
		;**** Okay it failed ****
.SyB_GetOpenAFile_Fail:
		scf
.SyB_GetOpenAFile_Ok:		
		ret
;LIBRARY SYB.WRITE.BYTE.TO.FILE		
;**** File Thing is
;**** 0 -
;**** 1 - Write Byte set?
;**** 2 -
;**** 3 -
;**** 4 - File Pos Addr 1
;**** 5 - File Pos Addr 2
;**** 6 - File Pos Addr 3
;**** 7 - File Pos Addr 4
;**** 8 - Segment Length 1
;**** 9 - Segment Length 2
.SyB_Write_Byte_To_File
		ld		(ix+1),1					;*** Set Writing Byte
		push	ix						
		pop		hl							;*** HL=IX
		ld		bc,10
		add		hl,bc						;*** HL=IX+10
		ld		e,(ix+4)
		ld		d,(ix+5)
		add		hl,de
		ld		(hl),a						;**** Has copied in proper Position
		;**** Check if 511
		ld		a,e
		cp		255
		jp		nz,SyB_Write_Byte_To_File_2
		ld		a,d
		And		%1
		jp		nz,SyB_Write_Byte_To_File_2
		;So is a save time!
		call	SyB_Write_512_Bytes
;**** Definately not saving (not 511)		
.SyB_Write_Byte_To_File_2
		push	ix
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		ix,1
		ld		iy,0
		call	SyB_Math_Add32
		pop		ix
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		;**** Check FilePos against Length
		ld		a,h
		And		%1
		ld		h,a
		ld		e,(ix+8)
		ld		d,(ix+9)
		Xor 	a
		push	hl
		sbc		hl,de
		pop		hl
		jp		nc,SyB_Write_Byte_To_File_4
		ret
.SyB_Write_Byte_To_File_4	
		ld		(ix+8),l
		ld		(ix+9),h
		ret			
;LIBRARY SYB.READ.BFF 
;********************
;Input IX = File Data 
.SyB_Read_BFF
		;**** Lets get the Byte reading ****
		ld		l,(ix+4)
		ld		a,(ix+5)
		And		%1
		ld		h,a
		
		ld		e,(ix+8)
		ld		d,(ix+9)
		push	hl
		sbc		hl,de
		pop		hl
		jp		nc,SyB_Read_Eof
		
		push	ix
		pop		de
		add		hl,de
		ld		bc,10
		add		hl,bc
		ld		a,(hl)
		ld		(SyB_Read_Byte_From_File_Byte),a
		;**** Lets add 1 to filepointer ****
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		push	ix
		ld		ix,1
		ld		iy,0				
		call	SyB_Math_Add32
		pop		ix		
			
		Xor		a
		cp		l
		jp		nz,SyB_Read_BFF_3
		ld		a,h
		And		%1
		jp		nz,SyB_Read_BFF_3
		;**** Check if we need to write the old stuff
		push	hl
		push	de
		ld		a,(ix+1)
		cp		1
		jp		nz,SyB_Read_BFF_99
		inclib	SYB.WRITE.512
		call	SyB_Write_512_Bytes
.SyB_Read_BFF_99
		inclib	SYB.READ.512
		call	SyB_Read_512_Bytes
		pop		de
		pop		hl		
		
.SyB_Read_BFF_3
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		ld		a,(SyB_Read_Byte_From_File_Byte)
		ret
.SyB_Read_Byte_From_File_Byte:		db 	0

.SyB_Read_Eof
		ld		a,0	
		ret			
;LIBRARY SYB.WRITE.512		
;IX=Address of File Data Header
.SyB_Write_512_Bytes
		;**** First must reset File Pointer 
		ld		a,(ix+5)				;Get Pointer down to last 512
		And		%11111110
		ld		b,a
		ld		c,0
		ld		e,(ix+6)
		ld		d,(ix+7)
		ld		a,(ix+3)
		push	ix
		ld		c,0						;C=0 FileBegin
		push	bc
		push	de
		pop		iy
		pop		ix
		call	SyFile_FILPOI
		pop		ix
		;**** Back to save
		push	ix
		pop		hl
		ld		bc,10
		add		hl,bc					;HL = Start of Data
		ld		(ix+1),0				;Set write Byte to Zero
		ld		a,(AppBnkNum)
		ld		e,a						;E = Ram Bank
		ld		a,(ix+3)				;A = OS Reference
		ld		c,(ix+8)				;BC = Length to write
		ld		b,(ix+9)
		push	ix
		push	bc
		push	ix
		call	SyFile_FILOUT
		pop		ix
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		e,(ix+6)
		ld		d,(ix+7)
		pop		ix						;IX = BC
		ld		iy,0
		call	SyB_Math_Add32
		pop		ix
		ld		(ix+4),l
		ld		(ix+5),h
		ld		(ix+6),e
		ld		(ix+7),d
		ld		(ix+8),0
		ld		(ix+9),0
		ret
;LIBRARY SYB.READ.512
;********************
.SyB_Read_512_Bytes
		push	ix
		pop		hl
		ld		bc,10
		add		hl,bc
		ld		a,(AppBnkNum)
		ld		e,a
		ld		a,(ix+3)
		ld		bc,512
		push	ix
		call	SyFile_FILINP
		pop		ix
		ld		(ix+1),0
		ld		(ix+8),c
		ld		(ix+9),b
		ret	
;LIBRARY SYB.FILE.BYTE.WRITE		
;***************************
.SyB_WriteByte
		inclib	SYB.WRITE.BYTE.TO.FILE
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteByte_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteByte_OK_1
		;*** Failed
		ld		e,a
		ld		d,20
		call	SyB_Mark_Error
		jr		SyB_WriteByte_2
.SyB_WriteByte_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
.SyB_WriteByte_2		
		ld		iy,(SyB_StackAddr)
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FILE.FLOAT.WRITE
;****************************
.SyB_WriteFloat
		inclib	SYB.WRITE.BYTE.TO.FILE
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteFloat_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteFloat_OK_1
		;*** Failed
		ld		d,21
		ld		e,a
		call	SyB_Mark_Error
		jr		SyB_WriteFloat_2
.SyB_WriteFloat_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+9)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)						
		ld		a,(iy+11)
		call	SyB_Write_Byte_To_File
SyB_WriteFloat_2	
		ld		iy,(SyB_StackAddr)	
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.FILE.INT.WRITE
;**************************
.SyB_WriteInt
		inclib	SYB.WRITE.BYTE.TO.FILE
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteInt_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteInt_OK_1
		;*** Failed
		ld		e,32
		ld		d,15
		call	SyB_Mark_Error
		jr		SyB_WriteInt_2
.SyB_WriteInt_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		a,(iy+7)
		call	SyB_Write_Byte_To_File
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		call	SyB_Write_Byte_To_File
.SyB_WriteInt_2:		
		ld		iy,(SyB_StackAddr)
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FILE.LINE.WRITE
;***********************
.SyB_WriteLine
		inclib	SYB.WRITE.BYTE.TO.FILE
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)	
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_WriteLine_OK_1
		cp		175						;WriteFile
		jp		z,SyB_WriteLine_OK_1
		;*** Failed
		ld		e,a
		ld		d,18
		call	SyB_Mark_Error
		jr		SyB_WriteLine_4
.SyB_WriteLine_OK_1:
		push	hl
		pop		ix						;IX=Start of File Data
		ld		b,(iy+9)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		a,b
		And		a
		jp		z,SyB_WriteLine_OK_3	
.SyB_WriteLine_OK_2:
		ld		a,(de)	
		inc		de
		push	bc
		push	de
		call	SyB_Write_Byte_To_File
		pop		de
		pop		bc
		dec		b
		ld		a,b
		And		a
		jp		nz,SyB_WriteLine_OK_2
.SyB_WriteLine_OK_3:		
		ld		a,13
		call	SyB_Write_Byte_To_File
.SyB_WriteLine_4:
		ld		iy,(SyB_StackAddr)
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FILE.BYTE.READ		
;**************************
.SyB_ReadByte
		inclib SYB.READ.BFF
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadByte_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadByte_OK_1
		;*** Failed
		ld		d,22
		ld		e,33
		jp		SyB_Mark_Error
.SyB_ReadByte_OK_1:
		push	hl
		pop		ix		
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)		
		ld		(iy+7),a
		ld		(iy+8),0
		ret
;LIBRARY SYB.FILE.FLOAT.READ
;***************************
.SyB_ReadFloat
		inclib 	SYB.READ.BFF
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadFloat_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadFloat_OK_1
		;*** Failed
		ld		d,23
		ld		e,33
		jp		SyB_Mark_Error
.SyB_ReadFloat_OK_1:
		push	hl
		pop		ix
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+8),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+10),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+11),a				
		ret
.SyB_ReadFloat_Temp:	dw	0
					
;LIBRARY SYB.FILE.INT.READ		
;*************************
.SyB_ReadInt
		inclib SYB.READ.BFF
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadInt_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadInt_OK_1
		;*** Failed
		ld		d,24
		ld		e,33
		jp		SyB_Mark_Error
.SyB_ReadInt_OK_1:
		push	hl
		pop		ix
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		call	SyB_Read_BFF
		ld		iy,(SyB_StackAddr)
		ld		(iy+8),a				
		ret
.SyB_ReadInt_Temp:	dw	0
;LIBRARY SYB.FILE.LINE.READ
;**************************
.SyB_ReadLine
		inclib 	SYB.READ.BFF
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		173						;OpenFile
		jp		z,SyB_ReadLine_OK_1
		cp		174						;ReadFile
		jp		z,SyB_ReadLine_OK_1
		;*** Failed
		ld		d,25
		ld		e,33
		jp		SyB_Mark_Error
.SyB_ReadLine_OK_1:
		ld		de,(SyB_StrStackAddr)
		ld		(iy+7),e
		ld		(iy+8),d
		ld		b,0
		ld		c,0
		push	hl
		pop		ix
.SyB_ReadLine_OK_2		
		push	de
		push	bc
		call	SyB_Read_BFF
		pop		bc
		pop		de
		cp		13
		jp		z,SyB_ReadLine_FinishedReading		
		cp		10
		jp		nz,SyB_ReadLine_OK_3
		ld		r,a
		Xor		a
		cp		c
		jp		nz,SyB_ReadLine_OK_3
		ld		c,1
		jp		SyB_ReadLine_OK_2		
.SyB_ReadLine_OK_3
		ld		c,1
		inc		b
		ld		(de),a
		inc		de
		ld		a,b
		cp		251
		jp		c,SyB_ReadLine_OK_2
.SyB_ReadLine_FinishedReading
		ld		(SyB_StrStackAddr),de
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),b
		ret		
		
		
;LIBRARY SYB.APP.POKEBYTE
;************************
.SyB_PokeByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeByte_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		b,(iy+7)
		rst	 	#20
		dw 		#812D
.SyB_PokeByte_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret
		
;LIBRARY SYB.APP.POKEFLOAT
;*************************
.SyB_PokeFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeFloat_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
		ld		c,(iy+9)
		ld		b,(iy+10)
		rst	 	#20
		dw 		#8127
		ld		b,(iy+11)		
		rst	 	#20
		dw 		#812D
.SyB_PokeFloat_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret			
		
;LIBRARY SYB.APP.POKEINT
;***********************
.SyB_PokeInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeInt_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
.SyB_PokeInt_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret		
		
;LIBRARY SYB.APP.PEEKBYTE
;************************
.SyB_PeekByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekByte_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#812A
		ld		(iy+13),b
		ld		(iy+14),0
.SyB_PeekByte_1		
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekByte_2			
		Xor		a
		ld		(iy+7),a
		ld		(iy+8),a
		jp		SyB_PeekByte_1

;LIBRARY SYB.APP.PEEKINT
;************************
.SyB_PeekInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekInt_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
.SyB_PeekInt_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekInt_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		jp		SyB_PeekInt_1

;LIBRARY SYB.APP.PEEKFLOAT
;*************************
.SyB_PeekFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekFloat_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de		
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
		rst 	#20
		dw		#8124
		ld		(iy+15),c
		ld		(iy+16),b
		rst 	#20
		dw		#812A
		ld		(iy+17),b		
.SyB_PeekFloat_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekFloat_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		ld		(iy+15),a
		ld		(iy+16),a
		ld		(iy+17),a
		jp		SyB_PeekFloat_1
		
;LIBRARY SYB.FORM.OPEN
;*********************
.SyB_OpenForm:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		call	SyB_Studio_WindowOpen
		jp		c,SyB_OpenForm_2
		inc		a
.SyB_OpenForm_2
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		ld		(iy+8),0		
		ret		
		
;LIBRARY SYB.APP.DIALOG
;***********************
.SyB_Dialog
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		%1111
		add		a
		add		a
		add		2
		ld		(SyB_Dialog_Info_1+2),a
		ld		(SyB_Dialog_Info_2+2),a
		ld		(SyB_Dialog_Info_3+2),a				
		ld		e,(iy+21)				;Originals stack length
		ld		hl,(SyB_StrStackAddr)
		ld		d,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		ld		c,e
		
		ld		e,(iy+19)				;DE = Address of Text
		ld		d,(iy+20)		
		ld		hl,SyB_Dialog_Info_Text_1	
		
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_2
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_3
		call	SyB_Dialog_Text_Copier					
		
		ld		hl,SyB_Dialog_Info_1
		ld		a,(iy+13)
		And		%11
		ld		e,a
		set 	7,e
		push	iy
		ld		a,(appBnkNum)
		call	SySystem_SYSWRN
		
.SyB_Dialog_Control_Loop:
		call	SymStudio_App_Wait_Message	;**** See what Event has occurre
		jr		nc,SyB_Dialog_Control_Loop_0
		cp		157
		jr		nz,SyB_Dialog_Control_Loop_0
		ld		a,(Event_Form_ID)			;Position 1
		jp		SyB_Dialog_Control_Loop_2
		cp		0
		jp		nz,SyB_Dialog_Control_Loop_2
.SyB_Dialog_Control_Loop_0
		;Xor		a
		;ld		(V_App_In_Use),a
		jr		SyB_Dialog_Control_Loop
.SyB_Dialog_Control_Loop_2
		pop		iy
		ld		(iy+19),a
		ld		(iy+20),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
;**** Copies Text from DE into HL ****
;**** C=Length left
.SyB_Dialog_Text_Copier		
		ld		b,31
.SyB_Dialog_Loop_1		
		ld		a,c
		Or		a
		jp		z,SyB_Dialog_Loop_2
		dec		c
		ld		a,(de)
		inc		de
		cp		"|"			
		jp		z,SyB_Dialog_Loop_2
		ld		(hl),a
		inc		hl
		dec		b
		djnz	SyB_Dialog_Loop_1
.SyB_Dialog_Loop_2
		Xor		a
		ld		(hl),a
		ret		

;***** STRING AREA *****
;***********************		
;LIBRARY SYB.STRING.MID
;**********************
.SyB_MID
		ld		ix,(SyB_StackAddr)
		ld		c,(ix+7)				;Length Required
		ld		a,(ix+13)				;From Where
		;Must check A (From Where)>0
		dec 	a
		ld		l,a
		ld		h,0
		ld		a,(ix+21)				;Originals stack length
		ld		e,(ix+19)
		ld		d,(ix+20)
		sub		l
		ld		b,a
		jp		c,SyB_MID_Empty
		add		hl,de
		Xor		a
		ld		(SyB_MidTemp),a
.SyB_MID_2	
		ld		a,(SyB_MidTemp)
		cp		b
		jr		z,SyB_MID_3
		cp		c
		jr		z,SyB_MID_3
		inc		a
		ld		(SyB_MidTemp),a
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		jr		SyB_MID_2
.SyB_MID_3	
		ld		e,(ix+19)
		ld		d,(ix+20)
		ld		l,a
		ld		h,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		jr		SyB_MID_4
.SyB_MID_Empty
		Xor		a
		ld		(ix+21),a
		ld		(SyB_StrStackAddr),de
.SyB_MID_4
		ld		(ix+21),a
		ld		hl,(SyB_StackAddr)
		ld		bc,12
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret	
.SyB_MidTemp		db	0
		

;LIBRARY SYB.STRING.TRIM
;***********************
.SyB_Trim
		ld		ix,(SyB_StackAddr)
		ld		a,(ix+9)
		Or		a
		ret		z
		ld		l,(ix+7)
		ld		h,(ix+8)
		
		ld		e,a				;This is the length
		ld		d,0
		ld		bc,0
.SyB_Trim_3		
		ld		a,(hl)
		cp		#20
		jp		nz,SyB_Trim_2
		inc		bc
		inc		hl
		inc		d
		dec		e
		jp		nz,SyB_Trim_3
.SyB_Trim_2
		ld		a,(ix+9)
		sub		d
		ld		(ix+9),a
		ld		c,a
		ld		b,0
		push	de
		ld		e,(ix+7)
		ld		d,(ix+8)
		Or		a
		jp		z,SyB_Trim_4
		ld		a,e
		cp		l
		jp		z,SyB_Trim_4
		ldir
.SyB_Trim_4		
		pop		de
		ld		c,d
		ld		b,0
		ld		hl,(SyB_StrStackAddr)
		Xor		a
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ret

;LIBRARY SYB.STRING.UCASE
;************************
.SyB_UCase
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		b,(hl)	
		ex		de,hl
.SyB_UCase_1
		ld		a,(hl)
		cp 		97
		jr		c,SyB_UCase_3
		cp		123
		jr		nc,SyB_UCase_3
		sub		32
		ld		(hl),a
.SyB_UCase_3
		inc		hl
		djnz	SyB_UCase_1
		ret

;LIBRARY SYB.STRING.STR
;**********************
.SyB_Str
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		call	SyB_Str_2
		ld		ix,(SyB_StackAddr)
		ld		hl,(SyB_StrStackAddr)
		ld		(ix+6),5
		ld		(ix+7),l
		ld		(ix+8),h
		ld		(Syb_StrStackAddr),de
		ex		de,hl
		Xor		a
		sbc		hl,de
		ld		(ix+9),l
		ret
.SyB_Str_2
 		push	de
        ex		de,hl
        call 	dspget
        pop 	hl		
        jp 		dsptxt

;LIBRARY SYB.STRING.LEFT
;***********************
.SyB_Left
		ld		ix,(SyB_StackAddr)
		ld		b,(ix+7)
		ld		a,(ix+15)				;Originals stack length
		sub		b
		ret		c
		ld		(ix+15),b
		ld		c,a
		ld		b,0
		Xor		a						;Sets no carry flag etc
		ld		hl,(SyB_StrStackAddr)
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret		

;LIBRARY SYB.STRING.LCASE
;************************
.SyB_LCase
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(iy+9)
		cp		0
		ret		z
		ld		b,a

.SyB_LCase_1
		ld		a,(hl)
		cp 		65
		jr		c,SyB_LCase_3
		cp		91
		jr		nc,SyB_LCase_3
		add		32
		ld		(hl),a
.SyB_LCase_3
		inc		hl
		djnz	SyB_LCase_1
		ret
		
;LIBRARY SYB.STRING.RIGHT
;*************************
.SyB_Right
		ld		iy,(SyB_StackAddr)
		ld		c,(iy+7)				;Length Required
		ld		a,(iy+15)				;Originals stack length
		sub		c
		jp		c,SyB_Right_1
		ld		b,a
		ld		e,(iy+13)				;DE=start of text on stack
		ld		d,(iy+14)	
		ld		(iy+15),c				;Store new length
		ld		a,c
		And		a
		jp		z,SyB_Right_1
		ld		l,b
		ld		h,0
		add		hl,de					;HL = Start of text
		ld		b,0
		ldir
		ld		(SyB_StrStackAddr),hl
.SyB_Right_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
		
;LIBRARY SYB.STRING.CHR
;**********************
.SyB_Chr
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),1
		ld		(hl),a
		inc		hl
		ld		(SyB_StrStackAddr),hl
		ret		
		
;LIBRARY SYB.MOUSE.X
;*********************
.SyB_MouseX:
		rst 	#20
		dw 		#813C	
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),e
		ld		(iy+2),d
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;LIBRARY SYB.MOUSE.Y
;*********************
.SyB_MouseY:
		rst 	#20
		dw 		#813C
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;LIBRARY SYB.MOUSE.KEY
;*********************
.SyB_MouseKey:
		rst 	#20
		dw 		#813F
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret			
		
;LIBRARY SYB.FORM.REFRESH.PARTS
;******************************
.SyB_RefreshStatus:
		call	SyB_RefreshFormPart
		jp		SyDesktop_WINSTA
.SyB_RefreshTitle
		call	SyB_RefreshFormPart
		jp		SyDesktop_WINTIT
.SyB_RefreshStatus:
		call	SyB_RefreshFormPart
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage	
.SyB_RefreshFormPart		
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
		
;LIBRARY SYB.FORM.SIZE.POS		
;*************************
.SyB_SetFormPos
		call	SyB_SetFormPosSize
		jp		SyDesktop_WINMOV
.SyB_SetFormSize
		call	SyB_SetFormPosSize
		jp		SyDesktop_WINSIZ		
;****                    ****		
.SyB_SetFormPosSize
		ld		iy,(SyB_StackAddr)
		ld		hl,SyB_Studio_FormIDs-1			;**** Point to Start of Window List
		ld		e,(iy+19)					
		ld		d,0
		add		hl,de							;**** Calc Position	
		ld		a,(hl)							;**** Checks if exists
		ld		e,(iy+13)
		ld		d,(iy+14)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.FILE.EXIST
;**********************
.SyB_FileExist
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(appBnkNum)
		db		#DD,#67
		ld		a,0
		ld		c,0
		call	SyFile_DIRPRR
		cp		0
		jr		z,SyB_FileExist_Yes
		cp		13
		jr		z,SyB_FileExist_No		
		di
.kaf	jr		kaf
.SyB_FileExist_Yes
		ld		hl,1
		jr		SyB_FileExist_Finish
.SyB_FileExist_No
		ld		hl,0
.SyB_FileExist_Finish
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ret		

;LIBRARY SYB.FILE.DIALOG
;**********************
.SyB_DirDialog:
		ld		a,(AppBnkNum)
		set		7,a
		jr		SyB_FileDialog
.SyB_OpenDialog:
		ld		a,(AppBnkNum)
		jr		SyB_FileDialog
.SyB_SaveDialog:
		ld		a,(AppBnkNum)
		set		6,a
.SyB_FileDialog:		
		ld		(SyB_FileDialog_Extra),a
		ld		iy,(SyB_StackAddr)
		;**** copy "*  ",0 into file area 
		ld		hl,SyB_FileDialog_Data
		ld		bc,4
		ld		de,(SyB_File_Dialog_Pointer)
		ldir
		push	de
		;**** oopy real stuff
		ld		l,(iy+13)
		ld		h,(iy+14)		
		ld		a,(iy+15)
		And		a
		jp		z,SyB_FileDialog_1
		ld		de,(SyB_File_Dialog_Pointer)		
		cp		3
		jp		c,SyB_FileDialog_2
		ld		a,3
.SyB_FileDialog_2:
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_1:		
		pop		de
		ld		l,(iy+19)
		ld		h,(iy+20)		
		ld		a,(iy+21)
		ld		(SyB_StrStackAddr),hl			;Reset to begining
		And		a
		jp		z,SyB_FileDialog_3
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_3:
		Xor		a
		ld		(de),a
		ld		hl,(SyB_File_Dialog_Pointer)		
		ld		a,(SyB_FileDialog_Extra)
		ld		c,(iy+7)	
		
		ld		ix,128
		ld		iy,6000
;		ld		de,Form1_ControlWindow
		call	SySystem_SELOPN
		ld		iy,(SyB_StackAddr)
		And		a
		jp		nz,SyB_FileDialog_Fail
		ld		hl,(SyB_File_Dialog_Pointer)
		ld		bc,4
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		b,0
.SyB_FileDialog_4:
		ld		a,(hl)
		And		a
		jp		z,SyB_FileDialog_5
		ld		(de),a
		inc		hl
		inc		de
		inc		b
		jr		SyB_FileDialog_4
.SyB_FileDialog_5:
		ld		(iy+21),b
		ld		(SyB_StrStackAddr),de
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_FileDialog_Fail:
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		(iy+21),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret				
SyB_FileDialog_Data:	db "*  ",0
SyB_FileDialog_Extra:	db	0		

;;LIBRARY SYB.CONTROL.MOUSEOVER
;.SyB_MouseOver
;		ld		iy,(SyB_StackAddr)
;		ld		l,(iy+7)
;		ld		h,(iy+8)
;		push	hl
;		pop		ix
;		ld		a,(ix+2)
;		bit		7,a						;***	Visible
;		jr		nz,SyB_Mo_Finish
;		rst 	#20:dw #813C			;***
;		push	hl
;		ld		l,(ix+6)
;		ld		h,(ix+7)
;	
		
		
		
;.SyB_MO_Finish
;		xor		a
;		ld		(iy+7),a
;		ld		(iy+8),a
;		ret





		
;LIBRARY SYB.CONTROL.PAINT.PEN
.SyB_GetPaintObjPen
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+8)				;**** Upper Byte of ID	
		ld		l,(iy+7)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(ix+2)	
		and 	a
		ret		nz
		ld		a,(ix+4)
		and		%1111
		ld		(iy+7),a
		xor		a
		ld		(iy+8),a
		ret
		
;LIBRARY SYB.CONTROL.PAINT.PEN.SET
;*****************************
.SyB_SetPaintObjPen
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+14)				;**** Upper Byte of ID	
		ld		l,(iy+13)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(ix+2)	
		cp		0
		jr		nz,SyB_SetPaintObjPen2
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		a,%1111
		and		e
		ld		(ix+4),a
.SyB_SetPaintObjPen2
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
;LIBRARY SYB.CONTROL.CTRLABEL.PEN.SET
;*****************************
.SyB_SetCtrLabelObjPen
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+14)				;**** Upper Byte of ID	
		ld		l,(iy+13)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(ix+2)	
		cp		6
		jr		nz,SyB_SetCtrLabelObjPen2
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		bc,6
		add		hl,bc
		ld		a,(iy+7)
		rla
		rla
		rla
		rla
		and		%11110000
		ld		c,a
		ld		a,(hl)
		and		%1111
		add		c
		ld		(hl),a
.SyB_SetCtrLabelObjPen2
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.CONTROL.CTRLABEL.PAPER.SET
;*****************************
.SyB_SetCtrLabelObjPaper
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+14)				;**** Upper Byte of ID	
		ld		l,(iy+13)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(ix+2)	
		cp		6
		jr		nz,SyB_SetCtrLabelObjPaper2
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		bc,6
		add		hl,bc
		ld		a,(iy+7)
		and		%1111
		ld		c,a
		ld		a,(hl)
		and		%11110000
		add		c
		ld		(hl),a
.SyB_SetCtrLabelObjPaper2
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret			

;LIBRARY SYB.CONTROL.ID
;*****************************
.SyB_GetObjID:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+13)
		dec		a
		And		%111
		ld		l,a
		ld		h,0
		add		hl,hl
		ld		de,ControWindowDataList
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

		
;LIBRARY SYB.CONTROL.REFRESHALL
;******************************
.SyB_RefreshAll:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		e,255
		jp		SyDesktop_WINDIN		
		
;LIBRARY SYB.CONTROL.REFRESH
;***********************
;This Indirect with extras
.SyB_Control_Refresh_3
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(iy+7)		
		dec		a
		and		%1111
		xor		%11111111
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		d,(hl)
		ld		e,a
		jr		SyB_Control_Refresh_21
;This Indirect
.SyB_Control_Refresh_2
		ld		hl,(SyB_StackAddr)			;16
		ld		bc,6						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		e,(hl)
.SyB_Control_Refresh_21
		inc		hl
		ld		a,(hl)
		rra
		rra
		rra
		and		%111
		ld		c,a
;This is Direct		
.SyB_Control_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINDIN
		jp		SyDesktop_SendMessage

;LIBRARY SYB.CONTROLTOOL.REFRESH
;***************************
;This Indirect
.SyB_ControlTool_Refresh_2		
		ld		hl,(SyB_StackAddr)			;16
		ld		bc,6						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		e,(hl)
		inc		hl
		ld		a,(hl)
		rra
		rra
		rra
		and		%111
		ld		c,a
.SyB_ControlTool_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINTOL
        jp 		SyDesktop_SendMessage

;LIBRARY SYB.STORE.INT.DIRECT
;****************************
.SyB_Store_Int_Direct
		ld		hl,(SyB_StackAddr)						;16
		ld		bc,6									;10
		add		hl,bc									;11
		ld		(SyB_StackAddr),hl						;16
		inc		hl										;6
		ldi												;16
		ldi												;16
		ret												;10				101		

;LIBRARY SYB.STORE.STR
;**********************
.SyB_Store_Str
		pop		ix
		ld		iy,(SyB_StackAddr)
		ld		l,(ix+0)
		ld		h,(ix+1)
		inc		ix
		inc		ix	
		call	SyB_Str_Store_2_Ram
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)
		
		
;LIBRARY SYB.FORM.SCROLL.REFRESH
;***************************
.SyB_Form_Scroll_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINSLD
        jp 		SyDesktop_SendMessage
		
;LIBRARY SYB.FORM.STATUS.REFRESH
;***************************
.SyB_Form_Status_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINSTA
        jp 		SyDesktop_SendMessage

;LIBRARY SYB.FORM.TITLE.REFRESH
;***************************
.SyB_Form_Title_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINTIT
        jp 		SyDesktop_SendMessage
;LIBRARY SYB.FORM.MAXIMIZE
;***************************
.SyB_Form_Maximize
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINMAX
        jp 		SyDesktop_SendMessage	
;LIBRARY SYB.FORM.MINIMIZE
;***************************
.SyB_Form_Minimize
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINMIN
        jp 		SyDesktop_SendMessage	
;LIBRARY SYB.FORM.RESTORE
;***************************
.SyB_Form_Restore
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINMID
        jp 		SyDesktop_SendMessage			
		
;LIBRARY SYB.FORM.LEFT
;*********************
.SyB_Form_Left
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l				;**** Upper Byte of ID
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.CONTROL.TEXT.LEN
;*********************
.SyB_Control_Text_Len
		ld		iy,(SyB_StackAddr)	
		dec		hl	
		ld		a,(hl)
		ld		(iy+1),a				;**** Upper Byte of ID
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret			
		

;LIBRARY SYB.CONTROL.SETPOS
;**************************
.SyB_SetObjPos
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)				;**** Upper Byte of ID
		ld		h,(iy+20)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		e,(iy+13)
		ld		d,(iy+14)
		ld		(ix+6),e
		ld		(ix+7),d
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+8),e
		ld		(ix+9),d
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.CONTROL.SETWIDTH
;*****************************
.SyB_SetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)				;**** Upper Byte of ID	
		ld		h,(iy+14)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+10),e
		ld		(ix+11),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
;LIBRARY SYB.CONTROL.SETHEIGHT
;*****************************
.SyB_SetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)			;**** Upper Byte of ID
		ld		h,(iy+14)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+12),e
		ld		(ix+13),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		

		
		
;LIBRARY SYB.CONTROL.SETVISIBLE
;*******************************
.SyB_SetObjVisible
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)		
		push	hl
		pop		ix
		ld		a,(ix+2)
		And		%111111
		ld		b,a
		ld		a,(iy+7)
		Or		a
		jp		z,SyB_SetObjVisible_1
		res		7,b
		jr		SyB_SetObjVisible_2
.SyB_SetObjVisible_1:
		set		7,b
.SyB_SetObjVisible_2
		;di
		;jr	Syb_SetObjVisible_2
		ld		(ix+2),b
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
;LIBRARY SYB.OBJ.LEFT		
;*********************
.SyB_GetObjLeft
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+6)
		ld		(iy+7),a
		ld		a,(ix+7)
		ld		(iy+8),a
		ret	

;LIBRARY SYB.OBJ.TOP		
;********************
.SyB_GetObjTop
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+8)
		ld		(iy+7),a
		ld		a,(ix+9)
		ld		(iy+8),a
		ret			
		
;LIBRARY SYB.OBJ.WIDTH
;**********************
.SyB_GetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+10)
		ld		(iy+7),a
		ld		a,(ix+11)
		ld		(iy+8),a
		ret			

;LIBRARY SYB.OBJ.HEIGHT
;***********************
.SyB_GetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+12)
		ld		(iy+7),a
		ld		a,(ix+13)
		ld		(iy+8),a
		ret			

;LIBRARY SYB.CONTROL.GETIMAGETILE
;***************************
.Syb_GetImageTile
		ld		c,11
		jr		GetImageInfo
.Syb_GetImageSheet
		ld		c,10
		jr		GetImageInfo
.Syb_GetImageWidthByte
		ld		c,0
		jr		GetImageInfo
.Syb_GetImageWidth
		ld		c,1
		jr		GetImageInfo
.Syb_GetImageHeight
		ld		c,2
		jr		GetImageInfo
.Syb_GetImageEncode
		ld		c,9
		jr		GetImageInfo		
.Syb_GetImageSize
		ld		c,7
.Syb_GetImageInfoWord
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)			;****
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+3)
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		b,0
		add		hl,bc
		rst #20:dw #8124	
		ld		(iy+7),c
		ld		(iy+8),b
		ret		
.Syb_GetImageInfo
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)			;****
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+3)
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		b,0
		add		hl,bc
		rst #20:dw #812A	
		ld		(iy+7),b
		xor		a
		ld		(iy+8),a
		ret
		
		
;LIBRARY SYB.CONTROL.SETGRAPHIC
;*******************************
.SyB_SetObjGraphic
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)			;****
		ld		h,(iy+20)
		push	hl
		pop		ix
.SyB_SetObjGraphic34		
		ld		a,(ix+2)
		ld		b,a
		and		%111111
		cp 		10
		jp		nz,SyB_SetObjGraphic_Finish			
		res		6,b
		ld		(ix+2),b
		
		ld		l,(iy+13)				;HL=Memory Bank Address
		ld		h,(iy+14)
		ld		a,(hl)
		cp		180
		jp		nz,SyB_SetObjGraphic_Finish		
		;**** So it is a Sheet File
		di
		inc		hl
		ld		a,(hl)
		ld		(ix+3),a				;New Bank for Extended Data
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)				;Get Tile wanted
		ld		h,(iy+8)	
		add		hl,hl					;*Multiply by two
		add		hl,de
		inc		hl
		inc		hl
		rst 	#20:dw #8124
		add		hl,bc
		ld		(ix+4),l
		ld		(ix+5),h
		ei
.SyB_SetObjGraphic_Finish
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


		
		
;LIBRARY SYB.CONTROL.TEXT
;***************************
.SyB_GetObjText
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix		
		ld		e,(ix+2)
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_GetObjText_Empty
		
		bit		7,a
		jp		z,SyB_GetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111
		jp		SyB_GetObjText_3
.SyB_GetObjText_2:
		push	ix
		pop		hl
.SyB_GetObjText_3:		
		ld		e,a
		ld		d,0
		add		hl,de	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		b,0
.SyB_GetObjText_5:			
		ld		a,(de)
		And		a
		jp		z,SyB_GetObjText_4
		ld		(hl),a
		inc		de
		inc		hl
		inc		b
		jr		SyB_GetObjText_5
.SyB_GetObjText_4:
		ld		(SyB_StrStackAddr),hl
		ld		(iy+9),b
		ret
.SyB_GetObjText_Empty:
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),0
		ret

;LIBRARY SYB.NET.TCP.SERVER.OPEN
;************************
.SyB_Net_TCP_Server_Open		

		ld		a,(SyB_Net_Handle)
		cp		255
		jr		nz,SyB_Net_TCP_Server_Open_End
		ld		iy,(SyB_StackAddr)
		ld		a,1
		ld		l,(iy+7)
		ld		h,(iy+8)		
        call 	snwmsgi_afbcdehlixiy
        db 		FNC_NET_TCPOPN
        call	snwmsgo_afhl
		ld		(Syb_Net_Handle),a
.SyB_Net_TCP_Server_Open_End
		ld		iy,(SyB_StackAddr)	
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.NET.TCP.CLIENT.OPEN
;************************
.SyB_Net_TCP_Client_Open
		ld		a,(SyB_Net_Handle)
		cp		255
		jr		nz,SyB_Net_TCP_Client_Open_End	
		ld		iy,(SyB_StackAddr)
		ld		a,0
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+19)
		ld		h,(iy+20)
		push	de
		push	hl
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		(SyB_StrStackAddr),hl
		ld		e,(iy+15)
		ld		d,0
		push	hl
		add		hl,de
		ld		a,0
		ld		(hl),a
		pop 	hl		
        ld 		de,(AppBnkNum)
        call 	snwmsgi_afdehl
        db 		FNC_NET_DNSVFY
        call 	snwmsgo_afbcdehlixiy
		ld		a,l
		pop		hl
		pop		de
		cp		1
		jr		nz,SyB_Net_TCP_Client_Open_End
		xor		a
		call 	snwmsgi_afbcdehlixiy
        db 		FNC_NET_TCPOPN
        call 	snwmsgo_afhl
		ld		(Syb_Net_Handle),a
.SyB_Net_TCP_Client_Open_End		
		ld		iy,(SyB_StackAddr)
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY.SYB.NET.CONVERT.IP.2.IXIY
.SyB.Net.Convert.2.IXIY
		
		
		
		ret
		
;LIBRARY SYB.NET.TCP.CLOSE
;************************
.SyB_Net_TCP_Close	
		ld		a,(Syb_Net_Handle)
		call 	snwmsgi_af
        db 		FNC_NET_TCPCLO
        call 	snwmsgo_afhl
		ld		a,255
		ld		(Syb_Net_Handle),a
		ret
		
;LIBRARY SYB.NET.TCP.STRING.RECEIVE
;************************
.SyB_Net_TCP_String_Receive
		ld		a,(AppBnkNum)
		ld		e,a
		ld		a,(Syb_Net_Handle)	
		cp		255
		jp		z,SyB_Net_TCP_String_Receive_2
		ld		iy,(SyB_StackAddr)
		ld		c,(iy+7)
		ld		b,0
		ld		hl,(Syb_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),c
		push	hl
		add		hl,bc
		ld		(SyB_StrStackAddr),hl
		pop		hl
		call 	snwmsgi_afbcdehl
        db 		FNC_NET_TCPRCV
        call 	snwmsgo_afbchl
		ret
.SyB_Net_TCP_String_Receive_2
		ld		hl,(Syb_StrStackAddr)
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),0
		ret
		
		
		
;LIBRARY SYB.NET.TCP.SEND
;************************
.SyB_Net_TCP_Send
		ld		a,(Syb_Net_Handle)	
		cp		255
		jp		z,SyB_Net_TCP_Send_2	
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		c,(iy+9)
		ld		b,0		
		ld		de,(AppBnkNum)
		call 	snwmsgi_afbcdehl
        db 		FNC_NET_TCPSND
        call 	snwmsgo_afbchl

.SyB_Net_TCP_Send_2		
		ld		iy,(SyB_StackAddr)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.NET.EVENT.TYPE
;**************************
.SyB_Net_Event_Type
		ld		a,(AppMsgB+8)
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.NET.EVENT.BYTES.RECEIVED
;**************************
.SyB_Net_Event_Bytes_Received
		ld		hl,(AppMsgB+4)
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret			
;LIBRARY SYB.NET.DNS
;*******************
.SyB_Net_DNS_Verify

.SyB_Net_DNS_Resolve
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		e,(iy+9)
		ld		d,0
		push	hl
		add		hl,de
		xor		a
		ld		(hl),a
		pop		hl
		ld		a,(SyNet_PrcID)
		or		a
		jr		z,SyB_Net_DNS_Resolve_20
		push	hl
		;DNS PART
        ld 		de,(AppBnkNum)
        call 	snwmsgi_afdehl
        db 		FNC_NET_DNSRSV
        call 	snwmsgo_afbcdehlixiy
		jr		nc,SyB_Net_DNS_Resolve_2
;*** Error
		pop		hl
.SyB_Net_DNS_Resolve_20		
		add		hl,de
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),0
		ret	
.SyB_Net_DNS_Resolve_2		
		pop		de
		db		#dd,#7d
		call	SyB_Net_Hex_Ret
		db		#dd,#7c
		call	SyB_Net_Hex_Ret		
		db		#fd,#7d	
		call	SyB_Net_Hex_Ret		
		db		#fd,#7c
		call	SyB_Net_Hex_Ret
		xor		a
		ld		(de),a
		inc		de
		ld		(SyB_StrStackAddr),de
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),8	
		ret

.SyB_Net_Hex_Ret
		push af
		rra
		rra
		rra
		rra
		and	%1111
		ld	hl,SyB_Net_Hex
		ld	c,a
		ld	b,0
		add	hl,bc
		ld	a,(hl)
		ld	(de),a
		inc	de
		pop	af
		and	%1111
		ld	hl,SyB_Net_Hex
		ld	c,a
		ld	b,0
		add	hl,bc
		ld	a,(hl)
		ld	(de),a
		inc	de		
		ret
.SyB_Net_Hex
		db "0123456789ABCDEF'		
		
;LIBRARY SYB.SYS.SCREENMODE
;***************************
.SyB_ScreenMode:
		ld 		hl,#8139
		rst 	#28
		ld		hl,(SyB_StackAddr)
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret	
		
;LIBRARY SYB.DIRECTORY.NEW
;*************************
.SyB_Directory_New
		ld		hl,SyFile_DIRNEW
		ld		(SyB_Directory_New_2+1),hl
		ld		a,2
		ld		(SyB_Directory_New_3+1),a
.SyB_Directory_New_1
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(appBnkNum)
		db		#DD,#67
SyB_Directory_New_2		
		call	SyFile_DIRNEW
		ret		nc
		ld		e,a
SyB_Directory_New_3		
		ld		d,2
		jp		SyB_Mark_Error	
;**** Delete shares New
.SyB_Directory_Delete
		ld		hl,SyFile_DIRRMD
		ld		(SyB_Directory_New_2+1),hl
		ld		a,3
		ld		(SyB_Directory_New_3+1),a	
		jp		SyB_Directory_New_1
		
;LIBRARY SYB.DIRECTORY.RENAME
;****************************
.SyB_Directory_Rename
		ld		hl,SyFile_DIRREN
		ld		(SyB_Directory_New_2+1),hl
		ld		a,4
		ld		(SyB_Directory_New_3+1),a
.SyB_Directory_Rename_1
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		e,(iy+7)
		ld		d,(iy+8)
		di
.afjttt	jr		afjttt		
		
		ld		bc,-12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(appBnkNum)
		db		#DD,#67
SyB_Directory_Rename_2		
		call	SyFile_DIRREN
		ret		nc
		ld		e,a
SyB_Directory_Rename_3		
		ld		d,4
		jp		SyB_Mark_Error
;**** Move shares Rename
.SyB_Directory_Move
		ld		hl,SyFile_DIRMOV
		ld		(SyB_Directory_New_2+1),hl
		ld		a,5
		ld		(SyB_Directory_New_3+1),a	
		jp		SyB_Directory_New_1			
		
;LIBRARY SYB.SYS.RESOLUTION
;***************************
.SyB_ResolutionX
		ld 		hl,#8139
		rst 	#28
		Push	ix
        jr		SyB_Resolution_2
.SyB_ResolutionY:
		ld 		hl,#8139
		rst 	#28
		Push 	iy
.SyB_Resolution_2
		ld		hl,(SyB_StackAddr)
		Xor		a		
		ld		(hl),a
		inc		hl	
		pop		de
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret
			
;LIBRARY SYB.SYS.RAMSIZE
;***********************
.SyB_RamSize
		ld 		hl,#8100			;SymBos Function
		rst 	#28
		ld		l,d
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamSize_1		
		add		hl,hl				;*2
		djnz	SyB_RamSize_1
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		

;LIBRARY SYB.SYS.RAMFREE
;***********************
.SyB_RamFree
		ld hl,#8100			;SymBos Function
		rst #28
		ld		l,e
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamFree_1		
		add		hl,hl				;*2
		djnz	SyB_RamFree_1
		push	ix
		pop		de
		ld		a,d
		ld		d,0
		rra
		rra
		And		%111111
		ld		e,a
		add		hl,de
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

		
;LIBRARY SYB.SYB.COLOURDEPTH		
;****************************
.SyB_ColourDepth:
		ld 		hl,#8139
		rst 	#28
		ld		a,d
		And		%1111
		ld		d,a
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		
		
;LIBRARY SYB.SYS.MACHINE
;***********************
.SyB_Machine
        ld 		hl,jmp_sysinf        ;#8103 SYSINF
        ld 		de,256*1+5
        ld 		ix,syb_machine_type
        ld 		iy,66+2+6+8
        rst 	#28
		ld		hl,(SyB_StackAddr)
		xor 	a
		ld		(hl),a
		inc		hl
		ld		a,(SyB_Machine_Type)
		ld		(hl),a
		inc		hl
		xor 	a
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret	
		
;LIBRARY SYB.SYS.KEY
;*******************
.SyB_KEY
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld 		hl,#8145:rst #28		;*** KEYTST
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),e
		ld		d,0
		ld		(iy+8),d
		ret
		
;LIBRARY SYB.SYS.KEYSTATUS
;*************************
.SyB_KEYSTATUS
		ld hl,#8148:rst #28
		ld		a,d
		rla
		rla
		rla
		or		e
		ld		a,e
		ld		d,0
		ld		iy,(SyB_StackAddr)
		ld		bc,-6
		add		iy,bc
		ld		(iy+7),e
		ld		(iy+8),d
		ld		(SyB_StackAddr),iy
		ret	
		
		
;LIBRARY SYB.CONTROL.VISIBLE.GET
;*******************************
.SYB_CONTROL_VISIBLE_GET
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)		
		push	hl
		pop		ix
		ld		a,(ix+2)
		rla		
		And		%1
		ld		(iy+7),a
		ld		(iy+8),0
		ret		
		
;;;;;LIBgRARY SYB.OBJ.VISIBLE
;;******************************
;.SyB_GetObjVisible
;		call	SyB_ControlAddrIX_IY78
;		ld		a,(ix+2)
;		And		%10000000
;		jp		z,SyB_GetObjVisible_1
;		Xor		a
;		jp		SyB_GetObjVisible_2
;.;SyB_GetObjVisible_1		
;		ld		a,1
;.SyB_GetObjVisible_2		
;		ld		(iy+7),a
;		ld		(iy+8),0
;		ret		

;LIBRARY SYB.TIME.SECOND
;***********************
.SyB_GetSecond
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;LIBRARY SYB.TIME.MINUTE
;***********************
.SyB_GetMinute
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),b
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.TIME.HOUR
;*********************
.SyB_GetHour
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),c
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret

;LIBRARY SYB.TIME.DAY
;*********************
.SyB_GetDay
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.TIME.MONTH
;**********************
.SyB_GetMonth
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),e
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy			
		ret

;LIBRARY SYB.TIME.YEAR
;*********************
.SyB_GetYear
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
