;LIBRARY QUIG.CONTROL.REFRESH
;*****************************
.Quig_Control_Refresh:
		ld		e,(hl)						;Get Control Number
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)		
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0							;b is empty
		ld		hl,SyB_Studio_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINDIN
		jp		SyDesktop_SendMessage
;LIBRARY QUIG.CONTROL.TOOL.REFRESH
;*****************************
.Quig_Control_ToolRefresh:
		ld		e,(hl)						;Get Control Number
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)		
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0							;b is empty
		ld		hl,SyB_Studio_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINTOL
		jp		SyDesktop_SendMessage		
;LIBRARY QUIG.FORM.REFRESH.PARTS
;******************************
.Quig_RefreshStatus:
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINSTA
        jp 		SyDesktop_SendMessage	
.Quig_RefreshTitle
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINTIT
        jp 		SyDesktop_SendMessage		
.Quig_RefreshMenu:
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage	
.Quig_RefreshFormPart
		ex		de,hl
		ld		hl,SyB_Studio_FormIDs
		add		hl,de
		ld		a,(hl)
		ret			
	
;LIBRARY QUIG.MOUSE.X
;*********************
.Quig_Mouse_X:
		pop		iy
		push	de					;DE Needs to be stored as it will be corrupted
		rst 	#20
		dw 		#813C
		ex		de,hl				;X results in DE so put in HL
		pop		de					;Gets stored DE back
		jp		(iy)
;LIBRARY QUIG.MOUSE.Y
;*********************
.Quig_Mouse_Y:
		pop		iy
		push	de
		rst 	#20
		dw 		#813C
		pop		de
		jp		(iy)
		
		
;LIBRARY SYB.FINDSTR
;*******************
.SyB_FindStr
		ld		hl,(SyB_StrStackAddr)	;This is the Addr after the Find String
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		xor		a
		sbc		hl,de
		ld		a,l
		db		#dd
		ld		h,a
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		ld		(SyB_StrStackAddr),de
		push	hl
		xor		a
		sbc		hl,de
		ld		a,l
		db		#dd
		ld		l,a
		ld		c,(iy+19)			;Start value
		ex		de,hl
		pop		de

;### Input      HL=search string, DE=find string, C=start position (starting at 1), IXL=search string length, IXH=find string length
;### Output     HL=position (starting at 1)
.instr   ld (instr3+1),hl
        ld a,c              ;adjust start position 0-based
        sub 1
        adc 0               ;accept 0 as start position as well (same as 1)
        ld c,a
        db #dd:ld a,l       ;calculate length of search area
        sub c
        jr c,instr4         ;too small...
        jr z,instr4
        db #dd:sub h
        jr c,instr4         ;... -> not found, finished
        inc a
        ld b,0
        add hl,bc           ;hl=search string start
        ld c,a              ;bc=length of 1st char search area
.instr1  ld a,(de)
        cpir                ;search for the 1st char
        jr nz,instr4        ;not found -> finished
        inc c
        push hl
        push de
        db #dd:ld l,h       ;test, if remaining chars match as well
.instr2  db #dd:dec l
        jr z,instr3         ;no remaining chars -> found!, finished
        inc de
        ld a,(de)           ;compare
        cp (hl)
        inc hl
        jr z,instr2         ;match -> repeat
        pop de
        pop hl
        dec c               ;don't match -> search again
        jr z,instr4         ;until there are no chars left -> not found, finished
        jr instr1
.instr3  ld de,0             ;found -> calculate position and return it
        pop hl
        pop hl
        or a
        sbc hl,de
        jr instr5
.instr4  ld hl,0             ;not fount -> return 0
.instr5  ;...                ;-> HL=position (starting at 1)
		ld		(iy+19),l
		ld		(iy+20),h

		ld		hl,(SyB_StrStackAddr)
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
		
		

;LIBRARY SYB.PUSH.V.BYTE.HL
;*********************
.SyB_Push_V_Byte_HL
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
;LIBRARY SYB.NEG.HL
;****************************
.SyB_Neg_HL
		xor 	a
		sub 	l
		ld 		l,a
		sbc 	a,a
		sub 	h
		ld 		h,a
		ret
;LIBRARY SYB.NEG.DE
;****************************
.SyB_Neg_DE
		xor 	a
		sub 	e
		ld 		e,a
		sbc 	a,a
		sub 	d
		ld 		d,a
		ret
;LIBRARY SYB.PUSH.V.BYT.DIRECT
;*****************************
.SyB_Push_V_Byt_Direct
		ld		hl,(SyB_StackAddr)		;16
		inc		hl						;6
		ld		(hl),a					;7
		inc		hl						;6
		xor		a
		ld		(hl),a					;7
		ld		bc,-8					;16
		add		hl,bc					;11
		ld		(SyB_StackAddr),hl		;16
		ret			
;LIBRARY SYB.PUSH.NULL.INT
;*************************
.SyB_Push_Null_Int
		Xor		a
		ld		hl,(SyB_StackAddr)
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		ld		bc,-8						;16
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16				
		ret
;LIBRARY SYB.PUSH.NULL.FLO
;*************************		
.SyB_Push_Null_Flo
		ld		hl,(SyB_StackAddr)
		ld		a,1
		ld		(hl),a
		inc		hl
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a						;Strange but should be #80 but isnt		
		ld		bc,-11						;16
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16				
		ret	
;LIBRARY SYB.PUSH.NULL.STR
;*************************		
.SyB_Push_Null_Str
		ld		hl,(SyB_StackAddr)
		ld		a,5
		ld		(hl),a
		inc		hl
		ld		de,(SyB_StrStackAddr)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		Xor		a
		ld		(hl),a
		ld		bc,-9						;16
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16				
		ret		
;LIBRARY SYB.STORE.HL.2.STACK
;****************************
.SyB_Store_HL_2_Stack
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.STACK.2.HL
;****************************
.SyB_Stack_2_HL
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
;LIBRARY SYB.ARRAY.1
.SyB_Array_1
		ex		de,hl
		ld		iy,(Syb_StackAddr)
		ld		c,(iy+7)
		ld		b,(iy+8)
		add		hl,bc
		add		hl,bc
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		bc,6
		add		iy,bc
		ld		(SyB_Stackaddr),iy
		ret
;LIBRARY SYB.REFRESHAREA
;***********************
.SyB_RefreshArea
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)			;h
		ld		h,(iy+14)
		ld		(AppMsgB+08),hl
		ld		l,(iy+7)			;w
		ld		h,(iy+8)
		ld		(AppMsgB+10),hl
		ld		l,(iy+19)			;y
		ld		h,(iy+20)
		ld		(AppMsgB+6),hl
		ld		c,(iy+32)
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		l,(iy+25)			;x
		ld		h,(iy+26)
		ld		e,(iy+31)
		ld		bc,30
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld 		c,MSC_DSK_WINPIN
        jp 		SyDesktop_SendMessage			
		
;LIBRARY SYB.CONTROL.SETS
;HL Address of Control
.SyB_Control_Return_Set
		ld		bc,8
		jr		SyB_Control_Focus_Set_2
.SyB_Control_ESC_Set
		ld		bc,9
		jr		SyB_Control_Focus_Set_2
.SyB_Control_Focus_Set
		ld		bc,14
.SyB_Control_Focus_Set_2		
		ld		a,(hl)		;Get Number
		ld		d,0			;DE=number
		ld		e,a
		ex		de,hl		;HL=Number DE=Start
		inc		hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl		;HL=HL*16
		ex		de,hl		;DE=Number*16:HL+Start
		scf		
		ccf					;No Carry Flag	
		sbc		hl,de		;Removed DE From start
		add		hl,bc		;Adds Set Increment
		ld		(hl),a
		RST 	#20:Dw #814b
		ret


;LIBRARY SYB.STR.CINT
;********************
.SyB_Str_Cint
		ld		iy,(Syb_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(Syb_StrStackAddr),hl
		ld		b,(iy+9)
		push	iy
		call	clcr16
		pop		iy
		jr		nc,SyB_Str_Cint_2
.SyB_Str_Cint_1		
		ld		hl,0
.SyB_Str_Cint_2		
		ld		(iy+7),l
		ld		(iy+8),h
		ret
.SyB_Str_Cint_Len
		ld		iy,(Syb_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(Syb_StrStackAddr),hl
		ld		b,(iy+9)
		push	iy
		call	clcr16
		pop		iy
		jr		c,SyB_Str_Cint_1
		ld		hl,(Syb_StrStackAddr)
		ex		de,hl
		sbc		hl,de
		jr		SyB_Str_Cint_2
		

;### CLCR16 -> Converts string into 16bit value
;### Input      HL=string, B=length
;### Output     HL=value, CF=1 -> invalid format
;### Destroyed  AF,BC,DE,IXL
clcr16s db 0        ;sign flag (0=pos, 1=neg)

clcr16  inc b
        dec b
        scf
        ret z
        ld a,(hl)           ;skip whitespace
        cp " "
        jr z,clcr165
        cp 9
        jr nz,clcr166
clcr165 inc hl
        dec b
        jr clcr16
clcr166 cp "-"              ;consider sign
        ld a,0
        jr nz,clcr161
        dec b
        scf
        ret z
        inc a
        inc hl
clcr161 ld (clcr16s),a
        ld a,(hl)           ;shouldn't start with invalid digit
        call clcr164
        ret c
        ex de,hl
        ld hl,0
        db #dd:ld l,b
clcr162 ld a,(de)           ;convert ascii to value
        call clcr164
        jr c,clcr163
        add hl,hl
        ret c
        ld c,l
        ld b,h
        add hl,hl
        ret c
        add hl,hl
        ret c
        add hl,bc
        ret c
        add l
        ld l,a
        ld a,0
        adc h
        ret c
        ld h,a
        inc de
        db #dd:dec l
        jr nz,clcr162
        ld a,l
        or h
        ret z
clcr163 ld a,(clcr16s)      ;convert to negative, if signed
        or a
        ret z
        ld a,l
        cpl
        ld l,a
        ld a,h
        cpl
        ld h,a
        inc hl
        bit 7,h
        ret nz
        scf
        ret
clcr164 sub "0"             ;convert one ASCII char to byte
        ret c
        cp 10
        ccf
        ret


;LIBRARY SYB.INT.ADD
;*******************
.SyB_INT_Add
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de						;***** Add Integers Together
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FLO.ADD		
;*******************
.SyB_FLO_Add
		inclib  SYB.FLOAT.ROUTINES
		inclib 	SYB.STACK.2.FLO
		call	
		call 	FLO_ADD
		jp		SyB_DecStack
;LIBRARY SYB.INT.AND
;*******************
.SyB_INT_And
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		(iy+13)
		ld		(iy+13),a
		ld		a,(iy+8)
		And		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.N.DIV16
;**********************
.SyB_N_Div16:
		ex		de,hl           	; HL = DE \ HL
		ld		a,e             	; Division by zero?
		Or		d
		jr		nz,SyB_N_Div17      ; Continue of not
		ld		hl,0
		ld		de,0
		scf			            	; Set Carry to indicate an error
		ret
.SyB_N_Div17:
		ld		c,l             	; AC = HL
		ld		a,h
		ld		hl,0            	; HL = Modulus
		ld		b,16            	; 16-bit division
		Or		a               	; Start with carry reset
.SyB_N_Div18:
		rl		c               	; AC = AC * 2
		rla  	                	; (set Carry to bit 0)
		rl		l               	; HL = HL * 2
		rl		h               	; (reset Carry again (HL = 0))
		push	hl
		sbc		hl,de
		ccf                     	; Carry set when Ok
		jr		c,SyB_N_Div19       ; Modulus cannot be >= Value
		ex		(sp),hl         	; Restore Modulus
.SyB_N_Div19:
		inc		SP              	; Get Modulus from Stack
       inc		SP
	djnz 	SyB_N_Div18         ; Repeat for all bits
; Shift last Carry-bit to divider
		ex		de,hl           	; DE = Modulus
		rl		c               	; Carry to C
		ld		l,c             	; HL = AC
		rla
		ld		h,a
		Or		a               	; Reset Carry (valid result)
		ret		
;LIBRARY SYB.INT.DIV
;*******************
.SyB_INT_Div
		inclib	SYB.N.DIV16
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),l
		ld		(iy+14),h
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FLO.DIV		
;*******************
.SyB_FLO_DIV
		inclib 	SYB.FLOAT.ROUTINES
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_DIV
		jp		SyB_DecStack
;LIBRARY SYB.INT.MOD
;*******************
.SyB_INT_MOD:
		inclib	SYB.N.DIV16
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+13)
		ld		d,(iy+14)
		call	SyB_N_Div16
		ld		(iy+13),e
		ld		(iy+14),d
		ld 		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
	

;LIBRARY SYB.INT.MUL.DEHL
;***********************
.SyB_INT_Mul_DEHL
		ld		c,l
		ld		a,h
		ld 		b,16
.SyB_INT_Mult16_Loop_DEHL:
		add		hl,hl
		sla 	c
		rla
		jr 		nc,Syb_INT_Mult16_NoAdd_DEHL
		add 	hl,de
.SyB_INT_Mult16_NoAdd_DEHL:
		djnz	SyB_INT_Mult16_Loop_DEHL
		ret	
		
;LIBRARY SYB.INT.MUL 	
;*******************
.SyB_INT_Mul
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		c,(iy+13)
		ld		a,(iy+14)
		ld 		b,16
.SyB_INT_Mult16_Loop:
		add		hl,hl
		sla 	c
		rla
		jr 		nc,Syb_INT_Mult16_NoAdd
		add 	hl,de
.SyB_INT_Mult16_NoAdd:
		djnz	SyB_INT_Mult16_Loop
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
;LIBRARY SYB.FLO.MUL
;********************				
.SyB_FLO_Mul
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO		
		call	FLO_MULT
		jp		SyB_DecStack
;LIBRARY SYB.INT.OR		
;******************
.SyB_INT_Or
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Or		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Or		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.INT.SUB		
;*******************
.SyB_INT_Sub
		ld		iy,(SyB_StackAddr)
		Xor		a
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+13)
		ld		h,(iy+14)
		sbc		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		
;LIBRARY SYB.FLO.SUB		
;*******************
.SyB_FLO_Sub
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_SUB
		jp		SyB_DecStack
;LIBRARY SYB.INT.XOR
;*******************
.SyB_INT_Xor
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		Xor		(iy+13)
		ld		(iy+13),a		
		ld		a,(iy+8)
		Xor		(iy+14)
		ld		(iy+14),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.CLOSE.FORM
;***********************
.SyB_CloseForm:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		call	SyB_Studio_CloseForm
		ld		a,(SyB_Studio_FormOS)
		call	SyDesktop_WINCLS
		ret		

;LIBRARY SYB.EVENT.CONTROL
;*************************
.SyB_Event_Control
		ld		bc,(Event_Control_ID)
		ld		a,b
		ld		de,ControWindowDataList
		rra
		and		%11100
		ld		l,a
		ld		h,0
		add		hl,de
		bit		0,b
		jr		z,SyB_Event_Control_2
		inc		hl						;Was a Tool so add 2 to HL
		inc		hl
.SyB_Event_Control_2		
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,c
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
;LIBRARY SYB.EVENT.DISPLAY
.SyB_Event_Display
		ld		hl,(Event_Control_ID)
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),l
		xor		a
		ld		(iy+2),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
		
;LIBRARY SYB.CONTROL.TEXT.SET
;****************************
.SyB_SetObjText:
		ld		iy,(SyB_StackAddr)			
		ld		l,(iy+13)
		ld		h,(iy+14)
		push	hl
		pop		ix
		ld		a,(ix+2)
		cp		32
		jp		z,SyB_SetObjText_Textline
		ld		e,a
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_SetObjText_Empty	
		bit		7,a
		jp		z,SyB_SetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111		
		jp		SyB_SetObjText_3
		
.SyB_SetObjText_2
		push	ix
		pop		hl
.SyB_SetObjText_3
		ld		e,a
		ld		d,0
		add		hl,de
.SyB_SetObjText_4		
		call	SyB_Str_Store_2_Ram
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
		
		
.SyB_SetObjText_Textline:		
		ld		l,(ix+4)
		ld		h,(ix+5)		
		push	hl
		pop		ix
		ld		a,(ix+10)						;Length of Existin String
		ld		e,(iy+9)						;Length of String on Stack		
		cp		e
		jp		nc,SyB_SetObjText_Textline_2
		ld		(iy+9),a
.SyB_SetObjText_Textline_2:		
		ld		a,(iy+9)
		ld		(ix+8),a
		jp		SyB_SetObjText_4
.SyB_SetObjText_Empty:
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret		

;LIBRARY SYB.MATH.RAD
;********************
.SyB_Rad:
		Xor		a
		ld		(FLO_VALUE_DEGRAD),a
		ret

;LIBRARY SYB.MATH.RND
;********************
.SyB_RND
		inclib	SYB.FLOAT.ROUTINES 
		ld		hl,(SyB_StackAddr)
		inc		hl
		call	FLO_RND
		ex		de,hl
		ld		hl,6
		add		hl,de
		call 	FLO_MULT
		ret

;LIBRARY SYB.MATH.LEN
;********************
.SyB_LEN
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		
		ld		de,(SyB_StrStackAddr)
		ld		(Syb_StrStackAddr),hl
		
		
		ex		de,hl
		xor		a
		sbc		hl,de

		ld		(iy+7),l
		ld		(iy+8),h
		ret		
		
;LIBRARY SYB.MATH.SQR
;********************
.SyB_SQR
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SQR

;LIBRARY SYB.MATH.TAN
;********************
.SyB_TAN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_TAN
		
;LIBRARY SYB.MATH.ATAN
;*********************
.SyB_ATAN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_ARC_TAN
		
;LIBRARY SYB.MATH.ABS
;********************
.SyB_Abs_Int
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		z
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret
.SyB_Abs_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		res		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret		

;LIBRARY SYB.MATH.SGN
;********************
.SyB_Sgn_Int
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+8)
		bit		7,a
		ret		nz
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret	
;**** Do Float SGN ****
.SyB_Sgn_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		set		7,a							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret			
		
;LIBRARY SYB.MATH.NEG
;********************
.SyB_Neg_Int
		ld		iy,(Syb_StackAddr)
.SyB_Neg_Int_10		
		ld		a,(iy+7)
		Xor		255
		ld		l,a
		ld		a,(iy+8)
		Xor		255
		ld		h,a
		inc		hl
		ld		(iy+7),l
		ld		(iy+8),h
		ret
;**** Do Float NEG ****
.SyB_Neg_Flo
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+10)
		Xor		128							;**** Alter Sgn Bit
		ld		(iy+10),a
		ret		
		
;LIBRARY SYB.MATH.SIN
;*********************
.SyB_SIN
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_SIN
		
;LIBRARY SYB.MATH.COS
;********************
.SyB_COS
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_COS
		
;LIBRARY SYB.MATH.DEG
;*********************
.SyB_Deg
		ld		a,1
		ld		(FLO_VALUE_DEGRAD),a
		ret	
		
;LIBRARY SYB.MATH.LOG		
;********************
.SyB_LOG
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_NAT

;LIBRARY SYB.MATH.LOG10	
;**********************
.SyB_LOG10
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_LOG_DEC
		
;LIBRARY SYB.MATH.NOT
;********************
.SyB_NOT
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)					
		And		a
		jr		nz,SyB_Not_2
		ld		a,(iy+8)
		And		a
		jr		nz,SyB_Not_2
		ld		(iy+7),1
		jr		SyB_Not_3
.SyB_Not_2		;**** Means <>0 SO Result = 0
		ld		(iy+7),0
.SyB_Not_3
		ld		(iy+8),0
		ret		

;LIBRARY SYB.MATH.RANDOMIZE
;**************************
.SyB_Randomize
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		call	FLO_RANDOMIZE
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc		
		ld		(SyB_StackAddr),hl
		ret
		
;LIBRARY SYB.MATH.ASC
;*********************
.SyB_ASC
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)					;**** Address of Text
		ld		d,(iy+8)					;**** Address of Text
		ld		c,(iy+9)					;**** Len of text
		ld		a,(de)
		ld		(iy+7),a
		ld		(iy+8),0
		Xor		a
		ld		hl,(SyB_StrStackAddr)
		ld		b,0
		sbc		hl,bc
		ld		(syB_StrStackAddr),hl
		ret
		
;LIBRARY SYB.MATH.EXP
;********************
.SyB_EXP
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		jp		FLO_POT_E


;LIBRARY SYB.APP.EXECUTE
;************************
.SyB_Execute:
		ld		iy,(Syb_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		e,(iy+10)
		ld		d,0
		push	hl
		add		hl,de
		ld		a,0
		ld		(hl),a
		pop		hl
		ld		a,(AppBnkNum)
		set		7,a
		call	SySystem_PRGRUN
		ld		iy,(Syb_StackAddr)
		ld		(iy+7),a
		xor 	a
		ld		(iy+8),a
		ret		

;LIBRARY SYB.APP.BANKSIZE
;*************************
.SyB_BankSize
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_BankSize_Error
		ld		de,4
		add		hl,de
		ld		a,(hl)
		inc		hl
		ld		(iy+7),a
		ld		a,(hl)
		ld		(iy+8),a
		ret
.SyB_BankSize_Error			
		ld		(iy+7),0
		ld		(iy+8),0
		ret
		
;LIBRARY SYB.APP.BANK.EMPTYSLOT		

;LIBRARY SYB.APP.CREATEBANK 
;**************************
.SyB_CreateBank
		ld		iy,(SyB_StackAddr)
		;**** File a memory Slot
		inclib	SYB.APP.MEMSLOT.AVAILABLE
		call	SyB_Mem_Slot_Available
		jp		nz,SyB_CreateBank_Error
SyB_CreateBank_FoundSlot
		ld		c,(iy+7)
		ld		b,(iy+8)
		push	bc
		push	hl
		Xor		a
		ld		e,a
		rst		#20
		dw		#8118
		pop		de
		jp		c,SyB_CreateBank_Error		
		ex		de,hl
		ld		c,172
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(hl),c
		inc		hl
		ld		(hl),a							;Stores Bank
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		pop		bc
		ld		(hl),c
		inc		hl
		ld		(hl),b		
		ret
SyB_CreateBank_Error
		pop		hl
		ld		(iy+7),0
		ld		(iy+8),0
		ret
		
		
;LIBRARY SYB.APP.CLEARBANK
;*************************
.SyB_ClearBank
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		nz,SyB_ClearBank_3
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		ld		e,c
		ld		d,b
.SyB_ClearBank_2		
		ld		b,0
		rst		#20:	dw #812D
		dec		e
		jp		nz,SyB_ClearBank_2
		dec		d
		jp		nz,SyB_ClearBank_2		
.SyB_ClearBank_3
		ret		
		
;LIBRARY SYB.APP.FREEBANK
;*************************
.SyB_FreeBank
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)			
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(hl)
		cp		172
		jp		z,SyB_FreeBank_4
		cp		180					;Free Sheet
		jp		nz,SyB_FreeBank_3
.SyB_FreeBank_4		
		Xor		a
		ld		(hl),a
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl		
		rst 	#20:dw 	#811B
SyB_FreeBank_3
		ret
		

		
;LIBRARY SYB.APP.LOADSHEET
;*************************
.SyB_LoadSheet:
		inclib 	SYB.GETOPENAFILE
		inclib 	SYFILE.FILPOI
		call	SyB_GetOpenAFile
		jp		c,SyB_LoadSheet_Fail_11
		ld		(SyB_LoadSheet_fileHandle),a
		;Find Length
		ld		iy,0
		ld		ix,0
		ld		c,2
		call	SyFile_FILPOI
		ld		(SyB_LoadSheet_fileLength),ix
		;Reset to Start
		ld		a,(SyB_LoadSheet_fileHandle)
		ld		ix,0
		ld		iy,0
		ld		c,0
		call	SyFile_FILPOI	
		;Find a Slot in Ram
		ld		bc,(SyB_LoadSheet_fileLength)
		Xor		a					;A = 0 - Look in any RamBank
		ld		e,1					;E = 1 - Look only in Data Areas
		rst 	#20:dw #8118
		jp		c,SyB_LoadSheet_Fail_2
		ld		(SyB_LoadSheet_fileBank),a
		ld		(SyB_LoadSheet_fileStart),hl
		;Find slot in List
		inclib	SYB.APP.MEMSLOT.AVAILABLE
		call	SyB_Mem_Slot_Available
		jp		nz,SyB_LoadSheet_Fail_1
.SyB_LoadSheetBank_FoundSlot
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		c,180
		ld		(hl),c					;180 Represents Sheet
		inc		hl
		ld		a,(SyB_LoadSheet_fileBank)
		ld		(hl),a					;Bank to Store
		inc		hl
		ld		de,(SyB_LoadSheet_fileStart)
		ld		(hl),e					;Where stored Low
		inc		hl
		ld		(hl),d					;Where Stored High
		inc		hl
		ld		bc,(SyB_LoadSheet_fileLength)
		ld		(hl),c					;Length
		inc		hl
		ld		(hl),b					;Length
		;Load Data into Slot
		
		push	ix
		push	iy
		ex		de,hl					;HL = Where
		ld		e,a						;E = Destination Bank
		ld		a,(SyB_LoadSheet_fileHandle)
		inclib	SYFILE.FILINP
		call	SyFile_FILINP
		;Close file
		ld		a,(SyB_LoadSheet_fileHandle)
		inclib	SYFILE.FILCLO
		call	SyFile_FILCLO
		pop		iy
		pop		ix
		
		;Get Number of Tiles
		ld		a,(SyB_LoadSheet_fileBank)
		ld		hl,(SyB_LoadSheet_fileStart)
		rst 	#20:dw #8124
		ld		(SyB_LoadSheet_fileTile),bc
		;Modify Addresses
.SyB_LoadSheetBank_MakeChanges
		Xor 	a
		cp		c
		jp		nz,SyB_LoadSheetBank_MakeChanges_2
		cp		b
		jp		z,SyB_LoadSheetBank_Finished
.SyB_LoadSheetBank_MakeChanges_2
		ld		a,(SyB_LoadSheet_fileBank)		
		push	hl
		push	hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,3					;We need Word 3/4 (Graphic Data Offset)
		add		hl,bc					;Adds 3
		push	hl						;Stores HL
		ld		bc,9					;Address we want to put in is +9 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 3/4 (Graphic Data Offset)
		rst 	#20:dw #8127			;Stores BC into (A HL)
		pop		hl						;Stores Address
		rst		#20:dw #8124			;Get contents of Addr List
		add		hl,bc					;Adds Content to HL to give start of Tile Data
		ld		bc,5					;We need Word 5/6 (Encode Data Byte Address)
		add		hl,bc					;Adds 5
		push	hl						;Stores HL
		ld		bc,4					;Address we want to put in is +4 of HL
		add		hl,bc
		ld		c,l
		ld		b,h						;BC Now is the Start of Data
		pop		hl						;Get back HL 5/6 (Encode Address)
		rst 	#20:dw #8127			;Stores BC into (A HL)		
		pop		hl
		inc		hl
		inc		hl
		ld		bc,(SyB_LoadSheet_fileTile)
		dec		bc
		ld		(SyB_LoadSheet_fileTile),bc
		jp		SyB_LoadSheetBank_MakeChanges
		;Done it
.SyB_LoadSheetBank_Finished		
		ret
		
.SyB_LoadSheet_Fail_11
		ld a,1
		nop
		nop
		di
.shee11	jr		shee11		

.SyB_LoadSheet_Fail_1
		ld a,1
		nop
		nop
		di
.shee	jr		shee		
.SyB_LoadSheet_Fail_2				;**** Not enough Memory free
		di
.shee2	jr		shee2		

.SyB_LoadSheet_fileHandle:	db	0
.SyB_LoadSheet_fileLength:	dw	0
.SyB_LoadSheet_fileStart:	dw	0
.SyB_LoadSheet_fileBank:	db	0
.SyB_LoadSheet_fileTile:	dw	0


;LIBRARY SYB.APP.MEMSLOT.AVAILABLE
;*********************************
;OUT HL - Address of memslot
;OUT NZ - Failed
.SyB_Mem_Slot_Available
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,23							;Number of Banks Possible-1
		ld		de,6							;Bytes to jump (Each Bank Ref is 6 bytes)
		Xor		a								;A=0
.SyB_Mem_Slot_Available_1			
		cp		(hl)
		ret		z	
		add		hl,de
		djnz	SyB_Mem_Slot_Available_1
		ret

;LIBRARY SYB.IF
;***************
.SyB_IF
		ld		bc,6
		ld		hl,(SyB_StackAddr)
		add		hl,bc
		ld		(Syb_StackAddr),hl		
		Xor		a
		inc		hl
		cp		(hl)					;7
		jr		nz,SyB_IF_2_1
		inc		hl
		cp		(hl)					;7
		jr		nz,SyB_IF_2_1
.SyB_IF_1								;So The result was False
		pop		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		jp		(hl)
.SyB_IF_2_1		
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)
		
;LIBRARY SYB.VAR.FILE.OPEN		
;********************
.SyB_Var_File_Open:
		push	de
		ld		iy,(SyB_StackAddr)		
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		ld		e,(iy+9)	
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		d,0
		add		hl,de
		ld		(hl),d
		pop		hl
		ld		(Syb_StrStackAddr),hl
		ld		a,(appBnkNum)
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN		
		jr		c,SyB_Var_File_Open_Fail
		pop		hl
		ld		(hl),a				;*** Store Handle
		inc		hl
		xor		a
		ld		(hl),a
		inc		hl
		ld		a,1					;*** Set Status to 1
.SyB_Var_File_Open_Set_Last_Stuff		
		ld		(hl),a				;*** Store status
		inc		hl
		xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),a				;Set EOF to Zero
		inc		hl
		ld		(hl),a
		ret
.SyB_Var_File_Open_Fail
		ld		e,a
		ld		d,20
		ld		(ErrorNum),de
		pop		hl
		ld		de,-1
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		xor 	a
		jr 		SyB_Var_File_Open_Set_Last_Stuff
	
;LIBRARY SYB.FILE.READ
;**************************
.SyB_File_Do_Read		
		ld		a,(de)
		ld		(SyB_File_Byte_Read_Handle),a			;Store handle 
		push	de										;Store File Handle Position
		ld		a,(appBnkNum)
		ld		e,a										;Get Data Address Bank
		ld		a,(SyB_File_Byte_Read_Handle)			;Get Handle				
		ld		hl,SyB_File_Byte_Read_Data
		ld		bc,6
		call	SySystem_CallFunction
        db		MSC_SYS_SYSFIL
        db		FNC_FIL_FILINP
		pop		hl
		ret
.SyB_File_Float_Read
		ld		bc,6
		call	SyB_File_Do_Read
		call 	nz,SyB_File_Read_Past_End
		;*** Copy read Data into correct Memory 
		ld		hl,(Syb_StackAddr)
		ld		de,SyB_File_Byte_Read_Data
		inc		hl
		ex		de,hl
		ldi
		ldi
		ldi
		ldi
		ldi
		jp		SyB_File_Read_End_Check
.SyB_File_Int_Read
		ld		bc,3
		call	SyB_File_Do_Read
		call 	nz,SyB_File_Read_Past_End	
		;*** Copy read Data into correct Memory 
		ld		hl,(Syb_StackAddr)
		ld		de,SyB_File_Byte_Read_Data
		inc		hl
		ex		de,hl
		ldi
		ldi
		jp		SyB_File_Read_End_Check
.SyB_File_Byte_Read
		ld		bc,2
		call	SyB_File_Do_Read
		call 	nz,SyB_File_Read_Past_End
		;*** Copy read Data into correct Memory 
		ld		hl,(Syb_StackAddr)
		ld		de,SyB_File_Byte_Read_Data
		inc		hl
		ex		de,hl
		ldi
		xor		a
		ld		(de),a
.SyB_File_Read_End_Check
		;***Reset File Pointer Back
		ld		a,(SyB_File_Byte_Read_Handle)			;Get Handle	
		ld		IY,65535
		ld		IX,-1
		ld		c,1
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILPOI
		ld		hl,(SyB_StackAddr)
		ld		bc,-6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret
.SyB_File_Read_Past_End
		;We have Read Past end of file
		ld		bc,4
		add		hl,bc
		ld		a,1
		ld		(hl),a
		inc 	hl
		xor		a
		ld		(hl),a
		ret
		
.SyB_File_Byte_Read_Handle
		db		0
.SyB_File_Byte_Read_Data
		ds		8

;LIBRARY SYB.GETOPENAFILE
;************************
.SyB_GetOpenAFile
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)					;Start of String
		ld		h,(iy+8)
		ld		(SyB_StrStackAddr),hl
		ld		a,(iy+9)					;Length		
		And		a							;If Length Zero
		jp		z,SyB_GetOpenAFile_Fail		;So Fail if zero
		ld		b,0	
		ld		de,(SyB_File_Name_Input)	;DE=Filename/Path		
		ld		c,a							;c=length
		ldir								;repeat
		Xor		a							;put a zero ender in the string
		ld		(de),a						;
		ld		a,(appBnkNum)
		ld		hl,(SyB_File_Name_Input)
		db		#DD,#67
		inclib 	SYFILE.FILOPN
		call	SyFile_FILOPN
		jr		nc,SyB_GetOpenAFile_Ok
		;**** Okay it failed ****
.SyB_GetOpenAFile_Fail:
		scf
.SyB_GetOpenAFile_Ok:		
		ret
		
;LIBRARY SYB.APP.POKEBYTE
;************************
.SyB_PokeByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeByte_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		b,(iy+7)
		rst	 	#20
		dw 		#812D
.SyB_PokeByte_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret
		
;LIBRARY SYB.APP.POKEFLOAT
;*************************
.SyB_PokeFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeFloat_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
		ld		c,(iy+9)
		ld		b,(iy+10)
		rst	 	#20
		dw 		#8127
		ld		b,(iy+11)		
		rst	 	#20
		dw 		#812D
.SyB_PokeFloat_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret			
		
;LIBRARY SYB.APP.POKEINT
;***********************
.SyB_PokeInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PokeInt_1
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,de
		ld		c,(iy+7)
		ld		b,(iy+8)		
		rst	 	#20
		dw 		#8127
.SyB_PokeInt_1
		ld		hl,(SyB_StackAddr)
		ld		bc,18
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret		
		
;LIBRARY SYB.APP.PEEKBYTE
;************************
.SyB_PeekByte
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekByte_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#812A
		ld		(iy+13),b
		ld		(iy+14),0
.SyB_PeekByte_1		
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekByte_2			
		Xor		a
		ld		(iy+7),a
		ld		(iy+8),a
		jp		SyB_PeekByte_1

;LIBRARY SYB.APP.PEEKINT
;************************
.SyB_PeekInt
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekInt_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
.SyB_PeekInt_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekInt_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		jp		SyB_PeekInt_1

;LIBRARY SYB.APP.PEEKFLOAT
;*************************
.SyB_PeekFloat
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(hl)
		cp		172
		jp		nz,SyB_PeekFloat_2
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,(iy+8)
		add		hl,de		
		rst 	#20
		dw		#8124
		ld		(iy+13),c
		ld		(iy+14),b
		rst 	#20
		dw		#8124
		ld		(iy+15),c
		ld		(iy+16),b
		rst 	#20
		dw		#812A
		ld		(iy+17),b		
.SyB_PeekFloat_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_PeekFloat_2			
		Xor		a
		ld		(iy+13),a
		ld		(iy+14),a
		ld		(iy+15),a
		ld		(iy+16),a
		ld		(iy+17),a
		jp		SyB_PeekFloat_1
		
;LIBRARY SYB.FORM.OPEN
;*********************
.SyB_OpenForm:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		And		%111
		call	SyB_Studio_WindowOpen
		jp		c,SyB_OpenForm_2
		inc		a
.SyB_OpenForm_2
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),a
		ld		(iy+8),0		
		ret		
		
;LIBRARY SYB.APP.DIALOG
;***********************
.SyB_Dialog
		inclib	SYB.APP.WAIT.MESSAGE
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		And		%1111
		add		a
		add		a
		add		2
		ld		(SyB_Dialog_Info_1+2),a
		ld		(SyB_Dialog_Info_2+2),a
		ld		(SyB_Dialog_Info_3+2),a				
		ld		e,(iy+21)				;Originals stack length
		ld		hl,(SyB_StrStackAddr)
		ld		d,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		ld		c,e
		
		ld		e,(iy+19)				;DE = Address of Text
		ld		d,(iy+20)		
		ld		hl,SyB_Dialog_Info_Text_1	
		
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_2
		call	SyB_Dialog_Text_Copier
		ld		hl,SyB_Dialog_Info_Text_3
		call	SyB_Dialog_Text_Copier					
		
		ld		hl,SyB_Dialog_Info_1
		ld		a,(iy+13)
		And		%11
		ld		e,a
		set 	7,e
		push	iy
		ld		a,(appBnkNum)
		call	SySystem_SYSWRN
		
.SyB_Dialog_Control_Loop:
		call	SyB_App_Wait_Message	;**** See what Event has occurre
		jr		nc,SyB_Dialog_Control_Loop_0
		cp		157
		jr		nz,SyB_Dialog_Control_Loop_0
		ld		a,(Event_Form_ID)			;Position 1
		jp		SyB_Dialog_Control_Loop_2
		cp		0
		jp		nz,SyB_Dialog_Control_Loop_2
.SyB_Dialog_Control_Loop_0
		;Xor		a
		;ld		(V_App_In_Use),a
		jr		SyB_Dialog_Control_Loop
.SyB_Dialog_Control_Loop_2
		pop		iy
		ld		(iy+19),a
		ld		(iy+20),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
;**** Copies Text from DE into HL ****
;**** C=Length left
.SyB_Dialog_Text_Copier		
		ld		b,31
.SyB_Dialog_Loop_1		
		ld		a,c
		Or		a
		jp		z,SyB_Dialog_Loop_2
		dec		c
		ld		a,(de)
		inc		de
		cp		"|"			
		jp		z,SyB_Dialog_Loop_2
		ld		(hl),a
		inc		hl
		dec		b
		djnz	SyB_Dialog_Loop_1
.SyB_Dialog_Loop_2
		Xor		a
		ld		(hl),a
		ret	
;LIBRARY SYB.APP.WAIT.MESSAGE
.SyB_App_Wait_Message:
        rst   #30
        ld    a,(AppPrzN)
        db    #dd:ld l,a
        db    #dd:ld h,-1
        ld    iy,AppMsgB
        rst   #18
        Or    a
        db    #dd:dec l
        ret   nz
        ld    a,(AppMsgB+0)
        Or    a
        jp    z,SyB_Studio_End
        scf
        ret		

;***** STRING AREA *****
;***********************		
;LIBRARY SYB.STRING.MID
;FUNCTION String.Mid,Mid
;	#INPUT Source$,Start%,Length%
;	#OUTPUT Result$
;	#ENTRY SyB_MID
;	#DESCR Returns a part of a source String given the character to start and length required.
;/FUNCTION
;**********************
.SyB_MID
		ld		ix,(SyB_StackAddr)
		ld		c,(ix+7)				;Length Required
		ld		a,(ix+13)				;From Where
		;Must check A (From Where)>0
		dec 	a
		ld		l,a
		ld		h,0
		ld		a,(ix+21)				;Originals stack length
		ld		e,(ix+19)
		ld		d,(ix+20)
		sub		l
		ld		b,a
		jp		c,SyB_MID_Empty
		add		hl,de
		Xor		a
		ld		(SyB_MidTemp),a
.SyB_MID_2	
		ld		a,(SyB_MidTemp)
		cp		b
		jr		z,SyB_MID_3
		cp		c
		jr		z,SyB_MID_3
		inc		a
		ld		(SyB_MidTemp),a
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		jr		SyB_MID_2
.SyB_MID_3	
		ld		e,(ix+19)
		ld		d,(ix+20)
		ld		l,a
		ld		h,0
		add		hl,de
		ld		(SyB_StrStackAddr),hl
		jr		SyB_MID_4
.SyB_MID_Empty
		Xor		a
		ld		(ix+21),a
		ld		(SyB_StrStackAddr),de
.SyB_MID_4
		ld		(ix+21),a
		ld		hl,(SyB_StackAddr)
		ld		bc,12
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret	
.SyB_MidTemp		db	0
		

;LIBRARY SYB.STRING.TRIM
;***********************
.SyB_Trim
		ld		ix,(SyB_StackAddr)
		ld		a,(ix+9)
		Or		a
		ret		z
		ld		l,(ix+7)
		ld		h,(ix+8)
		
		ld		e,a				;This is the length
		ld		d,0
		ld		bc,0
.SyB_Trim_3		
		ld		a,(hl)
		cp		#20
		jp		nz,SyB_Trim_2
		inc		bc
		inc		hl
		inc		d
		dec		e
		jp		nz,SyB_Trim_3
.SyB_Trim_2
		ld		a,(ix+9)
		sub		d
		ld		(ix+9),a
		ld		c,a
		ld		b,0
		push	de
		ld		e,(ix+7)
		ld		d,(ix+8)
		Or		a
		jp		z,SyB_Trim_4
		ld		a,e
		cp		l
		jp		z,SyB_Trim_4
		ldir
.SyB_Trim_4		
		pop		de
		ld		c,d
		ld		b,0
		ld		hl,(SyB_StrStackAddr)
		Xor		a
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ret

;LIBRARY SYB.STRING.UCASE
;************************
.SyB_UCase
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
.SyB_UCase_1
		ld		a,(hl)
		and		a
		ret		z
		cp 		97
		jr		c,SyB_UCase_2
		cp		123
		jr		nc,SyB_UCase_2
		sub		32
		ld		(hl),a
.SyB_UCase_2		
		inc		hl
		jr		SyB_UCase_1
		
;LIBRARY SYB.STRING.LCASE
;************************
.SyB_LCase
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
.SyB_LCase_1
		ld		a,(hl)
		and		a
		ret		z
		cp 		65
		jr		c,SyB_LCase_2
		cp		91
		jr		nc,SyB_LCase_2
		add		32
		ld		(hl),a
.SyB_LCase_2		
		inc		hl
		jr		SyB_LCase_1
		
;LIBRARY SYB.STRING.STR
;**********************
.SyB_Str
		inclib	SYB.DSPGET
		inclib 	SYB.FLOAT.ROUTINES
		inclib	SYB.INT.2.FLO.STACK.2
		ld		hl,(SyB_StackAddr)
		ld		bc,7
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		call	SyB_Str_2
		ld		ix,(SyB_StackAddr)
		ld		hl,(SyB_StrStackAddr)
		ld		(ix+6),5
		ld		(ix+7),l
		ld		(ix+8),h
		ld		(Syb_StrStackAddr),de
		ex		de,hl
		Xor		a
		sbc		hl,de
		ld		(ix+9),l
		ret
.SyB_Str_2
 		push	de
        ex		de,hl
        call 	dspget
        pop 	hl		
        jp 		dsptxt		

;LIBRARY SYB.STRING.LEFT
;***********************
.SyB_Left
		ld		ix,(SyB_StackAddr)
		ld		b,(ix+7)
		ld		a,(ix+15)				;Originals stack length
		sub		b
		ret		c
		ld		(ix+15),b
		ld		c,a
		ld		b,0
		Xor		a						;Sets no carry flag etc
		ld		hl,(SyB_StrStackAddr)
		sbc		hl,bc
		ld		(SyB_StrStackAddr),hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ret		


		
;LIBRARY SYB.STRING.RIGHT
;*************************
.SyB_Right
		ld		iy,(SyB_StackAddr)
		ld		c,(iy+7)				;Length Required
		ld		a,(iy+15)				;Originals stack length
		sub		c
		jp		c,SyB_Right_1
		ld		b,a
		ld		e,(iy+13)				;DE=start of text on stack
		ld		d,(iy+14)	
		ld		(iy+15),c				;Store new length
		ld		a,c
		And		a
		jp		z,SyB_Right_1
		ld		l,b
		ld		h,0
		add		hl,de					;HL = Start of text
		ld		b,0
		ldir
		ld		(SyB_StrStackAddr),hl
.SyB_Right_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
		
;LIBRARY SYB.STRING.CHR
;**********************
.SyB_Chr
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),1
		ld		(hl),a
		inc		hl
		ld		(SyB_StrStackAddr),hl
		ret		
		
;LIBRARY SYB.MOUSE.X
;*********************
.SyB_MouseX:
		rst 	#20
		dw 		#813C	
		ld		iy,(SyB_StackAddr)		
		ld		(iy+1),e
		ld		(iy+2),d
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;LIBRARY SYB.MOUSE.Y
;*********************
.SyB_MouseY:
		rst 	#20
		dw 		#813C
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;LIBRARY SYB.MOUSE.KEY
;*********************
.SyB_MouseKey:
		rst 	#20
		dw 		#813F
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret			
		
;LIBRARY SYB.FORM.REFRESH.PARTS
;******************************
.SyB_RefreshStatus:
		call	SyB_RefreshFormPart
		jp		SyDesktop_WINSTA
.SyB_RefreshTitle
		call	SyB_RefreshFormPart
		jp		SyDesktop_WINTIT
.SyB_RefreshStatus:
		call	SyB_RefreshFormPart
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage	
.SyB_RefreshFormPart		
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
		
;LIBRARY SYB.FORM.SIZE.POS		
;*************************
.SyB_SetFormPos
		call	SyB_SetFormPosSize
		jp		SyDesktop_WINMOV
.SyB_SetFormSize
		call	SyB_SetFormPosSize
		jp		SyDesktop_WINSIZ		
;****                    ****		
.SyB_SetFormPosSize
		ld		iy,(SyB_StackAddr)
		ld		hl,SyB_Studio_FormIDs-1			;**** Point to Start of Window List
		ld		e,(iy+19)					
		ld		d,0
		add		hl,de							;**** Calc Position	
		ld		a,(hl)							;**** Checks if exists
		ld		e,(iy+13)
		ld		d,(iy+14)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.FILE.EXIST
;**********************
.SyB_FileExist
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		a,(appBnkNum)
		db		#DD,#67
		ld		a,0
		ld		c,0
		call	SyFile_DIRPRR
		cp		0
		jr		z,SyB_FileExist_Yes
		ld		hl,0							
		jr		SyB_FileExist_Finish
.SyB_FileExist_Yes
		ld		hl,1
		jr		SyB_FileExist_Finish
.SyB_FileExist_Finish
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ret		

;LIBRARY SYB.FILE.DIALOG
;**********************
.SyB_DirDialog:
		ld		a,(AppBnkNum)
		set		7,a
		jr		SyB_FileDialog
.SyB_OpenDialog:
		ld		a,(AppBnkNum)
		jr		SyB_FileDialog
.SyB_SaveDialog:
		ld		a,(AppBnkNum)
		set		6,a
.SyB_FileDialog:		
		ld		(SyB_FileDialog_Extra),a
		ld		iy,(SyB_StackAddr)
		;**** copy "*  ",0 into file area 
		ld		hl,SyB_FileDialog_Data
		ld		bc,4
		ld		de,(SyB_File_Dialog_Pointer)
		ldir
		push	de
		;**** oopy real stuff
		ld		l,(iy+13)
		ld		h,(iy+14)		
		ld		a,(iy+15)
		And		a
		jp		z,SyB_FileDialog_1
		ld		de,(SyB_File_Dialog_Pointer)		
		cp		3
		jp		c,SyB_FileDialog_2
		ld		a,3
.SyB_FileDialog_2:
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_1:		
		pop		de
		ld		l,(iy+19)
		ld		h,(iy+20)		
		ld		a,(iy+21)
		ld		(SyB_StrStackAddr),hl			;Reset to begining
		And		a
		jp		z,SyB_FileDialog_3
		ld		c,a
		ld		b,0
		ldir
.SyB_FileDialog_3:
		Xor		a
		ld		(de),a
		ld		hl,(SyB_File_Dialog_Pointer)		
		ld		a,(SyB_FileDialog_Extra)
		ld		c,(iy+7)	
		
		ld		ix,128
		ld		iy,6000
;		ld		de,Form1_ControlWindow
		call	SySystem_SELOPN
		ld		iy,(SyB_StackAddr)
		And		a
		jp		nz,SyB_FileDialog_Fail
		ld		hl,(SyB_File_Dialog_Pointer)
		ld		bc,4
		add		hl,bc
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		b,0
.SyB_FileDialog_4:
		ld		a,(hl)
		And		a
		jp		z,SyB_FileDialog_5
		ld		(de),a
		inc		hl
		inc		de
		inc		b
		jr		SyB_FileDialog_4
.SyB_FileDialog_5:
		ld		(iy+21),b
		ld		(SyB_StrStackAddr),de
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	
.SyB_FileDialog_Fail:
		ld		de,(SyB_StrStackAddr)
		ld		(iy+19),e
		ld		(iy+20),d
		ld		(iy+21),0
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret				
SyB_FileDialog_Data:	db "*  ",0
SyB_FileDialog_Extra:	db	0		

;;LIBRARY SYB.CONTROL.MOUSEOVER
;.SyB_MouseOver
		
;LIBRARY SYB.CONTROL.PAINT.PEN
.SyB_GetPaintObjPen
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+8)				;**** Upper Byte of ID	
		ld		l,(iy+7)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(ix+4)
		and		%1111
		ld		(iy+7),a
		xor		a
		ld		(iy+8),a
		ret
		
;LIBRARY SYB.CONTROL.PAINT.PEN.SET
;*****************************
.SyB_SetPaintObjPen
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+14)				;**** Upper Byte of ID	
		ld		l,(iy+13)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(iy+7)
		and		%1111
		ld		e,a
		ld		a,(ix+4)
		and 	%10000000
		add 	e
		ld		(ix+4),a
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		
		
;LIBRARY SYB.CONTROL.CTRLABEL.PEN.SET
;*****************************
.SyB_SetCtrLabelObjPen
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+14)				;**** Upper Byte of ID	
		ld		l,(iy+13)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(ix+2)	
		cp		6
		jr		nz,SyB_SetCtrLabelObjPen2
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		bc,6
		add		hl,bc
		ld		a,(iy+7)
		rla
		rla
		rla
		rla
		and		%11110000
		ld		c,a
		ld		a,(hl)
		and		%1111
		add		c
		ld		(hl),a
.SyB_SetCtrLabelObjPen2
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.CONTROL.CTRLABEL.PAPER.SET
;*****************************
.SyB_SetCtrLabelObjPaper
		ld		iy,(SyB_StackAddr)
		ld		h,(iy+14)				;**** Upper Byte of ID	
		ld		l,(iy+13)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		a,(ix+2)	
		cp		6
		jr		nz,SyB_SetCtrLabelObjPaper2
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		bc,6
		add		hl,bc
		ld		a,(iy+7)
		and		%1111
		ld		c,a
		ld		a,(hl)
		and		%11110000
		add		c
		ld		(hl),a
.SyB_SetCtrLabelObjPaper2
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret			

;LIBRARY SYB.CONTROL.ID
;*****************************
.SyB_GetObjID:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+13)
		dec		a
		And		%111
		ld		l,a
		ld		h,0
		add		hl,hl
		ld		de,ControWindowDataList
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		ld		(iy+13),l
		ld		(iy+14),h
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.FOR.INT
;****     FOR STARTER       ****
;**** For Command (Integer) ****
;****                       ****
;IN HL = Address 
.SyB_ForStarter_Int
		ld		iy,(SyB_StackAddr)
		pop		hl					;The Address of the Variable to Use
		ld		e,(hl)				
		inc		hl
		ld		d,(hl)
		inc		hl
		
		ld		a,(iy+19)			;Gets the Value
		ld		(de),a				;Puts the Value into Variable
		ld		(iy+19),e			;Puts Lower Byte of Address into Stack
		inc		de					
		ld		a,(iy+20)
		ld		(de),a
		dec		de
		ld		(iy+20),d
		
		;**** Check What sort of step ****
		ld		a,(iy+8)
		bit		7,a
		jp		z,SyB_ForStarter_Int_2
		ld		(iy+21),1
		jp		(hl)
.SyB_ForStarter_Int_2:		
		ld		(iy+21),0
		jp		(hl)


;****         FOR          ****
.SyB_For_Int
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)	
		
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(iy+21)
		And		a
		jp		z,SyB_For_Int_PositiveStep
		ex		de,hl
		Xor		a
.SyB_For_Int_PositiveStep		
		sbc		hl,de
		jp		c,SyB_ForInt_Exit		
		pop		hl
		inc		hl
		inc		hl
		jp		(hl)
.SyB_ForInt_Exit
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy	
		jp		(hl)

;LIBRARY SYB.NEXT.INT		
;****          NEXT              ****

.SyB_Next_INT
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		c,(iy+7)
		ld		b,(iy+8)
		ex		de,hl
		add		hl,bc
		ex		de,hl
		ld		(hl),d
		dec		hl
		ld		(hl),e	
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl		
		jp		(hl)		
		
		
;LIBRARY SYB.CONTROL.REFRESHALL
;******************************
.SyB_RefreshAll:
		ld		iy,(SyB_StackAddr)
		ld		a,(iy+7)
		dec		a
		ld		c,a
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		e,255
		jp		SyDesktop_WINDIN		
		
;LIBRARY SYB.CONTROL.REFRESH
;***********************
;This Indirect with extras
.SyB_Control_Refresh_3
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		a,(iy+7)		
		dec		a
		and		%1111
		xor		%11111111
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		d,(hl)
		ld		e,a
		jr		SyB_Control_Refresh_21
;This Indirect
.SyB_Control_Refresh_2
		ld		hl,(SyB_StackAddr)			;16
		ld		bc,6						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		e,(hl)
.SyB_Control_Refresh_21
		inc		hl
		ld		a,(hl)
		rra
		rra
		rra
		and		%111
		ld		c,a
;This is Direct		
.SyB_Control_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINDIN
		jp		SyDesktop_SendMessage		

;LIBRARY SYB.CONTROLTOOL.REFRESH
;***************************
;This Indirect
.SyB_ControlTool_Refresh_2		
		ld		hl,(SyB_StackAddr)			;16
		ld		bc,6						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		e,(hl)
		inc		hl
		ld		a,(hl)
		rra
		rra
		rra
		and		%111
		ld		c,a
.SyB_ControlTool_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINTOL
        jp 		SyDesktop_SendMessage

;LIBRARY SYB.STORE.INT.DIRECT
;****************************
.SyB_Store_Int_Direct
		ld		hl,(SyB_StackAddr)						;16
		ld		bc,6									;10
		add		hl,bc									;11
		ld		(SyB_StackAddr),hl						;16
		inc		hl										;6
		ldi												;16
		ldi												;16
		ret												;10				101		

;LIBRARY SYB.STORE.STR
;**********************
.SyB_Store_Str
		pop		ix
		ld		iy,(SyB_StackAddr)
		ld		l,(ix+0)
		ld		h,(ix+1)
		inc		ix
		inc		ix	
		call	SyB_Str_Store_2_Ram
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)

;LIBRARY SYB.STORE.STR.TEXTLINE
;*****************************
.SyB_Store_Str_Textline
		pop		ix
		ld		l,(ix+0)
		ld		h,(ix+1)
		push	ix
		push	hl
		pop		ix
		ld		e,(ix+0)
		ld		d,(ix+1)			;DE Now Equals start of TextLine String
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		(Syb_StrStackAddr),hl
		ld		b,0
		ld		a,(iy+9)
		ld		(ix+4),a
		ld		(ix+5),b
		ld		(ix+6),b
		ld		(ix+7),b
		ld		(ix+8),a
		ld		(ix+9),b
		cp		0
		jr		z,SyB_Store_Str_Textline_2		;For Zero Length skip LDIR
		ld		c,a
		ldir
.SyB_Store_Str_Textline_2
		xor		a
		ld		(de),a
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		pop		ix
		inc		ix
		inc		ix			
		jp		(ix)
		

;LIBRARY SYB.FORM.REFRESHAREA
;***************************
.SyB_Form_RefreshArea
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		(AppMsgB+1),a
		ld		a,-1
		ld		(AppMsgB+2),a
		ld 		a,MSC_DSK_WINPIN
		ld		(AppMsgB+0),a
        db 		#dd:ld h,2       ;2 is the number of the desktop manager process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#10		
		ret
.SyB_Form_RefreshArea_X	
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+4),hl
.SyB_Form_RefreshArea_X_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
.SyB_Form_RefreshArea_Y
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+6),hl
		jr		SyB_Form_RefreshArea_X_1
.SyB_Form_RefreshArea_W
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+10),hl
		jr		SyB_Form_RefreshArea_X_1
.SyB_Form_RefreshArea_H
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+8),hl
		jr		SyB_Form_RefreshArea_X_1		
		
;LIBRARY SYB.FORM.SCROLL.REFRESH
;***************************
.SyB_Form_Scroll_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINSLD
        jp 		SyDesktop_SendMessage
		
;LIBRARY SYB.FORM.STATUS.REFRESH
;***************************
.SyB_Form_Status_Refresh
		ld		b,0
		ld		hl,SyB_Studio_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINSTA
        jp 		SyDesktop_SendMessage		
		
;LIBRARY SYB.FORM.LEFT
;*********************
.SyB_Form_Left
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l				;**** Upper Byte of ID
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.CONTROL.TEXT.LEN
;*********************
.SyB_Control_Text_Len
		ld		iy,(SyB_StackAddr)	
		dec		hl	
		ld		a,(hl)
		ld		(iy+1),a				;**** Upper Byte of ID
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret			
		

;LIBRARY SYB.CONTROL.SETPOS
;**************************
.SyB_SetObjPos
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)				;**** Upper Byte of ID
		ld		h,(iy+20)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		e,(iy+13)
		ld		d,(iy+14)
		ld		(ix+6),e
		ld		(ix+7),d
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+8),e
		ld		(ix+9),d
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.CONTROL.SETWIDTH
;*****************************
.SyB_SetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)				;**** Upper Byte of ID	
		ld		h,(iy+14)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+10),e
		ld		(ix+11),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
;LIBRARY SYB.CONTROL.SETHEIGHT
;*****************************
.SyB_SetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)			;**** Upper Byte of ID
		ld		h,(iy+14)				;**** Lower Byte of Id
		push	hl
		pop		ix
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		(ix+12),e
		ld		(ix+13),d
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		

		
		
;LIBRARY SYB.CONTROL.SETVISIBLE
;*******************************
.SyB_SetObjVisible
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)		
		push	hl
		pop		ix
		ld		a,(ix+2)
		And		%111111
		ld		b,a
		ld		a,(iy+7)
		Or		a
		jp		z,SyB_SetObjVisible_1
		res		7,b
		jr		SyB_SetObjVisible_2
.SyB_SetObjVisible_1:
		set		7,b
.SyB_SetObjVisible_2
		;di
		;jr	Syb_SetObjVisible_2
		ld		(ix+2),b
		ld		bc,12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
		
;LIBRARY SYB.OBJ.LEFT		
;*********************
.SyB_GetObjLeft
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+6)
		ld		(iy+7),a
		ld		a,(ix+7)
		ld		(iy+8),a
		ret	

;LIBRARY SYB.OBJ.TOP		
;********************
.SyB_GetObjTop
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+8)
		ld		(iy+7),a
		ld		a,(ix+9)
		ld		(iy+8),a
		ret			
		
;LIBRARY SYB.OBJ.WIDTH
;**********************
.SyB_GetObjWidth
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+10)
		ld		(iy+7),a
		ld		a,(ix+11)
		ld		(iy+8),a
		ret			

;LIBRARY SYB.OBJ.HEIGHT
;***********************
.SyB_GetObjHeight
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+12)
		ld		(iy+7),a
		ld		a,(ix+13)
		ld		(iy+8),a
		ret			

;LIBRARY SYB.CONTROL.GETIMAGETILE
;***************************
.Syb_GetImageTile
		ld		c,11
		jr		GetImageInfo
.Syb_GetImageSheet
		ld		c,10
		jr		GetImageInfo
.Syb_GetImageWidthByte
		ld		c,0
		jr		GetImageInfo
.Syb_GetImageWidth
		ld		c,1
		jr		GetImageInfo
.Syb_GetImageHeight
		ld		c,2
		jr		GetImageInfo
.Syb_GetImageEncode
		ld		c,9
		jr		GetImageInfo		
.Syb_GetImageSize
		ld		c,7
.Syb_GetImageInfoWord
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)			;****
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+3)
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		b,0
		add		hl,bc
		rst #20:dw #8124	
		ld		(iy+7),c
		ld		(iy+8),b
		ret		
.Syb_GetImageInfo
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)			;****
		ld		h,(iy+8)
		push	hl
		pop		ix
		ld		a,(ix+3)
		ld		l,(ix+4)
		ld		h,(ix+5)
		ld		b,0
		add		hl,bc
		rst #20:dw #812A	
		ld		(iy+7),b
		xor		a
		ld		(iy+8),a
		ret
		
		
;LIBRARY SYB.CONTROL.SETGRAPHIC
;*******************************
.SyB_SetObjGraphic
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+19)			;****
		ld		h,(iy+20)
		push	hl
		pop		ix
.SyB_SetObjGraphic34		
		ld		a,(ix+2)
		ld		b,a
		and		%111111
		cp 		10
		jp		nz,SyB_SetObjGraphic_Finish			
		res		6,b
		ld		(ix+2),b
		
		ld		l,(iy+13)				;HL=Memory Bank Address
		ld		h,(iy+14)
		ld		a,(hl)
		cp		180
		jp		nz,SyB_SetObjGraphic_Finish		
		;**** So it is a Sheet File
		di
		inc		hl
		ld		a,(hl)
		ld		(ix+3),a				;New Bank for Extended Data
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,(iy+7)				;Get Tile wanted
		ld		h,(iy+8)	
		add		hl,hl					;*Multiply by two
		add		hl,de
		inc		hl
		inc		hl
		rst 	#20:dw #8124
		add		hl,bc
		ld		(ix+4),l
		ld		(ix+5),h
		ei
.SyB_SetObjGraphic_Finish
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret


		
		
;LIBRARY SYB.CONTROL.TEXT
;***************************
.SyB_GetObjText
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		push	hl
		pop		ix		
		ld		e,(ix+2)
		ld		d,0
		ld		hl,SyB_Obj_Text_Pointer
		add		hl,de
		ld		a,(hl)
		And		a
		jp		z,SyB_GetObjText_Empty
		
		bit		7,a
		jp		z,SyB_GetObjText_2
		ld		l,(ix+4)
		ld		h,(ix+5)
		And		%111111
		jp		SyB_GetObjText_3
.SyB_GetObjText_2:
		push	ix
		pop		hl
.SyB_GetObjText_3:		
		ld		e,a
		ld		d,0
		add		hl,de	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		b,0
.SyB_GetObjText_5:			
		ld		a,(de)
		And		a
		jp		z,SyB_GetObjText_4
		ld		(hl),a
		inc		de
		inc		hl
		inc		b
		jr		SyB_GetObjText_5
.SyB_GetObjText_4:
		ld		(SyB_StrStackAddr),hl
		ld		(iy+9),b
		ret
.SyB_GetObjText_Empty:
		ld		hl,(SyB_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),0
		ret

;LIBRARY SYB.NET.TCP.SERVER.OPEN
;************************
.SyB_Net_TCP_Server_Open
		ld		a,(SyB_Net_Handle)
		cp		255
		jr		nz,SyB_Net_TCP_Server_Open_End
		ld		iy,(SyB_StackAddr)
		ld		a,1
		ld		l,(iy+7)
		ld		h,(iy+8)		
        call 	snwmsgi_afbcdehlixiy
        db 		FNC_NET_TCPOPN
        call	snwmsgo_afhl
		ld		(Syb_Net_Handle),a
.SyB_Net_TCP_Server_Open_End
		ld		iy,(SyB_StackAddr)	
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.NET.TCP.CLIENT.OPEN
;************************
.SyB_Net_TCP_Client_Open
		ld		a,(SyB_Net_Handle)
		cp		255
		jr		nz,SyB_Net_TCP_Client_Open_End	
		ld		iy,(SyB_StackAddr)
		ld		a,0
		ld		e,(iy+7)
		ld		d,(iy+8)
		ld		l,(iy+19)
		ld		h,(iy+20)
		push	de
		push	hl
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		(SyB_StrStackAddr),hl
		ld		e,(iy+15)
		ld		d,0
		push	hl
		add		hl,de
		ld		a,0
		ld		(hl),a
		pop 	hl		
        ld 		de,(AppBnkNum)
        call 	snwmsgi_afdehl
        db 		FNC_NET_DNSVFY
        call 	snwmsgo_afbcdehlixiy
		ld		a,l
		pop		hl
		pop		de
		cp		1
		jr		nz,SyB_Net_TCP_Client_Open_End
		xor		a
		call 	snwmsgi_afbcdehlixiy
        db 		FNC_NET_TCPOPN
        call 	snwmsgo_afhl
		ld		(Syb_Net_Handle),a
.SyB_Net_TCP_Client_Open_End		
		ld		iy,(SyB_StackAddr)
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY.SYB.NET.CONVERT.IP.2.IXIY
.SyB.Net.Convert.2.IXIY
		
		
		
		ret
		
;LIBRARY SYB.NET.TCP.CLOSE
;************************
.SyB_Net_TCP_Close	
		ld		a,(Syb_Net_Handle)
		call 	snwmsgi_af
        db 		FNC_NET_TCPCLO
        call 	snwmsgo_afhl
		ld		a,255
		ld		(Syb_Net_Handle),a
		ret
		
;LIBRARY SYB.NET.TCP.STRING.RECEIVE
;************************
.SyB_Net_TCP_String_Receive
		ld		a,(AppBnkNum)
		ld		e,a
		ld		a,(Syb_Net_Handle)	
		cp		255
		jp		z,SyB_Net_TCP_String_Receive_2
		ld		iy,(SyB_StackAddr)
		ld		c,(iy+7)
		ld		b,0
		ld		hl,(Syb_StrStackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),c
		push	hl
		add		hl,bc
		ld		(SyB_StrStackAddr),hl
		pop		hl
		call 	snwmsgi_afbcdehl
        db 		FNC_NET_TCPRCV
        call 	snwmsgo_afbchl
		ld		(SyB_Net_Received_Value),hl
		ld		(SyB_Net_Transfered_Value),bc
		ret
.SyB_Net_TCP_String_Receive_2
		ld		hl,(Syb_StrStackAddr)
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(iy+9),0
		ret
		
		
		
;LIBRARY SYB.NET.TCP.SEND
;************************
.SyB_Net_TCP_Send
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		c,(iy+9)
		ld		b,0
		push	hl
		add		hl,bc
		xor		a
		ld		(hl),a
		pop		hl
		ld		(Syb_StrStackAddr),hl
		ld		a,(AppBnkNum)
		ld		e,a
		ld		a,(Syb_Net_Status_Value)	
		cp		2
		jr		nz,SyB_Net_TCP_Send_2
		ld		a,1
		ld		(SyB_Net_Send_Wait_Value),a
.SyB_Net_TCP_Re_Send_Perhaps:	
		ld		a,(Syb_Net_Handle)	
		cp		255
		jr		z,SyB_Net_TCP_Send_2
		ld		(SyB_Net_TCP_Store),hl
		call 	snwmsgi_afbcdehl
        db 		FNC_NET_TCPSND
        call 	snwmsgo_afbchl
		jr		z,SyB_Net_TCP_Send_3
		;**** Need to resend
		rst		#30
		ld		a,(SyB_Net_Send_Wait_Value)
		inc		a
		cp		20
		jr		z,SyB_Net_TCP_Send_3
		ld		(SyB_Net_Send_Wait_Value),a		
		ld		a,l
		ld		hl,(SyB_Net_TCP_Store)
		add		hl,bc
		ld		c,a
		ld		b,0
		ld		a,(AppBnkNum)
		ld		e,a
		jr		SyB_Net_TCP_Re_Send_Perhaps
		
.SyB_Net_TCP_Send_3
		ld		iy,(SyB_StackAddr)
.SyB_Net_TCP_Send_2		
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
.SyB_Net_TCP_Store:	dw	0		
			
;LIBRARY SYB.NET.STATUS
;**************************
.SyB_Net_Status
		ld		a,(SyB_Net_Status_Value)
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.FUNCTION.HL.2.STACK
;*******************************
.SyB_Function_HL_2_Stack
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

		
;LIBRARY SYB.NET.DNS
;*******************
.SyB_Net_DNS_Verify

.SyB_Net_DNS_Resolve
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)				
		ld		(SyB_StrStackAddr),hl
		ld		e,(iy+9)
		ld		d,0
		push	hl
		add		hl,de
		xor		a
		ld		(hl),a
		pop		hl
		ld		a,(SyNet_PrcID)
		or		a
		jr		z,SyB_Net_DNS_Resolve_20
		;DNS PART
        ld 		de,(AppBnkNum)
        call 	snwmsgi_afdehl
        db 		FNC_NET_DNSRSV
        call 	snwmsgo_afbcdehlixiy
		jr		nc,SyB_Net_DNS_Resolve_2
;*** Error


.SyB_Net_DNS_Resolve_20		
		add		hl,de
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),0
		ret	
.SyB_Net_DNS_Resolve_Tmp 	dw 0		
.SyB_Net_DNS_Resolve_2
		
		push	iy
		push	iy	
		push	ix
		push 	ix
		ld		iy,(SyB_StrStackAddr)
		pop		hl
		ld		h,0
		call	clcnum
		ld		a,"."
		ld		(iy+0),a
		inc		iy
		pop		hl
		ld		l,h
		ld		h,0
		call	clcnum
		ld		a,"."		
		ld		(iy+0),a
		inc		iy		
		pop		hl
		ld		h,0
		call	clcnum
		ld		a,"."
		ld		(iy+0),a
		inc		iy
		pop		hl
		ld		l,h
		ld		h,0
		call	clcnum
		push	iy
		pop		de
		ld		hl,(SyB_StrStackAddr)
		and		a
		ex		de,hl
		sbc		hl,de
		ld		iy,(SyB_StackAddr)
		ld		(iy+9),l
		ld		(SyB_StrStackAddr),de
		ret				

clcnumt dw -1,-10,-100,-1000,-10000

clcnum  ld ix,clcnumt+8
        ld b,5
        xor a
        bit 7,h
        jr z,clcnum1
        ld (iy+0),"-"
        inc iy
        ld a,l
        cpl
        ld l,a
        ld a,h
        cpl
        ld h,a
        inc hl
clcnum1 ld e,(ix+0)
        ld d,(ix+1)
        dec ix
        dec ix
        ld c,"0"
clcnum2 add hl,de
        jr nc,clcnum5
        inc c
        inc a
        jr clcnum2
clcnum5 sbc hl,de
        or a
        jr z,clcnum3
        ld (iy+0),c
        inc iy
clcnum3 djnz clcnum1
        or a
        ret nz
        ld (iy+0),"0"
        inc iy
        ret
		
		

.SyB_Net_Hex_Ret
		push af
		rra
		rra
		rra
		rra
		and	%1111
		ld	hl,SyB_Net_Hex
		ld	c,a
		ld	b,0
		add	hl,bc
		ld	a,(hl)
		ld	(de),a
		inc	de
		pop	af
		and	%1111
		ld	hl,SyB_Net_Hex
		ld	c,a
		ld	b,0
		add	hl,bc
		ld	a,(hl)
		ld	(de),a
		inc	de		
		ret
.SyB_Net_Hex
		db "0123456789ABCDEF'		
		
;LIBRARY SYB.SYS.SCREENMODE
;***************************
.SyB_ScreenMode:
		ld 		hl,#8139
		rst 	#28
		ld		hl,(SyB_StackAddr)
		Xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret	
		
;LIBRARY SYB.DIRECTORY.NEW
;*************************
.SyB_Directory_New
		ld		hl,SyFile_DIRNEW
		ld		(SyB_Directory_New_2+1),hl
		ld		a,2
		ld		(SyB_Directory_New_3+1),a
.SyB_Directory_New_1
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(appBnkNum)
		db		#DD,#67
SyB_Directory_New_2		
		call	SyFile_DIRNEW
		ret		nc
		ld		e,a
SyB_Directory_New_3		
		ld		d,2
		jp		SyB_Mark_Error	
;**** Delete shares New
.SyB_Directory_Delete
		ld		hl,SyFile_DIRRMD
		ld		(SyB_Directory_New_2+1),hl
		ld		a,3
		ld		(SyB_Directory_New_3+1),a	
		jp		SyB_Directory_New_1
		
;LIBRARY SYB.DIRECTORY.RENAME
;****************************
.SyB_Directory_Rename
		ld		hl,SyFile_DIRREN
		ld		(SyB_Directory_New_2+1),hl
		ld		a,4
		ld		(SyB_Directory_New_3+1),a
.SyB_Directory_Rename_1
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ld		e,(iy+7)
		ld		d,(iy+8)
		di
.afjttt	jr		afjttt		
		
		ld		bc,-12
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ld		a,(appBnkNum)
		db		#DD,#67
SyB_Directory_Rename_2		
		call	SyFile_DIRREN
		ret		nc
		ld		e,a
SyB_Directory_Rename_3		
		ld		d,4
		jp		SyB_Mark_Error
;**** Move shares Rename
.SyB_Directory_Move
		ld		hl,SyFile_DIRMOV
		ld		(SyB_Directory_New_2+1),hl
		ld		a,5
		ld		(SyB_Directory_New_3+1),a	
		jp		SyB_Directory_New_1			
		
;LIBRARY SYB.SYS.RESOLUTION
;***************************
.SyB_ResolutionX
		ld 		hl,#8139
		rst 	#28
		Push	ix
        jr		SyB_Resolution_2
.SyB_ResolutionY:
		ld 		hl,#8139
		rst 	#28
		Push 	iy
.SyB_Resolution_2
		ld		hl,(SyB_StackAddr)
		Xor		a		
		ld		(hl),a
		inc		hl	
		pop		de
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret
			
;LIBRARY SYB.SYS.RAMSIZE
;***********************
.SyB_RamSize
		ld 		hl,#8100			;SymBos Function
		rst 	#28
		ld		l,d
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamSize_1		
		add		hl,hl				;*2
		djnz	SyB_RamSize_1
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		

;LIBRARY SYB.SYS.RAMFREE
;***********************
.SyB_RamFree
		ld hl,#8100			;SymBos Function
		rst #28
		ld		l,e
		inc		l
		ld		h,0
		ld		b,6
.SyB_RamFree_1		
		add		hl,hl				;*2
		djnz	SyB_RamFree_1
		push	ix
		pop		de
		ld		a,d
		ld		d,0
		rra
		rra
		And		%111111
		ld		e,a
		add		hl,de
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

		
;LIBRARY SYB.SYB.COLOURDEPTH		
;****************************
.SyB_ColourDepth:
		ld 		hl,#8139
		rst 	#28
		ld		a,d
		And		%1111
		ld		d,a
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret		
		
;LIBRARY SYB.SYS.MACHINE
;***********************
.SyB_Machine
        ld 		hl,jmp_sysinf        ;#8103 SYSINF
        ld 		de,256*1+5
        ld 		ix,syb_machine_type
        ld 		iy,66+2+6+8
        rst 	#28
		ld		hl,(SyB_StackAddr)
		xor 	a
		ld		(hl),a
		inc		hl
		ld		a,(SyB_Machine_Type)
		ld		(hl),a
		inc		hl
		xor 	a
		ld		(hl),a
		ld		de,-8
		add		hl,de
		ld		(SyB_StackAddr),hl
		ret	
		
;LIBRARY SYB.SYS.KEY
;*******************
.SyB_KEY
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)
		ld 		hl,#8145:rst #28		;*** KEYTST
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),e
		ld		d,0
		ld		(iy+8),d
		ret
		
;LIBRARY SYB.SYS.KEYSTATUS
;*************************
.SyB_KEYSTATUS
		ld hl,#8148:rst #28
		ld		a,d
		rla
		rla
		rla
		or		e
		ld		a,e
		ld		d,0
		ld		iy,(SyB_StackAddr)
		ld		bc,-6
		add		iy,bc
		ld		(iy+7),e
		ld		(iy+8),d
		ld		(SyB_StackAddr),iy
		ret	
		
		
;LIBRARY SYB.CONTROL.VISIBLE.GET
;*******************************
.SYB_CONTROL_VISIBLE_GET
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)
		ld		h,(iy+8)		
		push	hl
		pop		ix
		ld		a,(ix+2)
		rla		
		And		%1
		ld		(iy+7),a
		ld		(iy+8),0
		ret		
		
;;;;;LIBgRARY SYB.OBJ.VISIBLE
;;******************************
;.SyB_GetObjVisible
;		call	SyB_ControlAddrIX_IY78
;		ld		a,(ix+2)
;		And		%10000000
;		jp		z,SyB_GetObjVisible_1
;		Xor		a
;		jp		SyB_GetObjVisible_2
;.;SyB_GetObjVisible_1		
;		ld		a,1
;.SyB_GetObjVisible_2		
;		ld		(iy+7),a
;		ld		(iy+8),0
;		ret		

;LIBRARY SYB.TIME.SECOND
;***********************
.SyB_GetSecond
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),a
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret	

;LIBRARY SYB.TIME.MINUTE
;***********************
.SyB_GetMinute
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),b
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.TIME.HOUR
;*********************
.SyB_GetHour
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),c
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret

;LIBRARY SYB.TIME.DAY
;*********************
.SyB_GetDay
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),d
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret

;LIBRARY SYB.TIME.MONTH
;**********************
.SyB_GetMonth
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),e
		ld		(iy+2),0
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy			
		ret

;LIBRARY SYB.TIME.YEAR
;*********************
.SyB_GetYear
		rst		#20
		dw 		#810c
		ld		iy,(SyB_StackAddr)
		ld		(iy+1),l
		ld		(iy+2),h
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.PUSH.N.INT		
;***********************
.SyB_Push_N_Int
		pop		hl							;11
		ld		de,(SyB_StackAddr)			;20 ;**** Get Address of Data Stack		
		inc		de							;6	;**** Modes up Stack 1
		ldi									;16	;**** Copies (HL)-(DE)
		ldi									;16	;**** Copies (HL)-(DE)
		ex		de,hl
		ld		hl,(SyB_StackAddr)			;16
		ld		bc,-6						;10
		add		hl,bc						;11
		ld		(SyB_StackAddr),hl			;16
		ex		de,hl						;4
		jp		(hl)						;4			

;LIBRARY SYB.INT.EQ.DEHL
;***********************
.SyB_Int_Eq_DEHL
		ld		a,e
		cp		l
		jr		nz,SyB_Int_Eq_DEHL_Fail
		ld		a,d
		cp		h
		jr		nz,SyB_Int_Eq_DEHL_Fail
		ld		hl,1
		ret
.SyB_Int_Eq_DEHL_Fail
		scf
		ld		hl,0
		ret
		
;LIBRARY SYB.INT.EQ	
;**** Do Integer Equals ****
.SyB2_INT_EQ
		call	SyB_N_VGL_2
.SyB2_INT_EQ_10
		cp		0
		jp		z,SyB_Push_Bool_Result_1	;***** Result was Greater Than so 1 Bool Result
		jp		SyB_Push_Bool_Result_0		;***** Result was not Greater than so 0 Bool Result
;LIBRARY SYB.FLO.EQ	
;**** Do Float Equals ****
.SyB2_FLO_EQ
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.INT.EQ
		inclib 	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jp		SyB2_INT_EQ_10
;LIBRARY SYB.STR.EQ		
;**** Do String Equals ****
.SyB2_STR_EQ
		inclib	SYB.INT.EQ
		call	SyB_S_VGL					;String comparison
		call 	SyB2_Str_Reduce
		jp		SyB2_INT_EQ_10	
;LIBRARY SYB.INT.GTE.HL
;**********************
.SyB_INT_GTE_HL
		ld		a,h
		xor		d
		and		%10000000
		jr		z,SyB_INT_GTE_HL_1			;If Same sign 
		bit		7,d
		jr		z,SyB_INT_GTE_HL_3
.SyB_INT_GTE_HL_2
		xor		a
		ld		hl,1
		ret
.SyB_INT_GTE_HL_1		
		sbc		hl,de
		jr		nc,SyB_INT_GTE_HL_2
.SyB_INT_GTE_HL_3
		scf
		ld		hl,0
		ret
;LIBRARY SYB.INT.GTE		
;**** Do Integer Greater Than Equals ****
.SyB2_INT_GTE
		call	SyB_N_VGL_2
.SyB2_INT_GTE_10		
		cp		-1
		jp		z,SyB_Push_Bool_Result_0	;***** Result was not LessThanEqual so 0 Bool Result
		jp		SyB_Push_Bool_Result_1		;***** Result was LessThanEqual so 1 Bool Result
;LIBRARY SYB.FLO.GTE		
;**** Do Float Greater Than Equals ****
.SyB2_FLO_GTE
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.INT.GTE
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jp		SyB2_INT_GTE_10
;LIBRARY SYB.STR.GTE		
;**** Do String Greater Than Equals ****
.SyB2_STR_GTE
		inclib	SYB.INT.GTE
		call	SyB_S_VGL					;String comparison
		call	SyB2_Str_Reduce
		jp		SyB2_INT_GTE_10
;LIBRARY SYB.INT.LTE.HL
;**********************		
.SyB_INT_LTE_HL		
		ld		a,h
		xor		d
		and		%10000000
		jr		z,SyB_INT_LTE_HL_1
		bit		7,d
		jr		nz,SyB_INT_LTE_HL_3
.SyB_INT_LTE_HL_2
		xor		a
		ld		hl,1
		ret
.SyB_INT_LTE_HL_1
        sbc     hl,de
		jr		c,SyB_INT_LTE_HL_2
		jr		z,SyB_INT_LTE_HL_2
.SyB_INT_LTE_HL_3
		scf
		ld		hl,0
		ret		
;LIBRARY SYB.INT.LTE		
;**** Do Integer Lesser Than Equal ****
.SyB2_INT_LTE
		call	SyB_N_VGL_2
.SyB2_INT_LTE_10
		cp		1
		jp		z,SyB_Push_Bool_Result_0	;***** Result was not LessThanEqual so 0 Bool Result
		jp		SyB_Push_Bool_Result_1		;***** Result was LessThanEqual so 1 Bool Result
;LIBRARY SYB.FLO.LTE		
;**** Do Float Lesser Than Equal ****
.SyB2_FLO_LTE
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.INT.LTE
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jp		SyB2_INT_LTE_10
;LIBRARY SYB.STR.LTE
;**** Do String Lesser Than Equal ****
.SyB2_STR_LTE
		inclib	SYB.INT.LTE
		call	SyB_S_VGL					;String comparison
		call	SyB2_Str_Reduce
		jp		SyB2_INT_LTE_10
;LIBRARY SYB.INT.OT		
;**** Do Integer Other Than ****
.SyB2_INT_OT
		call	SyB_N_VGL_2
.SyB2_INT_OT_10
		cp		0
		jp		z,SyB_Push_Bool_Result_0	;***** Result was not Other Than so 0 Bool Result
		jp		SyB_Push_Bool_Result_1		;***** Result was Other Than so 1 Bool Result
;LIBRARY SYB.FLO.OT
;**** Do Float Other Than ****
.SyB2_FLO_OT
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.INT.OT
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jp		SyB2_INT_OT_10
;LIBRARY SYB.STR.OT		
;**** Do String Other Than ****
.SyB2_STR_OT
		inclib	SYB.INT.OT
		call	SyB_S_VGL					;String comparison
		call	SyB2_Str_Reduce
		jp		SyB2_INT_OT_10
		
;LIBRARY SYB.INT.LT.HL		
;**** Do Integer Lesser Than ****
.SyB_INT_LT_HL		
		ld		a,h
		xor		d
		and		%10000000
		jr		z,SyB_INT_LT_HL_1
		bit		7,d
		jr		nz,SyB_INT_LT_HL_3
.SyB_INT_LT_HL_2
		xor		a
		ld		hl,1
		ret
.SyB_INT_LT_HL_1
        sbc     hl,de
		jr		c,SyB_INT_LT_HL_2
.SyB_INT_LT_HL_3
		scf
		ld		hl,0
		ret		
;LIBRARY SYB.INT.LT		
;**** Do Integer Lesser Than ****
.SyB2_INT_LT
		call	SyB_N_VGL_2
.SyB2_INT_LT_10
		cp		-1
		jp		z,SyB_Push_Bool_Result_1	;***** Result was LessThan so 1 Bool Result
		jp		SyB_Push_Bool_Result_0		;***** Result was not LessThan so 0 Bool Result
;LIBRARY SYB.FLO.LT		
;**** Do Float Lesser Than ****
.SyB2_FLO_LT
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.INT.LT
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jp		SyB2_INT_LT_10
;LIBRARY SYB.STR.LT
;**** Do String Lesser Than ****
.SyB2_STR_LT
		inclib	SYB.INT.LT
		call	SyB_S_VGL					;String comparison
		call	SyB2_Str_Reduce
		jp		SyB2_INT_LT_10
;LIBRARY SYB.INT.GT.HL		
;**** Do Integer Greater Than ****
.SyB_INT_GT_HL
		ld		a,h
		xor		d
		and		%10000000
		jr		z,SyB_INT_GT_HL_1			;If Same sign 
		bit		7,d
		jr		z,SyB_INT_GT_HL_3
.SyB_INT_GT_HL_2
		xor		a
		ld		hl,1
		ret
.SyB_INT_GT_HL_1
;		di
;.hhttt4	jr	hhttt4
;			ei
		sbc		hl,de
;		di
;.hhttt5	jr	hhttt5
;			ei
		jr		z,SyB_INT_GT_HL_3
		jr		nc,SyB_INT_GT_HL_2
.SyB_INT_GT_HL_3
		scf
		ld		hl,0
		ret		
		
;LIBRARY SYB.INT.GT
;**** Do Integer Greater Than ****
.SyB2_INT_GT
		call	SyB_N_VGL_2
.SyB2_INT_GT_10
		cp		1
		jp		z,SyB_Push_Bool_Result_1	;***** Result was Greater Than so 1 Bool Result
		jp		SyB_Push_Bool_Result_0		;***** Result was not Greater than so 0 Bool Result	
;LIBRARY SYB.FLO.GT
;**** Do Float Greater Than ****
.SyB2_FLO_GT
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.INT.GT
		inclib	SYB.STACK.2.FLO
		call	SyB2_STACK_2_FLO
		call	FLO_VGL
		jp		SyB2_INT_GT_10
;LIBRARY SYB.STR.GT	
;**** Do String Greater Than ****
.SyB2_STR_GT
		inclib	SYB.INT.GT
		call	SyB_S_VGL					;String comparison
		call	SyB2_Str_Reduce
		jp		SyB2_INT_GT_10		
		
;**** Converts the Stack from a Float to Integer Value
;**** Depending on What Stack needs to be adjusted *****
;LIBRARY SYB.FLO.2.INT.STACK.1

.SyB_FLO_2_INT_Stack_1
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,7
		jp		SyB_FLO_2_INT_BC
;LIBRARY SYB.FLO.2.INT.STACK.2
.SyB_FLO_2_INT_Stack_2
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,13
		jp		SyB_FLO_2_INT_BC
;LIBRARY SYB.FLO.2.INT.STACK.3
.SyB_FLO_2_INT_Stack_3
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,19
		jp		SyB_FLO_2_INT_BC
;LIBRARY SYB.FLO.2.INT.STACK.4
.SyB_FLO_2_INT_Stack_4
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,25
		jp		SyB_FLO_2_INT_BC
;LIBRARY SYB.FLO.2.INT.STACK.5
.SyB_FLO_2_INT_Stack_5
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,31
		jp		SyB_FLO_2_INT_BC
;LIBRARY SYB.FLO.2.INT.STACK.6
.SyB_FLO_2_INT_Stack_6
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,37
		jp		SyB_FLO_2_INT_BC
;LIBRARY SYB.FLO.2.INT.STACK.7
.SyB_FLO_2_INT_Stack_7
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,43
		jp		SyB_FLO_2_INT_BC		
;LIBRARY SYB.FLO.2.INT.STACK.8
.SyB_FLO_2_INT_Stack_8
		inclib	SYB.FLOAT.ROUTINES
		inclib	SYB.FLO.2.INT.BC
		ld		bc,49
		jp		SyB_FLO_2_INT_BC

;LIBRARY SYB.STACK.2.FLO		
.SyB2_STACK_2_FLO
		ld		hl,(SyB_StackAddr)
		inc		hl
		ld		bc,6
		add		hl,bc
		ld		e,l
		ld		d,h
		add		hl,bc
		ret		

;LIBRARY SYB.INT.2.FLO.STACK.2

.SyB_INT_2_FLO_Stack_2
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,12
		jp		SyB_INT_2_FLO_BC
.SyB_INT_2_FLO_Stack_3
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,18
		jp		SyB_INT_2_FLO_BC
.SyB_INT_2_FLO_Stack_4
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,24
		jp		SyB_INT_2_FLO_BC
.SyB_INT_2_FLO_Stack_5
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,30
		jp		SyB_INT_2_FLO_BC
.SyB_INT_2_FLO_Stack_6
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,36
		jp		SyB_INT_2_FLO_BC
.SyB_INT_2_FLO_Stack_7
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,42
		jp		SyB_INT_2_FLO_BC
.SyB_INT_2_FLO_Stack_8
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,48
		jp		SyB_INT_2_FLO_BC	
;**** Converts the Stack from an Int to Float Value
.SyB_INT_2_FLO_Stack_1
		inclib	SYB.FLOAT.ROUTINES
.SyB_INT_2_FLO
		inclib	SYB.FLOAT.ROUTINES
		ld		bc,6	
.Syb_INT_2_FLO_BC
		inclib	SYB.FLOAT.ROUTINES	
		ld		hl,(SyB_StackAddr)
		add		hl,bc
		ld		a,1
		ld		(hl),a
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		dec		hl	
;		Xor		a
		bit		7,d
		jr		z,Syb_INT_2_FLO_BC_99				
		ld		a,e
		Xor		255
		ld		e,a
		ld		a,d
		Xor		255
		ld		d,a
		inc		de
		ld		a,128
.Syb_INT_2_FLO_BC_99			
		ex		de,hl
		call	FLO_KONV_HLA_TO_FLO
		ret			

;LIBRARY SYB.FLO.2.INT.BC		
;**** Converts the Stack from a Float to Integer Value
.SyB_FLO_2_INT_BC
		inclib	SYB.FLOAT.ROUTINES
		ld		hl,(SyB_StackAddr)
		add		hl,bc
.SyB_FLO_2_INT_XTRA		
		push	hl
		call	FLO_ROUND_FLO_TO_HLA
		bit		7,a
		jr		z,SyB_FLO_2_INT_2
		ld		a,l
		Xor		255
		ld		l,a
		ld		a,h
		Xor		255
		ld		h,a
		inc		hl
.SyB_FLO_2_INT_2
		ex		de,hl
		pop		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret
;LIBRARY SYB.PUSH.N.FLO
;***********************		
.SyB_Push_N_Flo
		inclib	SYB.FLOAT.ROUTINES
		pop		hl
		push	hl
		call	SyB_PushFlo
		pop		hl
		ld		bc,5
		add		hl,bc
		jp		(hl)
		
;LIBRARY SYB.STORE.FLO.ARRAY.1		
;**** Takes Single Array Float from Stack ****
.SyB_Store_Flo_Array_1
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		inc		de					;Stores Dimension data Ignore
		inc		de					;
		ld		hl,(SyB_StackAddr)
		ld		bc,13
		add		hl,bc
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc
		add		hl,de
		ex		de,hl
		ld		hl,(SyB_StackAddr)
		ld		bc,6
		add		hl,bc
		inc		hl
		ldi
		ldi
		ldi
		ldi
		ldi
		ld		(SyB_StackAddr),hl
		ret
;LIBRARY SYB.STORE.FLO.ARRAY.2		
;**** Takes Double Array Float from Stack ****
.SyB_Store_Flo_Array_2
		pop		hl					;Get Return Address
		ld		e,(hl)				;Gets the Following Two Bytes which hold Var Address Base
		inc		hl					;
		ld		d,(hl)				;DE=Var Address Base
		inc		hl					;Moves HL on
		push	hl					;Store the Reurn Position
		ex		de,hl				;HL = Start of Array
		ld		e,(hl)
		inc		hl
		ld		d,(hl)				;DE = Skip multiple
		inc		hl					;HL= Start of Array Data
		push	hl					;Return point
		ld		iy,(SyB_StackAddr)
		ld		l,(iy+13)
		ld		h,(iy+14)
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB_Store_Flo_Array_Mul_2	
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB_Store_Flo_Array_Mul_2
		pop		de
		sbc		hl,de
		push	hl
		ld		l,(iy+19)
		ld		h,(iy+20)
		ld		c,l
		ld		b,h
		add		hl,hl
		add		hl,hl
		add		hl,bc				;**** Times 5
		pop		de
		add		hl,de
		pop		de
		add		hl,de	
		ld		a,(iy+7)
		ld		(hl),a
		inc		hl
		ld		a,(iy+8)
		ld		(hl),a
		inc		hl
		ld		a,(iy+9)
		ld		(hl),a
		inc		hl
		ld		a,(iy+10)
		ld		(hl),a
		inc		hl
		ld		a,(iy+11)
		ld		(hl),a
		ld		bc,18
		add		iy,bc
		ld		(SyB_StackAddr),iy
		ret
;LIBRARY SYB.PUSH.N.STR
;**** Push String from Memory onto String Stack ****
.SyB_Push_N_Str
		pop		hl
		ld		a,(hl)
		inc		hl
		ld		iy,(SyB_StackAddr)
		ld		de,(SyB_StrStackAddr)
		ld		(iy+1),e
		ld		(iy+2),d
		ld		(iy+3),a
		ld		bc,-6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		And		a
		jp		z,SyB_Push_N_Str_Finish
		ld		c,a
		ld		b,0
		ldir
		ld		(SyB_StrStackAddr),de
.SyB_Push_N_Str_Finish	
		jp		(hl)
;LIBRARY SYB.PUSH.V.STR.ARRAY.1		
;****                                         ****
;**** Push String Var Array onto String Stack ****
;****                                         ****
.SyB_Push_V_Str_Array_1
		pop		ix							;Return Adress holds Variable Loc
		ld		l,(ix+0)
		ld		h,(ix+1)					;HL=Variable
		inc		ix
		inc		ix							;IX Skip 
		ld		iy,(SyB_StackAddr)
		ld		e,(iy+7)					;DE=Array value
		ld		d,(iy+8)		
		inc		hl							;Skip HL Over 
		inc		hl
		add		hl,de
		add		hl,de						;Add together to get String Pointer Address
		ld		e,(hl)
		inc		hl
		ld		d,(hl)						
		ex		de,hl						;HL=Address of string
		
		dec		hl							;Step Back 1 to Length
		ld		c,(hl)						;Move back to start of Text
		inc		hl
		ld		de,(SyB_StrStackAddr)		;Last Piece of String on Stack
		ld		b,0							;BC=Length to loop down
		;ld		(iy+6),5
		ld		(iy+7),e					;Stack = String Stack location
		ld		(iy+8),d					;ditto
		ld		(iy+9),c					;Stack = String Length
		Xor		a
		cp		c			
		jp		z,SyB_Push_V_Str_Array_1_1	;Do nothing if zero
		ldir								;Copy info to String Stack
		ld		(SyB_StrStackAddr),de		;Update new String Stack 
.SyB_Push_V_Str_Array_1_1
		jp		(ix)
		
;LIBRARY SYB.PUSH.V.INT.ARRAY.1.DIRECT		
;************************************
;DE = Array Address + 2
.SyB_Push_V_Int_Array_1_Direct
		ld		ix,(SyB_StackAddr)
		ld		l,(ix+7)
		ld		h,(ix+8)
		add		hl,hl					;**** Times 2
		add		hl,de
		ld		a,(hl)
		ld		(ix+7),a
		inc		hl
		ld		a,(hl)
		ld		(ix+8),a
		ret	
;LIBRARY SYB.PUSH.V.INT.ARRAY.1.DIRECT.DEHL
;******************************************
.SyB_Push_V_Int_Array_1_Direct_DEHL
		add		hl,hl			;11
		add		hl,de			;11
		ld		e,(hl)			;7
		inc		hl				;6
		ld		d,(hl)			;7
		ex		de,hl			;4
		ret						;10
		
;LIBRARY SYB.PUSH.V.STR.ARRAY.2		
;****                                                ****
;**** Push String Var Double Array onto String Stack ****
;****                                                ****
.SyB_Push_V_Str_Array_2
		pop		ix						;**** Holds Variable
		ld		l,(ix+0)				;HL=Variable Address
		ld		h,(ix+1)
		ld		e,(hl)					;DE=Array size
		inc		hl
		ld		d,(hl)
		inc		hl		
		push	hl
		

		ld		iy,(SyB_StackAddr)
		ld		l,(iy+7)				;**** Get the Second Stacked Integer
		ld		h,(iy+8)				;				
		;****  	Multiply shit ****
		ex		de,hl
		push	hl
		push	hl
		pop		bc
.SyB2_Store_Str_Array_Mul_2		
		add		hl,de
		dec		bc
		ld		a,b
		Or		c
		jr		nz,SyB2_Store_Str_Array_Mul_2
		pop		de
		sbc		hl,de
		ex		de,hl
		ld		l,(iy+13)
		ld		h,(iy+14)
		add		hl,hl
		add		hl,de
		pop		de
		add		hl,de
		inc		ix
		inc		ix
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl		
		dec		hl							;Step Back 1 to Length
		ld		c,(hl)						;Move back to start of Text
		inc		hl
			
		ld		de,(SyB_StrStackAddr)		;Last Piece of String on Stack
		ld		b,0							;BC=Length to loop down
		;ld		(iy+6),5
		ld		(iy+13),e					;Stack = String Stack location
		ld		(iy+14),d					;ditto
		ld		(iy+15),c					;Stack = String Length
		Xor		a
		cp		c			
		jp		z,SyB_Push_V_Str_Array_2_1	;Do nothing if zero
		ldir								;Copy info to String Stack
		ld		(SyB_StrStackAddr),de		;Update new String Stack 
.SyB_Push_V_Str_Array_2_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy
		jp		(ix)		
;LIBRARY SYB.DSPGET
;==============================================================================
;### DISPLAY-ROUTINES #########################################################
;==============================================================================
;### DSPGET -> converts 5byte floating point value to display format
;### Input  DE=pointer to 5byte floating point value
.DspGet
		jr		dspget99
.dspvaltmp   ds 5+1
.dspvalnum   ds 10+1
.dspvallen   db 0
.dspvalsgn   db 0        ;0=positive; display no sign, -1=minus
.dspvalexp   db 0        ;exponent (signed)
.dspvaldig   equ 10      ;maximum amount of displayed mantissa digits
.dspchrflg   db 0        ;flag (input), if 1000 points should be displayed
.dspfeflg    db 0        ;flag (input), if force exponent display
.dspchrcom   db "."      ;symbol for 1000 points
.dspchrpoi   db ","      ;symbol for comma
.dspintflg   db 0        ;flag (result), if displayed number is integer
.dspget99:
		inclib  SYB.FLOAT.ROUTINES	
		ld 		hl,0
        ld 		(dspvalsgn),hl
        ld 		hl,dspvaltmp
        call 	FLO_MOVE
        call 	FLO_PREPARE		
        ld 		a,b
        Or 		a
        jr 		z,dspget3
        And 	128
        add 	a
        sbc 	0
        ld 		(dspvalsgn),a
        ld 		a,e
        ld 		(dspvalexp),a
        ld 		ix,(dspvaltmp+0)
        ld 		de,(dspvaltmp+2)
        db 		#dd:ld a,l
        db 		#dd:Or h		
        Or 		e
        Or 		d
        jr 		z,dspget3
		ld 		iy,dspvalnum

		call 	clcn32
 
        push 	iy
		pop hl
        ld 		bc,dspvalnum-1
        Or 		a
        sbc 	hl,bc
        ld 		c,l
        ld 		a,"0"
        ld 		hl,dspvalexp

.dspget1
		cp 		(iy+0)
        jr 		nz,dspget2
        ld 		(iy+0),0
        dec 	iy
        inc 	(hl)
        dec 	c
        jr 		nz,dspget1
.dspget2
		ld 		a,c
.dspget3
		ld 		(dspvallen),a
        ret

;### DSPTXT -> converts display format value to text and displays it
.dsptxt
		Xor 	a
        ld 		(dspintflg),a
        ld 		a,(dspvalsgn)        ;*** Sign
        inc 	a
        jr 		nz,dsptxt1
        ld 		(hl),"-"
        inc 	hl
.dsptxt1
		ex 		de,hl
        ld 		a,(dspvallen)        ;*** Test, if value=0
        Or 		a
        jr 		nz,dsptxti
.dsptxty
		ld 		a,"0"                ;display only 0.
        ld 		(de),a
        inc 	de
        jr 		dsptxth
.dsptxti
		ld 		hl,dspvalnum
        ld 		a,(dspfeflg)
        Or 		a
        jr 		nz,dsptxt6           ;display exponent, if in RO mode and F-E on
        ld 		a,(dspvalexp)        ;*** Exponent
        ld 		b,a
        Or 		a
        ld 		a,(dspvallen)
        ld 		c,a
        jp 		m,dsptxta
        add	 	b                   ;*** Exponent positive -> exp display, if dspvallen + dspvalexp <= dspvaldig
        cp 		dspvaldig+1          ;a=length of complete number
        jr 		nc,dsptxt6
        ld 		b,a                  ;*** Display mantissa without comma (a,b=length of mantissa before comma)
        ld 		a,1
        ld 		(dspintflg),a
        ld 		a,b
.dsptxt2
		sub 	3
        jr 		z,dsptxtf
        jr 		nc,dsptxt2
.dsptxtf
		add 	3
        ld 		c,a                  ;c=1000 counter
.dsptxt3
		ld 		a,(hl)
        inc 	hl
        Or 		a
        jr 		nz,dsptxt4
        ld 		a,"0"
        dec 	hl
.dsptxt4
		call 	dsptxt5
        jr 		nz,dsptxt3
.dsptxth
		ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        Xor 	a
        ld 		(de),a
        ret
.dsptxt6
		ld 		a,(hl)               ;**** Display mantissa with exponent
        ld 		(de),a
        inc 	hl
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ld 		a,(dspvallen)
.dsptxt7
		dec 	a
        jr 		z,dsptxt8
        ldi
        jr 		dsptxt7
.dsptxt8
		ex 		de,hl
        ld 		(hl),"e"
        inc 	hl
        ld 		a,(dspvallen)        ;exp display = -(exp + mantissa length - 1)
        ld 		c,a
        ld 		a,(dspvalexp)
        add 	c
        dec 	a
        ld 		(hl),"+"
        jp 		p,dsptxt9
        ld 		(hl),"-"
        neg
.dsptxt9
		inc 	hl
        ex 		de,hl
        call 	clcdez
        ex 		de,hl
        ld 		(hl),e
        inc 	hl
        ld 		(hl),d
        inc 	hl
        ld 		(hl),0
        ret
.dsptxta
		add 	b                   ;*** Comma negative (a,c=len, b=comma -> a=len-neg comma)
        jr 		c,dsptxtb
        neg                     ;a=-(len+exp) [=distance between comma and first digit]
        ld 		b,a
        add 	c                   ;a=new number of digits-1
        cp 		dspvaldig+1
        jr 		nc,dsptxt6           ;too large -> display with exponent
        call 	dsptxte
        ld 		a,"0"
.dsptxtg
		ld 		(de),a
        inc 	de
        djnz 	dsptxtg
        jr 		dsptxtd
.dsptxtb
		jr 		z,dsptxtc            ;*** Display negative comma without exponent
        ld 		b,a
        call 	dsptxt2
        jr 		dsptxtd
.dsptxtc
		call 	dsptxte
.dsptxtd
		ld 		a,(hl)
        ldi
        Or 		a
        jr 		nz,dsptxtd
        ret
.dsptxte
		ld 		a,"0"
        ld 		(de),a
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ret
.dsptxt5
		ld 		(de),a               ;adds a digit (in A) and inserts a point, if needed
        inc 	de
        dec 	b
        ret 	z
        dec 	c
        ret 	nz
        ld 		a,(dspchrflg)
        dec 	a
        ret 	nz
        ld 		a,(dspchrpoi)
        ld 		(de),a
        inc 	de
        ld 		c,3+1
        dec 	c
        ret
		


;LIBRARY SYB.FLOAT.ROUTINES		
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@         C P C   -   F l o a t i n g - P o i n t - R o u t i n e s          @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;--- RANDOM NUMBERS -----------------------------------------------------------
;### FLO_RANDOMIZE0 -> RND seek to 0
;### FLO_RANDOMIZE -> RND seek to (HL)
;### FLO_RND -> Gets next RND value
;### FLO_LAST_RND -> Gets current RND value

;--- OPERATIONS ---------------------------------------------------------------
;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### FLO_VGL -> Compares (HL) with (DE)

;--- FUNCTIONS ----------------------------------------------------------------
;### FLO_VZW -> Changes the sign of (HL)
;### FLO_SQR -> Extracts the root of (HL)
;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### FLO_POT_E -> (HL)=E^(HL)
;### FLO_SIN -> Calculates the sinus of (HL)
;### FLO_COS -> Calculates the cosinus of (HL)
;### FLO_TAN -> Calculates the tangent of (HL)
;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### FLO_10A -> (HL)=(HL)*10^A
;### FLO_SGN -> Tests the sign of (HL)

;--- MISCELLANEOUS ------------------------------------------------------------
;### FLO_PI -> Gets PI
;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### FLO_DEGRAD -> Set Deg/Rad

;--- CONVERSION ---------------------------------------------------------------
;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer

;--- DISPLAY-PREPARATION ------------------------------------------------------
;### FLO_PREPARE -> Prepares the display of a FLO value


;--- begin routines -----------------------------------------------------------

;### FLO_PI -> Gets PI
;### Input      (HL)=Destination
;### Output     (HL)=PI, CF=1
;### Unchanged  BC,HL,IX,IY
;.FLO_PI
 ;       ld de,FLO_CONST_PI
;        jr FLO_MOVE
.l2f7d
		ld		de,FLO_CONST_C
		jr		FLO_MOVE
.l2f87
		ex		de,hl
.l2f88
		ld hl,#b10e
		jr FLO_MOVE
.l2f8d
        ld de,#b104
.l2f90
        ex de,hl




;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### Input      (DE)=Source value, (HL)=Destination
;### Output     (HL)=Value, CF=1
;### Unchanged  BC,DE,HL,IX,IY,(DE)
.FLO_MOVE
        push hl
        push de
        push bc
        ex de,hl
        ld bc,#0005
        ldir
        pop bc
        pop de
        pop hl
        scf
        ret

;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### Input      HL=value, A[bit7]=sign, (DE)=destination
;### Output     HL=DE, (HL)=FLO value
;### Unchanged  BC,IX,IY
.FLO_KONV_HLA_TO_FLO
        push de
        push bc
        Or #7f
        ld b,a
        Xor a
        ld (de),a
        inc de
        ld (de),a
        inc de
        ld c,#90
        Or h
        jr nz,l2fbb
        ld c,a
        Or l
        jr z,l2fbf
        ld l,h
        ld c,#88
        jr l2fbb
.l2fb7
        dec c
        sla l
        adc a
.l2fbb
        jp p,l2fb7
        And b
.l2fbf
        ex de,hl
        ld (hl),e
        inc hl
        ld (hl),a
        inc hl
        ld (hl),c
        pop bc
        pop hl
        ret

;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### Input      (HL)=LW, A[bit7]=sign
;### Output     (HL)=FLO value
;### Unchanged  BC,DE,HL,IY
.FLO_KONV_LW_TO_FLO
        push bc
        ld bc,#a000
        call l2fd3
        pop bc
        ret
        ld b,#a8
.l2fd3
        push de
        call l379c
        pop de
        ret

;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### Input      (HL)=FLO value
;### Output     HL=abs((HL)), A[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  BC,DE,IY
.FLO_ROUND_FLO_TO_HLA
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr z,l2ffd
        add #90
        ret nc
        push de
        push bc
        add #10
        call l373d
        sla c
        adc hl,de
        jr z,l2ffa
        ld a,(ix+#03)
        Or a
.l2ff6
        ccf
        pop bc
        pop de
        ret
.l2ffa
        sbc a
        jr l2ff6
.l2ffd
        ld l,a
        ld h,a
        scf
        ret
;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_ROUND_FLO_TO_LW
        call FLO_FIX_FLO_TO_LW
        ret nc
        ret p
.l3006
        push hl
        ld a,c
.l3008
        inc (hl)
        jr nz,l3011
        inc hl
        dec a
        jr nz,l3008
        inc (hl)
        inc c
.l3011
        pop hl
        scf
        ret

;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_FIX_FLO_TO_LW
        push hl
        push de
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr nz,l3029
        ld b,#04
.l3021
        ld (hl),a
        inc hl
        djnz l3021
        ld c,#01
        jr l3051
.l3029
        add #a0
        jr nc,l3052
        push hl
        call l373d
        Xor a
        cp b
        adc a
        Or c
        ld c,l
        ld b,h
        pop hl
        ld (hl),c
        inc hl
        ld (hl),b
        inc hl
        ld (hl),e
        inc hl
        ld e,a
        ld a,(hl)
        ld (hl),d
        And #80
        ld b,a
        ld c,#04
        Xor a
.l3047
        Or (hl)
        jr nz,l304f
        dec hl
        dec c
        jr nz,l3047
        inc c
.l304f
        ld a,e
        Or a
.l3051
        scf
.l3052
        pop de
        pop hl
        ret

;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_INT_FLO_TO_LW
        call 	FLO_FIX_FLO_TO_LW
        ret 	nc
        ret 	z
        bit 	7,b
        ret 	z
        jr 		l3006

;### FLO_PREPARE -> Prepares the display of a FLO value
;### Input      (HL)=FLO value
;### Output     (HL)=LW normed mantissa
;###            B = sign of mantissa
;###            D = sign of exponent
;###            E = exponent/comma position
;###            C = number of significant mantissa bytes (NOT digits!)
;### Unchanged  HL
.FLO_PREPARE
        call FLO_SGN
        ld b,a
        jr z,l30b7
        call m,l3734
        push hl
        ld a,(ix+#04)
        sub #80
        ld e,a
        sbc a
        ld d,a
        ld l,e
        ld h,d
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,de
        add hl,hl
        add hl,de
        add hl,hl
        add hl,hl
        add hl,de
        ld a,h
        sub #09
        ld c,a
        pop hl
        push bc
        call nz,l30c8
.l3085
        ld de,FLO_CONST_A
        call l36e2
        jr nc,l3098
        ld de,FLO_CONST_D1
        call FLO_MULT
        pop de
        dec e
        push de
        jr l3085
.l3098
        ld de,FLO_CONST_B
        call l36e2
        jr c,l30ab
        ld de,FLO_CONST_D1
        call FLO_DIV
        pop de
        inc e
        push de
        jr l3098
.l30ab
        call FLO_ROUND_FLO_TO_LW
        ld a,c
        pop de
.l30b0
        ld b,d
        dec a
        add l
        ld l,a
        ret nc
        inc h
        ret
.l30b7
        ld e,a
        ld (hl),a
        ld c,#01
        ret

;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer
;### Input      HL=16 bit integer, B[bit7]=sign
;### Output     HL=signed 16 bit integer
;###            CF=0 Overflow
;### Unchanged  BC,DE,IX,IY
.FLO_KONV_HLB_TO_INT
        ld a,h
        Or a
        jp m,ldd42
        Or b
        jp m,ldded
        scf
        ret
.ldd42
        Xor #80
        Or l
        ret nz
        ld a,b
        scf
        adc a
        ret
.ldded
        Xor a
        sub l
        ld l,a
        sbc h
        sub l
        cp h
        ld h,a
        scf
        ret nz
        cp #01
        ret

;### FLO_10A -> (HL)=(HL)*10^A
;### Input      (HL)=value, A=potence
;### Output     (HL)=(HL)*10^A
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_10A
        cpl
        inc a
.l30c8
        Or a
        scf
        ret z
        ld c,a
        jp p,l30d1
        cpl
        inc a
.l30d1
        ld de,FLO_CONST_D2
        sub #0d
        jr z,l30ed
        jr c,l30e3
        push bc
        push af
        call l30ed
        pop af
        pop bc
        jr l30d1
.l30e3
        ld b,a
        add a
        add a
        add b
        add e
        ld e,a
        ld a,#ff
        adc d
        ld d,a
.l30ed
        ld a,c
        Or a
        jp p,FLO_DIV
        jp FLO_MULT

;### FLO_RANDOMIZE0 -> RND seek to 0
;### Unchanged  AF,BC,DE,IX,IY
.FLO_RANDOMIZE0
        ld hl,#8965
        ld (FLO_VALUE_RND+2),hl
        ld hl,#6c07
        ld (FLO_VALUE_RND),hl
        ret

;### FLO_RANDOMIZE -> RND seek to (HL)
;### Input      (HL)=value
;### Unchanged  C,IY,FLO(HL)
.FLO_RANDOMIZE
        ex de,hl
        call FLO_RANDOMIZE0
        ex de,hl
        call FLO_SGN
        ret z
        ld de,FLO_VALUE_RND
        ld b,#04
.l3151
        ld a,(de)
        Xor (hl)
        ld (de),a
        inc de
        inc hl
        djnz l3151
        ret

;### FLO_RND -> Gets next RND value
;### Input      (HL)=Destination
;### Output     (HL)=new RND
;### Unchanged  HL,IY
.FLO_RND
        push hl
        ld hl,(FLO_VALUE_RND+2)
        ld bc,#6c07
        call l319c
        push hl
        ld hl,(FLO_VALUE_RND)
        ld bc,#8965
        call l319c
        push de
        push hl
        ld hl,(FLO_VALUE_RND+2)
        call l319c
        ex (sp),hl
        add hl,bc
        ld (FLO_VALUE_RND),hl
        pop hl
        ld bc,#6c07
        adc hl,bc
        pop bc
        add hl,bc
        pop bc
        add hl,bc
        ld (FLO_VALUE_RND+2),hl
        pop hl

;### FLO_LAST_RND -> Gets current RND value
;### Input      (HL)=Destination
;### Output     (HL)=current RND
;### Unchanged  HL,IY
.FLO_LAST_RND
        push hl
        pop ix
        ld hl,(FLO_VALUE_RND)
        ld de,(FLO_VALUE_RND+2)
        ld bc,#0000
        ld (ix+#04),#80
        jp l37ac
.l319c
        ex de,hl
        ld hl,#0000
        ld a,#11
.l31a2
        dec a
        ret z
        add hl,hl
        rl e
        rl d
        jr nc,l31a2
        add hl,bc
        jr nc,l31a2
        inc de
        jr l31a2

;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG10((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_DEC
        ld de,FLO_CONST_LOGDEC
        jr l31b9

;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_NAT
        ld de,FLO_CONST_LOGNAT
.l31b9
        call FLO_SGN
        dec a
        cp #01
        ret nc
        push de
        call l36d3
        push af
        ld (ix+#04),#80
        ld de,FLO_CONST_LOG
        call FLO_VGL
        jr nc,l31d7
        inc (ix+#04)
        pop af
        dec a
        push af
.l31d7
        call l2f87
        push de
        ld de,FLO_CONST_C
        push de
        call FLO_ADD
        pop de
        ex (sp),hl
        call FLO_SUB
        pop de
        call FLO_DIV
        call l3440
        db #04
        db #4c,#4b,#57,#5e,#7f
        db #0d,#08,#9b,#13,#80
        db #23,#93,#38,#76,#80
        db #20,#3b,#aa,#38,#82

.l3203
        push de
        call FLO_MULT
        pop de
        ex (sp),hl
        ld a,h
        Or a
        jp p,l3210
        cpl
        inc a
.l3210
        ld l,a
        ld a,h
        ld h,#00
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_ADD
        pop de
        jp FLO_MULT

;### FLO_POT_E -> (HL)=E^(HL)
;### Input      (HL)=value
;### Output     (HL)=E^(HL)
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_POT_E
        ld b,#e1
        call l3492
        jp nc,l2f7d
        ld de,FLO_CONST_POTE2
        call FLO_VGL
        jp p,l37e8
        ld de,FLO_CONST_POTE3
        call FLO_VGL
        jp m,l37e2
        ld de,FLO_CONST_POTE1
        call l3469
        ld a,e
        jp p,l3255
        neg
.l3255
        push af
        call l3570
        call l2f8d
        push de
        call l3443
        db #03
        db #f4,#32,#eb,#0f,#73
        db #08,#b8,#d5,#52,#7b
.FLO_CONST_HALF                     ;=1/2
        db #00,#00,#00,#00,#80

.l3270
        ex (sp),hl
        call l3443
        db #02
        db #09,#60,#de,#01,#78
        db #f8,#17,#72,#31,#7e

.l327f
        call FLO_MULT
        pop de
        push hl
        ex de,hl
        call FLO_SUB
        ex de,hl
        pop hl
        call FLO_DIV
        ld de,FLO_CONST_HALF
        call FLO_ADD
        pop af
        scf
        adc (ix+#04)
        ld (ix+#04),a
        scf
        ret

;### FLO_SQR -> Extracts the root of (HL)
;### Input      (HL)=value
;### Output     (HL)=sqr(HL)
;###            CF=0 error, negative value
;### Unchanged  HL
.FLO_SQR
        ld de,FLO_CONST_HALF

;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)^(DE)
;###            CF=0 Error [S=1 invalid parameter -X^(z/n), P=1 Overflow]
;### Unchanged  HL,FLO(DE)
.FLO_POT
        ex de,hl
        call FLO_SGN
        ex de,hl
        jp z,l2f7d
        push af
        call FLO_SGN
        jr z,l32e2
        ld b,a
        call m,l3734
        push hl
        call l3324
        pop hl
        jr c,l32ed
        ex (sp),hl
        pop hl
        jp m,l32ea
        push bc
        push de
        call FLO_LOG_NAT
        pop de
        call c,FLO_MULT
        call c,FLO_POT_E
.l32d9
        pop bc
        ret nc
        ld a,b
        Or a
        call m,FLO_VZW
        scf
        ret
.l32e2
        pop af
        scf
        ret p
        call l37e8
        Xor a
        ret
.l32ea
        Xor a
        inc a
        ret
.l32ed
        ld c,a
        pop af
        push bc
        push af
        ld a,c
        scf
.l32f3
        adc a
        jr nc,l32f3
        ld b,a
        call l2f8d
        ex de,hl
        ld a,b
.l32fc
        add a
        jr z,l3314
        push af
        call l3570
        jr nc,l331b
        pop af
        jr nc,l32fc
        push af
        ld de,#b104
        call FLO_MULT
        jr nc,l331b
        pop af
        jr l32fc
.l3314
        pop af
        scf
        call m,l35fb
        jr l32d9
.l331b
        pop af
        pop af
        pop bc
        jp m,l37e2
        jp l37ea
.l3324
        push bc
        call l2f88
        call FLO_FIX_FLO_TO_LW
        ld a,c
        pop bc
        jr nc,l3331
        jr z,l3334
.l3331
        ld a,b
        Or a
        ret
.l3334
        ld c,a
        ld a,(hl)
        rra
        sbc a
        And b
        ld b,a
        ld a,c
        cp #02
        sbc a
        ret nc
        ld a,(hl)
        cp #27
        ret c
        Xor a
        ret


		
;### FLO_DEGRAD -> Set Deg/Rad
;### Input      A=Typ (=0 -> Rad, >0 -> Deg)
;### Unchanged  AF,BC,DE,HL,IX,IY
.FLO_DEGRAD    
        ld (FLO_VALUE_DEGRAD),a
        ret

;### FLO_COS -> Calculates the cosinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=cos(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_COS
        call FLO_SGN
        call m,l3734
        Or #01
        jr l3354

;### FLO_SIN -> Calculates the sinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=sin(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_SIN
        Xor a
.l3354
        push af
        ld de,FLO_CONST_SINA
        ld b,#f0
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        jr z,l3365
        ld de,FLO_CONST_SINB
        ld b,#f6
.l3365
        call l3492
        jr nc,l33a4
        pop af
        call l346a
        ret nc
        ld a,e
        rra
        call c,l3734
        ld b,#e8
        call l3492
        jp nc,l37e2
        inc (ix+#04)
        call l3440
        db #06
        db #1b,#2d,#1a,#e6,#6e
        db #f8,#fb,#07,#28,#74
        db #01,#89,#68,#99,#79
        db #e1,#df,#35,#23,#7d
        db #28,#e7,#5d,#a5,#80
.FLO_CONST_F
        db #a2,#da,#0f,#49,#81

.l33a1
        jp FLO_MULT
.l33a4
        pop af
        jp nz,l2f7d
        ld a,(FLO_VALUE_DEGRAD)
        cp #01
        ret c
        ld de,FLO_CONST_SINC
        jp FLO_MULT		
		



;### FLO_TAN -> Calculates the tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=tan(HL)
;###            CF=0 error [Z=1 division by zero, S=1 value too big]
;### Unchanged  HL
.FLO_TAN
        call l2f8d
        push de
        call FLO_COS
        ex (sp),hl
        call c,FLO_SIN
        pop de
        jp c,FLO_DIV
        ret

;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=atn(HL)
;### Unchanged  HL
.FLO_ARC_TAN
        call FLO_SGN
        push af
        call m,l3734
        ld b,#f0
        call l3492
        jr nc,l3430
        dec a
        push af
        call p,l35fb
        call l3440
        db #0b
        db #ff,#c1,#03,#0f,#77
        db #83,#fc,#e8,#eb,#79
        db #6f,#ca,#78,#36,#7b
        db #d5,#3e,#b0,#b5,#7c
        db #b0,#c1,#8b,#09,#7d
        db #af,#e8,#32,#b4,#7d
        db #74,#6c,#65,#62,#7d
        db #d1,#f5,#37,#92,#7e
        db #7a,#c3,#cb,#4c,#7e
        db #83,#a7,#aa,#aa,#7f
        db #fe,#ff,#ff,#7f,#80

.l3426
        call FLO_MULT
        pop af
        ld de,FLO_CONST_F
        call p,FLO_SUBX
.l3430
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        ld de,FLO_CONST_TAN
        call nz,FLO_MULT
        pop af
        call m,l3734
        scf
        ret
.l3440
        call l3570
.l3443
        call l2f87
        pop hl
        ld b,(hl)
        inc hl
        call l2f90
.l344c
        inc de
        inc de
        inc de
        inc de
        inc de
        push de
        ld de,#b109
        dec b
        ret z
        push bc
        ld de,#b10e
        call FLO_MULT
        pop bc
        pop de
        push de
        push bc
        call FLO_ADD
        pop bc
        pop de
        jr l344c
.l3469
        Xor a
.l346a
        push af
        call FLO_MULT
        pop af
        ld de,FLO_CONST_HALF
        call nz,FLO_ADD
        push hl
        call FLO_ROUND_FLO_TO_HLA
        jr nc,l348e
        pop de
        push hl
        push af
        push de
        ld de,#b109
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_SUB
        pop af
        pop de
        scf
        ret
.l348e
        pop hl
        Xor a
        inc a
        ret
.l3492
        call l36d3
        ret p
        cp b
        ret z
        ccf
        ret

;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)-(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUB
        ld a,#01
        jr l34a3

;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### Input      (DE)=first value, (HL)=second value
;### Output     (HL)=(DE)-(HL)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUBX
        ld a,#80
        jr l34a3

;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)+(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_ADD
        Xor a
.l34a3
        push hl
        pop ix
        push de
        pop iy
        ld b,(ix+#03)
        ld c,(iy+#03)
        Or a
        jr z,l34bc
        jp m,l34ba
        rrca
        Xor c
        ld c,a
        jr l34bc
.l34ba
        Xor b
        ld b,a
.l34bc
        ld a,(ix+#04)
        cp (iy+#04)
        jr nc,l34d8
        ld d,b
        ld b,c
        ld c,d
        Or a
        ld d,a
        ld a,(iy+#04)
        ld (ix+#04),a
        jr z,l3525
        sub d
        cp #21
        jr nc,l3525
        jr l34e9
.l34d8
        Xor a
        sub (iy+#04)
        jr z,l3537
        add (ix+#04)
        cp #21
        jr nc,l3537
        push hl
        pop iy
        ex de,hl
.l34e9
        ld e,a
        ld a,b
        Xor c
        push af
        push bc
        ld a,e
        call l3743
        ld a,c
        pop bc
        ld c,a
        pop af
        jp m,l353c
        ld a,(iy+#00)
        add l
        ld l,a
        ld a,(iy+#01)
        adc h
        ld h,a
        ld a,(iy+#02)
        adc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        adc d
        ld d,a
        jp nc,l37b7
        rr d
        rr e
        rr h
        rr l
        rr c
        inc (ix+#04)
        jp nz,l37b7
        jp l37ea
.l3525
        ld a,(iy+#02)
        ld (ix+#02),a
        ld a,(iy+#01)
        ld (ix+#01),a
        ld a,(iy+#00)
        ld (ix+#00),a
.l3537
        ld (ix+#03),b
        scf
        ret
.l353c
        Xor a
        sub c
        ld c,a
        ld a,(iy+#00)
        sbc l
        ld l,a
        ld a,(iy+#01)
        sbc h
        ld h,a
        ld a,(iy+#02)
        sbc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        sbc d
        ld d,a
        jr nc,l356d
        ld a,b
        cpl
        ld b,a
        Xor a
        sub c
        ld c,a
        ld a,#00
        sbc l
        ld l,a
        ld a,#00
        sbc h
        ld h,a
        ld a,#00
        sbc e
        ld e,a
        ld a,#00
        sbc d
        ld d,a
.l356d
        jp l37ac
.l3570
        ld de,#b109
        call l2f90
        ex de,hl

;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)*(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_MULT
        push de
        pop iy
        push hl
        pop ix
        ld a,(iy+#04)
        Or a
        jr z,l35ad
        dec a
        call l36af
        jr z,l35ad
        jr nc,l35aa
        push af
        push bc
        call l35b0
        ld a,c
        pop bc
        ld c,a
        pop af
        bit 7,d
        jr nz,l35a3
        dec a
        jr z,l35ad
        sla c
        adc hl,hl
        rl e
        rl d
.l35a3
        ld (ix+#04),a
        Or a
        jp nz,l37b7
.l35aa
        jp l37ea
.l35ad
        jp l37e2
.l35b0
        ld hl,#0000
        ld e,l
        ld d,h
        ld a,(iy+#00)
        call l35f3
        ld a,(iy+#01)
        call l35f3
        ld a,(iy+#02)
        call l35f3
        ld a,(iy+#03)
        Or #80
.l35cc
        ld b,#08
        rra
        ld c,a
.l35d0
        jr nc,l35e6
        ld a,l
        add (ix+#00)
        ld l,a
        ld a,h
        adc (ix+#01)
        ld h,a
        ld a,e
        adc (ix+#02)
        ld e,a
        ld a,d
        adc (ix+#03)
        ld d,a
.l35e6
        rr d
        rr e
        rr h
        rr l
        rr c
        djnz l35d0
        ret
.l35f3
        Or a
        jr nz,l35cc
        ld l,h
        ld h,e
        ld e,d
        ld d,a
        ret
.l35fb
        call l2f87
        ex de,hl
        push de
        call l2f7d
        pop de

;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)/(DE)
;###            CF=0 Overflow (and ZF=1 -> division by zero)
;### Unchanged  HL,FLO(DE)
.FLO_DIV
        push de
        pop iy
        push hl
        pop ix
        Xor a
        sub (iy+#04)
        jr z,l366a
        call l36af
        jp z,l37e2
        jr nc,l3667
        push bc
        ld c,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
        ld b,(iy+#03)
        set 7,b
        call l369d
        jr c,l3633
        ld a,c
        Or a
        jr nz,l3639
        jr l3666
.l3633
        dec c
        add hl,hl
        rl e
        rl d
.l3639
        ld (ix+#04),c
        call l3672
        ld (ix+#03),c
        call l3672
        ld (ix+#02),c
        call l3672
        ld (ix+#01),c
        call l3672
        ccf
        call c,l369d
        ccf
        sbc a
        ld l,c
        ld h,(ix+#01)
        ld e,(ix+#02)
        ld d,(ix+#03)
        pop bc
        ld c,a
        jp l37b7
.l3666
        pop bc
.l3667
        jp l37ea
.l366a
        ld b,(ix+#03)
        call l37ea
        Xor a
        ret
.l3672
        ld c,#01
.l3674
        jr c,l367e
        ld a,d
        cp b
.l3678
        call z,l36a0
        ccf
        jr nc,l3691
.l367e
        ld a,l
        sub (iy+#00)
        ld l,a
        ld a,h
        sbc (iy+#01)
        ld h,a
        ld a,e
        sbc (iy+#02)
        ld e,a
        ld a,d
        sbc b
        ld d,a
        scf
.l3691
        rl c
        sbc a
        add hl,hl
        rl e
        rl d
        inc a
        jr nz,l3674
        ret
.l369d
        ld a,d
        cp b
        ret nz
.l36a0
        ld a,e
        cp (iy+#02)
        ret nz
        ld a,h
        cp (iy+#01)
        ret nz
        ld a,l
        cp (iy+#00)
        ret
.l36af
        ld c,a
        ld a,(ix+#03)
        Xor (iy+#03)
        ld b,a
        ld a,(ix+#04)
        Or a
        ret z
        add c
        ld c,a
        rra
        Xor c
        ld a,c
        jp p,l36cf
        set 7,(ix+#03)
        sub #7f
        scf
        ret nz
        cp #01
        ret
.l36cf
        Or a
        ret m
        Xor a
        ret
.l36d3
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        sub #80
        scf
        ret

;### FLO_VGL -> Compares (HL) with (DE)
;### Input      (HL)=first value, (DE)=second value
;### Output     A=Result [-1 -> (HL)<(DE), 0 -> (HL)=(DE), 1 -> (HL)>(DE)]
;###            ZF=1 -> (HL)=(DE), CF=1 -> (HL)<(DE)
;### Unchanged  BC,DE,HL,FLO(HL),FLO(DE)
.FLO_VGL
        push hl
        pop ix
.l36e2
        push de
        pop iy
        ld a,(ix+#04)
        cp (iy+#04)
        jr c,l3719
        jr nz,l3722
        Or a
        ret z
        ld a,(ix+#03)
        Xor (iy+#03)
        jp m,l3722
        ld a,(ix+#03)
        sub (iy+#03)
        jr nz,l3719
        ld a,(ix+#02)
        sub (iy+#02)
        jr nz,l3719
        ld a,(ix+#01)
        sub (iy+#01)
        jr nz,l3719
        ld a,(ix+#00)
        sub (iy+#00)
        ret z
.l3719
        sbc a
        Xor (iy+#03)
.l371d
        add a
        sbc a
        ret c
        inc a
        ret
.l3722
        ld a,(ix+#03)
        jr l371d

;### FLO_SGN -> Tests the sign of (HL)
;### Input      (HL)=value
;### Output     A=sign [-1 -> (HL)<0, 0 -> (HL)=0, 1 -> (HL)>0]
;###            ZF=1 -> (HL)=0, CF=1 -> (HL)<0
;### Unchanged  BC,DE,HL,IY,FLO(HL)
.FLO_SGN
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        jr l3722

;### FLO_VZW -> Changes the sign of (HL)
;### Input      (HL)=value
;### Output     (HL)=-(HL)
;### Unchanged  BC,DE,HL,IY
.FLO_VZW
        push hl
        pop ix
.l3734
        ld a,(ix+#03)
        Xor #80
        ld (ix+#03),a
        ret
.l373d
        cp #21
        jr c,l3743
        ld a,#21
.l3743
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld h,(hl)
        ld l,c
        ex de,hl
        set 7,d
        ld bc,#0000
        jr l375e
.l3753
        ld c,a
        ld a,b
        Or l
        ld b,a
        ld a,c
        ld c,l
        ld l,h
        ld h,e
        ld e,d
        ld d,#00
.l375e
        sub #08
        jr nc,l3753
        add #08
        ret z
.l3765
        srl d
        rr e
        rr h
        rr l
        rr c
        dec a
        jr nz,l3765
        ret
.l3773
        jr nz,l378c
        ld d,a
        ld a,e
        Or h
        Or l
        Or c
        ret z
        ld a,d
.l377c
        sub #08
        jr c,l379a
        ret z
        ld d,e
        ld e,h
        ld h,l
        ld l,c
        ld c,#00
        inc d
        dec d
        jr z,l377c
        ret m
.l378c
        dec a
        ret z
        sla c
        adc hl,hl
        rl e
        rl d
        jp p,l378c
        ret
.l379a
        Xor a
        ret
.l379c
        push hl
        pop ix
        ld (ix+#04),b
        ld b,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
.l37ac
        ld a,(ix+#04)
        dec d
        inc d
        call p,l3773
        ld (ix+#04),a
.l37b7
        sla c
        jr nc,l37cd
        inc l
        jr nz,l37cd
        inc h
        jr nz,l37cd
        inc de
        ld a,d
        Or e
        jr nz,l37cd
        inc (ix+#04)
        jr z,l37ea
        ld d,#80
.l37cd
        ld a,b
        Or #7f
        And d
        ld (ix+#03),a
        ld (ix+#02),e
        ld (ix+#01),h
        ld (ix+#00),l
.l37dd
        push ix
        pop hl
        scf
        ret
.l37e2
        Xor a
        ld (ix+#04),a
        jr l37dd
.l37e8
        ld b,#00
.l37ea
        push ix
        pop hl
        ld a,b
        Or #7f
        ld (ix+#03),a
        Or #ff
        ld (ix+#04),a
        ld (hl),a
        ld (ix+#01),a
        ld (ix+#02),a
        ret

;--- begin variables ----------------------------------------------------------

FLO_VALUE_DEGRAD    db 0
FLO_VALUE_RND       ds 4

;--- begin constants ----------------------------------------------------------

.Pi:
.Symbasic_FLO_CONST_PI		                    ;=PI
        db #a2,#da,#0f,#49,#82,0				;**** Padded out with a Zero

.FLO_CONST_LOG
        db #34,#f3,#04,#35,#80
.FLO_CONST_LOGNAT
        db #f8,#17,#72,#31,#80
.FLO_CONST_LOGDEC
        db #85,#9a,#20,#1a,#7f

.FLO_CONST_POTE1
        db #29,#3b,#aa,#38,#81
.FLO_CONST_POTE2
        db #c7,#33,#0f,#30,#87
.FLO_CONST_POTE3
        db #f8,#17,#72,#b1,#87

.FLO_CONST_SINA
        db #6e,#83,#f9,#22,#7f
.FLO_CONST_SINB
        db #b6,#60,#0b,#36,#79
.FLO_CONST_SINC
        db #13,#35,#fa,#0e,#7b
.FLO_CONST_TAN
        db #d3,#e0,#2e,#65,#86

.FLO_CONST_A
        db #f0,#1f,#bc,#3e,#96
.FLO_CONST_B
        db #fe,#27,#6b,#6e,#9e
.FLO_CONST_C
        db #00,#00,#00,#00,#81

.FLO_CONST_D1
        db #00,#00,#00,#20,#84
        db #00,#00,#00,#48,#87
        db #00,#00,#00,#7a,#8a
        db #00,#00,#40,#1c,#8e
        db #00,#00,#50,#43,#91
        db #00,#00,#24,#74,#94
        db #00,#80,#96,#18,#98
        db #00,#20,#bc,#3e,#9b
        db #00,#28,#6b,#6e,#9e
        db #00,#f9,#02,#15,#a2
        db #40,#b7,#43,#3a,#a5
        db #10,#a5,#d4,#68,#a8
.FLO_CONST_D2
        db #2a,#e7,#84,#11,#ac
					
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@              S Y M S T U D I O   S Y S T E M   L I B R A R Y               @
;@                     - SYMBOS FILE MANAGER FUNCTIONS -                      @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;Author: Prodatron / Symbiosis
;Date:   30.04.2006

;This library supports you in using the file manager functions.
;Instead of including the following routines in your application code you may
;use the "SySystem_CallFunction" routine directly, so that you would save some
;overhead. In this case you can see this library just as an example, how to
;access the file manager.
;The existance of "AppPrzN" (a byte, where the ID of the applications process
;is stored) and "AppMsgB" (the message buffer, 14 bytes, which are placed in
;the transfer ram area) is required.


;LIBRARY SYFILE.FILNEW
;******************************************************************************
;*** Name           File_New
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Attributes
;***                       Bit0 = 1 -> Read only
;***                       Bit1 = 1 -> Hidden
;***                       Bit2 = 1 -> System
;***                       Bit5 = 1 -> Archive
;*** Output         A    = Filehandler ID
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Creates a new file and opens it for read/write access. If the
;***                file was already existing, it will be emptied first. For
;***                additional information see 018 (FILOPN).
;******************************************************************************
.SyFile_FILNEW
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILNEW
        ret
;LIBRARY SYFILE.FILOPN
;******************************************************************************
;*** Name           File_Open
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;*** Output         A    = Filehandler ID
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Opens an existing file for read/write access. This means, that
;***                you can read and write in the file like you want. You can open
;***                up to 8 different files at the same time.
;***                For more information about the file path see the introduction
;***                of the DIRECTORY MANAGEMENT FUNCTIONS.
;***                The media will be reloaded first, if the device is set to
;***                "removeable media" and there is no other open file on the same
;***                device.
;******************************************************************************
.SyFile_FILOPN
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILOPN
        ret
;LIBRARY SYFILE.FILCLO
;******************************************************************************
;*** Name           File_Close
;*** Input          A    = Filehandler ID
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Closes an opened file. If there is unwritten data in the sector
;***                cache, it will be written to disc at once.
;***                This command closes a file in any case, even if an error
;***                occured.
;***                If an error occured during file reading/writing you must close
;***                the file, too, to have the filehandler free again!
;******************************************************************************
.SyFile_FILCLO
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILCLO
        ret
;LIBRARY SYFILE.FILINP
;******************************************************************************
;*** Name           File_Input
;*** Input          A    = Filehandler ID
;***                HL   = Destination address
;***                E    = Destination ram bank (0-8)
;***                BC   = Number of bytes
;*** Output         BC   = Number of read bytes
;***                ZF   = 1 -> All requested bytes have been read
;***                       0 -> The end of the file has been reached, and less
;***                            bytes than requested have been read (check BC)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Reads a specified amount of bytes out of an opened file. After
;***                this operation the file pointer will be moved behind the last
;***                read byte. This means, that it is possible to read several
;***                blocks with different sizes out of an opened file. It doesn't
;***                matter, if you already did write operations, too.
;***                If you try to read more bytes than available, the zero flag
;***                will be reset. In any case BC contains the amount of read
;***                bytes.
;******************************************************************************
.SyFile_FILINP
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILINP
        ret
;LIBRARY SYFILE_FILOUT
;******************************************************************************
;*** Name           File_Output
;*** Input          A    = Filehandler ID
;***                HL   = Source address
;***                E    = Source ram bank (0-8)
;***                BC   = Number of bytes
;*** Output         BC   = Number of written bytes
;***                A    = 0 -> All bytes have been written
;***                       1 -> The device is full, and less bytes have been
;***                            written (check BC)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Writes a specified amount of bytes into an opened file. After
;***                this operation the file pointer will be moved behind the last
;***                written byte. If the file pointer has been somewhere in the
;***                middle of the file before this operation, the data at this
;***                place will be overwritten. If you have been at the end of the
;***                file, its length will be extended.
;***                You can write several blocks with different sizes, and it
;***                doesn't matter if you already read from the file before.
;***                It's possible, that not all bytes have been written, if the
;***                device is full. Register A will be 1 in this case. In any case
;***                BC contains the amount of written bytes.
;******************************************************************************
.SyFile_FILOUT
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILOUT
        ret
;LIBRARY SYFILE.FILPOI
;******************************************************************************
;*** Name           File_Pointer
;*** Input          A    = Filehandler ID
;***                IY,IX= Difference
;***                C    = Reference point
;***                       0 = File begin
;***                       1 = Actual pointer position
;***                       2 = File end
;*** Output         IY,IX= new absolute pointer position
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL
;*** Description    Moves the file pointer to another position. The difference is
;***                specified with IY and IX, IY is the high word, IX the low word
;***                (difference = 65536 * IY + IX).
;***                You can also use this function to find out the length of an
;***                opened file. Just set IY,IX to 0 and choose 2 as the reference
;***                point type. The pointer will be placed behind the last byte of
;***                the file, so you will get its length in IY,IX.
;*** Examples       IY = 0,     IX = 1,   C = 1 -> Increases the position by 1
;***                IY = 65535, IX = -10, C = 2 -> Sets the pointer before the last
;***                                               10 bytes of the file
;******************************************************************************
.SyFile_FILPOI
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILPOI
        ret
;LIBRARY SYFILE.FILF2T
;******************************************************************************
;*** Name           File_Decode_Timestamp
;*** Input          BC   = Time code
;***                       bit  0- 4 = second/2
;***                       bit  5-10 = minute
;***                       bit 11-15 = hour
;***                DE   = Date code
;***                       bit  0- 4 = day (starting from 1)
;***                       bit  5- 8 = month (starting from 1)
;***                       bit  9-15 = year-1980
;*** Output         A    = second
;***                B    = minute
;***                C    = hour
;***                D    = day (starting from 1)
;***                E    = month (starting from 1)
;***                HL   = year
;*** Destroyed      F
;*** Description    Decodes the file timestamp, which is used for the file system.
;***                You can use this function after reading the timestamp of a
;***                file with 035 (DIRPRR) or 038 (DIRINP).
;******************************************************************************
.SyFile_FILF2T
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILF2T
        ret
;LIBRARY SYFILE.FILT2F
;******************************************************************************
;*** Name           File_Encode_Timestamp
;*** Input          A    = second
;***                B    = minute
;***                C    = hour
;***                D    = day (starting from 1)
;***                E    = month (starting from 1)
;***                HL   = year
;*** Output         BC   = Time code (see FILF2T)
;***                DE   = Date code (see FILF2T)
;*** Destroyed      AF,HL,IX,IY
;*** Description    Encodes the file timestamp, which is used for the file system.
;***                You can use this function before changing the timestamp of a
;***                file with 034 (DIRPRS).
;******************************************************************************
.SyFile_FILT2F
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILT2F
        ret
;LIBRARY SYFILE.FILLIN
;******************************************************************************
;*** Name           File_LineInput
;*** Input          A    = Filehandler ID
;***                HL   = Destination buffer address (size must be 255 bytes)
;***                E    = Destination buffer ram bank (0-8)
;*** Output         BC   = Number of read bytes (without terminator)
;***                ZF   = 0 -> 1 or more bytes have been loaded
;***                       1 -> EOF reached, nothing has been loaded
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Reads one text line out of an opened file. A text line is
;***                terminated by a single 13, a single 10, a combination of 13+10,
;***                a combination of 10+13 or by a single 26 ("end of file" code).
;***                The line terminator will not be copied to the destination line
;***                buffer, but a 0 will be added behind the last char of the line.
;***                This function allows you to read a text file line by line at a
;***                very high speed, because you don't need to read single chars
;***                and check for line feeds by yourself.
;******************************************************************************
.SyFile_FILLIN
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILLIN
        ret
;LIBRARY SYFILE.DIRDEV
;******************************************************************************
;*** Name           Directory_Device
;*** Input          A    = Driveletter ("A"-"Z")
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Selects the actual drive.
;***                As your application is running in a multitasking environment,
;***                unfortunately this command does not make many sense, as other
;***                applications could select an other drive again.
;******************************************************************************
.SyFile_DIRDEV
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRDEV
        ret
;LIBRARY SYFILE.DIRPTH
;******************************************************************************
;*** Name           Directory_Path
;*** Input          IXH  = File path ram bank (0-8)
;***                HL   = File path address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Selects the actual path for the actual or a different drive.
;***                As your application is running in a multitasking environment,
;***                unfortunately this command does not make many sense, as other
;***                applications could select an other path again.
;******************************************************************************
.SyFile_DIRPTH
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPTH
        ret
;LIBRARY SYFILE.DIRPRS
;******************************************************************************
;*** Name           Directory_Property_Set
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Property type
;***                       0 = Attribute          -> C  = attribute
;***                                                      Bit0 = 1 -> Read only
;***                                                      Bit1 = 1 -> Hidden
;***                                                      Bit2 = 1 -> System
;***                                                      Bit5 = 1 -> Archive
;***                       1 = Timestamp modified -> BC = time code, DE = date code
;***                       2 = Timestamp created  -> BC = time code, DE = date code
;***                BC,DE= see above
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Changes a property of a file or a directory. You can set the
;***                attribute, the "created" time and the "modified" time.
;***                For more information about the time and date code see 023
;***                (FILF2T).
;******************************************************************************
.SyFile_DIRPRS
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPRS
        ret
;LIBRARY SYFILE.DIRPRR
;******************************************************************************
;*** Name           Directory_Property_Get
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Property type
;***                       0 = Attribute
;***                       1 = Timestamp modified
;***                       2 = Timestamp created
;*** Output         C    = Attributes (if requested)
;***                       Bit0 = 1 -> Read only
;***                       Bit1 = 1 -> Hidden
;***                       Bit2 = 1 -> System
;***                       Bit3 = 1 -> Volume ID
;***                       Bit4 = 1 -> Directory
;***                       Bit5 = 1 -> Archive
;***                BC,DE= Time and date code (if requested)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,HL,IX,IY
;*** Description    Reads a property of a file or a directory.
;***                For more information about the time and date code see 023
;***                (FILF2T).
;******************************************************************************
.SyFile_DIRPRR
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPRR
        ret
;LIBRARY SYFILE.DIRREN
;******************************************************************************
;*** Name           Directory_Rename
;*** Input          IXH  = Ram bank (0-8) of old and new file name
;***                HL   = Address of file path and old file name
;***                DE   = Address of new file name
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Renames a file or a directory. The new file name must not
;***                include a path. The function will fail, if a file or directory
;***                with the new name already exists.
;******************************************************************************
.SyFile_DIRREN
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRREN
        ret
;LIBRARY SYFILE.DIRNEW
;******************************************************************************
;*** Name           Directory_New
;*** Input          IXH  = Directory path and name ram bank (0-8)
;***                HL   = Directory path and name address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Creates a new directory. The function will fail, if a file or
;***                directory with the same name already exists.
;******************************************************************************
.SyFile_DIRNEW
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRNEW
        ret
;LIBRARY SYFILE.DIRINP
;******************************************************************************
;*** Name           Directory_Input
;*** Input          IXH  = Directory path ram bank (0-8)
;***                HL   = Directory path address (may include a search mask)
;***                IXL  = forbidden attributes
;***                       Bit0 = 1 -> don't show read only files
;***                       Bit1 = 1 -> don't show hidden files
;***                       Bit2 = 1 -> don't show system files
;***                       Bit3 = 1 -> don't show volume ID entries
;***                       Bit4 = 1 -> don't show directories
;***                       Bit5 = 1 -> don't show archive files
;***                A    = Destination buffer ram bank (0-8)
;***                DE   = Destination buffer address
;***                BC   = Destination buffer length
;***                IY   = Number of entries, which should be skipped
;*** Output         HL   = Number of read entries
;***                BC   = Remaining unused space in the destination buffer
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,IX,IY
;*** Data structure 00  4B  File length (32bit double word)
;***                04  1W  Date code, see 023 (FILF2T)
;***                06  1W  Time code, see 023 (FILF2T)
;***                08  1B  Attributes, see 035 (DIRPRR)
;***                09  ?B  File or sub directory name
;***                ??  1B  0 terminator
;*** Description    Reads the content of a directory. You can specify a name filter
;***                filter by adding a file mask to the path (* and ? are allowed)
;***                and an attribute filter. We recommend always to set Bit3
;***                (volume ID) of the attribute filter byte.
;***                The system skips the specified amount of entries first and
;***                then loads as many entries as exist or as there is place in the
;***                destination buffer. Please note, that the entries will not be
;***                sorted. Depending on its name every entry in the destination
;***                buffer can have a different length and is terminated with 0
;***                behind the file name. Filenames don't contain spaces.
;******************************************************************************
.SyFile_DIRINP	
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRINP
        ret
;LIBRARY SYFILE.DIRDEL
;******************************************************************************
;*** Name           Directory_DeleteFile
;*** Input          IXH  = File path and name/mask ram bank (0-8)
;***                HL   = File path and name/mask address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Deletes one or more files. You can delete multiple files by
;***                using a file mask (* and ? are allowed).
;***                This function can't be used for deleting directories.
;******************************************************************************
.SyFile_DIRDEL
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRDEL
        ret
;LIBRARY SYFILE.DIRRMD
;******************************************************************************
;*** Name           Directory_DeleteDirectory
;*** Input          IXH  = Directory path and name ram bank (0-8)
;***                HL   = Directory path and name address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Deletes a sub directory. The sub directory has to be empty
;***                and not read only, otherwise the operation will be aborted.
;***                You can specify the directory with or without "/" at the
;***                end of the full path.
;******************************************************************************
.SyFile_DIRRMD
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRRMD
        ret
;LIBRARY SYFILE.DIRMOV
;******************************************************************************
;*** Name           Directory_Move
;*** Input          IXH  = File/directory old and new path ram bank (0-8)
;***                HL   = File/directory source path and name address
;***                DE   = File/directory destination path address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Moves a file or sub directory into another directory of the
;***                same drive. That means, that the drive letter of the source
;***                path must be the same like the drive letter of the
;***                destination path, otherwise the operation will be aborted.
;***                You can either move files or sub directories with this
;***                function, in both cases the source path+name must not end
;***                with a "/".
;******************************************************************************
.SyFile_DIRMOV
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRMOV
        ret
;LIBRARY SYFILE.DIRINF
;******************************************************************************
;*** Name           Directory_DriveInformation
;*** Input          A    = Driveletter ("A"-"Z")
;***                C    = Information type
;***                       0 = general drive information
;***                       1 = free and total amount of memory
;*** Output         - Information type 0:
;***                A    = Type
;***                       00 = Device does not exist
;***                       01 = Device is ready
;***                       02 = Device is not initialized
;***                       03 = Device is corrupt
;***                B    = Medium
;***                       01 = Floppy disc single side (Amsdos)
;***                       02 = Floppy disc double side (Fat 12)
;***                       08 = Ram disc
;***                       16 = IDE hard disc or CF card (Fat 16, Fat 32)
;***                C    = File system
;***                       01 = Amsdos Data
;***                       02 = Amsdos System
;***                       16 = Fat 12
;***                       17 = Fat 16
;***                       18 = Fat 32
;***                D    = Sectors per cluster
;***                IY,IX= Total number of clusters
;***                - Information type 1:
;***                HL,DE= Number of free 512Byte sectors
;***                IY,IX= Total number of clusters
;***                C    = Sectors per cluster
;***                - Information type 0 and 1:
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F
;*** Description    Returns information about one drive. This function can be
;***                used to find out the amount of free memory on one drive.
;***                Please note, that calculating the free amount of memory on
;***                a FAT16 device may take a while, as everytime the whole FAT
;***                (up to 128KB) needs to be scanned.
;******************************************************************************
.SyFile_DIRINF
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRINF
        ret
;LIBRARY SYFILE.DEVDIR
;******************************************************************************
;*** Name           Directory_Input_Extended
;*** Input          A    = [bit0-3] Destination buffer ram bank (0-8)
;***                       [bit4-7] Directory path ram bank (0-8)
;***                HL   = Directory path address (may include a search mask)
;***                DE   = Destination buffer address. This must first contain two
;***                       words with additional information at the beginning:
;***                       00  1W  Address of list control table
;***                       02  1W  Maximum number of entries
;***                       This function will overwrite this information and fill
;***                       the buffer with the directory data.
;***                BC   = Maximum size of destination buffer
;***                IXL  = forbidden attributes
;***                       Bit0 = 1 -> don't show read only files
;***                       Bit1 = 1 -> don't show hidden files
;***                       Bit2 = 1 -> don't show system files
;***                       Bit3 = 1 -> don't show volume ID entries
;***                       Bit4 = 1 -> don't show directories
;***                       Bit5 = 1 -> don't show archive files
;***                IY   = Number of entries, which should be skipped
;***                IXH  = Additional columns
;***                       Bit0 = 1 -> File size
;***                       Bit1 = 1 -> Date and time (last modified)
;***                       Bit2 = 1 -> Attributes
;*** Output         HL   = Number of read entries
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,IX,IY
;*** Description    This is a very powerful extension of the directory input
;***                (DIRINP) function. It reads the content of a directory and
;***                converts it into ready to use list control data. So if your
;***                application wants to display the content of a directory inside
;***                a list control, it can use this function and doesn't need to do
;***                any conversion jobs by itself. Also the list control itself can
;***                do the sorting of the directory.
;***                First you have to reserve two memory areas in the same ram
;***                bank. One area needs to be reserved inside the data ram area.
;***                It will contain the texts (file names, dates etc.) and numbers
;***                (file sizes) for the list control. You can choose any size, but
;***                we recommend at least 4000 Bytes. BC must contain its size,
;***                when you call the function. DE contains the address, and the
;***                low nibble of A the ram bank number.
;***                The second area needs to be reserved inside the transfer ram
;***                area of the same bank. It contains the data structure of the
;***                list control. It size is calculated like this:
;***                Size = Maximum_number_of_entries * (4 + Additional_columns * 2)
;***                So when you have two additional columns (like date and
;***                attributes) and want to load up to 100 entries, you need to
;***                reserve 800 bytes.
;***                As there are no more Z80-registers available, the address of
;***                this memory area and the maximum number of entries must be
;***                written to the beginning of the other memory area.
;***                For additional information about reading directories see 038
;***                (DIRINP).
;******************************************************************************
.SyFile_DEVDIR
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 	FNC_FIL_DEVDIR
        ret

		
