
		

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@                    S y m b O S   -   C o n s t a n t s                     @
;@                                                                            @
;@             (c) 2000-2008 by Prodatron / SymbiosiS (Jörn Mika)             @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;P R O C E S S - I D S
.PRC_ID_KERNEL   equ 95   ;kernel proces
.PRC_ID_DESKTOP  equ 2   ;desktop manager process
.PRC_ID_SYSTEM   equ 3   ;system manager process
;M E S S A G E S
;General
.MSC_GEN_QUIT    equ 0   ;application is beeing asked, to quit itself
.MSC_GEN_FOCUS   equ 255 ;application is beeing asked, to focus its window

;Kernel Commands
.MSC_KRL_MTADDP  equ 1   ;add process (P1/2=stack, P3=priority (7 high - 1 low), P4=ram bank (0-8))
.MSC_KRL_MTDELP  equ 2   ;delete process (P1=ID)
.MSC_KRL_MTADDT  equ 3   ;add timer (P1/2=stack, P4=ram bank (0-8))
.MSC_KRL_MTDELT  equ 4   ;delete timer (P1=ID)
.MSC_KRL_MTSLPP  equ 5   ;set process to sleep mode
.MSC_KRL_MTWAKP  equ 6   ;wake up process
.MSC_KRL_TMADDT  equ 7   ;add counter service (P1/2=address, P3=ram bank, P4=process, P5=frequency)
.MSC_KRL_TMDELT  equ 8   ;delete counter service (P1/2=address, P3=ram bank)
.MSC_KRL_TMDELP  equ 9   ;delete all counter services of one process (P1=process ID)

;Kernel Responses
.MSR_KRL_MTADDP  equ 129 ;process has been added (P1=0/1->ok/failed, P2=ID)
.MSR_KRL_MTDELP  equ 130 ;process has been deleted
.MSR_KRL_MTADDT  equ 131 ;timer process has been deleted (P1=0/1->ok/failed, P2=ID)
.MSR_KRL_MTDELT  equ 132 ;timer has been removed
.MSR_KRL_MTSLPP  equ 133 ;process is sleeping now
.MSR_KRL_MTWAKP  equ 134 ;process has been waked up
.MSR_KRL_TMADDT  equ 135 ;counter service has been added (P1=0/1->ok/failed)
.MSR_KRL_TMDELT  equ 136 ;counter service has been deleted
.MSR_KRL_TMDELP  equ 137 ;all counter services of a process have been deleted

;System Commands
.MSC_SYS_PRGRUN  equ 16  ;load application or document (P1/2=address filename, P3=ram bank filename)
.MSC_SYS_PRGEND  equ 17  ;quit application (P1=ID)
.MSC_SYS_SYSWNX  equ 18  ;open dialogue to change current window (next) (-)
.MSC_SYS_SYSWPR  equ 19  ;open dialogue to change current window (previouse) (vorheriges) (-)
.MSC_SYS_PRGSTA  equ 20  ;open dialogue to load application or document (-)
.MSC_SYS_SYSSEC  equ 21  ;open system secuity dialogue (-)
.MSC_SYS_SYSQIT  equ 22  ;open shut shown dialogue (-)
.MSC_SYS_SYSOFF  equ 23  ;shut down (-)
.MSC_SYS_PRGSET  equ 24  ;start control panel (P1=submodul -> 0=main window, 1=display settings, 2=date/time)
.MSC_SYS_PRGTSK  equ 25  ;start taskmanager (-)
.MSC_SYS_SYSFIL  equ 26  ;call filemanager function (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
.MSC_SYS_SYSHLP  equ 27  ;start help (-)
.MSC_SYS_SYSCFG  equ 28  ;call config function (P1=number, 0=load, 1=save, 2=reload background)
.MSC_SYS_SYSWRN  equ 29  ;open message/confirm window (P1/2=adresse, P3=ram bank, P4=number of buttons)
.MSC_SYS_PRGSRV  equ 30  ;shared service function (P4=type [0=search, 1=start, 2=release], P1/2=addresse 12char ID, P3=ram bank 12char ID or P3=program ID, if type=2)
.MSC_SYS_SELOPN  equ 31  ;open fileselect dialogue (P6=filename ram bank, P8/9=filename address, P7=forbidden attributes, P10=max entries, P12=max buffer size)

;System Responses
.MSR_SYS_PRGRUN  equ 144 ;application has been started (P1=result -> 0=ok, 1=file doesnt exist, 2=file is not executable, 3=error while loading  [P8=filemanager error code], 4=memory full, P8=app ID, P9=process ID)
.MSR_SYS_SYSFIL  equ 154 ;filemanager function returned (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
.MSR_SYS_SYSWRN  equ 157 ;message/confirm window response (P1 -> 0=already in use, 1=opened [P2=number], 2=ok, 3=yes, 4=no, 5=cancel/close)
.MSR_SYS_PRGSRV  equ 158 ;shared service function response (P1=state [5=not found, other codes see MSR_SYS_PRGRUN], P8=app ID, P9=process ID)
.MSR_SYS_SELOPN  equ 159 ;message from fileselect dialogue (P1 -> 0=Ok, 1=cancel, 2=already in use, 3=no memory free, 4=no window free, -1=open ok, modal window has been opened [P2=number])

;Desktop Commands
.MSC_DSK_WINOPN  equ 32  ;open window (P1=ram bank, P2/3=address data record)
.MSC_DSK_WINMEN  equ 33  ;redraw menu bar (P1=window ID) [only if focus]
.MSC_DSK_WININH  equ 34  ;redraw window content (P1=window ID, P2=-1/-Num/Object, P3=Object) [only if focus]
.MSC_DSK_WINTOL  equ 35  ;redraw window toolbar (P1=window ID) [only if focus]
.MSC_DSK_WINTIT  equ 36  ;redraw window title (P1=window ID) [only if focus]
.MSC_DSK_WINSTA  equ 37  ;redraw window status lien (P1=window ID) [only if focus]
.MSC_DSK_WINMVX  equ 38  ;set content x offset (P1=window ID, P2/3=XPos) [only if focus]
.MSC_DSK_WINMVY  equ 39  ;set content y offset (P1=window ID, P2/3=XPos) [only if focus]
.MSC_DSK_WINTOP  equ 40  ;takes window to the front (P1=window ID) [always]
.MSC_DSK_WINMAX  equ 41  ;maximize window (P1=window ID) [always]
.MSC_DSK_WINMIN  equ 42  ;minimize window (P1=window ID) [always]
.MSC_DSK_WINMID  equ 43  ;restore window size (P1=window ID) [always]
.MSC_DSK_WINMOV  equ 44  ;moves window to a new position (P1=window ID, P2/3=XPos, P4/5=YPos) [always]
.MSC_DSK_WINSIZ  equ 45  ;resize the window (P1=window ID, P2/3=XPos, P4/5=YPos) [always]
.MSC_DSK_WINCLS  equ 46  ;closes and removes window (P1=window ID) [always]
.MSC_DSK_WINDIN  equ 47  ;redraw window content, even if it hasnt focus (P1=window ID, P2=-1/-Num/Objekt, P3=Object) [always]
.MSC_DSK_DSKSRV  equ 48  ;desktop service request (P1=type, P2-P5=parameters)
.MSC_DSK_WINSLD  equ 49  ;redraw window scrollbars (P1=window ID) [only if focus]
.MSC_DSK_WINPIN  equ 50  ;redraw window content part (P1=window ID, P2=-1/-Num/Object, P3=Object, P4/5=Xbeg, P6/7=Ybeg, P8/9=Xlen, P10/11=Ylen) [always]
.MSC_DSK_WINSIN  equ 51  ;redraw content of a super control (P1=window ID, P2=super control ID, P3=SubObject) [always]
.MSC_DSK_MENCTX  equ 52  ;opens context menu (P1=ram bank, P2/3=address data record, P4/5=Xbeg [-1=mouse position], P6/7=Ybeg) ##!!## doc+lib
.MSC_DSK_STIADD  equ 53  ;adds systray-icon (P1=ram bank, P2/3=address, P4=ID)
.MSC_DSK_STIREM  equ 54  ;removes systray-icon (P1=number)
.MSC_DSK_STIUPD  equ 55  ;updates systray-icon (P1=number)
.MSC_DSK_CONPOS  equ 56  ;move a virtual control to a new position (P2/3=xpos, P4/5=ypos, P6/7=xlen, P8/9=ylen)
.MSC_DSK_CONSIZ  equ 57  ;resize a virtual control (P2/3=xpos, P4/5=ypos, P6/7=xlen, P8/9=ylen)



;Desktop Responses
.MSR_DSK_WOPNER  equ 160 ;open window failed; the maximum of 32 windows has been reached
.MSR_DSK_WOPNOK  equ 161 ;open window successfull (P4=number)
.MSR_DSK_WCLICK  equ 162 ;window has been clicked (P1=window number, P2=action, P3=subspezification, P4/5,P6/7,P8/9=parameters)
.MSR_DSK_DSKSRV  equ 163 ;desktop service answer (P1=type, P2-P5=parameters)
.MSR_DSK_WFOCUS  equ 164 ;window got/lost focus (P1=window number, P2=type [0=blur, 1=focus])
.MSR_DSK_CFOCUS  equ 165 ;control focus changed (P1=window number, P2=control number, P3=reason [0=mouse click/wheel, 1=tab key])
.MSR_DSK_WRESIZ  equ 166 ;window has been resized (P1=window number)
.MSR_DSK_WSCROL  equ 167 ;window content has been scrolled (P1=window number)
.MSR_DSK_MENCTX  equ 168 ;menu has been clicked or canceld (P1=1 ok, P2/3=value, P4=type [0=normal, 1=check]) ##!!## doc+lib
.MSR_DSK_STIADD  equ 169 ;result of adding systray-icon (P1=1 ok, P2=number)
.MSR_DSK_STICLK  equ 170 ;systray-icon has been clicked (P1=ID)
.MSR_DSK_WMODAL  equ 171 ;Window_ModalUnclick_Response
.MSR_DSK_CONPOS  equ 172 ;virtual control has been moved or canceled (P1=1 ok, P2/3=new xpos, P4/5=new ypos)
.MSR_DSK_CONSIZ  equ 173 ;virtual control has been resized or canceled (P1=1 ok, P2/3=new xlen, P4/5=new ylen)

.MSR_DSK_EXTDSK  equ 191 ;command for extended desktop (used internally; P1=command, P2-x=parameters)

.FNC_DXT_DSKBGR  equ 001 ;background has been updated
.FNC_DXT_FILRUN  equ 002 ;file has been opened via prgrun (P2/3=address, P4=bank)
.FNC_DXT_FILBRW  equ 003 ;file has been selected via file browser (P2/3=address, P4=bank)
.FNC_DXT_MENCLK  equ 004 ;startmenu has been clicked (P2/3=value)
.FNC_DXT_DSKCLK  equ 005 ;desktop window has been clicked (P2=action, P3=subspezification, P4/5,P6/7,P8/9=parameters)

;Shell Commands
.MSC_SHL_CHRINP  equ 64  ;char is requested (P1=channel [0=standard, 1=keyboard])
.MSC_SHL_STRINP  equ 65  ;line is requested (P1=channel [0=standard, 1=keyboard], P2=ram bank, P3/4=address)
.MSC_SHL_CHROUT  equ 66  ;char should be writtten (P1=channel [0=standard, 1=screen], P2=char)
.MSC_SHL_STROUT  equ 67  ;line should be writtten (P1=channel [0=standard, 1=screen], P2=ram bank, P3/4=address, P5=length)
.MSC_SHL_EXIT    equ 68  ;application released focus or quit itself (P1 -> 0=quit, 1=blur)
.MSC_SHL_PTHADD  equ 69  ;add additional path to current one (P1=base path, P3=addition path, P5=final path, P7=ram bank)

;Shell Responses
.MSR_SHL_CHRINP  equ 192 ;char has been received (P1=EOF-flag [0=no EOF], P2=char, P3=error status)
.MSR_SHL_STRINP  equ 193 ;line has been received (P1=EOF-flag [0=no EOF], P3=error status)
.MSR_SHL_CHROUT  equ 194 ;char has been written (P3=error status)
.MSR_SHL_STROUT  equ 195 ;line has been written (P3=error status)
.MSR_SHL_PTHADD  equ 197 ;path has been combined (P1=total end address, P3=directory end address, P5=flags)

;Screensaver Messages
.MSC_SAV_INIT    equ 1   ;initialises the screen saver (P1=bank of config data, P2/3=address of config data [64bytes])
.MSC_SAV_START   equ 2   ;start screen saver
.MSC_SAV_CONFIG  equ 3   ;open screen savers own config window (at the end the screen saver has to send the result back to the sender)
.MSR_SAV_CONFIG  equ 4   ;returns user adjusted screen saver config data (P1=bank of config data, P2/3=address of config data [64bytes])


;D E S K T O P - A C T I O N S
.DSK_ACT_CLOSE   equ 5   ;close button has been clicked or ALT+F4 has been pressed
.DSK_ACT_MENU    equ 6   ;menu entry has been clicked (P8/9=menu entry value)
.DSK_ACT_CONTENT equ 14  ;a control of the content has been clicked (P3=sub spec [see dsk_sub...], P4=key or P4/5=Xpos within the window, P6/7=Ypos, P8/9=control value)
.DSK_ACT_TOOLBAR equ 15  ;a control of the toolbar has been clicked (see DSK_ACT_CONTENT)
.DSK_ACT_KEY     equ 16  ;key has been pressed without touching/modifying a control (P4=Ascii Code)

.DSK_SUB_MLCLICK equ 0   ;left mouse button has been clicked
.DSK_SUB_MRCLICK equ 1   ;right mouse button has been clicked
.DSK_SUB_MDCLICK equ 2   ;double click with the left mouse button
.DSK_SUB_MMCLICK equ 3   ;middle mouse button has been clicked
.DSK_SUB_KEY     equ 7   ;keyboard has been clicked and did modify/click a control (P4=Ascii Code)
.DSK_SUB_MWHEEL  equ 8   ;mouse wheel has been moved (P4=Offset)


;D E S K T O P - S E R V I C E S
.DSK_SRV_MODGET  equ 1   ;get screen mode (output P2=mode, P3=virtual desktop)
.DSK_SRV_MODSET  equ 2   ;set screen mode (input P2=mode, P3=virtual desktop)
.DSK_SRV_COLGET  equ 3   ;get colour      (input P2=number, output P2=number, P3/4=RGB value)
.DSK_SRV_COLSET  equ 4   ;set colour      (input P2=number, P3/4=RGB value)
.DSK_SRV_DSKSTP  equ 5   ;freeze desktop  (input P2=type [0=Pen0, 1=Raster, 2=background, 255=no screen modification, switch off mouse])
.DSK_SRV_DSKCNT  equ 6   ;continue desktop
.DSK_SRV_DSKPNT  equ 7   ;clear desktop   (Eingabe P2=Typ [0=Pen0, 1=Raster, 2=background])
.DSK_SRV_DSKBGR  equ 8   ;initialize and redraw desktop background
.DSK_SRV_DSKPLT  equ 9   ;redraw the complete desktop
.DSK_SRV_DSKOPN  equ 11  ;open desktop background window


;C L I P B O A R D - T Y P E S
.CLPTYP_TEXT     equ 1   ;plain text
.CLPTYP_GRAPHIC  equ 2   ;graphic with extended header
.CLPTYP_ITEMS    equ 3   ;item list (*not defined yet*)
.CLPTYP_ICON     equ 4   ;desktop icon shortcut


;J U M P S

.jmp_memsum  equ #8100 ;MEMSUM
.jmp_sysinf  equ #8103 ;SYSINF
.jmp_clcnum  equ #8106 ;CLCNUM
.jmp_mtgcnt  equ #8109 ;MTGCNT
.jmp_timget  equ #810C ;TIMGET
.jmp_timset  equ #810F ;TIMSET
.jmp_memget  equ #8118 ;MEMGET
.jmp_memfre  equ #811B ;MEMFRE
.jmp_memsiz  equ #811E ;MEMSIZ
.jmp_meminf  equ #8121 ;MEMINF
.jmp_bnkrwd  equ #8124 ;BNKRWD
.jmp_bnkwwd  equ #8127 ;BNKWWD
.jmp_bnkrbt  equ #812A ;BNKRBT
.jmp_bnkwbt  equ #812D ;BNKWBT
.jmp_bnkcop  equ #8130 ;BNKCOP
.jmp_bnkget  equ #8133 ;BNKGET
.jmp_scrset  equ #8136 ;SCRSET (cpc only)
.jmp_scrget  equ #8139 ;SCRGET
.jmp_mosget  equ #813C ;MOSGET
.jmp_moskey  equ #813F ;MOSKEY
.jmp_bnk16c  equ #8142 ;BNK16C
.jmp_keytst  equ #8145 ;KEYTST
.jmp_keysta  equ #8148 ;KEYSTA
.jmp_keyput  equ #814B ;KEYPUT
.jmp_bufput  equ #814E ;BUFPUT
.jmp_bufget  equ #8151 ;BUFGET
.jmp_bufsta  equ #8154 ;BUFSTA
.jmp_iominp  equ #8157 ;IOMINP (cpc only)
.jmp_iomout  equ #815A ;IOMOUT (cpc only)
.jmp_txtlen  equ #815D ;TXTLEN
.jmp_keymul  equ #8160 ;KEYMUL
.jmp_g9kfnc  equ #8163 ;G9KFNC (g9k only)

.jmp_bnkret  equ #ff00 ;BNKRET
.jmp_bnkcll  equ #ff03 ;BNKCLL
.jmp_bnkcpr  equ #ff06 ;BNKCPR
.jmp_bnklok  equ #ff09 ;BNKLOK
.jmp_bnkrel  equ #ff0c ;BNKREL



;Filemanager Functions (call via MSC_SYS_SYSFIL)
.FNC_FIL_STOINI  equ 000 ;Storage Init (Removes all mass storage devices)
.FNC_FIL_STONEW  equ 001 ;Storage New (Adds a new mass storage device)
.FNC_FIL_STORLD  equ 002 ;Storage Reload (Reloads a mass storage device, if its "removeable media" status is activated)
.FNC_FIL_STODEL  equ 003 ;Storage Delete (Removes an existing mass storage device)
.FNC_FIL_STOINP  equ 004 ;Storage ReadSector (Reads a sector from a mass storage device (no memory banking))
.FNC_FIL_STOOUT  equ 005 ;Storage WriteSector (Write a sector to a mass storage device (no memory banking))
.FNC_FIL_STOACT  equ 006 ;Storage Activate (Loads the format and the file system type of a mass storage device)
.FNC_FIL_STOINF  equ 007 ;Storage Information (Returns information about a mass storage device)
.FNC_FIL_STOTRN  equ 008 ;Storage DataTransfer (Reads or writes a number of sectors (512 bytes) from/to the mass storage device)

.FNC_FIL_DEVDIR  equ 013 ;
.FNC_FIL_DEVINI  equ 014 ;
.FNC_FIL_DEVSET  equ 015 ;

.FNC_FIL_FILINI  equ 016 ;File Init (Initialises the whole file manager)
.FNC_FIL_FILNEW  equ 017 ;File New (Creates a new file and opens it for read/write access)
.FNC_FIL_FILOPN  equ 018 ;File Open (Opens an existing file for read/write access)
.FNC_FIL_FILCLO  equ 019 ;File Close (Closes an opened file)
.FNC_FIL_FILINP  equ 020 ;File Input (Reads a specified amount of bytes out of an opened file)
.FNC_FIL_FILOUT  equ 021 ;File Output (Writes a specified amount of bytes into an opened file)
.FNC_FIL_FILPOI  equ 022 ;File Pointer (Moves the file pointer to another position)
.FNC_FIL_FILF2T  equ 023 ;File Decode Timestamp (Decodes the file timestamp, which is used for the file system)
.FNC_FIL_FILT2F  equ 024 ;File Encode Timestamp (Encodes the file timestamp, which is used for the file system)
.FNC_FIL_FILLIN  equ 025 ;File LineInput (Reads one text line out of an opened file)
.FNC_FIL_FILCPR  equ 026 ;File Compressed (Reads from a compressed or uncompressed part of an opened file)


.FNC_FIL_DIRDEV  equ 032 ;Directory Device (Selects the current drive)
.FNC_FIL_DIRPTH  equ 033 ;Directory Path (Selects the current path for the current or a different drive)
.FNC_FIL_DIRPRS  equ 034 ;Directory Property Set (Changes a property of a file or a directory)
.FNC_FIL_DIRPRR  equ 035 ;Directory Property Get (Reads a property of a file or a directory)
.FNC_FIL_DIRREN  equ 036 ;Directory Rename (Renames a file or a directory)
.FNC_FIL_DIRNEW  equ 037 ;Directory New (Creates a new directory)
.FNC_FIL_DIRINP  equ 038 ;Directory Input (Reads the content of a directory)
.FNC_FIL_DIRDEL  equ 039 ;Directory Delete (Deletes one or more files)
.FNC_FIL_DIRRMD  equ 040 ;Directory Delete Directory (Deletes a sub directory)
.FNC_FIL_DIRMOV  equ 041 ;Directory Move (Moves a file or sub directory into another directory of the same drive)
.FNC_FIL_DIRINF  equ 042 ;Directory Drive Information (Returns information about one drive)

;Network Daemon Functions
.FNC_NET_CFGGET  equ 001 ;config information
.FNC_NET_CFGSET  equ 002 ;config setting

.FNC_NET_TCPOPN  equ 016 ;TCP open
.FNC_NET_TCPCLO  equ 017 ;TCP close
.FNC_NET_TCPSTA  equ 018 ;TCP status
.FNC_NET_TCPRCV  equ 019 ;TCP receive
.FNC_NET_TCPSND  equ 020 ;TCP send
.FNC_NET_TCPSKP  equ 021 ;TCP skip received data
.FNC_NET_TCPFLS  equ 022 ;TCP flush send buffer
.FNC_NET_TCPDIS  equ 023 ;TCP disconnect
.MSR_NET_TCPEVT  equ 159 ;TCP event

.FNC_NET_UDPOPN  equ 032 ;UDP open
.FNC_NET_UDPCLO  equ 033 ;UDP close
.FNC_NET_UDPSTA  equ 034 ;UDP status
.FNC_NET_UDPRCV  equ 035 ;UDP receive
.FNC_NET_UDPSND  equ 036 ;UDP send
.FNC_NET_UDPSKP  equ 037 ;UDP skip received data
.MSR_NET_UDPEVT  equ 175 ;UDP event

.FNC_NET_DNSRSV  equ 112 ;DNS resolve
.FNC_NET_DNSVFY  equ 113 ;DNS verify




.PrgDatCod     equ 0	;Code Length including 256 Header
.PrgDatDat     equ 2	;Data Length to a maximum 16k
.PrgDatTra     equ 4   ;Transfer Part Length
.PrgDatOrg     equ 6   ;Original ORG
.PrgDatRel     equ 8   ;Number of Entries in Relocation Table
.PrgDatStk     equ 10  ;Stack Length at start of Transfer
.PrgDatCrn     equ 12	;Crunched Length
.PrgDatCtp     equ 14	;Crunch Typ
.PrgDatNam     equ 15	;Program Name (Always 32 Bytes)+0 33 Byte
.PrgDatIdn     equ 48  ;SymExe10
.PrgDatRes     equ 62  ;Reserve
.PrgDatIsm     equ 90  ;Small Ico
.PrgDatIbg     equ 109 ;Big Ico
.PrgDatVer     equ 88  ;Version 3
.PrgDatLen     equ 256 ;

.PrgPstDat     equ 6   ;
.PrgPstTra     equ 8   ;
.PrgPstSpz     equ 10  ;
.PrgPstBnk     equ 14  ;
.PrgPstMem     equ 48  ;
.PrgPstNum     equ 88  ;
.PrgPstPrz     equ 89  ;


.ScanCode_E	equ 45

;----------------------------------------------------------------------------;
; V9990 register and port defines                                            ;
;----------------------------------------------------------------------------;

; Port defines
;.g9k_VRAM				equ	#60				; R/W
.CG9K_VRAM				equ	#ff60			; R/W
.g9k_PALETTE			equ	#61				; R/W
.CG9K_PALETTE			equ	#ff61				; R/W
.g9k_CMD_DATA			equ	#62				; R/W
.g9k_REG_DATA			equ	#63				; R/W
.CG9K_REG_DATA			equ	#ff63			; R/W
.CG9K_REG_SELECT		equ	#ff64			; W
.CG9K_STATUS			equ	#ff65			; R
.CG9K_INT_FLAG			equ	#ff66				; R/W
.g9k_SYS_CTRL			equ	#67				; W
.g9k_OUTPUT_CTRL		equ	#6F 		    ; R/W
.CG9K_OUTPUT_CTRL		equ	#ff6F 		    ; R/W

; Bit defines g9k_SYS_CTRL
.g9k_SYS_CTRL_SRS		equ	2				; Power on reset state
.g9k_SYS_CTRL_MCKIN		equ	1				; Select MCKIN terminal
.g9k_SYS_CTRL_XTAL		equ	0				; Select XTAL



; Register defines
.g9k_WRITE_ADDR			equ	0				; W
.g9k_READ_ADDR			equ	3				; W
.g9k_SCREEN_MODE0		equ	6				; R/W
.g9k_SCREEN_MODE1		equ 7				; R/W
.g9k_CTRL				equ	8				; R/W
.g9k_INT_ENABLE         equ 9       		; R/W
.g9k_INT_V_LINE_LO		equ	10				; R/W	
.g9k_INT_V_LINE_HI		equ	11				; R/W
.g9k_INT_H_LINE			equ	12				; R/W	
.g9k_PALETTE_CTRL		equ	13				; W
.g9k_PALETTE_PTR		equ	14				; W
.g9k_BACK_DROP_COLOR 	equ 15		      	; R/W
.CG9K_BACK_DROP_COLOR 	equ 15		      	; R/W
.g9k_DISPLAY_ADJUST		equ	16				; R/W
.g9k_SCROLL_LOW_Y		equ 17 			    ; R/W
.g9k_SCROLL_HIGH_Y		equ 18      		; R/W
.g9k_SCROLL_LOW_X		equ 19      		; R/W
.g9k_SCROLL_HIGH_X		equ 20      		; R/W
.g9k_SCROLL_LOW_Y_B		equ 21 				; R/W
.g9k_SCROLL_HIGH_Y_B	equ 22      		; R/W
.g9k_SCROLL_LOW_X_B		equ 23      		; R/W
.g9k_SCROLL_HIGH_X_B	equ 24      		; R/W
.g9k_PAT_GEN_TABLE   	equ 25      		; R/W
.g9k_LCD_CTRL        	equ 26      		; R/W
.g9k_PRIORITY_CTRL  	equ 27      		; R/W
.g9k_SPR_PAL_CTRL		equ	28				; W
.g9k_SC_X				equ	32				; W
.CG9K_SC_A				equ 32				; W
.g9k_SC_Y				equ	34				; W
.g9k_DS_X				equ	36				; W
.g9k_DS_Y				equ	38				; W
.g9k_NX					equ	40				; W
.g9k_NY					equ	42				; W
.g9k_ARG				equ	44				; W
.g9k_LOP				equ	45				; W
.g9k_WRITE_MASK			equ	46				; W
.g9k_FC					equ	48				; W
.g9k_BC					equ	50				; W
.g9k_OPCODE				equ	52				; W

; Register Select options
.g9k_DIS_INC_READ		equ	64
.g9k_DIS_INC_WRITE		equ	128

; Bit defines g9k_SCREEN_MODE0 (register 6)
.g9k_SCR0_STANDBY		equ	192				; Stand by mode
.g9k_SCR0_BITMAP		equ	128				; Select Bit map mode
.g9k_SCR0_P2			equ	64				; Select P1 mode
.g9k_SCR0_P1			equ	0				; Select P1 mode
.g9k_SCR0_DTCLK			equ	32				; Master Dot clock not divided
.g9k_SCR0_DTCLK2		equ	16				; Master Dot clock divided by 2
.g9k_SCR0_DTCLK4		equ	0				; Master Dot clock divided by 4
.g9k_SCR0_XIM2048		equ	12				; Image size = 2048
.g9k_SCR0_XIM1024		equ	8				; Image size = 1024
.g9k_SCR0_XIM512		equ	4				; Image size = 512
.g9k_SCR0_XIM256		equ	0				; Image size = 256
.g9k_SCR0_16BIT			equ	3				; 16 bits/dot
.g9k_SCR0_8BIT			equ	2				; 8 bits/dot
.g9k_SCR0_4BIT			equ	1				; 4 bits/dot
.g9k_SCR0_2BIT			equ 0				; 2 bits/dot

; Bit defines g9k_SCREEN_MODE1 (register 7)
.g9k_SCR1_C25M			equ	64				; Select 640*480 mode
.g9k_SCR1_SM1			equ	32				; Selection of 263 lines during non interlace , else 262
.g9k_SCR1_SM			equ	16				; Selection of horizontal frequency 1H=fsc/227.5
.g9k_SCR1_PAL			equ	8				; Select PAL, else NTSC
.g9k_SCR1_EO			equ	4				; Select of vertical resoltion of twice the non-interlace resolution
.g9k_SCR1_IL			equ	2				; Select Interlace
.g9k_SCR1_HSCN			equ	1				; Select High scan mode

; Bit defines g9k_CTRL    (Register 8)
.g9k_CTRL_DISP			equ	128				; Display VRAM
.g9k_CTRL_DIS_SPD		equ	64				; Disable display sprite (cursor)
.g9k_CTRL_YSE			equ	32				; /YS Enable
.g9k_CTRL_VWTE			equ	16				; VRAM Serial data bus control during digitization
.g9k_CTRL_VWM			equ	8				; VRAM write control during digitization
.g9k_CTRL_DMAE			equ	4				; Enable DMAQ output
.g9k_CTRL_VRAM512		equ	2				; VRAM=512KB
.g9k_CTRL_VRAM256		equ	1				; VRAM=256KB
.g9k_CTRL_VRAM128		equ	0				; VRAM=128KB

; Bit defines g9k_INT_ENABLE (register 9)
.g9k_INT_IECE	        equ 4       		; Command end interrupt enable control
.g9k_INT_IEH	        equ 2       		; Display position interrupt enable
.g9k_INT_IEV	        equ 1       		; Int. enable during vertical retrace line interval

; Bit Defines g9k_PALETTE_CTRL  (Register 13)
.g9k_PAL_CTRL_YUV		equ	192				; YUV mode
.g9k_PAL_CTRL_YJK		equ	128				; YJK mode
.g9k_PAL_CTRL_256		equ	64				; 256 color mode
.g9k_PAL_CTRL_PAL		equ	0				; Pallete mode
.g9k_PAL_CTRL_YAE		equ	32				; Enable YUV/YJK RGB mixing mode

; Bit defines g9k_LOP           (Register 45)
.g9k_LOP_TP				equ	16
.g9k_LOP_WCSC			equ	12
.g9k_LOP_WCNOTSC		equ	3
.g9k_LOP_WCANDSC		equ	8
.g9k_LOP_WCORSC			equ	14
.g9k_LOP_WCEORSC		equ	6

; Bit defines g9k_ARG
.g9k_ARG_MAJ			equ	1
.g9k_ARG_NEG			equ	2
.g9k_ARG_DIX			equ	4
.g9k_ARG_DIY			equ	8

; Blitter Commands g9k_OPCODE    (Register 52)
.g9k_OPCODE_STOP		equ	#00				; Command being excuted is stopped 
.g9k_OPCODE_LMMC		equ	#10     		; Data is transferred from CPU to VRAM rectangle area
.g9k_OPCODE_LMMV		equ	#20     		; VRAM rectangle area is painted out
.g9k_OPCODE_LMCM		equ	#30				; VRAM rectangle area is transferred to CPU
.g9k_OPCODE_LMMM		equ	#40				; Rectangle area os transferred from VRAM to VRAM
.g9k_OPCODE_CMMC		equ	#050			; CPU character data is color-developed and transferred to VRAM rectangle area
.g9k_OPCODE_CMMK		equ	#060			; Kanji ROM data is is color-developed and transferred to VRAM rectangle area
.g9k_OPCODE_CMMM		equ	#070			; VRAM character data is color-developed and transferred to VRAM rectangle area 
.g9k_OPCODE_BMXL		equ	#080			; Data on VRAM linear address is transferred to VRAM rectangle area
.g9k_OPCODE_BMLX		equ	#090			; VRAM rectangle area is transferred to VRAM linear address 
.g9k_OPCODE_BMLL		equ	#0A0			; Data on VRAM linear address is transferred to VRAM linear address 
.g9k_OPCODE_LINE		equ	#0B0			; Straight line is drawer on X-Y co-ordinates
.g9k_OPCODE_SRCH		equ	#0C0			; Border color co-ordinates on X-Y are detected
.g9k_OPCODE_POINT		equ	#0D0			; Color code on specified point on X-Y is read out
.g9k_OPCODE_PSET		equ	#0E0			; Drawing is executed at drawing point on X-Y co-ordinates
.g9k_OPCODE_ADVN		equ	#0F0			; Drawing point on X-Y co-ordinates is shifted

; Bit defines g9k_STATUS
.g9k_STATUS_TR          equ 128
.g9k_STATUS_VR          equ 64
.g9k_STATUS_HR          equ 32
.g9k_STATUS_BD          equ 16
.g9k_STATUS_MSC         equ 4
.g9k_STATUS_EO          equ 2
.g9k_STATUS_CE          equ 1

; Mode select defines for SetScreenMode
.g9k_MODE_P1			equ	0				; Pattern mode 0 256 212
.g9k_MODE_P2			equ	1				; Pattern mode 1 512 212
.g9k_MODE_B1			equ	2				; Bitmap mode 1 256 212
.g9k_MODE_B2			equ	3				; Bitmap mode 2 384 240
.g9k_MODE_B3			equ	4				; Bitmap mode 3 512 212
.g9k_MODE_B4			equ	5				; Bitmap mode 4 768 240
.g9k_MODE_B5			equ	6				; Bitmap mode 5 640 400 (VGA)
.g9k_MODE_B6			equ	7				; Bitmap mode 6 640 480 (VGA)
.g9k_MODE_B7			equ	8				; Bitmap mode 7 1024 212 (Undocumented v9990 mode)

; Fixed VRAM addresses
;g9k_SCRA_PAT_NAME_TABLE EQU     07C000h
;g9k_SCRB_PAT_NAME_TABLE EQU     07E000h
;g9k_P1_SPR_ATTRIB_TABLE EQU     03FE00h
;g9k_P2_SPR_ATTRIB_TABLE EQU     07BE00h

;g9k_CURSOR0_ATTRIB      EQU     07FE00h
;g9k_CURSOR1_ATTRIB      EQU     07FE08h

;g9k_CURSOR0_PAT_DATA    EQU     07FF00h
;g9k_CURSOR1_PAT_DATA    EQU     07FF80h

.g9k_RED                 equ 32
.g9k_GREEN               equ 1024
.g9k_BLUE                equ 1


;g9k_WRITE_MASK_LAYER_A	EQU	000FFh
;g9k_WRITE_MASK_LAYER_B	EQU	0FF00h

;Sound Daemon Functions and constants
.FNC_SND_SNDINF  equ 001 ;ask for sound information
.FNC_SND_SNDCOO  equ 003 ;cooperation with SymAmp/3rd party sound players
.FNC_SND_RMTCTR  equ 005 ;remote control
.FNC_SND_RMTACT  equ 006 ;activates remote playing
.FNC_SND_RMTDCT  equ 007 ;deactivates remote playing

.FNC_SND_MUSLOD  	equ 008 	;loads and inits music data
.FNC_SND_MUSFRE  	equ 009 	;removes music data
.FNC_SND_MUSRST  	equ 010 	;restarts a music
.FNC_SND_MUSCON  	equ 011 	;continues a music
.FNC_SND_MUSSTP  	equ 012 	;pauses music and mutes device
.FNC_SND_MUSVOL  	equ 013 	;sets music volume
.FNC_SND_EFXLOD  	equ 016 	;loads and inits effect data
.FNC_SND_EFXFRE  	equ 017 	;removes effect data
.FNC_SND_EFXPLY  	equ 018 	;plays an effect
.FNC_SND_EFXSTP  	equ 019 	;stops effects
.FNC_SND_EFXEVT  	equ 023 	;play event specific effect
.MSR_SND_SNDINF  	equ 129 	;returns sound information
.MSR_SND_MUSLOD  	equ 136 	;music  loading success state
.MSR_SND_EFXLOD  	equ 144 	;effect loading success state

.SND_EVT_NHINT   	equ 0   ;Notification - hint
.SND_EVT_NWARN   	equ 1   ;Notification - warning
.SND_EVT_NMESSG  	equ 2   ;Notification - message
.SND_EVT_WOPEN   	equ 3   ;Window - open
.SND_EVT_WTOP    	equ 4   ;Window - top
.SND_EVT_WRESTO  	equ 5   ;Window - restore
.SND_EVT_WMAX    	equ 6   ;Window - maximize
.SND_EVT_WMIN    	equ 7   ;Window - minimize
.SND_EVT_WCLOSE  	equ 8   ;Window - close
.SND_EVT_MOPEN   	equ 9   ;Menu - open
.SND_EVT_MHOVER  	equ 10  ;Menu - entry hover
.SND_EVT_MCLICK  	equ 11  ;Menu - entry clicked
.SND_EVT_CBUTTN  	equ 12  ;Click - button/tab/check/radio
.SND_EVT_CBITMP  	equ 13  ;Click - bitmap
.SND_EVT_CSLIDR  	equ 14  ;Click - slider
.SND_EVT_CLIST   	equ 15  ;Click - list
.SND_EVT_CTEXT   	equ 16  ;Click - text

.SND_SYS_CLICK1  	equ 1   ;Click 1
.SND_SYS_CLICK2  	equ 2   ;Click 2
.SND_SYS_BEEP1   	equ 3   ;Beep 1
.SND_SYS_BEEP2   	equ 4   ;Beep 2
.SND_SYS_RING1   	equ 5   ;Ring 1
.SND_SYS_RING2   	equ 6   ;Ring 2
.SND_SYS_ALERT1  	equ 7   ;Alert 1
.SND_SYS_ALERT2  	equ 8   ;Alert 2
.SND_SYS_SLIDR1  	equ 9   ;Slide 1
.SND_SYS_SLIDR2  	equ 10  ;Slide 2
.SND_SYS_RAISEU  	equ 11  ;Raise up
.SND_SYS_RAISED  	equ 12  ;Raise down
.SND_SYS_POPUP   	equ 13  ;Pop up
.SND_SYS_SHRINK  	equ 14  ;Shrink
.SND_SYS_TIC1    	equ 15  ;Tic 1
.SND_SYS_TIC2    	equ 16  ;Tic 2
.SND_SYS_SHOOT   	equ 17  ;Shoot
.SND_SYS_EXPLOS  	equ 18  ;Explosion
.SND_SYS_STEP    	equ 19  ;Step
.SND_SYS_LOSE    	equ 20  ;Lose
.SND_SYS_WIN     	equ 21  ;Win
SYMBOS_ORG #100
;**** 256 Application Header ****
.AppCodBeg     dw  AppDatBeg-AppCodBeg      ;Length of Cod
.AppDataSize   dw  AppTrnBeg-AppDatBeg      ;Length of Dat
.AppTrnSize    dw  AppTrnEnd-AppTrnBeg      ;Length of Transfe
.AppDatAdr     dw  #100                     ;Original Origi
.AppTrnAdr     dw  0                        ;Number of Entries In Relocation Tabl
.AppPrzLst     dw  AppStk-AppTrnBeg         ;Stack Lengt
               dw  0                        ;Length of Crunched Dat
.AppBnkNum     db  0                        ;Crunch Typ
.AppNam        db  "Dot box                 ",0
.AppIcon16     db  1
.AppIconOff    dw  Icon24_Data-AppCodBeg
.Appxxxx       db  0,0,0,0,0
.AppMemTab     db  "SymExe10"             ;File Check
.AppDataLen    equ  AppTrnBeg-AppDatBeg      ;Length of Data
.AppTrnLen     equ  AppTrnEnd-AppTrnBeg      ;Length of Transfer
.AppDataASz    equ  16000
.AppTrnLen2    equ  16000-AppTrnLen
.AppDataLen2   equ  AppDataASz-AppDataLen
.AppExtCode    dw  0
.AppExtData    dw  AppDataLen2
.AppExtTrans   dw  AppTrnLen2
               ds  26
.AppSymMinor   db  1
.AppSymMajor   db  3
.AppIcnSml    
.AppStartForm  equ 3
        db 2,8,8
      db     15,15,14,3,13,13,73,73,73,73,75,75,60,135,15,15
.AppIcnBig    
.AppIcnLrg       db 6,24,24
             db 255,255,255,255,255,255
             db 136,0,0,0,0,17
             db 136,0,16,224,0,17
             db 136,16,225,30,128,17
             db 136,33,15,15,104,17
             db 136,67,15,15,30,17
             db 136,135,30,135,30,17
             db 136,135,44,67,30,17
             db 152,15,72,33,30,17
             db 152,15,72,33,30,17
             db 152,15,72,33,30,17
             db 152,15,72,67,44,17
             db 152,15,60,135,44,17
             db 152,15,15,15,72,17
             db 136,135,15,15,192,17
             db 136,67,15,30,0,17
             db 136,48,195,15,128,17
             db 136,0,33,15,120,145
             db 136,0,16,15,15,145
             db 136,0,0,135,15,145
             db 136,0,0,67,15,145
             db 136,0,0,48,240,145
             db 136,0,0,0,0,17
             db 255,255,255,255,255,255

;***************
;**** Code *****
;***************
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3

.V_App_In_Use			db 	0

.AppPrz:
;**** Open Primary Window ****

		ld		hl,AppTrnEnd+260
		ld		a,h
		ld		(Quig_String_AS_HByte),a		;Set Byte so we can check if string is in String area or String buffer

		;Save the Machine type
		ld		hl,jmp_sysinf        ;*** get computer type
        ld		de,256+5
        ld 		ix,Quig_Machine_Type
        ld 		iy,66+2+6+8
        rst 	#28
		ld		a,(Quig_Machine_Type)
		and		31
		ld		(Quig_Machine_Type),a

		ld		a,AppStartForm					;**** Form to Open first
		ld		l,a
		ld		h,0
		call	Quig_Form_Open					;**** Form Opener
	
	
;****************************************
;**** Main Application Control Loop *****
;****************************************
.Quig_Control_Loop:
		ld		a,(V_App_In_Use)
		And		a
		jr		nz,Quig_Control_Loop_1
		rst		#30								;Wait for message
		ld		a,(AppPrzN)		
       	db		#dd:ld l,a
		db		#dd:ld h,-1
 		ld		iy,AppMsgB
		rst		#18
		db		#dd:dec l						;AppMsgB should be populated
		jr		nz,Quig_Control_Loop_2			;No Message so just run Main()code.	
;		ld		a,(rhht)
;		cp		1
;		jr		nz,afkee
;		ld		a,(AppMsgB+0)
;		ld		de,Quig_FormIDs
;		di
;.fuckit:jr		fuckit	
;.afkee:		
		ld		a,(AppMsgB+0)					
		or		a
		jp		z,Quig_End
		scf
		cp		MSR_DSK_WCLICK					;**** Click on a Control
		jp		z,Quig_Control_Event
		cp		MSR_DSK_WRESIZ					;**** Resize window ?
		jp		z,Quig_Form_Event_Resize
		cp		MSR_DSK_WSCROL					;**** Scrolled Form ?
		jp		z,Quig_Form_Event_Scroll
		cp		MSR_DSK_WFOCUS					;**** Focus window change ?
		jp		z,Quig_Form_Event_Window_Focus
		cp		MSR_DSK_CFOCUS					;**** Focus change ?
		jp		z,Quig_Form_Event_Focus	
		cp		MSR_DSK_WMODAL					;**** Clicked form blocked by a Modal
		jp		z,Quig_Form_Event_PopUp
		
.Quig_Control_Loop_2:
		call	qfunc_main
.Quig_Control_Loop_1:
		Xor		a
		ld		(V_App_In_Use),a	
		jp		Quig_Control_Loop
		
.Quig_DataAddr:				dw 	0

.Quig_Math_StackPointer:	dw	Quig_Math_Stack
.Quig_Math_Stack:			ds	60
.Quig_Math_StackTop:
		
;**** Redirect a Clicked on Control Event		
.Quig_Control_Event:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		a,(Event_Type)	 		
 		cp		DSK_ACT_CONTENT
 		jp		z,Quig_Content
 		cp		DSK_ACT_TOOLBAR
 		jp		z,Quig_Tool		
		cp		DSK_ACT_CLOSE
		jp		z,Quig_Form_CloseEvent
		cp		DSK_ACT_MENU
 		jp		z,Quig_Menu
		cp		DSK_ACT_KEY
		jp		z,Quig_Key

		jp		Quig_Control_Loop_2
		
;**** Form Event ****
.Quig_Form_Event_PopUp:
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch		
		ld		hl,Quig_FormClickOff
		ld		d,0
		add		hl,de
		ld		a,(hl)
		and		a
		jp		z,Quig_Control_Loop_1
		
		ld		l,e
		ld		h,0
		call	Quig_Form_Close		
		jp		Quig_Control_Loop_1		

.Quig_Form_Event_Window_Focus:
		ld		a,(Quig_Form_Focus)				;Focus Event Happened
		inc		a								;Inc
		ld		(Quig_Form_Focus),a				;Store 
		jp		Quig_Control_Loop_1				;Return
		ld		a,(Event_Type)
		and		a
		jr		z,Quig_Form_Event_Window_FocusLost
		call	Quig_FormSearch
		ld		a,e
		jr		Quig_Form_Event_Window_Focus2
.Quig_Form_Event_Window_FocusLost:
		ld		a,255
.Quig_Form_Event_Window_Focus2:		
		ld		(Quig_Form_Focus),a
		jp		Quig_Control_Loop_1
.Quig_Form_Focus:	db	0		

.Quig_Form_Event_Focus:
		ld		a,5
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Scroll
		ld		a,4
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Resize
		ld		a,3
.Quig_Form_Event_X:		
		ld		(Quig_Form_Event_X_1+1),a
		call	Quig_FormSearch
		ld		a,e
.Quig_Form_Event_X_1
		ld		c,0								;**** C = 3/4 etc
		call	SyB_Call_Form_Event
		jp		Quig_Control_Loop_1
		
;*********************
;**** Key Control ****
;*********************
.Quig_Key:
		ld		a,(AppMsgB+4)
		and		%10000000
;		jp		z,Quig_Content
		jp		Quig_Control_Loop_2

;**********************
;**** Menu Control ****
;**********************
.Quig_Menu:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		hl,(AppMsgB+8)
		Xor		a
		cp		h
		jr		nz,Quig_Call_Set12
		cp		l
		jp		z,Quig_Control_Loop_1
.Quig_Call_Set12
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld		(Quig_Call_Set2+1),hl
.Quig_Call_Set2:
		call	0
		pop		iy
		pop		ix		
		jp		Quig_Control_Loop_1

		
;****************************************
;**** User has clicked on one Tool Control ****
;****************************************		
.Quig_Tool:
		ld		hl,ControWindowDataList+2
		Jr		Quig_Content2
;**** User has clicked on one Control ****
.Quig_Content:
		ld		hl,ControWindowDataList
.Quig_Content2:
		push	hl	
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch
		ld		l,e
		ld		h,0
		add		hl,hl
		add		hl,hl	
		pop		de
		add		hl,de
	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(Event_Control_ID)
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de

		
		inc		hl
		inc		hl	
		ld		a,(hl)					;Get the Type
		cp		43						;Is it MultiList (Sorting)
		jr		nz,Quig_Content6		;No Then Skip
		push	hl						;Store HL for return
		inc		hl
		inc		hl
		ld		e,(hl)					;Address of ExtData for List
		inc		hl
		ld		d,(hl)
		push	de						;Push Address min DE
		pop		ix						;Return Address in IX
		call	Quig_srtfix				;DO sort routine if necessary
		pop		hl						;Restore HL
.Quig_Content6:
		ld		de,12
		add		hl,de
		ld		e,(hl)
		inc 	hl
		ld		d,(hl)
		Xor		a
		cp		e
		jp		nz,Quig_Content_Event_1
		cp		d
		jp		nz,Quig_Content_Event_1
		jp		Quig_Control_Loop
.Quig_Content_Event_1:
		Xor		a
		ld		(V_App_In_Use),a
		ld		(Quig_Content_Event_2+1),de
.Quig_Content_Event_2
		call	0
		jp		Quig_Control_Loop_1	
.rhht:	db	0		

;****                       ****		
;**** Shut down Application ****
;****                       ****	
.Quig_End:
.Quig_End_X2:	
		ld		a,(AppPrzN)
		db		#dd:ld l,a
		ld		a,(SysPrzN)
		db		#dd:ld h,a
		ld		a,(AppCodBeg+PrgPstNum)
		ld		h,a
		ld		l,MSC_SYS_PRGEND
		ld		(AppMsgB),hl
		ld		iy,AppMsgB
		rst		#10
.Quig_End_1
 		rst		#30
		jr		Quig_End_1
	
;****                  ****
;**** HL = Form Number
;****                  ****

.prgwin:db 0
.prgwin2:db 0
.Quig_Form_Open:
;HL=Quigs Form Number 0..7
		ld		a,l
		ld		(prgwin),a
		ld		de,Quig_FormIDs					;**** 8 Forms held as Symbos Window numbers	
		add		hl,de
		ld		a,(hl)
		cp		255
		ret		nz								;If Not 255 then already open
		push	hl
.Quig_Form_Open_90:
		ld		a,(prgwin)						;**** A = SymStudio Window Number			
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	Quig_GetWindowEventAddr			;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Window Data
		ld		a,(AppBnkNum)
		inclib 	SYDESKTOP.WINOPN
		call	SyDesktop_WINOPN
		pop		hl
		ret		c								;**** If Carry then hasn't Opened window
.Quig_Form_Open_91:
		ld		(hl),a							;**** Store Internal number into form list
		ld		(prgwin2),a
		ld		a,(prgwin)
		ld		c,1								;**** C = 1 = Get Open Address
		call	SyB_Call_Form_Event
		Xor		a		
		ret
;****              ****		
;**** Close a Form ****
;****              ****
;HL=Quigs Form Number
.Quig_Form_Close:
		ld		a,255
		ld		de,Quig_FormIDs					;**** 8 Forms held as Symbos Window numbers
		add		hl,de							;**** Works out place
		ld		c,(hl)							;**** C = Symbos Window number
		cp		c
		ret  	z
		ld		(hl),a							;**** Blank window
		ld		a,c								;**** A= Symbos window number
		ld 		c,MSC_DSK_WINCLS				;**** Close
        jp		SyDesktop_SendMessage		


.Quig_Form_CloseEvent
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch
		ld		a,e		
		ld		c,2								;**** C = 3/4 etc
		call	SyB_Call_Form_Event
		jp		Quig_Control_Loop_1	
		

;****                       ****
;**** Check If Event and Do ****
;****                       ****
;A=Form No C=Event To search
.SyB_Call_Form_Event:
		call	Quig_GetWindowEventAddr
		Xor		a
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		cp		e		
		jr		nz,SyB_Call_Form_Event_2	
		cp		d
		ret		z
.SyB_Call_Form_Event_2	
		ld		(SyB_Call_Form_Event_3+1),de
.SyB_Call_Form_Event_3
		call	0
		ret	

;**** Get a Internal Window number in a
;IN A = Window
;OUT A = Symbos Window number or #ff
;    HL =  address of Internal window stoe
.Quig_Form_Return
;		ld		(Quig_Form_No),a				;**** Store the number of the Internal Window
		ld		hl,Quig_FormIDs					;**** Point to Start of Window List
		ld		e,a								;**** DE = A
		ld		d,0
		add		hl,de							;**** Calc Position
		ld		a,(hl)							;**** Checks if exists
		ret
;****                                 ****
;**** Get User Form No fro OS Form No ****
;****                                 ****
.Quig_FormSearch:
		ld		a,(Event_Form_ID)
		ld		b,8
		ld		e,0
		ld		hl,Quig_FormIDs	
.Quig_FormSearch_1	
		cp		(hl)
		ret		z
		inc		e
		inc		hl
		djnz	Quig_FormSearch_1
		ret		


;### SRTFIX -> checks for list sort and corrects Quigs addresses of GUI string pointers
;### Input      IX=list record
;### Destroyed  AF,BC,DE,HL,IX,IY
.Quig_srtfix:
		bit 	0,(ix+15)
        ret 	z
        ld 		(ix+15),0
		

		
        ld 		l,(ix+0)
        ld 		h,(ix+1)            ;hl=number of lines
        ld 		e,(ix+4)
        ld 		d,(ix+5)
        push 	de                 	;(sp)=cell records
        ld 		e,(ix+10)
        ld 		d,(ix+11)
        push 	de
        pop 	iy                  ;iy=column records
        ld 		b,(ix+8)            ;b=number of columns
        pop 	ix                  ;ix=cell records
.Quig_srtfix1:
		push 	bc         			;** line loop
        push 	iy
        inc 	ix
        inc 	ix
.Quig_srtfix2:
		ld 		a,(iy+0)     		;** column loop
        and 	#1c
        jr 		nz,Quig_srtfix3
        ld 		e,(ix+0)
        ld 		d,(ix+1)
        dec 	de                  ;**??** IS THAT HERE??
		dec		de
		dec		de
        ld 		a,ixh
        ld 		(de),a              ;correct address-H
        dec 	de
        ld 		a,ixl
        ld 		(de),a              ;correct address-L
.Quig_srtfix3:
		inc 	ix
        inc 	ix
        ld 		de,8
        add 	iy,de
        djnz 	Quig_srtfix2
        pop 	iy
        pop 	bc
        dec 	hl
        ld 		a,l
        or 		h
        jr 		nz,Quig_srtfix1
        ret


;******************************************************************************
;*** Name           System_CallFunction
;*** Input          ((SP+0)) = System manager command
;***                ((SP+1)) = Function ID
;***                AF,BC,DE,HL,IX,IY = Input for the function
;*** Output         AF,BC,DE,HL,IX,IY = Output from the function
;*** Destroyed      -
;*** Description    Calls a function via the system manager. This function is
;***                needed to have access to the file manager.
;******************************************************************************
.SySystem_CallFunction
		ld (AppMsgB+04),bc      ;copy registers into the message buffer
        ld (AppMsgB+06),de
        ld (AppMsgB+08),hl
        ld (AppMsgB+10),ix
        ld (AppMsgB+12),iy
        push af
        pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ld (AppMsgB+00),de      ;module und funktion number
        ld a,e
        ld (SyCallN),a
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #10                 ;send message
.SyCall1 rst #30
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #18                 ;wait for answer
        db #dd:dec l
        jr nz,SyCall1
        ld a,(AppMsgB)
        sub 128
        ld e,a
        ld a,(SyCallN)
        cp e
        jr nz,SyCall1
        ld hl,(AppMsgB+02)      ;get registers out of the message buffer
        push hl
        pop af
        ld bc,(AppMsgB+04)
        ld de,(AppMsgB+06)
        ld hl,(AppMsgB+08)
        ld ix,(AppMsgB+10)
        ld iy,(AppMsgB+12)
        ret
.SyCallN db 0		
		
;**** A = Window 0-7
;**** C = 0 = Data Begin Address
;****     1 = Open Event Address
;****     2 = Close Event Address
;****     3 = Resize Event Address
;****     4 = Main Loop Address
.Quig_GetWindowEventAddr
		add		a				;Times 2
		add		a				;Times 4
		add		a				;Times 8
		add		c				;Event
		add		a				;Times 16 + (Event*2)
		ld		hl,App_Form_List
		ld		e,a
		ld		d,0
		add		hl,de
		ret

;.Quig_Form_No:				db	0
.Quig_FormIDs:				db  255,255,255,255,255,255,255,255
.Quig_FormClickOff:			db  0,0,0,0,0,0,0,0

.Quig_Directory_Error_Byte:		db	0
.Quig_String_Buffer_Area_Start 	equ AppTrnEnd+260
.Quig_String_Buffer_Top			equ AppTrnEnd+260+AppTrnLen2
.Quig_String_Buffer_StackNo:	dw 0
.Quig_String_Buffer_Pos:		dw AppTrnEnd+260
.Quig_String_Buffer_Stack:		dw AppTrnEnd+260,0,0,0,0,0,0,0,0,0
.Quig_String_AS_HByte:			db 0
.Quig_String_Pos:				dw Quig_String_End_Text+4
		
.ErrorNum:					dw	0
.ErrorPC:					dw	0
.False:						db	0
.True:						db	1
.tcounter					dw	0





	
	
QUIGLINE 1
; Quigs 1.01 Application for Symbos
QUIGLINE 2
; Name: Dot Box
QUIGLINE 3
; Coder:TMTLOGIC
QUIGLINE 4
; Date / Version: v2
QUIGLINE 5

QUIGLINE 6
;----------------------------------------------------------------------------------------------------------
QUIGLINE 7

QUIGLINE 8
// === var IO R/Sf3 ===
QUIGLINE 9

QUIGLINE 10
Var ioA_0:int
QUIGLINE 11
Var ioA_1:int
QUIGLINE 12
Var ioA_2:int
QUIGLINE 13
Var ioA_3:int
QUIGLINE 14
Var ioA_4:int
QUIGLINE 15
Var ioA_5:int
QUIGLINE 16
Var ioA_6:int
QUIGLINE 17
Var ioA_7:int
QUIGLINE 18
Var ioA_8:int
QUIGLINE 19
Var ioA_9:int
QUIGLINE 20
Var ioA_A:int
QUIGLINE 21
Var ioA_B:int
QUIGLINE 22
Var ioA_C:int
QUIGLINE 23
Var ioA_D:int
QUIGLINE 24
Var ioA_E:int
QUIGLINE 25
Var ioA_F:int
QUIGLINE 26

QUIGLINE 27
Var resp				:Int =0					// response value of the SF3
QUIGLINE 28

QUIGLINE 29

QUIGLINE 30

QUIGLINE 31
//------------------------------------------------------------------------------------------------------------
QUIGLINE 32
// === Defines ===
QUIGLINE 33

QUIGLINE 34

QUIGLINE 35
Var defNetStatusBitTx:byte		= 128	//=1 Tx Buffer is full
QUIGLINE 36
Var defNetStatusBitRx:byte		= 64	//=1 Data to read
QUIGLINE 37

QUIGLINE 38
Var defNetStatusBitError:byte	= 32	//=0 then no Errors 
QUIGLINE 39
Var defNetStatusBitVoip:byte	= 16	//'=0 then voip not active 
QUIGLINE 40
Var defNetStatusBitUser:byte	=  8	//'=0 then no user changes online/offline 
QUIGLINE 41
Var defNetStatusBitShMem:byte	=  4	//'=0 then no memory share changes 
QUIGLINE 42
Var defNetStatusBitMsg:byte		=  2	//'=0 then no new messages 
QUIGLINE 43
Var defNetStatusBitSys:byte		=  1	//'=0 then no system response data
QUIGLINE 44

QUIGLINE 45
Var defTileEmpty:int = 0
QUIGLINE 46
Var defTileHori:int  = 1
QUIGLINE 47
Var defTileVert:int  = 2
QUIGLINE 48
Var defTileBox:int   = 3
QUIGLINE 49
Var defTileDot:int   = 4
QUIGLINE 50

QUIGLINE 51
var defVoipIdle:int				=0		// rust
QUIGLINE 52
var defVoipOutgoingCall:int		=1		// je hoort dat het overgaat
QUIGLINE 53
var defVoipOtherBusy:int		=2		// je hoort dat de lijn bezet is
QUIGLINE 54
var defVoipOtherOffline:int		=3		// je hoort dat de persoon waarmee je wil bellen niet online is
QUIGLINE 55
var defVoipIncommingCall:int	=4		// iemand beld je dus de ringtone moet overgaan
QUIGLINE 56
var defVoipActiveCall:int		=5		// Bellen actief ,Mic is running
QUIGLINE 57

QUIGLINE 58
//------------------------------------------------------------------------------------------------------------
QUIGLINE 59
// === var system ===
QUIGLINE 60

QUIGLINE 61
Var strHardware:string = "NONE" 			// RSF3/SF3
QUIGLINE 62
Var strCPU:string		 					// EP CPC MSX
QUIGLINE 63
Var strFirmware:String = "20250121"			// ARM Firmware  needed
QUIGLINE 64
Var sText:String
QUIGLINE 65

QUIGLINE 66
Var iStpStartup:Int=0
QUIGLINE 67

QUIGLINE 68
Var intDelay:Int=2
QUIGLINE 69
Var intDelayCt:Int=0
QUIGLINE 70

QUIGLINE 71
Var sDb:String
QUIGLINE 72
var dbStp:int
QUIGLINE 73
var iDbL:int
QUIGLINE 74
var iDbT:int
QUIGLINE 75
var iDbC:int
QUIGLINE 76

QUIGLINE 77
var iAppExit:int=0
QUIGLINE 78

QUIGLINE 79
var iTimeOut:int = 0
QUIGLINE 80

QUIGLINE 81
var fc:int
QUIGLINE 82
var fn:int
QUIGLINE 83
var fx:int
QUIGLINE 84
var fy:int
QUIGLINE 85
var fsw:int
QUIGLINE 86

QUIGLINE 87
Var u8In1:Int
QUIGLINE 88
Var u8In2:Int
QUIGLINE 89

QUIGLINE 90
Var u8Out1:Int
QUIGLINE 91
Var u8Out2:Int
QUIGLINE 92
Var u8Out3:Int
QUIGLINE 93
Var u8Out4:Int
QUIGLINE 94
Var u8Out5:Int
QUIGLINE 95

QUIGLINE 96
Var u16In1:Int
QUIGLINE 97

QUIGLINE 98
Var u16Out1:Int
QUIGLINE 99
Var u16Out2:Int
QUIGLINE 100
Var u16Out3:Int
QUIGLINE 101
Var u16Out4:Int
QUIGLINE 102
Var u16Out5:Int
QUIGLINE 103
Var u16Out6:Int
QUIGLINE 104
Var u16Out7:Int
QUIGLINE 105
Var u16Out8:Int
QUIGLINE 106

QUIGLINE 107
Var strIn1:String
QUIGLINE 108

QUIGLINE 109
Var strOut1:String
QUIGLINE 110
Var strOut2:String
QUIGLINE 111
Var strOut3:String
QUIGLINE 112
Var strOut4:String
QUIGLINE 113
//------------------------------------------------------------------------------------------------------------
QUIGLINE 114
//	=== var Diverse ===
QUIGLINE 115

QUIGLINE 116
Var a:int
QUIGLINE 117
Var	t       :int
QUIGLINE 118
Var c		:Int
QUIGLINE 119
Var y		:Int = 0
QUIGLINE 120
Var x		:Int = 0
QUIGLINE 121
Var l		:int
QUIGLINE 122
var v:int
QUIGLINE 123
Var lt :int
QUIGLINE 124
Var lv :int
QUIGLINE 125
Var u16Ur:int
QUIGLINE 126
Var lc:int
QUIGLINE 127
Var li:Int
QUIGLINE 128

QUIGLINE 129
Var bSw:Int
QUIGLINE 130

QUIGLINE 131

QUIGLINE 132

QUIGLINE 133

QUIGLINE 134
;------------------------------------------------------------------------------------------------------------
QUIGLINE 135
;	=== Chat ===
QUIGLINE 136

QUIGLINE 137
Var strChatText(4):String	// 'row 1-4 text	histort old..
QUIGLINE 138
Var strChatInp:String		// 'input field
QUIGLINE 139

QUIGLINE 140
Var u8FifoIn:Int
QUIGLINE 141
Var u8FifoOut:Int
QUIGLINE 142
Var u8FifoContent:Byte
QUIGLINE 143
Var u16Fd(13):Int			//destination ID
QUIGLINE 144
Var strFm(13):String		//string Message 
QUIGLINE 145
Var strTm:String
QUIGLINE 146
Var strMs:String
QUIGLINE 147

QUIGLINE 148
Var u16Du:Int
QUIGLINE 149
Var u8Key:Int
QUIGLINE 150

QUIGLINE 151
;-------------------------------------------------------------------------------------------------
QUIGLINE 152
//	=== Sheets ===
QUIGLINE 153

QUIGLINE 154
Var shDD_dot:Sheet
QUIGLINE 155
Var shDD_hori:Sheet
QUIGLINE 156
Var shDD_vert:Sheet
QUIGLINE 157
Var shDD_fill:Sheet
QUIGLINE 158
Var shDD_start:Sheet
QUIGLINE 159
Var shDD_digi:Sheet
QUIGLINE 160
Var shDD_voip:Sheet
QUIGLINE 161

QUIGLINE 162
Var ImgIds(123):Int
QUIGLINE 163
Var ImgTile(132):Int
QUIGLINE 164
Var ImgTileCom(150):Int
QUIGLINE 165

QUIGLINE 166

QUIGLINE 167
//------------------------------------------------------------------------------------------------------------
QUIGLINE 168
//	=== GAME var ===
QUIGLINE 169

QUIGLINE 170

QUIGLINE 171

QUIGLINE 172
var iButChoise:int
QUIGLINE 173
var iSelImg:int
QUIGLINE 174

QUIGLINE 175
Var iGameMode:int = 0
QUIGLINE 176
var iWinner:int
QUIGLINE 177
var iPlayer:int	
QUIGLINE 178
var iPlayerActive:int
QUIGLINE 179
var bRestart:int = 0
QUIGLINE 180
var bExit:int = 0
QUIGLINE 181
Var iRecPointer:int=0
QUIGLINE 182

QUIGLINE 183
Var	u16PlayerList(3):int
QUIGLINE 184

QUIGLINE 185
Var u16OtherID:int
QUIGLINE 186

QUIGLINE 187
var iScore(3):int
QUIGLINE 188

QUIGLINE 189
var bNew_field:int=0
QUIGLINE 190
var bAgain:int = 0
QUIGLINE 191
var bReSend:int = 0
QUIGLINE 192
var iFlash:int
QUIGLINE 193
var iFlashCt:int=0
QUIGLINE 194

QUIGLINE 195
//------------------------------------------------------------------------------------------------------------
QUIGLINE 196
// === TMT-NET21 ===
QUIGLINE 197

QUIGLINE 198
Var strAppname		:String
QUIGLINE 199
Var u16MyUserID		:Int = 0
QUIGLINE 200
Var strUserPass		:String
QUIGLINE 201
Var strPlayerName(3):string
QUIGLINE 202

QUIGLINE 203
Var u16UserOnline(20)	:int
QUIGLINE 204
Var	iUserOnlineTotal	:int
QUIGLINE 205

QUIGLINE 206
Var	u8NetStatus:int
QUIGLINE 207

QUIGLINE 208
Var u8h:int
QUIGLINE 209
Var u8l:int
QUIGLINE 210
Var u8d:int
QUIGLINE 211

QUIGLINE 212
Var w:int
QUIGLINE 213

QUIGLINE 214
var iUserOnlineTimer :int = 0
QUIGLINE 215

QUIGLINE 216
;-------------------------------------------------------------------------------------------------
QUIGLINE 217
; === var SEONE
QUIGLINE 218

QUIGLINE 219
var sAtCmd:string
QUIGLINE 220
var sAtResp:string
QUIGLINE 221
var sAtData:string
QUIGLINE 222

QUIGLINE 223
;-------------------------------------------------------------------------------------------------
QUIGLINE 224
; === var VOIP
QUIGLINE 225

QUIGLINE 226
var iVoipChgCt:int
QUIGLINE 227
var iVoipStatus:int
QUIGLINE 228
var iVoipStatusOld:int
QUIGLINE 229
var u16OtherUserId:int
QUIGLINE 230
var iVoipSoundSelect:int=0
QUIGLINE 231
var iVoipSoundCt:int
QUIGLINE 232
var iVoipSoundSeq:int
QUIGLINE 233
var iUserOnlinePointer:int
QUIGLINE 234
var iDelayVoipCt:int
QUIGLINE 235
;------------------------------------------------------------------------------------------------------------
QUIGLINE 236

QUIGLINE 237

QUIGLINE 238
;---	FORM 1 field play field
QUIGLINE 239

QUIGLINE 240
Function Form1.Open.Event:Void()
QUIGLINE 241
EndF
QUIGLINE 242

QUIGLINE 243
Function Form1.Close.Event:Void()
QUIGLINE 244
	iAppExit = 1
QUIGLINE 245
EndF
QUIGLINE 246

QUIGLINE 247
;---	FORM 1 buttons
QUIGLINE 248

QUIGLINE 249
;--- 	FORM1 Events
QUIGLINE 250

QUIGLINE 251
Function Label14.Event:Void()
QUIGLINE 252
	bRestart = 1
QUIGLINE 253
Endf
QUIGLINE 254

QUIGLINE 255
Function Label15.Event:Void()
QUIGLINE 256
	iFlash = #23
QUIGLINE 257
endf
QUIGLINE 258

QUIGLINE 259
Function Image.Event:Void()
QUIGLINE 260
	if (iPlayer = iPlayerActive) then 
QUIGLINE 261
		CrtlEventToImg
QUIGLINE 262
	endif
QUIGLINE 263
Endf
QUIGLINE 264

QUIGLINE 265
Function ImageVoipRed.Event:Void()
QUIGLINE 266
	VoipRedButton
QUIGLINE 267
endf
QUIGLINE 268

QUIGLINE 269
Function ImageVoipGreen.Event:Void()
QUIGLINE 270
	VoipGreenButton
QUIGLINE 271
endf
QUIGLINE 272

QUIGLINE 273
;---	FORM 2 field  Choice user
QUIGLINE 274

QUIGLINE 275
Function Form2.Open.Event:Void()
QUIGLINE 276
endf
QUIGLINE 277

QUIGLINE 278
Function Form2.Close.Event:Void()
QUIGLINE 279
	iAppExit = 1
QUIGLINE 280
EndF
QUIGLINE 281

QUIGLINE 282
;---	FORM 2 buttons
QUIGLINE 283
;---	FORM 2 Events 
QUIGLINE 284

QUIGLINE 285
Function label21.Event:Void()
QUIGLINE 286
	iButChoise = 1
QUIGLINE 287
	if (iStpStartup = 120) and (iUserOnlineTotal > 0) then 
QUIGLINE 288
		Label21.Colour.Set Colour.Black,colour.Yellow,1
QUIGLINE 289
		Label21.refresh
QUIGLINE 290
		intDelay = 20
QUIGLINE 291
		intDelayCt = 0
QUIGLINE 292
	endif
QUIGLINE 293
	
QUIGLINE 294
endf
QUIGLINE 295

QUIGLINE 296
Function label22.Event:Void()
QUIGLINE 297
	iButChoise = 2
QUIGLINE 298
	if (iStpStartup = 120) and (iUserOnlineTotal > 1) then 
QUIGLINE 299
		Label22.Colour.Set Colour.Black,colour.Yellow,1
QUIGLINE 300
		Label22.refresh
QUIGLINE 301
		intDelay = 20
QUIGLINE 302
		intDelayCt = 0
QUIGLINE 303
	endif
QUIGLINE 304
endf
QUIGLINE 305

QUIGLINE 306
Function label23.Event:Void()
QUIGLINE 307
	iButChoise = 3
QUIGLINE 308

QUIGLINE 309
	if (iStpStartup = 120) and (iUserOnlineTotal > 2) then 
QUIGLINE 310
		Label23.Colour.Set Colour.Black,colour.Yellow,1
QUIGLINE 311
		Label23.refresh
QUIGLINE 312
		intDelay = 20
QUIGLINE 313
		intDelayCt = 0
QUIGLINE 314
	endif
QUIGLINE 315

QUIGLINE 316
endf
QUIGLINE 317

QUIGLINE 318
Function label24.Event:Void()
QUIGLINE 319
	iButChoise = 4
QUIGLINE 320
	if (iStpStartup = 120) and (iUserOnlineTotal > 3) then 
QUIGLINE 321
		Label24.Colour.Set Colour.Black,colour.Yellow,1
QUIGLINE 322
		Label24.refresh
QUIGLINE 323
		intDelay = 20
QUIGLINE 324
		intDelayCt = 0
QUIGLINE 325
	endif
QUIGLINE 326

QUIGLINE 327
endf
QUIGLINE 328

QUIGLINE 329
Function label25.Event:Void()
QUIGLINE 330
	iButChoise = 5
QUIGLINE 331
	if (iStpStartup = 120) and (iUserOnlineTotal > 4) then 
QUIGLINE 332
		Label25.Colour.Set Colour.Black,colour.Yellow,1
QUIGLINE 333
		Label25.refresh
QUIGLINE 334
		intDelay = 20
QUIGLINE 335
		intDelayCt = 0
QUIGLINE 336
	endif
QUIGLINE 337

QUIGLINE 338
endf
QUIGLINE 339

QUIGLINE 340

QUIGLINE 341
;---	FORM 3 Not used
QUIGLINE 342

QUIGLINE 343
;---	FORM 4 field Start ---
QUIGLINE 344

QUIGLINE 345
Function Form4.Open.Event:Void()
QUIGLINE 346
		Initialize
QUIGLINE 347
endf
QUIGLINE 348

QUIGLINE 349
Function Form4.Close.Event:Void()
QUIGLINE 350
	iAppExit = 1
QUIGLINE 351
EndF
QUIGLINE 352

QUIGLINE 353
;---	FORM 4 buttons
QUIGLINE 354

QUIGLINE 355
Function Button41.Event:Void()
QUIGLINE 356
	iStpStartup = 10
QUIGLINE 357
endf
QUIGLINE 358

QUIGLINE 359

QUIGLINE 360

QUIGLINE 361

QUIGLINE 362
Function Initialize:Void()
QUIGLINE 363

QUIGLINE 364
	sys_IO_init
QUIGLINE 365
	
QUIGLINE 366
	u8In1 = 0
QUIGLINE 367
	F72_26
QUIGLINE 368
	strHardware = strOut1
QUIGLINE 369
	
QUIGLINE 370
	//if (strHardware = "RSF3")  then 
QUIGLINE 371
		
QUIGLINE 372
	sAtCmd = "AT+SEMODE=VOICE":ATCmd
QUIGLINE 373
	//endif
QUIGLINE 374
	
QUIGLINE 375
	F131_39
QUIGLINE 376
	
QUIGLINE 377
	strAppname = "DOTBOX"
QUIGLINE 378
	
QUIGLINE 379
	shDD_start.Load(App.Path+"dd_start.qs1")
QUIGLINE 380
	Image410.Tile.Set shDD_start,0
QUIGLINE 381
	Image410.Refresh
QUIGLINE 382

QUIGLINE 383
	Button41.text.set "Loading..0%"
QUIGLINE 384
	Button41.refresh
QUIGLINE 385

QUIGLINE 386

QUIGLINE 387
	sText = " " + strCPU + " " + strHardware + " [" + App.Date + "]"
QUIGLINE 388
	Form4.status.text.set sText
QUIGLINE 389
	Form4.status.refresh
QUIGLINE 390

QUIGLINE 391

QUIGLINE 392
	shDD_dot.Load(App.Path+"dd_dot.qs2")
QUIGLINE 393
	Button41.text.set "Loading..10%" :Button41.refresh
QUIGLINE 394

QUIGLINE 395
	shDD_hori.Load(App.Path+"dd_hori.qs2")
QUIGLINE 396
	Button41.text.set "Loading..30%" :Button41.refresh
QUIGLINE 397

QUIGLINE 398
	shDD_vert.Load(App.Path+"dd_vert.qs2")
QUIGLINE 399
	Button41.text.set "Loading..50%" :Button41.refresh
QUIGLINE 400

QUIGLINE 401
	shDD_fill.Load(App.Path+"dd_fill.qs2")
QUIGLINE 402
	Button41.text.set "Loading..60%" :Button41.refresh
QUIGLINE 403

QUIGLINE 404
	shDD_digi.Load(App.Path+"dd_digi.qs2")
QUIGLINE 405
	Button41.text.set "Loading..80%" :Button41.refresh
QUIGLINE 406

QUIGLINE 407
	shDD_voip.Load(App.Path+"dd_voip.qs2")
QUIGLINE 408
	Button41.text.set "Loading..100%" :Button41.refresh
QUIGLINE 409

QUIGLINE 410
	Button41.text.set "START" :Button41.refresh
QUIGLINE 411
	
QUIGLINE 412
	Randomize ((Time.Hour.Get * 360) + (Time.Minute.Get * 60) + (Time.Second.Get))
QUIGLINE 413
	
QUIGLINE 414
	iGameMode = 0
QUIGLINE 415
	
QUIGLINE 416
		If Sound.Init = 0 Then
QUIGLINE 417
			sText = left(App.Path,1) + ":\soundd.exe"
QUIGLINE 418
			a = Execute(sText)			// Start netd local if not open
QUIGLINE 419
			a = Sound.Init
QUIGLINE 420
		
QUIGLINE 421
			sDb="Sound.Init" :sysDebug
QUIGLINE 422
	EndIf
QUIGLINE 423
EndF
QUIGLINE 424

QUIGLINE 425

QUIGLINE 426

QUIGLINE 427
;------------------------------------------------------------------------------------------------------------
QUIGLINE 428
;	=== Main
QUIGLINE 429

QUIGLINE 430
Function Main:Void()
QUIGLINE 431
	
QUIGLINE 432
	intDelayCt = intDelayCt + 1
QUIGLINE 433
	If intDelayCt < intDelay Then
QUIGLINE 434
		Return
QUIGLINE 435
	EndIf
QUIGLINE 436
	intDelayCt = 0
QUIGLINE 437
	
QUIGLINE 438
	if iAppExit > 0 then 
QUIGLINE 439
		symAppExit
QUIGLINE 440
	endif
QUIGLINE 441
	
QUIGLINE 442
	If  iGameMode = 1 Then
QUIGLINE 443
		
QUIGLINE 444
		chat_handler
QUIGLINE 445
		
QUIGLINE 446
		net21_rec_loop
QUIGLINE 447
	
QUIGLINE 448
		if (iSelImg > 0) and (iPlayer = iPlayerActive)  then 
QUIGLINE 449
			game_press_select
QUIGLINE 450
		endif
QUIGLINE 451
		
QUIGLINE 452
		if (bNew_field = 1) then 
QUIGLINE 453
			game_new_field
QUIGLINE 454
		endif
QUIGLINE 455

QUIGLINE 456
		if (bRestart = 1) then 
QUIGLINE 457
			game_replay
QUIGLINE 458
		endif
QUIGLINE 459
		
QUIGLINE 460
		if (iWinner > 0 ) then 
QUIGLINE 461
			iFlash = shl4(iWinner) or  3
QUIGLINE 462
			
QUIGLINE 463
			if (iWinner = iPlayer) then 
QUIGLINE 464
				label6.text.set "--- You are Winner !!!! ---"
QUIGLINE 465
				label6.refresh
QUIGLINE 466
			else
QUIGLINE 467
				label6.text.set "--- You lost !!!! ---"
QUIGLINE 468
				label6.refresh
QUIGLINE 469
			endif
QUIGLINE 470
			iWinner = 0
QUIGLINE 471
		endif
QUIGLINE 472
		
QUIGLINE 473
		if (iFlash > 0 ) then 
QUIGLINE 474
			iFlashCt = iFlashCt + 1
QUIGLINE 475
			if (iFlashCt = 21) then 
QUIGLINE 476
				iFlashCt = 1
QUIGLINE 477
			endif
QUIGLINE 478
			
QUIGLINE 479
			if (iFlashCt = 10) or (iFlashCt = 20)then 
QUIGLINE 480
				flashing
QUIGLINE 481
			endif
QUIGLINE 482
		endif
QUIGLINE 483
		
QUIGLINE 484
		VoipHandler
QUIGLINE 485
		VoipSoundHandler
QUIGLINE 486
		
QUIGLINE 487
		return
QUIGLINE 488
	endif
QUIGLINE 489
	
QUIGLINE 490
	stpStartup
QUIGLINE 491
EndF
QUIGLINE 492

QUIGLINE 493

QUIGLINE 494
Function symAppExit:void()
QUIGLINE 495

QUIGLINE 496
		sDb = "App exit":sysDebug 
QUIGLINE 497
		
QUIGLINE 498
		if iAppExit = 1 then 
QUIGLINE 499
			Form1.open
QUIGLINE 500
			F131_39
QUIGLINE 501
			iAppExit = 2
QUIGLINE 502
		endif	
QUIGLINE 503

QUIGLINE 504
		if iAppExit = 2 then 
QUIGLINE 505
			shDD_dot.free
QUIGLINE 506
			shDD_hori.free
QUIGLINE 507
			shDD_vert.free
QUIGLINE 508
			shDD_start.free
QUIGLINE 509
			shDD_digi.free
QUIGLINE 510
			shDD_voip.free
QUIGLINE 511
			App.exit
QUIGLINE 512
			iAppExit = 3
QUIGLINE 513
		endif	
QUIGLINE 514
endf
QUIGLINE 515

QUIGLINE 516
//*****************************************************************************************
QUIGLINE 517
							
QUIGLINE 518
Function chat_init:void()
QUIGLINE 519
endf
QUIGLINE 520

QUIGLINE 521
Function chat_handler:void()
QUIGLINE 522
	
QUIGLINE 523
	u8NetStatus = IO.In(ioA_A)
QUIGLINE 524
		if ((u8NetStatus and defNetStatusBitMsg) > 0)	then 
QUIGLINE 525
		chat_recvTxt
QUIGLINE 526
	endif
QUIGLINE 527
	
QUIGLINE 528
	If Event.Type = 16 Then
QUIGLINE 529
		u8Key = Event.KeyPressed
QUIGLINE 530

QUIGLINE 531
		if (u8Key = 8) then 						//BS
QUIGLINE 532
			se1_PlayTick
QUIGLINE 533
			chat_del
QUIGLINE 534
		Endif
QUIGLINE 535

QUIGLINE 536
		if (u8Key = 13) then 						//Enter  
QUIGLINE 537
			se1_PlayTick
QUIGLINE 538
			chat_send
QUIGLINE 539
		Endif
QUIGLINE 540

QUIGLINE 541
		if ((u8Key > 31) and (u8Key < 126)) then 	//AscII 
QUIGLINE 542
			se1_PlayTick
QUIGLINE 543
			chat_printChar
QUIGLINE 544
			
QUIGLINE 545
		Endif
QUIGLINE 546
	Endif
QUIGLINE 547
	
QUIGLINE 548
	chat_sendMsg
QUIGLINE 549
endf
QUIGLINE 550

QUIGLINE 551

QUIGLINE 552
Function chat_scroll:void()
QUIGLINE 553
	
QUIGLINE 554
	//	'scroll without input field
QUIGLINE 555
	
QUIGLINE 556
	strChatText(5) = strChatText(4)
QUIGLINE 557
	strChatText(4) = strChatText(3)
QUIGLINE 558
	strChatText(3) = strChatText(2)
QUIGLINE 559
	
QUIGLINE 560
	Label5.Text.Set	strChatText(5)
QUIGLINE 561
	Label5.Refresh	
QUIGLINE 562
	
QUIGLINE 563
	Label4.Text.Set	strChatText(4)
QUIGLINE 564
	Label4.Refresh	
QUIGLINE 565
	
QUIGLINE 566
	Label3.Text.Set	strChatText(3)
QUIGLINE 567
	Label3.Refresh	
QUIGLINE 568

QUIGLINE 569
EndF
QUIGLINE 570
	
QUIGLINE 571

QUIGLINE 572
Function chat_recvTxt:void()
QUIGLINE 573

QUIGLINE 574
//	'------ Print recv text message 
QUIGLINE 575

QUIGLINE 576
	chat_scroll
QUIGLINE 577
	
QUIGLINE 578
	F131_22
QUIGLINE 579
				
QUIGLINE 580
	strChatText(2) = strTm
QUIGLINE 581
	Label2.Text.Set	strChatText(2)
QUIGLINE 582
	Label2.Refresh
QUIGLINE 583
	
QUIGLINE 584
	se1_PlayBell
QUIGLINE 585
EndF
QUIGLINE 586

QUIGLINE 587
Function chat_del:void()
QUIGLINE 588
	
QUIGLINE 589
//	'DEL  key
QUIGLINE 590

QUIGLINE 591
	
QUIGLINE 592
	if len (strMs) = 0 then 
QUIGLINE 593
		sDb = "Input string empty"
QUIGLINE 594
		sysDebug
QUIGLINE 595
		return
QUIGLINE 596
	Endif
QUIGLINE 597
	
QUIGLINE 598

QUIGLINE 599
	l = Len(strMs) - 1
QUIGLINE 600
	strMs = Left(strMs,l)
QUIGLINE 601
	
QUIGLINE 602
	strChatInp =  strMs
QUIGLINE 603
	Label1.Text.Set  strChatInp
QUIGLINE 604
	Label1.Refresh
QUIGLINE 605
EndF
QUIGLINE 606

QUIGLINE 607

QUIGLINE 608
Function chat_printChar:void()
QUIGLINE 609

QUIGLINE 610
	if len(strMs) > 50 then 
QUIGLINE 611
		sDb = "Input string too  long > 50"
QUIGLINE 612
		sysDebug
QUIGLINE 613
		return
QUIGLINE 614
	EndIf
QUIGLINE 615

QUIGLINE 616
	strMs = strMs + Chr(u8Key)
QUIGLINE 617
	
QUIGLINE 618
	strChatInp =  strMs
QUIGLINE 619
	Label1.Text.Set  strChatInp
QUIGLINE 620
	Label1.Refresh
QUIGLINE 621

QUIGLINE 622
	//Label4.Text.Set  str(u8Key)
QUIGLINE 623
	//Label4.Refresh
QUIGLINE 624
	
QUIGLINE 625
EndF
QUIGLINE 626

QUIGLINE 627
Function chat_ClearInput:void()
QUIGLINE 628

QUIGLINE 629
//	'Clear input string 
QUIGLINE 630
	
QUIGLINE 631
	strMs = ""
QUIGLINE 632
	strChatInp =  strMs
QUIGLINE 633
	Label1.Text.Set  strChatInp
QUIGLINE 634
	Label1.Refresh
QUIGLINE 635
EndF
QUIGLINE 636

QUIGLINE 637
Function chat_send:void()
QUIGLINE 638

QUIGLINE 639
	chat_scroll
QUIGLINE 640
							
QUIGLINE 641
	strChatText(2) = str(u16MyUserID) + " "+strMs
QUIGLINE 642
	Label2.Text.Set	strChatText(2)
QUIGLINE 643
	Label2.Refresh
QUIGLINE 644
		
QUIGLINE 645
	strMs = strMs + Chr(13)
QUIGLINE 646
	
QUIGLINE 647
	u16Du = u16OtherID
QUIGLINE 648
	chat_fifo_in
QUIGLINE 649
	
QUIGLINE 650
	chat_ClearInput
QUIGLINE 651
EndF
QUIGLINE 652
							
QUIGLINE 653

QUIGLINE 654
Function chat_sendMsg:void()
QUIGLINE 655
	
QUIGLINE 656
	F131_21
QUIGLINE 657
	
QUIGLINE 658
	//	'if (r = 0) and (fc > 0 ) then gosub chat_sendMsg
QUIGLINE 659
	
QUIGLINE 660
	if (u8Out1 > 0) or (u8FifoContent = 0 ) then 
QUIGLINE 661
		return
QUIGLINE 662
	EndIf
QUIGLINE 663
	
QUIGLINE 664
	chat_fifo_out
QUIGLINE 665
	
QUIGLINE 666
	If u16Du = u16MyUserID then
QUIGLINE 667
		return
QUIGLINE 668
	EndIf
QUIGLINE 669
	
QUIGLINE 670
	F131_20
QUIGLINE 671
	
QUIGLINE 672
EndF
QUIGLINE 673

QUIGLINE 674
							
QUIGLINE 675
Function chat_fifo_in:void()
QUIGLINE 676

QUIGLINE 677
	if u8FifoContent = 12  then 
QUIGLINE 678
		sDb = "Fifo Full":sysDebug
QUIGLINE 679
		return 
QUIGLINE 680
	EndIf
QUIGLINE 681
		
QUIGLINE 682
	u16Fd(u8FifoIn) = u16Du
QUIGLINE 683
	
QUIGLINE 684
	strFm(u8FifoIn) = strMs
QUIGLINE 685
	
QUIGLINE 686
	u8FifoIn = u8FifoIn + 1
QUIGLINE 687
	
QUIGLINE 688
	//sDb = "fifo in: "+strFm(u8FifoIn)+" pos: "+str(u8FifoIn):sysDebug
QUIGLINE 689
	
QUIGLINE 690
	
QUIGLINE 691
	if u8FifoIn = 13 then 
QUIGLINE 692
		u8FifoIn = 0
QUIGLINE 693
	Endif
QUIGLINE 694
		
QUIGLINE 695
	u8FifoContent = u8FifoContent + 1
QUIGLINE 696
EndF
QUIGLINE 697

QUIGLINE 698
Function chat_fifo_out:void()
QUIGLINE 699

QUIGLINE 700
	if u8FifoContent = 0  then 
QUIGLINE 701
		//sDb = "fifo out , Fifo is empty":sysDebug
QUIGLINE 702
	endif	
QUIGLINE 703
	
QUIGLINE 704
	strIn1 = strFm(u8FifoOut)
QUIGLINE 705
	
QUIGLINE 706
	u16Du = u16Fd(u8FifoOut)
QUIGLINE 707
	
QUIGLINE 708
	u8FifoOut = u8FifoOut + 1
QUIGLINE 709
	
QUIGLINE 710
	if u8FifoOut = 13 then 
QUIGLINE 711
		u8FifoOut = 0
QUIGLINE 712
	endif
QUIGLINE 713
	
QUIGLINE 714
	u8FifoContent = u8FifoContent - 1
QUIGLINE 715
	
QUIGLINE 716
EndF
QUIGLINE 717

QUIGLINE 718
Function game_begin:void()
QUIGLINE 719
	
QUIGLINE 720
	intDelay = 2
QUIGLINE 721
	
QUIGLINE 722
	imageVoipGreen.tile.set shDD_voip,0 :imageVoipGreen.refresh
QUIGLINE 723
	imageVoipRed.tile.set shDD_voip,1 	:imageVoipRed.Refresh
QUIGLINE 724
	labelVoip.text.set "" :labelVoip.refresh
QUIGLINE 725
	
QUIGLINE 726
	sText ="Version: "+app.date
QUIGLINE 727
	Label5.Text.Set	sText
QUIGLINE 728
	Label5.Refresh	
QUIGLINE 729
	
QUIGLINE 730
	if (u16MyUserID < u16OtherID) then
QUIGLINE 731
		iPlayer = 1
QUIGLINE 732
		u16PlayerList(1) = u16MyUserID
QUIGLINE 733
		u16PlayerList(2) = u16OtherID
QUIGLINE 734
		
QUIGLINE 735
	else	
QUIGLINE 736
		iPlayer = 2 
QUIGLINE 737
		u16PlayerList(1) = u16OtherID
QUIGLINE 738
		u16PlayerList(2) = u16MyUserID
QUIGLINE 739
	endif
QUIGLINE 740

QUIGLINE 741
	
QUIGLINE 742
	
QUIGLINE 743
	Label7.Text.Set	Str(u16PlayerList(1))
QUIGLINE 744
	Label7.Refresh	
QUIGLINE 745
	Label8.Text.Set	Str(u16PlayerList(2))
QUIGLINE 746
	Label8.Refresh	
QUIGLINE 747
	
QUIGLINE 748
	u16in1 = u16PlayerList(1)
QUIGLINE 749
	F131_7
QUIGLINE 750
	label10.text.set strOut2
QUIGLINE 751
	label10.refresh
QUIGLINE 752
	label12.text.set strOut2
QUIGLINE 753
	label12.refresh
QUIGLINE 754
	
QUIGLINE 755
	
QUIGLINE 756
	u16in1 = u16PlayerList(2)
QUIGLINE 757
	F131_7
QUIGLINE 758
	label11.text.set strOut2
QUIGLINE 759
	label11.refresh
QUIGLINE 760
	label13.text.set strOut2
QUIGLINE 761
	label13.refresh
QUIGLINE 762
		
QUIGLINE 763
	iFlash = 0
QUIGLINE 764
	iWinner =0
QUIGLINE 765
	bAgain = 0
QUIGLINE 766
	iPlayerActive = 0
QUIGLINE 767
	iScore(1) = 0
QUIGLINE 768
	iScore(2) = 0
QUIGLINE 769
	
QUIGLINE 770
	
QUIGLINE 771
	game_resetField
QUIGLINE 772
	game_score_refresh
QUIGLINE 773
	
QUIGLINE 774
	if (iPlayer = 2) then 
QUIGLINE 775
		iGameMode = 1
QUIGLINE 776
		return
QUIGLINE 777
	endif
QUIGLINE 778
	
QUIGLINE 779
	
QUIGLINE 780
	iPlayerActive = 2
QUIGLINE 781
	net21_send
QUIGLINE 782
	
QUIGLINE 783
	game_showTurn
QUIGLINE 784
	
QUIGLINE 785
	iGameMode = 1
QUIGLINE 786
EndF
QUIGLINE 787

QUIGLINE 788
Function game_replay:void()
QUIGLINE 789
	bRestart = 0
QUIGLINE 790

QUIGLINE 791
	iFlash = 0
QUIGLINE 792
	iWinner =0
QUIGLINE 793
	bAgain = 0
QUIGLINE 794
	iScore(1) = 0
QUIGLINE 795
	iScore(2) = 0
QUIGLINE 796
	iPlayerActive = 2
QUIGLINE 797
	
QUIGLINE 798
	x = Rnd(2) 
QUIGLINE 799
	if (x = 0 ) then 
QUIGLINE 800
		x = 2
QUIGLINE 801
	EndIf
QUIGLINE 802

QUIGLINE 803
	iPlayerActive = x
QUIGLINE 804
	
QUIGLINE 805
	game_resetField
QUIGLINE 806
	game_score_refresh
QUIGLINE 807

QUIGLINE 808
	net21_send
QUIGLINE 809
	game_showTurn
QUIGLINE 810
	
QUIGLINE 811
	strMs = "RePlay game"
QUIGLINE 812
	chat_send
QUIGLINE 813
endf
QUIGLINE 814
						
QUIGLINE 815
Function game_showTurn:void()
QUIGLINE 816
	if (iPlayerActive = 0) then 
QUIGLINE 817
		sDb = "iPlayerActive = 0":sysDebug
QUIGLINE 818

QUIGLINE 819
		Label7.Colour.Set Colour.Black,colour.Orange,1 
QUIGLINE 820
		Label8.Colour.Set Colour.Black,colour.Orange,1 
QUIGLINE 821
		Label6.Text.Set	"Wait...."
QUIGLINE 822
		
QUIGLINE 823
		label6.refresh
QUIGLINE 824
		label7.refresh
QUIGLINE 825
		label8.refresh
QUIGLINE 826
		return
QUIGLINE 827
	endif
QUIGLINE 828
	
QUIGLINE 829
	if (iPlayerActive = 1) then 
QUIGLINE 830
		Label7.Colour.Set Colour.Black,colour.Orange,1 
QUIGLINE 831
		Label8.Colour.Set colour.Orange,Colour.Black,1 
QUIGLINE 832
	else
QUIGLINE 833
		Label7.Colour.Set colour.Orange,Colour.Black,1 
QUIGLINE 834
		Label8.Colour.Set Colour.Black,colour.Orange,1 
QUIGLINE 835
	Endif
QUIGLINE 836
	
QUIGLINE 837
	if (iPlayer = iPlayerActive) then 
QUIGLINE 838
		Label6.Text.Set	"Your turn"
QUIGLINE 839
	else
QUIGLINE 840
		Label6.Text.Set	"Other player"
QUIGLINE 841
	Endif
QUIGLINE 842
	
QUIGLINE 843
	
QUIGLINE 844
	label6.refresh
QUIGLINE 845
	label7.refresh
QUIGLINE 846
	label8.refresh
QUIGLINE 847
EndF
QUIGLINE 848
	
QUIGLINE 849
Function game_press_select:void()
QUIGLINE 850
	sDb="iSelect :"+str(iSelImg):sysDebug
QUIGLINE 851

QUIGLINE 852
	if (ImgTile(iSelImg) < 10)then 
QUIGLINE 853

QUIGLINE 854
		sDb="ImgTile(iSelImg)= " +str(ImgTile(iSelImg))+ "  defTileHori= " +str(defTileHori):sysDebug
QUIGLINE 855
		
QUIGLINE 856
		
QUIGLINE 857
		if (ImgTile(iSelImg)  = defTileHori) then 
QUIGLINE 858
			
QUIGLINE 859
			//sDb="hori ":sysDebug
QUIGLINE 860
			
QUIGLINE 861
			Ctrl.Image.Tile.Set ImgIds(iSelImg),shDD_hori,iPlayer
QUIGLINE 862
			ctrl.Refresh ImgIds(iSelImg)
QUIGLINE 863
			ImgTile(iSelImg) = ImgTile(iSelImg)  or (shl4(iPlayer))
QUIGLINE 864
			
QUIGLINE 865
		endif
QUIGLINE 866
		
QUIGLINE 867
		if (ImgTile(iSelImg)  = defTileVert) then 
QUIGLINE 868
			Ctrl.Image.Tile.Set ImgIds(iSelImg),shDD_vert,iPlayer
QUIGLINE 869
			ctrl.Refresh ImgIds(iSelImg)
QUIGLINE 870
			ImgTile(iSelImg) = ImgTile(iSelImg)  or (shl4(iPlayer))
QUIGLINE 871
		endif
QUIGLINE 872
		
QUIGLINE 873
		game_check_box
QUIGLINE 874
		game_check_score
QUIGLINE 875
		game_score_refresh
QUIGLINE 876
		game_next_player
QUIGLINE 877
		
QUIGLINE 878
	endif
QUIGLINE 879
	iSelImg = 0
QUIGLINE 880

QUIGLINE 881
endf
QUIGLINE 882

QUIGLINE 883
Function game_next_player:void()
QUIGLINE 884
	if (bAgain = 0) then
QUIGLINE 885
		iPlayerActive = 3 - iPlayer
QUIGLINE 886
	else
QUIGLINE 887
		iPlayerActive = iPlayer
QUIGLINE 888
	endif
QUIGLINE 889
	
QUIGLINE 890
	iSelImg = 0
QUIGLINE 891
	net21_send
QUIGLINE 892
	game_showTurn
QUIGLINE 893
	
QUIGLINE 894
endf
QUIGLINE 895

QUIGLINE 896

QUIGLINE 897
Function game_check_box:void()
QUIGLINE 898

QUIGLINE 899
; fill box when round is complete
QUIGLINE 900

QUIGLINE 901
	Data.Set BoxData
QUIGLINE 902
	for t = 1 to 25
QUIGLINE 903
		a = Data.Byte
QUIGLINE 904
		if (ImgTile(a) < 10) then 
QUIGLINE 905
			if (ImgTile(a - 11) > 10) and (ImgTile(a + 1) > 10) and (ImgTile(a + 11) > 10) and (ImgTile(a - 1) > 10) then 
QUIGLINE 906
				
QUIGLINE 907
				Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,iPlayer
QUIGLINE 908
				Ctrl.Refresh ImgIds(a)
QUIGLINE 909
				ImgTile(a) = ImgTile(a) or shl4(iPlayer)
QUIGLINE 910
			endif
QUIGLINE 911
		endif
QUIGLINE 912
	next
QUIGLINE 913
endf
QUIGLINE 914

QUIGLINE 915
Function game_check_score:void()
QUIGLINE 916
; calculate score boxes
QUIGLINE 917

QUIGLINE 918
	x = 0
QUIGLINE 919
	y = 0
QUIGLINE 920
	
QUIGLINE 921
	Data.Set BoxData 
QUIGLINE 922
	for t = 1 to 25
QUIGLINE 923
		a = Data.Byte
QUIGLINE 924

QUIGLINE 925
		if (Shr4(ImgTile(a)) = 1) then
QUIGLINE 926
			x = x + 1
QUIGLINE 927
		endif
QUIGLINE 928
		
QUIGLINE 929
		if (Shr4(ImgTile(a)) = 2) then
QUIGLINE 930
			y = y + 1
QUIGLINE 931
		endif
QUIGLINE 932
	next
QUIGLINE 933
	
QUIGLINE 934
	
QUIGLINE 935
	bAgain = 0
QUIGLINE 936
	if ((x+y) > (iScore(1) + iScore(2))) then 
QUIGLINE 937
		bAgain = 1
QUIGLINE 938
	endif
QUIGLINE 939
	
QUIGLINE 940
	iScore(1) = x
QUIGLINE 941
	iScore(2) = y
QUIGLINE 942
	
QUIGLINE 943

QUIGLINE 944
endf
QUIGLINE 945

QUIGLINE 946
Function game_score_refresh:void()
QUIGLINE 947
		
QUIGLINE 948
	;Player 1
QUIGLINE 949
	
QUIGLINE 950
	x = (iScore(1) / 10) and 15
QUIGLINE 951
	
QUIGLINE 952
	Image122.Tile.Set shDD_digi,(x+10)
QUIGLINE 953
	Image122.Refresh
QUIGLINE 954
	
QUIGLINE 955
	y = iScore(1) - (x*10)
QUIGLINE 956
	
QUIGLINE 957
	Image123.Tile.Set shDD_digi,(y+10)
QUIGLINE 958
	Image123.Refresh
QUIGLINE 959
	
QUIGLINE 960
	;Player 2
QUIGLINE 961

QUIGLINE 962
	x = (iScore(2) / 10) and 15
QUIGLINE 963
	
QUIGLINE 964
	Image126.Tile.Set shDD_digi,(x+0)
QUIGLINE 965
	Image126.Refresh
QUIGLINE 966
	
QUIGLINE 967
	y = iScore(2) - (x*10)
QUIGLINE 968
	
QUIGLINE 969
	Image127.Tile.Set shDD_digi,(y+0)
QUIGLINE 970
	Image127.Refresh
QUIGLINE 971
	
QUIGLINE 972
	iWinner = 0
QUIGLINE 973
	if ((iScore(1) + iScore(2))=25) then
QUIGLINE 974
		if (iScore(1) > iScore(2)) then 
QUIGLINE 975
			iWinner = 1
QUIGLINE 976
		else
QUIGLINE 977
			iWinner = 2
QUIGLINE 978
		endif
QUIGLINE 979
	endif
QUIGLINE 980
endf
QUIGLINE 981

QUIGLINE 982
Function game_new_field:void()
QUIGLINE 983
	// received field
QUIGLINE 984
	
QUIGLINE 985
	bNew_field = 0
QUIGLINE 986
	iSelImg = 0
QUIGLINE 987
	
QUIGLINE 988
	iPlayerActive = ImgTileCom(1)
QUIGLINE 989
	iScore(1) = ImgTileCom(2)
QUIGLINE 990
	iScore(2) = ImgTileCom(3)
QUIGLINE 991
	
QUIGLINE 992
	sDb ="Active player "+str(iPlayerActive):sysDebug
QUIGLINE 993
	
QUIGLINE 994
	For t=1 to 122
QUIGLINE 995
		if (ImgTileCom(t+4) <> ImgTile(t)) then 
QUIGLINE 996
			ImgTile(t) = ImgTileCom(t+4)
QUIGLINE 997
			
QUIGLINE 998
			sDb = "newField img"+str(t):sysDebug
QUIGLINE 999
			
QUIGLINE 1000
			x = shr4(ImgTile(t))	//.. player color
QUIGLINE 1001
			y = ImgTile(t) and 15	//.. tile type hor vert
QUIGLINE 1002
			
QUIGLINE 1003
			if (y = defTileHori) then 
QUIGLINE 1004
				Ctrl.Image.Tile.Set ImgIds(t),shDD_hori,x
QUIGLINE 1005
				Ctrl.Refresh ImgIds(t)
QUIGLINE 1006
			endif
QUIGLINE 1007

QUIGLINE 1008
			if (y = defTileVert) then 
QUIGLINE 1009
				Ctrl.Image.Tile.Set ImgIds(t),shDD_vert,x
QUIGLINE 1010
				Ctrl.Refresh ImgIds(t)
QUIGLINE 1011
			endif
QUIGLINE 1012

QUIGLINE 1013
			if (y = defTileBox) then 
QUIGLINE 1014
				Ctrl.Image.Tile.Set ImgIds(t),shDD_fill,x
QUIGLINE 1015
				Ctrl.Refresh ImgIds(t)
QUIGLINE 1016
			endif
QUIGLINE 1017
			
QUIGLINE 1018
		endif
QUIGLINE 1019
	next
QUIGLINE 1020
	
QUIGLINE 1021
	game_score_refresh
QUIGLINE 1022
	game_showTurn
QUIGLINE 1023
EndF
QUIGLINE 1024

QUIGLINE 1025
Function CrtlEventToImg:void()
QUIGLINE 1026
	x = Ctrl.GetID(Form1,Event.Control)
QUIGLINE 1027
	iSelImg = 0
QUIGLINE 1028
	
QUIGLINE 1029
	for t = 1 to 122
QUIGLINE 1030
		y = ImgIds(t)
QUIGLINE 1031
		if (x = y) then 
QUIGLINE 1032
			iSelImg  = t
QUIGLINE 1033
			t=123
QUIGLINE 1034
		endif
QUIGLINE 1035
	next
QUIGLINE 1036
endf
QUIGLINE 1037

QUIGLINE 1038
Function game_resetField:void()	
QUIGLINE 1039

QUIGLINE 1040
	LoadImgCtrls
QUIGLINE 1041
	
QUIGLINE 1042
	for t =  1 to 121
QUIGLINE 1043
		ImgTile(t) = 0
QUIGLINE 1044
	next
QUIGLINE 1045

QUIGLINE 1046
	if (defTileEmpty <> 0) then 
QUIGLINE 1047
		sDb="?? empty is niet nul !!!":sysDebug
QUIGLINE 1048
	endif 
QUIGLINE 1049
	
QUIGLINE 1050
	Data.Set DotsData 
QUIGLINE 1051
	for t = 1 to 36
QUIGLINE 1052
		a = Data.Byte
QUIGLINE 1053
		Ctrl.Image.Tile.Set ImgIds(a),shDD_dot,1
QUIGLINE 1054
		Ctrl.Refresh ImgIds(a)
QUIGLINE 1055
		ImgTile(a) = defTileDot
QUIGLINE 1056
	next
QUIGLINE 1057

QUIGLINE 1058
	Data.Set HoriData 
QUIGLINE 1059
	for t = 1 to 30
QUIGLINE 1060
		a = Data.Byte
QUIGLINE 1061
		Ctrl.Image.Tile.Set ImgIds(a),shDD_hori,0
QUIGLINE 1062
		Ctrl.Refresh ImgIds(a)
QUIGLINE 1063
		ImgTile(a) = defTileHori
QUIGLINE 1064
	next
QUIGLINE 1065

QUIGLINE 1066
	Data.Set VeriData 
QUIGLINE 1067
	for t = 1 to 30
QUIGLINE 1068
		a = Data.Byte
QUIGLINE 1069
		Ctrl.Image.Tile.Set ImgIds(a),shDD_vert,0
QUIGLINE 1070
		Ctrl.Refresh ImgIds(a)
QUIGLINE 1071
		ImgTile(a) = defTileVert
QUIGLINE 1072
	next
QUIGLINE 1073

QUIGLINE 1074
	Data.Set BoxData 
QUIGLINE 1075
	for t = 1 to 25
QUIGLINE 1076
		a = Data.Byte
QUIGLINE 1077
		Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,0
QUIGLINE 1078
		Ctrl.Refresh ImgIds(a)
QUIGLINE 1079
		ImgTile(a) = defTileBox
QUIGLINE 1080
	next
QUIGLINE 1081
EndF
QUIGLINE 1082

QUIGLINE 1083
Function flashing:void()
QUIGLINE 1084
	
QUIGLINE 1085
	Data.Set BoxData 
QUIGLINE 1086
	for t = 1 to 25
QUIGLINE 1087
		a = Data.Byte
QUIGLINE 1088
		if (ImgTile(a) = iFlash) then 
QUIGLINE 1089
			if (iFlashCt = 10) then	
QUIGLINE 1090
				Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,0
QUIGLINE 1091
				Ctrl.Refresh ImgIds(a)
QUIGLINE 1092
			else
QUIGLINE 1093
				Ctrl.Image.Tile.Set ImgIds(a),shDD_fill,shr4(iFlash)
QUIGLINE 1094
				Ctrl.Refresh ImgIds(a)
QUIGLINE 1095
			endif
QUIGLINE 1096
		endif
QUIGLINE 1097
		next
QUIGLINE 1098
endf
QUIGLINE 1099

QUIGLINE 1100

QUIGLINE 1101

QUIGLINE 1102
Function sysDebug:void()
QUIGLINE 1103
//	'------ debug tool  send to FTDI port in sDb
QUIGLINE 1104

QUIGLINE 1105
	iDbL = Len(sDb)
QUIGLINE 1106
	For iDbT = 1 To iDbL
QUIGLINE 1107
	iDbC = Asc(Mid(sDb,iDbT,1))
QUIGLINE 1108
		IO.Out ioA_0,iDbC
QUIGLINE 1109
	Next
QUIGLINE 1110
	IO.Out ioA_0,13
QUIGLINE 1111
	IO.Out ioA_0,10
QUIGLINE 1112
	
QUIGLINE 1113
EndF
QUIGLINE 1114

QUIGLINE 1115
Function net21_rec_loop:void()
QUIGLINE 1116
	
QUIGLINE 1117
	u8NetStatus = IO.In(ioA_A)
QUIGLINE 1118
	if ((u8NetStatus and DefNetStatusBitRx) = 0) then
QUIGLINE 1119
		return
QUIGLINE 1120
	endif
QUIGLINE 1121
	
QUIGLINE 1122
	for t = 1 to 500
QUIGLINE 1123
		net21_rec
QUIGLINE 1124
	next
QUIGLINE 1125
endf
QUIGLINE 1126

QUIGLINE 1127
Function net21_rec:void()
QUIGLINE 1128
	
QUIGLINE 1129
	u8NetStatus = IO.In(ioA_A)
QUIGLINE 1130
		if ((u8NetStatus and DefNetStatusBitRx) = 0) then 
QUIGLINE 1131
		return 
QUIGLINE 1132
	endif
QUIGLINE 1133
	
QUIGLINE 1134
	u16Ur = (IO.In(ioA_B) *256) + IO.In(ioA_C)
QUIGLINE 1135
	u8d = IO.In(ioA_D)
QUIGLINE 1136
	
QUIGLINE 1137
	If u16Ur <> u16OtherID then
QUIGLINE 1138
		sDb = "<> "+str(u16Ur):sysDebug
QUIGLINE 1139
		return 
QUIGLINE 1140
	endif
QUIGLINE 1141
	
QUIGLINE 1142
	if (u8d = 254) then	
QUIGLINE 1143
		iRecPointer = 1
QUIGLINE 1144
		return				//..start 
QUIGLINE 1145
	endif
QUIGLINE 1146
	
QUIGLINE 1147
	if (u8d = 255) then  
QUIGLINE 1148
		bNew_field = 1
QUIGLINE 1149
		
QUIGLINE 1150
		if ((iRecPointer-1) <> 125) then 
QUIGLINE 1151
			bReSend = 1
QUIGLINE 1152
			strMs = "!! Communication Error"	
QUIGLINE 1153
			chat_send
QUIGLINE 1154
		endif
QUIGLINE 1155
		return				//..end
QUIGLINE 1156
	endif
QUIGLINE 1157
	
QUIGLINE 1158
	if (iRecPointer > 0) and (iRecPointer < 135) then  
QUIGLINE 1159
		ImgTileCom(iRecPointer) = u8d
QUIGLINE 1160
		iRecPointer	= iRecPointer + 1
QUIGLINE 1161
		return
QUIGLINE 1162
	endif	
QUIGLINE 1163
Endf
QUIGLINE 1164

QUIGLINE 1165

QUIGLINE 1166

QUIGLINE 1167

QUIGLINE 1168
Function net21_send:void()
QUIGLINE 1169
	
QUIGLINE 1170
	//sDb="send start":sysDebug
QUIGLINE 1171
	//x=1
QUIGLINE 1172
	
QUIGLINE 1173
	u8h = (u16OtherID / 256)
QUIGLINE 1174
	u8l = (u16OtherID and 255)
QUIGLINE 1175
	
QUIGLINE 1176
	IO.Out ioA_B,u8h
QUIGLINE 1177
	IO.Out ioA_C,u8L
QUIGLINE 1178
	
QUIGLINE 1179
	u8d = 254			:net21_sendTx 	//..start
QUIGLINE 1180
	u8d = iPlayerActive	:net21_sendTx 	//..keer om
QUIGLINE 1181
	u8d = iScore(1) 	:net21_sendTx 
QUIGLINE 1182
	u8d = iScore(2) 	:net21_sendTx 
QUIGLINE 1183
	u8d = 111  			:net21_sendTx 
QUIGLINE 1184
	
QUIGLINE 1185
	For t = 1 to 121 
QUIGLINE 1186
		u8d = ImgTile(t) 
QUIGLINE 1187
		net21_sendTx
QUIGLINE 1188
	next 
QUIGLINE 1189
	
QUIGLINE 1190
	u8d = 255		:net21_sendTx 	//..end
QUIGLINE 1191

QUIGLINE 1192
EndF
QUIGLINE 1193
						
QUIGLINE 1194
	
QUIGLINE 1195
Function net21_sendTx:void()
QUIGLINE 1196
		
QUIGLINE 1197
	for w = 1 to 1000
QUIGLINE 1198
		u8NetStatus = IO.In(ioA_A)
QUIGLINE 1199
		
QUIGLINE 1200
		if (w > 800) then 	
QUIGLINE 1201
			Label1.text.set "> 800"
QUIGLINE 1202
			label1.refresh
QUIGLINE 1203
			w = 1000
QUIGLINE 1204
		endif
QUIGLINE 1205
		
QUIGLINE 1206
		if ((u8NetStatus and defNetStatusBitTx) = 0) then 
QUIGLINE 1207
			w = 1000
QUIGLINE 1208
		endif
QUIGLINE 1209
	next
QUIGLINE 1210
	
QUIGLINE 1211
	IO.Out ioA_D,u8d
QUIGLINE 1212
Endf
QUIGLINE 1213

QUIGLINE 1214
;-------------------------------------------------------------------------------------------------
QUIGLINE 1215
; === VOIP Functions
QUIGLINE 1216

QUIGLINE 1217
Function VoipHandler:Void()
QUIGLINE 1218
	
QUIGLINE 1219
	If iDelayVoipCt < 10 Then
QUIGLINE 1220
		iDelayVoipCt = iDelayVoipCt + 1
QUIGLINE 1221
		Return
QUIGLINE 1222
	EndIf
QUIGLINE 1223
	iDelayVoipCt = 0
QUIGLINE 1224
	
QUIGLINE 1225
	
QUIGLINE 1226
	if (iVoipChgCt < 20) then 
QUIGLINE 1227
		iVoipChgCt = iVoipChgCt + 1
QUIGLINE 1228
	endif
QUIGLINE 1229
	if (iVoipChgCt  = 18) then 
QUIGLINE 1230
		iVoipStatusOld = 255
QUIGLINE 1231
		VoipSeStatus
QUIGLINE 1232
	endif
QUIGLINE 1233
	
QUIGLINE 1234
	VoipSeStatus
QUIGLINE 1235
	
QUIGLINE 1236
	//VoipChkNewUsers
QUIGLINE 1237
endf
QUIGLINE 1238

QUIGLINE 1239
Function VoipGreenButton:Void()
QUIGLINE 1240

QUIGLINE 1241
	sDb="green  button":sysDebug
QUIGLINE 1242
	
QUIGLINE 1243
	if (iVoipStatus = defVoipIdle) then 
QUIGLINE 1244
		VoipCallUser
QUIGLINE 1245
	endif
QUIGLINE 1246

QUIGLINE 1247
	if (iVoipStatus = defVoipIncommingCall) then 
QUIGLINE 1248
		VoipCallAccept
QUIGLINE 1249
	endif
QUIGLINE 1250
	
QUIGLINE 1251
endf
QUIGLINE 1252

QUIGLINE 1253
Function VoipRedButton:Void()
QUIGLINE 1254
	sDb="red button" :sysDebug
QUIGLINE 1255
	VoipCallBreak
QUIGLINE 1256
endf
QUIGLINE 1257

QUIGLINE 1258
Function VoipCallUser:Void()
QUIGLINE 1259
	u16in1 = u16OtherUserId
QUIGLINE 1260
	F131_10
QUIGLINE 1261
endf
QUIGLINE 1262

QUIGLINE 1263
Function VoipCallAccept:Void()
QUIGLINE 1264
	F131_11
QUIGLINE 1265
endf
QUIGLINE 1266

QUIGLINE 1267
Function VoipCallBreak:Void()
QUIGLINE 1268
	F131_12
QUIGLINE 1269
endf
QUIGLINE 1270

QUIGLINE 1271
Function VoipSeStatus:Void()
QUIGLINE 1272
	iVoipStatus = IO.In(#FF21)
QUIGLINE 1273
	
QUIGLINE 1274
	if (iVoipStatus <> iVoipStatusOld) then	
QUIGLINE 1275
		
QUIGLINE 1276
		iVoipStatusOld = iVoipStatus
QUIGLINE 1277
		
QUIGLINE 1278
		sDb = "voip status:" + str(iVoipStatus):sysDebug
QUIGLINE 1279
		sDb = "voip defVoipIdle" + str(defVoipIdle):sysDebug
QUIGLINE 1280
		
QUIGLINE 1281
		if (iVoipStatus = defVoipIdle) then 
QUIGLINE 1282
			labelVoip.text.set "IDLE" :labelVoip.refresh
QUIGLINE 1283
			iVoipSoundSelect = 0
QUIGLINE 1284
		endif
QUIGLINE 1285

QUIGLINE 1286
		if (iVoipStatus = defVoipOutgoingCall) then 
QUIGLINE 1287
			labelVoip.text.set "OUTGOING" :labelVoip.refresh
QUIGLINE 1288
			iVoipSoundSelect = 1
QUIGLINE 1289
		endif
QUIGLINE 1290

QUIGLINE 1291
		if (iVoipStatus = defVoipOtherBusy) then 
QUIGLINE 1292
			labelVoip.text.set "IS BUSY" :labelVoip.refresh
QUIGLINE 1293
			iVoipSoundSelect = 2
QUIGLINE 1294
		endif
QUIGLINE 1295
		
QUIGLINE 1296
		if (iVoipStatus = defVoipOtherOffline) then 
QUIGLINE 1297
			labelVoip.text.set "OFFLINE !" :labelVoip.refresh
QUIGLINE 1298
			iVoipSoundSelect = 3
QUIGLINE 1299
		endif
QUIGLINE 1300
		
QUIGLINE 1301
		if (iVoipStatus = defVoipIncommingCall) then 
QUIGLINE 1302
			labelVoip.text.set "INCOMMING" :labelVoip.refresh
QUIGLINE 1303
			iVoipSoundSelect = 4
QUIGLINE 1304

QUIGLINE 1305
		endif
QUIGLINE 1306
		
QUIGLINE 1307
		if (iVoipStatus = defVoipActiveCall) then 
QUIGLINE 1308
			u16in1 = u16OtherUserId :F131_7
QUIGLINE 1309
			labelVoip.text.set "CALLING..." :labelVoip.refresh
QUIGLINE 1310
			iVoipSoundSelect = 5
QUIGLINE 1311
		endif
QUIGLINE 1312

QUIGLINE 1313
	endif
QUIGLINE 1314
endf
QUIGLINE 1315

QUIGLINE 1316

QUIGLINE 1317
Function VoipSoundHandler:Void()
QUIGLINE 1318

QUIGLINE 1319
	iVoipSoundCt = iVoipSoundCt + 1
QUIGLINE 1320
	if (iVoipSoundCt < 5) then 
QUIGLINE 1321
		return
QUIGLINE 1322
	endif
QUIGLINE 1323
	iVoipSoundCt = 0
QUIGLINE 1324
	
QUIGLINE 1325
	iVoipSoundSeq = iVoipSoundSeq  + 1
QUIGLINE 1326
	
QUIGLINE 1327
	if (iVoipSoundSeq > 5000) then 
QUIGLINE 1328
		iVoipSoundSeq = 0
QUIGLINE 1329
	endif
QUIGLINE 1330
	
QUIGLINE 1331
	if (iVoipSoundSelect = 0) then 
QUIGLINE 1332
		iVoipSoundSeq = 0
QUIGLINE 1333
		return 
QUIGLINE 1334
	elseif (iVoipSoundSelect = 1) then // soundPlayCallUser
QUIGLINE 1335
		
QUIGLINE 1336
		if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 12) or (iVoipSoundSeq = 15)  then 
QUIGLINE 1337
			Sound.FX.Play 0,sound.fx.sys.Ring2-1,255
QUIGLINE 1338
		endif
QUIGLINE 1339
		
QUIGLINE 1340
		if (iVoipSoundSeq > 30) then 
QUIGLINE 1341
			iVoipSoundSeq = 0
QUIGLINE 1342
		endif
QUIGLINE 1343
		
QUIGLINE 1344
	elseif (iVoipSoundSelect = 2) then // soundPlayBusy
QUIGLINE 1345

QUIGLINE 1346
		if (iVoipSoundSeq = 1)  then 
QUIGLINE 1347
			Sound.FX.Play 0,sound.fx.sys.Click1 -1 ,255
QUIGLINE 1348
		endif
QUIGLINE 1349
		
QUIGLINE 1350
		if (iVoipSoundSeq > 10) then 
QUIGLINE 1351
			iVoipSoundSeq = 0
QUIGLINE 1352
		endif
QUIGLINE 1353
	
QUIGLINE 1354
	elseif (iVoipSoundSelect = 3) then // soundPlayOffline
QUIGLINE 1355
	
QUIGLINE 1356
		if (iVoipSoundSeq = 1) or (iVoipSoundSeq = 4) or (iVoipSoundSeq = 7) then 
QUIGLINE 1357
			Sound.FX.Play 0,sound.fx.sys.Click1-1,255
QUIGLINE 1358
		endif
QUIGLINE 1359

QUIGLINE 1360
		if (iVoipSoundSeq > 20) then 
QUIGLINE 1361
			iVoipSoundSeq = 0
QUIGLINE 1362
		endif
QUIGLINE 1363
		
QUIGLINE 1364
	elseif (iVoipSoundSelect = 4) then // soundPlayBeCalled
QUIGLINE 1365

QUIGLINE 1366
		if (iVoipSoundSeq = 1)  then 
QUIGLINE 1367
			Sound.FX.Play 0,sound.fx.sys.Win-1,255
QUIGLINE 1368
		endif
QUIGLINE 1369
		
QUIGLINE 1370
		if (iVoipSoundSeq > 55) then 
QUIGLINE 1371
			iVoipSoundSeq = 0
QUIGLINE 1372
		endif
QUIGLINE 1373
		
QUIGLINE 1374
	endif
QUIGLINE 1375
	// iVoipSoundSelect = 5 CALLING
QUIGLINE 1376

QUIGLINE 1377
endf
QUIGLINE 1378

QUIGLINE 1379
Function VoipGetConnectedWith:Void()
QUIGLINE 1380

QUIGLINE 1381
;	Get VOIP connected userID
QUIGLINE 1382
;		
QUIGLINE 1383
; 	out:	u16OtherUserId
QUIGLINE 1384
;
QUIGLINE 1385

QUIGLINE 1386
	u16OtherUserId = (256 * IO.In(#FF22)) + IO.In(#FF23)
QUIGLINE 1387
	sDb = "Voip connected with :" + str(u16OtherUserId):sysDebug
QUIGLINE 1388
endf
QUIGLINE 1389

QUIGLINE 1390

QUIGLINE 1391

QUIGLINE 1392
;------------------------------------------------------------------------------------------------------------
QUIGLINE 1393
;	=== SOUND
QUIGLINE 1394

QUIGLINE 1395
Function se1_PlayBell:void()
QUIGLINE 1396
	
QUIGLINE 1397
endf
QUIGLINE 1398

QUIGLINE 1399
Function se1_PlayTick:void()
QUIGLINE 1400
	///Sound.FX.Play 0,Sound.FX.Sys.Tic1,255 
QUIGLINE 1401
endf
QUIGLINE 1402

QUIGLINE 1403

QUIGLINE 1404

QUIGLINE 1405

QUIGLINE 1406

QUIGLINE 1407

QUIGLINE 1408
;------------------------------------------------------------------------------------------------------------
QUIGLINE 1409
;	=== Data
QUIGLINE 1410

QUIGLINE 1411
Function ImgPos:Void()
QUIGLINE 1412
	
QUIGLINE 1413
	Asm
QUIGLINE 1414
	
QUIGLINE 1415
	.DotsData:
QUIGLINE 1416
	;Dots 6x6 = 36
QUIGLINE 1417
	Db   1,  3,  5,  7,  9, 11
QUIGLINE 1418
	Db  23, 25, 27, 29, 31, 33
QUIGLINE 1419
	Db  45, 47, 49, 51, 53, 55
QUIGLINE 1420
	Db  67, 69, 71, 73, 75, 77
QUIGLINE 1421
	Db  89, 91, 93, 95, 97, 99
QUIGLINE 1422
	Db 111,113,115,117,119,121
QUIGLINE 1423
	Db 0,0,0,0,0,0
QUIGLINE 1424
	
QUIGLINE 1425
	.HoriData:
QUIGLINE 1426
	;Horizontal 5x6 = 30
QUIGLINE 1427
	Db   2,  4,  6,  8, 10
QUIGLINE 1428
	Db  24, 26, 28, 30, 32
QUIGLINE 1429
	Db  46, 48, 50, 52, 54
QUIGLINE 1430
	Db  68, 70, 72, 74, 76
QUIGLINE 1431
	Db  90, 92, 94, 96, 98
QUIGLINE 1432
	Db 112,114,116,118,120
QUIGLINE 1433
	Db 0,0,0,0,0,0
QUIGLINE 1434
	
QUIGLINE 1435
	.VeriData:
QUIGLINE 1436
	;Vertical 6x5 = 30
QUIGLINE 1437
	Db  12, 14, 16, 18, 20, 22
QUIGLINE 1438
	Db  34, 36, 38, 40, 42, 44
QUIGLINE 1439
	Db  56, 58, 60, 62, 64, 66
QUIGLINE 1440
	Db  78, 80, 82, 84, 86, 88
QUIGLINE 1441
	Db 100,102,104,106,108,110
QUIGLINE 1442
	
QUIGLINE 1443
	.BoxData:
QUIGLINE 1444
	;Vertical 5x5 = 25
QUIGLINE 1445
	Db  13, 15, 17, 19, 21
QUIGLINE 1446
	Db  35, 37, 39, 41, 43
QUIGLINE 1447
	Db  57, 59, 61, 63, 65
QUIGLINE 1448
	Db  79, 81, 83, 85, 87
QUIGLINE 1449
	Db 101,103,105,107,109
QUIGLINE 1450
	Db 0,0,0,0,0,0
QUIGLINE 1451

QUIGLINE 1452
	Quigs
QUIGLINE 1453
EndF
QUIGLINE 1454

QUIGLINE 1455

QUIGLINE 1456

QUIGLINE 1457
Function  LoadImgCtrls:void()
QUIGLINE 1458
	
QUIGLINE 1459
	ImgIds( 1)=Ctrl.GetID(Form1,Image1.Display)
QUIGLINE 1460
	
QUIGLINE 1461
	ImgIds( 2)=Ctrl.GetID(Form1,Image2.Display)
QUIGLINE 1462
	ImgIds( 2)=Image2
QUIGLINE 1463
	
QUIGLINE 1464
	sDb="->> Display image "+str(Image2.Display) :sysDebug
QUIGLINE 1465
	
QUIGLINE 1466
	ImgIds( 3)=Ctrl.GetID(Form1,Image3.Display)
QUIGLINE 1467
	ImgIds( 4)=Ctrl.GetID(Form1,Image4.Display)
QUIGLINE 1468
	ImgIds( 5)=Ctrl.GetID(Form1,Image5.Display)
QUIGLINE 1469
	ImgIds( 6)=Ctrl.GetID(Form1,Image6.Display)
QUIGLINE 1470
	ImgIds( 7)=Ctrl.GetID(Form1,Image7.Display)
QUIGLINE 1471
	ImgIds( 8)=Ctrl.GetID(Form1,Image8.Display)
QUIGLINE 1472
	ImgIds( 9)=Ctrl.GetID(Form1,Image9.Display)
QUIGLINE 1473
	ImgIds(10)=Ctrl.GetID(Form1,Image10.Display)
QUIGLINE 1474
	ImgIds(11)=Ctrl.GetID(Form1,Image11.Display)
QUIGLINE 1475
	ImgIds(12)=Ctrl.GetID(Form1,Image12.Display)
QUIGLINE 1476
	ImgIds(13)=Ctrl.GetID(Form1,Image13.Display)
QUIGLINE 1477
	ImgIds(14)=Ctrl.GetID(Form1,Image14.Display)
QUIGLINE 1478
	ImgIds(15)=Ctrl.GetID(Form1,Image15.Display)
QUIGLINE 1479
	ImgIds(16)=Ctrl.GetID(Form1,Image16.Display)
QUIGLINE 1480
	ImgIds(17)=Ctrl.GetID(Form1,Image17.Display)
QUIGLINE 1481
	ImgIds(18)=Ctrl.GetID(Form1,Image18.Display)
QUIGLINE 1482
	ImgIds(19)=Ctrl.GetID(Form1,Image19.Display)
QUIGLINE 1483

QUIGLINE 1484
	ImgIds(20)=Ctrl.GetID(Form1,Image20.Display)
QUIGLINE 1485
	ImgIds(21)=Ctrl.GetID(Form1,Image21.Display)
QUIGLINE 1486
	ImgIds(22)=Ctrl.GetID(Form1,Image22.Display)
QUIGLINE 1487
	ImgIds(23)=Ctrl.GetID(Form1,Image23.Display)
QUIGLINE 1488
	ImgIds(24)=Ctrl.GetID(Form1,Image24.Display)
QUIGLINE 1489
	ImgIds(25)=Ctrl.GetID(Form1,Image25.Display)
QUIGLINE 1490
	ImgIds(26)=Ctrl.GetID(Form1,Image26.Display)
QUIGLINE 1491
	ImgIds(27)=Ctrl.GetID(Form1,Image27.Display)
QUIGLINE 1492
	ImgIds(28)=Ctrl.GetID(Form1,Image28.Display)
QUIGLINE 1493
	ImgIds(29)=Ctrl.GetID(Form1,Image29.Display)
QUIGLINE 1494

QUIGLINE 1495
	ImgIds(30)=Ctrl.GetID(Form1,Image30.Display)
QUIGLINE 1496
	ImgIds(31)=Ctrl.GetID(Form1,Image31.Display)
QUIGLINE 1497
	ImgIds(32)=Ctrl.GetID(Form1,Image32.Display)
QUIGLINE 1498
	ImgIds(33)=Ctrl.GetID(Form1,Image33.Display)
QUIGLINE 1499
	ImgIds(34)=Ctrl.GetID(Form1,Image34.Display)
QUIGLINE 1500
	ImgIds(35)=Ctrl.GetID(Form1,Image35.Display)
QUIGLINE 1501
	ImgIds(36)=Ctrl.GetID(Form1,Image36.Display)
QUIGLINE 1502
	ImgIds(37)=Ctrl.GetID(Form1,Image37.Display)
QUIGLINE 1503
	ImgIds(38)=Ctrl.GetID(Form1,Image38.Display)
QUIGLINE 1504
	ImgIds(39)=Ctrl.GetID(Form1,Image39.Display)
QUIGLINE 1505

QUIGLINE 1506
	ImgIds(40)=Ctrl.GetID(Form1,Image40.Display)
QUIGLINE 1507
	ImgIds(41)=Ctrl.GetID(Form1,Image41.Display)
QUIGLINE 1508
	ImgIds(42)=Ctrl.GetID(Form1,Image42.Display)
QUIGLINE 1509
	ImgIds(43)=Ctrl.GetID(Form1,Image43.Display)
QUIGLINE 1510
	ImgIds(44)=Ctrl.GetID(Form1,Image44.Display)
QUIGLINE 1511
	ImgIds(45)=Ctrl.GetID(Form1,Image45.Display)
QUIGLINE 1512
	ImgIds(46)=Ctrl.GetID(Form1,Image46.Display)
QUIGLINE 1513
	ImgIds(47)=Ctrl.GetID(Form1,Image47.Display)
QUIGLINE 1514
	ImgIds(48)=Ctrl.GetID(Form1,Image48.Display)
QUIGLINE 1515
	ImgIds(49)=Ctrl.GetID(Form1,Image49.Display)
QUIGLINE 1516
	
QUIGLINE 1517
	ImgIds(50)=Ctrl.GetID(Form1,Image50.Display)
QUIGLINE 1518
	ImgIds(51)=Ctrl.GetID(Form1,Image51.Display)
QUIGLINE 1519
	ImgIds(52)=Ctrl.GetID(Form1,Image52.Display)
QUIGLINE 1520
	ImgIds(53)=Ctrl.GetID(Form1,Image53.Display)
QUIGLINE 1521
	ImgIds(54)=Ctrl.GetID(Form1,Image54.Display)
QUIGLINE 1522
	ImgIds(55)=Ctrl.GetID(Form1,Image55.Display)
QUIGLINE 1523
	ImgIds(56)=Ctrl.GetID(Form1,Image56.Display)
QUIGLINE 1524
	ImgIds(57)=Ctrl.GetID(Form1,Image57.Display)
QUIGLINE 1525
	ImgIds(58)=Ctrl.GetID(Form1,Image58.Display)
QUIGLINE 1526
	ImgIds(59)=Ctrl.GetID(Form1,Image59.Display)
QUIGLINE 1527
	
QUIGLINE 1528
	ImgIds(60)=Ctrl.GetID(Form1,Image60.Display)
QUIGLINE 1529
	ImgIds(61)=Ctrl.GetID(Form1,Image61.Display)
QUIGLINE 1530
	ImgIds(62)=Ctrl.GetID(Form1,Image62.Display)
QUIGLINE 1531
	ImgIds(63)=Ctrl.GetID(Form1,Image63.Display)
QUIGLINE 1532
	ImgIds(64)=Ctrl.GetID(Form1,Image64.Display)
QUIGLINE 1533
	ImgIds(65)=Ctrl.GetID(Form1,Image65.Display)
QUIGLINE 1534
	ImgIds(66)=Ctrl.GetID(Form1,Image66.Display)
QUIGLINE 1535
	ImgIds(67)=Ctrl.GetID(Form1,Image67.Display)
QUIGLINE 1536
	ImgIds(68)=Ctrl.GetID(Form1,Image68.Display)
QUIGLINE 1537
	ImgIds(69)=Ctrl.GetID(Form1,Image69.Display)
QUIGLINE 1538
	
QUIGLINE 1539
	ImgIds(70)=Ctrl.GetID(Form1,Image70.Display)
QUIGLINE 1540
	ImgIds(71)=Ctrl.GetID(Form1,Image71.Display)
QUIGLINE 1541
	ImgIds(72)=Ctrl.GetID(Form1,Image72.Display)
QUIGLINE 1542
	ImgIds(73)=Ctrl.GetID(Form1,Image73.Display)
QUIGLINE 1543
	ImgIds(74)=Ctrl.GetID(Form1,Image74.Display)
QUIGLINE 1544
	ImgIds(75)=Ctrl.GetID(Form1,Image75.Display)
QUIGLINE 1545
	ImgIds(76)=Ctrl.GetID(Form1,Image76.Display)
QUIGLINE 1546
	ImgIds(77)=Ctrl.GetID(Form1,Image77.Display)
QUIGLINE 1547
	ImgIds(78)=Ctrl.GetID(Form1,Image78.Display)
QUIGLINE 1548
	ImgIds(79)=Ctrl.GetID(Form1,Image79.Display)
QUIGLINE 1549
	
QUIGLINE 1550
	ImgIds(80)=Ctrl.GetID(Form1,Image80.Display)
QUIGLINE 1551
	ImgIds(81)=Ctrl.GetID(Form1,Image81.Display)
QUIGLINE 1552
	ImgIds(82)=Ctrl.GetID(Form1,Image82.Display)
QUIGLINE 1553
	ImgIds(83)=Ctrl.GetID(Form1,Image83.Display)
QUIGLINE 1554
	ImgIds(84)=Ctrl.GetID(Form1,Image84.Display)
QUIGLINE 1555
	ImgIds(85)=Ctrl.GetID(Form1,Image85.Display)
QUIGLINE 1556
	ImgIds(86)=Ctrl.GetID(Form1,Image86.Display)
QUIGLINE 1557
	ImgIds(87)=Ctrl.GetID(Form1,Image87.Display)
QUIGLINE 1558
	ImgIds(88)=Ctrl.GetID(Form1,Image88.Display)
QUIGLINE 1559
	ImgIds(89)=Ctrl.GetID(Form1,Image89.Display)
QUIGLINE 1560

QUIGLINE 1561
	ImgIds(90)=Ctrl.GetID(Form1,Image90.Display)
QUIGLINE 1562
	ImgIds(91)=Ctrl.GetID(Form1,Image91.Display)
QUIGLINE 1563
	ImgIds(92)=Ctrl.GetID(Form1,Image92.Display)
QUIGLINE 1564
	ImgIds(93)=Ctrl.GetID(Form1,Image93.Display)
QUIGLINE 1565
	ImgIds(94)=Ctrl.GetID(Form1,Image94.Display)
QUIGLINE 1566
	ImgIds(95)=Ctrl.GetID(Form1,Image95.Display)
QUIGLINE 1567
	ImgIds(96)=Ctrl.GetID(Form1,Image96.Display)
QUIGLINE 1568
	ImgIds(97)=Ctrl.GetID(Form1,Image97.Display)
QUIGLINE 1569
	ImgIds(98)=Ctrl.GetID(Form1,Image98.Display)
QUIGLINE 1570
	ImgIds(99)=Ctrl.GetID(Form1,Image99.Display)
QUIGLINE 1571
	
QUIGLINE 1572
	ImgIds(100)=Ctrl.GetID(Form1,Image100.Display)
QUIGLINE 1573
	ImgIds(101)=Ctrl.GetID(Form1,Image101.Display)
QUIGLINE 1574
	ImgIds(102)=Ctrl.GetID(Form1,Image102.Display)
QUIGLINE 1575
	ImgIds(103)=Ctrl.GetID(Form1,Image103.Display)
QUIGLINE 1576
	ImgIds(104)=Ctrl.GetID(Form1,Image104.Display)
QUIGLINE 1577
	ImgIds(105)=Ctrl.GetID(Form1,Image105.Display)
QUIGLINE 1578
	ImgIds(106)=Ctrl.GetID(Form1,Image106.Display)
QUIGLINE 1579
	ImgIds(107)=Ctrl.GetID(Form1,Image107.Display)
QUIGLINE 1580
	ImgIds(108)=Ctrl.GetID(Form1,Image108.Display)
QUIGLINE 1581
	ImgIds(109)=Ctrl.GetID(Form1,Image109.Display)
QUIGLINE 1582
	
QUIGLINE 1583
	ImgIds(110)=Ctrl.GetID(Form1,Image110.Display)
QUIGLINE 1584
	ImgIds(111)=Ctrl.GetID(Form1,Image111.Display)
QUIGLINE 1585
	ImgIds(112)=Ctrl.GetID(Form1,Image112.Display)
QUIGLINE 1586
	ImgIds(113)=Ctrl.GetID(Form1,Image113.Display)
QUIGLINE 1587
	ImgIds(114)=Ctrl.GetID(Form1,Image114.Display)
QUIGLINE 1588
	ImgIds(115)=Ctrl.GetID(Form1,Image115.Display)
QUIGLINE 1589
	ImgIds(116)=Ctrl.GetID(Form1,Image116.Display)
QUIGLINE 1590
	ImgIds(117)=Ctrl.GetID(Form1,Image117.Display)
QUIGLINE 1591
	ImgIds(118)=Ctrl.GetID(Form1,Image118.Display)
QUIGLINE 1592
	ImgIds(119)=Ctrl.GetID(Form1,Image119.Display)
QUIGLINE 1593

QUIGLINE 1594
	ImgIds(120)=Ctrl.GetID(Form1,Image120.Display)
QUIGLINE 1595
	ImgIds(121)=Ctrl.GetID(Form1,Image121.Display)
QUIGLINE 1596

QUIGLINE 1597
endf
QUIGLINE 1598

QUIGLINE 1599
//------------------------------------------------------------------------------------------------------------
QUIGLINE 1600
// === STP PROGRAMS ===
QUIGLINE 1601

QUIGLINE 1602

QUIGLINE 1603
Function   stpStartup:Void()
QUIGLINE 1604
	
QUIGLINE 1605
	If iStpStartup = 0 Then
QUIGLINE 1606
		return 
QUIGLINE 1607
	EndIf
QUIGLINE 1608
	
QUIGLINE 1609
	if (iStpStartup <> 120) then 
QUIGLINE 1610
		sDb = "step  is: "+str(iStpStartup) :sysDebug 
QUIGLINE 1611
	endif
QUIGLINE 1612
	
QUIGLINE 1613
	If iStpStartup = 10 Then		//.. start
QUIGLINE 1614
		
QUIGLINE 1615
		strIn1 =  strFirmware
QUIGLINE 1616
		F72_25	//.. check firmware
QUIGLINE 1617
		If  u8Out1 > 0  Then
QUIGLINE 1618
			c = MsgBox("Firmware  out of  date !","Needed: ",strFirmware ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
QUIGLINE 1619
		EndIf
QUIGLINE 1620

QUIGLINE 1621
		F131_1	//.. get status
QUIGLINE 1622
		If u8Out1 = 3 Then
QUIGLINE 1623
			iStpStartup  = 30
QUIGLINE 1624
		Else
QUIGLINE 1625
			F131_0						//.. login tmtnet
QUIGLINE 1626
			iStpStartup = 20
QUIGLINE 1627
		EndIf
QUIGLINE 1628
		return 
QUIGLINE 1629
	EndIf
QUIGLINE 1630
	
QUIGLINE 1631
	If iStpStartup = 20 Then	//.. Wait for connection
QUIGLINE 1632
		F131_1	//.. get status
QUIGLINE 1633
		If u8Out1 = 0 Then
QUIGLINE 1634
			c = MsgBox("Wifi OFFLINE !","Not connected: ","" ,MsgBox.Title.Error	,MsgBox.Buttons.Ok,MsgBox.Icon.Default	)
QUIGLINE 1635
			iAppExit = 1
QUIGLINE 1636
		EndIf
QUIGLINE 1637
		
QUIGLINE 1638
		If u8Out1 = 3 Then
QUIGLINE 1639
			
QUIGLINE 1640
			iStpStartup  = 30
QUIGLINE 1641
		EndIf
QUIGLINE 1642
		return 
QUIGLINE 1643
	EndIf
QUIGLINE 1644
	
QUIGLINE 1645
	If iStpStartup = 30 Then	//.. Login ready
QUIGLINE 1646
	
QUIGLINE 1647
		
QUIGLINE 1648
		F131_8						//.. get my userID
QUIGLINE 1649
		
QUIGLINE 1650
		strIn1 = strAppname
QUIGLINE 1651
		F131_32						//.. set Appname
QUIGLINE 1652
		
QUIGLINE 1653
		iStpStartup = 100
QUIGLINE 1654
		
QUIGLINE 1655
		Form4.close
QUIGLINE 1656
		Form2.open
QUIGLINE 1657
		return 
QUIGLINE 1658
	EndIf
QUIGLINE 1659
	
QUIGLINE 1660
	
QUIGLINE 1661
	If iStpStartup = 100 Then	//.. Choise player
QUIGLINE 1662
		
QUIGLINE 1663
		F131_2					//.. clear userOnline table
QUIGLINE 1664
		
QUIGLINE 1665
		iButChoise = 0
QUIGLINE 1666
		
QUIGLINE 1667
		intDelay = 25			//.. 500ms
QUIGLINE 1668
		intDelayCt = 0 
QUIGLINE 1669
		iStpStartup = 110
QUIGLINE 1670
		return 
QUIGLINE 1671
	EndIf
QUIGLINE 1672
	
QUIGLINE 1673
	If iStpStartup = 110 Then	//.. Read online users
QUIGLINE 1674
		
QUIGLINE 1675
		F131_3					//.. read userOnline table
QUIGLINE 1676
		
QUIGLINE 1677
		; iUserOnlineTotal
QUIGLINE 1678
			
QUIGLINE 1679
		label21.text.set "..."
QUIGLINE 1680
		label22.text.set "..."
QUIGLINE 1681
		label23.text.set "..."
QUIGLINE 1682
		label24.text.set "..."
QUIGLINE 1683
		label25.text.set "..."
QUIGLINE 1684
	
QUIGLINE 1685
		Label21.Colour.Set Colour.White,colour.Blue,1
QUIGLINE 1686
		Label22.Colour.Set Colour.White,colour.Blue,1
QUIGLINE 1687
		Label23.Colour.Set Colour.White,colour.Blue,1
QUIGLINE 1688
		Label24.Colour.Set Colour.White,colour.Blue,1
QUIGLINE 1689
		Label25.Colour.Set Colour.White,colour.Blue,1
QUIGLINE 1690

QUIGLINE 1691

QUIGLINE 1692
		if (iUserOnlineTotal > 0) then 
QUIGLINE 1693
			u16In1 = u16UserOnline(0)
QUIGLINE 1694
			F131_7				//.. get User info
QUIGLINE 1695
			sText = strOut1 + "   " + strOut2
QUIGLINE 1696
			label21.text.set sText
QUIGLINE 1697
		endif
QUIGLINE 1698
		
QUIGLINE 1699
		if (iUserOnlineTotal > 1) then 
QUIGLINE 1700
			u16In1 = u16UserOnline(1)
QUIGLINE 1701
			F131_7				//.. get User info
QUIGLINE 1702
			sText = strOut1 + "   " + strOut2
QUIGLINE 1703
			label22.text.set sText
QUIGLINE 1704
		endif
QUIGLINE 1705
		
QUIGLINE 1706
		if (iUserOnlineTotal > 2) then 
QUIGLINE 1707
			u16In1 = u16UserOnline(2)
QUIGLINE 1708
			F131_7				//.. get User info
QUIGLINE 1709
			sText = strOut1 + "   " + strOut2
QUIGLINE 1710
			label23.text.set sText
QUIGLINE 1711
		endif
QUIGLINE 1712
	
QUIGLINE 1713
		if (iUserOnlineTotal > 3) then 
QUIGLINE 1714
			u16In1 = u16UserOnline(2)
QUIGLINE 1715
			F131_7				//.. get User info
QUIGLINE 1716
			sText = strOut1 + "   " + strOut2
QUIGLINE 1717
			label24.text.set sText
QUIGLINE 1718
		endif
QUIGLINE 1719

QUIGLINE 1720
		if (iUserOnlineTotal > 4) then 
QUIGLINE 1721
			u16In1 = u16UserOnline(2)
QUIGLINE 1722
			F131_7				//.. get User info
QUIGLINE 1723
			sText = strOut1 + "   " + strOut2
QUIGLINE 1724
			label25.text.set sText
QUIGLINE 1725
		endif
QUIGLINE 1726

QUIGLINE 1727
		label21.refresh
QUIGLINE 1728
		label22.refresh
QUIGLINE 1729
		label23.refresh
QUIGLINE 1730
		label24.refresh
QUIGLINE 1731
		label25.refresh
QUIGLINE 1732
				
QUIGLINE 1733
		intDelay = 10				// 200ms
QUIGLINE 1734
		intDelayCt = 0
QUIGLINE 1735
		iStpStartup = 120
QUIGLINE 1736
		return
QUIGLINE 1737
	EndIf
QUIGLINE 1738
	
QUIGLINE 1739
	If iStpStartup = 120 Then	
QUIGLINE 1740
		
QUIGLINE 1741
		u8NetStatus = IO.In(ioA_A)
QUIGLINE 1742
		
QUIGLINE 1743
		if ((u8NetStatus and defNetStatusBitUser) > 0) then 
QUIGLINE 1744
			iStpStartup = 110
QUIGLINE 1745
		endif
QUIGLINE 1746
		
QUIGLINE 1747
		if (iButChoise > 0) then 
QUIGLINE 1748
			iStpStartup = 130
QUIGLINE 1749
		endif
QUIGLINE 1750
		
QUIGLINE 1751
		return
QUIGLINE 1752
	endif
QUIGLINE 1753
	
QUIGLINE 1754
	If iStpStartup = 130 Then	
QUIGLINE 1755
	
QUIGLINE 1756
		x = iButChoise - 1
QUIGLINE 1757
		u16OtherID = u16UserOnline(x)
QUIGLINE 1758
		
QUIGLINE 1759
		u16OtherUserId = u16OtherID //voip
QUIGLINE 1760
		
QUIGLINE 1761
		sDb = "Other user is: "+str(u16OtherID) :sysDebug
QUIGLINE 1762
		
QUIGLINE 1763
		intDelay = 10			//.. 200ms
QUIGLINE 1764
		
QUIGLINE 1765
		if (u16OtherID = u16MyUserID ) then 
QUIGLINE 1766
			if (iButChoise = 1) then 
QUIGLINE 1767
				Label21.Colour.Set Colour.White,colour.Orange,1
QUIGLINE 1768
				Label21.refresh
QUIGLINE 1769
			endif
QUIGLINE 1770
			if (iButChoise = 2) then 
QUIGLINE 1771
				Label22.Colour.Set Colour.White,colour.Orange,1
QUIGLINE 1772
				Label22.refresh
QUIGLINE 1773
			endif
QUIGLINE 1774
			if (iButChoise = 3) then 
QUIGLINE 1775
				Label23.Colour.Set Colour.White,colour.Orange,1
QUIGLINE 1776
				Label23.refresh
QUIGLINE 1777
			endif
QUIGLINE 1778
			if (iButChoise = 4) then 
QUIGLINE 1779
				Label24.Colour.Set Colour.White,colour.Orange,1
QUIGLINE 1780
				Label24.refresh
QUIGLINE 1781
			endif
QUIGLINE 1782
			if (iButChoise = 5) then 
QUIGLINE 1783
				Label25.Colour.Set Colour.White,colour.Orange,1
QUIGLINE 1784
				Label25.refresh
QUIGLINE 1785
			endif
QUIGLINE 1786
			
QUIGLINE 1787
			iButChoise = 0
QUIGLINE 1788
			intDelay = 20			//.. 400ms
QUIGLINE 1789
			intDelayCt = 0
QUIGLINE 1790
			iStpStartup = 110
QUIGLINE 1791
			return
QUIGLINE 1792
		endif
QUIGLINE 1793
		
QUIGLINE 1794
		iButChoise = 0
QUIGLINE 1795
		
QUIGLINE 1796
		u16in1 = u16OtherID
QUIGLINE 1797
		F131_33
QUIGLINE 1798

QUIGLINE 1799
		iTimeOut = 0
QUIGLINE 1800
		intDelay = 10				//.. 200ms
QUIGLINE 1801
		intDelayCt = 0
QUIGLINE 1802
		iStpStartup = 140
QUIGLINE 1803
		return
QUIGLINE 1804
	endif
QUIGLINE 1805

QUIGLINE 1806
	If iStpStartup = 140 Then	//.. Wait for  Appname
QUIGLINE 1807
		
QUIGLINE 1808
		iTimeOut = iTimeOut + 1
QUIGLINE 1809
		if (iTimeout > 5) then 
QUIGLINE 1810
			sDb = "Appname timeout step 140":sysDebug
QUIGLINE 1811
			iStpStartup = 100
QUIGLINE 1812
		endif
QUIGLINE 1813
		
QUIGLINE 1814
		u8NetStatus = IO.In(ioA_A)
QUIGLINE 1815
		if ((u8NetStatus and defNetStatusBitSys) = 0) then 
QUIGLINE 1816
			return 
QUIGLINE 1817
		endif
QUIGLINE 1818
		
QUIGLINE 1819
		F131_34
QUIGLINE 1820
		
QUIGLINE 1821
		Label26.Text.Set "Appname: "+strOut1
QUIGLINE 1822
		Label26.Refresh
QUIGLINE 1823
		
QUIGLINE 1824
		sDb="App: "+strOut1: sysDebug
QUIGLINE 1825
		
QUIGLINE 1826
		if (strOut1 <> strAppname) then
QUIGLINE 1827
			iStpStartup = 100
QUIGLINE 1828
		else
QUIGLINE 1829
			iStpStartup = 150
QUIGLINE 1830
		endif
QUIGLINE 1831
		return
QUIGLINE 1832
	endif
QUIGLINE 1833
	
QUIGLINE 1834
	If iStpStartup = 150 Then	//.. End
QUIGLINE 1835

QUIGLINE 1836
		iStpStartup = 0
QUIGLINE 1837
		
QUIGLINE 1838
		Form2.close
QUIGLINE 1839
		Form1.open
QUIGLINE 1840
		
QUIGLINE 1841
		game_begin
QUIGLINE 1842
	endif
QUIGLINE 1843
EndF
QUIGLINE 1844
	
QUIGLINE 1845
;--------------------------------------------------------------------------	
QUIGLINE 1846

QUIGLINE 1847
Function sys_IO_init:Void()
QUIGLINE 1848

QUIGLINE 1849
	If  (Machine = 7)  Or  (Machine = 8)  Or  (Machine = 9) Or  (Machine = 10) Then
QUIGLINE 1850
		ioA_0 = #40f0 : ioA_1 = #41f0 : ioA_2 = #42f0 : ioA_3 = #43f0
QUIGLINE 1851
		ioA_4 = #44f0 : ioA_5 = #45f0 : ioA_6 = #46f0 : ioA_7 = #47f0
QUIGLINE 1852
		ioA_8 = #48f0 : ioA_9 = #49f0 : ioA_A = #4af0 : ioA_B = #4bf0
QUIGLINE 1853
		ioA_C = #4cf0 : ioA_D = #4df0 : ioA_E = #4ef0 : ioA_F = #4ff0
QUIGLINE 1854
		
QUIGLINE 1855
		strCPU = "MSX"
QUIGLINE 1856
	EndIf
QUIGLINE 1857
	
QUIGLINE 1858
	If  (Machine = 6)  Then
QUIGLINE 1859
		ioA_0 = #40 : ioA_1 = #41 : ioA_2 = #42 : ioA_3 = #43 
QUIGLINE 1860
		ioA_4 = #44 : ioA_5 = #45 : ioA_6 = #46 : ioA_7 = #47
QUIGLINE 1861
		ioA_8 = #48 : ioA_9 = #49 : ioA_A = #4a : ioA_B = #4b 
QUIGLINE 1862
		ioA_C = #4c : ioA_D = #4d : ioA_E = #4e : ioA_F = #4f
QUIGLINE 1863
		
QUIGLINE 1864
		strCPU = "EP"
QUIGLINE 1865
	EndIf
QUIGLINE 1866
	
QUIGLINE 1867
	If  (Machine = Machine.Pcw8xxx)  or  ( Machine = Machine.Pcw9xxx) or ( Machine = Machine.Pcw16)   Then
QUIGLINE 1868
		ioA_0 = #40B0 : ioA_1 = #41B0 : ioA_2 = #42B0 : ioA_3 = #43B0
QUIGLINE 1869
		ioA_4 = #44B0 : ioA_5 = #45B0 : ioA_6 = #46B0 : ioA_7 = #47B0
QUIGLINE 1870
		ioA_8 = #48B0 : ioA_9 = #49B0 : ioA_A = #4aB0 : ioA_B = #4bB0
QUIGLINE 1871
		ioA_C = #4cB0 : ioA_D = #4dB0 : ioA_E = #4eB0 : ioA_F = #4fB0
QUIGLINE 1872
		
QUIGLINE 1873
		strCPU = "PCW"
QUIGLINE 1874
	EndIf
QUIGLINE 1875
	
QUIGLINE 1876
	If  (Machine < 5)  Then
QUIGLINE 1877
		ioA_0 = #fd40 : ioA_1 = #fd41 : ioA_2 = #fd42 : ioA_3 = #fd43
QUIGLINE 1878
		ioA_4 = #fd44 : ioA_5 = #fd45 : ioA_6 = #fd46 : ioA_7 = #fd47
QUIGLINE 1879
		ioA_8 = #fd48 : ioA_9 = #fd49 : ioA_A = #fd4a : ioA_B = #fd4b
QUIGLINE 1880
		ioA_C = #fd4c : ioA_D = #fd4d : ioA_E = #fd4e : ioA_F = #fd4f
QUIGLINE 1881

QUIGLINE 1882
		strCPU = "CPC"
QUIGLINE 1883
	EndIf
QUIGLINE 1884
	
QUIGLINE 1885
	sDb = strCPU :sysDebug
QUIGLINE 1886
EndF
QUIGLINE 1887

QUIGLINE 1888
;--------------------------------------------------------------------------	
QUIGLINE 1889
;	=== SF3
QUIGLINE 1890

QUIGLINE 1891
Function  ArmResponse:Int()
QUIGLINE 1892
	// wait  for ARM progress
QUIGLINE 1893
	//
QUIGLINE 1894
	// return 0 = ready
QUIGLINE 1895
	// return 2 = error
QUIGLINE 1896
	
QUIGLINE 1897
	
QUIGLINE 1898
	resp = 1
QUIGLINE 1899
	
QUIGLINE 1900
	//wacht = 1000
QUIGLINE 1901
	
QUIGLINE 1902
	While (resp = 1)
QUIGLINE 1903
		resp = IO.In(ioA_1)
QUIGLINE 1904
	Wend
QUIGLINE 1905
	
QUIGLINE 1906
	If  resp = 2 Then
QUIGLINE 1907
		F72_4
QUIGLINE 1908
	EndIf
QUIGLINE 1909
	
QUIGLINE 1910
	Return(resp)
QUIGLINE 1911
EndF
QUIGLINE 1912

QUIGLINE 1913

QUIGLINE 1914
;--------------------------------------------------------------------------	
QUIGLINE 1915

QUIGLINE 1916
Function	F72_4:Void()
QUIGLINE 1917
	//Error
QUIGLINE 1918
	Lock.On
QUIGLINE 1919
	sDb = "SF3 ERROR"
QUIGLINE 1920
	sysDebug
QUIGLINE 1921
	Lock.Off
QUIGLINE 1922
EndF
QUIGLINE 1923
	
QUIGLINE 1924
Function F72_25:Void()
QUIGLINE 1925
	// check firmware
QUIGLINE 1926
	
QUIGLINE 1927
	Lock.On
QUIGLINE 1928
	IO.Out ioA_1,0
QUIGLINE 1929
	IO.Out ioA_2,25
QUIGLINE 1930
	
QUIGLINE 1931
	For  x = 1 To  8
QUIGLINE 1932
		IO.Out ioA_2,Asc(Mid(strIn1,x,1))
QUIGLINE 1933
	Next
QUIGLINE 1934
	
QUIGLINE 1935
	
QUIGLINE 1936
	IO.Out ioA_1,72
QUIGLINE 1937
	
QUIGLINE 1938
	
QUIGLINE 1939
	If ArmResponse =2 Then
QUIGLINE 1940
		//nop
QUIGLINE 1941
	EndIf
QUIGLINE 1942
	
QUIGLINE 1943
	u8Out1    = IO.In(ioA_2)
QUIGLINE 1944
	
QUIGLINE 1945
	Lock.Off
QUIGLINE 1946
EndF
QUIGLINE 1947

QUIGLINE 1948

QUIGLINE 1949

QUIGLINE 1950
Function F72_26:Void()
QUIGLINE 1951
	
QUIGLINE 1952
	// Get seperate system  info
QUIGLINE 1953
	
QUIGLINE 1954
	Lock.On
QUIGLINE 1955
	IO.Out ioA_1,0
QUIGLINE 1956
	IO.Out ioA_2,26
QUIGLINE 1957
	IO.Out ioA_2,0
QUIGLINE 1958
	//in0 todo
QUIGLINE 1959
	IO.Out ioA_1,72
QUIGLINE 1960
	
QUIGLINE 1961
	If ArmResponse =2 Then
QUIGLINE 1962
		//nop
QUIGLINE 1963
	EndIf
QUIGLINE 1964
	
QUIGLINE 1965
	c = 1
QUIGLINE 1966
	strOut1 = ""
QUIGLINE 1967
	While (c  > 0)
QUIGLINE 1968
		c=  IO.In(ioA_2)
QUIGLINE 1969
		If  c > 0 Then
QUIGLINE 1970
			strOut1= strOut1	+ Chr(c)
QUIGLINE 1971
		EndIf
QUIGLINE 1972
	Wend
QUIGLINE 1973
	
QUIGLINE 1974
	Lock.Off
QUIGLINE 1975
	
QUIGLINE 1976
	
QUIGLINE 1977
EndF
QUIGLINE 1978

QUIGLINE 1979
Function F131_0:Void()
QUIGLINE 1980
	// net21  Tmtnet login
QUIGLINE 1981
	
QUIGLINE 1982
	Lock.On
QUIGLINE 1983
	IO.Out ioA_1,0
QUIGLINE 1984
	IO.Out ioA_2,0
QUIGLINE 1985
	
QUIGLINE 1986
	IO.Out ioA_1,131
QUIGLINE 1987
	
QUIGLINE 1988
	If ArmResponse =2 Then
QUIGLINE 1989
		//nop
QUIGLINE 1990
	EndIf
QUIGLINE 1991
	
QUIGLINE 1992
	u8Out1    = IO.In(ioA_2)
QUIGLINE 1993
	Lock.Off
QUIGLINE 1994
	
QUIGLINE 1995
EndF
QUIGLINE 1996
			
QUIGLINE 1997
Function F131_1:void()
QUIGLINE 1998

QUIGLINE 1999
// ------  Get stutus
QUIGLINE 2000
//
QUIGLINE 2001
// 0 = Server logoff
QUIGLINE 2002
// 1 = Server online, user logoff
QUIGLINE 2003
// 2 = User login waiting for access
QUIGLINE 2004
// 3 = User login connected
QUIGLINE 2005
// 4 = Error
QUIGLINE 2006

QUIGLINE 2007
	
QUIGLINE 2008
	Lock.On
QUIGLINE 2009
	IO.Out ioA_1,0
QUIGLINE 2010
	IO.Out ioA_2,1
QUIGLINE 2011
	IO.Out ioA_1,131
QUIGLINE 2012
	
QUIGLINE 2013
	If ArmResponse =2 Then
QUIGLINE 2014
		//nop
QUIGLINE 2015
	EndIf
QUIGLINE 2016
	
QUIGLINE 2017
	u8Out1    = IO.In(ioA_2)
QUIGLINE 2018
	
QUIGLINE 2019
	Lock.Off
QUIGLINE 2020
Endf
QUIGLINE 2021

QUIGLINE 2022
Function F131_2:void()
QUIGLINE 2023

QUIGLINE 2024
//	------ Reset userOnline array
QUIGLINE 2025

QUIGLINE 2026
	Lock.On
QUIGLINE 2027
	
QUIGLINE 2028
	IO.Out ioA_1,0
QUIGLINE 2029
	IO.Out ioA_2,2
QUIGLINE 2030
	IO.Out ioA_1,131
QUIGLINE 2031
	
QUIGLINE 2032
	If ArmResponse =2 Then
QUIGLINE 2033
		//nop
QUIGLINE 2034
	EndIf
QUIGLINE 2035
				
QUIGLINE 2036
	for fc = 0 to 20			
QUIGLINE 2037
		u16UserOnline(fc) = 0
QUIGLINE 2038
	next 
QUIGLINE 2039
	iUserOnlineTotal = 0
QUIGLINE 2040
		
QUIGLINE 2041
	Lock.Off
QUIGLINE 2042
EndF
QUIGLINE 2043

QUIGLINE 2044
Function F131_3:void()
QUIGLINE 2045

QUIGLINE 2046
//	------ F131,3 Read online status all users
QUIGLINE 2047

QUIGLINE 2048
	
QUIGLINE 2049
	
QUIGLINE 2050
	Lock.On
QUIGLINE 2051
	
QUIGLINE 2052
	IO.Out ioA_1,0
QUIGLINE 2053
	IO.Out ioA_2,3
QUIGLINE 2054
	IO.Out ioA_1,131
QUIGLINE 2055
	
QUIGLINE 2056
	If ArmResponse =2 Then
QUIGLINE 2057
		//nop
QUIGLINE 2058
	EndIf
QUIGLINE 2059

QUIGLINE 2060
	iUserOnlineTotal = 0
QUIGLINE 2061
	
QUIGLINE 2062
	for fx = 0 to 20			
QUIGLINE 2063
		fy =(IO.In(ioA_2) *256) + IO.In(ioA_2)
QUIGLINE 2064
		if (fy > 0) then
QUIGLINE 2065
			u16UserOnline(iUserOnlineTotal) = fy
QUIGLINE 2066
			iUserOnlineTotal = iUserOnlineTotal + 1 
QUIGLINE 2067
		endif
QUIGLINE 2068
	next 
QUIGLINE 2069

QUIGLINE 2070
	sDb = "F131_3 users online:"  + str(iUserOnlineTotal):sysDebug
QUIGLINE 2071
	
QUIGLINE 2072
	Lock.Off
QUIGLINE 2073
	
QUIGLINE 2074
EndF
QUIGLINE 2075

QUIGLINE 2076
Function F131_7:Void()
QUIGLINE 2077
	
QUIGLINE 2078
//	' new21 Get user info
QUIGLINE 2079
//	'  #3003,Hans,NL,CPC,
QUIGLINE 2080
	
QUIGLINE 2081
	
QUIGLINE 2082
	sDb = "131_7 in "+str(u16in1):sysDebug
QUIGLINE 2083
	
QUIGLINE 2084
	Lock.On
QUIGLINE 2085
	IO.Out ioA_1,0
QUIGLINE 2086
	IO.Out ioA_2,7
QUIGLINE 2087
	IO.Out ioA_2,(u16in1 / 256)
QUIGLINE 2088
	IO.Out ioA_2,(u16in1 And 255)
QUIGLINE 2089
	IO.Out ioA_1,131
QUIGLINE 2090
	
QUIGLINE 2091
	If ArmResponse =2 Then
QUIGLINE 2092
		//nop
QUIGLINE 2093
	EndIf
QUIGLINE 2094
	
QUIGLINE 2095
	fsw = 0
QUIGLINE 2096
	fx = 1
QUIGLINE 2097
	
QUIGLINE 2098
	strOut1 = "" 	//.. 3000
QUIGLINE 2099
	strOut2 = ""	//.. Hans
QUIGLINE 2100
	strOut3 = ""	//.. NL
QUIGLINE 2101
	strOut4 = ""	//.. CPC
QUIGLINE 2102
	
QUIGLINE 2103
	For fn = 1 To 50
QUIGLINE 2104
		fc =IO.In(ioA_2)
QUIGLINE 2105
		
QUIGLINE 2106
		If fc = 0 Then
QUIGLINE 2107
			fsw = 1
QUIGLINE 2108
		EndIf
QUIGLINE 2109
		
QUIGLINE 2110
		If  fc =35 Then
QUIGLINE 2111
			fx  = 1
QUIGLINE 2112
		EndIf
QUIGLINE 2113
		
QUIGLINE 2114
		If (fc = 35) Or (fc = 44) Then
QUIGLINE 2115
			fx = fx + 1
QUIGLINE 2116
		Else
QUIGLINE 2117
			If fsw = 0 Then
QUIGLINE 2118
				If (fc <> 32) And  (fc <> 9) Then
QUIGLINE 2119
					If fx = 2 Then
QUIGLINE 2120
						strOut1 = strOut1 + Chr(fc)
QUIGLINE 2121
					EndIf
QUIGLINE 2122
					If fx =3 Then
QUIGLINE 2123
						strOut2 = strOut2 + Chr(fc)
QUIGLINE 2124
					EndIf
QUIGLINE 2125
					If fx =4 Then
QUIGLINE 2126
						strOut3 = strOut3 + Chr(fc)			// NL
QUIGLINE 2127
					EndIf
QUIGLINE 2128
					If fx = 5 Then
QUIGLINE 2129
						strOut4 = strOut4 + Chr(fc)
QUIGLINE 2130
					EndIf
QUIGLINE 2131
				EndIf
QUIGLINE 2132
			EndIf
QUIGLINE 2133
		EndIf
QUIGLINE 2134
	Next
QUIGLINE 2135
	
QUIGLINE 2136
	
QUIGLINE 2137
	
QUIGLINE 2138
	Lock.Off
QUIGLINE 2139
EndF
QUIGLINE 2140

QUIGLINE 2141

QUIGLINE 2142

QUIGLINE 2143
Function F131_8:void()
QUIGLINE 2144

QUIGLINE 2145
//	------ 8 get userId and password
QUIGLINE 2146

QUIGLINE 2147
	Lock.On
QUIGLINE 2148
	IO.Out ioA_1,0
QUIGLINE 2149
	IO.Out ioA_2,8
QUIGLINE 2150
	IO.Out ioA_1,131
QUIGLINE 2151
	
QUIGLINE 2152
	If ArmResponse =2 Then
QUIGLINE 2153
		//nop
QUIGLINE 2154
	EndIf
QUIGLINE 2155
	
QUIGLINE 2156
	u16MyUserID = (IO.In(ioA_2) *256) + IO.In(ioA_2) 		
QUIGLINE 2157
	
QUIGLINE 2158
	strUserPass = ""
QUIGLINE 2159
	fc = 1
QUIGLINE 2160
	While (fc  > 0)
QUIGLINE 2161
		fc=  IO.In(ioA_2)
QUIGLINE 2162
		If  fc > 0 Then
QUIGLINE 2163
			strUserPass= strUserPass + Chr(fc)
QUIGLINE 2164
		EndIf
QUIGLINE 2165
	Wend
QUIGLINE 2166
							
QUIGLINE 2167
	Lock.Off
QUIGLINE 2168
EndF
QUIGLINE 2169

QUIGLINE 2170
Function F131_10:void()
QUIGLINE 2171

QUIGLINE 2172
; ------ Voip call userID
QUIGLINE 2173

QUIGLINE 2174
	Lock.On
QUIGLINE 2175
	IO.Out ioA_1,0
QUIGLINE 2176
	IO.Out ioA_2,10
QUIGLINE 2177
	IO.Out ioA_2,(u16in1 / 256)
QUIGLINE 2178
	IO.Out ioA_2,(u16in1 And 255)
QUIGLINE 2179
	IO.Out ioA_1,131
QUIGLINE 2180
	
QUIGLINE 2181
	If ArmResponse =2 Then
QUIGLINE 2182
		//nop
QUIGLINE 2183
	EndIf
QUIGLINE 2184
							
QUIGLINE 2185
	Lock.Off
QUIGLINE 2186
EndF
QUIGLINE 2187

QUIGLINE 2188
Function F131_11:void()
QUIGLINE 2189

QUIGLINE 2190
; ------ Voip call accept 
QUIGLINE 2191

QUIGLINE 2192
	Lock.On
QUIGLINE 2193
	IO.Out ioA_1,0
QUIGLINE 2194
	IO.Out ioA_2,11
QUIGLINE 2195
	IO.Out ioA_1,131
QUIGLINE 2196
	
QUIGLINE 2197
	If ArmResponse =2 Then
QUIGLINE 2198
		//nop
QUIGLINE 2199
	EndIf
QUIGLINE 2200
							
QUIGLINE 2201
	Lock.Off
QUIGLINE 2202
EndF
QUIGLINE 2203

QUIGLINE 2204
Function F131_12:void()
QUIGLINE 2205

QUIGLINE 2206
; ------ Voip Break call 
QUIGLINE 2207

QUIGLINE 2208
	Lock.On
QUIGLINE 2209
	IO.Out ioA_1,0
QUIGLINE 2210
	IO.Out ioA_2,12
QUIGLINE 2211
	IO.Out ioA_1,131
QUIGLINE 2212
	
QUIGLINE 2213
	If ArmResponse =2 Then
QUIGLINE 2214
		//nop
QUIGLINE 2215
	EndIf
QUIGLINE 2216
							
QUIGLINE 2217
	Lock.Off
QUIGLINE 2218
EndF
QUIGLINE 2219

QUIGLINE 2220
Function F131_20:void()
QUIGLINE 2221

QUIGLINE 2222
//	------ 20 chat send
QUIGLINE 2223

QUIGLINE 2224
	
QUIGLINE 2225
	
QUIGLINE 2226
	Lock.On
QUIGLINE 2227
	IO.Out ioA_1,0
QUIGLINE 2228
	IO.Out ioA_2,20
QUIGLINE 2229
			
QUIGLINE 2230
	c =  (u16Du / 256)
QUIGLINE 2231
	IO.Out ioA_2,c
QUIGLINE 2232
	c =  (u16Du and 255)
QUIGLINE 2233
	IO.Out ioA_2,c
QUIGLINE 2234

QUIGLINE 2235
//	'Send message 
QUIGLINE 2236
//?? mt
QUIGLINE 2237
	IO.Out ioA_2,0
QUIGLINE 2238
	
QUIGLINE 2239
	l = Len(strIn1)
QUIGLINE 2240
	For t = 1 To l
QUIGLINE 2241
		c = Asc(Mid(strIn1,t,1))
QUIGLINE 2242
		IO.Out ioA_2,c
QUIGLINE 2243
	Next
QUIGLINE 2244

QUIGLINE 2245
	IO.Out ioA_1,131
QUIGLINE 2246
	
QUIGLINE 2247
	If ArmResponse =2 Then
QUIGLINE 2248
		//nop
QUIGLINE 2249
	EndIf
QUIGLINE 2250
	
QUIGLINE 2251
	Lock.Off
QUIGLINE 2252
EndF
QUIGLINE 2253

QUIGLINE 2254
Function F131_21:void()
QUIGLINE 2255

QUIGLINE 2256
//	'------ 21 Read chat tx status 
QUIGLINE 2257

QUIGLINE 2258
	Lock.On
QUIGLINE 2259
	IO.Out ioA_1,0
QUIGLINE 2260
	IO.Out ioA_2,21
QUIGLINE 2261
	IO.Out ioA_1,131
QUIGLINE 2262
	
QUIGLINE 2263
	If ArmResponse =2 Then
QUIGLINE 2264
		//nop
QUIGLINE 2265
	EndIf
QUIGLINE 2266
	
QUIGLINE 2267
	u8Out1 = IO.In(ioA_2)			// 'was r
QUIGLINE 2268
							
QUIGLINE 2269
	Lock.Off
QUIGLINE 2270
EndF
QUIGLINE 2271

QUIGLINE 2272

QUIGLINE 2273
Function F131_22:void()
QUIGLINE 2274

QUIGLINE 2275
//	'------ 22 read Text message 
QUIGLINE 2276

QUIGLINE 2277
	Lock.On
QUIGLINE 2278
	IO.Out ioA_1,0
QUIGLINE 2279
	IO.Out ioA_2,22
QUIGLINE 2280
	IO.Out ioA_1,131
QUIGLINE 2281
	
QUIGLINE 2282
	If ArmResponse =2 Then
QUIGLINE 2283
		//nop
QUIGLINE 2284
	EndIf
QUIGLINE 2285
						
QUIGLINE 2286
	fy = IO.In(ioA_2)				//'Number of bytes in buffer
QUIGLINE 2287
	fc = IO.In(ioA_2)				// @ removed
QUIGLINE 2288
	
QUIGLINE 2289
	strTm = ""
QUIGLINE 2290
	For fx = 1 to fy
QUIGLINE 2291
		fc = IO.In(ioA_2)
QUIGLINE 2292
		if (fc=13) or (fc=10) then 
QUIGLINE 2293
			fc = 32
QUIGLINE 2294
		endif
QUIGLINE 2295
		strTm = strTm + Chr(fc)
QUIGLINE 2296
	Next 
QUIGLINE 2297
	
QUIGLINE 2298
	Lock.Off
QUIGLINE 2299
EndF
QUIGLINE 2300

QUIGLINE 2301

QUIGLINE 2302

QUIGLINE 2303
Function F131_32:void()
QUIGLINE 2304

QUIGLINE 2305
//	'------ 32 Set your appname
QUIGLINE 2306
	
QUIGLINE 2307
	
QUIGLINE 2308
	Lock.On
QUIGLINE 2309
	IO.Out ioA_1,0
QUIGLINE 2310
	IO.Out ioA_2,32
QUIGLINE 2311

QUIGLINE 2312
	l = Len(strIn1)
QUIGLINE 2313
	For t = 1 To l
QUIGLINE 2314
		c = Asc(Mid(strIn1,t,1))
QUIGLINE 2315
		IO.Out ioA_2,c
QUIGLINE 2316
		sDb = str(c):sysDebug
QUIGLINE 2317
	Next
QUIGLINE 2318
	IO.Out ioA_2,0
QUIGLINE 2319
	
QUIGLINE 2320
	IO.Out ioA_1,131
QUIGLINE 2321
	
QUIGLINE 2322
	If ArmResponse =2 Then
QUIGLINE 2323
		//nop
QUIGLINE 2324
	EndIf
QUIGLINE 2325
	
QUIGLINE 2326
	
QUIGLINE 2327
	
QUIGLINE 2328
	sDb = "->":sysDebug
QUIGLINE 2329
	sDb = strIn1:sysDebug
QUIGLINE 2330
	sDb = strAppname:sysDebug
QUIGLINE 2331
	sDb = "<-":sysDebug
QUIGLINE 2332
	
QUIGLINE 2333
	Lock.Off
QUIGLINE 2334
EndF
QUIGLINE 2335

QUIGLINE 2336
Function F131_33:void()
QUIGLINE 2337

QUIGLINE 2338
//	'------ 33 Send query appname
QUIGLINE 2339
	
QUIGLINE 2340
	Lock.On
QUIGLINE 2341
	IO.Out ioA_1,0
QUIGLINE 2342
	IO.Out ioA_2,33
QUIGLINE 2343
	
QUIGLINE 2344
	c =  (u16in1 / 256)
QUIGLINE 2345
	IO.Out ioA_2,c
QUIGLINE 2346
	c =  (u16in1 and 255)
QUIGLINE 2347
	IO.Out ioA_2,c
QUIGLINE 2348

QUIGLINE 2349
	IO.Out ioA_1,131
QUIGLINE 2350
	
QUIGLINE 2351
	If ArmResponse =2 Then
QUIGLINE 2352
		//nop
QUIGLINE 2353
	EndIf
QUIGLINE 2354
	
QUIGLINE 2355
	Lock.Off
QUIGLINE 2356
EndF
QUIGLINE 2357

QUIGLINE 2358
Function F131_34:void()
QUIGLINE 2359
	
QUIGLINE 2360
//	------ Read other user app 
QUIGLINE 2361
			
QUIGLINE 2362
	IO.Out ioA_1,0
QUIGLINE 2363
	IO.Out ioA_2,34
QUIGLINE 2364
	IO.Out ioA_1,131
QUIGLINE 2365
	
QUIGLINE 2366
	If ArmResponse =2 Then
QUIGLINE 2367
		//nop
QUIGLINE 2368
	EndIf				 
QUIGLINE 2369
	
QUIGLINE 2370
	fx = 1
QUIGLINE 2371
	strOut1 = ""
QUIGLINE 2372
	while((fx > 0) and (len(strOut1) < 14))
QUIGLINE 2373
		fx = IO.In(ioA_2)
QUIGLINE 2374
		if fx > 30 then 
QUIGLINE 2375
			strOut1 = strOut1 + chr(fx)
QUIGLINE 2376
		endif
QUIGLINE 2377
	wend
QUIGLINE 2378
Endf
QUIGLINE 2379

QUIGLINE 2380
				
QUIGLINE 2381
Function F131_39:void()
QUIGLINE 2382

QUIGLINE 2383
//	'------ 39 Set streammode Z80
QUIGLINE 2384
// 	' also reset  appname 
QUIGLINE 2385

QUIGLINE 2386
	Lock.On
QUIGLINE 2387
	IO.Out ioA_1,0
QUIGLINE 2388
	IO.Out ioA_2,39
QUIGLINE 2389
	IO.Out ioA_1,131
QUIGLINE 2390
	
QUIGLINE 2391
	If ArmResponse =2 Then
QUIGLINE 2392
		//nop
QUIGLINE 2393
	EndIf
QUIGLINE 2394
	
QUIGLINE 2395
	Lock.Off
QUIGLINE 2396
EndF
QUIGLINE 2397

QUIGLINE 2398

QUIGLINE 2399
;-------------------------------------------------------------------------------------------------
QUIGLINE 2400
; === SEONE 
QUIGLINE 2401

QUIGLINE 2402
Function ATCmd:Void()
QUIGLINE 2403

QUIGLINE 2404
	sDb = sAtCmd:sysDebug
QUIGLINE 2405
	
QUIGLINE 2406
	l = Len(sAtCmd)
QUIGLINE 2407
	
QUIGLINE 2408
	For t = 1 to l
QUIGLINE 2409
		c = Asc(Mid(sAtCmd,t,1))
QUIGLINE 2410
		if (c <> 32) then 
QUIGLINE 2411
			IO.Out #FF20,c
QUIGLINE 2412
		endif
QUIGLINE 2413
	Next
QUIGLINE 2414
	IO.Out  #FF20,13
QUIGLINE 2415
	
QUIGLINE 2416
	AtResponsStr
QUIGLINE 2417
EndF
QUIGLINE 2418

QUIGLINE 2419
Function AtResponsStr:Void()
QUIGLINE 2420
	//.. OK    AT+SEMODE=FM
QUIGLINE 2421
	
QUIGLINE 2422
	sAtResp = ""
QUIGLINE 2423
	sAtData = ""
QUIGLINE 2424
	
QUIGLINE 2425
	x = 0
QUIGLINE 2426
	y = 0	// switch '='
QUIGLINE 2427
	a = 0
QUIGLINE 2428
	iTimeOut = 0	
QUIGLINE 2429
	
QUIGLINE 2430
	while( a = 0) 
QUIGLINE 2431
		
QUIGLINE 2432
		c = IO.In(#FF20) 
QUIGLINE 2433
									
QUIGLINE 2434
		if ((c > 31) and (x < 50)) then 
QUIGLINE 2435
			sAtResp = sAtResp  + chr(c)
QUIGLINE 2436
			
QUIGLINE 2437
			if (y=1) then 
QUIGLINE 2438
				sAtData = sAtData  + chr(c)
QUIGLINE 2439
			endif
QUIGLINE 2440
			
QUIGLINE 2441
			if (c = 61) then  // =
QUIGLINE 2442
				y=1
QUIGLINE 2443
			endif
QUIGLINE 2444
			
QUIGLINE 2445
			
QUIGLINE 2446
			x = x + 1
QUIGLINE 2447
		endif
QUIGLINE 2448
		
QUIGLINE 2449
		if ((c = 13) or (c = 10)  ) then 
QUIGLINE 2450
			a = 1
QUIGLINE 2451
		endif
QUIGLINE 2452
		
QUIGLINE 2453
		if (x > 50) then 
QUIGLINE 2454
			a = 1
QUIGLINE 2455
		endif
QUIGLINE 2456
		
QUIGLINE 2457
		if (iTimeOut > 10000) then 
QUIGLINE 2458
			a = 1
QUIGLINE 2459
		endif
QUIGLINE 2460
		
QUIGLINE 2461
		iTimeOut = iTimeOut + 1
QUIGLINE 2462
	wend
QUIGLINE 2463
	
QUIGLINE 2464
	sDb = "AT resp:" + sAtResp:sysDebug
QUIGLINE 2465
	
QUIGLINE 2466
EndF
QUIGLINE 2467

QUIGLINE 2468

QUIGLINE 2469

QUIGLINE 2470

QUIGLINE 2471

QUIGLINE 2472

QUIGLINE 2473




    ASM
;**** Core End
.Quig_CodeEnd:db 0
;**********************
;**** Data Section ****
;**********************
.AppDatBeg
.AppFormStart:    dw Form4_Begin
.AppFormLists
    dw Form1_ControlWindowData
;**** Form Icon Data ***
;**** Form Icon ***
.Form1_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
;**** Form Icon ***
.Form2_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
;**** Form Icon ***
.Form3_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
;**** Form Icon ***
.Form4_Icon:
        db 2,8,8
     db #0F,#0F,#3F,#CF,#7F,#EF,#6F,#6F,#6F,#67,#7F,#23,#3F,#89,#0F,#0F
;**** Define User Graphics ****
.Icon24_Data
.Icon24_Data_WidthByte:     db 12
.Icon24_Data_WidthPixel:    db 24
.Icon24_Data_Height:        db 24
.Icon24_Data_DataAddr:      dw Icon24_Data_Data
.Icon24_Data_EncodeAddr:    dw Icon24_Data_Encode
.Icon24_Data_Size:          dw 288
.Icon24_Data_Encode:        db 5
.Icon24_Data_Data:          
             db 51,51,51,51,51,51,51,51,51,51,51,51
             db 48,0,0,0,0,0,0,0,0,0,0,3
             db 48,0,0,0,0,1,17,16,0,0,0,3
             db 48,0,0,1,17,18,34,33,16,0,0,3
             db 48,0,0,18,34,34,34,34,33,16,0,3
             db 48,0,1,34,34,34,34,34,34,33,0,3
             db 48,0,18,34,34,33,18,34,34,33,0,3
             db 48,0,18,34,34,16,1,34,34,33,0,3
             db 48,1,34,34,33,0,0,18,34,33,0,3
             db 48,1,34,34,33,0,0,18,34,33,0,3
             db 48,1,34,34,33,0,0,18,34,33,0,3
             db 48,1,34,34,33,0,1,34,34,16,0,3
             db 48,1,34,34,34,17,18,34,34,16,0,3
             db 48,1,34,34,34,34,34,34,33,0,0,3
             db 48,0,18,34,34,34,34,34,17,0,0,3
             db 48,0,1,34,34,34,34,33,0,0,0,3
             db 48,0,0,17,17,34,34,34,16,0,0,3
             db 48,0,0,0,0,18,34,34,33,17,16,3
             db 48,0,0,0,0,1,34,34,34,34,16,3
             db 48,0,0,0,0,0,18,34,34,34,16,3
             db 48,0,0,0,0,0,1,34,34,34,16,3
             db 48,0,0,0,0,0,0,17,17,17,16,3
             db 48,0,0,0,0,0,0,0,0,0,0,3
             db 51,51,51,51,51,51,51,51,51,51,51,51
.Sheet_Data4:                   
.Sheet_Data4_WidthByte:     db 2
.Sheet_Data4_WidthPixel:    db 1
.Sheet_Data4_Height:        db 1
.Sheet_Data4_DataAddr:      dw Sheet_Data4_Data
.Sheet_Data4_EncodeAddr:    dw Sheet_Data4_Encode
.Sheet_Data4_Size:          dw 1
.Sheet_Data4_Encode:        db 0
.Sheet_Data4_Data:          db 200,1
;**** Define User Variables ****
.File_Select_Text:   dw File_Select_Text_Data+4
.Dir_Select_Text:   dw Dir_Select_Text_Data+4
.var_wrd_ioA_0:   dw 0
.var_wrd_ioA_1:   dw 0
.var_wrd_ioA_2:   dw 0
.var_wrd_ioA_3:   dw 0
.var_wrd_ioA_4:   dw 0
.var_wrd_ioA_5:   dw 0
.var_wrd_ioA_6:   dw 0
.var_wrd_ioA_7:   dw 0
.var_wrd_ioA_8:   dw 0
.var_wrd_ioA_9:   dw 0
.var_wrd_ioA_A:   dw 0
.var_wrd_ioA_B:   dw 0
.var_wrd_ioA_C:   dw 0
.var_wrd_ioA_D:   dw 0
.var_wrd_ioA_E:   dw 0
.var_wrd_ioA_F:   dw 0
.var_wrd_resp:   dw 0
.var_byt_defNetStatusBitTx:   db 128
.var_byt_defNetStatusBitRx:   db 64
.var_byt_defNetStatusBitError:   db 32
.var_byt_defNetStatusBitVoip:   db 16
.var_byt_defNetStatusBitUser:   db 8
.var_byt_defNetStatusBitShMem:   db 4
.var_byt_defNetStatusBitMsg:   db 2
.var_byt_defNetStatusBitSys:   db 1
.var_wrd_defTileEmpty:   dw 0
.var_wrd_defTileHori:   dw 1
.var_wrd_defTileVert:   dw 2
.var_wrd_defTileBox:   dw 3
.var_wrd_defTileDot:   dw 4
.var_wrd_defVoipIdle:   dw 0
.var_wrd_defVoipOutgoingCall:   dw 1
.var_wrd_defVoipOtherBusy:   dw 2
.var_wrd_defVoipOtherOffline:   dw 3
.var_wrd_defVoipIncommingCall:   dw 4
.var_wrd_defVoipActiveCall:   dw 5
.var_str_strHardware:   dw var_str_strHardware_Data+4
.var_str_strCPU:   dw var_str_strCPU_Data+4
.var_str_strFirmware:   dw var_str_strFirmware_Data+4
.var_str_sText:   dw var_str_sText_Data+4
.var_wrd_iStpStartup:   dw 0
.var_wrd_intDelay:   dw 2
.var_wrd_intDelayCt:   dw 0
.var_str_sDb:   dw var_str_sDb_Data+4
.var_wrd_dbStp:   dw 0
.var_wrd_iDbL:   dw 0
.var_wrd_iDbT:   dw 0
.var_wrd_iDbC:   dw 0
.var_wrd_iAppExit:   dw 0
.var_wrd_iTimeOut:   dw 0
.var_wrd_fc:   dw 0
.var_wrd_fn:   dw 0
.var_wrd_fx:   dw 0
.var_wrd_fy:   dw 0
.var_wrd_fsw:   dw 0
.var_wrd_u8In1:   dw 0
.var_wrd_u8In2:   dw 0
.var_wrd_u8Out1:   dw 0
.var_wrd_u8Out2:   dw 0
.var_wrd_u8Out3:   dw 0
.var_wrd_u8Out4:   dw 0
.var_wrd_u8Out5:   dw 0
.var_wrd_u16In1:   dw 0
.var_wrd_u16Out1:   dw 0
.var_wrd_u16Out2:   dw 0
.var_wrd_u16Out3:   dw 0
.var_wrd_u16Out4:   dw 0
.var_wrd_u16Out5:   dw 0
.var_wrd_u16Out6:   dw 0
.var_wrd_u16Out7:   dw 0
.var_wrd_u16Out8:   dw 0
.var_str_strIn1:   dw var_str_strIn1_Data+4
.var_str_strOut1:   dw var_str_strOut1_Data+4
.var_str_strOut2:   dw var_str_strOut2_Data+4
.var_str_strOut3:   dw var_str_strOut3_Data+4
.var_str_strOut4:   dw var_str_strOut4_Data+4
.var_wrd_a:   dw 0
.var_wrd_t:   dw 0
.var_wrd_c:   dw 0
.var_wrd_y:   dw 0
.var_wrd_x:   dw 0
.var_wrd_l:   dw 0
.var_wrd_v:   dw 0
.var_wrd_lt:   dw 0
.var_wrd_lv:   dw 0
.var_wrd_u16Ur:   dw 0
.var_wrd_lc:   dw 0
.var_wrd_li:   dw 0
.var_wrd_bSw:   dw 0
.ar1_str_strChatText:   dw 0
                 dw ar1_str_strChatText_Data+4
                 dw ar1_str_strChatText_Data+9
                 dw ar1_str_strChatText_Data+14
                 dw ar1_str_strChatText_Data+19
                 dw ar1_str_strChatText_Data+24
.var_str_strChatInp:   dw var_str_strChatInp_Data+4
.var_wrd_u8FifoIn:   dw 0
.var_wrd_u8FifoOut:   dw 0
.var_byt_u8FifoContent:   db 0
.ar1_wrd_u16Fd:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0
.ar1_str_strFm:   dw 0
                 dw ar1_str_strFm_Data+4
                 dw ar1_str_strFm_Data+9
                 dw ar1_str_strFm_Data+14
                 dw ar1_str_strFm_Data+19
                 dw ar1_str_strFm_Data+24
                 dw ar1_str_strFm_Data+29
                 dw ar1_str_strFm_Data+34
                 dw ar1_str_strFm_Data+39
                 dw ar1_str_strFm_Data+44
                 dw ar1_str_strFm_Data+49
                 dw ar1_str_strFm_Data+54
                 dw ar1_str_strFm_Data+59
                 dw ar1_str_strFm_Data+64
                 dw ar1_str_strFm_Data+69
.var_str_strTm:   dw var_str_strTm_Data+4
.var_str_strMs:   dw var_str_strMs_Data+4
.var_wrd_u16Du:   dw 0
.var_wrd_u8Key:   dw 0
.var_byt_shDD_dot_status:   db 0
.var_byt_shDD_dot_sheet:   db 0
.var_byt_shDD_dot_tiles:   db 0
.var_wrd_shDD_dot_size:   dw 0
.var_byt_shDD_dot_bank:   db 0
.var_wrd_shDD_dot_addr:   dw 0
.var_byt_shDD_dot_colourdepth:   db 0
.var_byt_shDD_hori_status:   db 0
.var_byt_shDD_hori_sheet:   db 0
.var_byt_shDD_hori_tiles:   db 0
.var_wrd_shDD_hori_size:   dw 0
.var_byt_shDD_hori_bank:   db 0
.var_wrd_shDD_hori_addr:   dw 0
.var_byt_shDD_hori_colourdepth:   db 0
.var_byt_shDD_vert_status:   db 0
.var_byt_shDD_vert_sheet:   db 0
.var_byt_shDD_vert_tiles:   db 0
.var_wrd_shDD_vert_size:   dw 0
.var_byt_shDD_vert_bank:   db 0
.var_wrd_shDD_vert_addr:   dw 0
.var_byt_shDD_vert_colourdepth:   db 0
.var_byt_shDD_fill_status:   db 0
.var_byt_shDD_fill_sheet:   db 0
.var_byt_shDD_fill_tiles:   db 0
.var_wrd_shDD_fill_size:   dw 0
.var_byt_shDD_fill_bank:   db 0
.var_wrd_shDD_fill_addr:   dw 0
.var_byt_shDD_fill_colourdepth:   db 0
.var_byt_shDD_start_status:   db 0
.var_byt_shDD_start_sheet:   db 0
.var_byt_shDD_start_tiles:   db 0
.var_wrd_shDD_start_size:   dw 0
.var_byt_shDD_start_bank:   db 0
.var_wrd_shDD_start_addr:   dw 0
.var_byt_shDD_start_colourdepth:   db 0
.var_byt_shDD_digi_status:   db 0
.var_byt_shDD_digi_sheet:   db 0
.var_byt_shDD_digi_tiles:   db 0
.var_wrd_shDD_digi_size:   dw 0
.var_byt_shDD_digi_bank:   db 0
.var_wrd_shDD_digi_addr:   dw 0
.var_byt_shDD_digi_colourdepth:   db 0
.var_byt_shDD_voip_status:   db 0
.var_byt_shDD_voip_sheet:   db 0
.var_byt_shDD_voip_tiles:   db 0
.var_wrd_shDD_voip_size:   dw 0
.var_byt_shDD_voip_bank:   db 0
.var_wrd_shDD_voip_addr:   dw 0
.var_byt_shDD_voip_colourdepth:   db 0
.ar1_wrd_ImgIds:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0
.ar1_wrd_ImgTile:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0
.ar1_wrd_ImgTileCom:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       dw 0,0,0,0,0,0,0,0,0,0
.var_wrd_iButChoise:   dw 0
.var_wrd_iSelImg:   dw 0
.var_wrd_iGameMode:   dw 0
.var_wrd_iWinner:   dw 0
.var_wrd_iPlayer:   dw 0
.var_wrd_iPlayerActive:   dw 0
.var_wrd_bRestart:   dw 0
.var_wrd_bExit:   dw 0
.var_wrd_iRecPointer:   dw 0
.ar1_wrd_u16PlayerList:   dw 0
       dw 0,0,0
.var_wrd_u16OtherID:   dw 0
.ar1_wrd_iScore:   dw 0
       dw 0,0,0
.var_wrd_bNew_field:   dw 0
.var_wrd_bAgain:   dw 0
.var_wrd_bReSend:   dw 0
.var_wrd_iFlash:   dw 0
.var_wrd_iFlashCt:   dw 0
.var_str_strAppname:   dw var_str_strAppname_Data+4
.var_wrd_u16MyUserID:   dw 0
.var_str_strUserPass:   dw var_str_strUserPass_Data+4
.ar1_str_strPlayerName:   dw 0
                 dw ar1_str_strPlayerName_Data+4
                 dw ar1_str_strPlayerName_Data+9
                 dw ar1_str_strPlayerName_Data+14
                 dw ar1_str_strPlayerName_Data+19
.ar1_wrd_u16UserOnline:   dw 0
       dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.var_wrd_iUserOnlineTotal:   dw 0
.var_wrd_u8NetStatus:   dw 0
.var_wrd_u8h:   dw 0
.var_wrd_u8l:   dw 0
.var_wrd_u8d:   dw 0
.var_wrd_w:   dw 0
.var_wrd_iUserOnlineTimer:   dw 0
.var_str_sAtCmd:   dw var_str_sAtCmd_Data+4
.var_str_sAtResp:   dw var_str_sAtResp_Data+4
.var_str_sAtData:   dw var_str_sAtData_Data+4
.var_wrd_iVoipChgCt:   dw 0
.var_wrd_iVoipStatus:   dw 0
.var_wrd_iVoipStatusOld:   dw 0
.var_wrd_u16OtherUserId:   dw 0
.var_wrd_iVoipSoundSelect:   dw 0
.var_wrd_iVoipSoundCt:   dw 0
.var_wrd_iVoipSoundSeq:   dw 0
.var_wrd_iUserOnlinePointer:   dw 0
.var_wrd_iDelayVoipCt:   dw 0
;Spongebob
;**** String Data ****
.Quigs_String_Data_Start:
.File_Select_Text_Data:         dw File_Select_Text:dw 1:db 0
.Dir_Select_Text_Data:          dw Dir_Select_Text:dw 1:db 0
.var_str_strHardware_Data:      dw var_str_strHardware:dw 5:db "NONE",0
.var_str_strCPU_Data:           dw var_str_strCPU:dw 1:db 0
.var_str_strFirmware_Data:      dw var_str_strFirmware:dw 9:db "20250121",0
.var_str_sText_Data:            dw var_str_sText:dw 1:db 0
.var_str_sDb_Data:              dw var_str_sDb:dw 1:db 0
.var_str_strIn1_Data:           dw var_str_strIn1:dw 1:db 0
.var_str_strOut1_Data:          dw var_str_strOut1:dw 1:db 0
.var_str_strOut2_Data:          dw var_str_strOut2:dw 1:db 0
.var_str_strOut3_Data:          dw var_str_strOut3:dw 1:db 0
.var_str_strOut4_Data:          dw var_str_strOut4:dw 1:db 0
.ar1_str_strChatText_Data:      
                                dw ar1_str_strChatText+2:dw 1:db 0 
                                dw ar1_str_strChatText+4:dw 1:db 0 
                                dw ar1_str_strChatText+6:dw 1:db 0 
                                dw ar1_str_strChatText+8:dw 1:db 0 
                                dw ar1_str_strChatText+10:dw 1:db 0 
.var_str_strChatInp_Data:       dw var_str_strChatInp:dw 1:db 0
.ar1_str_strFm_Data:            
                                dw ar1_str_strFm+2:dw 1:db 0 
                                dw ar1_str_strFm+4:dw 1:db 0 
                                dw ar1_str_strFm+6:dw 1:db 0 
                                dw ar1_str_strFm+8:dw 1:db 0 
                                dw ar1_str_strFm+10:dw 1:db 0 
                                dw ar1_str_strFm+12:dw 1:db 0 
                                dw ar1_str_strFm+14:dw 1:db 0 
                                dw ar1_str_strFm+16:dw 1:db 0 
                                dw ar1_str_strFm+18:dw 1:db 0 
                                dw ar1_str_strFm+20:dw 1:db 0 
                                dw ar1_str_strFm+22:dw 1:db 0 
                                dw ar1_str_strFm+24:dw 1:db 0 
                                dw ar1_str_strFm+26:dw 1:db 0 
                                dw ar1_str_strFm+28:dw 1:db 0 
.var_str_strTm_Data:            dw var_str_strTm:dw 1:db 0
.var_str_strMs_Data:            dw var_str_strMs:dw 1:db 0
.var_str_strAppname_Data:       dw var_str_strAppname:dw 1:db 0
.var_str_strUserPass_Data:      dw var_str_strUserPass:dw 1:db 0
.ar1_str_strPlayerName_Data:    
                                dw ar1_str_strPlayerName+2:dw 1:db 0 
                                dw ar1_str_strPlayerName+4:dw 1:db 0 
                                dw ar1_str_strPlayerName+6:dw 1:db 0 
                                dw ar1_str_strPlayerName+8:dw 1:db 0 
.var_str_sAtCmd_Data:           dw var_str_sAtCmd:dw 1:db 0
.var_str_sAtResp_Data:          dw var_str_sAtResp:dw 1:db 0
.var_str_sAtData_Data:          dw var_str_sAtData:dw 1:db 0
.Quig_Dialog_1_Data:            dw Quig_Dialog_1:dw 1:db 0
.Quig_Dialog_2_Data:            dw Quig_Dialog_2:dw 1:db 0
.Quig_Dialog_3_Data:            dw Quig_Dialog_3:dw 1:db 0
.Form1_Text_Data:               dw Form1_Text:dw 8:db "Dot Box",0
.Form1_Status_Text_Data:        dw Form1_Status_Text:dw 1:db 0
.Label9_Text_Data:              dw Label9_Text:dw 7:db "TMTNET",0
.Label7_Text_Data:              dw Label7_Text:dw 5:db "....",0
.Label8_Text_Data:              dw Label8_Text:dw 5:db "....",0
.Label6_Text_Data:              dw Label6_Text:dw 8:db "Wait...",0
.Label5_Text_Data:              dw Label5_Text:dw 20:db "Version 17 jan 2025",0
.Label4_Text_Data:              dw Label4_Text:dw 39:db "Thanks to: Trebmint Edoz and Prodatron",0
.Label3_Text_Data:              dw Label3_Text:dw 1:db 0
.Label2_Text_Data:              dw Label2_Text:dw 17:db "Made by Tmtlogic",0
.Label1_Text_Data:              dw Label1_Text:dw 10:db "Chat.....",0
.Label14_Text_Data:             dw Label14_Text:dw 7:db "REPLAY",0
.Label12_Text_Data:             dw Label12_Text:dw 13:db " Score: Name",0
.Label10_Text_Data:             dw Label10_Text:dw 5:db "Name",0
.Label11_Text_Data:             dw Label11_Text:dw 5:db "Name",0
.Label13_Text_Data:             dw Label13_Text:dw 12:db " Score Name",0
.Label15_Text_Data:             dw Label15_Text:dw 5:db "HELP",0
.LabelVoip_Text_Data:           dw LabelVoip_Text:dw 10:db "INCOMMING",0
.Form2_Text_Data:               dw Form2_Text:dw 8:db "DOT BOX",0
.Form2_Status_Text_Data:        dw Form2_Status_Text:dw 1:db 0
.Label20_Text_Data:             dw Label20_Text:dw 21:db "Choose your opponent",0
.Label21_Text_Data:             dw Label21_Text:dw 5:db " ...",0
.Label23_Text_Data:             dw Label23_Text:dw 5:db " ...",0
.Label24_Text_Data:             dw Label24_Text:dw 5:db " ...",0
.Label25_Text_Data:             dw Label25_Text:dw 5:db " ...",0
.Label26_Text_Data:             dw Label26_Text:dw 6:db "App >",0
.Label22_Text_Data:             dw Label22_Text:dw 5:db " ...",0
.Form3_Text_Data:               dw Form3_Text:dw 13:db "TMTNET LOGIN",0
.Form3_Status_Text_Data:        dw Form3_Status_Text:dw 1:db 0
.Form4_Text_Data:               dw Form4_Text:dw 7:db "TMTNET",0
.Form4_Status_Text_Data:        dw Form4_Status_Text:dw 1:db 0
.Label41_Text_Data:             dw Label41_Text:dw 8:db "DOT BOX",0
.Button41_Text_Data:            dw Button41_Text:dw 4:db "---",0
.Quig_String_Count   Equ 79
.Quig_String_End_Text:   db  0,0,0,0,0


;**************************
;**** Transfer Section ****
;**************************
.AppTrnBeg
          ds    256
.AppStk   ds    6*2
          dw    AppPrz
.AppPrzN  db    0
.AppMsgB
.Event_Message       db 0         ;0 Message No 16
.Event_Form_ID       db 0         ;1 Event happned on which Form
.Event_Type          db 0         ;2 Type of Event
.Event_UserInput     db 0         ;3 Key or Mouse Event
.Event_Key_ASCII                  ; Key ASCII - Shared Byte with next
.Event_MouseX        dw 0         ;4 MouseX when event happens
.Event_MouseY        dw 0         ;6 MouseY when event happens
.Event_Control_ID    dw 0         ;8 Control ID No
.Event_8             db 0         ;10
.Event_9             db 0         ;11
.Event_10            db 0         ;12
.Event_11            db 0         ;13
.Quig_Machine_Type   db 0    ;0=464, 1=664, 2=6128, 3=464Plus, 4=6128Plus 6=Enterprise 64/128 7=MSX1 8=MSX2, 9=MSX2+, 10=MSX TurboR 12=PCW8xxx, 13=PCW9xxx
.Quig_Null_String    db 0
;**** Dialog Transfer ****
.Quig_Dialog_1:      dw Quig_Dialog_1_Data+4,6
.Quig_Dialog_2:      dw Quig_Dialog_2_Data+4,6
.Quig_Dialog_3:      dw Quig_Dialog_3_Data+4,6
.Quig_Dialog_4:      dw 0,AppIcnLrg,Icon24_Data
.Quig_App_Version:   db "",0
.Quig_App_Coder:     db "(Coder name)",0
.Quig_App_Date:   	  db "09 May 2025",0
.App_Form_List
       dw  Form1_Begin,QFunc_Form1_Open_Event,QFunc_Form1_Close_Event,0,0,0,0,Form1
       dw  Form2_Begin,QFunc_Form2_Open_Event,QFunc_Form2_Close_Event,0,0,0,0,Form2
       dw  Form3_Begin,0,0,0,0,0,0,Form3
       dw  Form4_Begin,QFunc_Form4_Open_Event,QFunc_Form4_Close_Event,0,0,0,0,Form4
.ControWindowDataList
     dw Form1_ControlWindowData
     dw 0 ;**** There is No Toolbar
     dw Form2_ControlWindowData
     dw 0 ;**** There is No Toolbar
     dw Form3_ControlWindowData
     dw 0 ;**** There is No Toolbar
     dw Form4_ControlWindowData
     dw 0 ;**** There is No Toolbar
;***
;**** Z80 version of Form Form1 ***
;***
.Form1
.Form1_Addr:                    db 0,0
.Form1_Begin:                   
.Form1_Status:                  db 128
.Form1_Display:                 db 20
.Form1_SizeAdjust:              db 20
.Form1_OwnerID:                 db 0
.Form1_Left:                    dw 0
.Form1_Top:                     dw 0
.Form1_Width:                   dw 310
.Form1_Height:                  dw 171
.Form1_OffsetWidth:             dw 1
.Form1_OffsetHeight:            dw 8
.Form1_ContentWidth:            dw 301
.Form1_ContentHeight:           dw 171
.Form1_MinWidth:                dw 0
.Form1_MinHeight:               dw 0
.Form1_MaxWidth:                dw 1024
.Form1_MaxHeight:               dw 212
.Form1_IconAddr:                dw 0
.Form1_Text:                    dw Form1_Text_Data+4
.Form1_Status_Text:             dw Form1_Status_Text_Data+4
.Form1_MenuAddr:                dw 0  ;No Menu on form
.Form1_ControlWindowAddr:       dw Form1_ControlWindow
.Form1_ControlToolAddr:         dw 0;Form1_ControlTool
.Form1_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form1_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved

;****
;**** Data Control Record (ControlWindow) ****
;****
.Form1_ControlWindow:           
.Form1_ControlWindowCount:      db 145
.Form1_ControlWindowOwnerID:    db 0
.Form1_ControlWindowDataAddr:   dw Form1_ControlWindowData
.Form1_ControlWindowCalcAddr:   dw 0; Form1_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form1_ControlWindowFocus:      db 0
     db 0
;****
.Form1_ControlWindowData:       
;**** Object Window Background Data Record ****
dw 0,255*256+0,129,  0,0,1000,1000,0
;**** Object (Image14) Data Record ****
.Image14_Display      Equ 1
.Image14
.Image14_ID:                    dw 1
.Image14_Type:                  db 10   ;*ImageBox
.Image14_ExtDataBank:           db 255
.Image14_GrInfoAddr:            dw Sheet_Data4
.Image14_Left:                  dw 114
.Image14_Top:                   dw 12
.Image14_Width:                 dw 3
.Image14_Height:                dw 10
.Image14_Code:                  dw QFunc_Image_Event
;**** Object (Image9) Data Record ****
.Image9_Display      Equ 2
.Image9
.Image9_ID:                     dw 2
.Image9_Type:                   db 10   ;*ImageBox
.Image9_ExtDataBank:            db 255
.Image9_GrInfoAddr:             dw Sheet_Data4
.Image9_Left:                   dw 163
.Image9_Top:                    dw 5
.Image9_Width:                  dw 7
.Image9_Height:                 dw 7
.Image9_Code:                   dw 0
;**** Object (Label9) Data Record ****
.Label9_Display      Equ 3
.Label9
.Label9_ID:                     dw 3
.Label9_Type:                   db 1   ;*Label
.Label9_ExtDataBank:            db 255
.Label9_ExtDataAddr:            dw Label9_ExtData
.Label9_Left:                   dw 7
.Label9_Top:                    dw 5
.Label9_Width:                  dw 40
.Label9_Height:                 dw 8
.Label9_Code:                   dw 0
;**** Object (Label7) Data Record ****
.Label7_Display      Equ 4
.Label7
.Label7_ID:                     dw 4
.Label7_Type:                   db 1   ;*Label
.Label7_ExtDataBank:            db 255
.Label7_ExtDataAddr:            dw Label7_ExtData
.Label7_Left:                   dw 7
.Label7_Top:                    dw 25
.Label7_Width:                  dw 25
.Label7_Height:                 dw 8
.Label7_Code:                   dw 0
;**** Object (Label8) Data Record ****
.Label8_Display      Equ 5
.Label8
.Label8_ID:                     dw 5
.Label8_Type:                   db 1   ;*Label
.Label8_ExtDataBank:            db 255
.Label8_ExtDataAddr:            dw Label8_ExtData
.Label8_Left:                   dw 7
.Label8_Top:                    dw 55
.Label8_Width:                  dw 25
.Label8_Height:                 dw 8
.Label8_Code:                   dw 0
;**** Object (Label6) Data Record ****
.Label6_Display      Equ 6
.Label6
.Label6_ID:                     dw 6
.Label6_Type:                   db 1   ;*Label
.Label6_ExtDataBank:            db 255
.Label6_ExtDataAddr:            dw Label6_ExtData
.Label6_Left:                   dw 0
.Label6_Top:                    dw 104
.Label6_Width:                  dw 243
.Label6_Height:                 dw 8
.Label6_Code:                   dw 0
;**** Object (Label5) Data Record ****
.Label5_Display      Equ 7
.Label5
.Label5_ID:                     dw 7
.Label5_Type:                   db 1   ;*Label
.Label5_ExtDataBank:            db 255
.Label5_ExtDataAddr:            dw Label5_ExtData
.Label5_Left:                   dw 7
.Label5_Top:                    dw 115
.Label5_Width:                  dw 233
.Label5_Height:                 dw 8
.Label5_Code:                   dw 0
;**** Object (Label4) Data Record ****
.Label4_Display      Equ 8
.Label4
.Label4_ID:                     dw 8
.Label4_Type:                   db 1   ;*Label
.Label4_ExtDataBank:            db 255
.Label4_ExtDataAddr:            dw Label4_ExtData
.Label4_Left:                   dw 7
.Label4_Top:                    dw 125
.Label4_Width:                  dw 233
.Label4_Height:                 dw 8
.Label4_Code:                   dw 0
;**** Object (Label3) Data Record ****
.Label3_Display      Equ 9
.Label3
.Label3_ID:                     dw 9
.Label3_Type:                   db 1   ;*Label
.Label3_ExtDataBank:            db 255
.Label3_ExtDataAddr:            dw Label3_ExtData
.Label3_Left:                   dw 7
.Label3_Top:                    dw 135
.Label3_Width:                  dw 233
.Label3_Height:                 dw 8
.Label3_Code:                   dw 0
;**** Object (Label2) Data Record ****
.Label2_Display      Equ 10
.Label2
.Label2_ID:                     dw 10
.Label2_Type:                   db 1   ;*Label
.Label2_ExtDataBank:            db 255
.Label2_ExtDataAddr:            dw Label2_ExtData
.Label2_Left:                   dw 7
.Label2_Top:                    dw 145
.Label2_Width:                  dw 233
.Label2_Height:                 dw 8
.Label2_Code:                   dw 0
;**** Object (Label1) Data Record ****
.Label1_Display      Equ 11
.Label1
.Label1_ID:                     dw 11
.Label1_Type:                   db 1   ;*Label
.Label1_ExtDataBank:            db 255
.Label1_ExtDataAddr:            dw Label1_ExtData
.Label1_Left:                   dw 7
.Label1_Top:                    dw 155
.Label1_Width:                  dw 233
.Label1_Height:                 dw 8
.Label1_Code:                   dw 0
;**** Object (Label14) Data Record ****
.Label14_Display      Equ 12
.Label14
.Label14_ID:                    dw 12
.Label14_Type:                  db 1   ;*Label
.Label14_ExtDataBank:           db 255
.Label14_ExtDataAddr:           dw Label14_ExtData
.Label14_Left:                  dw 273
.Label14_Top:                   dw 104
.Label14_Width:                 dw 37
.Label14_Height:                dw 8
.Label14_Code:                  dw QFunc_Label14_Event
;**** Object (Image1) Data Record ****
.Image1_Display      Equ 13
.Image1
.Image1_ID:                     dw 13
.Image1_Type:                   db 10   ;*ImageBox
.Image1_ExtDataBank:            db 255
.Image1_GrInfoAddr:             dw Sheet_Data4
.Image1_Left:                   dw 95
.Image1_Top:                    dw 5
.Image1_Width:                  dw 7
.Image1_Height:                 dw 7
.Image1_Code:                   dw 0
;**** Object (Image2) Data Record ****
.Image2_Display      Equ 14
.Image2
.Image2_ID:                     dw 14
.Image2_Type:                   db 10   ;*ImageBox
.Image2_ExtDataBank:            db 255
.Image2_GrInfoAddr:             dw Sheet_Data4
.Image2_Left:                   dw 102
.Image2_Top:                    dw 7
.Image2_Width:                  dw 10
.Image2_Height:                 dw 3
.Image2_Code:                   dw QFunc_Image_Event
;**** Object (Image3) Data Record ****
.Image3_Display      Equ 15
.Image3
.Image3_ID:                     dw 15
.Image3_Type:                   db 10   ;*ImageBox
.Image3_ExtDataBank:            db 255
.Image3_GrInfoAddr:             dw Sheet_Data4
.Image3_Left:                   dw 112
.Image3_Top:                    dw 5
.Image3_Width:                  dw 7
.Image3_Height:                 dw 7
.Image3_Code:                   dw 0
;**** Object (Image4) Data Record ****
.Image4_Display      Equ 16
.Image4
.Image4_ID:                     dw 16
.Image4_Type:                   db 10   ;*ImageBox
.Image4_ExtDataBank:            db 255
.Image4_GrInfoAddr:             dw Sheet_Data4
.Image4_Left:                   dw 119
.Image4_Top:                    dw 7
.Image4_Width:                  dw 10
.Image4_Height:                 dw 3
.Image4_Code:                   dw QFunc_Image_Event
;**** Object (Image5) Data Record ****
.Image5_Display      Equ 17
.Image5
.Image5_ID:                     dw 17
.Image5_Type:                   db 10   ;*ImageBox
.Image5_ExtDataBank:            db 255
.Image5_GrInfoAddr:             dw Sheet_Data4
.Image5_Left:                   dw 129
.Image5_Top:                    dw 5
.Image5_Width:                  dw 7
.Image5_Height:                 dw 7
.Image5_Code:                   dw 0
;**** Object (Image6) Data Record ****
.Image6_Display      Equ 18
.Image6
.Image6_ID:                     dw 18
.Image6_Type:                   db 10   ;*ImageBox
.Image6_ExtDataBank:            db 255
.Image6_GrInfoAddr:             dw Sheet_Data4
.Image6_Left:                   dw 136
.Image6_Top:                    dw 7
.Image6_Width:                  dw 10
.Image6_Height:                 dw 3
.Image6_Code:                   dw QFunc_Image_Event
;**** Object (Image7) Data Record ****
.Image7_Display      Equ 19
.Image7
.Image7_ID:                     dw 19
.Image7_Type:                   db 10   ;*ImageBox
.Image7_ExtDataBank:            db 255
.Image7_GrInfoAddr:             dw Sheet_Data4
.Image7_Left:                   dw 146
.Image7_Top:                    dw 5
.Image7_Width:                  dw 7
.Image7_Height:                 dw 7
.Image7_Code:                   dw 0
;**** Object (Image8) Data Record ****
.Image8_Display      Equ 20
.Image8
.Image8_ID:                     dw 20
.Image8_Type:                   db 10   ;*ImageBox
.Image8_ExtDataBank:            db 255
.Image8_GrInfoAddr:             dw Sheet_Data4
.Image8_Left:                   dw 153
.Image8_Top:                    dw 7
.Image8_Width:                  dw 10
.Image8_Height:                 dw 3
.Image8_Code:                   dw QFunc_Image_Event
;**** Object (Image10) Data Record ****
.Image10_Display      Equ 21
.Image10
.Image10_ID:                    dw 21
.Image10_Type:                  db 10   ;*ImageBox
.Image10_ExtDataBank:           db 255
.Image10_GrInfoAddr:            dw Sheet_Data4
.Image10_Left:                  dw 170
.Image10_Top:                   dw 7
.Image10_Width:                 dw 10
.Image10_Height:                dw 3
.Image10_Code:                  dw QFunc_Image_Event
;**** Object (Image11) Data Record ****
.Image11_Display      Equ 22
.Image11
.Image11_ID:                    dw 22
.Image11_Type:                  db 10   ;*ImageBox
.Image11_ExtDataBank:           db 255
.Image11_GrInfoAddr:            dw Sheet_Data4
.Image11_Left:                  dw 180
.Image11_Top:                   dw 5
.Image11_Width:                 dw 7
.Image11_Height:                dw 7
.Image11_Code:                  dw 0
;**** Object (Image12) Data Record ****
.Image12_Display      Equ 23
.Image12
.Image12_ID:                    dw 23
.Image12_Type:                  db 10   ;*ImageBox
.Image12_ExtDataBank:           db 255
.Image12_GrInfoAddr:            dw Sheet_Data4
.Image12_Left:                  dw 97
.Image12_Top:                   dw 12
.Image12_Width:                 dw 3
.Image12_Height:                dw 10
.Image12_Code:                  dw QFunc_Image_Event
;**** Object (Image13) Data Record ****
.Image13_Display      Equ 24
.Image13
.Image13_ID:                    dw 24
.Image13_Type:                  db 10   ;*ImageBox
.Image13_ExtDataBank:           db 255
.Image13_GrInfoAddr:            dw Sheet_Data4
.Image13_Left:                  dw 101
.Image13_Top:                   dw 11
.Image13_Width:                 dw 12
.Image13_Height:                dw 12
.Image13_Code:                  dw 0
;**** Object (Image15) Data Record ****
.Image15_Display      Equ 25
.Image15
.Image15_ID:                    dw 25
.Image15_Type:                  db 10   ;*ImageBox
.Image15_ExtDataBank:           db 255
.Image15_GrInfoAddr:            dw Sheet_Data4
.Image15_Left:                  dw 118
.Image15_Top:                   dw 11
.Image15_Width:                 dw 12
.Image15_Height:                dw 12
.Image15_Code:                  dw 0
;**** Object (Image16) Data Record ****
.Image16_Display      Equ 26
.Image16
.Image16_ID:                    dw 26
.Image16_Type:                  db 10   ;*ImageBox
.Image16_ExtDataBank:           db 255
.Image16_GrInfoAddr:            dw Sheet_Data4
.Image16_Left:                  dw 131
.Image16_Top:                   dw 12
.Image16_Width:                 dw 3
.Image16_Height:                dw 10
.Image16_Code:                  dw QFunc_Image_Event
;**** Object (Image17) Data Record ****
.Image17_Display      Equ 27
.Image17
.Image17_ID:                    dw 27
.Image17_Type:                  db 10   ;*ImageBox
.Image17_ExtDataBank:           db 255
.Image17_GrInfoAddr:            dw Sheet_Data4
.Image17_Left:                  dw 135
.Image17_Top:                   dw 11
.Image17_Width:                 dw 12
.Image17_Height:                dw 12
.Image17_Code:                  dw 0
;**** Object (Image18) Data Record ****
.Image18_Display      Equ 28
.Image18
.Image18_ID:                    dw 28
.Image18_Type:                  db 10   ;*ImageBox
.Image18_ExtDataBank:           db 255
.Image18_GrInfoAddr:            dw Sheet_Data4
.Image18_Left:                  dw 148
.Image18_Top:                   dw 12
.Image18_Width:                 dw 3
.Image18_Height:                dw 10
.Image18_Code:                  dw QFunc_Image_Event
;**** Object (Image19) Data Record ****
.Image19_Display      Equ 29
.Image19
.Image19_ID:                    dw 29
.Image19_Type:                  db 10   ;*ImageBox
.Image19_ExtDataBank:           db 255
.Image19_GrInfoAddr:            dw Sheet_Data4
.Image19_Left:                  dw 152
.Image19_Top:                   dw 11
.Image19_Width:                 dw 12
.Image19_Height:                dw 12
.Image19_Code:                  dw 0
;**** Object (Image20) Data Record ****
.Image20_Display      Equ 30
.Image20
.Image20_ID:                    dw 30
.Image20_Type:                  db 10   ;*ImageBox
.Image20_ExtDataBank:           db 255
.Image20_GrInfoAddr:            dw Sheet_Data4
.Image20_Left:                  dw 165
.Image20_Top:                   dw 12
.Image20_Width:                 dw 3
.Image20_Height:                dw 10
.Image20_Code:                  dw QFunc_Image_Event
;**** Object (Image21) Data Record ****
.Image21_Display      Equ 31
.Image21
.Image21_ID:                    dw 31
.Image21_Type:                  db 10   ;*ImageBox
.Image21_ExtDataBank:           db 255
.Image21_GrInfoAddr:            dw Sheet_Data4
.Image21_Left:                  dw 169
.Image21_Top:                   dw 11
.Image21_Width:                 dw 12
.Image21_Height:                dw 12
.Image21_Code:                  dw 0
;**** Object (Image22) Data Record ****
.Image22_Display      Equ 32
.Image22
.Image22_ID:                    dw 32
.Image22_Type:                  db 10   ;*ImageBox
.Image22_ExtDataBank:           db 255
.Image22_GrInfoAddr:            dw Sheet_Data4
.Image22_Left:                  dw 182
.Image22_Top:                   dw 12
.Image22_Width:                 dw 3
.Image22_Height:                dw 10
.Image22_Code:                  dw QFunc_Image_Event
;**** Object (Image23) Data Record ****
.Image23_Display      Equ 33
.Image23
.Image23_ID:                    dw 33
.Image23_Type:                  db 10   ;*ImageBox
.Image23_ExtDataBank:           db 255
.Image23_GrInfoAddr:            dw Sheet_Data4
.Image23_Left:                  dw 95
.Image23_Top:                   dw 22
.Image23_Width:                 dw 7
.Image23_Height:                dw 7
.Image23_Code:                  dw 0
;**** Object (Image24) Data Record ****
.Image24_Display      Equ 34
.Image24
.Image24_ID:                    dw 34
.Image24_Type:                  db 10   ;*ImageBox
.Image24_ExtDataBank:           db 255
.Image24_GrInfoAddr:            dw Sheet_Data4
.Image24_Left:                  dw 102
.Image24_Top:                   dw 24
.Image24_Width:                 dw 10
.Image24_Height:                dw 3
.Image24_Code:                  dw QFunc_Image_Event
;**** Object (Image25) Data Record ****
.Image25_Display      Equ 35
.Image25
.Image25_ID:                    dw 35
.Image25_Type:                  db 10   ;*ImageBox
.Image25_ExtDataBank:           db 255
.Image25_GrInfoAddr:            dw Sheet_Data4
.Image25_Left:                  dw 112
.Image25_Top:                   dw 22
.Image25_Width:                 dw 7
.Image25_Height:                dw 7
.Image25_Code:                  dw 0
;**** Object (Image26) Data Record ****
.Image26_Display      Equ 36
.Image26
.Image26_ID:                    dw 36
.Image26_Type:                  db 10   ;*ImageBox
.Image26_ExtDataBank:           db 255
.Image26_GrInfoAddr:            dw Sheet_Data4
.Image26_Left:                  dw 119
.Image26_Top:                   dw 24
.Image26_Width:                 dw 10
.Image26_Height:                dw 3
.Image26_Code:                  dw QFunc_Image_Event
;**** Object (Image27) Data Record ****
.Image27_Display      Equ 37
.Image27
.Image27_ID:                    dw 37
.Image27_Type:                  db 10   ;*ImageBox
.Image27_ExtDataBank:           db 255
.Image27_GrInfoAddr:            dw Sheet_Data4
.Image27_Left:                  dw 129
.Image27_Top:                   dw 22
.Image27_Width:                 dw 7
.Image27_Height:                dw 7
.Image27_Code:                  dw 0
;**** Object (Image28) Data Record ****
.Image28_Display      Equ 38
.Image28
.Image28_ID:                    dw 38
.Image28_Type:                  db 10   ;*ImageBox
.Image28_ExtDataBank:           db 255
.Image28_GrInfoAddr:            dw Sheet_Data4
.Image28_Left:                  dw 136
.Image28_Top:                   dw 24
.Image28_Width:                 dw 10
.Image28_Height:                dw 3
.Image28_Code:                  dw QFunc_Image_Event
;**** Object (Image29) Data Record ****
.Image29_Display      Equ 39
.Image29
.Image29_ID:                    dw 39
.Image29_Type:                  db 10   ;*ImageBox
.Image29_ExtDataBank:           db 255
.Image29_GrInfoAddr:            dw Sheet_Data4
.Image29_Left:                  dw 146
.Image29_Top:                   dw 22
.Image29_Width:                 dw 7
.Image29_Height:                dw 7
.Image29_Code:                  dw 0
;**** Object (Image30) Data Record ****
.Image30_Display      Equ 40
.Image30
.Image30_ID:                    dw 40
.Image30_Type:                  db 10   ;*ImageBox
.Image30_ExtDataBank:           db 255
.Image30_GrInfoAddr:            dw Sheet_Data4
.Image30_Left:                  dw 153
.Image30_Top:                   dw 24
.Image30_Width:                 dw 10
.Image30_Height:                dw 3
.Image30_Code:                  dw QFunc_Image_Event
;**** Object (Image31) Data Record ****
.Image31_Display      Equ 41
.Image31
.Image31_ID:                    dw 41
.Image31_Type:                  db 10   ;*ImageBox
.Image31_ExtDataBank:           db 255
.Image31_GrInfoAddr:            dw Sheet_Data4
.Image31_Left:                  dw 163
.Image31_Top:                   dw 22
.Image31_Width:                 dw 7
.Image31_Height:                dw 7
.Image31_Code:                  dw 0
;**** Object (Image32) Data Record ****
.Image32_Display      Equ 42
.Image32
.Image32_ID:                    dw 42
.Image32_Type:                  db 10   ;*ImageBox
.Image32_ExtDataBank:           db 255
.Image32_GrInfoAddr:            dw Sheet_Data4
.Image32_Left:                  dw 170
.Image32_Top:                   dw 24
.Image32_Width:                 dw 10
.Image32_Height:                dw 3
.Image32_Code:                  dw QFunc_Image_Event
;**** Object (Image33) Data Record ****
.Image33_Display      Equ 43
.Image33
.Image33_ID:                    dw 43
.Image33_Type:                  db 10   ;*ImageBox
.Image33_ExtDataBank:           db 255
.Image33_GrInfoAddr:            dw Sheet_Data4
.Image33_Left:                  dw 180
.Image33_Top:                   dw 22
.Image33_Width:                 dw 7
.Image33_Height:                dw 7
.Image33_Code:                  dw 0
;**** Object (Image34) Data Record ****
.Image34_Display      Equ 44
.Image34
.Image34_ID:                    dw 44
.Image34_Type:                  db 10   ;*ImageBox
.Image34_ExtDataBank:           db 255
.Image34_GrInfoAddr:            dw Sheet_Data4
.Image34_Left:                  dw 97
.Image34_Top:                   dw 29
.Image34_Width:                 dw 3
.Image34_Height:                dw 10
.Image34_Code:                  dw QFunc_Image_Event
;**** Object (Image45) Data Record ****
.Image45_Display      Equ 45
.Image45
.Image45_ID:                    dw 45
.Image45_Type:                  db 10   ;*ImageBox
.Image45_ExtDataBank:           db 255
.Image45_GrInfoAddr:            dw Sheet_Data4
.Image45_Left:                  dw 95
.Image45_Top:                   dw 39
.Image45_Width:                 dw 7
.Image45_Height:                dw 7
.Image45_Code:                  dw 0
;**** Object (Image46) Data Record ****
.Image46_Display      Equ 46
.Image46
.Image46_ID:                    dw 46
.Image46_Type:                  db 10   ;*ImageBox
.Image46_ExtDataBank:           db 255
.Image46_GrInfoAddr:            dw Sheet_Data4
.Image46_Left:                  dw 102
.Image46_Top:                   dw 41
.Image46_Width:                 dw 10
.Image46_Height:                dw 3
.Image46_Code:                  dw QFunc_Image_Event
;**** Object (Image47) Data Record ****
.Image47_Display      Equ 47
.Image47
.Image47_ID:                    dw 47
.Image47_Type:                  db 10   ;*ImageBox
.Image47_ExtDataBank:           db 255
.Image47_GrInfoAddr:            dw Sheet_Data4
.Image47_Left:                  dw 112
.Image47_Top:                   dw 39
.Image47_Width:                 dw 7
.Image47_Height:                dw 7
.Image47_Code:                  dw 0
;**** Object (Image36) Data Record ****
.Image36_Display      Equ 48
.Image36
.Image36_ID:                    dw 48
.Image36_Type:                  db 10   ;*ImageBox
.Image36_ExtDataBank:           db 255
.Image36_GrInfoAddr:            dw Sheet_Data4
.Image36_Left:                  dw 114
.Image36_Top:                   dw 29
.Image36_Width:                 dw 3
.Image36_Height:                dw 10
.Image36_Code:                  dw QFunc_Image_Event
;**** Object (Image48) Data Record ****
.Image48_Display      Equ 49
.Image48
.Image48_ID:                    dw 49
.Image48_Type:                  db 10   ;*ImageBox
.Image48_ExtDataBank:           db 255
.Image48_GrInfoAddr:            dw Sheet_Data4
.Image48_Left:                  dw 119
.Image48_Top:                   dw 41
.Image48_Width:                 dw 10
.Image48_Height:                dw 3
.Image48_Code:                  dw QFunc_Image_Event
;**** Object (Image49) Data Record ****
.Image49_Display      Equ 50
.Image49
.Image49_ID:                    dw 50
.Image49_Type:                  db 10   ;*ImageBox
.Image49_ExtDataBank:           db 255
.Image49_GrInfoAddr:            dw Sheet_Data4
.Image49_Left:                  dw 129
.Image49_Top:                   dw 39
.Image49_Width:                 dw 7
.Image49_Height:                dw 7
.Image49_Code:                  dw 0
;**** Object (Image38) Data Record ****
.Image38_Display      Equ 51
.Image38
.Image38_ID:                    dw 51
.Image38_Type:                  db 10   ;*ImageBox
.Image38_ExtDataBank:           db 255
.Image38_GrInfoAddr:            dw Sheet_Data4
.Image38_Left:                  dw 131
.Image38_Top:                   dw 29
.Image38_Width:                 dw 3
.Image38_Height:                dw 10
.Image38_Code:                  dw QFunc_Image_Event
;**** Object (Image50) Data Record ****
.Image50_Display      Equ 52
.Image50
.Image50_ID:                    dw 52
.Image50_Type:                  db 10   ;*ImageBox
.Image50_ExtDataBank:           db 255
.Image50_GrInfoAddr:            dw Sheet_Data4
.Image50_Left:                  dw 136
.Image50_Top:                   dw 41
.Image50_Width:                 dw 10
.Image50_Height:                dw 3
.Image50_Code:                  dw QFunc_Image_Event
;**** Object (Image51) Data Record ****
.Image51_Display      Equ 53
.Image51
.Image51_ID:                    dw 53
.Image51_Type:                  db 10   ;*ImageBox
.Image51_ExtDataBank:           db 255
.Image51_GrInfoAddr:            dw Sheet_Data4
.Image51_Left:                  dw 146
.Image51_Top:                   dw 39
.Image51_Width:                 dw 7
.Image51_Height:                dw 7
.Image51_Code:                  dw 0
;**** Object (Image40) Data Record ****
.Image40_Display      Equ 54
.Image40
.Image40_ID:                    dw 54
.Image40_Type:                  db 10   ;*ImageBox
.Image40_ExtDataBank:           db 255
.Image40_GrInfoAddr:            dw Sheet_Data4
.Image40_Left:                  dw 148
.Image40_Top:                   dw 29
.Image40_Width:                 dw 3
.Image40_Height:                dw 10
.Image40_Code:                  dw QFunc_Image_Event
;**** Object (Image52) Data Record ****
.Image52_Display      Equ 55
.Image52
.Image52_ID:                    dw 55
.Image52_Type:                  db 10   ;*ImageBox
.Image52_ExtDataBank:           db 255
.Image52_GrInfoAddr:            dw Sheet_Data4
.Image52_Left:                  dw 153
.Image52_Top:                   dw 41
.Image52_Width:                 dw 10
.Image52_Height:                dw 3
.Image52_Code:                  dw QFunc_Image_Event
;**** Object (Image53) Data Record ****
.Image53_Display      Equ 56
.Image53
.Image53_ID:                    dw 56
.Image53_Type:                  db 10   ;*ImageBox
.Image53_ExtDataBank:           db 255
.Image53_GrInfoAddr:            dw Sheet_Data4
.Image53_Left:                  dw 163
.Image53_Top:                   dw 39
.Image53_Width:                 dw 7
.Image53_Height:                dw 7
.Image53_Code:                  dw 0
;**** Object (Image42) Data Record ****
.Image42_Display      Equ 57
.Image42
.Image42_ID:                    dw 57
.Image42_Type:                  db 10   ;*ImageBox
.Image42_ExtDataBank:           db 255
.Image42_GrInfoAddr:            dw Sheet_Data4
.Image42_Left:                  dw 165
.Image42_Top:                   dw 29
.Image42_Width:                 dw 3
.Image42_Height:                dw 10
.Image42_Code:                  dw QFunc_Image_Event
;**** Object (Image54) Data Record ****
.Image54_Display      Equ 58
.Image54
.Image54_ID:                    dw 58
.Image54_Type:                  db 10   ;*ImageBox
.Image54_ExtDataBank:           db 255
.Image54_GrInfoAddr:            dw Sheet_Data4
.Image54_Left:                  dw 170
.Image54_Top:                   dw 41
.Image54_Width:                 dw 10
.Image54_Height:                dw 3
.Image54_Code:                  dw QFunc_Image_Event
;**** Object (Image55) Data Record ****
.Image55_Display      Equ 59
.Image55
.Image55_ID:                    dw 59
.Image55_Type:                  db 10   ;*ImageBox
.Image55_ExtDataBank:           db 255
.Image55_GrInfoAddr:            dw Sheet_Data4
.Image55_Left:                  dw 180
.Image55_Top:                   dw 39
.Image55_Width:                 dw 7
.Image55_Height:                dw 7
.Image55_Code:                  dw 0
;**** Object (Image44) Data Record ****
.Image44_Display      Equ 60
.Image44
.Image44_ID:                    dw 60
.Image44_Type:                  db 10   ;*ImageBox
.Image44_ExtDataBank:           db 255
.Image44_GrInfoAddr:            dw Sheet_Data4
.Image44_Left:                  dw 182
.Image44_Top:                   dw 29
.Image44_Width:                 dw 3
.Image44_Height:                dw 10
.Image44_Code:                  dw QFunc_Image_Event
;**** Object (Image35) Data Record ****
.Image35_Display      Equ 61
.Image35
.Image35_ID:                    dw 61
.Image35_Type:                  db 10   ;*ImageBox
.Image35_ExtDataBank:           db 255
.Image35_GrInfoAddr:            dw Sheet_Data4
.Image35_Left:                  dw 101
.Image35_Top:                   dw 28
.Image35_Width:                 dw 12
.Image35_Height:                dw 12
.Image35_Code:                  dw 0
;**** Object (Image37) Data Record ****
.Image37_Display      Equ 62
.Image37
.Image37_ID:                    dw 62
.Image37_Type:                  db 10   ;*ImageBox
.Image37_ExtDataBank:           db 255
.Image37_GrInfoAddr:            dw Sheet_Data4
.Image37_Left:                  dw 118
.Image37_Top:                   dw 28
.Image37_Width:                 dw 12
.Image37_Height:                dw 12
.Image37_Code:                  dw 0
;**** Object (Image39) Data Record ****
.Image39_Display      Equ 63
.Image39
.Image39_ID:                    dw 63
.Image39_Type:                  db 10   ;*ImageBox
.Image39_ExtDataBank:           db 255
.Image39_GrInfoAddr:            dw Sheet_Data4
.Image39_Left:                  dw 135
.Image39_Top:                   dw 28
.Image39_Width:                 dw 12
.Image39_Height:                dw 12
.Image39_Code:                  dw 0
;**** Object (Image41) Data Record ****
.Image41_Display      Equ 64
.Image41
.Image41_ID:                    dw 64
.Image41_Type:                  db 10   ;*ImageBox
.Image41_ExtDataBank:           db 255
.Image41_GrInfoAddr:            dw Sheet_Data4
.Image41_Left:                  dw 152
.Image41_Top:                   dw 28
.Image41_Width:                 dw 12
.Image41_Height:                dw 12
.Image41_Code:                  dw 0
;**** Object (Image43) Data Record ****
.Image43_Display      Equ 65
.Image43
.Image43_ID:                    dw 65
.Image43_Type:                  db 10   ;*ImageBox
.Image43_ExtDataBank:           db 255
.Image43_GrInfoAddr:            dw Sheet_Data4
.Image43_Left:                  dw 169
.Image43_Top:                   dw 28
.Image43_Width:                 dw 12
.Image43_Height:                dw 12
.Image43_Code:                  dw 0
;**** Object (Image56) Data Record ****
.Image56_Display      Equ 66
.Image56
.Image56_ID:                    dw 66
.Image56_Type:                  db 10   ;*ImageBox
.Image56_ExtDataBank:           db 255
.Image56_GrInfoAddr:            dw Sheet_Data4
.Image56_Left:                  dw 97
.Image56_Top:                   dw 46
.Image56_Width:                 dw 3
.Image56_Height:                dw 10
.Image56_Code:                  dw QFunc_Image_Event
;**** Object (Image67) Data Record ****
.Image67_Display      Equ 67
.Image67
.Image67_ID:                    dw 67
.Image67_Type:                  db 10   ;*ImageBox
.Image67_ExtDataBank:           db 255
.Image67_GrInfoAddr:            dw Sheet_Data4
.Image67_Left:                  dw 95
.Image67_Top:                   dw 56
.Image67_Width:                 dw 7
.Image67_Height:                dw 7
.Image67_Code:                  dw 0
;**** Object (Image68) Data Record ****
.Image68_Display      Equ 68
.Image68
.Image68_ID:                    dw 68
.Image68_Type:                  db 10   ;*ImageBox
.Image68_ExtDataBank:           db 255
.Image68_GrInfoAddr:            dw Sheet_Data4
.Image68_Left:                  dw 102
.Image68_Top:                   dw 58
.Image68_Width:                 dw 10
.Image68_Height:                dw 3
.Image68_Code:                  dw QFunc_Image_Event
;**** Object (Image69) Data Record ****
.Image69_Display      Equ 69
.Image69
.Image69_ID:                    dw 69
.Image69_Type:                  db 10   ;*ImageBox
.Image69_ExtDataBank:           db 255
.Image69_GrInfoAddr:            dw Sheet_Data4
.Image69_Left:                  dw 112
.Image69_Top:                   dw 56
.Image69_Width:                 dw 7
.Image69_Height:                dw 7
.Image69_Code:                  dw 0
;**** Object (Image58) Data Record ****
.Image58_Display      Equ 70
.Image58
.Image58_ID:                    dw 70
.Image58_Type:                  db 10   ;*ImageBox
.Image58_ExtDataBank:           db 255
.Image58_GrInfoAddr:            dw Sheet_Data4
.Image58_Left:                  dw 114
.Image58_Top:                   dw 46
.Image58_Width:                 dw 3
.Image58_Height:                dw 10
.Image58_Code:                  dw QFunc_Image_Event
;**** Object (Image70) Data Record ****
.Image70_Display      Equ 71
.Image70
.Image70_ID:                    dw 71
.Image70_Type:                  db 10   ;*ImageBox
.Image70_ExtDataBank:           db 255
.Image70_GrInfoAddr:            dw Sheet_Data4
.Image70_Left:                  dw 119
.Image70_Top:                   dw 58
.Image70_Width:                 dw 10
.Image70_Height:                dw 3
.Image70_Code:                  dw QFunc_Image_Event
;**** Object (Image71) Data Record ****
.Image71_Display      Equ 72
.Image71
.Image71_ID:                    dw 72
.Image71_Type:                  db 10   ;*ImageBox
.Image71_ExtDataBank:           db 255
.Image71_GrInfoAddr:            dw Sheet_Data4
.Image71_Left:                  dw 129
.Image71_Top:                   dw 56
.Image71_Width:                 dw 7
.Image71_Height:                dw 7
.Image71_Code:                  dw 0
;**** Object (Image60) Data Record ****
.Image60_Display      Equ 73
.Image60
.Image60_ID:                    dw 73
.Image60_Type:                  db 10   ;*ImageBox
.Image60_ExtDataBank:           db 255
.Image60_GrInfoAddr:            dw Sheet_Data4
.Image60_Left:                  dw 131
.Image60_Top:                   dw 46
.Image60_Width:                 dw 3
.Image60_Height:                dw 10
.Image60_Code:                  dw QFunc_Image_Event
;**** Object (Image72) Data Record ****
.Image72_Display      Equ 74
.Image72
.Image72_ID:                    dw 74
.Image72_Type:                  db 10   ;*ImageBox
.Image72_ExtDataBank:           db 255
.Image72_GrInfoAddr:            dw Sheet_Data4
.Image72_Left:                  dw 136
.Image72_Top:                   dw 58
.Image72_Width:                 dw 10
.Image72_Height:                dw 3
.Image72_Code:                  dw QFunc_Image_Event
;**** Object (Image73) Data Record ****
.Image73_Display      Equ 75
.Image73
.Image73_ID:                    dw 75
.Image73_Type:                  db 10   ;*ImageBox
.Image73_ExtDataBank:           db 255
.Image73_GrInfoAddr:            dw Sheet_Data4
.Image73_Left:                  dw 146
.Image73_Top:                   dw 56
.Image73_Width:                 dw 7
.Image73_Height:                dw 7
.Image73_Code:                  dw 0
;**** Object (Image62) Data Record ****
.Image62_Display      Equ 76
.Image62
.Image62_ID:                    dw 76
.Image62_Type:                  db 10   ;*ImageBox
.Image62_ExtDataBank:           db 255
.Image62_GrInfoAddr:            dw Sheet_Data4
.Image62_Left:                  dw 148
.Image62_Top:                   dw 46
.Image62_Width:                 dw 3
.Image62_Height:                dw 10
.Image62_Code:                  dw QFunc_Image_Event
;**** Object (Image74) Data Record ****
.Image74_Display      Equ 77
.Image74
.Image74_ID:                    dw 77
.Image74_Type:                  db 10   ;*ImageBox
.Image74_ExtDataBank:           db 255
.Image74_GrInfoAddr:            dw Sheet_Data4
.Image74_Left:                  dw 153
.Image74_Top:                   dw 58
.Image74_Width:                 dw 10
.Image74_Height:                dw 3
.Image74_Code:                  dw QFunc_Image_Event
;**** Object (Image75) Data Record ****
.Image75_Display      Equ 78
.Image75
.Image75_ID:                    dw 78
.Image75_Type:                  db 10   ;*ImageBox
.Image75_ExtDataBank:           db 255
.Image75_GrInfoAddr:            dw Sheet_Data4
.Image75_Left:                  dw 163
.Image75_Top:                   dw 56
.Image75_Width:                 dw 7
.Image75_Height:                dw 7
.Image75_Code:                  dw 0
;**** Object (Image64) Data Record ****
.Image64_Display      Equ 79
.Image64
.Image64_ID:                    dw 79
.Image64_Type:                  db 10   ;*ImageBox
.Image64_ExtDataBank:           db 255
.Image64_GrInfoAddr:            dw Sheet_Data4
.Image64_Left:                  dw 165
.Image64_Top:                   dw 46
.Image64_Width:                 dw 3
.Image64_Height:                dw 10
.Image64_Code:                  dw QFunc_Image_Event
;**** Object (Image76) Data Record ****
.Image76_Display      Equ 80
.Image76
.Image76_ID:                    dw 80
.Image76_Type:                  db 10   ;*ImageBox
.Image76_ExtDataBank:           db 255
.Image76_GrInfoAddr:            dw Sheet_Data4
.Image76_Left:                  dw 170
.Image76_Top:                   dw 58
.Image76_Width:                 dw 10
.Image76_Height:                dw 3
.Image76_Code:                  dw QFunc_Image_Event
;**** Object (Image77) Data Record ****
.Image77_Display      Equ 81
.Image77
.Image77_ID:                    dw 81
.Image77_Type:                  db 10   ;*ImageBox
.Image77_ExtDataBank:           db 255
.Image77_GrInfoAddr:            dw Sheet_Data4
.Image77_Left:                  dw 180
.Image77_Top:                   dw 56
.Image77_Width:                 dw 7
.Image77_Height:                dw 7
.Image77_Code:                  dw 0
;**** Object (Image66) Data Record ****
.Image66_Display      Equ 82
.Image66
.Image66_ID:                    dw 82
.Image66_Type:                  db 10   ;*ImageBox
.Image66_ExtDataBank:           db 255
.Image66_GrInfoAddr:            dw Sheet_Data4
.Image66_Left:                  dw 182
.Image66_Top:                   dw 46
.Image66_Width:                 dw 3
.Image66_Height:                dw 10
.Image66_Code:                  dw QFunc_Image_Event
;**** Object (Image57) Data Record ****
.Image57_Display      Equ 83
.Image57
.Image57_ID:                    dw 83
.Image57_Type:                  db 10   ;*ImageBox
.Image57_ExtDataBank:           db 255
.Image57_GrInfoAddr:            dw Sheet_Data4
.Image57_Left:                  dw 101
.Image57_Top:                   dw 45
.Image57_Width:                 dw 12
.Image57_Height:                dw 12
.Image57_Code:                  dw 0
;**** Object (Image59) Data Record ****
.Image59_Display      Equ 84
.Image59
.Image59_ID:                    dw 84
.Image59_Type:                  db 10   ;*ImageBox
.Image59_ExtDataBank:           db 255
.Image59_GrInfoAddr:            dw Sheet_Data4
.Image59_Left:                  dw 118
.Image59_Top:                   dw 45
.Image59_Width:                 dw 12
.Image59_Height:                dw 12
.Image59_Code:                  dw 0
;**** Object (Image61) Data Record ****
.Image61_Display      Equ 85
.Image61
.Image61_ID:                    dw 85
.Image61_Type:                  db 10   ;*ImageBox
.Image61_ExtDataBank:           db 255
.Image61_GrInfoAddr:            dw Sheet_Data4
.Image61_Left:                  dw 135
.Image61_Top:                   dw 45
.Image61_Width:                 dw 12
.Image61_Height:                dw 12
.Image61_Code:                  dw 0
;**** Object (Image63) Data Record ****
.Image63_Display      Equ 86
.Image63
.Image63_ID:                    dw 86
.Image63_Type:                  db 10   ;*ImageBox
.Image63_ExtDataBank:           db 255
.Image63_GrInfoAddr:            dw Sheet_Data4
.Image63_Left:                  dw 152
.Image63_Top:                   dw 45
.Image63_Width:                 dw 12
.Image63_Height:                dw 12
.Image63_Code:                  dw 0
;**** Object (Image65) Data Record ****
.Image65_Display      Equ 87
.Image65
.Image65_ID:                    dw 87
.Image65_Type:                  db 10   ;*ImageBox
.Image65_ExtDataBank:           db 255
.Image65_GrInfoAddr:            dw Sheet_Data4
.Image65_Left:                  dw 169
.Image65_Top:                   dw 45
.Image65_Width:                 dw 12
.Image65_Height:                dw 12
.Image65_Code:                  dw 0
;**** Object (Image78) Data Record ****
.Image78_Display      Equ 88
.Image78
.Image78_ID:                    dw 88
.Image78_Type:                  db 10   ;*ImageBox
.Image78_ExtDataBank:           db 255
.Image78_GrInfoAddr:            dw Sheet_Data4
.Image78_Left:                  dw 97
.Image78_Top:                   dw 63
.Image78_Width:                 dw 3
.Image78_Height:                dw 10
.Image78_Code:                  dw QFunc_Image_Event
;**** Object (Image79) Data Record ****
.Image79_Display      Equ 89
.Image79
.Image79_ID:                    dw 89
.Image79_Type:                  db 10   ;*ImageBox
.Image79_ExtDataBank:           db 255
.Image79_GrInfoAddr:            dw Sheet_Data4
.Image79_Left:                  dw 101
.Image79_Top:                   dw 62
.Image79_Width:                 dw 12
.Image79_Height:                dw 12
.Image79_Code:                  dw QFunc_Image_Event
;**** Object (Image80) Data Record ****
.Image80_Display      Equ 90
.Image80
.Image80_ID:                    dw 90
.Image80_Type:                  db 10   ;*ImageBox
.Image80_ExtDataBank:           db 255
.Image80_GrInfoAddr:            dw Sheet_Data4
.Image80_Left:                  dw 114
.Image80_Top:                   dw 63
.Image80_Width:                 dw 3
.Image80_Height:                dw 10
.Image80_Code:                  dw QFunc_Image_Event
;**** Object (Image81) Data Record ****
.Image81_Display      Equ 91
.Image81
.Image81_ID:                    dw 91
.Image81_Type:                  db 10   ;*ImageBox
.Image81_ExtDataBank:           db 255
.Image81_GrInfoAddr:            dw Sheet_Data4
.Image81_Left:                  dw 118
.Image81_Top:                   dw 62
.Image81_Width:                 dw 12
.Image81_Height:                dw 12
.Image81_Code:                  dw 0
;**** Object (Image82) Data Record ****
.Image82_Display      Equ 92
.Image82
.Image82_ID:                    dw 92
.Image82_Type:                  db 10   ;*ImageBox
.Image82_ExtDataBank:           db 255
.Image82_GrInfoAddr:            dw Sheet_Data4
.Image82_Left:                  dw 131
.Image82_Top:                   dw 63
.Image82_Width:                 dw 3
.Image82_Height:                dw 10
.Image82_Code:                  dw QFunc_Image_Event
;**** Object (Image83) Data Record ****
.Image83_Display      Equ 93
.Image83
.Image83_ID:                    dw 93
.Image83_Type:                  db 10   ;*ImageBox
.Image83_ExtDataBank:           db 255
.Image83_GrInfoAddr:            dw Sheet_Data4
.Image83_Left:                  dw 135
.Image83_Top:                   dw 62
.Image83_Width:                 dw 12
.Image83_Height:                dw 12
.Image83_Code:                  dw 0
;**** Object (Image84) Data Record ****
.Image84_Display      Equ 94
.Image84
.Image84_ID:                    dw 94
.Image84_Type:                  db 10   ;*ImageBox
.Image84_ExtDataBank:           db 255
.Image84_GrInfoAddr:            dw Sheet_Data4
.Image84_Left:                  dw 148
.Image84_Top:                   dw 63
.Image84_Width:                 dw 3
.Image84_Height:                dw 10
.Image84_Code:                  dw QFunc_Image_Event
;**** Object (Image85) Data Record ****
.Image85_Display      Equ 95
.Image85
.Image85_ID:                    dw 95
.Image85_Type:                  db 10   ;*ImageBox
.Image85_ExtDataBank:           db 255
.Image85_GrInfoAddr:            dw Sheet_Data4
.Image85_Left:                  dw 152
.Image85_Top:                   dw 62
.Image85_Width:                 dw 12
.Image85_Height:                dw 12
.Image85_Code:                  dw 0
;**** Object (Image86) Data Record ****
.Image86_Display      Equ 96
.Image86
.Image86_ID:                    dw 96
.Image86_Type:                  db 10   ;*ImageBox
.Image86_ExtDataBank:           db 255
.Image86_GrInfoAddr:            dw Sheet_Data4
.Image86_Left:                  dw 165
.Image86_Top:                   dw 63
.Image86_Width:                 dw 3
.Image86_Height:                dw 10
.Image86_Code:                  dw QFunc_Image_Event
;**** Object (Image87) Data Record ****
.Image87_Display      Equ 97
.Image87
.Image87_ID:                    dw 97
.Image87_Type:                  db 10   ;*ImageBox
.Image87_ExtDataBank:           db 255
.Image87_GrInfoAddr:            dw Sheet_Data4
.Image87_Left:                  dw 169
.Image87_Top:                   dw 62
.Image87_Width:                 dw 12
.Image87_Height:                dw 12
.Image87_Code:                  dw 0
;**** Object (Image88) Data Record ****
.Image88_Display      Equ 98
.Image88
.Image88_ID:                    dw 98
.Image88_Type:                  db 10   ;*ImageBox
.Image88_ExtDataBank:           db 255
.Image88_GrInfoAddr:            dw Sheet_Data4
.Image88_Left:                  dw 182
.Image88_Top:                   dw 63
.Image88_Width:                 dw 3
.Image88_Height:                dw 10
.Image88_Code:                  dw QFunc_Image_Event
;**** Object (Image89) Data Record ****
.Image89_Display      Equ 99
.Image89
.Image89_ID:                    dw 99
.Image89_Type:                  db 10   ;*ImageBox
.Image89_ExtDataBank:           db 255
.Image89_GrInfoAddr:            dw Sheet_Data4
.Image89_Left:                  dw 95
.Image89_Top:                   dw 73
.Image89_Width:                 dw 7
.Image89_Height:                dw 7
.Image89_Code:                  dw 0
;**** Object (Image90) Data Record ****
.Image90_Display      Equ 100
.Image90
.Image90_ID:                    dw 100
.Image90_Type:                  db 10   ;*ImageBox
.Image90_ExtDataBank:           db 255
.Image90_GrInfoAddr:            dw Sheet_Data4
.Image90_Left:                  dw 102
.Image90_Top:                   dw 75
.Image90_Width:                 dw 10
.Image90_Height:                dw 3
.Image90_Code:                  dw QFunc_Image_Event
;**** Object (Image91) Data Record ****
.Image91_Display      Equ 101
.Image91
.Image91_ID:                    dw 101
.Image91_Type:                  db 10   ;*ImageBox
.Image91_ExtDataBank:           db 255
.Image91_GrInfoAddr:            dw Sheet_Data4
.Image91_Left:                  dw 112
.Image91_Top:                   dw 73
.Image91_Width:                 dw 7
.Image91_Height:                dw 7
.Image91_Code:                  dw 0
;**** Object (Image92) Data Record ****
.Image92_Display      Equ 102
.Image92
.Image92_ID:                    dw 102
.Image92_Type:                  db 10   ;*ImageBox
.Image92_ExtDataBank:           db 255
.Image92_GrInfoAddr:            dw Sheet_Data4
.Image92_Left:                  dw 119
.Image92_Top:                   dw 75
.Image92_Width:                 dw 10
.Image92_Height:                dw 3
.Image92_Code:                  dw QFunc_Image_Event
;**** Object (Image93) Data Record ****
.Image93_Display      Equ 103
.Image93
.Image93_ID:                    dw 103
.Image93_Type:                  db 10   ;*ImageBox
.Image93_ExtDataBank:           db 255
.Image93_GrInfoAddr:            dw Sheet_Data4
.Image93_Left:                  dw 129
.Image93_Top:                   dw 73
.Image93_Width:                 dw 7
.Image93_Height:                dw 7
.Image93_Code:                  dw 0
;**** Object (Image94) Data Record ****
.Image94_Display      Equ 104
.Image94
.Image94_ID:                    dw 104
.Image94_Type:                  db 10   ;*ImageBox
.Image94_ExtDataBank:           db 255
.Image94_GrInfoAddr:            dw Sheet_Data4
.Image94_Left:                  dw 136
.Image94_Top:                   dw 75
.Image94_Width:                 dw 10
.Image94_Height:                dw 3
.Image94_Code:                  dw QFunc_Image_Event
;**** Object (Image95) Data Record ****
.Image95_Display      Equ 105
.Image95
.Image95_ID:                    dw 105
.Image95_Type:                  db 10   ;*ImageBox
.Image95_ExtDataBank:           db 255
.Image95_GrInfoAddr:            dw Sheet_Data4
.Image95_Left:                  dw 146
.Image95_Top:                   dw 73
.Image95_Width:                 dw 7
.Image95_Height:                dw 7
.Image95_Code:                  dw 0
;**** Object (Image96) Data Record ****
.Image96_Display      Equ 106
.Image96
.Image96_ID:                    dw 106
.Image96_Type:                  db 10   ;*ImageBox
.Image96_ExtDataBank:           db 255
.Image96_GrInfoAddr:            dw Sheet_Data4
.Image96_Left:                  dw 153
.Image96_Top:                   dw 75
.Image96_Width:                 dw 10
.Image96_Height:                dw 3
.Image96_Code:                  dw QFunc_Image_Event
;**** Object (Image97) Data Record ****
.Image97_Display      Equ 107
.Image97
.Image97_ID:                    dw 107
.Image97_Type:                  db 10   ;*ImageBox
.Image97_ExtDataBank:           db 255
.Image97_GrInfoAddr:            dw Sheet_Data4
.Image97_Left:                  dw 163
.Image97_Top:                   dw 73
.Image97_Width:                 dw 7
.Image97_Height:                dw 7
.Image97_Code:                  dw 0
;**** Object (Image98) Data Record ****
.Image98_Display      Equ 108
.Image98
.Image98_ID:                    dw 108
.Image98_Type:                  db 10   ;*ImageBox
.Image98_ExtDataBank:           db 255
.Image98_GrInfoAddr:            dw Sheet_Data4
.Image98_Left:                  dw 170
.Image98_Top:                   dw 75
.Image98_Width:                 dw 10
.Image98_Height:                dw 3
.Image98_Code:                  dw QFunc_Image_Event
;**** Object (Image99) Data Record ****
.Image99_Display      Equ 109
.Image99
.Image99_ID:                    dw 109
.Image99_Type:                  db 10   ;*ImageBox
.Image99_ExtDataBank:           db 255
.Image99_GrInfoAddr:            dw Sheet_Data4
.Image99_Left:                  dw 180
.Image99_Top:                   dw 73
.Image99_Width:                 dw 7
.Image99_Height:                dw 7
.Image99_Code:                  dw 0
;**** Object (Image100) Data Record ****
.Image100_Display      Equ 110
.Image100
.Image100_ID:                   dw 110
.Image100_Type:                 db 10   ;*ImageBox
.Image100_ExtDataBank:          db 255
.Image100_GrInfoAddr:           dw Sheet_Data4
.Image100_Left:                 dw 97
.Image100_Top:                  dw 80
.Image100_Width:                dw 3
.Image100_Height:               dw 10
.Image100_Code:                 dw QFunc_Image_Event
;**** Object (Image101) Data Record ****
.Image101_Display      Equ 111
.Image101
.Image101_ID:                   dw 111
.Image101_Type:                 db 10   ;*ImageBox
.Image101_ExtDataBank:          db 255
.Image101_GrInfoAddr:           dw Sheet_Data4
.Image101_Left:                 dw 101
.Image101_Top:                  dw 79
.Image101_Width:                dw 12
.Image101_Height:               dw 12
.Image101_Code:                 dw 0
;**** Object (Image102) Data Record ****
.Image102_Display      Equ 112
.Image102
.Image102_ID:                   dw 112
.Image102_Type:                 db 10   ;*ImageBox
.Image102_ExtDataBank:          db 255
.Image102_GrInfoAddr:           dw Sheet_Data4
.Image102_Left:                 dw 114
.Image102_Top:                  dw 80
.Image102_Width:                dw 3
.Image102_Height:               dw 10
.Image102_Code:                 dw QFunc_Image_Event
;**** Object (Image103) Data Record ****
.Image103_Display      Equ 113
.Image103
.Image103_ID:                   dw 113
.Image103_Type:                 db 10   ;*ImageBox
.Image103_ExtDataBank:          db 255
.Image103_GrInfoAddr:           dw Sheet_Data4
.Image103_Left:                 dw 118
.Image103_Top:                  dw 79
.Image103_Width:                dw 12
.Image103_Height:               dw 12
.Image103_Code:                 dw 0
;**** Object (Image104) Data Record ****
.Image104_Display      Equ 114
.Image104
.Image104_ID:                   dw 114
.Image104_Type:                 db 10   ;*ImageBox
.Image104_ExtDataBank:          db 255
.Image104_GrInfoAddr:           dw Sheet_Data4
.Image104_Left:                 dw 131
.Image104_Top:                  dw 80
.Image104_Width:                dw 3
.Image104_Height:               dw 10
.Image104_Code:                 dw QFunc_Image_Event
;**** Object (Image105) Data Record ****
.Image105_Display      Equ 115
.Image105
.Image105_ID:                   dw 115
.Image105_Type:                 db 10   ;*ImageBox
.Image105_ExtDataBank:          db 255
.Image105_GrInfoAddr:           dw Sheet_Data4
.Image105_Left:                 dw 135
.Image105_Top:                  dw 79
.Image105_Width:                dw 12
.Image105_Height:               dw 12
.Image105_Code:                 dw 0
;**** Object (Image106) Data Record ****
.Image106_Display      Equ 116
.Image106
.Image106_ID:                   dw 116
.Image106_Type:                 db 10   ;*ImageBox
.Image106_ExtDataBank:          db 255
.Image106_GrInfoAddr:           dw Sheet_Data4
.Image106_Left:                 dw 148
.Image106_Top:                  dw 80
.Image106_Width:                dw 3
.Image106_Height:               dw 10
.Image106_Code:                 dw QFunc_Image_Event
;**** Object (Image107) Data Record ****
.Image107_Display      Equ 117
.Image107
.Image107_ID:                   dw 117
.Image107_Type:                 db 10   ;*ImageBox
.Image107_ExtDataBank:          db 255
.Image107_GrInfoAddr:           dw Sheet_Data4
.Image107_Left:                 dw 152
.Image107_Top:                  dw 79
.Image107_Width:                dw 12
.Image107_Height:               dw 12
.Image107_Code:                 dw 0
;**** Object (Image108) Data Record ****
.Image108_Display      Equ 118
.Image108
.Image108_ID:                   dw 118
.Image108_Type:                 db 10   ;*ImageBox
.Image108_ExtDataBank:          db 255
.Image108_GrInfoAddr:           dw Sheet_Data4
.Image108_Left:                 dw 165
.Image108_Top:                  dw 80
.Image108_Width:                dw 3
.Image108_Height:               dw 10
.Image108_Code:                 dw QFunc_Image_Event
;**** Object (Image109) Data Record ****
.Image109_Display      Equ 119
.Image109
.Image109_ID:                   dw 119
.Image109_Type:                 db 10   ;*ImageBox
.Image109_ExtDataBank:          db 255
.Image109_GrInfoAddr:           dw Sheet_Data4
.Image109_Left:                 dw 169
.Image109_Top:                  dw 79
.Image109_Width:                dw 12
.Image109_Height:               dw 12
.Image109_Code:                 dw 0
;**** Object (Image110) Data Record ****
.Image110_Display      Equ 120
.Image110
.Image110_ID:                   dw 120
.Image110_Type:                 db 10   ;*ImageBox
.Image110_ExtDataBank:          db 255
.Image110_GrInfoAddr:           dw Sheet_Data4
.Image110_Left:                 dw 182
.Image110_Top:                  dw 80
.Image110_Width:                dw 3
.Image110_Height:               dw 10
.Image110_Code:                 dw QFunc_Image_Event
;**** Object (Image111) Data Record ****
.Image111_Display      Equ 121
.Image111
.Image111_ID:                   dw 121
.Image111_Type:                 db 10   ;*ImageBox
.Image111_ExtDataBank:          db 255
.Image111_GrInfoAddr:           dw Sheet_Data4
.Image111_Left:                 dw 95
.Image111_Top:                  dw 90
.Image111_Width:                dw 7
.Image111_Height:               dw 7
.Image111_Code:                 dw 0
;**** Object (Image112) Data Record ****
.Image112_Display      Equ 122
.Image112
.Image112_ID:                   dw 122
.Image112_Type:                 db 10   ;*ImageBox
.Image112_ExtDataBank:          db 255
.Image112_GrInfoAddr:           dw Sheet_Data4
.Image112_Left:                 dw 102
.Image112_Top:                  dw 92
.Image112_Width:                dw 10
.Image112_Height:               dw 3
.Image112_Code:                 dw QFunc_Image_Event
;**** Object (Image113) Data Record ****
.Image113_Display      Equ 123
.Image113
.Image113_ID:                   dw 123
.Image113_Type:                 db 10   ;*ImageBox
.Image113_ExtDataBank:          db 255
.Image113_GrInfoAddr:           dw Sheet_Data4
.Image113_Left:                 dw 112
.Image113_Top:                  dw 90
.Image113_Width:                dw 7
.Image113_Height:               dw 7
.Image113_Code:                 dw 0
;**** Object (Image114) Data Record ****
.Image114_Display      Equ 124
.Image114
.Image114_ID:                   dw 124
.Image114_Type:                 db 10   ;*ImageBox
.Image114_ExtDataBank:          db 255
.Image114_GrInfoAddr:           dw Sheet_Data4
.Image114_Left:                 dw 119
.Image114_Top:                  dw 92
.Image114_Width:                dw 10
.Image114_Height:               dw 3
.Image114_Code:                 dw QFunc_Image_Event
;**** Object (Image115) Data Record ****
.Image115_Display      Equ 125
.Image115
.Image115_ID:                   dw 125
.Image115_Type:                 db 10   ;*ImageBox
.Image115_ExtDataBank:          db 255
.Image115_GrInfoAddr:           dw Sheet_Data4
.Image115_Left:                 dw 129
.Image115_Top:                  dw 90
.Image115_Width:                dw 7
.Image115_Height:               dw 7
.Image115_Code:                 dw 0
;**** Object (Image116) Data Record ****
.Image116_Display      Equ 126
.Image116
.Image116_ID:                   dw 126
.Image116_Type:                 db 10   ;*ImageBox
.Image116_ExtDataBank:          db 255
.Image116_GrInfoAddr:           dw Sheet_Data4
.Image116_Left:                 dw 136
.Image116_Top:                  dw 92
.Image116_Width:                dw 10
.Image116_Height:               dw 3
.Image116_Code:                 dw QFunc_Image_Event
;**** Object (Image117) Data Record ****
.Image117_Display      Equ 127
.Image117
.Image117_ID:                   dw 127
.Image117_Type:                 db 10   ;*ImageBox
.Image117_ExtDataBank:          db 255
.Image117_GrInfoAddr:           dw Sheet_Data4
.Image117_Left:                 dw 146
.Image117_Top:                  dw 90
.Image117_Width:                dw 7
.Image117_Height:               dw 7
.Image117_Code:                 dw 0
;**** Object (Image118) Data Record ****
.Image118_Display      Equ 128
.Image118
.Image118_ID:                   dw 128
.Image118_Type:                 db 10   ;*ImageBox
.Image118_ExtDataBank:          db 255
.Image118_GrInfoAddr:           dw Sheet_Data4
.Image118_Left:                 dw 153
.Image118_Top:                  dw 92
.Image118_Width:                dw 10
.Image118_Height:               dw 3
.Image118_Code:                 dw QFunc_Image_Event
;**** Object (Image119) Data Record ****
.Image119_Display      Equ 129
.Image119
.Image119_ID:                   dw 129
.Image119_Type:                 db 10   ;*ImageBox
.Image119_ExtDataBank:          db 255
.Image119_GrInfoAddr:           dw Sheet_Data4
.Image119_Left:                 dw 163
.Image119_Top:                  dw 90
.Image119_Width:                dw 7
.Image119_Height:               dw 7
.Image119_Code:                 dw 0
;**** Object (Image120) Data Record ****
.Image120_Display      Equ 130
.Image120
.Image120_ID:                   dw 130
.Image120_Type:                 db 10   ;*ImageBox
.Image120_ExtDataBank:          db 255
.Image120_GrInfoAddr:           dw Sheet_Data4
.Image120_Left:                 dw 170
.Image120_Top:                  dw 92
.Image120_Width:                dw 10
.Image120_Height:               dw 3
.Image120_Code:                 dw QFunc_Image_Event
;**** Object (Image121) Data Record ****
.Image121_Display      Equ 131
.Image121
.Image121_ID:                   dw 131
.Image121_Type:                 db 10   ;*ImageBox
.Image121_ExtDataBank:          db 255
.Image121_GrInfoAddr:           dw Sheet_Data4
.Image121_Left:                 dw 180
.Image121_Top:                  dw 90
.Image121_Width:                dw 7
.Image121_Height:               dw 7
.Image121_Code:                 dw 0
;**** Object (Image122) Data Record ****
.Image122_Display      Equ 132
.Image122
.Image122_ID:                   dw 132
.Image122_Type:                 db 10   ;*ImageBox
.Image122_ExtDataBank:          db 255
.Image122_GrInfoAddr:           dw Sheet_Data4
.Image122_Left:                 dw 235
.Image122_Top:                  dw 17
.Image122_Width:                dw 20
.Image122_Height:               dw 30
.Image122_Code:                 dw 0
;**** Object (Image123) Data Record ****
.Image123_Display      Equ 133
.Image123
.Image123_ID:                   dw 133
.Image123_Type:                 db 10   ;*ImageBox
.Image123_ExtDataBank:          db 255
.Image123_GrInfoAddr:           dw Sheet_Data4
.Image123_Left:                 dw 265
.Image123_Top:                  dw 17
.Image123_Width:                dw 20
.Image123_Height:               dw 30
.Image123_Code:                 dw 0
;**** Object (Label12) Data Record ****
.Label12_Display      Equ 134
.Label12
.Label12_ID:                    dw 134
.Label12_Type:                  db 1   ;*Label
.Label12_ExtDataBank:           db 255
.Label12_ExtDataAddr:           dw Label12_ExtData
.Label12_Left:                  dw 220
.Label12_Top:                   dw 5
.Label12_Width:                 dw 86
.Label12_Height:                dw 8
.Label12_Code:                  dw 0
;**** Object (Label10) Data Record ****
.Label10_Display      Equ 135
.Label10
.Label10_ID:                    dw 135
.Label10_Type:                  db 1   ;*Label
.Label10_ExtDataBank:           db 255
.Label10_ExtDataAddr:           dw Label10_ExtData
.Label10_Left:                  dw 35
.Label10_Top:                   dw 25
.Label10_Width:                 dw 55
.Label10_Height:                dw 8
.Label10_Code:                  dw 0
;**** Object (Label11) Data Record ****
.Label11_Display      Equ 136
.Label11
.Label11_ID:                    dw 136
.Label11_Type:                  db 1   ;*Label
.Label11_ExtDataBank:           db 255
.Label11_ExtDataAddr:           dw Label11_ExtData
.Label11_Left:                  dw 36
.Label11_Top:                   dw 55
.Label11_Width:                 dw 55
.Label11_Height:                dw 8
.Label11_Code:                  dw 0
;**** Object (Label13) Data Record ****
.Label13_Display      Equ 137
.Label13
.Label13_ID:                    dw 137
.Label13_Type:                  db 1   ;*Label
.Label13_ExtDataBank:           db 255
.Label13_ExtDataAddr:           dw Label13_ExtData
.Label13_Left:                  dw 220
.Label13_Top:                   dw 51
.Label13_Width:                 dw 85
.Label13_Height:                dw 8
.Label13_Code:                  dw 0
;**** Object (Image126) Data Record ****
.Image126_Display      Equ 138
.Image126
.Image126_ID:                   dw 138
.Image126_Type:                 db 10   ;*ImageBox
.Image126_ExtDataBank:          db 255
.Image126_GrInfoAddr:           dw Sheet_Data4
.Image126_Left:                 dw 235
.Image126_Top:                  dw 62
.Image126_Width:                dw 20
.Image126_Height:               dw 30
.Image126_Code:                 dw 0
;**** Object (Image127) Data Record ****
.Image127_Display      Equ 139
.Image127
.Image127_ID:                   dw 139
.Image127_Type:                 db 10   ;*ImageBox
.Image127_ExtDataBank:          db 255
.Image127_GrInfoAddr:           dw Sheet_Data4
.Image127_Left:                 dw 265
.Image127_Top:                  dw 62
.Image127_Width:                dw 20
.Image127_Height:               dw 30
.Image127_Code:                 dw 0
;**** Object (Label15) Data Record ****
.Label15_Display      Equ 140
.Label15
.Label15_ID:                    dw 140
.Label15_Type:                  db 1   ;*Label
.Label15_ExtDataBank:           db 255
.Label15_ExtDataAddr:           dw Label15_ExtData
.Label15_Left:                  dw 244
.Label15_Top:                   dw 104
.Label15_Width:                 dw 28
.Label15_Height:                dw 8
.Label15_Code:                  dw QFunc_Label15_Event
;**** Object (ImageVoipRed) Data Record ****
.ImageVoipRed_Display      Equ 141
.ImageVoipRed
.ImageVoipRed_ID:               dw 141
.ImageVoipRed_Type:             db 10   ;*ImageBox
.ImageVoipRed_ExtDataBank:      db 255
.ImageVoipRed_GrInfoAddr:       dw Sheet_Data4
.ImageVoipRed_Left:             dw 252
.ImageVoipRed_Top:              dw 133
.ImageVoipRed_Width:            dw 20
.ImageVoipRed_Height:           dw 20
.ImageVoipRed_Code:             dw QFunc_ImageVoipRed_Event
;**** Object (ImageVoipGreen) Data Record ****
.ImageVoipGreen_Display      Equ 142
.ImageVoipGreen
.ImageVoipGreen_ID:             dw 142
.ImageVoipGreen_Type:           db 10   ;*ImageBox
.ImageVoipGreen_ExtDataBank:    db 255
.ImageVoipGreen_GrInfoAddr:     dw Sheet_Data4
.ImageVoipGreen_Left:           dw 281
.ImageVoipGreen_Top:            dw 133
.ImageVoipGreen_Width:          dw 20
.ImageVoipGreen_Height:         dw 20
.ImageVoipGreen_Code:           dw QFunc_ImageVoipGreen_Event
;**** Object (LabelVoip) Data Record ****
.LabelVoip_Display      Equ 143
.LabelVoip
.LabelVoip_ID:                  dw 143
.LabelVoip_Type:                db 1   ;*Label
.LabelVoip_ExtDataBank:         db 255
.LabelVoip_ExtDataAddr:         dw LabelVoip_ExtData
.LabelVoip_Left:                dw 243
.LabelVoip_Top:                 dw 115
.LabelVoip_Width:               dw 67
.LabelVoip_Height:              dw 8
.LabelVoip_Code:                dw QFunc_Label24_Event
;**** Object (Paint1) Data Record ****
.Paint1_Display      Equ 144
.Paint1
.Paint1_ID:                     dw 144
.Paint1_Type:                   db 0   ;*Paint
.Paint1_ExtDataBank:            db 255
.Paint1_Appearance:             db  139,0
.Paint1_Left:                   dw 244
.Paint1_Top:                    dw 162
.Paint1_Width:                  dw 67
.Paint1_Height:                 dw 1
.Paint1_Code:                   dw 0
;**** Object (Label9) Extra Data Record ****
.Label9_ExtData:                
.Label9_Text:                   dw  Label9_Text_Data+4
.Label9_TextAppearance:         db  18
.Label9_TextAlignment:          db  194
;**** Object (Label7) Extra Data Record ****
.Label7_ExtData:                
.Label7_Text:                   dw  Label7_Text_Data+4
.Label7_TextAppearance:         db  33
.Label7_TextAlignment:          db  194
;**** Object (Label8) Extra Data Record ****
.Label8_ExtData:                
.Label8_Text:                   dw  Label8_Text_Data+4
.Label8_TextAppearance:         db  33
.Label8_TextAlignment:          db  194
;**** Object (Label6) Extra Data Record ****
.Label6_ExtData:                
.Label6_Text:                   dw  Label6_Text_Data+4
.Label6_TextAppearance:         db  135
.Label6_TextAlignment:          db  192
;**** Object (Label5) Extra Data Record ****
.Label5_ExtData:                
.Label5_Text:                   dw  Label5_Text_Data+4
.Label5_TextAppearance:         db  33
.Label5_TextAlignment:          db  192
;**** Object (Label4) Extra Data Record ****
.Label4_ExtData:                
.Label4_Text:                   dw  Label4_Text_Data+4
.Label4_TextAppearance:         db  33
.Label4_TextAlignment:          db  192
;**** Object (Label3) Extra Data Record ****
.Label3_ExtData:                
.Label3_Text:                   dw  Label3_Text_Data+4
.Label3_TextAppearance:         db  33
.Label3_TextAlignment:          db  192
;**** Object (Label2) Extra Data Record ****
.Label2_ExtData:                
.Label2_Text:                   dw  Label2_Text_Data+4
.Label2_TextAppearance:         db  33
.Label2_TextAlignment:          db  192
;**** Object (Label1) Extra Data Record ****
.Label1_ExtData:                
.Label1_Text:                   dw  Label1_Text_Data+4
.Label1_TextAppearance:         db  18
.Label1_TextAlignment:          db  192
;**** Object (Label14) Extra Data Record ****
.Label14_ExtData:               
.Label14_Text:                  dw  Label14_Text_Data+4
.Label14_TextAppearance:        db  135
.Label14_TextAlignment:         db  194
;**** Object (Label12) Extra Data Record ****
.Label12_ExtData:               
.Label12_Text:                  dw  Label12_Text_Data+4
.Label12_TextAppearance:        db  18
.Label12_TextAlignment:         db  194
;**** Object (Label10) Extra Data Record ****
.Label10_ExtData:               
.Label10_Text:                  dw  Label10_Text_Data+4
.Label10_TextAppearance:        db  33
.Label10_TextAlignment:         db  192
;**** Object (Label11) Extra Data Record ****
.Label11_ExtData:               
.Label11_Text:                  dw  Label11_Text_Data+4
.Label11_TextAppearance:        db  33
.Label11_TextAlignment:         db  192
;**** Object (Label13) Extra Data Record ****
.Label13_ExtData:               
.Label13_Text:                  dw  Label13_Text_Data+4
.Label13_TextAppearance:        db  18
.Label13_TextAlignment:         db  194
;**** Object (Label15) Extra Data Record ****
.Label15_ExtData:               
.Label15_Text:                  dw  Label15_Text_Data+4
.Label15_TextAppearance:        db  135
.Label15_TextAlignment:         db  194
;**** Object (LabelVoip) Extra Data Record ****
.LabelVoip_ExtData:             
.LabelVoip_Text:                dw  LabelVoip_Text_Data+4
.LabelVoip_TextAppearance:      db  11
.LabelVoip_TextAlignment:       db  194
;***
;**** Z80 version of Form Form2 ***
;***
.Form2
.Form2_Addr:                    db 1,0
.Form2_Begin:                   
.Form2_Status:                  db 128
.Form2_Display:                 db 21
.Form2_SizeAdjust:              db 16
.Form2_OwnerID:                 db 0
.Form2_Left:                    dw 0
.Form2_Top:                     dw 0
.Form2_Width:                   dw 134
.Form2_Height:                  dw 114
.Form2_OffsetWidth:             dw 1
.Form2_OffsetHeight:            dw 8
.Form2_ContentWidth:            dw 125
.Form2_ContentHeight:           dw 114
.Form2_MinWidth:                dw 0
.Form2_MinHeight:               dw 0
.Form2_MaxWidth:                dw 1024
.Form2_MaxHeight:               dw 212
.Form2_IconAddr:                dw Form2_Icon
.Form2_Text:                    dw Form2_Text_Data+4
.Form2_Status_Text:             dw Form2_Status_Text_Data+4
.Form2_MenuAddr:                dw 0  ;No Menu on form
.Form2_ControlWindowAddr:       dw Form2_ControlWindow
.Form2_ControlToolAddr:         dw 0;Form2_ControlTool
.Form2_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form2_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved

;****
;**** Data Control Record (ControlWindow) ****
;****
.Form2_ControlWindow:           
.Form2_ControlWindowCount:      db 8
.Form2_ControlWindowOwnerID:    db 0
.Form2_ControlWindowDataAddr:   dw Form2_ControlWindowData
.Form2_ControlWindowCalcAddr:   dw 0; Form2_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form2_ControlWindowFocus:      db 0
     db 0
;****
.Form2_ControlWindowData:       
;**** Object Window Background Data Record ****
dw 0,255*256+0,129,  0,0,1000,1000,0
;**** Object (Label20) Data Record ****
.Label20_Display      Equ 1
.Label20
.Label20_ID:                    dw 2049
.Label20_Type:                  db 1   ;*Label
.Label20_ExtDataBank:           db 255
.Label20_ExtDataAddr:           dw Label20_ExtData
.Label20_Left:                  dw 8
.Label20_Top:                   dw 12
.Label20_Width:                 dw 115
.Label20_Height:                dw 8
.Label20_Code:                  dw 0
;**** Object (Label21) Data Record ****
.Label21_Display      Equ 2
.Label21
.Label21_ID:                    dw 2050
.Label21_Type:                  db 1   ;*Label
.Label21_ExtDataBank:           db 255
.Label21_ExtDataAddr:           dw Label21_ExtData
.Label21_Left:                  dw 8
.Label21_Top:                   dw 30
.Label21_Width:                 dw 115
.Label21_Height:                dw 8
.Label21_Code:                  dw QFunc_Label21_Event
;**** Object (Label23) Data Record ****
.Label23_Display      Equ 3
.Label23
.Label23_ID:                    dw 2051
.Label23_Type:                  db 1   ;*Label
.Label23_ExtDataBank:           db 255
.Label23_ExtDataAddr:           dw Label23_ExtData
.Label23_Left:                  dw 8
.Label23_Top:                   dw 50
.Label23_Width:                 dw 115
.Label23_Height:                dw 8
.Label23_Code:                  dw QFunc_Label23_Event
;**** Object (Label24) Data Record ****
.Label24_Display      Equ 4
.Label24
.Label24_ID:                    dw 2052
.Label24_Type:                  db 1   ;*Label
.Label24_ExtDataBank:           db 255
.Label24_ExtDataAddr:           dw Label24_ExtData
.Label24_Left:                  dw 8
.Label24_Top:                   dw 60
.Label24_Width:                 dw 115
.Label24_Height:                dw 8
.Label24_Code:                  dw QFunc_Label24_Event
;**** Object (Label25) Data Record ****
.Label25_Display      Equ 5
.Label25
.Label25_ID:                    dw 2053
.Label25_Type:                  db 1   ;*Label
.Label25_ExtDataBank:           db 255
.Label25_ExtDataAddr:           dw Label25_ExtData
.Label25_Left:                  dw 8
.Label25_Top:                   dw 70
.Label25_Width:                 dw 115
.Label25_Height:                dw 8
.Label25_Code:                  dw QFunc_Label25_Event
;**** Object (Label26) Data Record ****
.Label26_Display      Equ 6
.Label26
.Label26_ID:                    dw 2054
.Label26_Type:                  db 1   ;*Label
.Label26_ExtDataBank:           db 255
.Label26_ExtDataAddr:           dw Label26_ExtData
.Label26_Left:                  dw 8
.Label26_Top:                   dw 99
.Label26_Width:                 dw 113
.Label26_Height:                dw 8
.Label26_Code:                  dw 0
;**** Object (Label22) Data Record ****
.Label22_Display      Equ 7
.Label22
.Label22_ID:                    dw 2055
.Label22_Type:                  db 1   ;*Label
.Label22_ExtDataBank:           db 255
.Label22_ExtDataAddr:           dw Label22_ExtData
.Label22_Left:                  dw 8
.Label22_Top:                   dw 40
.Label22_Width:                 dw 115
.Label22_Height:                dw 8
.Label22_Code:                  dw QFunc_Label22_Event
;**** Object (Label20) Extra Data Record ****
.Label20_ExtData:               
.Label20_Text:                  dw  Label20_Text_Data+4
.Label20_TextAppearance:        db  131
.Label20_TextAlignment:         db  194
;**** Object (Label21) Extra Data Record ****
.Label21_ExtData:               
.Label21_Text:                  dw  Label21_Text_Data+4
.Label21_TextAppearance:        db  135
.Label21_TextAlignment:         db  192
;**** Object (Label23) Extra Data Record ****
.Label23_ExtData:               
.Label23_Text:                  dw  Label23_Text_Data+4
.Label23_TextAppearance:        db  135
.Label23_TextAlignment:         db  192
;**** Object (Label24) Extra Data Record ****
.Label24_ExtData:               
.Label24_Text:                  dw  Label24_Text_Data+4
.Label24_TextAppearance:        db  135
.Label24_TextAlignment:         db  192
;**** Object (Label25) Extra Data Record ****
.Label25_ExtData:               
.Label25_Text:                  dw  Label25_Text_Data+4
.Label25_TextAppearance:        db  135
.Label25_TextAlignment:         db  192
;**** Object (Label26) Extra Data Record ****
.Label26_ExtData:               
.Label26_Text:                  dw  Label26_Text_Data+4
.Label26_TextAppearance:        db  33
.Label26_TextAlignment:         db  192
;**** Object (Label22) Extra Data Record ****
.Label22_ExtData:               
.Label22_Text:                  dw  Label22_Text_Data+4
.Label22_TextAppearance:        db  135
.Label22_TextAlignment:         db  192
;***
;**** Z80 version of Form Form3 ***
;***
.Form3
.Form3_Addr:                    db 2,0
.Form3_Begin:                   
.Form3_Status:                  db 0
.Form3_Display:                 db 85
.Form3_SizeAdjust:              db 16
.Form3_OwnerID:                 db 0
.Form3_Left:                    dw 0
.Form3_Top:                     dw 0
.Form3_Width:                   dw 94
.Form3_Height:                  dw 5
.Form3_OffsetWidth:             dw 1
.Form3_OffsetHeight:            dw 8
.Form3_ContentWidth:            dw 85
.Form3_ContentHeight:           dw 5
.Form3_MinWidth:                dw 0
.Form3_MinHeight:               dw 0
.Form3_MaxWidth:                dw 1024
.Form3_MaxHeight:               dw 212
.Form3_IconAddr:                dw Form3_Icon
.Form3_Text:                    dw Form3_Text_Data+4
.Form3_Status_Text:             dw Form3_Status_Text_Data+4
.Form3_MenuAddr:                dw 0  ;No Menu on form
.Form3_ControlWindowAddr:       dw Form3_ControlWindow
.Form3_ControlToolAddr:         dw 0;Form3_ControlTool
.Form3_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form3_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved

;****
;**** Data Control Record (ControlWindow) ****
;****
.Form3_ControlWindow:           
.Form3_ControlWindowCount:      db 1
.Form3_ControlWindowOwnerID:    db 0
.Form3_ControlWindowDataAddr:   dw Form3_ControlWindowData
.Form3_ControlWindowCalcAddr:   dw 0; Form3_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form3_ControlWindowFocus:      db 0
     db 0
;****
.Form3_ControlWindowData:       
;**** Object Window Background Data Record ****
dw 0,255*256+0,129,  0,0,1000,1000,0
;***
;**** Z80 version of Form Form4 ***
;***
.Form4
.Form4_Addr:                    db 3,0
.Form4_Begin:                   
.Form4_Status:                  db 129
.Form4_Display:                 db 85
.Form4_SizeAdjust:              db 16
.Form4_OwnerID:                 db 0
.Form4_Left:                    dw 0
.Form4_Top:                     dw 0
.Form4_Width:                   dw 120
.Form4_Height:                  dw 92
.Form4_OffsetWidth:             dw 1
.Form4_OffsetHeight:            dw 8
.Form4_ContentWidth:            dw 111
.Form4_ContentHeight:           dw 92
.Form4_MinWidth:                dw 0
.Form4_MinHeight:               dw 0
.Form4_MaxWidth:                dw 1024
.Form4_MaxHeight:               dw 212
.Form4_IconAddr:                dw Form4_Icon
.Form4_Text:                    dw Form4_Text_Data+4
.Form4_Status_Text:             dw Form4_Status_Text_Data+4
.Form4_MenuAddr:                dw 0  ;No Menu on form
.Form4_ControlWindowAddr:       dw Form4_ControlWindow
.Form4_ControlToolAddr:         dw 0;Form4_ControlTool
.Form4_ToolBarHeight:           dw 0;
     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved
.Form4_SuperWindow:             db  0
     ds 140,0                   ;Symbos Reserved

;****
;**** Data Control Record (ControlWindow) ****
;****
.Form4_ControlWindow:           
.Form4_ControlWindowCount:      db 4
.Form4_ControlWindowOwnerID:    db 0
.Form4_ControlWindowDataAddr:   dw Form4_ControlWindowData
.Form4_ControlWindowCalcAddr:   dw 0; Form4_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form4_ControlWindowFocus:      db 0
     db 0
;****
.Form4_ControlWindowData:       
;**** Object Window Background Data Record ****
dw 0,255*256+0,131,  0,0,1000,1000,0
;**** Object (Label41) Data Record ****
.Label41_Display      Equ 1
.Label41
.Label41_ID:                    dw 6145
.Label41_Type:                  db 1   ;*Label
.Label41_ExtDataBank:           db 255
.Label41_ExtDataAddr:           dw Label41_ExtData
.Label41_Left:                  dw 5
.Label41_Top:                   dw 4
.Label41_Width:                 dw 104
.Label41_Height:                dw 8
.Label41_Code:                  dw 0
;**** Object (Image410) Data Record ****
.Image410_Display      Equ 2
.Image410
.Image410_ID:                   dw 6146
.Image410_Type:                 db 10   ;*ImageBox
.Image410_ExtDataBank:          db 255
.Image410_GrInfoAddr:           dw Sheet_Data4
.Image410_Left:                 dw 6
.Image410_Top:                  dw 21
.Image410_Width:                dw 100
.Image410_Height:               dw 47
.Image410_Code:                 dw 0
;**** Object (Button41) Data Record ****
.Button41_Display      Equ 3
.Button41
.Button41_ID:                   dw 6147
.Button41_Type:                 db 16   ;*Button
.Button41_ExtDataBank:          db 255
.Button41_Text:                 dw Button41_Text_Data+4
.Button41_Left:                 dw 24
.Button41_Top:                  dw 73
.Button41_Width:                dw 73
.Button41_Height:               dw 11
.Button41_Code:                 dw QFunc_Button41_Event
;**** Object (Label41) Extra Data Record ****
.Label41_ExtData:               
.Label41_Text:                  dw  Label41_Text_Data+4
.Label41_TextAppearance:        db  33
.Label41_TextAlignment:         db  194
.SyStud_TimerRoutines    dw 0
.Quig_File_Select_Ext          ds 4
.Quig_File_Select_File         ds 256
.AppTrnEnd


