;LIBRARY QUIG.SOUND.INIT
;***********************
.Quig_Sound_Int:
		inclib 	SYSYSTEM.SENDMESSAGE
		inclib 	SYSYSTEM.WAITMESSAGE
        ld 		e,0
        ld 		hl,Quig_ssndmnt
        ld 		a,(AppBnkNum)
		ld		c,MSC_SYS_PRGSRV
        call 	SySystem_SendMessage
.Quig_Sound_Int2:
		call 	SySystem_WaitMessage
        cp 		MSR_SYS_PRGSRV
        jr 		nz,Quig_Sound_Int2
		ld 		a,(AppMsgB+1)
        ld 		hl,(AppMsgB+8)
        or 		a
        scf
        jr	 	z,Quig_Sound_Int3		;We are OK
		ld		hl,0					;Sound Daemon not running
		ret								;
.Quig_Sound_Int3:		
        ld 		a,h
        ld 		(Quig_Sound_PrcID),a
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_SNDINF
        call 	Quig_ssnmsg1
        call 	Quig_ssnmsgo_afhl
        or 		a
		ld		(Quig_Sound_Hardware),a
		ld		a,h
		ld		(Quig_Sound_Pref_Music),a
		ld		a,l
		ld		(Quig_Sound_Pref_FX),a
		ld		hl,1
        ret
		
;IN HL = Volume		
;   DE = Effect
;	(ST1)=Handle
.Quig_Sound_FX_Play:
		pop		bc				;Gets Return Address
		ld		h,l				;H = L or Volume
		ld		l,e				;L = E Effect
		pop		de				;Get HL
		ld		a,e				;a = l the Handle
		push	bc				;Pushes return address
		ld		de,0
		ld		b,3				;3 = play always on rotating channel
		call 	Quig_ssnmsgi_afbchl
        db 		FNC_SND_EFXPLY
        ret
;In HL = Pitch
;IN de = Volume		
;   (ST1) = Effect
;	(ST2)=Handle
.Quig_Sound_FX_PlayOPL4:
		pop		iy				;Return Address
		ex		de,hl			;DE = Pitch,HL=Volume
		ld		h,l				;H=Volume
		pop		bc
		ld		l,c				;L=Effect
		pop		bc
		ld		a,c				;A=Handle
		push	iy	
		ld		b,1
		ld		c,128
		call 	Quig_ssnmsgi_afbchl
        db 		FNC_SND_EFXPLY
        ret		
;IN HL = Effect
;   DE = HANDLE
.Quig_Sound_FX_Stop:
		ld		a,e
		call	Quig_ssnmsgi_afhl
        db 		FNC_SND_EFXSTP
        ret
;IN HL = Handle
.Quig_Sound_FX_Release:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_EFXFRE
        ret
;IN HL = Filename
.Quig_Sound_Music_Load_OPL4:
		ld		a,2								;OPL4
		jr		Quig_Sound_Music_Load2
.Quig_Sound_Music_Load:
		ld		a,1								;PSG
.Quig_Sound_Music_Load2:		
		ld		(Quig_Sound_Music_Load_Type+1),a
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File
		jp		c,Quig_Sound_LoadFail
		;		Opened succesfully		
		ld		(Quig_SML_Handle),a		
		ld		e,0
.Quig_Sound_Music_Load_Type:		
		ld		d,1								;Set PSG/OPL4
        call 	Quig_ssnmsgi_afbcdehl	
        db 		FNC_SND_MUSLOD
.Quig_Sound_Music_Load_9:		
        call 	Quig_ssnmsg1
        call	Quig_ssnmsgo_af
		jr		c,Quig_Sound_LoadFail2		
		ld		l,a
		ld		h,0
		push	hl
		call	Quig_SML_Close
		pop		hl
		ret
		
.Quig_Sound_SFX_Load_OPL4:
		ld		a,2								;OPL4
		jr		Quig_Sound_SFX_Load2
.Quig_Sound_SFX_Load:
		ld		a,1								;PSG
.Quig_Sound_SFX_Load2:


		ld		(Quig_Sound_SFX_Load_Type+1),a
		ld		a,(appBnkNum)					;Filename Bank
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN					;Open File
		

		
		jp		c,Quig_Sound_LoadFail
		;		Opened succesfully		
		ld		(Quig_SML_Handle),a		
		

		
		ld		e,0
.Quig_Sound_SFX_Load_Type:		
		ld		d,1								;Set PSG/OPL4
        call 	Quig_ssnmsgi_afbcdehl	
        db 		FNC_SND_EFXLOD
		jr		Quig_Sound_Music_Load_9		
		
.Quig_SML_Close:
		ld		a,(Quig_SML_Handle)
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO		
		ret	
.Quig_SML_Handle:	db	0
.Quig_Sound_LoadFail2:
		call	Quig_SML_Close
.Quig_Sound_LoadFail:
		ld		hl,255
		ret

;IN HL=Volume
;   DE=Handle
.Quig_Sound_Music_Volume:
		ld		a,e
		ld		h,l
        call 	Quig_ssnmsgi_afhl
        db 		FNC_SND_MUSVOL
        ret
		
;IN HL = Handle
.Quig_Sound_Music_Play:
		ld		a,l				;A= Handle
		ld		l,0				;L=0
        call 	Quig_ssnmsgi_afhl
        db 		FNC_SND_MUSRST
		ret
;IN HL=handle
.Quig_Sound_Music_Stop:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_MUSSTP
		ret
;IN HL=Handle		
.Quig_Sound_Music_Continue:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_MUSCON
		ret
;IN HL=Handle		
.Quig_Sound_Music_Release:
		ld		a,l
        call 	Quig_ssnmsgi_af
        db 		FNC_SND_MUSFRE
        ret
		
		
.Quig_Sound_PrcID:		db	0
.Quig_Sound_Hardware: 	db	0
.Quig_Sound_Pref_Music:	db	0
.Quig_Sound_Pref_Fx:	db 	0
.Quig_ssndmnt: db 	"Sound Daemon"
.Quig_ssnmsgi_afbcdehl:
        ld 		(AppMsgB+06),de   ;store registers to message buffer
.Quig_ssnmsgi_afbchl:
        ld 		(AppMsgB+04),bc
.Quig_ssnmsgi_afhl:
        ld 		(AppMsgB+08),hl
.Quig_ssnmsgi_af
        push 	af:pop hl
        ld 		(AppMsgB+02),hl
        pop 	hl
        ld 		a,(hl)               ;set command
        inc 	hl
        push 	hl
        ld 		(AppMsgB+0),a
        ld 		(Quig_ssnmsg2+1),a
        ld 		iy,AppMsgB
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        ld 		a,(Quig_Sound_PrcID)
        db 		#dd:ld h,a
        ld 		(Quig_ssnmsg1+2),ix
        rst 	#10                 ;send message
        ret
.Quig_ssnmsg1: 
		ld 		ix,0                 ;wait for response
        rst 	#08
        db 		#dd:dec l
        jr 		nz,Quig_ssnmsg1
        ld 		a,(AppMsgB)
        sub 	128
.Quig_ssnmsg2:
		cp 		0
        ret 	z
        ld 		a,(AppPrzN)        ;wrong response code -> put this back to the last entry in the message queue and wait for a correct one
        db 		#dd:ld h,a
        ld 		a,(Quig_Sound_PrcID)
        db 		#dd:ld l,a
        rst 	#10
        rst 	#30
        jr 		Quig_ssnmsg1
.Quig_ssnmsgo_afhl:
        ld 		hl,(AppMsgB+02)   ;get registers from the message buffer
        push 	hl
        pop 	af
        ld 		hl,(AppMsgB+08)
        ret
.Quig_ssnmsgo_af:
        ld 		hl,(AppMsgB+02)
        push 	hl
        pop 	af
        ret

;LIBRARY QUIG.SOUND.LOAD
;***********************
; HL = Address of String 0 terminated
.Quig_Sound_Load:
		ld 		hl,0			;Sound address
		ret
		
;LIBRARY QUIG.SOUND.PLAY
;***********************
; HL = Address of sound
.Quig_Sound_Play:
		ret		
;LIBRARY QUIG.SOUND.STOP
;***********************
; HL = Address of sound
.Quig_Sound_Stop:
		ret				

;LIBRARY QUIG.GET.KEYPRESS
.Quig_Get_Keypress:
		ld		a,(Event_Type)
		cp		16
		jr		z,Quig_Get_Keypress2
		ld		hl,0
		ret
.Quig_Get_Keypress2:		
		ld		a,(Event_Key_ASCII)
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.KEY.MULTI		
;**** Fast 6 Keyscan reader for games

;Read in last 6
.Quig_Key_Multi_Set:
		pop		iy
		ld		a,l
		ld		(QMKR6+1),a
		ld		a,e
		ld		(QMKR5+1),a		
		pop		hl
		ld		a,l
		ld		(QMKR4+1),a
		pop		hl
		ld		a,l
		ld		(QMKR3+1),a
		pop		hl
		ld		a,l
		ld		(QMKR2+1),a	
		pop		hl
		ld		a,l
		ld		(QMKR1+1),a			
		jp		(iy)
.Quig_Key_Multi_Read:
.QMKR1:
		ld		e,0
.QMKR6:		
		ld		d,0
.QMKR2:
		ld		a,0
		ld		ixl,a
.QMKR3:
		ld		a,0
		ld		ixh,a
.QMKR4:
		ld		a,0
		ld		iyl,a
.QMKR5:
		ld		a,0
		ld		iyh,a
		ld 		hl,#8160:rst #28
		ld		a,e
		ld		(Quig_Key_Multi_Res+1),a
		ret
		
.Quig_Key_Multi_Res:
		ld		a,0				;Multi_Res+1 = Scan code Result
		and		l
		ld		l,a
		ld		h,0
		ret
		
;LIBRARY QUIG.SET.INT
.Quig_Set_Int:
		ret
		
;LIBRARY QUIG.DATA.BYTE		
.Quig_Data_Byte:
		ld 		hl,(Quig_DataAddr)
		ld		a,(hl)
		inc		hl
		ld		(Quig_DataAddr),hl
		ld		l,a
		ld		h,0
		ret

;LIBRARY QUIG.GARBAGE
;********************
.Quig_Garbage:
		ld		hl,Quigs_String_Data_Start
		ld		ix,Quig_String_Count
		call	memgrb
		inc		de
		inc		de
		inc		de
		inc		de
		ld		(Quig_String_Pos),de
		ret
		
;### MEMGRB -> does a garbage collection
;### Input      IX=element counter, HL=start address
;### Output     DE=new top address
.memgrb:ld 		e,l          ;HL=source pointer, DE=destination pointer
        ld 		d,h
.memgrb1:
		db #dd:ld a,l
        db #dd:or h
        ret 	z
.memgrb2:
		ld 		c,(hl)       ;get pointer (or 0=empty-marker)
        inc 	hl
        ld 		b,(hl)
        ld 		a,c
        or 		b
        jr 		nz,memgrb3
        inc 	hl                  ;*** empty area found -> skip it
        ld 		c,(hl)
        inc 	hl
        ld 		b,(hl)       ;BC=length
        inc 	hl
        add 	hl,bc       ;HL=next entry
        jr 		memgrb2
.memgrb3:
		dec 	hl                  ;*** string found -> move and perhaps shrink it
        ldi
		ldi         ;copy pointer-link
        inc 	bc
		inc 	bc   ;restore pointer-adr
        push 	de         ;push new length adr
        inc 	de
		inc 	de
        ld 		a,e
        ld 		(bc),a
        inc 	bc
        ld 		a,d
        ld 		(bc),a       ;set pointer to new address
        ld 		c,(hl)
        inc 	hl
        ld 		b,(hl)
        inc 	hl          ;BC=old length
        push 	hl
        add 	hl,bc       ;HL=next entry
        ex 		(sp),hl
        ld 		bc,-1        ;BC=cpl(new length)
.memgrb4:
		ld 		a,(hl)       ;move string bytes
        ldi
        or 		a
        jr 		nz,memgrb4   ;until 0-terminator reached
        pop 	hl          ;get next entry
        ex 		(sp),hl      ;push next entry, HL=new length adr
        ld 		a,c          ;write new length to new length adr
        cpl
        ld 		(hl),a
        inc 	hl
        ld 		a,b
        cpl
        ld 		(hl),a
        pop 	hl          ;HL=next entry
        dec 	ix
        jr 		memgrb1		
		







;LIBRARY QUIG.G9K.TILE.SET
; DE = Ptr to pattern data
; HL = Pattern number
;  A = Layer number (0=A,1=B)
.Quig_g9k_Tile_Set_A:
		xor		a
		jr		Quig_g9k_Tile_Set
.Quig_g9k_Tile_Set_B:
		ld		a,1
.Quig_g9k_Tile_Set:
		push	de
		add		a,a
		ld		(Quig_Pat_LAYER_SEL_SC),a
		ld		(Quig_Pat_LAYER_SEL_DS),a
		add		hl,hl
		add		hl,hl
		add		hl,hl
		ld		a,l
		ld		(Quig_Pat_X),a
		ld		a,h
		add		a
		add		a
		add		a
		ld		(Quig_Pat_Y),a
		ld		hl,Quig_Pat_X
		;Do SetupCopyRamToXY
		ld		a,g9k_DS_X
		out		(g9k_REG_SELECT),a
		ld		bc,8*256+g9k_REG_DATA
		;g9kCmdWait
.Quig_g9k_Tile_Set_Wait:		
		in		a,(g9k_STATUS)
		rra
		jr		c,Quig_g9k_Tile_Set_Wait
		otir
		;G9KWriteReg
		ld		a,g9k_OPCODE
		out 	(g9k_REG_SELECT),a
		ld		a,g9k_OPCODE_LMMC
		out		(g9k_REG_DATA),a
		;
		pop		hl
		ld		bc,64
;CopyRamToXY:
; HL = Pointer to data
; BC = Bytes to copy
		ld		a,b
		ld		b,c
		inc		b
		dec		b
		jr		z,Quig_g9k_Tile_Set_1
		inc		a
.Quig_g9k_Tile_Set_1:		
		ld		c,g9k_CMD_DATA
.Quig_g9k_Tile_Set_Loop:		
		otir
		dec		a
		jp		nz,Quig_g9k_Tile_Set_Loop
		ret
		
.Quig_Pat_X:					db	0
.Quig_Pat_LAYER_SEL_SC:		db	0
.Quig_Pat_Y:					db	0,0
.Quig_Pat_WIDTH:				db	8
.Quig_Pat_LAYER_SEL_DS:		db	0
.Quig_Pat_HEIGHT:			db	8,0		


	

;LIBRARY QUIG.G9K.MAP.SET
; HL = Y
; DE = X
; ST1 = Pattern number in generator table (on screen patterns 0 to A=8159,B=7679)
;  A = Layer number (0=A,1=B)
.Quig_g9k_DrawTileA:
		pop		iy
		ld		bc,#c000
		jr		Quig_g9k_DrawTile
.Quig_g9k_DrawTileB:
		pop		iy
		ld		bc,#e000
.Quig_g9k_DrawTile:
		ld		a,l
		and		%00111111
		ld		l,a
		add		hl,hl	;*2
		add		hl,hl	;*4
		add		hl,hl	;*8
		add		hl,hl	;*16
		add		hl,hl	;*32
		add		hl,hl	;*64
		ld		a,e
		and		%00111111
		ld		e,a
		add		hl,de
		add		hl,hl
		add		hl,bc
		
		
		
		ld		e,7
		;SetVramWrite
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		out		(c),e
		;
		pop		de
		ld		bc,CG9K_VRAM
		out		(c),e
		out		(c),d
		jp		(iy)
		
		
		
		
;LIBRARY QUIG.G9K.MAP.FILL
; HL = Pattern number in generator table (on screen patterns 0 to A=8159,B=7679)
; DE = X
;  A = Layer number (0=A,1=B)
.Quig_g9k_FillMapA:
		ld		bc,#c000
		jr		Quig_g9k_FillMap
.Quig_g9k_FillMapB:
		ld		bc,#e000
.Quig_g9k_FillMap:
		ld		hl,0
		add		hl,bc
		ld		b,255
.Quig_g9k_FillMap2:	
		push	bc
;		push	hl
		ld		e,7
		;SetVramWrite
		ld		a,g9k_WRITE_ADDR
		ld		bc,CG9K_REG_SELECT
		out		(c),a
		ld		bc,CG9K_REG_DATA
		out		(c),l
		out		(c),h
		out		(c),e
		ld		hl,Quig_g9k_MapFill_Data
		ld		bc,CG9K_VRAM
		call 	Quig_g9k_32outi
;		pop		hl
;		ld		de,32
;		add		hl,de
		pop		bc
		dec		b
		djnz	Quig_g9k_FillMap2
		jp		(iy)	
.Quig_g9k_MapFill_Data:
		dw		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;LIBRARY QUIG.G9K.SETMODE
.Quig_g9k_SetMode
		ld		a,0				;quit reset mode & select XTAL oscilator
		ld		bc,CG9K_VRAM+7
		out		(c),a
		ld		a,6				;set REGISTER 6,7,8 for P1 mode
		ld		bc,CG9K_VRAM+4
		out		(c),a
		ld		a,5				;reg #6
		ld		bc,CG9K_VRAM+3
		out		(c),a
		ld		a,0				;reg #7   +8 pour 50Hz
		out		(c),A
		ret
;LIBRARY QUIG.G9K.SETMODE.50	
.Quig_g9k_SetMode_50
		
		ld		a,0				;quit reset mode & select XTAL oscilator
		ld		bc,CG9K_VRAM+7
		out		(c),a
		ld		a,6				;set REGISTER 6,7,8 for P1 mode
		ld		bc,CG9K_VRAM+4
		out		(c),a
		ld		a,5				;reg #6
		ld		bc,CG9K_VRAM+3
		out		(c),a
		ld		a,8				;reg #7   +8 pour 50Hz
		out		(c),A
		ret		
		

		
		
;LIBRARY QUIG.G9K.DISPLAY.ON
.Quig_g9k_Display_On
		ld		a,%10000010		;REG #8: display on, SPR on, 512kB VRAM
		ld		bc,CG9K_VRAM+3
		out		(c),a
		ret
;LIBRARY QUIG.G9K.DISPLAY.OFF
.Quig_g9k_Display_Off
		ld		a,%0000010		;REG #8: display on, SPR on, 512kB VRAM
		ld		bc,CG9K_VRAM+3
		out		(c),a
		ret		
		
;LIBRARY QUIG.TIMER.SET.ON
;*************************
.Quig_Timer_Set_On:
		ld		a,1
		ld		(Quig_Timer_On),a
		ret
;LIBRARY QUIG.TIMER.SET.STOP
;*************************
.Quig_Timer_Set_Stop:
		xor		a
		ld		(Quig_Timer_On),a
		ret
;LIBRARY QUIG.TIMER.ISON
;*************************
.Quig_Timer_IsOn:
		ld		a,(Quig_Timer_On)
		ld		l,a
		ld		h,0
		ret
	
;LIBRARY QUIG.IRND
;*****************
.Quig_IRandomize:
		ld		(Quig_RNDSeed),hl
		ret
.Quig_IRnd:
		inclib  QUIG.DIV16
		push	hl
		ld		de,(Quig_RNDSeed)	; Seed is usually 0
		ld		a,d
		ld		h,e
		ld		l,253
		or		a
		sbc		hl,de
		sbc		a,0
		sbc		hl,de
		ld		d,0
		sbc		a,d
		ld		e,a
		sbc		hl,de
		jr		nc,Quig_IRnd2	
		inc		hl
.Quig_IRnd2	
		ld		(Quig_RNDSeed),hl
		ex		de,hl
		pop		hl
		call	Quig_Div16
		ex		de,hl
		ret
.Quig_RNDSeed:dw	100

;LIBRARY QUIG.OPEN.FORM
.Quig_Open_Form:
		
		ld		a,l								;**** Which form are we looking at
		call 	Quig_Form_Return
		cp		255
		ret		nz								;**** Already in use
		
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	Quig_GetWindowEventAddr			;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Window Data
		ld		a,(AppBnkNum)
		inclib 	SYDESKTOP.WINOPN
		call	SyDesktop_WINOPN


		


;******************************************************************************
;*** Name           Window_Open_Command
;*** Input          A  = Window data record ram bank (0-8)
;***                DE = Window data record address (#C000-#FFFF)
;*** Output         A  = Window ID (only, if CF=0)
;***                CF = Success status
;***                     0 = OK
;***                     1 = window couldn't be opened, as the maximum number
;***                         of windows (32) has been reached
;*** Destroyed      BC,DE,HL,IX,IY
;*** Description    Opens a new window. Its data record must be placed in the
;***                transfer ram area (between #c000 and #ffff).
;***                For more information about the window data record see the
;***                chapter "desktop manager data records".
;***                For more information about the transfer ram memory types see
;***                the "applications" chapter.
;******************************************************************************
;.SyDesktop_WINOPN
		
;		call	Quig_Form_ReOpen
;		ret
;LIBRARY QUIG.CLOSE.FORM
.Quig_Close_Form:
		ld		a,l
		ld		h,0
		call	Quig_Form_Close
		ret		

		
;LIBRARY QUIG.NOT
;********************
.Quig_Not:
		ld		a,l				
		And		a
		jr		nz,Quig_Not_2
		ld		a,h
		And		a
		jr		nz,Quig_Not_2
		ld		hl,1
		ret
.Quig_Not_2		;**** Means <>0 SO Result = 0
		ld		hl,0
		ret		
		
;LIBRARY QUIG.LEN
;*****************
.Quig_Len:
;** INP String$[HL]
;** OUT HL = String Length
		xor		a
		ld 		c,a
		ld 		b,a
		cpir
		ld 		l,a
		ld 		h,a
		scf
		sbc 	hl,bc
		ret
;LIBRARY QUIG.ASC
;*****************
.Quig_Asc:
;** INP String$[HL]
;** OUT HL = ASCII of first string character
		ld		l,(hl)
		ld		h,0
		ret

;LIBRARY QUIG.HEX
;****************
.Quig_Hex:
		ld		de,(Quig_String_Buffer_Pos)
		ld		a,h
		call	Quig_Hex_Num1
		ld		a,h
		call	Quig_Hex_Num2
		ld		a,l
		call	Quig_Hex_Num1
		ld		a,l
		call	Quig_Hex_Num2
		ld		hl,(Quig_String_Buffer_Pos)		
		ld		(Quig_String_Buffer_Pos),de
		ret
.Quig_Hex_Num1:
		rra
		rra
		rra
		rra
.Quig_Hex_Num2:	
		or		#f0
		daa
		add		a,#A0
		adc		a,#40
		ld		(de),a
		inc		de
		ret	

;LIBRARY QUIG.SQR.INT
;********************
.Quig_Sqr_Int	
		ld		a,-1
		ld		d,a
		ld		e,a
.Quig_Sqrt16:	
		add		hl,de
		inc		a
		dec		e
		dec		de
		jr		c,Quig_Sqrt16
		ld		l,a
		ld		h,0
		ret
		
;LIBRARY QUIG.VALIDSTRING
;************************
;IN HL = String start
.Quig_ValidString:
		ld		de,(Quig_String_Buffer_Pos)
		dec		hl
.Quig_ValidString_Loop:
		inc		hl
		ld		a,(hl)
		ld		c,a
		;Is a zero
		and		a
		jr		z,Quig_ValidString_Finish
		ld		a,c
		and		%10000000
		jr		nz,Quig_ValidString_Loop
		ld		a,c
		and		%11100000
		jr		z,Quig_ValidString_Loop
		ld		a,c
		ld		(de),a
		inc		de
		jr		Quig_ValidString_Loop
.Quig_ValidString_Finish:
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(de),a
		inc		de
		ld		(Quig_String_Buffer_Pos),de
		ret

;LIBRARY QUIG.REPLACE
;********************
;IN ST = Source
;   DE = Find
;   HL = Replace
.Quig_Replace:
		pop		iy			;Gets return position
		ld		(Quig_Replace_Text_Start),hl
		ex		de,hl
		ld		(Quig_Find_Text_Start),hl		
		inclib	QUIG.LEN
		call	Quig_Len
		ld		a,l
		ld		(Quig_Replace_x+1),a
		xor		a
		ld		(Quig_Find_Text_Len),a
		ld		de,(Quig_String_Buffer_Pos)
		pop		hl			;Gets source
		ld		bc,(Quig_Find_Text_Start)
.Quig_Replace_1:		
		ld		a,(hl)
		cp		0
		jr		z,Quig_Replace_Finish
		ld		(Quig_Replace_2+1),a
		ld		a,(bc)
.Quig_Replace_2:
		cp		0							;Compare to Find text
		jr		z,Quig_Replace_Match		;Is same the jump to same area
		;no same just move on
		xor		a
		ld		(Quig_Find_Text_Len),a
		ldi		
		ld		bc,(Quig_Find_Text_Start)
		jr		Quig_Replace_1
		
.Quig_Replace_match:
		ld		a,(Quig_Find_Text_Len)
		cp		0
		jr		nz,Quig_Replace_match2:
		ld		(Quig_Match_start),de
.Quig_Replace_Match2:
		inc		a
.Quig_Replace_x:		
		cp		0					;Length placed here
		jr		z,Quig_Replace_Replace
		;Was not same so reset length count & copy
		ld		(Quig_Find_Text_Len),a	
		inc		bc
		inc		bc
		ldi		
		jr		Quig_Replace_1
		
.Quig_Replace_Replace:
		push	hl
		ld		hl,(Quig_Replace_Text_Start)
		ld		de,(Quig_Match_Start)
.Quig_Replace_Replace_2:		
		ld		a,(hl)
		cp		0
		jr		z,Quig_Replace_Replace_3:
		ld		(de),a
		inc		de
		inc		hl
		jr		Quig_Replace_Replace_2
.Quig_Replace_Replace_3:
		xor		a
		ld		(Quig_Find_Text_Len),a
		ld		bc,(Quig_Find_Text_Start)
		pop		hl
		inc		hl
		jr		Quig_Replace_1
		
.Quig_Replace_Finish:
		xor		a
		ld		(de),a
		inc		de
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		jp		(iy)
.Quig_Replace_Text_Start:dw	0
.Quig_Find_Text_Start:dw	0
.Quig_Match_start:		dw 0
.Quig_Find_Text_Len:db 	0	

;LIBRARY QUIG.FINDSTR		
;### FNDSTR -> searches for a string inside another string
;### Input      HL=search string, DE=find string, BC=start position (starting at 1)
;### Output     HL=position (starting at 1; 0=not found)
.Quig_FindStr:
		ld		c,l
		ld		b,h
		pop		iy
		pop		hl
.fndstr:
		ld 		a,c
        or 		b
        jr 		z,fndstr1
        dec 	bc
.fndstr1: 
		ld 		(fndstr7+1),hl
        ld 		(fndstr2+1),de
        push 	hl
        push 	bc
        ex 		de,hl
        call 	fndstr0        ;HL=strlen find
        push 	hl
        ld 		(fndstr3+1),hl
        ex 		de,hl
        call 	fndstr0        ;HL=strlen search
        pop 	de
        pop 	bc
        or 		a
        sbc 	hl,bc           ;HL=remaining length at startpos
        jr 		c,fndstr6
        sbc 	hl,de           ;HL=remaining length (startpos + find strlen)-1
        jr 		c,fndstr6
        inc 	hl
        ex 		de,hl
        pop 	hl
        add 	hl,bc           ;HL=startposition
        ld 		c,e
        ld 		b,d              ;BC=1st char search length
.fndstr2:
		ld 		de,0         ;*** main loop
        ld 		a,(de)
        cpir
        jr 		nz,fndstr5
        push 	hl
        push 	bc
.fndstr3:
		ld 		bc,0
.fndstr4:
		dec 	bc
        ld 		a,c
        or 		b
        jr 		z,fndstr7
        inc 	de
        ld 		a,(de)
        cp 		(hl)
        inc 	hl
        jr 		z,fndstr4
        pop 	bc
        pop 	hl
        ld 		a,c
        or 		b
        jr 		nz,fndstr2
.fndstr5: 
		ld 		hl,0
        jp		(iy)
.fndstr6:
		pop 	hl
        jr 		fndstr5
.fndstr7:
		ld		de,0
        pop 	bc
        pop 	hl
        or 		a
        sbc 	hl,de
        jp		(iy)
.fndstr0:
		xor 	a
        ld 		c,a
        ld 		b,a
        cpir
        ld 		a,c
        cpl
        ld 		l,a
        ld 		a,b
        cpl
        ld 		h,a
		ret
		
;LIBRARY QUIG.APP.COMMANDLINE
;*****************************
;IN HL = Last byte in Code
.Quig_App_CommandLine:
		ld		hl,Quig_CodeEnd
		inc		hl
		ret
.Quig_App_CommandLine_Len
		inclib 	QUIG.LEN
		ld		hl,Quig_CodeEnd
		inc		hl
		jp		Quig_Len

;LIBRARY QUIG.APP.SYSTEMPATH
;***************************
.Quig_App_SystemPath:
		ld		ix,(Quig_String_Buffer_Pos)
		ld 		de,256*32+5
		ld 		iy,0
		ld 		hl,jmp_sysinf
		rst 	#28
		
		xor		a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		e,l
		ld		d,h
.Quig_App_SysPath2:
		ld		a,(hl)
		inc		hl
		cp		0
		jr		nz,Quig_App_SysPath2
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
		ret
		
;LIBRARY QUIG.APP.PATH
;**********************
.Quig_App_Path
		ld		hl,Quig_CodeEnd
		inc		hl
		ld		de,(Quig_String_Buffer_Pos)
		ld		bc,0
.Quig_App_Path_1		
		ld		a,(hl)
		cp		"."
		jr		z,Quig_App_Path_Found
		cp		"\"
		jr		z,Quig_App_Path9
		cp		"/"
		jr		nz,Quig_App_Path_x
.Quig_App_Path9:
		ld		a,"\"
		ld		c,b
.Quig_App_Path_x:
		ld		(de),a
		inc		b
		inc		hl
		inc		de
		jr		Quig_App_Path_1
.Quig_App_Path_Found:
		ld		hl,(Quig_String_Buffer_Pos)
		ld		e,l
		ld		d,h
		ld		b,0
		add		hl,bc
		inc		hl
		xor		a
		ld		(hl),a
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
		ret
;LIBRARY QUIG.MLIST.SORT
;***********************
.Quig_Mlist_SortOnRefresh:
		ld		a,(hl)
		set 	6,a
		ld		(hl),a
		ret
;St1 = Appearance
;DE=Column		
;HL=SorOrder		
.Quig_Mlist_SortColumn:
		ld		a,e
		and		%1111
		ld		e,a
		res 	7,e
		ld		a,l
		and		%1
		cp		0
		jr		z,Quig_Mlist_SortColumn2
		set		7,e
.Quig_Mlist_SortColumn2:		
		pop		iy
		pop		hl
		ld		a,(hl)
		and		%1110000
		or		e
		ld		(hl),a
		jp		(iy)


;LIBRARY QUIG.MLIST.COLUMN.WIDTH.SET
;***********************************
;IN ST = Address Of ColumnData1
;   DE = Column
;   HL = Value
.Quig_Mlist_Column_Width_Set
		pop		iy
		ld		c,l
		ld		b,h
		ex		de,hl
		pop		de
		add		hl,hl		;*2
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,de
		inc		hl
		inc		hl
		ld		(hl),c
		inc		hl
		ld		(hl),b
		jp		(iy)
;LIBRARY QUIG.MLIST.COLUMN.WIDTH.GET
;***********************************
;IN DE = Address Of ColumnData1
;   HL = Column
.Quig_Mlist_Column_Width_Get
		add		hl,hl		;*2
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,de
		inc		hl
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ret		
;LIBRARY QUIG.MLIST.COLUMN.ALIGN.SET
;***********************************
;IN ST = Address Of ColumnData1
;   DE = Column
;   HL = Value
.Quig_Mlist_Column_Align_Set
		pop		iy
		ld		a,l
		and		%11
		ex		de,hl
		pop		de
		add		hl,hl		;*2
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,de
		ld		(hl),a
		jp		(iy)
;LIBRARY QUIG.MLIST.COLUMN.ALIGN.GET
;***********************************
;IN DE = Address Of ColumnData1
;   HL = Column
.Quig_Mlist_Column_Align_Get
		add		hl,hl		;*2
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,de
		ld		a,(hl)
		and		%11
		ld		l,a
		ld		h,0
		ret
		
;LIBRARY QUIG.FORM.MENU.TEXT.SET		
;********************************
;IN (ST1) = Form_List
;   DE = Item Number
;   HL = String Address
.Quig_Form_Menu_Text_Set
		pop		iy
		pop		bc
		push	hl			;Store String
		ld		l,c
		ld		h,b
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		de
		inc		de
		ex		de,hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		pop		hl
		push 	iy
		Inclib 	QUIG.LETSTRING
		jp		Quig_LetString
		
;LIBRARY QUIG.FORM.MENU.TEXT.GET
;*******************************
;IN DE=Form_List
;   HL = Item Number
.Quig_Form_Menu_Text_Get
		ex		de,hl
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		de
		inc		de
		ex		de,hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ret
;LIBRARY QUIG.FORM.MENU.ACTIVE.GET
;*********************************
;IN DE = Form_List
;   HL = Item Number
.Quig_Form_Menu_Active_Get
		ex		de,hl
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(de)
		and		%1
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.FORM.MENU.CHECK.GET
;*********************************
;IN DE = Form_List
;   HL = Item Number
.Quig_Form_Menu_Check_Get
		ex		de,hl
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(de)
		rra		
		and		%1
		ld		l,a
		ld		h,0
		ret		
;LIBRARY QUIG.FORM.MENU.ACTIVE.SET
;*********************************
;IN (ST1) = Form_List
;   DE = Item Number
;	HL = Value
.Quig_Form_Menu_Active_Set
		pop		iy
		ld		c,l				;Store Value
		pop		hl
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,c
		and		%1
		ld		c,a
		ld		a,(de)
		and		%11111110
		or		c
		ld		(de),a
		jp		(iy)
;LIBRARY QUIG.FORM.MENU.CHECK.SET
;*********************************
;IN (ST1) = Form_List
;   DE = Item Number
;	HL = Value
.Quig_Form_Menu_Check_Set
		pop		iy
		ld		c,l				;Store Value
		pop		hl
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,c
		rla
		and		%10
		ld		c,a
		ld		a,(de)
		and		%11111101
		or		c
		ld		(de),a
		jp		(iy)
;LIBRARY QUIG.FORM.MENU.ICON.ON
;*********************************
;IN (ST1) = Form_List
;   DE = Item Number
;	HL = Value
.Quig_Form_Menu_Icon_On:
		pop		iy
		ld		c,l				;Store Value
		pop		hl
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,c
		rla
		rla
		rla
		rla
		and		%10000
		ld		c,a
		ld		a,(de)
		and		%11101111
		or		c
		ld		(de),a
		jp		(iy)		
		
		
		
;LIBRARY QUIG.MLIST.TITLE.SET
;IN [ST]= Address of 1st Title in List
;    DE = Column Number
;    HL = String		
.Quig_MList_Title_Set:
		pop		iy		;Return address
		ld		c,l
		ld		b,h
		pop		hl
		ex		de,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl		;*8
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,c
		ld		h,b
		push	iy
		Inclib 	QUIG.LETSTRING
		jp		Quig_LetString		
		
;LIBRARY QUIG.MLIST.TITLE.GET
;****************************
;IN DE = Address of 1st Title in List
;   HL = Column number
.Quig_Mlist_Title_Get:
		add		hl,hl
		add		hl,hl
		add		hl,hl		;*8
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ret		

;LIBRARY QUIG.MLIST.COLUMN.DATA.START
;IN HL = Address of MList Ext Data
;IN BC = Row
.Quig_Mlist_Column_Data_Start:
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		push	bc				;Store Row		
		ld		de,4
		add		hl,de
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		inc		hl
		inc		hl
		ld		a,(hl)
		pop		de				;Gets Row
		push	bc				;Stores Offset Address
		inc		a
		add		a,a
		ld		l,a
		ld		h,0
		inclib 	QUIG.MUL16
		call	Quig_Mul16
		pop		de	
		add		hl,de
		ret

;LIBRARY QUIG.MLIST.TEXT.SET
;***************************
;IN ST = Address of MListExtData
;   ST = Column
;   DE = Row
;   HL = Source Text
.Quig_MList_Int_Set:
		pop		iy
		ld		(Quig_MList_Text_Set_Source),hl
			
		ld		c,e
		ld		b,d			;BC=Row
		pop		de			;DE=Column
		pop		hl			;HL=Address
		push	de			;Store Column
		Inclib 	QUIG.MLIST.COLUMN.DATA.START
		call	Quig_Mlist_Column_Data_Start
		inc		hl
		inc		hl
		pop		de
		add		hl,de
		add		hl,de
		ld		de,(Quig_MList_Text_Set_Source)
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		(iy)
.Quig_MList_Long_Set:
		pop		iy
		ld		(Quig_MList_Text_Set_Source),hl		
		ld		c,e
		ld		b,d			;BC=Row
		pop		de			;DE=Column
		pop		hl			;HL=Address
		push	de			;Store Column
		Inclib 	QUIG.MLIST.COLUMN.DATA.START
		call	Quig_Mlist_Column_Data_Start
		inc		hl
		inc		hl
		pop		de
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)									;Destination Address
		ld		hl,(Quig_MList_Text_Set_Source)			;Source address to copy from
		ldi
		ldi
		ldi
		ldi
		jp		(iy)		
.Quig_MList_Text_Set:
		pop		iy
		ld		(Quig_MList_Text_Set_Source),hl
		ld		c,e
		ld		b,d			;BC=Row
		pop		de			;DE=Column
		pop		hl			;HL=Address
		push	de			;Store Column
		Inclib 	QUIG.MLIST.COLUMN.DATA.START
		call	Quig_Mlist_Column_Data_Start
		inc		hl
		inc		hl
		pop		de
		add		hl,de
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		hl,(Quig_MList_Text_Set_Source)
		push	iy
		Inclib 	QUIG.LETSTRING
		jp		Quig_LetString
.Quig_MList_Text_Set_Source:	dw 0		
		
;LIBRARY QUIG.MLIST.SELECTED.GET
;IN DE = Address of MListExtData
;   HL = Row
.Quig_MList_Selected_Get:
		ld		c,l
		ld		b,h
		ex		de,hl
		Inclib 	QUIG.MLIST.COLUMN.DATA.START
		call	Quig_Mlist_Column_Data_Start
		inc		hl
		ld		a,(hl)
		ld		hl,0
		bit		7,a
		jr		z,Quig_MList.Selected_Get2
		inc		hl
.Quig_MList.Selected_Get2
		ret
;LIBRARY QUIG.MLIST.SELECTED.SET
;IN ST = Address of MListExtData
;   DE = Row
;   HL = Value
.Quig_MList_Selected_Set:
		pop		iy	
		ld		a,l
		and		a
		jr		z,Quig_MList_Selected_Set_9
		ld		a,#ff
		jr		Quig_MList_Selected_Set_8
.Quig_MList_Selected_Set_9		
		ld		a,#bf
.Quig_MList_Selected_Set_8
		ld		(Quig_MList_Selected_Set_x+1),a
		ld		c,e		
		ld		b,d
		pop		hl
		Inclib 	QUIG.MLIST.COLUMN.DATA.START
		call	Quig_Mlist_Column_Data_Start
		inc		hl
.Quig_MList_Selected_Set_x
		db		#cb,#bf			;Either SET 7,a or RES 7,a
		ld		(hl),a
		jp		(iy)
		
;LIBRARY QUIG.MLIST.TEXT.GET
;***************************
;IN ST = Address of MListExtData
;   DE = Column
;   HL = Row
.Quig_Mlist_Text_Get:
		pop		iy				;Get Return
		ld		c,l
		ld		b,h
		pop		hl
		push	de
		Inclib 	QUIG.MLIST.COLUMN.DATA.START
		call	Quig_Mlist_Column_Data_Start

		inc		hl
		inc		hl
		pop		de
		add		hl,de
		add		hl,de
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		jp		(iy)


		
;LIBRARY QUIG.SHEET.SIZE
;***********************
;IN HL = Address Sheet Status
.Quig_Sheet_Size:
		inc 	hl
		inc		hl
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ret
;LIBRARY QUIG.SHEET.COLOUR.DEPTH
;*********************
.Quig_Sheet_Colour_Depth:
		Inclib 	QUIG.GET.BYTE
		ld		bc,8
		add		hl,bc
		jp		Quig_Get_Byte		
;LIBRARY QUIG.GET.BYTE.PLUS1
;*********************
.Quig_Get_Byte_Plus1:
		Inclib 	QUIG.GET.BYTE
		inc		hl
		jp		Quig_Get_Byte
;LIBRARY QUIG.GET.BYTE
;*********************
.Quig_Get_Byte:
		ld		l,(hl)
		ld		h,0
		ret
;LIBRARY QUIG.SET.BYTE
;*********************
.Quig_Set_Byte:
		ex		de,hl
		ld		(hl),e
		ret	
;LIBRARY QUIG.DROP.LIST.SET
;**************************
.Quig_Drop_List_Set
		inclib	QUIG.LETSTRING
		pop		iy
		pop		bc
		ex		de,hl
		add		hl,hl
		add		hl,hl
		inc		hl
		inc		hl
		add		hl,bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		ld		e,c
		ld		d,b		
		push	iy
		jp		Quig_LetString
	
;LIBRARY QUIG.LIST.INDEX.SET
;INP [DE] = ListClick HL = Value
.Quig_List_Index_Set:
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret
		
;LIBRARY QUIG.LIST.SELECTED.GET
;*******************************
;INP [DE]-Start of List Data, [HL] Line required
.Quig_List_Selected_Get
		add		hl,hl
		add		hl,hl
		inc		hl
		add		hl,de
		ld		a,(hl)
		and 	%10000000
		jp		z,Quig_List_Selected_Get_2
		ld		a,1
Quig_List_Selected_Get_2
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.LIST.SELECTED.SET
;*******************************
;INP [DE]-Start of List Data, [HL] Line required
.Quig_List_Selected_Set
		add		hl,hl
		add		hl,hl
		inc		hl
		add		hl,de
		ld		a,(hl)
		set 	7,a
		ld		(hl),a
		ret		
;LIBRARY QUIG.LIST.SELECTED.RESET
;*******************************
;INP [DE]-Start of List Data, [HL] Line required
.Quig_List_Selected_ReSet
		add		hl,hl
		add		hl,hl
		inc		hl
		add		hl,de
		ld		a,(hl)
		res 	7,a
		ld		(hl),a
		ret				
		
;LIBRARY QUIG.DROP.LIST.GET
;**************************
.Quig_Drop_List_Get
		add		hl,hl
		add		hl,hl
		inc		hl
		inc		hl
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ret
;LIBRARY QUIG.COMBO.INDEX.SET
.Quig_Combo_Index_Set
;INP HL = Index Number
;    DE = Address of _ListClick
		ex		de,hl		;swap
		ld		(hl),e		;copy Index Number DE in _ListClick
		inc		hl
		ld		(hl),d
		ld		bc,5		;Offset
		add		hl,bc		;Skip 5 to point at _ListColumnTitle
		ld		c,l			;Store _ListColumnTitle in BC
		ld		b,h
		
		ex		de,hl		;Swap so HL is Index
		add		hl,hl		;*4
		add		hl,hl
		add		hl,de
		
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		l,c
		ld		h,b
		ld		(hl),e
		inc		hl
		ld		(hl),b
		ret
		
;LIBRARY QUIG.CHR
;****************
.Quig_Chr
		ld		de,(Quig_String_Buffer_Pos)
		ld		a,l
		ld		(de),a
		inc		de
		xor		a
		ld		(de),a
		inc		de
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret

;*** Input          A  = Menu data record ram bank (0-8)
;***                DE = Menu data record address (#C000-#FFFF)
;***                HL = X position (-1=place at mouse position)
;***                BC = Y position
;*** Output         CF = status (0=entry has been clicked, 1=menu canceled)
;***                - if CF is 0:
;***                HL = Menu entry value
;***                C  = Menu entry type (0=normal, 1=checked entry)


;LIBRARY QUIG.CONTEXT.MENU
;*************************
;IN HL=Menu data position
.Quig_Context_Menu:
		ex		de,hl
        ld 		a,(AppBnkNum)
		ld		hl,-1
        ld 		(AppMsgB+06),bc
        ld 		c,MSC_DSK_MENCTX
        call 	SyDesktop_SendMessage
.Quig_Context_Menu2:
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_MENCTX
        jr 		nz,Quig_Context_Menu2
        ld 		a,(AppMsgB+4)     ;menu entry type
        ld 		c,a
        ld 		a,(AppMsgB+1)     ;success state
        ld 		hl,(AppMsgB+2)    ;menu entry value
        cp 		1                    ;A=1 -> cf=0, A=0 -> cf=1
		ret 	nz
		xor		a
		ld		de,0
		sbc		hl,de
		ret		z
		ld		(Quig_Call_Set28+1),hl
.Quig_Call_Set28:
		call	0
        ret

;LIBRARY QUIG.PAINT.SET
;**********************
;DE Paint Pos
;HL Paper Colour
.Quig_Paint_Set:
		ex		de,hl
		ld		a,(hl)
		and		%11000000
		ld		b,a
		ld		a,e
		and		%1111
		or		b
		ld		(hl),a
		ret
;LIBRARY QUIG.PAINT.GET
;**********************
;HL : Paint Pos
.Quig_Paint_Get:
		ld		a,(hl)
		and		%1111
		ld		l,a
		ld		h,0
		ret
		
;LIBRARY QUIG.FORM.MODAL
;***********************
;DE = FormNo
;HL = Parent FormNo

.Quig_Form_PopUp:
		ld		a,1
		jr		Quig_Form_Modal5
.Quig_Form_Modal:
		xor		a
.Quig_Form_Modal5:		
		ld		(Quig_Form_Modal_4+1),a
		ld		a,l				
		ld		(Quig_Form_Modal_3+1),a			;Puts parent form no in Ld a,x		
		ld		hl,Quig_FormIDs					;Get Symbos form value for parent form
		add		hl,de
		ld		a,(hl)
		cp		255								;Is it used if 255 then Exit
		ret		z
		inc		a
		ld		(Quig_Form_Modal_2+1),a	
		ld		bc,8							;Move on 8 To Quig_FormClickOff Table which follows Quig_FormIDs
		add		hl,bc
.Quig_Form_Modal_4:		
		ld		a,0								;Put 0 Into this tabel a form position
		ld		(hl),a
		
		;Form stuff
		ld		a,e								;A = Form No
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	Quig_GetWindowEventAddr			;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Form Window Data		
		inc		de								;DE = Form position +2
		inc		de
		ld		a,(de)							;Load and set bit 4
		set 	4,a
		ld		(de),a
		
		;Parent form stuff
.Quig_Form_Modal_3:		
		ld		a,0								;A = Parent Form No
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	Quig_GetWindowEventAddr			;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Form Window Data			
		ld		hl,51
		add		hl,de
.Quig_Form_Modal_2:
		ld		a,0
		ld		(hl),a
		ret

	



		
;LIBRARY QUIG.FORM.CONTROL.COUNT
;****************************
;INP HL = Pointer to Control number on form
.Quig_Form_Control_Count:
		xor		a
		ld		h,a
		dec		hl
		ret
;LIBRARY QUIG.FORM.CONTROL.ID
;*****************************
;INP HL = Display Number
;    DE = Address of start of Window data
.Quig_Form_Control_ID:
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		ret

;LIBRARY QUIG.CONTROL.VALUE.SET
;******************************
;INP HL = Value 
;    DE = Value	address
.Quig_Control_Value_Set:
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret
;LIBRARY QUIG.CONTROL.STEP.SET
;*****************************
;INP HL = Value
;    DE = Value address
.Quig_Control_Step_Set:
		ex		de,hl
		ld		a,e
		ld		(hl),a
		inc		hl
		xor		%11111111
		inc		a
		ld		(hl),a
		ret
;LIBRARY QUIG.CONTROL.DISPLAY.GET
;************************
;INP HL = Control Address
.Quig_Control_Display_Get
		ld		a,(hl)
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.CONTROL.TYPE.GET
;************************
;INP HL = Control Address
.Quig_Control_Type_Get:
		inc		hl
		inc		hl
		ld		a,(hl)
		and		%111111
		ld		l,a
		ld		h,0
		ret	
;LIBRARY QUIG.CONTROL.LOCATION.GET
;*********************************
;INP HL = Control Address
.Quig_Control_Location_Get1:
		ld		bc,6						;/Left
		jr		Quig_Control_Location_Get
.Quig_Control_Location_Get2:				;/Top
		ld		bc,8
		jr		Quig_Control_Location_Get
.Quig_Control_Location_Get3:
		ld		bc,10						;/Width
		jr		Quig_Control_Location_Get
.Quig_Control_Location_Get4:
		ld		bc,12
.Quig_Control_Location_Get:
		add		hl,bc
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ret
		
;LIBRARY QUIG.CONTROL.TEXT.GET	
;*****************************
;IN HL=Control
.Quig_Control_Text_Get:	
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ret
.Quig_Control_Text_Len:
		INCLIB 	QUIG.LEN
		call	Quig_Control_Text_Get
		jp		Quig_Len
		
;LIBRARY QUIG.CONTROL.TEXT.SET		
;*****************************
;IN HL=Start of Source String
;   DE=Start of Control Block
.Quig_Control_Text_Set:
		INCLIB 	QUIG.LETSTRING		
		ex		de,hl			;HL now is the Control block pointer
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ex		de,hl
		jp		Quig_LetString
		
;LIBRARY QUIG.TEXTBOX.LETSTRING
;******************************
;IN HL=Start of Source String
;   DE=Start of Destination String
.Quig_TextBox_LetString:
		ex		de,hl
		push	de
		ld		de,8
		add		hl,de
		
		ld		(Quig_TextBox_StringLenPos),hl
		inc		hl
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		pop		de
		ex		de,hl
		ld		(Quig_TextBox_StringMax),bc
.Quig_TextBox_Strcop:
		ld 		a,(hl)
		ldi
		ret 	po
		or 		a
		jr 		nz,Quig_TextBox_strcop
		ld		hl,(Quig_TextBox_StringMax)
		ret

.Quig_TextBox_StringLenPos:dw	0		
.Quig_TextBox_StringMax:dw	0		
		

;LIBRARY QUIG.BASE64.ENCODE
;***************************		
.b64txt  
		db 		"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
;### B64ENC -> Encodes a binary into a Base64 text string
;### Input      HL=source binary address, BC=source length (<32768), DE=destination text address, IXL=text line length
;### Output     BC=length of Base64 text
;### Destroyed  AF,DE,HL,IX,IY
.Quig_Base64_Encode
		push	hl
		inclib 	QUIG.LEN
		call	Quig_Len
		ld		c,l
		ld		b,h
		pop		hl
		ld		de,(Quig_String_Buffer_Pos)
		DB 		#DD:LD L,76
.b64enc  
		xor 	a
        ld 		(b64chr3+2),a
        ld 		(b64chr3+3),a
        db 		#dd:ld h,a
.b64enc1 
		push 	bc
        push 	hl
        inc 	b
        dec 	b
        ld 		b,(hl)
        inc 	hl
        ld 		a,c
        ld 		c,(hl)
        inc 	hl
        jr 		nz,b64enc2
        cp 		3
        jr 		nc,b64enc2
        ld 		h,a
        ld 		l,0
        dec 	a
        jr 		nz,b64enc3
        ld 		c,0
        jr 		b64enc3
.b64enc2 
		ld 		l,(hl)       ;B,C,L=source bytes
        ld 		h,3
.b64enc3 
		ld 		a,b
        rrca
        rrca
        call 	b64chr     ;1.char -> byte0, bit7-2
        ld 		a,c
        rr 		b:rra
        rr 		b:rra
        rrca
        rrca
        call 	b64chr     ;2.char -> byte0, bit1-0, byte1, bit7-4
        dec 	h
        jr 		nz,b64enc5
        ld 		a,"="
        call 	b64chr0
.b64enc4
		ld 		a,"="
        call 	b64chr0
        jr 		b64enc6
.b64enc5 
		ld 		a,c
        rl 		l:rla
        rl 		l:rla
        call 	b64chr     ;3.char -> byte1, bit3-0, byte2, bit7-6
        dec 	h
        jr 		z,b64enc4
        ld 		a,l
        rra		:rra
        call 	b64chr     ;4.char -> byte2, bit 5-0
.b64enc6 
		pop		hl
        inc 	hl:inc hl:inc hl
        pop 	bc
        dec 	bc:dec bc:dec bc
        bit 	7,b
        jr 		nz,b64enc7
        ld 		a,b
        or 		c
        jr 		nz,b64enc1
.b64enc7
		ld 		bc,(b64chr3+2)
		
		ld		hl,(Quig_String_Buffer_Pos)
		ld		e,l
		ld		d,h
		add		hl,bc
		xor		a
		ld		(hl),a
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
        ret

;### B64CHR -> Writes one Byte as a Base64-char
;### Input      DE=destination text address, IXL=text line length, IXH=line char counter, (b64chr3+2)=total char counter
;### Output     DE,IXH,(b64chr3+2) updated
;### Destroyed  AF

.b64chr  
		and 	63
        ld 		iy,b64txt
        ld 		(b64chr1+2),a
.b64chr1 
		ld 		a,(iy+0)
.b64chr0 
		ld 		(de),a
        inc 	de
.b64chr3 
		ld 		iy,0
        inc 	iy
        db 		#dd:inc h
        db 		#dd:ld a,h
        db 		#dd:cp l
        jr 		c,b64chr2
        ld 		a,13
		ld 		(de),a
		inc 	de
		inc 	iy
        ld 		a,10
		ld 		(de),a
		inc 	de
		inc 	iy
        db 		#dd:ld h,0
.b64chr2 
		ld 		(b64chr3+2),iy
        ret
;LIBRARY QUIG.BASE64.DECODE
;### B64DEC -> Decodes a Base64 text string into a binary
;### Input      HL=source text address, BC=source length, DE=destination binary address
;### Output     CF=0 -> BC=length of binary, CF=1 -> wrong char(s) in source text
;### Destroyed  AF,DE,HL,IX,IY
.Quig_Base64_Decode
		push	hl
		inclib 	QUIG.LEN
		call	Quig_Len
		ld		c,l
		ld		b,h
		pop		hl
		ld		de,(Quig_String_Buffer_Pos)
.b64dec  
		push 	hl
		pop 	ix
        push 	de
        pop 	iy
        ld 		hl,0             ;l=char number (0-3), h=remaining bits
.b64dec1 
		ld 		a,(ix+0)
		inc 	ix
        cp 		32               ;ignore whitespaces
        jr 		z,b64dec8
        cp 		13
        jr 		z,b64dec8
        cp 		10
        jr 		z,b64dec8
        cp 		"="
        jr 		z,b64dec9
        ld 		e,62
        cp 		"+"
        jr 		z,b64dec3
        inc 	e
        cp 		"/"
        jr 		z,b64dec3
        sub 	"0"
        ld 		e,52
        cp 		10
        jr 		c,b64dec2
        sub 	65-48
        ld 		e,0
        cp 		26
        jr 		c,b64dec2
        sub 	97-65
        ld 		e,26
        cp 		e
        ccf
        ret 	c
.b64dec2 
		add 	e
        ld 		e,a
.b64dec3 
		ld 		a,l
        sub 	1
        jr 		z,b64dec5
        jr 		c,b64dec4
        dec 	a
        jr 		z,b64dec6
        ld 		a,h              ;char 3 -> byte 3, bit 5-0
        or 		e
        call 	b64dec0
        ld 		l,-1
        jr 		b64dec7
.b64dec4 
		ld 		h,e              ;char 0 -> byte 0, bit7-2
        jr 		b64dec7
.b64dec5 
		rl 		e:rl e           ;char 1 -> byte 0, bit1-0, byte 1, bit 7-4
        ld 		a,h
        rl 		e:rla
        rl 		e:rla
        call 	b64dec0
        ld 		a,h
        and 	#f0
        ld 		h,a
        jr 		b64dec7
.b64dec6 
		ld 		a,e              ;char 2 -> byte1, bit 3-0, byte 2, bit 7-6
        rrca	:rrca
        ld 		e,a
        and 	#0f
        or 		h
        call 	b64dec0
        ld 		a,h
        and 	#c0
        ld 		h,a
.b64dec7 
		inc 	l
.b64dec8 
		dec 	bc
        ld 		a,c
        or 		b
        jr 		nz,b64dec1
.b64dec9 
		ld 		bc,(b64deca+1)
		ld		hl,(Quig_String_Buffer_Pos)
		
		ld		e,l
		ld		d,h
		add		hl,bc
		xor		a
		ld		(hl),a
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
        ret
.b64dec0 
		ld 		(iy+0),a
        inc 	iy
        ld 		h,e
.b64deca 
		ld 		de,0
        inc 	de
        ld 		(b64deca+1),de
        ret


		
		
;LIBRARY QUIG.STRING.MEMORY
.Quig_String_Memory:
		ld		hl,(AppCodBeg+2)
		ld		de,File_Select_Text_Data-AppDatBeg
		scf
		sbc		hl,de
		ret
;LIBRARY QUIG.STRING.FREE
.Quig_String_Free:
		ld		hl,(AppCodBeg+2)
		ld		de,AppDatBeg
		add		hl,de
		ld		de,(Quig_String_Pos)
		scf
		sbc		hl,de
		ret	
;LIBRARY QUIG.STRING.BUFFER.FREE
.Quig_String_Buffer_Free:
		ld		hl,Quig_String_Buffer_Top
		ld		de,(Quig_String_Buffer_Pos)
		xor		a
		sbc		hl,de
		ret				

;LIBRARY QUIG.CLIPBOARD.TEXT.SET
;*******************************
;IN HL = Text
.Quig_ClipBoard_Text_Set:
		push	hl						;Store the location of text
		INCLIB 	QUIG.LEN
		call	quig_Len
		ld		(Quig_Clipboard_CopyLen+2),hl
		pop		bc						
		ld		de,(Quig_String_Buffer_Pos)
		ex		de,hl
		xor		a
		sbc		hl,de
		dec		hl
		sbc		hl,bc
		cp		h
		jr		nz,Quig_ClipBoard_Text_Set2
		ld		(Quig_String_Buffer_Pos),bc
.Quig_ClipBoard_Text_Set2:		
		push	bc
		pop		ix
.Quig_Clipboard_CopyLen:
		ld		iy,0
		ld		a,(appBnkNum)
		ld		e,a
		ld		d,1
		rst 	#20:dw #814e	
		ret
		
;LIBRARY QUIG.CLIPBOARD.TEXT.GET
;*******************************
.Quig_ClipBoard_Text_Get:
		ld		a,(appBnkNum)			;Bank2CopyToo
		ld		e,a						;Dest bank
		ld		ix,(Quig_String_Buffer_Pos)	;Copy too
		ld		iy,2048
		ld		d,1						;Text only
		rst 	#20:dw #8151
		
		push	iy
		pop		de
		ld		hl,(Quig_String_Buffer_Pos)
		add		hl,de
		ld		a,(hl)
		cp		0
		jr		z,Quig_ClipBoard_Text_Get2
		inc		hl
		xor		a
		ld		(hl),a
.Quig_ClipBoard_Text_Get2:
		inc		hl
		ld		de,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
		ret		
	
;LIBRARY QUIG.TEXTLINE.TEXT.SET
;*****************************
.Quig_TextBox_Reformat_Text_Set:
		ex		de,hl
		push	hl			;Push Destination
		ld		bc,18
		add		hl,bc
		ld		a,1
		ld		(hl),a
		inc		hl
		xor		a
		ld		(hl),a
		ld		bc,5
		add		hl,bc
		ld		bc,-8
		ld		(hl),c
		inc		b
		ld		(hl),b
		pop		hl
		ex		de,hl		
;******************************
;IN HL=Start of Source String
;   DE= 		
.Quig_TextLine_Text_Set:
		INCLIB 	QUIG.LETSTRING
		ld		(Quig_ls_scr_addr),hl
		ld		bc,1
		xor		a
		ld		c,a
		ld		b,a
		cpir				
		sub		c					;Invert BC gives string length inc 0 terminator
		ld 		c,a
		sbc		a,a
		sub		b
		ld 		b,a
		
		
	
		ex		de,hl				;HL=Start of TextLine Extended data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		(Quig_ls_des_addr),de
		inc		hl
		inc		hl
		inc		hl					;HL now at CurPos address
		dec		bc
		xor		a
		ld		(hl),c				;CurPos=BC
		inc		hl
		ld		(hl),b	
		inc		hl
		ld		(hl),a				;Selected=0
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),c
		inc 	hl
		ld		(hl),b
		inc		hl
		ld		e,(hl)				;DE = Get Max Length
		inc		hl
		ld		d,(hl)
		dec		hl
		dec		hl
		dec		hl					;HL = Length
		ex		de,hl				;HL = Max length DE = Length address
		push	hl
		scf		
		inc		bc
		sbc		hl,bc
		jr		nc,Quig_TL_TSet_Shorter
.Quig_TL_TSet_TooLong				
		pop		hl					;Pops Max
		ex		de,hl				;DE=Max
		ld		c,e					
		ld		b,d
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jr		Quig_TL_TSet_Copy
.Quig_TL_TSet_Shorter:
		pop		hl
		ex		de,hl
		dec		bc
		ld		(hl),c
		inc		hl
		ld		(hl),b
		inc		bc
.Quig_TL_TSet_Copy
		
		ld		de,(Quig_ls_des_addr)
		ld		hl,(Quig_ls_scr_addr)	
		ldir
		jp		Quig_LS_Finish
	
;LIBRARY QUIG.TEXTBOX.REFORMAT
;*****************************
.Quig_TextBox_Reformat:
		ld		de,-8
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret

;LIBRARY QUIG.IO.OUT
;********************
;IN DE=Port
;   HL=Value
.Quig_Io_Out:
		ld 		c,e
		ld		b,d
		out		(c),l
		ret
;LIBRARY QUIG.IO.IN
;********************
;IN HL=Port
.Quig_Io_In:
		ld 		c,l
		ld		b,h
		in		l,(c)
		ld		h,0
		ret		

;LIBRARY QUIG.LETSTRING.REFRESH
;******************************
; IN ST1 = Refresh 
;    HL=Start of Source String
;    DE=Start of Destination Old string
.Quig_LetString_Refresh
		INCLIB 	QUIG.LETSTRING
		INCLIB	QUIG.CONTROL.REFRESH
		pop		bc
		ld		(Quig_LetString_Refresh_Str),bc
		call	Quig_LetString
		pop		hl
		call	Quig_Control_Refresh
		ld		iy,(Quig_LetString_Refresh_Str)
		jp		(iy)
.Quig_LetString_Refresh_Str:	dw	0
		
;LIBRARY QUIG.LETSTRING
;**********************
;IN HL=Start of Source String
;   DE=Start of Destination Old string
.Quig_LetString
		ld		(Quig_ls_scr_addr),hl
		ld		(Quig_ls_des_addr),de
		;Get Len of Source
		xor		a
		ld 		c,a
		ld 		b,a
		cpir
		ld 		l,a
		ld 		h,a
		scf
		sbc 	hl,bc
		inc		hl
		ld		(Quig_ls_src_len),hl 	;Stores string length in src_len
		ex		de,hl
		dec		hl
		ld		b,(hl)
		dec		hl
		ld		c,(hl)
		ex		de,hl
		scf
		sbc		hl,bc
		jp		nc,Quig_LS_source_longer

;So the Source is shorter than destination		
.Quig_LS_copy_source2oldspot
		ld		de,(Quig_ls_des_addr)		;Get destination
		ld		hl,(Quig_ls_scr_addr)		;Get Source
		ld		bc,(Quig_ls_src_len)
		ldir
		jr		Quig_LS_Finish	

;Source is longer than destination
.Quig_LS_source_longer
		ld		de,(Quig_String_Pos)	;Get the next String Position we can copy too
		ld		hl,(Quig_ls_scr_addr)
;Copy from string area rather than buffer
.Quig_LS_source_longer_normal
		push	de	;Pushes String Pos
		ld		bc,(Quig_ls_src_len)	
		ldir
		inc		de	;Skip the 4 header places
		inc		de
		inc		de
		inc		de
		ld		(Quig_String_Pos),de	;New top of text
		;Change the original destination to null string
		ld		hl,(Quig_ls_des_addr)		;Get Source				
		dec		hl
		dec		hl
		dec		hl
		ld		d,(hl)
		xor		a
		ld		(hl),a
		dec		hl
		ld		e,(hl)
		ld		(hl),a
		ld		bc,(Quig_ls_src_len)
		pop		hl	;Gets Old string pos
		dec		hl
		ld		(hl),b
		dec		hl
		ld		(hl),c
		dec		hl
		ld		(hl),d
		dec		hl
		ld		(hl),e
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
.Quig_LS_Finish	
		;Clear the String Buffer to current string stack start
		INCLIB 	QUIG.STRING.STACK.CLEAR
		call	Quig_String_Stack_Clear

		;Do we need a garbage collection
		call	Quig_LS_CheckGarbage		
		ret		nz			;Space
		
	
		
		;Less than 1024 bytes left
		INCLIB 	QUIG.GARBAGE
		call	Quig_Garbage
		call	Quig_LS_CheckGarbage		
		ret		nz			;Now is Space
		INCLIB 	QUIG.DIALOG
		ld		hl,Quig_LS_Err1
		push	hl
		ld		hl,Quig_LS_Err2
		push	hl
		ld		de,Quig_LS_Err3
		ld		hl,1
		call	Quig_Dialog
		ret
.Quig_LS_Err1:	db	"ERROR",0
.Quig_LS_Err2:	db	"Out of String space",0
.Quig_LS_Err3:	db 	0
		
;CheckFreespace
;Return Z=No Space NZ=Okay	
		;Check how much freespace there is
.Quig_LS_CheckGarbage:		
		ld		hl,(AppCodBeg+2)
		ld		de,AppDatBeg
		add		hl,de
		ld		de,(Quig_String_Pos)
		scf
		sbc		hl,de
		ld		a,h
		and		%11111100
		ret		
		

.Quig_ls_src_len:	dw	0
.Quig_ls_scr_addr:	dw	0
.Quig_ls_des_addr:	dw	0

;LIBRARY QUIG.STRING.STACK.CLEAR
.Quig_String_Stack_Clear:
		ld		hl,(Quig_String_Buffer_StackNo)
		ld		de,Quig_String_Buffer_Stack
		add		hl,hl
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		(Quig_String_Buffer_Pos),de
		ret
		
		
;LIBRARY QUIG.STR.ADD
.Quig_Str_Add
		push	hl
		ex		de,hl
		ld		de,(Quig_String_Buffer_Pos)
		xor		a
.Quig_Str_Add_p1		
		cp		(hl)
		ldi
		jr		nz,Quig_Str_Add_p1
		dec		de
		pop		hl
.Quig_Str_Add_p2		
		cp		(hl)
		ldi
		jr		nz,Quig_Str_Add_p2
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret

		
;LIBRARY QUIG.STR.STR
;### CLCNUM -> Converts signed 16Bit value into ASCII string
;### Input      HL=value
.Quig_Str_From_INT_HL
		push	de
		call	Quig_Str_Str
		pop		de
		ret
.Quig_Str_From_INT_DE
		push	hl
		ex		de,hl
		call	Quig_Str_Str
		ex		de,hl
		pop		hl
		ret		

.Quig_clcnumt dw -1,-10,-100,-1000,-10000
.Quig_Str_Str
        ld      iy,(Quig_String_Buffer_Pos)
        push    iy

        bit     7,h
        jr      z,Quig_clcnum0
        ld      (iy+0),"-"
        inc     iy
        ld      a,l
        cpl
        ld      l,a
        ld      a,h
        cpl
        ld      h,a
        inc     hl
.Quig_clcnum0 
        ld      ix,Quig_clcnumt+8
        ld      b,5
        xor     a
.Quig_clcnum1
        ld      e,(ix+0)
        ld      d,(ix+1)
        dec     ix
        dec     ix
        ld      c,"0"
.Quig_clcnum2 
        add     hl,de
        jr      nc,Quig_clcnum5
        inc     c
        inc     a
        jr      Quig_clcnum2
.Quig_clcnum5 
        sbc     hl,de
        or      a
        jr      z,quig_clcnum3
        ld      (iy+0),c
        inc     iy
.Quig_clcnum3 
        djnz    Quig_clcnum1
        or      a
        jr      nz,Quig_clcnum6
        ld      (iy+0),"0"
        inc     iy
.Quig_clcnum6   ld      (iy+0),0
		inc		iy
        ld      (Quig_String_Buffer_Pos),iy
        pop     hl
        ret	

;LIBRARY QUIG.CONTROL.GETID
;***************************
;IN DE = Form Number
;   HL = COntrol Position number
.Quig_Control_GetID
		ex		de,hl			;Swap
		add		hl,hl			; Number *4
		add		hl,hl
		ld		bc,ControWindowDataList
		add		hl,bc			;HL = Position of ControlData
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a				;HL=Address of Control stuff
		ex		de,hl
		add		hl,hl			;*2
		add		hl,hl			;*4
		add		hl,hl			;*8
		add		hl,hl			;*16
		add		hl,de
		ret
		
;LIBRARY QUIG.RIGHT
;************************
;DE = String Start 
;HL = Length
.Quig_Right:
		ex		de,hl			;Swap HL=String
		push	hl				;Push String Start
		push	de				;Push Required Length
		INCLIB 	QUIG.LEN		
		call	Quig_Len		;HL=Length
		pop		bc				;BC=Required Length
		xor 	a
		sbc		hl,bc			;HL = Length - ReqLength
		jr		nc,Quig_Right_2
		ld		hl,0
.Quig_Right_2:
		pop		de				;String Start
		ex		de,hl
		add		hl,de
		ld		de,(Quig_String_Buffer_Pos)	
.Quig_Right_Lets_Copy		
		ld		a,(hl)
		ld		(de),a
		inc		de
		inc		hl
		and		a
		jr		nz,Quig_Right_Lets_Copy
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret
		
;LIBRARY QUIG.LEFT
;************************
.Quig_Left:
		ld		c,l
		ld		b,h
		ex		de,hl
		ld		de,(Quig_String_Buffer_Pos)	
.Quig_Left_x:
		ld		a,(hl)
		ld		(de),a
		inc		de
		inc		hl
		and		a
		jr		z,Quig_Left_2
		xor		a
		cp		c
		jr		nz,Quig_Left_3
		cp		b
		jr		z,Quig_Left_4
.Quig_Left_3:		
		dec		bc
		jr		Quig_Left_x
.Quig_Left_4:
		dec		de
		ld		(de),a
		inc		de
.Quig_Left_2:
		ld		hl,(Quig_String_Buffer_Pos)	
		ld		(Quig_String_Buffer_Pos),de		
		ret
		
		
;LIBRARY QUIG.MID
;******************
;ST: String
;DE: Start
;HL: Len 
.Quig_Mid
		pop		iy					;Get the Return position
		
		ld		c,e					;BC = Start
		ld		b,d
		ld		e,l					;DE = Len
		ld		d,h
		pop		hl					;HL = String
		
		
		xor		a					;A=0
		cpir 						;Repeat until BC=0 or 0 terminator found
		jr		z,Quig_mid_empty
		dec		hl		
		ld		c,e
		ld		b,d
		ld		de,(Quig_String_Buffer_Pos)	
		
.Quig_Mid_1x		
		ld 		a,(hl)
		ldi
		jp 		po,Quig_mid_3x
		or 		a
		jr 		nz,Quig_Mid_1x
.Quig_Mid_2x

		ld		hl,(Quig_String_Buffer_Pos)
	
		ld		(Quig_String_Buffer_Pos),de
		jp		(iy)
.Quig_Mid_3x
		xor		a
		ld		(de),a
		inc		de
		jr		Quig_Mid_2x
.Quig_mid_empty
		xor		a
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(hl),a
		inc		hl
		ex		de,hl
		jr		Quig_Mid_2x
		
;LIBRARY QUIG.UCASE
;************************
.Quig_UCase
		ld		de,(Quig_String_Buffer_Pos)
.Quig_UCase1
		ld		a,(hl)
		cp		97
		jr		c,Quig_UCase2
		cp		123
		jr		nc,Quig_UCase2
		sub		32
.Quig_UCase2
		ld		(de),a
		inc		de
		inc		hl
		and 	a
		jp		nz,Quig_UCase1
		
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret

;LIBRARY QUIG.LCASE
;************************
.Quig_LCase
		ld		de,(Quig_String_Buffer_Pos)
.Quig_LCase1
		ld		a,(hl)
		cp		65
		jr		c,Quig_LCase2
		cp		91
		jr		nc,Quig_LCase2
		add		32
.Quig_LCase2		
		ld		(de),a
		inc		de
		inc		hl
		and 	a
		jp		nz,Quig_LCase1

		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret			
	
;LIBRARY QUIG.STR.EQUAL
;***********************
.Quig_Str_Equal		
;** Test, if STR1=STR2
;** Input      DE=str1, HL=str2
;** Output     HL=result (1=true, 0=false)
		ld 		a,(de)
        cp 		(hl)
        jr 		nz,Quig_cmpseq1
        inc 	de
        inc 	hl
        or 		a
        jr 		nz,Quig_Str_Equal
        ld 		hl,1
        ret
.Quig_cmpseq1 
		ld 		hl,0
        ret
;LIBRARY QUIG.STR.OTHER.THAN
;***********************
.Quig_Str_Ot	
;** Test, if STR1<>STR2
;** Input      DE=str1, HL=str2
;** Output     HL=result (1=true, 0=false)  
		ld 		a,(de)
        cp 		(hl)
        jr 		nz,Quig_cmpsot1
        inc 	de
        inc 	hl
        or 		a
        jr 		nz,Quig_Str_Ot
        ld 		hl,0
        ret
.Quig_cmpsot1 
		ld 		hl,1
        ret		
		
;LIBRARY QUIG.STR.GREATER.THAN
;******************************
.Quig_Str_Gt	
;### Test, if STR1>STR2
;### Input      DE=str1, HL=str2
;### Output     HL=result (1=true, 0=false)
		ld 		a,(de)
        cp 		(hl)
        jr 		nz,Quig_cmpsgt2
        inc 	de
        inc 	hl
        or 		a
        jr 		nz,Quig_Str_Gt
.Quig_cmpsgt1 
		ld 		hl,0
        ret
.Quig_cmpsgt2 
		jr 		c,Quig_cmpsgt1
        ld 		hl,1
        ret

;LIBRARY QUIG.STR.GREATER.THAN.EQUAL
;***********************************
.Quig_Str_Gte
;** Input      DE=str1, HL=str2
;** Output     HL=result (1=true, 0=false)
		ld 		a,(de)
        cp 		(hl)
        jr 		nz,Quig_cmpsge2
        inc 	de
        inc 	hl
        or 		a
        jr 		nz,Quig_Str_Gte
.Quig_cmpsge1
		ld 		hl,1
        ret
.Quig_cmpsge2 
		jr 		nc,Quig_cmpsge1
        ld 		hl,0
        ret

;LIBRARY QUIG.STR.LESSER.THAN
;**********************************
.Quig_Str_Lt
;### Input      DE=str1, HL=str2
;### Output     HL=result (1=true, 0=false)
		ld		a,(de)
		cp		(hl)
		jr		nz,Quig_cmpslt2
		inc		de
		inc		hl
		or		a
		jr 		nz,Quig_cmpslt
.Quig_cmpslt1 
		ld 		hl,0
        ret
.Quig_cmpslt2 
		jr 		nc,Quig_cmpslt1
		ld 		hl,1
		ret
;LIBRARY QUIG.STR.LESSER.THAN.EQUAL
;**********************************
.Quig_Str_Lte
;### Input      DE=str1, HL=str2
;### Output     HL=result (1=true, 0=false)
  
		ld 		a,(de)
		cp		(hl)
		jr		nz,Quig_cmpsle2
		inc		de
		inc		hl
		or 		a
		jr 		nz,Quig_Str_Lte
.Quig_cmpsle1 
		ld		hl,1
        ret
.Quig_cmpsle2 
		jr 		c,Quig_cmpsle1
        ld 		hl,0
        ret

;LIBRARY QUIG.CHECK.TICK.SET
;****************************
.Quig_Check_Tick_Set:
		ld		a,l
		and		%1
		ld		(de),a
		xor		a
		inc		de
		ld		(de),a
		ret	

;LIBRARY QUIG.CONTROL.REFRESHAREA
;*****************************
;ST 3 = Control
;ST 2 = X
;ST 1 = Y
;DE = Width
;HL = Height
.Quig_Control_RefreshArea:
		pop		iy
		ld		(AppMsgB+10),hl
		ld		(AppMsgB+8),de
		pop		hl
		ld		(AppMsgB+6),hl
		pop		hl
		ld		(AppMsgB+4),hl
		pop		hl
		push	iy
		ld 		a,MSC_DSK_WINPIN
		ld		(AppMsgB),a			
		ld		a,(hl)						;Get Control Number
		ld		(AppMsgB+2),a			
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)		
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld		(AppMsgB+1),a
        ld 		iy,AppMsgB
        db 		#dd:ld h,2       ;2 is the number of the desktop manager process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#10
        ret

;LIBRARY QUIG.SPRITE.ON
;***********************
;DE = First On of Sprites
;HL = Sprite Number
.Quig_Sprite_On:
		add		hl,hl		;*2
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,hl		;*16
		add		hl,hl		;*32
		add		hl,de
		res  	6,(hl)
		ret
	
;		add		hl,hl		;*2
;		ld		c,l			;BC=HL*2
;		ld		b,h
;		add		hl,hl		;*4
;		add		hl,hl		;*8
;		add		hl,bc		;*10
;		add		hl,de
;		ld		a,10
;		ld		(hl),a
;		ret

;LIBRARY QUIG.SPRITE.OFF
;***********************
;DE = First On of Sprites
;HL = Sprite Number
.Quig_Sprite_Off:
		add		hl,hl		;*2
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,hl		;*16
		add		hl,hl		;*32
		add		hl,de
		set  	6,(hl)
		ret	


;		add		hl,hl		;*2
;		ld		c,l			;BC=HL*2
;		ld		b,h
;		add		hl,hl		;*4
;		add		hl,hl		;*8
;		add		hl,bc		;*10
;		add		hl,de
;		ld		a,138
;		ld		(hl),a
;		ret
;LIBRARY QUIG.SPRITE.GET
;***********************
;DE = First On of Sprites
;HL = Sprite Number
.Quig_Sprite_Get:
		add		hl,hl		;*2
		ld		c,l			;BC=HL*2
		ld		b,h
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,bc		;*10
		add		hl,de
		ld		l,(hl)
		ld		h,0
		ret		
		
;LIBRARY QUIG.SPRITE.POS.SET
;****************************
;ST2 = FirstX of Sprites
;ST1 = Sprite No
;DE = X
;HL = Y
.Quig_Sprite_Pos_Set	
		pop  	iy
		ld		d,l			;Puts Y into D
		pop		hl			;HL Sprite Number
		add		hl,hl		;*2
		ld		c,l
		ld		b,h			;bc=hl*2		
		add		hl,hl		;*4
		add		hl,hl		;*8
		add		hl,bc		;*10
		pop		bc
		add		hl,bc
		ld		(hl),e		
		inc		hl
		ld		(hl),d
		jp		(iy)

;LIBRARY QUIG.FOCUS.SET
;***************************
;DE = Form Focus Position
;HL = display number
.Quig_Focus_Set:
		ld		a,l
		inc		a
		ld		(de),a
		ret
		
;LIBRARY QUIG.CONTROL.REFRESH
;*****************************
;DE=Control
;HL=Sequence number
.Quig_Control_RefreshSequence:

		ex		de,hl
		ld		d,(hl)						;Get Control Number
		ld		a,255		
		xor		e
		ld		e,a
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)	
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINDIN
		jp		SyDesktop_SendMessage

.Quig_Control_Refresh:
		ld		e,(hl)						;Get Control Number
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)
		bit		0,a
		jr		nz,Quig_Control_Refresh22
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINDIN
		jp		SyDesktop_SendMessage
.Quig_Control_Refresh22:		
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0							;b is empty
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINTOL
		jp		SyDesktop_SendMessage		
		
		
;LIBRARY QUIG.CONTROL.TOOL.REFRESH
;*****************************
.Quig_Control_ToolRefresh:
		ld		e,(hl)						;Get Control Number
		inc		hl							;Move to Second byte of Control ID
		ld		a,(hl)		
		rra
		rra
		rra
		and		%111						;Rotate 3 bits for forms 0-7
		ld		c,a							;c=form number
		ld		b,0							;b is empty
		ld		hl,Quig_FormIDs
		add     hl,bc
		ld		a,(hl)
		ld 		c,MSC_DSK_WINTOL
		jp		SyDesktop_SendMessage

;LIBRARY QUIG.FORM.REFRESH.PARTS
;******************************
.Quig_RefreshControlAll:
		call	Quig_RefreshFormPart
		ld		e,255
		ld		c,MSC_DSK_WINDIN
		jp 		SyDesktop_SendMessage
.Quig_RefreshToolAll:
		call	Quig_RefreshFormPart
		ld		e,255
		ld		c,MSC_DSK_WINTOL
		jp 		SyDesktop_SendMessage		
.Quig_RefreshStatus:
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINSTA
        jp 		SyDesktop_SendMessage	
.Quig_RefreshTitle
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINTIT
        jp 		SyDesktop_SendMessage		
.Quig_RefreshMenu:
		call	Quig_RefreshFormPart
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage	
.Quig_RefreshFormPart
		ex		de,hl
		ld		hl,Quig_FormIDs
		add		hl,de
		ld		a,(hl)
		ret	




;ifdef use_SyDesktop_STIREM
;    if use_SyDesktop_STIREM=1
;SyDesktop_STIREM
;;******************************************************************************
;;*** Name           SystrayIcon_Remove_Command
;;*** Input          A  = Icon ID
;;*** Output         -
;;*** Destroyed      AF,BC,DE,HL,IX,IY
;;*** Description    ...
;;******************************************************************************
 ;       ld c,MSC_DSK_STIREM
 ;       jp SyDesktop_SendMessage
;    endif
;endif

;LIBRARY QUIG.SHL1
;*****************
.Quig_Shl1:
		add		hl,hl
		ret
;LIBRARY QUIG.SHR1
;*****************
.Quig_Shr1:
		srl 	h:rr 	l
		ret
;LIBRARY QUIG.SHL2
;*****************
.Quig_Shl2:
		add		hl,hl
		add		hl,hl
		ret		
;LIBRARY QUIG.SHR2
;*****************
.Quig_Shr2:
		SRL H:RR L:SRL H:RR L
		ret	
;LIBRARY QUIG.SHL3
;*****************
.Quig_Shl3:
		add		hl,hl:add hl,hl:add hl,hl
		ret			
;LIBRARY QUIG.SHR3
;*****************
.Quig_Shr3:
		LD 	A,L:SRL H:RRA:SRL H:RRA:SRL H:RRA:LD L,A
		ret	
;LIBRARY QUIG.SHL4
;*****************
.Quig_Shl4:
		add		hl,hl:add hl,hl:add hl,hl:add hl,hl
		ret		
;LIBRARY QUIG.SHR4
;*****************
.Quig_Shr4:
		LD A,L:SRL H:RRA:SRL H:RRA:SRL H:RRA:SRL H:RRA:LD L,A
		ret	
;LIBRARY QUIG.SHL5
;*****************
.Quig_Shl5:
		add		hl,hl:add hl,hl:add hl,hl:add hl,hl
		ret		
;LIBRARY QUIG.SHR5
;*****************
.Quig_Shr5:	
		ld a,l:srl h:rra:srl h:rra:srl h:rra:srl h:rra:srl h:rra:ld l,a	
		ret
;LIBRARY QUIG.SHL6
;*****************
.Quig_Shl6:		
		xor 	a
		rr 		h:rr l:rra
		rr 		h:rr l:rra
		ld 		h,l
		ld 		l,a		
		ret
;LIBRARY QUIG.SHR6
;*****************
.Quig_Shr6:	
		ld a,h:rl l:rla:rl l:rla:ld l,a:ld a,h:rlca:rlca
        and 3:ld h,a
		ret
;LIBRARY QUIG.SHL7
;*****************
		rr 	h:ld h,l:rr h:ld l,0:rr l
		ret
;LIBRARY QUIG.SHR7
;*****************
.Quig_Shr7:
		ld a,h:rl l:rla:ld l,a:ld a,h:rlca:and 1:ld h,a
		ret
;LIBRARY QUIG.SHL8
;*****************
.Quig_Shl8:
		ld		h,l
		ld		l,0
		ret		
;LIBRARY QUIG.SHR8
;*****************
.Quig_Shr8:
		ld		l,h
		ld		h,0
		ret
;LIBRARY QUIG.SHL9
;*****************
.Quig_Shl9:
		add		hl,hl
		ld		h,l
		ld		l,0
		ret
;LIBRARY QUIG.SHR9
;*****************
.Quig_Shr9:
		srl 	h:ld	l,h
		ld		h,0
		ret	
;LIBRARY QUIG.SHL11
;*****************
.Quig_Shl11:
		ld		h,l:ld l,0
		add		hl,hl:add hl,hl:add hl,hl
		ret	
;LIBRARY QUIG.SHR12
;*****************
.Quig_Shr12:
		LD 		A,H:SRL H:RRA:SRL H:RRA:SRL H:RRA:SRL H:RRA:LD L,A:LD h,0
		ret			
;LIBRARY QUIG.SHL12
;*****************
.Quig_Shl12:
		ld		h,l:ld l,0
		add		hl,hl:add hl,hl:add hl,hl:add hl,hl
		ret			
		
;LIBRARY QUIG.RANGE
;******************
;IN HL = Value
;   DE = Max
;   ST = Min
.Quig_Range:
		pop		iy					;Pull the Return Address
.Quig_minmax:
		bit 	7,h
        jr 		z,Quig_minmax1
        ld 		hl,0         		;value is unsigned now
.Quig_minmax1: 
		ld 		c,l
        ld 		b,h          		;bc,hl=value
        or		a
        sbc 	hl,de
        jr 		nc,Quig_minmax2   	;value>=max -> let's take max
        ld 		e,c          		;value<max -> let's take value
        ld 		d,b
        or 		a
.Quig_minmax2:
		pop 	hl          		;get min
        ld 		c,l
        ld 		b,h          		;bc,hl=min, de=value
        sbc 	hl,de
        ex 		de,hl        		;hl=value
        jr 		c,Quig_minmax_Exit       ;min<value -> take value
        ld 		l,c
        ld 		h,b          		;min>=value -> take min
.Quig_minmax_Exit:
		jp		(iy)				;exit

;LIBRARY QUIG.MOUSE.XYKEY
.Quig_Mouse_XYKey:
		rst		#20
		dw 		#813C
		ld		(Quig_Mouse_ResultX),de
		ld		(Quig_Mouse_ResultY),hl
		rst 	#20
		dw 		#813F
		ld		(Quig_Mouse_ResultKey),a
		ret	
.Quig_Mouse_ResultX:	dw	0
.Quig_Mouse_ResultY:	dw	0
.Quig_Mouse_ResultKey:	db	0		
	
;LIBRARY QUIG.MOUSE.X
;*********************
.Quig_Mouse_X:
		rst 	#20
		dw 		#813C
		ex		de,hl				;X results in DE so put in HL
		ret
;LIBRARY QUIG.MOUSE.Y
;*********************
.Quig_Mouse_Y:
		rst 	#20
		dw 		#813C
		ret
;LIBRARY QUIG.MOUSE.KEY
;*********************
.Quig_Mouse_Key:
		rst 	#20
		dw 		#813F
		ld		l,a
		ld		h,0
		ret		

;LIBRARY QUIG.INTFRAC.STRUCT
;****************************
;HL=Amount - DE = Addr Fractional
.Quig_IntFrac_Struct:
.fxpadd  ex de,hl    ;1
        ld c,(hl)   ;2
        inc hl      ;2
        ld b,(hl)   ;2
        inc hl      ;2
        ex de,hl    ;1

        bit 7,h
        jr nz,fxpadd1

        add hl,bc   ;3
        ld a,(de)   ;2
        adc 0       ;2
        ld (de),a   ;2
        ex de,hl    ;1
        dec hl      ;2
        ld (hl),d   ;2
        dec hl      ;2
        ld (hl),e   ;2 28
        ret

.fxpadd1 add hl,bc   ;3
        ld a,(de)   ;2
        adc -1      ;2
        ld (de),a   ;2
        ex de,hl    ;1
        dec hl      ;2
        ld (hl),d   ;2
        dec hl      ;2
        ld (hl),e   ;2
        ret



;LIBRARY QUIG.INTFRAC
;*****************
;HL=Amount - DE = Addr Fractional - St = Addr LargeInt
.Quig_IntFrac:
		pop 	iy
		ld		a,h
		bit		7,a
		jp		nz,Quig_IntFrac_Neg

		ld		a,(de)
		ld		c,a
		ld		b,0
		add		hl,bc
		ld		a,l
		ld		(de),a
		ld		c,h
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		add		hl,bc
		jp		(iy)
		
.Quig_IntFrac_Neg:		
		;DO ABS
		ld		a,l
		xor		255
		ld		l,a
		ld		a,h
		xor		255
		ld		h,a
		inc		hl
		
		ld		a,(de)
		ld		c,a
		ld		b,0
		add		hl,bc
		ld		a,l
		ld		(de),a
		ld		c,h
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		and		a
		sbc		hl,bc
		jp		(iy)

;LIBRARY QUIG.INTSIN
;***************************
;In HL = (0-255)
.Quig_IntSin:
		ld 		a,l
		ex		de,hl
		ld 		bc,Quig_IntSinTable
		and		%1111111
		ld		l,a
		ld		h,0
		add		hl,bc
		ld		a,(hl)
		ld		l,a
		ld		h,0
		bit		7,e
		ret		z
		;ld		a,l
		xor		255
		ld		l,a
		dec		h
;		ld		a,h
;		xor		255
;		ld		h,a
		inc		hl
		ret	
.Quig_IntSinTable
		db 0,6,13,19,25,31,37,44,50,56,62,68,74,80,86,92,98,103,109,115,120
		db 126,131,136,142,147,152,157,162,167,171,176,180,185,189,193,197
		db 201,205,208,212,215,219,222,225,228,230,233,236,238,240,242,244
		db 246,247,249,250,251,252,253,254,254,255,255,255,255,255,254,254
		db 253,252,251,250,249,247,246,244,242,240,238,236,233,231,228,225
		db 222,219,215,212,209,205,201,197,193,189,185,180,176,171,167,162
		db 157,152,147,142,137,131,126,120,115,109,103,98,92,86,80,74,68,62
		db 56,50,44,38,31,25,19,13,6


;LIBRARY QUIG.MUL8
;*****************
;IN H & E
;Out HL
.Quig_Mul8:
		ld		h,l
		ld 		d,0
		ld 		l,d
		sla 	h : jr nc,1 : ld l,e
		add 	hl,hl : jr nc,1 : add hl,de
		add 	hl,hl : jr nc,1 : add hl,de
		add 	hl,hl : jr nc,1 : add hl,de
		add 	hl,hl : jr nc,1 : add hl,de
		add 	hl,hl : jr nc,1 : add hl,de
		add 	hl,hl : jr nc,1 : add hl,de
		add 	hl,hl : ret nc : add hl,de
		ret		
;LIBRARY QUIG.MUL16
;***********************
.Quig_Mul16
		ld		c,l
		ld		a,h
		ld 		b,16
.Quig_INT_Mult16_Loop_DEHL:
		add		hl,hl
		sla 	c
		rla
		jr 		nc,Quig_INT_Mult16_NoAdd_DEHL
		add 	hl,de
.Quig_INT_Mult16_NoAdd_DEHL:
		djnz	Quig_INT_Mult16_Loop_DEHL
		ret	
		
;LIBRARY QUIG.DIV16
;**********************
.Quig_Mod16:
		call	Quig_Div16
		ex		de,hl
		ret
.Quig_Div16:
		ex		de,hl           	; HL = DE \ HL
		ld		a,e             	; Division by zero?
		Or		d
		jr		nz,Quig_N_Div17      ; Continue of not
		ld		hl,0
		ld		de,0
		scf			            	; Set Carry to indicate an error
		ret
.Quig_N_Div17:
		ld		c,l             	; AC = HL
		ld		a,h
		ld		hl,0            	; HL = Modulus
		ld		b,16            	; 16-bit division
		Or		a               	; Start with carry reset
.Quig_N_Div18:
		rl		c               	; AC = AC * 2
		rla  	                	; (set Carry to bit 0)
		rl		l               	; HL = HL * 2
		rl		h               	; (reset Carry again (HL = 0))
		push	hl
		sbc		hl,de
		ccf                     	; Carry set when Ok
		jr		c,Quig_N_Div19       ; Modulus cannot be >= Value
		ex		(sp),hl         	; Restore Modulus
.Quig_N_Div19:
		inc		SP              	; Get Modulus from Stack
		inc		SP
		djnz 	Quig_N_Div18         ; Repeat for all bits
; Shift last Carry-bit to divider
		ex		de,hl           	; DE = Modulus
		rl		c               	; Carry to C
		ld		l,c             	; HL = AC
		rla
		ld		h,a
		Or		a               	; Reset Carry (valid result)
		ret		

;LIBRARY QUIG.INT.LTE.HL
;**********************
;;### Output     HL=1 -> true
;;###            HL=0 -> false
.Quig_LTE_HL
		ld		a,h
		xor		d
		jp 		m,Quig_cmplte2
		sbc 	hl,de
		jr		nc,Quig_cmplte3
.Quig_cmplte1                 ;false
		ld 		hl,0
		ret
.Quig_cmplte2 
		bit 	7,d
		jr 		z,Quig_cmplte1
.Quig_cmplte3                ;true
        ld 		hl,1
        ret
.Quig_LT_HL
		ld 		a,h
        xor		d
		jp 		m,quig_cmplte2
		sbc 	hl,de
		jr 		z,quig_cmplte1
		jr 		nc,quig_cmplte3
		;false
		ld 		hl,0
		ret
		
.Quig_LTE_HL_Direct
		ld		a,h
		xor		d
		jp 		m,Quig_cmplte2dx
		sbc 	hl,de
		jr		nc,Quig_cmplte3dx
.Quig_cmplte1dx                 ;false
		xor		a
		ret
.Quig_cmplte2dx 
		bit 	7,d
		jr 		z,Quig_cmplte1dx
.Quig_cmplte3dx                ;true
        ld		a,1
		or 		a
        ret
.Quig_LT_HL_Direct
		ld 		a,h
        xor		d
		jp 		m,quig_cmplte2dx
		sbc 	hl,de
		jr 		z,quig_cmplte1dx
		jr 		nc,quig_cmplte3dx
		;false
		xor 	a
		ret		
		
		
;LIBRARY QUIG.INT.GTE.HL
;************************		
;### CMPLTE -> test HL>=DE
;### Output     HL=1 -> true
;###            HL=0 -> false
.Quig_GTE_HL
		ld		a,h
        xor		d
        jp 		m,quig_cmpgte2
        ex 		de,hl
        sbc 	hl,de
        jr 		nc,quig_cmpgte3
.quig_cmpgte1               ;false
        ld 		hl,0
        ret
.quig_cmpgte2 
		bit 	7,d
        jr 		nz,quig_cmpgte1
.quig_cmpgte3              ;true
        ld 		hl,1
        ret
.Quig_GT_HL
		ld 		a,h
        xor 	d
        jp 		m,quig_cmpgte2
        sbc 	hl,de
        jr 		c,quig_cmpgte3
        ;false
        ld 		hl,0
        ret	
.Quig_GTE_HL_Direct
		ld		a,h
        xor		d
        jp 		m,quig_cmpgte2dx
        ex 		de,hl
        sbc 	hl,de
        jr 		nc,quig_cmpgte3dx
.quig_cmpgte1dx               ;false
        xor		a
        ret
.quig_cmpgte2dx 
		bit 	7,d
        jr 		nz,quig_cmpgte1dx
.quig_cmpgte3dx              ;true
        ld 		a,1
		or		a
        ret
.Quig_GT_HL_Direct
		ld 		a,h
        xor 	d
        jp 		m,quig_cmpgte2dx
        sbc 	hl,de
        jr 		c,quig_cmpgte3dx
        ;false
        xor 	a
        ret	

;LIBRARY QUIG.DRIVE.GETINFO
;************************
;IN HL
.Quig_Drive_GetFreeSpace
		ld		a,(hl)
		ld		c,1
		inclib	SYFILE.DIRINF
		call	SyFile_DirInf
		jr		c,Quig_Drive_GetInfoError
		ld		(Quig_Drive_Info_FreeSpace),de
		ld		(Quig_Drive_Info_FreeSpace+2),hl
		ld		hl,1
		ret	
.Quig_Drive_GetInfo:
		ld		a,(hl)
		ld		c,0
		inclib	SYFILE.DIRINF
		call	SyFile_DirInf
		jr		c,Quig_Drive_GetInfoError
		ld		(Quig_Drive_Info_Type),a			;Store the Drive Type
		ld		a,b
		ld		(Quig_Drive_Info_Medium),a			;Store the Drive Medium
		ld		a,c
		ld		(Quig_Drive_Info_FileSystem),a		;Store the Drive File Sytem
		ld		a,d
		ld		(Quig_Drive_Info_SectorsPerCluster),a		;Store the sectors per cluster
		ld		(Quig_Drive_Info_Clusters),ix
		ld		(Quig_Drive_Info_Clusters+2),iy
		ld		hl,1
		ret
.Quig_Drive_Medium:
		ld		a,(Quig_Drive_Info_Medium)
		and		%1111111
		ld		l,a
		ld		h,0
		ret
.Quig_Drive_Removable:
		ld		a,(Quig_Drive_Info_Medium)
		ld		hl,0
		bit		7,a
		ret		nz
		inc		l
		ret
		
.Quig_Drive_GetInfoError:
		ld		(Quig_Drive_Info_Error),a
		ld		hl,0
		ret
;Quig_Directory_Read_Size:		
;		ld		hl,Quig_Drive_Info_Clusters
;		ret
.Quig_Drive_Info_Error:					db	0	
.Quig_Drive_Info_Type:					db	0
.Quig_Drive_Info_Medium:				db	0	
.Quig_Drive_Info_FileSystem:			db	0
.Quig_Drive_Info_SectorsPerCluster:		db	0
.Quig_Drive_Info_Clusters:				db	#00,#00,#00,#00
.Quig_Drive_Info_FreeSpace:				db	#00,#00,#00,#00
	
;LIBRARY QUIG.DRIVE.GETLIST
;***************************
.Quig_Drive_GetList:
		ld 		hl,jmp_sysinf
		ld 		e,3
		ld 		ix,(Quig_String_Buffer_Pos)
		rst 	#28                 ;load device config	

		ld		hl,(Quig_String_Buffer_Pos)
		xor 	a
		ld		(Quig_Drive_List_Count),a
		ld		de,Quig_Drive_List
		call	Quig_Drive_GetList_LoopCopy
		call	Quig_Drive_GetList_LoopCopy
		call	Quig_Drive_GetList_LoopCopy
		call	Quig_Drive_GetList_LoopCopy
		call	Quig_Drive_GetList_LoopCopy
		call	Quig_Drive_GetList_LoopCopy
		call	Quig_Drive_GetList_LoopCopy
		call	Quig_Drive_GetList_LoopCopy		
		ret
.Quig_Drive_GetList_LoopCopy:		
		ld		a,(hl)
		cp		0
		jp		z,Quig_Drive_GetListSkip1
		ld		(de),a
		xor		a
		inc		de
		ld		(de),a
		inc		de
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		ld		bc,12
		ldir
		ld		a,(Quig_Drive_List_Count)
		inc		a
		ld		(Quig_Drive_List_Count),a
		inc		de
		inc		de
		ret
.Quig_Drive_GetListSkip1:
		ld		bc,16
		add		hl,bc
		ret
.Quig_Drive_Letter:
		ld		bc,Quig_Drive_List
		jr		Quig_Drive_Name2
.Quig_Drive_Name:
		ld		bc,Quig_Drive_List+2
.Quig_Drive_Name2:		
		add		hl,hl			;*2
		add		hl,hl			;*4
		add		hl,hl			;*8
		add		hl,hl			;*16
		add		hl,bc
		ret

.Quig_Drive_List_Count:	db	0		
.Quig_Drive_List:ds 128		
		

;LIBRARY QUIG.DIRECTORY.READ
;****************************
;INP DE = Address of Directory filter
;INP HL = Attributes
.Quig_Directory_Read:
		ld		a,l
		ld		(Quig_Directory_Attr),a
		ld		hl,Quig_Directory_Path
.Quig_Directory_Read77:			
		ld		a,(de)
		ld		(hl),a
		inc		hl
		inc		de
		and 	a
		jr		nz,Quig_Directory_Read77
		ld		hl,0
		ld		(Quig_Directory_LoadedCount),hl
		ld		(Quig_Directory_LoadedEntry),hl		
		ld		hl,Quig_DRead_Data
		ld		(Quig_Directory_LastAddr),hl

.Quig_Directory_ReadNext:
		ld		hl,(Quig_Directory_LoadedCount)		;How many Left
		ld		a,l
		and		a			
		jr		z,Quig_Directory_ReadNext_Load		;If 0 Then Load More
		;Okay We have data already
		dec		hl									;Reduce count
		ld		(Quig_Directory_LoadedCount),hl
		ld		hl,(Quig_Directory_LastAddr)		;Find start of last data
		ld		de,9
		add		hl,de
.Quig_Directory_ReadNext_FindNext:		
		ld		a,(hl)
		inc		hl
		and		a
		jr		nz,Quig_Directory_ReadNext_FindNext
		ld		(Quig_Directory_LastAddr),hl
		ret

.Quig_Directory_ReadNext_Load:
		;Okay We need to read as we've got no data
		ld		a,(Quig_Directory_Attr)
		db 		#dd:ld l,a							;Copy Attributes into IXL
		ld		iy,(Quig_Directory_LoadedEntry)		;Entry at
		ld		a,(appBnkNum):db #dd:ld h,a			;Copy Bank into A & IXH
		ld		hl,Quig_Directory_Path				;Path Addr
		ld		de,Quig_DRead_Data					;Address of buffer
		ld		bc,512								;Length of Buffer
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_DIRINP
		ld		a,l
		and		a
		jr		nz,Quig_Directory_ReadNext_Load2
.Quig_Directory_ReadNext_Load3:		
		;Okay failed to read any
		ld		hl,-1
		ld		(Quig_Directory_LoadedCount),hl		;Store the amount loaded
		ret
.Quig_Directory_ReadNext_Load2:	
		dec		hl
		ld		(Quig_Directory_LoadedCount),hl		;Store the amount loaded
		inc		hl
		ld		de,(Quig_Directory_LoadedEntry)		;Get Entry Point
		add		hl,de
		ld		(Quig_Directory_LoadedEntry),hl
		ld		hl,Quig_DRead_Data
		ld		(Quig_Directory_LastAddr),hl		
		ret

.Quig_Directory_Read_Entry:
		ld		hl,1
		ld		a,(Quig_Directory_LoadedCount+1)
		cp		0
		ret		z
		dec		hl
		ret
		
.Quig_Directory_Read_Size:		
		ld		hl,(Quig_Directory_LastAddr)
		ret
.Quig_Directory_Read_Name:
		ld		hl,(Quig_Directory_LastAddr)
		ld		de,9
		add		hl,de
		ret
.Quig_Directory_Read_Type:
		ld		hl,(Quig_Directory_LastAddr)
		ld		de,8
		add		hl,de
		ld		a,(hl)
		ld		l,a
		ld		h,0
		ret
		
.Quig_Directory_Read_Date:
		ld		de,6
.Quig_Directory_Read_Date2:		
		ld		hl,(Quig_Directory_LastAddr)
		add		hl,de
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ret
.Quig_Directory_Read_Time:
		ld		de,4
		jr		Quig_Directory_Read_Date2
		
.Quig_Directory_Path: 			ds	128
.Quig_Directory_Attr:			db	0		
.Quig_Directory_LoadedCount:	dw	0
.Quig_Directory_LoadedEntry:	dw	0
.Quig_Directory_LastAddr:		dw	0		
.Quig_DRead_Data:				ds 	512		
		
;LIBRARY QUIG.TIMECODE
.Quig_TimeCode_Read_Sec:
		ld		a,l
		and		%11111
		add		a
		ld		l,a
		ld		h,0
		ret
.Quig_TimeCode_Read_Min:
		inclib	QUIG.SHR5
		call	Quig_Shr5
		ld		a,l
		and		%111111
		ld		l,a
		ld		h,0
		ret	
.Quig_TimeCode_Read_Hour:
		ld		a,h
		rra
		rra
		rra
		and		%11111
		ld		l,a
		ld		h,0
		ret	
;LIBRARY QUIG.DATECODE
.Quig_Datecode_Read_Day:
		ld		a,l
		and		%11111
		ld		l,a
		ld		h,0
		ret
.Quig_Datecode_Read_Month:
		inclib	QUIG.SHR5
		call	Quig_Shr5
		ld		a,l
		and		%1111
		ld		l,a
		ld		h,0
		ret
.Quig_DateCode_Read_Year:
		ld		a,h
		rra
		and		%1111111
		ld		l,a
		ld		h,0
		ld		de,1980
		add		hl,de
		ret
		



;LIBRARY QUIG.TIMECODE
.Quig_Timecode_GetThem:
		ld		c,l
		ld		b,h
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILF2T
		ld		h,0
		ret
.Quig_Timecode_Sec:
		call	Quig_Timecode_GetThem
		ld		l,a
		ret
.Quig_Timecode_Min:
		call	Quig_Timecode_GetThem
		ld		l,b
		ret		
.Quig_Timecode_Hour:
		call	Quig_Timecode_GetThem
		ld		l,c
		ret		
;LIBRARY QUIG.DATECODE
.Quig_Datecode_GetThem:
		ex		de,hl
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILF2T
		ret
.Quig_Datecode_Day:
		ld		a,l
		and		%11111
		ld		l,a
		ld		h,0
		ret
;		call	Quig_Datecode_GetThem
;		ld		l,d
;		ld		h,0
;		ret
.Quig_Datecode_Month:
		
		call	Quig_Datecode_GetThem
		ld		l,e
		ld		h,0
		ret		
.Quig_Datecode_Year:
		call	Quig_Datecode_GetThem
		ret			
		
;LIBRARY QUIG.DIRECTORY.RENAME
;*****************************
;INP HL = Address of Original Directory name
;INP DE = Address of Renamed directory
.Quig_Directory_New
		ld		a,FNC_FIL_DIRNEW
		ex		de,hl
		jr		Quig_Directory_Rename_2	
.Quig_Directory_Move
		ld		a,FNC_FIL_DIRMOV
		jr		Quig_Directory_Rename_2
.Quig_Directory_Delete
		ld		a,FNC_FIL_DIRRMD
		ex		de,hl
		jr		Quig_Directory_Rename_2
.Quig_File_Delete
		ld		a,FNC_FIL_DIRDEL
		ex		de,hl
		jr		Quig_Directory_Rename_2		
.Quig_Directory_Rename
		ld		a,FNC_FIL_DIRREN
.Quig_Directory_Rename_2		
		ld		(Quig_Directory_Ren_1),a
		ld		a,(appBnkNum)
		db		#DD,#67
		ex		de,hl
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
.Quig_Directory_Ren_1		
        db 		FNC_FIL_DIRREN
		jr		c,Quig_Directory_Rename_22
		ld		a,1
.Quig_Directory_Rename_22		
		ld		(Quig_Directory_Error_Byte),a
		inclib 	QUIG.LETSTRING
		jp		Quig_LS_Finish
		

;LIBRARY QUIG.FILE.SELECT.OPEN
;*****************************
		inclib	QUIG.LETSTRING
		inclib	SYSYSTEM.SENDMESSAGE
		inclib	SYSYSTEM.WAITMESSAGE		
.Quig_File_Select_Open
		call	Quig_File_Select_Copy_2_Path_Area
		ld		b,0	
		jr		Quig_File_Select_Save_2	
.Quig_File_Select_Save
		call	Quig_File_Select_Copy_2_Path_Area
		ld		b,64
.Quig_File_Select_Save_2		
		call 	Quig_File_Select_Dialog_Call
		ld		de,(File_Select_Text)
		and		a
		jr		z,Quig_File_Select_Open_Finish_2
		xor		a
		;Failed
		ld		hl,Quig_File_Select_File
		ld		(hl),a
		call	Quig_LetString
		ld		l,a
		ld		h,a
		ret
.Quig_File_Select_Open_Finish_2
		ld		l,a
		ld		h,0
		push	hl		
		ld		hl,Quig_File_Select_File
		call	Quig_LetString
		pop		hl
		ret	
		
.Quig_Directory_Select
		ex		de,hl
		ld		hl,Quig_Directory_Ext
		call	Quig_File_Select_Copy_2_Path_Area
		ld		b,128		
		call 	Quig_File_Select_Dialog_Call
		;ld		de,(Directory_Select_Text)
		ld		de,(File_Select_Text)		
		and		a
		jr		z,Quig_Directory_Select_Finish_2
		xor		a
		;Failed
		ld		hl,Quig_File_Select_File
		ld		(hl),a
		call	Quig_LetString
		ld		l,a
		ld		h,a
		ret
.Quig_Directory_Select_Finish_2
		ld		l,a
		ld		h,0
		push	hl		
		ld		hl,Quig_File_Select_File
		call	Quig_LetString
		pop		hl
		ret	
.Quig_Directory_Ext:
		db		"*",0
	
.Quig_File_Select_Copy_2_Path_Area
		push	de
		ld		de,Quig_File_Select_Ext
.Quig_File_Select_1
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		and		a
		jr		nz,Quig_File_Select_1
		;ld		de,Quig_File_Select_Ext+4
		;xor		a
		;ld		(de),a
		;inc		de
		ld		de,Quig_File_Select_File
		pop		hl
.Quig_File_Select_2	
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		and		a
		jr		nz,Quig_File_Select_2
		ret
.Quig_File_Select_Dialog_Call
		;INP 	B=0,64 or 128 for open,save,directory 
		ld		hl,Quig_File_Select_Ext
		ld		a,(AppBnkNum)
		and		%1111
		add		b
		ld		c,0
		ld		ix,160
		ld		iy,2048
		ld		de,Form1_Begin
		call	Quig_File_Select_Open_2
		ret
		
		
.Quig_File_Select_Open_2
;******************************************************************************
;*** Name           Dialogue_FileSelector_Command
;*** Input          HL = File mask, path and name address (#C000-#FFFF)
;***                     00  3B  File extension filter (e.g. "*  ")
;***                     03  1B  0
;***                     04 256B path and filename
;***                A  = File mask, path and name ram bank (0-8)
;***                C  = Attribute filter
;***                     Bit0 = 1 -> don't show read only files
;***                     Bit1 = 1 -> don't show hidden files
;***                     Bit2 = 1 -> don't show system files
;***                     Bit3 = 1 -> don't show volume ID entries
;***                     Bit4 = 1 -> don't show directories
;***                     Bit5 = 1 -> don't show archive files
;***                IX = Maximum number of directory entries
;***                IY = Maximum size of directory data buffer
;***                DE = Data record of the caller window; the file selector
;***                     window will be a super window of it, during its open)
;*** Output         A  = Success status
;***                     0 -> The user choosed a file and closed the dialogue
;***                          with "OK". The complete file path and name can be
;***                          found in the filepath buffer of the application.
;***                     1 -> The user aborted the file selection. The content
;***                          of the applications filepath buffer is unchanged.
;***                     2 -> The file selection dialogue is currently used by
;***                          another application. It can only be opened once
;***                          at the same time. The user should close the
;***                          dialogue first before it can be opened again by
;***                          the application.
;***                     3 -> Memory full. There was not enough memory
;***                          available for the directory buffer and/or the
;***                          list data structure.
;***                     4 -> No window available. The desktop manager couldn't
;***                          open a new window for the dialogue, as the
;***                          maximum number of windows (32) has already been
;***                          reached.
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Opens the file selection dialogue. In this dialogue the user
;***                can move through the directory structure, change the drive and
;***                search and select a file.
;***                If you specify a path, the dialogue will start directly in the
;***                directory. If you append a filename, too, it will be used as
;***                the preselected file.
;***                You can filter the entries of the directory by attributes and
;***                filename extension. We recommend always to set Bit3 of the
;***                attribute filter byte.
;***                The File mask/path/name string (260 bytes) must always be
;***                placed in the transfer ram area (#C000-#FFFF). For more
;***                information about this memory types see the "applications"
;***                chapter.
;***                Please note, that the system will reserve memory to store the
;***                listed directory entries and the data structure of the list.
;***                With IX and IY you can choose, how much memory should be used.
;***                We recommend to set the number of entries between 100 and 200
;***                (Amsdos supports a maximum amount of 64 entries) and to set the
;***                data buffer between 5000 and 10000.
;******************************************************************************
        ld 		(SySSOpW2),de
        push 	iy
        ld 		iy,AppMsgB
        ld 		(iy+6),a
        ld 		(iy+7),c
        ld 		(iy+8),l
        ld 		(iy+9),h
        db 		#dd:ld a,l
        ld 		(iy+10),a
        db 		#dd:ld a,h
        ld 		(iy+11),a
        pop 	de
        ld 		(iy+12),e
        ld 		(iy+13),d
        ld 		c,MSC_SYS_SELOPN
        call 	SySystem_SendMessage
.SySSOp12: 
		call 	SySystem_WaitMessage
        cp 		MSR_SYS_SELOPN
        jr 		nz,SySSOp12
        ld 		a,(iy+1)
        cp 		-1
        ret 	nz
        ld 		ix,(SySSOpW2)
        ld 		a,(iy+2)
        ld 		(ix+51),a
        jr 		SySSOp12
.SySSOpW2:
		dw 0

		
;LIBRARY QUIG.KEY.TEST
;**********************
.Quig_Key_Test
		ld		e,l
		ld		hl,#8145
		rst		#28
		ld		l,e
		ld		h,0
		ret
;LIBRARY QUIG.KEY.CAPS
;**********************
.Quig_Key_Caps
		ld		hl,#8148
		rst		#28
		ld		l,d
		ld		h,0
		ret		
;LIBRARY QUIG.KEY.SHIFT
;**********************
.Quig_Key_Shift
		ld		hl,#8148
		rst		#28
		ld		a,e
		and		%1
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.KEY.CONTROL
;**********************
.Quig_Key_Control
		ld		hl,#8148
		rst		#28
		ld		a,e
		rra
		and		%1
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.KEY.ALT
;**********************
.Quig_Key_Alt
		ld		hl,#8148
		rst		#28
		ld		a,e
		rra
		rra
		and		%1
		ld		l,a
		ld		h,0
		ret			
		
;LIBRARY QUIG.CLIPBOARD.TYPE
;*****************************
.Quig_Clipboard_Type
		rst		#20
		dw		#8154
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.CLIPBOARD.LEN
;*****************************
.Quig_Clipboard_Len
		rst		#20
		dw		#8154
		ld		l,c
		ld		h,b
		ret		
;LIBRARY QUIG.TIME.SECOND.GET
;************************
.Quig_Time_Second_Get
		rst 	#20
		dw		#810c
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.TIME.MINUTE.GET
;************************
.Quig_Time_Minute_Get
		rst 	#20
		dw		#810c
		ld		l,b
		ld		h,0
		ret
;LIBRARY QUIG.TIME.HOUR.GET
;************************
.Quig_Time_Hour_Get
		rst 	#20
		dw		#810c
		ld		l,c
		ld		h,0
		ret	
;LIBRARY QUIG.TIME.DAY.GET
;************************
.Quig_Time_Day_Get
		rst 	#20
		dw		#810c
		ld		l,d
		ld		h,0
		ret
;LIBRARY QUIG.TIME.MONTH.GET
;************************
.Quig_Time_Month_Get
		rst 	#20
		dw		#810c
		ld		l,e
		ld		h,0
		ret
;LIBRARY QUIG.TIME.YEAR.GET
;************************
.Quig_Time_Year_Get
		rst 	#20
		dw		#810c
		ret	
;LIBRARY QUIG.SCREEN.MODE.SET
;HL = Mode to Set
.Quig_Screen_Mode_Set:
		
		
;LIBRARY QUIG.SCREEN.MODE.GET
;************************
.Quig_Screen_Mode_Get:
		ld		hl,#8139
		rst		#28
		ld		l,e
		ld		h,0
		ret
;LIBRARY QUIG.SCREEN.COLOUR.GET
;************************
.Quig_Screen_Colour_Get
		ld		hl,#8139
		rst		#28
		ld		l,d
		ld		h,0
		ret	
;LIBRARY QUIG.SCREEN.RESX.GET
;************************
.Quig_Screen_ResX_Get
		ld		hl,#8139
		rst		#28
		push	ix
		pop		hl
		ret
;LIBRARY QUIG.SCREEN.RESY.GET
;************************
.Quig_Screen_ResY_Get
		ld		hl,#8139
		rst		#28
		push	iy
		pop		hl
		ret			
;LIBRARY QUIG.MACHINE.GET
;****************************
.Quig_Machine_Get	
		ld		a,(Quig_Machine_Type)
		ld		l,a
		ld		h,0
		ret
		
;LIBRARY QUIG.NEG.INT
;********************
.Quig_Neg_Int
		ld		a,l
		xor		255
		ld		l,a
		ld		a,h
		xor		255
		ld		h,a
		inc		hl
		ret
;LIBRARY QUIG.SGN.INT
;********************
.Quig_Sgn_Int:
		ld		a,%10000000
		and		h
		jr		z,Quig_Sgn_Int_2
		ld		hl,-1
		ret
.Quig_Sgn_Int_2		
		ld		hl,1
		ret
;LIBRARY QUIG.DISTANCE.INT
;*************************
;Input HL = value 1 DE = value 2
;Out HL = distance between 2  
.Quig_Distance_Int
		or		a
		sbc		hl,de
		bit 	7,h
		ret 	z
		xor 	a
		sub 	l
		ld 		l,a
		sbc 	a,a
		sub 	h
		ld h,a	
		ret	
;LIBRARY QUIG.COLLISION.INT
;**************************
;Input (Radius,x1,y1,x2,y2)
.Quig_Collision_Int:
.coldet  pop iy              ;4  iy=return
        pop bc              ;3  bc=y1
        or a                ;1
        sbc hl,bc           ;4  hl=y2-y1
        pop bc              ;3  bc=x1
        pop ix              ;4  ix=radius
        jr nc,coldet2       ;2
        ld a,l              ;1
        neg                 ;2
        ld l,a              ;1  l=abs(y2-y1)
.coldet2 inc h               ;1
        jr z,coldet3        ;2
        dec h               ;1
        jr nz,coldet0       ;2  abs(y2-y1)>255 -> false
.coldet3 ex de,hl            ;1  e=abs(y2-y1)
        or a                ;1
        sbc hl,bc           ;4  hl=x2-x1
        ld a,l              ;1
        jr nc,coldet4       ;2
        neg                 ;2  a=abs(x2-x1)
.coldet4 inc h               ;1
        jr z,coldet5        ;2
        dec h               ;1
        jr nz,coldet0       ;2  abs(x2-x1)>255 -> false
.coldet5 add e               ;1  a=abs(x2-x1)+abs(y2-y1)
        jr c,coldet0        ;2  distance>255 -> false
        jr z,coldet1        ;2  distance=0 -> true
        dec a               ;1
        ;cp ixl              ;2
		db 	#dd,#bd
		
        jr nc,coldet0       ;2  (distance-1)>=radius -> false
.coldet1 ld hl,1             ;3  collision true
        jp (iy)             ;2
.coldet0 ld hl,0             ;   collision false
        jp (iy)             ;
		
;LIBRARY QUIG.ABS.INT
;****************
.Quig_Abs_Int
		bit 	7,h
		ret 	z
		xor 	a
		sub 	l
		ld 		l,a
		sbc 	a,a
		sub 	h
		ld h,a	
		ret	

;LIBRARY QUIG.STR.CINT	
;***********************
.Quig_Str_Cint
		push	hl		;Store String Start position
		xor		a
		ld 		c,a
		ld 		b,a
		cpir
		pop		hl
		call	CLCR16
		jr		nc,Quig_Str_Cint_2
		ld		hl,0
.Quig_Str_Cint_2		
		ret

;### CLCR16 -> Converts string into 16bit value
;### Input      HL=string, B=length
;### Output     HL=value, CF=1 -> invalid format
;### Destroyed  AF,BC,DE,IXL
.clcr16s:
		db 		0        ;sign flag (0=pos, 1=neg)

.clcr16:
		inc 	b
		dec 	b
		scf
		ret 	z
		ld		a,(hl)           ;skip whitespace
		cp		" "
		jr		z,clcr165
        cp		9
		jr		nz,clcr166
.clcr165:
		inc 	hl
        dec 	b
		jr 		clcr16
.clcr166:
		cp 		"-"              ;consider sign
        ld 		a,0
        jr 		nz,clcr161
        dec 	b
        scf
        ret 	z
        inc 	a
        inc 	hl
.clcr161: 
		ld 		(clcr16s),a
        ld 		a,(hl)           ;shouldn't start with invalid digit
        call 	clcr164
        ret 	c
        ex 		de,hl
        ld 		hl,0
        db 		#dd:ld l,b
.clcr162: 
		ld 		a,(de)           ;convert ascii to value
        call 	clcr164
        jr 		c,clcr163
        add 	hl,hl
        ret 	c
        ld 		c,l
        ld 		b,h
        add 	hl,hl
        ret 	c
        add 	hl,hl
        ret 	c
        add 	hl,bc
        ret 	c
        add 	l
        ld 		l,a
        ld 		a,0
        adc 	h
        ret 	c
        ld 		h,a
        inc 	de
        db 		#dd:dec l
        jr 		nz,clcr162
        ld 		a,l
        or 		h
        ret 	z
.clcr163:
		ld 		a,(clcr16s)      ;convert to negative, if signed
        or 		a
        ret		z
        ld 		a,l
        cpl
        ld 		l,a
        ld 		a,h
        cpl
        ld 		h,a
        inc 	hl
        bit 	7,h
        ret 	nz
        scf
        ret
.clcr164:
		sub 	"0"             ;convert one ASCII char to byte
        ret 	c
        cp 		10
        ccf
        ret
		
;LIBRARY QUIG.FILE.OPEN
;**********************
.Quig_File_NewBinary:
		ld		a,2
		jr		Quig_File_New1
.Quig_File_New:
		ld		a,1
.Quig_File_New1		
		ld		(Quig_File_Open_x+1),a
		push	de
		ld		a,(appBnkNum)
		db		#DD,#67
		xor		a
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILNEW
		jr		Quig_File_Open_2
.Quig_File_OpenBinary:
		ld		a,2
		jr		Quig_File_Open1		
.Quig_File_Open:
		ld		a,1
.Quig_File_Open1:			
		ld		(Quig_File_Open_x+1),a
		push	de
		ld		a,(appBnkNum)
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN	
.Quig_File_Open_2:		
		pop		de
		inclib	QUIG.FILE.FAIL
		jp		c,Quig_File_Fail_DE		
		ld		(de),a			;File Handle
		inc		de
.Quig_File_Open_x
		ld		a,1				;Set Status as 1 or 2
		ld		(de),a
		xor		a				;A=0 
		inc		de
		ld		(de),a			;EOF=0
		inc		de
		inc		a				;A=1
		ld		(de),a			;Error=1... 1 Is Okay
		ret
		
;LIBRARY QUIG.FILE.FAIL
;**********************
;HL=Start of File record	
.Quig_File_Fail_DE:
		ex		de,hl
.Quig_File_Fail_HL:		
		inc		hl
		inc		hl
		inc		hl
		ld		(hl),a			;Store Error number
		ret

;LIBRARY QUIG.FILE.WRITESTRING
;*****************************
;IN HL:Address of String
;   DE:Address of File Handle
.Quig_File_WriteString
		push	de
		ld		de,(Quig_String_Buffer_Pos)
		ld		bc,1
.Quig_File_WriteString_1
		ld		a,(hl)
		cp		13
		jr		nz,Quig_File_Not_CR
		ld		a,1					;Fake a 13 as an 1
.Quig_File_Not_CR
		cp		10
		jr		nz,Quig_File_Not_CR2
		ld		a,2
.Quig_File_Not_CR2
		and		a
		jr		z,Quig_File_WriteString_2
.Quig_File_WriteString_3		
		ld		(de),a
		inc		hl
		inc		de
		inc		bc
		jr		Quig_File_WriteString_1
.Quig_File_WriteString_2		
		ld		a,13
		ld		(de),a
		inc		de
		ld		a,10
		ld		(de),a		
		ld		hl,(Quig_String_Buffer_Pos)
		pop		de
		ld		a,(de)
		ld		d,a
		ld		a,(appBnkNum)
		ld		e,a
		ld		a,d
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOUT
		INCLIB 	QUIG.STRING.STACK.CLEAR
		call	Quig_String_Stack_Clear				
		ret

		

;LIBRARY QUIG.GET.EOF
;*********************
.Quig_Get_Eof:
		inc		hl
		inc		hl
		ld		a,(hl)
		cp		0
		jr		nz,Quig_Get_Eof_4
		dec		hl
		dec		hl
		push	hl
		inclib 	QUIG.FILE.READINT
		call 	Quig_File_ReadByte
		jr		nz,Quig_Get_Eof_3
		ld		a,l
		cp		26
		jr		nz,Quig_Get_Eof_2
.Quig_Get_Eof_3		
		pop		hl
		inc		hl
		inc		hl
		ld		a,1
		ld		(hl),a
.Quig_Get_Eof_4		
		ld		l,a
		ld		h,0
		ret
.Quig_Get_Eof_2
		pop		hl
		ld		a,(hl)
		ld		c,1
		ld		iy,65535
		ld		ix,-1
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILPOI
		ld		hl,0
		ret	
		
;LIBRARY QUIG.FILE.CLOSE
;************************
.Quig_File_Close
		inc		hl
		ld		a,(hl)
		dec		hl
		cp		2
		jr		z,Quig_File_Close1
		push	hl
		ex		de,hl
		ld		hl,26			;69(e)*256+26   So thats 26EOF+"e"
		inclib 	QUIG.FILE.WRITEINT
		call	Quig_File_WriteByte
		pop		hl
.Quig_File_Close1		
		ld		e,(hl)
		xor		a
		ld		(hl),a
		inc		hl
		ld		(hl),a
		ld		a,e
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILCLO		
		ret
;LIBRARY QUIG.FILE.READSTRING
;*****************************
.Quig_File_RS_1:	dw	0
.Quig_File_RS_2:	db	0
.Quig_File_RS_3:	dw	0
.Quig_File_ReadString:
		ld		a,(hl)		;The File handle
		ld		(Quig_File_RS_2),a
		ld		(Quig_File_RS_3),hl
		ld		hl,(Quig_String_Buffer_Pos) ;Place to read too
		ld		(Quig_SB_Pos),hl		
.Quig_File_Readstring_2:
		ld		a,(appBnkNum)
		ld		e,a			;The Banks to place into
		ld		a,(Quig_File_RS_2)		;File handle
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILLIN		
		jr		z,Quig_File_ReadString_EOF_Set
		ld		a,b
		cp		0
		jr		nz,Quig_File_Readstring_3
		;Keep loading more
		ld		hl,(Quig_SB_Pos)
		add		hl,bc
		ld		(Quig_SB_Pos),hl
		jr		Quig_File_Readstring_2

.Quig_File_Readstring_3		
		ld		hl,(Quig_String_Buffer_Pos)
.Quig_File_ReadString_6		
		ld		a,(hl)
		cp		1				;Fake 13
		jr		z,Quig_File_ReadString_CR
		cp		2				;Fake 10
		jr		z,Quig_File_ReadString_CR2		
		cp		0
		jr		z,Quig_File_ReadString_4
.Quig_File_ReadString_5		
		inc		hl
		jr		Quig_File_ReadString_6
.Quig_File_Readstring_4:		
		ld		de,(Quig_String_Buffer_Pos)
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
		ret
.Quig_File_ReadString_EOF_Set:
		ld		hl,(Quig_File_RS_3)
		inc		hl
		inc		hl
		ld		a,1
		ld		(hl),a			;Set EOF Flag
		jr		Quig_File_Readstring_3
.Quig_File_ReadString_CR:
		ld		a,13
		ld		(hl),a
		jr		Quig_File_ReadString_5
.Quig_File_ReadString_CR2:
		ld		a,10
		ld		(hl),a
		jr		Quig_File_ReadString_5	
.Quig_SB_Pos:dw	0		

;LIBRARY QUIG.FILE.READINT
;*****************************
.Quig_File_RI:  dw	0,0,0
.Quig_File_ReadInt:
		ld		bc,2
.Quig_File_ReadInt_2:
		ld		a,(appBnKNum)
		ld		e,a
		ld		a,(hl)
		ld		hl,Quig_File_RI
		call 	SySystem_CallFunction
	    db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP
		ld		hl,(Quig_File_RI)
		ret
.Quig_File_ReadByte:
		ld		bc,1
		call	Quig_File_ReadInt_2
		ld		h,0
		ret

;LIBRARY QUIG.FILE.WRITEMEMORY
;*****************************
;STACK =File Handle
;STACK =Bank
;DE    =Start
;HL    =Length
.Quig_File_WriteMemory:
		pop		iy
		ld		c,l				;bc=length
		ld		b,h
		ex		de,hl			;hl=start
		pop		de				;Pop Bank
		ld		a,e				;a=bank	
		pop		de				;Get File handle
		push	af
		ld		a,(de)			;a=filehandle
		ld		(Quig_File_WMem),de
		pop		de
		ld		e,d
		push 	iy
		call 	SySystem_CallFunction
	    db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOUT
		
		ret		nc
		ld		hl,(Quig_File_WMem)
		inclib	QUIG.FILE.FAIL
		jp		Quig_File_Fail_HL		
.Quig_File_WMem:	dw	0		
		
		
;LIBRARY QUIG.FILE.READMEMORY
;*****************************
;STACK =File Handle
;STACK =Bank
;DE    =Start
;HL    =Length
.Quig_File_ReadMemory:
		pop		iy
		ld		c,l				;bc=length
		ld		b,h
		ex		de,hl			;hl=start
		pop		de				;Pop Bank
		ld		a,e				;a=bank
		pop		de				;Get File handle
		push	af
		ld		a,(de)			;a=filehandle
		pop		de
		ld		e,d	
		push 	iy
		call 	SySystem_CallFunction
	    db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP
		ld		l,c
		ld		h,b
		ret
		
;LIBRARY QUIG.FILE.WRITEINT
;*****************************
;DE=File_Handle
;HL=Int to Write	
.Quig_File_WriteByte:
		ld		bc,1
		jr		Quig_File_WriteInt_2
;DE=File_Handle
;HL=Int to Write	
.Quig_File_WriteInt:
		ld		bc,2
.Quig_File_WriteInt_2:		
		ld		(Quig_File_WI),hl
		ld		a,(appBnKNum)
		ld		l,a
		ld		a,(de)
		ld		e,l
		ld		hl,Quig_File_WI	
		call 	SySystem_CallFunction
	    db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOUT
		ret
.Quig_File_WI:	dw	0




;LIBRARY QUIG.FILE.SIZE
;**********************
;HL=Filename
.Quig_File_Size:
		ld		a,(appBnkNum)
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN	
		jr		c,Quig_File_Size_Fail		
		ld		(Quig_File_Size2+1),a
		;Get Length
		ld		ix,0					;Move IXIY relative 0
		ld		iy,0
		ld		c,2						;Where file is
		call 	SySystem_CallFunction
	    db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILPOI
		ld		(Quig_File_Size_Long),ix
		ld		(Quig_File_Size_Long+2),iy
.Quig_File_Size2:		
		ld		a,0
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO			
		ld		hl,Quig_File_Size_Long
		ret
.Quig_File_Size_Fail:
		ld		hl,0
		ret
.Quig_File_Size_Long:	dw 0,0


;LIBRARY QUIG.EXECUTE
;********************
;HL = Filepath/name
.Quig_Execute:
		inclib	SYSYSTEM.PRGRUN
		ld		a,(AppBnkNum)
		set		7,a
		call	SySystem_PRGRUN
		ld		l,a
		ld		h,0
		ret	

;LIBRARY QUIG.CREATEBANK
;************************
		push	de					;Store DE
		push	hl
		inclib	QUIG.APP.MEMSLOT.AVAILABLE							
		call	Quig_Mem_Slot_Available
		jr		nz,Quig_CreateBank_Fail
		pop		bc
		push 	bc			;Length
		push	hl			;Table Position
		Xor		a
		ld		e,a
		rst		#20
		dw		#8118		;Out HL is placement
		jr		c,Quig_CreateBank_Fail
		;Bank created - Now store
		pop		de			;Get Table Position
		ex		hl,de		;HL=Table position DE=Ram Place
		push	hl
		ld		c,172
		ld		(hl),c
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		pop		bc
		ld		(hl),c		
		inc		hl
		ld		(hl),b
		pop		hl			;Get Table position back
		pop 	de			;Whatever was in DE prior to routine
		ret
.Quig_CreateBank_Fail
		ld		hl,0
		pop		de
		ret
		


		


;LIBRARY QUIG.SHEETFREE		
;**********************
.Quig_SheetFree:
		ld		a,(hl)
		cp		1
		ret		nz
		xor		a				;Clean the Status
		ld		(hl),a
		ld		c,(hl)
		inc		hl
		inc		hl
		inc		hl
		ld		c,(hl)
		ld		(hl),a
		inc		hl
		ld		b,(hl)
		ld		(hl),a
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,d
		ld		a,e
		rst 	#20:dw 	#811B
		ret

;LIBRARY QUIG.SHEETFREE		
;**********************
.Quig_SheetFree:
		ld		a,(hl)
		cp		1
		ret		nz
		xor		a				;Clean the Status
		ld		(hl),a
		ld		c,(hl)
		inc		hl
		inc		hl
		inc		hl
		ld		c,(hl)
		ld		(hl),a
		inc		hl
		ld		b,(hl)
		ld		(hl),a
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,d
		ld		a,e
		rst 	#20:dw 	#811B
		ret
		

;LIBRARY QUIG.SHEETLOAD
;**********************
.Quig_SheetLoad:
		inclib 	QUIG.SHEETFREE
		ld		(Quig_SheetLoad_Where),de		
		;**** Need to place FreeMemory if Necessary
		push	hl
		ex		de,hl
		call	Quig_SheetFree
		
		pop		hl
		ld		a,(appBnkNum)
		db		#DD,#67
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILOPN		
		ld		de,(Quig_SheetLoad_Where)
		jp		c,Quig_SheetLoad_Fail_1
		ld		(Quig_SheetLoad_Handle),a
		;**** Load the first 3 Bytes of file -  Get File type & Size
		ld		a,(appBnkNum)
		ld		e,a
		ld		hl,Quig_SheetLoad_Type
		ld		bc,6
		ld		a,(Quig_SheetLoad_Handle)
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILINP
		ld		a,(Quig_SheetLoad_Type)
		and #fe                                     ;*MOD*
		cp		178                         		;*MOD*
		jp		nz,Quig_SheetLoad_Fail_2		
		;**** Find a Space
		ld		bc,(Quig_Sheetload_Size)
;**** Set colour depth and modify size)		
		bit		7,b
		jr		z,Quig_SheetLoad_F2
		ld		a,1
		jr		Quig_SheetLoad_F3
.Quig_SheetLoad_F2
		xor		a
.Quig_SheetLoad_F3
		ld		(Quig_SheetLoad_CD),a
		res		7,b
		ld		(Quig_Sheetload_Size),bc
;***************
		Xor		a					;A = 0 - Look in any RamBank
		ld		e,1					;E = 1 - Look only in Data Areas
		rst 	#20:dw #8118
		jp		c,Quig_SheetLoad_Fail_3
		ld		(Quig_SheetLoad_Bank),a
		ld		(Quig_SheetLoad_Addr),hl

		;**** Load rest of file Bytes into Bank
		ld		e,a
		ld		bc,(Quig_Sheetload_Size)
		ld		a,(Quig_SheetLoad_Type)      ;*MOD*
		rra                                          ;*MOD*
		ccf                                          ;*MOD*
		ld		a,(Quig_SheetLoad_Handle)
        call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCPR                       ;*MOD*
		jp		c,Quig_SheetLoad_Fail_1
		;**** Successfully loaded the file into bank
		
		ld		a,(Quig_SheetLoad_Handle)
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_FILCLO		
		ld		hl,(Quig_SheetLoad_Addr)
		
		ld		(Quig_SheetLoad_Fill+1),hl
		inc		hl
		inc		hl
		inc		hl
		ld		a,(Quig_SheetLoad_Tiles)			;Number of Tiles
		ld		b,a
.Quig_SheetLoad_Loop
		push	bc
		ld		a,(Quig_SheetLoad_Bank)
		rst		#20:dw	#8124
		ex		de,hl
.Quig_SheetLoad_Fill
		ld		hl,0
		add		hl,bc
		ld		c,l
		ld		b,h
		ex		de,hl
		ld		e,c
		ld		d,b
		dec		de
		dec		hl
		dec		hl
		rst 	#20:dw #8127						;Write word to bank
		ld		c,e
		ld		b,d
		rst 	#20:dw #8127						;Write word to bank
		ld		bc,5
		add		hl,bc
		pop		bc
		djnz	Quig_SheetLoad_Loop
	
		ld		hl,Quig_SheetLoad_Status
		ld		de,(Quig_SheetLoad_Where)
		ld		bc,9
		ldir
		ret
	
.Quig_SheetLoad_Where:	dw		0
.Quig_SheetLoad_Handle:	db		0
.Quig_SheetLoad_Type:	db		0			;Need to be 179 (uncompressed) or 178 (compressed) ;*MOD*
.Quig_SheetLoad_Status:	db		0
.Quig_SheetLoad_SheetNo:db		0
.Quig_SheetLoad_Tiles:	db		0
.Quig_Sheetload_Size:	dw		0
.Quig_SheetLoad_Bank:	db		0
.Quig_SheetLoad_Addr:	dw		0
.Quig_SheetLoad_CD:		db		0

.Quig_SheetLoad_Fail_1:
;File not found or error
		ld		a,0
		jr		Quig_SheetLoad_Fail
.Quig_SheetLoad_Fail_2:
;Not a Sheet file
		ld		a,100		
		jr		Quig_SheetLoad_Fail
.Quig_SheetLoad_Fail_3:
;Not enough Data Ram to load this file
		ld		a,101
.Quig_SheetLoad_Fail:
		ld		hl,(Quig_SheetLoad_Where)
		ld		(hl),a
		ret

	
;LIBRARY QUIG.MAX.INT
;*********************
; HL = Second Value
; DE = First Value
.Quig_Min_Int:
		ld		(Quig_Max_HL),de
		ld		(Quig_Max_DE),hl
		ex		de,hl
		jr		Quig_Max_Int2
.Quig_Max_Int:
		ld		(Quig_Max_HL),de
		ld		(Quig_Max_DE),hl
.Quig_Max_Int2:		
		ld 		a,h
        xor		d
		jp 		m,quig_Max_te2
		sbc 	hl,de
		jr 		z,quig_Max_te1
		jr 		nc,quig_Max_te3
		;false
		ld 		hl,(Quig_Max_HL)
		ret
.Quig_Max_te1                 ;false
		ld 		hl,(Quig_Max_HL)
		ret
.Quig_Max_te2 
		bit 	7,d
		jr 		z,Quig_Max_te1
.Quig_Max_te3                ;true
        ld 		hl,(Quig_Max_DE)
        ret
.Quig_Max_HL:dw 0
.Quig_Max_DE:dw	0		
		

;LIBRARY QUIG.MEMORY.FREE
;************************
.Quig_Memory_Free:
		ld		a,(hl)			;Read status
		and		a
		ret		z				;Empty so return
		xor		a				;Make 0
		ld		(hl),a			;Clear Status
		inc		hl			
		ld		c,(hl)			;bc=length to empty
		ld		(hl),a			;clear on way
		inc		hl
		ld		b,(hl)
		ld		(hl),a		
		inc		hl				
		ld		a,(hl)			;Bank
		inc		hl	
		ld		e,(hl)			;hl=Address
		inc		hl
		ld		h,(hl)
		ld		l,e
		rst 	#20:dw #811B
		ret


;LIBRARY QUIG.MEMORY.CREATE
;**************************
;HL=Type
;DE=Size to Create
;ST=Address of Memory container Status
.Quig_Memory_Create:
		inclib	QUIG.MEMORY.FREE
		pop		iy
		ld		a,l
		ld		(Quig_Memory_Create_2_x+1),a
		ld		(Quig_Memory_C_Size),de
		pop		hl
		ld		(Quig_Memory_C_Addr),hl
		ld		a,(hl)
		and		a
		jr		z,Quig_Memory_Create_2
		call	Quig_Memory_Free
.Quig_Memory_Create_2
		ld		bc,(Quig_Memory_C_Size)
		xor		a
.Quig_Memory_Create_2_x		
		ld		e,0
		rst 	#20:dw #8118
		jp		c,Quig_Memory_Create_2_x2
		ex		de,hl				;DE=Address A=Bank
		ld		hl,(Quig_Memory_C_Addr)
		ld		c,1					;Set Bank to 1
		ld		(hl),c
		inc		hl
		ld		bc,(Quig_Memory_C_Size)		;Set the Size
		ld		(hl),c
		inc		hl
		ld		(hl),b
		inc		hl
		ld		(hl),a				;Set Bank
		inc		hl
		ld		(hl),e				;Set Address
		inc		hl
		ld		(hl),d
.Quig_Memory_Create_2_x2:			
		jp		(iy)
.Quig_Memory_C_Size:	dw 	0
.Quig_Memory_C_Addr:	dw	0


;LIBRARY QUIG.MEMORY.INT.GET
;***************************
;DE = Memory Addr
;HL = Position
.Quig_Memory_Int_Get:
		ex		de,hl			;Swap them 
		ld		a,(hl)			;Get Bank
		inc		hl			
		ld		c,(hl)			;Get Lower Addr
		inc		hl			
		ld		h,(hl)			;Get Upper Address
		ld		l,c
		add		hl,de			;Add Pos+Address
		rst 	#20:dw #8124
		ld		l,c
		ld		h,b
		ret
		
;LIBRARY QUIG.MEMORY.BYTE.GET
;***************************
;DE = Memory Addr
;HL = Position
.Quig_Memory_Byte_Get:
		ex		de,hl			;Swap them 
		ld		a,(hl)			;Get Bank
		inc		hl			
		ld		c,(hl)			;Get Lower Addr
		inc		hl			
		ld		h,(hl)			;Get Upper Address
		ld		l,c
		add		hl,de			;Add Pos+Address
		rst 	#20:dw #812A
		ld		l,b
		ld		h,0
		ret		

;LIBRARY QUIG.MEMORY.STRING.GET
;******************************
;ST1 = Memory
;DE = Position
;HL = Length
.Quig_Memory_String_Get:
		pop		iy									;Return Address
		ld		(Quig_Memory_String_Get_Len),hl		;Store Length
		pop		hl
		ld		a,(hl)								;Get Bank
		and		%1111
		ld		b,a									;Bank Into Low		
		inc		hl
		ld		(Quig_Memory_SS_2+1),hl
.Quig_Memory_SS_2		
		ld		hl,(0)
		add		hl,de								;Offset+Position
		ld		a,(AppBnkNum)
		rla
		rla
		rla
		rla
		and		%11110000
		or		b
		ld		de,(Quig_String_Buffer_Pos)
		ld		bc,(Quig_Memory_String_Get_Len)
		rst 	#20:dw #8130
		ld		hl,(Quig_String_Buffer_Pos)
		ld		bc,(Quig_Memory_String_Get_Len)
		add		hl,bc
		xor		a
		ld		(hl),a
		inc		hl
		ex		de,hl
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		jp		(iy)
		
.Quig_Memory_String_Get_Len:	dw	0

;LIBRARY QUIG.MEMORY.STRING.SET
;***************************
;ST1 = Memory
;DE = Position
;HL = String
.Quig_Memory_String_Set:
		pop		iy			;Return Address
		INCLIB 	QUIG.LEN
		ld		(Quig_Memory_String_Source_Addr),hl
		push	de
		call	Quig_Len
		pop		de
		inc		hl
		ld		(Quig_Memory_String_Len),hl
		pop		hl			;Get Memory Pos
		ld		a,(hl)		;Destination Bank
		and		%1111		;Mask 15
		add		a			;*16
		add		a
		add		a
		add		a		
		inc		hl
		ld		(Quig_Memory_String_Set_2+1),hl
.Quig_Memory_String_Set_2		
		ld		hl,(0)
		add		hl,de		
		ex		de,hl
		ld		l,a
		ld		a,(AppBnkNum);Get source Bank
		add		l
		ld		hl,(Quig_Memory_String_Source_Addr)
		ld		bc,(Quig_Memory_String_Len)
		rst 	#20:dw #8130
		jp		(iy)
.Quig_Memory_String_Source_Addr: dw 0		
.Quig_Memory_String_Len: dw 0
		
;LIBRARY QUIG.MEMORY.INT.SET
;***************************
;ST1 = Memory
;DE = Position
;HL = Int
.Quig_Memory_Int_Set:
		pop		iy
		ld		c,l				;BC=Int to set
		ld		b,h
		pop		hl				;Gets the Memory Position
		ld		a,(hl)
		inc		hl
		ld		(Quig_Memory_Int_Set_2+1),hl
.Quig_Memory_Int_Set_2		
		ld		hl,(0)
		add		hl,de
		rst 	#20:dw #8127
		jp		(iy)
;LIBRARY QUIG.MEMORY.BYTE.SET
;***************************
;ST1 = Memory
;DE = Position
;HL = Byte
.Quig_Memory_Byte_Set:
		pop		iy
		ld		b,l
		pop		hl				;Gets the Memory Position
		ld		a,(hl)
		inc		hl
		ld		(Quig_Memory_Byte_Set_2+1),hl
.Quig_Memory_Byte_Set_2		
		ld		hl,(0)
		add		hl,de
		
;		di
;.tjw	jr		tjw		
		rst 	#20:dw #812D
		jp		(iy)	


;LIBRARY QUIG.DIALOG
;*******************
;ST2 = TextLine1
;ST1 = TextLine2
;DE = TextLine3
;HL = Buttons

;ST2 = TextLine1
;ST1 = TextLine2
;ST1 = TextLine3
;ST1 = TitleText
;DE = Buttons
;HL = Icon
.Quig_Dialog:
		IncLib 	SYSYSTEM.SENDMESSAGE
		Inclib 	QUIG.LETSTRING
		pop		iy
		
		ld		d,%01000000
		ld		a,l
		and		a
		jr		z,Quig_Dialog_Skipit
		ld		d,%11000000
.Quig_Dialog_skipit
		pop		hl
		ld		a,l
		rla		
		rla		
		rla
		and		%111000
		ld		l,a
		ld		a,e		;button
		or		d
		or		l
		
		ld		(Quig_Dialog_x+1),a		
		pop		hl
		ld		de,(Quig_Dialog_3)
		call	Quig_LetString
		pop		hl
		ld		de,(Quig_Dialog_2)
		call	Quig_LetString
		pop		hl
		ld		de,(Quig_Dialog_1)
		call	Quig_LetString
		ld		hl,Icon24_Data_Data
		ld		(AppMsgB+12),hl
		push	iy
.Quig_Dialog_x		
		ld		e,0
		ld		a,(appBnkNum)
		ld		hl,Quig_Dialog_1
        ld 		c,MSC_SYS_SYSWRN
        call 	SySystem_SendMessage
.Quig_Dialog_Loop:
		call	Quig_Dialog_Wait_Message
		jr		nc,Quig_Dialog_Loop
		cp		157
		jr		nz,Quig_Dialog_Loop
		ld    	a,(AppMsgB+1)
		cp		1
		jr		z,Quig_Dialog_Loop
		ld		l,a
		ld		h,0	
		
		pop		iy
		jp		(iy)
.Quig_Dialog_Wait_Message:
        rst   	#30
		ld    	a,(AppPrzN)
        db    	#dd:ld l,a
        db    	#dd:ld h,-1
        ld    	iy,AppMsgB
        rst   	#18
        Or    	a
        db    	#dd:dec l
        ret    	nz
        ld    	a,(AppMsgB+0)
        Or    	a
        scf
        ret

		

				
;LIBRARY QUIG.FORM.SIZE	
;*************************
.Quig_SetFormSize
;** Form%[STACK}, Width%[DE], Height%[HL]
		pop		iy						;Gets return Address
		pop		bc						;Gets form number
		push	hl						;Store Height
		ld		hl,Quig_FormIDs			;**** Point to Start of Window List
		add		hl,bc
		ld		a,(hl)
		pop		hl						;POP Height
		push	iy						;Puts Return Address on Stack
        ld 		c,MSC_DSK_WINSIZ
        jp 		SyDesktop_SendMessage

;LIBRARY QUIG.FORM.COORD.SET
;***************************
.Quig_Form_Coord_Set:
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret
		
;LIBRARY QUIG.FORM.POS
;*************************
.Quig_SetFormPos
;** Form%[STACK}, X%[DE], Y%[HL]
		pop		iy						;Gets return Address
		pop		bc						;Gets form number
		push	hl						;Store Height
		ld		hl,Quig_FormIDs		;**** Point to Start of Window List
		add		hl,bc
		ld		a,(hl)
		pop		hl						;POP Height
		push	iy						;Puts Return Address on Stack
        ld 		c,MSC_DSK_WINMOV
        jp 		SyDesktop_SendMessage			


		
;LIBRARY QUIG.TEXTBOX.PEN
;***************************
;INP Control_TextPalette[HL]
.Quig_TextBox_Pen
		ld		a,(hl)
		and		%11110000
		rra
		rra
		rra
		rra
.Quig_TextBox_Pen_2		
		ld		l,a
		ld		h,0
		ret
.Quig_TextBox_Paper
		ld		a,(hl)
		and		%1111
		jr		Quig_TextBox_Pen_2
;LIBRARY QUIG.TEXTBOX.READONLY
;*****************************
;INP Control_ReadOnly[HL]
.Quig_TextBox_Palette		
		ld		a,(hl)
		and		%100
		rra
		rra
.Quig_TextBox_Palette_2		
		ld		l,a
		ld		h,0
		ret
.Quig_TextBox_ReadOnly		
		ld		a,(hl)
		and		%10
		rra
		jr		Quig_TextBox_Palette_2
		
;LIBRARY QUIG.FILE.EXIST
;** INP FileString[HL]		
.Quig_File_Exist
		ld		a,(appBnkNum)
		db		#DD,#67
		ld		a,0
		ld		c,0	
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 		FNC_FIL_DIRPRR			
		ld		hl,0
		jr		c,Quig_File_Exist_2		
		inc		hl
.Quig_File_Exist_2
		ret
	

			

;LIBRARY SYB.FORM.REFRESHAREA
;***************************
.SyB_Form_RefreshArea
		ld		b,0
		ld		hl,Quig_FormIDs
		add		hl,bc
		ld		a,(hl)
		ld		(AppMsgB+1),a
		ld		a,-1
		ld		(AppMsgB+2),a
		ld 		a,MSC_DSK_WINPIN
		ld		(AppMsgB+0),a
        db 		#dd:ld h,2       ;2 is the number of the desktop manager process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#10		
		ret
.SyB_Form_RefreshArea_X	
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+4),hl
.SyB_Form_RefreshArea_X_1
		ld		bc,6
		add		iy,bc
		ld		(SyB_StackAddr),iy		
		ret
.SyB_Form_RefreshArea_Y
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+6),hl
		jr		SyB_Form_RefreshArea_X_1
.SyB_Form_RefreshArea_W
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+10),hl
		jr		SyB_Form_RefreshArea_X_1
.SyB_Form_RefreshArea_H
		ld		iy,(SyB_StackAddr)
		ld		(iy+7),l
		ld		(iy+8),h
		ld		(AppMsgB+8),hl
		jr		SyB_Form_RefreshArea_X_1	
;LIBRARY QUIG.IDLE
.Quig_Idle:
		rst		#30
		ret
	
;LIBRARY QUIG.FRAME.COLOUR.SET
;INP Control [ST],Pen [DE],Paper{HL]
.Quig_Frame_Colour_Set:
		pop		iy
		ld		a,l
		and		%11
		ld		b,a
		ld		a,e
		and		%11
		rla
		rla
		or		b
		and		%1111
		pop		bc
		ld		(bc),a
		jp		(iy)
		
;LIBRARY QUIG.CHECK.COLOUR.SET
;INP Pen[DE],PAPER[HL]
.Quig_Check_Colour_Set
		pop		iy
		ld		a,l
		and		%11
		ld		c,a
		ld		a,e
		rla
		rla
		and		%1100
		or		c
		pop		hl
		ld		(hl),a
		jp		(iy)
		
		
;LIBRARY QUIG.CTRLABEL.COLOUR.SET
;INP Control[ST1],Pen[DE],Paper[HL]
.Quig_CtrLabel_Colour_Set:
		pop		iy
		ld		a,l
		and		%1111
		ld		l,a
		ld		a,e
		rla
		rla
		rla
		rla
		and		%11110000
		or		l
		pop		hl
		ld		(hl),a
		jp		(iy)
;LIBRARY QUIG.FORM.PAPER
.Quig_Form_Paper:
		ld		a,l
		and		%1111
		add		128
		ld		(de),a
		ret

;LIBRARY QUIG.EXTDATAPLUS2.ADDR
.Quig_ExtDataPlus2_Addr:
		ld		de,4
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		inc		hl
		inc		hl
		ret
;LIBRARY QUIG.EXTDATATEXT.ADDR
.Quig_ExtDataText_Addr:
		ld		de,4
		add		hl,de				;HL=ControlID Address + 4 to point to ExtData area
		ld		e,(hl)				;
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ret		
;LIBRARY QUIG.LABEL.COLOUR.SET
;INP Control[ST2],Pen[ST1],Paper[DE],Filled[HL]
.Quig_Label_Colour_Set:
		pop		iy					;Return Address
		pop		bc					;Pen
		ld		a,l					;Fill bit
		rrca
		and		%10000000			;mask
		ld		l,a					;l=shifted fill bit
		ld		d,c					;Pen Colour
		ld		a,e					;Paper Colour
		pop		bc					;Address of Control
		inc		bc
		ld		a,(bc)				
		and		%10000000
		jr		nz,Quig_Label_Colour_Set16
.Quig_Label_Colour_Set4:		
		ld		a,d					;a = pen colour
		rla							;rotate >>2
		rla
		and		%1100				;mask	
		ld		d,a					;store in e
		ld		a,e					;Get Paper
		and		%11					;
		or		d					;Pen colour					
		or		l					;Fill bit
		dec		bc
		ld		(bc),a				;Store
		jp		(iy)
.Quig_Label_Colour_Set16:
		ld		a,d					;a = pen colour
		rla
		rla
		rla
		rla
		and		%11110000			;mask
		ld		d,a
		ld		a,e					;Get Paper
		and		%1111
		or		d					;Pen colour
		dec		bc					;Back to original spot
		ld		(bc),a				;Store
		ld		a,l
		rra
		and		%01000000
		ld		l,a
		inc		bc
		ld		a,(bc)
		and		%10111111
		or		l					;Fill bit
		ld		(bc),a
		jp		(iy)		
		


;.Quig_Label_Colour_Set:
;		pop		iy						;Return Address
;		ld		a,l						;Filled Attrib
;		rrca							;Rotate Bit 0 into Bit 7
;		and		%10000000				;And Bit 7
;		ld		l,a						
;		ld		a,e
;		and		%11
;		or		l
;		ld		l,a
;		pop		bc
;		ld		a,c
;		and		%11
;		rla
;		rla
;		or		l
;		pop		bc
;		ld		(bc),a
;		jp		(iy)

;LIBRARY QUIG.LABEL.PAPER.GET
;INP Control[HL]
.Quig_Label_Paper_Get
		ld		a,(hl)
		and		%11
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.LABEL.PEN.GET
;INP Control[HL]
.Quig_Label_Pen_Get
		ld		a,(hl)
		rra
		rra
		and		%11
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.LABEL.FILLED.GET
;INP Control[HL]
.Quig_Label_Filled_Get
		ld		a,(hl)
		rlca
		and		%1
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.LIST.SELECT.SET	
;INP DE = Address of Click, HL = Value
.Quig_List_Select_Set:
		ld		a,l
		ld		(de),a
		inc		de
		ld		a,%01000000
		or		h
		ld		(de),a
		ret
;LIBRARY QUIG.CTRLABEL.PAPER.GET
;INP Control[HL]
.Quig_CtrLabel_Paper_Get
		ld		a,(hl)
		and		%1111
		ld		l,a
		ld		h,0
		ret
;LIBRARY QUIG.CTRLABEL.PEN.GET
;INP Control[HL]
.Quig_CtrLabel_Pen_Get
		ld		a,(hl)
		rla
		rla
		rla
		rla
		and		%1111
		ld		l,a
		ld		h,0
		ret		

;LIBRARY QUIG.TEXTBOX.PALETTE.SET
;*********************************
;** INP Control_TextAppearance%[STACK 1],Pen%[DE],Paper%[HL]
.Quig_TextBox_Palette_Set:
		pop		iy
		ld		a,e
		and		%1111
		rla
		rla
		rla
		rla
		ld		e,a
		ld		a,l
		and		%1111
		or		e
		pop		hl
		ld		(hl),a
		jp		(iy)
		
;LIBRARY QUIG.CONTROL.SETPOS2
;****************************
;** INP Control%[STACK 1],Left%[DE],Top%[HL]
.Quig_Control_SetPos2:
		INCLIB  QUIG.CONTROL.SETPOS
		ld		bc,6					;/Add 6 to Get Left/Top
		jr		Quig_CSP2
.Quig_Control_SetSize2:		
		ld		bc,8					;/Add 8 to get Width/Height
.Quig_CSP2:		
		pop		iy
		ld		(Quig_CSP2_Var),hl
		pop		hl
		add		hl,bc
		ld		bc,(Quig_CSP2_Var)
		jp		Quig_Control_SetPos_x
.Quig_CSP2_Var:	dw	0		
		
;LIBRARY QUIG.CONTROL.SETPOS
;****************************
;** INP Control%[STACK 1],Left%[DE],Top%[HL]
.Quig_Control_SetPos
		pop		iy					;/Get the return address
		ld		c,l					;/Swap Top Value into BC
		ld		b,h
		pop		hl					;/Pop in Control Address
.Quig_Control_SetPos_x
		ld		(hl),e				;/Copy Left into Control+6 (Control.Left)
		inc		hl
		ld		(hl),d
		inc		hl
		ld		(hl),c				;/Copy Top into Control+8 (Control.Top)
		inc		hl
		ld		(hl),b
		jp		(iy)				;/Return
		
;LIBRARY QUIG.SET.CONTROL.WORD
;*****************************		
;INP	Control[DE],VALUE[HL]
.Quig_Set_Control_Word
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ret

;LIBRARY QUIG.CONTROL.TRANSPARENCY.SET
;*************************************
;INP Control%[DE],Visible%[HL]
.Quig_Control_Transparency_Set:
		ex		de,hl
		inc		hl
		inc		hl
		ld		a,(hl)
		and		%10000000
		ld		d,a
		ld		a,e
		and		%0
		add		10
		or		d
		ld		(hl),a
		ret
		
;LIBRARY QUIG.CONTROL.VISIBLE.SET
;*******************************
;INP Control%[DE],Visible%[HL]
.Quig_Control_Visible_Set:
		ex		de,hl
		inc		hl
		inc		hl
		ld		a,e
		and		a
		jr		nz,Quig_SetControlVisible_2
		ld		e,(hl)
		set		6,e
.Quig_SetControlVisible_1		
		ld		(hl),e
		ret
.Quig_SetControlVisible_2		
		ld		e,(hl)
		res		6,e
		jr		Quig_SetControlVisible_1
		
.Quig_GetObjLeft
		ld		bc,6
		add		hl,bc
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a
		ret

;LIBRARY QUIG.RADIO.SELECTED.SET
;*******************************
.Quig_Radio_Selected_Set:
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		dec		hl
		ld		(hl),a
		ret
;LIBRARY QUIG.RADIO.SELECTED.GET
;*******************************
.Quig_Radio_Selected_Get:
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		dec		hl
		ld		e,(hl)
		cp		e
		jr		nz,Quig_Radio_Selected_Get_2
		ld		hl,1
		ret
.Quig_Radio_Selected_Get_2
		ld		hl,0
		ret


;LIBRARY QUIG.BACKGROUND.TILE.SET
;********************************
;DE=Canvas ExtraData
;HL=Sheet_Status address
		INCLIB 	QUIG.TILE.SET
.Quig_Background_Tile_Set
		ld		(Quig_CanvasExtData),de		;Store Extra Data Address
		ld		(Quig_BckTileSetSheet),hl	;Store Sheet Status Address
		ex		de,hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		push	de							;Stack=Address Of Control
		ld		de,(Quig_BckTileSetSheet)	;DE=Sheet_Status address
		ld		hl,0						;Tile Number
		call	Quig_Tile_Set
		
		;Get the Canvas Bank/Address Into banks of 
		ld		hl,(Quig_CanvasExtData)
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl						;DE = address of AddrBck1
		;Get and copy into Place
		ld		a,(hl)
		ld		(Quig_GraphicBank),a
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ld		(Quig_GraphicBlock),bc
		
		ex		de,hl					;DE = Canvas Background
		ld		a,(hl)					
		inc		hl
		ld		h,(hl)
		ld		l,a						;HL = Canvas Background Address
		inc		hl						;+1
		inc		hl						;+1
		inc		hl						;+1 HL now = Address of Bck1_ExtData
		
		ld		b,8						;Loop through 8 Background objects
		ex		de,hl
		ld		hl,(Quig_GraphicBlock)	
.Quig_BGT_1		
		push	bc						;Store loop
		ld		a,(Quig_GraphicBank)	;Get Bank
		ld		(de),a					;Store
		inc		de						;Inc
		ld		bc,9					;+9
		add		hl,bc
		ex		de,hl					;HL=Copy address - DE Block address
		ld		(hl),e
		inc		hl
		ld		(hl),d
		ld		bc,30
		add		hl,bc
		ex		de,hl
		pop		bc						;Recall loop value
		djnz	Quig_BGT_1				;Loop
		
		;Let copy from EXT Data are to the canvas area
		;Destination address
		ld		hl,(Quig_CanvasExtData)
		ld		bc,86
		add		hl,bc
		ex		de,hl
		;Source Address
		ld		hl,(Quig_GraphicBlock)
		ld		bc,9
		add		hl,bc
		ld		a,(Quig_GraphicBank)
		and		%1111
		ld		c,a
		ld		a,(AppBnkNum)
		rla
		rla
		rla
		rla
		and		%11110000
		or		c
		ld		bc,72	
		rst 	#20:dw #8130
		ret
.Quig_CanvasExtData:	dw 	0
.Quig_BckTileSetSheet:	dw	0
.Quig_GraphicBank:		db	0
.Quig_GraphicBlock:		dw	0


;LIBRARY QUIG.CTTEXT

;IN HL = String start
.Quig_CtText_Remove:
		ld		de,(Quig_String_Buffer_Pos)
		dec		hl
.Quig_CtTextR_Loop:
		inc		hl
		ld		a,(hl)
		ld		c,a
		;Is a zero
		and		a
		jr		z,Quig_CtTextR_Finish
		ld		a,c
		and		%10000000
		jr		nz,Quig_CtTextR_Loop
		ld		a,c
		and		%11100000
		jr		nz,Quig_CtTextR_AddBack
		ld		c,a
.Quig_CtTextR_Colour:		
		cp		1
		jr		nz,Quig_CtTextR_Under
		inc		hl
		jr		Quig_CtTextR_Loop
.Quig_CtTextR_Under:

.Quig_CtTextR_Graphic:		
		cp		6
		jr		nz,Quig_CtTextR_Loop
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		jr		Quig_CtTextR_Loop

.Quig_CtTextR_AddBack:
		ld		a,c
		ld		(de),a
		inc		de
		jr		Quig_CtTextR_Loop
		
.Quig_CtTextR_Finish:
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(de),a
		inc		de
		ld		(Quig_String_Buffer_Pos),de
		ret


.Quig_CtText_Colour:
		ld		a,e
		rla
		rla
		rla
		rla
		and		%11110000
		ld		b,a
		ld		a,l
		and		%1111
		or		b
		ld		hl,(Quig_String_Buffer_Pos)   ;Where to copy string
		ld		c,1
		ld		(hl),c			;Control code 6
		inc		hl
		ld		(hl),a			;Colour
		jr		Quig_CtText_FinishString
.Quig_CtText_Graphic:
		ld		c,l
		ld		b,h
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,bc						;*9
		
		ex		de,hl						;DE=Tile*9 HL=Sheet	
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		inc		hl
		ld		a,(hl)						;bank				
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		add		hl,bc
		inc		hl
		ex		de,hl
		ld		hl,(Quig_String_Buffer_Pos)   ;Where to copy string
		ld		c,6
		ld		(hl),c			;Control code 6
		inc		hl
		ld		c,128
		ld		(hl),c			;Offset	
		inc		hl
		ld		(hl),a			;Bank
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
.Quig_CtText_FinishString:			
		inc		hl
		xor		a
		ld		(hl),a
		inc		hl
		ex		de,hl
		ld		hl,(Quig_String_Buffer_Pos)
		ld		(Quig_String_Buffer_Pos),de
		ret			

		
		
;LIBRARY QUIG.TILE.SET
;*********************
;Stack=Address Of Control
;DE=Sheet_Status address
;HL=Tile Number
.Quig_Control_Tile_Set:
		pop		iy
		pop		bc						;Address of control
.Quig_Control_Tile_Set_ZeroHL:		
		inc		bc						;
		inc		bc						;
		ld		a,(bc)				
		cp		10						;Graphic?
		jr		nz,Quig_Tile_Set_Fail_2
		inc		bc
		push	bc
		jr		Quig_Tile_Set_2
.Quig_Tile_Set_Fail_2:
		jp		(iy)
;DE=Address of Control
;HL=Sheet Address
.Quig_Tile_Set_HL0:
		pop		iy
		push	de
		ex		de,hl
		ld		hl,0
		jr		Quig_Tile_Set_2

;Stack=Address ExtraData
;Stack=Object Number
;DE=Sheet_Status address
;HL=Tile Number		
.Quig_Tile_ObjSet:
		pop		iy
		ld		c,l
		ld		b,h
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,bc						;*9
		inc		de
		inc		de
		inc		de
		inc		de
		inc		de
		ld		a,(de)						;bank				
		ld		(Quig_Tile_Set_Bank),a
		inc		de
		ld		a,(de)
		ld		c,a
		inc		de
		ld		a,(de)
		ld		b,a
		add		hl,bc
		ld		(Quig_Tile_Set_Addr),hl
		;********************************************
		pop		hl							;Sheet Obj Number
		ld		a,l
		ld		(Quig_TOSet_Tile),a
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,hl						;*16
		add		hl,hl						;*32
		ex		de,hl
		pop		hl							;Extra Data = store
		ld		(Quig_TOSet_ED),hl
		inc		hl							;Move to the Obj1 Address
		inc		hl
		inc		hl
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		ex		de,hl
		add		hl,bc
		inc		hl
		inc		hl
		inc		hl
		ex		de,hl
		ld		hl,Quig_Tile_Set_Bank
		ldi
		ldi
		ldi
		;***********************************************
		ld		a,(Quig_Tile_Set_Bank)	
		ld		hl,(Quig_Tile_Set_Addr)
		inc		hl
		rst 	#20:dw #8124
		push	bc
		ld		a,(Quig_TOSet_Tile)
		add		a							;*2
		ld		e,a							;c=a*2
		add		a							;*4
		add		a							;*8
		add		e
		ld		e,a
		ld		d,0
		ld		hl,(Quig_TOSet_ED)
		ld		bc,14
		add		hl,bc
		add		hl,de
		pop		bc
		ld		(hl),c
		inc		hl
		ld		(hl),b
		jp		(iy)
.Quig_TOSet_Tile:	db	0		
.Quig_TOSet_ED:		dw	0		
		
	
		
.Quig_TileObjStore1: dw 0		
;Stack=Address Of Control
;DE=Sheet_Status address
;HL=Tile Number
.Quig_Tile_Set:
		pop		iy
		
		

		
.Quig_Tile_Set_2:		
		ld		a,(de)
		cp		1
		jp		nz,Quig_Tile_Set_Fail
		inc		de
		inc		de
		ld		a,(de)
		cp		l		
		jr		c,Quig_Tile_Set_Fail		;Asking for a tile higher than Tiles in set
		jr		z,Quig_Tile_Set_Fail		;Asking for a tile higher than Tiles in set
		ld		c,l
		ld		b,h
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,bc						;*9
		inc		de
		inc		de
		inc		de
		ld		a,(de)						;bank				
		ld		(Quig_Tile_Set_Bank),a
		inc		de
		ld		a,(de)
		ld		c,a
		inc		de
		ld		a,(de)
		ld		b,a
		add		hl,bc
		ld		(Quig_Tile_Set_Addr),hl
		pop		de
		ld		hl,Quig_Tile_Set_Bank
		ldi
		ldi
		ldi
		jp		(iy)
.Quig_Tile_Set_Bank:	db		0
.Quig_Tile_Set_Addr:	dw		0
.Quig_Tile_Set_Fail:
		pop		hl
		ld		a,255
		ld		(hl),a
		inc		hl
		ld		de,Sheet_Data4
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		(iy)

;LIBRARY QUIG.NET.TCP.STATUS
;***************************
;IN  HL = Socket
;OUT HL = Status
.Quig_Net_Tcp_Status:
		ld		a,(Quig_Net_Process)
		cp		255
		jr		z,Quig_Net_Tcp_Status_3
		ld		a,l
		cp		255
		jr		z,Quig_Net_Tcp_Status_3

		
        call 	snwmsgi_af
        db 		FNC_NET_TCPSTA
        call 	snwmsgo_afbcdehlixiy	
		jr		nc,Quig_Net_Tcp_Status_2
.Quig_Net_Tcp_Status_3:		
		ld		hl,255
		ret	
.Quig_Net_Tcp_Status_2:
		ld		h,0
		ret
;LIBRARY QUIG.NET.TCP.FLUSH
;**************************
;HL = SOCKET
.Quig_Net_TCP_Flush
		ld		a,(Quig_Net_Process)
		cp		255
		ret		z
		ld		a,l
		call 	snwmsgi_af
        db 		FNC_NET_TCPFLS
        call 	snwmsgo_afhl
		ret		
;LIBRARY QUIG.NET.TCP.CLOSE
;**************************
;HL = SOCKET
.Quig_Net_TCP_Close
		ld		a,(Quig_Net_Process)
		cp		255
		ret		z
		ld		a,l
		call 	snwmsgi_af
        db 		FNC_NET_TCPCLO
        call 	snwmsgo_afhl
		ret


		
;LIBRARY QUIG.EVENT.NET.TCP.ESTABLISH
;************************************
.Quig_Event_Net_TCP_Establish:
		ld		hl,0
		ld		a,(Quig_Event_Net)
		cp		2
		ret		nz
		inc		hl
		ret
;LIBRARY QUIG.EVENT.NET.TCP.RECEIVED
;************************************
.Quig_Event_Net_TCP_Received:
		ld		hl,0
		ld		a,(Quig_Event_Net)
		cp		128
		ret		nz
		inc		hl
		ret
;LIBRARY QUIG.EVENT.NET.TCP.CLOSING
;************************************
.Quig_Event_Net_TCP_Closing:
		ld		hl,0
		ld		a,(Quig_Event_Net)
		cp		3
		ret		nz
		inc		hl
		ret
;LIBRARY QUIG.EVENT.NET.TCP.CLOSED
;************************************
.Quig_Event_Net_TCP_Closed:
		ld		hl,0
		ld		a,(Quig_Event_Net)
		cp		4
		ret		nz
		inc		hl
		ret



;LIBRARY QUIG.PRINTER


;### PRTBSY -> check if printer is busy
;### Input      (Quig_Machine_Type)=platform
;### Output     HL=status (0=printer is ready, -1=printer is busy, 1=platform not supported)
.Quig_prtbsy:  
		ld 		a,(Quig_Machine_Type)
        cp 		5
        jr 		c,Quig_prtbsy_cpc
        cp 		7
        jr 		c,Quig_prtbyt0
        cp 		10+1
        jr 		nc,Quig_prtbyt0
.Quig_prtbsy_msx:
        in 		a,(#90)
        rra
        rra
.Quig_prtbsy1: 
		sbc 	a
        ld 		l,a
        ld 		h,a
        ret
.Quig_prtbsy_cpc:
        ld 		b,#f5
        in 		a,(c)
        rla
        rla
        jr 		Quig_prtbsy1

;### PRTSTR -> print string
;### Input      (HL)=string (0-terminated), (Quig_Machine_Type)=platform
;### Output     HL=status (0=ok, 1=timeout/platform not supported)
.Quig_prtstr:
		ld 		a,(hl)
        or 		a
        jr 		z,Quig_prtstr1
        push 	hl
        ld 		l,a
        call 	Quig_prtbyt
        pop 	hl
        inc 	hl
        jr 		Quig_prtstr
.Quig_prtstr1:
		ld 		hl,0
        ret
;### PRTBYT -> print byte
;### Input      L=byte, (Quig_Machine_Type)=platform
;### Output     HL=status (0=ok, 1=timeout/platform not supported)
.Quig_prtbyt_timout   equ 100
.Quig_prtbyt_timdly   equ 3

.Quig_prtbyt:  
		ld 		de,25603
        ld 		a,(Quig_Machine_Type)
        cp 		5
        jr 		c,Quig_prtbyt_cpc
        cp 		7
        jr 		c,Quig_prtbyt0
        cp 		10+1
        jr 		c,Quig_prtbyt_msx
.Quig_prtbyt0:
		ld 		hl,1                 ;timeout/platform not supported
        ret

		

.Quig_prtbyt_msx:                      ;*** msx
        in 		a,(#90)
        rra
        rra
        jr 		nc,Quig_prtbyt1
        dec 	e
        jr 		nz,Quig_prtbyt_msx
        rst 	#30
        dec 	d
        jr 		z,Quig_prtbyt0
        ld 		e,Quig_prtbyt_timdly
        jr 		Quig_prtbyt_msx
.Quig_prtbyt1:
		ld 		a,l
        out 	(#91),a
        xor 	a
        out 	(#90),a
        dec 	a
        out 	(#90),a
        ld 		hl,0
        ret

.Quig_prtbyt_cpc:                      ;*** cpc
        ld 		b,#f5
.Quig_prtbyt2: 
		in 		a,(c)
        rla
        rla
        jr 		nc,Quig_prtbyt3
        dec 	e
        jr 		nz,Quig_prtbyt2
        rst 	#30
        dec 	d
        jr 		z,Quig_prtbyt0
        ld 		e,Quig_prtbyt_timdly
        jr 		Quig_prtbyt2
.Quig_prtbyt3:
		ld 		b,#ef
        res 	7,l
        out 	(c),l
        set 	7,l
        out 	(c),l
        res 	7,l
        out 	(c),l
        ld 		hl,0
        ret




;LIBRARY QUIG.INIT.NETCHECK
;***********************
.Quig_Init_NetCheck
		ld		a,(Quig_Net_Process)
		cp		255
		ret		nz
;******************************************************************************
;*** Name           Network_Init
;*** Input          -
;*** Output         CF   = Error state (0 = ok, 1 = Network daemon not running)
;***                - if CF is 0:
;***                (SyNet_PrcID) = Network daemon process ID
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    ...
;******************************************************************************
		inclib 	SYSYSTEM.SENDMESSAGE
		inclib 	SYSYSTEM.WAITMESSAGE
		push	hl
		push	de
        ld 		e,0
        ld 		hl,snwdmnt
        ld 		a,(AppBnkNum)
		ld 		c,MSC_SYS_PRGSRV
        call 	SySystem_SendMessage
.Quig_Net_SPSr1
		call 	SySystem_WaitMessage
        cp 		MSR_SYS_PRGSRV
        jr 		nz,Quig_Net_SPSr1
        ld 		a,(AppMsgB+1)
        ld 		hl,(AppMsgB+8)
        or 		a
        scf
        jr		nz,Quig_Init_NetCheck2
        ld 		a,h
        ld 		(Quig_Net_Process),a
        or 		a
.Quig_Init_NetCheck2
		pop		de
		pop		hl
		ld		a,(Quig_Net_Process)
		cp		255
        ret		
.snwdmnt:
		db "Network Daem"
		
;LIBRARY QUIG.NET.TCP.SERVER.OPEN
;********************************
;INP HL = Port
;OUT HL = Handle
.Quig_Net_Tcp_Server_Open
		inclib 	QUIG.INIT.NETCHECK
		call	Quig_Init_NetCheck
		ret		z					;If 255 Then Return
		ld		a,1
        call 	snwmsgi_afbcdehlixiy
        db 		FNC_NET_TCPOPN
        call	snwmsgo_afhl
;		ret		c
		ld		l,a
		ld		h,0
		ret

;LIBRARY QUIG.NET.TCP.CLIENT.OPEN
;********************************
;IN  HL = Port
;    DE = IP
;OUT HL = Handle
.Quig_Net_TCP_Client_Open
		;**** Check we are Initialised
		inclib 	QUIG.INIT.NETCHECK
		call	Quig_Init_NetCheck
		ret		z					;If 255 Then Return	
		push	hl						;Store Port Number
		ex		de,hl					;HL =  Pointer to
		ld 		de,(AppBnkNum)
        call 	snwmsgi_afdehl
        db 		FNC_NET_DNSVFY
        call 	snwmsgo_afbcdehlixiy
		ld		a,l
		pop		de
		cp		1
		jr		nz,Quig_Net_TCP_Client_Open_End
		ld		hl,-1
		xor		a
		ld		(Quig_Net_TCP_Server),a		
		call 	snwmsgi_afbcdehlixiy
        db 		FNC_NET_TCPOPN
        call 	snwmsgo_afhl
		jr		c,Quig_Net_TCP_Client_Open_End
		ld		l,a
		ld		h,0
		ret
.Quig_Net_TCP_Client_Open_End
		ld		hl,0
		ret
		
;LIBRARY QUIG.NET.SEND
;*********************
		inclib 	SYSYSTEM.SENDMESSAGE
		inclib 	SYSYSTEM.WAITMESSAGE
.Quig_Net_Send_Byte:
		ld		bc,1		;BC=LENGTH
		jr		Quig_Net_Send_ByteInt
.Quig_Net_Sent_Int:			
		ld		bc,2		;BC=LENGTH
.Quig_Net_Send_ByteInt:		
		ld		a,(Quig_Net_Process)
		cp		255
		ret		z	
		ld		(Quig_Net_Send_Data),hl
		ld		a,e			;A=SOCKET
		ld		(Quig_Net_Send_4+1),a	
		ld		hl,Quig_Net_Send_Data
		jr		Quig_Net_Send_2
.Quig_Net_Send_Data:	dw	0
;INP HL = String
;    DE = Socket
.Quig_Net_Send:
		inclib 	SYSYSTEM.SENDMESSAGE
		inclib 	SYSYSTEM.WAITMESSAGE
		ld		a,(Quig_Net_Process)
		cp		255
		ret		z	
		INCLIB 	QUIG.LEN
		ld		(Quig_Net_Send_Addr),hl
		push	de	
		call	Quig_Len
		pop		de

		ld		c,l			;BC=LENGTH
		ld		b,h
		ld		a,e			;A=SOCKET
		ld		(Quig_Net_Send_4+1),a	
		ld		hl,(Quig_Net_Send_Addr)	
		call	Quig_Net_Send_2
		jp		Quig_LS_Finish
.Quig_Net_Send_2:
		ld		a,(AppBnkNum)
		ld		e,a
		di
.Quig_Net_Send_4:
		ld		a,0
		call	snwmsgi_afbcdehl
        db		FNC_NET_TCPSND
        call	snwmsgo_afbchl
		jr		z,Quig_Net_Send_3
		;**** Need to resend
		rst		#30
		ld		e,c		;de=bc	bytes sent
		ld		d,b
		ld		c,l		;hl=bc	bytes remaining
		ld		b,h
		ld		hl,(Quig_Net_Send_Addr)
		add		hl,de
		ld		(Quig_Net_Send_Addr),hl
		jr		Quig_Net_Send_2
.Quig_Net_Send_3:
		ei
		ret
.Quig_Net_Send_Addr:	dw		0

;LIBRARY QUIG.NET.RECEIVE.BYTE
;***********************************
.Quig_Net_Receive_Byte:
		ld		a,(AppBnkNum)			
		ld		e,a								;e=app
		ld		a,(Quig_Event_Net_Handle)		;socket connection number
		ld		hl,(Quig_Net_Received_Value)	;Length of data
		dec		hl
		ld		(Quig_Net_Received_Value),hl
		ld		bc,1
		ld		hl,Quig_Net_Receive_Byte		;Store data recieved		
		call 	snwmsgi_afbcdehl				;Receive string to HL
        db 		FNC_NET_TCPRCV
        call 	snwmsgo_afbchl
		ld		a,(Quig_Net_Receive_Byte)
		ld		l,a
		ld		h,0
		ret
.Quig_Net_Receive_Byte:	dw	0

;LIBRARY QUIG.NET.RECEIVE.STRING
;***********************************
.Quig_Net_Receive_Part_String:
		ex		de,hl
		ld		hl,(Quig_Net_Received_Value)	;Length of data
		scf
		scf
		sbc		hl,de
		jr		c,Quig_Net_Receive_String
		ld		c,e
		ld		b,d
		ld		a,(AppBnkNum)			
		ld		e,a								;e=app
		ld		hl,(Quig_String_Buffer_Pos)		;String pointer address
		ld		a,(Quig_Event_Net_Handle)		;socket connection number
		jr		Quig_Net_Receive_StringX		
.Quig_Net_Receive_String:
		ld		a,(AppBnkNum)			
		ld		e,a								;e=app
		ld		hl,(Quig_String_Buffer_Pos)		;String pointer address
		ld		a,(Quig_Event_Net_Handle)		;socket connection number
		ld		bc,(Quig_Net_Received_Value)	;Length of data
.Quig_Net_Receive_StringX:		
		call 	snwmsgi_afbcdehl				;Receive string to HL
        db 		FNC_NET_TCPRCV
        call 	snwmsgo_afbchl
		jr		nz,Quig_Net_Receive_String_2
		ld		hl,0
.Quig_Net_Receive_String_2:	
		ld		(Quig_Net_Received_Value),hl
		ld		hl,(Quig_String_Buffer_Pos)		;Recall string begin address
		ld		e,l								;DE = begin							
		ld		d,h				
		add		hl,bc							;Add length
		xor 	a								;A=0
		ld		(hl),a							;Text terminator
		inc		hl								;New pointer position + 1
		ld		(Quig_String_Buffer_Pos),hl		;Store new position
		ex		de,hl							;HL=Start of text
		ret

;LIBRARY QUIG.NET.DNS.VERIFY
;***************************
.Quig_Net_DNS_Verify
		ld		a,(Quig_Net_Process)
		cp		255
		jr		z,Quig_Net_DNS_VerifyFail
		ld		a,(appBnkNum)
		ld		e,a
		call 	snwmsgi_afdehl
		db 		FNC_NET_DNSVFY
		call 	snwmsgo_afbcdehlixiy
		ld		h,0
		ret
.Quig_Net_DNS_VerifyFail
		ld		hl,0
		ret
		
;LIBRARY QUIG.NET.DNS.RESOLVE
;****************************
.Quig_Net_DNS_Resolve
		INCLIB	QUIG.STR.STR
		ld		a,(Quig_Net_Process)
		cp		255
		jr		z,Quig_Net_DNS_ResolveFail
		ld		a,(appBnkNum)
		ld		e,a
		ld		d,0
		call 	snwmsgi_afdehl
		db 		FNC_NET_DNSRSV
		call 	snwmsgo_afbcdehlixiy
		jp		nc,Quig_Net_DNS_Resolve_2
.Quig_Net_DNS_ResolveFail
		ld		ix,0
		ld		iy,0
		;ld		hl,(Quig_String_Buffer_Pos)
		;xor		a
		;ld		(hl),a
		;inc		hl
		;ld		(Quig_String_Buffer_Pos),hl
		;dec		hl
		;ret
.Quig_Net_DNS_Resolve_2		
		push	iy
		push	iy	
		push	ix
		push 	ix
		pop		hl
		ld		h,0	
		call	Quig_Str_Str
		ld		(Quig_DNS_Resolve_Start),hl
		ld		hl,(Quig_String_Buffer_Pos)
		dec		hl
		ld		a,"."
		ld		(hl),a
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl
		pop		hl
		ld		l,h
		ld		h,0
		call	Quig_Str_Str
		ld		hl,(Quig_String_Buffer_Pos)
		dec		hl
		ld		a,"."
		ld		(hl),a
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl
		pop		hl
		ld		h,0
		call	Quig_Str_Str
		ld		hl,(Quig_String_Buffer_Pos)
		dec		hl
		ld		a,"."
		ld		(hl),a
		inc		hl
		ld		(Quig_String_Buffer_Pos),hl		
		pop		hl
		ld		l,h
		ld		h,0
		call	Quig_Str_Str
		ld		hl,(Quig_DNS_Resolve_Start)
		ret
.Quig_DNS_Resolve_Start:dw	0		

;LIBRARY QUIG.VIRTUALBOX.MOVE
;IN X=(ST2),Y=(ST1), W=DE, H=HL
.Quig_VirtualBox_ReSize:
		pop		iy
		ld		(Quig_VirtualH),hl
		ld		(Quig_VirtualW),de	
		pop		hl						;HL=Y
		pop		de						;DE=X
		push	iy						;Put return Address on Stack
		ld		bc,(Quig_VirtualW)
		ld		ix,(Quig_VirtualH)
        ld 		(AppMsgB+06),bc
        ld 		(AppMsgB+08),ix
        ld 		c,MSC_DSK_CONSIZ
        call 	SyDesktop_SendMessage
.Quig_SyCoxPs1: 
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_CONSIZ
        jr 		nz,Quig_SyCoxPs1		
        ld 		a,(AppMsgB+1)
        rra
		ccf
		jr		c,Quig_SyCoPs2
		ld 		de,(AppMsgB+2)
        ld 		hl,(AppMsgB+4)
		ld		(Quig_VirtualW),de
		ld		(Quig_VirtualH),hl
		ld		hl,1
		ret
.Quig_VirtualBox_Move:	
		pop		iy
		ld		(Quig_VirtualH),hl
		ld		(Quig_VirtualW),de	
		pop		hl						;HL=Y
		pop		de						;DE=X
		push	iy						;Put return Address on Stack
		ld		bc,(Quig_VirtualW)
		ld		ix,(Quig_VirtualH)
        ld 		(AppMsgB+06),bc
        ld 		(AppMsgB+08),ix
        ld 		c,MSC_DSK_CONPOS
        call 	SyDesktop_SendMessage
.Quig_SyCoPs1: 
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_CONPOS
        jr 		nz,Quig_SyCoPs1		
        ld 		a,(AppMsgB+1)
        rra
		ccf
		jr		c,Quig_SyCoPs2
		ld 		de,(AppMsgB+2)
        ld 		hl,(AppMsgB+4)
		ld		(Quig_VirtualX),de
		ld		(Quig_VirtualY),hl
		ld		hl,1
		ret
.Quig_SyCoPs2:		
        ld		hl,0
        ret



.Quig_Horizontal_Move:
		ld		(Quig_HoriY),hl
		ld		hl,-1
		ld		de,-1
		ld		bc,2040
		ld		ix,(Quig_HoriY)
		call	Quig_Horizontal_MoveOO
		ld		hl,0
		ld 		a,(AppMsgB+1)
        rra
		ccf
		ret		c
		ld		hl,(AppMsgB+4)
		ld		de,(Quig_HoriY)
		xor		a
		sbc		hl,de
		ld		(Quig_HoriY),hl
		ld		hl,1
		ret
.Quig_Vertical_Move:
		ld		(Quig_VertX),hl
		ld		c,l
		ld		b,h
		ld		hl,-1
		ld		de,-1
		ld		ix,2048
		call	Quig_Horizontal_MoveOO
		ld		hl,0
		ld 		a,(AppMsgB+1)
        rra
		ccf
		ret		c
		ld		hl,(AppMsgB+2)
		ld		de,(Quig_VertX)
		xor		a
		sbc		hl,de
		ld		(Quig_VertX),hl
		ld		hl,1
		ret
.Quig_Horizontal_MoveOO:		
        ld 		(AppMsgB+06),bc
        ld 		(AppMsgB+08),ix
        ld 		c,MSC_DSK_CONSIZ
        call 	SyDesktop_SendMessage
.Quig_Horizontal_Move2:		
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_CONSIZ
        jr 		nz,Quig_Horizontal_Move2	
		ret			
		
.Quig_VirtualX:	dw	0
.Quig_VirtualY:	dw	0	
.Quig_VirtualW:	dw	0
.Quig_VirtualH:	dw	0
.Quig_HoriY:	dw	0
.Quig_VertX:	dw	0	
	
;LIBRARY QUIG.CANVAS.CREATE	
;*****************************
.Quig_Canvas_Update:
        ld 		ix,Quig_cvs_test
        call 	Quig_cvsspr
		ld 		a,(prgwin2)
		ld		e,240
		ld		d,Canvas1_Bck1_Display
		ld 		c,MSC_DSK_WININH
		jp		SyDesktop_SendMessage
		ret
.Quig_Sprite_Image:		
;Stack=Address ExtraData
;Stack=Object Number
;DE=Sheet_Status address
;HL=Tile Number		
		pop		iy
		ld		c,l							;BC=Tile Number
		ld		b,h
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,bc						;HL = Tile Number*9	
		inc		de:inc	de:inc de:inc de:inc de
		ld		a,(de)						;bank
		ld		(Quig_Sprite_Image_x1+1),a	
		inc		de
		ld		a,(de)
		ld		c,a
		inc		de
		ld		a,(de)
		ld		b,a
		add		hl,bc
		ex		de,hl
		;********************************************
		pop		hl							;Sheet Obj Number
		ld		a,l
		add		hl,hl						;*2
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,hl						;*16
		add		hl,hl						;*32
		pop		bc
		add		hl,bc
.Quig_Sprite_Image_x1:		
		ld		(hl),0
		inc		hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		(iy)
;*********************		
.Quig_Sprite_Position:
		pop		iy
		ld		c,l				;Y Pos
		ld		b,e				;X Pos
		pop		hl
		ld		a,l
		and		%111
		ld		l,a
		ld		h,0
		add		hl,hl			;*2
		add		hl,hl			;*4
		ld		e,l
		ld		d,h
		add		hl,hl			;*8
		add		hl,de			;*12
		ld		de,Quig_cvs_sprite0+2
		add		hl,de
		ld		(hl),b
		inc		hl
		inc		hl
		inc		hl
		ld		(hl),c
		jp		(iy)
;**********************
.Quig_Sprite_Size:
;ST2=Canvas Data Area, ST1=SpriteNo, DE=Width, HL=Height
		pop		iy
		ld		c,l					;BC=Width/Height
		ld		b,e
		pop		hl					;Get Sprite Number
		ld		a,l
		rla		:rla:rla:rla:rla
		and		%11100000
		ld		l,a					;HL = Sprite Number * 32
		ld		h,0					;
		pop		de					;First Sprite Width/Height Data
		add		hl,de				;Add together
		ld		(hl),b
		inc		hl
		inc		hl
		ld		(hl),c
		inc		hl
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		inc		hl
		inc		hl
		inc		hl
		ld		(hl),b
		inc		hl
		inc		hl
		inc		hl
		ld		(hl),c
		jp		(iy)
		
		

		
;### CVSUPD -> updates canvas encoding/xbytes after first display
;### Input      IX=canvas data record
;### Destroyed  AF,BC,DE,HL
.Quig_cvsupd: 
		ld 		a,(ix+Quig_bgr_bnk)
        ld 		l,(ix+Quig_bgr_adrbmp+0)
        ld 		h,(ix+Quig_bgr_adrbmp+1)
        dec 	hl
        rst 	#20:dw jmp_bnkrbt
        ld 		(ix+Quig_bgr_enc),b
        ld 		de,-10
        add 	hl,de
        rst 	#20:dw jmp_bnkrbt
        ld 		(ix+Quig_bgr_xbytes),b
        ld 		l,(ix+Quig_bgr_adrtil+0)
        ld 		h,(ix+Quig_bgr_adrtil+1)
        ld 		de,Quig_cvstil4-Quig_cvstil0+1
        add 	hl,de
        rst 	#20:dw jmp_bnkwbt
        ret		
		
;Canvas Stuff
;SpriteDataRecord[ST3],CanvasDataRecord[ST2]+3,W[ST1],H[DE],EncodeType[HL]
.Quig_Canvas_Create:
		pop		ix					;Return Address
		pop		bc					;Width

		ld		a,l					;a=EncodeType
		and		%1					;0 or 1
		jr		z,Quig_Canvas_Create4	
.Quig_Canvas_Create16:
		ld		h,5
		ld		a,c					;c=width
		rra
		and		%1111111
		jr		Quig_Canvas_Cx1
.Quig_Canvas_Create4:
		ld		h,1
		ld		a,c					;c=width
		rra
		rra
		and		%111111	
.Quig_Canvas_Cx1:
		ld		l,a
		ex		de,hl				;DE encoding=msx,16colours; width=80 bytes
		ld		h,l
		ld		l,c					;width=160pixel, height=96pixel
		ld		bc,128				;Tile buffer size

		pop		iy					;Get Control Address+3
		ld		a,(iy+3)			;Get Left
		ld		(Quig_cvs_test),a
		ld		a,(iy+5)			;Get Top
		ld		(Quig_cvs_test+1),a
		ld		(Quig_Canvas_Cx5+1),iy				
		inc		iy
		ld		(Quig_Canvas_Cx6+1),iy
		pop		iy					;Get First Sprite Control
		push	ix					;Store Return Address
		ld 		a,8                 ;8 sprites
		ld 		ix,Quig_cvs_test    ;canvas data record
        call 	Quig_cvsini         ;init canvas		
        jp 		c,Quig_End
.Quig_Canvas_Cx5:		
        ld 		(3),a         		;set background control
.Quig_Canvas_Cx6:		
        ld 		(4),hl
        ld 		(AppMemTab+0),a     ;register reserved memory
        ld 		(AppMemTab+1),de
        ld 		(AppMemTab+3),bc
		ret

;        call tilfil                 ;fill background with tiles
;       ld ix,cvs_test
;       call cvsupd                 ;after first display we have to update some canvas data again, as encoding and colours may changed 
;canvas data record
.Quig_bgr_xpos    equ 0   ;position within form
.Quig_bgr_ypos    equ 1
.Quig_bgr_adr     equ 2   ;address headers (spr_max*9+10); address of total block
.Quig_bgr_adrbmp  equ 4   ;address background bitmap
.Quig_bgr_adrtil  equ 6   ;address tile function + tile buffer
.Quig_bgr_memsiz  equ 8   ;size of the reserved additional memory
.Quig_bgr_bnk     equ 10  ;64k ram bank (1-15)
.Quig_bgr_bnkcop  equ 11  ;bit0-3 app bank, bit4-7 background bitmap bank
.Quig_bgr_enc     equ 12  ;encoding type (0 or 5); **may change after first display!**
.Quig_bgr_xbytes  equ 13  ;width in bytes; **may change after first display!**

.Quig_spr_count   equ 14  ;number of sprites
.Quig_spr_headers equ 15  ;total size of background restore headers (=number*9)

.Quig_spr_data    equ 16  ;begin of sprite data records

;sprite data sub record
.Quig_spr_flag    equ 0   ;0=not used
.Quig_spr_old_x   equ 1   ;old x position
.Quig_spr_pos_x   equ 2   ;new x position
.Quig_spr_len_x   equ 3   ;x size
.Quig_spr_old_y   equ 4   ;old y position
.Quig_spr_pos_y   equ 5   ;new y position
.Quig_spr_len_y   equ 6   ;y size
           ;equ 7   ;*reserved*
.Quig_spr_contrl  equ 8   ;points to background restore (+00) and sprite (+16) control
.Quig_spr_backgr  equ 10  ;points to background restore header
.Quig_spr_reclen  equ 12
.Quig_spr_max     equ 16
.Quig_cvs_test:
		db 2,2:ds 16-2
.Quig_cvs_sprite0:		
		db 1,00,10,0,00,16,0:ds 5
.Quig_cvs_sprite1:
		db 1,16,16,0,16,16,0:ds 5
.Quig_cvs_sprite2:
		db 1,32,32,0,32,32,0:ds 5
.Quig_cvs_sprite3:
		db 1,48,48,0,48,48,0:ds 5
.Quig_cvs_sprite4:
		db 1,00,00,0,00,00,0:ds 5
.Quig_cvs_sprite5:
		db 1,16,16,0,16,16,0:ds 5
.Quig_cvs_sprite6:
		db 1,32,32,0,32,32,0:ds 5
.Quig_cvs_sprite7:
		db 1,48,48,0,48,48,0:ds 5	

;==============================================================================
;### SPRITE ROUTINES ##########################################################
;==============================================================================

;### CVSSPR -> updates sprite and background restore controls and headers
;### Input      ix=canvas data record
;### Destroyed  AF,BC,DE,HL,IX,IY
.Quig_cvsspr:
		push 	ix

        ld 		a,(ix+Quig_bgr_enc)
        bit 	2,a
        ld 		a,3                      ;4col -> 4 pixels/byte (-1)
        jr 		z,Quig_cvsspr0
        ld 		a,1                      ;16col -> 2 pixels/byte (-1)
.Quig_cvsspr0: 
		ld 		(Quig_cvsspr9+1),a

        ld 		a,(ix+Quig_bgr_xpos)          ;patch code with background data
        ld 		(Quig_cvssprc+1),a
        ld 		(Quig_cvssprf+1),a
        ld 		a,(ix+Quig_bgr_ypos)
        ld 		(Quig_cvssprd+1),a
        ld 		(Quig_cvssprg+1),a
        ld 		a,(ix+Quig_bgr_xbytes)
        ld 		(Quig_cvsspre+1),a
        ld 		l,(ix+Quig_bgr_adrbmp+0)
        ld 		h,(ix+Quig_bgr_adrbmp+1)
        ld 		(Quig_cvssprh+1),hl

        ld 		a,(ix+Quig_spr_count)
        ld 		bc,Quig_spr_data
        add 	ix,bc
.Quig_cvsspr1:
		push 	af
        ld 		a,(ix+Quig_spr_flag)
        or 		a
        jp 		z,Quig_cvssprb                ;not active -> skip

        ld 		a,(ix+Quig_spr_contrl+0)
        ld 		iyl,a
        ld 		a,(ix+Quig_spr_contrl+1)
        ld 		iyh,a                    ;iy=controls (+00=restore old background, +16=plot sprite at new position)
        ld 		(iy+00+02),64            ;first de-activate background restore

        ld 		a,(ix+Quig_spr_old_x)     ;*** XDIF?
        sub 	(ix+Quig_spr_pos_x)
        jr 		z,Quig_cvsspr4                ;no x-dif

        jr 		c,Quig_cvsspr2
        ld 		d,a                      ;d=dif = rest-xlen
        ld 		a,(ix+Quig_spr_len_x)
        cp 		d
        jr 		c,Quig_cvsspr7                ;len<dif -> restore all
        add 	(ix+Quig_spr_pos_x)
        ld 		e,a                      ;e=len+xnew = rest-xpos
        jr 		Quig_cvsspr3
.Quig_cvsspr2:
		neg                         ;new>old
        cp 		(ix+Quig_spr_len_x)
        jr 		nc,Quig_cvsspr7               ;dif>=len -> restore all
        ld 		d,a                      ;b=dif = rest-xlen
        ld 		e,(ix+Quig_spr_old_x)
.Quig_cvsspr3: 
		ld 		a,(ix+Quig_spr_old_y)     ;*** RESTORE XDIF
        cp 		(ix+Quig_spr_pos_y)
        jr 		nz,Quig_cvsspr7               ;both x and ydif -> restore all
        ld 		c,a
        jr 		Quig_cvsspr8

.Quig_cvsspr4:
		ld 		a,(ix+Quig_spr_old_y)     ;*** YDIF?
        sub 	(ix+Quig_spr_pos_y)
        jp 		z,Quig_cvssprb                ;both no x and y dif -> skip restore

        jr 		c,Quig_cvsspr5
        ld 		b,a                      ;b=dif = rest-ylen
        ld 		a,(ix+Quig_spr_len_y)
        cp 		b
        jr 		c,Quig_cvsspr7                ;len<dif -> restore all
        add 	(ix+Quig_spr_pos_y)
        ld 		c,a                      ;c=len+ynew = rest-ypos
        jr 		Quig_cvsspr6
.Quig_cvsspr5:
		neg
        cp 		(ix+Quig_spr_len_y)
        jr 		nc,Quig_cvsspr7               ;dif>=len -> restore all
        ld 		b,a                      ;b=dif = rest-ylen
        ld 		c,(ix+Quig_spr_old_y)

.Quig_cvsspr6:
		ld 		e,(ix+Quig_spr_old_x)     ;*** RESTORE YDIF
        ld 		d,(ix+Quig_spr_len_x)
        jr 		Quig_cvsspr9

.Quig_cvsspr7:
		ld 		e,(ix+Quig_spr_old_x)     ;*** RESTORE ALL
        ld 		d,(ix+Quig_spr_len_x)
        ld 		c,(ix+Quig_spr_old_y)
.Quig_cvsspr8:
		ld 		b,(ix+Quig_spr_len_y)

.Quig_cvsspr9:
		ld 		a,0                  ;*** UPDATE controls and headers [e=rest-posx, d=rest-lenx, c=rest-posy, b=rest-leny]
        and 	e
        jr 		z,Quig_cvsspra
        ld 		l,a                      ;align to byte for xpos
        neg
        add 	e
        ld 		e,a
        ld 		a,d                      ;increase xlen, if xpos has been decreased
        add 	l
        ld 		d,a

.Quig_cvsspra:
		ld 		(iy+00+02),10            ;activate background restore
        ld 		(iy+00+10),d             ;store control xsize
        ld 		(iy+00+12),b             ;store control ysize

.Quig_cvssprc:
		ld 		a,0                      ;bgr_xpos
        add 	e
        ld 		(iy+00+06),a
        ld 		a,0
        adc 	a
        ld 		(iy+00+07),a             ;store control xpos

.Quig_cvssprd:
		ld 		a,0                      ;bgr_ypos
        add 	c
        ld 		(iy+00+08),a
        ld 		a,0
        adc 	a
        ld 		(iy+00+09),a             ;store control ypos

        ld 		h,c                      ;h=ypos
        ld 		c,b                      ;c=ysize
        push 	de                     ;(sp)=l-xpos, h-xsize
.Quig_cvsspre:
		ld 		e,0
        call 	Quig_clcmu8
.Quig_cvssprh:
		ld 		de,0                     ;bgr_adrbmp
        add 	hl,de
        ex 		de,hl                    ;de=adr of bmp+ypos
        pop 	hl
        ld 		a,h                      ;a=xsize
        ld 		h,0                      ;hl=xpos
        srl 	l                       ;hl=xbyte
        add 	hl,de
        ex 		de,hl                    ;de=adr of bmp+ypos+xbyte
        ld 		l,(ix+Quig_spr_backgr+0)      ;hl=background bitmap header
        ld 		h,(ix+Quig_spr_backgr+1)
        inc 	hl
        ld 		(hl),a                   ;store bitmap xsize
        inc 	hl
        ld 		(hl),c                   ;store bitmap ysize
        inc 	hl
        ld 		(hl),e                   ;store bitmap adr
        inc 	hl
        ld 		(hl),d

        ld 		a,(ix+Quig_spr_pos_x)
        ld 		(ix+Quig_spr_old_x),a
.Quig_cvssprf:
		add 	0                       ;bgr_xpos
        ld 		(iy+16+06),a
        ld 		a,0
        adc 	a
        ld 		(iy+16+07),a             ;store sprite xpos
        ld 		a,(ix+Quig_spr_pos_y)
        ld 		(ix+Quig_spr_old_y),a
.Quig_cvssprg:
		add 	0                       ;bgr_ypos
        ld 		(iy+16+08),a
        ld 		a,0
        adc 	a
        ld 		(iy+16+09),a             ;store sprite ypos

.Quig_cvssprb:
		ld 		de,Quig_spr_reclen
        add 	ix,de
        pop 	af
        dec 	a
        jp 		nz,Quig_cvsspr1

        pop 	ix
        ld 		c,(ix+Quig_spr_headers)
.Quig_cvsspri:
		ld 		b,0
        ld 		a,(ix+Quig_bgr_bnkcop)
        ld 		e,(ix+Quig_bgr_adr+0)
        ld 		d,(ix+Quig_bgr_adr+1)
        ld 		hl,Quig_bgrhed
        rst 	#20:dw jmp_bnkcop
        ret	

;;### CVSCOS -> collision detection between two specific sprites
;;### Input      IX=sprite1 data record within canvas data record, IY=sprite2
;;### Output     CF=1 no collision
;;###            CF=0 collision
;;### Destroyed  AF,BC,DE,L
;cvscos  ld e,(iy+spr_pos_y)     ;e=y1
;        ld a,(iy+spr_len_y)
;        add e
;        dec a
;        ld d,a                  ;d=y2
;        ld l,(iy+spr_pos_x)     ;l=x1
;        ld a,(iy+spr_len_x)
;        add l
;        dec a                   ;a=x2
;        cp (ix+spr_pos_x)
;        ret c                   ;px2<ex1 -> no collision
;        ld a,(ix+spr_pos_x)
;        add (ix+spr_len_x)
;        dec a
;        cp l
;        ret c                   ;ex2<px1 -> no collision
;        ld a,d
;        cp (ix+spr_pos_y)
;        ret c                   ;py2<ey1 -> no collision
;        ld a,(ix+spr_pos_y)
;        add (ix+spr_len_y)
;        dec a
;        cp e
;        ret		
		
;### CVSINI -> reserves a background canvas in any bank and prepares everything for the canvas engine
;### Input      A=number of sprites, E=xsize in bytes, L=xsize in pixels, H=ysize in pixels, D=encoding type, BC=tile buffer size
;###            IX=canvas data record, IY=sprite control data records
;### Output     CF=0 -> ok, A=memory/baxkground bank, HL=background address, DE=memory address, BC=memory size
;###            CF=1 -> memory full
;### Destroyed  AF,B,D

.Quig_bgrhed:  		ds 9*Quig_spr_max
.Quig_bgrhed0: 		ds 10

.Quig_cvsini:
		ld 		(ix+Quig_spr_count),a
        ld 		(Quig_bgrhed0+1),hl
        ld 		l,a
        add 	a
        add 	a
        add 	a
        add 	l
        ld 		(ix+Quig_spr_headers),a
        ld 		a,d
        ld 		(Quig_bgrhed0+9),a
        ld 		(ix+Quig_bgr_enc),a
        ld 		a,e
        ld 		(Quig_bgrhed0+0),a
        ld 		(ix+Quig_bgr_xbytes),a
        ld 		(Quig_cvstil4+1),a
        push 	bc
        ld 		e,a
        call 	Quig_clcmu8             		;hl=background bitmap size
        ld 		(Quig_bgrhed0+7),hl
        pop 	bc                  			;bc=tilebuffer size
        add 	hl,bc
        ld 		bc,9*Quig_spr_max+10+Quig_cvstil_end-Quig_cvstil0
        add 	hl,bc               			;hl=bitmap+tilebuffer+headers+plotroutine
        ld 		(ix+Quig_bgr_memsiz+0),l
        ld 		(ix+Quig_bgr_memsiz+1),h
        ld 		c,l
        ld 		b,h
        xor 	a
        ld 		e,1
        rst 	#20:dw jmp_memget
        ret 	c
        ld 		(ix+Quig_bgr_bnk),a       ;store bank
        ld 		(ix+Quig_bgr_adr+0),l     ;store total/headers address
        ld 		(ix+Quig_bgr_adr+1),h
        push 	hl
        ld 		bc,9*Quig_spr_max+10
        add 	hl,bc
        ld 		(ix+Quig_bgr_adrbmp+0),l  ;store bitmap address
        ld 		(ix+Quig_bgr_adrbmp+1),h
        ld 		(Quig_bgrhed0+3),hl
        dec 	hl
        ld 		(Quig_bgrhed0+5),hl       ;store encoding byte address
        inc 	hl
        ld 		bc,(Quig_bgrhed0+7)
        add 	hl,bc
        ld 		(ix+Quig_bgr_adrtil+0),l  ;store tile function address
        ld 		(ix+Quig_bgr_adrtil+1),h
        ld 		bc,Quig_cvstil_end-Quig_cvstil0
        add 	hl,bc
        ld 		(Quig_cvstil2+1),hl       ;store tile buffer address
        add 	a:add a:add a:add a
        ld 		hl,AppBnkNum
        add 	(hl)
        ld 		(ix+Quig_bgr_bnkcop),a    ;store src/dst bank for copying

        pop 	hl                  ;hl=headers address
        ld 		b,(ix+Quig_spr_count)
        ld 		c,(ix+Quig_bgr_bnk)
        push 	ix
        ld 		de,Quig_spr_data
        add 	ix,de
        push 	ix
.Quig_cvsini1: 
		ld 		(iy+00+2),64         ;deactivated
        ld 		(iy+00+3),c          ;header bank
        ld 		(iy+00+4),l          ;header address
        ld 		(iy+00+5),h

        ld 		a,(iy+16+10)         ;init sprite data record with form control data
        ld 		(ix+Quig_spr_len_x),a
        ld 		a,(iy+16+12)
        ld 		(ix+Quig_spr_len_y),a

        ld 		a,iyl
        ld 		(ix+Quig_spr_contrl+0),a
        ld 		a,iyh
        ld 		(ix+Quig_spr_contrl+1),a
        ld 		de,9
        add 	hl,de
        ld 		de,Quig_spr_reclen
        add 	ix,de
        ld 		de,32
        add 	iy,de
        djnz 	Quig_cvsini1

        pop 	ix
        ld 		de,Quig_bgrhed
        ;ld 		a,(ix-Quig_spr_data+Quig_spr_count)
		ld 		a,(ix-2)
.Quig_cvsini2:
		ld 		(ix+Quig_spr_backgr+0),e
        ld 		(ix+Quig_spr_backgr+1),d
        ld 		hl,Quig_bgrhed0           ;prepare restore bitmap headers
        ldi
        ex 		de,hl
        ld 		(hl),2:inc hl:inc de
        ld 		(hl),2:inc hl:inc de
        ex 		de,hl
        ld 		bc,6
        ldir
        ld 		c,Quig_spr_reclen
        add 	ix,bc
        dec 	a
        jr 		nz,Quig_cvsini2
        pop 	ix


		;***********
        ld 		c,9*Quig_spr_max+10
        call 	Quig_cvsspri
        ld 		a,(ix+Quig_bgr_bnkcop)
        ld 		e,(ix+Quig_bgr_adrtil+0)
        ld 		d,(ix+Quig_bgr_adrtil+1)
        ld 		hl,Quig_cvstil0
        ld 		bc,Quig_cvstil_end-Quig_cvstil0
        rst 	#20:dw jmp_bnkcop
		
        ld 		a,(ix+Quig_bgr_bnk)
        ld 		l,(ix+Quig_bgr_adr+0)
        ld 		h,(ix+Quig_bgr_adr+1)
        ld 		e,l
        ld 		d,h
        ld 		bc,9*Quig_spr_max
        add 	hl,bc
        ld 		c,(ix+Quig_bgr_memsiz+0)
        ld 		b,(ix+Quig_bgr_memsiz+1)
        ret		

;### CVSTSH -> plots tile into canvas and shows it on the screen
;### Input      A,HL=tile header bank and address, IX=canvas data record, C=xpos inside canvas in bytes, B=ypos inside canvas in pixels
;###            IYL=tile xsize in pixels, IYH=tile ysize in pixels
;###            E=canvas control ID, D=window ID
;### Destroyed  AF,BC,DE,HL,IX,IY
.Quig_cvstsh:
;DE=XPos,HL=Ypos

.Quig_Canvas_Tile_Draw:
		ld		b,l							;Get YPos
		
		ld 		a,(Quig_cvs_test+Quig_bgr_enc)
        or 		a
        jr 		nz,Quig_Canvas_Tile_Draw_16          ;4col cpc
.Quig_Canvas_Tile_Draw_4:		
		ld		a,e
		rra		a
		rra		a
		and		%111111
.Quig_Canvas_Tile_Draw_16:		
		ld		a,e
		rra		a
		and		%1111111
.Quig_Canvas_Tile_Draw_X:	
		ld		c,a							;Get XPos Byte (not e)

;		push 	de
;        push 	ix
;        push 	iy
;        push 	bc
;        call 	Quig_cvstil
;        pop 	bc          ;c=xofs, b=yofs
;        pop 	ix          ;ixl=xsiz, ixh=ysiz
;        pop 	iy
;        ld 		e,0
;        ld 		a,c
;        add 	(iy+Quig_bgr_xpos)
;        ld 		l,a
;        ld 		a,e
;        adc 	a
;        ld 		h,a          ;hl=xbeg
;        ld 		a,b
;        add 	(iy+Quig_bgr_ypos)
;        ld 		c,a
;        ld 		a,e
;        adc 	a
;        ld 		b,a          ;bc=ybeg
;        ld 		a,ixh
;        ld 		ixh,e        ;ix=xlen
;        ld 		iyl,a
;        ld 		iyh,e        ;iy=ylen
;        pop 	de
;        ld 		a,d
;        jp 		SyDesktop_WINPIN


.Quig_Canvas_Tile:
;ST2=Tile Bank, ST1=TileNumber, DE=XPos,HL=Ypos	
;		ld		b,l							;Get YPos
;		ld		c,e							;Get XPos Byte
		pop		iy							;Return Address
		pop		hl							;Tile Number
		ld		e,l							;Temp DE=HL
		ld		d,h		
		add		hl,hl						;*2		
		add		hl,hl						;*4
		add		hl,hl						;*8
		add		hl,de						;*9
		pop		de							;Get Address
		push	bc							;Stores BC Width Height
		
		inc		de							
		inc		de
		inc		de
		inc		de
		inc		de
		ld		a,(de)						;bank	
		ld		(Quig_Canvas_Tile2+1),a
		inc		de
		ld		a,(de)						;Start Address low
		ld		c,a
		inc		de
		ld		a,(de)						;Start Address High
		ld		b,a
.Quig_Canvas_Tile2:		
		ld		a,0

		add		hl,bc						;Address of Graphic Header AS=Bank; HL=Address		
		pop		bc
		ld 		ix,Quig_cvs_test
		push	iy							;Push Return Address
		jp		Quig_cvstil
		
;### CVSTIL -> plots tile into canvas
;### Input      A,HL=tile header bank and address, IX=canvas data record, C=xpos inside canvas in bytes, B=ypos inside canvas in pixels
;### Destroyed  AF,BC,DE,HL,IX,IY
.Quig_cvstilh ds 9

.Quig_cvstil:
		push 	bc
        push 	af

        ld 		c,a
        ld 		a,(AppBnkNum)
        add 	a:add a:add a:add a
        add 	c
        ld 		de,Quig_cvstilh
        ld 		bc,9
        rst 	#20:dw jmp_bnkcop   ;get tile header

        ld 		l,(ix+Quig_bgr_adrtil+0)
        ld 		h,(ix+Quig_bgr_adrtil+1)
        ld 		(Quig_cvstil1+2),hl
        ld 		de,Quig_cvstil_end-Quig_cvstil0
        add 	hl,de
        ex 		de,hl
        ld 		hl,(Quig_cvstilh+3)
        ld 		a,(ix+Quig_bgr_bnk)
        add 	a:add a:add a:add a
        pop 	bc
        add 	b
        ld 		bc,(Quig_cvstilh+7)
        rst 	#20:dw jmp_bnkcop   		;copy tile bitmap to tile buffer

        pop 	bc
        ld 		e,b                  		;e=ypos
        ld 		h,(ix+Quig_bgr_xbytes)
        call 	Quig_clcmu8             	;hl=ypos oft
        ld 		b,0                  ;bc=xpos in bytes
        add 	hl,bc
        ld 		c,(ix+Quig_bgr_adrbmp+0)
        ld 		b,(ix+Quig_bgr_adrbmp+1)
        add 	hl,bc               ;hl=destination adr in background bitmap

        ld 		a,(Quig_cvstilh+0)
        ld 		e,a                  ;e=xsize
        ld 		a,(Quig_cvstilh+2)
        ld 		d,a                  ;d=ysize
.Quig_cvstil6:		
        ld 		b,(ix+Quig_bgr_bnk)       ;b=bank
.Quig_cvstil1: 
		ld 		ix,0                 ;ix=routine address
        ld 		iy,#fff4
        push 	bc
        push 	de
        push 	hl
        call 	jmp_bnklok
        pop 	hl
        pop 	de
        pop 	af
        inc 	c
        ret 	nz
        ld 		b,a
        rst 	#30
        jr 		Quig_cvstil1


;hl=dest adr, e=xsize, d=ysize
.Quig_cvstil0:
		jr 		Quig_cvstil5
;hl=bmpadr, de=bmplen-1
        ld 		c,e
        ld 		b,d
        ld 		e,l
        ld 		d,h
        inc 	de
        ldir
        jp 		#ff0c    ;c is 0 here
.Quig_cvstil5:
;hl=dest adr, e=xsize, d=ysize
;.Quig_cvstil0:
		push 	de
        pop 	ix
.Quig_cvstil2: 
		ld 		de,0                 ;de=src adr
        ex 		de,hl
.Quig_cvstil3:
		ld 		c,ixl
        ld 		b,0
        push 	de
        ldir
        pop 	de
        ex 		de,hl
.Quig_cvstil4: 
		ld 		c,0                  ;bc=bgr xlen
        add 	hl,bc
        ex 		de,hl
        dec 	ixh
        jr 		nz,Quig_cvstil3
        ld 		c,b
        jp 		#ff0c
.Quig_cvstil_end:


;### CVSFIL -> fills canvas with colour
;### Input      IX=canvas data record, C=colour (0-15)
.Quig_Canvas_Fill:
		ld		a,l
		and		%1111
		ld		c,a
		ld		ix,Quig_cvs_test
.Quig_cvsfil:
		ld 		a,(ix+Quig_bgr_enc)
        or 		a
        jr 		z,Quig_cvsfil3            ;4col cpc
        cp 		#11
        jr 		z,Quig_cvsfil3            ;4col cpc downrendered
        bit 	2,a
        jr 		z,Quig_cvsfil2            ;4col msx

        ld 		a,c                  ;* 16col msx
.Quig_cvsfil1:
		add 	a:add a:add a:add a
        add 	c
        jr 		Quig_cvsfil5
.Quig_cvsfil2:
		ld 		a,c                  ;* 4col msx
        and 	3
        ld 		c,a
        add 	a:add a
        add 	c
        ld 		c,a
        jr 		Quig_cvsfil1
.Quig_cvsfil3 
		xor 	a                   ;* 4col cpc
        rr 		c
        jr 		nc,Quig_cvsfil4
        ld 		a,#f0
.Quig_cvsfil4:
		rr 		c
        jr 		nc,Quig_cvsfil5
        add 	#0f
.Quig_cvsfil5:
		ld 		b,a
        ld 		l,(ix+Quig_bgr_adrtil+0)
        ld 		h,(ix+Quig_bgr_adrtil+1)
        inc 	hl:inc hl
        ld 		(Quig_cvstil1+2),hl
        ld 		l,(ix+Quig_bgr_adrbmp+0)
        ld 		h,(ix+Quig_bgr_adrbmp+1)
        ld 		a,(ix+Quig_bgr_bnk)
        rst 	#20:dw jmp_bnkwbt
        ld 		bc,-4
        add 	hl,bc
        rst 	#20:dw jmp_bnkrwd
        inc 	hl
        ld 		e,c
        ld 		d,b
		dec		de
        jp 		Quig_cvstil6	
		
		

		

;### CLCMU8 -> 8x8bit unsigned multiplication
;### Input      H,E=values
;### Output     HL=H*E, B=0
;### Destroyed  AF,B,D
.Quig_clcmu8:
		ld 		d,0
        sla 	h
        sbc 	a
        and 	e
        ld 		l,a
        ld 		b,7
.Quig_clcmu81: 
		add 	hl,hl
        jr 		nc,Quig_clcmu82
        add 	hl,de
.Quig_clcmu82: 
		djnz 	Quig_clcmu81
        ret
		
		

;LIBRARY QUIG.LONG.FUNCLETHL
.Quig_Long_FuncLetHL:
		push 	de
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		call	Quig_Long_Stack_HL_Check		;Checks if HL is on stack and decreases Pointer if so		
		ld		a,(hl)
		ld		(ix+0),a
		inc		hl
		ld		a,(hl)
		ld		(ix+1),a
		inc		hl
		ld		a,(hl)
		ld		(ix+2),a
		inc		hl
		ld		a,(hl)
		ld		(ix+3),a		
		pop		de
		ret
.Quig_Long_FuncLetDE:
		push 	hl
		ex		de,hl
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		call	Quig_Long_Stack_HL_Check		;Checks if HL is on stack and decreases Pointer if so		
		ld		a,(hl)
		ld		(ix+0),a
		inc		hl
		ld		a,(hl)
		ld		(ix+1),a
		inc		hl
		ld		a,(hl)
		ld		(ix+2),a
		inc		hl
		ld		a,(hl)
		ld		(ix+3),a		
		pop		hl
		ret		
	
;LIBRARY QUIG.LETLONG
.Quig_LetLong:	
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		call	Quig_Long_Stack_HL_Check		;Checks if HL is on stack and decreases Pointer if so
		ldi
		ldi
		ldi
		ldi
		ret
;LIBRARY QUIG.INT.FROMLONG		
.Quig_Int_FromLong:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		call	Quig_Long_Stack_HL_Check		;Checks if HL is on stack and decreases Pointer if so
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		ret
;LIBRARY QUIG.LONG.FROMINT
.Quig_Long_FromInt:
		ld 		a,h
		ex		de,hl
		add 	a
		sbc 	a
		ld		hl,(Quig_Math_StackPointer)
		push	hl
		ld 		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(hl),a
		inc		hl
		ld		(Quig_Math_StackPointer),hl
		pop		hl
		ret
	
	
;LIBRARY QUIG.LONG.STACK.DEHL.CHECK		
.Quig_Long_Stack_HL_Check:
		ld		bc,Quig_Math_Stack
		push	hl						;Keep HL content
		xor		a						;Set Carry to 0
		sbc		hl,bc					;Sets carry is HL Pointer < Stack Top		
		cp		h
		jr		nz,Quig_Long_Stack_DEHL_Check2
		ld		bc,-4
		ld		hl,(Quig_Math_StackPointer)
		add		hl,bc
		ld		(Quig_Math_StackPointer),hl	
.Quig_Long_Stack_DEHL_Check2:
		pop		hl
		ret		
;LIBRARY QUIG.LONG.STACK.INCREMENT
.Quig_Long_Stack_Increment:
        ld 		hl,(Quig_Math_StackPointer)
        push 	hl	
        ld 		(hl),e
        inc 	hl
        ld 		(hl),d
        inc 	hl
        ld 		(hl),c
        inc 	hl
        ld 		(hl),b
        inc 	hl
		ld		(Quig_Math_StackPointer),hl
		pop		hl
		ret
;LIBRARY QUIG.LONG.ADD		
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Add:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT	
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib	QUIG.LONG.PARAMS
        call 	Quig_long_params
        call 	long_add       ;bcde=ixhl+bcde
		jp		Quig_Long_Stack_Increment
.long_add:
        add 	hl,de
        ex 		de,hl
        push 	ix
        pop 	hl
        adc 	hl,bc
        ld 		c,l
        ld 		b,h
        ret		

;LIBRARY QUIG.LONG.SUB
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Sub:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT	
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib	QUIG.LONG.PARAMS
        call 	Quig_long_params
        call 	long_sub       ;bcde=ixhl-bcde
		jp		Quig_Long_Stack_Increment
.long_sub:
        or 		a
        sbc 	hl,de
        ex 		de,hl
        push 	ix
        pop 	hl
        sbc 	hl,bc
        ld 		c,l
        ld 		b,h
        ret
;LIBRARY QUIG.LONG.MUL
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Mul:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib 	QUIG.LONG.PARAMS
        call 	Quig_long_params
        call 	long_mul       ;bcde=ixhl*bcde
		jp		Quig_Long_Stack_Increment
.long_mul:
        ld 		a,b              
        xor 	ixh
        push 	af             ;store combined sign
		inclib 	QUIG.LONG.ABS
        call 	Quig_long_abs
        ld 		a,b:or c         ;one par should be 16bit or less
        jr 		z,long_muld
        ld 		a,ixl:or ixh
        jr 		z,long_mule
		inclib	QUIG.LONG.RESULT.NEGSIGN
        jp 		Quig_long_result_sign ;both >16bit -> overflow
.long_muld:
        ex 		de,hl            ;swap pars
        ld 		c,ixl
        ld 		b,ixh
.long_mule:                   ;bc,de=par1,hl=par2
        ld 		ix,0             ;**** BEG 32*16b UNSIGNED MULTIPLICATION
        ld 		iy,0             ;(iyix=bcde*hl)
        ld 		a,16
        jr 		long_mul3
.long_mul1:
        add 	ix,ix
        push 	af
        add 	iy,iy
        pop 	af
        jr 		nc,long_mul3
        inc 	iy
.long_mul3:
        rl 		l
        rl 		h
        jr 		nc,long_mul4
        add 	ix,de
        jr 		nc,long_mul2
        inc 	iy
.long_mul2:
        add 	iy,bc
.long_mul4:
        dec 	a
        jr 		nz,long_mul1     ;**** END
        ld 		e,ixl
        ld 		d,ixh
        ld 		c,iyl
        ld 		b,iyh            ;bcde=result
        jp 		quig_long_result_sign

;LIBRARY QUIG.LONG.PARAMS		
;ixhl=(de), bcde=(hl)
.Quig_long_params:
        ld 		iyl,e
        ld 		iyh,d
        ld 		e,(hl)
        inc 	hl
        ld 		d,(hl)
        inc 	hl
        ld 		c,(hl)
        inc 	hl
        ld 		b,(hl)
        ld 		l,(iy+2)
        ld 		h,(iy+3)
        push 	hl
        ld 		l,(iy+0)
        ld 		h,(iy+1)
        pop 	ix
        ret
;LIBRARY QUIG.LONG.ABS
;ixhl=abs(ixhl), bcde=abs(debc)
.quig_long_abs
		inclib 	QUIG.LONG.RESULT.NEGSIGN
        bit 	7,b
        call 	nz,quig_long_result_neg
        ld 		a,ixh
        bit 	7,a
        ret 	z
        ld 		a,l:cpl:ld l,a   ;par1=abs(par1)
        ld 		a,h:cpl:ld h,a
        ld 		a,ixl:cpl:ld ixl,a
        ld 		a,ixh:cpl:ld ixh,a
        inc 	hl
        ld 		a,l
        or 		h
        ret 	nz
        inc 	ix
        ret

;LIBRARY QUIG.LONG.RESULT.NEGSIGN
;corrects sign, if necessary
.quig_long_result_sign:
        pop 	af
        ret 	p               ;combined sign is pos -> finished		
.quig_long_result_neg
        ld 		a,e:cpl:ld e,a   ;combined sign is neg -> result=-result
        ld 		a,d:cpl:ld d,a
        ld 		a,c:cpl:ld c,a
        ld 		a,b:cpl:ld b,a
        inc 	de
        ld 		a,e
        or 		d
        ret 	nz
        inc 	bc
        ret		

;LIBRARY QUIG.LONG.DIV
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Div:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT	
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib 	QUIG.LONG.PARAMS
        call 	Quig_long_params
        call 	long_div       ;bcde=ixhl/bcde
		jp		Quig_Long_Stack_Increment
;### LONG_DIV
;### bcde=ixhl/bcde
.long_div:
        ld 		a,b              
        xor 	ixh
        push 	af             ;store combined sign
        call 	long_div0
        ld 		a,(iy+0):rla:cpl:ld e,a
        ld 		a,(iy+1):rla:cpl:ld d,a
        ld 		a,(iy+2):rla:cpl:ld c,a
        ld 		a,(iy+3):rla:cpl:ld b,a
		inclib	QUIG.LONG.RESULT.SIGN
        jp 		Quig_long_result_sign
.long_div_buf:ds 		4
.long_div0:
		inclib	QUIG.LONG.ABS
        call 	Quig_long_abs
        ld 		iy,long_div_buf
        ld 		(long_div_buf+0),hl
        ld 		(long_div_buf+2),ix  ;(long_div_buf)=par1
        ld 		(long_div2+1),de
        ld 		(long_div3+1),bc
        ld 		(long_div4+1),de
        ld 		(long_div5+1),bc     ;(code)=par2
        ld 		hl,0
        ld 		de,0                 ;dehl=calcvalue
        ld 		a,32
.long_div1:
        rl 		(iy+0)
        rl 		(iy+1)
        rl 		(iy+2)
        rl 		(iy+3)
        adc 	hl,hl
        ex 		de,hl
        adc 	hl,hl
        ex 		de,hl
.long_div2:
        ld 		bc,0
        sbc 	hl,bc
.long_div3:
        ld 		bc,0
        ex 		de,hl
        sbc 	hl,bc
        ex 		de,hl
        jr 		nc,long_div6
.long_div4:
        ld 		bc,0
        add 	hl,bc
.long_div5:
        ld 		bc,0
        ex 		de,hl
        adc 	hl,bc
        ex 		de,hl
.long_div6:
        dec 	a
        jr 		nz,long_div1
        ret		
;LIBRARY QUIG.LONG.MOD
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Mod:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREASE	
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
        call 	Quig_long_params
        call 	Quig_long_mod       ;bcde=ixhl MOD bcde
		jp		Quig_Long_Stack_Decrement

;LIBRARY QUIG.LONG.AND
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_And:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib	QUIG.LONG.PARAMS
        call 	Quig_long_params
        call 	long_and       ;bcde=ixhl AND bcde
		jp		Quig_Long_Stack_Increment
.long_and:
        ld 		a,  l:and e:ld e,a
        ld 		a,  h:and d:ld d,a
        ld 		a,ixl:and c:ld c,a
        ld 		a,ixl:and b:ld b,a
        ret

;LIBRARY QUIG.LONG.OR
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Or:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT	
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib	QUIG.LONG.PARAMS
        call 	Quig_long_params
        call 	long_or       ;bcde=ixhl OR bcde
		jp		Quig_Long_Stack_Increment
.long_or:
        ld 		a,  l:or e:ld e,a
        ld 		a,  h:or d:ld d,a
        ld 		a,ixl:or c:ld c,a
        ld 		a,ixl:or b:ld b,a
        ret		
;LIBRARY QUIG.LONG.XOR
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Xor:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib	QUIG.LONG.PARAMS
        call 	Quig_long_params
        call 	long_xor       ;bcde=ixhl XOR bcde
		jp		Quig_Long_Stack_Increment
.long_xor:
        ld 		a,  l:xor e:ld e,a
        ld 		a,  h:xor d:ld d,a
        ld 		a,ixl:xor c:ld c,a
        ld 		a,ixl:xor b:ld b,a
        ret	
;LIBRARY QUIG.LONG.CMP
;### LONG_CMP
;### ixhl=bcde -> ZF=1, CF=0
;### ixhl<bcde -> ZF=0, CF=1
;### ixhl>bcde -> ZF=0, CF=0
;### HL=0
.Quig_long_cmp:
        ld 		a,ixh
        add 	128
        ld 		ixh,a
        ld 		a,b
        add 	128
        ld 		b,a          ;min=0, max=2^32-1
		
		or 		a
        sbc 	hl,de
        ex 		de,hl
        push 	ix
        pop 	hl
        sbc 	hl,bc
        ld 		c,l
        ld 		b,h
		
        ;call 	Quig_long_sub
        ld 		hl,0
        ret 	c
        ret 	nz
        ld 		a,e
        or 		d
        ret
;IN HL = Pointer to 4 bytes data
;   DE = Pointer to 4 bytes Data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Equals:
		call	Quig_Long_CompareAll
        ret 	nz
        inc 	l
        ret	
.Quig_Long_CompareAll:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT	
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		ex		de,hl
		call	Quig_Long_Stack_HL_Check
		inclib	QUIG.LONG.PARAMS
        call 	Quig_long_params
        jp 		Quig_long_cmp		
		
.Quig_Long_Nequals:
		call	Quig_Long_CompareAll
        ret 	z
        inc 	l
        ret
.Quig_Long_Gt:
		call	Quig_Long_CompareAll
        ret 	z
        ret 	c
        inc 	l
        ret	
.Quig_Long_Gte:
		call	Quig_Long_CompareAll
        ret c
        inc l
        ret	
.Quig_long_lte
		call	Quig_Long_CompareAll
        ld l,1
        ret z
        ret c
        dec l
        ret		
.Quig_long_lt
		call	Quig_Long_CompareAll
        ret nc
        inc l
        ret		
		

;LIBRARY QUIG.LONG.NEG
;IN HL = Pointer to 4 bytes data
;   (Quig_Math_StackPointer) = Position on Stack to store result - jumpt too Quig_Long_Stack_Decrement for this	
.Quig_Long_Neg:
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib 	QUIG.LONG.STACK.INCREMENT	
		call	Quig_Long_Stack_HL_Check
        ld 		e,(hl)
        inc 	hl
        ld 		d,(hl)
        inc 	hl
        ld 		c,(hl)
        inc 	hl
        ld 		b,(hl)

		inclib 	QUIG.LONG.RESULT.NEGSIGN
		call	Quig_Long_result_neg		;bcde=NEG(bcde)
		jp		Quig_Long_Stack_Increment
	
;LIBRARY QUIG.HL2IXDE
.Quig_HL2IXDE:
		ld 		a,(hl):ld ixl,a:inc hl
		ld 		a,(hl):ld ixh,a:inc hl
		ld 		e,(hl):inc hl
		ld 		d,(hl)
		ret

;LIBRARY QUIG.LONG2STRING
;IN (HL) is a pointer to 4 byte LONG Value
.Quig_Long2String
        ld      iy,(Quig_String_Buffer_Pos)
        push    iy
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		call	Quig_Long_Stack_HL_Check		;Checks if HL is on stack and decreases Pointer if so		
		INCLIB	QUIG.HL2IXDE
		call	Quig_HL2IXDE
		INCLIB 	QUIG.CNV32S
		call	Quig_cnv32s
		inc		iy
		inc		iy
;		di
;.wuue	jr		wuue		
		ld		(Quig_String_Buffer_Pos),iy
		pop		hl
		ret
		
;LIBRARY QUIG.CNV32S
;### CNV32S -> Converts 32Bit-number (signed) to string (terminated by 0)
;### Input      DE,IX=value, IY=destination address
;### Output     IY=Address of last char
;### Destroyed  AF,BC,DE,HL,IX
.Quig_cnv32s:
		bit 	7,d
        jr 		z,Quig_cnv32u
        ld 		(iy+0),"-"
        inc 	iy
        ld 		a,ixl:cpl:ld ixl,a
        ld 		a,ixh:cpl:ld ixh,a
        db		#dd,#a5			;and 	ixl
        inc 	a
        ld 		a,e:cpl:ld e,a
        ld 		a,d:cpl:ld d,a
        inc 	ix
        jr 		nz,Quig_cnv32u
        inc 	de
        jr 		Quig_cnv32u
;### CNV32U -> Converts 32Bit-number (unsigned) to string (terminated by 0)
;### Input      DE,IX=value, IY=destination address
;### Output     IY=Address of last char
;### Destroyed  AF,BC,DE,HL,IX
.Quig_cnv32ut:
		dw 		1,0,     10,0,     100,0,     1000,0,     10000,0
        dw 		#86a0,1, #4240,#f, #9680,#98, #e100,#5f5, #ca00,#3b9a
.Quig_cnv32uz: 	ds 4

.Quig_cnv32u:
		ld 		(Quig_cnv32uz),ix
        ld 		(Quig_cnv32uz+2),de
        ld 		ix,Quig_cnv32ut+36
        ld 		b,9
        ld 		c,0
.Quig_cnv32u1:
		ld 		a,"0"
        or 		a
.Quig_cnv32u2:
		ld 		e,(ix+0):ld d,(ix+1):ld hl,(Quig_cnv32uz):  sbc hl,de:ld (Quig_cnv32uz),hl
        ld 		e,(ix+2):ld d,(ix+3):ld hl,(Quig_cnv32uz+2):sbc hl,de:ld (Quig_cnv32uz+2),hl
        jr 		c,Quig_cnv32u5
        inc 	c
        inc 	a
        jr 		Quig_cnv32u2
.Quig_cnv32u5: 
		ld 		e,(ix+0):ld d,(ix+1):ld hl,(Quig_cnv32uz):  add hl,de:ld (Quig_cnv32uz),hl
        ld 		e,(ix+2):ld d,(ix+3):ld hl,(Quig_cnv32uz+2):adc hl,de:ld (Quig_cnv32uz+2),hl
        ld 		de,-4
        add 	ix,de
        inc 	c
        dec 	c
        jr 		z,Quig_cnv32u3
        ld 		(iy+0),a
        inc 	iy
.Quig_cnv32u3: 
		djnz 	Quig_cnv32u1
        ld 		a,(Quig_cnv32uz)
        add 	"0"
        ld 		(iy+0),a
        ld 		(iy+1),0
        ret	
	
;******************************	
;****************************** FLOATING POINT STUFF ****************************
;******************************


;LIBRARY SYB.DSPGET
;==============================================================================
;### DISPLAY-ROUTINES #########################################################
;==============================================================================
;### DSPGET -> converts 5byte floating point value to display format
;### Input  DE=pointer to 5byte floating point value
.DspGet
		jr		dspget99
.dspvaltmp   ds 5+1
.dspvalnum   ds 10+1
.dspvallen   db 0
.dspvalsgn   db 0        ;0=positive; display no sign, -1=minus
.dspvalexp   db 0        ;exponent (signed)
.dspvaldig   equ 10      ;maximum amount of displayed mantissa digits
.dspchrflg   db 0        ;flag (input), if 1000 points should be displayed
.dspfeflg    db 0        ;flag (input), if force exponent display
.dspchrcom   db "."      ;symbol for 1000 points
.dspchrpoi   db ","      ;symbol for comma
.dspintflg   db 0        ;flag (result), if displayed number is integer
.dspget99:
		inclib  SYB.FLOAT.ROUTINES	
		ld 		hl,0
        ld 		(dspvalsgn),hl
        ld 		hl,dspvaltmp
        call 	FLO_MOVE
        call 	FLO_PREPARE		
        ld 		a,b
        Or 		a
        jr 		z,dspget3
        And 	128
        add 	a
        sbc 	0
        ld 		(dspvalsgn),a
        ld 		a,e
        ld 		(dspvalexp),a
        ld 		ix,(dspvaltmp+0)
        ld 		de,(dspvaltmp+2)
        db 		#dd:ld a,l
        db 		#dd:Or h		
        Or 		e
        Or 		d
        jr 		z,dspget3
		ld 		iy,dspvalnum

		call 	clcn32
 
        push 	iy
		pop hl
        ld 		bc,dspvalnum-1
        Or 		a
        sbc 	hl,bc
        ld 		c,l
        ld 		a,"0"
        ld 		hl,dspvalexp

.dspget1
		cp 		(iy+0)
        jr 		nz,dspget2
        ld 		(iy+0),0
        dec 	iy
        inc 	(hl)
        dec 	c
        jr 		nz,dspget1
.dspget2
		ld 		a,c
.dspget3
		ld 		(dspvallen),a
        ret

;### DSPTXT -> converts display format value to text and displays it
.dsptxt
		Xor 	a
        ld 		(dspintflg),a
        ld 		a,(dspvalsgn)        ;*** Sign
        inc 	a
        jr 		nz,dsptxt1
        ld 		(hl),"-"
        inc 	hl
.dsptxt1
		ex 		de,hl
        ld 		a,(dspvallen)        ;*** Test, if value=0
        Or 		a
        jr 		nz,dsptxti
.dsptxty
		ld 		a,"0"                ;display only 0.
        ld 		(de),a
        inc 	de
        jr 		dsptxth
.dsptxti
		ld 		hl,dspvalnum
        ld 		a,(dspfeflg)
        Or 		a
        jr 		nz,dsptxt6           ;display exponent, if in RO mode and F-E on
        ld 		a,(dspvalexp)        ;*** Exponent
        ld 		b,a
        Or 		a
        ld 		a,(dspvallen)
        ld 		c,a
        jp 		m,dsptxta
        add	 	b                   ;*** Exponent positive -> exp display, if dspvallen + dspvalexp <= dspvaldig
        cp 		dspvaldig+1          ;a=length of complete number
        jr 		nc,dsptxt6
        ld 		b,a                  ;*** Display mantissa without comma (a,b=length of mantissa before comma)
        ld 		a,1
        ld 		(dspintflg),a
        ld 		a,b
.dsptxt2
		sub 	3
        jr 		z,dsptxtf
        jr 		nc,dsptxt2
.dsptxtf
		add 	3
        ld 		c,a                  ;c=1000 counter
.dsptxt3
		ld 		a,(hl)
        inc 	hl
        Or 		a
        jr 		nz,dsptxt4
        ld 		a,"0"
        dec 	hl
.dsptxt4
		call 	dsptxt5
        jr 		nz,dsptxt3
.dsptxth
		ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        Xor 	a
        ld 		(de),a
        ret
.dsptxt6
		ld 		a,(hl)               ;**** Display mantissa with exponent
        ld 		(de),a
        inc 	hl
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ld 		a,(dspvallen)
.dsptxt7
		dec 	a
        jr 		z,dsptxt8
        ldi
        jr 		dsptxt7
.dsptxt8
		ex 		de,hl
        ld 		(hl),"e"
        inc 	hl
        ld 		a,(dspvallen)        ;exp display = -(exp + mantissa length - 1)
        ld 		c,a
        ld 		a,(dspvalexp)
        add 	c
        dec 	a
        ld 		(hl),"+"
        jp 		p,dsptxt9
        ld 		(hl),"-"
        neg
.dsptxt9
		inc 	hl
        ex 		de,hl
        call 	clcdez
        ex 		de,hl
        ld 		(hl),e
        inc 	hl
        ld 		(hl),d
        inc 	hl
        ld 		(hl),0
        ret
.dsptxta
		add 	b                   ;*** Comma negative (a,c=len, b=comma -> a=len-neg comma)
        jr 		c,dsptxtb
        neg                     ;a=-(len+exp) [=distance between comma and first digit]
        ld 		b,a
        add 	c                   ;a=new number of digits-1
        cp 		dspvaldig+1
        jr 		nc,dsptxt6           ;too large -> display with exponent
        call 	dsptxte
        ld 		a,"0"
.dsptxtg
		ld 		(de),a
        inc 	de
        djnz 	dsptxtg
        jr 		dsptxtd
.dsptxtb
		jr 		z,dsptxtc            ;*** Display negative comma without exponent
        ld 		b,a
        call 	dsptxt2
        jr 		dsptxtd
.dsptxtc
		call 	dsptxte
.dsptxtd
		ld 		a,(hl)
        ldi
        Or 		a
        jr 		nz,dsptxtd
        ret
.dsptxte
		ld 		a,"0"
        ld 		(de),a
        inc 	de
        ld 		a,(dspchrcom)
        ld 		(de),a
        inc 	de
        ret
.dsptxt5
		ld 		(de),a               ;adds a digit (in A) and inserts a point, if needed
        inc 	de
        dec 	b
        ret 	z
        dec 	c
        ret 	nz
        ld 		a,(dspchrflg)
        dec 	a
        ret 	nz
        ld 		a,(dspchrpoi)
        ld 		(de),a
        inc 	de
        ld 		c,3+1
        dec 	c
        ret
		
		
;LIBRARY QUIG.FLOAT.COPYSLOT
;IN DE=FLO_HL_COPY or FLO_DE_COPY
;   HL=Address to copy from
.Quig_Float_CopyToSlot:
		push	de
		ld		bc,Quig_Math_Stack
		push	hl						;Keep HL content
		xor		a						;Set Carry to 0
		sbc		hl,bc					;Sets carry is HL Pointer < Stack Top
		cp		h
		jr		nz,Quig_Float_CopyToSlot2
		ld		bc,-5
		ld		hl,(Quig_Math_StackPointer)
		add		hl,bc
		ld		(Quig_Math_StackPointer),hl	
.Quig_Float_CopyToSlot2:
		pop		hl
		ldi
		ldi
		ldi
		ldi
		ldi
		pop		hl
		ret
		
;LIBRARY QUIG.LETFLOAT
.Quig_LetFloat:	
		inclib 	QUIG.FLOAT.REDUCE.STACK
		call	Quig_Float_Reduce_Stack		;Checks if HL is on stack and decreases Pointer if so
		ldi
		ldi
		ldi
		ldi
		ldi
		ret		
		
;LIBRARY QUIG.FLOAT.REDUCE.STACK
.Quig_Float_Reduce_Stack:
		ld		bc,Quig_Math_Stack	
		push	hl						;Keep HL content
		xor		a						;Set Carry to 0
		sbc		hl,bc					;Sets carry is HL Pointer < Stack Top
		cp		h
		jr		nz,Quig_Float_Reduce_Stack2
		ld		hl,(Quig_Math_StackPointer)				
		ld		bc,-5
		add		hl,bc
		ld		(Quig_Math_StackPointer),hl	
.Quig_Float_Reduce_Stack2:
		pop		hl
		ret

;LIBRARY QUIG.FLOAT.COPYHL.STACK
.Quig_Float_CopyHL_Stack:
		inclib	QUIG.FLOAT.ROUTINES
		inclib	QUIG.FLOAT.COPYSLOT		
		ld		de,FLO_HL_COPY
		call	Quig_Float_CopyToSlot
		ret
;LIBRARY QUIG.FLOAT.COPYDEHL_STACK
.Quig_Float_CopyDEHL_Stack:
		inclib	QUIG.FLOAT.ROUTINES
		inclib	QUIG.FLOAT.COPYSLOT		
		push	de
		ld		de,FLO_DE_COPY
		call	Quig_Float_CopyToSlot
		pop		hl
		ld		de,FLO_HL_COPY
		call	Quig_Float_CopyToSlot
		ld		de,FLO_DE_COPY
		ret
;LIBRARY QUIG.FLOAT.RESULT2STACK
.Quig_Float_Result2Stack:		
		ld		hl,FLO_HL_COPY
		ld		de,(Quig_Math_StackPointer)
		push	de
		ldi
		ldi
		ldi
		ldi
		ldi
		ld		(Quig_Math_StackPointer),de
		pop		hl
		ret

;### Output     A=Result [-1 -> (HL)<(DE), 0 -> (HL)=(DE), 1 -> (HL)>(DE)]
;###            ZF=1 -> (HL)=(DE), CF=1 -> (HL)<(DE)
;LIBRARY QUIG.FLOAT.EQUALS		
.Quig_Float_Equals:	
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_VGL
		ld		hl,0
		ret		nz
		inc		l
		ret
;LIBRARY QUIG.FLOAT.NEQUALS		
.Quig_Float_NEquals:	
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_VGL
		ld		hl,0
		ret		z
		inc		l
		ret
;LIBRARY QUIG.FLOAT.GTE		
.Quig_Float_Gte:	
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_VGL
		ld		hl,0
		ret		c
		inc		l
		ret	
;LIBRARY QUIG.FLOAT.LTE	
.Quig_Float_Lte:	
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_VGL
		ld		hl,0
		jr		z,Quig_Float_Lte2
		ret		nc
.Quig_Float_Lte2:		
		inc		l
		ret	
;LIBRARY QUIG.FLOAT.GT	
.Quig_Float_Gt:	
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_VGL
		ld		hl,0
		cp		1
		ret		nz		
		inc		l
		ret	
;LIBRARY QUIG.FLOAT.LT	
.Quig_Float_Lt:	
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_VGL
		ld		hl,0
		cp		-1
		ret		nz		
		inc		l
		ret

;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### Input      (HL)=FLO value
;### Output     HL=abs((HL)), A[bit7]=sign
;LIBRARY QUIG.FLOAT2INT
.Quig_Float2Int:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_ROUND_FLO_TO_HLA
		bit		7,a
		jr		nz,Quig_Float2Int2
		res		7,h
		ret
.Quig_Float2Int2:
		res 	7,h
		ld		a,l
		xor		255
		ld		l,a
		ld		a,h
		xor		255
		ld		h,a
		inc		hl		
		ret
		
;LIBRARY QUIG.LONG2FLOAT
.Quig_Long2Float:
;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### Input      (HL)=LW, A[bit7]=sign
;### Output     (HL)=FLO value
;### Unchanged  BC,DE,HL,IY
		inclib 	QUIG.LONG.STACK.DEHL.CHECK
		inclib	QUIG.FLOAT.ROUTINES
		call	Quig_Long_Stack_HL_Check		;Checks if HL is on stack and decreases Pointer if so
		ld		de,FLO_HL_COPY
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		ld		a,(hl)
		ld		(de),a
		inc		hl
		inc		de
		ld		a,(hl)
		ld		(de),a
		ld		hl,FLO_HL_COPY
		and		%1000000		
		call	FLO_KONV_LW_TO_FLO
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack

;LIBRARY QUIG.INT2FLOAT
.Quig_Int2Float:
		inclib	QUIG.FLOAT.ROUTINES
		ld		a,h
		and		%10000000
		ld		de,FLO_HL_COPY
		call	FLO_KONV_HLA_TO_FLO	
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack		
;LIBRARY QUIG.FLOAT.ADD
.Quig_Float_Add:
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_ADD
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack		
;LIBRARY QUIG.FLOAT.SUBTRACT
.Quig_Float_Subtract:
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_SUB
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack
;LIBRARY QUIG.FLOAT.DIVIDE
.Quig_Float_Divide:
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_DIV
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack
;LIBRARY QUIG.FLOAT.MULTIPLY
.Quig_Float_Multiply:
		inclib	QUIG.FLOAT.COPYDEHL_STACK
		call	Quig_Float_CopyDEHL_Stack
		call	FLO_MULT
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack
;LIBRARY QUIG.FLOAT.SQR
.Quig_Float_Sqr:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_SQR
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack
;LIBRARY QUIG.FLOAT.SIN
.Quig_Float_Sin:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_SIN
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack				
;LIBRARY QUIG.FLOAT.COS
.Quig_Float_Cos:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_COS
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack				
;LIBRARY QUIG.FLOAT.TAN
.Quig_Float_Tan:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_TAN
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack	
;LIBRARY QUIG.FLOAT.ATAN
.Quig_Float_ATan:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_ARC_TAN
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack			
;LIBRARY QUIG.FLOAT.LOG
.Quig_Float_Log:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_LOG_NAT
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack	
;LIBRARY QUIG.FLOAT.LOG10
.Quig_Float_Log10:
		inclib	QUIG.FLOAT.COPYHL.STACK
		call	Quig_Float_CopyHL_Stack
		call	FLO_LOG_DEC
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack	
		
;LIBRARY QUIG.FLOAT.RND		
.Quig_Float_Rnd:
		inclib	QUIG.FLOAT.ROUTINES
		inclib	QUIG.FLOAT.COPYSLOT
		ld		de,FLO_DE_COPY		
		call	Quig_Float_CopyToSlot
		ld		hl,FLO_HL_COPY
		call	FLO_RND
		ld		de,FLO_DE_COPY	
		call	FLO_MULT
		inclib	QUIG.FLOAT.RESULT2STACK
		jp		Quig_Float_Result2Stack		


;LIBRARY QUIG.FLOAT.RANDOMIZE.SEED
.Quig_Float_Randomize_Seed:
		inclib	QUIG.FLOAT.ROUTINES
		inclib 	QUIG.FLOAT.REDUCE.STACK
		call	Quig_Float_Reduce_Stack		;Checks if HL is on stack and decreases Pointer if so
		ld		de,Quig_Float_Randomize_Seed2
		ldi
		ldi
		ldi
		ldi
		ldi
		ld		hl,Quig_Float_Randomize_Seed2		
		call	FLO_RANDOMIZE
		ret				
.Quig_Float_Randomize_Seed2:	db 	0,0,0,0,0

;LIBRARY QUIG.FLOAT.RADDEG
		inclib	QUIG.FLOAT.ROUTINES		
.Quig_Float_Rad:
		xor		a
		jr		Quig_Float_Rad2
.Quig_Float_Deg:
		ld		a,1		
.Quig_Float_Rad2:
		ld		(FLO_VALUE_DEGRAD),a
		ret
;LIBRARY QUIG.FLOAT.FORMAT
;IN HL=1000 Dots
;DE=Display
.Quig_Float_Format:
		ld		a,l
		and		%1
		ld		l,a
		ld		h,e
		ld		(quig_dispformat),hl
		ret

;### CNVSTR -> converts FP number to string
;### Input      (DE)=5byte FP number, H=decimal places (-1=force exponent display, -2=just show all), L=flag, if 1000er dots
;###            (cfgnumcom)=comma char  ("." for english, "," for german etc.)
;###            (cfgnumpoi)=1000er char ("," for english, "." for german etc.)
;### Output     (cnvstrtxt)=string, BC=string length (2-27, including 0terminator)
;### Destroyed  AF,DE,L,IX,IY
;LIBRARY QUIG.FLOAT.TO.STRING
.Quig_Float_To_String:
		inclib	QUIG.FLOAT.REDUCE.STACK
		call 	Quig_Float_Reduce_Stack
		ex		de,hl
		ld		hl,(quig_dispformat)
		call	quig_cnvstr
		ld		hl,(Quig_String_Buffer_Pos)
		ld		e,l
		ld		d,h
		add		hl,bc
		ld		(Quig_String_Buffer_Pos),hl
		ex		de,hl
		ret
.quig_dispformat:	dw 512
.quig_cnvstrdig   equ 10
.quig_cnvstrman:   ds 11		;quig_cnvstrdig+1              ;mantissa string
.quig_cnvstrmal:   dw 0                        ;mantissa length
.quig_cnvstrtxtp:  db 0
.quig_cnvstrdot:   db 0
.quig_cnvstrcom:   db 0

.quig_cnvfltb ds 5

.quig_cfgnumcom   db "."
.quig_cfgnumpoi   db ","

.quig_cnvstr:  
		ld 		(quig_cnvstrdot),hl
		push	hl
		ld 		hl,quig_cnvfltb
		inclib	QUIG.FLOAT.ROUTINES
		call 	FLO_MOVE
		call 	FLO_PREPARE        ;(HL)=LW normed mantissa, B=sign of mantissa (0 -> FLO=0), E=exponent/comma position (decimal)
		ld 		d,b
		inc b:	dec b
		jr		nz,quig_cnvstrs
		ld		hl,"0"
		ld 		(quig_cnvstrman),hl
		ld 		l,1
		jr		quig_cnvstr3
.Quig_cnvstrs:
		push	de
		ld		ix,(quig_cnvfltb+0)
		ld		de,(quig_cnvfltb+2)
		ld 		iy,quig_cnvstrman
		INCLIB 	QUIG.CNV32S
		call	quig_cnv32s             ;cnvstrman=mantissa as string
		push 	iy:pop hl
		ld 		bc,quig_cnvstrman-1
		or		a
		sbc		hl,bc               ;HL=manlen
        pop		de                  ;D=mansgn, E=exp
.quig_cnvstr3: 
		dec 	l                       ;** remove end-zeroes and correct exponent
        jr 		z,quig_cnvstrq
        ld 		a,(iy+0)
        sub 	"0"
        jr 		nz,quig_cnvstrq
        ld 		(iy+0),a
        dec 	iy
        inc 	e
        jr 		quig_cnvstr3
.quig_cnvstrq:
		inc 	l
        ld 		(quig_cnvstrmal),hl
        pop 	af                  ;A=comma
        ;ld 		hl,quig_cnvstrtxt
        ld 		hl,(Quig_String_Buffer_Pos)
        push	hl
        bit		7,d
        jr		z,quig_cnvstr1
        ld 		(hl),"-"             ;negative mantissa
        inc 	hl
.quig_cnvstr1: 
		inc 	a
        jr 		nz,quig_cnvstr7
.quig_cnvstr6: 
		push 	de                     ;** exponent display
        ex 		de,hl
        ld 		hl,quig_cnvstrman  
        ldi
        ld 		a,(quig_cfgnumcom)
        ld 		(de),a
        inc 	de
.quig_cnvstr2:
		ld 		a,(hl)
        ldi
        or 		a
        jr 		nz,quig_cnvstr2
        dec 	de
        ex 		de,hl
        ld 		(hl),"e"
        inc 	hl
        pop 	de
        ld 		a,(quig_cnvstrmal)        ;exp display = exp + mantissa length - 1
        add 	e
        dec 	a
        ld 		(hl),"+"
        jp 		p,quig_cnvstr4
        ld 		(hl),"-"
        neg
.quig_cnvstr4:
		inc 	hl
        call 	quig_cnv08s
.quig_cnvstr5:
		xor 	a
        ld 		(hl),a
        inc 	hl
        pop 	de
        sbc 	hl,de
        ld 		c,l
        ld 		b,h
        ret
.quig_cnvstrp:
		ex 		de,hl
        jr 		quig_cnvstr5

.quig_cnvstr7:
		ld 		a,(quig_cnvstrmal)            ;** try comma display
        bit 	7,e
        jr 		nz,quig_cnvstrd
        add 	e                       ;** exp is positive
        cp 		quig_cnvstrdig+1          ;a=length of complete number
        jr 		nc,quig_cnvstr6           ;exp too long -> exp display
        ex 		de,hl
        ld 		hl,quig_cnvstrman
        call 	quig_cnvstrj                ;** display mantissa without comma
        ex 		de,hl
        ld 		a,(quig_cnvstrcom)        ;check if forced comma
        or 		a
        jr 		z,quig_cnvstr5
        cp 		-2
        jr 		z,quig_cnvstr5
        ld 		b,a                  ;yes, add comma and number of "0"
        inc 	b
        ld 		a,(quig_cfgnumcom)
.quig_cnvstrc:
		ld 		(hl),a
        inc 	hl
        ld 		a,"0"
        djnz 	quig_cnvstrc
        jr 		quig_cnvstr5

.quig_cnvstrd 
		ld 		c,a                      ;** exp is negative
        add 	e
        jr 		c,quig_cnvstri
        neg                     ;* comma outside mantissa
        ld 		b,a
        ld 		a,(quig_cnvstrcom)
        or 		a
        jr 		z,quig_cnvstre
        ld 		a,b
        add 	c
        cp 		quig_cnvstrdig+1
        jr 		nc,quig_cnvstr6           ;too large -> switch to exp display
.quig_cnvstre:
		ex 		de,hl
        ld 		hl,quig_cnvstrman
        call 	quig_cnvstrf
        jr 		z,quig_cnvstrp
        ld 		a,"0"
.quig_cnvstrg:
		ld 		(de),a
        inc 	de
        call 	quig_cnvstrh
        jr 		z,quig_cnvstrp
        djnz 	quig_cnvstrg
        jr 		quig_cnvstrl
.quig_cnvstri:
		ex 		de,hl                ;* comma inside mantissa
        ld 		hl,quig_cnvstrman
        jr 		z,quig_cnvstrk
        call 	quig_cnvstrj            ;display mantissa part before comma
        ld 		a,(quig_cnvstrcom)
        or 		a
        jr 		z,quig_cnvstrp
        call 	quig_cnvstrn
        jr 		quig_cnvstrl
.quig_cnvstrk:
		call 	quig_cnvstrf
        jr 		z,quig_cnvstrp
.quig_cnvstrl:
		ldi                     ;display mantissa after comma
        call 	quig_cnvstrh
        jr 		z,quig_cnvstrp
        ld 		a,(hl)
        jr 		nc,quig_cnvstrm
        or 		a
        jr 		nz,quig_cnvstrl
        jr 		quig_cnvstrp
.quig_cnvstrm:
		or 		a
        jr 		nz,quig_cnvstrl
        dec 	hl
        ld 		(hl),"0"
        jr 		quig_cnvstrl

.quig_cnvstrj:
		ld 		b,a                      ;** display mantissa until comma
.quig_cnvstr8:
		sub 	3
        jr 		z,quig_cnvstr9
		jr 		nc,quig_cnvstr8
.quig_cnvstr9:
		add 	3
        ld 		c,a                  ;c=1000 counter
.quig_cnvstra:
		ld 		a,(hl)
        inc 	hl
        or 		a
        jr 		nz,quig_cnvstrb
        ld 		a,"0"                ;end reached, fill with "0"
        dec 	hl
.quig_cnvstrb:
		call 	quig_cnvdig             ;add digit
        jr 		nz,quig_cnvstra
        ret

.quig_cnvstrf:
		ld 		a,"0"                ;start with "0," -> zf=1 -> end reached
        ld 		(de),a
        inc 	de
        ld 		a,(quig_cnvstrcom)
        or 		a
        ret 	z
.quig_cnvstrn:
		ld 		a,(quig_cfgnumcom)
        ld 		(de),a
        inc 	de
        ret
.quig_cnvstrh:
		push 	hl                 ;check if max comma reached -> zf=1 -> yes, zf=0 -> no, cf=1 never
        ld 		hl,quig_cnvstrcom
        bit 	7,(hl)
        scf
        jr 		nz,quig_cnvstro
        or 		a
        dec 	(hl)
.quig_cnvstro:
		pop 	hl
        ret

;### CNVDIG -> adds a digit and inserts a 1000er point, if needed
;### Input      DE=string, A=char, C=point counter, B=length counter
.quig_cnvdig:
		ld 		(de),a
        inc 	de
        dec 	b
        ret 	z
        dec 	c
        ret 	nz
        ld 		a,(quig_cnvstrdot)
        dec 	a
        ret 	nz
        ld 		a,(quig_cfgnumpoi)
        ld 		(de),a
        inc 	de
        ld 		c,3+1
        dec 	c
        ret

;### CNV08S -> converts 8bit to decimal string
;### Input      A=number, HL=destination string, B=counter
;### Output     HL=next string position, B+=length
;### Destroyed  AF,DE
.quig_cnv08s:
		ld 		de,255
        cp 		100
        jr 		c,quig_cnv08s2
        ld 		d,"2"
        sub 	200
        jr 		nc,quig_cnv08s1
        add 	100
        dec 	d
.quig_cnv08s1:
		ld 		(hl),d
        inc 	hl
        inc 	b
.quig_cnv08s2:
		sub 	10
        inc 	e
        jr 		nc,quig_cnv08s2
        jr 		nz,quig_cnv08s3
        inc 	d:dec d
        jr 		z,quig_cnv08s4
.quig_cnv08s3:
		set 	4,e
        set 	5,e
		ld 		(hl),e
        inc 	hl
        inc 	b
.quig_cnv08s4:
		add 	"0"+10
        ld 		(hl),a
       inc 	hl
        inc 	b
        ret


;LIBRARY QUIG.FLOAT.ROUTINES		
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@         C P C   -   F l o a t i n g - P o i n t - R o u t i n e s          @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;--- RANDOM NUMBERS -----------------------------------------------------------
;### FLO_RANDOMIZE0 -> RND seek to 0
;### FLO_RANDOMIZE -> RND seek to (HL)
;### FLO_RND -> Gets next RND value
;### FLO_LAST_RND -> Gets current RND value

;--- OPERATIONS ---------------------------------------------------------------
;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### FLO_VGL -> Compares (HL) with (DE)

;--- FUNCTIONS ----------------------------------------------------------------
;### FLO_VZW -> Changes the sign of (HL)
;### FLO_SQR -> Extracts the root of (HL)
;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### FLO_POT_E -> (HL)=E^(HL)
;### FLO_SIN -> Calculates the sinus of (HL)
;### FLO_COS -> Calculates the cosinus of (HL)
;### FLO_TAN -> Calculates the tangent of (HL)
;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### FLO_10A -> (HL)=(HL)*10^A
;### FLO_SGN -> Tests the sign of (HL)

;--- MISCELLANEOUS ------------------------------------------------------------
;### FLO_PI -> Gets PI
;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### FLO_DEGRAD -> Set Deg/Rad

;--- CONVERSION ---------------------------------------------------------------
;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer

;--- DISPLAY-PREPARATION ------------------------------------------------------
;### FLO_PREPARE -> Prepares the display of a FLO value


;--- begin routines -----------------------------------------------------------


;### FLO_PI -> Gets PI
;### Input      (HL)=Destination
;### Output     (HL)=PI, CF=1
;### Unchanged  BC,HL,IX,IY

.FLO_HL_COPY:		db 	0,0,0,0,0
.FLO_DE_COPY:		db	0,0,0,0,0

.FLO_PI
        ld de,FLO_CONST_PI
        jr FLO_MOVE
.l2f7d
		ld		de,FLO_CONST_C
		jr		FLO_MOVE
.l2f87
		ex		de,hl
.l2f88
		ld hl,#b10e
		jr FLO_MOVE
.l2f8d
       ld de,#b104
.l2f90
        ex de,hl




;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### Input      (DE)=Source value, (HL)=Destination
;### Output     (HL)=Value, CF=1
;### Unchanged  BC,DE,HL,IX,IY,(DE)
.FLO_MOVE
        push hl
        push de
        push bc
        ex de,hl
        ld bc,#0005
        ldir
        pop bc
        pop de
        pop hl
        scf
        ret

;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### Input      HL=value, A[bit7]=sign, (DE)=destination
;### Output     HL=DE, (HL)=FLO value
;### Unchanged  BC,IX,IY
.FLO_KONV_HLA_TO_FLO
        push de
        push bc
        Or #7f
        ld b,a
        Xor a
        ld (de),a
        inc de
        ld (de),a
        inc de
        ld c,#90
        Or h
        jr nz,l2fbb
        ld c,a
        Or l
        jr z,l2fbf
        ld l,h
        ld c,#88
        jr l2fbb
.l2fb7
        dec c
        sla l
        adc a
.l2fbb
        jp p,l2fb7
        And b
.l2fbf
        ex de,hl
        ld (hl),e
        inc hl
        ld (hl),a
        inc hl
        ld (hl),c
        pop bc
        pop hl
        ret

;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### Input      (HL)=LW, A[bit7]=sign
;### Output     (HL)=FLO value
;### Unchanged  BC,DE,HL,IY
.FLO_KONV_LW_TO_FLO
        push bc
        ld bc,#a000
        call l2fd3
        pop bc
        ret
        ld b,#a8
.l2fd3
        push de
        call l379c
        pop de
        ret

;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### Input      (HL)=FLO value
;### Output     HL=abs((HL)), A[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  BC,DE,IY
.FLO_ROUND_FLO_TO_HLA
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr z,l2ffd
        add #90
        ret nc
        push de
        push bc
        add #10
        call l373d
        sla c
        adc hl,de
        jr z,l2ffa
        ld a,(ix+#03)
        Or a
.l2ff6
        ccf
        pop bc
        pop de
        ret
.l2ffa
        sbc a
        jr l2ff6
.l2ffd
        ld l,a
        ld h,a
        scf
        ret
;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_ROUND_FLO_TO_LW
        call FLO_FIX_FLO_TO_LW
        ret nc
        ret p
.l3006
        push hl
        ld a,c
.l3008
        inc (hl)
        jr nz,l3011
        inc hl
        dec a
        jr nz,l3008
        inc (hl)
        inc c
.l3011
        pop hl
        scf
        ret

;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_FIX_FLO_TO_LW
        push hl
        push de
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr nz,l3029
        ld b,#04
.l3021
        ld (hl),a
        inc hl
        djnz l3021
        ld c,#01
        jr l3051
.l3029
        add #a0
        jr nc,l3052
        push hl
        call l373d
        Xor a
        cp b
        adc a
        Or c
        ld c,l
        ld b,h
        pop hl
        ld (hl),c
        inc hl
        ld (hl),b
        inc hl
        ld (hl),e
        inc hl
        ld e,a
        ld a,(hl)
        ld (hl),d
        And #80
        ld b,a
        ld c,#04
        Xor a
.l3047
        Or (hl)
        jr nz,l304f
        dec hl
        dec c
        jr nz,l3047
        inc c
.l304f
        ld a,e
        Or a
.l3051
        scf
.l3052
        pop de
        pop hl
        ret

;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_INT_FLO_TO_LW
        call 	FLO_FIX_FLO_TO_LW
        ret 	nc
        ret 	z
        bit 	7,b
        ret 	z
        jr 		l3006

;### FLO_PREPARE -> Prepares the display of a FLO value
;### Input      (HL)=FLO value
;### Output     (HL)=LW normed mantissa
;###            B = sign of mantissa
;###            D = sign of exponent
;###            E = exponent/comma position
;###            C = number of significant mantissa bytes (NOT digits!)
;### Unchanged  HL
.FLO_PREPARE
        call FLO_SGN
        ld b,a
        jr z,l30b7
        call m,l3734
        push hl
        ld a,(ix+#04)
        sub #80
        ld e,a
        sbc a
        ld d,a
        ld l,e
        ld h,d
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,de
        add hl,hl
        add hl,de
        add hl,hl
        add hl,hl
        add hl,de
        ld a,h
        sub #09
        ld c,a
        pop hl
        push bc
        call nz,l30c8
.l3085
        ld de,FLO_CONST_A
        call l36e2
        jr nc,l3098
        ld de,FLO_CONST_D1
        call FLO_MULT
        pop de
        dec e
        push de
        jr l3085
.l3098
        ld de,FLO_CONST_B
        call l36e2
        jr c,l30ab
        ld de,FLO_CONST_D1
        call FLO_DIV
        pop de
        inc e
        push de
        jr l3098
.l30ab
        call FLO_ROUND_FLO_TO_LW
        ld a,c
        pop de
.l30b0
        ld b,d
        dec a
        add l
        ld l,a
        ret nc
        inc h
        ret
.l30b7
        ld e,a
        ld (hl),a
        ld c,#01
        ret

;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer
;### Input      HL=16 bit integer, B[bit7]=sign
;### Output     HL=signed 16 bit integer
;###            CF=0 Overflow
;### Unchanged  BC,DE,IX,IY
.FLO_KONV_HLB_TO_INT
        ld a,h
        Or a
        jp m,ldd42
        Or b
        jp m,ldded
        scf
        ret
.ldd42
        Xor #80
        Or l
        ret nz
        ld a,b
        scf
        adc a
        ret
.ldded
        Xor a
        sub l
        ld l,a
        sbc h
        sub l
        cp h
        ld h,a
        scf
        ret nz
        cp #01
        ret

;### FLO_10A -> (HL)=(HL)*10^A
;### Input      (HL)=value, A=potence
;### Output     (HL)=(HL)*10^A
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_10A
        cpl
        inc a
.l30c8
        Or a
        scf
        ret z
        ld c,a
        jp p,l30d1
        cpl
        inc a
.l30d1
        ld de,FLO_CONST_D2
        sub #0d
        jr z,l30ed
        jr c,l30e3
        push bc
        push af
        call l30ed
        pop af
        pop bc
        jr l30d1
.l30e3
        ld b,a
        add a
        add a
        add b
        add e
        ld e,a
        ld a,#ff
        adc d
        ld d,a
.l30ed
        ld a,c
        Or a
        jp p,FLO_DIV
        jp FLO_MULT

;### FLO_RANDOMIZE0 -> RND seek to 0
;### Unchanged  AF,BC,DE,IX,IY
.FLO_RANDOMIZE0
        ld hl,#8965
        ld (FLO_VALUE_RND+2),hl
        ld hl,#6c07
        ld (FLO_VALUE_RND),hl
        ret

;### FLO_RANDOMIZE -> RND seek to (HL)
;### Input      (HL)=value
;### Unchanged  C,IY,FLO(HL)
.FLO_RANDOMIZE
        ex de,hl
        call FLO_RANDOMIZE0
        ex de,hl
        call FLO_SGN
        ret z
        ld de,FLO_VALUE_RND
        ld b,#04
.l3151
        ld a,(de)
        Xor (hl)
        ld (de),a
        inc de
        inc hl
        djnz l3151
        ret

;### FLO_RND -> Gets next RND value
;### Input      (HL)=Destination
;### Output     (HL)=new RND
;### Unchanged  HL,IY
.FLO_RND
        push hl
        ld hl,(FLO_VALUE_RND+2)
        ld bc,#6c07
        call l319c
        push hl
        ld hl,(FLO_VALUE_RND)
        ld bc,#8965
        call l319c
        push de
        push hl
        ld hl,(FLO_VALUE_RND+2)
        call l319c
        ex (sp),hl
        add hl,bc
        ld (FLO_VALUE_RND),hl
        pop hl
        ld bc,#6c07
        adc hl,bc
        pop bc
        add hl,bc
        pop bc
        add hl,bc
        ld (FLO_VALUE_RND+2),hl
        pop hl

;### FLO_LAST_RND -> Gets current RND value
;### Input      (HL)=Destination
;### Output     (HL)=current RND
;### Unchanged  HL,IY
.FLO_LAST_RND
        push hl
        pop ix
        ld hl,(FLO_VALUE_RND)
        ld de,(FLO_VALUE_RND+2)
        ld bc,#0000
        ld (ix+#04),#80
        jp l37ac
.l319c
        ex de,hl
        ld hl,#0000
        ld a,#11
.l31a2
        dec a
        ret z
        add hl,hl
        rl e
        rl d
        jr nc,l31a2
        add hl,bc
        jr nc,l31a2
        inc de
        jr l31a2

;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG10((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_DEC
        ld de,FLO_CONST_LOGDEC
        jr l31b9

;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_NAT
        ld de,FLO_CONST_LOGNAT
.l31b9
        call FLO_SGN
        dec a
        cp #01
        ret nc
        push de
        call l36d3
        push af
        ld (ix+#04),#80
        ld de,FLO_CONST_LOG
        call FLO_VGL
        jr nc,l31d7
        inc (ix+#04)
        pop af
        dec a
        push af
.l31d7
        call l2f87
        push de
        ld de,FLO_CONST_C
        push de
        call FLO_ADD
        pop de
        ex (sp),hl
        call FLO_SUB
        pop de
        call FLO_DIV
        call l3440
        db #04
        db #4c,#4b,#57,#5e,#7f
        db #0d,#08,#9b,#13,#80
        db #23,#93,#38,#76,#80
        db #20,#3b,#aa,#38,#82

.l3203
        push de
        call FLO_MULT
        pop de
        ex (sp),hl
        ld a,h
        Or a
        jp p,l3210
        cpl
        inc a
.l3210
        ld l,a
        ld a,h
        ld h,#00
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_ADD
        pop de
        jp FLO_MULT

;### FLO_POT_E -> (HL)=E^(HL)
;### Input      (HL)=value
;### Output     (HL)=E^(HL)
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_POT_E
        ld b,#e1
        call l3492
        jp nc,l2f7d
        ld de,FLO_CONST_POTE2
        call FLO_VGL
        jp p,l37e8
        ld de,FLO_CONST_POTE3
        call FLO_VGL
        jp m,l37e2
        ld de,FLO_CONST_POTE1
        call l3469
        ld a,e
        jp p,l3255
        neg
.l3255
        push af
        call l3570
        call l2f8d
        push de
        call l3443
        db #03
        db #f4,#32,#eb,#0f,#73
        db #08,#b8,#d5,#52,#7b
.FLO_CONST_HALF                     ;=1/2
        db #00,#00,#00,#00,#80

.l3270
        ex (sp),hl
        call l3443
        db #02
        db #09,#60,#de,#01,#78
        db #f8,#17,#72,#31,#7e

.l327f
        call FLO_MULT
        pop de
        push hl
        ex de,hl
        call FLO_SUB
        ex de,hl
        pop hl
        call FLO_DIV
        ld de,FLO_CONST_HALF
        call FLO_ADD
        pop af
        scf
        adc (ix+#04)
        ld (ix+#04),a
        scf
        ret

;### FLO_SQR -> Extracts the root of (HL)
;### Input      (HL)=value
;### Output     (HL)=sqr(HL)
;###            CF=0 error, negative value
;### Unchanged  HL
.FLO_SQR
        ld de,FLO_CONST_HALF

;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)^(DE)
;###            CF=0 Error [S=1 invalid parameter -X^(z/n), P=1 Overflow]
;### Unchanged  HL,FLO(DE)
.FLO_POT
        ex de,hl
        call FLO_SGN
        ex de,hl
        jp z,l2f7d
        push af
        call FLO_SGN
        jr z,l32e2
        ld b,a
        call m,l3734
        push hl
        call l3324
        pop hl
        jr c,l32ed
        ex (sp),hl
        pop hl
        jp m,l32ea
        push bc
        push de
        call FLO_LOG_NAT
        pop de
        call c,FLO_MULT
        call c,FLO_POT_E
.l32d9
        pop bc
        ret nc
        ld a,b
        Or a
        call m,FLO_VZW
        scf
        ret
.l32e2
        pop af
        scf
        ret p
        call l37e8
        Xor a
        ret
.l32ea
        Xor a
        inc a
        ret
.l32ed
        ld c,a
        pop af
        push bc
        push af
        ld a,c
        scf
.l32f3
        adc a
        jr nc,l32f3
        ld b,a
        call l2f8d
        ex de,hl
        ld a,b
.l32fc
        add a
        jr z,l3314
        push af
        call l3570
        jr nc,l331b
        pop af
        jr nc,l32fc
        push af
        ld de,#b104
        call FLO_MULT
        jr nc,l331b
        pop af
        jr l32fc
.l3314
        pop af
        scf
        call m,l35fb
        jr l32d9
.l331b
        pop af
        pop af
        pop bc
        jp m,l37e2
        jp l37ea
.l3324
        push bc
        call l2f88
        call FLO_FIX_FLO_TO_LW
        ld a,c
        pop bc
        jr nc,l3331
        jr z,l3334
.l3331
        ld a,b
        Or a
        ret
.l3334
        ld c,a
        ld a,(hl)
        rra
        sbc a
        And b
        ld b,a
        ld a,c
        cp #02
        sbc a
        ret nc
        ld a,(hl)
        cp #27
        ret c
        Xor a
        ret


		
;### FLO_DEGRAD -> Set Deg/Rad
;### Input      A=Typ (=0 -> Rad, >0 -> Deg)
;### Unchanged  AF,BC,DE,HL,IX,IY
.FLO_DEGRAD    
        ld (FLO_VALUE_DEGRAD),a
        ret

;### FLO_COS -> Calculates the cosinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=cos(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_COS
        call FLO_SGN
        call m,l3734
        Or #01
        jr l3354

;### FLO_SIN -> Calculates the sinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=sin(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_SIN
        Xor a
.l3354
        push af
        ld de,FLO_CONST_SINA
        ld b,#f0
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        jr z,l3365
        ld de,FLO_CONST_SINB
        ld b,#f6
.l3365
        call l3492
        jr nc,l33a4
        pop af
        call l346a
        ret nc
        ld a,e
        rra
        call c,l3734
        ld b,#e8
        call l3492
        jp nc,l37e2
        inc (ix+#04)
        call l3440
        db #06
        db #1b,#2d,#1a,#e6,#6e
        db #f8,#fb,#07,#28,#74
        db #01,#89,#68,#99,#79
        db #e1,#df,#35,#23,#7d
        db #28,#e7,#5d,#a5,#80
.FLO_CONST_F
        db #a2,#da,#0f,#49,#81

.l33a1
        jp FLO_MULT
.l33a4
        pop af
        jp nz,l2f7d
        ld a,(FLO_VALUE_DEGRAD)
        cp #01
        ret c
        ld de,FLO_CONST_SINC
        jp FLO_MULT		
		



;### FLO_TAN -> Calculates the tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=tan(HL)
;###            CF=0 error [Z=1 division by zero, S=1 value too big]
;### Unchanged  HL
.FLO_TAN
        call l2f8d
        push de
        call FLO_COS
        ex (sp),hl
        call c,FLO_SIN
        pop de
        jp c,FLO_DIV
        ret

;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=atn(HL)
;### Unchanged  HL
.FLO_ARC_TAN
        call FLO_SGN
        push af
        call m,l3734
        ld b,#f0
        call l3492
        jr nc,l3430
        dec a
        push af
        call p,l35fb
        call l3440
        db #0b
        db #ff,#c1,#03,#0f,#77
        db #83,#fc,#e8,#eb,#79
        db #6f,#ca,#78,#36,#7b
        db #d5,#3e,#b0,#b5,#7c
        db #b0,#c1,#8b,#09,#7d
        db #af,#e8,#32,#b4,#7d
        db #74,#6c,#65,#62,#7d
        db #d1,#f5,#37,#92,#7e
        db #7a,#c3,#cb,#4c,#7e
        db #83,#a7,#aa,#aa,#7f
        db #fe,#ff,#ff,#7f,#80

.l3426
        call FLO_MULT
        pop af
        ld de,FLO_CONST_F
        call p,FLO_SUBX
.l3430
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        ld de,FLO_CONST_TAN
        call nz,FLO_MULT
        pop af
        call m,l3734
        scf
        ret
.l3440
        call l3570
.l3443
        call l2f87
        pop hl
        ld b,(hl)
        inc hl
        call l2f90
.l344c
        inc de
        inc de
        inc de
        inc de
        inc de
        push de
        ld de,#b109
        dec b
        ret z
        push bc
        ld de,#b10e
        call FLO_MULT
        pop bc
        pop de
        push de
        push bc
        call FLO_ADD
        pop bc
        pop de
        jr l344c
.l3469
        Xor a
.l346a
        push af
        call FLO_MULT
        pop af
        ld de,FLO_CONST_HALF
        call nz,FLO_ADD
        push hl
        call FLO_ROUND_FLO_TO_HLA
        jr nc,l348e
        pop de
        push hl
        push af
        push de
        ld de,#b109
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_SUB
        pop af
        pop de
        scf
        ret
.l348e
        pop hl
        Xor a
        inc a
        ret
.l3492
        call l36d3
        ret p
        cp b
        ret z
        ccf
        ret

;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)-(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUB
        ld a,#01
        jr l34a3

;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### Input      (DE)=first value, (HL)=second value
;### Output     (HL)=(DE)-(HL)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUBX
        ld a,#80
        jr l34a3

;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)+(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_ADD
        Xor a
.l34a3
        push hl
        pop ix
        push de
        pop iy
        ld b,(ix+#03)
        ld c,(iy+#03)
        Or a
        jr z,l34bc
        jp m,l34ba
        rrca
        Xor c
        ld c,a
        jr l34bc
.l34ba
        Xor b
        ld b,a
.l34bc
        ld a,(ix+#04)
        cp (iy+#04)
        jr nc,l34d8
        ld d,b
        ld b,c
        ld c,d
        Or a
        ld d,a
        ld a,(iy+#04)
        ld (ix+#04),a
        jr z,l3525
        sub d
        cp #21
        jr nc,l3525
        jr l34e9
.l34d8
        Xor a
        sub (iy+#04)
        jr z,l3537
        add (ix+#04)
        cp #21
        jr nc,l3537
        push hl
        pop iy
        ex de,hl
.l34e9
        ld e,a
        ld a,b
        Xor c
        push af
        push bc
        ld a,e
        call l3743
        ld a,c
        pop bc
        ld c,a
        pop af
        jp m,l353c
        ld a,(iy+#00)
        add l
        ld l,a
        ld a,(iy+#01)
        adc h
        ld h,a
        ld a,(iy+#02)
        adc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        adc d
        ld d,a
        jp nc,l37b7
        rr d
        rr e
        rr h
        rr l
        rr c
        inc (ix+#04)
        jp nz,l37b7
        jp l37ea
.l3525
        ld a,(iy+#02)
        ld (ix+#02),a
        ld a,(iy+#01)
        ld (ix+#01),a
        ld a,(iy+#00)
        ld (ix+#00),a
.l3537
        ld (ix+#03),b
        scf
        ret
.l353c
        Xor a
        sub c
        ld c,a
        ld a,(iy+#00)
        sbc l
        ld l,a
        ld a,(iy+#01)
        sbc h
        ld h,a
        ld a,(iy+#02)
        sbc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        sbc d
        ld d,a
        jr nc,l356d
        ld a,b
        cpl
        ld b,a
        Xor a
        sub c
        ld c,a
        ld a,#00
        sbc l
        ld l,a
        ld a,#00
        sbc h
        ld h,a
        ld a,#00
        sbc e
        ld e,a
        ld a,#00
        sbc d
        ld d,a
.l356d
        jp l37ac
.l3570
        ld de,#b109
        call l2f90
        ex de,hl

;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)*(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_MULT
        push de
        pop iy
        push hl
        pop ix
        ld a,(iy+#04)
        Or a
        jr z,l35ad
        dec a
        call l36af
        jr z,l35ad
        jr nc,l35aa
        push af
        push bc
        call l35b0
        ld a,c
        pop bc
        ld c,a
        pop af
        bit 7,d
        jr nz,l35a3
        dec a
        jr z,l35ad
        sla c
        adc hl,hl
        rl e
        rl d
.l35a3
        ld (ix+#04),a
        Or a
        jp nz,l37b7
.l35aa
        jp l37ea
.l35ad
        jp l37e2
.l35b0
        ld hl,#0000
        ld e,l
        ld d,h
        ld a,(iy+#00)
        call l35f3
        ld a,(iy+#01)
        call l35f3
        ld a,(iy+#02)
        call l35f3
        ld a,(iy+#03)
        Or #80
.l35cc
        ld b,#08
        rra
        ld c,a
.l35d0
        jr nc,l35e6
        ld a,l
        add (ix+#00)
        ld l,a
        ld a,h
        adc (ix+#01)
        ld h,a
        ld a,e
        adc (ix+#02)
        ld e,a
        ld a,d
        adc (ix+#03)
        ld d,a
.l35e6
        rr d
        rr e
        rr h
        rr l
        rr c
        djnz l35d0
        ret
.l35f3
        Or a
        jr nz,l35cc
        ld l,h
        ld h,e
        ld e,d
        ld d,a
        ret
.l35fb
        call l2f87
        ex de,hl
        push de
        call l2f7d
        pop de

;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)/(DE)
;###            CF=0 Overflow (and ZF=1 -> division by zero)
;### Unchanged  HL,FLO(DE)
.FLO_DIV
        push de
        pop iy
        push hl
        pop ix
        Xor a
        sub (iy+#04)
        jr z,l366a
        call l36af
        jp z,l37e2
        jr nc,l3667
        push bc
        ld c,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
        ld b,(iy+#03)
        set 7,b
        call l369d
        jr c,l3633
        ld a,c
        Or a
        jr nz,l3639
        jr l3666
.l3633
        dec c
        add hl,hl
        rl e
        rl d
.l3639
        ld (ix+#04),c
        call l3672
        ld (ix+#03),c
        call l3672
        ld (ix+#02),c
        call l3672
        ld (ix+#01),c
        call l3672
        ccf
        call c,l369d
        ccf
        sbc a
        ld l,c
        ld h,(ix+#01)
        ld e,(ix+#02)
        ld d,(ix+#03)
        pop bc
        ld c,a
        jp l37b7
.l3666
        pop bc
.l3667
        jp l37ea
.l366a
        ld b,(ix+#03)
        call l37ea
        Xor a
        ret
.l3672
        ld c,#01
.l3674
        jr c,l367e
        ld a,d
        cp b
.l3678
        call z,l36a0
        ccf
        jr nc,l3691
.l367e
        ld a,l
        sub (iy+#00)
        ld l,a
        ld a,h
        sbc (iy+#01)
        ld h,a
        ld a,e
        sbc (iy+#02)
        ld e,a
        ld a,d
        sbc b
        ld d,a
        scf
.l3691
        rl c
        sbc a
        add hl,hl
        rl e
        rl d
        inc a
        jr nz,l3674
        ret
.l369d
        ld a,d
        cp b
        ret nz
.l36a0
        ld a,e
        cp (iy+#02)
        ret nz
        ld a,h
        cp (iy+#01)
        ret nz
        ld a,l
        cp (iy+#00)
        ret
.l36af
        ld c,a
        ld a,(ix+#03)
        Xor (iy+#03)
        ld b,a
        ld a,(ix+#04)
        Or a
        ret z
        add c
        ld c,a
        rra
        Xor c
        ld a,c
        jp p,l36cf
        set 7,(ix+#03)
        sub #7f
        scf
        ret nz
        cp #01
        ret
.l36cf
        Or a
        ret m
        Xor a
        ret
.l36d3
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        sub #80
        scf
        ret

;### FLO_VGL -> Compares (HL) with (DE)
;### Input      (HL)=first value, (DE)=second value
;### Output     A=Result [-1 -> (HL)<(DE), 0 -> (HL)=(DE), 1 -> (HL)>(DE)]
;###            ZF=1 -> (HL)=(DE), CF=1 -> (HL)<(DE)
;### Unchanged  BC,DE,HL,FLO(HL),FLO(DE)
.FLO_VGL
        push hl
        pop ix
.l36e2
        push de
        pop iy
        ld a,(ix+#04)
        cp (iy+#04)
        jr c,l3719
        jr nz,l3722
        Or a
        ret z
        ld a,(ix+#03)
        Xor (iy+#03)
        jp m,l3722
        ld a,(ix+#03)
        sub (iy+#03)
        jr nz,l3719
        ld a,(ix+#02)
        sub (iy+#02)
        jr nz,l3719
        ld a,(ix+#01)
        sub (iy+#01)
        jr nz,l3719
        ld a,(ix+#00)
        sub (iy+#00)
        ret z
.l3719
        sbc a
        Xor (iy+#03)
.l371d
        add a
        sbc a
        ret c
        inc a
        ret
.l3722
        ld a,(ix+#03)
        jr l371d

;### FLO_SGN -> Tests the sign of (HL)
;### Input      (HL)=value
;### Output     A=sign [-1 -> (HL)<0, 0 -> (HL)=0, 1 -> (HL)>0]
;###            ZF=1 -> (HL)=0, CF=1 -> (HL)<0
;### Unchanged  BC,DE,HL,IY,FLO(HL)
.FLO_SGN
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        jr l3722

;### FLO_VZW -> Changes the sign of (HL)
;### Input      (HL)=value
;### Output     (HL)=-(HL)
;### Unchanged  BC,DE,HL,IY
.FLO_VZW
        push hl
        pop ix
.l3734
        ld a,(ix+#03)
        Xor #80
        ld (ix+#03),a
        ret
.l373d
        cp #21
        jr c,l3743
        ld a,#21
.l3743
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld h,(hl)
        ld l,c
        ex de,hl
        set 7,d
        ld bc,#0000
        jr l375e
.l3753
        ld c,a
        ld a,b
        Or l
        ld b,a
        ld a,c
        ld c,l
        ld l,h
        ld h,e
        ld e,d
        ld d,#00
.l375e
        sub #08
        jr nc,l3753
        add #08
        ret z
.l3765
        srl d
        rr e
        rr h
        rr l
        rr c
        dec a
        jr nz,l3765
        ret
.l3773
        jr nz,l378c
        ld d,a
        ld a,e
        Or h
        Or l
        Or c
        ret z
        ld a,d
.l377c
        sub #08
        jr c,l379a
        ret z
        ld d,e
        ld e,h
        ld h,l
        ld l,c
        ld c,#00
        inc d
        dec d
        jr z,l377c
        ret m
.l378c
        dec a
        ret z
        sla c
        adc hl,hl
        rl e
        rl d
        jp p,l378c
        ret
.l379a
        Xor a
        ret
.l379c
        push hl
        pop ix
        ld (ix+#04),b
        ld b,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
.l37ac
        ld a,(ix+#04)
        dec d
        inc d
        call p,l3773
        ld (ix+#04),a
.l37b7
        sla c
        jr nc,l37cd
        inc l
        jr nz,l37cd
        inc h
        jr nz,l37cd
        inc de
        ld a,d
        Or e
        jr nz,l37cd
        inc (ix+#04)
        jr z,l37ea
        ld d,#80
.l37cd
        ld a,b
        Or #7f
        And d
        ld (ix+#03),a
        ld (ix+#02),e
        ld (ix+#01),h
        ld (ix+#00),l
.l37dd
        push ix
        pop hl
        scf
        ret
.l37e2
        Xor a
        ld (ix+#04),a
        jr l37dd
.l37e8
        ld b,#00
.l37ea
        push ix
        pop hl
        ld a,b
        Or #7f
        ld (ix+#03),a
        Or #ff
        ld (ix+#04),a
        ld (hl),a
        ld (ix+#01),a
        ld (ix+#02),a
        ret

;--- begin variables ----------------------------------------------------------

.FLO_VALUE_DEGRAD    db 0
.FLO_VALUE_RND       ds 4

;--- begin constants ----------------------------------------------------------

.FLO_CONST_PI		                    ;=PI
        db #a2,#da,#0f,#49,#82,0				;**** Padded out with a Zero
.FLO_CONST_LOG
        db #34,#f3,#04,#35,#80
.FLO_CONST_LOGNAT
        db #f8,#17,#72,#31,#80
.FLO_CONST_LOGDEC
        db #85,#9a,#20,#1a,#7f

.FLO_CONST_POTE1
        db #29,#3b,#aa,#38,#81
.FLO_CONST_POTE2
        db #c7,#33,#0f,#30,#87
.FLO_CONST_POTE3
        db #f8,#17,#72,#b1,#87

.FLO_CONST_SINA
        db #6e,#83,#f9,#22,#7f
.FLO_CONST_SINB
        db #b6,#60,#0b,#36,#79
.FLO_CONST_SINC
        db #13,#35,#fa,#0e,#7b
.FLO_CONST_TAN
        db #d3,#e0,#2e,#65,#86

.FLO_CONST_A
        db #f0,#1f,#bc,#3e,#96
.FLO_CONST_B
        db #fe,#27,#6b,#6e,#9e
.FLO_CONST_C
        db #00,#00,#00,#00,#81

.FLO_CONST_D1
        db #00,#00,#00,#20,#84
        db #00,#00,#00,#48,#87
        db #00,#00,#00,#7a,#8a
        db #00,#00,#40,#1c,#8e
        db #00,#00,#50,#43,#91
        db #00,#00,#24,#74,#94
        db #00,#80,#96,#18,#98
        db #00,#20,#bc,#3e,#9b
        db #00,#28,#6b,#6e,#9e
        db #00,#f9,#02,#15,#a2
        db #40,#b7,#43,#3a,#a5
        db #10,#a5,#d4,#68,#a8
.FLO_CONST_D2
        db #2a,#e7,#84,#11,#ac
		
		
		
					
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@              S Y M S T U D I O   S Y S T E M   L I B R A R Y               @
;@                     - SYMBOS FILE MANAGER FUNCTIONS -                      @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;Author: Prodatron / Symbiosis
;Date:   30.04.2006

;This library supports you in using the file manager functions.
;Instead of including the following routines in your application code you may
;use the "SySystem_CallFunction" routine directly, so that you would save some
;overhead. In this case you can see this library just as an example, how to
;access the file manager.
;The existance of "AppPrzN" (a byte, where the ID of the applications process
;is stored) and "AppMsgB" (the message buffer, 14 bytes, which are placed in
;the transfer ram area) is required.


;LIBRARY SYFILE.FILNEW
;******************************************************************************
;*** Name           File_New
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Attributes
;***                       Bit0 = 1 -> Read only
;***                       Bit1 = 1 -> Hidden
;***                       Bit2 = 1 -> System
;***                       Bit5 = 1 -> Archive
;*** Output         A    = Filehandler ID
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Creates a new file and opens it for read/write access. If the
;***                file was already existing, it will be emptied first. For
;***                additional information see 018 (FILOPN).
;******************************************************************************
.SyFile_FILNEW
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILNEW
        ret
;LIBRARY SYFILE.FILOPN
;******************************************************************************
;*** Name           File_Open
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;*** Output         A    = Filehandler ID
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Opens an existing file for read/write access. This means, that
;***                you can read and write in the file like you want. You can open
;***                up to 8 different files at the same time.
;***                For more information about the file path see the introduction
;***                of the DIRECTORY MANAGEMENT FUNCTIONS.
;***                The media will be reloaded first, if the device is set to
;***                "removeable media" and there is no other open file on the same
;***                device.
;******************************************************************************
.SyFile_FILOPN
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILOPN
        ret
;LIBRARY SYFILE.FILCLO
;******************************************************************************
;*** Name           File_Close
;*** Input          A    = Filehandler ID
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Closes an opened file. If there is unwritten data in the sector
;***                cache, it will be written to disc at once.
;***                This command closes a file in any case, even if an error
;***                occured.
;***                If an error occured during file reading/writing you must close
;***                the file, too, to have the filehandler free again!
;******************************************************************************
.SyFile_FILCLO
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILCLO
        ret
;LIBRARY SYFILE.FILINP
;******************************************************************************
;*** Name           File_Input
;*** Input          A    = Filehandler ID
;***                HL   = Destination address
;***                E    = Destination ram bank (0-8)
;***                BC   = Number of bytes
;*** Output         BC   = Number of read bytes
;***                ZF   = 1 -> All requested bytes have been read
;***                       0 -> The end of the file has been reached, and less
;***                            bytes than requested have been read (check BC)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Reads a specified amount of bytes out of an opened file. After
;***                this operation the file pointer will be moved behind the last
;***                read byte. This means, that it is possible to read several
;***                blocks with different sizes out of an opened file. It doesn't
;***                matter, if you already did write operations, too.
;***                If you try to read more bytes than available, the zero flag
;***                will be reset. In any case BC contains the amount of read
;***                bytes.
;******************************************************************************
.SyFile_FILINP
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILINP
        ret
;LIBRARY SYFILE_FILOUT
;******************************************************************************
;*** Name           File_Output
;*** Input          A    = Filehandler ID
;***                HL   = Source address
;***                E    = Source ram bank (0-8)
;***                BC   = Number of bytes
;*** Output         BC   = Number of written bytes
;***                A    = 0 -> All bytes have been written
;***                       1 -> The device is full, and less bytes have been
;***                            written (check BC)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Writes a specified amount of bytes into an opened file. After
;***                this operation the file pointer will be moved behind the last
;***                written byte. If the file pointer has been somewhere in the
;***                middle of the file before this operation, the data at this
;***                place will be overwritten. If you have been at the end of the
;***                file, its length will be extended.
;***                You can write several blocks with different sizes, and it
;***                doesn't matter if you already read from the file before.
;***                It's possible, that not all bytes have been written, if the
;***                device is full. Register A will be 1 in this case. In any case
;***                BC contains the amount of written bytes.
;******************************************************************************
.SyFile_FILOUT
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILOUT
        ret
;LIBRARY SYFILE.FILPOI
;******************************************************************************
;*** Name           File_Pointer
;*** Input          A    = Filehandler ID
;***                IY,IX= Difference
;***                C    = Reference point
;***                       0 = File begin
;***                       1 = Actual pointer position
;***                       2 = File end
;*** Output         IY,IX= new absolute pointer position
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL
;*** Description    Moves the file pointer to another position. The difference is
;***                specified with IY and IX, IY is the high word, IX the low word
;***                (difference = 65536 * IY + IX).
;***                You can also use this function to find out the length of an
;***                opened file. Just set IY,IX to 0 and choose 2 as the reference
;***                point type. The pointer will be placed behind the last byte of
;***                the file, so you will get its length in IY,IX.
;*** Examples       IY = 0,     IX = 1,   C = 1 -> Increases the position by 1
;***                IY = 65535, IX = -10, C = 2 -> Sets the pointer before the last
;***                                               10 bytes of the file
;******************************************************************************
.SyFile_FILPOI
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILPOI
        ret
;LIBRARY SYFILE.FILF2T
;******************************************************************************
;*** Name           File_Decode_Timestamp
;*** Input          BC   = Time code
;***                       bit  0- 4 = second/2
;***                       bit  5-10 = minute
;***                       bit 11-15 = hour
;***                DE   = Date code
;***                       bit  0- 4 = day (starting from 1)
;***                       bit  5- 8 = month (starting from 1)
;***                       bit  9-15 = year-1980
;*** Output         A    = second
;***                B    = minute
;***                C    = hour
;***                D    = day (starting from 1)
;***                E    = month (starting from 1)
;***                HL   = year
;*** Destroyed      F
;*** Description    Decodes the file timestamp, which is used for the file system.
;***                You can use this function after reading the timestamp of a
;***                file with 035 (DIRPRR) or 038 (DIRINP).
;******************************************************************************
.SyFile_FILF2T
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILF2T
        ret
;LIBRARY SYFILE.FILT2F
;******************************************************************************
;*** Name           File_Encode_Timestamp
;*** Input          A    = second
;***                B    = minute
;***                C    = hour
;***                D    = day (starting from 1)
;***                E    = month (starting from 1)
;***                HL   = year
;*** Output         BC   = Time code (see FILF2T)
;***                DE   = Date code (see FILF2T)
;*** Destroyed      AF,HL,IX,IY
;*** Description    Encodes the file timestamp, which is used for the file system.
;***                You can use this function before changing the timestamp of a
;***                file with 034 (DIRPRS).
;******************************************************************************
.SyFile_FILT2F
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILT2F
        ret
;LIBRARY SYFILE.FILLIN
;******************************************************************************
;*** Name           File_LineInput
;*** Input          A    = Filehandler ID
;***                HL   = Destination buffer address (size must be 255 bytes)
;***                E    = Destination buffer ram bank (0-8)
;*** Output         BC   = Number of read bytes (without terminator)
;***                ZF   = 0 -> 1 or more bytes have been loaded
;***                       1 -> EOF reached, nothing has been loaded
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Reads one text line out of an opened file. A text line is
;***                terminated by a single 13, a single 10, a combination of 13+10,
;***                a combination of 10+13 or by a single 26 ("end of file" code).
;***                The line terminator will not be copied to the destination line
;***                buffer, but a 0 will be added behind the last char of the line.
;***                This function allows you to read a text file line by line at a
;***                very high speed, because you don't need to read single chars
;***                and check for line feeds by yourself.
;******************************************************************************
.SyFile_FILLIN
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILLIN
        ret
;LIBRARY SYFILE.DIRDEV
;******************************************************************************
;*** Name           Directory_Device
;*** Input          A    = Driveletter ("A"-"Z")
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Selects the actual drive.
;***                As your application is running in a multitasking environment,
;***                unfortunately this command does not make many sense, as other
;***                applications could select an other drive again.
;******************************************************************************
.SyFile_DIRDEV
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRDEV
        ret
;LIBRARY SYFILE.DIRPTH
;******************************************************************************
;*** Name           Directory_Path
;*** Input          IXH  = File path ram bank (0-8)
;***                HL   = File path address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Selects the actual path for the actual or a different drive.
;***                As your application is running in a multitasking environment,
;***                unfortunately this command does not make many sense, as other
;***                applications could select an other path again.
;******************************************************************************
.SyFile_DIRPTH
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPTH
        ret
;LIBRARY SYFILE.DIRPRS
;******************************************************************************
;*** Name           Directory_Property_Set
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Property type
;***                       0 = Attribute          -> C  = attribute
;***                                                      Bit0 = 1 -> Read only
;***                                                      Bit1 = 1 -> Hidden
;***                                                      Bit2 = 1 -> System
;***                                                      Bit5 = 1 -> Archive
;***                       1 = Timestamp modified -> BC = time code, DE = date code
;***                       2 = Timestamp created  -> BC = time code, DE = date code
;***                BC,DE= see above
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Changes a property of a file or a directory. You can set the
;***                attribute, the "created" time and the "modified" time.
;***                For more information about the time and date code see 023
;***                (FILF2T).
;******************************************************************************
.SyFile_DIRPRS
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPRS
        ret
;LIBRARY SYFILE.DIRPRR
;******************************************************************************
;*** Name           Directory_Property_Get
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Property type
;***                       0 = Attribute
;***                       1 = Timestamp modified
;***                       2 = Timestamp created
;*** Output         C    = Attributes (if requested)
;***                       Bit0 = 1 -> Read only
;***                       Bit1 = 1 -> Hidden
;***                       Bit2 = 1 -> System
;***                       Bit3 = 1 -> Volume ID
;***                       Bit4 = 1 -> Directory
;***                       Bit5 = 1 -> Archive
;***                BC,DE= Time and date code (if requested)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,HL,IX,IY
;*** Description    Reads a property of a file or a directory.
;***                For more information about the time and date code see 023
;***                (FILF2T).
;******************************************************************************
.SyFile_DIRPRR
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPRR
        ret
;LIBRARY SYFILE.DIRREN
;******************************************************************************
;*** Name           Directory_Rename
;*** Input          IXH  = Ram bank (0-8) of old and new file name
;***                HL   = Address of file path and old file name
;***                DE   = Address of new file name
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Renames a file or a directory. The new file name must not
;***                include a path. The function will fail, if a file or directory
;***                with the new name already exists.
;******************************************************************************
.SyFile_DIRREN
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRREN
        ret

;LIBRARY SYFILE.DIRINP
;******************************************************************************
;*** Name           Directory_Input
;*** Input          IXH  = Directory path ram bank (0-8)
;***                HL   = Directory path address (may include a search mask)
;***                IXL  = forbidden attributes
;***                       Bit0 = 1 -> don't show read only files
;***                       Bit1 = 1 -> don't show hidden files
;***                       Bit2 = 1 -> don't show system files
;***                       Bit3 = 1 -> don't show volume ID entries
;***                       Bit4 = 1 -> don't show directories
;***                       Bit5 = 1 -> don't show archive files
;***                A    = Destination buffer ram bank (0-8)
;***                DE   = Destination buffer address
;***                BC   = Destination buffer length
;***                IY   = Number of entries, which should be skipped
;*** Output         HL   = Number of read entries
;***                BC   = Remaining unused space in the destination buffer
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,IX,IY
;*** Data structure 00  4B  File length (32bit double word)
;***                04  1W  Date code, see 023 (FILF2T)
;***                06  1W  Time code, see 023 (FILF2T)
;***                08  1B  Attributes, see 035 (DIRPRR)
;***                09  ?B  File or sub directory name
;***                ??  1B  0 terminator
;*** Description    Reads the content of a directory. You can specify a name filter
;***                filter by adding a file mask to the path (* and ? are allowed)
;***                and an attribute filter. We recommend always to set Bit3
;***                (volume ID) of the attribute filter byte.
;***                The system skips the specified amount of entries first and
;***                then loads as many entries as exist or as there is place in the
;***                destination buffer. Please note, that the entries will not be
;***                sorted. Depending on its name every entry in the destination
;***                buffer can have a different length and is terminated with 0
;***                behind the file name. Filenames don't contain spaces.
;******************************************************************************
.SyFile_DIRINP	
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRINP
        ret
;LIBRARY SYFILE.DIRDEL
;******************************************************************************
;*** Name           Directory_DeleteFile
;*** Input          IXH  = File path and name/mask ram bank (0-8)
;***                HL   = File path and name/mask address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Deletes one or more files. You can delete multiple files by
;***                using a file mask (* and ? are allowed).
;***                This function can't be used for deleting directories.
;******************************************************************************
.SyFile_DIRDEL
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRDEL
        ret
;LIBRARY SYFILE.DIRRMD
;******************************************************************************
;*** Name           Directory_DeleteDirectory
;*** Input          IXH  = Directory path and name ram bank (0-8)
;***                HL   = Directory path and name address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Deletes a sub directory. The sub directory has to be empty
;***                and not read only, otherwise the operation will be aborted.
;***                You can specify the directory with or without "/" at the
;***                end of the full path.
;******************************************************************************
.SyFile_DIRRMD
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRRMD
        ret
;LIBRARY SYFILE.DIRMOV
;******************************************************************************
;*** Name           Directory_Move
;*** Input          IXH  = File/directory old and new path ram bank (0-8)
;***                HL   = File/directory source path and name address
;***                DE   = File/directory destination path address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Moves a file or sub directory into another directory of the
;***                same drive. That means, that the drive letter of the source
;***                path must be the same like the drive letter of the
;***                destination path, otherwise the operation will be aborted.
;***                You can either move files or sub directories with this
;***                function, in both cases the source path+name must not end
;***                with a "/".
;******************************************************************************
.SyFile_DIRMOV
		call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRMOV
        ret
;LIBRARY SYFILE.DIRINF
;******************************************************************************
;*** Name           Directory_DriveInformation
;*** Input          A    = Driveletter ("A"-"Z")
;***                C    = Information type
;***                       0 = general drive information
;***                       1 = free and total amount of memory
;*** Output         - Information type 0:
;***                A    = Type
;***                       00 = Device does not exist
;***                       01 = Device is ready
;***                       02 = Device is not initialized
;***                       03 = Device is corrupt
;***                B    = Medium
;***                       01 = Floppy disc single side (Amsdos)
;***                       02 = Floppy disc double side (Fat 12)
;***                       08 = Ram disc
;***                       16 = IDE hard disc or CF card (Fat 16, Fat 32)
;***                C    = File system
;***                       01 = Amsdos Data
;***                       02 = Amsdos System
;***                       16 = Fat 12
;***                       17 = Fat 16
;***                       18 = Fat 32
;***                D    = Sectors per cluster
;***                IY,IX= Total number of clusters
;***                - Information type 1:
;***                HL,DE= Number of free 512Byte sectors
;***                IY,IX= Total number of clusters
;***                C    = Sectors per cluster
;***                - Information type 0 and 1:
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F
;*** Description    Returns information about one drive. This function can be
;***                used to find out the amount of free memory on one drive.
;***                Please note, that calculating the free amount of memory on
;***                a FAT16 device may take a while, as everytime the whole FAT
;***                (up to 128KB) needs to be scanned.
;******************************************************************************
.SyFile_DIRINF
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRINF
        ret
;LIBRARY SYFILE.DEVDIR
;******************************************************************************
;*** Name           Directory_Input_Extended
;*** Input          A    = [bit0-3] Destination buffer ram bank (0-8)
;***                       [bit4-7] Directory path ram bank (0-8)
;***                HL   = Directory path address (may include a search mask)
;***                DE   = Destination buffer address. This must first contain two
;***                       words with additional information at the beginning:
;***                       00  1W  Address of list control table
;***                       02  1W  Maximum number of entries
;***                       This function will overwrite this information and fill
;***                       the buffer with the directory data.
;***                BC   = Maximum size of destination buffer
;***                IXL  = forbidden attributes
;***                       Bit0 = 1 -> don't show read only files
;***                       Bit1 = 1 -> don't show hidden files
;***                       Bit2 = 1 -> don't show system files
;***                       Bit3 = 1 -> don't show volume ID entries
;***                       Bit4 = 1 -> don't show directories
;***                       Bit5 = 1 -> don't show archive files
;***                IY   = Number of entries, which should be skipped
;***                IXH  = Additional columns
;***                       Bit0 = 1 -> File size
;***                       Bit1 = 1 -> Date and time (last modified)
;***                       Bit2 = 1 -> Attributes
;*** Output         HL   = Number of read entries
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,IX,IY
;*** Description    This is a very powerful extension of the directory input
;***                (DIRINP) function. It reads the content of a directory and
;***                converts it into ready to use list control data. So if your
;***                application wants to display the content of a directory inside
;***                a list control, it can use this function and doesn't need to do
;***                any conversion jobs by itself. Also the list control itself can
;***                do the sorting of the directory.
;***                First you have to reserve two memory areas in the same ram
;***                bank. One area needs to be reserved inside the data ram area.
;***                It will contain the texts (file names, dates etc.) and numbers
;***                (file sizes) for the list control. You can choose any size, but
;***                we recommend at least 4000 Bytes. BC must contain its size,
;***                when you call the function. DE contains the address, and the
;***                low nibble of A the ram bank number.
;***                The second area needs to be reserved inside the transfer ram
;***                area of the same bank. It contains the data structure of the
;***                list control. It size is calculated like this:
;***                Size = Maximum_number_of_entries * (4 + Additional_columns * 2)
;***                So when you have two additional columns (like date and
;***                attributes) and want to load up to 100 entries, you need to
;***                reserve 800 bytes.
;***                As there are no more Z80-registers available, the address of
;***                this memory area and the maximum number of entries must be
;***                written to the beginning of the other memory area.
;***                For additional information about reading directories see 038
;***                (DIRINP).
;******************************************************************************
.SyFile_DEVDIR
		call 	SySystem_CallFunction
        db 		MSC_SYS_SYSFIL
        db 	FNC_FIL_DEVDIR
        ret


;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@              S Y M S T U D I O   S Y S T E M   L I B R A R Y               @
;@                    - SYMBOS SYSTEM MANAGER FUNCTIONS -                     @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;Author: Prodatron / Symbiosis
;Date:   28.10.2005

;The system manager is responsible for starting and stopping applications and
;it also provides several dialogue services.
;This library supports you in using the system manager functions.
;The existance of "AppPrzN" (a byte, where the ID of the applications process
;is stored) and "AppMsgB" (the message buffer, 14 bytes, which are placed in
;the transfer ram area) is required.


;LIBRARY SYSYSTEM.PRGRUN
;******************************************************************************
;*** Name           Program_Run_Command
;*** Input          HL = File path and name address
;***                A  = [Bit0-3] File path and name ram bank (0-8)
;***                     [Bit7  ] Flag, if system error message should be
;***                              suppressed
;*** Output         A  = Success status
;***                     0 = OK
;***                     1 = File does not exist
;***                     2 = File is not an executable and its type is not
;***                         associated with an application
;***                     3 = Error while loading (see P8 for error code)
;***                     4 = Memory full
;***                - If success status is 0:
;***                L  = Application ID
;***                H  = Process ID (the applications main process)
;***                - If success status is 3:
;***                L  = File manager error code
;*** Destroyed      F,BC,DE,IX,IY
;*** Description    Loads and starts an application or opens a document with a
;***                known type by loading the associated application first.
;***                If Bit7 of A is not set, the system will open a message box,
;***                if an error occurs during the loading process.
;***                If the operation was successful, you will find the
;***                application ID and the process ID in L and H. If it failed
;***                because of loading problems L contains the file manager
;***                error code.
;******************************************************************************
.SySystem_PRGRUN 
		inclib	SYSYSTEM.SENDMESSAGE
		inclib	SYSYSTEM.WAITMESSAGE
		ld		c,MSC_SYS_PRGRUN
		call 	SySystem_SendMessage
.SySPRn1
		call 	SySystem_WaitMessage
		cp 		MSR_SYS_PRGRUN
		jr 		nz,SySPRn1
		ld 		a,(iy+1)
		ld 		l,(iy+8)
		ld 		h,(iy+9)
		ret

;LIBRARY SYSYSTEM.PRGEND
;******************************************************************************
;*** Name           Program_End_Command
;*** Input          L  = Application ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Stops an application and releases all its used system
;***                resources. This command first stops all processes of the
;***                application. After this all open windows will be closed and the
;***                reserved memory will be released.
;***                Please note, that this command can't release memory, stop
;***                processes and timers or close windows, which are not
;***                registered for the application. Such resources first have
;***                to be released by the application itself.
;******************************************************************************
.SySystem_PrgEnd:
		inclib	SYSYSTEM.SENDMESSAGE
		ld		c,MSC_SYS_PRGEND
		jp		SySystem_SendMessage

;LIBRARY SYSYSTEM.SYSWRN
;******************************************************************************
;*** Name           Dialogue_Infobox_Command
;*** Input          HL = Content data address (#C000-#FFFF)
;***                A  = Content data ram bank (0-8)
;***                E  = [Bit0-6] Number of buttons (MUST BY ALWAYS 1)
;***                     [Bit7  ] Box type
;***                              0 = warning (default warning symbol)
;***                              1 = info (own symbol will be used)
;*** Content data   00  1W  Address of text line 1
;***                02  1W  4 * [text line 1 pen] + 2
;***                04  1W  Address of text line 2
;***                06  1W  4 * [text line 2 pen] + 2
;***                08  1W  Address of text line 3
;***                10  1W  4 * [text line 3 pen] + 2
;***                - if E[bit7] is 1:
;***                12  1W  Address of symbol (24x24 pixel SymbOS graphic format)
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Opens an info or warning box and displays three line of text
;***                and one "OK" button. If Bit7 of E is set to 1 you can specify
;***                an own symbol, which will be showed left to the text. If this
;***                bit is not set, a "!"-warning symbol will be displayed.
;***                Currently multiple choice alert boxes are not supported, which
;***                means, that the number of buttons always have to be set to 1.
;***                Please note, that the content data must always be placed in the
;***                transfer ram area (#C000-#FFFF). The texts itself and the
;***                optional graphic must always be placed inside a 16K (data ram
;***                area).
;***                As the text line pen, you should choose 1, so 6 would be the
;***                correct value.
;***                For more information about the mentioned memory types (data,
;***                transfer) see the "applications" chapter.
;***                For more information about the SymbOS graphic format see the
;***                "desktop manager data records" chapter.
;******************************************************************************
.SySystem_SYSWRN:
		inclib	SYSYTEM.SENDMESSAGE
		ld		c,MSC_SYS_SYSWRN
		jp		SySystem_SendMessage

;### SUB ROUTINES #############################################################

;LIBRARY SYSYSTEM.SENDMESSAGE
;******************************************************************************
;*** Input          C       = Command
;***                HL,A,DE = additional Parameters
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the system manager
;******************************************************************************
.SySystem_SendMessage:
		ld		iy,AppMsgB
		ld 		(iy+0),c
		ld 		(iy+1),l
		ld 		(iy+2),h
		ld 		(iy+3),a
		ld		(iy+4),e
		ld		(iy+5),d
		db 		#dd:ld h,3       ;3 is the number of the system manager process
		ld 		a,(AppPrzN)
		db 		#dd:ld l,a
		rst 	#10
		ret

;LIBRARY SYSYSTEM.WAITMESSAGE
;******************************************************************************
;*** Input          -
;*** Output         IY = message buffer
;***                A  = first byte in the Message buffer (IY+0)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the desktop manager, which includes the
;***                window ID and additional parameters
;******************************************************************************
.SySystem_WaitMessage:
		ld		iy,AppMsgB
.SySWMs1
		db		#dd:ld h,3       ;3 is the number of the system manager process
		ld		a,(AppPrzN)
		db 		#dd:ld l,a
		rst 	#08             ;wait for a system manager message
		db 		#dd:dec l
		jr 		nz,SySWMs1
		ld 		a,(iy+0)		
		ret

;LIBRARY SYKERNAL.MTADDP		
;******************************************************************************
;*** Name           Multitasking_Add_Process_Command
;*** Input          HL = Stack address (see notes below)
;***                A  = Ram bank (0-8)
;***                E  = Priority (1=highest, 7=lowest)
;*** Output         A  = Process ID
;***                CF = Success status
;***                     0 = OK
;***                     1 = the process couldn't been added, as the maximum
;***                         number of processes (32) has been reached
;*** Destroyed      BC,DE,HL,IX,IY
;*** Description    Adds a new process with a given priority and starts it
;***                immediately.
;***                Application processes usually will be started with priority 4.
;***                Note, that the desktop manager process runs with priority 1,
;***                the system manager process with 2. If you start a process,
;***                which should do some long and intensive calculation, you should
;***                choose a priority greater than 4, so that other applications
;***                will not be disturbed.
;***                The stack must always be placed between #C000 and #FFFF
;***                (transfer ram area). It must contain the start address of the
;***                process (or timer) routine at offset 12 and may contain the
;***                initial values of the registers. You can choose the size of the
;***                stack buffer by yourself, just be sure, that it is large
;***                enough.
;***                At offset 13 there must be a free byte. In this byte the kernel
;***                will write the ID of the process (or timer) after it has been
;***                started.
;*** Example(stack)                ds 128              ;Stack buffer
;***                stack_pointer: dw 0                ;initial value for IY
;***                               dw 0                ;initial value for IX
;***                               dw 0                ;initial value for HL
;***                               dw 0                ;initial value for DE
;***                               dw 0                ;initial value for BC
;***                               dw 0                ;initial value for AF
;***                               dw process_start    ;process start address
;***                process_id:    db 0                ;kernel writes the ID here
;******************************************************************************
.SyKernel_MTADDP:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_MTADDP
		call	SyKernel_Message
        Xor		a
        cp		l
        ld		a,h
        ret

;LIBRARY SYKERNAL.MTDELP
;******************************************************************************
;*** Name           Multitasking_Delete_Process_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Stops an existing process and deletes it.
;******************************************************************************
.SyKernal_MTDELP:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_MTDELP
		ld		l,a
		jp		SyKernel_Message

;LIBRARY SYKERNAL.MTADDT
;******************************************************************************
;*** Name           Multitasking_Add_Timer_Command
;*** Input          HL = Stack address (see notes below)
;***                A  = Ram bank (0-8)
;*** Output         A  = Timer ID
;***                CF = Success status
;***                     0 = OK
;***                     1 = the timer couldn't been added, as the maximum
;***                         number of timers (32) has been reached
;*** Destroyed      BC,DE,HL,IX,IY
;*** Description    Adds a new timer and starts it immediately. Timers will be
;***                called 50times per second. Please see MSC_KRL_MTADDP for
;***                information about the stack.
;******************************************************************************
.SyKernel_MTADDT:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_MTADDT
		call	SyKernel_Message
		Xor		a
		cp		l
		ld		a,h
		ret

;LIBRARY SYKERNAL.MTDELT
;******************************************************************************
;*** Name           Multitasking_Delete_Timer_Command
;*** Input          A  = Timer ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Stops an existing timer and deletes it.
;******************************************************************************
.SyKernel_MTDELT:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_MTDELT
		ld		l,a
		jp		SyKernel_Message

;LIBRARY SYKERNAL.MTSLPP
;******************************************************************************
;*** Name           Multitasking_Sleep_Process_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Puts an existing process into the sleep mode. It is stopped and
;***                does not run anymore, until it receives a message, or until it
;***                will be wacked up again (see MSC_KRL_MTWAKP).
;***                Usually this command is not needed, as a process can put itself
;***                into the sleep mode with the MSGSLP restart (see above).
;******************************************************************************
.SyKernel_MTSLPP:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_MTSLPP
		ld		l,a
		jp		SyKernel_Message

;LIBRARY SYKERNAL.MTWAKP
;******************************************************************************
;*** Name           Multitasking_WakeUp_Process_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Wakes up a process, which was sleeping before. A process will
;***                be wacked up, too, when another process is sending a message to
;***                it.
;******************************************************************************
.SyKernel_MTWAKP:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_MTWAKP
		ld		l,a
		jp		SyKernel_Message

;LIBRARY SYKERNAL.TMADDT
;******************************************************************************
;*** Name           Timer_Add_Counter_Command
;*** Input          HL = Counter byte address
;***                E  = Counter byte ram bank (0-8)
;***                A  = Process ID
;***                B  = Speed (counter will be increased every x/50 second)
;*** Output         CF = Success status
;***                     0 = OK
;***                     1 = the timer couldn't been added, as the maximum
;***                         number of counter (16) has been reached
;*** Description    Adds a counter for a process. You need to specify a byte
;***                anywhere in the memory. This byte then will be increased every
;***                B/50 seconds. So if you want, that the kernel increases it once
;***                per second, you have to set B to 50.
;***                As an example you could check this byte regulary, and if it has
;***                been changed you call an event routine. This is much easier and
;***                faster than setting up an own timer.
;******************************************************************************
.SyKernel_TMADDT:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_TMADDT
		call	SyKernel_Message
		Xor		a
		cp		l
		ret

;LIBRARY SYKERNAL.TMDELT
;******************************************************************************
;*** Name           Timer_Delete_Counter_Command
;*** Input          HL = Counter byte address
;***                E  = Counter byte ram bank (0-8)
;*** Output         -
;*** Description    Stops the specified counter. Please note, that this will be
;***                done automatically, if the process should be deleted.
;******************************************************************************
.SyKernel_TMDELT:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_TMDELT
		jp		SyKernel_Message

;LIBRARY SYKERNAL.TMDELP
;******************************************************************************
;*** Name           Timer_Delete_AllProcessCounters_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Description    Stops all counters of one process. Please note, that this will
;***                be done automatically, if the process should be deleted.
;******************************************************************************
.SyKernel_TMDELP:
		inclib	SYKERNAL.MESSAGE
		ld		c,MSC_KRL_TMDELP
		ld		l,a
		jp		SyKernel_Message
		
;LIBRARY SYKERNAL.MESSAGE
;******************************************************************************
;*** Input          C        = Command
;***                HL,E,A,B = Additional parameters
;*** Output         HL       = returned parameters
;*** Destroyed      AF,BC,DE,IX,IY
;*** Description    Sends a message to the kernel, waits for the answer and
;***                returns the result
;******************************************************************************
.SyKernel_Message: 
		ld		iy,AppMsgB
		ld		(iy+0),c
		ld		(iy+1),l
		ld		(iy+2),h
		ld		(iy+3),e
		ld		(iy+4),a
		ld		(iy+5),b
		ld		a,c
		add 	128
		ld		(SyKMsgN),a
        db 		#dd:ld h,1       ;1 is the number of the kernel process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 		#10
.SyKMsg1 
		db 		#dd:ld h,1       ;1 is the number of the kernel process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#08             ;wait for a kernel message
        db 		#dd:dec l
        jr 		nz,SyKMsg1
        ld 		a,(SyKMsgN)
        cp 		(iy+0)
        jr 		nz,SyKMsg1
        ld 		l,(iy+1)
        ld 		h,(iy+2)
        ret
.SyKMsgN db 0





;LIBRARY SYDESKTOP.WINOPN
;******************************************************************************
;*** Name           Window_Open_Command
;*** Input          A  = Window data record ram bank (0-8)
;***                DE = Window data record address (#C000-#FFFF)
;*** Output         A  = Window ID (only, if CF=0)
;***                CF = Success status
;***                     0 = OK
;***                     1 = window couldn't be opened, as the maximum number
;***                         of windows (32) has been reached
;*** Destroyed      BC,DE,HL,IX,IY
;*** Description    Opens a new window. Its data record must be placed in the
;***                transfer ram area (between #c000 and #ffff).
;***                For more information about the window data record see the
;***                chapter "desktop manager data records".
;***                For more information about the transfer ram memory types see
;***                the "applications" chapter.
;******************************************************************************
.SyDesktop_WINOPN:
		inclib 	SYDESKTOP.SENDMESSAGE
		inclib 	SYDESKTOP.WAITMESSAGE		
		ld		b,a
        db 		#dd:ld l,e
        db 		#dd:ld h,d
        ld 		a,(AppPrzN)      ;register window for the application process
        ld 		(ix+3),a
        ld 		a,b
        ld 		c,MSC_DSK_WINOPN
        call 	SyDesktop_SendMessage
.SyWOpn1 
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_WOPNER
        scf
        ret 	z               ;return with set carry flag, if window couldn't be opened
        cp 		MSR_DSK_WOPNOK
        jr 		nz,SyWOpn1       ;different message than "open ok" -> continue waiting
        ld 		a,(iy+4)         ;get window ID and return with cleared carry flag
        ret

;LIBRARY SYDESKTOP.WINMEN
;******************************************************************************
;*** Name           Window_Redraw_Menu_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the menu bar of a window. If you changed your menus you
;***                should call this command to update the screen display.
;******************************************************************************
.SyDesktop_WINMEN:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINMEN
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WININH		
;******************************************************************************
;*** Name           Window_Redraw_Content_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  content.
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws one, all or a specified number of controls inside the
;***                window content. This command is very important, if you make
;***                changes and want to display them.
;***                This command is identical with MSC_DSK_WINDIN with the
;***                exception, that it only works, if the window has focus. Because
;***                of this, it is a little bit faster, as the desktop manager
;***                doesn't need to take care about other windows, which could hide
;***                some parts of the window.
;******************************************************************************
.SyDesktop_WININH:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WININH
        jp 		SyDesktop_SendMessage
		
;LIBRARY SYDESKTOP.WINTOL
;******************************************************************************
;*** Name           Window_Redraw_Toolbar_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  toolbar.
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws one, all or a specified number of controls inside the
;***                window toolbar. Use this command to update the screen display,
;***                if you made changes in the toolbar.
;******************************************************************************
.SyDesktop_WINTOL:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINTOL
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINTIT
;******************************************************************************
;*** Name           Window_Redraw_Title_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the title bar of a window. Use this command to update
;***                the screen display, if you changed the text of the window
;***                title.
;******************************************************************************
.SyDesktop_WINTIT:
		inclib 	SYDESKTOP.SENDMESSAGE
		ld 		c,MSC_DSK_WINTIT
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINSTA
;******************************************************************************
;*** Name           Window_Redraw_Statusbar_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the status bar of a window. Use this command to update
;***                the screen display, if you changed the text of the status bar.
;******************************************************************************
.SyDesktop_WINSTA:
		inclib 	SYDESKTOP.SENDMESSAGE
		ld 		c,MSC_DSK_WINSTA
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINMVX
;******************************************************************************
;*** Name           Window_Set_ContentX_Command
;*** Input          A  = Window ID
;***                DE = new X offset of the visible window content
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    If the size of the window content is larger than the visible
;***                part, you can scroll its X offset with this command. The
;***                command works also, if the window is not resizeable by the
;***                user.
;******************************************************************************
.SyDesktop_WINMVX:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINMVX
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINMVY
;******************************************************************************
;*** Name           Window_Set_ContentY_Command
;*** Input          A  = Window ID
;***                DE = new Y offset of the visible window content
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    If the size of the window content is larger than the visible
;***                part, you can scroll its Y offset with this command. The
;***                command works also, if the window is not resizeable by the
;***                user.
;******************************************************************************
.SyDesktop_WINMVY:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINMVY
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINTOP
;******************************************************************************
;*** Name           Window_Focus_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Takes the window to the front position on the screen.
;******************************************************************************
.SyDesktop_WINTOP:
		inclib 	SYDESKTOP.SENDMESSAGE
		ld 		c,MSC_DSK_WINTOP
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINMAX
;******************************************************************************
;*** Name           Window_Size_Maximize_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is minimized or restored
;*** Description    Maximizes a window. A maximized window has a special status,
;***                where it can't be moved to another screen position.
;******************************************************************************
.SyDesktop_WINMAX:
		inclib 	SYDESKTOP.SENDMESSAGE
		ld 		c,MSC_DSK_WINMAX
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINMIN
;******************************************************************************
;*** Name           Window_Size_Minimize_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is maximized or restored
;*** Description    Minimizes a window. It will disappear from the screen and can
;***                only be accessed by the user via the task bar.
;******************************************************************************
.SyDesktop_WINMIN:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINMIN
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINMID
;******************************************************************************
;*** Name           Window_Size_Restore_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is maximized or minimized
;*** Description    Restores the window or the size of the window, if it was
;***                minimized or maximized before.
;******************************************************************************
.SyDesktop_WINMID:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINMID
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINMOV
;******************************************************************************
;*** Name           Window_Set_Position_Command
;*** Input          A  = Window ID
;***                DE = new X window position
;***                HL = new Y window position
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is not maximized
;*** Description    Moves the window to another position on the screen. This will
;***                not work, if the window is maximized.
;******************************************************************************
.SyDesktop_WINMOV:
		inclib 	SYDESKTOP.SENDMESSAGE
		ld 		c,MSC_DSK_WINMOV
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINSIZ
;******************************************************************************
;*** Name           Window_Set_Size_Command
;*** Input          A  = Window ID
;***                DE = new window width
;***                HL = new window height
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Resizes a window. This command will always work, even if the
;***                window is not resizeable by the user.
;***                Please note, that the size always refers to the visible content
;***                of the window, not to the whole window including the control
;***                elements. So with title bar, scroll bars etc. a window can have
;***                a bigger size on the screen.
;******************************************************************************
.SyDesktop_WINSIZ:
		inclib 	SYDESKTOP.SENDMESSAGE
		ld 		c,MSC_DSK_WINSIZ
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINCLS
;******************************************************************************
;*** Name           Window_Close_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Closes the window. The desktop manager will remove it from the
;***                screen.
;******************************************************************************
.SyDesktop_WINCLS:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINCLS
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINDIN
;******************************************************************************
;*** Name           Window_Redraw_ContentExtended_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  content.
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Redraws one, all or a specified number of controls inside the
;***                window content. This command is identical with MSC_DSK_WININH
;***                with the exception, that it always works but with less speed.
;***                For more information see MSC_DSK_WININH.
;******************************************************************************
.SyDesktop_WINDIN:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINDIN
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINSLD
;******************************************************************************
;*** Name           Window_Redraw_Slider_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the two slider of the window, with which the user can
;***                scroll the content. Sliders will only be displayed, if the
;***                window is resizeable.
;***                Usally you should use MSC_DSK_WINMVX and MSC_DSK_WINMVY to
;***                scroll the content of the window. These commands will update
;***                the sliders by themself.
;***                If you manipulate the content position in the window data
;***                record by yourself, you can use this command to update the
;***                screen display.
;******************************************************************************
.SyDesktop_WINSLD:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		c,MSC_DSK_WINSLD
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.WINPIN
;******************************************************************************
;*** Name           Window_Redraw_ContentArea_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  content.
;***                HL = Area X begin inside the window content
;***                BC = Area Y begin
;***                IX = Area X length
;***                IY = Area Y length
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    This command works like MSC_DSK_WINDIN, but it updates only a
;***                specified area inside the window content. Changes outside the
;***                area won't be updated. This command is especially useful for
;***                updating large graphics, if only a part of the graphic should
;***                be updated, and you don't want to loose performance with
;***                updating the other parts of it, too.
;***                For more information see MSC_DSK_WINDIN and MSC_DSK_WININH.
;******************************************************************************
.SyDesktop_WINPIN:
		inclib 	SYDESKTOP.SENDMESSAGE
        ld 		(AppMsgB+06),bc
        ld 		(AppMsgB+08),ix
        ld 		(AppMsgB+10),iy
        ld 		c,MSC_DSK_WINPIN
        jp 		SyDesktop_SendMessage

;LIBRARY SYDESKTOP.MODGET
;******************************************************************************
;*** Name           DesktopService_ScreenModeGet
;*** Input          -
;*** Output         E  = Screen mode
;***                     0 = 160 x 200, 16 colours
;***                     1 = 320 x 200,  4 colours (standard mode)
;***                     2 = 640 x 200,  2 colours
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Returns the actual screen resolution and number of possible
;***                colours.
;******************************************************************************
.SyDesktop_MODGET:
		inclib 	SYDESKTOP.SERVICE
        ld 		a,DSK_SRV_MODGET
        jp 		SyDesktop_Service

;LIBRARY SYDESKTOP.MODSET
;******************************************************************************
;*** Name           DesktopService_ScreenModeSet
;*** Input          E  = Screen mode
;***                     0 = 160 x 200, 16 colours
;***                     1 = 320 x 200,  4 colours (standard mode)
;***                     2 = 640 x 200,  2 colours
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sets the screen resolution and number of possible colours.
;******************************************************************************
.SyDesktop_MODSET:
		inclib 	SYDESKTOP.SERVICE
        ld 		a,DSK_SRV_MODSET
        jp 		SyDesktop_Service

;LIBRARY SYDESKTOP.COLGET
;******************************************************************************
;*** Name           DesktopService_ColourGet
;*** Input          E  = Colour number (0-15)
;*** Output         D  = Bit[0-3] blue  component (0-15)
;***                     Bit[4-7] green component (0-15)
;***                L  = Bit[0-3] red   component (0-15)
;*** Destroyed      AF,BC,E,H,IX,IY
;*** Description    Returns the definition of a colours. Please note, that you
;***                always have a range of 4096, even if the computer is not a CPC
;***                PLUS, as the system recalculates the colour for standard CPCs
;***                (factor 5,33 for each component).
;******************************************************************************
.SyDesktop_COLGET:
		inclib 	SYDESKTOP.SERVICE
        ld 		a,DSK_SRV_COLGET
        jp 		SyDesktop_Service

;LIBRARY SYDESKTOP.COLSET
;******************************************************************************
;*** Name           DesktopService_ColourSet
;*** Input          E  = Colour number (0-15)
;***                D  = Bit[0-3] blue  component (0-15)
;***                     Bit[4-7] green component (0-15)
;***                L  = Bit[0-3] red   component (0-15)
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Defines one colour. Please note, that you always have a range
;***                of 4096, even if the computer is not a CPC PLUS, as the system
;***                recalculates the colour for standard CPCs (factor 5,33 for each
;***                component).
;******************************************************************************
.SyDesktop_COLSET:
		inclib 	SYDESKTOP.SERVICE
		ld 		a,DSK_SRV_COLSET
        jp 		SyDesktop_Service

;LIBRARY SYDESKTOP.DSKBGR
;******************************************************************************
;*** Name           DesktopService_RedrawBackground
;*** Input          -
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Redraws the desktop background.
;******************************************************************************
.SyDesktop_DSKBGR:
		inclib 	SYDESKTOP.SERVICE
        ld 		a,DSK_SRV_DSKBGR
        jp 		SyDesktop_Service

;LIBRARY SYDESKTOP.DSKPLT
;******************************************************************************
;*** Name           DesktopService_RedrawComplete
;*** Input          -
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Redraws the complete screen. The background, the task bar and
;***                all windows will be updated.
;******************************************************************************
.SyDesktop_DSKPLT:
		inclib 	SYDESKTOP.SERVICE
        ld 		a,DSK_SRV_DSKPLT
        jp 		SyDesktop_Service

;LIBRARY SYDESKTOP.SERVICE
;******************************************************************************
;*** Input          A     = Function
;***                DE,HL = additional parameters
;*** Output         DE,HL = returned parameters
;*** Destroyed      AF,BC,IX,IY
;*** Description    Sends a service request message to the desktop manager,
;***                waits for the answer and returns with the result
;******************************************************************************
.SyDesktop_Service:
		inclib 	SYDESKTOP.SENDMESSAGE
		inclib	SYDESKTOP.WAITMESSAGE
		ld 		c,MSC_DSK_DSKSRV
        ld 		(SyDSrvN),a
        push 	af
        call 	SyDesktop_SendMessage
        pop 	af
        cp 		1
        jr 		z,SyDSrv1
        cp 		3
        jr 		z,SyDSrv1
        cp 		5
        ret 	nz
.SyDSrv1:
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_DSKSRV
        jr 		nz,SyDSrv1
        ld 		a,(SyDSrvN)
        cp 		(iy+1)
        jr 		nz,SyDSrv1
        ld 		e,(iy+2)
        ld 		d,(iy+3)
        ld 		l,(iy+4)
        ld 		h,(iy+5)
        ret
.SyDSrvN db 0

;LIBRARY SYDESKTOP.SENDMESSAGE
;******************************************************************************
;*** Input          C  = Command
;***                A  = Window ID
;***                DE,HL = additional parameters
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the desktop manager, which includes the
;***                window ID and additional parameters
;******************************************************************************
.SyDesktop_SendMessage:
        ld 		iy,AppMsgB
        ld 		(iy+0),c
        ld 		(iy+1),a
        ld 		(iy+2),e
        ld 		(iy+3),d
        ld 		(iy+4),l
        ld 		(iy+5),h
        db 		#dd:ld h,2       ;2 is the number of the desktop manager process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#10
        ret
	
		

;LIBRARY SYDESKTOP.WAITMESSAGE
;******************************************************************************
;*** Input          -
;*** Output         IY = message buffer
;***                A  = first byte in the Message buffer (IY+0)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the desktop manager, which includes the
;***                window ID and additional parameters
;******************************************************************************
.SyDesktop_WaitMessage: 
		ld 		iy,AppMsgB
.SyDWMs1:
		db 		#dd:ld h,2       ;2 is the number of the desktop manager process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#08             ;wait for a desktop manager message
        db 		#dd:dec l
        jr 		nz,SyDWMs1
        ld 		a,(iy+0)
        ret