
;***************
;**** Code *****
;***************
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3

.V_App_In_Use			db 	0

.AppPrz:
;**** Open Primary Window ****

		ld		hl,AppTrnEnd+260
		ld		a,h
		ld		(Quig_String_AS_HByte),a		;Set Byte so we can check if string is in String area or String buffer

		;Save the Machine type
		ld		hl,jmp_sysinf        ;*** get computer type
        ld		de,256+5
        ld 		ix,Quig_Machine_Type
        ld 		iy,66+2+6+8
        rst 	#28
		ld		a,(Quig_Machine_Type)
		and		31
		ld		(Quig_Machine_Type),a

		ld		a,AppStartForm					;**** Form to Open first
		ld		l,a
		ld		h,0
		call	Quig_Form_Open					;**** Form Opener
	#IF USETIMER	
		;**** Sets up the Timer Stack ****
		ld		hl,Quig_TimerStack
		ld		a,(AppBnkNum)
		ld		e,7
		ld 		c,MSC_KRL_MTADDP
		call 	SyKernel_Message
        xor 	a
        cp 		l
        ld 		a,h
		;call	SyKernel_MTADDT
  		jp      c,Quig_End
       	ld      (PrgPstSpz+AppCodBeg),a
	#ENDIF
	
	#IF USESYSTRAY
	.Quig_SysTray_Add:
		ld		de,Icon24_Data-19
		ld		l,-1
		ld 		c,MSC_DSK_STIADD
        ld 		b,a
        ld 		a,(AppPrzN)
        ld 		h,a
        ld 		a,(AppBnkNum)
        call 	SyDesktop_SendMessage
.Quig_SysTray_Add_x:		
		call 	SyDesktop_WaitMessage
        cp 		MSR_DSK_STIADD
        jr 		nz,Quig_SysTray_Add_x
        ld 		hl,(AppMsgB+1)
        push 	hl
        pop 	af
		jr		nc,2
		ld		a,255
		ld		(Quig_systray_Icon),a
		jr		1
.Quig_systray_Icon: db	0
	#ENDIF	
	
;****************************************
;**** Main Application Control Loop *****
;****************************************
.Quig_Control_Loop:
		ld		a,(V_App_In_Use)
		And		a
		jr		nz,Quig_Control_Loop_1
		rst		#30								;Wait for message
		ld		a,(AppPrzN)		
       	db		#dd:ld l,a
		db		#dd:ld h,-1
 		ld		iy,AppMsgB
		rst		#18
		db		#dd:dec l						;AppMsgB should be populated
		jr		nz,Quig_Control_Loop_2			;No Message so just run Main()code.	
	#IF USENET
		ld		a,(Quig_Net_Process)			;Get Process number (Default 255 until set)
		cp		255							
		jr		z,Quig_Control_Loop_99			;=255 Net not initialized so skip
		db 		#dd:cp h
		jp		z,Quig_Net_Event				;IXH = Process number so must be Net Event
.Quig_Control_Loop_99:		
	#ENDIF
;		ld		a,(rhht)
;		cp		1
;		jr		nz,afkee
;		ld		a,(AppMsgB+0)
;		ld		de,Quig_FormIDs
;		di
;.fuckit:jr		fuckit	
;.afkee:		
		ld		a,(AppMsgB+0)					
		or		a
		jp		z,Quig_End
		scf
		cp		MSR_DSK_WCLICK					;**** Click on a Control
		jp		z,Quig_Control_Event
		cp		MSR_DSK_WRESIZ					;**** Resize window ?
		jp		z,Quig_Form_Event_Resize
		cp		MSR_DSK_WSCROL					;**** Scrolled Form ?
		jp		z,Quig_Form_Event_Scroll
		cp		MSR_DSK_WFOCUS					;**** Focus window change ?
		jp		z,Quig_Form_Event_Window_Focus
		cp		MSR_DSK_CFOCUS					;**** Focus change ?
		jp		z,Quig_Form_Event_Focus	
		cp		MSR_DSK_WMODAL					;**** Clicked form blocked by a Modal
		jp		z,Quig_Form_Event_PopUp
		
	#IF USESYSTRAY	
		cp 		MSR_DSK_STICLK
		call	z,qfunc_SysTray_Event
	#ENDIF				
.Quig_Control_Loop_2:
		call	qfunc_main
.Quig_Control_Loop_1:
		Xor		a
		ld		(V_App_In_Use),a	
		jp		Quig_Control_Loop
		
#IF USENET		
;**** NET EVENTS		
.Quig_Net_Event:
;		INCLIB   QUIG.NET.TCP.FIND.FREE.HANDLE
;		INCLIB   QUIG.NET.TCP.SOCKET.COUNT
        call 	snwmsgo_afbcdehlixiy
		ld		(Quig_Event_Net_Handle),a
		ld		a,l
		ld		(Quig_Event_Net),a
		
		ld		(Quig_Net_Received_Value),bc
		
		ld		a,(Quig_Event_Net)
		cp		2					;tcpestablished
		jp		z,Quig_Found_TCP_Establish
		cp		128
		jp		z,Quig_Found_Data_Received
		cp		3
		jp		z,Quig_Found_Data_Received		
		cp		4
		jp		z,Quig_Found_Data_Received
		
		jp		Quig_Control_Loop_2

.Quig_Found_Data_Received:
		jp		Quig_Net_Event6
		
.Quig_Found_TCP_Establish:
		ld		(Quig_Event_Net_Port),de
		ld		(Quig_Event_Net_IXIY),ix
		ld		(Quig_Event_Net_IXIY+2),iy
.Quig_Net_Event6:		
		call 	QFunc_Net_Event	
.Quig_Net_Event7:
		jp		Quig_Control_Loop_2
		
.Quig_Net_Error:			dw	0
.Quig_Net_Handle:			db	255
.Quig_Net_Process:			db	255

.Quig_Net_TCP_Server:		db	0
.Quig_Net_TCP_Server_Port:	dw	0
.Quig_Net_TCP_Socket:		db 	0
.Quig_Net_TCP_Socket_Max:	db 	0

.Quig_Net_Received_Value:	dw	0
.Quig_Net_Transfered_Value:	dw 	0
.Quig_Net_Send_Wait_Value:	dw 	0

.Quig_Event_Net:			db	0
.Quig_Event_Net_Handle:		db	255
.Quig_Event_Net_Port:		dw	0
.Quig_Event_Net_IXIY:		dw	0,0

#ENDIF
.Quig_DataAddr:				dw 	0

.Quig_Math_StackPointer:	dw	Quig_Math_Stack
.Quig_Math_Stack:			ds	60
.Quig_Math_StackTop:
		
;**** Redirect a Clicked on Control Event		
.Quig_Control_Event:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		a,(Event_Type)	 		
 		cp		DSK_ACT_CONTENT
 		jp		z,Quig_Content
 		cp		DSK_ACT_TOOLBAR
 		jp		z,Quig_Tool		
		cp		DSK_ACT_CLOSE
		jp		z,Quig_Form_CloseEvent
		cp		DSK_ACT_MENU
 		jp		z,Quig_Menu
		cp		DSK_ACT_KEY
		jp		z,Quig_Key

		jp		Quig_Control_Loop_2
		
;**** Form Event ****
.Quig_Form_Event_PopUp:
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch		
		ld		hl,Quig_FormClickOff
		ld		d,0
		add		hl,de
		ld		a,(hl)
		and		a
		jp		z,Quig_Control_Loop_1
		
		ld		l,e
		ld		h,0
		call	Quig_Form_Close		
		jp		Quig_Control_Loop_1		

.Quig_Form_Event_Window_Focus:
		ld		a,(Quig_Form_Focus)				;Focus Event Happened
		inc		a								;Inc
		ld		(Quig_Form_Focus),a				;Store 
		jp		Quig_Control_Loop_1				;Return
		ld		a,(Event_Type)
		and		a
		jr		z,Quig_Form_Event_Window_FocusLost
		call	Quig_FormSearch
		ld		a,e
		jr		Quig_Form_Event_Window_Focus2
.Quig_Form_Event_Window_FocusLost:
		ld		a,255
.Quig_Form_Event_Window_Focus2:		
		ld		(Quig_Form_Focus),a
		jp		Quig_Control_Loop_1
.Quig_Form_Focus:	db	0		

.Quig_Form_Event_Focus:
		ld		a,5
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Scroll
		ld		a,4
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Resize
		ld		a,3
.Quig_Form_Event_X:		
		ld		(Quig_Form_Event_X_1+1),a
		call	Quig_FormSearch
		ld		a,e
.Quig_Form_Event_X_1
		ld		c,0								;**** C = 3/4 etc
		call	SyB_Call_Form_Event
		jp		Quig_Control_Loop_1
		
;*********************
;**** Key Control ****
;*********************
.Quig_Key:
		ld		a,(AppMsgB+4)
		and		%10000000
;		jp		z,Quig_Content
		jp		Quig_Control_Loop_2

;**********************
;**** Menu Control ****
;**********************
.Quig_Menu:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		hl,(AppMsgB+8)
		Xor		a
		cp		h
		jr		nz,Quig_Call_Set12
		cp		l
		jp		z,Quig_Control_Loop_1
.Quig_Call_Set12
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld		(Quig_Call_Set2+1),hl
.Quig_Call_Set2:
		call	0
		pop		iy
		pop		ix		
		jp		Quig_Control_Loop_1

		
;****************************************
;**** User has clicked on one Tool Control ****
;****************************************		
.Quig_Tool:
		ld		hl,ControWindowDataList+2
		Jr		Quig_Content2
;**** User has clicked on one Control ****
.Quig_Content:
		ld		hl,ControWindowDataList
.Quig_Content2:
		push	hl	
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch
		ld		l,e
		ld		h,0
		add		hl,hl
		add		hl,hl	
		pop		de
		add		hl,de
	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(Event_Control_ID)
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de

		
		inc		hl
		inc		hl	
		ld		a,(hl)					;Get the Type
		cp		43						;Is it MultiList (Sorting)
		jr		nz,Quig_Content6		;No Then Skip
		push	hl						;Store HL for return
		inc		hl
		inc		hl
		ld		e,(hl)					;Address of ExtData for List
		inc		hl
		ld		d,(hl)
		push	de						;Push Address min DE
		pop		ix						;Return Address in IX
		call	Quig_srtfix				;DO sort routine if necessary
		pop		hl						;Restore HL
.Quig_Content6:
		ld		de,12
		add		hl,de
		ld		e,(hl)
		inc 	hl
		ld		d,(hl)
		Xor		a
		cp		e
		jp		nz,Quig_Content_Event_1
		cp		d
		jp		nz,Quig_Content_Event_1
		jp		Quig_Control_Loop
.Quig_Content_Event_1:
		Xor		a
		ld		(V_App_In_Use),a
		ld		(Quig_Content_Event_2+1),de
.Quig_Content_Event_2
		call	0
		jp		Quig_Control_Loop_1	
.rhht:	db	0		

;****                       ****		
;**** Shut down Application ****
;****                       ****	
.Quig_End:
	#IF USESYSTRAY
		ld		a,(Quig_systray_Icon)
		cp		255
		jr		z,Quig_End_X2
		ld 		c,MSC_DSK_STIREM
		call 	SyDesktop_SendMessage
	#ENDIF
.Quig_End_X2:	
		ld		a,(AppPrzN)
		db		#dd:ld l,a
		ld		a,(SysPrzN)
		db		#dd:ld h,a
		ld		a,(AppCodBeg+PrgPstNum)
		ld		h,a
		ld		l,MSC_SYS_PRGEND
		ld		(AppMsgB),hl
		ld		iy,AppMsgB
		rst		#10
.Quig_End_1
 		rst		#30
		jr		Quig_End_1
	
;****                  ****
;**** HL = Form Number
;****                  ****

.prgwin:db 0
.prgwin2:db 0
.Quig_Form_Open:
;HL=Quigs Form Number 0..7
		ld		a,l
		ld		(prgwin),a
		ld		de,Quig_FormIDs					;**** 8 Forms held as Symbos Window numbers	
		add		hl,de
		ld		a,(hl)
		cp		255
		ret		nz								;If Not 255 then already open
		push	hl
.Quig_Form_Open_90:
		ld		a,(prgwin)						;**** A = SymStudio Window Number			
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	Quig_GetWindowEventAddr			;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Window Data
		ld		a,(AppBnkNum)
		inclib 	SYDESKTOP.WINOPN
		call	SyDesktop_WINOPN
		pop		hl
		ret		c								;**** If Carry then hasn't Opened window
.Quig_Form_Open_91:
		ld		(hl),a							;**** Store Internal number into form list
		ld		(prgwin2),a
		ld		a,(prgwin)
		ld		c,1								;**** C = 1 = Get Open Address
		call	SyB_Call_Form_Event
		Xor		a		
		ret
;****              ****		
;**** Close a Form ****
;****              ****
;HL=Quigs Form Number
.Quig_Form_Close:
		ld		a,255
		ld		de,Quig_FormIDs					;**** 8 Forms held as Symbos Window numbers
		add		hl,de							;**** Works out place
		ld		c,(hl)							;**** C = Symbos Window number
		cp		c
		ret  	z
		ld		(hl),a							;**** Blank window
		ld		a,c								;**** A= Symbos window number
		ld 		c,MSC_DSK_WINCLS				;**** Close
        jp		SyDesktop_SendMessage		


.Quig_Form_CloseEvent
		ld		a,(Event_Form_ID)
		call	Quig_FormSearch
		ld		a,e		
		ld		c,2								;**** C = 3/4 etc
		call	SyB_Call_Form_Event
		jp		Quig_Control_Loop_1	
		

;****                       ****
;**** Check If Event and Do ****
;****                       ****
;A=Form No C=Event To search
.SyB_Call_Form_Event:
		call	Quig_GetWindowEventAddr
		Xor		a
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		cp		e		
		jr		nz,SyB_Call_Form_Event_2	
		cp		d
		ret		z
.SyB_Call_Form_Event_2	
		ld		(SyB_Call_Form_Event_3+1),de
.SyB_Call_Form_Event_3
		call	0
		ret	

;**** Get a Internal Window number in a
;IN A = Window
;OUT A = Symbos Window number or #ff
;    HL =  address of Internal window stoe
.Quig_Form_Return
;		ld		(Quig_Form_No),a				;**** Store the number of the Internal Window
		ld		hl,Quig_FormIDs					;**** Point to Start of Window List
		ld		e,a								;**** DE = A
		ld		d,0
		add		hl,de							;**** Calc Position
		ld		a,(hl)							;**** Checks if exists
		ret
;****                                 ****
;**** Get User Form No fro OS Form No ****
;****                                 ****
.Quig_FormSearch:
		ld		a,(Event_Form_ID)
		ld		b,8
		ld		e,0
		ld		hl,Quig_FormIDs	
.Quig_FormSearch_1	
		cp		(hl)
		ret		z
		inc		e
		inc		hl
		djnz	Quig_FormSearch_1
		ret		


;### SRTFIX -> checks for list sort and corrects Quigs addresses of GUI string pointers
;### Input      IX=list record
;### Destroyed  AF,BC,DE,HL,IX,IY
.Quig_srtfix:
		bit 	0,(ix+15)
        ret 	z
        ld 		(ix+15),0
		

		
        ld 		l,(ix+0)
        ld 		h,(ix+1)            ;hl=number of lines
        ld 		e,(ix+4)
        ld 		d,(ix+5)
        push 	de                 	;(sp)=cell records
        ld 		e,(ix+10)
        ld 		d,(ix+11)
        push 	de
        pop 	iy                  ;iy=column records
        ld 		b,(ix+8)            ;b=number of columns
        pop 	ix                  ;ix=cell records
.Quig_srtfix1:
		push 	bc         			;** line loop
        push 	iy
        inc 	ix
        inc 	ix
.Quig_srtfix2:
		ld 		a,(iy+0)     		;** column loop
        and 	#1c
        jr 		nz,Quig_srtfix3
        ld 		e,(ix+0)
        ld 		d,(ix+1)
        dec 	de                  ;**??** IS THAT HERE??
		dec		de
		dec		de
        ld 		a,ixh
        ld 		(de),a              ;correct address-H
        dec 	de
        ld 		a,ixl
        ld 		(de),a              ;correct address-L
.Quig_srtfix3:
		inc 	ix
        inc 	ix
        ld 		de,8
        add 	iy,de
        djnz 	Quig_srtfix2
        pop 	iy
        pop 	bc
        dec 	hl
        ld 		a,l
        or 		h
        jr 		nz,Quig_srtfix1
        ret


;******************************************************************************
;*** Name           System_CallFunction
;*** Input          ((SP+0)) = System manager command
;***                ((SP+1)) = Function ID
;***                AF,BC,DE,HL,IX,IY = Input for the function
;*** Output         AF,BC,DE,HL,IX,IY = Output from the function
;*** Destroyed      -
;*** Description    Calls a function via the system manager. This function is
;***                needed to have access to the file manager.
;******************************************************************************
.SySystem_CallFunction
		ld (AppMsgB+04),bc      ;copy registers into the message buffer
        ld (AppMsgB+06),de
        ld (AppMsgB+08),hl
        ld (AppMsgB+10),ix
        ld (AppMsgB+12),iy
        push af
        pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ld (AppMsgB+00),de      ;module und funktion number
        ld a,e
        ld (SyCallN),a
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #10                 ;send message
.SyCall1 rst #30
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #18                 ;wait for answer
        db #dd:dec l
        jr nz,SyCall1
        ld a,(AppMsgB)
        sub 128
        ld e,a
        ld a,(SyCallN)
        cp e
        jr nz,SyCall1
        ld hl,(AppMsgB+02)      ;get registers out of the message buffer
        push hl
        pop af
        ld bc,(AppMsgB+04)
        ld de,(AppMsgB+06)
        ld hl,(AppMsgB+08)
        ld ix,(AppMsgB+10)
        ld iy,(AppMsgB+12)
        ret
.SyCallN db 0		
		
;**** A = Window 0-7
;**** C = 0 = Data Begin Address
;****     1 = Open Event Address
;****     2 = Close Event Address
;****     3 = Resize Event Address
;****     4 = Main Loop Address
.Quig_GetWindowEventAddr
		add		a				;Times 2
		add		a				;Times 4
		add		a				;Times 8
		add		c				;Event
		add		a				;Times 16 + (Event*2)
		ld		hl,App_Form_List
		ld		e,a
		ld		d,0
		add		hl,de
		ret

;.Quig_Form_No:				db	0
.Quig_FormIDs:				db  255,255,255,255,255,255,255,255
.Quig_FormClickOff:			db  0,0,0,0,0,0,0,0

.Quig_Directory_Error_Byte:		db	0
.Quig_String_Buffer_Area_Start 	equ AppTrnEnd+260
.Quig_String_Buffer_Top			equ AppTrnEnd+260+AppTrnLen2
.Quig_String_Buffer_StackNo:	dw 0
.Quig_String_Buffer_Pos:		dw AppTrnEnd+260
.Quig_String_Buffer_Stack:		dw AppTrnEnd+260,0,0,0,0,0,0,0,0,0
.Quig_String_AS_HByte:			db 0
.Quig_String_Pos:				dw Quig_String_End_Text+4
		
.ErrorNum:					dw	0
.ErrorPC:					dw	0
.False:						db	0
.True:						db	1
.tcounter					dw	0





#IF USETIMER
.Quig_Timer_Code:
		di
.afeew	jr		afeew		


		ld		a,(Quig_Timer_On)
		and		a
		jp		nz,feet1
		rst		#30
		jp		Quig_Timer_Code
.feet1		
		di
.feet	jr		feet	

		
.Quig_Timer_On:				db	0
.Quig_Timer_Count:			dw	0

.SyKernel_Message:
;******************************************************************************
;*** Input          C        = Command
;***                HL,E,A,B = Additional parameters
;*** Output         HL       = returned parameters
;*** Destroyed      AF,BC,DE,IX,IY
;*** Description    Sends a message to the kernel, waits for the answer and
;***                returns the result
;******************************************************************************
        ld 		iy,AppMsgB
        ld 		(iy+0),c
        ld 		(AppMsgB+1),hl
        ld 		(iy+3),e
        ld 		(iy+4),a
        ld 		(iy+5),b
        ld 		a,c
        add 	128
        ld 		(SyKMsgN),a
        db 		#dd:ld h,1       ;1 is the number of the kernel process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#10
.SyKMsg1:
		db 		#dd:ld h,1       ;1 is the number of the kernel process
        ld 		a,(AppPrzN)
        db 		#dd:ld l,a
        rst 	#08             ;wait for a kernel message
        db 		#dd:dec l
        jr 		nz,SyKMsg1
        ld 		a,(SyKMsgN)
        cp 		(iy+0)
        jr 		nz,SyKMsg1
        ld 		hl,(AppMsgB+1)
        ret
.SyKMsgN db 0

		
#ENDIF	
#IF USENET



;### SUB ROUTINES #############################################################
.snwmsgi_afbcdehlixiy
        ld (AppMsgB+10),ix   ;store registers to message buffer
        ld (AppMsgB+12),iy
.snwmsgi_afbcdehl
        ld (AppMsgB+04),bc
.snwmsgi_afdehl
        ld (AppMsgB+06),de
.snwmsgi_afhl
        ld (AppMsgB+08),hl
.snwmsgi_af
        push af:pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld a,(hl)               ;set command
        inc hl
        push hl
        ld (AppMsgB+0),a
        ld (snwmsg2+1),a
        ld iy,AppMsgB
        ld a,(AppPrzN)	;ld a,(App_PrcID)
        db #dd:ld l,a
        ld a,(Quig_Net_Process)
        db #dd:ld h,a
        ld (snwmsg1+2),ix
        rst #10                 ;send message
.snwmsg1 ld ix,0                 ;wait for response
        rst #08
        db #dd:dec l
        jr nz,snwmsg1
        ld a,(AppMsgB)
        sub 128
.snwmsg2 cp 0
        ret z
        ld	a,(AppPrzN)			;ld a,(App_PrcID)        ;wrong response code -> re-send and wait for correct one
        db #dd:ld h,a
        ld a,(Quig_Net_Process)
        db #dd:ld l,a
        rst #10
        rst #30
        jr snwmsg1
.snwmsgo_afbcdehlixiy
        ld ix,(AppMsgB+10)   ;get registers from the message buffer
        ld iy,(AppMsgB+12)
        ld de,(AppMsgB+06)
.snwmsgo_afbchl
        ld bc,(AppMsgB+04)
.snwmsgo_afhl
        ld hl,(AppMsgB+02)
        push hl
        pop af
        ld hl,(AppMsgB+08)
        ret
#ENDIF	
	
	