Function VideoSuite(yh=0)
	;******************
	MHit=MouseHit(1)
	MDwn=MouseDown(1)
	If MSelected>0
		If MDwn=1 Then
			Mx=MXHeld:My=MYHeld
		Else
			MSelected=0
		EndIf
	EndIf
	If MSelected=0 Then Mx=MouseX():My=MouseY()
	
	SetFont fntArial
	;**** Draw Backdrop ****
	
	DrawBlockRect Backdrop_Image,0,21,0,0,GrapW-200,54
	DrawBlockRect Backdrop_Image,0,75,1003,54,240,620
	
	z=75+610
	While z<(GrapH-24)
		DrawBlockRect Backdrop_Image,0,z,0,400,240,100	
		z=z+100
	Wend	
	
	DrawBlockRect Backdrop_Image,240,GrapH-248,1243,414,70,230
	n=(GrapW-310)/52
	For f=0 To n
		DrawBlockRect Backdrop_Image,310+(f*52),GrapH-248,1313,414,52,230
	Next
	Color UserColsR(1),UserColsG(1),UserColsB(1)
	
	Rect 240,75,GrapW-240,GrapH-323,1
	;**** FileLister *****
	If Vid_PropOld<>GUI_GadVal(CollectGads2(19))/12 Then
		VideoFileListerDraw()
		Vid_PropOld=GUI_GadVal(CollectGads2(19))/12
	EndIf
	If MX>76 And MX<210 Then
		If my>258 And my<379 And MDwn Then
			n=Floor(my-256)/12
			If Vid_FileList(n)>0 Then
				Vid_FileSelect=Vid_FileList(n)
				VideoFileListerDraw()
			EndIf	
		EndIf	
	EndIf
	DrawBlockRect FileLister,77,259,0,0,132,121
	;*********************
	;**** Screen Sizer and Projector *****
	Vid_PixWid=Gui_GadVal(CollectGads2(20))
	Vid_PixHei=Gui_GadVal(CollectGads2(21))
	n=ScreenWidth(Vid_PixWid,Vid_Mode+6)
	If Vid_PixWid>Vid_PixWidMax Then Vid_PixWid=Vid_PixWidMax
	DrawBlockRect PreviewScreen,((GrapW-240)/2)-(n/2)+240,260-(Vid_PixHei),0,0,n,Vid_PixHei*2
	
	;DrawBlockRect PreviewScreen,300,300,0,0,n,Vid_PixHei*2	
	
	;***********************
	;**** Video Mode selector *****
	If MDwn Then
		If mx>16 And mx<217 And my>408 And my<436 Then Vid_Mode=Floor(mx-31)/29
	EndIf
	DrawImageRect Backdrop_Image,16+(Vid_Mode*29),408,(Vid_Mode*29)+1045,794,29,26
	;*******************************
	;**** Time and Slider ****
	If MY>GrapH-248 And MY<GrapH-226 And MHit Then
		If MX>241 And MX<254 Then
			If Vid_TimeLine#=2 Then Vid_TimeLine#=1:Vid_TimeStr$="1 sec"
			If Vid_TimeLine#=5 Then Vid_TimeLine#=2:Vid_TimeStr$="2 secs"
			If Vid_TimeLine#=10 Then Vid_TimeLine#=5:Vid_TimeStr$="5 secs"
			If Vid_TimeLine#=30 Then Vid_TimeLine#=10:Vid_TimeStr$="10 secs"
			If Vid_TimeLine#=60 Then Vid_TimeLine#=30:Vid_TimeStr$="30 secs"			
			If Vid_TimeLine#=300 Then Vid_TimeLine#=60:Vid_TimeStr$="1 min"
		EndIf
		If MX>294 And MX<309 Then
			If Vid_TimeLine#=60 Then Vid_TimeLine#=300:Vid_TimeStr$="5 mins"
			If Vid_TimeLine#=30 Then Vid_TimeLine#=60:Vid_TimeStr$="1 min"
			If Vid_TimeLine#=10 Then Vid_TimeLine#=30:Vid_TimeStr$="30 secs"
			If Vid_TimeLine#=5 Then Vid_TimeLine#=10:Vid_TimeStr$="10 secs"
			If Vid_TimeLine#=2 Then Vid_TimeLine#=5:Vid_TimeStr$="5 secs"		
			If Vid_TimeLine#=1 Then Vid_TimeLine#=2:Vid_TimeStr$="2 secs"
		EndIf
	EndIf
	Vid_TimeLineMin=Gui_GadVal(HScr)/(52.0/Vid_TimeLine):Vid_TimeLineMax=Vid_TimeLineMin+(13*Vid_TimeLine)
	a=Int(Vid_TimeLineMin)
	ss$="Time: "+Str$(a/60)+":"+Right$("00"+Str$(a Mod 60),2)
	Color 255,255,255
	Text 244,GrapH-262,ss$
	Color 40,40,160	
	Text 273,GrapH-244,Vid_TimeStr$,1
	
	Vid_InTimeZone=0
	Vid_Hit=0
	If KeyHit(211)Then Vid_Hit=2	
	If MX=>309 And MX<=985 Then
		For f=1 To 12
			If My>Vid_TimeSlotTop(f) And My<Vid_TimeSlotBot(f) Then
				If MHit Then
					Vid_InTimeZone2=f
					Vid_Hit=1
				EndIf
				Vid_InTimeZone=f
			EndIf
		Next
		If MDwn=False Then
			Vid_InTimeZone2=0
		EndIf	
	EndIf
	;***** Setup Time Pointer
	If Vid_InTimeZone2=1 Then Vid_TimeLinePointer#=(((MX-309.0)/52.0)*Vid_TimeLine)+Vid_TimeLineMin
	DrawBars()
	d=0
	;***** Indicate Selected area *****
	If Vid_InTimeZone>1 Then
		a9#=(((MX-309.0)/52.0)*Vid_TimeLine)+Vid_TimeLineMin
		If Med_Max(Vid_InTimeZone)=0 Then
			a1=-1
			a2=-2
			Med_Last=0
			d=1
		EndIf
		For g=1 To Med_Max(Vid_InTimeZone)
			If a9#>=Med_Start#(Vid_InTimeZone,g) And a9#<Med_Stop#(Vid_InTimeZone,g)Then
				a1=Video_TimeLine_Calc(Med_Start#(Vid_InTimeZone,g),Vid_TimeLineMin,Vid_TimeLineMax)
				a2=Video_TimeLine_Calc(Med_Stop#(Vid_InTimeZone,g),Vid_TimeLineMin,Vid_TimeLineMax)
				d=2
				a8#=Med_Start#(Vid_InTimeZone,g)
				If (a9#-a8#)<(0.1*Vid_TimeLine)Then a9#=a8#:d=3
				a8#=Med_Stop#(Vid_InTimeZone,g)
				If (a8#-a9#)<(0.1*Vid_TimeLine)Then a9#=a8#:d=4							
				Med_Last=g-1
				Exit
			EndIf
			If a9#<Med_Start#(Vid_InTimeZone,g) And a9#>Med_Start#(Vid_InTimeZone,g-1)Then
				a1=Video_TimeLine_Calc(Med_Stop#(Vid_InTimeZone,g-1),Vid_TimeLineMin,Vid_TimeLineMax)
				a2=Video_TimeLine_Calc(Med_Start#(Vid_InTimeZone,g),Vid_TimeLineMin,Vid_TimeLineMax)
				d=1
				Med_Last=g-1				
				Exit
			EndIf
			If a9#>Med_Stop#(Vid_InTimeZone,Med_Max(Vid_InTimeZone))Then
				a1=Video_TimeLine_Calc(Med_Stop#(Vid_InTimeZone,Med_Max(Vid_InTimeZone)),Vid_TimeLineMin,Vid_TimeLineMax)
				a2=-2
				d=1
				Med_Last=Med_Max(Vid_InTimeZone)
				Exit
			EndIf
		Next
		If d>=0 And d<=4 Then 
			If a1=-1 And a2>-1 Then a1=0
			If a2=-2 And a1>-1 Then a2=676
			If a1=-1 And a2=-2 Then a1=0:a2=676
			If a1>-1 And a2>-1 Then
				n=(Vid_TimeSlotBot(Vid_InTimeZone)-Vid_TimeSlotTop(Vid_InTimeZone))-1
				Color 255,255,255
				Rect a1+309,Vid_TimeSlotTop(Vid_InTimeZone)+1,a2-a1+1,Vid_TimeSlotBot(Vid_InTimeZone)-Vid_TimeSlotTop(Vid_InTimeZone)-1,0
				Rect a1+310,Vid_TimeSlotTop(Vid_InTimeZone)+2,a2-a1-1,Vid_TimeSlotBot(Vid_InTimeZone)-Vid_TimeSlotTop(Vid_InTimeZone)-3,0
				If Doing=1 And Vid_FileSelect>0 Then  ;**** Indicate Film media can be implanted
					If (d=1 Or d=3 Or d=4) And (Vid_InTimeZone=2 Or Vid_InTimeZone=3 Or Vid_InTimeZone=4 Or Vid_InTimeZone=6) Then
						DrawImageRect Backdrop_Image,MouseX()-2,MouseY()-29,Icon_Pos(2,1),Icon_Pos(2,2),31,31
					EndIf
				EndIf
	
				If Doing=1 And d>1 And (Vid_InTimeZone=2 Or Vid_InTimeZone=3 Or Vid_InTimeZone=4 Or Vid_InTimeZone=6)Then
					;If MSelected=2
						DrawImageRect Backdrop_Image,MouseX()-2,MouseY()-29,Icon_Pos(20,1),Icon_Pos(20,2),31,31
					;EndIf
					If MHit=1 Then
						MSelected=2:MXHeld=MX:MYHeld=MY:MXNo=Med_last+1:MXTimeLine=Vid_InTimeZone
					EndIf
				EndIf		
	
				
				If Doing=2 Then  ;***** Indicate Whitespace can be implanted
					If (d=2 Or d=3 Or d=4) And (Vid_InTimeZone=2 Or Vid_InTimeZone=3 Or Vid_InTimeZone=4 Or Vid_InTimeZone=6) Then DrawImageRect Backdrop_Image,MouseX()-2,MouseY()-29,1186,1029,31,31
				EndIf
				If Doing=3 Then  ;***** Indicate Whitespace can be implanted
					If (d=1 Or d=3 Or d=4) And Vid_InTimeZone>=2 And Vid_InTimeZone<=12 Then DrawImageRect Backdrop_Image,MouseX()-2,MouseY()-29,1122,1029,31,31
					
				EndIf
				If Doing>=7 And Doing<=14 Then
					If (d=>2 And d<=4) And (Vid_InTimeZone=2 Or Vid_InTimeZone=3 Or Vid_InTimeZone=4 Or Vid_InTimeZone=6) Then
						DrawImageRect Backdrop_Image,MouseX()-2,MouseY()-29,Icon_Pos(Doing,1),Icon_Pos(Doing,2),31,31
					EndIf
				EndIf
				If Doing>=7 And Doing<=14 And d>1 Then
					If Det_Used(Med_Det(Vid_InTimeZone,Med_Last+1))>0 Then
						g=Med_Det(Vid_InTimeZone,Med_Last+1)
						h=Doing-6
						For f=1 To Det_Max(g,h)
							a11=Video_TimeLine_Calc(Med_Start#(Vid_InTimeZone,Med_last+1)+Det_Offs#(g,h,f),Vid_TimeLineMin,Vid_TimeLineMax)
							If a11>-1 Then 
								DrawImageRect Backdrop_Image,a11+305,Vid_TimeSlotTop(Vid_InTimeZone)+3,1032,800,9,14						
								If Mx>a11+305 And mx<a11+314 And my>Vid_TimeSlotTop(Vid_InTimeZone)+3 And my<Vid_TimeSlotTop(Vid_InTimeZone)+17 Then
									If MSelected=0 Or (MSelected=1 And f=MXNo) Then 
										ss$=Det_Name$(h)+": "+Str$(Det_Val(g,h,f))
										n=StringWidth(ss$)+10
										Color 160,0,0:Rect a11+309-(n/2),Vid_TimeSlotTop(Vid_InTimeZone)-29,n,13
										Color 255,255,255:Text a11+309,Vid_TimeSlotTop(Vid_InTimeZone)-30,Ss$,1
									EndIf
									If MHit=1 Then
										MSelected=1:MXHeld=MX:MYHeld=MY:MXNo=f:MXMax#=Med_Stop(Vid_InTimeZone,Med_Last+1)-Med_Start(Vid_InTimeZone,Med_Last+1)
										MDetVal=Det_Val#(g,h,f)
									EndIf
									If Vid_Hit=2 And Det_Max(g,h)>0 Then
										For k=f To Det_Max(g,h)
											Det_Offs#(g,h,k)=Det_Offs#(g,h,k+1)
											Det_Val#(g,h,k)=Det_Val#(g,h,k+1)
										Next
										Det_Max(g,h)=Det_Max(g,h)-1
									EndIf
								EndIf
							EndIf	
						Next 
					EndIf
				EndIf
				If MSelected=1 Then VideoSlideDetails(g,h,MXNo,MXMax)
				If MSelected=2 Then MovieMover()
			EndIf
		EndIf
	EndIf

	If yh=0 Then
		If CollectGads2(2)=EV_HIT()	Then ImportVideo()								;**** Import Video FileName
		If CollectGads2(7)=EV_HIT()	Then PlayConvertVideo()							;**** Import Video FileName
		If CollectGads2(13)=EV_HIT() Then ImportSMF()								;**** Import SMF video file
		If CollectGads2(11)=EV_HIT() Then ExportVideoProject()						;**** Export Video Project
		If CollectGads2(10)=EV_HIT() Then ImportVideoProject()						;**** Import Video Project
		If CollectGads2(23)=EV_HIT() Then DoOutputVideo(Vid_Mode)					;**** Output Video
	EndIf
	
	If Spas=0
		;**** respond to space
		If d=1 And Vid_InTimeZone>1 And Vid_InTimeZone<13 Then
			;**** Delete Space ****
			If Vid_Hit=2 And Doing=0 Then 
				a8#=Med_Stop#(Vid_InTimeZone,Med_Last)
				If (a9#-a8#)<(0.1*Vid_TimeLine)Then a9#=a8#
				a10#=Med_Start(Vid_InTimeZone,Med_Last+1)-a9#
				For f=Med_Last+1 To Med_Max(Vid_InTimeZone)
					Med_Start(Vid_InTimeZone,f)=Med_Start(Vid_InTimeZone,f)-a10#
					Med_Stop(Vid_InTimeZone,f)=Med_Stop(Vid_InTimeZone,f)-a10#
				Next
			EndIf
			;**** Add Some Space
			If Vid_Hit=1 And Doing=3 Then
				a10#=Vid_TimeLine
				For f=Med_Last+1 To Med_Max(Vid_InTimeZone)
					Med_Start(Vid_InTimeZone,f)=Med_Start(Vid_InTimeZone,f)+a10#
					Med_Stop(Vid_InTimeZone,f)=Med_Stop(Vid_InTimeZone,f)+a10#
				Next
			EndIf
			;**** Add Media into Space *****
			If Vid_Hit=1 And Doing=1 And Vid_FileSelect>0 Then
				If Vid_InTimeZone=2 Or Vid_InTimeZone=3 Or Vid_InTimeZone=4 Or Vid_InTimeZone=6 Then
					a10#=SVF_Frames(Vid_FileSelect)/SVF_frps(Vid_FileSelect)
					MediaShiftUp(Vid_InTimeZone,a10#,Med_Last+1)
					a=Med_Last+1
					Med_SVF(Vid_InTimeZone,a)=Vid_FileSelect
					Med_Start(Vid_InTimeZone,a)=a9#
					Med_Stop(Vid_InTimeZone,a)=(SVF_Frames(Med_SVF(Vid_InTimeZone,a))/SVF_frps(Med_SVF(Vid_InTimeZone,a)))+Med_Start#(Vid_InTimeZone,a)
					Med_Det(Vid_InTimeZone,a)=CreateVideoDetail(Med_Stop(Vid_InTimeZone,a)-Med_Start(Vid_InTimeZone,a))
				EndIf
			EndIf
		EndIf
		;**** respond to object
		If (d=2 Or d=3 Or d=4)And Vid_InTimeZone>1 And Vid_InTimeZone<13 Then
			;**** Add a Slider
			If Vid_Hit=1 And Doing>=7 And Doing<=14 And MSelected=0 Then
				k=Med_Det(Vid_InTimeZone,Med_Last+1)
				k1=Doing-6
				If Det_Max(k,k1)<10 Then
					Det_Max(k,k1)=Det_Max(k,k1)+1
					k2=Det_Max(k,k1)
					Det_Offs#(k,k1,k2)=a9#-Med_Start(Vid_InTimeZone,Med_Last+1)
					If Doing=7 Or Doing=8 Then Det_Val#(k,k1,k2)=2
					If Doing=9 Or Doing=10 Or Doing=14 Then Det_Val#(k,k1,k2)=0
					If Doing=11 Or Doing=12 Or Doing=13 Then Det_Val#(k,k1,k2)=1
					SortVideoSliders(k,k1)
				EndIf
			EndIf
			
			;**** Delete Object ****
			If Vid_Hit=2 And (Doing=0 Or(Doing=1 And d=2))Then
				Det_Used(Med_Det(Vid_InTimeZone,Med_Last+1))=0
				a10#=Med_Stop(Vid_InTimeZone,Med_Last+1)-Med_Start(Vid_InTimeZone,Med_Last+1)
				MediaShiftDown(Vid_InTimeZone,a10#,Med_Last+1)
			EndIf
			;**** Add Some Space
			If (d=4 Or d=3)And Vid_Hit=1 And Doing=3 Then
				a10#=Vid_TimeLine
				For f=Med_Last+(d-2) To Med_Max(Vid_InTimeZone)
					Med_Start(Vid_InTimeZone,f)=Med_Start(Vid_InTimeZone,f)+a10#
					Med_Stop(Vid_InTimeZone,f)=Med_Stop(Vid_InTimeZone,f)+a10#
				Next
			EndIf
			;**** Add Media into Space Previous(d=3) / After(d=4) *****
			If (d=4 Or d=3)And Vid_Hit=1 And Doing=1 And Vid_FileSelect>0 Then
				If Vid_InTimeZone=2 Or Vid_InTimeZone=3 Or Vid_InTimeZone=4 Or Vid_InTimeZone=6 Then
					a10#=SVF_Frames(Vid_FileSelect)/SVF_frps(Vid_FileSelect)
					a=Med_Last+(d-2)
					MediaShiftUp(Vid_InTimeZone,a10#,a)
					Med_SVF(Vid_InTimeZone,a)=Vid_FileSelect
					Med_Start(Vid_InTimeZone,a)=a9#
					Med_Stop(Vid_InTimeZone,a)=(SVF_Frames(Med_SVF(Vid_InTimeZone,a))/SVF_frps(Med_SVF(Vid_InTimeZone,a)))+Med_Start#(Vid_InTimeZone,a)
					Med_Det(Vid_InTimeZone,a)=CreateVideoDetail(Med_Stop(Vid_InTimeZone,a)-Med_Start(Vid_InTimeZone,a))
				EndIf
			EndIf
			;**** Splice a piece of movie *****	
			If Vid_Hit=1 And Doing=2 Then 		;And Med_Type(Vid_InTimeZone,Med_last+1)=1 Then
				a10#=a9#-Med_Start(Vid_InTimeZone,Med_Last+1)
				a=Med_Last+1
				MediaShiftUp(Vid_InTimeZone,0,a)
				Med_Start(Vid_InTimeZone,Med_Last+2)=a9#
				Med_Offs(Vid_InTimeZone,Med_Last+2)=a10#			
				Med_Stop(Vid_InTimeZone,Med_Last+1)=a9#
			EndIf
		EndIf	
		;**** Draw the Timer Pointer and time elements ****
		e=Video_TimeLine_Calc(Vid_TimeLinePointer#,Vid_TimeLineMin,Vid_TimeLineMax)
		If e>-1 Then
			Color 0,0,0
			;DrawImageRect Backdrop_Image,e+305,439,1365,413,9,230
			DrawImageRect Backdrop_Image,e+305,GrapH-249,1365,413,9,230
			a=Floor(Vid_TimeLinePointer)
			ss$="Time: "+Str$(a/60)+":"+Right$("00"+Str$(a Mod 60),2)
			Text e+310,GrapH-262,ss$,1
		EndIf
		;************
		If Vid_Count=0 Then
			VideoSeek()
			Vid_LastElement=0
			For f=2 To 12
				If Med_Stop(f,Med_Max(f))>Vid_LastElement Then Vid_LastElement=Med_Stop(f,Med_Max(f))
			Next
			Vid_LastElement=Vid_LastElement+(6*Vid_TimeLine)
			GUI_Prop_Range(HScr,0,(Vid_LastElement*(52.0/Vid_TimeLine)))		
		EndIf	
		If Vid_Count=1 Then VideoLoad()
		If Vid_Count=2 Then VideoCalc()
		If Vid_Count=3 Then ConvertVideoImage(Vid_PixWid,Vid_PixHei,Vid_Mode+6)
		Vid_Count=(Vid_Count+1)Mod 8
	EndIf

End Function
Function VideoSlideDetails(go,ho,fo,maxallowed=0)
	;Det_Offs#(1024,10,10)
	MX2=MouseX()
	a7#=(((MXHeld-309.0)/52.0)*Vid_TimeLine)+Vid_TimeLineMin
	a8#=(((MX2-309.0)/52.0)*Vid_TimeLine)+Vid_TimeLineMin
	Vid_TimeLinePointer#=a8#

	a6#=Det_Offs#(go,ho,fo)+(a8#-a7#)
	If a6#>=0 And a6#<=maxallowed Then 
		MXHeld=MX2
		Det_Offs#(go,ho,fo)=a6#
	EndIf

	MY2=MouseY()	
	a6#=MDetVal#+((MYHeld-MY2)*Det_Info(ho,3))
	If a6#>=Det_Info#(ho,1) And a6#<=Det_Info#(ho,2)Then 
		Det_Val#(go,ho,fo)=a6#
	EndIf
	SortVideoSliders(go,ho)
End Function
Function MovieMover()
	MX2=MouseX():MY2=MouseY()
	For f=1 To 12
		If MY2>Vid_TimeSlotTop(f) And MY2<Vid_TimeSlotBot(f) Then
			Vid_ITZ=f
			Exit
		EndIf
	Next
	If Vid_ITZ=2 Or Vid_ITZ=3 Or Vid_ITZ=4 Or Vid_ITZ=6 Then 
		a7#=(((MXHeld-309.0)/52.0)*Vid_TimeLine)+Vid_TimeLineMin
		a8#=(((MX2-309.0)/52.0)*Vid_TimeLine)+Vid_TimeLineMin
		a2#=Med_Start(MXTimeLine,MXNo)+(a8#-a7#)
		a3#=Med_Stop(MXTimeLine,MXNo)+(a8#-a7#)
		;**** Erase Old
		ms1#=Med_Start(MXTimeLine,MXNo)
		ms2#=Med_Stop(MXTimeLine,MXNo)
		ms3#=Med_SVF(MXTimeLine,MXNo)
		ms4#=Med_Offs(MXTimeLine,MXNo)
		ms5#=Med_Det(MXTimeLine,MXNo)
		ms6#=Med_Type(MXTimeLine,MXNo)
		For f=MXNo To Med_Max(MXTimeLine)
			Med_Start(MXTimeLine,f)=Med_Start(MXTimeLine,f+1)
			Med_Stop(MXTimeLine,f)=Med_Stop(MXTimeLine,f+1)
			Med_SVF(MXTimeLine,f)=Med_SVF(MXTimeLine,f+1)
			Med_Offs(MXTimeLine,f)=Med_Offs(MXTimeLine,f+1)
			Med_Det(MXTimeLine,f)=Med_Det(MXTimeLine,f+1)				
			Med_Type(MXTimeLine,f)=Med_Type(MXTimeLine,f+1)
		Next
		Med_Max(MXTimeLine)=Med_Max(MXTimeLine)-1
		;****
	
		allowed=0
		For f=1 To Med_Max(Vid_ITZ)
			If a2#>=Med_Stop(Vid_ITZ,f-1) And a3#<=Med_Start(Vid_ITZ,f) Then	 
				allowed=1
				gt=f
				Exit
			EndIf
		Next
		If (Allowed=0 And a2#>=Med_Stop(Vid_ITZ,Med_Max(Vid_ITZ))) Or Med_Max(Vid_ITZ)=0 Then
			Allowed=1
			gt=Med_Max(Vid_ITZ)+1
		EndIf
		If a2#<0 Then Allowed=0
		
		If Allowed=0 Then
			For f=Med_Max(MXTimeLine) To MXNo Step -1
				Med_Start(MXTimeLine,f+1)=Med_Start(MXTimeLine,f)
				Med_Stop(MXTimeLine,f+1)=Med_Stop(MXTimeLine,f)
				Med_SVF(MXTimeLine,f+1)=Med_SVF(MXTimeLine,f)
				Med_Offs(MXTimeLine,f+1)=Med_Offs(MXTimeLine,f)
				Med_Det(MXTimeLine,f+1)=Med_Det(MXTimeLine,f)				
				Med_Type(MXTimeLine,f+1)=Med_Type(MXTimeLine,f)
			Next
			Med_Max(MXTimeLine)=Med_Max(MXTimeLine)+1
			Med_Start(MXTimeLine,MXNo)=ms1#
			Med_Stop(MXTimeLine,MXNo)=ms2#
			Med_SVF(MXTimeLine,MXNo)=ms3#
			Med_Offs(MXTimeLine,MXNo)=ms4#
			Med_Det(MXTimeLine,MXNo)=ms5#
			Med_Type(MXTimeLine,MXNo)=ms6#
		Else
			For f=Med_Max(Vid_ITZ) To gt Step -1
				Med_Start(Vid_ITZ,f+1)=Med_Start(Vid_ITZ,f)
				Med_Stop(Vid_ITZ,f+1)=Med_Stop(Vid_ITZ,f)
				Med_SVF(Vid_ITZ,f+1)=Med_SVF(Vid_ITZ,f)
				Med_Offs(Vid_ITZ,f+1)=Med_Offs(Vid_ITZ,f)
				Med_Det(Vid_ITZ,f+1)=Med_Det(Vid_ITZ,f)				
				Med_Type(Vid_ITZ,f+1)=Med_Type(Vid_ITZ,f)
			Next
			Med_Max(Vid_ITZ)=Med_Max(Vid_ITZ)+1
			Med_Start(Vid_ITZ,gt)=a2#
			Med_Stop(Vid_ITZ,gt)=a3#
			Med_SVF(Vid_ITZ,gt)=ms3#
			Med_Offs(Vid_ITZ,gt)=ms4#
			Med_Det(Vid_ITZ,gt)=ms5#
			Med_Type(Vid_ITZ,gt)=ms6#
			;If Vid_ITZ<>MXTimeLIne Then
			;	dety=Vid_ITZ
			;	dety1=MXTimeLine
			;	Stop
			;EndIf
			MXTimeLine=Vid_ITZ
			MXHeld=MX2
			MYHeld=MY2
			MXNo=gt
		EndIf
	EndIf
End Function
Function CreateVideoDetail(a11#)
	For f=1 To 1024
		If Det_Used(f)=0 Then
			Det_Max(f,1)=2:Det_Offs#(f,1,1)=0:Det_Offs#(f,1,2)=a11#		;**** Contrast
			Det_Val#(f,1,1)=1.2:Det_Val#(f,1,2)=1.2							;**** Contrast

			Det_Max(f,2)=2:Det_Offs#(f,2,1)=0:Det_Offs#(f,2,2)=a11#		;**** Brightness
			Det_Val#(f,2,1)=2:Det_Val#(f,2,2)=2							;**** Brightness

			Det_Max(f,3)=2:Det_Offs#(f,3,1)=0:Det_Offs#(f,3,2)=a11#		;**** Position X
			Det_Val#(f,3,1)=0:Det_Val#(f,3,2)=0							;**** Position X

			Det_Max(f,4)=2:Det_Offs#(f,4,1)=0:Det_Offs#(f,4,2)=a11#		;**** Position Y
			Det_Val#(f,4,1)=0:Det_Val#(f,4,2)=0							;**** Position Y

			Det_Max(f,5)=2:Det_Offs#(f,5,1)=0:Det_Offs#(f,5,2)=a11#		;**** Scale X
			Det_Val#(f,5,1)=1:Det_Val#(f,5,2)=1							;**** Scale X

			Det_Max(f,6)=2:Det_Offs#(f,6,1)=0:Det_Offs#(f,6,2)=a11#		;**** Scale y
			Det_Val#(f,6,1)=1:Det_Val#(f,6,2)=1							;**** Scale y

			Det_Max(f,7)=2:Det_Offs#(f,7,1)=0:Det_Offs#(f,7,2)=a11#		;**** Alpha
			Det_Val#(f,7,1)=1:Det_Val#(f,7,2)=1							;**** Alpha

			Det_Max(f,8)=2:Det_Offs#(f,8,1)=0:Det_Offs#(f,8,2)=a11#		;**** Chroma
			Det_Val#(f,8,1)=0:Det_Val#(f,8,2)=0							;**** Chroma			
			
			Det_Used(f)=1
			Return f
		EndIf
	Next
	Return 0
End Function
Function SortVideoSliders(k,k1)
	Repeat
		t=0
		For f=1 To Det_Max(k,k1)-1
			If Det_Offs#(k,k1,f)>Det_Offs#(k,k1,f+1)Then
				a8#=Det_Offs#(k,k1,f+1)
				Det_Offs#(k,k1,f+1)=Det_Offs#(k,k1,f)
				Det_Offs#(k,k1,f)=a8#
				a8#=Det_Val#(k,k1,f+1)
				Det_Val#(k,k1,f+1)=Det_Val#(k,k1,f)
				Det_Val#(k,k1,f)=a8#
				If MSelected=1 Then
					If f=MXNo Then
						MXNo=MXNo+1
					Else If f+1=MXNo Then
						MXNo=MXNo-1
					EndIf
				EndIf
				t=1
			EndIf
		Next
	Until t=0
End Function
Function MediaShiftUp(TZ,Am#,StAt)
	For f=Med_Max(TZ) To StAt Step -1
		Med_Start(TZ,f+1)=Med_Start(TZ,f)+Am#
		Med_Stop(TZ,f+1)=Med_Stop(TZ,f)+Am#
		Med_SVF(TZ,f+1)=Med_SVF(TZ,f)
		Med_Offs(TZ,f+1)=Med_Offs(TZ,f)
		Med_Det(TZ,f+1)=Med_Det(TZ,f)				
		Med_Type(TZ,f+1)=Med_Type(TZ,f)
	Next
	Med_Max(TZ)=Med_Max(TZ)+1
End Function
Function MediaShiftDown(TZ,Am#,StAt)
	For f=StAt To Med_Max(TZ)
		Med_Start(TZ,f)=Med_Start(TZ,f+1)-Am#
		Med_Stop(TZ,f)=Med_Stop(TZ,f+1)-Am#
		Med_SVF(TZ,f)=Med_SVF(TZ,f+1)
		Med_Offs(TZ,f)=Med_Offs(TZ,f+1)
		Med_Det(TZ,f)=Med_Det(TZ,f+1)				
		Med_Type(TZ,f)=Med_Type(TZ,f+1)
	Next
	Med_Max(TZ)=Med_Max(TZ)-1
End Function
Function VideoSeek()
	For f=2 To 12
		Med_Pos(f)=0
		For g=1 To Med_Max(f)
			a1#=Video_TimeLine_On(Vid_TimeLinePointer#,Med_Start#(f,g),Med_Stop#(f,g))
			If a1#>-1 Then
				a=Med_SVF(f,g)
				h=Floor((a1#+Med_Offs(f,g))*SVF_frps#(a))
				Med_Pos(f)=(((SVF_PixWid(a)*SVF_PixHei(a))*2)*h)+32
				Med_File(f)=a
				;**** Work out settings ****
				a10#=Vid_TimeLinePointer#-Med_Start#(f,g)
				If Med_Det(f,g)>0 Then
					a11=Med_Det(f,g)
					For j=1 To 10
						For h=1 To Det_Max(a11,j)
							If a10#=>Det_Offs#(a11,j,h-1) And a10#<=Det_Offs#(a11,j,h) Then
								;Work Divisor
								a9#=(a10#-Det_Offs#(a11,j,h-1))/(Det_Offs#(a11,j,h)-Det_Offs#(a11,j,h-1))
								Med_Val#(f,j)=((Det_Val#(a11,j,h)-Det_Val#(a11,j,h-1))*a9#)+Det_Val#(a11,j,h-1)
								h=999
							EndIf
						Next
						If a10#<=Det_Offs#(a11,j,1)Then Med_Val#(f,j)=Det_Val#(a11,j,1)
						If a10#>=Det_Offs#(a11,j,Det_Max(a11,j))Then Med_Val#(f,j)=Det_Val#(a11,j,Det_Max(a11,j))
					Next	
				EndIf
				g=Med_Max(f)+1
			EndIf
			If a1#=-1 Then g=Med_Max(f)+1
		Next
	Next
End Function
Function VideoCalc()

	d=Vid_Screens(1)
	d1=Vid_Screens(7)
	a=0
	For f=0 To 159
		For g=0 To 15
			PokeInt(d,a,0):PokeInt(d,a+4,0):PokeInt(d,a+8,0):PokeInt(d,a+12,0)
			PokeInt(d,a+16,0):PokeInt(d,a+20,0):PokeInt(d,a+24,0):PokeInt(d,a+28,0)
			PokeInt(d,a+32,0):PokeInt(d,a+36,0):PokeInt(d,a+40,0):PokeInt(d,a+44,0)			
			a=a+48
		Next
	Next
	For f=6 To 2 Step -1
		If Med_Pos(f)>0 Then
			n=Med_File(f)
			c=Vid_Screens(f)
			d=Vid_Screens(1)
			soc1#=SVF_PixHei(n)*Med_Val#(f,6)	;Actual Height to Draw
			Soc2#=SVF_PixHei(n)/soc1#			;Divisor
			soc3=(soc1#/2)+((Med_Val(f,4))*2)
			
			soc5#=SVF_PixWid(n)*Med_Val#(f,5)	;Actual Width to Draw
			soc6#=SVF_PixWid(n)/soc5#			;Divisor
			soc7# = (soc5#/2)+((-Med_Val(f,3))*2)

			;**** Set Alpha up
			If Med_Val#(f,7)<.95 Then
				soc9=True
			Else
				soc9=False
			EndIf	

			NewInt#=Med_Val#(f,1)
			NewBright#=128+((Med_Val#(f,2)-2)*64)
			For Y=0 To soc1#-1
				b9=Y+(79-soc3)
				If b9>=0 And b9<160 Then
					b=Floor(Y*Soc2#)*768
					b9=b9*768
					;For x=1 To SVF_PixWid(n)
					For X=0 To soc5#-1
						j9=X+(127-soc7)  ;127-soc7
						If j9>=0 And j9<256 Then
							k=(Floor(X*soc6#)*3)+b
							k9=(j9*3)+b9
							r1=(PeekByte(c,k+2)):g1=(PeekByte(c,k+1)):b1=(PeekByte(c,k))
							
							r1=((r1-128)*NewInt#)+NewBright#
							If r1<0 Then r1=0
							If r1>255 Then r1=255		
							g1=((g1-128)*NewInt#)+NewBright#
							If g1<0 Then g1=0
							If g1>255 Then g1=255	
							b1=((b1-128)*NewInt#)+NewBright#
							If b1<0 Then b1=0
							If b1>255 Then b1=255
							If soc9 Then 
								r2=(PeekByte(d,k9)):g2=(PeekByte(d,k9+1)):b2=(PeekByte(d,k9+2))								
								r1=((r1-r2)*Med_Val#(f,7))+r2
								g1=((g1-g2)*Med_Val#(f,7))+g2
								b1=((b1-b2)*Med_Val#(f,7))+b2								
							EndIf
							PokeByte(d,k9+2,b1)
							PokeByte(d,k9+1,g1)
							PokeByte(d,k9,r1)
						EndIf	
					Next
				EndIf	
			Next
		EndIf
	Next

	f1=ActualScreenWidth(Gui_GadVal(CollectGads2(20)),Vid_Mode)

	k9=0
	For f=1 To Gui_GadVal(CollectGads2(21))
		For g=1 To f1
			r2=PeekByte(d,k9):g2=PeekByte(d,k9+1):b2=PeekByte(d,k9+2)			;Source
			r1=PeekByte(d1,k9):g1=PeekByte(d1,k9+1):b1=PeekByte(d1,k9+2)		;Backup
			aq=Abs(r2-r1)+Abs(g2-g1)+Abs(b2-b1)
			If aq>0 Or KeyFramer=0 Then
				PokeByte(d,k9+2,b2)
				PokeByte(d,k9+1,g2)
				PokeByte(d,k9,r2)
				PokeByte(d1,k9+2,b2)
				PokeByte(d1,k9+1,g2)
				PokeByte(d1,k9,r2)
			Else
				PokeByte(d,k9+2,b1)
				PokeByte(d,k9+1,g1)
				PokeByte(d,k9,r1)
				PokeByte(d1,k9+2,b1)
				PokeByte(d1,k9+1,g1)
				PokeByte(d1,k9,r1)
			EndIf
			k9=k9+3
		Next 
	Next
	
End Function
Function VideoLoad()
	For f=2 To 12
		If Med_Pos(f)>0 And Med_Pos(f)<>Med_PosOld(f)Then
			Med_PosOld(f)=Med_Pos(f)
			n=Med_File(f)
			a=OpenFile(SVF_Name$(n))
			b=0
			If a<>0 Then
				SeekFile(a,Med_Pos(f)) 
				For Y=SVF_PixHei(n)-1 To 0 Step -1
					b=Y*768
					For X=1 To SVF_PixWid(n)/2
						c=ReadInt(a)
						PokeByte (Vid_Screens(f),b,(c And 31)Shl 3)
						PokeByte (Vid_Screens(f),b+1,((c Shr 5)And 31)Shl 3)
						PokeByte (Vid_Screens(f),b+2,((c Shr 10)And 31)Shl 3)
						PokeByte (Vid_Screens(f),b+3,((c Shr 16)And 31)Shl 3)
						PokeByte (Vid_Screens(f),b+4,((c Shr 21)And 31)Shl 3)
						PokeByte (Vid_Screens(f),b+5,((c Shr 26)And 31)Shl 3)
						b=b+6
					Next
				Next
				CloseFile(a)
				Med_PosOld(f)=Med_Pos(f)
			EndIf	
		EndIf
	Next
End Function
Function ConvertVideoImage(bwid,PixHei#,ConType)
	;NewInt#=GUI_GadFloat#(CollectGads2(33))/64
	;NewBright#=(GUI_GadFloat#(CollectGads2(32))*2)-128
	NewInt#=1
	NewBright#=128
	
	Clrs4(0)=700
	Clrs4(1)=40
	Clrs4(2)=500
	Clrs4(3)=263
	;**** 1:1 Ratio
	If ConType=0 Or ConType=1 Or ConType=6 Or ConType=9 Or ConType=12 Then
		Ratio=2
	EndIf
	;**** 2:1 Ratio
	If ConType=2 Or ConType=3 Or ConType=4 Or ConType=8 Or ConType=10 Or ConType=11 Or ConType=13 Then
		Ratio=1
	EndIf
	;**** 1:2 Ratio
	If ConType=6 Then 
		Ratio=4
	EndIf	
	;**** 16 Colour
	If ConType=0 Or ConType=2 Or ConType=6 Or ConType=9 Or ConType=11 Then
		Colrange=2
		PixWid#=bwid*2
	EndIf
	;**** 4 Colour
	If ConType=1 Or ConType=3 Or ConType=7 Or ConType=10 Then
		Colrange=1
		PixWid#=bwid*4
	EndIf
	;**** 256 colour
	If ConType=12 Then
		Colrange=3
		PixWid#=bwid
	EndIf	
	;**** 2 Colour
	If ConType=4 Or ConType=8 Or ConType=13 Then
		colrange=4
		PixWid#=bwid*8
	EndIf
	
	SetBuffer ImageBuffer(PreviewScreen)
	ClsColor 39,39,134
	Cls
	LockBuffer ImageBuffer(PreviewScreen)
	w2#=256/PixWid#		;ImageWidth(GrpImage(Gaq))/PixWid#
	h2#=120/PixHei#		;ImageHeight(GrpImage(Gaq))/PixHei#
	h3=768				;ImageWidth(GrpImage(Gaq))*3
	c=Vid_Screens(1)
	Rer=PixHei-1
	Ger=PixWid-1
	If Rer>520 Then Rer=520
	If Ratio=4 Then
		If Ger>210 Then Ger=210
	EndIf
	If Ratio=2 Then
		If Ger>420 Then Ger=420
	EndIf
	If Ratio=1 Then
		If Ger>820 Then Ger=820
	EndIf
	qa=0
	For f=0 To Rer
		d=Int(f*h2#)
		;If d>=ImageHeight(GrpImage(Gaq)) Then d=ImageHeight(GrpImage(Gaq))
		d=d*h3
		Tot=0
		Count=0
		For g=0 To Ger
			a=(Int(g*w2#)*3)+d
			b1=ConvertPixel(ColRange,a,c,g,f)
			If Ratio=4 Then
				WritePixelFast (g Shl 2),(f Shl 1),b1
				WritePixelFast (g Shl 2)+1,(f Shl 1),b1
				WritePixelFast (g Shl 2)+2,(f Shl 1),b1
				WritePixelFast (g Shl 2)+3,(f Shl 1),b1				
				WritePixelFast (g Shl 2),(f Shl 1)+1,b1
				WritePixelFast (g Shl 2)+1,(f Shl 1)+1,b1
				WritePixelFast (g Shl 2)+2,(f Shl 1)+1,b1
				WritePixelFast (g Shl 2)+3,(f Shl 1)+1,b1				
			EndIf
			If Ratio=2 Then
				WritePixelFast (g Shl 1),(f Shl 1),b1
				WritePixelFast (g Shl 1)+1,(f Shl 1),b1
				WritePixelFast (g Shl 1),(f Shl 1)+1,b1
				WritePixelFast (g Shl 1)+1,(f Shl 1)+1,b1
			EndIf
			If Ratio=1 Then
				WritePixelFast g,(f Shl 1),b1
				WritePixelFast g,(f Shl 1)+1,b1
			EndIf
			If ConType=0 Or ConType=3 Or ConType=5 Then
				If Count=0 Then Tot=((ReturnByteThing And 15)Shl 4)
				If Count=1 Then
					Tot=Tot+((ReturnByteThing And 15))
					PokeByte(ScreenMem,qa,Tot)
					qa=qa+1
				EndIf	
				Count=Count+1
				If Count>1 Then Count=0
			EndIf
			If ConType=6 Then
				PokeByte(ScreenMem,qa,ReturnByteThing)
				qa=qa+1
			EndIf
			If ConType=1 Or ConType=4 Then
				If Count=0 Then Tot=((ReturnByteThing And 3)Shl 6)
				If Count=1 Then Tot=Tot+((ReturnByteThing And 3) Shl 4)
				If Count=2 Then Tot=Tot+((ReturnByteThing And 3) Shl 2)
				If Count=3 Then
					Tot=Tot+((ReturnByteThing And 3))
					PokeByte(ScreenMem,qa,Tot)
					qa=qa+1
				EndIf
				Count=Count+1
				If Count>3 Then Count=0
			EndIf
		Next		
	Next
	UnlockBuffer ImageBuffer(PreviewScreen)
	SetBuffer BackBuffer()

	;ScreenMem=CreateBank(32000)
	;ScreenMemBack=CreateBank(32000)
	;ScreenMemOut=
	qa=2
	qa1=2
	MissedCount=0
	NotMissed=0

	NotChanged=0
	FirstChanged=0
	Bigget=0
	
	For f=0 To Rer
		For g=1 To bwid
			Orig=PeekByte(ScreenMem,qa)
			Old=PeekByte(ScreenMemBack,qa)
			If KeyFramer<>0 Then
				If (qa>FirstChanged+5 Or qa=0) And Orig=Old Then
					If Notchanged=0 Then
						Bigget=qa
					EndIf
					NotChanged=NotChanged+1
				EndIf
				If Orig<>Old Or NotChanged>120 Then
					If NotChanged>1 Then
						;**** Store the Exiting Changed Stuff
						a10=Bigget-FirstChanged
						While a10>0
							a11=a10
							If a11>120 Then
								a11=120
							EndIf
							a10=a10-120
							PokeByte(ScreenMemOut,qa1,a11)
							qa1=qa1+1
							For n=0 To a11-1
								a12=PeekByte(ScreenMem,qa+n)
								PokeByte(ScreenMemOut,qa1,a12)
								qa1=qa1+1
							Next
						Wend
						
						PokeByte(ScreenMemOut,qa1,128+NotChanged)
						qa1=qa1+1
						NotChanged=0
						FirstChanged=qa
					Else
						NotChanged=0
					EndIf	
				EndIf
			Else
				qa1=qa1+1
			EndIf
			PokeByte(ScreenMemBack,qa,Orig)
			qa=qa+1
		Next
	Next
	If KeyFramer<>0 Then
		a10=qa-FirstChanged
		While a10>0							
			a11=a10
			If a11>120 Then
				a11=120
			EndIf
			a10=a10-120
			PokeByte(ScreenMemOut,qa1,a11)
			qa1=qa1+1
			For n=0 To a11-1
				a12=PeekByte(ScreenMem,qa+n)
				PokeByte(ScreenMemOut,qa1,a12)
				qa1=qa1+1
			Next
		Wend
		qa1=qa1+1
		PokeByte(ScreenMemOut,qa1,0)
		qa1=qa1+1
	EndIf	
	MissedCount=qa1
	
End Function
Function ImportSMF()
	ChangeDir CDir$+"Video\"
	Make_Fake_Image()
	FileName$=IO_FileRequest$("Import .SMF Video",".SMF|",400,160)

	If FileName$<>"" Then
		For f=1 To 256
			If SVF_Name$(f)=""Then
				SVF_Name$(f)=FileName$
				b=GetSVFInfo(f)
				If b<>1 Then
					SVF_Name$(f)=""
				Else
					Vid_FileSelect=f
					k=Int(Rnd(16))
					SVF_Red(f)=Rand_Red(k)
					SVF_Green(f)=Rand_Green(k)
					SVF_Blue(f)=Rand_Blue(k)	
				EndIf
				f=9999
			EndIf
		Next
		VideoFileListerDraw()
	EndIf
	FakerOn=0
	WaitRelease()
	ChangeDir CDir$
End Function
Function ExportVideoProject()
	ChangeDir CDir$+"Video\"
	Make_Fake_Image()
	FileName$=IO_FileRequest$("Export Video Project",".SVP|",400,160)
	FakerOn=0:GUI_Mark2():Flip
	If FileName$<>"" Then
		a=Instr(filename$,".")
		If a=0 Then FileName$=FileName$+".SVP"
		CpRun=CpRun+1:ComR$(CpRun Mod 50)="< EDITOR > Please wait. Exporting video project"+FileName$
		GUI_Mark2():Flip
		
		file=WriteFile(filename$)
		WriteLine(file,"symstudio video project")
		For f=1 To 256
			WriteLine(file,SVF_Name$(f))
			WriteFloat(file,SVF_frps#(f))
			WriteFloat(file,SVF_PixWid(f))
			WriteFloat(file,SVF_PixHei(f))
			WriteFloat(file,SVF_Frames#(f))
			WriteFloat(file,SVF_Red(f))
			WriteFloat(file,SVF_Green(f))
			WriteFloat(file,SVF_Blue(f))
		Next
		For f=1 To 12
			WriteInt(file,Med_Max(f))
			For g=1 To Med_Max(f)
				WriteFloat(file,Med_Start#(f,g))
				WriteFloat(file,Med_Stop#(f,g))
				WriteInt(file,Med_Type(f,g))
				WriteInt(file,Med_SVF(f,g))
				WriteFloat(file,Med_Offs#(f,g))
				WriteInt(file,Med_Det(f,g))
			Next
		Next
		For f=1 To 1024
			WriteInt(file,Det_Used(f))
			If Det_Used(f)<>0 Then
				For g=1 To 10
					WriteInt(file,Det_Max(f,g))
					For h=1 To Det_Max(f,g)
						WriteFloat(file,Det_Offs#(f,g,h))
						WriteFloat(file,Det_Val#(f,g,h))
					Next
				Next
			EndIf
		Next
		CloseFile(file)
	EndIf
	waitrelease()
	Package=q
	If Package<>Package2 Then
		Package2=Package
		DrawSidePanel(Package)
	EndIf	
End Function
Function ImportVideoProject()
	ChangeDir CDir$+"Video\"
	Make_Fake_Image()
	FileName$=IO_FileRequest$("Import Video Project",".SVP|",400,160)
	FakerOn=0:GUI_Mark2():Flip
	If FileName$<>"" Then
		a=Instr(filename$,".")
		If a=0 Then FileName$=FileName$+".SVP"
		CpRun=CpRun+1:ComR$(CpRun Mod 50)="< EDITOR > Please wait. Importing video project"+FileName$
		GUI_Mark2():Flip
		
		file=OpenFile(filename$)
		ss$=ReadLine(file)
		If ss$="symstudio video project"Then
			For f=1 To 256
				SVF_Name$(f)=ReadLine(file)
				SVF_frps#(f)=ReadFloat(file)
				SVF_PixWid(f)=ReadFloat(file)
				SVF_PixHei(f)=ReadFloat(file)
				SVF_Frames#(f)=ReadFloat(file)
				SVF_Red(f)=ReadFloat(file)
				SVF_Green(f)=ReadFloat(file)
				SVF_Blue(f)=ReadFloat(file)
			Next
			For f=1 To 12
				Med_Max(f)=ReadInt(file)
				For g=1 To Med_Max(f)
					Med_Start#(f,g)=ReadFloat(file)
					Med_Stop#(f,g)=ReadFloat(file)
					Med_Type(f,g)=ReadInt(file)
					Med_SVF(f,g)=ReadInt(file)
					Med_Offs#(f,g)=ReadFloat(file)
					Med_Det(f,g)=ReadInt(file)
				Next
			Next
			For f=1 To 1024
				Det_Used(f)=ReadInt(file)
				If Det_Used(f)<>0 Then
					For g=1 To 10
						Det_Max(f,g)=ReadInt(file)
						For h=1 To Det_Max(f,g)
							Det_Offs#(f,g,h)=ReadFloat(file)
							Det_Val#(f,g,h)=ReadFloat(file)
						Next
					Next
				EndIf
			Next
		EndIf
		CloseFile(file)
	EndIf
	WaitRelease()
	Package=q
	If Package<>Package2 Then
		Package2=Package
		DrawSidePanel(Package)
	EndIf
	SetFont fntArial
	VideoFileListerDraw()	
End Function
Function VideoFileListerDraw()
	ClsColor 231,231,255
	SetBuffer ImageBuffer(FileLister)
	Cls
	For f=1 To 11
		Vid_FileList(f)=0
	Next
	a=0:b=GUI_GadVal(CollectGads2(19))/12:c=0
	For f=1 To 256
		If SVF_Name$(f)>""Then
			If a>=b And a<b+10 Then
				file$=SVF_Name$(f)
				n=1
				For g=1 To Len(file$)
					If Mid$(file$,g,1)="\"Then n=g+1
				Next
				file$=Mid$(file$,n)
				n=Instr(file$,".")
				If n>0 Then File$=Mid$(File$,1,n-1)
				If f=Vid_FileSelect Then
					Color 142,142,250
					Rect 0,c*12+1,160,12
					Color 255,255,255
					Text 16,c*12,File$
				Else
					Color 0,0,0
					Text 16,c*12,File$
				EndIf
				Color 0,0,0
				Rect 2,c*12+2,12,10,1
				Color SVF_Red(f),SVF_Green(f),SVF_Blue(f)
				Rect 3,c*12+3,10,8				
				Vid_FileList(c+1)=f
				c=c+1
			EndIf
			a=a+1
		EndIf
	Next
	SetBuffer BackBuffer()
End Function
Function DrawBars()
	For f=1 To 12
		For g=1 To Med_Max(f) 
			a1=Video_TimeLine_Calc(Med_Start#(f,g),Vid_TimeLineMin,Vid_TimeLineMax)
			a2=Video_TimeLine_Calc(Med_Stop#(f,g),Vid_TimeLineMin,Vid_TimeLineMax)
			If a1=-1 And a2>-1 Then a1=0
			If a2=-2 And a1>-1 Then a2=676
			If a1=-1 And a2=-2 Then a1=0:a2=676
			If a1>-1 And a2>-1 Then
				r1=SVF_Red(Med_SVF(f,g))
				g1=SVF_Green(Med_SVF(f,g))
				b1=SVF_Blue(Med_SVF(f,g))
				n=(Vid_TimeSlotBot(f)-Vid_TimeSlotTop(f))-1
				Color r1,g1,b1
				Rect a1+309,Vid_TimeSlotTop(f)+1,a2-a1+1,n,1
				Color 0,0,0
				Rect a1+309,Vid_TimeSlotTop(f)+1,a2-a1+1,Vid_TimeSlotBot(f)-Vid_TimeSlotTop(f)-1,0
			EndIf
		Next
	Next 
End Function
Function Video_TimeLine_On#(a9#,b1#,b2#)
	If a9#<b1# Then Return -1
	If a9#>b2# Then Return -2
	Return a9#-b1#
End Function
Function Video_TimeLine_Calc#(a9#,b1#,b2#)
	If a9#<b1# Then Return -1
	If a9#>b2# Then Return -2
	Return ((a9#-b1#)/(b2#-b1#))*676
End Function
Function ExportImage(gr,merd2=3)
	Make_Fake_Image()	
	ChangeDir CDir$+"Graphics\"
	;If merd=0 Then FileName$=IO_FileRequest$("Export Graphic CPC Mode 0",".SG0|.SB0|",400,160,1):Ext$=".SG0"
	;If merd=1 Then FileName$=IO_FileRequest$("Export Graphic CPC Mode 1",".SG1|.SGX|",400,160,1):Ext$=".SG1"
	;If merd=2 Then FileName$=IO_FileRequest$("Export Graphic CPC Mode 2",".SG2|.SB2|",400,160,1):Ext$=".SG2"
	;If merd=3 Then FileName$=IO_FileRequest$("Export Graphic MSX Screen 5",".SG5|.SB5|",400,160,1):Ext$=".SG5"
	;If merd=4 Then FileName$=IO_FileRequest$("Export Graphic MSX Screen 6",".SG6|.SB6|",400,160,1):Ext$=".SG6"
	;If merd=5 Then FileName$=IO_FileRequest$("Export Graphic MSX Screen 7",".SG7|.SB7|",400,160,1):Ext$=".SG7"
	;If merd=6 Then FileName$=IO_FileRequest$("Export Graphic MSX Screen 8",".SG8|.SB8|",400,160,1):Ext$=".SG8"
	
	merd=10
	If merd2=6 Then merd=0	
	If merd2=7 Then merd=1
	If merd2=9 Then merd=3
	If merd2=10 Then merd=4
	If merd2=11 Then merd=5	
	
	
	If merd>=0 And merd<=6 Then FileName$=IO_FileRequest$("Export Graphic SGX",".SGX|",400,160,1):Ext$=".SGX"
	FakerOn=0
	If FileName$<>"" Then
		a=Instr(filename$,".")
		If a=0 Then FileName$=FileName$+Ext$
		
		CpRun=CpRun+1:ComR$(CpRun Mod 50)="< EDITOR > Please wait. Exporting Image to File"+FileName$
		GUI_Mark2():Flip
		file=WriteFile(filename$)
		Upw=60
		If FileDataReturn=1 Then
			;**** Full Screen Background
			If merd=1 Then
				For ket=0 To 1
					Ket1=Ket*160
					WriteByte(file,40)
					WriteByte(file,160)
					WriteByte(file,200)
					For Y=1 To 200
						For X=0 To 159 Step 4
							j=(GetImagePixel(GrpCBank(gr,merd),X+Ket1,Y,320,190,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))Shl 6
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+1,Y,320,190,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))Shl 4
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+2,Y,320,190,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))Shl 2
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+3,Y,320,190,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))							
							j0=(j And 1)				;Pixel 3 - Bit 0
							j1=(j And 2)Shr 1 			;Pixel 3 - Bit 1
							j2=(j And 4)Shr 2			;Pixel 2 - Bit 0
							j3=(j And 8)Shr 3			;Pixel 2 - Bit 1
							j4=(j And 16)Shr 4			;Pixel 1 - Bit 0
							j5=(j And 32)Shr 5			;Pixel 1 - Bit 1
							j6=(j And 64)Shr 6			;Pixel 0 - Bit 0
							j7=(j And 128)Shr 7			;Pixel 0 - Bit 1
							j=(j6 Shl 7)+(j7 Shl 3)+(j4 Shl 6)+(j5 Shl 2)+(j2 Shl 5)+(j3 Shl 1)+(j0 Shl 4)+(j1)
							WriteByte(file,j)
						Next	
					Next
				Next
			EndIf
			If merd=3 Then
				For ket=0 To 1
					If Ket=0 Then Ket1=0:Ket2=128
					If Ket=1 Then Ket1=128:Ket2=128
					WriteByte(file,64)
					WriteByte(file,5)
					WriteByte(file,Ket2/2)
					WriteByte(file,0)		
					WriteByte(file,Ket2)
					WriteByte(file,0)		
					WriteByte(file,212)
					WriteByte(file,0)
					For Y=0 To 211
						For X=0 To (Ket2-1) Step 2
							j=(GetImagePixel(GrpCBank(gr,merd),X+Ket1,Y,256,202,GrpCWid(gr,merd)*2,GrpCHei(gr,merd)))Shl 4
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+1,Y,256,202,GrpCWid(gr,merd)*2,GrpCHei(gr,merd)))
							WriteByte(file,j)
						Next	
					Next
				Next
			EndIf
			If merd=4 Then
				For ket=0 To 3
					If Ket=0 Then Ket1=0:Ket2=152
					If Ket=1 Then Ket1=152:Ket2=152
					If Ket=2 Then Ket1=304:Ket2=152				
					If Ket=3 Then Ket1=456:Ket2=56
					WriteByte(file,64)
					WriteByte(file,5)
					WriteByte(file,Ket2/4)
					WriteByte(file,0)		
					WriteByte(file,Ket2)
					WriteByte(file,0)		
					WriteByte(file,212)
					WriteByte(file,0)
					For Y=0 To 211
						For X=0 To (Ket2-1) Step 4
							j=(GetImagePixel(GrpCBank(gr,merd),X+Ket1,Y,512,202,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))Shl 6
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+1,Y,512,202,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))Shl 4
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+2,Y,512,202,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))Shl 2
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+3,Y,512,202,GrpCWid(gr,merd)*4,GrpCHei(gr,merd)))
							WriteByte(file,j)
						Next	
					Next
				Next
			EndIf			
			If merd=5 Then
				For ket=0 To 3
					If Ket=0 Then Ket1=0:Ket2=152
					If Ket=1 Then Ket1=152:Ket2=152
					If Ket=2 Then Ket1=304:Ket2=152					
					If Ket=3 Then Ket1=456:Ket2=56
					WriteByte(file,64)
					WriteByte(file,5)
					WriteByte(file,Ket2/2)
					WriteByte(file,0)		
					WriteByte(file,Ket2)
					WriteByte(file,0)		
					WriteByte(file,212)
					WriteByte(file,0)
					For Y=0 To 211
						For X=0 To (Ket2-1) Step 2
							j=(GetImagePixel(GrpCBank(gr,merd),X+Ket1,Y,512,202,GrpCWid(gr,merd)*2,GrpCHei(gr,merd)))Shl 4
							j=j+(GetImagePixel(GrpCBank(gr,merd),X+Ket1+1,Y,512,202,GrpCWid(gr,merd)*2,GrpCHei(gr,merd)))
							WriteByte(file,j)
						Next	
					Next
				Next
			EndIf
		EndIf
		If FileDataReturn=0 Then
			nf=GrpCWid(gr,merd)
			WriteByte(file,64)
			If merd<3 Then
				j1=0
			Else
				j1=1
			EndIf	
			If merd=0 Or merd=3 Or merd=5 Then
				j2=1
			Else
				j2=0
			EndIf
			wef=GrpCWid(gr,merd)
			wef1=wef
			kef=PixelWidthByte(wef,merd)
			Kef1=kef
			If j1=0 Then
				If wef1>255 Then
					wef1=255
					kef1=1020
				EndIf
			Else
				If wef1>252 Then
					wef1=252
					kef1=508
				EndIf			
			EndIf
			WriteByte(file,j1+(j2 Shl 2))
			WriteByte(file,wef1 Mod 256)
			WriteByte(file,Floor(wef1/256))		
			WriteByte(file,Kef1 Mod 256)
			WriteByte(file,Floor(Kef1/256))		
			WriteByte(file,GrpCHei(gr,merd)Mod 256)
			WriteByte(file,Floor(GrpCHei(gr,merd)/256))
			For Y=1 To GrpCHei(gr,merd)
				wr=((Y-1)*GrpCWid(gr,merd))*2
				wr1=((Y-1)*GrpCWid(gr,merd))*4
				For X=1 To wef1			; *** was nf
					If merd=3 Or merd=5 Or merd=0 Then
						j=(PeekByte(GrpCBank(gr,merd),wr+(X*2)-1)Shl 4)+PeekByte(GrpCBank(gr,merd),wr+(X*2))
						If merd=0 Then
							j0=(j And 1)				;Pixel 1 - Bit 0
							j1=(j And 2)Shr 1			;Pixel 1 - Bit 1
							j2=(j And 4)Shr 2			;Pixel 1 - Bit 2
							j3=(j And 8)Shr 3			;Pixel 1 - Bit 3
							j4=(j And 16)Shr 4			;Pixel 0 - Bit 0
							j5=(j And 32)Shr 5			;Pixel 0 - Bit 1
							j6=(j And 64)Shr 6			;Pixel 0 - Bit 2
							j7=(j And 128)Shr 7			;Pixel 0 - Bit 3
							j=(j4 Shl 7)+(j5 Shl 3)+(j6 Shl 5)+(j7 Shl 1)+(j0 Shl 6)+(j1 Shl 2)+(j2 Shl 4)+(j3)
						EndIf
						WriteByte(file,j)
					EndIf
					If merd=1 Or merd=4 Then
						j=(PeekByte(GrpCBank(gr,merd),wr1+((X*4))-4)Shl 6)
						j=j+(PeekByte(GrpCBank(gr,merd),wr1+((X*4)-3))Shl 4)
						j=j+(PeekByte(GrpCBank(gr,merd),wr1+((X*4)-2))Shl 2)					
						j=j+(PeekByte(GrpCBank(gr,merd),wr1+((X*4)-1)))
						If merd=1 Then
							j0=(j And 1)				;Pixel 3 - Bit 0
							j1=(j And 2)Shr 1 			;Pixel 3 - Bit 1
							j2=(j And 4)Shr 2			;Pixel 2 - Bit 0
							j3=(j And 8)Shr 3			;Pixel 2 - Bit 1
							j4=(j And 16)Shr 4			;Pixel 1 - Bit 0
							j5=(j And 32)Shr 5			;Pixel 1 - Bit 1
							j6=(j And 64)Shr 6			;Pixel 0 - Bit 0
							j7=(j And 128)Shr 7			;Pixel 0 - Bit 1
							j=(j6 Shl 7)+(j7 Shl 3)+(j4 Shl 6)+(j5 Shl 2)+(j2 Shl 5)+(j3 Shl 1)+(j0 Shl 4)+(j1)					
						EndIf
						WriteByte(file,j)
					EndIf
				Next
			Next
		EndIf
		CloseFile(file)
	EndIf
	If Package<>Package2 Then
		Package2=Package
		DrawSidePanel(Package)
	EndIf
End Function


Function GetImagePixel(DtStr,Apw=0,Aph=0,Spw=320,Sph=200,Upw=0,Uph=0)
		Opw=0:Oph=0
		If Upw<Spw Then Opw=(Spw-Upw)/2
		If Uph<Sph Then Oph=(Sph-Uph)/2
		If Apw>=Opw And Apw<Opw+Upw And Aph>=Oph And Aph<Oph+Uph Then
			Return PeekByte(DtStr,(Upw*(Aph-Oph))+(Apw-Opw))
		Else
			Return 1
		EndIf	
End Function
Function ConvertDox()

	file=OpenFile("tester.htm")

	LoC=0
	While Not(Eof(file)) 
		Cd$(LoC)=ReadLine(file)
		LoC=LoC+1
	Wend
	CloseFile(file)
	CurrLine=0
	Gathering=0
	FontSetting=0:AlignSetting=0
	FileX=WriteFile("output.txt")
	Htm_HTML=0
	Setup_Dox_Headers()		;**** Sets up Data Banks with header Info & Defaults


	Add_Dox_Add2(1,23)

	While CurrLine<=LoC
		Answer$=Seperate$(CurrLine)
		Cod=1

.BanditsAhead				
		r$=Upper$(SepSort$(Cod))
		If r$=""Then Goto BanditsLoop
		If r$="<"Then
			Cod=Cod+1
			Gathering=9999
			Goto BanditsAhead
		EndIf
		If r$=">"Then
			;**** Check what This was doing ****
			If Gathering=400 Then Dox_Func_IMG				;**** IMG 
			Cod=Cod+1
			Gathering=0
			Goto BanditsAhead
		EndIf
		;**** Within Gather
		If Gathering>0 Then
			If r$="/"Then
				TurnOff=1
				Cod=Cod+1
				r$=Upper$(SepSort$(Cod))
				If r$=""Then Goto BanditsLoop	
			EndIf
			;**** HTML Tags
			If r$="HTML"Then
				If TurnOff=0 Then Htm_HTML=1:Gathering=100
				If TurnOff=1 Then Htm_HTML=0:Gathering=0
			EndIf
			If r$="B" Or r$="BOLD"Then
				If TurnOff=0 Then Htm_BOLD=1:Gathering=200:Dox_Font_Change
				If TurnOff=1 Then Htm_BOLD=0:Gathering=0:Dox_Font_Change
			EndIf
			If r$="I"Then
				If TurnOff=0 Then Htm_ITAL=1:Gathering=201:Dox_Font_Change
				If TurnOff=1 Then Htm_ITAL=0:Gathering=0:Dox_Font_Change
			EndIf			
			If r$="BIG"Then
				If TurnOff=0 Then Htm_BIG=1:Gathering=202:Dox_Font_Change
				If TurnOff=1 Then Htm_BIG=0:Gathering=0:Dox_Font_Change
			EndIf
			If r$="H1"Or r$="H2"Or r$="H3" Then
				If TurnOff=0 Then Htm_BIG=1:Gathering=204:Dox_Force_CR()
				If TurnOff=1 Then Htm_BIG=0:Gathering=0:Dox_Force_CR()
			EndIf
			If r$="H4"Or r$="H5"Or r$="H6" Then
				If TurnOff=0 Then Htm_BIG=0:Gathering=204:Dox_Force_CR()
				If TurnOff=1 Then Htm_BIG=0:Gathering=0:Dox_Force_CR()
			EndIf
			
			If r$="BR"Then Gathering=250:Add_Dox_Add2(8,3):ForceCR=0		;Carriage Return			

			If r$="P"Then
				If TurnOff=0 Then Htm_P=1:Gathering=300:Dox_Force_CR()
				If TurnOff=1 Then Htm_P=0:Gathering=0:Dox_Force_CR()
			EndIf

			If r$="IMG"Then
				If TurnOff=0 Then Htm_IMG=1:Gathering=400:Dox_Attr_Clear(20)
			EndIf
			

			If r$="ALIGN"Then
				Cod=Cod+1
				r$=Upper$(SepSort$(Cod))			
				If r$="="Then
					Cod=Cod+1
					r$=Upper$(SepSort$(Cod))
					If r$="LEFT"Or r$=(Chr$(34)+"LEFT"+Chr$(34)) Then Htm_ALIGN=1:Dox_Align_Change
					If r$="RIGHT"Or r$=(Chr$(34)+"RIGHT"+Chr$(34)) Then Htm_ALIGN=2:Dox_Align_Change
					If r$="CENTER"Or r$=(Chr$(34)+"CENTER"+Chr$(34)) Then Htm_ALIGN=3:Dox_Align_Change					
				EndIf
			EndIf

			If r$="SRC"Then Dox_Add_Attribute(1)

			TurnOff=0
			Cod=Cod+1
			Goto BanditsAhead
		EndIf

		;**** Add Text if needed ****
		If Gathering=0 Then
			tre$=r$
			tre$=Mid$(Answer$,Wrd(Cod,1)+1,1)
			If tre$=" " Then
				tre$=Mid$(Answer$,Wrd(Cod,0),Wrd(Cod,1)-Wrd(Cod,0)+2)
			Else
				tre$=Mid$(Answer$,Wrd(Cod,0),Wrd(Cod,1)-Wrd(Cod,0)+1)
			EndIf
			WriteLine (FileX,"db "+Chr$(34)+tre$+Chr$(34))
			For f=1 To Len(tre$)
				PokeByte(DOX_Text,DOX_Text_Size,Asc(Mid$(Tre$,f,1)))
				DOX_Text_Size=DOX_Text_Size+1
			Next
			ForceCR=1
			Cod=Cod+1
			Goto BanditsAhead
		EndIf
.BanditsLoop
		CurrLine=CurrLine+1
	Wend


	Correct_Dox_Headers()

	CloseFile(FileX)
	;**** Save Dox File ****
	file=WriteFile("Output.dox")
	WriteBytes(Dox_Info,file,0,Dox_Info_Size)
	WriteBytes(Dox_Index,file,0,Dox_Index_Size)
	WriteBytes(DOX_Text,file,0,DOX_Text_Size)
	WriteBytes(Dox_Graphic,file,0,Dox_Graphic_Size)
	WriteBytes(Dox_Graphic_Data,file,0,Dox_Graphic_Data_Size)
	CloseFile(file)

	aw1=Dox_Info_Size:ae1=PeekShort(Dox_Info,4)
	aw2=Dox_Index_Size:ae2=PeekShort(Dox_Index,4)
	aw3=DOX_Text_Size:ae3=PeekShort(DOX_Text,4)
	aw4=Dox_Graphic_Size:ae4=PeekShort(Dox_Graphic,4)

	RuntimeError "Success"
End Function
Function Dox_Func_IMG()
	r$=Dox_Find_Attr$(20,1)			;**** 20 (search Group) 1=SRC
	
	Stop
	
	BlitzGet(r$,CurrentDir$()+"graphics","convertdox.gif")
	
	
	Stop
	
	wep=LoadGifImage("graphics\convertdox.gif")
	If wep<>0 Then
		Dox_Graphic_Used=Dox_Graphic_Used+1
		Dox_Graphic_ID(Dox_Graphic_Used)=Dox_Graphic_Data_Size
		gw=ImageWidth(wep)/4
		gh=ImageHeight(wep)/2

		If gw<2 Then gw=2
		If gw>254 Then gw=254
		gw=gw And 254

		
		PokeByte(Dox_Graphic_Data,Dox_Graphic_Data_Size+0,64)
		PokeByte(Dox_Graphic_Data,Dox_Graphic_Data_Size+1,5)
		PokeShort(Dox_Graphic_Data,Dox_Graphic_Data_Size+2,gw)
		PokeShort(Dox_Graphic_Data,Dox_Graphic_Data_Size+4,(gw Shl 1))
		PokeShort(Dox_Graphic_Data,Dox_Graphic_Data_Size+6,gh)
		Dox_Graphic_Data_Size=Dox_Graphic_Data_Size+8
		SetBuffer ImageBuffer(wep)
		b1=0
		gh1=1

		SceX#=Float(ImageWidth(wep))/Float(gw)
		SceX1#=SceX#/2.0
		For f=0 To ImageHeight(wep)+4 Step 2
			If gh1>gh Then Exit
			gh1=gh1+1
			b2=0
			For g=0 To gw-1
				GetColor g*SceX#,f
				a1=ColorRed():a2=ColorGreen():a3=ColorBlue():a4=a1+a2+a3
				If a4=0 Then
					b9=0
				Else
					PokeByte TinyBnk,0,a1
					PokeByte TinyBnk,1,a2
					PokeByte TinyBnk,2,a3
					ConvertPixel(2,0,TinyBnk,b2,b1)
					b9=ReturnByteThing
				EndIf
				b2=(b2+1) Mod 16
				GetColor (g*SceX#)+SceX1#,f
				a1=ColorRed():a2=ColorGreen():a3=ColorBlue():a4=a1+a2+a3
				If a4=0 Then
					b8=0
				Else
					PokeByte TinyBnk,0,ColorRed()
					PokeByte TinyBnk,1,ColorGreen()
					PokeByte TinyBnk,2,ColorBlue()
					ConvertPixel(2,0,TinyBnk,b2,b1)
					b8=ReturnByteThing
				EndIf
				b2=(b2+1) Mod 16
				PokeByte(Dox_Graphic_Data,Dox_Graphic_Data_Size,(b9 Shl 4)+b8)
				Dox_Graphic_Data_Size=Dox_Graphic_Data_Size+1
			Next
		
			b1=(b1+1) Mod 16
		Next
		SetBuffer BackBuffer()
		;RuntimeError "Buggered "+Str$(gw)+" "+Str$(gh)+" "+Str$(Dox_Graphic_Data_Size)

		Add_Dox_Add2(10,2)
		Add_Dox_Add2(Dox_Graphic_Used,8)
		Add_Dox_Add2(255,1)
	EndIf

End Function
Function Dox_Find_Attr$(a,b)
	For f=1 To 32
		If Dox_Attr(a,f)=b Then
			r$=Dox_Attr_Str$(a,f)
			If Mid$(r$,1,1)=Chr$(34)Then r$=Mid$(r$,2)
			If Mid$(r$,Len(r$),1)=Chr$(34) Then r$=Left$(r$,Len(r$)-1)
			Return r$
		EndIf	
	Next
	Return ""
End Function
Function Dox_Attr_Clear(a)
	For f=0 To 32
		Dox_Attr(a,f)=0
		Dox_Attr_Str$(a,f)=""
		Dox_Attr_Val(a,f)=0
	Next
End Function
Function Dox_Add_Attribute(a)

	If Gathering=400 Then b=20		;**** Is Image ****
	If a=1 Then	Dox_Get_String(a,b) 	;**** SRC
	
;
;			If r$="ALIGN"Then
;				Cod=Cod+1
;				r$=Upper$(SepSort$(Cod))			
;				If r$="="Then
;					Cod=Cod+1
;					r$=Upper$(SepSort$(Cod))
;					If r$="LEFT"Or r$=(Chr$(34)+"LEFT"+Chr$(34)) Then Htm_Align=1:Dox_Align_Change
;					If r$="RIGHT"Or r$=(Chr$(34)+"RIGHT"+Chr$(34)) Then Htm_Align=2:Dox_Align_Change
;					If r$="CENTER"Or r$=(Chr$(34)+"CENTER"+Chr$(34)) Then Htm_Align=3:Dox_Align_Change					
;				EndIf
;			EndIf
;
;			If r$="SRC"Then Dox_Add_Attribute(1)
End Function
Function Dox_Get_String$(a1,b1)
	Cod=Cod+1
	r$=SepSort$(Cod)
	If r$="="Then
		Cod=Cod+1
		r$=SepSort$(Cod)
		For f=1 To 32
			If Dox_Attr(b1,f)=0 Then
				Dox_Attr(b1,f)=a1
				Dox_Attr_Str$(b1,f)=r$
			EndIf	
		Next
		Return r$
	EndIf	
	Return ""
End Function
Function Dox_Force_CR()
	Dox_Font_Change
	If ForceCR=1 Then
		Add_Dox_Add2(8,3)
		ForceCR=0
	EndIf
	Htm_ALIGN=1
	Dox_Align_Change
End Function
Function Dox_Align_Change()
	If AlignSetting<>Htm_ALIGN Then
		AlignSetting=Htm_ALIGN
		Add_Dox_Add2(9,1)
		Add_Dox_Add2(AlignSetting,1)		
	EndIf
End Function	
Function Dox_Font_Change()
	a=(Htm_BIG Shl 2)+(Htm_ITAL Shl 1)+(Htm_BOLD)
	If FontSetting<>a Then
		FontSetting=a
		If FontSetting=0 Then Add_Dox_Add3(2,1,1)		;Normal
		If FontSetting=1 Then Add_Dox_Add3(2,3,1)		;Bold
		If FontSetting=2 Then Add_Dox_Add3(2,2,1)		;Itals
		If FontSetting=3 Then Add_Dox_Add3(2,2,1)		;OverRides Itals
		If FontSetting=4 Then Add_Dox_Add3(2,4,1)		;Big
		If FontSetting=5 Then Add_Dox_Add3(2,4,1)		;Overrides to Big
		If FontSetting=6 Then Add_Dox_Add3(2,4,1)		;OverRides to Big
		If FontSetting=7 Then Add_Dox_Add3(2,4,1)		;Overrides To Big		
	EndIf

End Function

Function Setup_Dox_Headers()
	Dox_Info_Size=8
	Dox_Index_Size=8
	DOX_Text_Size=8
	Dox_Graphic_Size=9
	Dox_Graphic_Used=0
	Dox_Graphic_Data_Size=0
	
	;**** Info First ****
	PokeByte(Dox_Info,0,Asc("I")):PokeByte(Dox_Info,1,Asc("N")):PokeByte(Dox_Info,2,Asc("F")):PokeByte(Dox_Info,3,Asc("O"))
	PokeShort(Dox_Info,4,0):PokeShort(Dox_Info,6,0)
	;**** Index ****
	PokeByte(Dox_Index,0,Asc("I")):PokeByte(Dox_Index,1,Asc("N")):PokeByte(Dox_Index,2,Asc("D")):PokeByte(Dox_Index,3,Asc("X"))
	PokeShort(Dox_Index,4,0):PokeShort(Dox_Index,6,0)
	;**** Text ****
	PokeByte(DOX_Text,0,Asc("T")):PokeByte(DOX_Text,1,Asc("E")):PokeByte(DOX_Text,2,Asc("X")):PokeByte(DOX_Text,3,Asc("T"))
	PokeShort(DOX_Text,4,0):PokeShort(DOX_Text,6,0)
	;**** Graphic ****
	PokeByte(Dox_Graphic,0,Asc("G")):PokeByte(Dox_Graphic,1,Asc("R")):PokeByte(Dox_Graphic,2,Asc("P")):PokeByte(Dox_Graphic,3,Asc("H"))
	PokeShort(Dox_Graphic,4,0):PokeShort(Dox_Graphic,6,0)
	PokeByte(Dox_Graphic,8,0)

End Function

Function Correct_Dox_Headers()
	Add_Dox_Info_String("DOX document example")     ;title
	Add_Dox_Info_String("Prodatron")                ;author
	Add_Dox_Info_String("SymbiosiS")                ;company
	Add_Dox_Info_String("1.0")                      ;revision
	Add_Dox_Info_String("28.03.2007")               ;last update
	Add_Dox_Info_String("New SymbOS features")      ;topic
	Add_Dox_Info_String("Demo document")            ;category
	Add_Dox_Info_String("A little demonstration")   ;comments
	;**** End Document *****
	WriteLine (FileX,"db 0,255")
	PokeByte(DOX_Text,DOX_Text_Size,0):	PokeByte(DOX_Text,DOX_Text_Size+1,255):DOX_Text_Size=DOX_Text_Size+2
	
	PokeShort(Dox_Info,4,Dox_Info_Size-8)
	PokeShort(Dox_Index,4,Dox_Index_Size-8)
	PokeShort(DOX_Text,4,DOX_Text_Size-8)
	b=(Dox_Graphic_Used*2)+Dox_Graphic_Data_Size+1
	PokeShort(Dox_Graphic,4,b)
	PokeByte(Dox_Graphic,8,Dox_Graphic_Used)
	For f=1 To Dox_Graphic_Used
		If f<Dox_Graphic_Used Then
			b=Dox_Graphic_ID(f+1)-Dox_Graphic_ID(f)
		Else
			b=Dox_Graphic_Data_Size-Dox_Graphic_ID(f)
		EndIf
		PokeShort(Dox_Graphic,Dox_Graphic_Size,b)
		Dox_Graphic_Size=Dox_Graphic_Size+2
	Next
	PokeByte(Dox_Graphic,Dox_Graphic_Data_Size,"E")
	PokeByte(Dox_Graphic,Dox_Graphic_Data_Size+1,"N")
	PokeByte(Dox_Graphic,Dox_Graphic_Data_Size+2,"D")
	PokeByte(Dox_Graphic,Dox_Graphic_Data_Size+3,"F")
	PokeShort(Dox_Graphic,Dox_Graphic_Data_Size+4,0)
	PokeShort(Dox_Graphic,Dox_Graphic_Data_Size+6,0)
	Dox_Graphic_Data_Size=Dox_Graphic_Data_Size+8
	
End Function


Function Add_Dox_Add2(z1,z2)
	WriteLine(FileX,"db "+Str$(z1)+","+Str$(z2))
	PokeByte(DOX_Text,DOX_Text_Size,z1)
	PokeByte(DOX_Text,DOX_Text_Size+1,z2)
	DOX_Text_Size=DOX_Text_Size+2
End Function
Function Add_Dox_Add3(z1,z2,z3)
	WriteLine(FileX,"db "+Str$(z1)+","+Str$(z2)+","+Str$(z3))
	PokeByte(DOX_Text,DOX_Text_Size,z1)
	PokeByte(DOX_Text,DOX_Text_Size+1,z2)
	PokeByte(DOX_Text,DOX_Text_Size+2,z3)	
	DOX_Text_Size=DOX_Text_Size+3
End Function

Function Add_Dox_Info_String(qp$)
	For f=1 To Len(qp$)
		PokeByte(Dox_Info,Dox_Info_Size,Asc(Mid$(qp$,f,1)))
		Dox_Info_Size=Dox_Info_Size+1
	Next
	PokeByte(Dox_Info,Dox_Info_Size,0)
	Dox_Info_Size=Dox_Info_Size+1	
End Function

Function DoOutputVideo(merd)
	ChangeDir CDir$+"Video\"
	Make_Fake_Image()
	;If merd=0 Then FileName$=IO_FileRequest$("Export Video CPC Mode 0",".VI0|",400,160):Ext$=".VI0"
	;If merd=1 Then FileName$=IO_FileRequest$("Export Video CPC Mode 1",".VI1|",400,160):Ext$=".VI1"
	;If merd=2 Then FileName$=IO_FileRequest$("Export Video CPC Mode 2",".VI2|",400,160):Ext$=".VI2"
	;If merd=3 Then FileName$=IO_FileRequest$("Export Video MSX Screen 5",".VI5|",400,160):Ext$=".Vi5"
	;If merd=4 Then FileName$=IO_FileRequest$("Export Video MSX Screen 6",".VI6|",400,160):Ext$=".VI6"
	;If merd=5 Then FileName$=IO_FileRequest$("Export Video MSX Screen 7",".VI7|",400,160):Ext$=".VI7"
	;If merd=6 Then FileName$=IO_FileRequest$("Export Video MSX Screen 8",".VI8|",400,160):Ext$=".VI8"
	If merd>=0 And merd<=6 Then FileName$=IO_FileRequest$("Export Video",".VID|",400,160):Ext$=".VID"
	
	;FakerOn=1:Gui_Mark2():Flip
	If FileName$<>"" Then
		WaitRelease()
		a=Instr(filename$,".")
		If a=0 Then FileName$=FileName$+Ext$
		a8#=0
		For f=2 To 12
			If Med_Stop(f,Med_Max(f))>a8# Then a8#=Med_Stop(f,Med_Max(f))
		Next
		a9#=GUI_GadVal(CollectGads2(22))
		b9=Floor((a8#-Vid_TimeLinePointer#)*a9#)
		If b9>0 Then
			b8=GUI_GadVal(CollectGads2(20))
			PixWid=ActualByteWidth(GUI_GadVal(CollectGads2(20)),merd)
			PixHei=GUI_GadVal(CollectGads2(21))

			Exceed=0
			While (PixHei*PixWid)>16384
				PixHei=PixHei-1
				Exceed=Exceed+1
			Wend
			FrmSize=(PixWid*PixHei);+2
			FrmSize=(512-(FrmSize Mod 512))+FrmSize
			a8#=Vid_TimeLinePointer#
			a7#=1.0/GUI_GadVal(CollectGads2(22))
	
			OutputFile=WriteFile(Filename$)		
			WriteByte(OutputFile,Asc("S"))
			WriteByte(OutputFile,Asc("y"))
			WriteByte(OutputFile,Asc("m"))
			WriteByte(OutputFile,Asc("V"))
			WriteByte(OutputFile,Asc("i"))
			WriteByte(OutputFile,Asc("d"))
			WriteByte(OutputFile,Asc("1"))
			WriteByte(OutputFile,Asc("0"))
			WriteByte(OutputFile,0)
			WriteByte(OutputFile,0)											;Crunch
			WriteByte(OutputFile,Int(a9#))									;Frames Per second
			WriteByte(OutputFile,b9 Mod 256)								;Number of Frames Low
			WriteByte(OutputFile,(b9/256)Mod 256)							;Number of Frames Middle
			WriteByte(OutputFile,(b9/65536)Mod 256)							;Number of Frames High
			WriteShort(OutputFile,PixelWidthByte(PixWid,merd))				;Width in Pixels
			WriteShort(OutputFile,PixHei)									;Height in Pixels

			merd1=merd
			If merd<2 Then
				merd1=1
			Else
				merd1=7
			EndIf			
			If merd=1 Then 
				WriteByte(OutputFile,1)										;Mode
			Else
				WriteByte(OutputFile,7)										;Mode
			EndIf
			For f=0 To 15
				a0=(OS_Red(f)Shl 4) And 15
				a1=(OS_Green(f)Shl 4) And 15
				a2=(OS_Blue(f)Shl 4) And 15
				a=a0+(a1*16)+(a2*256)
				WriteShort(OutputFile,a)									;Colour
			Next
			WriteShort(OutputFile,FrmSize)									;Size of Frame
			Pad(512-(32+21))

			Me=0
			Me1=1
			Bling#=0
			KeyFramer=0
			Bling2#=0
			k1=1
			For k=1 To b9
				VideoSeek()
				VideoLoad()
				VideoCalc()
				GUI_Mark2(1)

				;BuildBlocks(Vid_PixWid,Vid_PixHei,Vid_Mode)
				ConvertVideoImage(Vid_PixWid,Vid_PixHei,Vid_Mode+6)


				Me=ScreenMem
				;PokeShort(Me,0,0)
				;bling=FrmSize
				;dre=0
				;If KeyFramer<>0 And (MissedCount#*1.8)<FrmSize Then
				;	Me=ScreenMemOut
				;	Bling#=(512-(MissedCount Mod 512))+MissedCount
				;	PokeShort(me,0,(512-(MissedCount Mod 512))+MissedCount)
				;	dre=1
				;EndIf

				OutputVideoFrame(Me,Vid_Mode,ActualByteWidth(GUI_GadVal(CollectGads2(20)),merd),PixHei)
				
				KeyFramer=(KeyFramer+1)Mod 16
				Vid_PixWid=Gui_GadVal(CollectGads2(20))
				Vid_PixHei=PixHei
				n=ScreenWidth(Vid_PixWid,Vid_Mode)
				If Vid_PixWid>Vid_PixWidMax Then Vid_PixWid=Vid_PixWidMax
				DrawBlockRect PreviewScreen,610-(n/2),260-(Vid_PixHei),0,0,n,Vid_PixHei*2

				Color 120,0,0:Rect 510,246,190,32
				If Exceed=0 Then
					If KeyFramer<>0 And dre=1 Then 
						bling2#=bling2#+bling#
						k1=k1+1
					EndIf
				
					Color 255,255,255:Text 610,247,Str$(k1)+"@"+Str$(bling2#/k1)+"    "+Str$(k-k1)+"@"+Str$(FrmSize),1
					Color 255,255,255:Text 610,263,"Exporting Frame: "+Str$(k)+" / "+Str$(b9),1
				Else
					Color 255,255,255:Text 610,247,"Exporting Frame: "+Str$(k)+" / "+Str$(b9),1
					Color 255,200,200:Text 610,263,"(Frame >> 16k - "+Exceed+" lines cropped)",1					
				EndIf

				Vid_TimeLinePointer#=Vid_TimeLinePointer#+a7#
				Flip
			Next
			Vid_TimeLinePointer#=a8#
			CloseFile(OutputFile)
		EndIf
		FakerOn=0:GUI_Mark2():Flip	
	EndIf
End Function
Function OutputVideoFrame(me,merd,CaptureWidth,CaptureHeight)
	;Me=ScreenMem
	qa=0;2
	For Y=0 To CaptureHeight-1
		wr=Y*CaptureWidth
		wr1=(Y*CaptureWidth)*4	
		For X=0 To CaptureWidth-1
			If merd=3 Or merd=5 Or merd=0 Then
				j=PeekByte(me,wr+X)
				If merd=0 Then
					j0=(j And 1)				;Pixel 1 - Bit 0
					j1=(j And 2)Shr 1			;Pixel 1 - Bit 1
					j2=(j And 4)Shr 2			;Pixel 1 - Bit 2
					j3=(j And 8)Shr 3			;Pixel 1 - Bit 3
					j4=(j And 16)Shr 4			;Pixel 0 - Bit 0
					j5=(j And 32)Shr 5			;Pixel 0 - Bit 1
					j6=(j And 64)Shr 6			;Pixel 0 - Bit 2
					j7=(j And 128)Shr 7			;Pixel 0 - Bit 3
					j=(j4 Shl 7)+(j5 Shl 3)+(j6 Shl 5)+(j7 Shl 1)+(j0 Shl 6)+(j1 Shl 2)+(j2 Shl 4)+(j3)
				EndIf
				WriteByte(OutputFile,j)
				qa=qa+1
			EndIf
			If merd=1 Or merd=4 Then
				j=PeekByte(me,wr+X)
				If merd=1 Then
					j0=(j And 1)				;Pixel 3 - Bit 0
					j1=(j And 2)Shr 1 			;Pixel 3 - Bit 1
					j2=(j And 4)Shr 2			;Pixel 2 - Bit 0
					j3=(j And 8)Shr 3			;Pixel 2 - Bit 1
					j4=(j And 16)Shr 4			;Pixel 1 - Bit 0
					j5=(j And 32)Shr 5			;Pixel 1 - Bit 1
					j6=(j And 64)Shr 6			;Pixel 0 - Bit 0
					j7=(j And 128)Shr 7			;Pixel 0 - Bit 1
					j=(j6 Shl 7)+(j7 Shl 3)+(j4 Shl 6)+(j5 Shl 2)+(j2 Shl 5)+(j3 Shl 1)+(j0 Shl 4)+(j1)					
				EndIf
				WriteByte(OutputFile,j)
				qa=qa+1
			EndIf
		Next
	Next
	Pad(512-(qa Mod 512))
End Function
Function ActualScreenWidth(BytWid,TheType)
	If TheType=0 Or TheType=1 Or TheType=2 Then
		If BytWid>78 Then BytWid=78
	EndIf
	If TheType=3 Or TheType=4 Then
		If BytWid>126 Then BytWid=126
	EndIf
	If TheType=5 Or TheType=6 Then
		If BytWid>252 Then BytWid=252
	EndIf	

	If TheType=0 Or TheType=3 Or TheType=5 Then
		Return BytWid*2
	EndIf
	If TheType=1 Or TheType=4 Then
		Return BytWid*4
	EndIf
	If TheType=2 Then
		Return BytWid*8
	EndIf
	If TheType=6 Then
		Return BytWid
	EndIf	
End Function
Function ActualByteWidth(BytWid,TheType)
	If TheType=0 Or TheType=1 Or TheType=2 Then
		If BytWid>78 Then BytWid=78
	EndIf
	If TheType=3 Or TheType=4 Then
		If BytWid>126 Then BytWid=126
	EndIf
	If TheType=5 Or TheType=6 Then
		If BytWid>252 Then BytWid=252
	EndIf
	Return BytWid
End Function


; -----------------------------------------------------------------------------
; File download function
; -----------------------------------------------------------------------------
; webFile$  -- file to download
; saveDir$  -- directory to download into
; saveFile$ -- filename to save as (use "" to use name of downloaded file automatically)
; -----------------------------------------------------------------------------
; Note that if you just provide a web server address, the document downloaded will
; be named "Unknown file.txt"
; -----------------------------------------------------------------------------

Function BlitzGet (webFile$, saveDir$, saveFile$)
	If Left (webFile$, 7) = "http://" Then webFile$ = Right (webFile$, Len (webFile$) - 7)
	; -------------------------------------------------------------------------
	; Split into hostname and path/filename to download
	; -------------------------------------------------------------------------
	slash = Instr (webFile$, "/")
	If slash
		webHost$ = Left (webFile$, slash - 1)
		webFile$ = Right (webFile$, Len (webFile$) - slash + 1)
	Else
		webHost$ = webFile$
		webFile$ = "/"
	EndIf
	; -----------------------------------------------------------------------
	; Add trailing slash to download dir if not given
	; -------------------------------------------------------------------------
	If Right (saveDir$, 1) <> "\" Then saveDir$ = saveDir$ + "\"
	; -------------------------------------------------------------------------
	; Save filename -- get from webFile$ if not provided
	; -------------------------------------------------------------------------
	If saveFile$ = ""
		If webFile = "/"
			saveFile$ = "Unknown file.txt"
		Else
			For findSlash = Len (webFile$) To 1 Step - 1
				testForSlash$ = Mid (webFile$, findSlash, 1)
				If testForSlash$ = "/"
					saveFile$ = Right (webFile$, Len (webFile$) - findSlash)
					Exit
				EndIf
			Next
			If saveFile$ = "" Then saveFile$ = "Unknown file.txt"
		EndIf
	EndIf
	; DEBUG
	; RuntimeError "Web host: " + webHost$ + Chr (10) + "Web file: " + webFile$ + Chr (10) + "Save dir: " + saveDir$ + Chr (10) + "Save file: " + saveFile$
	www = OpenTCPStream (webHost$, 80)
	If www
		WriteLine www, "GET " + webFile$ + " HTTP/1.1" ; GET / gets default page...
		WriteLine www, "Host: " + webHost$
		WriteLine www, "User-Agent: BlitzGet Deluxe"
		WriteLine www, "Accept: */*"
		WriteLine www, ""
		
		; ---------------------------------------------------------------------
		; Find blank line after header data, where the action begins...
		; ---------------------------------------------------------------------
				
		Repeat
			;Cls
			header$ = ReadLine (www)
			Reply$ = ""
			pos = Instr (header$, ": ")
			If pos
				Reply$ = Left (header$, pos + 1)
			EndIf
			Select Lower (Reply$)
				Case "content-length: "
					bytesToRead = ReplyContent (header$, Reply$)
				Case "date: "
					date$ = ReplyContent (header$, Reply$)
				Case "server: "
					server$ = ReplyContent (header$, Reply$)
				Case "content-type: "
					contentType$ = ReplyContent (header$, Reply$)
				Default
					If gotReply = 0 Then initialReply$ = header$: gotReply = 1
			End Select
			;DisplayResponse ()
			;Flip
		Until header$ = "" Or (Eof (www))
		If bytesToRead = 0 Then Goto skipDownload
		; ---------------------------------------------------------------------
		; Create new file to write downloaded bytes into
		; ---------------------------------------------------------------------
		save = WriteFile (saveDir$ + saveFile$)
		If Not save Then Goto skipDownload
		; ---------------------------------------------------------------------
		; Incredibly complex download-to-file routine...
		; ---------------------------------------------------------------------

		For readWebFile = 1 To bytesToRead
		
			If Not Eof (www) Then WriteByte save, ReadByte (www)
			
			; Call BytesReceived with position and size every 100 bytes (slows down a LOT with smaller updates)
			
			tReadWebFile = readWebFile
			If tReadWebFile Mod 100 = 0 Then BytesReceived (readWebFile, bytesToRead)

		Next

		CloseFile save
		
		; Fully downloaded?
		If (readWebFile - 1) = bytesToRead
			success = 1
		EndIf
		; Final update (so it's not rounded to nearest 100 bytes!)
		BytesReceived (bytesToRead, bytesToRead)
		.skipDownload
		CloseTCPStream www
	Else
		RuntimeError "Failed to connect"
	EndIf
	Return success	
End Function
Function ReplyContent$ (header$, reply$)
	Return Right (header$, Len (header$) - Len (reply$))
End Function
Function BytesReceived (posByte, totalBytes)
	; Example update code...
	;Cls
	;Text 0, 10, "Downloading file -- please wait..."
	;Text 0, 30, "Received: " + posByte + "/" + totalBytes + " bytes (" + Percent (posByte, totalBytes) + "%)"
	;DisplayResponse ()
	;Flip
End Function

Function LoadGifImage(fname$)

	thegif=OpenMovie(fname$)
	animPic=CreateImage(MovieWidth(thegif),MovieHeight(thegif))

	DrawMovie thegif,0,0	
	GrabImage animPic,0,0
	Return animpic
	


End Function

;~IDEal Editor Parameters:
;~F#15A#16E#1C7#1E8#1FF#20A#215#29B#2B7#383#39F#3D6#411#439#44E#453#458#52B#535#5C7
;~F#615#620#627#63B#64B#654#65B#66B#683#6AA#6B0#6B8#774#78C#810
;~C#Blitz3D