

Function Gu_Setup()
	
	;**** (2) Project Tab
	Gu_Create_ProjectTab()
	
	
	
	;**** Form Side Panel
	;**** (4-5) Form Edit
	Gu_Create_FormEdit()
	Gg_Set_Group(ggControlProperties,20,240,260,GrapH-300,1)
	;**** (6) Form Add Control
	Gu_Create_AddControl()
	;**** (7) Form Heirachy
	Gu_Create_FormHeirTab()	
	
	;**** (10-11) Graphics Edit
	Gu_Create_GraphicEdit()
	;**** (12) Tiles Edit
	Gu_Create_TileEdit()
	
	
	;**** (26) Info Panel
	Gu_Create_InfoPanel
	;**** (27) Add Info panel console part
	Gu_Create_InfoPanelConsole
	
	;**** (30) Data Panel
	Gu_Create_DataPanel()
	;**** (31-32) Add Data Panel Code part
	Gu_Create_CodeEditor()
	;**** (34) Add Data Panel Form part
	Gu_Create_FormEditor()
	;**** (36) Add Data Panel Sheet part
	Gu_Create_SheetEditor()
	
	;**** (39) Sheet Import
	Gu_Create_SheetImport()
	
	;**** (41-44) Video Import
	Gu_Create_VideoImport()
	
	
	
	;**** (45) Setting Menu
	Gu_Create_SettingsForm()
	;**** (46) Setting Menu
	Gu_Create_MenuEditor()	
	;**** (47) Open File Menu
	Gu_Create_OpenFile()	
	;**** (47) Save As File Menu
	Gu_Create_SaveAsFile()	
	
	;**** (49) File Selector ****
	Gu_Create_FileSelector()
	
	
	
	
	;**** (50) Main Bar selection
	Gu_Create_TopBar()
	;**** (51) File menu
	Gu_Create_FileMenu()	
	;**** (52) File menu
	Gu_Create_EditMenu()
	;**** (53) File menu
	Gu_Create_ProjectMenu()
	;**** (54) File menu
	Gu_Create_CompileMenu()
	;**** (55) File menu
	Gu_Create_OptionsMenu()	
	
	
End Function

Function Gu_Create_TopBar()
	Gg_Set_Group(ggTopBar,10,1,GrapW-30,56,1)
	Gu_New_MenuBarSolid(gTopMenuSolid,ggTopBar,2,4,GrapW,"")
	Gu_New_MenuBarText(gTopMenuFile,ggTopBar,2,4,38,51,"FILE")
	Gu_New_MenuBarText(gTopMenuEdit,ggTopBar,58,4,40,52,"EDIT")
	Gu_New_MenuBarText(gTopMenuProject,ggTopBar,118,4,68,53,"PROJECT")
	Gu_New_MenuBarText(gTopMenuCompile,ggTopBar,192,4,68,54,"COMPILE")	
	Gu_New_MenuBarText(gTopMenuOptions,ggTopBar,272,4,68,55,"OPTIONS")		
	
	Gu_New_ImgButton(gTopBarNew,ggTopBar,2,26,42,32,175,668,175,707,175,746,"New Project")
	Gu_New_ImgButton(gTopBarSave,ggTopBar,45,26,42,32,218,668,218,707,218,746,"Save Project (Ctrl S)")
	Gu_New_ImgButton(gTopBarSaveAs,ggTopBar,88,26,42,32,261,668,261,707,261,746,"Save Project As (Ctrl E)")
	Gu_New_ImgButton(gTopBarOpen,ggTopBar,131,26,42,32,562,668,562,707,562,746,"Open Project As (Ctrl O)")	
	Gu_New_ImgButton(gTopBarClose,ggTopBar,224,26,42,32,304,668,304,707,304,746,"Close Project")	
	Gu_New_ImgButton(gTopBarSettings,ggTopBar,260,26,42,32,347,668,347,707,347,746,"Settings")
	Gu_New_ImgButton(gTopBarCompile,ggTopBar,310,26,42,32,390,668,390,707,390,746,"Compile (F5)")
	Gu_New_ImgButton(gTopBarDebugCompile,ggTopBar,346,26,42,32,433,668,433,707,433,746,"Debug Compile (F9)")
	
	Gu_New_Text(gTopBarOutputText,ggTopBar,400,32,50,"Output:")
	Gu_New_TextSlider(gTopBarOutput,ggTopBar,450,32,100,1,1,3,"Directory|CPC DSK|MSX DSK|-4|-5|-6|-7|-8|","Selected Form")
	
	
	Gu_New_ImgButton(gTopBarDonate,ggTopBar,618,26,85,32,476,668,476,707,476,746,"Help Make Unify Better")	
	Gu_New_ImgButton(gTopBarForum,ggTopBar,574,26,42,32,605,668,605,707,605,746,"Visit the Symbos Forum")	
End Function
Function Gu_Create_FileMenu()
	Gg_Set_Group(ggFileMenu,10,24,150,130,0)
	Gu_New_MenuList(gFileMenu,ggFileMenu,0,0,Gg_W(ggFileMenu),Gg_H(ggFileMenu),"New Project|Open Project|Save Project|Save Project as|-|About|Exit Quigs")
End Function	
Function Gu_Create_EditMenu()
	Gg_Set_Group(ggEditmenu,66,24,150,92,0)
	Gu_New_MenuList(gEditMenu,ggEditmenu,0,0,Gg_W(ggEditmenu),Gg_H(ggEditmenu),"Cut|Copy|Paste|-|Select All Text")
End Function
Function Gu_Create_ProjectMenu()
	Gg_Set_Group(ggProjectMenu,126,24,160,206,0)
	Gu_New_MenuList(gProjectMenu,ggProjectMenu,0,0,Gg_W(ggProjectMenu),Gg_H(ggProjectMenu),"Settings|-|Add Form|Delete Form|-|Add Sheet|Clear Sheet|Create Video|-|Add Main()|Add Net.Event()|Add Timer.Event()|")
End Function
Function Gu_Create_CompileMenu()
	Gg_Set_Group(ggCompileMenu,200,24,160,96,0)
	Gu_New_MenuList(gCompileMenu,ggCompileMenu,0,0,Gg_W(ggCompileMenu),Gg_H(ggCompileMenu),"Compile|Debug Compile|Error Check|-|Compile Settings")
End Function
Function Gu_Create_OptionsMenu()
	Gg_Set_Group(ggOptionsMenu,280,24,160,142,0)
	Gu_New_MenuList(gOptionsMenu,ggOptionsMenu,0,0,Gg_W(ggOptionsMenu),Gg_H(ggOptionsMenu),"Editor Settings|-|Show 16 Colour|Show Func/Vars|-|Help|Forum|Donate")
End Function
Function Gu_Create_SettingsForm()
	Gg_Set_Group(ggSettingsForm,GrapW/2-260,GrapH/2-250,520,510,1)
	Gu_New_Form(gSettingsForm,ggSettingsForm,0,0,Gg_W(ggSettingsForm),Gg_H(ggSettingsForm),"Project Settings")
	
	Gu_New_TextButton(gSettingsDone,ggSettingsForm,Gg_W(ggSettingsForm)-56,Gg_H(ggSettingsForm)-30,50,24,"Done")		
End Function
Function Gu_Create_MenuEditor()
	Gg_Set_Group(ggMenuEditor,GrapW/2-230,GrapH/2-250,460,510,1)
	Gu_New_Form(gMenuEditor,ggMenuEditor,0,0,Gg_W(ggSettingsForm),Gg_H(ggSettingsForm),"Form Menu Editor")
	
	Gu_New_List(gMenuEditor,ggMenuEditor,28,20,202,152,ListScreen,gc5,ObSData(FrNo,Hit,QStT)):Gu_Val(gc3)=1:Gu_Var(gc3)=QStT	
	
	
	Gu_New_TextButton(gMenuEditorDone,ggMenuEditor,Gg_W(ggMenuEditor)-56,Gg_H(ggMenuEditor)-30,50,24,"Done")		
End Function
Function Gu_Create_OpenFile()
	Gg_Set_Group(ggOpenFile,GrapW/2-155,GrapH/2-300,290,500,1)
	Gu_New_Form(gOpenFile,ggOpenFile,0,0,Gg_W(ggOpenFile),Gg_H(ggOpenFile),"Open Quigs Project")
	Gu_New_Text(gOpenFiletxt,ggOpenFile,20,26,100,"Select Project:")
	
	Gu_New_TextInput(gOpenFileFile,ggOpenFile,50,442,220,"File")
	Gu_New_TextButton(gOpenFileOk,ggOpenFile,Gu_W(gOpenFile)-70,466,50,20,"OK")
	Gu_New_TextButton(gOpenFileCancel,ggOpenFile,Gu_W(gOpenFile)-130,466,50,20,"Cancel")		
End Function
Function Gu_Create_SaveAsFile()
	Gg_Set_Group(ggSaveAsFile,GrapW/2-155,GrapH/2-300,290,500,1)
	Gu_New_Form(gSaveAsFile,ggSaveAsFile,0,0,Gg_W(ggSaveAsFile),Gg_H(ggSaveAsFile),"Save Quigs Project")
	Gu_New_Text(gSaveAsFiletxt,ggSaveAsFile,20,26,100,"Select Project:")
	
	Gu_New_TextInput(gSaveAsFileFile,ggSaveAsFile,50,442,220,"File")
	Gu_New_TextButton(gSaveAsFileSave,ggSaveAsFile,Gu_W(gSaveAsFile)-70,466,50,20,"Save")
	Gu_New_TextButton(gsaveAsFileCancel,ggSaveAsFile,Gu_W(gSaveAsFile)-130,466,50,20,"Cancel")		
End Function
Function Gu_Create_SheetImport()
	Gg_Set_Group(ggSheetImport,GrapW/2-410,GrapH/2-300,820,560,1)
	Gu_New_Form(gSheetImport,ggSheetImport,0,0,Gg_W(ggSheetImport),Gg_H(ggSheetImport),"Sheet Import / Create")
	
	Gu_New_SheetImport(gSheetImportV,ggSheetImport,10,28,516,404,"")
	Gu_New_Text(gSheetSourceTxt,ggSheetImport,542,26,100,"Select Import Image:")
	Gu_New_Text(gSheetText1,ggSheetImport,230,444,60,"Wid:---")
	Gu_New_Text(gSheetText2,ggSheetImport,320,444,60,"Hei:---")
	Gu_New_Text(gSheetText3,ggSheetImport,410,444,60,"Sze:---")
	
	Gu_New_SpecialSlider(gSheetSliderBright,ggSheetImport,230,498,206,26,651,867,651,895,"Set the Input Brightness")
	Gu_New_SpecialSlider(gSheetSliderContrast,ggSheetImport,230,528,206,26,651,923,651,951,"Set the Input Contrast")
	Gu_New_SpecialSlider(gSheetSliderR,ggSheetImport,12,468,206,26,651,980,651,1008,"Increase/Decrease Red Input")
	Gu_New_SpecialSlider(gSheetSliderG,ggSheetImport,12,498,206,26,651,1037,651,1065,"Increase/Decrease Green Input")	
	Gu_New_SpecialSlider(gSheetSliderB,ggSheetImport,12,528,206,26,651,1093,651,1121,"Increase/Decrease Blue Input")
	Gu_New_IntInput(gSheetWidth,ggSheetImport,106,444,0,0,256,"Width:","Width in Bytes")
	Gu_New_IntInput(gSheetHeight,ggSheetImport,216,444,0,0,256,"Height:","Height in Pixels")
	
	Gu_Val(gSheetSliderBright)=128
	Gu_Val(gSheetSliderContrast)=128
	Gu_Val(gSheetSliderR)=128
	Gu_Val(gSheetSliderG)=128
	Gu_Val(gSheetSliderB)=128	
	
	Gg_Set_Group(ggSheetColours,Gg_X(ggSheetImport),Gg_Y(ggSheetImport),Gg_W(ggSheetImport),Gg_H(ggSheetImport),1)
	Gu_New_ImgButton(Gc_Pat1_23,ggSheetColours,229,468,25,26,495,867,495,894,495,921,"4 Colour True")
	Gu_New_ImgButton(Gc_Pat2_23,ggSheetColours,255,468,25,26,521,867,521,894,521,921,"16 Colour True")
	Gu_New_ImgButton(Gc_Pat3_23,ggSheetColours,281,468,25,26,547,867,547,894,547,921,"4 Colour Toonish")
	Gu_New_ImgButton(Gc_Pat4_23,ggSheetColours,307,468,25,26,573,867,573,894,573,921,"16 Colour Toonish")
	Gu_New_ImgButton(Gc_Pat5_23,ggSheetColours,333,468,25,26,599,867,599,894,599,921,"4 Colour Exact")
	Gu_New_ImgButton(Gc_Pat6_23,ggSheetColours,359,468,25,26,625,867,625,894,625,921,"16 Colour Exact")
	
	Gu_New_TextButton(gSheetDone,ggSheetImport,Gg_W(ggSheetImport)-136,Gg_H(ggSheetImport)-36,120,24,"Create Sheet")
	Gu_New_TextButton(gSheetCancel,ggSheetImport,Gg_W(ggSheetImport)-268,Gg_H(ggSheetImport)-36,120,24,"Cancel")	
	
	n$="Auto|MSX 512x212|MSX 256x212|CPC 320x200|256x256|"
	Gu_New_TextSlider(gSheetImportSize,ggSheetImport,670,446,126,1,1,5,n$,"Size at which to generate image in pixels")
	Gu_New_Text(gSheetImportSizeLabel,ggSheetImport,560,446,80,"Import Pixel Size:")
	
	
	Gu_Sel(Gc_Pat1_23)=1
	
End Function
Function Gu_Create_VideoImport()
	Gg_Set_Group(ggVideoImport,GrapW/2-410,GrapH/2-300,820,560,1)
	Gu_New_Form(gVideoImport,ggVideoImport,0,0,Gg_W(ggVideoImport),Gg_H(ggVideoImport),"Video Import / Create")
	Gu_New_VideoImport(gVideoImportV,ggVideoImport,10,28,516,404,"")
	Gu_New_Text(gVideoSourcetxt,ggVideoImport,542,26,100,"Select Import Video:")
	Gu_New_Text(gVideoText1,ggVideoImport,170,454,300,"Captured frames")
	Gu_New_TextButton(gVideoDone,ggVideoImport,700,516,100,30,"Done")
	Gu_New_TextButton(gVideoReset,ggVideoImport,700,480,100,30,"Reset")	
	Gu_New_IntInput(gVideoFPS,ggVideoImport,682,524,8,1,12,"Capture FPS:","Video in Frame per second")	
	
	Gg_Set_Group(ggVideoRecord,GrapW/2-410,GrapH/2-300,820,560,1)
	Gu_New_TextButton(gVideoButton1,ggVideoRecord,700,444,100,30,"Start")
	
	Gg_Set_Group(ggVideoOutput,GrapW/2-410,GrapH/2-300,820,560,1)
	Gu_New_SpecialSlider(gVideoSliderBright,ggVideoOutput,252,520,206,26,651,867,651,895,"Set the Input Brightness")
	Gu_New_SpecialSlider(gVideoSliderContrast,ggVideoOutput,10,520,206,26,651,923,651,951,"Set the Input Contrast")
	Gu_Val(gVideoSliderBright)=128
	Gu_Val(gVideoSliderContrast)=128	
	Gu_New_IntInput(gVideoWidth,ggVideoOutput,106,480,212,32,256,"Width:","Width in Pixels")
	Gu_New_IntInput(gVideoHeight,ggVideoOutput,106,500,144,32,212,"Height:","Height in Pixels")
	Gu_New_Hscroller(gVideoHScroller,ggVideoOutput,12,430,512,1,1,100,1,0)
	Gu_New_TextButton(gVideoOutput,ggVideoOutput,700,444,100,30,"Output Video")
	
	Gu_New_TextButton(gVideoCalc,ggVideoOutput,450,480,50,24,"Calc")		
	
	Gg_Set_Group(ggVideoColours,GrapW/2-410,GrapH/2-300,820,560,1)
	Gu_New_ImgButton(gVideoPat1,ggVideoColours,229,478,25,26,495,867,495,894,495,921,"4 Colour True")
	Gu_New_ImgButton(gVideoPat2,ggVideoColours,255,478,25,26,521,867,521,894,521,921,"16 Colour True")
	Gu_New_ImgButton(gVideoPat3,ggVideoColours,281,478,25,26,547,867,547,894,547,921,"4 Colour Toonish")
	Gu_New_ImgButton(gVideoPat4,ggVideoColours,307,478,25,26,573,867,573,894,573,921,"16 Colour Toonish")
	Gu_New_ImgButton(gVideoPat5,ggVideoColours,333,478,25,26,599,867,599,894,599,921,"4 Colour Exact")
	Gu_New_ImgButton(gVideoPat6,ggVideoColours,359,478,25,26,625,867,625,894,625,921,"16 Colour Exact")	
	Gu_Sel(gVideoPat1)=1
	
End Function
Function Gu_Create_FileSelector()
	Gg_Set_Group(ggFileSel,30,500,250,422,1)
	Gu_New_FileSelector(gFileSelList,ggFileSel,0,0,Gg_W(ggFileSel)-16,Gg_H(ggFileSel)-30,"")
	Gu_New_Vscroller(gFileVScroll,ggFileSel,Gu_W(gFileSelList)+8,3,Gu_H(gFileSelList)-6,0,0,0,20,gFileSelList)	
End Function
Function Gu_Create_ProjectTab()
	Gg_Set_Group(ggProject,6,64,310,GrapH-72,1)
	Gu_New_Tab(gProjectTab,ggProject,1,1,244,124,"Controls",1)
	Gu_Add_Tab(gProjectTab,"Graphics",3)
	Gu_Add_Tab(gProjectTab,"Mapper",4)
	
End Function
Function Gu_Create_FormHeirTab()
	Gg_Set_Group(ggFormHeir,12,228,300,GrapH-252,1)
	Gu_New_Tab(gFormHeirTab,ggFormHeir,1,1,244,124,"Properties",1)
	Gu_Add_Tab(gFormHeirTab,"Heirachy",3)
End Function
Function Gu_Create_FormEdit()
	Gg_Set_Group(ggFormEdit,10,88,300,50,1)
	Gu_New_Frame(gFormEditFrame,ggFormEdit,1,1,300,48,"Control Form")
	
	Gu_New_TextSlider(gFormEditTextSlider,ggFormEdit,60,22,144,1,1,1,"Form1|-2|-3|-4|-5|-6|-7|-8|","Selected Form")
	Gu_New_Text(gFormEditLabel,ggFormEdit,16,22,80,"Form:")
	
	
	Gu_New_TextButton(gFormEditFormAdd,ggFormEdit,210,19,40,20,"Add")
	Gu_New_TextButton(gFormEditFormDelete,ggFormEdit,254,19,40,20,"Delete")	
End Function
Function Gu_Create_GraphicEdit()
	Gg_Set_Group(ggGraphicEdit,10,88,300,GrapH-108,1)
	Gu_New_Frame(gGraphicEditFrame,ggGraphicEdit,1,1,300,Gg_H(ggGraphicEdit)-4,"Edit Graphics")
	Gu_New_TextButton(gGraphicVideoCreate,ggGraphicEdit,20,24,130,20,"Create Video")
	Gu_New_TextButton(gGraphicBackdropCreate,ggGraphicEdit,154,24,130,20,"Create Backdrop")
	
	Gu_New_TextDivider(gGraphicDivide,ggGraphicEdit,12,55,240,"Sheet Info")	
	
	n$="Sheet 1|Sheet 2|Sheet 3|Sheet 4|Sheet 5|Sheet 6|Sheet 7|Sheet 8|Sheet 9|Sheet 10|"
	n$=n$+"Sheet 11|Sheet 12|Sheet 13|Sheet 14|Sheet 15|Sheet 16|Sheet 17|Sheet 18|Sheet 19|Sheet 20|"
	n$=n$+"Sheet 21|Sheet 22|Sheet 23|Sheet 24|Sheet 25|Sheet 26|Sheet 27|Sheet 28|Sheet 29|Sheet 30|"
	n$=n$+"Sheet 31|Sheet 32|Sheet 33|Sheet 34|Sheet 35|Sheet 36|Sheet 37|Sheet 38|Sheet 39|Sheet 40|"	
	Gu_New_TextSlider(gGraphicsEditTextSlider,ggGraphicEdit,60,76,110,1,1,40,n$,"Selected Sheet")
	Gu_New_Text(gGraphicLabel,ggGraphicEdit,16,76,80,"Sheet:")
	
	Gu_New_TextButton(gGraphicSheetImport,ggGraphicEdit,182,74,52,20,"Import")
	Gu_New_TextButton(gGraphicSheetClear,ggGraphicEdit,240,74,52,20,"Clear")
	
	Gu_New_Text(gGraphicColourText,ggGraphicEdit,50,102,100,"Colour Depth: ---")	
	Gu_New_Text(gGraphicSizeText,ggGraphicEdit,170,102,100,"Size in Bytes: ---")
	Gu_New_Text(gGraphicWidthText,ggGraphicEdit,60,120,100,"Pixel Width: ---")	
	Gu_New_Text(gGraphicHeightText,ggGraphicEdit,176,120,100,"Pixel Height: ---")
	
	Gu_New_TextInput(gGraphicExportFile,ggGraphicEdit,184,144,106,"Export File (Max 8 chars)")
	Gu_New_Check(gGraphicExportCheck,ggGraphicEdit,290,164,1,"Export Primary with Project")
	Gu_New_Check(gGraphicExportCheck2,ggGraphicEdit,290,182,1,"Export Secondary with Project")	
	
	Gg_Set_Group(ggGraphicTab,20,296,280,GrapH-308,1)	
	Gu_New_Tab(gGraphicTab,ggGraphicTab,1,1,280,Gg_H(ggGraphicTab)-24,"Artist",1)
	Gu_Add_Tab(gGraphicTab,"Tiles",3)
End Function
Function Gu_Create_TileEdit()
	Gg_Set_Group(ggTileEdit,Gg_X(ggGraphicTab),Gg_Y(ggGraphicTab)+20,300,GrapH-108,1)
	
	n$="Single|Grid|Manual|"	
	Gu_New_TextSlider(gTileLayout,ggTileEdit,70,10,90,2,1,3,n$,"Tile Layout Method")	
	Gu_New_Text(gTileLayoutText,ggTileEdit,20,10,80,"Layout:")
	Gu_New_Check(gTileLocked,ggTileEdit,260,10,0,"Locked")
	
	Gu_New_Text(gTileText,ggTileEdit,20,32,100,"Tile Count: -")
	Gu_New_Text(gTileMemText,ggTileEdit,154,32,100,"Byte Size: -")		
	
	Gu_New_TextDivider(gTileDivider,ggTileEdit,12,56,250,"Tile Grid")
	
	Gu_New_IntInput(gTileXOff,ggTileEdit,90,76,0,0,64,"OX","Tile Grid X Offset")
	Gu_New_IntInput(gTileYOff,ggTileEdit,90,94,0,0,64,"OY","Tile Grid Y Offset")
	Gu_New_IntInput(gTileWidth,ggTileEdit,176,76,0,0,64,"W","Tile Width")
	Gu_New_IntInput(gTileHeight,ggTileEdit,176,94,0,0,64,"H","Tile Height")	
	Gu_New_IntInput(gTileXGap,ggTileEdit,264,76,0,0,64,"GX","Tile Grid X Gap")
	Gu_New_IntInput(gTileYGap,ggTileEdit,264,94,0,0,64,"GY","Tile Grid Y Gap")		
	
	
End Function

Function Gu_Create_AddControl()
	Gg_Set_Group(ggControlAdd,10,146,300,68,1)
	a=10:b=22:c=16
	Gu_New_Frame(gAddCFrame,ggControlAdd,1,1,300,66,"Add Control")
	Gu_New_ImgButton(gAddControlSelect,ggControlAdd,a,c,20,20,0,0,0,21,0,42):a=a+b
	Gu_New_ImgButton(gAddControlLabel,ggControlAdd,a,c,20,20,21,0,21,21,21,42,"Deselect"):a=a+b
	Gu_New_ImgButton(gAddControlTextLine,ggControlAdd,a,c,20,20,42,0,42,21,42,42,"Add TextLine Control"):a=a+b
	Gu_New_ImgButton(gAddControlFrame,ggControlAdd,a,c,20,20,63,0,63,21,63,42,"Add Frame Control"):a=a+b
	Gu_New_ImgButton(gAddControlButton,ggControlAdd,a,c,20,20,84,0,84,21,84,42,"Add Button Control"):a=a+b
	Gu_New_ImgButton(gAddControlRadio,ggControlAdd,a,c,20,20,105,0,105,21,105,42,"Add Radio Control"):a=a+b
	Gu_New_ImgButton(gAddControlCheck,ggControlAdd,a,c,20,20,126,0,126,21,126,42,"Add Check Control"):a=a+b
	Gu_New_ImgButton(gAddControlTab,ggControlAdd,a,c,20,20,147,0,147,21,147,42,"Add Tab Control"):a=a+b
	Gu_New_ImgButton(gAddControlVScroll,ggControlAdd,a,c,20,20,168,0,168,21,168,42,"Add VScroll Control"):a=a+b
	Gu_New_ImgButton(gAddControlHScroll,ggControlAdd,a,c,20,20,189,0,189,21,189,42,"Add HScroll Control"):a=a+b
	Gu_New_ImgButton(gAddControlVSpinner,ggControlAdd,a,c,20,20,210,0,210,21,210,42,"Add VSpinner Control"):a=a+b
	Gu_New_ImgButton(gAddControlHSpinner,ggControlAdd,a,c,20,20,231,0,231,21,231,42,"Add HSpinner Control"):a=a+b
	Gu_New_ImgButton(gAddControlPaint,ggControlAdd,a,c,20,20,252,0,252,21,252,42,"Add Paint Control"):a=a+b
	a=10:c=c+22
	Gu_New_ImgButton(gAddControlBox,ggControlAdd,a,c,20,20,273,0,273,21,273,42,"Add Box Control"):a=a+b
	Gu_New_ImgButton(gAddControlImgBox,ggControlAdd,a,c,20,20,294,0,294,21,294,42,"Add ImgBox Control"):a=a+b
	Gu_New_ImgButton(gAddControlProgress,ggControlAdd,a,c,20,20,315,0,315,21,315,42,"Add Progress Control"):a=a+b
	Gu_New_ImgButton(gAddControlCtrLabel,ggControlAdd,a,c,20,20,357,0,357,21,357,42,"Add CtrLabel Control"):a=a+b
	;Gu_New_ImgButton(gAddControlIcon,ggControlAdd,a,c,20,20,378,0,378,21,378,42,"Add Icon Control"):a=a+b
	;Gu_New_ImgButton(gAddControlSuper,ggControlAdd,a,c,20,20,399,0,399,21,399,42,"Add Super Control"):a=a+b
	Gu_New_ImgButton(gAddControlTextBox,ggControlAdd,a,c,20,20,420,0,420,21,420,42,"Add TextBox Control"):a=a+b
	Gu_New_ImgButton(gAddControlList,ggControlAdd,a,c,20,20,441,0,441,21,441,42,"Add List Control"):a=a+b
	Gu_New_ImgButton(gAddControlDrop,ggControlAdd,a,c,20,20,462,0,462,21,462,42,"Add Drop Control")	:a=a+b
	Gu_New_ImgButton(gAddControlSprite,ggControlAdd,a,c,20,20,483,0,483,21,483,42,"Add Sprite Control")	:a=a+b
	Gu_New_ImgButton(gAddControlPlayArea,ggControlAdd,a,c,20,20,504,0,504,21,504,42,"Add PlayArea Control")	:a=a+b	
	
End Function
Function Gu_Create_DataPanel()
	Gg_Set_Group(ggData,324,64,GrapW-330,GrapH-210,1)
	Gu_New_Tab(gDataTab,ggData,1,1,244,124,"Code",1)
	Gu_Add_Tab(gDataTab,"Form",3)
	Gu_Add_Tab(gDataTab,"Sheet",4):Gu_TabIndex(gDataTab)=1	
End Function
Function Gu_Create_CodeEditor()
	Gg_Set_Group(ggCodeEditor,Gg_X(ggData)+4,Gg_Y(ggData)+18,Gg_W(ggData)-8,Gg_H(ggData)-22,1)
	a=Int((Gg_H(ggCodeEditor)-20)/14)*14
	Gu_New_CodeEditor(gCodeEditor,ggCodeEditor,1,1,Gg_W(ggCodeEditor)-212,a,"")
	Gu_New_Vscroller(gCodeVScroll,ggCodeEditor,Gu_W(gCodeEditor)+4,8,Gu_H(gCodeEditor)-10,0,0,0,0,0)
	Gu_New_Text(gCodeLn,ggCodeEditor,10,Gu_H(gCodeEditor)+4,40,"Ln:1")
	Gu_New_Text(gCodeCol,ggCodeEditor,80,Gu_H(gCodeEditor)+4,40,"Cl:1")
	Gu_New_Text(gCodeCaps,ggCodeEditor,10,Gu_H(gCodeEditor)+20,40,"Caps:")
	Gu_New_Text(gCodeLines,ggCodeEditor,80,Gu_H(gCodeEditor)+20,40,"Rw:1")
	
	Gu_New_Text(gCodeCommand,ggCodeEditor,140,Gu_H(gCodeEditor)+4,400,"Cmd:")
	Gu_New_Text(gCodeCommandDesc,ggCodeEditor,174,Gu_H(gCodeEditor)+20,400,"")	
	
	Gu_New_TextInput(gCodeFind,ggCodeEditor,620,Gu_H(gCodeEditor)+4,Gg_W(ggCodeEditor)-730,"Text")
	Gu_New_TextButton(gCodeFindButton,ggCodeEditor,Gg_W(ggCodeEditor)-108,Gu_H(gCodeEditor)+3,46,17,"Find")
	Gu_New_TextButton(gCodeFindNextButton,ggCodeEditor,Gg_W(ggCodeEditor)-56,Gu_H(gCodeEditor)+3,46,17,"Next")	
	
	;**** Code Function Table
	Gg_Set_Group(ggFuncEditor,Gg_X(ggData)+4,Gg_Y(ggData)+18,Gg_W(ggData)-8,Gg_H(ggData)-22,1)
	Gu_New_FuncList(gFuncList,ggFuncEditor,Gg_W(ggCodeEditor)-184,24,160,Gg_H(ggData)-72,Funcscreen,"")
	Gu_New_Vscroller(gFuncScroll,ggFuncEditor,Gu_X(gFuncList)+Gu_W(gFuncList)+10,27,Gu_H(gFuncList)-6,0,0,0,1,1)
	Gu_New_Text(gFuncText,ggFuncEditor,Gg_W(ggCodeEditor)-176,8,40,"Function List:")
	
	
;	;**** Code Area
;	gg=12:Gg_Set_Group(gg,290,106,100,100,1)
;	Gu_New_Vscroller(gCodeVScroll,gg,GrapW-300,0,GrapH-370,0,0,0,0,0)
;	Gu_New_Vscroller(Gc_VIntelli_12,gg,0,0,0,0,0,0,0,0)
	
	
End Function 
Function Gu_Create_FormEditor()
	Gg_Set_Group(ggFormEditor,Gg_X(ggData)+4,Gg_Y(ggData)+18,Gg_W(ggData)-8,Gg_H(ggData)-22,1)
	a=((Gg_H(ggFormEditor)-20)/FontHeight())*FontHeight()
	Gu_New_FormEditor(gFormEditor,ggFormEditor,1,6,Gg_W(ggFormEditor)-8,a-4,"")
	Gu_New_Text(gFormX,ggFormEditor,10,Gu_H(gCodeEditor)+4,40,"X:")
	Gu_New_Text(gFormY,ggFormEditor,60,Gu_H(gCodeEditor)+4,40,"Y:")
	Gu_New_Text(gFormNo,ggFormEditor,110,Gu_H(gCodeEditor)+4,40,"Form:")	
	Gu_New_Text(gFormControlNo,ggFormEditor,210,Gu_H(gCodeEditor)+4,40,"Control:")
	Gu_New_Text(gFormDispNo,ggFormEditor,310,Gu_H(gCodeEditor)+4,40,"Display:")	
End Function
Function Gu_Create_SheetEditor()
	Gg_Set_Group(ggSheetEditor,Gg_X(ggData)+4,Gg_Y(ggData)+18,Gg_W(ggData)-8,Gg_H(ggData)-22,1)
	
	Gu_New_Sheet(gSheetEditor,ggSheetEditor,3,8,Gg_W(ggSheetEditor)-10,Gg_H(ggSheetEditor)-40,"")
	
	a=(Gg_H(ggSheetEditor)-72)/120
	Gu_New_Vscroller(gSheetSelectScroll,ggSheetEditor,Gg_W(ggSheetEditor)-18,24,Gg_H(ggSheetEditor)-80,0,0,39,a,1)
	
	Gu_New_Vscroller(gSheetEditVScroll,ggSheetEditor,Gg_W(ggSheetEditor)-204,24,Gg_H(ggSheetEditor)-96,0,0,1,1,1)
	Gu_New_Hscroller(gSheetEditHScroll,ggSheetEditor,24,Gg_H(ggSheetEditor)-72,Gg_W(ggSheetEditor)-240,0,0,1,1,1)
	
	Gu_New_IntInput(gSheetViewScale,ggSheetEditor,220,Gg_H(ggSheetEditor)-20,1,1,8,"View Size")
	Gu_New_Text(gSheetXPos,ggSheetEditor,10,Gg_H(ggSheetEditor)-20,40,"X:-")
	Gu_New_Text(gSheetYPos,ggSheetEditor,60,Gg_H(ggSheetEditor)-20,40,"Y:-")
	Gu_New_TextSlider(gSheetType,ggSheetEditor,290,Gg_H(ggSheetEditor)-20,110,1,1,2,"Primary|Secondary|","Image type")	
	Gu_New_Text(gSheetTypeText,ggSheetEditor,244,Gg_H(ggSheetEditor)-20,40,"Image:")
	
	Gu_New_Check(gSheetViewTiles,ggSheetEditor,510,Gg_H(ggSheetEditor)-20,1,"View Tiles","Show the Tiles Mesh")	
	
;	Gu_New_Text(gFormX,ggFormEditor,10,Gu_H(gCodeEditor)+4,40,"X:")
;	Gu_New_Text(gFormY,ggFormEditor,60,Gu_H(gCodeEditor)+4,40,"Y:")
;	Gu_New_Text(gFormNo,ggFormEditor,110,Gu_H(gCodeEditor)+4,40,"Form:")	
;	Gu_New_Text(gFormControlNo,ggFormEditor,210,Gu_H(gCodeEditor)+4,40,"Control:")
;	Gu_New_Text(gFormDispNo,ggFormEditor,310,Gu_H(gCodeEditor)+4,40,"Display:")	
End Function
Function Gu_Create_InfoPanel()
	Gg_Set_Group(ggInfo,324,GrapH-136,GrapW-330,130,1)
	Gu_New_Tab(gInfoTab,ggInfo,1,1,244,124,"Console",1)
	Gu_Add_Tab(gInfoTab,"Assets",2)
	Gu_Add_Tab(gInfoTab,"Information",1):Gu_TabIndex(gInfoTab)=1
End Function
Function Gu_Create_InfoPanelConsole()
	Gg_Set_Group(ggConsole,Gg_X(ggInfo)+4,Gg_Y(ggInfo)+18,Gg_W(ggInfo)-8,Gg_H(ggInfo)-22,1)
	Gu_New_ConsoleList(gConsoleList,ggConsole,1,1,Gg_W(ggConsole)-150,Gg_H(ggConsole)-1,"")
End Function 

;**** GUI Functions
Function Gg_Set_Group(f,X,Y,W,H,Vis)
	Gg_Vis(f)=Vis
	Gg_X(f)=X:Gg_Y(f)=Y:Gg_W(f)=W:Gg_H(f)=H
End Function
Function Gu_New_Viewsize4(f,Grp,X,Y,vl,cap$,tip$="")
	Gu_Typ(f)=Gu_Typ_Viewsize4
	Gu_Grp(f)=Grp
	Gu_Chk(f)=0
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=51:Gu_H(f)=16
	Gu_Cap(f)=cap$
	Gu_Tip(f)=tip$
	Gu_Var(f)=-1
	Gu_Val(f)=vl
End Function
Function Gu_New_SpecialSlider(f,Grp,X,Y,W,H,x1,y1,x2,y2,Tip$="")
	Gu_Typ(f)=Gu_Typ_SpecialSlider
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_X1(f)=x1:Gu_Y1(f)=y1
	Gu_X2(f)=x2:Gu_Y2(f)=y2
	Gu_Tip(f)=Tip$
	Gu_Var(f)=-1
End Function
Function Gu_New_CreateCode(f,Grp,X,Y,Vl,tip$="")
	Gu_Typ(f)=Gu_Typ_CreateCode
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_H(f)=16:Gu_W(f)=26
	Gu_Val(f)=Vl
	Gu_Var(f)=-1
	Gu_Tip(f)=tip$
End Function
Function Gu_New_Vscroller(f,Grp,X,Y,H,Vl,Mi,Mx,Shw,List)
	Gu_Typ(f)=Gu_Typ_Vscroller
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_H(f)=H
	Gu_Min(f)=Mi:Gu_Max(f)=Mx:Gu_Val(f)=Vl:Gu_Shw(f)=Shw
	Gu_ScrollList(f)=List
	Gu_Var(f)=-1
End Function
Function Gu_New_Hscroller(f,Grp,X,Y,W,Vl,Mi,Mx,Shw,List)
	Gu_Typ(f)=Gu_Typ_HScroller
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W
	Gu_Min(f)=Mi:Gu_Max(f)=Mx:Gu_Val(f)=Vl:Gu_Shw(f)=Shw
	Gu_ScrollList(f)=List
	Gu_Var(f)=-1
End Function
Function Gu_New_ImgButton(f,Grp,X,Y,W,H,x1,y1,x2,y2,x3,y3,Tip$="")
	Gu_Typ(f)=Gu_Typ_ImgButton
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_X1(f)=x1:Gu_Y1(f)=y1
	Gu_X2(f)=x2:Gu_Y2(f)=y2
	Gu_X3(f)=x2:Gu_Y3(f)=y3
	Gu_Tip(f)=Tip$
	Gu_Var(f)=-1
End Function
Function Gu_New_TextButton(f,Grp,X,Y,W,H,Cap$="",Tip$="")
	Gu_Typ(f)=Gu_Typ_TextButton
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap$(f)=Cap$
	Gu_Tip(f)=Tip$
	Gu_Var(f)=-1
End Function
Function Gu_New_FuncList(f,Grp,X,Y,W,H,ImgHand,ListTxt$)
	Gu_Typ(f)=Gu_Typ_FuncList
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=Int(H/14)*14
	Gu_ImgHandle(f)=CreateImage(200,Gu_H(f))
	Gu_Txt(f)=ListTxt$
	Gu_Min(f)=0
	
	If ListTxt>"" Then
		g=0
		While ListTxt$>"" 
			a=Instr(ListTxt$,"~|")
			If a>0 Then
				g=g+1
				lstext$(g)=Left$(ListTxt$,a-1)
				ListTxt$=Mid$(ListTxt,a+2)
			Else
				If ListTxt$>"" Then
					g=g+1
					lstext$(g)=ListTxt$
					ListTxt$=""
				EndIf		
			EndIf
		Wend
		Gu_Max(f)=G
	EndIf
	Gu_Var(f)=-1
End Function
Function Gu_New_List(f,Grp,X,Y,W,H,ImgHand,child,ListTxt$)
	Gu_Typ(f)=Gu_Typ_List
	Gu_Grp(f)=Grp
	Gu_Child(f)=child
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=Int(H/14)*14
	Gu_ImgHandle(f)=ImgHand
	Gu_Txt(f)=ListTxt$
	Gu_TxtOld(f)=ListTxt$	
	Gu_Min(f)=0
	
	If ListTxt>"" Then
		g=0
		While ListTxt$>"" 
			a=Instr(ListTxt$,"~|")
			If a>0 Then
				g=g+1
				lstext$(g)=Left$(ListTxt$,a-1)
				ListTxt$=Mid$(ListTxt,a+2)
			Else
				If ListTxt$>"" Then
					g=g+1
					lstext$(g)=ListTxt$
					ListTxt$=""
				EndIf		
			EndIf
		Wend
		Gu_Max(f)=G
	EndIf
	Gu_Var(f)=-1
End Function
Function Gu_New_Align(f,Grp,X,Y,vl,cap$,Tip$="")
	Gu_Typ(f)=Gu_Typ_Align
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=0:Gu_H(f)=0
	Gu_Cap(f)=cap$
	Gu_Tip(f)=Tip$
	Gu_Val(f)=vl
	Gu_Var(f)=-1
End Function
Function Gu_New_TextInput(f,Grp,x,y,w,cap$="",txt$="",Tip$="")
	Gu_Typ(f)=Gu_Typ_TextInput
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=x:Gu_Y(f)=y:Gu_W(f)=w:Gu_H(f)=16
	Gu_Cap(f)=cap$
	Gu_Txt(f)=txt$
	Gu_Tip(f)=Tip$
	Gu_Var(f)=-1
	Gu_Legal(f)=0
End Function
Function Gu_New_TextDivider(f,Grp,x,y,w,cap$="")
	Gu_Typ(f)=Gu_Typ_TextDivider
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=x:Gu_Y(f)=y:Gu_W(f)=w:Gu_H(f)=0
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_New_MenuBarSolid(f,Grp,x,y,w,cap$="")
	Gu_Typ(f)=Gu_Typ_MenuBarSolid
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=x:Gu_Y(f)=y:Gu_W(f)=w:Gu_H(f)=20
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_New_MenuBarText(f,Grp,x,y,w,vl,cap$="")
	Gu_Typ(f)=Gu_Typ_MenuBarText
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=x:Gu_Y(f)=y:Gu_W(f)=w:Gu_H(f)=20
	Gu_Val(f)=vl
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_New_MenuList(f,Grp,x,y,w,h,cap$="")
	Gu_Typ(f)=Gu_Typ_Menulist
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=x:Gu_Y(f)=y:Gu_W(f)=w:Gu_H(f)=h
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_New_Text(f,Grp,x,y,w,cap$="")
	Gu_Typ(f)=Gu_Typ_Text
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=x:Gu_Y(f)=y:Gu_W(f)=w:Gu_H(f)=0
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_New_Frame(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_Frame
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_New_Form(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_Form
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_New_Tab(f,Grp,X,Y,W,H,cap$,Im)
	Gu_Typ(f)=Gu_Typ_Tab
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_TabCount(f)=1
	Gu_TabIndex(f)=1
	Gu_Tab(f,Gu_TabIndex(f))=cap$
	Gu_TabImage(f,Gu_TabIndex(f))=Im
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
End Function
Function Gu_Add_Tab(f,cap$,im)
	Gu_TabCount(f)=Gu_TabCount(f)+1
	Gu_Tab(f,Gu_TabCount(f))=cap$
	Gu_TabImage(f,Gu_TabCount(f))=im
End Function
Function Gu_New_ConsoleList(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_ConsoleList
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
	Gu_ImgHandle(f)=CreateImage(1200,360)
End Function
Function Gu_New_CodeEditor(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_CodeEditor
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
	Gu_ImgHandle(f)=CreateImage(2400,1200)
	MaskImage Gu_ImgHandle(f),255,0,254
End Function
Function Gu_New_SheetImport(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_SheetImport
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
	Gu_ImgHandle(f)=CreateImage(1024,1024)
	MaskImage Gu_ImgHandle(f),255,0,254
End Function
Function Gu_New_Sheet(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_Sheet
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
	Gu_ImgHandle(f)=CreateImage(1024,1024)
	MaskImage Gu_ImgHandle(f),255,0,254
End Function
Function Gu_New_VideoImport(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_VideoImport
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
	Gu_ImgHandle(f)=CreateImage(512,400)
	MaskImage Gu_ImgHandle(f),255,0,254	
End Function
Function Gu_New_FormEditor(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_FormEditor
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
	Gu_ImgHandle(f)=CreateImage(1280,1280)
	MaskImage Gu_ImgHandle(f),255,0,254
End Function
Function Gu_New_FileSelector(f,Grp,X,Y,W,H,cap$)
	Gu_Typ(f)=Gu_Typ_FileSelector
	Gu_Grp(f)=Grp
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=W:Gu_H(f)=H
	Gu_Cap(f)=cap$
	Gu_Var(f)=-1
	Gu_ImgHandle(f)=CreateImage(300,800)
End Function
Function Gu_New_Check(f,Grp,X,Y,Chk,cap$,tip$="")
	Gu_Typ(f)=Gu_Typ_Check
	Gu_Grp(f)=Grp
	Gu_Chk(f)=Chk
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=0:Gu_H(f)=0
	Gu_Cap(f)=cap$
	Gu_Tip(f)=tip$
	Gu_Var(f)=-1
End Function
Function Gu_New_IntInput(f,Grp,X,Y,vl,mi,mx,cap$,tip$="")
	Gu_Typ(f)=Gu_Typ_IntInput
	Gu_Grp(f)=Grp
	Gu_Chk(f)=0
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=0:Gu_H(f)=0
	Gu_Cap(f)=cap$
	Gu_Tip(f)=tip$
	Gu_Var(f)=-1
	Gu_Val(f)=vl
	Gu_Min(f)=mi
	Gu_Max(f)=mx
End Function
Function Gu_New_TextSlider(f,Grp,X,Y,w,vl,mi,mx,cap$,tip$="")
	Gu_Typ(f)=Gu_Typ_TextSlider
	Gu_Grp(f)=Grp
	Gu_Chk(f)=0
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=w:Gu_H(f)=16
	Gu_Cap(f)=cap$
	Gu_Tip(f)=tip$
	Gu_Var(f)=-1
	Gu_Val(f)=vl
	Gu_Min(f)=mi
	Gu_Max(f)=mx
End Function
Function Gu_New_PenInput(f,Grp,X,Y,vl,cap$,tip$="")
	Gu_Typ(f)=Gu_Typ_PenInput
	Gu_Grp(f)=Grp
	Gu_Chk(f)=0
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=0:Gu_H(f)=0
	Gu_Cap(f)=cap$
	Gu_Tip(f)=tip$
	Gu_Var(f)=-1
	Gu_Val(f)=vl
End Function
Function Gu_New_PenInput4(f,Grp,X,Y,vl,cap$,tip$="")
	Gu_Typ(f)=Gu_Typ_PenInput4
	Gu_Grp(f)=Grp
	Gu_Chk(f)=0
	Gu_Sel(f)=0
	Gu_X(f)=X:Gu_Y(f)=Y:Gu_W(f)=0:Gu_H(f)=0
	Gu_Cap(f)=cap$
	Gu_Tip(f)=tip$
	Gu_Var(f)=-1
	Gu_Val(f)=vl
End Function

;**** Draw Functions
Function Gu_Draw()
	formlockedevent=0
	If MouseX()=Gu_MX And MouseY()=Gu_MY Then
		MoveCount=MoveCount+1
	Else
		MoveCount=0
	EndIf	
	
	Gu_MX=MouseX():Gu_MY=MouseY():Gu_MRC_Pressed=0
	If MouseDown(1) Then 
		Gu_MRC=1
		If Gu_MRC_Old<>Gu_MRC Then Gu_MRC_Pressed=1
		
		If Gu_Repeater>30 Then 
			Gu_MRC_Pressed=1
			Gu_Repeater=29
		EndIf
		Gu_Repeater=Gu_Repeater+1
	Else
		Gu_Repeater=0
		Gu_MRC=0
	EndIf
	
	If Gu_MRC_Pressed>0 Then Gu_Focus=0
	
	If Gu_Focus>0 Then
		If Gu_Var(Gu_Focus)>0 Then
			s$=ObSData(FrNo,Hit,Gu_Var(Gu_Focus))
		Else
			s$=Gu_Txt(Gu_Focus)
		EndIf
		
		;**** LEFT ****
		If KyV(203)Then
			If Gu_Focus_CP>1 Then Gu_Focus_CP=Gu_Focus_CP-1
		EndIf
		;**** RIGHT ****
		If KyV(205)Then
			If Gu_Focus_CP<=Len(s$)Then Gu_Focus_CP=Gu_Focus_CP+1
		EndIf
		;**** HOME ****
		If KyV(199)Then Gu_Focus_CP=1
		;**** END ****
		If KyV(207)Then Gu_Focus_CP=Len(s$)+1
		
		If ax1<>0 And kval=1 Then
			ay1$=Mid$(s$,1,Gu_Focus_CP-1)
			ay2$=Mid$(s$,Gu_Focus_CP)
			If ax2=8 Then
				If Len(ay1$)>1 Then 
					s$=Mid$(ay1$,1,Len(ay1$)-1)+ay2$
					Gu_Focus_CP=Gu_Focus_CP-1
				Else
					If Len(ay1$)=1 Then 
						s$=ay2$
						Gu_Focus_CP=Gu_Focus_CP-1
					EndIf	
				EndIf
			EndIf	
			If (ax2>=32 And ax2<=126) Then
				
				If Gu_Legal(Gu_Focus)=1 Then 
					If ax2=46 Or (ax2>=48 And ax2<=57) Or (ax2>=97 And ax2<=122) Or (ax2>=65 And ax2<=90) Then
						ay1$=Mid$(s$,1,Gu_Focus_CP-1)
						ay2$=Mid$(s$,Gu_Focus_CP)
						If ((api_GetKeyState($14) And $FFFF) <> 0) Then
							s$=ay1$+Upper$(Chr$(ax2))+ay2$
						Else
							s$=ay1$+Chr$(ax2)+ay2$
						EndIf
						Gu_Focus_CP=Gu_Focus_CP+1
					EndIf
				Else
					ay1$=Mid$(s$,1,Gu_Focus_CP-1)
					ay2$=Mid$(s$,Gu_Focus_CP)
					If ((api_GetKeyState($14) And $FFFF) <> 0) Then
						s$=ay1$+Upper$(Chr$(ax2))+ay2$
					Else
						s$=ay1$+Chr$(ax2)+ay2$
					EndIf
					Gu_Focus_CP=Gu_Focus_CP+1
				EndIf
				
			EndIf
			If Gu_Var(Gu_Focus)>0 Then
				
				If Gu_Legal(Gu_Focus)=0 Then
					ObSData(FrNo,Hit,Gu_Var(Gu_Focus))=s$
				Else
					If Len(s$)>2 Then 
						ObSData(FrNo,Hit,Gu_Var(Gu_Focus))=s$
					EndIf	
				EndIf	
			Else
				Gu_Txt(Gu_Focus)=s$
			EndIf
		EndIf
		
	EndIf	
	
	MoveTip$=""
	
	v1=Gu_MRC_Pressed
	v=v1
	For f=1 To 1024
		Gu_Evt(f)=0
		If Gg_Vis(Gu_Grp(f))>0 Then
			If Gu_Grp(f)<formlocked Then
				Gu_MRC_Pressed=0
			Else
				Gu_MRC_Pressed=v
			EndIf
			Select Gu_Typ(f)
				Case Gu_Typ_ImgButton
					Gu_Draw_ImgButton(f)
				Case Gu_Typ_Frame
					Gu_Draw_Frame(f)
				Case Gu_Typ_Check
					Gu_Draw_Check(f)
				Case Gu_Typ_IntInput	
					Gu_Draw_IntInput(f)
				Case Gu_Typ_PenInput
					Gu_Draw_PenInput(f)
				Case Gu_Typ_TextInput
					Gu_Draw_TextInput(f)
				Case Gu_Typ_TextDivider
					Gu_Draw_TextDivider(f)
				Case Gu_Typ_PenInput4
					Gu_Draw_PenInput4(f)
				Case Gu_Typ_Align
					Gu_Draw_Align(f)
				Case Gu_Typ_FuncList
					Gu_Draw_FuncList(f)
				Case Gu_Typ_Vscroller
					Gu_Draw_VScroller(f)
				Case Gu_Typ_CreateCode
					Gu_Draw_CreateCode(f)
				Case Gu_Typ_Viewsize4
					Gu_Draw_ViewSize4(f)
				Case Gu_Typ_Text
					Gu_Draw_Text(f)
				Case Gu_Typ_SpecialSlider
					Gu_Draw_SpecialSlider(f)
				Case Gu_Typ_List
					Gu_Draw_List(f)
				Case Gu_Typ_Form
					Gu_Draw_Form(f)
				Case Gu_Typ_Tab
					Gu_Draw_Tab(f)					
				Case Gu_Typ_ConsoleList
					Gu_Draw_ConsoleList(f)
				Case Gu_Typ_CodeEditor
					Gu_Draw_CodeEditor(f)
				Case Gu_Typ_FormEditor
					Gu_Draw_FormEditor(f)
				Case Gu_Typ_FileSelector
					Gu_Draw_FileSelector(f)
				Case Gu_Typ_SheetImport
					Gu_Draw_SheetImport(f)
				Case Gu_Typ_TextSlider
					Gu_Draw_TextSlider(f)
				Case Gu_Typ_MenuBarText
					Gu_Draw_MenuBarText(f)
				Case Gu_Typ_Menulist
					Gu_Draw_MenuList(f)
				Case Gu_Typ_MenuBarSolid
					Gu_Draw_MenuBarSolid(f)	
				Case Gu_Typ_VideoImport	
					Gu_Draw_VideoImport(f)
				Case Gu_Typ_TextButton
					Gu_Draw_TextButton(f)
				Case Gu_Typ_HScroller
					Gu_Draw_HScroller(f)
				Case Gu_Typ_Sheet
					Gu_Draw_Sheet(f)					
			End Select
		EndIf
	Next
	If v1>0 And formlocked=>ggFileMenu And formlockedevent=0 Then
		formlocked=0
	EndIf
	If MoveTip$>"" Then
		Color 255,200,110
		SetFont modfont3
		x7=StringWidth(MoveTip$)
		Rect Gu_MX+6,Gu_MY+16,x7+16,16,1
		Color 0,0,0
		Rect Gu_MX+6,Gu_MY+16,x7+16,16,0
		Text Gu_MX+14,Gu_MY+17,MoveTip$
	End If
	Gu_MRC_Old=Gu_MRC
End Function
Function CheckToolTip(f)
	If MoveCount>30 And Gu_Tip(f)>"" Then MoveTip$=Gu_Tip(f)
End Function
Function Gu_Draw_CreateCode(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	y2=738+(Gu_Val(f)*34)
	If Gu_MX>x9 And Gu_MX<x9+Gu_W(f) And Gu_MY>y9 And Gu_MY<y9+Gu_H(f) Then 
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),1280,y2+17,Gu_W(f),Gu_H(f)
		If Gu_MRC_Pressed=1 Then 
			Gu_Alter_Selected(f)
			Gu_Evt(f)=1
		EndIf
		CheckToolTip(f)
	Else
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),1280,y2,Gu_W(f),Gu_H(f)
	EndIf
End Function	
Function Gu_Draw_VScroller(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 29,27,29
	Rect x9-10,y9-3,20,Gu_H(f)+6,1	
	If Gu_Val(f)<Gu_Max(f) Then 
		
		Color 60,57,60
		Rect x9,y9,3,Gu_H(f),1
		If Gu_Held(f)=0 Then
			Color 120,117,120
		Else
			Color 255,198,0
		EndIf	
		a1#=Float(Gu_Shw(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If a1#>1 Then a1#=1
		a2#=a1*(Gu_H(f)-6)
	
		b1#=Float(Gu_Val(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If b1#>1 Then b1#=1
		b2#=b1*(Gu_H(f)-6)
		
		c1#=Float((Gu_Max(f)-Gu_Min(f)))/Float(Gu_H(f)-6)
		
	
		If Gu_MX>x9-5-Gu_Held(f) And Gu_MX<x9+6+Gu_Held(f) And Gu_MY=>y9+b2#-Gu_Held(f) And Gu_MY<=y9+b2#+a2#+Gu_Held(f) Then 
			
			If Gu_MRC_Pressed=1 And Gu_Repeater<10 Then 
				Gu_Sy=Gu_MY
				Gu_Svl=Gu_Val(f)
				Gu_Held(f)=30
			EndIf
			If Gu_Held(f)=30 Then 
				a=Gu_Val(f)
				If MouseDown(1)=0 Then 
					Gu_Held(f)=0
				Else
					
					Gu_Val(f)=Gu_Svl+(Float((Gu_MY-Gu_Sy)*c1#))
					;If Gu_Val(f)<Gu_Min(f) Then Gu_Val(f)=Gu_Min(f)
					;If Gu_Val(f)>Gu_Max(f)-(a2#*c1#) Then Gu_Val(f)=Gu_Max(f)-(a2#*c1#)
				EndIf
				If Gu_ScrollList(f)>0 And a<>Gu_Val(f) Then 
					If Gu_Typ(f-1)=19 Then DrawFunctionBox(f-1,f)
					If Gu_Typ(f-1)=25 Then Gu_Paint_ComboBox(f-1,f)
				EndIf			
				
			EndIf
			CheckToolTip(f)
		Else
			Gu_Held(f)=0
		EndIf
		If Gu_Val(f)<Gu_Min(f) Then Gu_Val(f)=Gu_Min(f)
		If Gu_Val(f)>Gu_Max(f)-(a2#*c1#) Then Gu_Val(f)=Gu_Max(f)-(a2#*c1#)
		
		a1#=Float(Gu_Shw(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If a1#>1 Then a1#=1
		a2#=a1*(Gu_H(f)-6)
		
		b1#=Float(Gu_Val(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If b1#>1 Then b1#=1
		b2#=b1*(Gu_H(f)-6)
		
		c1#=Float((Gu_Max(f)-Gu_Min(f)))/Float(Gu_H(f)-6)
		
		Rect x9-2,y9+b2#,7,a2#,1
		
		
		Rect x9-3,y9+b2+1,1,a2#-2
		Rect x9+5,y9+b2+1,1,a2#-2
		
		;Line x9-3,y9+b2#+1,x9-3,y9+b2#+a2#-2
		;Line x9+5,y9+b2#+1,x9+5,y9+b2#+a2#-2
		
	EndIf
	
	
End Function
Function Gu_Draw_HScroller(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 29,27,29
	Rect x9-4,y9,Gu_W(f)+8,20,1	
	If Gu_Val(f)<Gu_Max(f) Then 
		
		Color 60,57,60
		Rect x9+1,y9+8,Gu_W(f),3,1
		If Gu_Held(f)=0 Then
			Color 120,117,120
		Else
			Color 255,198,0
		EndIf	
		a1#=Float(Gu_Shw(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If a1#>1 Then a1#=1
		a2#=a1*(Gu_W(f)-6)
		
		b1#=Float(Gu_Val(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If b1#>1 Then b1#=1
		b2#=b1*(Gu_W(f)-6)
		
		c1#=Float((Gu_Max(f)-Gu_Min(f)))/Float(Gu_W(f)-6)
		
		If Gu_MY>y9+5-Gu_Held(f) And Gu_MY<y9+13+Gu_Held(f) And Gu_MX=>x9+b2#-Gu_Held(f)-4 And Gu_MX<=x9+b2#+a2#+Gu_Held(f)+4 Then 
			
			If Gu_MRC_Pressed=1 And Gu_Repeater<10 Then 
				Gu_Sy=Gu_MX
				Gu_Svl=Gu_Val(f)
				Gu_Held(f)=30
			EndIf
			If Gu_Held(f)=30 Then 
				a=Gu_Val(f)
				If MouseDown(1)=0 Then 
					Gu_Held(f)=0
				Else
					
					Gu_Val(f)=Gu_Svl+(Float((Gu_MX-Gu_Sy)*c1#))
					
				EndIf
				If Gu_ScrollList(f)>0 And a<>Gu_Val(f) Then 
					If Gu_Typ(f-1)=19 Then DrawFunctionBox(f-1,f)
					If Gu_Typ(f-1)=25 Then Gu_Paint_ComboBox(f-1,f)
				EndIf			
				
			EndIf
			CheckToolTip(f)
		Else
			Gu_Held(f)=0
		EndIf
		
		If Gu_Val(f)<Gu_Min(f) Then Gu_Val(f)=Gu_Min(f)
		If Gu_Val(f)>Gu_Max(f)-(a2#*c1#) Then Gu_Val(f)=Gu_Max(f)-(a2#*c1#)
		
		a1#=Float(Gu_Shw(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If a1#>1 Then a1#=1
		a2#=a1*(Gu_W(f)-6)
		
		b1#=Float(Gu_Val(f))/Float((Gu_Max(f)-Gu_Min(f)))
		If b1#>1 Then b1#=1
		b2#=b1*(Gu_W(f)-6)
		
		c1#=Float((Gu_Max(f)-Gu_Min(f)))/Float(Gu_W(f)-6)
		
		Rect x9+b2#-3,y9+6,a2#+7,7,1
		;Line x9+b2#+1,y9+5,x9+b2#+a2#-2,y9+5
		;Line x9+b2#+1,y9+13,x9+b2#+a2#-2,y9+13
	EndIf
	
End Function
Function Gu_Draw_FuncList(f)
	Grp=Gu_Grp(f)
	
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp):y8=Gu_Y(f)+Gg_Y(Grp)+Gu_H(f)
	
	If (Gu_MX>x9 And Gu_MX<x8 And Gu_MY>y9 And Gu_MY<y8) Then
		;Color 255,198,0
		;Line x9,y9-1,x8-1,y9-1
		;Line x9,y8+1,x8-1,y8+1
		;Line x9-1,y9,x9-1,y8
		;Line x8,y9,x8,y8
		DrawBlockRect Gu_ImgHandle(f),x9,y9,0,0,Gu_W(f),Gu_H(f)
		;Rect x9,y9,Gu_W(f),Gu_H(f)+1,0
		If Gu_MRC_Pressed=1 Then 
			;Gu_Val(f)=(MouseY()-y9)/14+Gu_Val(f+1)+1
			;If Gu_Val(f)>Gu_Max(f) And Gu_Max(f)>0 Then Gu_Val(f)=Gu_Max(f)
			DrawFunctionBox(f,f+1)
			a=(MouseY()-y9)/14+Gu_Val(f+1)
			If UDF$(a)>""Then 
				Gu_Val(f)=a
				Gu_Evt(f)=1
			EndIf	
		EndIf
	Else
		DrawBlockRect Gu_ImgHandle(f),x9,y9,0,0,Gu_W(f),Gu_H(f)
	EndIf
	
End Function
Function Gu_Draw_List(f)
	Grp=Gu_Grp(f)
	
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp):y8=Gu_Y(f)+Gg_Y(Grp)+Gu_H(f)
	
	;s$=Gu_Txt(f)
	
	If (Gu_MX>x9 And Gu_MX<x8 And Gu_MY>y9 And Gu_MY<y8) Then
		Color 255,198,0
		Line x9,y9-1,x8-1,y9-1
		Line x9,y8+1,x8-1,y8+1
		Line x9-1,y9,x9-1,y8
		Line x8,y9,x8,y8
		
		DrawBlockRect Gu_ImgHandle(f),x9,y9,0,0,Gu_W(f),Gu_H(f)
		Rect x9,y9,Gu_W(f),Gu_H(f)+1,0
		
		
		
		
		If Gu_MRC_Pressed=1 Then 
			Gu_Val(f)=Int((MouseY()-y9)/14)+Int(Gu_Val(f+1))+1
			Gu_Paint_ComboBox(f,f+1)
			Gu_Txt(Gu_Child(f))=lstext$(Gu_Val(f))
			ObSData(FrNo,Hit,QCap)=lstext$(Gu_Val(f))
			Gu_Alter_Selected(f)
			Gu_Evt(f)=1
		EndIf
		
	Else
		DrawBlockRect Gu_ImgHandle(f),x9,y9,0,0,Gu_W(f),Gu_H(f)
	EndIf
	
End Function
Function Gu_Draw_ImgButton(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	If Gu_Sel(f)=1 Then 
		DrawImageRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),Gu_X2(f),Gu_Y2(f),Gu_W(f),Gu_H(f)
		If Gu_MX>x9 And Gu_MX<x9+Gu_W(f) And Gu_MY>y9 And Gu_MY<y9+Gu_H(f) Then 
			CheckToolTip(f)
		EndIf
	Else
		If Gu_MX>x9 And Gu_MX<x9+Gu_W(f) And Gu_MY>y9 And Gu_MY<y9+Gu_H(f) Then 
			DrawImageRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),Gu_X3(f),Gu_Y3(f),Gu_W(f),Gu_H(f)
			If Gu_MRC_Pressed=1 Then 
				Gu_Alter_Selected(f)
				Gu_Evt(f)=1
			EndIf
			CheckToolTip(f)
		Else
			DrawImageRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),Gu_X1(f),Gu_Y1(f),Gu_W(f),Gu_H(f)
		EndIf	
	EndIf	
End Function
Function Gu_Draw_Form(f)
	Grp=Gu_Grp(f)
	Gu_X(f)=Gg_X(Grp):Gu_Y(f)=Gg_Y(grp)
	Gu_W(f)=Gg_W(grp):Gu_H(f)=Gg_H(grp)
	
	x9=Gu_X(f):x8=Gu_X(f)+Gu_W(f)
	y9=Gu_Y(f):y8=Gu_Y(f)+Gu_H(f)
	
	;**** Fill Form
	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
	Rect x9+1,y9+1,x8-x9-1,16,1
	Color CGui_Bk1_R,CGui_Bk1_G,CGui_Bk1_B
	Rect x9+1,y9+17,x8-x9-1,y8-y9-18,1	
	
	;**** Draw Outline
	Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
	Line x9,y9+1,x9,y8-1
	Line x8,y9+1,x8,y8-1
	Line x9+1,y9,x8-1,y9
	Line x9+1,y8,x8-1,y8
	
	
	Color 255,255,255
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f))
	Text x9+(Gu_W(f)/2)-(x7/2),y9+2,Gu_Cap(f)
	
End Function
Function Gu_Draw_CodeEditor(f)
	Grp=Gu_Grp(f)
	
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	
	DrawImageRect Gu_ImgHandle(f),x9+70,y9,codescroll+70,0,Gu_W(f)-70,Gu_H(f)
	DrawImageRect Gu_ImgHandle(f),x9,y9,0,0,70,Gu_H(f)
	
End Function
Function Gu_Draw_SheetImport(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	
	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
	Rect x9-2,y9-2,Gu_W(f)+4,Gu_H(f)+4,1
	
	a1=Gu_Val(gSheetWidth)
	If a1>128 Then a1=128
	b1=Gu_Val(gSheetHeight)
	If b1>200 Then b1=200
	
	DrawImageRect Gu_ImgHandle(f),x9,y9,0,0,a1*4,b1*2
End Function
Function Gu_Draw_Sheet(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	
	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
	Rect x9-2,y9-2,Gu_W(f)+4,Gu_H(f)+4,1
;	Color CGui_Bk3_R,CGui_Bk3_G,CGui_Bk3_B
;	Rect x9+20,y9+20,Gu_W(f)-210,Gu_H(f)-60
	
	
	DrawImageRect Gu_ImgHandle(gSheetEditor),x9+16,y9+16,0,0,Gu_W(gSheetEditor)-220,Gu_H(gSheetEditor)-60
	
	
	;w=Gu_Val(gGraphicsEditTextSlider)
	;If GrpWid(w)>0 Then
	;	DrawImageRect GrpCImg(w,0),x9+24,y9+24,0,0,GrpWid(w)*4,GrpHei(w)*2
	;EndIf	
	
	
	h1=20
	a=1
	While h1<Gu_H(f)-110
		a1=Gu_Val(gSheetSelectScroll)+a
		
		If a1=CurrSheet Then
			Color CGui_Bk1_R,CGui_Bk1_G,CGui_Bk1_B
			Rect x8-168,y9+h1-5,142,110
		EndIf	
		
		Color 220,220,220
		Text x8-160,y9+h1,Str(a1)
		If GrpWid(a1)>0 And GrpCImg(a1,2)<>0 Then
			DrawImageRect GrpCImg(a1,2),x8-136,y9+h1,0,0,100,100
		Else
			Color CGui_Bk3_R,CGui_Bk3_G,CGui_Bk3_B
			Rect x8-136,y9+h1,100,100
		EndIf
		a=a+1
		h1=h1+110
	Wend
	
	
	
End Function
Function Gu_Draw_VideoImport(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
	Rect x9-2,y9-2,Gu_W(f)+4,Gu_H(f)+4,1
	x1=(512-vid_imgwid)/2
	y1=(400-vid_imghei)/2
	DrawImageRect Gu_ImgHandle(f),x9+x1,y9+y1,0,0,vid_imgwid,vid_imghei
End Function
Function Gu_Draw_FileSelector(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	
	SetFont modfont2
	
	a=Gu_Min(f)
	If (Gu_MX>x9 And Gu_MX<x8 And Gu_MY>y9 And Gu_MY<y8) Then 
		If Gu_MRC_Pressed=1 Then
			a=((Gu_MY-y9)/FontHeight())+Gu_Val(gFileSelList)
			If a=Gu_Min(f) Then
				Gu_Evt(f)=1
			EndIf	
		EndIf
	EndIf
	If (Gu_Val(gFileVScroll)<>Gu_Val(gFileSelList)) Or (a<>Gu_Min(f)) Then
		
		Gu_Val(gFileSelList)=Gu_Val(gFileVScroll)
		SetBuffer ImageBuffer(Gu_ImgHandle(gFileSelList))
		ClsColor CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
		Cls
		Y=2:e=0
		Color 255,255,255
		While Y<Gu_H(gFileSelList) And e<NoOfFiles
			n=Gu_Val(gFileVScroll)+e
			If n=a Then
				Gu_Min(f)=a
				Color 90,90,90
				Rect 6,Y,300, FontHeight(),1
				Color 255,255,255
			EndIf	
			If FileLst(n)>"" Then 
				DrawImageRect Backdrop_Image,10,Y,251+(FileLTyp(n)+3)*16,1020,12,12
				Text 25,Y,FileLst(n)
			EndIf
			Y=Y+FontHeight()
			e=e+1
		Wend
		SetBuffer BackBuffer()
		Gu_Shw(gFileVScroll)=e
	EndIf
	Color 255,255,255
	e=(Gu_MY-y9)/FontHeight()+Gu_Val(gFileVScroll)
	If e>-1 And e<=NoOfFiles Then Text x9-100,y9,Str(FileLst(e))
	
	
	Grp=Gu_Grp(f)
	
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	
	DrawImageRect Gu_ImgHandle(f),x9,y9,0,0,Gu_W(f),Gu_H(f)
	
End Function
Function Gu_Draw_FormEditor(f)
	Grp=Gu_Grp(f)
	
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	
	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
	Rect x9,y9,Gu_W(f),y1off
	Rect x9,y9+y1off,x1off,Gu_H(f)-y1off
	
	
	Rect x9+x1off,y9+y1off+196,256,1
	
	DrawImageRect Gu_ImgHandle(f),x9+x1off,y9+y1off,0,0,Gu_W(f)-x1off,Gu_H(f)-y1off
	
End Function
Function Gu_Draw_Tab(f)
	Grp=Gu_Grp(f)
	Gu_X(f)=Gg_X(Grp):Gu_Y(f)=Gg_Y(grp)
	Gu_W(f)=Gg_W(grp):Gu_H(f)=Gg_H(grp)
	
	x9=Gu_X(f):x8=Gu_X(f)+Gu_W(f)
	y9=Gu_Y(f):y8=Gu_Y(f)+Gu_H(f)
	
	;**** Fill Form
;	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
;	Rect x9+1,y9+1,x8-x9-1,16,1
	
	Color CGui_Bk1_R,CGui_Bk1_G,CGui_Bk1_B
	Rect x9+1,y9+18,x8-x9-1,y8-y9-18,1	
	
	;**** Draw Outline
	Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
	Rect x9,y9+18,1,Gu_H(f)-18
	Rect x8,y9+18,1,Gu_H(f)-18
	Rect x9+1,y9+17,Gu_W(f)-1,1
	Rect x9+1,y8,Gu_W(f)-1,1
	
	SetFont modfont2
	;Draw first tab Background
	x7=StringWidth(Gu_Tab(f,Gu_TabIndex(f)))+42
	
	Color CGui_Bk1_R,CGui_Bk1_G,CGui_Bk1_B
	Rect x9+1,y9+1,x7-1,17,1	
	Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
	
	Rect x9,y9+1,1,16
	Rect x9+x7,y9+1,1,16
	Rect x9+1,y9,x7-1,1
	
	Color 200,200,200
	Text x9+24,y9+2,Gu_Tab(f,Gu_TabIndex(f))
	If Gu_TabImage(f,Gu_TabIndex(f))>0 Then DrawImageRect Backdrop_Image,x9+8,y9+3,251+(Gu_TabImage(f,Gu_TabIndex(f))-1)*16,1020,12,12
	
	e=Gu_TabIndex(f)
	For g=1 To Gu_TabCount(f)
		If Gu_TabIndex(f)<>g Then
			Text x9+x7+24,y9+2,Gu_Tab(f,g)
			If Gu_TabImage(f,g)>0 Then DrawImageRect Backdrop_Image,x9+x7+8,y9+3,251+(Gu_TabImage(f,g)-1)*16,1020,12,12
			a=x7+2
			x7=x7+StringWidth(Gu_Tab(f,g))+42
			b=x7-10
			If Gu_MX>x9+a And Gu_MX<x9+b And Gu_MY>y9+2 And Gu_MY<y9+17 Then
				If Gu_MRC_Pressed=1 Then e=g
			EndIf	
		EndIf
	Next	
	Gu_TabIndex(f)=e
	
	
	
End Function
Function Gu_Draw_ConsoleList(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp):y8=Gu_Y(f)+Gg_Y(Grp)+Gu_H(f)
	DrawBlockRect Gu_ImgHandle(f),x9,y9,0,0,Gu_W(f),Gu_H(f)
	
End Function 
Function Gu_Draw_Frame(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp):y8=Gu_Y(f)+Gg_Y(Grp)+Gu_H(f)
	
	Color 200,200,200
	SetFont modfont2
	Text x9+9,y9,Gu_Cap(f)
	x7=StringWidth(Gu_Cap(f))
	
	Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
	
	Rect x9,y9+8,1,Gu_H(f)-8
	Rect x8,y9+8,1,Gu_H(f)-8
	Rect x9+1,y9+7,6,1
	Rect x9+x7+12,y9+7,Gu_W(f)-x7-12,1
	Rect x9+1,y8,Gu_W(f)-1,1
	
End Function
Function Gu_Draw_TextDivider(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp)
	Color 122,120,122
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f))
	Text x9+10,y9,Gu_Cap(f)
	Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
	Rect x9,y9+6,8,1
	Rect x9+x7+16,y9+6,Gu_W(f)-x7-16,1
	
End Function
Function Gu_Draw_Text(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp)
	Color 220,218,220
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f))
	Text x9,y9,Gu_Cap(f)
End Function
Function Gu_Draw_MenuBarSolid(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp)
	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B
	Rect x9-10,y9-2,x8,22,1
	Color CGui_Bk1_R,CGui_Bk1_G,CGui_Bk1_B
	Rect x9-12,y9+21,Gu_W(h),1
End Function
Function Gu_Draw_MenuBarText(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp):Y8=Y9+18
	
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f))
	If Gu_MX=>x9 And Gu_MX<=x8 And Gu_MY=>y9 And Gu_MY<=y8 Then
		Color 255,198,0
		Rect x9+1,y9,Gu_W(f)-1,1
		Rect x9+1,y9+18,Gu_W(f)-1,1
		Rect x9,y9+1,1,17
		Rect x8,y9+1,1,17
		Text x9+6,y9+2,Gu_Cap(f)
		;DrawImageRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),Gu_X3(f),Gu_Y3(f),Gu_W(f),Gu_H(f)
		If Gu_MRC_Pressed=1 And formlocked=0 Then 
			formlocked=Gu_Val(f)
			While MouseDown(1)
				
			Wend
			v1=0
		EndIf
	Else
		Color 255,255,255
		Text x9+6,y9+2,Gu_Cap(f)
	EndIf	
	
End Function
Function Gu_Draw_TextButton(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp):Y8=Y9+Gu_H(f)
	
	SetFont modfont2
	x7=x9+(Gu_W(f)/2)-(StringWidth(Gu_Cap(f))/2)
	y7=y9+(Gu_H(f)/2)-7
	If Gu_MX=>x9 And Gu_MX<=x8 And Gu_MY=>y9 And Gu_MY<=y8 Then
		Color 255,198,0
		Rect x9+1,y9,Gu_W(f)-1,1
		Rect x9+1,y8,Gu_W(f)-1,1
		Rect x9,y9+1,1,Gu_H(f)-1
		Rect x8,y9+1,1,Gu_H(f)-1		
		Text x7,y7,Gu_Cap(f)
		If Gu_MRC_Pressed=1 Then 
			Gu_Evt(f)=1
		EndIf
	Else
		Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
		Rect x9+1,y9,Gu_W(f)-1,1
		Rect x9+1,y8,Gu_W(f)-1,1
		Rect x9,y9+1,1,Gu_H(f)-1
		Rect x8,y9+1,1,Gu_H(f)-1
		Color 255,255,255
		Text x7,y7,Gu_Cap(f)
	EndIf	
	
End Function
Function Gu_Draw_MenuList(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp):Y8=Y9+Gu_H(f)
	
	SetFont modfont2
	
	
	Color CGui_Bk2_R,CGui_Bk2_G,CGui_Bk2_B	
	Rect x8,y9+4,4,Gu_H(f),1
	Rect x9+4,y9+Gu_H(f),Gu_W(f),4,1
	
	Color CGui_Bk1_R,CGui_Bk1_G,CGui_Bk1_B
	Rect x9,y9,Gu_W(f),Gu_H(f),1
	Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
	Rect x9,y9,Gu_W(f),Gu_H(f),0
	
	a$=Gu_Cap$(f)
	b$=""
	yb=y9+4
	c=0
	Color 220,220,220
	While a$>""
		c=c+1
		ah=Instr(a$,"|",1)
		If ah>0 Then 
			b$=Mid$(a$,1,ah-1)
			a$=Mid$(a$,ah+1)
		Else
			b$=a$
			a$=""
		EndIf
		If b$<>"-" Then
			If Gu_MX=>x9 And Gu_MX<=x8 And Gu_MY=>yb And Gu_MY<=yb+16 Then
				Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
				Rect x9+4,yb,Gu_W(f)-8,15
				Color 220,220,220
				If Gu_MRC_Pressed=1 Then 
					Gu_Evt(f)=c
					formlockedevent=1
					While MouseDown(1)
						
					Wend
				EndIf
			EndIf
			Text x9+16,yb,b$
			yb=yb+18
		Else
			Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
			Rect x9+16,yb+4,Gu_W(f)-10,1
			Color 220,220,220
			yb=yb+12
		EndIf
	Wend	
	
	
	
;	If Gu_MX=>x9 And Gu_MX<=x8 And Gu_MY=>y9 And Gu_MY<=y8 Then
;		Color 255,198,0
;		Line X9+1,Y9,x8,y9
;		Line X9+1,Y9+19,x8-1,y9+19
;		Line x9,y9+1,x9,y9+18
;		Line x8,y9+1,x8,y9+18
		
;		Text x9+6,y9+2,Gu_Cap(f)
	;	;DrawImageRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),Gu_X3(f),Gu_Y3(f),Gu_W(f),Gu_H(f)
	;	If Gu_MRC_Pressed=1 Then 
	;		formlocked=Gu_Val(f)
	;	EndIf
;	Else
		
;		Text x9+6,y9+2,Gu_Cap(f)
;	EndIf	
	
End Function
Function Gu_Draw_TextInput(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp):x8=Gu_X(f)+Gg_X(Grp)+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	If Gu_Var(f)>0 Then
		s$=ObSData(FrNo,Hit,Gu_Var(f))
	Else
		s$=Gu_Txt(f)
	EndIf	
	
	SetFont modfont2
	Color 29,27,29
	Rect x9+1,y9+1,Gu_W(f)-1,14,1
	If (Gu_MX>x9 And Gu_MX<x8 And Gu_MY>y9 And Gu_MY<y9+15) Or Gu_Focus=f Then
		Color 255,198,0
		Rect x9+1,y9,Gu_W(f)-1,1
		Rect x9+1,y9+15,Gu_W(f)-1,1
		Rect x9,y9+1,1,14
		Rect x8,y9+1,1,14
		
		Rect x9+1,y9+1,Gu_W(f)-1,14,0
		If Gu_MRC_Pressed=1 Then
			Gu_Focus=f
			a=Gu_MX-(x9+4)
			If a<0 Then a=0
			If a>Gu_W(f)-8 Then a=Gu_W(f)-8
			Gu_Focus_CP=1
			For fd=1 To Len(s$)
				If StringWidth(Mid(s$,1,fd))>a Then
					fd=Len(s$)+1
				Else
					Gu_Focus_CP=Gu_Focus_CP+1
				EndIf	
			Next
		EndIf
		If Gu_Focus=f Then
			Color 255,255,255
			a=StringWidth(Mid(s$,1,Gu_Focus_CP-1))
			Rect a+x9+4,y9+3,3,11,1
		EndIf
		CheckToolTip(f)
	Else	
		Color CGui_Ot1_R,CGui_Ot1_G,CGui_Ot1_B
		Rect x9+1,y9,Gu_W(f)-1,1
		Rect x9+1,y9+15,Gu_W(f)-1,1
		Rect x9,y9+1,1,14
		Rect x8,y9+1,1,14
	EndIf
	If Gu_Focus=f Then
		Color 255,198,0
		If Gu_Child(f)>0 Then
			If Gu_Typ(Gu_Child(f))=Gu_Typ_List Then 
				If s$<>lstext$(Gu_Val(Gu_Child(f))) Then
					lstext$(Gu_Val(Gu_Child(f)))=s$
					tf$=ObSData(FrNo,Gu_Val(Gu_Child(f)),QStT)
					Gu_Paint_ComboBox(Gu_Child(f),Gu_Child(f)+1)
				EndIf	
			EndIf
		EndIf	
	Else
		Color 200,200,200
	EndIf
	Text x9+4,y9+1,s$
	Color 200,200,200
	x7=StringWidth(Gu_Cap(f)+":")
	Text x9-x7-2,y9+1,Gu_Cap(f)+":"	
	
End Function
Function Gu_Draw_Check(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 200,200,200
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f)+":")
	Text x9-x7-18,y9,Gu_Cap(f)+":"
	
	If Gu_Chk(f)=1 Then
		If Gu_MX>x9-x7-18 And Gu_MX<x9 And Gu_MY>y9 And Gu_MY<y9+15 Then
			DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-13,Gu_Y(f)+Gg_Y(Grp),1282,719,13,14
			If Gu_MRC_Pressed=1 Then 
				Gu_Chk(f)=(Gu_Chk(f)+1)Mod 2
				If Gu_Var(f)=>0 Then ObData(FrNo,Hit,Gu_Var(f))=Gu_Chk(f)
				Gu_Evt(f)=1
			EndIf
			CheckToolTip(f)
		Else
			DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-13,Gu_Y(f)+Gg_Y(Grp),1282,704,13,14
		EndIf	
	Else
		If Gu_MX>x9-x7-18 And Gu_MX<x9 And Gu_MY>y9 And Gu_MY<y9+15 Then
			DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-13,Gu_Y(f)+Gg_Y(Grp),1296,719,13,14
			If Gu_MRC_Pressed=1 Then 
				Gu_Chk(f)=(Gu_Chk(f)+1)Mod 2
				If Gu_Var(f)=>0 Then ObData(FrNo,Hit,Gu_Var(f))=Gu_Chk(f)
				Gu_Evt(f)=1
			EndIf
			CheckToolTip(f)
		Else
			DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-13,Gu_Y(f)+Gg_Y(Grp),1296,704,13,14
		EndIf	
	EndIf
End Function
Function Gu_Draw_IntInput(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 200,200,200
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f)+":")
	Text x9-x7-52,y9,Gu_Cap(f)+":"
	
	v=0
	If Gu_Var(f)=QHei Or Gu_Var(f)=QTop Then v=1
	
	Color 95,96,95
	Rect Gu_X(f)+Gg_X(Grp)-43,Gu_Y(f)+Gg_Y(Grp),36,16,0
	Color 29,27,29
	Rect Gu_X(f)+Gg_X(Grp)-42,Gu_Y(f)+Gg_Y(Grp)+1,34,14,1
	Color 255,255,255
	If Gu_Var(f)=>0 Then
		If v=0 Then
			Text Gu_X(f)+Gg_X(Grp)-25,y9+1,Str$(Int(ObData(FrNo,Hit,Gu_Var(f)))),1,0
		Else
			Text Gu_X(f)+Gg_X(Grp)-25,y9+1,Str$(Int(ObData(FrNo,Hit,Gu_Var(f))/2)),1,0
		EndIf	
	Else
		Text Gu_X(f)+Gg_X(Grp)-25,y9+1,Str$(Int(Gu_Val(f))),1,0
	EndIf	
	If Gu_MX>x9-8 And Gu_MX<x9 And Gu_MY>y9 And Gu_MY<y9+15 Then
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-8,Gu_Y(f)+Gg_Y(Grp),1335,720,8,16
		If Gu_MRC_Pressed=1 Then 
			If Gu_Var(f)=>0 Then
				If v=0 Then 
					ObData(FrNo,Hit,Gu_Var(f))=ObData(FrNo,Hit,Gu_Var(f))+1
				Else
					ObData(FrNo,Hit,Gu_Var(f))=ObData(FrNo,Hit,Gu_Var(f))+2
				EndIf	
				If ObData(FrNo,Hit,Gu_Var(f))>Gu_Max(f) Then ObData(FrNo,Hit,Gu_Var(f))=Gu_Max(f)
			Else
				Gu_Val(f)=Gu_Val(f)+1
				If Gu_Val(f)>Gu_Max(f) Then Gu_Val(f)=Gu_Max(f)
			EndIf	
		EndIf
		CheckToolTip(f)
	Else
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-8,Gu_Y(f)+Gg_Y(Grp),1335,703,8,16
	EndIf
	If Gu_MX>x9-50 And Gu_MX<x9-42 And Gu_MY>y9 And Gu_MY<y9+15 Then	
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-50,Gu_Y(f)+Gg_Y(Grp),1310,720,8,16
		If Gu_MRC_Pressed=1 Then
			If Gu_Var(f)=>0 Then 
				If v=0 Then
					ObData(FrNo,Hit,Gu_Var(f))=ObData(FrNo,Hit,Gu_Var(f))-1
				Else
					ObData(FrNo,Hit,Gu_Var(f))=ObData(FrNo,Hit,Gu_Var(f))-2
				EndIf	
				If ObData(FrNo,Hit,Gu_Var(f))<Gu_Min(f) Then ObData(FrNo,Hit,Gu_Var(f))=Gu_Min(f)
			Else
				Gu_Val(f)=Gu_Val(f)-1
				If Gu_Val(f)<Gu_Min(f) Then Gu_Val(f)=Gu_Min(f)
			EndIf
		EndIf
		CheckToolTip(f)
	Else	
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-50,Gu_Y(f)+Gg_Y(Grp),1310,703,8,16	
	EndIf
End Function
Function Gu_Draw_TextSlider(f)
	Grp=Gu_Grp(f)
	
	x9=Gu_X(f)+Gg_X(Grp):x8=x9+Gu_W(f)
	y9=Gu_Y(f)+Gg_Y(grp):y8=y9+Gu_H(f)
	
	Color 200,200,200
	SetFont modfont2
	
	Color 95,96,95
	Rect x9+8,y9,x8-16-x9,16,0
	Color 29,27,29
	Rect x9+9,y9+1,x8-18-x9,14,1
	Color 255,255,255
	
	
		
	If Gu_MX>x8-8 And Gu_MX<x8 And Gu_MY>y9 And Gu_MY<y9+15 Then
		DrawBlockRect Backdrop_Image,x8-8,y9,1335,720,8,16
		If Gu_MRC_Pressed=1 Then 
			If Gu_Val(f)<Gu_Max(f)Then Gu_Val(f)=Gu_Val(f)+1
			Gu_Evt(f)=1
		EndIf
		CheckToolTip(f)
	Else
		DrawBlockRect Backdrop_Image,x8-8,y9,1335,703,8,16
	EndIf
	If Gu_MX>x9 And Gu_MX<x9+8 And Gu_MY>y9 And Gu_MY<y9+15 Then	
		DrawBlockRect Backdrop_Image,x9,y9,1310,720,8,16
		If Gu_MRC_Pressed=1 Then
			If Gu_Val(f)>Gu_Min(f) Then Gu_Val(f)=Gu_Val(f)-1
			Gu_Evt(f)=1
		EndIf
		CheckToolTip(f)
	Else	
		DrawBlockRect Backdrop_Image,x9,y9,1310,703,8,16	
	EndIf
	
	If Mid$(Gu_Cap$(f),1,6)<>"Form1|" And f=gFormEditTextSlider Then Stop
	d1$=Gu_Cap$(f)
	d2$=""
	For g=1 To Gu_Val(f)
		a=Instr(d1$,"|",1)
		If a>0 Then 
			d2$=Mid$(d1$,1,a-1)
			d1$=Mid$(d1$,a+1)
		EndIf	
	Next
	Text x9+12,y9+1,Str$(Int(Gu_Val(f)))+":"+d2$
	
	
End Function
Function Gu_Draw_SpecialSlider(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	a7#=Float(Gu_W(f)-40)/255.0
	If Gu_MX>x9 And Gu_MX<x9+Gu_W(f) And Gu_MY>y9 And Gu_MY<y9+Gu_H(f) Then 
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),Gu_X2(f),Gu_Y2(f),Gu_W(f),Gu_H(f)
		If MouseDown(1) Then 
			Gu_Evt(f)=1
			Gu_Val(f)=Gu_MX-x9-30
			If Gu_Val(f)<0 Then Gu_Val(f)=0
			If Gu_Val(f)>Gu_W(f)-40 Then Gu_Val(f)=Gu_W(f)-40
			Gu_Val(f)=Gu_Val(f)/a7#
		EndIf
		Color 20,20,20
		Rect x9+30+(Gu_Val(f)*a7#)-1,Gu_Y(f)+Gg_Y(Grp)+7,7,11
		Color 255,198,0
		Rect x9+30+(Gu_Val(f)*a7#),Gu_Y(f)+Gg_Y(Grp)+7,5,10,1
		Color 20,20,20
		Text x9+Gu_W(f)-17,y9+7,Int(Gu_Val(f)/2.56)+"%",1,0
		CheckToolTip(f)
	Else
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp),Gu_Y(f)+Gg_Y(Grp),Gu_X1(f),Gu_Y1(f),Gu_W(f),Gu_H(f)
		Color 20,20,20
		Rect x9+30+(Gu_Val(f)*a7#)-1,Gu_Y(f)+Gg_Y(Grp)+7,7,11
		Color 120,117,120
		Rect x9+30+(Gu_Val(f)*a7#),Gu_Y(f)+Gg_Y(Grp)+7,5,10,1
		Color 20,20,20
		Text x9+Gu_W(f)-17,y9+7,Int(Gu_Val(f)/2.56)+"%",1,0
	EndIf
	
End Function
Function Gu_Draw_PenInput(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 200,200,200
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f)+":")
	Text x9-x7-50,y9,Gu_Cap(f)+":"
	
	
	DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-45,Gu_Y(f)+Gg_Y(Grp),1347,703,45,27
	
	If Gu_MX>x9-26 And Gu_MX<x9-2 And Gu_MY>y9+2 And Gu_MY<y9+26 Then
		a=(Gu_MX-(x9-26))/6
		b=(Gu_MY-(y9+2))/6
		Color 255,198,0
		Rect x9-27+(a*6),y9+(b*6),9,9,0
		Rect x9-26+(a*6),y9+(b*6)+1,7,7,0
		If Gu_MRC_Pressed=1 Then 
			If Gu_Var(f)=>0 Then 
				ObData(FrNo,Hit,Gu_Var(f))=a+(b*4)
			Else
				Gu_Val(f)=a+(b*4)
			EndIf	
		EndIf
		CheckToolTip(f)
	EndIf
	If Gu_Var(f)=>0 Then 
		Color OS_Red(ObData(FrNo,Hit,Gu_Var(f))),OS_Green(ObData(FrNo,Hit,Gu_Var(f))),OS_Blue(ObData(FrNo,Hit,Gu_Var(f)))
	Else
		Color OS_Red(Gu_Val(f)),OS_Green(Gu_Val(f)),OS_Blue(Gu_Val(f))
	EndIf	
	Rect x9-43,Gu_Y(f)+Gg_Y(Grp)+2,15,23,1
	
End Function
Function Gu_Draw_PenInput4(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 200,200,200
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f)+":")
	Text x9-x7-50,y9,Gu_Cap(f)+":"
	
	DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-45,Gu_Y(f)+Gg_Y(Grp),1347,738,45,16
	
	If Gu_MX>x9-26 And Gu_MX<x9-2 And Gu_MY>y9+2 And Gu_MY<y9+16 Then
		a=(Gu_MX-(x9-26))/6
		Color 255,198,0
		Rect x9-27+(a*6),y9,9,15,0
		Rect x9-26+(a*6),y9+1,7,13,0
		If Gu_MRC_Pressed=1 Then 
			If Gu_Var(f)=>0 Then 
				ObData(FrNo,Hit,Gu_Var(f))=a
			Else
				Gu_Val(f)=a
			EndIf	
		EndIf
		CheckToolTip(f)
	EndIf
	If Gu_Var(f)=>0 Then 
		Color OS_Red(ObData(FrNo,Hit,Gu_Var(f))),OS_Green(ObData(FrNo,Hit,Gu_Var(f))),OS_Blue(ObData(FrNo,Hit,Gu_Var(f)))
	Else
		Color OS_Red(Gu_Val(f)),OS_Green(Gu_Val(f)),OS_Blue(Gu_Val(f))
	EndIf	
	Rect x9-43,Gu_Y(f)+Gg_Y(Grp)+2,15,12,1
	
End Function
Function Gu_Draw_ViewSize4(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 200,200,200
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f)+":")
	Text x9-x7-58,y9,Gu_Cap(f)+":"
	
	If Gu_Var(f)=>0 Then 
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-53,Gu_Y(f)+Gg_Y(Grp),1347,755+(ObData(FrNo,Hit,Gu_Var(f))*17),51,16
	Else
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-53,Gu_Y(f)+Gg_Y(Grp),1347,755+(Gu_Val(f)*17),51,16
	EndIf
	If Gu_MX>x9-52 And Gu_MX<x9-4 And Gu_MY=>y9 And Gu_MY<y9+16 Then
		a=(Gu_MX-(x9-51))/12
		Color 255,198,0
		Rect x9-51+(a*12),y9,12,15,0
		Rect x9-50+(a*12),y9+1,10,13,0
		If Gu_MRC_Pressed=1 Then 
			If Gu_Var(f)=>0 Then 
				ObData(FrNo,Hit,Gu_Var(f))=a
			Else
				Gu_Val(f)=a
			EndIf	
		EndIf
		CheckToolTip(f)
	EndIf
	
End Function
Function Gu_Draw_Align(f)
	Grp=Gu_Grp(f)
	x9=Gu_X(f)+Gg_X(Grp)
	y9=Gu_Y(f)+Gg_Y(Grp)
	
	Color 200,200,200
	SetFont modfont2
	x7=StringWidth(Gu_Cap(f)+":")
	Text x9-x7-38,y9,Gu_Cap(f)+":"
	
	If Gu_Var(f)=>0 Then 
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-33,Gu_Y(f)+Gg_Y(Grp),1310,738+(ObData(FrNo,Hit,Gu_Var(f))*17),33,16
	Else
		DrawBlockRect Backdrop_Image,Gu_X(f)+Gg_X(Grp)-33,Gu_Y(f)+Gg_Y(Grp),1310,738+(Gu_Val(f)*17),33,16
	EndIf
	If Gu_MX>x9-31 And Gu_MX<x9-2 And Gu_MY>y9+2 And Gu_MY<y9+16 Then
		a=(Gu_MX-(x9-31))/10
		Color 255,198,0
		Rect x9-33+(a*10),y9,12,15,0
		Rect x9-32+(a*10),y9+1,10,13,0
		If Gu_MRC_Pressed=1 Then 
			If Gu_Var(f)=>0 Then 
				ObData(FrNo,Hit,Gu_Var(f))=a
			Else
				Gu_Val(f)=a
			EndIf	
		EndIf
		CheckToolTip(f)
	EndIf
	
End Function
Function Gu_Alter_Selected(f)
	grp=Gu_Grp(f)
	For h=1 To 1024
		If grp=Gu_Grp(h)Then
			If h<>f Then
				Gu_Sel(h)=0
			Else
				Gu_Sel(h)=1
				Gg_Sel(grp)=h
			EndIf	
		EndIf
	Next
End Function
Function Gu_Paint_ComboBox(Bn,sn)
	
	SetBuffer ImageBuffer(Gu_ImgHandle(Bn))
	k1=Int(Gu_H(Bn)/14)*14
	Color 29,27,29
	Rect 0,0,220,k1+14,1
	
	k=k1/14
	SetFont fntscreen2
	
	
	
	
	Gu_Min(sn)=0
	Gu_Max(sn)=Gu_Max(Bn)
	Gu_Shw(sn)=Int(Gu_H(Bn)/14)
	r=Int(Gu_Val(sn))+1
	f=1
	If r>0 Then f=r
	j=0
	
	Gu_Txt$(Bn)=""
	
	h=1
	For g=Gu_Max(Bn) To 1 Step -1
		If lstext$(g)>""Then 
			h=g
			g=1
		EndIf
	Next	
	For g=1 To h
		Gu_Txt$(Bn)=Gu_Txt$(Bn)+lstext$(g)+"~|"
	Next
	ObSData$(FrNo,Hit,Gu_Var(Bn))=Gu_Txt$(Bn)
	
	
	While f<=Gu_Max(Bn) And f>=0
		If f=Gu_Val(Bn) Then
			Color UserColsR(5),UserColsG(5),UserColsB(5)
			Rect 3,j,Gu_W(Bn)-6,14,1
			Color UserColsR(6),UserColsG(6),UserColsB(6)
			Text 6,j+1,Mid(lstext$(f),1,28)
		Else
			Color UserColsR(1),UserColsG(1),UserColsB(1)
			Rect 3,j,Gu_W(Bn)-6,14,1
			Color UserColsR(6),UserColsG(6),UserColsB(6)
			Text 6,j+1,Mid(lstext$(f),1,28)
		EndIf	
		f=f+1
		j=j+14
		If j>Gu_H(Bn) Then f=Gu_Max(Bn)+1
	Wend
	Color UserColsR(6),UserColsG(6),UserColsB(6)
;	Text 100,20,Str$(Int(Gu_Val(Bn)))+" "+Str$(Int(Gu_Val(sn)))	
	SetBuffer BackBuffer()
	
End Function

;**** GUI Colours
Const CGui_Bk1_R=65
Const CGui_Bk1_G=63
Const CGui_Bk1_B=65
Const CGui_Ot1_R=92
Const CGui_Ot1_G=90
Const CGui_Ot1_B=92
Const CGui_Bk2_R=29
Const CGui_Bk2_G=27
Const CGui_Bk2_B=29

Const CGui_Bk3_R=39
Const CGui_Bk3_G=37
Const CGui_Bk3_B=39

;**** GUI Types
Const Gu_Typ_ImgButton=10
Const Gu_Typ_Frame=11
Const Gu_Typ_Check=12
Const Gu_Typ_IntInput=13
Const Gu_Typ_PenInput=14
Const Gu_Typ_TextInput=15
Const Gu_Typ_TextDivider=16
Const Gu_Typ_PenInput4=17
Const Gu_Typ_Align=18
Const Gu_Typ_FuncList=19
Const Gu_Typ_Vscroller=20
Const Gu_Typ_CreateCode=21
Const Gu_Typ_Viewsize4=22
Const Gu_Typ_Text=23
Const Gu_Typ_SpecialSlider=24
Const Gu_Typ_List=25
Const Gu_Typ_Form=26
Const Gu_Typ_Tab=27
Const Gu_Typ_ConsoleList=28
Const Gu_Typ_CodeEditor=29
Const Gu_Typ_FormEditor=30
Const Gu_Typ_FileSelector=31
Const Gu_Typ_SheetImport=32
Const Gu_Typ_TextSlider=33
Const Gu_Typ_MenuBarText=34
Const Gu_Typ_Menulist=35
Const Gu_Typ_MenuBarSolid=36
Const Gu_Typ_VideoImport=37
Const Gu_Typ_TextButton=38
Const Gu_Typ_HScroller=39
Const Gu_Typ_Sheet=40

;*************************************************************
;**** Main Slection / Project Panel
Const ggProject=2
Const Gc_Do_Form_2=80
Const Gc_Do_Code_2=81
Const Gc_Do_Image_2=82
Const Gc_Do_Video_2=83
Const gProjectTab=84



;***** Form Edit
Const ggFormEdit=4
Const gFormEditFrame=140
Const gFormEditTextSlider=141
Const gFormEditLabel=142
Const gFormEditFormAdd=143
Const gFormEditFormDelete=144




;***** Form Control Selection
Const ggControlAdd=6
Const gAddCFrame=99
Const gAddControlSelect=100
Const gAddControlLabel=106
Const gAddControlTextLine=107
Const gAddControlFrame=102
Const gAddControlButton=103
Const gAddControlRadio=104
Const gAddControlCheck=105
Const gAddControlTab=113
Const gAddControlVScroll=110
Const gAddControlHScroll=111
Const gAddControlVSpinner=108
Const gAddControlHSpinner=109
Const gAddControlPaint=116
Const gAddControlBox=114
Const gAddControlImgBox=112
Const gAddControlProgress=115
Const gAddControlTimer=117
Const gAddControlCtrLabel=118
Const gAddControlDrop=119
Const gAddControlIcon=120
Const gAddControlSuper=121
Const gAddControlTextBox=122
Const gAddControlSprite=123
Const gAddControlPlayArea=124
Const gAddControlList=125

;***** Form Heirachy
Const ggFormHeir=7
Const gFormHeirTab=148

;**** Control Controls
Const ggControlProperties=8
Const gc1 = 150
Const gc2 = 151
Const gc3 = 152
Const gc4 = 153
Const gc5 = 154
Const gc6 = 155
Const gc7 = 156
Const gc8 = 157
Const gc9 = 158
Const gc10 = 159
Const gc11 = 160
Const gc12 = 161
Const gc13 = 162
Const gc14 = 163
Const gc15 = 164
Const gc16 = 165
Const gc17 = 166
Const gc18 = 167
Const gc19 = 168
Const gc20 = 169
Const gc21 = 170
Const gc22 = 171
Const gc23 = 172
Const gc24 = 173
Const gc25 = 174
Const gc26 = 175
Const gc27 = 176
Const gc28 = 177
Const gc29 = 178
Const gcControlDetails = 179
Const gcName = 180
Const gcX = 181
Const gcY = 182
Const gcW = 183
Const gcH = 184
Const gControlPrev=185
Const gControlNext=186
Const gControlFront=187
Const gControlBack=188
Const gControlDelete=189
Const gControlText=190


;***** Graphic Edit
Const ggGraphicEdit=10
Const gGraphicEditFrame=200
Const gGraphicVideoCreate=201
Const gGraphicBackdropCreate=202
Const gGraphicDivide=203
Const gGraphicsEditTextSlider=204
Const gGraphicLabel=205
Const gGraphicSheetImport=206
Const gGraphicSheetClear=207
Const gGraphicColourText=208
Const gGraphicSizeText=209
Const gGraphicWidthText=210
Const gGraphicHeightText=211
Const gGraphicExportFile=212
Const gGraphicExportCheck=213
Const gGraphicExportCheck2=214

Const ggGraphicTab=11
Const gGraphicTab=215

;***** Tile Edit
Const ggTileEdit=12
Const gTileText=220
Const gTileMemText=221
Const gTileLayout=222
Const gTileLayoutText=223
Const gTileLocked=224
Const gTileDivider=225

Const gTileXOff=226
Const gTileYOff=227
Const gTileWidth=228
Const gTileHeight=229
Const gTileXGap=230
Const gTileYGap=231

;***** Artist Edit
Const ggArtistEdit=13
;Const ggTileText=240

;**** Code Func List
Const gAddCFrame1=320
Const Gc_FuncList_11=321
Const Gc_VScroller_11=322

;**** Code Area

Const Gc_VIntelli_12=331

;***** Image Sheet Area


Const ggInfo=26
Const gInfoTab=440

Const ggConsole=27
Const gConsoleList=441

Const ggData=30
Const gDataTab=460

Const ggCodeEditor=31
Const gCodeEditor=461
Const gCodeVScroll=462
Const gCodeLn=463
Const gCodeCol=464
Const gCodeCaps=465
Const gCodeLines=466
Const gCodeCommand=467
Const gCodeCommandDesc=468
Const gCodeFind=469
Const gCodeFindButton=470
Const gCodeFindNextButton=471

Const ggFuncEditor=32
Const gFuncList=472
Const gFuncScroll=473
Const gFuncText=474

Const ggFormEditor=34
Const gFormEditor=480
Const gFormNo=481
Const gFormControlNo=482
Const gFormDispNo=483
Const gFormX=484
Const gFormY=485

Const ggSheetEditor=36
Const gSheetEditor=500
Const gSheetEditVScroll=501
Const gSheetEditHScroll=502
Const gSheetViewScale=503
Const gSheetXPos=504
Const gSheetYPos=505
Const gSheetType=506
Const gSheetTypeText=507
Const gSheetViewTiles=508

Const gSheetSelectScroll=510

;Const gFormNo=471
;Const gFormControlNo=472
;Const gFormDispNo=473
;Const gFormX=474
;Const gFormY=475


Const ggSheetImport=39
Const gSheetImport=560
Const gSheetSourceTxt=561
Const gSheetImportV=562
Const gSheetTiles=563
Const gSheetAnim2=565
Const gSheetGrpFrame=566
Const gViewSize=567
Const gSheetExact=568
Const gSheetVScroller=569
Const gSheetLoadImage=570
Const gSheetReLoadImage=571
Const gSheetClearImage=572
Const gSheetText1=573
Const gSheetText2=574
Const gSheetText3=575
Const gSheetDivider=576
Const gSheetSliderBright=577
Const gSheetSliderContrast=578
Const gSheetSliderR=579
Const gSheetSliderG=580
Const gSheetSliderB=581
Const gSheetWidth=582
Const gSheetHeight=583
Const gSheetDone=584
Const gSheetCancel=585
Const gSheetImportSize=586
Const gSheetImportSizeLabel=587

Const ggSheetColours=40
Const Gc_Pat1_23=606
Const Gc_Pat2_23=607
Const Gc_Pat3_23=608
Const Gc_Pat4_23=609
Const Gc_Pat5_23=610
Const Gc_Pat6_23=611


;**** Video Stuff
Const ggVideoImport=41
Const gVideoImport=615
Const gVideoImportV=616
Const gVideoText1=617
Const gVideoSourcetxt=618
Const gVideoDone=619
Const gVideoReset=620

Const ggVideoRecord=42
Const gVideoButton1=621
Const gVideoFPS=622

Const ggVideoOutput=43
Const gVideoSliderBright=623
Const gVideoSliderContrast=624
Const gVideoWidth=625
Const gVideoHeight=626
Const gVideoHScroller=627
Const gVideoOutput=628

Const ggVideoColours=44
Const gVideoPat1=629
Const gVideoPat2=630
Const gVideoPat3=631
Const gVideoPat4=632
Const gVideoPat5=633
Const gVideoPat6=634

Const gVideoCalc=635

;**** Settings Form
Const ggSettingsForm=45
Const gSettingsForm=640
Const gSettingsDone=659

;**** Menu Editor
Const ggMenuEditor=46
Const gMenuEditor=660
Const gMenuEditorDone=679

;**** Open File
Const ggOpenFile=47
Const gOpenFile=680
Const gOpenFiletxt=681
Const gOpenFileFile=682
Const gOpenFileOk=683
Const gOpenFileCancel=684
;**** Save As File
Const ggSaveAsFile=48
Const gSaveAsFile=690
Const gSaveAsFiletxt=691
Const gSaveAsFileFile=692
Const gSaveAsFileSave=693
Const gsaveAsFileCancel=694

Const ggFileSel=49
Const gFileSelList=720
Const gFileVScroll=721

;**** Other Main Slection
Const ggTopBar=50
Const gTopMenuSolid=730
Const gTopMenuFile=731
Const gTopMenuEdit=732
Const gTopMenuProject=733
Const gTopMenuCompile=734
Const gTopMenuOptions=735

Const gTopBarNew=741
Const gTopBarSave=742
Const gTopBarSaveAs=743
Const gTopBarClose=744
Const gTopBarSettings=745
Const gTopBarCompile=746
Const gTopBarDebugCompile=747
Const gTopBarOpen=748
Const gTopBarOutputText=749
Const gTopBarOutput=750
Const gTopBarDonate=751
Const gTopBarForum=752

Const ggFileMenu=51
Const gFileMenu=760

Const ggEditmenu=52
Const gEditMenu=761

Const ggProjectMenu=53
Const gProjectMenu=762

Const ggCompileMenu=54
Const gCompileMenu=763

Const ggOptionsMenu=55
Const gOptionsMenu=764

;ffmpeg -i k.mp4 -q:a 0 -map a k.mp3

;~IDEal Editor Parameters:
;~F#4D#66#6A#6E#72#76#9B#C6#EE#F5#FA#105#124#13B#15A#160#17F#189#1A2#1A8
;~F#1AE#1B2#1BD#1C7#1D0#1D9#1E2#1ED#1F6#213#232#23C#247#24F#257#260#268#270#278#280
;~F#28C#291#29A#2A4#2AE#2B8#2C2#2CC#2D5#2DF#2EC#2F9#304#311#3D1#3D4#3E4#434#47C#499
;~F#4BC#4EE#4F8#507#534#53E#575#585#5BD#5C4#5D7#5E4#5ED#5F6#612#62F#67A#6BF#6E3#725
;~F#759#77A#79E#7C0#7DF#7FE#80B
;~B#846#847#848#849#84A#84B#84C#84D#84E#850#851#852#855#856#857#858#859#85A#85B#85C
;~B#85D#85E#85F#860#861#862#863#864#865#866#867#868#869#86A#86B#86C#86D#86E#86F#870
;~B#871#872#873#877#878#879#87A#87B#87C#881#882#883#884#885#886#88C#88D#88E#88F#890
;~B#891#892#893#894#895#896#897#898#899#89A#89B#89C#89D#89E#89F#8A0#8A1#8A2#8A3#8A4
;~B#8A5#8A6#8A9#8AA#8AD#8AE#8AF#8B0#8B1#8B2#8B3#8B4#8B5#8B6#8B7#8B8#8B9#8BA#8BB#8BC
;~B#8BD#8BE#8BF#8C0#8C1#8C2#8C3#8C4#8C5#8C6#8C7#8C8#8C9#8CA#8CB#8CC#8CD#8CE#8CF#8D0
;~B#8D1#8D2#8D3#8D4#8D5#8D6#8DA#8DB#8DC#8DD#8DE#8DF#8E0#8E1#8E2#8E3#8E4#8E5#8E6#8E7
;~B#8E8#8E9#8EB#8EC#8EF#8F0#8F1#8F2#8F3#8F4#8F5#8F7#8F8#8F9#8FA#8FB#8FC#8FF#900#903
;~B#904#905#909#90E#90F#911#912#914#915#917#918#919#91A#91B#91C#91D#91E#91F#920#921
;~B#922#924#925#926#927#929#92A#92B#92C#92D#92E#92F#931#932#933#934#935#936#937#938
;~B#939#93A#93C#93E#93F#940#941#942#945#946#947#948#949#94A#94B#94C#94D#94E#94F#950
;~B#951#952#953#954#955#956#957#958#959#95A#95B#95C#95D#95E#95F#960#962#963#964#965
;~B#966#967#968#96C#96D#96E#96F#970#971#972#974#975#976#978#979#97A#97B#97C#97D#97E
;~B#980#981#982#983#984#985#986#988#98B#98C#98D#995#996#997#998#999#99A#99C#99D#99E
;~B#99F#9A0#9A1#9A3#9A4#9A5#9A8#9A9#9AA#9AB#9AC#9AD#9AE#9B0#9B1#9B2#9B3#9B4#9B5#9B6
;~B#9B7#9B8#9B9#9BA#9BB#9BD#9BE#9C0#9C1#9C3#9C4#9C6#9C7#9C9#9CA
;~C#Blitz3D