Function GraphicsProjectPanel()
	If formlocked>0 Then 
		DrawGraphicPanel()
		Return
	EndIf
	
	
	If CurrSheet<>Gu_Val(gGraphicsEditTextSlider) Or ForceGraphics=1 Then 
		a9=Gu_Val(gGraphicsEditTextSlider)
		Gu_Val(gTileLayout)=GrpTMethod(a9)
		Gu_Chk(gGraphicExportCheck)=GrpInclude(a9)
		Gu_Chk(gGraphicExportCheck2)=GrpInclude2(a9)
		Gu_Txt$(gGraphicExportFile)=GrpFile$(a9)
		
		If ImgScaled<>0 Then FreeImage ImgScaled
		ImgScaled=0
		CurrSheet=a9
		DrawGraphicPanel()
		GenerateTileImage()
		ForceGraphics=0
	EndIf	
	
	
	
	
	;**** Upgrade Tile Method if altered
	If GrpFile$(CurrSheet)<>Gu_Cap$(gGraphicExportFile) Then 
		GrpFile$(CurrSheet)=Gu_Txt$(gGraphicExportFile)
	EndIf	
	If GrpTMethod(CurrSheet)<>Gu_Val(gTileLayout) Then
		GrpTMethod(CurrSheet)=Gu_Val(gTileLayout)
		GenerateTileImage()
	EndIf	
	
	If GrpInclude(CurrSheet)<>Gu_Chk(gGraphicExportCheck) Or GrpInclude2(CurrSheet)<>Gu_Chk(gGraphicExportCheck2) Then 
		GrpInclude(CurrSheet)=Gu_Chk(gGraphicExportCheck)
		GrpInclude2(CurrSheet)=Gu_Chk(gGraphicExportCheck2)
	EndIf
	If GrpTOffX(CurrSheet)<>Gu_Val(gTileXOff) Or GrpTOffY(CurrSheet)<>Gu_Val(gTileYOff) Then 
		GrpTOffX(CurrSheet)=Gu_Val(gTileXOff)
		GrpTOffY(CurrSheet)=Gu_Val(gTileYOff)
		GenerateTileImage()
	EndIf
	If GrpTGridWid(CurrSheet)<>Gu_Val(gTileWidth) Or GrpTGridHei(CurrSheet)<>Gu_Val(gTileHeight)Then 
		GrpTGridWid(CurrSheet)=Gu_Val(gTileWidth)
		GrpTGridHei(CurrSheet)=Gu_Val(gTileHeight)
		GenerateTileImage()
	EndIf
	If GrpTGapX(CurrSheet)<>Gu_Val(gTileXGap)Or GrpTGapY(CurrSheet)<>Gu_Val(gTileYGap)Then 
		GrpTGapX(CurrSheet)=Gu_Val(gTileXGap)
		GrpTGapY(CurrSheet)=Gu_Val(gTileYGap)
		GenerateTileImage()
	EndIf
	
	
	
	If ImgPrimary<>Gu_Val(gSheetType)Then 
		If ImgScaled<>0 Then FreeImage ImgScaled
		ImgScaled=0
		ImgPrimary=Gu_Val(gSheetType)
	EndIf
	If GrpWid(CurrSheet)>0 Then
		a=1
		If GrpPat(CurrSheet)Mod 2=0 Then
			Gu_Cap(gGraphicColourText)="Colour Depth: 16"
			a=2
		Else
			Gu_Cap(gGraphicColourText)="Colour Depth: 4"
		EndIf	
		Gu_Cap(gGraphicSizeText)="Size in Bytes: "+Str$((GrpWid(CurrSheet)*GrpHei(CurrSheet)*a)/2)
		Gu_Cap(gGraphicWidthText)="Pixel Width: "+Str$(GrpWid(CurrSheet)*2)
		Gu_Cap(gGraphicHeightText)="Pixel Height: "+Str$(GrpHei(CurrSheet))
		Gg_Vis(ggGraphicTab)=1
	Else
		Gu_Cap(gGraphicColourText)="Colour Depth: ---"
		Gu_Cap(gGraphicSizeText)="Size in Bytes: ---"
		Gu_Cap(gGraphicWidthText)="Pixel Width: ---"
		Gu_Cap(gGraphicHeightText)="Pixel Height: ---"
	EndIf
	If ImgViewSize <> Gu_Val(gSheetViewScale)Then
		s#=ImgViewSize/Gu_Val(gSheetViewScale)
		Gu_Val(gSheetEditVScroll)=Gu_Val(gSheetEditVScroll)/s#
		Gu_Val(gSheetEditHScroll)=Gu_Val(gSheetEditHScroll)/s#
		ImgViewSize=Gu_Val(gSheetViewScale)
		If ImgScaled<>0 Then FreeImage ImgScaled
		ImgScaled=0
	EndIf
	
	
	
	x1=Gg_X(ggSheetEditor)+ImgViewX+20
	y1=Gg_Y(ggSheetEditor)+ImgViewY+24
	
	If MouseX()>=x1 And MouseY()>=y1 And MouseX()<x1+ImgViewW And MouseY()<y1+ImgViewH Then
		ImgXMouse=((MouseX()-x1)+ImgViewXOff)/(ImgViewSize*2)
		ImgYmouse=((MouseY()-y1)+ImgViewYOff)/(ImgViewSize*2)
		Gu_Cap(gSheetXPos)="X: "+Str$(ImgXMouse)
		Gu_Cap(gSheetYPos)="Y: "+Str$(ImgYmouse)
		
		
		;ImgPrimary=1
	Else
		Gu_Cap(gSheetXPos)="X: -"
		Gu_Cap(gSheetYPos)="Y: -"
		ImgXMouse=-1
		ImgYmouse=-1
	EndIf
	DrawGraphicPanel()
	
	x5=Gg_X(ggSheetEditor)+Gg_W(ggSheetEditor)-160
	y5=MouseY()-(Gg_Y(ggSheetEditor)+20)
	If MouseDown(1) Then 
		If MouseX()>x5 And MouseX()<x5+110 And y5=>0 And y5<Gg_H(ggSheetEditor)-60 Then 
			Gu_Val(gGraphicsEditTextSlider)=Int(y5/110)+Gu_Val(gSheetSelectScroll)+1
			Repeat 
				Delay 1
			Until Not(MouseDown(1))
			If CurrSheet=Gu_Val(gGraphicsEditTextSlider) And GrpWid(CurrSheet)=0 Then
				formlocked=ggSheetImport
				Gg_Vis(ggSheetImport)=1
				Gg_Vis(ggSheetColours)=1
				Gg_Vis(ggFileSel)=1
				FillFileSelector(CDir$+"\graphics","BMP|PNG|JPG")
				SheetImportForm()
			EndIf
			Gu_Txt$(gGraphicExportFile)=GrpFile$(Gu_Val(gGraphicsEditTextSlider))
			ForceGraphics=1
		EndIf
	EndIf
	
End Function

Function DrawGraphicPanel()
	SetBuffer ImageBuffer(Gu_ImgHandle(gSheetEditor))
	Color CGui_Bk3_R,CGui_Bk3_G,CGui_Bk3_B
	
	w9=Gu_W(gSheetEditor)-240
	h9=Gu_H(gSheetEditor)-74
	Rect 0,0,w9+16,h9+24
	w=Gu_Val(gGraphicsEditTextSlider)
	If GrpWid(w)>0 Then
		If ImgScaled=0 Then
			ImgScaled=ScaleImageFast(GrpCImg(w,ImgPrimary-1), Gu_Val(gSheetViewScale), Gu_Val(gSheetViewScale))
			
			;Generate Tile Image
			GenerateTileImage()
			SetBuffer ImageBuffer(Gu_ImgHandle(gSheetEditor))
			
		EndIf
		If ImgScaled>0 Then 
			h8=ImageHeight(ImgScaled)
			w8=ImageWidth(ImgScaled)
			
			Gu_Shw(gSheetEditVScroll)=h9
			If h8<=h9 Then
				Gu_Max(gSheetEditVScroll)=h9
				Gu_Val(gSheetEditVScroll)=1
			Else
				Gu_Max(gSheetEditVScroll)=h8
			EndIf
			If h8>h9 Then 
				h7=h9
			Else
				h7=h8
			EndIf
			Gu_Shw(gSheetEditHScroll)=w9
			If w8<=w9 Then
				Gu_Max(gSheetEditHScroll)=w9
				Gu_Val(gSheetEditHScroll)=1
			Else
				Gu_Max(gSheetEditHScroll)=w8
			EndIf
			If w8>w9 Then 
				w7=w9
			Else
				w7=w8
			EndIf		
			
			w6=Int((w9/2)-(w7/2))+8
			h6=Int((h9/2)-(h7/2))+8
			
			w5=Gu_Val(gSheetEditHScroll)
			h5=Gu_Val(gSheetEditVScroll)
			
			w5=w5-(w5 Mod (ImgViewSize*2))
			h5=h5-(h5 Mod (ImgViewSize*2))		
			DrawImageRect ImgScaled,w6,h6,w5,h5,w7,h7
			If Gu_Chk(gSheetViewTiles) Then 
				If ImgTiled<>0 Then DrawImageRect ImgTiled,w6,h6,w5,h5,w7,h7
			EndIf	
			ImgViewX=w6:ImgViewY=h6
			ImgViewXOff=w5:ImgViewYOff=h5
			ImgViewW=w7:ImgViewH=h7
			
			If w5>ImageWidth(ImgScaled) Or h5>ImageHeight(ImgScaled) Then
				Gu_Val(gSheetEditHScroll)=1
				Gu_Val(gSheetEditVScroll)=1
			EndIf	
			
			If ImgXMouse>-1 Then
				a1=ImgViewSize*2
				x1=w6+((ImgXMouse*ImgViewSize*2)-w5)
				y1=h6+((ImgYmouse*ImgViewSize*2)-h5)
				Color 255,255,255
				Rect x1-1,y1-1,a1+2,a1+2,0
				Color 0,0,0
				Rect x1,y1,a1,a1,0
				Rect x1-2,y1-2,a1+4,a1+4,0
			EndIf
		EndIf
	EndIf
	
	SetBuffer BackBuffer()
	
End Function
Function GenerateTileMap()
	
	Gu_Val(gTileXOff)=GrpTOffX(CurrSheet)
	Gu_Val(gTileYOff)=GrpTOffY(CurrSheet)
	Gu_Val(gTileWidth)=GrpTGridWid(CurrSheet)
	Gu_Val(gTileHeight)=GrpTGridHei(CurrSheet)
	Gu_Val(gTileXGap)=GrpTGapX(CurrSheet)
	Gu_Val(gTileYGap)=GrpTGapY(CurrSheet)	
	
	a1=GrpCImg(CurrSheet,0)
	ih=(ImageHeight(a1)/2)
	iw=(ImageWidth(a1)/2)
	h1=GrpTGridHei(CurrSheet)
	w1=GrpTGridWid(CurrSheet)
	y1=GrpTOffY(CurrSheet)
	b1=0
	c1=0
	c2=0
	t1=0
	
	
	While y1+h1<=ih And t1<255
		x1=GrpTOffX(CurrSheet)
		While x1+w1<=iw And t1<255
			GrpTX(CurrSheet,t1)=x1
			GrpTY(CurrSheet,t1)=y1
			GrpTWid(CurrSheet,t1)=w1
			GrpTHei(CurrSheet,t1)=h1
			
			b1=((w1 Shr 1)+(w1 Mod 2))
			If (b1 Mod 2)=1 Then b1=b1+1
			b1=(b1*h1)+10
			GrpT16Byte(CurrSheet,t1)=b1
			c1=c1+b1
			
			b1=w1 Shr 2
			If w1 Mod 4<>0 Then b1=b1+1
			If (b1 Mod 2)=1 Then b1=b1+1
			b1=(b1*h1)+10
			GrpT4Byte(CurrSheet,t1)=b1
			c2=c2+b1
			
			x1=x1+w1+GrpTGapX(CurrSheet)
			t1=t1+1
		Wend
		y1=y1+h1+GrpTGapY(CurrSheet)
	Wend
	GrpTNo(CurrSheet)=t1
	GrpT16BytesTot(CurrSheet)=c1
	GrpT4BytesTot(CurrSheet)=c2	
	Gu_Cap(gTileText)="Tile Count: "+Str(t1)
	Gu_Cap(gTileMemText)="Bytes: "+Str(c1)+" & "+Str(c2)	
	
End Function

Function GenerateTileImage()
	If GrpWid(CurrSheet)>0 Then
		
		If Gu_Val(gTileLayout)=2 Then
			GenerateTileMap()
		Else
			iw=ImageWidth(GrpCImg(CurrSheet,0))/2
			ih=ImageHeight(GrpCImg(CurrSheet,0))/2
			GrpTX(CurrSheet,0)=0
			GrpTY(CurrSheet,0)=0
			
			GrpTWid(CurrSheet,0)=iw
			GrpTHei(CurrSheet,0)=ih
			GrpTNo(CurrSheet)=1
			
			b1=((iw Shr 1)+(iw Mod 2))
			If (b1 Mod 2)=1 Then b1=b1+1
			b1=(b1*ih)+10
			GrpT16Byte(CurrSheet,0)=b1
			
			b1=iw Shr 2
			If iw Mod 4<>0 Then b1=b1+1
			If (b1 Mod 2)=1 Then b1=b1+1
			b1=(b1*ih)+10
			GrpT4Byte(CurrSheet,0)=b1
			
			GrpT16BytesTot(CurrSheet)=GrpT16Byte(CurrSheet,0)
			GrpT4BytesTot(CurrSheet)=GrpT4Byte(CurrSheet,0)
			
			Gu_Cap(gTileText)="Tile Count: "+Str(1)
			Gu_Cap(gTileMemText)="Bytes : "+Str(GrpT16BytesTot(CurrSheet))+"/"+Str(GrpT4BytesTot(CurrSheet))
		EndIf	
		If ImgTiled<>0 Then FreeImage ImgTiled
		ImgTiled=CreateImage(ImageWidth(ImgScaled),ImageHeight(ImgScaled))
		SetBuffer ImageBuffer(ImgTiled)
		a1=ImgViewSize*2
		Color 90,90,90
		For f=0 To GrpTNo(CurrSheet)-1
			Rect GrpTX(CurrSheet,f)*a1,GrpTY(CurrSheet,f)*a1,GrpTWid(CurrSheet,f)*a1,GrpTHei(CurrSheet,f)*a1,0
		Next
	EndIf
End Function

Function SheetImportForm()
	;*** Import File
	ImageAltered=0
	Gg_X(ggFileSel)=Gg_X(ggSheetImport)+550
	Gg_Y(ggFileSel)=Gg_Y(ggSheetImport)+44
	
	If Gu_Evt(gSheetCancel) Then
		formlocked=0
		Return
	EndIf
	If Gu_Evt(gSheetDone) Then
		If ShtNo>0 Then 
			w=Gu_Val(gGraphicsEditTextSlider)
			GrpWid(w)=Gu_Val(gSheetWidth)
			GrpHei(w)=Gu_Val(gSheetHeight)
			FreeImage GrpCImg(w,0)
			GrpCImg(w,0)=CreateImage(GrpWid(w)*4,GrpHei(w)*2)
			ConvertSheetImage(ShtNo,GrpWid(w),GrpHei(w),0,GrpCImg(w,0))
			
			p1=PattType
			If PattType Mod 2=0 Then 
				PattType=PattType-1
			Else
				PattType=PattType+1
			EndIf
			FreeImage GrpCImg(w,1)
			GrpCImg(w,1)=CreateImage(GrpWid(w)*4,GrpHei(w)*2)
			ConvertSheetImage(ShtNo,GrpWid(w),GrpHei(w),0,GrpCImg(w,1))
			PattType=p1
			FreeImage GrpCImg(w,2)
			GrpCImg(w,2)=CreateImage(128,128)
			ConvertSheetImage2(ShtNo,50,100,0,GrpCImg(w,2))
			
			GrpName$(w)="Sheet"+Str$(w)
			GrpFile$(w)="Sheet"+Str$(w)
			GrpPat(w)=PattType
			GrpInclude(w)=1
			
			
			
			
			GrpTMethod(w)=1
			GrpTOffX(w)=0
			GrpTOffY(w)=0
			GrpTGapX(w)=0
			GrpTGapY(w)=0
			GrpTGridWid(w)=8
			GrpTGridHei(w)=8
			
			Gu_Val(gTileLayout)=GrpTMethod(w)
			Gu_Txt$(gGraphicExportFile)=GrpFile$(w)
			ImgScaled=0
			ImgScaled=ScaleImageFast(GrpCImg(w,ImgPrimary-1), Gu_Val(gSheetViewScale), Gu_Val(gSheetViewScale))
			GenerateTileMap()
			
		EndIf
		formlocked=0
		Return
	EndIf	
	
	If Gu_Evt(gFileSelList)=1 Then
		filename$=CDir$+"Graphics\"+FileLst(Gu_Min(gFileSelList))
		ShtNo=SheetImportGraphic(FileName$,64)
		If ShtNo>0 Then
			Select Gu_Val(gSheetImportSize)
				Case 1
					x1=GrpWid(ShtNo)/2.0
					y1=GrpHei(ShtNo)
					If x1>256 Then x1=256
					If y1>256 Then y1=256
				Case 2
					x1=256
					y1=212
				Case 3
					x1=128
					y1=212
				Case 4
					x1=160
					y1=200
				Case 5
					x1=128
					y1=256
			End Select		
			Gu_Val(gSheetWidth)=x1
			Gu_Val(gSheetHeight)=y1
			ConvertSheetImage(ShtNo,Gu_Val(gSheetWidth),Gu_Val(gSheetHeight),0,Gu_ImgHandle(gSheetImportV))
		EndIf
	EndIf	
	
	
	
	If ShtNo>0 Then
		If Gu_Sel(Gc_Pat1_23)=1 Then PattType=1
		If Gu_Sel(Gc_Pat2_23)=1 Then PattType=2
		If Gu_Sel(Gc_Pat3_23)=1 Then PattType=3
		If Gu_Sel(Gc_Pat4_23)=1 Then PattType=4
		If Gu_Sel(Gc_Pat5_23)=1 Then PattType=5
		If Gu_Sel(Gc_Pat6_23)=1 Then PattType=6
		If PattType<>OldPattType Then ImageAltered=1:OldPattType=PattType
		
		If Gu_Val(gSheetSliderR)<>GrpCR#(ShtNo,ConType2) Then ImageAltered=1
		If Gu_Val(gSheetSliderG)<>GrpCG#(ShtNo,ConType2) Then ImageAltered=1
		If Gu_Val(gSheetSliderB)<>GrpCB#(ShtNo,ConType2) Then ImageAltered=1
		
		If Gu_Val(gSheetSliderContrast)<>GrpCCont#(ShtNo,ConType2) Then ImageAltered=1
		If Gu_Val(gSheetSliderBright)<>GrpCBright#(ShtNo,ConType2) Then ImageAltered=1
		
		If Gu_Val(gSheetWidth)<>GrpCWid(ShtNo,ConType2) Then ImageAltered=1:Gu_W(gSheetWidth)=Gu_Val(gSheetWidth)
		If Gu_Val(gSheetHeight)<>GrpCHei(ShtNo,ConType2) Then ImageAltered=1:Gu_H(gSheetHeight)=Gu_Val(gSheetHeight)
	EndIf
	
	If ImageAltered=1 Then
		ConvertSheetImage(ShtNo,Gu_Val(gSheetWidth),Gu_Val(gSheetHeight),0,Gu_ImgHandle(gSheetImportV))
		ImageAltered=0
	EndIf
End Function
Function SheetImportGraphic(FileName$,n=0)
	AddNewLog("IMPORTING "+FileName$+"...",1)
	Gu_Draw()
	;Find Empty Sheet Slot
	If n=0 Then 
		For f=1 To 63
			If GrpImage(f)=0 Then
				n=f
				f=65
			EndIf	
		Next
	EndIf
	c=ImportGraphic2(FileName$,n)
	If c=1 Then
		AddNewLog("Import Successful",1)
	Else
		AddNewLog("**** Import Failed **** ",1)
		n=0
	EndIf
	Gu_Draw()
	Return n
	
End Function

Function VideoImportForm()
	Gg_X(ggFileSel)=Gg_X(ggVideoImport)+550
	Gg_Y(ggFileSel)=Gg_Y(ggVideoImport)+44
	
	
	If Gu_Evt(gFileSelList)=1 Then
		If Vid_handle>0 Then 
			CloseMovie(Vid_handle)
			CloseFile vid_file
		EndIf	
		
		Vid_PixWid=512
		Vid_PixHei=400
		vid_imgwid=Vid_PixWid
		vid_imghei=Vid_PixHei
		
		imgMovie=CreateImage(Vid_PixWid,Vid_PixHei)
		MaskImage imgMovie,255,0,255
		
		video_file=FileLst(Gu_Min(gFileSelList))
		Vid_handle=OpenMovie(CDir$+"Video\"+video_file)
		vid_bank=CreateBank(Vid_PixWid*Vid_PixHei*3)
		
		Vid_FPS=Gu_Val(gVideoFPS)
		Vid_q2=1000/Vid_FPS
		Vid_q3=MilliSecs()
		Vid_q4=MilliSecs()+1000
		Vid_secs=0
		Vid_Mins=0
		Vid_CapFrame=0
		vid_file=WriteFile("Video\testfile.smf")
		WriteByte(vid_file,"s"):WriteByte(vid_file,"y"):WriteByte(vid_file,"m"):WriteByte(vid_file,"b")
		WriteByte(vid_file,"o"):WriteByte(vid_file,"s"):WriteByte(vid_file,"v"):WriteByte(vid_file,"i")
		WriteByte(vid_file,"d"):WriteByte(vid_file,"e"):WriteByte(vid_file,"o"):WriteByte(vid_file,"f")
		WriteByte(vid_file,"i"):WriteByte(vid_file,"l"):WriteByte(vid_file,"e"):WriteByte(vid_file,"1")			
		WriteInt(vid_file,1000)
		WriteInt(vid_file,Vid_q2)		
		WriteInt(vid_file,Vid_PixWid)
		WriteInt(vid_file,Vid_PixHei)
		
		Gu_Evt(gFileSelList)=0
		Gu_ImgHandle(gVideoImportV)=imgMovie
		
	EndIf
	
	If Gu_Evt(gVideoDone) Then
		If Vid_handle<>0 Then 
			CloseMovie(Vid_handle)
		EndIf
		
		formlocked=0
		Return
	EndIf	
	
	;**** Get Video into file
	If Vid_handle>0 Then
		Gg_Vis(ggVideoRecord)=1
		If MoviePlaying(Vid_handle)=True And Gu_Evt(gVideoButton1)=0 Then
			SetBuffer ImageBuffer(imgMovie)
			DrawMovie Vid_handle,0,0,Vid_PixWid,Vid_PixHei
			SetBuffer BackBuffer()
			If Vid_q3<=MilliSecs()Then
				Vid_q3=Vid_q3+Vid_q2
				Vid_CapFrame=Vid_CapFrame+1
				c=0
				SetBuffer ImageBuffer(imgMovie)
				LockBuffer ImageBuffer(imgMovie)
				For Y=0 To Vid_PixHei-1 Step 2
					For X=0 To Vid_PixWid-1 Step 2
						a=ReadPixelFast(X,Y)
						;b=Int(((a Shr 16)And 255) Shr 3)
						;g=Int(((a Shr 8)And 255)Shr 3)
						;r=Int((a And 255) Shr 3)
						;b=(((a And 255) Shr 3) Shl 10)+((((a Shr 8)And 255)Shr 3) Shl 5)+((a Shr 16)And 255) Shr 3
						PokeShort vid_bank,c,(((a And 255) Shr 3) Shl 10)+((((a Shr 8)And 255)Shr 3) Shl 5)+((a Shr 16)And 255) Shr 3
						c=c+2
					Next
				Next
				
				UnlockBuffer ImageBuffer(imgMovie)
				SetBuffer BackBuffer()
				WriteBytes vid_bank,vid_file,0,c
				Gu_Cap$(gVideoText1)="- Captured: "+Str$(Vid_CapFrame)+" frames - @ "+Str$(Vid_FPS)+" FPS -"
				Gu_Cap$(gVideoButton1)="Stop Capture"
			EndIf
			
			If Vid_q4<=MilliSecs()Then
				Vid_q4=MilliSecs()+1000
				Vid_secs=Vid_secs+1
				If Vid_secs>59 Then
					Vid_secs=0
					Vid_Mins=Vid_Mins+1
				EndIf	
			EndIf
		Else
			CloseMovie(Vid_handle)
			CloseFile vid_file
			vid_file=0
			Vid_handle=0
			Gu_Max(gVideoHScroller)=Vid_CapFrame-1
			Gu_Min(gVideoHScroller)=0
			Gu_Val(gVideoHScroller)=0
			vid_update=-1
			vid_output=0
		EndIf
	Else		
		If Vid_handle=0 And Vid_CapFrame>0 Then
			
			If vid_output>0 Then 
				;**** We are Outputting video
				
				NewInt#=(Gu_Val(gVideoSliderContrast)/64)
				NewBright#=(Gu_Val(gVideoSliderBright)*2)-128
				
				b=(Vid_PixHei/2)*(Vid_PixWid)
				a=(Int(vid_output)*b)+32
				SeekFile vid_file,a
				ReadBytes vid_bank,vid_file,0,b
				
				;**** Convert to Image
				LockBuffer ImageBuffer(imgMovie)
				SetBuffer ImageBuffer(imgMovie)
				xw=(Int(Gu_Val(gVideoWidth)) Shr 1)Shl 1
				vid_imgwid=xw*2
				vid_imghei=Gu_Val(gVideoHeight)*2
				w2#=Vid_PixWid/Gu_Val(gVideoWidth)
				h2#=Vid_PixHei/Gu_Val(gVideoHeight)
				n9=0
				For f=0 To Gu_Val(gVideoHeight)-1
					d=(Int(f*h2#)Shr 1)*Vid_PixWid; Int(f*h2#)*Vid_PixWid
					For g=0 To xw-1
						a=PeekShort(vid_bank,((Int(g*w2#)Shr 1)Shl 1)+d)
						tr1=((a And 31)*8)
						tg1=(((a And 992)Shr 5)*8)
						tb1=(((a And 31744)Shr 10)*8)
						r2=Floor(((tr1-128)*NewInt#)+NewBright#)
						If r2<0 Then r2=0
						If r2>255 Then r2=255		
						g2=Floor(((tg1-128)*NewInt#)+NewBright#)
						If g2<0 Then g2=0
						If g2>255 Then g2=255
						b2=Floor(((tb1-128)*NewInt#)+NewBright#)
						If b2<0 Then b2=0
						If b2>255 Then b2=255
						r2=r2 Shr 4
						g2=g2 Shr 4
						b2=b2 Shr 4
						b8=(r2 Shl 8) + (g2 Shl 4) + b2
						b1=Patt16(b8,(g And 7)+((f And 7)*8),PattType)
						
						ColourLine(g)=b1
						
						If(vid_output Mod Vid_FPS)=1 Then 
							b3=OS_Col(b1)
							ge=g Shl 1
							fe=f Shl 1
							WritePixelFast ge,fe,b3
							WritePixelFast ge+1,fe,b3
							WritePixelFast ge,fe+1,b3
							WritePixelFast ge+1,fe+1,b3
						EndIf 
					Next
					
					;Output the data in correct method
					c1=0
					For g=1 To Video_PixWidByte
						If Video_Colour=0 Then 
							j=(ColourLine(c1+1)And 15)+((ColourLine(c1)And 15)Shl 4)
							;j0=(j And 1)				;Pixel 1 - Bit 0
							;j1=(j And 2)Shr 1			;Pixel 1 - Bit 1
							;j2=(j And 4)Shr 2			;Pixel 1 - Bit 2
							;j3=(j And 8)Shr 3			;Pixel 1 - Bit 3
							;j4=(j And 16)Shr 4			;Pixel 0 - Bit 0
							;j5=(j And 32)Shr 5			;Pixel 0 - Bit 1
							;j6=(j And 64)Shr 6			;Pixel 0 - Bit 2
							;j7=(j And 128)Shr 7			;Pixel 0 - Bit 3
							;j=(j4 Shl 7)+(j5 Shl 3)+(j6 Shl 5)+(j7 Shl 1)+(j0 Shl 6)+(j1 Shl 2)+(j2 Shl 4)+(j3)
							;j=(j4 Shl 7)+(j5 Shl 3)+(j6 Shl 5)+(j7 Shl 1)+(j0 Shl 6)+(j1 Shl 2)+(j2 Shl 4)+(j3)
							c1=c1+2
						Else
							j=(ColourLine(c1)And 3)+((ColourLine(c1+1)And 3)Shl 2)+((ColourLine(c1+2)And 3)Shl 4)+((ColourLine(c1+3)And 3)Shl 6)
							j0=(j And 1)				;Pixel 3 - Bit 0
							j1=(j And 2)Shr 1 			;Pixel 3 - Bit 1
							j2=(j And 4)Shr 2			;Pixel 2 - Bit 0
							j3=(j And 8)Shr 3			;Pixel 2 - Bit 1
							j4=(j And 16)Shr 4			;Pixel 1 - Bit 0
							j5=(j And 32)Shr 5			;Pixel 1 - Bit 1
							j6=(j And 64)Shr 6			;Pixel 0 - Bit 0
							j7=(j And 128)Shr 7			;Pixel 0 - Bit 1
							j=(j6 Shl 7)+(j7 Shl 3)+(j4 Shl 6)+(j5 Shl 2)+(j2 Shl 5)+(j3 Shl 1)+(j0 Shl 4)+(j1)	
							c1=c1+4
						EndIf		
						WriteByte(OutputFile,j)
					Next
				Next
				For g=1 To Video_FramePad
					WriteByte(OutputFile,0)
				Next
				
				UnlockBuffer ImageBuffer(imgMovie)
				SetBuffer BackBuffer()
				
				Gu_Cap$(gVideoText1)="- Outputing Frame "+Str$(vid_output)+"/"+Str$(Vid_CapFrame)+" -"
				Gu_Cap$(gVideoButton1)="Stop Output"
				
				If vid_output=>Vid_CapFrame Then
					vid_output=0
					CloseFile OutputFile
				Else
					vid_output=vid_output+1
				EndIf
				
			Else	
				If Gu_Evt(gVideoOutput)=1 Then 
					vid_output=1
					ChangeDir(CDir$+"video")
					video_fileout$=Mid$(video_file$,1,Len(video_file$)-3)+"mp3"
					DeleteFile video_fileout$
					ExecFile("ffmpeg -i "+video_file$+" -b:a 32k "+video_fileout$)
					ChangeDir(CDir$)
					
					video_fileout$=Mid$(video_file$,1,Len(video_file$)-3)+"vid"
					OutputFile=WriteFile(CDir$+"Video\"+video_fileout$)
					
					Video_Colour=PattType Mod 2
					If Video_Colour=0 Then 
						Video_PixWidByte=((Gu_Val(gVideoWidth)-1)Shr 1)+1
					Else
						Video_PixWidByte=((Gu_Val(gVideoWidth)-1)Shr 2)+1
					EndIf
					
					s=0
					WriteByte(OutputFile,Asc("S")):s=s+1
					WriteByte(OutputFile,Asc("y")):s=s+1
					WriteByte(OutputFile,Asc("m")):s=s+1
					WriteByte(OutputFile,Asc("V")):s=s+1
					WriteByte(OutputFile,Asc("i")):s=s+1
					WriteByte(OutputFile,Asc("d")):s=s+1
					WriteByte(OutputFile,Asc("1")):s=s+1
					WriteByte(OutputFile,Asc("0")):s=s+1
					WriteByte(OutputFile,0):s=s+1
					WriteByte(OutputFile,0)	:s=s+1													;Crunch
					WriteByte(OutputFile,Int(Vid_FPS)):s=s+1											;Frames Per second
					WriteByte(OutputFile,Vid_CapFrame Mod 256)	:s=s+1								;Number of Frames Low
					WriteByte(OutputFile,(Vid_CapFrame/256)Mod 256)	:s=s+1							;Number of Frames Middle
					WriteByte(OutputFile,(Vid_CapFrame/65536)Mod 256):s=s+1							;Number of Frames High
					
					WriteShort(OutputFile,Gu_Val(gVideoWidth)):s=s+2
					WriteShort(OutputFile,Gu_Val(gVideoHeight)):s=s+2								;Height in Pixels
					If Video_Colour=0 Then 
						WriteByte(OutputFile,7)	:s=s+1												;MSX Mode
					Else
						WriteByte(OutputFile,1)	:s=s+1												;CPC Mode
					EndIf
					For f=0 To 15
						a0=(OS_Red(f)Shl 4) And 15
						a1=(OS_Green(f)Shl 4) And 15
						a2=(OS_Blue(f)Shl 4) And 15
						a=a0+(a1*16)+(a2*256)
						WriteShort(OutputFile,a)	
						s=s+2				;Colour
					Next
					a=((Video_PixWidByte*Gu_Val(gVideoHeight)) And 65024)+512
					Video_FramePad=a-(Video_PixWidByte*Gu_Val(gVideoHeight))
					WriteShort(OutputFile,a)				;Size of Frame
					s=s+2
					WriteByte(OutputFile,0)						;number for languages
					s=s+1
					For f=1 To 8
						For g=1 To 16
							WriteByte(OutputFile,0)						;number for languages
							s=s+1
						Next	
					Next
					;Movie name
					For f=0 To 31
						WriteByte(OutputFile,0)						;number for languages
						s=s+1
					Next
					;Movie Info
					For f=0 To 31
						WriteByte(OutputFile,0)						;number for languages
						s=s+1
					Next
					WriteByte(OutputFile,(Video_Colour+1)Mod 2)
					s=s+1
					s1=s
					For f=1 To (512-s1)
						WriteByte(OutputFile,0)
						s=s+1
					Next
					Return
				EndIf 	
				If vid_file=0 Then
					vid_file=ReadFile("Video\testfile.smf")
				EndIf
				ImageAltered=0
				If Gu_Sel(gVideoPat1)=1 Then PattType=1
				If Gu_Sel(gVideoPat2)=1 Then PattType=2
				If Gu_Sel(gVideoPat3)=1 Then PattType=3
				If Gu_Sel(gVideoPat4)=1 Then PattType=4
				If Gu_Sel(gVideoPat5)=1 Then PattType=5
				If Gu_Sel(gVideoPat6)=1 Then PattType=6
				
				
				If Gu_Evt(gVideoCalc)=1 Then
					Testcount=0
					;NewInt#=(Gu_Val(gVideoSliderContrast)/64)
					;NewBright#=(Gu_Val(gVideoSliderBright)*2)-128
					
					b=(Vid_PixHei/2)*(Vid_PixWid)
					a=(Int(Gu_Val(gVideoHScroller))*b)+32
					SeekFile vid_file,a
					ReadBytes vid_bank,vid_file,0,b
					
				;**** Convert to Image
					LockBuffer ImageBuffer(imgMovie)
					SetBuffer ImageBuffer(imgMovie)
					
					
					
					xw=(Int(Gu_Val(gVideoWidth)) Shr 1)Shl 1
					
					vid_imgwid=xw*2
					vid_imghei=Gu_Val(gVideoHeight)*2
					
					
					w2#=Vid_PixWid/Gu_Val(gVideoWidth)
					h2#=Vid_PixHei/Gu_Val(gVideoHeight)
					
					y1=0
					For f=0 To Gu_Val(gVideoHeight)-1
						x1=0
						
						d=(Int(f*h2#)Shr 1)*Vid_PixWid
						fe=f Shl 1
						For g=0 To xw-1
							a=PeekShort(vid_bank,((Int(g*w2#)Shr 1)Shl 1)+d)
							;tr1=((a And 31)*8)
							;tg1=(((a And 992)Shr 5)*8)
							;tb1=(((a And 31744)Shr 10)*8)
							r2=Floor(((((a And 31)Shl 3)-128)*NewInt#)+NewBright#)
							If r2<0 Then r2=0
							If r2>255 Then r2=255		
							g2=Floor((((((a And 992)Shr 5)Shl 3)-128)*NewInt#)+NewBright#)
							If g2<0 Then g2=0
							If g2>255 Then g2=255
							b2=Floor((((((a And 31744)Shr 10) Shl 3)-128)*NewInt#)+NewBright#)
							If b2<0 Then b2=0
							If b2>255 Then b2=255
							
							b3=OS_Col(Patt16(((r2 Shr 4) Shl 8) + ((g2 Shr 4) Shl 4) + (b2 Shr 4),(g And 7)+((f And 7)*8),PattType))
							
							ge=g Shl 1
							
							
							scarray(x1,y1)=b3
							x1=x1+1
						Next
						y1=y1+1
					Next
					
					
					For f=0 To y1 Step 2
						For g=0 To x1 Step 8
							a=Testcount
							For f1=0 To 1
								For g1=0 To 7
									test(a,g1,f1)=scarray(g1+g,f1+f)
								Next
							Next
							foundone=0
							For h=0 To Testcount-1
								c=0
								For f1=0 To 1
									For g1=0 To 7
										If test(a,g1,f1)<>test(h,g1,f1) Then c=1
									Next
								Next
								If c=0 Then foundone=1
							Next
							If foundone=0 Then Testcount=Testcount+1
						Next
					Next	
					
					UnlockBuffer ImageBuffer(imgMovie)
					SetBuffer BackBuffer()
					
				EndIf				
				
				
				If PattType<>OldPattType Then ImageAltered=1:OldPattType=PattType
				If vid_update<>Gu_Val(gVideoHScroller) Then ImageAltered=1
				
				If ImageAltered=1 Then
					NewInt#=(Gu_Val(gVideoSliderContrast)/64)
					NewBright#=(Gu_Val(gVideoSliderBright)*2)-128
					
					b=(Vid_PixHei/2)*(Vid_PixWid)
					a=(Int(Gu_Val(gVideoHScroller))*b)+32
					SeekFile vid_file,a
					ReadBytes vid_bank,vid_file,0,b
					
				;**** Convert to Image
					LockBuffer ImageBuffer(imgMovie)
					SetBuffer ImageBuffer(imgMovie)
					
					
					
					xw=(Int(Gu_Val(gVideoWidth)) Shr 1)Shl 1
					
					vid_imgwid=xw*2
					vid_imghei=Gu_Val(gVideoHeight)*2
					
					
					w2#=Vid_PixWid/Gu_Val(gVideoWidth)
					h2#=Vid_PixHei/Gu_Val(gVideoHeight)
					
					For f=0 To Gu_Val(gVideoHeight)-1
						d=(Int(f*h2#)Shr 1)*Vid_PixWid
						fe=f Shl 1
						For g=0 To xw-1
							a=PeekShort(vid_bank,((Int(g*w2#)Shr 1)Shl 1)+d)
							;tr1=((a And 31)*8)
							;tg1=(((a And 992)Shr 5)*8)
							;tb1=(((a And 31744)Shr 10)*8)
							r2=Floor(((((a And 31)Shl 3)-128)*NewInt#)+NewBright#)
							If r2<0 Then r2=0
							If r2>255 Then r2=255		
							g2=Floor((((((a And 992)Shr 5)Shl 3)-128)*NewInt#)+NewBright#)
							If g2<0 Then g2=0
							If g2>255 Then g2=255
							b2=Floor((((((a And 31744)Shr 10) Shl 3)-128)*NewInt#)+NewBright#)
							If b2<0 Then b2=0
							If b2>255 Then b2=255
							
							b3=OS_Col(Patt16(((r2 Shr 4) Shl 8) + ((g2 Shr 4) Shl 4) + (b2 Shr 4),(g And 7)+((f And 7)*8),PattType))
							
							ge=g Shl 1
							
							WritePixelFast ge,fe,b3
							WritePixelFast ge+1,fe,b3
							If Gu_Held(gVideoHScroller)=0 Then 
								WritePixelFast ge,fe+1,b3
								WritePixelFast ge+1,fe+1,b3
							EndIf
						Next
					Next
					UnlockBuffer ImageBuffer(imgMovie)
					SetBuffer BackBuffer()
				EndIf
				Gg_Vis(ggVideoOutput)=1
				Gg_Vis(ggVideoColours)=1
				d=(xw*Gu_Val(gVideoHeight))/2
				Gu_Cap$(gVideoText1)="- Frames: "+Str$(Int(Gu_Val(gVideoHScroller))+1)+" / "+Str$(Vid_CapFrame)+" - Size "+Str$(d)+" "+Testcount
			EndIf
			
			
		Else
			Gu_Cap$(gVideoText1)="-Choose Source Video from File select-"
			Gu_Cap$(gVideoButton1)="Start"
		EndIf	
	EndIf
	
End Function

Function MakeSheetFile(ShtNum,Typ,aft=0)
	If GrpWid(ShtNum)<1 Then Return 0
	If GrpFile(ShtNum)="" Then SetError 120,"Sheet "+ShtNum+" has no filename." :Return 999
	cnum=4
	If GrpPat(ShtNum)Mod 2=0 Then cnum=16
	
	If aft=1 Then
		If cnum=16 Then
			cnum=4
		Else
			cnum=16
		EndIf
	EndIf	
	
	If cnum=4 Then	
		filename$="output\"+GrpFile(ShtNum)+".qs1"
	Else
		filename$="output\"+GrpFile(ShtNum)+".qs2"
	EndIf
	os=WriteFile(filename$)
	WriteByte os,179
	WriteByte os,1
	WriteByte os,ShtNum
	WriteByte os,GrpTNo(ShtNum)
	
	If cnum=4 Then 
		WriteShort os,GrpT4BytesTot(ShtNum)
	Else
		WriteShort os,GrpT16BytesTot(ShtNum)+32768
	EndIf
	
	c1=0
	d1=GrpTNo(ShtNum)*9
	e1=d1
	
	;***** Start Tile Table
	For f=0 To GrpTNo(ShtNum)-1
		a$=""
		If cnum=4 Then 								;Byte Width (Even only)
			WriteByte os,(GrpT4Byte(ShtNum,f)-10)/GrpTHei(ShtNum,f):c1=c1+1
		Else	
			WriteByte os,(GrpT16Byte(ShtNum,f)-10)/GrpTHei(ShtNum,f):c1=c1+1
		EndIf
		WriteByte os,GrpTWid(ShtNum,f):c1=c1+1		;Pixel Width
		WriteByte os,GrpTHei(ShtNum,f):c1=c1+1		;Pixel Height
		WriteShort os,d1+1:c1=c1+2					;Graphic data
		WriteShort os,d1:c1=c1+2					;Encoding data
		If cnum=4 Then 
			WriteShort os,GrpT4Byte(ShtNum,f)-10:c1=c1+2
			d1=d1+GrpT4Byte(ShtNum,f)-9
		Else
			WriteShort os,GrpT16Byte(ShtNum,f)-10:c1=c1+2
			d1=d1+GrpT16Byte(ShtNum,f)-9
		EndIf
	Next
	
	SetBuffer ImageBuffer(GrpCImg(ShtNum,0))
	LockBuffer ImageBuffer(GrpCImg(ShtNum,0))
	
	For f=0 To GrpTNo(ShtNum)-1
		x6=(GrpTWid(ShtNum,f)+GrpTX(ShtNum,f))Shl 1
		
		If cnum=4 Then
			m=((GrpT4Byte(ShtNum,f)-10)/GrpTHei(ShtNum,f))-1
			WriteByte os,0:c1=c1+1					;Encode CPC 4 colour
			For y1=0 To GrpTHei(ShtNum,f)-1
				y5=(y1+GrpTY(ShtNum,f))Shl 1
				For x1=0 To m
					
					x5=((x1 Shl 2)+GrpTX(ShtNum,f))Shl 1
					If x5<x6 Then
						p0=ReturnOSCol(ReadPixelFast(x5,y5))
					Else
						p0=0
					EndIf
					If x5+2<x6 Then
						p1=ReturnOSCol(ReadPixelFast(x5+2,y5))
					Else
						p1=0
					EndIf
					If x5+4<x6 Then
						p2=ReturnOSCol(ReadPixelFast(x5+4,y5))
					Else
						p2=0
					EndIf	
					If x5+6<x6 Then
						p3=ReturnOSCol(ReadPixelFast(x5+6,y5))
					Else
						p3=0
					EndIf
					WriteByte os,ConvertScreenByte((p0 Shl 6)+(p1 Shl 4)+(p2 Shl 2)+p3)
					c1=c1+1
				Next
			Next
		Else	
			WriteByte os,5:c1=c1+1					;Encode MSX 16 colour
			m=((GrpT16Byte(ShtNum,f)-10)/GrpTHei(ShtNum,f))-1
			For y1=0 To GrpTHei(ShtNum,f)-1
				y5=(y1+GrpTY(ShtNum,f))Shl 1
				For x1=0 To m
					x5=((x1 Shl 1)+GrpTX(ShtNum,f))Shl 1
					If x5<x6 Then
						p0=ReturnOSCol(ReadPixelFast(x5,y5))
					Else
						p0=0
					EndIf
					If x5+2<x6 Then
						p1=ReturnOSCol(ReadPixelFast(x5+2,y5))
					Else
						p1=0
					EndIf					
					WriteByte os,(p0 Shl 4)+p0
					c1=c1+1
				Next
			Next
		EndIf
	Next
	UnlockBuffer ImageBuffer(GrpCImg(ShtNum,0))
	SetBuffer BackBuffer()
	
	CloseFile os
	Return cnum
	
End Function

Function ReturnOSCol(a5)
	r1=(a5 Shr 16)And 255
	g1=(a5 Shr 8) And 255
	b1=a5 And 255
	For k=0 To 15
		If OS_Red(k)=r1 And OS_Green(k)=g1 And OS_Blue(k)=b1 Then Return k
	Next	
	Stop
	
End Function
;~IDEal Editor Parameters:
;~C#Blitz3D