;****
;**** Join all the Header,Code & Form data
;**** into a complete FORM.asm file
;****
Function CompileForm()
	
	NetEvent=0
	TimerEvent=0
	Timer$=".SyStud_TimerRoutines    dw "
	If CompileType=0 Then AddNewLog("COMPILING...")
	ChangeDir CDir$+"sys"
	;**** Save the Code stuff
	FileOut = WriteFile("tempcode.asm")
	For f=1 To Lstline
		WriteLine(FileOut,"QUIGLINE "+Str(f))
		WriteLine(FileOut,Cd$(f))
	Next
	;Filein3 = ReadFile("symbos_basic.asm")
	CloseFile(FileOut)
	SaveFormTemp()    	;**** Save Original Data
	For k=0 To NoOfFrms
		SortForm(k)			;**** Allow for Tab Stuff
	Next
	For f=0 To 65536
		Ed$(f,0)=""
		Ed$(f,1)=""
		Ed$(f,2)=""
	Next
;	AddNewLog("< COMPILER > Retrieving code / libraries....")
	For k=0 To NoOfFrms
		ParentStuff(k)
	Next
;	AddNewLog("< COMPILER > Comparing Object to Code Events....")
	AddLabelFunc(1)				;Rework out all Functions / Labels
	
	
	;**** Clear Code Found Shite
	For k=0 To NoOfFrms
		For f1=1 To 512
			CodeFound(k,f1)=0
		Next
		CodeFoundWindow(k,0)=0
		CodeFoundWindow(k,1)=0
		CodeFoundWindow(k,2)=0
		CodeFoundWindow(k,3)=0
		CodeFoundWindow(k,4)=0
		CodeFoundWindow(k,5)=0
		CodeFoundWindow(k,6)=0
		CodeFoundWindow(k,7)=0
	Next
	;**** Do Code Found Shite
	For f=1 To Lstline
		If Trim$(Upper$(Mid$(Cd$(f),1,8)))="FUNCTION" Or Trim$(Upper$(Mid$(Cd$(f),1,4)))="FUNC" Then
			Answer$=Seperate$(f)
			ss$=Upper$(SepSort$(2))
			If ss$>"" Then
				If ss$="NET.EVENT" Then
					NetEvent=1
				EndIf
				If ss$="TIMER.EVENT" Then
					TimerEvent=1
				EndIf
				For k=0 To NoOfFrms
					If Upper$(ObSData$(k,1,QVTB))=ss$ Then CodeFoundWindow(k,0)=1
					If Upper$(ObSData$(k,1,QClB))=ss$ Then CodeFoundWindow(k,1)=1
					If Upper$(ObSData$(k,1,QRss))=ss$ Then CodeFoundWindow(k,2)=1
					If Upper$(ObSData$(k,1,QVSc))=ss$ Then CodeFoundWindow(k,3)=1
					If Upper$(ObSData$(k,1,QROn))=ss$ Then CodeFoundWindow(k,4)=1					
				Next	
				For k=0 To NoOfFrms
					For f1=1 To 255
						If ObData(k,f1,QTyp)>1 Then
							If ObSData$(k,f1,QFun)>"" Then 
								If Upper$(ObSData$(k,f1,QFun))=ss$ Then
									CodeFound(k,f1)=2
									f1=512
								EndIf
							Else
								If Upper$(ObSData$(k,f1,QNam)+".EVENT")=ss$ Then
									CodeFound(k,f1)=1
									f1=512
								EndIf
							EndIf
						EndIf
					Next
				Next
				For k=0 To NoOfFrms
					If NoOfMn(k)>1 Then
						For f1=2 To NoOfMn(k)
							If Upper$(Mn$(k,f1,2)+".EVENT")=ss$ Then
								CodeFound(k,f1+256)=1
								f1=512
							EndIf
						Next
					EndIf
				Next
			EndIf
		EndIf
	Next
	
	
	
	;**** Check Start Form Exists somewhere
	Tot=0
	For k=0 To NoOfFrms
		If ObData(k,1,QWnd)=1 Then tot=k+1
	Next
	If Tot=0 Then ObData(0,1,QWnd)=1
		
		
	;**** Clean Group Checks
	For f1=0 To 100
		RadGroupCheck(f1)=0
	Next
	;AddNewLog("< COMPILER > Creating application Z80 source....")
	Mem=0
	EdL0=0:EdL1=0:EdL2=0
	CreateProgramHeader(1)
	CreateFormData()		;Create all the Window/Data Info for Forms and content
	For f1=0 To 99
		If RadGroupCheck(f1)>0 Then
			AddTran ".GroupStatus"+Str$(f1)+":  db  "+Str$(RadGroupCheck(f1))
			AddTran ".GroupCoord"+Str$(f1)+":   db  -1,-1,-1,-1"
		EndIf
	Next
	;***** Load the Library Code and
	;***** put into the Transfer Code Section
	ChangeDir CDir$
	For f=1 To LibNumber
		Filein = ReadFile(LibName$(f))
		While Eof(Filein)=False
			AddTran ReadLine$(Filein)
		Wend
		CloseFile(Filein)
	Next
	ChangeDir CDir$+"sys"
	AddTran Timer$+"0"
;	Ed$(EdL2+0,2)=".SyB_Dialog_Info_Box"
;	Ed$(EdL2+1,2)="       dw SyB_Dialog_Info_Text,6,SyB_Dialog_Info_Text,6,SyB_Dialog_Info_Text,6"
;	Ed$(EdL2+2,2)="       dw 0"
;	EdL2=EdL2+3
	
	AddTran ".AppTrnEnd"
	EdL0=EdL0+1
	;AddNewLog("< COMPILER > Writing Assembler Source....")

	fileout = WriteFile(CurrentDir$()+"form.asm")
	For f=0 To EdL0+1
		WriteLine (fileout,Ed$(f,0))
	Next
	WriteLine (fileout,"    ASM")
	WriteLine (fileout,";**** Core End")
	For f=0 To EdL1+1
		WriteLine (fileout,Ed$(f,1))
	Next
	For f=0 To EdL2+1
		WriteLine (fileout,Ed$(f,2))
	Next	
	CloseFile (Fileout)
	;**** Clears temporary compile data ****
	For f=0 To 255
		ObData(CFr,f,QDok)=0
		ObData(CFr,f,QPr2)=0
	Next
 	OpenFormTemp()				;*** Get Original Data Back ***
	ChangeDir CDir$
	
	VarNo=0
	For k=1 To 49999
		VarName$(k)="":VarNameU$(k)="":VarName2$(k)="":VarType(k)=0:VarLink$(k)="":VarAvoid(k)=0:VarText$(k)=""
		VarArray(k,0)=0:VarArray(k,1)=0:VarArray(k,2)=0:VarFunc(k)=0:VarCont(k)=0:VarNotList(k)=0
	Next
	For k=1 To 26
		ComUsed(k)=0
		For f=1 To 2048
			ComUStr(f,k)=""
			ComStr(f,k)=""
		Next	
	Next	
	
	
End Function

Function Write_Code_Transfersss(Stringinfo$)
	Ed$(EdL2,2)=Stringinfo$
	EdL2=EdL2+1
End Function	

Function CreateFormData()
;	;**** Creates all data from form
	;**** Lets create Sequential List of Forms & Supers
	CDR=1
	AddTran ".ControWindowDataList"
	For k=0 To NoOfFrms
		For f=1 To 255
			If ObData(k,f,QTyp)=1 Then 
				AddTran "     dw "+ObSData(k,f,QNam)+"_ControlWindowData"
				If ObData(k,f,QTBH)>7 Then 
					AddTran "     dw "+ObSData(k,f,QNam)+"_ControlToolData"
				Else
					AddTran "     dw 0 ;**** There is No Toolbar"
				EndIf	
			EndIf	
		Next
	Next
	WinDatForm=0
	For k=0 To NoOfFrms
		WinDatForm=k*8
		CreateWindowDataRecord(k,1)
		CreateGroupControlRecord(k,1,"ControlWindow")
		;**** Search out Super Controls
		Actual=0
		For f=1 To 255 
			s3=ObData(k,f,QPar):If s3<0 Then s3=0
			If ObData(k,f,QTyp)>1 And ObData(k,s3,QTyp)<>21 And ObData(k,f,QITB)<255 Then
				Actual=Actual+1
			EndIf			
			If ObData(k,f,QTyp)=21 Then 
				CreateGroupControlRecord(k,f,"ControlWindow",actual)
			EndIf
		Next
		;**** Do the 16 Data for each Object
		Actual=0
		For f=1 To 255
			If ObData(k,f,QTyp)=1 Then
				Nm$=ObSData(k,f,QNam)
				AddTran ANS$(Nm$,"ControlWindowData")
				AddTran ";**** Object Window Background Data Record ****"
				AddTran "dw 0,255*256+0,"+ObData(k,f,QPap)+",  0,0,1000,1000,0"
				Actual=Actual+1
			EndIf
			s3=ObData(k,f,QPar):If s3<0 Then s3=0
			If ObData(k,f,QTyp)>1 And ObData(k,s3,QTyp)<>21 And ObData(k,f,QITB)<255 Then
				Actual=CreateDataControlRecord(k,f,Actual)
			EndIf
		Next
		WinDatForm=WinDatForm+1
		;**** Checks for all the Super Controls
		For g=1 To 255
			If ObData(k,g,QTyp)=21 And ObData(k,g,QITB)<255 Then
				Nm$=ObSData(k,g,QNam)
				AddTran ANS$(Nm$,"ControlWindowData")
				AddTran ";**** Object Window Background Data Record ****"
				AddTran "dw 0,255*256+0,"+ObData(CFr,g,QPap)+",  0,0,1000,1000,0"
				Actual=Actual+1
				For h=g+1 To 255
					If ObData(k,h,QTyp)>1 And ObData(k,h,QPar)=g And ObData(k,h,QITB)<255 Then
						Actual=CreateDataControlRecord(k,h,Actual)
					EndIf					
				Next
			EndIf
		Next
		
		If ObData(k,1,QTBH)>7 Then 
			CreateGroupControlRecord2(k,1,"ControlTool")
			;**** Search out Super Controls
			Actual=0
			For f=1 To 255 
				s3=ObData(k,f,QPar):If s3<0 Then s3=0
				If ObData(k,f,QTyp)>1 And ObData(k,s3,QTyp)<>21 And ObData(k,f,QITB)>255 Then
					Actual=Actual+1
				EndIf			
				If ObData(k,f,QTyp)=21 And ObData(k,f,QITB)>255 Then 
					CreateGroupControlRecord(k,f,"ControlTool",actual)
				EndIf
			Next
			;**** Do the 16 Data for each Object
			Actual=0
			For f=1 To 255
				If ObData(k,f,QTyp)=1 Then
					Nm$=ObSData(k,f,QNam)
					AddTran ANS$(Nm$,"ControlToolData")
					AddTran ";**** Object Window Background Data Record ****"
					AddTran "dw 0,255*256+0,"+ObData(k,f,QPap)+",  0,0,1000,1000,0"
					Actual=Actual+1
				EndIf
				s3=ObData(k,f,QPar):If s3<0 Then s3=0
				If ObData(k,f,QTyp)>1 And ObData(k,s3,QTyp)<>21 And ObData(k,f,QITB)>255 Then
					Actual=CreateDataControlRecord(k,f,Actual)
				EndIf
			Next
			WinDatForm=WinDatForm+1
			;**** Checks for all the Super Controls
			For g=1 To 255
				If ObData(k,g,QTyp)=21 Then
					Nm$=ObSData(k,g,QNam)
					AddTran ANS$(Nm$,"ControlToolData")
					AddTran ";**** Object Window Background Data Record ****"
					AddTran "dw 0,255*256+0,"+ObData(CFr,g,QPap)+",  0,0,1000,1000,0"
					Actual=Actual+1
					For h=g+1 To 255
						If ObData(k,h,QTyp)>1 And ObData(k,h,QPar)=g And ObData(k,h,QITB)>255 Then
							Actual=CreateDataControlRecord(k,h,Actual)
						EndIf					
					Next
				EndIf
			Next		
		EndIf
		
		;CreateFormIcon(k,1)
		Nm$=ObSData(k,1,QNam)
		;**** Do the Extras for Each Object	
		For f=1 To 255
			If ObData(k,f,QTyp)>1 Then CreateDataControlExtras(k,f)
		Next
	Next
	
End Function

Function CompileReadFile(fil$,a9)
	Filein = ReadFile(fil$)
	canuse=1
	skipline=0
	While Not Eof(Filein)
		q$=ReadLine$(Filein)
		q1$=Trim$(Upper$(q$))
		If Mid$(q1$,1,3)="#IF" Then
			q2$=Trim$(Mid$(q1$,4))
			If q2$="USENET" And NetEvent=0 Then canuse=0
			If q2$="USETIMER" And TimerEvent=0 Then canuse=0
			Skipline=1
		EndIf
		If Mid$(q1$,1,6)="#ENDIF"Then
			canuse=1
			skipline=1
		EndIf	
		If canuse=1 And skipline=0 Then
			Select a9
				Case 0 AddCode q$
				Case 1 AddData q$
				Case 3 AddTran q$
			End Select
		EndIf	
		skipline=0
	Wend
	CloseFile(Filein)
	
End Function

Function CreateProgramHeader(ObjNo)
	
	CompileReadFile("Consts.asm",0)
	f=0
	For k=0 To NoOfFrms	
		If ObData(k,1,QWnd)=1 Then 
			f=k
			Exit
		EndIf
	Next	
	AddCode "SYMBOS_ORG #100"
	AddCode ";**** 256 Application Header ****"
	AddCode ".AppCodBeg     dw  AppDatBeg-AppCodBeg      ;Length of Code
	AddCode "               dw  AppTrnBeg-AppDatBeg      ;Length of Data
	AddCode "               dw  AppTrnEnd-AppTrnBeg      ;Length of Transfer
	AddCode ".AppDatAdr     dw  #100                    ;Original Origin
	AddCode ".AppTrnAdr     dw  0                        ;Number of Entries In Relocation Table
	AddCode ".AppPrzLst     dw  AppStk-AppTrnBeg         ;Stack Length
	AddCode "               dw  0                        ;Length of Crunched Data
	AddCode ".AppBnkNum     db  0                        ;Crunch Type
	
	
	AddCode ".AppNam        db  "+Chr$(34)+Left$(ApTitle$+"                                ",32)+Chr$(34)+",0"
	AddCode ".AppMemTab     db  "+Chr$(34)+"SymExe10"+Chr$(34)+"             ;File Check"
	AddCode ".AppExtCode    dw  0"
	AddCode ".AddExtData    dw  "+4096
	AddCode ".AddExtTrans   dw  "+4096
	AddCode "               ds  28"
	AddCode ".AppIcnSml    "
	AddCode ".AppStartForm  equ "+Str$(f)
	CreateAppIconSmall()
	AddCode ".AppIcnBig    "
	CreateAppIconLarge()
	CompileReadFile("Main.asm",0)
	
	Filein = ReadFile("tempcode.asm")
	While Not Eof(Filein) 
		Ed$(EdL0,0)=ReadLine$(Filein)
		EdL0=EdL0+1
	Wend 
	CloseFile (Filein)
	
	
	;AddData "CODE Z80"
	AddData ".Quig_CodeEnd:db 0"
	AddData ";**********************"
	AddData ";**** Data Section ****"
	AddData ";**********************"
	AddData ".AppDatBeg"
	AddData ".AppFormLists"
	For n=1 To 1
		Nm$=ObSData(CFr,1,QNam)
		AddData "    dw "+ObSData$(CFr,1,QNam)+"_ControlWindowData"
	Next
	AddData ";**** Form Icon Data ****
	For k=0 To NoOfFrms
		CreateFormIcon(k,1)
	Next	
	AddData ";**** Define User Graphics ****"	
	AddData ";**** Define User Variables ****"
	
	
	AddTran ";**************************"
	AddTran ";**** Transfer Section ****"
	AddTran ";**************************"
	AddTran ".AppTrnBeg"
	AddTran "          ds    128"
	AddTran ".AppStk   ds    6*2"
	AddTran "          dw    AppPrz"
	AddTran ".AppPrzN  db    0"
	AddTran ".AppMsgB"
	AddTran ".Event_Message       db 0         ;0 Message No 162
	AddTran ".Event_Form_ID       db 0         ;1 Event happned on which Form"
	AddTran ".Event_Type          db 0         ;2 Type of Event"
	AddTran ".Event_UserInput     db 0         ;3 Key or Mouse Event"
	AddTran ".Event_Key_ASCII                  ;4 Key ASCII - Shared Byte with next"
	AddTran ".Event_MouseX        dw 0         ;5 MouseX when event happens"
	AddTran ".Event_MouseY        dw 0         ;6 MouseY when event happens"
	AddTran ".Event_Control_ID    dw 0         ;7 Control ID No"
	AddTran ".Event_8             db 0         ;8"
	AddTran ".Event_9             db 0         ;9"
	AddTran ".Event_10            db 0         ;10"
	AddTran ".Event_11            db 0         ;11"
	AddTran ".Event_12            db 0         ;12"	
	AddTran ".Event_13            db 0         ;13"
	AddTran ".Event_14            db 0         ;14"	
	AddTran ".Quig_Machine_Type   db 0    ;0=464, 1=664, 2=6128, 3=464Plus, 4=6128Plus 7=Enterprise 64/128 8=MSX2, 9=MSX2+, 10=MSX TurboR 12=PCW8xxx, 13=PCW9xxx"
	AddTran ".Quig_Null_String    db 0"
	AddTran ";**** Dialog Transfer ****"
	AddTran ".Quig_Dialog_1:      dw Quig_Dialog_1_Data+4,6"
	AddTran ".Quig_Dialog_2:      dw Quig_Dialog_2_Data+4,6"
	AddTran ".Quig_Dialog_3:      dw Quig_Dialog_3_Data+4,6"
	AddTran ".Quig_Dialog_4:      dw AppIcnLrg"
	AddTran ".Quig_InitDir:       dw Quig_InitDir_Data+4"
	AddTran ".Quig_InitCommand:   dw Quig_InitCommand_Data+4"
	
	If TimerEvent=1 Then 
		AddTran ";**************************
		AddTran ";**** Quig Timer Stack ****
		AddTran ";**************************
		AddTran "           ds 64              ;Stack buffer"
		AddTran ".Quig_TimerStack"
		AddTran "           dw 0                    ;IY"
		AddTran "           dw 0                    ;IX"
		AddTran "           dw 0                    ;HL"
		AddTran "           dw 0                    ;DE"
		AddTran "           dw 0                    ;BC"
		AddTran "           dw 0                    ;AF"
		AddTran "           dw Quig_Timer_Code       ;Start of Timer Routine"
		AddTran "           db 0"
	EndIf
	AddTran ".App_Form_List"
	For k=0 To NoOfFrms
		a$="       dw  "+ObSData$(k,1,QNam)+"_Begin,"
		;Ed$(EdL2+0,2)=Ed$(EdL2+0,2)+ObSData$(k,1,QNam)+"_Begin,"
		If CodeFoundWindow(k,0)=1 Then 
			a$=a$+"QFunc_"+Replace(ObSData$(k,1,QVTB),".","_")+","			
		Else
			a$=a$+"0,"
		EndIf
		If CodeFoundWindow(k,1)=1 Then 
			a$=a$+"QFunc_"+Replace(ObSData$(k,1,QClB),".","_")+","			
		Else
			a$=a$+"0,"
		EndIf
		If CodeFoundWindow(k,2)=1 Then 
			a$=a$+"QFunc_"+Replace(ObSData$(k,1,QRss),".","_")+","			
		Else
			a$=a$+"0,"
		EndIf
		If CodeFoundWindow(k,3)=1 Then 
			a$=a$+"QFunc_"+Replace(ObSData$(k,1,QVSc),".","_")+","			
		Else
			a$=a$+"0,"
		EndIf
		If CodeFoundWindow(k,4)=1 Then 
			a$=a$+"QFunc_"+Replace(ObSData$(k,1,QROn),".","_")+",0,0"			
		Else
			a$=a$+"0,0,0"
		EndIf		
		AddTran a$
	Next
End Function
Function CreateWindowDataRecord(CFr,ObjNo)
	Nm$=ObSData(CFr,ObjNo,QNam)
	AddTran ";****
	AddTran ";**** Z80 version of Form "+ObSData(CFr,1,QNam)+" ****
	AddTran ";****
	AddTran "."+Nm$
	AddTran ANS$(Nm$,"Addr")+"db "+CFr+",0"
	AddTran ANS$(Nm$,"Begin")
	
	Tot=0
	If ObData(CFr,ObjNo,QWnd)=1 Then Tot=Tot+1					;**** BIT 7 - Centered Form
	If ObData(CFr,ObjNo,QCol)=1 Then Tot=Tot+128				;**** BIT 7 - Centered Form
	AddTran ANS$(Nm$,"Status")+"db "+Tot
	Tot=0
	;If GrpImage(ObData(CFr,ObjNo,QGra))<>0 Then Tot=Tot+1		;**** BIT 0 - Show Icon
	If ObData(CFr,ObjNo,QSIc)=1 Then Tot=Tot+1		;**** BIT 0 - Show Icon
	If ObData(CFr,ObjNo,QRss)=1 Then Tot=Tot+2					;**** BIT 1 - Is Resizable
	If ObData(CFr,ObjNo,QClB)=1 Then Tot=Tot+4					;**** BIT 2 - Close Button
	If ObData(CFr,ObjNo,QTBH)>7 Then Tot=Tot+8					;**** BIT 3 - Tool Bar
	If ObData(CFr,ObjNo,QTiB)=1 Then Tot=Tot+16					;**** BIT 4 - Title Bar
	If NoOfMn(CFr)>1 Then Tot=Tot+32							;**** BIT 5 - Menu Bar
	If ObData(CFr,ObjNo,QStB)=1 Then Tot=Tot+64					;**** BIT 6 - Status Bar
	
	AddTran ANS$(Nm$,"Display")+"db "+Tot
	
	Tot=0
	If ObData(CFr,ObjNo,QVTB)=0 Then Tot=Tot+4
	If ObData(CFr,ObjNo,QMov)=0 Then Tot=Tot+8
	If ObData(CFr,ObjNo,QSpW)=1 Then Tot=Tot+16
	AddTran ANS$(Nm$,"SizeAdjust")+"db "+Tot
	AddTran ANS$(Nm$,"OwnerID")+"db 0"
	AddTran ANS$(Nm$,"Left")+"dw "+Str$(ObData(CFr,ObjNo,QLef))
	AddTran ANS$(Nm$,"Top")+"dw "+Str$(ObData(CFr,ObjNo,QTop))
	AddTran ANS$(Nm$,"Width")+"dw "+Str$(ObData(CFr,ObjNo,QWid))
	CompBarHeight=0
	If ObData(CFr,ObjNo,QTiB)=1 Then CompBarHeight=CompBarHeight+20	        ;TitleBar
	If ObData(CFr,ObjNo,QStB)=1 Then CompBarHeight=CompBarHeight+20			;StatusBar
	If ObData(CFr,ObjNo,QRss)=1 Then CompBarHeight=CompBarHeight+16			;Resizable
	If ObData(CFr,ObjNo,QTBH)>7 Then CompBarHeight=CompBarHeight+(ObData(CFr,ObjNo,QTBH)*2)			;ToolBar	
	If NoOfMn(CFr)>1 Then CompBarHeight=CompBarHeight+19					;MenuBar
	;If ObData(ObjNo,67)=1 Then CompBarHeight=CompBarHeight+ObData(CurrObj,68)			;ToolBar
	AddTran ANS$(Nm$,"Height")+"dw "+Str$((ObData(CFr,ObjNo,QHei)-CompBarHeight)/2)
	AddTran ANS$(Nm$,"OffsetWidth")+"dw 1"
	AddTran ANS$(Nm$,"OffsetHeight")+"dw 8"
	AddTran ANS$(Nm$,"ContentWidth")+"dw "+Str$(ObData(CFr,ObjNo,QWid)-9)
	AddTran ANS$(Nm$,"ContentHeight")+"dw "+Str$((ObData(CFr,ObjNo,QHei)-CompBarHeight)/2)
	AddTran ANS$(Nm$,"MinWidth")+"dw 0"
	AddTran ANS$(Nm$,"MinHeight")+"dw 0"
	AddTran ANS$(Nm$,"MaxWidth")+"dw 1024"
	AddTran ANS$(Nm$,"MaxHeight")+"dw 212"	
	;AddLine2 ANS$(Nm$,"IconAddr")+"dw "+Nm$+"_Icon"							;28
	If ObData(CFr,1,QSIc)=1 Then
		AddTran ANS$(Nm$,"IconAddr")+"dw AppIcnSml"							;28
	Else
		AddTran ANS$(Nm$,"IconAddr")+"dw 0"							;28
	EndIf
	AddTran ANS$(Nm$,"Text")+"dw "+Nm$+"_Text_Data+4"						;30
	AddTran ANS$(Nm$,"Status_Text")+"dw "+Nm$+"_Status_Text_Data+4"			;32
	AddTran ANS$(Nm$,"MenuAddr")+"dw "+Nm$+"_Menu"							;34
	AddTran ANS$(Nm$,"ControlWindowAddr")+"dw "+Nm$+"_ControlWindow"			;36
	If ObData(CFr,ObjNo,QTBH)>7 Then 
		AddTran ANS$(Nm$,"ControlToolAddr")+"dw "+Nm$+"_ControlTool"			;38
		AddTran ANS$(Nm$,"ToolBarHeight")+"dw "+Str$(ObData(CFr,ObjNo,QTBH))		;40
	Else
		AddTran ANS$(Nm$,"ControlToolAddr")+"dw 0;"+Nm$+"_ControlTool"			;38
		AddTran ANS$(Nm$,"ToolBarHeight")+"dw 0;"							;40
	EndIf	
	AddTran "     db 0,0,0,0,0,0,0,0,0       ;Symbos Reserved"
	AddTran ANS$(Nm$,"SuperWindow")+"db  2"
	AddTran "     ds 140,0                   ;Symbos Reserved"
	
	Ed$(EdL2+0,2)=ANS$(Nm$,"Menu")
	For f=0 To 128
		MenuName$(f)=""
	Next
	If NoOfMn(CFr)>1 Then
		MenuCount=1
		h=0
    	For p=0 To 5
			For r=2 To NoOfMn(CFr)
				If MnP(CFr,r)=P Then
				    h=1
					MnN(CFr,r)=MenuCount
					If (MnP(CFr,r+1)>MnP(CFr,r)) Or MenuCount=1 Then
					;If (MnP(r+1)>MnP(r)) Then					
						MnT(CFr,r)=0
					Else
						MnT(CFr,r)=1
					EndIf
				EndIf
				If MnP(CFr,r)<P And h=1 Then
					MenuCount=MenuCount+1
					h=0
				EndIf	
			Next
		Next
		EdL2=EdL2+1
		MenuCount=1
		.OverAndOver:
		a=CountMenuItem(MenuCount,CFr)
		If a>0 Then
			If MenuName$(MenuCount)=""Then
				Ed$(EdL2+0,2)=SpaceIt$("."+Nm$+"_Menu_Entries")+"dw "+Str$(a)	
			Else
				Ed$(EdL2+0,2)=SpaceIt$("."+MenuName$(MenuCount))+"dw "+Str$(a)
			EndIf	
			EdL2=EdL2+1
			For f=2 To NoOfMn(CFr)
				If MnN(CFr,f)=MenuCount Then
					b=0
					If MnAct(CFr,f)>0 Then b=b+1
					If MnChk(CFr,f)>0 Then b=b+2
					If MnT(CFr,f)=0 Then b=b+4
					If Mid$(Mn$(CFr,f,1),1,1)="-"Then
						Ed$(EdL2+0,2)="        dw  1+8,#8000,0,0"
						EdL2=EdL2+1
					Else
						If MnT(CFr,f)=0 Then
							Ed$(EdL2+0,2)=SpaceIt$("."+Mn$(CFr,f,2)+"_Appearance")+"dw "+Str$(b)
							Ed$(EdL2+1,2)=SpaceIt$("."+Mn$(CFr,f,2)+"_Text")+"dw "+Mn$(CFr,f,2)+"_Text_Data+4"
							Ed$(EdL2+2,2)=SpaceIt$("."+Mn$(CFr,f,2)+"_Data")+"dw "+Mn$(CFr,f,2)+"_Entries"
							MenuName$(MnN(CFr,f+1))=Mn$(CFr,f,2)+"_Entries"
							Ed$(EdL2+3,2)=SpaceIt$("")+"dw 0"
							EdL2=EdL2+4
						EndIf
						If MnT(CFr,f)=1 Then
							Ed$(EdL2+0,2)=SpaceIt$("."+Mn$(CFr,f,2)+"_Appearance")+"dw "+Str$(b)
							Ed$(EdL2+1,2)=SpaceIt$("."+Mn$(CFr,f,2)+"_Text")+"dw "+Mn$(CFr,f,2)+"_Text_Data+4"
							If CodeFound(CFr,f+256)=1 Then
								Ed$(EdL2+2,2)=SpaceIt$("."+Mn$(CFr,f,2)+"_Data")+"dw "+Mn$(CFr,f,2)+"_Event"							
							Else
								Ed$(EdL2+2,2)=SpaceIt$("."+Mn$(CFr,f,2)+"_Data")+"dw 0"
							EndIf
							Ed$(EdL2+3,2)=SpaceIt$("")+"dw 0"
							EdL2=EdL2+4
						EndIf
					EndIf
				EndIf
			Next
			MenuCount=MenuCount+1
			Goto OverAndOver
		EndIf
	Else
		Ed$(EdL2+1,2)="        dw  0"
		EdL2=EdL2+2
	EndIf
End Function
Function CountMenuItem(r1,Cfr)
	r=0
	For f=2 To NoOfMn(Cfr)
		If MnN(Cfr,f)=r1 Then r=r+1
	Next
	Return r
End Function
Function CreateGroupControlRecord(CFr,ObjNo,Oper$,ac=0)
	Nm$=ObSData(CFr,ObjNo,QNam)
	Tot=1
	For f=1 To 255
		If ObData(CFr,f,QTyp)<>17 And ObData(CFr,f,QITB)< 255 Then
			If ObjNo<2 Then			;This is the Form so Total Like this
				s3=ObData(CFr,f,QPar)
				If s3<0 Then s3=0
				If ObData(CFr,f,QTyp)>1 And ObData(CFr,s3,QTyp)<>21 Then Tot=Tot+1
			Else
				If ObData(CFr,f,QPar)=ObjNo Then Tot=Tot+1
			EndIf
		EndIf
	Next
	EdL2=EdL2+1
	AddTran ";****"
	AddTran ";**** Data Control Record ("+Oper$+") ****"
	AddTran ";****"
	AddTran ANS$(Nm$,Oper$)
	AddTran ANS$(Nm$,Oper$+"Count")+"db "+Str$(Tot)	
	AddTran ANS$(Nm$,Oper$+"OwnerID")+"db "+ac    :CDR=CDR+1
	AddTran ANS$(Nm$,Oper$+"DataAddr")+"dw "+Nm$+"_"+Oper$+"Data"
	AddTran ANS$(Nm$,Oper$+"CalcAddr")+"dw 0; "+Nm$+"_"+Oper$+"Calc"
	AddTran "     db 0,0,0,0,0,0,0,0"
	AddTran ANS$(Nm$,Oper$+"Focus")+"db 0"
	AddTran "     db 0"
	AddTran ";****"
;	AddTran ANS$(Nm$,Oper$+"Data99")
	
End Function
Function CreateGroupControlRecord2(CFr,ObjNo,Oper$,ac=0)
	Nm$=ObSData(CFr,ObjNo,QNam)
	Tot=1
	For f=1 To 255
		If ObData(CFr,f,QTyp)<>17 And ObData(CFr,f,QITB)>255 Then
			If ObjNo<2 Then			;This is the Form so Total Like this
				s3=ObData(CFr,f,QPar)
				If s3<0 Then s3=0
				If ObData(CFr,f,QTyp)>1 And ObData(CFr,s3,QTyp)<>21 Then Tot=Tot+1
			Else
				If ObData(CFr,f,QPar)=ObjNo Then Tot=Tot+1
			EndIf
		EndIf
	Next
	Ed$(EdL2+0,2)=";****"
	Ed$(EdL2+1,2)=";**** Data Control Record ("+Oper$+") ****"
	Ed$(EdL2+2,2)=";****"
	Ed$(EdL2+3,2)=ANS$(Nm$,Oper$)
	Ed$(EdL2+4,2)=ANS$(Nm$,Oper$+"Count")+"db "+Str$(Tot)	
	Ed$(EdL2+5,2)=ANS$(Nm$,Oper$+"OwnerID")+"db "+ac    :CDR=CDR+1
	Ed$(EdL2+6,2)=ANS$(Nm$,Oper$+"DataAddr")+"dw "+Nm$+"_"+Oper$+"Data"
	Ed$(EdL2+7,2)=ANS$(Nm$,Oper$+"CalcAddr")+"dw 0; "+Nm$+"_"+Oper$+"Calc"
	Ed$(EdL2+8,2)="     db 0,0,0,0,0,0,0,0"
	Ed$(EdL2+9,2)=ANS$(Nm$,Oper$+"Focus")+"db 0"
	Ed$(EdL2+10,2)="     db 0"
	Ed$(EdL2+11,2)=";****"
	Ed$(EdL2+12,2)=ANS$(Nm$,Oper$+"Data")
	
	EdL2=EdL2+12
End Function
Function CreateDataControlRecord(CFr,ObjNo,ActualObjNo)
	Nm$=ObSData(CFr,ObjNo,QNam)
	
	ThisQTyp=ObData(CFr,ObjNo,QTyp)
	AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Data Record ****"
	If ThisQTyp=Cntr_Timer Then Return ActualObjNo
	
	AddTran "."+Nm$+"_Display      Equ "+Str$(ActualObjNo)
	ObData(CFr,ObjNo,QCID)=(CFr*2048)+ActualObjNo
	AddTran "."+Nm$
	AddTran ANS$(Nm$,"ID")+"dw "+Str$(((WinDatForm)*256)+ActualObjNo)
	n9=0
	If ObData(CFr,ObjNo,QPar)>255 Then
		If (ObData(CFr,ObData(CFr,ObjNo,QPar)Mod 256,QVle))<>(ObData(CFr,ObjNo,QPar)/256)Then n9=128
	EndIf
	
	AddTran ANS$(Nm$,"Type")+"db "+Str$(n9+TypNo(ObData(CFr,ObjNo,QTyp)))+"   ;*"+TypObj$(ObData(CFr,ObjNo,QTyp))
		
	AddTran ANS$(Nm$,"ExtDataBank")+"db 255"
	
	If ExtDataNeeded(CFr,ObjNo)=1 Then
		If ThisQTyp=Cntr_Button Then
			AddTran ANS$(Nm$,"Text")+"dw "+Nm$+"_Text_Data+4"
		Else
			AddTran ANS$(Nm$,"ExtDataAddr")+"dw "+Nm$+"_ExtData"
		EndIf
	Else
		;**** ImageBox
		If ThisQTyp=Cntr_ImageBox Then			;**** ImageBox (10) Graphics Extended Data
			AddTran ANS$(Nm$,"GrInfoAddr")+"dw Sheet_Data4"
		EndIf
	EndIf
	
	Select ThisQTyp
		Case Cntr_Progress
			n8=(ObData(CFr,ObjNo,QLn1)*1)+(ObData(CFr,ObjNo,QLn2)*4)+(ObData(CFr,ObjNo,QPen)*16)+(ObData(CFr,ObjNo,QPap)*64)
			AddTran ANS$(Nm$,"Appearance")+"db  "+Str$(n8)
			AddTran ANS$(Nm$,"Value")+"db  "+Str$(ObData(CFr,ObjNo,QVle))
		Case Cntr_Box
			q=128+(ObData(CFr,ObjNo,QPap)And 15)+(ObData(CFr,ObjNo,QFil)*64)
			q1=(ObData(CFr,ObjNo,QLn1)And 15)+((ObData(CFr,ObjNo,QLn2)And 15)*16)
			AddTran ANS$(Nm$,"Appearance")+"db  "+Str$(q)+","+Str$(q1)
		Case Cntr_Paint
			q=ObData(CFr,ObjNo,QPen)
			If ObData(CFr,ObjNo,QEPa)=0 Then 
				AddTran ANS$(Nm$,"Appearance")+"db  "+Str$(q)+",0"
			Else
				AddTran ANS$(Nm$,"Appearance")+"db  "+Str$(q+128)+",0"
			EndIf	
	End Select		
	
	;**** Get Parent Info
	w=ObjNo
	b1=ObData(CFr,ObjNo,QLef)
	b2=ObData(CFr,ObjNo,QTop)-2
	.Lippy
	If (ObData(CFr,w,QPar)Mod 256)>1 And ObData(CFr,ObData(CFr,ObjNo,QPar),QTyp)<>21 Then
		w=(ObData(CFr,w,QPar)Mod 256)
		b1=b1+ObData(CFr,w,QLef)
		b2=b2+ObData(CFr,w,QTop)
		Goto Lippy
	EndIf
	
	If ObData(CFr,ObjNo,QITB)<256 And ObData(CFr,1,QTBH)>7 Then
		b2=b2-(ObData(CFr,1,QTBH)*2)
	EndIf
	
	AddTran ANS$(Nm$,"Left")+"dw "+b1  ;ObData(CFr,ObjNo,QLef)
	AddTran ANS$(Nm$,"Top")+"dw "+b2/2  ;(ObData(CFr,ObjNo,QTop)/2)
	AddTran ANS$(Nm$,"Width")+"dw "+ObData(CFr,ObjNo,QWid)
	
	If ThisQtyp=Cntr_TextLine Then 
		If ThisQtyp=Cntr_TextLine Then AddTran ANS$(Nm$,"Height")+"dw 12 ; TextLine always set to 12
		
	Else	
		AddTran ANS$(Nm$,"Height")+"dw "+(ObData(CFr,ObjNo,QHei)/2)
	EndIf	
		
	If ObSData(CFr,ObjNo,QFun)>"" Then
		If FindCode(ObSData(CFr,ObjNo,QFun))=>0 Then
			AddTran ANS$(Nm$,"Code")+"dw QFunc_"+Replace(ObSData(CFr,ObjNo,QFun),".","_")
		Else
			AddTran ANS$(Nm$,"Code")+"dw 0"
		EndIf	
	Else
		AddTran ANS$(Nm$,"Code")+"dw 0"
	EndIf
	ActualObjNo=ActualObjNo+1
	Return ActualObjNo
End Function
Function CreateDataControlExtras(CFr,ObjNo)
	Nm$=ObSData(CFr,ObjNo,QNam)
	
	Select ObData(CFr,ObjNo,QTyp)
		;**** Label
		Case Cntr_Label
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"Text")+"dw  "+Nm$+"_Text_Data+4"
			AddTran ANS$(Nm$,"TextAppearance")+"db  "+Str$(ObData(CFr,ObjNo,QPap)+(ObData(CFr,ObjNo,QPen)*16))
			AddTran ANS$(Nm$,"TextAlignment")+"db  "+Str$(ObData(CFr,ObjNo,QAli)+(ObData(CFr,ObjNo,QFil)Shl 6)+128)
;			AddTran ANS$(Nm$,"TextAppearance")+"db  "+Str$(ObData(CFr,ObjNo,QPap)+(ObData(CFr,ObjNo,QPen)*4)+(ObData(CFr,ObjNo,QFil)*128))
;			AddTran ANS$(Nm$,"TextAlignment")+"db  "+Str$(ObData(CFr,ObjNo,QAli))
		;**** Control Label
		Case Cntr_CntrLabel
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"Text")+"dw  "+Nm$+"_Text_Data+4"
			;If ObData(CFr,ObjNo,QCap)>Len(ObSData$(CFr,ObjNo,QCap))Then
			;	y7=ObData(CFr,ObjNo,QCap)
			;Else
			;	y7=Len(ObSData$(CFr,ObjNo,QCap))
			;EndIf		
			AddTran ANS$(Nm$,"TextMaxLen")+"dw  255;"+Str$(y7)
			AddTran ANS$(Nm$,"TextFontAddr")+"dw  -1"	
			AddTran ANS$(Nm$,"TextAppearance")+"db  "+Str$(ObData(CFr,ObjNo,QPap)+(ObData(CFr,ObjNo,QPen)*16))	
			AddTran ANS$(nm$,"TextUnderline")+"db 0"
		;**** Frame
		Case Cntr_Frame
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"Text")+"dw  "+Nm$+"_Text_Data+4"
			AddTran ANS$(Nm$,"Appearance")+"db  "+Str$(ObData(CFr,ObjNo,QPap)+(ObData(CFr,ObjNo,QPen)*4))
		;**** Button
		;**** Check	
		Case Cntr_Check
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"ValueAddr")+"dw  "+Nm$+"_Value"
			AddTran ANS$(Nm$,"Text")+"dw  "+Nm$+"_Text_Data+4"
			AddTran ANS$(Nm$,"TextAppearance")+"db  "+Str$(ObData(CFr,ObjNo,QPap)+(ObData(CFr,ObjNo,QPen)*4))
			AddTran ANS$(Nm$,"Value")+"dw  "+Str$(ObData(CFr,ObjNo,QVle))
		;**** Radio
		Case Cntr_Radio
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			ac=ObData(CFr,ObjNo,QGrp)
			If ObjNo=RadGroup(ObData(CFr,ObjNo,QGrp)) Then
				RadGroupCheck(ac)=ObjNo
			Else
				If RadGroupCheck(ac)=0 Then
					RadGroupCheck(ac)=1
				EndIf
			EndIf
			AddTran ANS$(Nm$,"GroupStatusAddr")+"dw  GroupStatus"+Str$(ObData(CFr,ObjNo,QGrp))
			AddTran ANS$(Nm$,"Text")+"dw  "+Nm$+"_Text_Data+4"
			AddTran ANS$(Nm$,"TextAppearance")+"db  "+Str$(ObData(CFr,ObjNo,QPap)+(ObData(CFr,ObjNo,QPen)*4))
			AddTran ANS$(Nm$,"Value")+"db  "+Str$(ObjNo)
			AddTran ANS$(Nm$,"GroupCoordAddr")+"dw  GroupCoord"+Str$(ObData(CFr,ObjNo,QGrp))
		;**** HSpinner
		Case Cntr_HSpinner
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"FixedValue")+"db  0"
			AddTran "     db  0    ;Not Used Yet"
			AddTran ANS$(Nm$,"Value")+"dw  "+Str$(ObData(CFr,ObjNo,QVle))	
			AddTran ANS$(Nm$,"Max")+"dw  "+Str$(ObData(CFr,ObjNo,QMax))	
			AddTran ANS$(Nm$,"ValueIncrease")+"db  1"
			AddTran ANS$(Nm$,"ValueDecrease")+"db  -1"			
			
		;**** VSpinner
		Case Cntr_VSpinner
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"FixedValue")+"db  0"
			AddTran "     db  0    ;Not Used Yet"
			AddTran ANS$(Nm$,"Value")+"dw  "+Str$(ObData(CFr,ObjNo,QVle))	
			AddTran ANS$(Nm$,"Max")+"dw  "+Str$(ObData(CFr,ObjNo,QMax))	
			AddTran ANS$(Nm$,"ValueIncrease")+"db  1"
			AddTran ANS$(Nm$,"ValueDecrease")+"db  -1"
		;**** HScroll
		Case Cntr_HScroll
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"FixedValue")+"db  "+Str$((ObData(CFr,ObjNo,QWnd)*2)+1)
			AddTran "     db  0    ;Not Used Yet"
			AddTran ANS$(Nm$,"Value")+"dw  "+Str$(ObData(CFr,ObjNo,QVle))	
			AddTran ANS$(Nm$,"Max")+"dw  "+Str$(ObData(CFr,ObjNo,QMax))	
			AddTran ANS$(Nm$,"ValueIncrease")+"db  "+Str$(ObData(CFr,ObjNo,QSte))
			AddTran ANS$(Nm$,"ValueDecrease")+"db  "+Str$(-(ObData(CFr,ObjNo,QSte)))
		;**** VScroll
		Case Cntr_VScroll
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"FixedValue")+"db  "+Str$(ObData(CFr,ObjNo,QWnd)) ;Str$((ObData(CFr,ObjNo,QWnd)*2)+1)
			AddTran "     db  0    ;Not Used Yet"
			AddTran ANS$(Nm$,"Value")+"dw  "+Str$(ObData(CFr,ObjNo,QVle))	
			AddTran ANS$(Nm$,"Max")+"dw  "+Str$(ObData(CFr,ObjNo,QMax))	
			AddTran ANS$(Nm$,"ValueIncrease")+"db  "+Str$(ObData(CFr,ObjNo,QSte))
			AddTran ANS$(Nm$,"ValueDecrease")+"db  "+Str$(-(ObData(CFr,ObjNo,QSte)))			
		;**** TabFrame	
		Case Cntr_TabFrame
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Additional Extra Data Record ****"
			AddTran ANS$(Nm$,"AdditionalExtData")
			AddTran ANS$(Nm$,"OldValue")+"db  "+Str$(ObData(CFr,ObjNo,QVle)-1)
			AddTran ANS$(Nm$,"Redraw")+"db  "+Str$(ObData(CFr,ObjNo,QDok))
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"Tabs")+"db  "+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"Appearance")+"db  "+Str$((ObData(CFr,ObjNo,QPen)*64)+(ObData(CFr,ObjNo,QPen)*16)+(ObData(CFr,ObjNo,QPen)*4)+(ObData(CFr,ObjNo,QPap)*1))
			AddTran ANS$(Nm$,"Value")+"db  "+Str$(ObData(CFr,ObjNo,QVle)-1)
			For j=0 To 7; ObData(CFr,ObjNo,QTab) ;QTab
				AddTran ANS$(Nm$,"Text_"+Str$(j))+"dw  "+Nm$+"_Text_"+Str$(j)+"_Data+4"
				AddTran ANS$(Nm$,"TabWidth"+Str$(j))+"db -1"
			Next
		;**** Drop
		Case Cntr_Drop
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			vf$=ObSData$(CFr,ObjNo,QStT)
			c1=0
			While Instr(vf$,"~|")
				vf$=Mid$(vf$,Instr(vf$,"~|")+2)
				c1=c1+1
			Wend			
			AddTran ANS$(Nm$,"Lines")+"dw  "+Str$(c1)+"  ;Number of Line Strings"
			AddTran ANS$(Nm$,"FirstLine")+"dw  1    ;2";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"ListAddr")+"dw  "+ObSData(CFr,ObjNo,QNam)+"_ListData ;4"
			AddTran "     dw  0      ;6";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"Column")+"db  1    ;8";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"ColumnAppearence")+"db  0   ;9";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"ColumnDataRecord")+"dw  "+ObSData(CFr,ObjNo,QNam)+"_ListColumnData    ;10"
			AddTran ANS$(Nm$,"ListClick")+"dw  0 ;12";+Str$(ObData(CFr,ObjNo,QTab))	
			p=ObData(CFr,ObjNo,QSli)
			AddTran ANS$(Nm$,"ListAppearence")+"db  "+Str$(p)+";Bit 0 Slider"			
			AddTran "     db  0    ;Not Used Yet"
			;Column stuff
			AddTran ANS$(Nm$,"ListColumnData")+"db  0   ;14";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran "     db  0    ;Not Used Yet"
			AddTran ANS$(Nm$,"ListColumnWidth")+"dw "+Str$(ObData(CFr,ObjNo,QWid))
			AddTran ANS$(Nm$,"ListColumnTitle")+"dw  "+nm$+"_Text_1_Data+4;"+Str$(ObData(CFr,ObjNo,QWid))
			AddTran "     db  0,0    ;Not Used Yet"
			AddTran ANS$(Nm$,"MaxLines")+"dw  "+Str$(ObData(CFr,ObjNo,QMax))+"  ;Max Number of Line Strings"			
			AddTran ANS$(nm$,"ListData")
			For p=1 To ObData(CFr,ObjNo,QMax)
				If p<=c1 Then 
					AddTran "             dw   0;"
					AddTran ANS$(nm$,"Text_"+Str$(p))+"dw "+nm$+"_Text_"+Str$(p)+"_Data+4"
				Else
					AddTran "             dw   0,0 ;Blank for expansion"
				EndIf
			Next
		;**** List
		Case Cntr_List
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			vf$=ObSData$(CFr,ObjNo,QStT)
			c1=0
			While Instr(vf$,"~|")
				vf$=Mid$(vf$,Instr(vf$,"~|")+2)
				c1=c1+1
			Wend
			AddTran ANS$(Nm$,"Lines")+"dw  "+Str$(c1)+"  ;Number of Line Strings"
			AddTran ANS$(Nm$,"FirstLine")+"dw  0    ;2";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"ListAddr")+"dw  "+ObSData(CFr,ObjNo,QNam)+"_ListData ;4"
			AddTran "     dw  0      ;6";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"Column")+"db  1   ;8";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"ColumnAppearence")+"db  0   ;9";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran ANS$(Nm$,"ColumnDataRecord")+"dw  "+ObSData(CFr,ObjNo,QNam)+"_ListColumnData    ;10"
			AddTran ANS$(Nm$,"ListClick")+"dw  0 ;12";+Str$(ObData(CFr,ObjNo,QTab))	
			
			p=ObData(CFr,ObjNo,QSli)+(ObData(CFr,ObjNo,QROn)*2)
			AddTran ANS$(Nm$,"ListAppearence")+"db  "+Str$(p)+"; Bit 0 Slider Bit 1 Multiselect"
			AddTran "     db  0    ;Not Used Yet"
			;Column stuff
			AddTran ANS$(Nm$,"ListColumnData")+"db  0   ;14";+Str$(ObData(CFr,ObjNo,QTab))
			AddTran "     db  0    ;Not Used Yet"
			AddTran ANS$(Nm$,"ListColumnWidth")+"dw "+Str$(ObData(CFr,ObjNo,QWid))
			AddTran ANS$(Nm$,"ListColumnTitle")+"dw  "+nm$+"_Text_1_Data+4;"+Str$(ObData(CFr,ObjNo,QWid))
			AddTran "     db  0,0    ;Not Used Yet"
			AddTran ANS$(Nm$,"MaxLines")+"dw  "+Str$(ObData(CFr,ObjNo,QMax))+"  ;Max Number of Line Strings"
			AddTran ANS$(nm$,"ListData")
			For p=1 To ObData(CFr,ObjNo,QMax)
				If p<=c1 Then 
					AddTran "             dw   0;"
					AddTran ANS$(nm$,"Text_"+Str$(p))+"dw "+nm$+"_Text_"+Str$(p)+"_Data+4"				
				Else
					AddTran "             dw   0,0 ;Blank for expansion"
				EndIf	
			Next
		;**** Super
		Case Cntr_Super
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")		
			AddTran ANS$(Nm$,"ControlWindowAddr")+"dw  "+ObSData(CFr,ObjNo,QNam)+"_ControlWindow"
			AddTran ANS$(Nm$,"ScrollWidth")+"dw  "+ObData(CFr,ObjNo,QWid)
			AddTran ANS$(Nm$,"ScrollHeight")+"dw  "+(ObData(CFr,ObjNo,QHei)/2)
			AddTran ANS$(Nm$,"OffsetLeft")+"dw  0"
			AddTran ANS$(Nm$,"OffsetTop")+"dw  0"
			AddTran ANS$(Nm$,"ScrollBars")+"db  "+((ObData(CFr,ObjNo,QVSc)*2)+ObData(CFr,ObjNo,QHSc))
		;**** TextLine
		Case Cntr_TextLine
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"Text")+"dw  "+Nm$+"_Text_Data+4"
			AddTran ANS$(Nm$,"FDC")+"dw  0"
			AddTran ANS$(Nm$,"CurPos")+"dw  "+Str$(Len(ObSData(CFr,ObjNo,QCap)))
			AddTran ANS$(Nm$,"Selected")+"dw  0"
			AddTran ANS$(Nm$,"InputLen")+"dw  "+Str$(Len(ObSData$(CFr,ObjNo,QCap)))
			If ObData(CFr,ObjNo,QMxC)<Len(ObSData$(CFr,ObjNo,QCap)) Then
				AddTran ANS$(Nm$,"InputMax")+"dw  "+Str$(Len(ObSData$(CFr,ObjNo,QCap)))
			Else	
				AddTran ANS$(Nm$,"InputMax")+"dw  "+Str$(ObData(CFr,ObjNo,QMxC))
			EndIf	
			AddTran ANS$(Nm$,"Password")+"db  0"
			AddTran ANS$(Nm$,"Text_Data")+"dw  "+Nm$+"_Text:dw "+Str$(ObData(CFr,ObjNo,QMxC))	
			AddTran ANS$(Nm$,"Input")+"db  "+Chr$(34)+ObSData$(CFr,ObjNo,QCap)+Chr$(34)+",0"
			AddTran "    ds  "+Str$(ObData(CFr,ObjNo,QMxC)-Len(ObSData$(CFr,ObjNo,QCap)))
		;**** TextBox
		Case Cntr_TextBox
			AddTran ";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
			AddTran ANS$(Nm$,"ExtData")
			AddTran ANS$(Nm$,"Text")+"dw  "+Nm$+"_Text_Data+4 ;0"			
			AddTran ANS$(Nm$,"Empty1")+"dw  0 ;2"
			AddTran ANS$(Nm$,"CurrPos")+"dw  0 ;4"
			AddTran ANS$(Nm$,"Selected")+"dw  0 ;6"
			AddTran ANS$(Nm$,"InputLen")+"dw  "+Str$(Len(ObSData$(CFr,ObjNo,QCap)))+" ;8"
			If ObData(CFr,ObjNo,QMxC)<Len(ObSData$(CFr,ObjNo,QCap)) Then
				AddTran ANS$(Nm$,"InputMax")+"dw  "+Str$(Len(ObSData$(CFr,ObjNo,QCap)))+" ;10"
			Else	
				AddTran ANS$(Nm$,"InputMax")+"dw  "+Str$(ObData(CFr,ObjNo,QMxC))+" ;10"
			EndIf
			ade=0
			If ObData(CFr,ObjNo,QROn)=1 Then ade=ade+2
			If ObData(CFr,ObjNo,QEPa)=1 Then ade=ade+4
			AddTran ANS$(Nm$,"ReadOnly")+"db  "+Str$(ade)+" ;12"
			If ObData(CFr,ObjNo,QEPa)=1 Then
				AddTran ANS$(Nm$,"TextPalette")+"db  "+Str$(ObData(CFr,ObjNo,QPap)+(ObData(CFr,ObjNo,QPen)*16))+" ;13"
			Else
				AddTran ANS$(Nm$,"TextPalette")+"db  0 ;13"
			EndIf	
			AddTran ANS$(Nm$,"Empty2")+"db  0 ;14"
			AddTran ANS$(Nm$,"Font")+"dw  0 ;15"
			AddTran ANS$(Nm$,"Empty3")+"db  0 ;17"			
			AddTran ANS$(Nm$,"Lines")+"dw  1 ;18"
			AddTran ANS$(Nm$,"Pixel")+"dw  -1 ;20"
			AddTran ANS$(Nm$,"LinesMax")+"dw  "+Str$(ObData(CFr,ObjNo,QMLi))+" ;22"
			AddTran ANS$(Nm$,"Empty4")+"dw  -8 ;24"
			AddTran ANS$(Nm$,"Empty5")+"dw  0 ;26"	
			AddTran ANS$(Nm$,"Empty6")+"dw  "+Nm$+"_ExtData ;28"	
			AddTran ANS$(Nm$,"Empty7")+"dw  0 ;30"	
			AddTran ANS$(Nm$,"Empty8")+"dw  0 ;32"	
			AddTran ANS$(Nm$,"Empty9")+"dw  0 ;34"	
			AddTran ANS$(Nm$,"Empty10")+"dw  0 ;36"
			AddTran ANS$(Nm$,"WordWrap")+"db  2 ;38"	
			AddTran ANS$(Nm$,"TabStop")+"db  0 ;39"
			AddTran ANS$(Nm$,"Empty11")+"db  0,0,0,0 ;40"
			AddTran ANS$(Nm$,"Empty12")+"db  0,0,0,0 ;44"
			For l=1 To ObData(CFr,ObjNo,QMLi)
				AddTran ANS$(Nm$,"Line"+Str$(l))+"dw  0 ;"+Str$((l*2)+46)
			Next
			AddTran ANS$(Nm$,"Text_Data")+"dw  "+Nm$+"_Text:dw "+Str$(ObData(CFr,ObjNo,QMxC))	
			AddTran ANS$(Nm$,"Input")+"db  "+Chr$(34)+ObSData$(CFr,ObjNo,QCap)+Chr$(34)+",0"
			AddTran "    ds  "+Str$(ObData(CFr,ObjNo,QMxC)-Len(ObSData$(CFr,ObjNo,QCap)))
	End Select
	
;	;**** ImageBox
;	If ObData(CFr,ObjNo,QTyp)=12 Then
;		Ed$(EdL1+0,1)=";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
;		Ed$(EdL1+1,1)=ANS$(Nm$,"ExtData")
;		EdL1=EdL1+2
;		Ed$(EdL1+0,1)=ANS$(Nm$,"Addr")+"db  6,24,24"
;		Ed$(EdL1+1,1)="   ds  24*6"
;		EdL1=EdL1+2		
;	EndIf
	
	;**** Progress
	;If TypNo(ObData(CFr,ObjNo,QTyp))=4 Then
	;	Ed$(EdL2+0,2)=";**** Object ("+ObSData(CFr,ObjNo,QNam)+") Extra Data Record ****"
	;	Ed$(EdL2+1,2)=Ans$(Nm$,"ExtData")
	;	n8=(ObData(CFr,ObjNo,QLn1)*1)+(ObData(CFr,ObjNo,QLn2)*4)+(ObData(CFr,ObjNo,QPen)*16)+(ObData(CFr,ObjNo,QPap)*64)
	;	Ed$(EdL2+2,2)=Ans$(Nm$,"Appearance")+"db  "+Str$(n8)
	;	Ed$(EdL2+3,2)=Ans$(Nm$,"Value")+"db  "+Str$(ObData(CFr,ObjNo,QVle))
	;	EdL2=EdL2+4
	;EndIf
	If TypNo(ObData(CFr,ObjNo,QTyp))=99 And CodeFound(CFr,ObjNo)>0 Then
		AddData ANS$(Nm$,"Data")
		AddData ANS$(Nm$,"Active")+"db  "+Str$(ObData(CFr,ObjNo,QAct))
		AddData ANS$(Nm$,"Status")+"db  0"
		AddData ANS$(Nm$,"Value")+"dw  "+Str$(ObData(CFr,ObjNo,QVle))
		AddData ANS$(Nm$,"Max")+"dw  "+Str$(ObData(CFr,ObjNo,QVle))
		AddData ANS$(Nm$,"Addr")+"dw  "+ObSData$(CFr,ObjNo,QNam)+"_Event"
		Timer$=Timer$+ObSData$(CFr,ObjNo,QNam)+"_Data,"
	EndIf
End Function

Function AddCode(add$)
	Ed$(EdL0,0)=add$
	EdL0=EdL0+1
End Function
Function AddData(add$)
	Ed$(EdL1,1)=add$
	EdL1=EdL1+1
End Function
Function AddTran(add$)
	Ed$(EdL2,2)=add$
	EdL2=EdL2+1
End Function

Function CalcString$(s1$,a)
	a1=Len(s1$)
	b1=a-a1
	If b1<1 Then
		s1$=Chr$(34)+s1$+Chr$(34)+",0"
	Else
		s1$=Chr$(34)+s1$+Chr$(34)+":"
		s2$=" ds "+Str$(b1)+",0"
		s1$=s1$+s2$
	EndIf
	Return s1$
End Function
Function CreateFormIcon(CFr,ObjNo)
	Nm$=ObSData(CFr,ObjNo,QNam)
	AddData ";**** Form Icon ****
	AddData "."+Nm$+"_Icon:"
	AddData "        db 2,8,8"
	
	If GrpImage(ObData(CFr,ObjNo,QGra))<>0 Then
		w1=GrpWid(ObData(CFr,ObjNo,QGra))
		w2=0
		If (w1 Mod 4)>0 Then w2=1
		w1=((w1/4)+w2)-2				;Original Image Byte width
		t1=0
		r$="    db  "
		For n8=1 To 8
			For n9=1 To 2
				t0=PeekByte(GrpBank(ObData(CFr,ObjNo,QGra)),t1)
				r$=r$+"#"+Right$("00"+Hex$(ConvertScreenByte(t0)),2)+","
				t1=t1+1
			Next	
			t1=t1+w1
		Next	
		AddData Left$(r$,Len(r$)-1)
	Else
		AddData "    db 0,0,0,0,0,0,0,0"
	EndIf
End Function
Function CreateAppIconSmall()
	Ed$(EdL0+0,0)="        db 2,8,8"
	EdL0=EdL0+1
	If GrpImage(ApIconSmall)<>0 Then
		w1=GrpWid(ApIconSmall)
		w2=0
		If (w1 Mod 4)>0 Then w2=1
		w1=((w1/4)+w2)-2				;Original Image Byte width
		t1=0
		r$="      db  "
		For n8=1 To 8
			For n9=1 To 2
				t0=PeekByte(GrpBank(ApIconSmall),t1)
				r$=r$+"#"+Right$("00"+Hex$(ConvertScreenByte(t0)),2)+","
				t1=t1+1
			Next	
			t1=t1+w1
		Next	
		Ed$(EdL0+0,0)=Left$(r$,Len(r$)-1)
		EdL0=EdL0+1
	Else
		Ed$(EdL0+0,0)="      db     15,15,14,3,13,13,73,73,73,73,75,75,60,135,15,15"
		EdL0=EdL0+1
	EndIf
End Function
Function CreateAppIconLarge()
	Ed$(EdL0+0,0)=".AppIcnLrg       db 6,24,24"
	EdL0=EdL0+1
	
	If GrpImage(ApIconLarge)<>0 Then
		t2=GrpCBank(ApIconLarge,1)
		For h=0 To 23
			r$="      db  "
			For i=0 To 23 Step 4
				t1=i+(h * (GrpCWid(ApIconLarge,1)*4))
				j1=PeekByte(t2,t1)Shl 6
				j2=PeekByte(t2,t1+1)Shl 4
				j3=PeekByte(t2,t1+2)Shl 2
				j4=PeekByte(t2,t1+3)
				j1=j1+j2+j3+j4
				r$=r$+"#"+Right$("00"+Hex$(ConvertScreenByte(j1)),2)+","
			Next
			Ed$(EdL0+0,0)=Left$(r$,Len(r$)-1)
			EdL0=EdL0+1
		Next
	Else
		Ed$(EdL0+0,0)="      db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"
		Ed$(EdL0+1,0)="      db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"
		Ed$(EdL0+2,0)="      db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"		
		EdL0=EdL0+3
	EndIf
End Function
Function CreateString(ObjNo,Oper$,Oper2$)
	Nm$=ObSData(CFr,ObjNo,QNam)
	Ed$(EdL2+0,2)=ANS$(Nm$,Oper$)+"db "+Chr$(34)+Oper2$+Chr$(34)+",0"
	EdL2=EdL2+1
End Function
Function ANS$(Objt$,Oper$)
	Ss$="."+Objt$+"_"+Oper$+":"
	If Len(ss$)<32 Then
		Return Left$(Ss$+"                               ",32)
	Else
		Return Ss$
	EndIf	
End Function
Function SaveFormTemp()
	FileOut = WriteFile("tempform.dat")
	For nr=0 To NoOfFrms
		a=0
		For f1=0 To 255
			For g1=0 To 49
				If ObData(nr,f1,g1)<>0 Then
					a=a+1
				EndIf
			Next
			For g1=0 To 49
				If ObSData$(nr,f1,g1)<>"" Then
					a=a+1
				EndIf
			Next		
		Next
		WriteInt(Fileout,a)
		For f1=0 To 255
			For g1=0 To 49
				If ObData(nr,f1,g1)<>0 Then
					WriteInt(FileOut,0)			
					WriteInt(Fileout,f1)
					WriteInt(Fileout,g1)
					WriteFloat(Fileout,ObData(nr,f1,g1))
				EndIf
			Next
			For g1=0 To 49
				If ObSData$(nr,f1,g1)<>"" Then
					WriteInt(FileOut,1)			
					WriteInt(Fileout,f1)
					WriteInt(Fileout,g1)
					WriteLine(Fileout,ObSData$(nr,f1,g1))
				EndIf
			Next		
		Next
	Next
	CloseFile(FileOut)
End Function
Function OpenFormTemp()
	Filein = OpenFile("tempform.dat")
	For nr=0 To NoOfFrms
		For f1=0 To 255
			For g1=0 To 49
				ObData(nr,f1,g1)=0
				ObSData$(nr,f1,g1)=""
			Next
		Next 
		a=ReadInt(Filein)
		b=0
		While b<a
			c=ReadInt(Filein)
			c1=ReadInt(Filein)
			c2=ReadInt(Filein)
			If c=0 Then
				ObData(nr,c1,c2)=ReadFloat(Filein)
			EndIf
			If c=1 Then
				ObSData$(nr,c1,c2)=ReadLine(Filein)
			EndIf
			b=b+1
		Wend
	Next
	CloseFile(Filein)
End Function
Function ParentStuff(CFr)


	;**** Set QPr2 = QPr2 is the ParentNumber

	For f=1 To 254
		a1=f
.Backdraft
		If (ObData(CFr,a1,QPar)Mod 256)>0 Then
			a1=ObData(CFr,a1,QPar)Mod 256
			Goto Backdraft
		EndIf

		

	Next




	p=1
	For f=1 To 254
		ObData(CFr,f,QDok)=0


	Next



;	p=1
;	For f=1 To 254
;
;
;
;	
;		ObData(CFr,f,QDok)=p
;		If ObData(CFr,f,QTyp)=13 Then		;Tab
;			For g=1 To ObData(CFr,f,QTab)
;				Par(p)=(f)+(g*256)
;				p=p+1
;			Next
;		EndIf
;	Next
;	For f=1 To 254
;		a=ObData(CFr,f,QPar)
;.Blib
;		If a>1 And a<256 Then
;			a=ObData(Cfr,a,QPar)
;			Goto Blib
;		EndIf	
;		e=0
;		If p>1 Then
;			For g=1 To p-1
;				If a=Par(g)Then e=g
;			Next
;		EndIf	
;		ObData(CFr,f,QPr2)=e
;	Next
End Function
Function SortForm(CFr)
	Return
	uy=1
	.Pinchard
	uf=0
	For f9=uy To 255
		If ObData(CFr,f9,QTyp)=13 Then			;**** Tab
			uf=1
			For n1=255 To f9+1 Step -1
				For g1=0 To 60
					ObData(CFr,n1,g1)=ObData(CFr,n1-1,g1)
					ObSData$(CFr,n1,g1)=ObSData$(CFr,n1-1,g1)
				Next
				If ObData(CFr,n1,QPar)=>f9 Then ObData(CFr,n1,QPar)=ObData(CFr,n1,QPar)+1
			Next
			ObSData$(CFr,f9,QNam)="Fr_"+ObSData$(CFr,f9+1,QNam) 		;**** Name
			ObData(CFr,f9,QTyp)=14										;**** Type (Frame = 2)
			ObData(CFr,f9,QPar)=ObData(CFr,f9+1,QPar)					;**** Parent
			ObData(CFr,f9,QTop)=ObData(CFr,f9+1,QTop)+20				;**** Top
			ObData(CFr,f9,QLef)=ObData(CFr,f9+1,QLef)					;**** Left
			ObData(CFr,f9,QWid)=ObData(CFr,f9+1,QWid)					;**** Width
			ObData(CFr,f9,QHei)=ObData(CFr,f9+1,QHei)-20				;**** Height
			ObData(CFr,f9+1,QHei)=20									;**** Put in proper SymBos Tab Height
			ObData(CFr,f9,QPen)=ObData(CFr,f9+1,QPen)  	     		  	;**** Pen
			ObData(CFr,f9,QPap)=ObData(CFr,f9+1,QPap)  	      		 	;**** Paper
			uy=f9+2
			f9=255
		EndIf
	Next
	If uf=1 Then Goto Pinchard
End Function
Function ConvertScreenByte(ry)
	t1=(ry Shr 6)And 3
	t2=(ry Shr 4)And 3
	t3=(ry Shr 2)And 3
	t4=ry And 3
	If t1=1 Then
		t1=2
	Else If t1=2 Then
		t1=1
	EndIf	
	If t2=1 Then
		t2=2
	Else If t2=2 Then
		t2=1
	EndIf
	If t3=1 Then
		t3=2
	Else If t3=2 Then
		t3=1
	EndIf
	If t4=1 Then
		t4=2
	Else If t4=2 Then
		t4=1
	EndIf
	ry=(t1*64)+(t2*16)+(t3*4)+(t4)

	s7=(ry And 128)
	s6=(ry And 64) Shr 3
	s5=(ry And 32) Shl 1
	s4=(ry And 16) Shr 2
	s3=(ry And 8) Shl 2
	s2=(ry And 4) Shr 1
	s1=(ry And 2) Shl 3
	s0=(ry And 1)
	Return (s7+s6+s5+s4+s3+s2+s1+s0)
End Function
Function ExtDataNeeded(CFr,ObjNo)
	e9=1
	n9=ObData(CFr,ObjNo,QTyp)
	If n9=12 Then e9=0	
	If n9=14 Then e9=0
	If n9=15 Then e9=0
	If n9=16 Then e9=0
	Return e9
End Function


;~IDEal Editor Parameters:
;~F#B7#275#447#46D#4A1#4A6#4AE#4D4#4EE
;~B#155
;~C#Blitz3D