Function Assembler(debug=0)
	CurrWhile=0
	CodeType=0
	ChangeDir CDir$
	
	;Library Stuff load
	For f=1 To 1024
		LbUsed(f)=0
		LbName$(f)=""
	Next
	a=1
	LbFound=0
	Filein = OpenFile("sys\lib-basic.asm")
	While Not Eof(Filein) 
		r$=ReadLine$(Filein)
		If Trim(r$)>""Then 
			Lb$(a)=r$
			r$=Trim(r$)
			If Mid(Trim$(r$),1,1)=";"Then
				r$=Trim(Mid$(r$,2))
				If Upper$(Mid$(r$,1,8))="LIBRARY "Then
					r$=Trim(Upper$(Mid$(r$,9)))
					If LbFound>0 Then
						LbEnd(LbFound)=a-1
					EndIf	
					LbFound=LbFound+1
					LbName$(LbFound)=r$
					LbStart(LbFound)=a
				EndIf	
			EndIf
			a=a+1
		EndIf	
	Wend
	If LbFound>0 Then LbEnd(LbFound)=a
	
	CloseFile(Filein)
	
	FileOut = WriteFile("sys\tempcode.asm")
	For f=1 To Lstline
		WriteLine(FileOut,Cd$(f))
	Next
	CloseFile (FileOut)
	LoC=0
	
	VarNo=0
	Err=0
	GetDeclares("sys\form.asm")
	If Err>0 Then CurrLine=ErrLn:Goto BitterBit2	
	GetFunctions("sys\form.asm")
	If Err>0 Then CurrLine=ErrLn:Goto BitterBit2	
	Cod=0
	;**** Clean the Old Stuff
	For g=1 To 3
		For f=0 To 65535
			PokeByte MemoryBank(g),f,0
		Next
	Next
	Failed=0
	OrgVer=1
	UnRef=0
	N_Stack_Count=0
	.LoopyLoo
	
	FLine=0
	
	For f=0 To LabCount
		Lab$(f)="":LabT(f)=0:LabV(f)=0:LabOK(f)=0:LabRef(f)=0
	Next
	LoopNum=0
	LabCount=0
	If OrgVer=1 Then MemBank=MemoryBank(1)
	If OrgVer=2 Then MemBank=MemoryBank(2)
	Readout$=""
	Pass=1:Err=0
	Failed3=65536
	DirectCommand=0
	CurrIf=0:CurrWend=0:CurrRepeat=0:CurrExit=0
	For f=0 To 255
		For g=0 To 255
			ExitWhere(f,g)=0
		Next
	Next
.LakePlacid
	LibIgnore=0
	If Pass=1 Then
		AddNewLog("< ASSEMBLER > Definition Pass 1.... ",0)
	Else	
		AddNewLog("< ASSEMBLER > Compile Pass 2.... ",0)
	EndIf
	
	
	PC=0:PC1=0
	FaF=1
	ForceEndIf=0
	ErrMessage$=""
	
	;**** Process ****
	While FaF<=LoC+LibEnd
		If ForceEndIf>0 Then BasicForceEndIf():ForceEndIf=0
		CurrLine=FaF
		Cod=1
		Answer$=Seperate2$(FaF)
.BlimBlam
		If Err<>0 Then Goto BitterBit2
		Okay=0
		r$=Upper$(SepSort$(Cod))
		If Mid$(r$,1,10)="SYMBASLINE"Then 
			Cod=Cod+1
			r$=Upper$(SepSort$(Cod))
			
			CurrBasL=GetDecimal(r$,1,0)
			Cod=Cod+1
			r$=Upper$(SepSort$(Cod))
		EndIf
		If r$=";"Or r$="" Or r$="/"Or r$="GLOBAL" Or r$="INCLUDESHEET" Or r$="INCLUDEFILE"Then Goto FunkTurd
		If r$=":"Then
			Cod=Cod+1
			Goto BlimBlam
		EndIf
		r9$=Mid$(r$,1,1)
		If r9$<>"."Then 
			If Okay=0 Then
				If r$="AFUNCTION"Then 
					FuncFunction(Cod)
					CodeType=0
					Okay=1
				EndIf	
			EndIf
			If Okay=0 Then
				If r$="FUNCTION"Then 
					FuncFunction(Cod)
					CodeType=1
					Okay=1
				EndIf
			EndIf	
			If CodeType=0 Then
				If Okay=0 Then 
					CompileZ80(r$)
				EndIf	
			Else
				If Okay=0 Then CompileBasic(r$)
				If Okay=0 Then
					For f=1 To FuncNo
						If Upper$(Func$(f))=r$ Then
							BasicCallFunction(Cod,f)
							f=FuncNo+1
							Okay=1
						EndIf
					Next
				EndIf
				If Okay=0 Then
					For f=1 To VarNo
						If Upper$(VarName$(f))=r$ Or Upper$(VarName2$(f))=r$ Then
							If VarType(f)>3999 And VarType(f)<4200 Then
								;BasicControlFunction(Cod,Lower$(r$),VarCont(f)/256,VarCont(f)Mod 256)
								BasicControlFunction(VarType(f),VarCont(f)/256,VarCont(f)Mod 256)
							Else	
								BasicLET(Cod,f)
							EndIf
							f=VarNo+1
							Okay=1
						EndIf
					Next
				EndIf
			EndIf
		EndIf	
		;**** Is it a Label
		If Okay=0 Then
			If (Mid$(r9$,1,1)="." And CodeType=1) Or CodeType=0 Then
				n=FuncAddLabel(Cod)
				If CodeType=0 Then 
					Final$(FLine)=r$
					FLine=FLine+1
				EndIf	
				If n=1 Then
					r$=Upper$(SepSort$(Cod))
					If r$<>""Then Goto BlimBlam
					If r$=":"Then
						Cod=Cod+1
						Goto BlimBlam
					EndIf
				EndIf
			EndIf
		EndIf
.BitterBit
		;**** Multiple commands on line
		If Okay=1 Then
			r$=Upper$(SepSort$(Cod))
			If r$=":"Then
				Cod=Cod+1
				Goto BlimBlam
			EndIf
			If r$="ELSE" And CodeType=1 And ForceEndIf=1 Then
				Goto BlimBlam
			EndIf
			If DirectCommand=1 Then
				DirectCommand=0
				Goto BlimBlam
			EndIf
		EndIf
.BitterBit2		
If Okay=0 Or Err<>0 Then
			If Err<>0 Then
				If Err=10 Then
					AddNewLog("< ASSEMBLER > "+Str$(Okay)+" "+Str$+(CodeType)+"Duplicate Defintion in Line "+Str(CurrBasL)+" - "+Cd$(FaF))
				EndIf
				;****
				;**** Basic Error Messages ****
				;****
				If Err>40 Then
					AddNewLog("< ASSEMBLER > **** "+ErrMessage$+" in Line "+Str(FaF)+" - "+Cd$(FaF))
				EndIf
			Else
				r$=Upper$(SepSort$(Cod))
				AddNewLog("< ASSEMBLER > Illegal Operand in line "+Str(FaF)+" - "+r$)
			EndIf
			CrrLine=CurrBasL
			GUI_Prop_Range(VScr,0,(Floor(FontH2*Lstline)+32)+FontH2#)
			df=(((Floor(FontH2*Lstline)+32)+FontH2#)/(Lstline+10))*CrrLine
			GUI_SetVal(VScr,df)
			Goto EndItAll
		EndIf
.FunkTurd
		FaF=FaF+1
	Wend
	;**** Process End
	
	h=0
	If OrgVer=1 And Pass=1 Then
		For f=1 To UnRef
			t=0
			For g=1 To LabCount
				If Lab$(g)=UnRefLab$(f)Then
					If LabOK(g)<>0 Then
						t=1
						g=LabCount
					EndIf	
				EndIf
			Next
			If t=0 Then
				AddNewLog("< ASSEMBLER > **** "+Cd$(UnRefLin(f)))
				AddNewLog("< ASSEMBLER > -"+UnRefLab$(f)+"- Undefined Symbol in Line "+Str$(UnRefLin(f)))
				h=1
			EndIf
		Next
	EndIf
	
	;RuntimeError(Readout$)
	
	If h=1 Then Goto EndItAll

	If Pass=1
		rw$="< ASSEMBLER > Pass 1 (Success) "+Str$(LoC)+" Lines [Size "+Str$(PC-Org(OrgVer))+" -"
		rw$=rw$+" Data "+Str$(GetRoutineLocation("AppTrnBeg")-GetRoutineLocation("AppDatBeg"))+" -"
		rw$=rw$+" Code "+Str$(GetRoutineLocation("Syb_CodeEnd")-GetRoutineLocation("AppCodBeg"))+" -"
		rw$=rw$+" Trans "+Str$(GetRoutineLocation("AppTrnEnd")-GetRoutineLocation("AppTrnBeg"))+" - "+Str$(PC1)+"]"
		AddNewLog(rw$)
	Else	
		AddNewLog("< ASSEMBLER > Pass 2 (Success) "+Str$(LoC)+" Lines ["+Str$(PC-Org(OrgVer))+" bytes]")
	EndIf
	Fin(OrgVer)=PC
	For f=1 To LabCount
		LabRef(f)=0
	Next	
	UnRef=0
	If Failed>=Failed3 Then Stop
	If Failed>0 Then
		Failed3=Failed
		Failed=0
		Pass=Pass+1
		Goto LakePlacid
	EndIf
	
	If debug=1 Then r4=1:Goto EndItAll
	
	OrgVer=OrgVer+1
	If OrgVer=2 Then Goto LoopyLoo
	

	Orig=PeekShort(MemoryBank(1),Org(1)+6)
	nr=1
	Reloc$ = ""
	p1=0
	For f=Org(1) To Fin(1)
		Wert1=PeekShort(MemoryBank(1),f)
		Wert2=PeekShort(MemoryBank(2),f+258)
		If (Wert1+258=Wert2) Then
			Reloc$=Reloc$+Chr$((nr+Orig-1)Mod 256)+Chr$(Int((nr+orig-1)/256))
			p1=p1+1
		EndIf
		nr=nr+1
	Next

	nr=Fin(1)-Org(1)
	

	nr=0
	For f=Org(1) To Org(1)+7
		PokeByte MemoryBank(3),nr,PeekByte(MemoryBank(1),f)
		nr=nr+1
	Next
	PokeShort MemoryBank(3),8,p1
	nr=10
	For f=Org(1)+10 To Fin(1)
		PokeByte MemoryBank(3),nr,PeekByte(MemoryBank(1),f)
		nr=nr+1
	Next
	nr=Fin(1)-Org(1)
	For f=1 To Len(Reloc$)
		PokeByte MemoryBank(3),nr,Asc(Mid$(Reloc$,f,1))
		nr=nr+1
	Next
	
	;**** Output the Final Assembler Listing
	FileOut = WriteFile("sys\listing.asm")
	For f=0 To FLine
		WriteLine(FileOut,Final$(f))
	Next
	CloseFile (FileOut)	
	
	;**** Output Files ****
	ChangeDir(CDir$+"output")
	filebank=WriteFile(ApName$+".exe")
	WriteBytes MemoryBank(3),filebank,0,nr
	CloseFile filebank
	If CompileType=0 Then 
		AddNewLog("< ASSEMBLER > File "+Chr$(34)+"\Output\"+Lower$(File$)+".dsk"+Chr$(34)+" created.")
	Else
		e$=Dsk1$
		Filename$=""
		If FileType(e$+".dsk")=1 Then				;File exist
			ee=OpenFile(e$+".dsk")
			If ee=0 Then 
				AddNewLog("< ASSEMBLER > **** Primary development DSK in use. Secondary used")
				e$=Dsk2$
			Else
				CloseFile(ee)
			EndIf
		EndIf
		DeleteFile e$+".dsk"
		If CompileType=1 Then
			filename$="cpcxfsw.exe -nd "+e$+" -p "+ApName$+".exe "+ApName$+".exe"
			For f=1 To IncNo
				filename$=filename$+Chr$(13)+Chr$(10)+"cpcxfsw.exe "+e$+" -p "+IncFile$(f)+" "+IncFile$(f)
			Next
			ExecFile(filename$)
			AddNewLog("< ASSEMBLER > CPC DSK "+Chr$(34)+"\Output\"+e$+".dsk"+Chr$(34)+" created.")
		EndIf
		If CompileType=2 Then
			
			filename$="DSKTOOL A "+e$+".dsk "+ApName$+".exe"
			For f=1 To IncNo
				filename$=filename$+" "+IncFile$(f)
			Next
			ExecFile(filename$)
			AddNewLog("< ASSEMBLER > MSX DSK "+Chr$(34)+"\Output\"+e$+".dsk"+Chr$(34)+" created.")
		EndIf	
		ChangeDir(CDir$)
	EndIf	
	r4=1
.EndItAll

	For f=1 To LabCount
		LabRef(f)=0
		Lab$(f)=""
		LabT(f)=0
		LabV(f)=0
		LabOK(f)=0
	Next
	For f=1 To UnRef
		UnRefLab$(f)=""
		UnRefLin(f)=""
	Next
	ChangeDir CDir$
	Filein = ReadFile("sys\tempcode.asm")
	For f=1 To Lstline
		Cd$(f)=ReadLine$(Filein)
	Next
	CloseFile (Filein)
	If r4=1 Then		
		AddNewLog("< ASSEMBLER > Assembly Completed Successfully")
	Else
		AddNewLog("< ASSEMBLER > ERRORS - Assembly Unsuccessful in Line "+Str$(CurrBasL))
	EndIf
	;CloseFile Sporax	
End Function

Function CompileBasic(r$)
	
	If Mid$(r$,1,1)<"M"Then
		If r$="APP.BANK.FREE"Then BasicFreeBank():Return					;Done Instructions
		If r$="APP.SHEET.FREE"Then BasicFreeBank():Return					;Done Instructions
		If r$="APP.BANK.CLEAR"Then BasicClearBank():Return					;Don Instruction
		If r$="APP.POKEBYTE"Then BasicPokeByte():Return
		If r$="APP.POKEINT"Then BasicPokeInt():Return
		If r$="APP.POKEFLOAT"Then BasicPokeFloat():Return
		
		If r$="CLEARBANK"Then BasicClearBank():Return						;Done Instruction
		If r$="CLOSEFILE"Then BasicCloseFile():Return
		If r$="CLOSEFORM"Then BasicCloseForm():Return
		If r$="CODE"Then FuncCODE():Return
		If r$="CONTROL.CTRLABEL.PEN.SET" Then BasicSetCtrLabelObjPen():Return
		If r$="CONTROL.CTRLABEL.PAPER.SET" Then BasicSetCtrLabelObjPaper():Return		
		If r$="CONTROL.REFRESH" Then BasicRefreshObj():Return
		If r$="CONTROL.POSITION.SET" Then BasicSetObjPos():Return
		If r$="CONTROL.TEXT.SET" Then BasicSetObjText():Return
		If r$="CONTROL.PAINT.PEN.SET" Then BasicSetPaintObjPen():Return		
		If r$="CONTROL.WIDTH.SET"Then BasicSetObjWidth():Return
		If r$="CONTROL.HEIGHT.SET"Then BasicSetObjHeight():Return
		If r$="CONTROL.VISIBLE.SET"Then BasicSetObjVisible():Return
		If r$="CONTROL.TILE.SET"Then BasicSetObjGraphic():Return
		If r$="CONTROL.REFRESHALL"Then BasicRefreshAll():Return
		If r$="CONTROL.GRAPHIC.SET"Then BasicSetObjGraphic():Return
		
		If r$="DIRECTORY_NEW" Or r$="DIRECTORY.NEW" Then BasicDirectoryNew():Return
		If r$="DIRECTORY_DELETE" Or r$="DIRECTORY.DELETE" Then BasicDirectoryDelete():Return
		If r$="DIRECTORY_RENAME" Or r$="DIRECTORY.RENAME" Then BasicDirectoryRename():Return
		If r$="DIRECTORY_MOVE" Or r$="DIRECTORY.MOVE" Then BasicDirectoryMove():Return		
		If r$="DEG"Then BasicDeg():Return
		If r$="DI"Then BasicDi(Cod):Return
		If r$="DRAWTILE"Then BasicDrawTile(Cod):Return
		
		If r$="EI"Then BasicEi(Cod):Return
		If r$="ELSE"Then BasicElse(Cod):Return
		If r$="ENDIF"Then BasicEndIf(Cod):Return
		If r$="ENDF" Or r$="ENDFUNCTION" Then FuncENDF():Return
		If r$="ERROR.CLEAR"Then BasicErrorClear():Return
		If r$="EXIT"Then BasicExit(Cod):Return
		
		If r$="FILE.CLOSE"Then BasicCloseFile():Return
		If r$="FILE.BYTE.WRITE"Then BasicWriteByte():Return
		If r$="FILE.INT.WRITE"Then BasicWriteInt():Return
		If r$="FILE.FLOAT.WRITE"Then BasicWriteFloat():Return
		If r$="FILE.LINE.WRITE"Then BasicWriteLine():Return
		If r$="FOREVER"Then BasicForever(Cod):Return
		If r$="FOR"Then BasicFor(Cod):Return
		If r$="FREEBANK"Then BasicFreeBank():Return							;Done Instructions
		If r$="FREESHEET"Then BasicFreeBank():Return						;Done Instructions
		
		If r$="FORM.CLOSE"Then BasicCloseForm():Return
		If r$="FORM.POSITION.SET" Then BasicSetFormPos():Return
		If r$="FORM.SIZE.SET" Then BasicSetFormSize():Return
		If r$="FORM.STATUS.REFRESH"Then BasicRefreshStatus():Return
		If r$="FORM.MENU.REFRESH"Then BasicRefreshMenu():Return
		If r$="FORM.TITLE.REFRESH"Then BasicRefreshTitle():Return
		
		If r$="GOTO"Then BasicGoto(Cod):Return
		If r$="GARBAGE"Then BasicGarbage(Cod):Return
		
		If r$="IF"Then BasicIF():Return
	Else
		If r$="MATH.RANDOMIZE"Then BasicRandomize():Return
		If r$="MATH.RAD"Then BasicRad():Return
		If r$="MATH.DEG"Then BasicDeg():Return
		
		If r$="NEXT"Then BasicNext(Cod):Return
		
		If r$="POKEBYTE"Then BasicPokeByte():Return
		If r$="POKEINT"Then BasicPokeInt():Return
		If r$="POKEFLOAT"Then BasicPokeFloat():Return
		
		If r$="RAD"Then BasicRad():Return
		If r$="RANDOMIZE"Then BasicRandomize():Return
		If r$="REPEAT"Then BasicRepeat(Cod):Return
		If r$="RETURN"Then BasicReturn(Cod):Return
		If r$="REFRESHAREA"Then BasicRefreshArea():Return
		If r$="REFRESHOBJ"Or r$="REFRESHOBJECT" Then BasicRefreshObj():Return
		If r$="REFRESHTOOL" Then BasicRefreshTool():Return		
		If r$="REFRESHTITLE"Then BasicRefreshTitle():Return
		If r$="REFRESHALL"Then BasicRefreshAll():Return		
		If r$="REFRESHSTATUS"Then BasicRefreshStatus():Return
		If r$="REFRESHMENU"Then BasicRefreshMenu():Return
		
		If r$="SEEKFILE"Then BasicSeekFile(Cod):Return
		If r$="SETPAINTOBJPEN" Then BasicSetPaintObjPen():Return
		If r$="SETCTRLABELOBJPEN" Then BasicSetCtrLabelObjPen():Return
		If r$="SETCTRLABELOBJPAPER" Then BasicSetCtrLabelObjPaper():Return			
		If r$="SETFORMPOS"Then BasicSetFormPos():Return
		If r$="SETFORMSIZE"Then BasicSetFormSize():Return
		If r$="SETOBJPOS" Then BasicSetObjPos():Return
		If r$="SETOBJWIDTH"Then BasicSetObjWidth():Return
		If r$="SETOBJHEIGHT"Then BasicSetObjHeight():Return
		If r$="SETOBJVISIBLE"Then BasicSetObjVisible():Return
		If r$="SETOBJTEXT"Then BasicSetObjText():Return
		If r$="SETOBJGRAPHIC"Then BasicSetObjGraphic():Return
		If r$="SETTOOLGRAPHIC"Then BasicSetObjGraphic():Return
		If r$="SETSECOND"Then BasicSetSecond(Cod):Return
		If r$="SETMINUTE"Then BasicSetMinute(Cod):Return
		If r$="SETHOUR"Then BasicSetHour(Cod):Return
		If r$="SETDAY"Then BasicSetDay(Cod):Return
		If r$="SETMONTH"Then BasicSetMonth(Cod):Return
		If r$="SETYEAR"Then BasicSetYear(Cod):Return
		
		If r$="TOOL.REFRESH"Then BasicRefreshTool():Return
		If r$="TOOL.POSITION.SET" Then BasicSetObjPos():Return
		If r$="TOOL.WIDTH.SET"Then BasicSetObjWidth():Return
		If r$="TOOL.HEIGHT.SET"Then BasicSetObjHeight():Return
		If r$="TOOL.VISIBLE.SET"Then BasicSetObjVisible():Return
		If r$="TOOL.TILE.SET"Then BasicSetObjGraphic():Return
		
		If r$="UNTIL"Then BasicUntil(Cod):Return
		
		If r$="WRITEBYTE"Then BasicWriteByte():Return
		If r$="WRITEINT"Then BasicWriteInt():Return
		If r$="WRITEFLOAT"Then BasicWriteFloat():Return
		If r$="WRITELINE"Then BasicWriteLine():Return				
		If r$="WHILE"Then BasicWHILE(Cod):Return
		If r$="WEND"Then BasicWEND(Cod):Return
	EndIf	
End Function

Function CompileZ80(r$)
	r9$=Mid$(r$,1,1)
	If r9$="A" Or r9$="B" Or r9$="C"Then
		If r$="AND" Then FuncAND():Return					
		If r$="ADD" Then FuncADD():Return					;New
		If r$="ADC" Then FuncADC():Return		
		If r$="BIT" Then FuncBIT():Return
		If r$="CP"  Then FuncCP():Return					;New
		If r$="CALL"Then FuncCALL():Return				;New
		If r$="CPL" Then FuncCPL():Return					;New
		If r$="CCF" Then FuncCCF():Return					;New
		If r$="CPI" Then FuncCPI():Return					;New
		If r$="CPIR"Then FuncCPIR():Return				;New
		If r$="CPD" Then FuncCPD():Return					;New
		If r$="CPDR"Then FuncCPDR():Return				;New
		If r$="CODE"Then FuncCODE():Return
	EndIf
	If r9$="D"Or r9$="E"Or r9$="H"Or r9$="F"Then
		If r$="DB"Or r$="DEFB" Or r$="DEFM" Or r$="DM" Then FuncDB(0):Return		;New
		If r$="DW"Or r$="DEFW"Then FuncDW(0):Return			;New
		If r$="DS"Or r$="DEFS"Then FuncDS(0):Return			;New
		If r$="DEC" Then FuncDEC():Return
		If r$="DJNZ"Then FuncDJNZ():Return
		If r$="DAA" Then FuncDAA():Return						;New
		If r$="DI"  Then FuncDI():Return					;New		
		If r$="EXX" Then FuncEXX():Return						;New
		If r$="EX"  Then FuncEX():Return
		If r$="EI"  Then FuncEI():Return						;New
		If r$="ENDL"Or r$="ENDLIB"Or r$="ENDLIBRARY" Then
			Cod=Cod+1
			Okay=1
			Return
		EndIf
		If r$="ENDF" Or r$="ENDFUNCTION" Then FuncENDF():Return
		If r$="HALT"Then FuncHALT():Return					;New
	EndIf
	If r9$="I"Or r9$="J"Then
		If r$="INC" Then FuncINC():Return 						;New
		If r$="IN"  Then FuncIN():Return
		If r$="JR"  Then FuncJR():Return
		If r$="JP"  Then FuncJP():Return						;New
		If r$="INI" Then FuncINI():Return						;New
		If r$="INIR"Then FuncINIR():Return					;New
		If r$="IND" Then FuncIND():Return						;New
		If r$="INDR"Then FuncINDR():Return					;New
		If r$="IM"  Then FuncIM():Return
		If r$="INCLIB" Then FuncIncLib():Return		
	EndIf
	If r9$="L"Or r9$="N"Then
		If r$="LD"     Then FuncLD():Return					;New
		If r$="LDIR"   Then FuncLDIR():Return					;New
		If r$="LDI"    Then FuncLDI():Return						;New
		If r$="LDD"    Then FuncLDD():Return						;New
		If r$="LDDR"   Then FuncLDDR():Return					;New
		If r$="LIBRARY"Then FuncLibrary():Return
		
		If r$="NEG"    Then FuncNEG():Return						;New
		If r$="NOP"    Then FuncNOP():Return						;New
	EndIf
	If r9$="O"Or r9$="P"Then
		If r$="OUT" Then FuncOUT():Return
		If r$="OR"  Then FuncOR():Return
		If r$="POP" Then FuncPop():Return						;New
		If r$="PUSH"Then FuncPush():Return				;New
		If r$="OUTI"Then FuncOUTI():Return					;New
		If r$="OTIR"Then FuncOTIR():Return					;New
		If r$="OUTD"Then FuncOUTD():Return					;New
		If r$="OTDR"Then FuncOTDR():Return					;New
	EndIf
	If r9$="R"Then
		If r$="RET" Then FuncRET():Return						;New					
		If r$="RES" Then FuncRES():Return		
		If r$="RLC" Then FuncRLC():Return
		If r$="RL"  Then FuncRL():Return
		If r$="RRC" Then FuncRRC():Return
		If r$="RR"  Then FuncRR():Return
		If r$="RLCA"Then FuncRLCA():Return					;New
		If r$="RLA" Then FuncRLA():Return						;New
		If r$="RRCA"Then FuncRRCA():Return					;New
		If r$="RRA" Then FuncRRA():Return						;New
		If r$="RLD" Then FuncRLD():Return						;New
		If r$="RRD" Then FuncRRD():Return						;New
		If r$="RETI"Then FuncRETI():Return					;New
		If r$="RETN"Then FuncRETN():Return					;New
		If r$="RST" Then FuncRST():Return						;New	
	EndIf
	If r9$="S"Or r9$="X"Then
		If r$="SUB"Then FuncSUB():Return						;New
		If r$="SBC"Then FuncSBC():Return
		If r$="SET"Then FuncSET():Return
		If r$="SLA"Then FuncSLA():Return  
		If r$="SRA"Then FuncSRA():Return
		If r$="SRL"Then FuncSRL():Return 	
		If r$="SCF"Then FuncSCF():Return						;New			
		If r$="XOR"Then FuncXOR():Return						;New
		If r$="SYMBOS_ORG"Then FuncORG():Return
	EndIf	
End Function	


Function AsmPokeByte(a,b)
	PokeByte MemBank,PC,a
	PC=PC+1
End Function
Function Pk1(a,sob$="")
	PokeByte MemoryBank(4),PC1,a
	PokeByte MemoryBank(5),PC1+102,a
	PC1=PC1+1
	If sob$>"" Then 
		Final$(FLine)=sob$
		FLine=FLine+1
	EndIf
End Function
Function Pk1n(sob$)
	PokeByte MemoryBank(4),PC1,0
	PokeByte MemoryBank(5),PC1+102,0
	PC1=PC1+1
End Function
Function Pk2(a,sob$="")
	;PokeByte MemoryBank(4),PC1,a
	;PokeByte MemoryBank(5),PC1+102,a
	PC1=PC1+2
End Function
Function PkBy(p,b,i,alt=0)
	PokeByte MemBank,p,b
	If i>0 Then PC=PC+i
End Function
Function PkSh(p,b,i,alt=0)
	PokeShort MemBank,p,b
	If i>0 Then PC=PC+i
End Function
Function FuncFunction(Wrd)
	FunctionUsing=0
	Cod=Cod+1
	gt=0
	r$=Upper$(SepSort$(Cod))
	If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
	r9$=Mid$(r$,1,1)
	If r9$<"A"Or r9$>"Z"Then
		Err=111
		ErrMessage$="Function name not valid"
		Return
	EndIf
	FunctionName$=r$
	For f=1 To LabCount
		If Lab$(f)=r$ Then
			gt=f
			f=LabCount
		EndIf	
	Next
	If gt=0 Then
		LabCount=LabCount+1
		gt=LabCount
	EndIf
	LabRef(gt)=LabRef(gt)+1
	If LabRef(gt)>1 Then				;*** Label already declared
		Err=10
		Okay=0
		Return 0
	EndIf
	Lab$(gt)=r$
	LabT(gt)=0
	LabOK(gt)=1
	LabV(gt)=PC

	e=0
	For k=1 To FuncNo
		If r$=Upper$(Func$(k))Then
			e=k
			Exit
		EndIf	
	Next
	
	Cod=Cod+1
	ty=0
	r$=Upper$(SepSort$(Cod))
	If r$="#" Or r$="$"Or r$="%"Then Cod=Cod+1:r$=Upper$(SepSort$(Cod))
	If r$="("Then
		.limbplacement	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>")"Then Goto limbplacement		
		If r$=""Then
			Err=113
			ErrMessage$="')' expected"
			Return
		EndIf
	EndIf
	FunctionUsing=0
	;Is this a Basic Function that needs to convert to Vars????
	If FuncType(e)>10 Then
		;11 Because 11=Basic Function Command
		If FuncType(e)>11 Then FunctionUsing=FuncType(e)-10
		If FuncParams(e)>0 Then
			AddRoutine("SyB_Function_Pass")
			
			PkBy(PC,FuncParams(e),1);PokeByte MemBank,PC,FuncParams(e):PC=PC+1			;Number to Parameters to Pass
			
			
			
			For n=FuncParams(e) To 1 Step -1
				jk=VarType(FuncParVar(e,n)):nk=0
				If jk=2 Or jk=11 Then nk=1
				If jk=13 Then nk=3
				If jk=5 Or jk=15 Then nk=5
				If nk=0 Then RuntimeError(VarType(FuncParVar(e,n)))
				PkBy(PC,nk,1);PokeByte MemBank,PC,nk:PC=PC+1
				t=GetRoutineLocation(VarName(FuncParVar(e,n)))
				PkSh(PC,t,2,1) ;PokeShort MemBank,PC,t:PC=PC+2
			Next
		EndIf
	EndIf
	Okay=1
End Function
Function SetError(E4,Er$)
	Err=E4
	ErrMessage=Er$
	Return Err
End Function
Function FuncAddLabel(Wrd)
	gt=0
	r$=Upper$(SepSort$(Cod))
	If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
	r9$=Mid$(r$,1,1)
	If r9$<"A"Or r9$>"Z"Then Return 0
	For f=1 To LabCount
		If Lab$(f)=r$ Then
			gt=f
			f=LabCount
		EndIf	
	Next
	If gt=0 Then
		LabCount=LabCount+1
		gt=LabCount
	EndIf
	LabRef(gt)=LabRef(gt)+1
	If LabRef(gt)>1 Then				;*** Label already declared
		Err=10
		Okay=0
		Return 0
	EndIf
	Lab$(gt)=r$
	Cod=Cod+1
	Okay=1
	r$=Upper$(SepSort$(Cod))
	If r$="EQU"Then
		LabT(gt)=1
		a=PC
		Cod=Cod+1
		Failed2=Failed
		t=GetNumber(1)
		If Failed2=Failed Then
			LabV(gt)=t
			LabOK(gt)=1
		Else
			LabV(gt)=0
			LabOK(gt)=0
		EndIf
		Return 1
	EndIf
	If r$="DEFBYTE"Then
		Cod=Cod+1

	EndIf
	LabT(gt)=0
	LabV(gt)=PC
	LabOK(gt)=1
	Return 1
End Function
Function FuncCheckLabel(Wrd)
	gt=0
	If LabCount>0 Then
		r$=Upper$(SepSort$(Wrd))
		If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
		For f=1 To LabCount
			If Lab$(f)=r$ Then
				gt=f
				f=LabCount
			EndIf	
		Next
	EndIf
	If gt=0 Then			;**** Just check if Library
		r$=Upper$(SepSort$(Wrd))
		For f=1 To Lib
			If r$=Libr$(f)Then
				LibUsed(f)=1
				f=Lib+1
			EndIf
		Next
	EndIf
	If gt=0 Then
		UnRef=UnRef+1
		UnRefLab$(UnRef)=r$
		UnRefLin(UnRef)=CurrLine
	EndIf
	Return gt
End Function
Function FuncDB(Typ)
	Dub$="     DB "
.Libble
	Cod=Cod+1
	r$=SepSort$(Cod)
	If Mid$(r$,1,1)=Chr$(34)Then
		dub$=dub$+Chr$(34)
		For f=1 To Len(r$)
			p$=Mid$(r$,f,1)
			If p$<>Chr$(34)Then 
				PkBy(PC,Asc(p$),1)
				Pk1(Asc(p$))
				dub$=dub$+p$
			EndIf	
		Next
		dub$=dub$+Chr$(34)
		Cod=Cod+1
	Else
		t=GetNumber(Typ)
		If Err=0 Then 
			PkBy(PC,t,1)
			Pk1(t)
			dub$=dub$+Str$(t)
		Else	
			SetError(900,"DB used incorrectly")
			Return
		EndIf
	EndIf
	If Err=0 Then
		r$=SepSort$(Cod)	
		If r$=","Then 
			dub$=dub$+","
			Goto Libble
		EndIf
	Else
		SetError(900,"DB used incorrectly")
	EndIf
	Final$(FLine)=dub$
	FLine=FLine+1
	Okay=1
End Function
Function FuncDW(Typ)
	Dub$="     DW "
.Libble2
	Cod=Cod+1
	r$=SepSort$(Cod)
	t=GetNumber(1)
	GetFir$=Reply$
	GetFia1=GetFia
	If Err=0 Then
		PkSh(PC,t,2)
		If GetFia1=0 Then
			dub$=dub$+Str$(t)
			Pk2(t)
		Else
			dub$=dub$+GetFir$
			Pk2(0,GetSec)
		EndIf
	Else
		SetError(900,"DW used incorrectly")
	EndIf
	If Err=0 Then
		r$=SepSort$(Cod)	
		If r$=","Then 
			dub$=dub$+","
			Goto Libble2
		EndIf
	Else	
		SetError(900,"DW used incorrectly")
	EndIf
	Final$(FLine)=dub$
	FLine=FLine+1
	Okay=1
End Function
Function FuncDS(Typ)
	Dub$="     DS "
	
.Libble3
	Cod=Cod+1
	r$=SepSort$(Cod)
	t=GetNumber(1)
	t2=0
	r$=SepSort$(Cod)
	dub$=dub$+Str$(t)
	If r$=","Then
		Cod=Cod+1
		t2=GetNumber(1)
		dub$=dub$+","+Str$(t2)
	EndIf
	If Err=0 Then
		For n=1 To t
			PkBy(PC,t2,1)
			Pk1(t2)
		Next
	EndIf
	If Err=0 Then
		r$=SepSort$(Cod)	
		If r$=","Then
			dub$=dub$+","
			Goto Libble3
		EndIf	
	EndIf
	Final$(FLine)=dub$
	FLine=FLine+1	
	Okay=1
End Function
Function FuncORG()
	Cod=Cod+1
	r$=SepSort$(Cod)
	t=GetNumber(1)
	If OrgVer=2 Then
		t=t+258
	EndIf
	Okay=1
	PC=t
	PC1=t
	Org(OrgVer)=t
End Function
Function GetRegister(Wrd)
	r$=Upper$(SepSort$(Cod))
	If r$="AF"Then
		Cod=Cod+1
		Return 1
	EndIf	
	If r$="BC"Then
		Cod=Cod+1
		Return 2
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		Return 3
	EndIf
	If r$="HL"Then
		Cod=Cod+1
		Return 4
	EndIf	
	If r$="SP"Then
		Cod=Cod+1
		Return 5
	EndIf
	If r$="IX"Then
		Cod=Cod+1
		Return 6
	EndIf
	If r$="IY"Then
		Cod=Cod+1
		Return 7
	EndIf
	
	If r$="B"Then
		Cod=Cod+1
		Return 16
	EndIf
	If r$="C"Then
		Cod=Cod+1
		Return 17
	EndIf
	If r$="D"Then
		Cod=Cod+1
		Return 18
	EndIf	
	If r$="E"Then
		Cod=Cod+1
		Return 19
	EndIf
	If r$="H"Then
		Cod=Cod+1
		Return 20
	EndIf
	If r$="L"Then
		Cod=Cod+1
		Return 21
	EndIf
	If r$="A"Then
		Cod=Cod+1
		Return 23
	EndIf
	
	If r$="R"Then
		Cod=Cod+1
		Return 32
	EndIf
	If r$="I"Then
		Cod=Cod+1
		Return 33
	EndIf
	
	If r$="("Then Goto BracketStuff
	
	b1=GetNumber(1)
	Return (b1*256)+81
	Okay=1
	
	.BracketStuff
	a=0
	t=0
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="BC"Then
		Cod=Cod+1
		a=64
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		a=65
	EndIf
	If r$="HL"Then
		Cod=Cod+1
		a=67
	EndIf
	If r$="AF"Then
		Cod=Cod+1
		a=68
	EndIf
	If r$="SP"Then
		Cod=Cod+1
		a=69
	EndIf
	If r$="C"Then
		Cod=Cod+1
		a=70
	EndIf
	If r$="IX"Then
		Cod=Cod+1
		a=71
		r$=Upper$(SepSort$(Cod))
		If r$="+"Then
			Cod=Cod+1
			t=GetNumber(0)
		EndIf
	EndIf
	If r$="IY"Then
		Cod=Cod+1
		a=72
		r$=Upper$(SepSort$(Cod))
		If r$="+"Then
			Cod=Cod+1
			t=GetNumber(0)
		EndIf
	EndIf
	If a=0 Then
		t=GetNumber(1)
		a=80
		Okay=1
	EndIf
	r$=Upper$(SepSort$(Cod))
	If r$<>")"Then Stop
	Cod=Cod+1
	Return a+(t*256)
End Function
Function GetNumber(Typ=0)
	;**** Typ 0 = 8bit 1 = 16bit
	Fia=0
	GetFia=0
	Reply$=""
	Total=0
	Total2=0
	Add1=1:Add1_1=1
	Add2=0:Add2_1=0
	.Lumpy
	r$=Upper$(SepSort$(Cod))
	Reply$=Reply$+r$
	sign=0
	If r$="+"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
	EndIf
	If r$="-"Then
		sign=1
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
	EndIf
	If Mid$(r$,1,1)="#" Or Mid$(r$,1,1)="&" Or Mid$(r$,1,1)="$" Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
		Tot2=GetHex(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	If Mid$(r$,1,1)="%"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
		Tot2=GetBinary(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	If Mid$(r$,1,1)>="0" And Mid$(r$,1,1)<="9"Then
		Tot2=GetDecimal(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	If Mid$(r$,1,1)=Chr$(34)Then
		Tot2=GetNumString(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	;t=GetRoutineLocation(r$)
	t=FuncCheckLabel(Cod)
	GetFia=1
	If t=0 Then
		Fia=1
		Failed=Failed+1
		Tot2=0
		Tot2_1=0
		Goto Binder
	Else
		If LabOK(t)=1 Then 
			Tot2=LabV(t)
			Tot2_1=Tot2+258
			Goto Binder
		Else
			Failed=Failed+1
			Tot2=0
			Tot2_1=0
			Goto Binder
		EndIf	
	EndIf
.Binder
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="+"Then Add2=1:Reply$=Reply$+r$
	If r$="-"Then Add2=2:Reply$=Reply$+r$
	If r$="/"Then Add2=3:Reply$=Reply$+r$
	If r$="*"Then Add2=4:Reply$=Reply$+r$
	If r$="MOD"Then Add2=5:Reply$=Reply$+r$
	If Add1=1 Then Total=Total+Tot2:Total2=Total2+Tot2_1
	If Add1=2 Then Total=Total-Tot2:Total2=Total2+Tot2_1
	If Add1=3 Then 
		If Tot2<>0 Then
			Total=Total/Tot2
			Total2=Total2/Tot2_1
		Else
			Total=0
			Total2=0
		EndIf
	EndIf	
	If Add1=4 Then Total=Total*Tot2:Total2=Total2*Tot2_1
	If Add1=5 Then Total=Total Mod Tot2:Total2=Total2 Mod Tot2_1
	If Add2>0 Then
		Add1=Add2
		Add2=0
		Cod=Cod+1
		Goto Lumpy
	EndIf
	If Typ=0 Then
		If Total<0 Or Total>255 Then
			Err=98
			ErrMessage$="expecting 8 bit value"
			SecondTotal=0
			Return 0
		EndIf
	EndIf
	If Fia=1 Then Return 0
	SecondTotal=Total2
	Return Total
End Function
Function GetBinary(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		If a$<>"0" And a$<>"1"Then
			ErrMessage$="Binary Error"
			Err=99
			Failed=1
			Return 0
		EndIf	
		If a$="1"Then
			Tot2=Tot2+Base
		EndIf
		Base=Base*2
	Next
	If re=0 Then   ;**** 8 Bit
		;If Tot2<0 Or Tot2>255 Then
		;	Err=98
		;	Failed=1
		;	Return 0
		;EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=32768-Tot2
		EndIf	
	EndIf
	Return Tot2
End Function
Function GetNumString(r$,re,si)
	r$=Mid$(r$,2)
	If Len(r$)>1 Then
		r$=Mid$(r$,1,Len(r$)-1)
	EndIf
	If Len(r$)>1 Then
		Err=98
		Return 0
	EndIf
	Return Asc(r$)
End Function
Function GetHex(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		n=-1
		If a$=>"0" And a$<="9" Then
			n=Asc(a$)-48
		EndIf
		If a$=>"A" And a$<="F"Then
			n=Asc(a$)-55
		EndIf
		If n=-1 Then
			Err=99
			Failed=1
			Return 0
		EndIf	
		Tot2=Tot2+(n*Base)
		Base=Base*16
	Next

	If re=0 Then   ;**** 8 Bit
		;If Tot2<0 Or Tot2>255 Then
		;	Err=98
		;	Failed=1
		;	Return 0
		;EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=32768-Tot2
		EndIf	
	EndIf
	Return Tot2
	
End Function
Function GetDecimal(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		n=-1
		If a$=>"0" And a$<="9" Then
			n=Asc(a$)-48
		Else
			ErrMessage$="Decimal Error "+r$
			Err=99
			Failed=1
			Return 0
		EndIf	
		Tot2=Tot2+(n*Base)
		Base=Base*10
	Next
	If re=0 Then   ;**** 8 Bit
		;If Tot2<0 Or Tot2>255 Then
		;	Err=98
		;	Failed=1
		;	Return 0
		;EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=65536-Tot2
		EndIf
	EndIf
	Return Tot2	
End Function
Function GetCC(s2$)
	e1=-1
	If s2$="NZ"Then e1=0
	If s2$="Z"Then e1=1
	If s2$="NC" Then e1=2
	If s2$="C"Then e1=3
	If s2$="PO"Then e1=4
	If s2$="PE"Then e1=5
	If s2$="P"Then e1=6
	If s2$="M"Then e1=7
	Return e1
End Function
Function GetQQ(s2$)
	e1=-1
	If s2$="BC"Then e1=0
	If s2$="DE"Then e1=1
	If s2$="HL"Then e1=2
	If s2$="AF"Then e1=3
	Return e1
End Function	
Function CCRegister$(xc)
	If xc=7 Then Return "M"
	If xc=0 Then Return "NZ"	
	If xc=1 Then Return "Z"	
	If xc=2 Then Return "NC"	
	If xc=3 Then Return "C"
	If xc=4 Then Return "PO"
	If xc=5 Then Return "PE"
	If xc=6 Then Return "P"
End Function
Function RRegister$(xc)
	If xc=7 Then Return "A"
	If xc=0 Then Return "B"	
	If xc=1 Then Return "C"	
	If xc=2 Then Return "D"	
	If xc=3 Then Return "E"
	If xc=4 Then Return "H"
	If xc=5 Then Return "L"
	If xc=6 Then Return "(HL)"
End Function
Function SSRegister$(xc)
	If xc=0 Then Return "BC"
	If xc=1 Then Return "DE"	
	If xc=2 Then Return "HL"	
	If xc=3 Then Return "SP"
End Function
Function QQRegister$(xc)
	If xc=0 Then Return "BC"
	If xc=1 Then Return "DE"	
	If xc=2 Then Return "HL"	
	If xc=3 Then Return "AF"
End Function
Function Str16$(a)
	If a<=32768 Then 
		Return Str$(a)
	Else
		Return "-"+Str$(Abs(65536-a))
	EndIf	
End Function
Function FuncADD()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n1=23 And (n2>=16 And n2<=23) Then				;***** ADD A,r
		PkBy(PC,128+(n2-16),1)
		Pk1(128+(n2-16),"     ADD A,"+RRegister$(n2-16)+"    ;** "+Mid$(Hex$(128+(n2-16)),7,2))
		Okay=1:Return
	EndIf
	If n1=23 And n2=81 Then								;***** ADD A,N
		PkBy(PC,198,1)
		Pk1(198,"     ADD A,"+Str$(n2t)+"    ;** "+Mid$(Hex$(198),7,2)+" "+Mid$(Hex$(n2t),7,2))
		PkBy(PC,n2t,1)
		Pk1(n2t)
		Okay=1:Return
	EndIf		
	If n1=23 And n2=67 Then								;***** ADD A,(HL)
		PkBy(PC,134,1)
		Pk1(134,"     ADD A,(HL)    ;** "+Mid$(Hex$(134),7,2))
		Okay=1:Return
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** ADD A,(IX+n) (IY+n)
		If n2=71 Then
			PkBy(PC,221,1)
			Pk1(221,"     ADD A,(IX+"+Str$(n2t)+")"+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(134),7,2)+" "+Mid$(Hex$(n2t),7,2))
			PkBy(PC,134,1)
			Pk1(134)
		EndIf
		If n2=72 Then
			PkBy(PC,253,1)
			Pk1(253,"     ADD A,(IY+"+Str$(n2t)+")"+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(134),7,2)+" "+Mid$(Hex$(n2t),7,2))
			PkBy(PC,134,1)
			Pk1(134)
		EndIf
		PkBy(PC,n2t,1)
		Pk1(n2t)
		Okay=1:Return
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then					;***** ADD HL,ss
		PkBy(PC,((n2-2)*16)+9,1)
		Pk1(((n2-2)*16)+9,"     ADD HL,"+SSRegister$(n2-2)+"    ;** "+Mid$(Hex$(((n2-2)*16)+9),7,2))
		Okay=1:Return
	EndIf	

	If n1=6 And (n2=2 Or n2=3 Or n2=5 Or n2=6) Then		;***** ADD IX,pp
		PkBy(PC,221,1)
		b=9
		If n2=2 Then b=b+(0*16):wq$="BC"
		If n2=3 Then b=b+(1*16):wq$="DE"
		If n2=5 Then b=b+(3*16):wq$="SP"
		If n2=6 Then b=b+(2*16):wq$="IX"
		Pk1(221,"     ADD IX,"+wq$+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(b),7,2))
		PkBy(PC,b,1)
		Pk1(b)
		Okay=1:Return
	EndIf
	If n1=7 And (n2=2 Or n2=3 Or n2=5 Or n2=7) Then		;***** ADD IY,rr
		PkBy(PC,253,1)
		b=9
		If n2=2 Then b=b+(0*16):wq$="BC"
		If n2=3 Then b=b+(1*16):wq$="DE"
		If n2=5 Then b=b+(3*16):wq$="SP"
		If n2=7 Then b=b+(2*16)	:wq$="IY"
		Pk1(253,"     ADD IY,"+wq$+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(b),7,2))
		PkBy(PC,b,1)
		Okay=1:Return
	EndIf
	SetError(900,"ADD used incorrectly")
	Return
End Function

Function FuncIncLib()
	Cod=Cod+1
	k$=Upper$(SepSort$(Cod))
	If k$>"" Then
		k$=Upper$(Trim(k$))
		
		For f=1 To LbFound
			If k$=LbName$(f)Then
				If LbUsed(f)=0 Then	
					For g=LbStart(f) To LbEnd(f)
						LibEnd=LibEnd+1
						Ld$(LibEnd)=Lb$(g)
					Next
					LbUsed(f)=1
				EndIf
				f=LbFound+1
			EndIf	
		Next
		Cod=Cod+1
	EndIf
	Okay=1
	Return 1
End Function

Function FuncLibrary()
	LibIgnore=1
	Cod=Cod+1
	gt=0
	r$=Upper$(SepSort$(Cod))
	If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
	r9$=Mid$(r$,1,1)
	If r9$<"A"Or r9$>"Z"Then Return 0
	For f=1 To LabCount
		If Lab$(f)=r$ Then
			gt=f
			f=LabCount
		EndIf	
	Next
	If gt=0 Then
		LabCount=LabCount+1
		gt=LabCount
	EndIf
	LabRef(gt)=LabRef(gt)+1
	If LabRef(gt)>1 Then				;*** Label already declared
		Err=10
		Okay=0
		Return 0
	EndIf
	Lab$(gt)=r$
	Cod=Cod+1
	Okay=1
	LabT(gt)=0
	LabV(gt)=PC
	LabOK(gt)=1
	For h=1 To Lib
		If r$=Libr$(h)Then
			If LibUsed(h)<>0 Then
				LibIgnore=0
			EndIf
		EndIf
	Next
	Cod=Cod+1
	Okay=1
	Return 1	
End Function
Function FuncADC()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	b=1
	If n1=23 And (n2>=16 And n2<=23) Then				;***** ADC A,r
		PkBy(PC,128+(n2-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=23 And n2=81 Then				;***** ADC A,N
		PkBy(PC,198+(b*8),1)
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf		
	If n1=23 And n2=67 Then								;***** ADC A,(HL)
		PkBy(PC,134+(b*8),1)
		Okay=1:Return
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** ADC A,(IX+n) (IY+n)
		If n2=71 Then
			PkBy(PC,221,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		If n2=72 Then
			PkBy(PC,253,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then				;***** ADC HL,ss
		PkBy(PC,237,1)
		PkBy(PC,((n2-2)*16)+74,1)
		Okay=1:Return
	EndIf
	Return SetError(900,"ADC used incorrectly")
End Function
Function FuncSBC()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	b=3
	If n1=23 And (n2>=16 And n2<=23) Then				;***** SBC A,r
		PkBy(PC,128+(n2-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=23 And n2=81 Then								;***** SBC A,N
		PkBy(PC,198+(b*8),1)
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf		
	If n1=23 And n2=67 Then								;***** SBC A,(HL)
		PkBy(PC,134+(b*8),1)
		Okay=1:Return
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** SBC A,(IX+n) (IY+n)
		If n2=71 Then
			PkBy(PC,221,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		If n2=72 Then
			PkBy(PC,253,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then					;***** SBC HL,ss
		PkBy(PC,237,1)
		PkBy(PC,((n2-2)*16)+66,1)
		Okay=1:Return
	EndIf
	SetError(900,"SBC used incorrectly")
End Function
Function FuncCP()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	GetFir=GetFia
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=7
	If n1>=16 And n1<=23 Then						;***** CP r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Pk1(128+(n1-16)+(b*8),"     CP "+RRegister(n1-16)+"    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))
		Okay=1:Return
	EndIf
	If n1=81 Then									;***** cp n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Pk1((b*8)+198,"     CP "+GetFir$+"    ;** "+Mid$(Hex$((b*8)+198),7,2)+" xx")
		Pk1n(GetFir$)
		Okay=1:Return
	EndIf		
	If n1=67 Then									;***** cp (HL)
		PkBy(PC,(b*8)+134,1)
		Pk1(190,"     CP (HL)    ;** "+Mid$(Hex$(190),7,2))
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then						;***** cp (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(221,"     CP (IX+"+GetFir+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(190),7,2)+" xx")
			Pk1(190)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(253,"     CP (IY+"+GetFir+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(190),7,2)+" xx")
			Pk1(190)
		EndIf
		PkBy(PC,n1t,1)
		Pk1n(GetFir)
		Okay=1:Return
	EndIf
	Return SetError(900,"CP used incorrectly")
End Function
Function FuncOR()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=6
	If n1>=16 And n1<=23 Then					;***** OR r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=81 Then								;***** OR n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Okay=1:Return
	EndIf		
	If n1=67 Then								;***** OR (HL)
		PkBy(PC,(b*8)+134,1)
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then					;***** OR (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		PkBy(PC,n1t,1)
		Okay=1:Return
	EndIf
	SetError(900,"OR used incorrectly")
End Function
Function FuncXOR()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=5
	If n1>=16 And n1<=23 Then					;***** XOR r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Pk1(128+(n1-16)+(b*8),"     XOR "+RRegister(n1-16)+"    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))
		Okay=1:Return
	EndIf
	If n1=81 Then								;***** XOR n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Pk1((b*8)+198,"     XOR "+Reply$+"    ;** "+Mid$(Hex$((b*8)+198),7,2)+" "+Mid$(Hex$(n1t),7,2))
		Pk1(n1t)
		Okay=1:Return
	EndIf		
	If n1=67 Then								;***** XOR (HL)
		PkBy(PC,(b*8)+134,1)
		Pk1((b*8)+134,"     XOR (HL)    ;** "+Mid$(Hex$((b*8)+134),7,2))
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then					;***** XOR (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(221,"     XOR (IX+"+Reply$+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$((b*8)+134),7,2)+" "+Mid$(Hex$(n1t),7,2))
			Pk1((b*8)+134)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(253,"     XOR (IX+"+Reply$+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$((b*8)+134),7,2)+" "+Mid$(Hex$(n1t),7,2))
			Pk1((b*8)+134)
		EndIf
		PkBy(PC,n1t,1)
		Pk1(n1t)
		Okay=1:Return
	EndIf
	SetError(900,"XOR used incorrectly")
End Function
Function FuncAND()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=4
	If n1>=16 And n1<=23 Then					;***** AND r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=81 Then								;***** AND n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Okay=1:Return 0
	EndIf		
	If n1=67 Then								;***** AND (HL)
		PkBy(PC,(b*8)+134,1)
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then					;***** AND (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		PkBy(PC,n1t,1)
		Okay=1:Return
	EndIf
	SetError(900,"AND used incorrectly")
End Function
Function FuncSUB()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=2
	If n1>=16 And n1<=23 Then						;***** SUB r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Pk1(128+(n1-16)+(b*8),"     SUB "+RRegister$(n1-16)+"    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))
		Okay=1:Return
	EndIf
	If n1=81 Then									;***** SUB n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Pk1((b*8)+198,"     SUB "+Reply$+"    ;** "+Mid$(Hex$((b*8)+198),7,2)+" "+Mid$(Hex$(n1t),7,2))
		Pk1(n1t)		
		Okay=1:Return
	EndIf		
	If n1=67 Then									;***** SUB (HL)
		PkBy(PC,(b*8)+134,1)
		Pk1((b*8)+134,"     SUB (HL)    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))		
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then						;***** SUB (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(221,"     SUB ("+Reply$+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$((b*8)+134),7,2))
			Pk1((b*8)+134)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(253,"     SUB ("+Reply$+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$((b*8)+134),7,2))
			Pk1((b*8)+134)			
		EndIf
		PkBy(PC,n1t,1)
		Pk1(n1t)	
		Okay=1:Return
	EndIf
	SetError(900,"SUB used incorrectly")
End Function
Function FuncSET()
	n1=0
	Cod=Cod+1
	b1=GetNumber(0)
	If b1<0 Or b1>7 Then
		Err=97
		Return
	EndIf
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"SET used incorrectly")
		Return
	EndIf
	Cod=Cod+1
	n1=GetRegister(Cod)
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then			;SET b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+64+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=67 Then						;SET b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b 110
		Okay=1:Return
	EndIf
	If n1=71 Then						;SET b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=72 Then						;SET b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	Cod=Cod+1
	SetError(900,"SET used incorrectly")
End Function
Function FuncRES()
	n1=0
	Cod=Cod+1
	b1=GetNumber(0)
	If b1<0 Or b1>7 Then
		SetError(900,"RES used incorrectly")
		Return
	EndIf
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"RES used incorrectly")
		Return
	EndIf
	Cod=Cod+1
	n1=GetRegister(Cod)
	n1t=n1/256
	n1=n1 Mod 256
	If n1>=16 And n1<=23 Then			;RES b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=67 Then						;RES b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+6+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b 110
		Okay=1:Return
	EndIf
	If n1=71 Then						;RES b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+128+6
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=72 Then						;RES b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+128+6
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	Cod=Cod+1
	SetError(900,"RES used incorrectly")
	Return
End Function
Function FuncBIT()
	n1=0
	Cod=Cod+1
	b1=GetNumber(0)
	If b1<0 Or b1>7 Then Return SetError(97,"BIT used incorrectly")
	
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then Return SetError(97,"BIT used incorrectly")
	Cod=Cod+1
	n1=GetRegister(Cod)
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then			;BIT b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+64
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=67 Then						;BIT b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=71 Then						;BIT b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Return 0
	EndIf
	If n1=72 Then						;BIT b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Return 0
	EndIf
	Cod=Cod+1
	Return SetError(900,"BIT used incorrectly")
End Function
Function FuncSRL()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=7
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"SRL used incorrectly")
End Function
Function FuncSRA()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=5
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"SRA used incorrectly")
End Function
Function FuncSLA()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=4
	n1t=n1/256
	n1=n1 Mod 256
	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"SLA used incorrectly")
End Function
Function FuncRR()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=3
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RR used incorrectly")
End Function
Function FuncRRC()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=1
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RRC used incorrectly")
End Function
Function FuncRL()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=2
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RL used incorrectly")
End Function
Function FuncRLC()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=0
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RLC used incorrectly")
End Function
Function FuncDEC()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)

	n1t=n1/256
	n1=n1 Mod 256

	If n1=6 Then				;***** DEC IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,43:PC=PC+1			;&2b
		Okay=1:Return
	EndIf
	If n1=7 Then				;***** DEC IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,43:PC=PC+1			;&2b		
		Okay=1:Return
	EndIf
	If n1>=2 And n1<=5 Then				;***** DEC ss
		n2=(n1-2)*16+11
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 ss1 011		
		Okay=1:Return
	EndIf
	If n1=67 Then					;***** DEC (HL)
		PokeByte MemBank,PC,53:PC=PC+1			;x 00 110 101
		Okay=1:Return
	EndIf
	If n1>=16 And n1<=23 Then				;***** DEC r
		n2=(n1-16)*8+5
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 r 101		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** DEC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd		
		EndIf
		PokeByte MemBank,PC,53:PC=PC+1			;x 110101
		PokeByte MemBank,PC,n1t:PC=PC+1			;
		Okay=1:Return
	EndIf
	SetError(900,"DEC used incorrectly")
End Function
Function FuncINC() 
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)

	n1t=n1/256
	n1=n1 Mod 256

	If n1=6 Then				;***** INC IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,35:PC=PC+1			;&23
		Pk1(221,"     INC IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(35),7,2))
		Pk1(35)
		Okay=1:Return
	EndIf
	If n1=7 Then				;***** INC IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,35:PC=PC+1			;&23
		Pk1(253,"     INC IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(35),7,2))
		Pk1(35)		
		Okay=1:Return
	EndIf
	If n1>=2 And n1<=5 Then				;***** INC ss
		n2=(n1-2)*16+3
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 ss0 011
		Pk1(n2,"     INC "+SSRegister(n1-2)+"    ;** "+Mid$(Hex$(n2),7,2))
		Okay=1:Return
	EndIf
	If n1=67 Then					;***** INC (HL)
		PokeByte MemBank,PC,52:PC=PC+1			;x 00 110 100
		Pk1(52,"     INC (HL)    ;** "+Mid$(Hex$(52),7,2))		
		Okay=1:Return
	EndIf
	If n1>=16 And n1<=23 Then				;***** INC r
		n2=(n1-16)*8+4
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 r 100
		Pk1(n2,"     INC "+RRegister(n1-16)+"    ;** "+Mid$(Hex$(n2),7,2))
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			Pk1(221,"     INC (IX+"+Str$(n1t)+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(52),7,2)+" "+Mid$(Hex$(n1t),7,2))
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			Pk1(253,"     INC (IX+"+Str$(n1t)+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(52),7,2)+" "+Mid$(Hex$(n1t),7,2))
		EndIf
		PokeByte MemBank,PC,52:PC=PC+1			;x 110100
		PokeByte MemBank,PC,n1t:PC=PC+1			;
		Pk1(52)
		Pk1(n1t)
		Okay=1:Return
	EndIf
	SetError(900,"INC used incorrectly")
End Function
Function FuncIN()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"IN used incorrectly")
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(Cod)

	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n1=23 And n2=80 Then					;* IN a,(n)
		PokeByte MemBank,PC,219:PC=PC+1			;&DB
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1:Return
	EndIf
	If n1=>16 And n1<=23 And n2=70 Then		; IN r,(C)
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,((n1-16)*8)+64:PC=PC+1			;x 01 r 000
		Okay=1:Return
	EndIf
	SetError(900,"IN used incorrectly")
End Function
Function FuncOUT()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"OUT used incorrectly")
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(Cod)

	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n2=23 And n1=80 Then			
		PokeByte MemBank,PC,211:PC=PC+1			;&D3
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Okay=1:Return
	EndIf
	If n2=>16 And n2<=23 And n1=70 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,((n2-16)*8)+65:PC=PC+1			;x 01 r 001
		Okay=1:Return
	EndIf
	SetError(900,"OUT used incorrectly")
End Function
Function FuncLD()
	Okay=0
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	GetFir$=Reply$
	GetFia1=GetFia
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"LD gggg  used incorrectly")
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(Cod)
	GetSec$=Reply$
	GetFia2=GetFia
	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	If n2=23 And n1=80 Then 			;**** LD (nn),a
		PokeByte MemBank,PC,50:PC=PC+1	;&32
		Pk1(50,"     LD ("+GetFir+"),A    ;** "+Mid$(Hex$(50),7,2)+" LL HH")
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1			;data 1
		
		Pk1(0)
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;data 1		
		Pk1(0)
		Okay=1:Return
	End If
	If n1=23 And n2=80 Then 			;**** LD a,(nn)
		PokeByte MemBank,PC,58:PC=PC+1	;&3a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1	
		If GetFia2=0 Then 
			Pk1(58,"     LD A,("+Str16$(n2t)+")    ;** "+Mid$(Hex$(58),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk2(n2t)
		Else
			Pk1(58,"     LD A,("+GetSec+")    ;** "+Mid$(Hex$(58),7,2)+" LL HH")
			Pk2(n2t,GetSec)
		EndIf
		Okay=1:Return
	End If
	If n1=>2 And n1<=5 And n2=81 Then 			;**** LD dd,nn
		PokeByte MemBank,PC,((n1-2)*16)+1:PC=PC+1			;x 00 dd0 001
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1
		If GetFia2=0 Then 
			Pk1(((n1-2)*16)+1,"     LD "+SSRegister$(n1-2)+","+Str16$(n2t)+"    ;** "+Mid$(Hex$(((n1-2)*16)+1),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk2(n2t)
		Else
			Pk1(((n1-2)*16)+1,"     LD "+SSRegister$(n1-2)+","+GetSec+"    ;** "+Mid$(Hex$(((n1-2)*16)+1),7,2)+" LL HH")
			Pk2(n2t,GetSec)
		EndIf		
		
		Pk1(0)
		Pk1(0)		
		Okay=1:Return
	End If
	If n1=6 And n2=81 Then 			;**** LD IX,nn
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,33:PC=PC+1			;&21
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1
		If GetFia2=0 Then 
			Pk1(221,"     LD IX,"+Str16$(n2t)+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(33),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk1(33)
			Pk2(n2t)
		Else
			Pk1(221,"     LD IX,"+GetSec+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(33),7,2)+" LL HH")
			Pk1(33)
			Pk2(n2t,GetSec)
		EndIf
		Okay=1:Return
	End If
	If n1=7 And n2=81 Then 			;**** LD IY,nn
		PokeByte MemBank,PC,253:PC=PC+1			;&fd	
		PokeByte MemBank,PC,33:PC=PC+1			;&21
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1
		If GetFia2=0 Then 
			Pk1(253,"     LD IY,"+Str16$(n2t)+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(33),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk1(33)
			Pk2(n2t)
		Else
			Pk1(253,"     LD IY,"+GetSec+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(33),7,2)+" LL HH")
			Pk1(33)
			Pk2(n2t,GetSec)
		EndIf
		Okay=1:Return
	End If	

	If n1>=16 And n1<=23 And n2=81 Then 			;**** LD r,n
		PokeByte MemBank,PC,((n1-16)*8)+6:PC=PC+1			;x 00 r 110	
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(((n1-16)*8)+6,"     LD "+RRegister(n1-16)+","+GetSec+"    ;** "+Mid$(Hex$(((n1-16)*8)+6),7,2)+" "+" LL")
		Pk1n(GetSec)
		Okay=1:Return
	End If
	If n1=67 And n2=81 Then 			;**** LD (HL),n
		PokeByte MemBank,PC,54:PC=PC+1			;&36	
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(54,"     LD "+RRegister(n1-16)+","+GetSec+"    ;** "+Mid$(Hex$(54),7,2)+" "+" LL")
		Pk1n(GetSec)
		Okay=1:Return
	End If
	If n1=71 And n2=81 Then 			;**** LD (IX+ ),n
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,54:PC=PC+1			;&36			
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		PokeByte MemBank,PC,n2t:PC=PC+1			;ix+data
		Pk1(221,"     LD (IX+"+GetFir+"),"+GetSec+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(54),7,2)+" LL xx")		
		Pk1(54)
		Pk1n(GetFir)
		Pk1n(GetSec)		
		Okay=1:Return
	EndIf
	If n1=72 And n2=81 Then 			;**** LD (IY+ ),n
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,54:PC=PC+1			;&36			
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		PokeByte MemBank,PC,n2t:PC=PC+1			;ix+data
		Pk1(253,"     LD (IY+"+GetFir+"),"+GetSec+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(54),7,2)+" LL xx")	
		Pk1(54)
		Pk1n(GetSec)
		Pk1n(GetFir)		
		Okay=1:Return
	EndIf	
	If (n2>=16 And n2<=23) And n1=71 Then 	;**** LD (IX+ ),r
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Pk1(221,"     LD (IX+"+GetFir+"),"+RRegister(n2-16)+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1((n2-16)+112)
		Pk1n(GetFir)
		Okay=1:Return
	EndIf
	If (n2>=16 And n2<=23) And n1=72 Then 	;**** LD (IY+ ),r
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Pk1(253,"     LD (IY+"+GetFir+"),"+RRegister(n2-16)+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1((n2-16)+112)
		Pk1n(GetFir)		
		Okay=1:Return
	EndIf
	If (n1>=16 And n1<=23) And n2=71 Then 	;**** LD r,(IX+ )
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		n9=(n1-16)*8+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 101
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(221,"     LD "+RRegister(n1-16)+",(IX+"+GetSec+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1(n9)
		Pk1n(GetSec)		
		Okay=1:Return
	EndIf
	If (n1>=16 And n1<=23) And n2=72 Then 	;**** LD r,(IY+ )
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		n9=(n1-16)*8+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 110
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(253,"     LD "+RRegister(n1-16)+",(IY+"+GetSec+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1(n9)
		Pk1n(GetSec)		
		Okay=1:Return
	EndIf

	If (n2>=16 And n2<=23) And n1=67 Then 	;**** LD (HL),r
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		Pk1(n9,"     LD (HL),"+RRegister(n2-16)+"    ;** "+Mid$(Hex$(n9),7,2))
		Okay=1:Return
	End If
	If (n1>=16 And n1<=23) And n2=67 Then 	;**** LD r,(HL)
		n9=((n1-16)*8)+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 110
		Pk1(n9,"     LD "+RRegister(n1-16)+",(HL)    ;** "+Mid$(Hex$(n9),7,2))
		Okay=1:Return
	End If

	If n1=23 And n2=64 Then			;***** LD A,(BC)
		PokeByte MemBank,PC,10:PC=PC+1			;&0a
		Pk1(10,"     LD A,(BC)    ;** "+Mid$(Hex$(10),7,2))
		Okay=1:Return
	EndIf
	If n1=64 And n2=23 Then			;***** LD (BC),A
		PokeByte MemBank,PC,2:PC=PC+1			;&02
		Pk1(2,"     LD (BC),A    ;** "+Mid$(Hex$(2),7,2))
		Okay=1:Return
	EndIf
	If n1=23 And n2=65 Then			;***** LD A,(DE)
		PokeByte MemBank,PC,26:PC=PC+1			;&1a
		Pk1(26,"     LD A,(DE)    ;** "+Mid$(Hex$(26),7,2))		
		Okay=1:Return
	EndIf
	If n1=65 And n2=23 Then			;***** LD (DE),A
		PokeByte MemBank,PC,18:PC=PC+1			;&12
		Pk1(18,"     LD (DE),A    ;** "+Mid$(Hex$(18),7,2))
		Okay=1:Return
	EndIf
	If n1=4 And n2=80 Then			;***** LD HL,(nn)
		PokeByte MemBank,PC,42:PC=PC+1			;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(42,"     LD HL,("+GetSec+")    ;** "+Mid$(Hex$(42),7,2)+" LL HH")
		Pk2(GetSec$)
		Okay=1:Return
	EndIf
	If n1=2 And n2=80 Then			;***** LD BC,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,75:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh	
		Pk1(237,"     LD BC,("+GetSec+")    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(75),7,2)+" LL HH")
		Pk1(75)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf
	If n1=3 And n2=80 Then			;***** LD DE,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,91:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(237,"     LD DE,("+GetSec+")    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(91),7,2)+" LL HH")
		Pk1(91)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf
	If n1=5 And n2=80 Then			;***** LD SP,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,123:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(237,"     LD SP,("+GetSec+")    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(123),7,2)+" LL HH")
		Pk1(123)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf	
	If n1=6 And n2=80 Then			;***** LD IX,(nn)
		PokeByte MemBank,PC,221:PC=PC+1				;&ed
		PokeByte MemBank,PC,42:PC=PC+1				;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(221,"     LD IX,("+GetSec+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(42),7,2)+" LL HH")
		Pk1(42)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf	
	If n1=7 And n2=80 Then			;***** LD IY,(nn)
		PokeByte MemBank,PC,253:PC=PC+1				;&ed
		PokeByte MemBank,PC,42:PC=PC+1				;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(253,"     LD IY,("+GetSec+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(42),7,2)+" LL HH")
		Pk1(42)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf	
	If n1=80 And n2=4 Then			;***** LD (nn),HL
		PokeByte MemBank,PC,34:PC=PC+1			;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(34,"     LD ("+GetFir+"),HL    ;** "+Mid$(Hex$(34),7,2)+" LL HH")
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf
	If n1=80 And n2=2 Then			;***** LD (nn),BC
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,67:PC=PC+1				;x 01 dd 00 11
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh	
		Pk1(237,"     LD ("+GetFir+"),BC    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(67),7,2)+" LL HH")
		Pk1(67)
		Pk2(GetFir$)
		Okay=1:Return
	EndIf
	If n1=80 And n2=3 Then			;***** LD (nn),DE
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,83:PC=PC+1				;x 01 dd 00 11		
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(237,"     LD ("+GetFir+"),DE    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(83),7,2)+" LL HH")
		Pk1(83)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf
	If n1=80 And n2=5 Then			;***** LD (nn),SP
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,115:PC=PC+1				;x 01 dd 00 11		
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh	
		Pk1(237,"     LD ("+GetFir+"),SP    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(115),7,2)+" LL HH")
		Pk1(115)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf	
	If n1=80 And n2=6 Then			;***** LD (nn),IX
		PokeByte MemBank,PC,221:PC=PC+1				;&dd
		PokeByte MemBank,PC,34:PC=PC+1				;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(221,"     LD ("+GetFir+"),IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(34),7,2)+" LL HH")
		Pk1(34)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf
	If n1=80 And n2=7 Then			;***** LD (nn),IY
		PokeByte MemBank,PC,253:PC=PC+1				;&fd
		PokeByte MemBank,PC,34:PC=PC+1				;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(253,"     LD ("+GetFir+"),IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(34),7,2)+" LL HH")
		Pk1(34)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf		
	If n1>=16 And n1<=23 And n2=>16 And n2<=23 Then			;***** LD r,r
		r1=((n1-16)*8)+(n2-16)+64
		PokeByte MemBank,PC,r1:PC=PC+1			;x  01 r r
		Pk1(r1,"     LD "+RRegister(n1-16)+","+RRegister(n2-16)+"    ;** "+Mid$(Hex$(r1),7,2))
		Okay=1:Return	
	EndIf

	If n1=5 And n2=4 Then 			;***** LD SP,HL
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Pk1(249,"     LD SP,HL    ;** "+Mid$(Hex$(249),7,2))
		Okay=1:Return	
	EndIf
	If n1=5 And n2=6 Then 			;***** LD SP,IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Pk1(221,"     LD SP,IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(249),7,2))
		Pk1(249)
		Okay=1:Return	
	EndIf
	If n1=5 And n2=7 Then 			;***** LD SP,IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Pk1(253,"     LD SP,IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(249),7,2))
		Pk1(249)		
		Okay=1:Return		
	EndIf	

	If n1=32 And n2=23 Then			;***** LD R,A
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,79:PC=PC+1			;&4f
		Pk1(237,"     LD R,A    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(79),7,2))
		Pk1(79)
		Okay=1:Return	
	EndIf
	If n1=23 And n2=32 Then			;***** LD A,R
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,95:PC=PC+1			;&5f
		Pk1(237,"     LD A,R    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(95),7,2))
		Pk1(95)		
		Okay=1:Return
	EndIf
	If n1=33 And n2=23 Then			;***** LD I,A
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,71:PC=PC+1			;&47
		Pk1(237,"     LD I,A    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(71),7,2))
		Pk1(71)			
		Okay=1:Return	
	EndIf
	If n1=23 And n2=33 Then			;***** LD A,I
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,87:PC=PC+1			;&57
		Pk1(237,"     LD A,I    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(87),7,2))
		Pk1(87)			
		Okay=1:Return		
	EndIf
	SetError(900,"LD used incorrectly")
End Function
Function FuncEX()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="AF"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>"AF"Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		PokeByte MemBank,PC,8:PC=PC+1			;&08
		Okay=1
		Cod=Cod+1
		Return	
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>"HL"Then
			SetError(900,"EX used incorrectly")
			Return
		EndIf	
		PokeByte MemBank,PC,235:PC=PC+1			;&eb
		Okay=1
		Cod=Cod+1
		Return	
	EndIf
	If r$="("Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>"SP"Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>")"Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"EX used incorrectly")
			Return
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		n=0
		If r$="HL"Then
			n=1
			PokeByte MemBank,PC,227:PC=PC+1			;&e3
			Okay=1
			Cod=Cod+1
			Return
		EndIf
		If r$="IX"Then
			n=1
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,227:PC=PC+1			;&e3
			Okay=1
			Cod=Cod+1
			Return
		EndIf
		If r$="IY"Then
			n=1
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,227:PC=PC+1			;&e3
			Okay=1
			Cod=Cod+1
			Return
		EndIf
	EndIf	
	SetError(900,"EX used incorrectly")
End Function
Function FuncPop()
	r$=Upper$(SepSort$(Cod+1))	
	h=GetQQ(r$)	
	If h>=0 And h<=3 Then
		h1=193+(h*16)
		PokeByte MemBank,PC,193+(h*16):PC=PC+1			;x11 qq0 001
		Pk1(193+(h*16),"     POP "+QQRegister$(h)+"    ;** "+Mid$(Hex$(193+(h*16)),7,2))
		Cod=Cod+2
		Okay=1:Return
	EndIf
	If h=-1 Then
		If r$="IX"Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,225:PC=PC+1			;&e1
			Pk1(221,"     POP IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(225),7,2))
			Pk1(225)
			Cod=Cod+2
			Okay=1:Return
		EndIf
		If r$="IY"Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,225:PC=PC+1			;&e1
			Pk1(253,"     POP IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(225),7,2))
			Pk1(225)
			Cod=Cod+2
			Okay=1:Return
		EndIf	
	EndIf
	SetError(900,"POP used incorrectly")
End Function
Function FuncIM()
	Cod=Cod+1
	t=GetNumber(0)
	If t<0 Or t>2 Then
		SetError(900,"IM used incorrectly")
		Return
	EndIf
	If t=0 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,70:PC=PC+1			;&46
		Cod=Cod+1
		Okay=1:Return
	EndIf	
	If t=1 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,86:PC=PC+1			;&56
		Cod=Cod+1
		Okay=1:Return
	EndIf
	If t=2 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,94:PC=PC+1			;&5e
		Cod=Cod+1
		Okay=1:Return
	EndIf	
End Function	
Function FuncPush()
	r$=Upper$(SepSort$(Cod+1))	
	h=GetQQ(r$)	
	If h>=0 And h<=3 Then
		h1=197+(h*16)
		PokeByte MemBank,PC,197+(h*16):PC=PC+1			;x11 qq0 101
		Pk1(197+(h*16),"     PUSH "+QQRegister$(h)+"    ;** "+Mid$(Hex$(197+(h*16)),7,2))
		Cod=Cod+2
		Okay=1:Return
	EndIf
	If h=-1 Then
		If r$="IX"Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,229:PC=PC+1			;&e5
			Pk1(221,"     PUSH IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(229),7,2))
			Pk1(229)
			Cod=Cod+2
			Okay=1:Return
		EndIf
		If r$="IY"Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,229:PC=PC+1			;&e5
			Pk1(253,"     PUSH IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(229),7,2))
			Pk1(229)
			Cod=Cod+2
			Okay=1:Return
		EndIf	
	EndIf
	SetError(900,"PUSH used incorrectly")
End Function
Function FuncCALL()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=196+(h*8)
		PokeByte MemBank,PC,h1:PC=PC+1			;x11 cc 100	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"CALL used incorrectly")
			Return
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		t=GetNumber(1)
		Pk1(h1,"     CALL "+CCRegister(h)+","+Reply$+"    ;** "+Mid$(Hex$(h1),7,2)+" LL HH")		
		Okay=1
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,205:PC=PC+1			;&cd
		t=GetNumber(1)
		Pk1(205,"     CALL "+Reply$+"    ;** "+Mid$(Hex$(205),7,2)+" LL HH")	
		Okay=1
	EndIf
	t1=t Mod 256
	t2=(t/256)Mod 256
	PokeByte MemBank,PC,t1:PC=PC+1
	PokeByte MemBank,PC,t2:PC=PC+1
	Pk2(t)
	If Okay<>1 Then SetError(900,"CALL used incorrectly")
End Function
Function FuncRST()
	Cod=Cod+1
	b3=Failed
	t=GetNumber(1)
	b=0
	If t=8 Then b=1:Okay=1
	If t=16 Then b=2:Okay=1
	If t=24 Then b=3:Okay=1
	If t=32 Then b=4:Okay=1
	If t=40 Then b=5:Okay=1
	If t=48 Then b=6:Okay=1
	If t=56 Then b=7:Okay=1
	If Okay=1 Then 
		PokeByte MemBank,PC,(b*8)+199:PC=PC+1
		Pk1((b*8)+199,"     RST "+Str$(t)+"    ;** "+Mid$(Hex$((b*8)+199),7,2))
	Else
		SetError(900,"RST used incorrectly")
	EndIf
End Function
Function FuncDJNZ()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	b3=Failed
	t=GetNumber(1)	
	If b3=Failed Then
		t=t-PC-2
		If t>128 Or t<-127 Then Stop
	Else
		t=0
	EndIf
	PokeByte MemBank,PC,16:PC=PC+1				
	PokeByte MemBank,PC,t:PC=PC+1
	Okay=1
	Cod=Cod+1
	Return
End Function
Function FuncJR()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	b=0
	If r$="C"Then b=1
	If r$="NC"Then b=2
	If r$="Z"Then b=3
	If r$="NZ"Then b=4
	If b>0 Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))		
		If r$<>","Then
			SetError(900,"JR used incorrectly")
			Return
		Else
			Cod=Cod+1
			r$=Upper$(SepSort$(Cod))
		EndIf	
	EndIf
	b3=Failed
	t=GetNumber(1)	
	If b3=Failed Then
		t=t-PC-2
		If t>128 Or t<-127 Then 
			SetError(900,"JR outside range")
			Return
		EndIf	
	Else
		t=0
	EndIf
	If b=0 Then t1=24				;JR e 	&18
	If b=1 Then t1=56				;JR c,e  &38
	If b=2 Then t1=48				;JR nc,e  &30
	If b=3 Then t1=40				;JR z,e	  &28
	If b=4 Then t1=32   			;jr nz,e  &20
	PokeByte MemBank,PC,t1:PC=PC+1				
	PokeByte MemBank,PC,t:PC=PC+1
	Okay=1
	Cod=Cod+1
	Return
End Function
Function FuncJP()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="("Then Goto Jumping2
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=194+(h*8)
		PokeByte MemBank,PC,h1:PC=PC+1			;x11 cc 010		
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"JP used incorrectly")
			Return
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		t=GetNumber(1)
		Pk1(h1,"     JP "+CCRegister(h)+","+Reply$+"    ;** "+Mid$(Hex$(h1),7,2)+" LL HH")			
		Okay=1
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,195:PC=PC+1			;&c3
		t=GetNumber(1)
		Pk1(195,"     JP "+Reply$+"    ;** "+Mid$(Hex$(195),7,2)+" LL HH")
		Okay=1
	EndIf
	If Left$(r$,1)="."Then r$=Mid$(r$,2)
	If Okay=1 Then 
		t1=t Mod 256
		t2=(t/256)Mod 256
		PokeByte MemBank,PC,t1:PC=PC+1
		PokeByte MemBank,PC,t2:PC=PC+1
		Pk2(t,Reply$)
	Else
		SetError(900,"JP used incorrectly")
	EndIf
	Return

.Jumping2
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	n=0
	If r$="HL"Then
		PokeByte MemBank,PC,233:PC=PC+1			;#e9
		n=1			
	EndIf
	If r$="IX"Then
		PokeByte MemBank,PC,221:PC=PC+1			;#dd
		PokeByte MemBank,PC,233:PC=PC+1			;#e9		
		n=1			
	EndIf
	If r$="IY"Then
		PokeByte MemBank,PC,253:PC=PC+1			;#fd
		PokeByte MemBank,PC,233:PC=PC+1			;#e9		
		n=1			
	EndIf
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$<>")"Then n=0	
	If n=0 Then
		SetError(900,"JP used incorrectly")
	Else
		Okay=1
		Cod=Cod+1
	EndIf
End Function
Function FuncRET()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))	
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=192+(h*8)
		PokeByte MemBank,PC,192+(h*8):PC=PC+1			;x11 cc 000
		Pk1(192+(h*8),"     RET "+CCRegister$(h)+"    ;** "+Mid$(Hex$(192+(h*8)),7,2))
		Cod=Cod+1
		Okay=1:Return
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,201:PC=PC+1			;&c9
		Pk1(201,"     RET    ;** "+Mid$(Hex$(201),7,2))
		Okay=1:Return	
	EndIf
	SetError(900,"RET used incorrectly")
	Return	
End Function
Function FuncENDF()
	If CurrIf>0 Then
		SetError(106,"'EndIf' expected before 'EndF'")
		Return
	EndIf	
	If CurrWhile>0 Then
		SetError(106,"'Wend' expected before 'EndF'")
		Return
	EndIf
	If CurrRepeat>0 Then
		SetError(106,"'Until' expected before 'EndF'")
		Return
	EndIf	
	Cod=Cod+1
	If FunctionUsing=0 Or CodeType=0 Then
		PokeByte MemBank,PC,201:PC=PC+1			;&c9
	Else
		;**** Function must return Value
		If FunctionUsing=2 Then
			AddJPRoutine("SyB_Push_Null_Int","SYB.MATH.PUSH.INT.0") 		;JP Not Call. Ret at End of Routine
		EndIf	
		If FunctionUsing=3 Then
			AddJPRoutine("SyB_Push_Null_Flo")		;JP not Call
		EndIf
		If FunctionUsing=5 Then
			AddJPRoutine("SyB_Push_Null_Str") 		;JP not Call
		EndIf
		If FunctionUsing<>2 And FunctionUsing<>3 And FunctionUsing<>5 Then RuntimeError(527)
		
	EndIf
	FunctionUsing=0
	Okay=1		
End Function
Function FuncRLCA()
	PokeByte MemBank,PC,7:PC=PC+1			;&07
	Pk1(7,"     RLCA    ;** "+Mid$(Hex$(7),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRLA()
	PokeByte MemBank,PC,23:PC=PC+1			;&17
	Pk1(23,"     RLA    ;** "+Mid$(Hex$(23),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRCA()
	PokeByte MemBank,PC,15:PC=PC+1			;&0f
	Pk1(15,"     RRCA    ;** "+Mid$(Hex$(15),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRA()
	PokeByte MemBank,PC,31:PC=PC+1			;&1f
	Pk1(31,"     RRA    ;** "+Mid$(Hex$(31),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRLD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,111:PC=PC+1			;&6f
	Pk1(237,"     RLD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(111),7,2))
	Pk1(111)
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,103:PC=PC+1			;&67
	Pk1(237,"     RRD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(103),7,2))
	Pk1(103)
	Cod=Cod+1
	Okay=1
End Function
Function FuncNOP()
	PokeByte MemBank,PC,0:PC=PC+1			;&0
	Pk1(0,"     NOP    ;** 00")
	Cod=Cod+1
	Okay=1
End Function
Function FuncEXX()
	PokeByte MemBank,PC,217:PC=PC+1			;&d9
	Pk1(217,"     EXX    ;** "+Mid$(Hex$(217),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRETI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,77:PC=PC+1			;&4d
	Pk1(237,"     RETI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(77),7,2))
	Pk1(77)
	Cod=Cod+1
	Okay=1
End Function
Function FuncRETN()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,69:PC=PC+1			;&45
	Pk1(237,"     RETN    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(69),7,2))
	Pk1(69)
	Cod=Cod+1
	Okay=1
End Function
Function FuncINI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,162:PC=PC+1			;&a2
	Pk1(237,"     INI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(162),7,2))
	Pk1(162)
	Cod=Cod+1
	Okay=1
End Function
Function FuncINIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,178:PC=PC+1			;&b2
	Pk1(237,"     INIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(178),7,2))
	Pk1(178)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncIND()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,170:PC=PC+1			;&aa
	Pk1(237,"     IND    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(170),7,2))
	Pk1(170)
	Cod=Cod+1
	Okay=1
End Function
Function FuncINDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,186:PC=PC+1			;&ba
	Pk1(237,"     INDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(186),7,2))
	Pk1(186)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOUTI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,163:PC=PC+1			;&a3
	Pk1(237,"     OUTI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(163),7,2))
	Pk1(163)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOTIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,179:PC=PC+1			;&b3
	Pk1(237,"     OTIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(179),7,2))
	Pk1(179)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOUTD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,171:PC=PC+1			;&ab
	Pk1(237,"     OUTD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(171),7,2))
	Pk1(171)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOTDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,139:PC=PC+1			;&8b
	Pk1(237,"     OTDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(139),7,2))
	Pk1(139)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,168:PC=PC+1			;&a8
	Pk1(237,"     LDD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(168),7,2))
	Pk1(168)
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,184:PC=PC+1			;&b8
	Pk1(237,"     LDDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(184),7,2))
	Pk1(184)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,161:PC=PC+1			;&a1
	Pk1(237,"     CPI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(161),7,2))
	Pk1(161)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,177:PC=PC+1			;&b1	
	Pk1(237,"     CPIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(177),7,2))
	Pk1(177)
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,169:PC=PC+1			;&a9
	Pk1(237,"     CPD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(169),7,2))
	Pk1(169)
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,185:PC=PC+1			;&b9
	Pk1(237,"     CPDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(185),7,2))
	Pk1(185)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncHALT()
	PokeByte MemBank,PC,118:PC=PC+1			;&76
	Pk1(118,"     HALT    ;** "+Mid$(Hex$(118),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncCCF()
	PokeByte MemBank,PC,63:PC=PC+1			;&3f
	Pk1(63,"     CCF    ;** "+Mid$(Hex$(63),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncSCF()
	PokeByte MemBank,PC,55:PC=PC+1			;&37
	Pk1(55,"     SCF    ;** "+Mid$(Hex$(55),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncDAA()
	PokeByte MemBank,PC,39:PC=PC+1			;&27
	Pk1(39,"     DAA    ;** "+Mid$(Hex$(39),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPL()
	PokeByte MemBank,PC,47:PC=PC+1			;&2f
	Pk1(47,"     CPL    ;** "+Mid$(Hex$(47),7,2))	
	Cod=Cod+1
	Okay=1
End Function
Function FuncNEG()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,68:PC=PC+1			;&44
	Pk1(237,"     NEG     ;** ED 44")
	Pk1(68)
	Cod=Cod+1
	Okay=1
End Function
Function FuncEI()
	PokeByte MemBank,PC,251:PC=PC+1			;&fb
	Pk1(251,"     EI     ;** FB")
	Cod=Cod+1
	Okay=1
End Function
Function FuncDI()
	PokeByte MemBank,PC,243:PC=PC+1			;&f3
	Pk1(243,"     DI     ;** F3")
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,176:PC=PC+1			;&b0
	Pk1(237,"     LDIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(176),7,2))
	Pk1(176)
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,160:PC=PC+1			;&a0
	Pk1(237,"     LDI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(160),7,2))
	Pk1(160)	
	Cod=Cod+1
	Okay=1
End Function
;***** Basic Expressions *****
Function FuncCODE()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="ASSEM" Or r$="ASM" Or r$="Z80"Then
		Okay=1
		Cod=Cod+1
		CodeType=0
		Okay=1:Return
	EndIf
	If r$="BASIC" Then
		Okay=1
		Cod=Cod+1
		CodeType=1
		Okay=1:Return
	EndIf
	SetError(900,"CODE used incorrectly")
	Return
End Function
Function BasicFor(Wrd)
	Cod=Cod+1
	r$=SepSort$(Cod)
	res=IsVariable#(r$)
	If Succeed=False Then ErrMessage$="Variable expected after Next":Err=120:Return
	t=GetRoutineLocation(r$)
	If VarType(res)<>11 And VarType(Res)<>13 Then 
		ErrMessage$="Next Variable must either be a Float or Integer variable":Err=120:Return
	EndIf
	LoopNum=LoopNum+1	
	If VarType(res)=11 Then LoopTyp(LoopNum)=1			;Integer For Next
	If VarType(res)=13 Then LoopTyp(LoopNum)=2			;Float For Next	
	Res1=Res
	Cod=Cod+1
	r$=SepSort$(Cod)
	If r$<>"="Then ErrMessage$="'=' was expected":Err=120:Return
	Cod=Cod+1
	Terminator$="TO"
	If VarType(Res1)=11 Then AddExpression(Cod,0,2)
	If VarType(Res1)=13 Then AddExpression(Cod,0,3)
	Terminator$="STEP"
	r$=Upper$(SepSort$(Cod))
	If r$<>"TO"Then ErrMessage$=r$+"'TO' was expected":Err=120:Return
	Cod=Cod+1
	If VarType(Res1)=11 Then AddExpression(Cod,0,2)
	If VarType(Res1)=13 Then AddExpression(Cod,0,3)
	Terminator$=""
	r$=Upper$(SepSort$(Cod))
	If r$="STEP"Then
		Cod=Cod+1
		If VarType(Res1)=11 Then AddExpression(Cod,0,2)
		If VarType(Res1)=13 Then AddExpression(Cod,0,3)
	Else
		If VarType(Res1)=11 Then AddRoutine("SyB_Push_Int_1","SYB.MATH.PUSH.INT.1")
		If VarType(Res1)=13 Then AddRoutine("SyB_Push_Flo_1","SYB.MATH.PUSH.FLOAT.1")		
	EndIf
	
	If VarType(Res1)=11 Then AddRoutine("SyB_ForStarter_Int")
	If VarType(Res1)=13 Then AddRoutine("SyB_ForStarter_Flo")	
	Cod=Cod+1
	t1=t Mod 256
	t2=(t/256)Mod 256
	PokeByte MemBank,PC,t1:PC=PC+1
	PokeByte MemBank,PC,t2:PC=PC+1
	LoopStart(LoopNum)=PC
	If VarType(Res1)=11 Then AddRoutine("SyB_For_Int")
	If VarType(Res1)=13 Then AddRoutine("SyB_For_Flo")
	LoopAddr(LoopNum)=PC					;This gets the 
	PokeByte MemBank,PC,0:PC=PC+1
	PokeByte MemBank,PC,0:PC=PC+1
	Okay=1	
End Function
Function BasicNext(Wrd)
	Cod=Cod+1
	If LoopNum<1 Then ErrMessage$="Unexpected NEXT":Err=120:Return
	If LoopTyp(LoopNum)=3 Then ErrMessage$="WHILE Loop still unresolved":Err=120:Return
	If LoopTyp(LoopNum)=4 Then ErrMessage$="REPEAT Loop still unresolved":Err=120:Return	
	If LoopTyp(LoopNum)=1 Then AddRoutine("SyB_Next_Int")
	If LoopTyp(LoopNum)=2 Then AddRoutine("SyB_Next_Flo")
	t1=LoopStart(LoopNum) Mod 256
	t2=(LoopStart(LoopNum))/256
	PokeByte MemBank,PC,t1:PC=PC+1						;Put the Adress to jump back too
	PokeByte MemBank,PC,t2:PC=PC+1		
	t1=PC Mod 256
	t2=(PC/256)Mod 256	
	PokeByte MemBank,LoopAddr(LoopNum),t1				;Put the Adress to skip into FOR
	PokeByte MemBank,LoopAddr(LoopNum)+1,t2	
	LoopNum=LoopNum-1
	Okay=1
End Function
Function BasicCloseFile()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	AddRoutine("SyB_CloseFile","SYB.FILE.CLOSE")
	Okay=1
End Function
Function BasicSeekFile(Wrd)
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then ErrMessage$="',' expected":Err=120:Return
	Cod=Cod+1	
	AddExpression(Cod,d,3)
	AddRoutine("SyB_SeekFile")
	Okay=1
End Function
Function BasicFreeBank()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	AddRoutine("SyB_FreeBank","SYB.APP.FREEBANK")
	Okay=1
End Function
Function BasicClearBank()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	AddRoutine("SyB_ClearBank","SYB.APP.CLEARBANK")
	Okay=1
End Function
Function BasicPokeByte()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then ErrMessage$="',' expected":Err=120:Return
	Cod=Cod+1	
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then ErrMessage$="',' expected":Err=120:Return
	Cod=Cod+1	
	AddExpression(Cod,d,2)
	AddRoutine("SyB_PokeByte","SYB.APP.POKEBYTE")
	Okay=1
End Function
Function BasicRefreshAll()
	Cod=Cod+1
	AddExpression(Cod,0,2)	
	AddRoutine("SyB_RefreshAll","SYB.CONTROL.REFRESHALL")
	Okay=1
End Function
Function BasicRefreshTitle()
	Cod=Cod+1
	AddExpression(Cod,0,2)	
	AddRoutine("SyB_RefreshTitle","SYB.FORM.REFRESH.PARTS")
	Okay=1	
End Function
Function BasicRefreshStatus()
	Cod=Cod+1
	AddExpression(Cod,0,2)	
	AddRoutine("SyB_RefreshStatus","SYB.FORM.REFRESH.PARTS")
	Okay=1	
End Function
Function BasicRandomize()
	Cod=Cod+1
	AddExpression(Cod,0,3)	
	AddRoutine("SyB_Randomize","SYB.MATH.RANDOMIZE")
	Okay=1	
End Function
Function BasicPokeInt()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then ErrMessage$="',' expected":Err=120:Return
	Cod=Cod+1	
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then ErrMessage$="',' expected":Err=120:Return
	Cod=Cod+1	
	AddExpression(Cod,d,2)
	AddRoutine("SyB_PokeInt","SYB.APP.POKEINT")
	Okay=1
End Function
Function BasicPokeFloat()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then ErrMessage$="',' expected":Err=120:Return
	Cod=Cod+1	
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then ErrMessage$="',' expected":Err=120:Return
	Cod=Cod+1	
	AddExpression(Cod,d,3)
	AddRoutine("SyB_PokeFloat","SYB.APP.POKEFLOAT")
	Okay=1
End Function
Function BasicLET(Wrd,Var=0)
;**** 11 = Variable 16bit Integer
;**** 12 = Variable 32bit Integer
;**** 13 = Variable 40bit Float
;**** 14 = Variable 8Bit Byte
;**** 15 = Variable 16Bit String
	
	VarLocation=GetRoutineLocation(VarName$(Var))
	r1$=SepSort$(Cod)
	Cod=Cod+1
	r$=SepSort$(Cod)
	Cod=Cod+CheckVarSame(r$,r1$,Var)
	
	If Err>0 Then Return
	a=VarType(Var)
	a9=0
	;**** Single Array ****
	If a=31 Or a=33 Or a=35 Then
		r$=Upper$(SepSort$(Cod))
		If r$<>"("Then
			Err=108
			ErrMessage$="'(' expected"
			Return
		EndIf
		Cod=Cod+1
		AddExpression$(Cod,1,2)			;Get result with Int Out
		If Err<>0 Then Return
		r$=Upper$(SepSort$(Cod))
		If r$<>")"Then
			Err=108
			ErrMessage$="')' expected"
			Return
		EndIf
		Cod=Cod+1
		a9=1
	EndIf
	;**** Double Array ****
	If a=41 Or a=43 Or a=45 Then
		r$=Upper$(SepSort$(Cod))
		If r$<>"("Then
			Err=108
			ErrMessage$="'(' expected"
			Return
		EndIf		
		Cod=Cod+1
		Terminator$=","
		r$=Upper$(SepSort$(Cod))
		AddExpression$(Cod,1,2)			;Get result with Int Out
		If Err<>0 Then Return
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			Err=108
			ErrMessage$="',' expected"
			Return
		EndIf
		Cod=Cod+1
		AddExpression$(Cod,1,2)			;Get result with Int Out
		If Err<>0 Then Return
		r$=Upper$(SepSort$(Cod))
		If r$<>")"Then
			Err=108
			ErrMessage$="')' expected"
			Return
		EndIf
		Cod=Cod+1		
		a9=2
	EndIf
	;**** Lets Decode Expression
	r$=Upper$(SepSort$(Cod))
	
	adder=0
	If r$="+"Then adder=1
	If r$="-"Then adder=2
	If adder>0 Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
	EndIf	
	If r$<>"=" Then
		Err=101					;"=" expected
		Return
	EndIf
	;If adder>0 Then Stop
	Cod=Cod+1
	HLReturn=1
	LastOperation=AddExpression$(Cod)
	If Err<>0 Then Return
	n=-1
	If a=11 Or a=14 Or a=31 Or a=41 Then n=2
	If a=13 Or a=33 Or a=43 Then n=3
	If a=15 Or a=35 Or a=45 Then n=5
	If n=2 And LastOperation=3 Then AddRoutine("SyB_Flo_2_Int_Stack_1","SYB.FLOAT.2.INT.STACK"):LastOperation=2
	If n=3 And LastOperation=2 Then AddRoutine("SyB_Int_2_Flo","SYB.INT.2.FLOAT.STACK"):LastOperation=3
	If LastOperation<>n Then
		ErrMessage$="Did Not recognise Type To Type"
		Err=110
		Return	
	EndIf
	
	If n=2 And a9=0 And a<>14 Then
		If WasHLReturn=1 Then
			PokeByte MemBank,PC,34:PC=PC+1			;**** #22  -  LD (nn),HL
			PokeShort MemBank,PC,VarLocation:PC=PC+2
		Else	
			If adder=0 Then 
				PokeByte MemBank,PC,17:PC=PC+1			;**** #11  -  LD DE,addr
				PokeShort MemBank,PC,VarLocation:PC=PC+2
				AddRoutine("SyB_Store_Int_Direct","SYB.STORE.STACK.2.DE")		
			Else
				PokeByte MemBank,PC,17:PC=PC+1			;**** #11  -  LD DE,addr
				PokeShort MemBank,PC,VarLocation:PC=PC+2
				AddRoutine("SyB_Store_Int_Direct_Addertttttttrrrrr")		
			EndIf		
		EndIf
	EndIf	
	
	
	If n=2 And a9=0 And a=14 Then AddRoutine("SyB_Store_Byt"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	If n=2 And a9=1 Then 
		PokeByte MemBank,PC,17:PC=PC+1			;**** #11  -  LD DE,addr
		PokeShort MemBank,PC,VarLocation+2:PC=PC+2
		AddRoutine("SyB_Store_Int_Array_1_Direct","SYB.STORE.INT.ARRAY.1.DIRECT")			
		;AddRoutine("SyB_Store_Int_Array_1"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	EndIf	
	If n=2 And a9=2 Then AddRoutine("SyB_Store_Int_Array_2"):PokeShort MemBank,PC,VarLocation:PC=PC+2	
	If n=3 And a9=0 Then AddRoutine("SyB_Store_Flo"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	If n=3 And a9=1 Then AddRoutine("SyB_Store_Flo_Array_1","SYB.STORE.FLO.ARRAY.1"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	If n=3 And a9=2 Then AddRoutine("SyB_Store_Flo_Array_2","SYB.STORE.FLOAT.ARRAY.2"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	If n=5 And a9=0 Then AddRoutine("SyB_Store_Str"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	If n=5 And a9=1 Then AddRoutine("SyB_Store_Str_Array_1"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	If n=5 And a9=2 Then AddRoutine("SyB_Store_Str_Array_2"):PokeShort MemBank,PC,VarLocation:PC=PC+2
	;PokeShort MemBank,PC,VarLocation:PC=PC+2
	Okay=1
End Function
Function CommandBracket()
	r$=Upper$(SepSort$(Cod))
	If r$="("Then
		Cod=Cod+1
		Return 2
	EndIf
	Return 0	
End Function

Function BasicDirectoryNew()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,5)
	AddRoutine("SyB_Directory_New","SYB.DIRECTORY.NEW")
	Okay=1
End Function
Function BasicDirectoryDelete()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,5)
	AddRoutine("SyB_Directory_Delete","SYB.DIRECTORY.NEW")
	Okay=1
End Function
Function BasicDirectoryRename()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,5)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then 
		ErrMessage$="',' expected":Err=120
		Return
	EndIf
	Cod=Cod+1
	AddExpression(Cod,d,5)
	AddRoutine("SyB_Directory_Rename","SYB.DIRECTORY.RENAME")
	Okay=1
End Function
Function BasicDirectoryMove()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,5)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then 
		ErrMessage$="',' expected":Err=120
		Return
	EndIf
	Cod=Cod+1
	AddExpression(Cod,d,5)
	AddRoutine("SyB_Directory_Move","SYB.DIRECTORY.RENAME")
	Okay=1
End Function
Function BasicDialog(Wrd)
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,5)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then 
		ErrMessage$="',' expected":Err=120
		Return
	EndIf
	Cod=Cod+1
	AddExpression(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then 
		RuntimeError(76)
		ErrMessage$="',' expected":Err=120
		Return
	EndIf
	Cod=Cod+1
	AddExpression(Cod,d,2)
	AddRoutine("SyB_Dialog")
	Okay=1
End Function
Function BasicReturn(Wrd)
	Cod=Cod+1
	If FunctionUsing>0 Then
		AddExpression(Cod,0,FunctionUsing)
	EndIf
	PokeByte MemBank,PC,201:PC=PC+1		;*** C9 = RET
	Okay=1
End Function
Function BasicRepeat(Wrd)
	Cod=Cod+1
	RepeatStartAddr(CurrRepeat)=PC
	CurrRepeat=CurrRepeat+1
	CurrExit=CurrExit+1
	Okay=1
	DirectCommand=1
End Function
Function BasicWHILE(Wrd)
	Cod=Cod+1
	WhileStartAddr(CurrWhile)=PC
	AddExpression(Cod,0,2)
	AddRoutine("SyB_IF")
	WhileListAddr(CurrWhile)=PC
	PokeShort MemBank,PC,0:PC=PC+2			;***** This is where the Jump Address While False will be 
	CurrWhile=CurrWhile+1
	CurrExit=CurrExit+1
	Okay=1
	DirectCommand=1
End Function
Function BasicExit(Wrd)
	Cod=Cod+1
	If CurrExit<0 Then
		ErrMessage$="'Exit' not within a loop"
		Err=106
	EndIf
	PokeByte MemBank,PC,195:PC=PC+1			;&cd	JP
	For h=1 To 255
		If ExitWhere(CurrExit,h)=0 Then ExitWhere(CurrExit,h)=PC:Exit
	Next
	PokeShort MemBank,PC,0:PC=PC+2			;**** Just blank to be filled in when we have the exit point address
	Okay=1	
End Function
Function BasicForever(Wrd)
	Cod=Cod+1
	CurrRepeat=CurrRepeat-1

	If CurrRepeat<0 Then
		ErrMessage$="'forever' without 'repeat'"
		Err=105
		Return
	EndIf
	PokeByte MemBank,PC,195:PC=PC+1			;&cd	JP
	PokeShort MemBank,PC,RepeatStartAddr(CurrRepeat):PC=PC+2
	;**** Exit Stuff
	For h=1 To 255
		If ExitWhere(CurrExit,h)<>0 Then
			PokeShort MemBank,ExitWhere(CurrExit,h),PC
			ExitWhere(CurrExit,h)=0
		EndIf	
	Next
	CurrExit=CurrExit-1
	;****
	Okay=1
End Function
Function BasicUntil(Wrd)
	Cod=Cod+1
	CurrRepeat=CurrRepeat-1
	CurrExit=CurrExit-1
	If CurrRepeat<0 Then
		ErrMessage$="'until' without 'repeat'"
		Err=105
		Return
	EndIf
	AddExpression$(Cod)
	PokeByte MemBank,PC,205:PC=PC+1			;&cd	CALL
	t=GetRoutineLocation("SymBasic_IFCMP32")
	PokeShort MemBank,PC,t:PC=PC+2
	PokeShort MemBank,PC,RepeatStartAddr(CurrRepeat):PC=PC+2
	;**** Exit Stuff
	For h=1 To 255
		If ExitWhere(CurrExit,h)<>0 Then
			PokeShort MemBank,ExitWhere(CurrExit,h),PC
			ExitWhere(CurrExit,h)=0
		EndIf	
	Next
	CurrExit=CurrExit-1
	;****
	Okay=1
End Function
Function BasicRad()
	Cod=Cod+1
	AddRoutine("SyB_Rad","SYB.MATH.RAD") 
	Okay=1
End Function
Function BasicGarbage(Wrd)
	Cod=Cod+1
	AddRoutine("SyB_Garbage") 
	Okay=1
End Function
Function BasicSetSecond(Wrd)
	Cod=Cod+1
	AddRoutine("SyB_SetSecond")
	Okay=1
End Function
Function BasicSetMinute(Wrd)
	Cod=Cod+1
	AddRoutine("SyB_SetMinute")
	Okay=1
End Function
Function BasicSetHour(Wrd)
	Cod=Cod+1
	AddRoutine("SyB_SetHour")
	Okay=1
End Function
Function BasicSetDay(Wrd)
	Cod=Cod+1
	AddRoutine("SyB_SetDay")
	Okay=1
End Function
Function BasicSetMonth(Wrd)
	Cod=Cod+1
	AddRoutine("SyB_SetMonth")
	Okay=1
End Function
Function BasicSetYear(Wrd)
	Cod=Cod+1
	AddRoutine("SyB_SetYear")
	Okay=1
End Function
Function BasicDeg()
	Cod=Cod+1
	AddRoutine("SyB_Deg","SYB.MATH.SIN")
	Okay=1
End Function
Function BasicErrorClear()
	Cod=Cod+1
	AddRoutine("SyB_ErrorClear","SYB.ERROR.CLEAR")
	Okay=1
End Function
Function BasicDi(Wrd)
	Cod=Cod+1
	PokeByte MemBank,PC,243:PC=PC+1		;243=DI
	Okay=1
End Function
Function BasicEi(Wrd)
	Cod=Cod+1
	PokeByte MemBank,PC,251:PC=PC+1		;251=EI
	Okay=1
End Function
Function BasicWEND(Wrd)
	Cod=Cod+1
	CurrWhile=CurrWhile-1
	CurrExit=CurrExit-1
	If CurrExit<0 Then CurrExit=0
	If CurrWhile<0 Then
		ErrMessage$="'Wend' without 'While'"
		Err=105
		Return
	EndIf
	;**** Puts Loop to start of wend
	PokeByte MemBank,PC,195:PC=PC+1		;*** JP
	PokeShort MemBank,PC,WhileStartAddr(CurrWhile):PC=PC+2
	WhileStartAddr(CurrWhile)=0
	;**** Puts to Jump to after Wend
	PokeShort MemBank,WhileListAddr(CurrWhile),PC
	WhileListAddr(CurrWhile)=0
	;**** Exit Stuff
	For h=1 To 255
		If ExitWhere(CurrExit,h)<>0 Then
			PokeShort MemBank,ExitWhere(CurrExit,h),PC
			ExitWhere(CurrExit,h)=0
		EndIf	
	Next
	CurrExit=CurrExit-1
	;****	
	Okay=1
End Function
Function BasicIF()
	Cod=Cod+1
	HLReturn=1
	AddExpression$(Cod,0,2)
	ForceEndIf=1
	r$=Upper$(SepSort$(Cod))
	If r$="THEN" Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
	EndIf
	If r$=";" Or r$="" Or r$="/" Then
		ForceEndIf=0
	EndIf
	If WasHLReturn=1 Then
		PokeByte MemBank,PC,125:PC=PC+1
		PokeByte MemBank,PC,167:PC=PC+1
		PokeByte MemBank,PC,32:PC=PC+1
		PokeByte MemBank,PC,5:PC=PC+1
		PokeByte MemBank,PC,124:PC=PC+1
		PokeByte MemBank,PC,167:PC=PC+1
		PokeByte MemBank,PC,202:PC=PC+1
		Pk1(125,"     LD A,L    ;**")
		Pk1(167,"     AND A    ;**")
		Pk1(32,"     JR NZ,xx    ;**")
		Pk1(7)
		Pk1(124,"     LD A,L    ;**")
		Pk1(167,"     AND A    ;**")
		Pk1(202,"     JP NZ,xx    ;**")
	Else	
		AddRoutine("SyB_IF","SYB.IF")
	EndIf	
	IfListAddr(CurrIf)=PC
	PokeShort MemBank,PC,0:PC=PC+2			;***** This is where the Jump Address If False will be 
	IfElseList(CurrIf)=1
	CurrIf=CurrIf+1
	Okay=1
	DirectCommand=1
End Function
Function BasicEndIf(Wrd)
	Cod=Cod+1
	CurrIf=CurrIf-1
	If CurrIf<0 Then
		Err=102
		Return
	EndIf	
	;**** Puts to Jump too location in the Last IF / ELSE reference
	PokeShort MemBank,IfListAddr(CurrIf),PC
	IfListAddr(CurrIf)=0
	Okay=1
End Function
Function BasicForceEndIf()
	CurrIf=CurrIf-1
	If CurrIf<0 Then
		Err=102
		Return
	EndIf	
	;**** Puts to Jump too location in the Last IF / ELSE reference
	PokeShort MemBank,IfListAddr(CurrIf),PC
	IfListAddr(CurrIf)=0
	Okay=1
End Function
Function BasicElse(Wrd)
	Cod=Cod+1
	If CurrIf<=0 Then
		Err=103
		Return
	EndIf
	If IfElseList(CurrIf-1)=0 Then
		Err=104
		Return
	EndIf
	
	IfElseList(CurrIf-1)=0
	;**** First we need to add a Jump to the current code
	PokeByte MemBank,PC,195:PC=PC+1			;***** Add a JP instructio
	a=PC
	PokeShort MemBank,PC,0:PC=PC+2			;***** This is where the Jump Address (Filled in with ENDIF)
	;****
	PokeShort MemBank,IfListAddr(CurrIf-1),PC
	IfListAddr(CurrIf-1)=a
	Okay=1
	DirectCommand=1
	
End Function
Function BasicGoto(Wrd)
	Cod=Cod+1
	PokeByte MemBank,PC,195:PC=PC+1			;&c3
	r$=Upper$(SepSort$(Cod))	
	t=GetRoutineLocation(r$)
	Cod=Cod+1
	t1=t Mod 256
	t2=(t/256)Mod 256
	PokeByte MemBank,PC,t1:PC=PC+1
	PokeByte MemBank,PC,t2:PC=PC+1
	Okay=1
End Function
Function BasicControlFunction(vartyp,f,g)
	;**** Control.Refresh
	If vartyp=4000 And ObData(f,g,QTyp)>1 Then
		If ObData(f,g,QITB)>255 Then
			PokeByte MemBank,PC,30:PC=PC+1								;**** #1E,x  -  LD E,x
			PokeByte MemBank,PC,ObData(f,g,QCID)Mod 256:PC=PC+1			;**** #1E,x 
			PokeByte MemBank,PC,14:PC=PC+1								;**** #0E,x  -  LD C,x
			PokeByte MemBank,PC,ObData(f,g,QCID)/2048:PC=PC+1			;**** #0E,x 
			AddRoutine("SyB_ControlTool_Refresh","Syb.ControlTool.Refresh")
			Okay=1:Return
		Else
			PokeByte MemBank,PC,30:PC=PC+1								;**** #1E,x  -  LD E,x
			PokeByte MemBank,PC,ObData(f,g,QCID)Mod 256:PC=PC+1			;**** #1E,x 
			PokeByte MemBank,PC,14:PC=PC+1								;**** #0E,x  -  LD C,x
			PokeByte MemBank,PC,ObData(f,g,QCID)/2048:PC=PC+1			;**** #0E,x 			
			AddRoutine("SyB_Control_Refresh","Syb.Control.Refresh")
			Okay=1:Return
		EndIf
	EndIf
	;If cnt$=".graphic" And ObData(f,g,QTyp)=12 Then 					;Only for ImageBox's
	;EndIf	
	
	;**** Control.Scroll.Refresh
	If vartyp=4001 And ObData(f,g,QTyp)=1
		PokeByte MemBank,PC,14:PC=PC+1									;**** #0E,x  -  LD C,x
		PokeByte MemBank,PC,ObData(f,g,QCID)*8:PC=PC+1					;**** #0E,x 
		AddRoutine("SyB_Form_Scroll_Refresh","SYB.FORM.SCROLL.REFRESH")
		Okay=1:Return
	EndIf
	
	Cod=Cod+1
End Function
Function BasicWriteByte()
	Cod=Cod+1
	d=CommandBracket()	
	AddExpression$(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		ErrMessage$="',' expected":Err=120
		Return
	Else
		Cod=Cod+1
		AddExpression$(Cod,d,2)
		AddRoutine("SyB_WriteByte","SYB.FILE.BYTE.WRITE")
	EndIf
	Okay=1	
End Function
Function BasicWriteInt()
	Cod=Cod+1
	d=CommandBracket()	
	AddExpression$(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		ErrMessage$="',' expected":Err=120
		Return
	Else
		Cod=Cod+1
		AddExpression$(Cod,d,2)
		AddRoutine("SyB_WriteInt","SYB.FILE.INT.WRITE")
	EndIf
	Okay=1	
End Function
Function BasicWriteFloat()
	Cod=Cod+1
	d=CommandBracket()	
	AddExpression$(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		ErrMessage$="',' expected":Err=120
		Return
	Else
		Cod=Cod+1
		AddExpression$(Cod,d,3)
		AddRoutine("SyB_WriteFloat","SYB.FILE.FLOAT.WRITE")
	EndIf
	Okay=1	
End Function
Function BasicWriteLine()
	Cod=Cod+1
	d=CommandBracket()	
	AddExpression$(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		ErrMessage$="',' expected":Err=120
		Return
	Else
		Cod=Cod+1
		AddExpression$(Cod,d,5)
		AddRoutine("SyB_WriteLine","SYB.FILE.LINE.WRITE")
	EndIf
	Okay=1	
End Function

Function BasicCloseForm()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)	
	AddRoutine("SyB_CloseForm","SYB.FORM.CLOSE")
	Okay=1	
End Function
Function BasicDrawTile(Wrd)
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 5
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_DrawObjTile")
	Okay=1	
	
End Function
Function BasicSetFormPos()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 2
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetFormPos","SYB.FORM.SIZE.POS")
	Okay=1
End Function
Function BasicSetFormSize()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 2
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(120,"',' expected")
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetFormSize","SYB.FORM.SIZE.POS")
	Okay=1
End Function
Function BasicSetObjPos()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 2
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetObjPos","SYB.CONTROL.SETPOS")
	Okay=1
End Function
Function BasicSetObjGraphic()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 2
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetObjGraphic","SYB.CONTROL.SETGRAPHIC")
	Okay=1
End Function
Function BasicSetToolGraphic(Wrd)
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 2
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetToolGraphic")
	Okay=1
End Function
Function BasicSetPaintObjPen()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetPaintObjPen","SYB.CONTROL.PAINT.PEN.SET")
	Okay=1
End Function
Function BasicSetCtrLabelObjPen()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetCtrLabelObjPen","SYB.CONTROL.CTRLABEL.PEN.SET")
	Okay=1
End Function
Function BasicSetCtrLabelObjPaper()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetCtrLabelObjPaper","SYB.CONTROL.CTRLABEL.PAPER.SET")
	Okay=1
End Function
Function BasicSetObjWidth()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetObjWidth","SYB.CONTROL.SETWIDTH")
	Okay=1
End Function
Function BasicSetObjHeight()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetObjHeight","SYB.CONTROL.SETHEIGHT")
	Okay=1
End Function
Function BasicSetObjVisible()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_SetObjVisible","SYB.CONTROL.SETVISIBLE")
	Okay=1
End Function
Function BasicSetObjText()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,5)
	Next
	AddRoutine("SyB_SetObjText","SYB.CONTROL.TEXT.SET")
	Okay=1
End Function
Function BasicRefreshArea()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	For f=1 To 4
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			ErrMessage$="',' expected":Err=120
			Return
		EndIf
		Cod=Cod+1
		AddExpression(Cod,d,2)
	Next
	AddRoutine("SyB_RefreshArea","SYB.CONTROL.REFRESHAREA")
	Okay=1
End Function	
Function BasicRefreshObj()
	Cod=Cod+1
	d=CommandBracket()	
	AddExpression$(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	AddRoutine("SyB_Control_Refresh_2","SYB.CONTROL.REFRESH")
	Okay=1	
End Function
Function BasicRefreshTool()
	Cod=Cod+1
	d=CommandBracket()	
	AddExpression$(Cod,d,2)
	r$=Upper$(SepSort$(Cod))
	AddRoutine("SyB_ControlTool_Refresh_2","SYB.CONTROLTOOL.REFRESH")
	Okay=1	
End Function
Function BasicRefreshMenu()
	Cod=Cod+1
	d=CommandBracket()
	AddExpression(Cod,d,2)
	AddRoutine("SyB_RefreshMenu","SYB.FORM.REFRESH.PARTS")
	Okay=1
End Function	
Function BasicCallFunction(Wrd,q)
	StkItm=FuncParams(q)
	Cod=Cod+1
	d=CommandBracket()	
	For k=stkitm To 1 Step -1
		n=VarType(FuncParVar(q,k))
		n1=99
		If n=11 Then n1=2
		If n=13 Then n1=3
		If n=15 Then n1=5
		If n1=99 Then ErrMessage$="Function "+Func$(q)+" includes wrong data type":Err=120:Return
		AddExpression(Cod,d,n1)
		If Err>0 Then Return
		If k>1 Then
			r$=Upper$(SepSort$(Cod))
			If r$<>","Then
				ErrMessage$="',' expected":Err=120
				Return
			EndIf
			Cod=Cod+1			
		EndIf	
	Next
	r$=Upper$(SepSort$(Cod))
	If d>1 Then
		If r$<>")"Then ErrMessage$=r$+"Too many operands For "+Func$(q):Err=120:Return
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
	EndIf	
	If r$<>"" And r$<>":"Then ErrMessage$=r$+"Too many operands For "+Func$(q):Err=120:Return
	AddRoutine(Func$(q))
	Okay=1
	
	
	
;	StkItm=CalStackNo-Pos-1
;	c=
;	(g)
;	If StkItm<>FuncParams(c) Then Err=120:ErrMessage$="Incorrect number of Function parameters":Return
;	For k=StkItm To 1 Step-1
;		n=FuncParVar(c,k)
;		If n=1 Then n=2
;		n1=CalStack(k,0)
;					;RuntimeError(n+" "+n1)
;		If n>100000 Then n=n-100000
;		If n=2 And n1=3 Then
;			AddRoutine("SyB_Flo_2_Int_Stack_"+Str$(StkItm-k+1)):n1=n
;		EndIf
;		If n=3 And n1=2 Then
;			AddRoutine("SyB_Int_2_Flo_Stack_"+Str$(StkItm-k+1)):n1=n
;		EndIf
;		If n<>n1 Then Err=120:ErrMessage$="Type mismatch "+Str$(n)+" "+Str$(n1)+" "+Str$(k):Return
;	Next
;	AddRoutine(Func$(OpListRes(g)))
;	For j=CalStackNo-1 To g Step -1
;		DelCalStack()
;	Next
;	n=FuncType(OpListRes(g))
;	If n>10 Then n=n-10
;	AddCalStack(n)	
	
	
	
End Function
Function AddExpressionNew$(ChkWord,Bracketed=0,MustBe=0)
	
	Tok=1
	Operand=0
	OStack=0
	ItemsOnOp=0
	Wert=0
	While Tok<>0 And wert=0
		ANS$=SepSort$(ChkWord)
		If Upper$(ANS$)="THEN" Or ANS$="" Then 
			wert=-1
		Else
			wert=0
		EndIf	
		If wert=0 Then 
			ans2$=SepSort$(ChkWord+1)
			If ANS$="-" And ans2$="("Then ANS$="-(":ChkWord=ChkWord+1
			If ANS$="=" And ans2$="="Then ANS$="=":ChkWord=ChkWord+1
			If ANS$="=" And ans2$=">"Then ANS$=">=":ChkWord=ChkWord+1
			If ANS$="=" And ans2$="<"Then ANS$="<=":ChkWord=ChkWord+1
			If ANS$=">" And ans2$="="Then ANS$=">=":ChkWord=ChkWord+1
			If ANS$="<" And ans2$="="Then ANS$="<=":ChkWord=ChkWord+1
			If ANS$="<" And ans2$=">"Then ANS$="<>":ChkWord=ChkWord+1
			If ANS$="!" And ans2$="="Then ANS$="<>":ChkWord=ChkWord+1
			If ANS$="&" And ans2$="&"Then ANS$="AND":ChkWord=ChkWord+1
			If ANS$="|" And ans2$="|"Then ANS$="OR":ChkWord=ChkWord+1
			Tok=0
			Prec=0
			If Operand=1 Then
				If Tok=0 And ANS$=","Then
					s=0
					Tok=49
					wert=2
					For f=OStackNo To 1 Step -1
						If OStackTok(f)>30 And OStackTok(f)<60 Then
							OStackPos(f)=OStackPos(f)+1
							f=-1
							wert=0
						Else
							s=1
							OpListRes#(ItemsOnOp)=0
							OpListStr$(ItemsOnOp)=OStackStr$(f)
							OpListTok(ItemsOnOp)=OStackTok(f)
							ItemsOnOp=ItemsOnOp+1
							OStackNo=OStackNo-1
						EndIf
					Next
					operand=0
				EndIf
				
				If Tok=0 And ANS$=")" Then
					Tok=58
					wert=1
					s=0
					For f=OStackNo To 1 Step -1
						If OStackTok(f)>30 And OStackTok(f)<60 Then
							If OStackTok(f)<59 Then					;**** Neg
								OStackPos(f)=OStackPos(f)+1
								OpListRes#(ItemsOnOp)=0
								OpListStr$(ItemsOnOp)=OStackStr$(f)+"["+Trim(Str$(OStackPos(f)))+"]"
								OpListTok(ItemsOnOp)=OStackTok(f)							
								ItemsOnOp=ItemsOnOp+1
							EndIf
							f=-1
							wert=0
							OStackNo=OStackNo-1
						Else
							s=1
							OpListRes#(ItemsOnOp)=0
							OpListStr$(ItemsOnOp)=OStackStr$(f)
							OpListTok(ItemsOnOp)=OStackTok(f)
							ItemsOnOp=ItemsOnOp+1
							OStackNo=OStackNo-1
						EndIf
					Next
					operand=1
				EndIf
				If Tok=0 And ANS$="-"Then Prec=4:Tok=60:Operand=0
				If Tok=0 And ANS$="+"Then Prec=4:Tok=61:Operand=0
				If Tok=0 And ANS$="/"Then Prec=3:Tok=62:Operand=0
				If Tok=0 And ANS$="*"Then Prec=3:Tok=63:Operand=0
				If Tok=0 And Upper$(ANS$)="AND"Then Prec=11:Tok=64:Operand=0
				If Tok=0 And Upper$(ANS$)="OR"Then Prec=12:Tok=65:Operand=0
				If Tok=0 And Upper$(ANS$)="XOR"Then Prec=12:Tok=66:Operand=0
				If Tok=0 And ANS$="="Then Prec=7:Tok=67:Operand=0
				If Tok=0 And ANS$=">="Then Prec=6:Tok=68:Operand=0
				If Tok=0 And ANS$="<="Then Prec=6:Tok=69:Operand=0
				If Tok=0 And ANS$="<>"Then Prec=7:Tok=70:Operand=0
				If Tok=0 And ANS$="<"Then Prec=6:Tok=71:Operand=0
				If Tok=0 And ANS$=">"Then Prec=6:Tok=72:Operand=0
				If Tok=0 And Upper$(ANS$)="MOD" Then Prec=3:Tok=73:Operand=0
			Else
			;**** Stacked PreOps
				If Tok=0 And ANS$="-("Then
					Tok=55
					OStackNo=OStackNo+1
					OStackTok(OStackNo)=Tok
					OStackPrec(OStackNo)=1
					OStackStr$(OStackNo)="NEG"
					OStackPos(OStackNo)=0
				EndIf
				If Tok=0 And ANS$="("Then
					Tok=59
					OStackNo=OStackNo+1
					OStackTok(OStackNo)=Tok
					OStackPrec(OStackNo)=1
					OStackStr$(OStackNo)=ANS$
					OStackPos(OStackNo)=0
				EndIf
			;****
				DoNeg=0
				If Tok=0 And ANS$="-"Then ;**** Check If Negative
					DoNeg=1
					ANS$=ans2$
					ans2$=SepSort$(ChkWord+1)
					ChkWord=ChkWord+1
				EndIf
				If Tok=0 Then 		;***** Check If Number
					Res#=IsNumber#(ANS$)
					If Succeed=True Then
						If ResultInt=0 Then
							Tok=1
							OpListRes#(ItemsOnOp)=Int(Res#)
							OpListStr$(ItemsOnOp)=OpListRes#(ItemsOnOp)
							OpListTok(ItemsOnOp)=Tok
							ItemsOnOp=ItemsOnOp+1
							If DoNeg=1 Then 
								OpListRes#(ItemsOnOp)=0
								OpListStr$(ItemsOnOp)="NEG"
								OpListTok(ItemsOnOp)=55
								ItemsOnOp=ItemsOnOp+1
							EndIf	
							Operand=1:CanNeg=1
						EndIf
					EndIf
				EndIf
				If Tok=0 Then		;***** Check if Variable
					Res=Int(IsVariable#(ANS$))
					If Succeed=True Then
						a=CheckVarPost(Res,VarType(Res))
						If a=0 Then Return
						If VarType(Res)=>11 And VarType(Res)<=19 Then 
							Tok=VarType(Res)
							OpListRes#(ItemsOnOp)=Res
							OpListStr$(ItemsOnOp)=VarName(Res)
							OpListTok(ItemsOnOp)=Tok
							ItemsOnOp=ItemsOnOp+1
							If DoNeg=1 Then 
								OpListRes#(ItemsOnOp)=0
								OpListStr$(ItemsOnOp)="NEG"
								OpListTok(ItemsOnOp)=55
								ItemsOnOp=ItemsOnOp+1
							EndIf
							Operand=1:CanNeg=1
						EndIf
						If VarType(Res)=>31 And VarType(Res)<=45 Then
							If ans2$<>"("Then wert=17
							ChkWord=ChkWord+1
							Tok=VarType(Res)
							OStackNo=OStackNo+1
							OStackTok(OStackNo)=Tok
							OStackPrec(OStackNo)=1
							OStackStr$(OStackNo)=VarName(Res)
							OStackPos(OStackNo)=0
						EndIf	
					EndIf
				EndIf
			EndIf
			If Prec>0 And wert=0 Then
				If OStackNo>0 Then
					If Prec=>OStackPrec(OStackNo) Then
						For f=OStackNo To 1 Step -1
							If OStackPrec(f)=1 Then 
								f=1
							Else	
								If Prec=>OStackPrec(f) Then
									OpListRes#(ItemsOnOp)=0
									OpListStr$(ItemsOnOp)=OStackStr$(f)
									OpListTok(ItemsOnOp)=OStackTok(f)
									ItemsOnOp=ItemsOnOp+1
									OStackNo=OStackNo-1
								Else
									f=1
								EndIf
							EndIf
						Next
					EndIf
				EndIf
				OStackNo=OStackNo+1
				OStackTok(OStackNo)=Tok
				OStackPrec(OStackNo)=Prec
				
				OStackStr$(OStackNo)=ANS$
			EndIf
			ChkWord=ChkWord+1
		EndIf
	Wend
	
	If tok=0 Or wert>0 Then
		BigStr$="Failed"
	Else
		For f=OStackNo To 1 Step -1
			OpListRes#(ItemsOnOp)=0
			OpListStr$(ItemsOnOp)=OStackStr$(f)
			OpListTok(ItemsOnOp)=OStackTok(f)
			ItemsOnOp=ItemsOnOp+1
			OStackNo=OStackNo-1
		Next
		BigStr$=""
		For f=0 To ItemsOnOp-1
			BigStr$=BigStr$+OpListStr(f)+"("+OpListTok(f)+") / "
		Next
		
	EndIf
	CopyToClipboardText(BigStr$)
	Stop
	
End Function
Function AddExpressionQ$(ChkWord,Bracketed=0,MustBe=0)
	cabbage=0
	cabbage2=0
	BigStr$=""
	ExprNo=0
	Pae=0
	Finished=0
	operand=0
	ItemsOnOp=0
	OStackNo=0
	While Finished=0
		ANS$=SepSort$(ChkWord)
		ans2$=SepSort$(ChkWord+1)
		If ANS$=""And Pae>0 Then
			Err=109
			ErrMessage$="')' expected"
			Return
		EndIf
		If (Upper$(ANS$)="THEN" Or Upper$(ANS$)=Terminator$ Or ANS$=":" Or ANS$=";" Or (ANS$="," And Bracketed<>1) Or ANS$="")And Pae=0 Then Cod=ChkWord:Finished=1
		;**** This is for when I need to do define arrays r(x,x,x)= so the process stops before the = 
		If ANS$=")" And Bracketed>0 And Pae=0 Then Cod=ChkWord:Finished=1
		If Finished=0 Then
			If ANS$="-" And ans2$="("Then ANS$="-(":ChkWord=ChkWord+1
			If ANS$="=" And ans2$="="Then ANS$="=":ChkWord=ChkWord+1
			If ANS$="=" And ans2$=">"Then ANS$=">=":ChkWord=ChkWord+1
			If ANS$="=" And ans2$="<"Then ANS$="<=":ChkWord=ChkWord+1
			If ANS$=">" And ans2$="="Then ANS$=">=":ChkWord=ChkWord+1
			If ANS$="<" And ans2$="="Then ANS$="<=":ChkWord=ChkWord+1
			If ANS$="<" And ans2$=">"Then ANS$="<>":ChkWord=ChkWord+1
			If ANS$="!" And ans2$="="Then ANS$="<>":ChkWord=ChkWord+1
			If ANS$="&" And ans2$="&"Then ANS$="AND":ChkWord=ChkWord+1
			If ANS$="|" And ans2$="|"Then ANS$="OR":ChkWord=ChkWord+1
			If ANS$="("Then Pae=Pae+1
			If ANS$=")"Then
				Pae=Pae-1
				If Pae<0 Then
					Err=110
					ErrMessage$="Unexpected ')'"
					Return
				EndIf
			EndIf
			If operand=1 Then
				operand=0
				Prec=0
				If ANS$="-"Then Prec=3:Tok=60:CanNeg=1
				If ANS$="+"Then Prec=3:Tok=61:CanNeg=1
				If ANS$="/"Then Prec=2:Tok=62:CanNeg=1
				If ANS$="*"Then Prec=2:Tok=63:CanNeg=1
				If Upper$(ANS$)="AND"Then Prec=5:Tok=64:CanNeg=1
				If Upper$(ANS$)="OR"Then Prec=5:Tok=65:CanNeg=1
				If Upper$(ANS$)="XOR"Then Prec=5:Tok=66:CanNeg=1
				If ANS$="="Then Prec=4:Tok=67:CanNeg=1
				If ANS$=">="Then Prec=4:Tok=68:CanNeg=1
				If ANS$="<="Then Prec=4:Tok=69:CanNeg=1
				If ANS$="<>"Then Prec=4:Tok=70:CanNeg=1
				If ANS$="<"Then Prec=4:Tok=71:CanNeg=1
				If ANS$=">"Then Prec=4:Tok=72:CanNeg=1		
				If Upper$(ANS$)="MOD" Then Prec=4:Tok=73:CanNeg=1
				If Upper$(ANS$)="SHR" Then Prec=4:Tok=74:CanNeg=1
				If Upper$(ANS$)="SHL" Then Prec=4:Tok=75:CanNeg=1
				
				If ANS$=","Then
					For f=OStackNo To 1 Step -1
						If OStackTok(f)<255 Then
							OpListRes#(ItemsOnOp)=0
							OpListStr$(ItemsOnOp)=OStackStr$(f)
							OpListTok(ItemsOnOp)=OStackTok(f)
							OStackNo=OStackNo-1
							ItemsOnOp=ItemsOnOp+1
						Else
							OStackNo=f
							f=1
						EndIf
					Next
					Goto SkipThis
				EndIf					
				
				If ANS$=")"Then
					For f=OStackNo To 1 Step -1
						If OStackTok(f)=255 Then
							If (OStackStr$(f)="(" Or OStackStr$(f)=",") Then
								OStackNo=f-1
								f=1
							Else
								OpListRes#(ItemsOnOp)=0
								OpListStr$(ItemsOnOp)=OStackStr$(f)
								OpListTok(ItemsOnOp)=OStackTok(f)
								OStackNo=f-1
								ItemsOnOp=ItemsOnOp+1
								f=1
							EndIf
						Else
							OpListRes#(ItemsOnOp)=0
							OpListStr$(ItemsOnOp)=OStackStr$(f)
							OpListTok(ItemsOnOp)=OStackTok(f)
							OStackNo=OStackNo-1
							ItemsOnOp=ItemsOnOp+1
						EndIf
					Next
					operand=1
					Goto SkipThis
				EndIf				
				
				If Prec>0 Then
					If OStackNo>0 Then
						If Prec=>OStackPrec(OStackNo) Then
							For f=OStackNo To 1 Step -1
								If OStackPrec(f)=1 Then 
									f=1
								Else	
									If Prec=>OStackPrec(f) Then
										OpListRes#(ItemsOnOp)=0
										OpListStr$(ItemsOnOp)=OStackStr$(f)
										OpListTok(ItemsOnOp)=OStackTok(f)
										ItemsOnOp=ItemsOnOp+1
										OStackNo=OStackNo-1
									Else
										f=1
									EndIf
								EndIf
							Next
						EndIf
					EndIf
					OStackNo=OStackNo+1
					OStackTok(OStackNo)=Tok
					OStackPrec(OStackNo)=Prec
					OStackStr$(OStackNo)=ANS$
				Else
					hghg$=ANS$
					Stop
				EndIf
			Else
				SoNegThis=0
				If ANS$="-"Then
					ChkWord=ChkWord+1
					ANS$=SepSort$(ChkWord)
					SoNegThis=1
				EndIf
				If ANS$="("Then
					Pae=Pae+1
					OStackNo=OStackNo+1
					OStackTok(OStackNo)=255
					OStackPrec(OStackNo)=1
					OStackStr$(OStackNo)="("
					;OStackPos(OStackNo)=Pae
					Goto SkipThis
				EndIf
				
				;If ANS$="+"Then Goto SkipThis
				;If ANS$="-"Then
				;	OpListRes#(ItemsOnOp)=0
				;	OpListStr$(ItemsOnOp)="NEG"
				;	OpListTok(ItemsOnOp)=19				;NEG THIS
				;	ItemsOnOp=ItemsOnOp+1
				;	Goto SkipThis
				;EndIf
				
				;**** Check if its a Function
				;For f=1 To ItemNumbers
				;	If Lower$(ANS$)=Lower$(ItemName$(f)) And ItemType$(f)="function" Then
				;		perhaps=0
				;		If ItemOutput$(f)="%"Then perhaps=1
				;		If ItemOutput$(f)="#"Then perhaps=3
				;		If ItemOutput$(f)="$"Then perhaps=5
				;		If ans2$="%" Then
				;			If perhaps<>1 Then
				;				Err=109
				;				ErrMessage$="'%' expected"
				;				Return
				;			Else
				;				ChkWord=ChkWord+1
				;			EndIf
				;		EndIf
				;		If ans2$="#" Then
				;			If perhaps<>3 Then
				;				Err=109
				;				ErrMessage$="'#' expected"
				;				Return
				;			Else
				;				ChkWord=ChkWord+1
				;			EndIf
				;		EndIf
				;		If ans2$="$" Then
				;			If perhaps<>5 Then
				;				Err=109
				;				ErrMessage$="'$' expected"
				;				Return
				;			Else
				;				ChkWord=ChkWord+1
				;			EndIf
				;		EndIf
				;		ChkWord=ChkWord+1
				;		ANS$=SepSort$(ChkWord)
				;		If ItemInput$(f)>"" Then 
				;			If ANS$<>"("Then
				;				Err=109
				;				ErrMessage$="'(' expected"
				;				Return
				;			EndIf
				;			Pae=Pae+1
				;			OStackNo=OStackNo+1
				;			OStackTok(OStackNo)=8000+f
				;			OStackPrec(OStackNo)=1
				;			OStackStr$(OStackNo)=ItemRoutine$(f)
				;		Else
				;			If ANS$="(" Then
				;				ChkWord=ChkWord+1
				;				ANS$=SepSort$(ChkWord)
				;				If ANS$<>")"Then Err=109:ErrMessage="')' expected":Return
				;			Else
				;				ChkWord=ChkWord-1
				;			EndIf
				;			OpListRes#(ItemsOnOp)=0
				;			OpListStr$(ItemsOnOp)=ItemInput$(f)
				;			OpListTok(ItemsOnOp)=8000+f
				;			ItemsOnOp=ItemsOnOp+1
				;			operand=1
				;		EndIf		
				;		Goto SkipThis
				;	EndIf
				;Next
				;**** Check if Direct String ****
				;If Mid$(Expr$(f),1,1)=Chr$(34)Then
				;	CanNeg=0
				;	OpListRes#(ItemsOnOp)=0
				;	OpListStr$(ItemsOnOp)=Expr$(f)
				;	OpListTok(ItemsOnOp)=5				;String Token
				;	ItemsOnOp=ItemsOnOp+1
				;	Goto SkipThis
				;EndIf
				;;**** Check if its a Function
				;Res#=IsFunction#(Expr$(f))
				;If Succeed=True Then
				;	;**** Float Functions
				;	If Res#=>8000 And Res#<8300 Then
				;		OpListRes#(ItemsOnOp)=Res#
				;		OpListStr$(ItemsOnOp)=Expr$(f)
				;		OpListTok(ItemsOnOp)=7				;Function Token	
				;		ItemsOnOp=ItemsOnOp+1
				;		Goto SkipThis
				;	EndIf
				;EndIf				;**** Check if its a Function
				;Res#=IsFunction#(Expr$(f))
				;If Succeed=True Then
				;	;**** Float Functions
				;	If Res#=>8000 And Res#<8100 Then
				;		a=CheckVarPost(f,13)
				;		If a=0 Then Return
				;		OpListRes#(ItemsOnOp)=Res#
				;		OpListStr$(ItemsOnOp)=Expr$(f)
				;		OpListTok(ItemsOnOp)=7				;Function Token	
				;		ItemsOnOp=ItemsOnOp+1
				;		IsFunc=1
				;		Goto GandiMan
				;	EndIf	
				;	;**** Integer Function	
				;	If Res#=>8100 And Res#<8200 Then
				;		a=CheckVarPost(f,12)
				;		If a=0 Then Return
				;		OpListRes#(ItemsOnOp)=Res#
				;		OpListStr$(ItemsOnOp)=Expr$(f)
				;		OpListTok(ItemsOnOp)=7				;Function Token	
				;		ItemsOnOp=ItemsOnOp+1
				;		IsFunc=1
				;		Goto GandiMan	
				;	EndIf
				;	;**** String Function	
				;	If Res#=>8200 And Res#<8300 Then
				;		a=CheckVarPost(f,15)
				;		If a=0 Then Return
				;		OpListRes#(ItemsOnOp)=Res#
				;		OpListStr$(ItemsOnOp)=Expr$(f)
				;		OpListTok(ItemsOnOp)=7				;Function Token	
				;		ItemsOnOp=ItemsOnOp+1
				;		IsFunc=1
				;		Goto GandiMan	
				;	EndIf
				;	;**** User Functions
				;	CanNeg=0
				;	hi=FuncType(Res)
				;	If hi=1 Or hi=11 Then Err=120:ErrMessage$="Cannot use Function without output":Return
				;	If hi<10 Then hi=hi+10
				;	a=CheckVarPost(f,hi)
				;	If a=0 Then Return
				;	OpListRes#(ItemsOnOp)=Res#
				;	OpListStr$(ItemsOnOp)=Expr$(f)
				;	OpListTok(ItemsOnOp)=9				;Function Token
				;	ItemsOnOp=ItemsOnOp+1
				;	IsFunc=1
				;	Goto GandiMan
				;EndIf		
				;***** Check if Number
				
				Res#=IsNumber#(ANS$)
				If Succeed=True Then
					CanNeg=0
					Operand=1
					If ResultInt=0 Then
						If SoNegThis=1 Then 
							OpListRes#(ItemsOnOp)=-Int(Res#)
						Else
							OpListRes#(ItemsOnOp)=Int(Res#)
						EndIf	
						OpListStr$(ItemsOnOp)=OpListRes#(ItemsOnOp)
						OpListTok(ItemsOnOp)=1				;16 Bit Integer Token
						ItemsOnOp=ItemsOnOp+1
						Goto SkipThis
					Else
						If SoNegThis=1 Then
							OpListRes#(ItemsOnOp)=-Res#
						Else
							OpListRes#(ItemsOnOp)=Res#
						EndIf	
						OpListStr$(ItemsOnOp)=OpListRes#(ItemsOnOp)
						OpListTok(ItemsOnOp)=3				;16 Bit Integer Token
						ItemsOnOp=ItemsOnOp+1
						Goto SkipThis
					EndIf
				EndIf
				If ANS$="-("Then
					OStackNo=OStackNo+1
					OStackTok(OStackNo)=1000+19
					If SoNegThis=1 Then OStackTok(OStackNo)=OStackTok(OStackNo)+50000
					OStackPrec(OStackNo)=1
					OStackStr$(OStackNo)=ANS$
					operand=0
					Goto SkipThis
				EndIf	
				
				;***** Check if Variable
				Res=Int(IsVariable#(ANS$))
				If Succeed=True Then
					CanNeg=0
					operand=1
					a=CheckVarPost(f,VarType(Res))
					If a=0 Then Return
					If VarType(Res)=>11 And VarType(Res)<=19 Then 			;*** 16 Bit Int
						OpListRes#(ItemsOnOp)=Res
						OpListStr$(ItemsOnOp)=VarName(Res)
						OpListTok(ItemsOnOp)=VarType(Res)
						ItemsOnOp=ItemsOnOp+1
						If SoNegThis=1 Then
							OpListRes#(ItemsOnOp)=0
							OpListStr$(ItemsOnOp)="NEG"
							OpListTok(ItemsOnOp)=19
							ItemsOnOp=ItemsOnOp+1
						EndIf
						Goto SkipThis
					EndIf
					If VarType(res)>=31 And VarType(Res)<=45 Then
						
						;perhaps=0
						;If ItemOutput$(f)="%"Then perhaps=1
						;If ItemOutput$(f)="#"Then perhaps=3
						;If ItemOutput$(f)="$"Then perhaps=5
						;If ans2$="%" Then
						;	If perhaps<>1 Then
						;		Err=109
						;		ErrMessage$="'%' expected"
						;		Return
						;	Else
						;		ChkWord=ChkWord+1
						;	EndIf
						;EndIf
						;If ans2$="#" Then
						;	If perhaps<>3 Then
						;		Err=109
						;		ErrMessage$="'#' expected"
						;		Return
						;	Else
						;		ChkWord=ChkWord+1
						;	EndIf
						;EndIf
						;If ans2$="$" Then
						;	If perhaps<>5 Then
						;		Err=109
						;		ErrMessage$="'$' expected"
						;		Return
						;	Else
						;		ChkWord=ChkWord+1
						;	EndIf
						;EndIf
						ChkWord=ChkWord+1
						ANS$=SepSort$(ChkWord)
						If ANS$<>"("Then
							Err=109
							ErrMessage$="'(' expected"
							Return
						EndIf
						OpListRes#(ItemsOnOp)=0
						OpListStr$(ItemsOnOp)="ClBr"
						OpListTok(ItemsOnOp)=8
						ItemsOnOp=ItemsOnOp+1
						
						Pae=Pae+1
						OStackNo=OStackNo+1
						OStackTok(OStackNo)=1000+VarType(res)
						If SoNegThis=1 Then OStackTok(OStackNo)=OStackTok(OStackNo)+50000
						OStackPrec(OStackNo)=1
						OStackStr$(OStackNo)=VarName(res)
						operand=0
						Goto SkipThis
					EndIf
				EndIf
			EndIf	
			.SkipThis
			ChkWord=ChkWord+1
		EndIf
	Wend	
	For f=OStackNo To 1 Step -1
		OpListRes#(ItemsOnOp)=0
		OpListStr$(ItemsOnOp)=OStackStr$(f)
		OpListTok(ItemsOnOp)=OStackTok(f)
		ItemsOnOp=ItemsOnOp+1
		OStackNo=OStackNo-1
	Next
	
	
;***** Fist Pass To Add Negs to Lists
	f=0
	While f<=ItemsOnOp
		If OpListTok(f)>50000 Then
			OpListTok(f)=OpListTok(f)-50000
			For g=ItemsOnOp To f Step -1
				OpListRes#(g+1)=OpListRes#(g)
				OpListStr$(g+1)=OpListStr$(g)
				OpListTok(g+1)=OpListTok(g)
			Next
			ItemsOnOp=ItemsOnOp+1
			OpListRes#(f+1)=0
			OpListTok(f+1)=19
			OpListStr$(f+1)="NEG"
		EndIf
		f=f+1
	Wend
	
	
	
	BigStr$=""
	For f=0 To ItemsOnOp-1
		BigStr$=BigStr$+OpListStr(f)+"("+OpListTok(f)+") / "
	Next	
	CopyToClipboardText(BigStr$)
	Stop
	
;********************************************
;***** Here we process the RVP math statement
;********************************************
	SimpleExpression=0
	OldPc=PC
	CalStackNo=0
	bow$=""
	IsNeg=0
	For f=0 To ItemsOnOp-1
		;**** Check For Array Variable
		
		
		If OpListTok(f)=8 Then
			AddCalStack(8)
		EndIf	
		
		If OpListTok(f)=1031 Then		;**** This is Integer Variable
			a1=GetStacktoBrack()
			If a1<>1 Then ErrMessage$="Wrong number of entries for array":Err=120:Return
			If CalStack(CalStackNo-1,0)<>2 Then ErrMessage$="Integer expected for array":Err=120:Return
			DelCalStack()
			DelCalStack()
			AddCalStack(2)
		EndIf
		
		
		;;**** Check For Array Variable
		;If OpListTok(f)=31 Or OpListTok(f)=33 Or OpListTok(f)=35  Then		;**** This is Integer Variable
		;	AddCalStack(8,OpListRes(f))
		;	SimpleExpression=1
		;EndIf
		;**** Check For Double Array Variable
		If OpListTok(f)=41 Or OpListTok(f)=43 Or OpListTok(f)=45 Then		;**** This is Integer Variable
			AddCalStack(8,OpListRes(f))
			SimpleExpression=1
		EndIf		
		;**** Check For Function
		If OpListTok(f)=9 Then		;**** This is Function
			AddCalStack(9,OpListRes(f))
			SimpleExpression=1
		EndIf
		;**** Check For Basic Function
		If OpListTok(f)=7 Then		;**** This is Function
			AddCalStack(7,OpListRes(f))
			SimpleExpression=1
		EndIf
		;**** Gets a Integer Number
		If OpListTok(f)=1 Or OpListTok(f)=2 Then 
			AddRoutine("SyB_Push_N_Int","SYB.PUSH.N.INT")
			AddCalStack(2)
			AddIntNumber(OpListRes#(f),IsNeg)
		EndIf
		;**** Gets an Equate Integer Number
		If OpListTok(f)=89 Then 
			AddRoutine("SyB_Push_N_Int","SYB.PUSH.N.INT")
			AddCalStack(2)
			AddVariable(f)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Int")
		EndIf
		;**** Gets a Integer Variable
		If OpListTok(f)=11 Or OpListTok(f)=12 Then 
			PokeByte MemBank,PC,42:PC=PC+1			;**** #2A  -  LD HL,(addr)
			PokeShort MemBank,PC,GetRoutineLocation(VarName$(OpListRes#(f))):PC=PC+2
			AddRoutine("SyB_Push_V_Int_Direct","SYB.PUSH.V.INT.DIRECT")
			AddCalStack(2)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Int") 
		EndIf
		;**** Gets a Byte Variable
		If OpListTok(f)=14 Then
			PokeByte MemBank,PC,58:PC=PC+1			;**** #3A  -  Ld HL,(addr)
			PokeShort MemBank,PC,GetRoutineLocation(VarName$(OpListRes#(f))):PC=PC+2
			AddRoutine("SyB_Push_V_Byt_Direct","SYB.PUSH.V.BYTE.DIRECT")
			AddCalStack(2)
			;AddVariable(f)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Int") 
		EndIf	
		;**** Gets a Float Number
		If OpListTok(f)=3 Then 		
			AddRoutine("SyB_Push_N_Flo")
			AddCalStack(3)
			AddFloNumber(OpListRes#(f),IsNeg)
			SimpleExpression=1
		EndIf	
		;**** Get a Float Variable
		If OpListTok(f)=13 Then
			AddRoutine("SyB_Push_V_Flo")
			AddCalStack(3)
			AddVariable(f)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Flo")
			SimpleExpression=1
		EndIf
		;**** Gets a String 
		If OpListTok(f)=5 Then 
			AddRoutine("SyB_Push_N_Str")
			AddCalStack(5)
			AddString(OpListStr$(f))
			SimpleExpression=1
		EndIf		
		;**** Gets a String Variable
		If OpListTok(f)=15 Then 
			AddRoutine("SyB_Push_V_Str","SYB.PUSH.V.STR")
			AddCalStack(5)
			AddVariable(f)
			SimpleExpression=1
		EndIf
		
		;**** Functions Doing
		If OpListTok(f)=50 Then
			a=-1
			For g=CalStackNo To 0 Step -1
				n=CalStack(g,0)
				If n=9 Then a=3:Exit
				If n=8 Then a=1:Exit
				If n=7 Then a=2:Exit
			Next
			;**** System Functions
			If a=2 Then CheckSystemFunction(g)
			If a=1 Then CheckArrays(g)
			If a=3 Then CheckUserFunction(g)
			SimpleExpression=1
		EndIf
		
		;**** Operands
		
		If OpListTok(f)=>60 And OpListTok(f)<74 Then
			a1=CalStack(CalStackNo-1,0)
			a2=CalStack(CalStackNo-2,0)
			DelCalStack()
			DelCalStack()
			n=0
			If a1=2 And a2=2 Then n=2
			If a1=3 Or a2=3 Then n=3
			If a1=5 And a2=5 Then n=5
			If n=2 Then
				If OpListTok(f)=60 Then AddRoutine("SyB_INT_Sub","SYB.MATH.SUB.INT"):AddCalStack(2)
				If OpListTok(f)=61 Then AddRoutine("SyB_INT_Add","SYB.MATH.ADD.INT"):AddCalStack(2)
				If OpListTok(f)=62 Then AddRoutine("SyB_INT_Div","SYB.MATH.DIVIDE.INT"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=63 Then AddRoutine("SyB_INT_Mul","SYB.MATH.MULT.INT"):AddCalStack(2)
				
				If OpListTok(f)=64 Then AddRoutine("SyB_INT_And","SYB.MATH.AND"):AddCalStack(2)
				If OpListTok(f)=65 Then AddRoutine("SyB_INT_Or","SYB.MATH.OR"):AddCalStack(2)
				If OpListTok(f)=66 Then AddRoutine("SyB_INT_Xor","SYB.MATH.XOR"):AddCalStack(2)
				If OpListTok(f)=73 Then AddRoutine("SyB_INT_Mod","SYB.MATH.MOD"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=74 Then AddRoutine("SyB_INT_Shr"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=75 Then AddRoutine("SyB_INT_Shl"):AddCalStack(2):SimpleExpression=1
				
				If OpListTok(f)=67 Then AddRoutine("SyB_INT_EQ","SYB.MATH.EQUAL.INT"):AddCalStack(2)
				If OpListTok(f)=68 Then AddRoutine("SyB_INT_GTE","SYB.MATH.GTEQUAL.INT"):AddCalStack(2)
				If OpListTok(f)=69 Then AddRoutine("SyB_INT_LTE","SYB.MATH.LTEQUAL.INT"):AddCalStack(2)		
				If OpListTok(f)=70 Then AddRoutine("SyB_INT_OT","SYB.MATH.OTHERTHAN.INT"):AddCalStack(2):SimpleExpression=1				
				If OpListTok(f)=71 Then AddRoutine("SyB_INT_LT","SYB.MATH.LESSERTHAN.INT"):AddCalStack(2):SimpleExpression=1				
				If OpListTok(f)=72 Then AddRoutine("SyB_INT_GT","SYB.MATH.GREATERTHAN.INT"):AddCalStack(2):SimpleExpression=1
			EndIf
			If n=3 Then
				SimpleExpression=1
				a8=OpListTok(f)
				If (a8>=60 And a8<=63) Or (a8>=67 And a8<=72) Then
					If a2=2 Then AddRoutine("SyB_INT_2_FLO_Stack_2","SYB.INT.2.FLOAT.STACK")
					If a1=2 Then AddRoutine("SyB_INT_2_FLO","SYB.INT.2.FLOAT.STACK")			
				EndIf
				If (a8>=64 And a8<=66) Or a8=73 Then
					If a2=3 Then AddRoutine("SyB_FLO_2_INT_Stack_2","SYB.FLOAT.2.INT.STACK")
					If a1=3 Then AddRoutine("SyB_FLO_2_INT_Stack_1","SYB.FLOAT.2.INT.STACK")			
				EndIf
				If OpListTok(f)=60 Then AddRoutine("SyB_FLO_Sub","SYB.MATH.SUB.FLOAT"):AddCalStack(3)
				If OpListTok(f)=61 Then AddRoutine("SyB_FLO_Add","SYB.MATH.ADD.FLOAT"):AddCalStack(3)
				If OpListTok(f)=62 Then AddRoutine("SyB_FLO_Div","SYB.MATH.DIVIDE.FLOAT"):AddCalStack(3)
				If OpListTok(f)=63 Then AddRoutine("SyB_FLO_Mul","SYB.MATH.MULTIPLY.FLOAT"):AddCalStack(3)
				
				If OpListTok(f)=64 Then AddRoutine("SyB_INT_And","SYB.MATH.And"):AddCalStack(2)	;Int Inputs
				If OpListTok(f)=65 Then AddRoutine("SyB_INT_Or"):AddCalStack(2)		;Int Inputs
				If OpListTok(f)=66 Then AddRoutine("SyB_INT_Xor","SYB.MATH.XOR"):AddCalStack(2)	;Int Inputs
				If OpListTok(f)=73 Then AddRoutine("SyB_INT_Mod","SYB.MATH.MOD"):AddCalStack(2)	;Int Inputs
				
				If OpListTok(f)=67 Then AddRoutine("SyB_FLO_EQ","SYB.MATH.EQUAL.FLOAT"):AddCalStack(2)
				If OpListTok(f)=68 Then AddRoutine("SyB_FLO_GTE","SYB.MATH.GTEQUAL.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=69 Then AddRoutine("SyB_FLO_LTE","SYB.MATH.GTEQUAL.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=70 Then AddRoutine("SyB_FLO_OT","SYB.MATH.OT.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=71 Then AddRoutine("SyB_FLO_LT","SYB.MATH.LT.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=72 Then AddRoutine("SyB_FLO_GT","SYB.MATH.GT.FLOAT"):AddCalStack(2)
			EndIf
			If n=5 Then
				SimpleExpression=1
				If OpListTok(f)=61 Then AddRoutine("SyB_STR_Add","SYB.STR.ADD"):AddCalStack(5)
				If OpListTok(f)=60 Or OpListTok(f)=62 Or OpListTok(f)=63 Or OpListTok(f)=62 Then
					ErrMessage$="Operator cannot be applied to Strings"
					Err=121
				EndIf
				If OpListTok(f)=64 Or OpListTok(f)=65 Or OpListTok(f)=66 Then
					ErrMessage$="Operator cannot be applied to Strings"
					Err=121
				EndIf
				If OpListTok(f)=67 Then AddRoutine("SyB2_STR_EQ"):AddCalStack(2)
				If OpListTok(f)=68 Then AddRoutine("SyB2_STR_GTE"):AddCalStack(2)				
				If OpListTok(f)=69 Then AddRoutine("SyB2_STR_LTE"):AddCalStack(2)
				If OpListTok(f)=70 Then AddRoutine("SyB2_STR_OT"):AddCalStack(2)
				If OpListTok(f)=71 Then AddRoutine("SyB2_STR_LT"):AddCalStack(2)
				If OpListTok(f)=72 Then AddRoutine("SyB2_STR_GT"):AddCalStack(2)
			EndIf	
		EndIf	
		IsNeg=0
		If OpListTok(f)=74 Then IsNeg=1
		bow$=bow$+OpListStr$(f)+" "
		;If CalStackNo>2 Then SimpleExpression=1
	Next
	;CpRun=CpRun+1:ComR$(CpRun Mod 50)=bw$:CompileRundown()
	
	;**** Finished So Just Check output Valid / Balanced
	If CalStackNo<>1 Then
		;RuntimeError(CalStackNo+" "+MustBe)
		If Err=0 Then ErrMessage$="Error in expression"
		Err=120
	Else
		If MustBe>0 Then
			a1=CalStack(CalStackNo-1,0)
			If MustBe=5 And a1<>5 Then
				ErrMessage$="Expecting String "+a1
				Err=120
			EndIf				
			If (MustBe=2 Or MustBe=3) And a1=5 Then
				ErrMessage$="Expecting value not String"
				Err=120
			EndIf
			If MustBe=2 And a1=3 Then
				AddRoutine("SyB_Flo_2_Int_Stack_1")
			EndIf
			If MustBe=3 And a1=2 Then
				AddRoutine("SyB_Int_2_Flo")
			EndIf
		EndIf
	EndIf
	If SimpleExpression=0 Then
		IsNeg=0
		PC=OldPc
		RegDE=0
		StackCount=0
		If ItemsOnOp>0 Then
			RegHL=0
		Else
			RegHL=1
		EndIf	
		
		For f=0 To ItemsOnOp-1
			
			;**** Single Integer array
			If OpListTok(f)=1031 Then
				wcf=GetRoutineLocation(OpListStr(f))
				If RegHL=1 And RegDE=1 Then
					PokeByte MemBank,PC,229:PC=PC+1
					PokeByte MemBank,PC,235:PC=PC+1	
					Pk1(229,"     PUSH HL    ;**")
					Pk1(235,"     EX DE,HL    ;**")
					RegDE=0
					StackCount=StackCount+1
				EndIf
				If RegHL=1 Then 
					PokeByte MemBank,PC,41:PC=PC+1
					PokeByte MemBank,PC,17:PC=PC+1
					PokeShort MemBank,PC,wcf+2:PC=PC+2
					PokeByte MemBank,PC,25:PC=PC+1
					PokeByte MemBank,PC,94:PC=PC+1
					PokeByte MemBank,PC,35:PC=PC+1
					PokeByte MemBank,PC,86:PC=PC+1
					PokeByte MemBank,PC,225:PC=PC+1
					Pk1(41,"     ADD HL,HL    ;**")
					Pk1(237,"     LD DE,"+Str16$(wcf+2)+"    ;**")
					Pk1(91)
					Pk2(wcf+2)
					Pk1(25,"     ADD HL,DE    ;**")
					Pk1(94,"     LD E,(HL)    ;**")
					Pk1(35,"     INC HL    ;**")
					Pk1(86,"     LD D,(HL)    ;**")
					Pk1(225,"     POP HL    ;**")
					RegDE=1
				Else
				;	PokeByte MemBank,PC,42:PC=PC+1			
				;	PokeShort MemBank,PC,wcf:PC=PC+2
				;	Pk1(42,"     LD HL,("+Str16$(wcf)+")    ;**")
				;	Pk2(wcf)
				;	RegHL=1
				EndIf				
				
				
				
				
				;PokeByte MemBank,PC,243:PC=PC+1
				;PokeByte MemBank,PC,24:PC=PC+1
				;PokeByte MemBank,PC,254:PC=PC+1
			EndIf
			;**** -
			If OpListTok(f)=60 Then
				If StackCount>0 Then
					PokeByte MemBank,PC,209:PC=PC+1
					PokeByte MemBank,PC,235:PC=PC+1
					Pk1(209,"     POP DE    ;**")
					Pk1(235,"     EX DE,HL    ;**")
					RegDE=1
					StackCount=StackCount-1
				EndIf
				PokeByte MemBank,PC,167:PC=PC+1			;
				PokeByte MemBank,PC,237:PC=PC+1			;
				PokeByte MemBank,PC,82:PC=PC+1			;
				Pk1(167,"     AND A        ;**")
				Pk1(237,"     SBC HL,DE    ;**")
				Pk1(82)
				RegDE=0:RegHL=1
			EndIf
			;**** +
			If OpListTok(f)=61 Then 
				If StackCount>0 Then
					PokeByte MemBank,PC,209:PC=PC+1
					Pk1(209,"     POP DE    ;**")
					RegDE=1
					StackCount=StackCount-1
				EndIf				
				PokeByte MemBank,PC,25:PC=PC+1			;
				Pk1(25,"     ADD HL,DE    ;**")
				RegDE=0:RegHL=1
			EndIf
			;**** x Multiply
			If OpListTok(f)=63 Then
				AddRoutine("SyB_INT_Mul_HL","SYB.MATH.MULT.INT")
				RegDE=0:RegHL=1
			EndIf
			If OpListTok(f)=64 Then    						;**** AND
				If StackCount>0 Then
					PokeByte MemBank,PC,209:PC=PC+1
					Pk1(209,"     POP DE    ;**")
					RegDE=1
					StackCount=StackCount-1
				EndIf
				PokeByte MemBank,PC,124:PC=PC+1			;**** #7C  -  LD A,H
				PokeByte MemBank,PC,162:PC=PC+1			;**** #A2  -  AND D
				PokeByte MemBank,PC,103:PC=PC+1			;**** #67  -  LD H,A				
				PokeByte MemBank,PC,125:PC=PC+1			;**** #7D  -  LD A,L
				PokeByte MemBank,PC,163:PC=PC+1			;**** #A3  -  AND E
				PokeByte MemBank,PC,111:PC=PC+1			;**** #6F  -  LD L,A
				RegDE=0:RegHL=1
			EndIf
			If OpListTok(f)=65 Then							;**** OR
				If StackCount>0 Then
					PokeByte MemBank,PC,209:PC=PC+1
					Pk1(209,"     POP DE    ;**")
					RegDE=1
					StackCount=StackCount-1
				EndIf
				PokeByte MemBank,PC,124:PC=PC+1			;**** #7C  -  LD A,H
				PokeByte MemBank,PC,178:PC=PC+1			;**** #B2  -  OR D
				PokeByte MemBank,PC,103:PC=PC+1			;**** #67  -  LD H,A				
				PokeByte MemBank,PC,125:PC=PC+1			;**** #7D  -  LD A,L
				PokeByte MemBank,PC,179:PC=PC+1			;**** #B3  -  OR E
				PokeByte MemBank,PC,111:PC=PC+1			;**** #6F  -  LD L,A
				
				RegDE=0:RegHL=1					
			EndIf
			If OpListTok(f)=66 Then							;**** XOR
				If StackCount>0 Then
					PokeByte MemBank,PC,209:PC=PC+1
					Pk1(209,"     POP DE    ;**")
					RegDE=1
					StackCount=StackCount-1
				EndIf
				PokeByte MemBank,PC,124:PC=PC+1			;**** #7C  -  LD A,H
				PokeByte MemBank,PC,170:PC=PC+1			;**** #AA  -  XOR D
				PokeByte MemBank,PC,103:PC=PC+1			;**** #67  -  LD H,A	
				PokeByte MemBank,PC,125:PC=PC+1			;**** #7D  -  LD A,L
				PokeByte MemBank,PC,171:PC=PC+1			;**** #AB  -  XOR E
				PokeByte MemBank,PC,111:PC=PC+1			;**** #6F  -  LD L,A				
				RegDE=0:RegHL=1					
			EndIf
			If OpListTok(f)=67 Then 					;**** = EQUALS
				AddRoutine("SyB_INT_EQ_HL","SYB.MATH.EQUAL.INT")
				RegDE=0:RegHL=1
			EndIf
			If OpListTok(f)=68 Then 					;**** => GREATER THAN EQUAL
				AddRoutine("SyB_INT_GTE_HL","SYB.MATH.GTEQUAL.INT")
				RegDE=0:RegHL=1
			EndIf
			If OpListTok(f)=69 Then 					;**** <= LESSER THAN EQUAL
				AddRoutine("SyB_INT_LTE_HL","SYB.MATH.LTEQUAL.INT")
				RegDE=0:RegHL=1
			EndIf			
			;**** Gets a Integer Variable
			If OpListTok(f)=11 Or OpListTok(f)=12 Then
				wcf=GetRoutineLocation(VarName$(OpListRes#(f)))
				If RegHL=1 And RegDE=1 Then
					qw=0
					;If OpListTok(f-1)=1 Or OpListTok(f-1)=2 Then
					;	If PeekByte(MemBank,PC-3)=17 Then
					;		awq=PeekShort(MemBank,PC-2)
					;		PC=PC-3
					;		PokeByte MemBank,PC,229:PC=PC+1
					;		PokeByte MemBank,PC,33:PC=PC+1			
					;		PokeShort MemBank,PC,awq:PC=PC+2
					;		Pk1(229,"     PUSH HL    ;**")
					;		Pk1(42,"     LD HL,"+Str16$(awq)+"    ;**")
					;		Pk2(awq)
					;		qw=1
					;	EndIf
					;EndIf					
					;If OpListTok(f-1)=11 Or OpListTok(f-1)=12 Then
					;	If PeekByte(MemBank,PC-4)=237 Then
					;		awq=PeekShort(MemBank,PC-2)
					;		PC=PC-4
					;		PokeByte MemBank,PC,229:PC=PC+1
					;		PokeByte MemBank,PC,42:PC=PC+1			
					;		PokeShort MemBank,PC,awq:PC=PC+2
					;		Pk1(229,"     PUSH HL    ;**")
					;		Pk1(42,"     LD HL,("+Str16$(awq)+")    ;**")
					;		Pk2(awq)
					;		qw=1
					;	EndIf
					;EndIf
					If qw=0 Then
						PokeByte MemBank,PC,229:PC=PC+1
						PokeByte MemBank,PC,235:PC=PC+1	
						Pk1(229,"     PUSH HL    ;**")
						Pk1(235,"     EX DE,HL    ;**")
					EndIf
					RegDE=0
					StackCount=StackCount+1
				EndIf
				If RegHL=1 Then 
					PokeByte MemBank,PC,237:PC=PC+1
					PokeByte MemBank,PC,91:PC=PC+1	
					PokeShort MemBank,PC,wcf:PC=PC+2
					Pk1(237,"     LD DE,("+Str16$(wcf)+")    ;**")
					Pk1(91)
					Pk2(wcf)
					RegDE=1
				Else
					PokeByte MemBank,PC,42:PC=PC+1			
					PokeShort MemBank,PC,wcf:PC=PC+2
					Pk1(42,"     LD HL,("+Str16$(wcf)+")    ;**")
					Pk2(wcf)
					RegHL=1
				EndIf	
				;If IsNeg=1 Then AddRoutine("SyB_Neg_Int") 
			EndIf
			;**** Gets a Integer Number
			If OpListTok(f)=1 Or OpListTok(f)=2 Then
				wcf=OpListRes#(f)
				r=0
				If wcf>-1 And wcf<3 Then r=r+1
				If OpListTok(f+1)=61 Or OpListTok(f+1)=60 Then r=r+1
				If f<ItemsOnOp-1 Then r=r+1
				If RegHL=1 Then r=r+1
				
				If RegHL=1 And RegDE=1 And r<4 Then
					qw=0
					;If OpListTok(f-1)=1 Or OpListTok(f-1)=2 Then
					;	If PeekByte(MemBank,PC-3)=17 Then
					;		awq=PeekShort(MemBank,PC-2)
					;		PC=PC-3
					;		PokeByte MemBank,PC,229:PC=PC+1
					;		PokeByte MemBank,PC,33:PC=PC+1			
					;		PokeShort MemBank,PC,awq:PC=PC+2
					;		Pk1(229,"     PUSH HL    ;**")
					;		Pk1(42,"     LD HL,"+Str16$(awq)+"    ;**")
					;		Pk2(awq)
					;		qw=1
					;	EndIf
					;EndIf					
					;If OpListTok(f-1)=11 Or OpListTok(f-1)=12 Then
					;	If PeekByte(MemBank,PC-4)=237 Then
					;		awq=PeekShort(MemBank,PC-2)
					;		PC=PC-4
					;		PokeByte MemBank,PC,229:PC=PC+1
					;		PokeByte MemBank,PC,42:PC=PC+1			
					;		PokeShort MemBank,PC,awq:PC=PC+2
					;		Pk1(229,"     PUSH HL    ;**")
					;		Pk1(42,"     LD HL,("+Str16$(awq)+")    ;**")
					;		Pk2(awq)
					;		qw=1
					;	EndIf
					;EndIf
					If qw=0 Then 
						PokeByte MemBank,PC,229:PC=PC+1
						PokeByte MemBank,PC,235:PC=PC+1	
						Pk1(229,"     PUSH HL    ;**")
						Pk1(235,"     EX DE,HL    ;**")
					EndIf	
					RegDE=0
					StackCount=StackCount+1
				EndIf
				;If r=99 Then			;All conditions filled for INC or DEC or NOP
				;	If regDE=1 Then
				;		If wcf=1 Then
				;			If OpListTok(f+1)=61 Then
				;				PokeByte MemBank,PC,19:PC=PC+1	
				;				Pk1(19,"     INC DE    ;**")
				;			Else
				;				PokeByte MemBank,PC,27:PC=PC+1	
				;				Pk1(27,"     DEC DE    ;**")							
				;			EndIf	
				;		EndIf
				;	Else
				;		If wcf=1 Then
				;			If OpListTok(f+1)=61 Then
				;				PokeByte MemBank,PC,35:PC=PC+1	
				;				Pk1(35,"     INC HL    ;**")
				;			Else
				;				PokeByte MemBank,PC,43:PC=PC+1	
				;				Pk1(43,"     DEC HL    ;**")							
				;			EndIf	
				;		EndIf
				;	EndIf	
				;	f=f+1
				;Else
					If RegHL=1 Then
						PokeByte MemBank,PC,17:PC=PC+1	
						PokeByte MemBank,PC,wcf Mod 256:PC=PC+1
						PokeByte MemBank,PC,wcf/256:PC=PC+1
						Pk1(17,"     LD DE,"+Str16$(wcf)+"    ;**")
						Pk2(wcf)
						RegDE=1
					Else	
						PokeByte MemBank,PC,33:PC=PC+1			;x 00 dd0 001
						PokeByte MemBank,PC,wcf Mod 256:PC=PC+1			;data 1
						PokeByte MemBank,PC,wcf/256:PC=PC+1			;data 1
						Pk1(33,"     LD HL,"+Str16$(wcf)+"    ;**")
						Pk2(wcf)
						RegHL=1
					EndIf
				;EndIf
			EndIf
		Next
		
		If HLReturn=0 Then 
			AddRoutine("SyB_Store_HL_2_Stack","SYB.STORE.HL.2.STACK")
		Else	
			WasHLReturn=1
		EndIf
	End If	
	
	HLReturn=0
	
	Return CalStack(CalStackNo-1,0)	
	
	
End Function

Function GetStacktoBrack()
	a=CalStackNo-1
	b=0
	If a>-1 Then
		If CalStack(a,0)=8 Then
			a=0
		Else
			b=b+1
		EndIf
		a=a-1
	EndIf	
	Return b
End Function
Function AddExpression$(ChkWord,Bracketed=0,MustBe=0)
	WasHLReturn=0
	ExprNo=0
	Pae=0
.Bribble
	ANS$=SepSort$(ChkWord)
	ans2$=SepSort$(ChkWord+1)
	If ANS$=""And Pae>0 Then
		Err=109
		ErrMessage$="')' expected"
		Return
	EndIf
	If (Upper$(ANS$)="THEN" Or Upper$(ANS$)=Terminator$ Or ANS$=":" Or ANS$=";" Or (ANS$="," And Bracketed<>1) Or ANS$="")And Pae=0 Then
		Cod=ChkWord
		Goto Bribble2
	EndIf
	;**** This is for when I need to do define arrays r(x,x,x)= so the process stops before the = 
	If ANS$=")" And Bracketed>0 And Pae=0 Then
		Cod=ChkWord
		Goto Bribble2
	EndIf
	If ANS$="=" And ans2$=">"Then
		ANS$=">="
		ChkWord=ChkWord+1
	EndIf
	If ANS$="=" And ans2$="<"Then
		ANS$="<="
		ChkWord=ChkWord+1
	EndIf
	If ANS$=">" And ans2$="="Then
		ANS$=">="
		ChkWord=ChkWord+1
	EndIf
	If ANS$="<" And ans2$="="Then
		ANS$="<="
		ChkWord=ChkWord+1
	EndIf
	If ANS$="<" And ans2$=">"Then
		ANS$="<>"
		ChkWord=ChkWord+1
	EndIf
	If ANS$="("Then
		Pae=Pae+1
	EndIf
	If ANS$=")"Then
		Pae=Pae-1
		If Pae<0 Then
			Err=110
			ErrMessage$="Unexpected ')'"
			Return
		EndIf
	EndIf
	ExprNo=ExprNo+1
	Expr$(ExprNo)=ANS$
	ChkWord=ChkWord+1
	Goto Bribble

;**** Have sorted into words
;**** This puts them in priority order Reverse Polish (PostFix)
;**** Tokens are
;**** 1  = 16 bit Integer
;**** 2  = 32 bit Integer
;**** 3  = 40 bit Float
;**** 4  = 8 Bit Byte 
;**** 5  = 16 Bit String
;**** 8  = Array on Stack
;**** 9  = Function

;**** 11 = Variable 16bit Integer
;**** 12 = Variable 32bit Integer
;**** 13 = Variable 40bit Float
;**** 14 = Variable 8Bit Byte
;**** 15 = Variable 16Bit String

;**** 21 = Address Variable 16Bit Integer
;**** 22 = Address Variable 32Bit Integer
;**** 23 = Address Variable 40Bit Float
;**** 24 = Address Variable 8Bit Byte
;**** 25 = Address Varaible 16Bit String

;**** 31 = Single Dimension 16bit Integer Array
;**** 32 = Single Dimension 32bit Integer Array
;**** 33 = Single Dimension 40bit Integer Array
;**** 34 = Single Dimension 8Bit Byte Array
;**** 35 = Single Dimension 16bit String Array

;**** 41 = Double Dimension 16bit Integer Array
;**** 42 = Double Dimension 32bit Integer Array
;**** 43 = Double Dimension 40bit Float Array
;**** 44 = Double Dimension 8Bit Byte Array
;**** 45 = Double Dimension 16Bit String Array

;**** 50 = End Function

;**** 60 = "-" Minus
;**** 61 = "+" Plus
;**** 62 = "/" Divide
;**** 63 = "*" Multiply
;**** 64 = AND
;**** 65 = OR
;**** 66 = XOR
;**** 67 = "=" Equals
;**** 68 = ">=" Greater Than Equals
;**** 69 = "<=" Lesser Than Equals
;**** 70 = "<>" Other Than
;**** 71 = "<" Lesser Than
;**** 72 = ">" Greater Than
;**** 73 = MOD	
;**** 74 = "SHR" Shift Bits Right
;**** 75 = "SHL" Shift Bits Left	

;**** 80 = PI

	.Bribble2
	
	CanNeg=1
	ItemsOnList=0
	ItemsOnOp=0
	AddEndFunc=0
	IsFunc=0
	For f=1 To ExprNo
		If Expr$(f)="//ignore:me//"Then Goto GandiMan	
		Prec=0
		If IsFunc=1 Then
			If Expr$(f)="("Then
				Prec=1:Tok=101:CanNeg=1
			Else
				If ReqBrack=0 Then
					ErrMessage$="'(' expected"
					Err=110
					Return 0
				EndIf
				canneg=0
			EndIf
		Else
			If Expr$(f)="("Then Prec=1:Tok=100:CanNeg=1
		EndIf
		IsFunc=0
		If CanNeg=0 Then
			If Expr$(f)="-"Then Prec=2:Tok=60:CanNeg=1
			If Expr$(f)="+"Then Prec=2:Tok=61:CanNeg=1
		Else	
			If Expr$(f)="-"Then 
				Expr$(f)="{Neg}"
				CanNeg=0
				OpListRes#(ItemsOnOp)=0
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=74				;16 Bit Integer Token
				ItemsOnOp=ItemsOnOp+1				
				Goto GandiMan
			EndIf	
			If Expr$(f)="+"Then 
				Expr$(f)="{Pos}"
				CanNeg=0
				OpListRes#(ItemsOnOp)=0
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=74				;16 Bit Integer Token
				ItemsOnOp=ItemsOnOp+1				
				Goto GandiMan
			EndIf
		EndIf	
		If Expr$(f)="/"Then Prec=1:Tok=62:CanNeg=1
		If Expr$(f)="*"Then Prec=1:Tok=63:CanNeg=1
		If Upper$(Expr$(f))="AND"Then Prec=5:Tok=64:CanNeg=1
		If Upper$(Expr$(f))="OR"Then Prec=5:Tok=65:CanNeg=1
		If Upper$(Expr$(f))="XOR"Then Prec=5:Tok=66:CanNeg=1
		If Expr$(f)="="Then Prec=4:Tok=67:CanNeg=1
		If Expr$(f)=">="Then Prec=4:Tok=68:CanNeg=1
		If Expr$(f)="<="Then Prec=4:Tok=69:CanNeg=1
		If Expr$(f)="<>"Then Prec=4:Tok=70:CanNeg=1
		If Expr$(f)="<"Then Prec=4:Tok=71:CanNeg=1
		If Expr$(f)=">"Then Prec=4:Tok=72:CanNeg=1		
		If Upper$(Expr$(f))="MOD" Then Prec=4:Tok=73:CanNeg=1
		If Upper$(Expr$(f))="SHR" Then Prec=4:Tok=74:CanNeg=1
		If Upper$(Expr$(f))="SHL" Then Prec=4:Tok=75:CanNeg=1
		If Prec>0 Then
			If ItemsOnList>0 And Prec>1 Then
				For g=1 To Prec-1
					For h=ItemsOnList-1 To 0 Step-1
						If ItListTok(h)=100 Or ItListTok(h)=101 Then
							h=0
						Else	
							If ItListPrec(h)=g Then 
								;*** Add This to the OpStack
								OpListStr$(ItemsOnOp)=ItListStr$(h)
								OpListTok(ItemsOnOp)=ItListTok(h)
								ItemsOnOp=ItemsOnOp+1
								ItListPrec(h)=999
								ItListStr$(h)="(Empty)"
								ItListTok(h)=0
							EndIf
						EndIf
					Next
				Next
			EndIf
			ItListStr$(ItemsOnList)=Expr$(f)
			ItListPrec(ItemsOnList)=Prec
			ItListTok(ItemsOnList)=Tok
			ItemsOnList=ItemsOnList+1
			Goto GandiMan
		EndIf
		If Expr$(f)=")"Then
			CanNeg=0
			For g=1 To 10
				For h=ItemsOnList-1 To 0 Step-1
					If ItListTok(h)=100 Or ItListTok(h)=101 Then
						h=0
					Else	
						If ItListPrec(h)=g Then 
							;*** Add This to the OpStack
							OpListStr$(ItemsOnOp)=ItListStr$(h)
							OpListTok(ItemsOnOp)=ItListTok(h)
							ItemsOnOp=ItemsOnOp+1
							ItListPrec(h)=999
							ItListStr$(h)="(Empty)"
							ItListTok(h)=0
						EndIf
					EndIf
				Next
			Next
			;**** This Erases the last ( it finds in the ItList ****
			For h=ItemsOnList-1 To 0 Step-1
				If ItListTok(h)=100 Or ItListTok(h)=101 Then
					If ItListTok(h)=101 Then AddEndFunc=1
					ItListPrec(h)=999
					ItListStr$(h)="(Empty)"
					ItListTok(h)=0
					h=0
				EndIf
			Next
			Goto GandiMan			
		EndIf
		If Expr$(f)=","Then
			CanNeg=1
			For g=1 To 10
				For h=ItemsOnList-1 To 0 Step-1
					If ItListTok(h)=100 Or ItListTok(h)=101 Then
						h=0
					Else	
						If ItListPrec(h)=g Then 
							;*** Add This to the OpStack
							OpListStr$(ItemsOnOp)=ItListStr$(h)
							OpListTok(ItemsOnOp)=ItListTok(h)
							ItemsOnOp=ItemsOnOp+1
							ItListPrec(h)=999
							ItListStr$(h)="(Empty)"
							ItListTok(h)=0
						EndIf
					EndIf
				Next
			Next
			Goto GandiMan			
		EndIf
		;**** Check if Direct String ****
		If Mid$(Expr$(f),1,1)=Chr$(34)Then
			CanNeg=0
			OpListRes#(ItemsOnOp)=0
			OpListStr$(ItemsOnOp)=Expr$(f)
			OpListTok(ItemsOnOp)=5				;String Token
			ItemsOnOp=ItemsOnOp+1
			Goto GandiMan
		EndIf
		;**** Check if its a Function
		Res#=IsFunction#(Expr$(f))
		If Succeed=True Then
			;**** Float Functions
			If Res#=>8000 And Res#<8100 Then
				a=CheckVarPost(f,13)
				If a=0 Then Return
				OpListRes#(ItemsOnOp)=Res#
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=7				;Function Token	
				ItemsOnOp=ItemsOnOp+1
				IsFunc=1
				If ReqBrack=1 Then AddEndFunc=1:IsFunc=0
				Goto GandiMan
			EndIf	
			;**** Integer Function	
			If Res#=>8100 And Res#<8200 Then
				;If Res#=8119 Then Stop
				a=CheckVarPost(f,12)
				If a=0 Then Return
				OpListRes#(ItemsOnOp)=Res#
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=7				;Function Token	
				ItemsOnOp=ItemsOnOp+1
				IsFunc=1
				If ReqBrack=1 Then AddEndFunc=1:IsFunc=0
				Goto GandiMan	
			EndIf
			;**** String Function	
			If Res#=>8200 And Res#<8300 Then
				a=CheckVarPost(f,15)
				If a=0 Then Return
				OpListRes#(ItemsOnOp)=Res#
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=7				;Function Token	
				ItemsOnOp=ItemsOnOp+1
				IsFunc=1
				If ReqBrack=1 Then AddEndFunc=1:IsFunc=0
				Goto GandiMan	
			EndIf
			;**** User Functions
			CanNeg=0
			hi=FuncType(Res)
			If hi=1 Or hi=11 Then Err=120:ErrMessage$="Cannot use Function without output":Return
			If hi<10 Then hi=hi+10
			a=CheckVarPost(f,hi)
			If a=0 Then Return
			OpListRes#(ItemsOnOp)=Res#
			OpListStr$(ItemsOnOp)=Expr$(f)
			OpListTok(ItemsOnOp)=9				;Function Token
			ItemsOnOp=ItemsOnOp+1
			IsFunc=1
			Goto GandiMan
		EndIf
		;**** Check if its a Number
		Res#=IsNumber#(Expr$(f))
		If Succeed=True Then
			CanNeg=0
			If ResultInt=0 Then
				OpListRes#(ItemsOnOp)=Int(Res#)
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=1				;16 Bit Integer Token
				ItemsOnOp=ItemsOnOp+1
				Goto GandiMan
			Else
				OpListRes#(ItemsOnOp)=Res#
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=3				;16 Bit Integer Token
				ItemsOnOp=ItemsOnOp+1
				Goto GandiMan
			EndIf
		EndIf
		;;**** Check If its a Label
		;Res=Int(IsLabel#(Expr$(f)))
		;If Succeed=True Then
		;	RuntimeError(Res)
		;	CanNeg=0
		;	OpListRes#(ItemsOnOp)=Res
		;	OpListStr$(ItemsOnOp)=Expr$(f)
		;	OpListTok(ItemsOnOp)=89
		;	ItemsOnOp=ItemsOnOp+1
		;	Goto GandiMan
		;EndIf
		;**** Check If its a Variable
		Res=Int(IsVariable#(Expr$(f)))
		If Succeed=True Then
			CanNeg=0
			a=CheckVarPost(f,VarType(Res))
			If a=0 Then Return
			;**** 16Bit Variable
			If VarType(Res)=>11 And VarType(Res)<=15 Then 			;*** 16 Bit Int
				OpListRes#(ItemsOnOp)=Res
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=VarType(Res)
				ItemsOnOp=ItemsOnOp+1
				Goto GandiMan
			EndIf
			If VarType(Res)=>31 And VarType(Res)<=35 Then
				OpListRes#(ItemsOnOp)=Res
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=VarType(Res)
				ItemsOnOp=ItemsOnOp+1
				IsFunc=1
				Goto GandiMan
			EndIf
			If VarType(Res)=>41 And VarType(Res)<=45 Then
				OpListRes#(ItemsOnOp)=Res
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=VarType(Res)
				ItemsOnOp=ItemsOnOp+1
				IsFunc=1
				Goto GandiMan
			EndIf
			;**** 16Bit Variable
			If VarType(Res)=89 Then 
				OpListRes#(ItemsOnOp)=Res
				OpListStr$(ItemsOnOp)=Expr$(f)
				OpListTok(ItemsOnOp)=VarType(Res)
				ItemsOnOp=ItemsOnOp+1
				Goto GandiMan
			EndIf
		EndIf
		
		Err=115
		ErrMessage$="Unrecognised operator '"+Expr$(f)+"'"
		Return
.GandiMan
		If AddEndFunc=1 Then
			OpListRes#(ItemsOnOp)=0
			OpListStr$(ItemsOnOp)="EndF"
			OpListTok(ItemsOnOp)=50
			ItemsOnOp=ItemsOnOp+1
			AddEndFunc=0
		EndIf
	Next
	;**** Force Remaining Stuff onto OpList
	For g=1 To 10
		For h=ItemsOnList-1 To 0 Step-1
			If ItListTok(h)=100 Or ItListTok(h)=101 Then
				h=0
			Else	
				If ItListPrec(h)=g Then 
					;*** Add This to the OpStack
					OpListStr$(ItemsOnOp)=ItListStr$(h)
					OpListTok(ItemsOnOp)=ItListTok(h)
					ItemsOnOp=ItemsOnOp+1
					ItListPrec(h)=999
					ItListStr$(h)="(Empty)"
					ItListTok(h)=0
				EndIf
			EndIf
		Next
	Next
;********************************************
;***** Here we process the RVP math statement
;********************************************
	SimpleExpression=0
	OldPc=PC
	CalStackNo=0
;	ew$=""
	bow$=""
	IsNeg=0
	For f=0 To ItemsOnOp-1
		;**** Check For Array Variable
		If OpListTok(f)=31 Or OpListTok(f)=33 Or OpListTok(f)=35  Then		;**** This is Integer Variable
			AddCalStack(8,OpListRes(f))
			SimpleExpression=1
		EndIf
		;**** Check For Double Array Variable
		If OpListTok(f)=41 Or OpListTok(f)=43 Or OpListTok(f)=45 Then		;**** This is Integer Variable
			AddCalStack(8,OpListRes(f))
			SimpleExpression=1
		EndIf		
		;**** Check For Function
		If OpListTok(f)=9 Then		;**** This is Function
			AddCalStack(9,OpListRes(f))
			SimpleExpression=1
		EndIf
		;**** Check For Basic Function
		If OpListTok(f)=7 Then		;**** This is Function
			AddCalStack(7,OpListRes(f))
			SimpleExpression=1
		EndIf
		;**** Gets a Integer Number
		If OpListTok(f)=1 Or OpListTok(f)=2 Then 
			AddRoutine("SyB_Push_N_Int","SYB.PUSH.N.INT")
			AddCalStack(2)
			AddIntNumber(OpListRes#(f),IsNeg)
		EndIf
		;**** Gets an Equate Integer Number
		If OpListTok(f)=89 Then 
			AddRoutine("SyB_Push_N_Int","SYB.PUSH.N.INT")
			AddCalStack(2)
			AddVariable(f)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Int")
		EndIf
		;**** Gets a Integer Variable
		If OpListTok(f)=11 Or OpListTok(f)=12 Then 
			PokeByte MemBank,PC,42:PC=PC+1			;**** #2A  -  LD HL,(addr)
			PokeShort MemBank,PC,GetRoutineLocation(VarName$(OpListRes#(f))):PC=PC+2
			AddRoutine("SyB_Push_V_Int_Direct","SYB.PUSH.V.INT.DIRECT")
			AddCalStack(2)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Int") 
		EndIf
		;**** Gets a Byte Variable
		If OpListTok(f)=14 Then
			PokeByte MemBank,PC,58:PC=PC+1			;**** #3A  -  Ld HL,(addr)
			PokeShort MemBank,PC,GetRoutineLocation(VarName$(OpListRes#(f))):PC=PC+2
			AddRoutine("SyB_Push_V_Byt_Direct","SYB.PUSH.V.BYTE.DIRECT")
			AddCalStack(2)
			;AddVariable(f)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Int") 
		EndIf	
		;**** Gets a Float Number
		If OpListTok(f)=3 Then 		
			AddRoutine("SyB_Push_N_Flo")
			AddCalStack(3)
			AddFloNumber(OpListRes#(f),IsNeg)
			SimpleExpression=1
		EndIf	
		;**** Get a Float Variable
		If OpListTok(f)=13 Then
			AddRoutine("SyB_Push_V_Flo")
			AddCalStack(3)
			AddVariable(f)
			If IsNeg=1 Then AddRoutine("SyB_Neg_Flo")
			SimpleExpression=1
		EndIf
		;**** Gets a String 
		If OpListTok(f)=5 Then 
			AddRoutine("SyB_Push_N_Str")
			AddCalStack(5)
			AddString(OpListStr$(f))
			SimpleExpression=1
		EndIf		
		;**** Gets a String Variable
		If OpListTok(f)=15 Then 
			AddRoutine("SyB_Push_V_Str","SYB.PUSH.V.STR")
			AddCalStack(5)
			AddVariable(f)
			SimpleExpression=1
		EndIf
		
		;**** Functions Doing
		If OpListTok(f)=50 Then
			a=-1
			For g=CalStackNo To 0 Step -1
				n=CalStack(g,0)
				If n=9 Then a=3:Exit
				If n=8 Then a=1:Exit
				If n=7 Then a=2:Exit
			Next
			;**** System Functions
			If a=2 Then CheckSystemFunction(g)
			If a=1 Then CheckArrays(g)
			If a=3 Then CheckUserFunction(g)
			SimpleExpression=1
		EndIf
		
		;**** Operands
		
		If OpListTok(f)=>60 And OpListTok(f)<74 Then
			a1=CalStack(CalStackNo-1,0)
			a2=CalStack(CalStackNo-2,0)
			DelCalStack()
			DelCalStack()
			n=0
			If a1=2 And a2=2 Then n=2
			If a1=3 Or a2=3 Then n=3
			If a1=5 And a2=5 Then n=5
			If n=2 Then
				If OpListTok(f)=60 Then AddRoutine("SyB_INT_Sub","SYB.MATH.SUB.INT"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=61 Then AddRoutine("SyB_INT_Add","SYB.MATH.ADD.INT"):AddCalStack(2)
				If OpListTok(f)=62 Then AddRoutine("SyB_INT_Div","SYB.MATH.DIVIDE.INT"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=63 Then AddRoutine("SyB_INT_Mul","SYB.MATH.MULT.INT"):AddCalStack(2):SimpleExpression=1
				
				If OpListTok(f)=64 Then AddRoutine("SyB_INT_And","SYB.MATH.AND"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=65 Then AddRoutine("SyB_INT_Or","SYB.MATH.OR"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=66 Then AddRoutine("SyB_INT_Xor","SYB.MATH.XOR"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=73 Then AddRoutine("SyB_INT_Mod","SYB.MATH.MOD"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=74 Then AddRoutine("SyB_INT_Shr"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=75 Then AddRoutine("SyB_INT_Shl"):AddCalStack(2):SimpleExpression=1
				
				If OpListTok(f)=67 Then AddRoutine("SyB_INT_EQ","SYB.MATH.EQUAL.INT"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=68 Then AddRoutine("SyB_INT_GTE","SYB.MATH.GTEQUAL.INT"):AddCalStack(2):SimpleExpression=1
				If OpListTok(f)=69 Then AddRoutine("SyB_INT_LTE","SYB.MATH.LTEQUAL.INT"):AddCalStack(2):SimpleExpression=1			
				If OpListTok(f)=70 Then AddRoutine("SyB_INT_OT","SYB.MATH.OTHERTHAN.INT"):AddCalStack(2):SimpleExpression=1				
				If OpListTok(f)=71 Then AddRoutine("SyB_INT_LT","SYB.MATH.LESSERTHAN.INT"):AddCalStack(2):SimpleExpression=1				
				If OpListTok(f)=72 Then AddRoutine("SyB_INT_GT","SYB.MATH.GREATERTHAN.INT"):AddCalStack(2):SimpleExpression=1
			EndIf
			If n=3 Then
				SimpleExpression=1
				a8=OpListTok(f)
				If (a8>=60 And a8<=63) Or (a8>=67 And a8<=72) Then
					If a2=2 Then AddRoutine("SyB_INT_2_FLO_Stack_2","SYB.INT.2.FLOAT.STACK")
					If a1=2 Then AddRoutine("SyB_INT_2_FLO","SYB.INT.2.FLOAT.STACK")			
				EndIf
				If (a8>=64 And a8<=66) Or a8=73 Then
					If a2=3 Then AddRoutine("SyB_FLO_2_INT_Stack_2","SYB.FLOAT.2.INT.STACK")
					If a1=3 Then AddRoutine("SyB_FLO_2_INT_Stack_1","SYB.FLOAT.2.INT.STACK")			
				EndIf
				If OpListTok(f)=60 Then AddRoutine("SyB_FLO_Sub","SYB.MATH.SUB.FLOAT"):AddCalStack(3)
				If OpListTok(f)=61 Then AddRoutine("SyB_FLO_Add","SYB.MATH.ADD.FLOAT"):AddCalStack(3)
				If OpListTok(f)=62 Then AddRoutine("SyB_FLO_Div","SYB.MATH.DIVIDE.FLOAT"):AddCalStack(3)
				If OpListTok(f)=63 Then AddRoutine("SyB_FLO_Mul","SYB.MATH.MULTIPLY.FLOAT"):AddCalStack(3)
				
				If OpListTok(f)=64 Then AddRoutine("SyB_INT_And","SYB.MATH.And"):AddCalStack(2)	;Int Inputs
				If OpListTok(f)=65 Then AddRoutine("SyB_INT_Or"):AddCalStack(2)		;Int Inputs
				If OpListTok(f)=66 Then AddRoutine("SyB_INT_Xor","SYB.MATH.XOR"):AddCalStack(2)	;Int Inputs
				If OpListTok(f)=73 Then AddRoutine("SyB_INT_Mod","SYB.MATH.MOD"):AddCalStack(2)	;Int Inputs
				
				If OpListTok(f)=67 Then AddRoutine("SyB_FLO_EQ","SYB.MATH.EQUAL.FLOAT"):AddCalStack(2)
				If OpListTok(f)=68 Then AddRoutine("SyB_FLO_GTE","SYB.MATH.GTEQUAL.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=69 Then AddRoutine("SyB_FLO_LTE","SYB.MATH.GTEQUAL.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=70 Then AddRoutine("SyB_FLO_OT","SYB.MATH.OT.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=71 Then AddRoutine("SyB_FLO_LT","SYB.MATH.LT.FLOAT"):AddCalStack(2)				
				If OpListTok(f)=72 Then AddRoutine("SyB_FLO_GT","SYB.MATH.GT.FLOAT"):AddCalStack(2)
			EndIf
			If n=5 Then
				SimpleExpression=1
				If OpListTok(f)=61 Then AddRoutine("SyB_STR_Add","SYB.STR.ADD"):AddCalStack(5)
				If OpListTok(f)=60 Or OpListTok(f)=62 Or OpListTok(f)=63 Or OpListTok(f)=62 Then
					ErrMessage$="Operator cannot be applied to Strings"
					Err=121
				EndIf
				If OpListTok(f)=64 Or OpListTok(f)=65 Or OpListTok(f)=66 Then
					ErrMessage$="Operator cannot be applied to Strings"
					Err=121
				EndIf
				If OpListTok(f)=67 Then AddRoutine("SyB2_STR_EQ"):AddCalStack(2)
				If OpListTok(f)=68 Then AddRoutine("SyB2_STR_GTE"):AddCalStack(2)				
				If OpListTok(f)=69 Then AddRoutine("SyB2_STR_LTE"):AddCalStack(2)
				If OpListTok(f)=70 Then AddRoutine("SyB2_STR_OT"):AddCalStack(2)
				If OpListTok(f)=71 Then AddRoutine("SyB2_STR_LT"):AddCalStack(2)
				If OpListTok(f)=72 Then AddRoutine("SyB2_STR_GT"):AddCalStack(2)
			EndIf	
		EndIf	
		IsNeg=0
		If OpListTok(f)=74 Then IsNeg=1
		bow$=bow$+OpListStr$(f)+" "
		If CalStackNo>3 Then SimpleExpression=1
	Next
	;CpRun=CpRun+1:ComR$(CpRun Mod 50)=bw$:CompileRundown()
	
	;**** Finished So Just Check output Valid / Balanced
	If CalStackNo<>1 Then
		;RuntimeError(CalStackNo+" "+MustBe)
		If Err=0 Then ErrMessage$="Error in expression"
		Err=120
	Else
		If MustBe>0 Then
			a1=CalStack(CalStackNo-1,0)
			If MustBe=5 And a1<>5 Then
				ErrMessage$="Expecting String "+a1
				Err=120
			EndIf				
			If (MustBe=2 Or MustBe=3) And a1=5 Then
				ErrMessage$="Expecting value not String"
				Err=120
			EndIf
			If MustBe=2 And a1=3 Then
				AddRoutine("SyB_Flo_2_Int_Stack_1")
			EndIf
			If MustBe=3 And a1=2 Then
				AddRoutine("SyB_Int_2_Flo")
			EndIf
		EndIf
	EndIf
	If SimpleExpression=0 Then
		IsNeg=0
		PC=OldPc
		RegDE=0
		RegHL=0
		For f=0 To ItemsOnOp-1
			
			If OpListTok(f)=61 Then 
				PokeByte MemBank,PC,25:PC=PC+1			;x 00 dd0 001
				Pk1(25,"     ADD HL,DE    ;**")
				RegDE=0
			EndIf
			If OpListTok(f)=1 Or OpListTok(f)=2 Then
				wcf=OpListRes#(f)
				If RegHL=1 Then
					PokeByte MemBank,PC,235:PC=PC+1			;x 00 dd0 001
					Pk1(235,"     EX DE,HL    ;**")
					RegDE=1
				EndIf	
				PokeByte MemBank,PC,33:PC=PC+1			;x 00 dd0 001
				PokeByte MemBank,PC,wcf Mod 256:PC=PC+1			;data 1
				PokeByte MemBank,PC,wcf/256:PC=PC+1			;data 1
				Pk1(33,"     LD HL,"+Str16$(wcf)+"    ;**")
				Pk2(wcf)
				RegHL=1
			EndIf
		Next
		
		If HLReturn=0 Then 
			AddRoutine("SyB_Store_HL_2_Stack","SYB.STORE.HL.2.STACK")
		Else	
			WasHLReturn=1
		EndIf
	End If	
	
	HLReturn=0
	
	Return CalStack(CalStackNo-1,0)
End Function	
Function CheckArrays(Pos)
	StkItm=CalStackNo-Pos-1
	FunNo=CalStack(Pos,1)
	zx=VarType(FunNo)
	If zx=31 Or zx=33 Or zx=35 Then 
		If StkItm<>1 Then ErrMessage$="Incorrect number of dimensions":Err=120:Return 0
		If CalStack(Pos+1,0)=3 Then  ;**** Only Do If Integer
			AddRoutine("SyB_FLO_2_INT_Stack_1")
		EndIf		
	EndIf
	If zx=41 Or zx=43 Or zx=45 Then 
		If StkItm<>2 Then ErrMessage$="Incorrect number of dimensions":Err=120:Return 0
		If CalStack(Pos+1,0)=3 Then  ;**** Only Do If Integer
			AddRoutine("SyB_FLO_2_INT_Stack_1")
		EndIf
		If CalStack(Pos+2,0)=3 Then  ;**** Only Do If Integer
			AddRoutine("SyB_FLO_2_INT_Stack_2")
		EndIf
	EndIf
	If zx=31 Then
		PokeByte MemBank,PC,17:PC=PC+1			;**** #11  -  LD DE,addr
		t=GetRoutineLocation(VarName$(FunNo))+2
		PokeShort MemBank,PC,t:PC=PC+2
		AddRoutine("SyB_Push_V_Int_Array_1_Direct","SYB.PUSH.V.INT.ARRAY.1.DIRECT")	
		For j=CalStackNo-1 To Pos Step -1
			DelCalStack()
		Next				
		AddCalStack(2)					
	EndIf	
	If zx=33 Then
		;AddRoutine("SyB_Push_V_Flo_Array_1")
		;PokeShort MemBank,PC,GetRoutineLocation(VarName$(FunNo)):PC=PC+2
		;For j=CalStackNo-1 To Pos Step -1
		;	DelCalStack()
		;Next				
		;AddCalStack(3)
		PokeByte MemBank,PC,17:PC=PC+1			;**** #11  -  LD DE,addr
		t=GetRoutineLocation(VarName$(FunNo))+2
		PokeShort MemBank,PC,t:PC=PC+2		
		AddRoutine("SyB_Push_V_Flo_Array_1_Direct","SYB.PUSH.V.FLOAT.ARRAY.1.DIRECT")
		For j=CalStackNo-1 To Pos Step -1
			DelCalStack()
		Next				
		AddCalStack(3)
	EndIf
	If zx=35 Then
		AddRoutine("SyB_Push_V_Str_Array_1")
		PokeShort MemBank,PC,GetRoutineLocation(VarName$(FunNo)):PC=PC+2
		For j=CalStackNo-1 To Pos Step -1
			DelCalStack()
		Next				
		AddCalStack(5)					
	EndIf
	If zx=41 Then
		AddRoutine("SyB_Push_V_Int_Array_2","SYB.PUSH.V.INT.ARRAY.2")
		PokeShort MemBank,PC,GetRoutineLocation(VarName$(FunNo)):PC=PC+2
		For j=CalStackNo-1 To Pos Step -1
			DelCalStack()
		Next				
		AddCalStack(2)
	EndIf
	If zx=43 Then
		AddRoutine("SyB_Push_V_Flo_Array_2","SYB.PUSH.V.FLOAT.ARRAY.2")
		PokeShort MemBank,PC,GetRoutineLocation(VarName$(FunNo)):PC=PC+2
		For j=CalStackNo-1 To Pos Step -1
			DelCalStack()
		Next				
		AddCalStack(3)					
	EndIf
	If zx=45 Then
		AddRoutine("SyB_Push_V_Str_Array_2")
		PokeShort MemBank,PC,GetRoutineLocation(VarName$(FunNo)):PC=PC+2
		For j=CalStackNo-1 To Pos Step -1
			DelCalStack()
		Next				
		AddCalStack(5)					
	EndIf	
	
End Function
Function CheckUserFunction(Pos)
	StkItm=CalStackNo-Pos-1
	c=OpListRes(Pos)
	If StkItm<>FuncParams(c)Then 
		;RuntimeError (StkItm+" "+FuncParams(c))
		Err=120:ErrMessage$="Incorrect number of Function parameters":Return
	EndIf	
	k1=StkItm
	For k=(Pos+StkItm) To (Pos+1) Step-1
	
	
	;For k=StkItm To 1 Step-1
		n=FuncParVar(c,k1)
		n1=CalStack(k,0)
		If n>100000 Then 
			n=n-100000
		Else
			j=n
			n=VarType(n)
			p=99
			If n=11 Or n=12 Then n=2:p=1
			If n=13 Then n=3:p=1
			If n=15 Then n=5:p=1
			If p=99 Then ErrMessage$=Func$(j)+" incorrect":Err=120:Return
		EndIf
		If n=2 And n1=3 Then
			AddRoutine("SyB_Flo_2_Int_Stack_"+Str$(StkItm-k1+1)):n1=n
		EndIf
		If n=3 And n1=2 Then
			AddRoutine("SyB_Int_2_Flo_Stack_"+Str$(StkItm-k1+1)):n1=n
		EndIf
		If n<>n1 Then Err=120:ErrMessage$=Func$(OpListRes(Pos))+" yype mismatch":Return
		k1=k1-1
	Next
	AddRoutine(Func$(OpListRes(Pos)))
	
	For j=CalStackNo-1 To Pos Step -1
		DelCalStack()
	Next
	n=FuncType(OpListRes(Pos))
	If n>11 Then n=n-10
	AddCalStack(n)
End Function
Function CheckSystemFunction(Pos)
	StkItm=CalStackNo-Pos-1
	FunNo=CalStack(Pos,1)
	
	If FunNo>=8000 And FunNo<=8009
		;**** SIN
		If FunNo=8000 Then
			If StkItm<>1 Then ErrMessage$="SIN used incorrectly":Err=120:Return
			CheckFunctionInput("SIN",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("SIN",3,Pos,"SYB.MATH.SIN"):Return
		EndIf
		;**** COS
		If FunNo=8001 Then
			If StkItm<>1 Then ErrMessage$="COS used incorrectly":Err=120:Return
			CheckFunctionInput("COS",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("COS",3,Pos,"SYB.MATH.COS"):Return
		EndIf	
		;**** TAN
		If FunNo=8002 Then	
			If StkItm<>1 Then ErrMessage$="TAN used incorrectly":Err=120:Return
			CheckFunctionInput("TAN",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("TAN",3,Pos,"SYB.MATH.TAN"):Return
		EndIf	
		;**** SQR
		If FunNo=8003 Then
			If StkItm<>1 Then ErrMessage$="SQR used incorrectly":Err=120:Return
			CheckFunctionInput("SQR",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("SQR",3,Pos,"SYB.MATH.SQR"):Return
		EndIf
		;**** LOG
		If FunNo=8004 Then
			If StkItm<>1 Then ErrMessage$="LOG used incorrectly":Err=120:Return
			CheckFunctionInput("LOG",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("LOG",3,Pos,"SYB.MATH.LOG"):Return
		EndIf	
		;**** LOG10
		If FunNo=8005 Then	
			If StkItm<>1 Then ErrMessage$="LOG10 used incorrectly":Err=120:Return
			CheckFunctionInput("LOG10",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("LOG10",3,Pos,"SYB.MATH.LOG10"):Return
		EndIf
		;**** ATAN
		If FunNo=8006 Then
			If StkItm<>1 Then ErrMessage$="ATAN used incorrectly":Err=120:Return
			CheckFunctionInput("ATAN",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("ATAN",3,Pos,"SYB.MATH.ATAN"):Return
		EndIf	
		;**** EXP
		If FunNo=8007 Then
			If StkItm<>1 Then ErrMessage$="EXP used incorrectly":Err=120:Return
			CheckFunctionInput("EXP",Pos,3)		;Name,Pos,Typ 
			ApplyFunction("EXP",3,Pos,"SYB.MATH.EXP"):Return
		EndIf		
		;**** FLOAT
		If FunNo=8008 Then
			If StkItm<>1 Then ErrMessage$="FLOAT used incorrectly":Err=120		
			If CalStack(Pos+1,0)<2 Or CalStack(Pos+1,0)>3 Then 
				ErrMessage$="FLOAT expecting number":Err=120
			Else
				;**** Number Found
				If CalStack(Pos+1,0)=2 Then  ;**** Only Do If Integer
					AddRoutine("SyB_INT_2_FLO")
					For j=CalStackNo-1 To Pos Step -1
						DelCalStack()
					Next
					AddCalStack(3)				
				EndIf	
			EndIf
			Return
		EndIf
	EndIf
	;**** PEEKFLOAT
	If FunNo=8020 Then
		If StkItm<>2 Then ErrMessage$="PEEKFLOAT used incorrectly":Err=120:Return
		CheckFunctionInput("PeekFloat",Pos,2)			;Name,Pos,Typ 
		CheckFunctionInput("PeekFloat",Pos+1,2)		;Name,Pos,Typ 
		ApplyFunction("PeekFloat",3,Pos,"SYB.APP.PEEKFLOAT")
	EndIf
	;**** RND
	If FunNo=8021 Then
		If StkItm<>1 Then ErrMessage$="RND used incorrectly":Err=120:Return
		CheckFunctionInput("RND",Pos,3)		;Name,Pos,Typ 
		ApplyFunction("RND",3,Pos,"SYB.MATH.RND")
	EndIf
	;**** NOT
	If FunNo=8022 Then
		If StkItm<>1 Then ErrMessage$="NOT used incorrectly":Err=120:Return
		CheckFunctionInput("NOT",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("NOT",2,Pos,"SYB.MATH.NOT")
	EndIf
	;**** NEG
	If FunNo=8023 Then
		If StkItm<>1 Then ErrMessage$="NEG used incorrectly":Err=120:Return
		If CalStack(Pos+1,0)<2 Or CalStack(Pos+1,0)>3 Then 
			ErrMessage$="NEG expecting number":Err=120
		Else
			;**** Number Found
			If CalStack(Pos+1,0)=3 Then
				CheckFunctionInput("NEG",Pos,3)		;Name,Pos,Typ 
				ApplyFunction("NEG_FLO",3,Pos,"SYB.MATH.NEG")
			Else
				CheckFunctionInput("NEG",Pos,2)		;Name,Pos,Typ 
				ApplyFunction("NEG_INT",2,Pos,"SYB.MATH.NEG")
			EndIf	
		EndIf
	EndIf
	;**** ABS
	If FunNo=8024 Then
		If StkItm<>1 Then ErrMessage$="ABS used incorrectly":Err=120:Return
		If CalStack(Pos+1,0)<2 Or CalStack(Pos+1,0)>3 Then 
			ErrMessage$="ABS expecting number":Err=120
		Else
			;**** Number Found
			If CalStack(Pos+1,0)=3 Then
				CheckFunctionInput("ABS",Pos,3)		;Name,Pos,Typ 
				ApplyFunction("ABS_FLO",3,Pos,"SYB.MATH.ABS")
			Else
				CheckFunctionInput("ABS",Pos,2)		;Name,Pos,Typ 
				ApplyFunction("ABS_INT",2,Pos,"SYB.MATH.ABS")
			EndIf	
		EndIf
	EndIf	
	;**** SGN
	If FunNo=8025 Then
		If StkItm<>1 Then ErrMessage$="SGN used incorrectly":Err=120:Return
		If CalStack(Pos+1,0)<2 Or CalStack(Pos+1,0)>3 Then 
			ErrMessage$="SGN expecting number":Err=120
		Else
			;**** Number Found
			If CalStack(Pos+1,0)=3 Then
				CheckFunctionInput("SGN",Pos,3)		;Name,Pos,Typ 
				ApplyFunction("SGN_FLO",3,Pos,"SYB.MATH.SGN")
			Else
				CheckFunctionInput("SGN",Pos,2)		;Name,Pos,Typ 
				ApplyFunction("SGN_INT",2,Pos,"SYB.MATH.SGN")
			EndIf	
		EndIf
	EndIf	
	
	;**** INT
	If FunNo=8100 Then
		If StkItm<>1 Then ErrMessage$="INT used incorrectly":Err=120		
		If CalStack(Pos+1,0)<2 Or CalStack(Pos+1,0)>3 Then 
			ErrMessage$="INT expecting number":Err=120
		Else
			;**** Number Found
			If CalStack(Pos+1,0)=3 Then  ;**** Only Do If Integer
				AddRoutine("SyB_FLO_2_INT_Stack_1")
				For j=CalStackNo-1 To Pos Step -1
					DelCalStack()
				Next
				AddCalStack(2)				
			EndIf	
		EndIf
	EndIf
	
	;**** DIALOG
	If FunNo=8160 Then
		If StkItm<>3 Then ErrMessage$="DIALOG used incorrectly":Err=120:Return
		CheckFunctionInput("Dialog",Pos,5)			;Name,Pos,Typ 
		CheckFunctionInput("Dialog",Pos+1,2)		;Name,Pos,Typ 
		CheckFunctionInput("Dialog",Pos+2,2)		;Name,Pos,Typ 		
		ApplyFunction("Dialog",2,Pos,"SYB.APP.DIALOG")
	EndIf
	;**** FILEPOS
	If FunNo=8161 Then
		If StkItm<>1 Then ErrMessage$="FILE.POSITION used incorrectly":Err=120:Return
		CheckFunctionInput("FilePos",Pos,2)			;Name,Pos,Typ 	
		ApplyFunction("FilePos",3,Pos,"SYB.FILE.POSITION")	
	EndIf
	;**** FILESIZE
	If FunNo=8162 Then
		If StkItm<>1 Then ErrMessage$="FILE.SIZE used incorrectly":Err=120:Return
		CheckFunctionInput("FileSize",Pos,5)			;Name,Pos,Typ 	
		ApplyFunction("FileSize",3,Pos,"SYB.FILE.SIZE")	
	EndIf	
	;**** TRIM$
	If FunNo=8208 Then
		If StkItm<>1 Then ErrMessage$="TRIM$ used incorrectly":Err=120:Return
		CheckFunctionInput("Trim",Pos,5)			;Name,Pos,Typ
		ApplyFunction("Trim",5,Pos,"SYB.STRING.TRIM")
	EndIf	
	;**** ASC
	If FunNo=8101 Then
		If StkItm<>1 Then ErrMessage$="ASC used incorrectly":Err=120:Return
		CheckFunctionInput("Asc",Pos,5)			;Name,Pos,Typ
		ApplyFunction("Asc",2,Pos,"SYB.MATH.ASC")	
	EndIf
	;**** LEN
	If FunNo=8102 Then
		If StkItm<>1 Then ErrMessage$="LEN used incorrectly":Err=120:Return
		CheckFunctionInput("Len",Pos,5)			;Name,Pos,Typ
		ApplyFunction("Len",2,Pos,"SYB.MATH.LEN")
	EndIf
	;**** FILE.OPEN
	If FunNo=8110 Then
		If StkItm<>1 Then ErrMessage$="FILE.OPEN used incorrectly":Err=120:Return
		CheckFunctionInput("OpenFile",Pos,5)			;Name,Pos,Typ
		ApplyFunction("OpenFile",2,Pos,"SYB.FILE.OPEN")		
	EndIf
	;**** READBYTE
	If FunNo=8111 Then
		If StkItm<>1 Then ErrMessage$="FILE.BYTE.READ used incorrectly":Err=120:Return
		CheckFunctionInput("ReadByte",Pos,2)			;Name,Pos,Typ
		ApplyFunction("ReadByte",2,Pos,"SYB.FILE.BYTE.READ")
	EndIf
	;**** READFLOAT
	If FunNo=8009 Then
		If StkItm<>1 Then ErrMessage$="FILE.FLOAT.READ used incorrectly":Err=120:Return
		CheckFunctionInput("ReadFloat",Pos,2)			;Name,Pos,Typ
		ApplyFunction("ReadFloat",3,Pos,"SYB.FILE.FLOAT.Read")
	EndIf
	;**** READINT
	If FunNo=8112 Then
		If StkItm<>1 Then ErrMessage$="FILE.INT.READ used incorrectly":Err=120:Return
		CheckFunctionInput("ReadInt",Pos,2)			;Name,Pos,Typ
		ApplyFunction("ReadInt",2,Pos,"SYB.FILE.INT.READ")
	EndIf	
	
	;**** READLINE
	If FunNo=8209 Then
		If StkItm<>1 Then ErrMessage$="FILE.LINE.READ$ used incorrectly":Err=120:Return
		CheckFunctionInput("ReadLine",Pos,2)			;Name,Pos,Typ
		ApplyFunction("ReadLine",5,Pos,"SYB.FILE.LINE.READ")
	EndIf	
	
	;**** EOF
	If FunNo=8113 Then
		If StkItm<>1 Then ErrMessage$="EOF used incorrectly":Err=120:Return 
		CheckFunctionInput("EOF",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("EOF",2,Pos)
	EndIf
	;**** WRITEFILE
	If FunNo=8163
		If StkItm<1 Or StkItm>2 Then ErrMessage$="FILE.WRITE used incorrectly":Err=120:Return
		If StkItm=1 Then
			CheckFunctionInput("WriteFile",Pos,5)		;Name,Pos,Typ 
			AddRoutine("SyB_Push_Null_Int")			
		EndIf
		If StkItm=2 Then
			CheckFunctionInput("WriteFile",Pos,5)		;Name,Pos,Typ
			CheckFunctionInput("WriteFile",Pos+1,2)		;Name,Pos,Typ
			;RuntimeError(ErrMessage$)
		EndIf
		ApplyFunction("WriteFile",2,Pos,"SYB.FILE.WRITE")
	EndIf	
	
	;**** UCASE
	If FunNo=8200 Then
		If StkItm<>1 Then ErrMessage$="UCASE$ used incorrectly":Err=120:Return
		CheckFunctionInput("UCase",Pos,5)		;Name,Pos,Typ 
		ApplyFunction("UCase",5,Pos,"SYB.STRING.UCASE")		
	EndIf
	;**** LCASE
	If FunNo=8201 Then
		If StkItm<>1 Then ErrMessage$="LCASE$ used incorrectly":Err=120:Return
		CheckFunctionInput("LCase",Pos,5)		;Name,Pos,Typ 
		ApplyFunction("LCase",5,Pos,"SYB.STRING.LCASE")
	EndIf
	;**** LEFT
	If FunNo=8202
		If StkItm<>2 Then ErrMessage$="LEFT$ used incorrectly":Err=120:Return
		CheckFunctionInput("Left",Pos,5)		;Name,Pos,Typ 
		CheckFunctionInput("Left",Pos+1,2)		;Name,Pos,Typ 
		ApplyFunction("Left",5,Pos,"SYB.STRING.LEFT")
	EndIf	
	;**** RIGHT
	If FunNo=8203
		If StkItm<>2 Then ErrMessage$="RIGHT$ used incorrectly":Err=120:Return
		CheckFunctionInput("Right",Pos,5)		;Name,Pos,Typ 
		CheckFunctionInput("Right",Pos+1,2)		;Name,Pos,Typ 
		ApplyFunction("Right",5,Pos,"SYB.STRING.RIGHT")
	EndIf
	;**** MID
	If FunNo=8204
		If StkItm<>3 Then ErrMessage$="MID$ used incorrectly":Err=120:Return
		CheckFunctionInput("Mid",Pos,5)			;Name,Pos,Typ 
		CheckFunctionInput("Mid",Pos+1,2)		;Name,Pos,Typ 
		CheckFunctionInput("Mid",Pos+2,2)		;Name,Pos,Typ 		
		ApplyFunction("Mid",5,Pos,"SYB.STRING.MID")
	EndIf
	;**** OPENDIALOG
	If FunNo=8210
		If StkItm<2 Or StkItm>3 Then ErrMessage$="OPENDIALOG$ used incorrectly":Err=120:Return
		If StkItm=3 Then 
			CheckFunctionInput("OpenDialog",Pos,5)			;Name,Pos,Typ 
			CheckFunctionInput("OpenDialog",Pos+1,5)		;Name,Pos,Typ 
			CheckFunctionInput("OpenDialog",Pos+2,2)		;Name,Pos,Typ 		
		Else
			CheckFunctionInput("OpenDialog",Pos,5)			;Name,Pos,Typ
			CheckFunctionInput("OpenDialog",Pos+1,5)		;Name,Pos,Typ			
			AddRoutine("SyB_Push_Null_Int")
		EndIf
		ApplyFunction("OpenDialog",5,Pos,"SYB.FILE.DIALOG")
	EndIf
	;**** SAVEDIALOG
	If FunNo=8211
		If StkItm<2 Or StkItm>3 Then ErrMessage$="SAVEDIALOG$ used incorrectly":Err=120:Return
		If StkItm=3 Then 
			CheckFunctionInput("SaveDialog",Pos,5)			;Name,Pos,Typ 
			CheckFunctionInput("SaveDialog",Pos+1,5)		;Name,Pos,Typ 
			CheckFunctionInput("SaveDialog",Pos+2,2)		;Name,Pos,Typ 		
		Else
			CheckFunctionInput("SaveDialog",Pos,5)			;Name,Pos,Typ
			CheckFunctionInput("SaveDialog",Pos+1,5)		;Name,Pos,Typ			
			AddRoutine("SyB_Push_Null_Int","SYB.FILE.DIALOG")
		EndIf
		ApplyFunction("SaveDialog",5,Pos)
	EndIf
	;**** DIRDIALOG
	If FunNo=8212
		If StkItm<2 Or StkItm>3 Then ErrMessage$="DIRDIALOG$ used incorrectly":Err=120:Return
		If StkItm=3 Then 
			CheckFunctionInput("DirDialog",Pos,5)			;Name,Pos,Typ 
			CheckFunctionInput("DirDialog",Pos+1,5)		;Name,Pos,Typ 
			CheckFunctionInput("DirDialog",Pos+2,2)		;Name,Pos,Typ 		
		Else
			CheckFunctionInput("DirDialog",Pos,5)			;Name,Pos,Typ
			CheckFunctionInput("DirDialog",Pos+1,5)		;Name,Pos,Typ			
			AddRoutine("SyB_Push_Null_Int","SYB.FILE.DIALOG")
		EndIf
		ApplyFunction("DirDialog",5,Pos)
	EndIf
	;**** CHR
	If FunNo=8205
		If StkItm<>1 Then ErrMessage$="CHR$ used incorrectly":Err=120:Return
		CheckFunctionInput("Chr",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("Chr",5,Pos,"SYB.STRING.CHR")
	EndIf
	;**** STR
	If FunNo=8207
		If StkItm<>1 Then ErrMessage$="STR$ used incorrectly":Err=120:Return
		CheckFunctionInput("Str",Pos,3)		;Name,Pos,Typ 
		ApplyFunction("Str",5,Pos,"SYB.STRING.STR")
	EndIf	
	;**** MACHINE
	If FunNo=8114 Then
		If StkItm>0 Then ErrMessage$="MACHINE used incorrectly":Err=120:Return
		ApplyFunction("Machine",2,Pos,"SYB.SYS.MACHINE")		
	EndIf
	;**** COLOURDEPTH
	If FunNo=8115 Then
		If StkItm>0 Then ErrMessage$="COLOURDEPTH used incorrectly":Err=120:Return
		ApplyFunction("ColourDepth",2,Pos,"SYB.SYB.COLOURDEPTH")
	EndIf
	;**** SCREENMODE
	If FunNo=8116 Then
		If StkItm>0 Then ErrMessage$="SCREENMODE used incorrectly":Err=120:Return
		ApplyFunction("ScreenMode",2,Pos,"SYB.SYS.SCREENMODE")
	EndIf
	;**** RESOLUTIONX
	If FunNo=8117 Then
		If StkItm>0 Then ErrMessage$="RESOLUTIONX used incorrectly":Err=120:Return
		ApplyFunction("ResolutionX",2,Pos,"SYB_SYS_RESOLUTION")
	EndIf	
	;**** RESOLUTIONY
	If FunNo=8118 Then
		If StkItm>0 Then ErrMessage$="RESOLUTIONY used incorrectly":Err=120:Return
		ApplyFunction("ResolutionY",2,Pos,"SYB_SYS_RESOLUTION")
	EndIf	
	;**** MOUSEX
	If FunNo=8119 Then
		If StkItm>0 Then ErrMessage$="MOUSEX used incorrectly":Err=120:Return
		ApplyFunction("MouseX",2,Pos,"SYB.MOUSE.X")
	EndIf	
	;**** MOUSEY
	If FunNo=8120 Then
		If StkItm>0 Then ErrMessage$="MOUSEY used incorrectly":Err=120:Return
		ApplyFunction("MouseY",2,Pos,"SYB.MOUSE.Y")
	EndIf
	;**** MOUSEKEY
	If FunNo=8140 Then
		If StkItm>0 Then ErrMessage$="MOUSEKEY used incorrectly":Err=120:Return
		ApplyFunction("MouseKey",2,Pos,"SYB.MOUSE.KEY")
	EndIf
	;**** RAMSIZE
	If FunNo=8133 Then
		If StkItm>0 Then ErrMessage$="RAMSIZE used incorrectly":Err=120:Return
		ApplyFunction("RamSize",2,Pos,"SYB.SYS.RAMSIZE")
	EndIf
	;**** RAMFREE
	If FunNo=8134 Then
		If StkItm>0 Then ErrMessage$="RAMFREE used incorrectly":Err=120:Return
		ApplyFunction("RamFree",2,Pos,"SYB.SYS.RAMFREE")
	EndIf
	;**** SECOND
	If FunNo=8121 Then
		If StkItm<>0 Then ErrMessage$="GETSECOND used incorrectly":Err=120:Return
		ApplyFunction("GetSecond",2,Pos,"SYB.TIME.SECOND")
	EndIf	
	;**** MINUTE
	If FunNo=8122 Then
		If StkItm<>0 Then ErrMessage$="GETMINUTE used incorrectly":Err=120:Return
		ApplyFunction("GetMinute",2,Pos,"SYB.TIME.MINUTE")
	EndIf
	;**** HOUR
	If FunNo=8123 Then
		If StkItm<>0 Then ErrMessage$="GETHOUR used incorrectly":Err=120:Return
		ApplyFunction("GetHour",2,Pos,"SYB.TIME.HOUR")
	EndIf	
	;**** DAY
	If FunNo=8124 Then
		If StkItm<>0 Then ErrMessage$="GETDAY used incorrectly":Err=120:Return
		ApplyFunction("GetDay",2,Pos,"SYB.TIME.DAY")
	EndIf	
	;**** MONTH
	If FunNo=8125 Then
		If StkItm<>0 Then ErrMessage$="GETMONTH used incorrectly":Err=120:Return
		ApplyFunction("GetMonth",2,Pos,"SYB.TIME.MONTH")
	EndIf
	;**** YEAR
	If FunNo=8126 Then
		If StkItm<>0 Then ErrMessage$="GETYEAR used incorrectly":Err=120:Return
		ApplyFunction("GetYear",2,Pos,"SYB.TIME.YEAR")
	EndIf
	;;**** TIMEZONE
	;If FunNo=8127 Then
	;	If StkItm<>0 Then ErrMessage$="GetTimeZone used incorrectly":Err=120:Return
	;	ApplyFunction("GetTimeZone",2,Pos)
	;EndIf	
	
	;**** CREATEBANK
	If FunNo=8128 Then
		If StkItm<>1 Then ErrMessage$="CREATEBANK used incorrectly":Err=120:Return
		CheckFunctionInput("CreateBank",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("CreateBank",2,Pos,"SYB.APP.CREATEBANK")
	EndIf
	;**** BANKSIZE
	If FunNo=8129 Then
		If StkItm<>1 Then ErrMessage$="BANKSIZE used incorrectly":Err=120:Return
		CheckFunctionInput("BankSize",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("BankSize",2,Pos,"SYB.APP.BANKSIZE")
	EndIf
	;**** KEY
	If FunNo=8164 Then
		If StkItm<>1 Then ErrMessage$="KEY used incorrectly":Err=120:Return
		CheckFunctionInput("Key",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("Key",2,Pos,"SYB.SYS.KEY")
	EndIf
	;**** KEYSTATUS
	If FunNo=8165 Then
		If StkItm<>0 Then ErrMessage$="KEYSTATUS used incorrectly":Err=120:Return
		ApplyFunction("KeyStatus",2,Pos,"SYB.SYS.KEYSTATUS")
	EndIf
	;**** EXECUTE
	If FunNo=8166 Then
		If StkItm<>1 Then ErrMessage$="EXECUTE used incorrectly":Err=120:Return
		CheckFunctionInput("Execute",Pos,5)		;Name,Pos,Typ 
		ApplyFunction("Execute",2,Pos,"SYB.APP.EXECUTE")
	EndIf
	;**** GETPAINTOBJPEN 
	If FunNo=8167 Then
		If StkItm<>1 Then ErrMessage$="GETPAINTOBJPEN used incorrectly":Err=120:Return
		CheckFunctionInput("GetPaintObjPen",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetPaintObjPen",2,Pos,"SYB.CONTROL.PAINT.PEN")
	EndIf
	;**** FILEEXIST
	If FunNo=8168 Then
		If StkItm<>1 Then ErrMessage$="FILE.EXIST used incorrectly":Err=120:Return
		CheckFunctionInput("FileExist",Pos,5)		;Name,Pos,Typ 
		ApplyFunction("FileExist",2,Pos,"SYB.FILE.EXIST")
	EndIf
	;**** CREATEDIR
	If FunNo=8169 Then
		If StkItm<>1 Then ErrMessage$="CREATEDIR used incorrectly":Err=120:Return
		CheckFunctionInput("CreateDir",Pos,5)		;Name,Pos,Typ 
		ApplyFunction("CreateDir",2,Pos)
	EndIf
	;**** DELETEDIR
	If FunNo=8170 Then
		If StkItm<>1 Then ErrMessage$="DELETEDIR used incorrectly":Err=120:Return
		CheckFunctionInput("DeleteDir",Pos,5)		;Name,Pos,Typ 
		ApplyFunction("DeleteDir",2,Pos)
	EndIf
	;**** RENAMEDIR
	If FunNo=8171 Then
		If StkItm<>1 Then ErrMessage$="RENAMEDIR used incorrectly":Err=120:Return
		CheckFunctionInput("RenameDir",Pos,5)		;Name,Pos,Typ 
		ApplyFunction("RenameDir",2,Pos)
	EndIf
	;**** PEEKBYTE
	If FunNo=8131 Then
		If StkItm<>2 Then ErrMessage$="PEEKBYTE used incorrectly":Err=120:Return
		CheckFunctionInput("PeekByte",Pos,2)			;Name,Pos,Typ 
		CheckFunctionInput("PeekByte",Pos+1,2)			;Name,Pos,Typ 		
		ApplyFunction("PeekByte",2,Pos,"SYB.APP.PEEKBYTE")
	EndIf
	;**** PEEKINT
	If FunNo=8132 Then
		If StkItm<>2 Then ErrMessage$="PEEKINT used incorrectly":Err=120:Return
		CheckFunctionInput("PeekInt",Pos,2)			;Name,Pos,Typ 
		CheckFunctionInput("PeekInt",Pos+1,2)		;Name,Pos,Typ 		
		ApplyFunction("PeekInt",2,Pos,"SYB.APP.PEEKINT")
	EndIf
	;**** GETOBJLEFT
	If FunNo=8135 Then
		If StkItm<>1 Then ErrMessage$="GETOBJLEFT used incorrectly":Err=120:Return
		CheckFunctionInput("GetObjLeft",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetObjLeft",2,Pos,"SYB.OBJ.LEFT")
	EndIf	
	;**** GETOBJHEIGHT
	If FunNo=8136 Then
		If StkItm<>1 Then ErrMessage$="GETOBJHEIGHT used incorrectly":Err=120:Return
		CheckFunctionInput("GetObjHeight",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetObjHeight",2,Pos,"SYB.OBJ.HEIGHT")
	EndIf
	;**** GETOBJWIDTH
	If FunNo=8137 Then
		If StkItm<>1 Then ErrMessage$="GETOBJWIDTH used incorrectly":Err=120:Return
		CheckFunctionInput("GetObjWidth",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetObjWidth",2,Pos,"SYB.OBJ.WIDTH")
	EndIf		
	;**** GETOBJVISIBLE / CONTROL.VISIBLE
	If FunNo=8138 Then
		If StkItm<>1 Then ErrMessage$="GETOBJVISIBLE used incorrectly":Err=120:Return
		CheckFunctionInput("GetObjVisible",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetObjVisible",2,Pos,"SYB.OBJ.VISIBLE")
	EndIf	
	;**** GETOBJTOP
	If FunNo=8139 Then
		If StkItm<>1 Then ErrMessage$="GETOBJTOP used incorrectly":Err=120:Return
		CheckFunctionInput("GetObjTop",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetObjTop",2,Pos,"SYB.OBJ.TOP")
	EndIf
	;**** GETOBJTEXT
	If FunNo=8141 Then
		If StkItm<>1 Then ErrMessage$="GETOBJTEXT$ used incorrectly":Err=120:Return
		CheckFunctionInput("GetObjText",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetObjText",5,Pos,"SYB.CONTROL.TEXT")
	EndIf
	;**** OPENFORM
	If FunNo=8142 Then
		If StkItm<>1 Then ErrMessage$="OPENFORM used incorrectly":Err=120:Return
		CheckFunctionInput("OpenForm",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("OpenForm",2,Pos)
	EndIf
	;**** MOUSEOVER
	If FunNo=8143 Then
		If StkItm<>1 Then ErrMessage$="MOUSEOVER used incorrectly":Err=120:Return
		CheckFunctionInput("MouseOver",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("MouseOver",2,Pos)
	EndIf
	;**** GETOBJID
	If FunNo=8144 Then
		If StkItm<>2 Then ErrMessage$="GETOBJID used incorrectly":Err=120:Return
		CheckFunctionInput("GetObjId",Pos,2)		;Name,Pos,Typ 
		CheckFunctionInput("GetObjId",Pos+1,2)		;Name,Pos,Typ 		
		ApplyFunction("GetObjId",2,Pos,"SYB.CONTROL.ID")
	EndIf
	;**** LOADSHEET
	If FunNo=8145 Then
		If StkItm<>1 Then ErrMessage$="LOADSHEET used incorrectly":Err=120:Return
		CheckFunctionInput("LoadSheet",Pos,5)		;Name,Pos,Typ
		ApplyFunction("LoadSheet",2,Pos,"SYB.APP.LOADSHEET")
	EndIf
	;**** GETIMGTILE
	If FunNo=8174 Then
		If StkItm<>1 Then ErrMessage$="CONTROL.IMAGE.TILE used incorrectly":Err=120:Return
		CheckFunctionInput("GetImageTile",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetImageTile",2,Pos,"SYB.CONTROL.GETIMAGETILE")		
	EndIf
	;**** GETIMGSHEET
	If FunNo=8175 Then
		If StkItm<>1 Then ErrMessage$="CONTROL.IMAGE.SHEET used incorrectly":Err=120:Return
		CheckFunctionInput("GetImageSheet",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetImageSheet",2,Pos,"SYB.CONTROL.GETIMAGETILE")		
	EndIf
	;**** GETIMGWIDTHBYTE
	If FunNo=8176 Then
		If StkItm<>1 Then ErrMessage$="CONTROL.IMAGE.WIDTHBYTE used incorrectly":Err=120:Return
		CheckFunctionInput("GetImageWidthByte",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetImageWidthByte",2,Pos,"SYB.CONTROL.GETIMAGETILE")		
	EndIf
	;**** GETIMGWIDTH
	If FunNo=8177 Then
		If StkItm<>1 Then ErrMessage$="CONTROL.IMAGE.WIDTH used incorrectly":Err=120:Return
		CheckFunctionInput("GetImageWidth",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetImageWidth",2,Pos,"SYB.CONTROL.GETIMAGETILE")		
	EndIf
	;**** GETIMGHEIGHT
	If FunNo=8178 Then
		If StkItm<>1 Then ErrMessage$="CONTROL.IMAGE.HEIGHT used incorrectly":Err=120:Return
		CheckFunctionInput("GetImageHeight",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetImageHeight",2,Pos,"SYB.CONTROL.GETIMAGETILE")		
	EndIf
	;**** GETIMGENCODE
	If FunNo=8179 Then
		If StkItm<>1 Then ErrMessage$="CONTROL.IMAGE.ENCODE used incorrectly":Err=120:Return
		CheckFunctionInput("GetImageEncode",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetImageEncode",2,Pos,"SYB.CONTROL.GETIMAGETILE")		
	EndIf
	;**** GETIMGSIZE
	If FunNo=8180 Then
		If StkItm<>1 Then ErrMessage$="CONTROL.IMAGE.SIZE used incorrectly":Err=120:Return
		CheckFunctionInput("GetImageSize",Pos,2)		;Name,Pos,Typ 
		ApplyFunction("GetImageSize",2,Pos,"SYB.CONTROL.GETIMAGETILE")		
	EndIf		
	;**** EVENTCONTROL
	If FunNo=8181 Then
		If StkItm>0 Then ErrMessage$="EVENT.CONTROL used incorrectly":Err=120:Return
		ApplyFunction("Event_Control",2,Pos,"SYB.EVENT.CONTROL")
	EndIf
	;**** EVENTTOOL
	If FunNo=8182 Then
		If StkItm>0 Then ErrMessage$="EVENT.TOOL used incorrectly":Err=120:Return
		ApplyFunction("Event_Control",2,Pos,"SYB.EVENT.CONTROL")
	EndIf
	;**** EVENTTOOL
	If FunNo=8183 Then
		If StkItm>0 Then ErrMessage$="EVENT.FORM used incorrectly":Err=120:Return
		ApplyFunction("Event_Form",2,Pos,"SYB.EVENT.FORM")
	EndIf
	;**** EVENTDISPLAY
	If FunNo=8184 Then
		If StkItm>0 Then ErrMessage$="EVENT.DISPLAY used incorrectly":Err=120:Return
		ApplyFunction("Event_Display",2,Pos,"SYB.EVENT.DISPLAY")
	EndIf
	;**** ERROR
	If FunNo=8185 Then
		If StkItm>0 Then ErrMessage$="ERROR used incorrectly":Err=120:Return
		ApplyFunction("Error",2,Pos,"SYB.ERROR")
	EndIf
	;**** ERROR.TYPE
	If FunNo=8186 Then
		If StkItm>0 Then ErrMessage$="EVENT.TYPE used incorrectly":Err=120:Return
		ApplyFunction("Error_Type",2,Pos,"SYB.ERROR")
	EndIf
	
End Function
Function IsFunction#(Srq$)
	ReqBrack=0
	Srq$=Upper$(Srq$)
	;**** Float Results
	;*** MATH SIN
	If Srq$="SIN"Then Succeed=True:Return 8000
	If Srq$="MATH.SIN"Then Succeed=True:Return 8000
	;*** MATH COS
	If Srq$="COS"Then Succeed=True:Return 8001
	If Srq$="MATH.COS"Then Succeed=True:Return 8001
	;*** MATH TAN
	If Srq$="TAN"Then Succeed=True:Return 8002
	If Srq$="MATH.TAN"Then Succeed=True:Return 8002
	;*** MATH SQR
	If Srq$="SQR"Then Succeed=True:Return 8003	
	If Srq$="MATH.SQR"Then Succeed=True:Return 8003
	;*** MATH LOG
	If Srq$="LOG"Then Succeed=True:Return 8004
	If Srq$="MATH.LOG"Then Succeed=True:Return 8004
	;*** MATH LOG10
	If Srq$="LOG10"Then Succeed=True:Return 8005
	If Srq$="MATH.LOG10"Then Succeed=True:Return 8005
	;*** MATH ATAN
	If Srq$="ATAN"Then Succeed=True:Return 8006
	If Srq$="MATH.ATAN"Then Succeed=True:Return 8006
	;*** MATH EXP
	If Srq$="EXP"Then Succeed=True:Return 8007	
	If Srq$="MATH.EXP"Then Succeed=True:Return 8007		
	;*** MATH FLOAT
	If Srq$="FLOAT"Then Succeed=True:Return 8008
	If Srq$="MATH.FLOAT"Then Succeed=True:Return 8008
	;*** FILE FLOAT READ
	If Srq$="FILE.FLOAT.READ"Then Succeed=True:Return 8009	;To Do
	If Srq$="READFLOAT"Then Succeed=True:Return 8009	;To Do
	
	
	
	;*** MATH APP.PEEKFLOAT
	If Srq$="PEEKFLOAT"Then Succeed=True:Return 8020
	If Srq$="APP.PEEKFLOAT"Then Succeed=True:Return 8020
	;*** MARTH RND
	If Srq$="RND"Then Succeed=True:Return 8021
	If Srq$="MATH.RND"Then Succeed=True:Return 8021		
	;*** MATH NOT
	If Srq$="NOT"Then Succeed=True:Return 8022
	If Srq$="MATH.NOT"Then Succeed=True:Return 8022
	;*** MATH NEG
	If Srq$="NEG"Then Succeed=True:Return 8023
	If Srq$="MATH.NEG"Then Succeed=True:Return 8023
	;*** MATH ABS
	If Srq$="ABS"Then Succeed=True:Return 8024
	If Srq$="MATH.ABS"Then Succeed=True:Return 8024
	;*** MATH SGN
	If Srq$="SGN"Then Succeed=True:Return 8025
	If Srq$="MATH.SGN"Then Succeed=True:Return 8025
	;**** Integer Results
	If Srq$="INT"Then Succeed=True:Return 8100
	;**** MATH.ASC
	If Srq$="ASC"Then Succeed=True:Return 8101
	If Srq$="MATH.ASC"Then Succeed=True:Return 8101
	
	If Srq$="LEN"Then Succeed=True:Return 8102
	;*** FILE.OPEN
	If Srq$="FILE.OPEN"Then Succeed=True:Return 8110
	;*** FILE.WRITE
	If Srq$="FILE.WRITE"Then Succeed=True:Return 8163
	;*** FILE.BYTE.READ
	If Srq$="FILE.BYTE.READ"Then Succeed=True:Return 8111		;To Do
	If Srq$="READBYTE"Then Succeed=True:Return 8111		;To Do
	;*** FILE.INT.READ
	If Srq$="FILE.INT.READ"Then Succeed=True:Return 8112		;To Do
	If Srq$="READINT"Then Succeed=True:Return 8112		;To Do
	If Srq$="EOF"Then Succeed=True:Return 8113
	;*** SYS MACHINE
	If Srq$="MACHINE"Then Succeed=True:ReqBrack=1:Return 8114		
	If Srq$="SYS.MACHINE"Then Succeed=True:ReqBrack=1:Return 8114
	;*** SYS COLOURDEPTH
	If Srq$="COLOURDEPTH"Then Succeed=True:ReqBrack=1:Return 8115
	If Srq$="SYS.COLOURDEPTH"Then Succeed=True:ReqBrack=1:Return 8115
	;*** SYS SCREENMODE
	If Srq$="SCREENMODE"Then Succeed=True:ReqBrack=1:Return 8116
	If Srq$="SYS.SCREENMODE"Then Succeed=True:ReqBrack=1:Return 8116
	;*** SYS RESOLUTION X
	If Srq$="RESOLUTIONX"Then Succeed=True:ReqBrack=1:Return 8117
	If Srq$="SYS.RESOLUTIONX"Then Succeed=True:ReqBrack=1:Return 8117
	;*** SYS RESOLUTION Y
	If Srq$="RESOLUTIONY"Then Succeed=True:ReqBrack=1:Return 8118
	If Srq$="SYS.RESOLUTIONY"Then Succeed=True:ReqBrack=1:Return 8118
	;*** MOUSE X
	If Srq$="MOUSEX"Then Succeed=True:ReqBrack=1:Return 8119
	If Srq$="MOUSE.X"Then Succeed=True:ReqBrack=1:Return 8119
	;*** MOUSE Y
	If Srq$="MOUSEY"Then Succeed=True:ReqBrack=1:Return 8120
	If Srq$="MOUSE.Y"Then Succeed=True:ReqBrack=1:Return 8120
	;*** TIME SECOND
	If Srq$="GETSECOND"Then Succeed=True:ReqBrack=1:Return 8121
	If Srq$="TIME.SECOND"Then Succeed=True:ReqBrack=1:Return 8121
	;*** TIME MINUTE
	If Srq$="GETMINUTE"Then Succeed=True:ReqBrack=1:Return 8122
	If Srq$="TIME.MINUTE"Then Succeed=True:ReqBrack=1:Return 8122
	;*** TIME HOUR
	If Srq$="GETHOUR"Then Succeed=True:ReqBrack=1:Return 8123
	If Srq$="TIME.HOUR"Then Succeed=True:ReqBrack=1:Return 8123
	;*** TIME DAY
	If Srq$="GETDAY"Then Succeed=True:ReqBrack=1:Return 8124
	If Srq$="TIME.DAY"Then Succeed=True:ReqBrack=1:Return 8124
	;*** TIME MONTH
	If Srq$="GETMONTH"Then Succeed=True:ReqBrack=1:Return 8125
	If Srq$="TIME.MONTH"Then Succeed=True:ReqBrack=1:Return 8125	
	;*** TIME YEAR
	If Srq$="GETYEAR"Then Succeed=True:ReqBrack=1:Return 8126
	If Srq$="TIME.YEAR"Then Succeed=True:ReqBrack=1:Return 8126
	
	If Srq$="GETTIMEZONE"Then Succeed=True:Return 8127
	
	;*** APP CREATEBANK
	If Srq$="APP.BANK.CREATE"Then Succeed=True:Return 8128
	If Srq$="CREATEBANK"Then Succeed=True:Return 8128
	;*** APP BANKSIZE
	If Srq$="BANKSIZE"Then Succeed=True:Return 8129
	If Srq$="APP.BANK.SIZE"Then Succeed=True:Return 8129
	;*** APP PEEKBYTE
	If Srq$="PEEKBYTE"Then Succeed=True:Return 8131
	If Srq$="APP.PEEK.BYTE"Then Succeed=True:Return 8131
	;*** APP PEEKINT
	If Srq$="PEEKINT"Then Succeed=True:Return 8132
	If Srq$="APP.PEEK.INT"Then Succeed=True:Return 8132	
	;*** SYS RAMSIZE
	If Srq$="RAMSIZE"Then Succeed=True:Return 8133
	If Srq$="SYSTEM.RAM.SIZE"Then Succeed=True:Return 8133
	;*** SYS RAMFREE
	If Srq$="RAMFREE"Then Succeed=True:Return 8134
	If Srq$="SYSTEM.RAM.FREE"Then Succeed=True:Return 8134	
	;*** OBJ LEFT
	If Srq$="GETOBJLEFT"Then Succeed=True:Return 8135
	If Srq$="CONTROL.LEFT"Then Succeed=True:Return 8135	
	;*** OBJ HEIGHT
	If Srq$="GETOBJHEIGHT"Then Succeed=True:Return 8136
	If Srq$="CONTROL.HEIGHT"Then Succeed=True:Return 8136
	;*** OBJ WIDTH
	If Srq$="GETOBJWIDTH"Then Succeed=True:Return 8137
	If Srq$="CONTROL.WIDTH"Then Succeed=True:Return 8137
	;*** VISIBLE
	If Srq$="GETOBJVISIBLE"Then Succeed=True:Return 8138
	If Srq$="CONTROL.VISIBLE"Then Succeed=True:Return 8138
	;*** OBJ TOP
	If Srq$="GETOBJTOP"Then Succeed=True:Return 8139
	If Srq$="CONTROL.TOP"Then Succeed=True:Return 8139
	;*** MOUSE KEY
	If Srq$="MOUSEKEY"Then Succeed=True:Return 8140
	If Srq$="MOUSE.KEY"Then Succeed=True:Return 8140	
	;*** CONTROL TEXT
	If Srq$="GETOBJTEXT"Then Succeed=True:Return 8141
	If Srq$="CONTROL.TEXT"Then Succeed=True:Return 8141
	
	If Srq$="OPENFORM"Then Succeed=True:Return 8142	
	If Srq$="MOUSEOVER"Then Succeed=True:Return 8143
	;*** CONTROL OBJID
	If Srq$="GETOBJID"Then Succeed=True:Return 8144
	If Srq$="CONTROL.ID"Then Succeed=True:Return 8144
	;*** APP LOADSHEET
	If Srq$="LOADSHEET"Then Succeed=True:Return 8145
	If Srq$="APP.SHEET.LOAD"Then Succeed=True:Return 8145
	;*** APP.DIALOG
	If Srq$="DIALOG"Then Succeed=True:Return 8160
	If Srq$="APP.DIALOG"Then Succeed=True:Return 8160
	;*** FILE.POSITION
	If Srq$="FILE.POSITION"Then Succeed=True:Return 8161
	;*** FILE.SIZE
	If Srq$="FILE.SIZE"Then Succeed=True:Return 8162
	If Srq$="FILESIZE"Then Succeed=True:Return 8162
	
	;*** SYS KEY
	If Srq$="KEY"Then Succeed=True:Return 8164
	If Srq$="SYS.KEY"Then Succeed=True:Return 8164
	;*** SYS KEYSTATUS
	If Srq$="KEYSTATUS"Then Succeed=True:Return 8165
	If Srq$="SYS.KEYSTATUS"Then Succeed=True:Return 8165
	;*** APP EXECUTE
	If Srq$="EXECUTE"Then Succeed=True:Return 8166
	If Srq$="APP.EXECUTE"Then Succeed=True:Return 8166
	;*** OBJ PAINT PEN
	If Srq$="GETPAINTOBJPEN"Then Succeed=True:Return 8167
	If Srq$="CONTROL.PAINT.PEN"Then Succeed=True:Return 8167
	;*** FILE.EXIST
	If Srq$="FILEEXIST"Then Succeed=True:Return 8168
	If Srq$="FILE.EXIST"Then Succeed=True:Return 8168
	If Srq$="FILE.ATTRIBUTE"Then Succeed=True:Return 8168
	If Srq$="DIRECTORY.EXIST"Then Succeed=True:Return 8168
	If Srq$="DIRECTORY.ATTRIBUTE"Then Succeed=True:Return 8168	
	
	If Srq$="CREATEDIR"Then Succeed=True:Return 8169
	If Srq$="DELETEDIR"Then Succeed=True:Return 8170
	If Srq$="RENAMEDIR"Then Succeed=True:Return 8171
	If Srq$="DELETEFILE"Then Succeed=True:Return 8172
	If Srq$="RENAMEFILE"Then Succeed=True:Return 8173	
	
	;*** OBJ IMAGE TILE
	If Srq$="GETIMAGEOBJTILE"Then Succeed=True:Return 8174
	If Srq$="CONTROL.IMAGE.TILE"Then Succeed=True:Return 8174
	;*** OBJ IMAGE SHEET
	If Srq$="GETIMAGEOBJSHEET"Then Succeed=True:Return 8175
	If Srq$="CONTROL.IMAGE.SHEET"Then Succeed=True:Return 8175
	;*** OBJ IMAGE WIDTHBYTE
	If Srq$="GETIMAGEOBJWIDTHBYTE"Then Succeed=True:Return 8176
	If Srq$="CONTROL.IMAGE.WIDTHBYTE"Then Succeed=True:Return 8176
	;*** OBJ IMAGE WIDTH
	If Srq$="GETIMAGEOBJWIDTH"Then Succeed=True:Return 8177
	If Srq$="CONTROL.IMAGE.WIDTH"Then Succeed=True:Return 8177	
	;*** OBJ IMAGE HEIGHT
	If Srq$="GETIMAGEOBJHEIGHT"Then Succeed=True:Return 8178
	If Srq$="CONTROL.IMAGE.HEIGHT"Then Succeed=True:Return 8178	
	;*** OBJ IMAGE ENCODE
	If Srq$="GETIMAGEOBJENCODE"Then Succeed=True:Return 8179
	If Srq$="CONTROL.IMAGE.ENCODE"Then Succeed=True:Return 8179
	;*** OBJ IMAGE ENCODE
	If Srq$="GETIMAGEOBJSIZE"Then Succeed=True:Return 8180
	If Srq$="CONTROL.IMAGE.SIZE"Then Succeed=True:Return 8180
	;*** OBJ EVENT CONTROL
	If Srq$="EVENT.CONTROL"Then Succeed=True:ReqBrack=1:Return 8181
	;*** OBJ EVENT TOOL
	If Srq$="EVENT.TOOL"Then Succeed=True:ReqBrack=1:Return 8182
	;*** OBJ EVENT FORM
	If Srq$="EVENT.FORM"Then Succeed=True:ReqBrack=1:Return 8183
	;*** OBJ EVENT DISPLAY
	If Srq$="EVENT.DISPLAY"Then Succeed=True:ReqBrack=1:Return 8184
	;*** APP ERROR.TYPE
	If Srq$="ERROR"Then Succeed=True:ReqBrack=1:Return 8185
	;*** APP ERROR
	If Srq$="ERROR.TYPE"Then Succeed=True:ReqBrack=1:Return 8186
	
	
	;**** String Results
	;*** STRING UCASE
	If Srq$="UCASE"Then Succeed=True:Return 8200
	If Srq$="STRING.UCASE"Then Succeed=True:Return 8200
	;*** STRING LCASE
	If Srq$="LCASE"Then Succeed=True:Return 8201
	If Srq$="STRING.LCASE"Then Succeed=True:Return 8201
	;*** STRING LEFT
	If Srq$="LEFT"Then Succeed=True:Return 8202
	If Srq$="STRING.LEFT"Then Succeed=True:Return 8202
	;*** STRING RIGHT
	If Srq$="RIGHT"Then Succeed=True:Return 8203
	If Srq$="STRING.RIGHT"Then Succeed=True:Return 8203
	;*** STRING MID
	If Srq$="MID"Then Succeed=True:Return 8204
	If Srq$="STRING.MID"Then Succeed=True:Return 8204
	;*** STRING CHR
	If Srq$="CHR"Then Succeed=True:Return 8205
	If Srq$="STRING.CHR"Then Succeed=True:Return 8205
	
	If Srq$="READSTRING"Then Succeed=True:Return 8206	;To Do
	;*** STRING STR
	If Srq$="STR"Then Succeed=True:Return 8207
	If Srq$="STRING.STR"Then Succeed=True:Return 8207
	;*** STRING TRIM
	If Srq$="TRIM"Then Succeed=True:Return 8208
	If Srq$="STRING.TRIM"Then Succeed=True:Return 8208
	;*** FILE READ LINE
	If Srq$="FILE.LINE.READ"Then Succeed=True:Return 8209	;To Do
	If Srq$="READLINE"Then Succeed=True:Return 8209	;To Do
	;*** FILE OPEN DIALOG
	If Srq$="OPENDIALOG"Then Succeed=True:Return 8210
	If Srq$="FILE.DIALOG.OPEN"Then Succeed=True:Return 8210
	;*** FILE CLOSE DIALOG
	If Srq$="SAVEDIALOG"Then Succeed=True:Return 8211
	If Srq$="FILE.DIALOG.SAVE"Then Succeed=True:Return 8211
	;*** DIRECTORY DIALOG
	If Srq$="DIRDIALOG"Then Succeed=True:Return 8212
	If Srq$="DIRECTORY.DIALOG"Then Succeed=True:Return 8212	
	
	If Len(Srq$)>0 Then
		For f=1 To FuncNo
			If Upper$(Func$(f))=Srq$ Then
				Succeed=True
				Return f
			EndIf
		Next
	EndIf
	Succeed=False
	Return 0
End Function
Function CheckFunctionInput(ss$,NPos,Ty)
	If CalStack(NPos+1,0)=5 And Ty<5 Then
		ErrMessage$=ss$+" expecting number value":Err=120
		Return
	EndIf
	If CalStack(NPos+1,0)<5 And Ty>4 Then
		ErrMessage$=ss$+" expecting string":Err=120
		Return
	EndIf	
	If CalStack(NPos+1,0)=3 And Ty=2 Then  ;**** Only Do If Integer
		AddRoutine("SyB_FLO_2_INT_Stack_1")
	EndIf	
	If CalStack(NPos+1,0)=2 And Ty=3 Then  ;**** Only Do If Integer
		AddRoutine("SyB_INT_2_FLO")
	EndIf
End Function
Function ApplyFunction(ss$,Ty,Pos,e$="")
	AddRoutine("SyB_"+ss$,e$)
	For j=CalStackNo-1 To Pos Step -1
		DelCalStack()
	Next
	AddCalStack(Ty)
End Function
Function ConvertFraction$(Res#,IsNeg=0)
	br$=""
	n=0
	Treg=Floor(Res#)
	Keg#=Float(Res#-Treg)
	While Keg#>0 Or n>24
		Keg#=Keg#*2
		Treg=Floor(Keg#)
		Keg#=Float(Keg#-Treg)
		If Treg>0 Then
			Br$=br$+"1"
		Else
			Br$=br$+"0"
		EndIf
		n=n+1
	Wend
	
	br1$=""
	n1=0
	j=1
	Treg=Floor(Res#)
	While Treg>0
		If treg And 1 Then
			Br1$="1"+br1$
		Else
			Br1$="0"+br1$
		EndIf
		Treg=Treg Shr 1
		n1=n1+1
	Wend
	
	
	br$=Mid$(br1$+br$+"000000000000000000000000000000000000",2,31)
	If IsNeg=0 Then 
		br$="0"+br$
	Else
		br$="1"+br$
	EndIf
	n2=128+n1
	br1$=""
	j=1
	While j<=n2
		If (n2 And j)<>0 Then
			Br1$="1"+br1$
		Else
			Br1$="0"+br1$
		EndIf
		j=j Shl 1
	Wend		
	Return Mid$(br$,9,24)+Mid$(br$,1,8)+Right$("00000000"+br1$,8)
End Function
Function ShoveOperand(e$,NoOfOperator,s1=0,s2=0,s3=0,s4=0,s5=0,s6=0,s7=0,s8=0)
	If NoOfOperator=2 Then
		a1=ConvertCheckType(CalStack(CalStackNo-1,0))
		a2=ConvertCheckType(CalStack(CalStackNo-2,0))


		b1=s1 And 7
		b2=(s1 Shr 3)And 7
		b3=(s1 Shr 6)And 7








		
		For f=1 To 8
			If f=1 Then g=s1
			If f=2 Then g=s2
			If f=3 Then g=s3
			If f=4 Then g=s4
			If f=5 Then g=s5
			If f=6 Then g=s6
			If f=7 Then g=s7
			If f=8 Then g=s8		
			b1=g And 7
			b2=(g Shr 3) And 7
			b3=(g Shr 6) And 7
			If a1=b3 And a2=b2 Then
				If b1=2 Then e$=e$+"_Long":n=2
				If b1=3 Then e$=e$+"_Float":n=3
				If b1=5 Then e$=e$+"_String":n=5
				If b3<>b1 And b3=3 Then e$=e$+"_1F"
				If b3<>b1 And b3=2 Then e$=e$+"_1L"
				If b3<>b1 And b3=5 Then e$=e$+"_1S"
				If b2<>b1 And b2=3 Then e$=e$+"_2F"
				If b2<>b1 And b2=2 Then e$=e$+"_2L"
				If b2<>b1 And b2=5 Then e$=e$+"_2S"
				PokeByte MemBank,PC,205:PC=PC+1			
				t=GetRoutineLocation(e$)
				PokeShort MemBank,PC,t:PC=PC+2
				DelCalStack()
				DelCalStack()
				AddCalStack(n,0,PC-2,e$)
				Return
			EndIf
		Next

		
		Err=110:ErrMessage$="Type mismatch":Return
	EndIf
End Function
Function AddRoutine(e$,k$="")
	gt=GetRoutineLocation(e$)
	If gt=0 Then			;**** Just check if Library
		r$=Upper$(e$)
		For f=1 To Lib
			If r$=Libr$(f)Then
				LibUsed(f)=1
			EndIf
		Next
	EndIf
	PokeByte MemBank,PC,205:PC=PC+1
	PokeShort MemBank,PC,gt:PC=PC+2
	If k$>"" Then
		k$=Upper$(Trim(k$))
		
		For f=1 To LbFound
			If k$=LbName$(f)Then
				If LbUsed(f)=0 Then	
					For g=LbStart(f) To LbEnd(f)
						LibEnd=LibEnd+1
						Ld$(LibEnd)=Lb$(g)
					Next
					LbUsed(f)=1
				EndIf
				f=LbFound+1
			EndIf	
		Next
	EndIf	
End Function
Function AddJPRoutine(e$,k$="")
	gt=GetRoutineLocation(e$)
	PokeByte MemBank,PC,195:PC=PC+1
	PokeShort MemBank,PC,gt:PC=PC+2
	If k$>"" Then
		k$=Upper$(Trim(k$))
		
		For f=1 To LbFound
			If k$=LbName$(f)Then
				If LbUsed(f)=0 Then	
					For g=LbStart(f) To LbEnd(f)
						LibEnd=LibEnd+1
						Ld$(LibEnd)=Lb$(g)
					Next
					LbUsed(f)=1
				EndIf
				f=LbFound+1
			EndIf	
		Next
	EndIf
End Function
Function AddIntNumber(w,IsNeg=0)
	If IsNeg=0 Then
		PokeShort MemBank,PC,w:PC=PC+2
	Else
		PokeShort MemBank,PC,-w:PC=PC+2
	EndIf
	;WriteLine Sporax,PeekShort(MemBank,PC-2)
End Function
Function AddFloNumber(Res#,IsNeg=0)
	
	Br$=ConvertFraction$(Res#,IsNeg)
	
	PokeByte MemBank,PC+0,WorkOutByte(Mid$(Br$,17,8))
	PokeByte MemBank,PC+1,WorkOutByte(Mid$(Br$,9,8))
	PokeByte MemBank,PC+2,WorkOutByte(Mid$(Br$,1,8))
	PokeByte MemBank,PC+3,WorkOutByte(Mid$(Br$,25,8))
	PokeByte MemBank,PC+4,WorkOutByte(Mid$(Br$,33,8))	
	
	PC=PC+5
	If IsNeg=0 Then
		;WriteLine Sporax,Res#+" "+WorkOutByte(Mid$(Br$,17,8))+" "+WorkOutByte(Mid$(Br$,9,8))+" "+WorkOutByte(Mid$(Br$,1,8))+" "+WorkOutByte(Mid$(Br$,25,8))+" "+WorkOutByte(Mid$(Br$,33,8))
	Else
		;WriteLine Sporax,-Res#
	EndIf
	;RuntimeError(WorkOutByte(Mid$(Br$,33,8)))
End Function
Function WorkOutByte(Br1$)
	n=0
	j=1
	If Len(Br1$)<>8 Then RuntimeError(g)
	For f=Len(Br1$) To 1 Step -1
		If Mid$(Br1$,f,1)="1" Then n=n+j
		j=j Shl 1
	Next
	Return n
End Function
Function AddVariable(w)
	df$=VarName$(OpListRes#(w))
	df$=Replace(df$,".","_")
	PokeShort MemBank,PC,GetRoutineLocation(df$):PC=PC+2
	;WriteLine Sporax,VarName$(OpListRes#(w))
End Function
Function AddString(s$)
	If Left$(s$,1)=Chr$(34) Then s$=Mid$(s$,2)
	If Right$(s$,1)=Chr$(34) Then s$=Mid$(s$,1,Len(s$)-1)
	PokeByte MemBank,PC,Len(s$):PC=PC+1
	For f=1 To Len(s$)
		PokeByte MemBank,PC,Asc(Mid$(s$,f,1)):PC=PC+1
	Next
End Function
Function CheckVarPost(e,tres)
	n=0
	If Expr$(e+1)="$"Then n=15				;**** was 5
	If Expr$(e+1)="%"Then n=11				;**** was 1
	If Expr$(e+1)="#"Then n=13				;**** was 3
	Killer=0
	If n=0 Then Killer=1
	If (tres=15 Or tres=35 Or tres=45)And n=15 Then Killer=1
	If (tres=11 Or tres=12 Or tres=31 Or tres=41)And n=11 Then Killer=1
	If (tres=13 Or tres=33 Or tres=43)And n=13 Then Killer=1
	If Killer=0
		RuntimeError(tres+"  "+n)
		ErrMessage$="'"+Expr$(e)+"' has been defined as a different type "+Expr$(e+1)
		Err=120
		Return 0
	EndIf
	If n<>0 Then Expr$(e+1)="//ignore:me//"
	Return 1
End Function
Function CheckVarPost2(r$,r1$,tres)
	n=0
	If r1$="$"Then n=5
	If r1$="%"Then n=1
	If r1$="#"Then n=3
	If n<>0 And n<>tres Then
		ErrMessage$="'"+r$+"' has been defined as a different type"
		Err=120
		Return 0
	EndIf
	Return 1
End Function
Function CheckVarSame(r$,r1$,vn)
	n=0
	If r$="$"Then n=5
	If r$="%"Then n=2
	If r$="#"Then n=3
	a=VarType(vn)
	If a=11 Or a=12 Or a=31 Or a=41 Then
		If n<>2 And n>0 Then 
			ErrMessage$="'"+r1$+"' has been defined as an Integer type"
			Err=120
			Return 1
		EndIf
	EndIf
	If a=13 Or a=33 Or a=43 Then
		If n<>3 And n>0 Then 
			ErrMessage$="'"+r1$+"' has been defined as an Float type"
			Err=120
			Return 1
		EndIf
	EndIf
	If a=15 Or a=35 Or a=45 Then
		If n<>5 And n>0 Then 
			ErrMessage$="'"+r1$+"' has been defined as an String type"
			Err=120
			Return 1
		EndIf
	EndIf
	If n>0 Then Return 1
End Function
Function ConvertCheckType(q)
	t=0
	;**** Short
	If q=11 Or q=21 Or q=31 Or q=41 Or q=1 Then
		q=1
		t=1
	EndIf
	;**** Long
	If q=12 Or q=22 Or q=32 Or q=42 Or q=2 Then
		q=2
		t=1
	EndIf
	;**** Float
	If q=13 Or q=23 Or q=33 Or q=43 Or q=3 Then
		q=3
		t=1
	EndIf
	;**** Byte
	If q=14 Or q=24 Or q=34 Or q=44 Or q=4 Then
		q=4
		t=1
	EndIf
	;**** Strings
	If q=15 Or q=25 Or q=35 Or q=45 Or q=5 Then
		q=5
		t=1
	EndIf		
	If t=0 Then Return 0
	Return q
End Function
Function AddCalStack(What,No=0,Pointer=0,Oper$="")
	LastOperation=What
	CalStack(CalStackNo,0)=What
	CalStack(CalStackNo,1)=No
	CalStack(CalStackNo,2)=Pointer
	CalStStr$(CalStackNo)=Oper$
	CalStackNo=CalStackNo+1
End Function
Function DelCalStack()
	CalStack(CalStackNo,0)=0
	CalStack(CalStackNo,1)=0
	CalStack(CalStackNo,2)=0
	CalStStr$(CalStackNo)=""	
	CalStackNo=CalStackNo-1
End Function
Function GetRoutineLocation(e$)
	gt=0
	If LabCount>0 Then
		r$=Upper$(e$)
		If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
		For f=1 To LabCount
			If Lab$(f)=r$ Then
				gt=f
				f=LabCount
			EndIf	
		Next
	EndIf
	If gt=0 Then
		UnRef=UnRef+1
		UnRefLab$(UnRef)=r$
		;If r$=""Then RuntimeError(23)
		UnRefLin(UnRef)=CurrLine
		UnRefPC(UnRef)=PC
	EndIf
	
	If gt=0 Then
		Failed=Failed+1
		Goto Lompin
	Else
		If LabOK(gt)=1 Then 
			gt=LabV(gt)
			Goto Lompin
		Else
			Failed=Failed+1
			Goto Lompin
		EndIf	
	EndIf
.Lompin
	Return gt
End Function
Function CallRoutine(e$,typo)
	gt=GetRoutineLocation(e$)
	PokeByte MemBank,PC,205:PC=PC+1
	AddCalStack(typo,0,PC,e$)
	PokeShort MemBank,PC,gt:PC=PC+2
End Function
Function IncludeData(Val#,typo)
	If typo=2 Then PokeShort MemBank,PC,Val#:PC=PC+2:Return

	Stop

End Function
Function IsNumber#(Srq$)
	ResultInt=0
	Tot#=0
	Tot2=0
	TotBase=1
	Srq$=Upper$(Srq$)
	If Mid$(Srq$,1,7)="SYSTEM." Then
		az=0
		If Srq$="SYSTEM.MACHINE.CPC464"Then Tot#=0:az=1
		If Srq$="SYSTEM.MACHINE.CPC664"Then Tot#=1:az=1
		If Srq$="SYSTEM.MACHINE.CPC6128"Then Tot#=2:az=1
		If Srq$="SYSTEM.MACHINE.CPC464PLUS"Then Tot#=3:az=1
		If Srq$="SYSTEM.MACHINE.CPC6128PLUS"Then Tot#=4:az=1
		If Srq$="SYSTEM.MACHINE.ENTERPRISE"Then Tot#=7:az=1
		If Srq$="SYSTEM.MACHINE.MSX2"Then Tot#=8:az=1
		If Srq$="SYSTEM.MACHINE.MSX2PLUS"Then Tot#=9:az=1
		If Srq$="SYSTEM.MACHINE.MSXTURBOR"Then Tot#=10:az=1		
		If Srq$="SYSTEM.MACHINE.PCW8XXX"Then Tot#=12:az=1
		If Srq$="SYSTEM.MACHINE.PCW9XXX"Then Tot#=13:az=1
		If az>0 Then 
			Succeed=True
			If UsingSign=1 Then Return -Tot#
			Return Tot#
		EndIf
		Succeed=False
	EndIf
	If Mid$(Srq$,1,11)="EVENT.MOUSE" Then
		az=0
		If Srq$="EVENT.MOUSE.LEFTCLICK"Then Tot#=0:az=1
		If Srq$="EVENT.MOUSE.RIGHTCLICK"Then Tot#=1:az=1
		If Srq$="EVENT.MOUSE.LEFTDBLCLICK"Then Tot#=2:az=1
		If Srq$="EVENT.MOUSE.TOOLCLICK"Then Tot#=15:az=1
		If Srq$="EVENT.MOUSE.CONTROLCLICK"Then Tot#=14:az=1
		If Srq$="EVENT.MOUSE.MIDDLECLICK"Then Tot#=3:az=1
		If Srq$="EVENT.MOUSE.WHEELMOVE"Then Tot#=8:az=1			
		If az>0 Then 
			Succeed=True
			If UsingSign=1 Then Return -Tot#
			Return Tot#
		EndIf
		Succeed=False
	EndIf	
	
	If Len(Srq$)>0 Then
		For Pil=Len(Srq$)To 1 Step -1
			tg=0
			Srq1$=Mid$(Srq$,Pil,1)
			If Srq1$>="0" And Srq1$<="9"Then
				Tot#=Tot#+((Asc(Srq1$)-48)*TotBase)
				TotBase=TotBase*10
				tg=1
			EndIf
			If Srq1$="."Then
				Tot#=Tot#/TotBase
				TotBase=1
				tg=1
				ResultInt=1
			EndIf
			If tg=0 Then
				Succeed=False
				Return 0
			EndIf
		Next
		Succeed=True
		If UsingSign=1 Then Return -Tot#
		Return Tot#
	EndIf
	Succeed=False
	Return 0
End Function
Function IsQuote$(Srq$)
	Srq$=Trim$(Srq$)
	If Mid$(Srq$,1,1)<>Chr$(34)Then Return"@Sheet filename expected"
	Srq$=Trim$(Mid$(Srq$,2))
	s$=""
	b=1
	.label1
	If Len(s$)>8 Then Return "@Sheet Filename too long"
	c$=Mid$(Srq$,b,1)
	If c$=Chr$(34) Then Goto dffd
	If (Upper$(c$)>="A"And Upper$(c$)<="Z")Or (c$>="0" And c$<="9") Or c$="_"Then 
		s$=s$+c$
		b=b+1
		Goto label1
	EndIf
	Return "@Invalid filename"
	.dffd
	Return s$
End Function
Function IsVariable#(Srq$)
	Srq$=Upper$(Srq$)
	If Len(Srq$)>0 Then
		For f=1 To VarNo
			If Upper$(VarName$(f))=Srq$ Or Upper$(VarName2$(f))=Srq$ Then
				Succeed=True
				Return f
			EndIf
		Next
	EndIf
	Succeed=False
	Return 0
End Function
Function IsLabel#(Srq$)
	Srq$=Upper$(Srq$)
	If Len(Srq$)>0 Then
		For f=1 To LabCount
			If Upper$(Lab$(f))=Srq$ Then
				Succeed=True
				Return f
			EndIf
		Next
	EndIf
	Succeed=False
	Return 0
End Function
Function SepSort$(q10=1)
	If Wrd(q10,0)=0 Then Return ""
	Return Mid$(Answer$,Wrd(q10,0),Wrd(q10,1)-Wrd(q10,0)+1)
End Function
Function Seperate$(t9)
	Goit$=Cd$(t9)
	Doi=0
	;Doing = 1 = Word or Number
	;Doing = 2 = Quotes
	n6=0
	p6=1
	While n6<Len(Goit$)
		n6=n6+1
		j=Asc(Mid$(Goit$,n6,1))
		If j=34 Then
			If Doi<>2 Then
				Wrd(p6,0)=n6
				Doi=2
			Else
				Wrd(p6,1)=n6
				p6=p6+1
				Doi=0
			EndIf	
		EndIf
		If Doi<>2 Then	
			If (j=>97 And j<=122)Or (j>=48 And j<=57) Or (j>=65 And j<=90)Or j=46 Or j=95 Or j=38 Then
				If Doi=0 Then
					Doi=1
					Wrd(p6,0)=n6
				EndIf
			Else
				If Doi=1 Then
					Doi=0
					Wrd(p6,1)=n6-1
					p6=p6+1
				EndIf	
			EndIf
			If doi<>1 Then
				If j=36 Then
					Wrd(p6,0)=n6
					Doi=1
				EndIf
				If (j>36 And j<38) Or (j>38 And j<46) Or (j>=58 And j<=64) Or j=35 Or j=33 Then
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
				If (j>=91 And j<=94)Or (j>=123 And j<=125) Or j=47 Then		
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
			EndIf	
		EndIf
	Wend
	If Doi=1 Then
		Wrd(p6,1)=n6
		p6=p6+1
	EndIf
	If Doi=2 Then
		Goit$=Goit$+Chr$(34)
		Wrd(p6,1)=n6+1
		p6=p6+1
	EndIf
	Wrd(p6,0)=0
	Return Goit$
End Function
Function Seperate2$(t9)
	
	If t9<=CoreEnd Then Goit$=Cd$(t9):r=1
	If t9>CoreEnd+LibEnd Then Goit$=Cd$(t9-LibEnd)
	If t9>CoreEnd And t9<=CoreEnd+LibEnd Then Goit$=Ld$(t9-CoreEnd)
	
	Doi=0
	;Doing = 1 = Word or Number
	;Doing = 2 = Quotes
	n6=0
	p6=1
	While n6<Len(Goit$)
		n6=n6+1
		j=Asc(Mid$(Goit$,n6,1))
		If j=34 Then
			If Doi<>2 Then
				Wrd(p6,0)=n6
				Doi=2
			Else
				Wrd(p6,1)=n6
				p6=p6+1
				Doi=0
			EndIf	
		EndIf
		If Doi<>2 Then	
			If (j=>97 And j<=122)Or (j>=48 And j<=57) Or (j>=65 And j<=90)Or j=46 Or j=95 Or j=38 Then
				If Doi=0 Then
					Doi=1
					Wrd(p6,0)=n6
				EndIf
			Else
				If Doi=1 Then
					Doi=0
					Wrd(p6,1)=n6-1
					p6=p6+1
				EndIf	
			EndIf
			If doi<>1 Then
				If j=36 Then
					Wrd(p6,0)=n6
					Doi=1
				EndIf
				If (j>36 And j<38) Or (j>38 And j<46) Or (j>=58 And j<=64) Or j=35 Or j=33 Then
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
				If (j>=91 And j<=94)Or (j>=123 And j<=125) Or j=47 Then		
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
			EndIf	
		EndIf
	Wend
	If Doi=1 Then
		Wrd(p6,1)=n6
		p6=p6+1
	EndIf
	If Doi=2 Then
		Goit$=Goit$+Chr$(34)
		Wrd(p6,1)=n6+1
		p6=p6+1
	EndIf
	Wrd(p6,0)=0
	Return Goit$
End Function
Function GetDeclares(ew1$)
	Filein = ReadFile(ew1$)
	LoC=0
	VarNo=0
	For k=0 To 4096
		VarName$(k)="":VarType(k)=0:VarLink$(k)="":VarAvoid(k)=0:VarText$(k)=""
		VarArray(k,0)=0:VarArray(k,1)=0:VarArray(k,2)=0
	Next
	For f=1 To 32
		ShtData(f,0)=0
	Next
	ShtCount=0
	IncNo=0
	While Not Eof(Filein) 
		Cd$(LoC+1)=ReadLine$(Filein)
		LoC=LoC+1
		If Upper$(Trim$(Mid$(Cd$(LoC),1,11)))="INCLUDEFILE"Then
			Answer$=Seperate$(LoC)
			Cod=1
			r$=Upper(SepSort(Cod))
			If r$="INCLUDEFILE"Then
				Cod=Cod+1
				Err=0
				r$=SepSort$(Cod)
				r$=IsQuote(r$)
				If Mid$(r$,1,1)="@" Then
					ErrMessage$=Mid$(r$,2,99):Err=120:ErrLn=LoC:Return
				Else	
					ShtNm$=r$
				EndIf
				Cod=Cod+1
				r$=SepSort$(Cod)				
				Stop
			EndIf
		EndIf	
		If Upper$(Trim$(Mid$(Cd$(LoC),1,12)))="INCLUDESHEET" Or Upper$(Trim$(Mid$(Cd$(LoC),1,15)))="INCLUDESHEETEXT"Then 
			Answer$=Seperate$(LoC)
			Cod=1			
			r$=Upper$(SepSort$(Cod))
			If r$="INCLUDESHEET" Or r$="INCLUDESHEETEXT" Then
				ded=0
				If r$="INCLUDESHEETEXT"Then ded=1
				Cod=Cod+1
				Err=0
				r$=SepSort$(Cod)
				r$=IsQuote(r$)
				If Mid$(r$,1,1)="@" Then
					ErrMessage$=Mid$(r$,2,99):Err=120:ErrLn=LoC:Return
				Else	
					ShtNm$=r$
				EndIf
				Cod=Cod+1
				r$=SepSort$(Cod)
				If r$<>","Then ErrMessage$="',' expected":Err=120::ErrLn=LoC:Return
				Cod=Cod+1
				r$=SepSort$(Cod)
				ShtNum=IsNumber#(r$)
				If Succeed Then
					;RuntimeError(ShtNum)
				Else
					ErrMessage$="Expecting Sheet number":Err=120::ErrLn=LoC:Return
				EndIf
				Cod=Cod+1
				r$=SepSort$(Cod)
				If r$<>","Then ErrMessage$="',' expected":Err=120::ErrLn=LoC:Return
				Cod=Cod+1
				r$=SepSort$(Cod)
				ShtTyp=IsNumber#(r$)
				If Succeed Then
					;RuntimeError(ShtNum)
				Else
					ErrMessage$="Expecting Sheet Type":Err=120::ErrLn=LoC:Return
				EndIf				
				Cod=Cod+1
				r$=SepSort$(Cod)
				If r$<>","Then ErrMessage$="',' expected":Err=120::ErrLn=LoC:Return
				Cod=Cod+1
				r$=SepSort$(Cod)
				ShtWid=IsNumber#(r$)				
				If Succeed Then
					;RuntimeError(ShtNum)
				Else
					ErrMessage$="Expecting Tile width":Err=120::ErrLn=LoC:Return
				EndIf					
				Cod=Cod+1
				r$=SepSort$(Cod)
				If r$<>","Then ErrMessage$="',' expected":Err=120::ErrLn=LoC:Return
				Cod=Cod+1
				r$=SepSort$(Cod)
				ShtHei=IsNumber#(r$)				
				If Succeed Then
					;RuntimeError(ShtNum)
				Else
					ErrMessage$="Expecting Tile height":Err=120::ErrLn=LoC:Return
				EndIf
				If ded=1 Then
					Cod=Cod+1
					r$=SepSort$(Cod)
					If r$<>","Then ErrMessage$="',' expected":Err=120::ErrLn=LoC:Return
					Cod=Cod+1
					r$=SepSort$(Cod)
					extras=IsNumber#(r$)				
					If Succeed Then
					;RuntimeError(ShtNum)
					Else
						ErrMessage$="Expecting Extra Slots":Err=120::ErrLn=LoC:Return
					EndIf
				EndIf
				
				If Err<>0 Then RuntimeError(346)
				;ShtCount=ShtCount+1
				If ded=0 Then 
					OutputSheet(ShtNm$,ShtNum,ShtTyp,ShtWid,ShtHei,0)
				Else
					OutputSheet(ShtNm$,ShtNum,ShtTyp,ShtWid,ShtHei,extras)
				EndIf	
				If Err>0 Then ErrLn=LoC:Return
				
				
			EndIf
		EndIf
		If Upper$(Trim$(Mid$(Cd$(LoC),1,6)))="GLOBAL"Then
			Answer$=Seperate$(LoC)
			Cod=1
			r$=Upper$(SepSort$(Cod))
			If r$="GLOBAL"Then			
				Cod=Cod+1
				r$=SepSort$(Cod)
				Err=0
				Rep=0
				While Rep=0 Or Err<>0
					GlobalCheck(r$)
					r$=SepSort$(Cod)
					If r$=","Then
						Cod=Cod+1
						r$=SepSort$(Cod)
					Else
						rep=1
					EndIf
				Wend
			EndIf
			If Err<>0 Then RuntimeError(345)
		EndIf
	Wend 
	CloseFile (Filein)
	;**** Get the Variable associated to the forms
	
	FileOut = WriteFile(ew1$)
	For k=1 To LoC
		WriteLine(FileOut,Cd$(k))
		
		
		
		If Cd$(k)=";**** Define User Variables ****" Then
			ew$=".SyB_Dialog_Info_Text_1:   ds 32":WriteLine(FileOut,ew$)
			ew$=".SyB_Dialog_Info_Text_2:   ds 32":WriteLine(FileOut,ew$)
			ew$=".SyB_Dialog_Info_Text_3:   ds 32":WriteLine(FileOut,ew$)
			For f=1 To VarNo
				;**** Store a Normal 16 Bit Variable
				If VarType(f)=11 And VarName$(f)>"" Then
					ew$="."+VarName$(f)+":   dw "+VarInitial(f)
					WriteLine(FileOut,ew$)
				EndIf
				If VarType(f)=12 And VarName$(f)>"" Then
					ew$="."+VarName$(f)+":   dw "+VarInitial(f)+",0"
					WriteLine(FileOut,ew$)
				EndIf
				If VarType(f)=13 And VarName$(f)>"" Then
					ew$="."+VarName$(f)+":   db  "+By0+","+By1+","+By2+","+By3+","+Skag+"    ;+VarInitial(f),0"
					WriteLine(FileOut,ew$)
				EndIf
				If VarType(f)=15 And VarName$(f)>""Then
					ew$="."+VarName$(f)+":   dw "+VarName$(f)+"_Data+3"
					VarLink$(f)=VarName$(f)
					WriteLine(FileOut,ew$)
				EndIf
				;**** Store Array of String Pointers ****
				If (VarType(f)=35 Or VarType(f)=45)And VarName$(f)>""Then				
					If VarArray(f,0)=1 Then
						k1=0
						k3=VarArray(f,1)+1
						ew$="."+VarName$(f)+":   dw 0"
					EndIf
					If VarArray(f,0)=2 Then
						k1=VarArray(f,1)
						k3=(VarArray(f,1)+1)*(VarArray(f,2)+1)
						ew$="."+VarName$(f)+":   dw "+(k1+1)*2
					EndIf
					VarLink$(f)=VarName$(f)
					WriteLine(FileOut,ew$)
					k2=0
					Eq$=""
					StrPos=3
					For k1=1 To k3
						ew$="                 dw "+VarName$(f)+"_Data+"+Str$(StrPos)
						StrPos=StrPos+Len(VarText$(f))+4
						WriteLine(FileOut,ew$)
					Next
				EndIf
				;**** Store an Array of 16 Bit Variables
				If (VarType(f)=31 Or VarType(f)=41)And VarName$(f)>""Then
					If VarArray(f,0)=1 Then
						k1=0
						k3=VarArray(f,1)+1
					EndIf
					If VarArray(f,0)=2 Then
						k1=VarArray(f,1)
						k3=(VarArray(f,1)+1)*(VarArray(f,2)+1)
					EndIf
					ew$="."+VarName$(f)+":   dw "+(k1+1)*2
					WriteLine(FileOut,ew$)
					k2=0
					Eq$=""
					For k1=1 To k3
						eq$=eq$+"0,"
						k2=k2+1
						If k2=>20 Or k1=k3 Then
							ew$="       dw "+Mid$(eq$,1,Len(eq$)-1)
							WriteLine(FileOut,ew$)
							k2=0
							eq$=""
						EndIf
					Next
				EndIf
				;**** Store an Array of Float Variables
				If (VarType(f)=33 Or VarType(f)=43)And VarName$(f)>""Then
					If VarArray(f,0)=1 Then
						k1=0
						k3=VarArray(f,1)+1
					EndIf
					If VarArray(f,0)=2 Then
						k1=VarArray(f,1)
						k3=(VarArray(f,1)+1)*(VarArray(f,2)+1)
					EndIf
					;If Len(VarName$(f))<3 Then RuntimeError(VarName$(f)+" "+VarNo)
					ew$="."+VarName$(f)+":   dw "+(k1+1)*5
					WriteLine(FileOut,ew$)
					k2=0
					Eq$=""
					For k1=1 To k3
						;eq$=eq$+"#2a,#e7,#84,#11,#ac,"
						eq$=eq$+"0,0,0,0,0,"
						k2=k2+1
						If k2=>6 Or k1=k3 Then
							ew$="       db "+Mid$(eq$,1,Len(eq$)-1)
							WriteLine(FileOut,ew$)
							k2=0
							eq$=""
						EndIf
					Next
				EndIf
			Next
			;**** Some Constants
			VarNo=VarNo+1:VarName$(VarNo)="False":VarType(VarNo)=14								;Byte	
			VarNo=VarNo+1:VarName$(VarNo)="True":VarType(VarNo)=14								;Byte	
			VarNo=VarNo+1:VarName$(VarNo)="PI":VarType(VarNo)=13								;Float
			VarNo=VarNo+1:VarName$(VarNo)="ErrorNum":VarType(VarNo)=11							;Word	
			VarNo=VarNo+1:VarName$(VarNo)="ErrorPC":VarType(VarNo)=11							;Word
			VarNo=VarNo+1:VarName$(VarNo)="InitDir":VarType(VarNo)=15							;String	
			VarText$(VarNo)=""
			VarLink$(VarNo)=VarName$(VarNo)	
			VarNo=VarNo+1:VarName$(VarNo)="InitCommand":VarType(VarNo)=15						;String		
			VarText$(VarNo)=""
			VarLink$(VarNo)=VarName$(VarNo)				
			
			
			For k1=0 To NoOfFrms
				AddFormVar(k1)
			Next
			n=0
			ew$=".SyB_StringTopAddr:      dw SyB_StringTop"
			WriteLine(FileOut,ew$)
			ew$=";**** String Data ****
			WriteLine(Fileout,ew$)
			For f=1 To VarNo
				If VarType(f)=15 And VarAvoid(f)=0 Then
					ew$=SpaceIt$("."+VarName$(f)+"_Data")+"dw "+VarLink$(f)+":db "+Len(VarText$(f))
					If Len(VarText$(f))>0 Then
						ew$=ew$+":db "+Chr$(34)+VarText$(f)+Chr$(34)+",0"
					Else
						ew$=ew$+":db 0"
					EndIf
					WriteLine(FileOut,ew$)
					n=n+Len(VarText$(f))+4
				EndIf
				If (VarType(f)=35 Or VarType(f)=45)And VarAvoid(f)=0 Then
					ew$=SpaceIt$("."+VarName$(f)+"_Data")
					WriteLine(FileOut,ew$)
					If VarArray(f,0)=1 Then
						k1=0
						k3=VarArray(f,1)+1
					EndIf
					If VarArray(f,0)=2 Then
						k1=VarArray(f,1)
						k3=(VarArray(f,1)+1)*(VarArray(f,2)+1)
					EndIf					
					StrPos=2
					For k1=1 To k3
						ew$=SpaceIt$("")
						ew$=Mid$(ew$,2)+" "
						ew$=ew$+"dw "+VarLink$(f)+"+"+Str$(StrPos)+":db "+Len(VarText$(f))
						If Len(VarText$(f))>0 Then
							ew$=ew$+":db "+Chr$(34)+VarText$(f)+Chr$(34)+",0"
						Else
							ew$=ew$+":db 0"
						EndIf
						WriteLine(FileOut,ew$)
						StrPos=StrPos+2
						n=n+Len(VarText$(f))+4
					Next
				EndIf
			Next
			x1=1024
			If StSpac$="1k"Then x1=1024*1
			If StSpac$="2k"Then x1=1024*2
			If StSpac$="3k"Then x1=1024*3
			If StSpac$="4k"Then x1=1024*4
			If StSpac$="5k"Then x1=1024*5
			If StSpac$="6k"Then x1=1024*6
			If StSpac$="8k"Then x1=1024*8
			If StSpac$="10k"Then x1=1024*10		
			If StSpac$="12k"Then x1=1024*12
			If n>x1 Then ErrMessage="Strings exceed user String compile size settings":Err=120:Return
			ew$=".SyB_StringTop:       ds "+Str$(x1-n)+",0"
			WriteLine(FileOut,ew$)
			ew$=".SyB_StringTopMem: 
			WriteLine(FileOut,ew$)
		EndIf
		If Cd$(k)=";**** Define User Graphics ****" Then
			ew$=SpaceIt$(".Sheet_Data4")
			WriteLine(FileOut,ew$)
			WriteLine(FileOut,".Sheet_Data4_WidthByte:     db 1")			
			WriteLine(FileOut,".Sheet_Data4_WidthPixel:    db 1")			
			WriteLine(FileOut,".Sheet_Data4_Height:        db 1")
			WriteLine(FileOut,".Sheet_Data4_DataAddr:      dw Sheet_Data4_Data")
			WriteLine(FileOut,".Sheet_Data4_EncodeAddr:    dw Sheet_Data4_Encode")			
			WriteLine(FileOut,".Sheet_Data4_Size:          dw 1")
			WriteLine(FileOut,".Sheet_Data4_Encode:        db 0")
			WriteLine(FileOut,".Sheet_Data4_Data:          dw 0")				
			ew$=SpaceIt$(".Sheet_Data16")
			WriteLine(FileOut,ew$)
			WriteLine(FileOut,".Sheet_Data16_WidthByte:     db 100")			
			WriteLine(FileOut,".Sheet_Data16_WidthPixel:    db 100")			
			WriteLine(FileOut,".Sheet_Data16_Height:        db 100")
			WriteLine(FileOut,".Sheet_Data16_DataAddr:      dw Sheet_Data16_Data")
			WriteLine(FileOut,".Sheet_Data16_EncodeAddr:    dw Sheet_Data16_Encode")			
			WriteLine(FileOut,".Sheet_Data16_Size:          dw 1")
			WriteLine(FileOut,".Sheet_Data16_Encode:        db 5")
			WriteLine(FileOut,".Sheet_Data16_Data:          dw 0")			
		EndIf
	Next
	
	CloseFile(FileOut)
	
End Function
Function OutputSheet(ShtNm$,ShtNum,ShtTyp,ShtWid,ShtHei,Extras)
	If ShtTyp=1 Then 
		k1=0
	Else
		k1=1
	EndIf	
	If GrpImage(ShtNum)<>0 Then 
		Ig=ShtNum
		If ShtTyp=1 Then nf=GrpCWid(Ig,0)*2
		If ShtTyp=0 Then nf=GrpCWid(Ig,1)*4
		nh=GrpCHei(Ig,k1)
		a1=Ceil(nf/ShtWid):If a1<1 Then a1=1
		a2=Ceil(nh/ShtHei):If a2<1 Then a2=1
	Else
		ErrMessage$="Sheet "+ShtNum+" does not exist":Err=120:Return
	EndIf
	
	IncNo=IncNo+1
	IncFile$(IncNo)=ShtNm$+".GSH"
	os=WriteFile("output\"+ShtNm$+".GSH")
	no=a1*a2
	WriteShort(os,no)					;This is the number of Tiles	
	If ShtTyp=1 Then
		sz=((ShtWid/2)*ShtHei)+12
	Else
		sz=((ShtWid/4)*ShtHei)+12
	EndIf
	For f=1 To no
		WriteShort(os,((no-f)*2)+((f-1)*sz))
	Next
	Tile=0
	NoTile=0
	While NoTile=0
		c1=(tile Mod a1)*ShtWid
		If a1>0 Then 
			c2=(Floor(Tile/a1))*ShtHei
		Else
			c2=0
		EndIf	
		NoTile=0
		If Tile=>(a2*a1)Then 
			NoTile=1
		Else
			;WriteLine(FileOut,".Sheet_Data16_WidthByte:     db 1")			
			;WriteLine(FileOut,".Sheet_Data16_WidthPixel:    db 1")			
			;WriteLine(FileOut,".Sheet_Data16_Height:        db 1")
			;WriteLine(FileOut,".Sheet_Data16_DataAddr:      dw Sheet_Data16_Data")
			;WriteLine(FileOut,".Sheet_Data16_EncodeAddr:    dw Sheet_Data16_Encode")			
			;WriteLine(FileOut,".Sheet_Data16_Size:          dw 1")
			;WriteLine(FileOut,".Sheet_Data16_Encode:        db 5")
			;WriteLine(FileOut,".Sheet_Data16_Data:          dw 0")	
			;**** Width of Complete Graphic  - 0
			If ShtTyp=1 Then
				WriteByte(os,ShtWid/2)		;Bit 7 Is set for MSX
			Else
				WriteByte(os,ShtWid/4)
			EndIf
			;**** Width in Pixels - 1
			WriteByte(os,ShtWid)							;WidthPixel		
			;**** Height in Pixels - 2
			WriteByte(os,ShtHei)							;Height 
			;**** Data Addr - 3/4
			WriteShort(os,0)								;data
			;**** Endcode Addr - 5/6
			WriteShort(os,0)								;data encode
			;**** Size - 7/8
			If ShtTyp=1 Then 
				WriteShort(os,ShtHei*(ShtWid/2))			;Size
			Else
				WriteShort(os,ShtHei*(ShtWid/4))				
			EndIf											
			;**** Encode
			If ShtTyp=1 Then 
				WriteByte(os,5)								;encode
			Else
				WriteByte(os,0)				
			EndIf
			;**** Data for Sheet & Tile
			WriteByte(os,ShtNum)								;encode
			WriteByte(os,Tile)									;encode
			
			If ShtTyp=0 Then
				t2=GrpCBank(Ig,1)
			Else
				t2=GrpCBank(Ig,0)
			EndIf
			;**** Graphic Data
			For h=0 To ShtHei-1
				If ShtTyp=0 Then
					For i=0 To ShtWid-3 Step 4
						t1=i+c1+((h + c2) * nf)
						j1=PeekByte(t2,t1)Shl 6
						j2=PeekByte(t2,t1+1)Shl 4
						j3=PeekByte(t2,t1+2)Shl 2
						j4=PeekByte(t2,t1+3)
						j1=j1+j2+j3+j4
						WriteByte(os,ConvertScreenByte(j1))
					Next
				Else
					For i=0 To ShtWid-2 Step 2
						t1=i+c1+((h + c2) * nf)
						j1=PeekByte(t2,t1)Shl 4
						j2=PeekByte(t2,t1+1)
						j1=j1+j2
						;j1=200
						WriteByte(os,j1)
					Next	
				EndIf
			Next
			
			For f=1 To Extras
				If ShtTyp=1 Then
					WriteByte(os,ShtWid/2)		;Bit 7 Is set for MSX
				Else
					WriteByte(os,ShtWid/4)
				EndIf
				;**** Width in Pixels - 1
				WriteByte(os,ShtWid)							;WidthPixel		
				;**** Height in Pixels - 2
				WriteByte(os,ShtHei)							;Height 
				;**** Data Addr - 3/4
				WriteShort(os,0)								;data
				;**** Endcode Addr - 5/6
				WriteShort(os,0)								;data encode
				;**** Size - 7/8
				If ShtTyp=1 Then 
					WriteShort(os,ShtHei*(ShtWid/2))			;Size
				Else
					WriteShort(os,ShtHei*(ShtWid/4))				
				EndIf											
				;**** Encode
				If ShtTyp=1 Then 
					WriteByte(os,5)								;encode
				Else
					WriteByte(os,0)				
				EndIf
				Stop
				
			Next
			
			
			Tile=Tile+1
		EndIf
	Wend
	CloseFile(os)
End Function
Function AddVars()
	VarNo=VarNo+1:VarName$(VarNo)="InitDir":VarType(VarNo)=15							;String	
	VarNo=VarNo+1:VarName$(VarNo)="InitCommand":VarType(VarNo)=15						;String	
End Function
Function GlobalCheck(r$)
	VarNo=VarNo+1
	VarArray(VarNo,0)=0:VarArray(VarNo,1)=0:VarArray(VarNo,2)=0
	a=11								;This is an Integer
	;VarNo=VarNo+1
	VarName$(VarNo)=r$
	Cod=Cod+1
	r$=SepSort$(Cod)
	
	If r$="%"Or r$="#" Or r$="$"Then
		If r$="%"Then a=11
		If r$="#"Then a=13
		If r$="$"Then a=15
		Cod=Cod+1
		r$=SepSort$(Cod)
	EndIf
	If r$="("Then
		Succeed=False
		Cod=Cod+1
		r$=SepSort$(Cod)							
		res=IsNumber#(r$)
		If Succeed And Res>0 Then
			VarArray(VarNo,0)=1
			VarArray(VarNo,1)=Int(res)
		EndIf
		If Succeed=False Or Res<0 Then
			Err=120
			ErrMessage$="Declarion error "+VarName$(VarNo)			
			Return
		EndIf
		Cod=Cod+1
		r$=SepSort$(Cod)
		If r$="," Then			;**** Double array
			Succeed=False
			Cod=Cod+1
			r$=SepSort$(Cod)
			
			res=IsNumber#(r$)				
			If Succeed And Res>0 Then
				VarArray(VarNo,0)=2
				VarArray(VarNo,2)=Int(res)
				;Cod=Cod+1
				;r$=SepSort$(Cod)		
			EndIf
			If Succeed=False Or Res<0 Then
				Err=120
				ErrMessage$="Declarion error "+VarName$(VarNo)			
				Return
			EndIf
			Cod=Cod+1
			r$=SepSort$(Cod)
			;RuntimeError(r$)			
		EndIf
		If r$<>")"Then
			Err=120
			ErrMessage$="Declarion error ) expected in "+VarName$(VarNo)			
			Return
		EndIf
		Cod=Cod+1
		r$=SepSort$(Cod)
	EndIf
	If VarArray(VarNo,0)=1 And a=11 Then a=31
	If VarArray(VarNo,0)=1 And a=13 Then a=33
	If VarArray(VarNo,0)=1 And a=15 Then a=35	
	If VarArray(VarNo,0)=2 And a=11 Then a=41
	If VarArray(VarNo,0)=2 And a=13 Then a=43
	If VarArray(VarNo,0)=2 And a=15 Then a=45
	VarType(VarNo)=a
	
End Function
Function GetFunctions(ew1$)
	LoC=0
	FuncNo=0
	;**** Read in the entire Source
	Filein = ReadFile(ew1$)
	While Not Eof(Filein) 
		Cd$(LoC+1)=ReadLine$( Filein )
		LoC=LoC+1
		If Cd$(LoC+1)=";**** Core End"Then 
			CoreEnd=LoC
			LibEnd=0
		End If
		;Check if Function declared
		If Upper$(Trim$(Mid$(Cd$(LoC),1,9)))="AFUNCTION" Or Upper$(Trim$(Mid$(Cd$(LoC),1,8)))="FUNCTION" Then
			Answer$=Seperate$(LoC)
			r$=Upper$(SepSort$(1))
			Cod=2
			If r$="AFUNCTION" Or r$="FUNCTION" Then
				If r$="AFUNCTION"Then 
					Doi=0
				Else
					Doi=1
				EndIf
				r$=Upper$(SepSort$(Cod))
				FuncNo=FuncNo+1
				Func$(FuncNo)=r$
				Ft1=0
				Cod=Cod+1:r$=Upper$(SepSort$(Cod))				
				If r$="%"Then Ft=2:Ft1=1
				If r$="#"Then Ft=3:Ft1=1
				If r$="$"Then Ft=5:Ft1=1
				If ft1>0 Then
					Cod=Cod+1:r$=Upper$(SepSort$(Cod))					
				Else
					Ft=1
				EndIf
				If Doi=1 Then ft=ft+10
				FuncType(FuncNo)=ft
				a=0
				ty=0
				If r$="("Then
					.SpunkBuckets
					Cod=Cod+1:r$=Upper$(SepSort$(Cod))
					
					If r$=")"Then Goto OverSpunkBuckets
					Gunk=0
					;RuntimeError(r$+"  "+doi)
					If Doi=0 Then
						If r$="%"Then 
							ty=ty+1:Gunk=1
							FuncParVar(FuncNo,ty)=100002
						EndIf
						If r$="#"Then 
							ty=ty+1:Gunk=1
							FuncParVar(FuncNo,ty)=100003
						EndIf
						If r$="$"Then 
							ty=ty+1:Gunk=1
							FuncParVar(FuncNo,ty)=100005
						EndIf	
						Cod=Cod+1:r$=Upper$(SepSort$(Cod))
					Else
						For k=1 To VarNo
							If Upper$(VarName$(k))=r$ Then
								ty=ty+1
								FuncParVar(FuncNo,ty)=k
								k=VarNo+1
								Gunk=1
							EndIf
						Next
						Cod=Cod+1:r$=Upper$(SepSort$(Cod))
						If Gunk>0 Then 
							If r$="#"Or r$="$" Or r$="%"Then
								Cod=Cod+1:r$=Upper$(SepSort$(Cod))
							EndIf
						EndIf	
					EndIf
					If Gunk=0 Then Err=120:ErrMessage$="Error Defining function":Return
					If r$="," Then Goto SpunkBuckets
					If r$<>")"Then Err=120:ErrMessage$="Error Defining function":Return
					
				EndIf
				.OverSpunkBuckets
				FuncParams(FuncNo)=ty
			EndIf
		EndIf
		
		If Upper$(Trim$(Mid$(Cd$(LoC),1,7)))="LIBRARY"Then
			Answer$=Seperate$(LoC)
			r$=Upper$(SepSort$(1))
			If r$="LIBRARY"Then
				r$=Upper$(SepSort$(2))
				Lib=Lib+1
				Libr$(Lib)=r$
				LibUsed(Lib)=0
			EndIf
		EndIf
	Wend 
	CloseFile (Filein)

End Function
Function AddFormVar(frm)
	;**** 3 is Button
	;**** 6 is Label
	;**** 7 is TextLine
	;**** 2 is Frame
	;**** 4 is Radio
	;**** 5 is CheckBox

	;**** 8 is VSpinner
	;**** 9 is HSpinner
	;**** 10 is VScroll
	;**** 11 is HScroll
	;**** 16 is PaintBox
	;**** 14 is Box

;**** 11 = Variable 16 bit Integer
;**** 12 = Variable 32 bit Integer
;**** 13 = Variable 40 bit Float
;**** 14 = Variable 8 Bit Byte
;**** 15 = Varaible 16 Bit String

	
;	;**** Some Constants
;	VarNo=VarNo+1:VarName$(VarNo)="False":VarType(VarNo)=14								;Byte	
;	VarNo=VarNo+1:VarName$(VarNo)="True":VarType(VarNo)=14								;Byte	
;	VarNo=VarNo+1:VarName$(VarNo)="PI":VarType(VarNo)=13								;Float
;	VarNo=VarNo+1:VarName$(VarNo)="ErrorNum":VarType(VarNo)=11							;Word	
;	VarNo=VarNo+1:VarName$(VarNo)="ErrorPC":VarType(VarNo)=11							;Word
;	VarNo=VarNo+1:VarName$(VarNo)="InitDir":VarType(VarNo)=15							;String	
;	VarText$(VarNo)=""
;	VarLink$(VarNo)=VarName$(VarNo)	
;	VarNo=VarNo+1:VarName$(VarNo)="InitCommand":VarType(VarNo)=15						;String		
;	VarText$(VarNo)=""
;	VarLink$(VarNo)=VarName$(VarNo)	
	
	;Ed$(EdL2+9,2) =".Event_Message       db 0         ;Message No 162
	;Ed$(EdL2+10,2)=".Event_Form_ID       db 0         ;Event happned on which Form"
	;Ed$(EdL2+11,2)=".Event_Type          db 0         ;Type of Event"
	;Ed$(EdL2+12,2)=".Event_UserInput     db 0         ;Key or Mouse Event"
	;Ed$(EdL2+13,2)=".Event_Key_ASCII                  ;Key ASCII - Shared Byte with next"
	;Ed$(EdL2+14,2)=".Event_MouseX        dw 0         ;MouseX when event happens"
	;Ed$(EdL2+15,2)=".Event_MouseY        dw 0         ;MouseY when event happens"
	;Ed$(EdL2+16,2)=".Event_Control_ID    dw 0         ;Control ID No"	
	
	VarNo=VarNo+1:VarName$(VarNo)="Event_Message":VarType(VarNo)=14:VarName2$(VarNo)="Event.Message"							;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_Form_ID":VarType(VarNo)=14:VarName2$(VarNo)="Event.Form"									;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_Type":VarType(VarNo)=14:VarName2$(VarNo)="Event.Type"									;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_UserInput":VarType(VarNo)=14:VarName2$(VarNo)=Nm$+"Event.Input"							;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_Ascii":VarType(VarNo)=14:VarName2$(VarNo)=Nm$+"Event.Ascii"							;Byte	
	VarNo=VarNo+1:VarName$(VarNo)="Event_MouseX":VarType(VarNo)=11:VarName2$(VarNo)=Nm$+"Event.Mouse.X"							;Word	
	VarNo=VarNo+1:VarName$(VarNo)="Event_MouseY":VarType(VarNo)=11:VarName2$(VarNo)=Nm$+"Event.Mouse.Y"							;Word	
	VarNo=VarNo+1:VarName$(VarNo)="Event_Control_ID":VarType(VarNo)=11:VarName2$(VarNo)=Nm$+"Event.Control.ID"						;Word
	VarNo=VarNo+1:VarName$(VarNo)="Event_MouseY":VarType(VarNo)=11:VarName2$(VarNo)=Nm$+"Event.Mouse.Y"							;Word	
	
	;**** First Do Form Information
	Nm$=ObSData(frm,1,QNam)
	VarNo=VarNo+1:VarName$(VarNo)=Nm$:VarType(VarNo)=12									;Long
	AddControlVars(Nm$,"Status",Ut_Byte)
	AddControlVars(Nm$,"Display",Ut_Byte)
	AddControlVars(Nm$,"SizeAdjust",Ut_Byte)
	AddControlVars(Nm$,"OwnerID",Ut_Byte)
	AddControlVars(Nm$,"Left",Ut_Word)	
	AddControlVars(Nm$,"Top",Ut_Word)	
	AddControlVars(Nm$,"Width",Ut_Word)
	AddControlVars(Nm$,"Height",Ut_Word)
	AddControlVars(Nm$,"OffsetWidth",Ut_Word)
	AddControlVars(Nm$,"OffsetHeight",Ut_Word)
	AddControlVars(Nm$,"ContentWidth",Ut_Word)
	AddControlVars(Nm$,"ContentHeight",Ut_Word)
	AddControlVars(Nm$,"MinWidth",Ut_Word)
	AddControlVars(Nm$,"MinHeight",Ut_Word)
	AddControlVars(Nm$,"MaxWidth",Ut_Word)
	AddControlVars(Nm$,"MaxHeight",Ut_Word)
	
	AddControlDirective(Nm$,"Scroll.Refresh",4001,frm,1)
	
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_IconAddr":VarType(VarNo)=11						;Word
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_MenuAddr":VarType(VarNo)=11						;Word
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ControlWindowAddr":VarType(VarNo)=11			;Word
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ControlToolAddr":VarType(VarNo)=11				;Word
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ToolBarHeight":VarType(VarNo)=11				;Word
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_MaxHeight":VarType(VarNo)=11					;Word
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text":VarType(VarNo)=15							;String
	VarText$(VarNo)=ObSData$(frm,1,QCap)
	VarLink$(VarNo)=Nm$+"_Text"
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_StatusText":VarType(VarNo)=15				;String
	VarText$(VarNo)=ObSData$(frm,1,QStT)
	VarLink$(VarNo)=Nm$+"_StatusText"
	For f=1 To 255
		a=ObData(frm,f,QTyp)
		b=0
		If a>1 Then
			If a=3 Or a=6 Or a=7 Or a=2 Or a=4 Or a=8 Or a=9 Or a=10 Or a=11 Or a=5 Or a=13 Then b=1
			If a=14 Or a=15 Or a=16 Or a=12 Or a=21 Or a=18 Then b=1
			gh=VarNo
			;If b=1 Then
			;	Nm$=ObSData(frm,f,QNam)				
			;	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Display":VarType(VarNo)=89			;Equate
			;EndIf
			If b=1 Then
				Nm$=ObSData(frm,f,QNam)
				
				AddControlVars(Nm$,"Display",89)
				AddControlVars(Nm$,"ID",Ut_Word)
				VarNo=VarNo+1:VarName$(VarNo)=Nm$:VarType(VarNo)=89
				AddControlVars(Nm$,"Type",Ut_Byte)
				AddControlVars(Nm$,"Left",Ut_Word)
				AddControlVars(Nm$,"Top",Ut_Word)
				AddControlVars(Nm$,"Width",Ut_Word)
				AddControlVars(Nm$,"Height",Ut_Word)
				AddControlVars(Nm$,"Code",Ut_Word)
				AddControlDirective(Nm$,"Refresh",4000,frm,f)
			EndIf
			If b=0 Then
				Nm$=ObSData(frm,f,QNam)	
				If a=17 Then		;**** Timer
					AddControlVars(Nm$,"Active",Ut_Byte)
					AddControlVars(Nm$,"Status",Ut_Byte)
					AddControlVars(Nm$,"Value",Ut_Word)
					AddControlVars(Nm$,"Max",Ut_Word)
					AddControlVars(Nm$,"Code",Ut_Word)
					AddControlVars(Nm$,"Type",Ut_Byte)
				EndIf
			EndIf
			;**** Specific to Types
			If a=3 Then			;**** Button
				AddControlVars(Nm$,"TextMaxLen",Ut_Byte)
				AddControlVars(Nm$,"Text",15)
				VarText$(VarNo-1)=ObSData$(frm,f,QCap):VarLink$(VarNo-1)=Nm$+"_Text"
				VarText$(VarNo)=ObSData$(frm,f,QCap):VarLink$(VarNo)=Nm$+"_Text"
			EndIf
			If a=6 Then			;**** Label
				AddControlVars(Nm$,"TextAppearance",Ut_Byte)
				AddControlVars(Nm$,"TextAlignment",Ut_Byte)
				AddControlVars(Nm$,"TextMaxLen",Ut_Byte)
				AddControlVars(Nm$,"Text",15)
				VarText$(VarNo-1)=ObSData$(frm,f,QCap):VarLink$(VarNo-1)=Nm$+"_Text"
				VarText$(VarNo)=ObSData$(frm,f,QCap):VarLink$(VarNo)=Nm$+"_Text"
			EndIf
			If a=7 Then			;**** TextLine
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_CurPos":VarType(VarNo)=11			;Word
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Selected":VarType(VarNo)=11			;Word
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_InputLen":VarType(VarNo)=11			;Word				
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_InputMax":VarType(VarNo)=11			;Word
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Flags":VarType(VarNo)=14			;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Input":VarType(VarNo)=15			;String
				VarAvoid(VarNo)=1
			EndIf
			If a=2 Then			;**** Frame
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Appearance":VarType(VarNo)=14		;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TextMaxLen":VarType(VarNo)=14		;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text":VarType(VarNo)=15				;String
				VarText$(VarNo)=ObSData$(frm,f,QCap)				
				VarLink$(VarNo)=Nm$+"_Text"				
			EndIf	
			If a=4 Then			;**** Radio
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TextAppearance":VarType(VarNo)=14	;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Value":VarType(VarNo)=14			;Byte				
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TextMaxLen":VarType(VarNo)=14		;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text":VarType(VarNo)=15				;String
				VarText$(VarNo)=ObSData$(frm,f,QCap)				
				VarLink$(VarNo)=Nm$+"_Text"				
			EndIf
			;**** VSpinner / HSPinner / VScroll / HScroll
			If a=>8 And a<=11 Then 
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Value":VarType(VarNo)=11			;Word			
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Max":VarType(VarNo)=11				;Word
			EndIf
			If a=5 Then 		;**** Check
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Value":VarType(VarNo)=14			;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TextMaxLen":VarType(VarNo)=14		;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text":VarType(VarNo)=15				;String
				VarText$(VarNo)=ObSData$(frm,f,QCap)				
				VarLink$(VarNo)=Nm$+"_Text"				
			EndIf
			If a=13 Then 		;**** Tab
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Tabs":VarType(VarNo)=14				;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Appearance":VarType(VarNo)=14		;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Value":VarType(VarNo)=14			;Byte
				For p=1 To ObData(frm,f,QTab)
					VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TabWidth"+Str$(p):VarType(VarNo)=14		;Byte
					VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TextMaxLen"+Str$(p):VarType(VarNo)=14	;Byte
					VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text_"+Str$(p):VarType(VarNo)=15			;String
					r$=GetTab$(frm,f,p)
					If ObData(frm,f,QCap)>Len(r$)Then
						y7=ObData(frm,f,QCap)
					Else
						y7=Len(r$)
					EndIf	
					VarText$(VarNo)=r$
					VarLink$(VarNo)=Nm$+"_Text_"+Str$(p)					
				Next
			EndIf
			If a=18 Then		;**** Control Label
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TextAppearance":VarType(VarNo)=14	;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_TextMaxLen":VarType(VarNo)=11		;Word
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text":VarType(VarNo)=15				;String
				VarText$(VarNo)=ObSData$(frm,f,QCap)
				VarLink$(VarNo)=Nm$+"_Text"
			EndIf
			If a=15 Then        ;**** Progress bar
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Appearance":VarType(VarNo)=14		;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Value":VarType(VarNo)=14			;Byte
			EndIf
			If a=16 Then		;**** Paint 
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Appearance":VarType(VarNo)=14		;Byte
			EndIf
			If a=12 Then 		;**** ImageBox
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_GrWidthByte":VarType(VarNo)=14		;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_GrWidth":VarType(VarNo)=14			;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_GrHeight":VarType(VarNo)=14			;Byte
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_GrDataAddr":VarType(VarNo)=11		;Word
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_GrEncodeAddr":VarType(VarNo)=11		;Word
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_GrSize":VarType(VarNo)=14			;Word
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_GrEncode":VarType(VarNo)=14			;Byte
			EndIf
			If a=21 Then 		;**** Super Container
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ScrollWidth":VarType(VarNo)=11		;Word				
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ScrollHeight":VarType(VarNo)=11		;Word	
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_OffsetLeft":VarType(VarNo)=11		;Word	
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_OffsetTop":VarType(VarNo)=11		;Word				
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ScrollBars":VarType(VarNo)=14		;Byte					
			EndIf	
			
		EndIf
	Next
	;**** Add Menu Stuff
	If NoOfMn(frm)>1 Then
		VarNo=VarNo+1:VarName$(VarNo)=ObSData(frm,1,QNam)+"_Menu_Entries":VarType(VarNo)=11		;Word
		;RuntimeError(VarName$(VarNo))
		For f=2 To NoOfMn(frm)
			If Mid$(Mn$(frm,f,1),1,1)<>"-"Then
				Nm$=Mn$(frm,f,2)
				If MnT(frm,f)=0 Then
					VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Entries"VarType(VarNo)=11		;Word
				EndIf
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Appearance":VarType(VarNo)=11		;Word	
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text":VarType(VarNo)=15				;String			
				VarText$(VarNo)=Mn$(frm,f,1)
				VarLink$(VarNo)=Nm$+"_Text"
			EndIf
		Next
	EndIf	
End Function
Function AddControlVars(Nm$,What$,VarTypeNo)
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_"+What$:VarType(VarNo)=VarTypeNo
	VarName2$(VarNo)=Nm$+"."+What$
End Function
Function AddControlDirective(Nm$,What$,VarTypeNo,frm,f)
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_"+What$:VarType(VarNo)=VarTypeNo:VarCont(VarNo)=(frm*256)+f
	VarName2$(VarNo)=Nm$+"."+What$
End Function
Function SpaceIt$(e$)
	If Len(e$)>=32 Then e$=e$+":":Return e$
	If Len(e$)<32 Then e$=Mid$(e$+":                                       ",1,32):Return e$
	
End Function
Function ConvertString$(Thing$)
	hj=0
	For f=1 To Len(Thing$)
		If Mid$(Thing$,f,1)="."Then hj=f
	Next

	;minus=1

	Flt$=""
	Intg$=""
	Skag=128
	;**** Okay there is a decimal point
	If hj>0 Then
		w2#=128
		w1#=Mid$(Thing$,hj)
		w1#=w1#*256
		
		If Minus=1 Then
			w1#=1-w1#
		EndIf
		While w1#>0
			If w1#=>w2# Then
				w1#=w1#-w2#
				Flt$=Flt$+"1"
			Else	
				Flt$=Flt$+"0"
			EndIf
			w2#=w2#/2
		Wend
	EndIf

	If hj>1 Then
		w3=Mid$(Thing$,1,hj)
		Intg$=Bin(w3)
		For f=1 To Len(Intg$)
			nerd$=Mid$(Intg$,f,1)
			If nerd$="1"Then Intg$=Mid$(Intg$,f):Exit
		Next
	EndIf
	If Intg$=""Then	
		For f=1 To Len(Flt$)
			Skag=Skag-1
			nerd$=Mid$(Flt$,f,1)
			If nerd$="1"Then Flt$=Mid$(Flt$,f):Exit	
		Next
	Else
		Skag=Skag+Len(Intg$)
	EndIf

	Over$=Mid$(Mid$(Intg$+Flt$,2)+"00000000000000000000000000000000",1,31)
	By3=Bin2Dec("0"+Mid$(over$,1,7))
	By0=Bin2Dec(Mid$(Over$,8,8))
	By1=Bin2Dec(Mid$(Over$,16,8))
	By2=Bin2Dec(Mid$(Over$,24,8))
	;Print Skag
	;Print Over$
	;Print By3
	;Print By0
	;Print By1
	;Print by2
End Function
Function Bin2Dec(hy$)
	e=1
	g=0
	For f=Len(hy$) To 1 Step -1
		If Mid$(hy$,f,1)="1" Then g=g+e
		e=e*2
	Next
	Return g
End Function

;~IDEal Editor Parameters:
;~F#263#267#270#275#27A#27E#282#2D5#2DA#30C#328#372#392#39E#422#490#4B5#4C0#4EB#511
;~F#51D#525#52F#539#53F#545#5A1#5B9#5E2#615#649#676#699#6C5#6E8#714#745#776#7A2#7C6
;~F#7EA#80D#831#855#879#89D#8CA#902#920#93E#AB9#B10#B2E#B48#B66#B86#B99#BAA#BD3#C15
;~F#C28#C49#C4F#C55#C5B#C61#C69#C71#C77#C7D#C85#C8D#C95#C9D#CA5#CAD#CB5#CBD#CC5#CCD
;~F#CD5#CDD#CE5#CED#CF5#CFD#D03#D09#D0F#D15#D1B#D23#D29#D2F#D37#D40#D52#D86#D98#D9F
;~F#DAA#DB1#DB8#DC7#DCD#DD3#DD9#DDF#DEE#DFD#E82#E8B#E92#E99#EA7#EB5#ECB#ED3#EDB#EE7
;~F#EF4#F0A#F23#F28#F2D#F32#F37#F3C#F41#F46#F4B#F50#F55#F5A#F5F#F7B#FA1#FAD#FB8#FCF
;~F#FDB#FFB#100A#1019#1028#1038#103F#1050#1060#1070#1080#1090#10A0#10B0#10C0#10D0#10E0#10F0#1100#1110
;~F#1120#1128#1130#1137#1250#18D5#1924#194F#1BC4#1CDF#1CEF#1CF6#1D29#1D99#1DAB#1DBB#1DD6#1DE2#1DFF#1E1D
;~F#1E2C#1E4F#1E55#1EC1#1ECE#1ED2#1F58#214D#2151#2197#22F0#22F4#22F8#22FD#233A
;~C#Blitz3D