;**** Defines *****
Dim Cd$(65536),MemoryBank(10),Org(10),Fin(10)
Dim Lab$(65536),LabT(65536),LabV(65536),LabOK(65536),LabRef(65536)
Global Filein,LoC,Cod,PC,Okay=0,LabCount=0,Err=0,Total,Tot2,Failed=0,Failed3=0,Pass=0
Global MemBank,OrgVer=1,Reloc$

;**** Read in Assembly
AppTitle "SymbOS Assembler 0.41" 
CDir$=CurrentDir$()

Filein = ReadFile("sys\form.asm")
While Not Eof(Filein) 
	Cd$(LoC+1)=ReadLine$( Filein )
	LoC=LoC+1
Wend 
CloseFile (Filein)
MemoryBank(1)=CreateBank(65536)
MemoryBank(2)=CreateBank(65536)
MemoryBank(3)=CreateBank(65536)

.LoopyLoo
For f=0 To LabCount
	Lab$(f)="":LabT(f)=0:LabV(f)=0:LabOK(f)=0:LabRef(f)=0
Next 
LabCount=0

If OrgVer=1 Then MemBank=MemoryBank(1)
If OrgVer=2 Then MemBank=MemoryBank(2)

Pass=1
Failed3=65536
.LakePlacid
Print "Pass "+Pass
PC=0
For f=1 To LoC
	Cod=1
	n$=Seperate$(Cd$(f))
.BlimBlam
	If Err<>0 Then Stop

	Okay=0
	r$=Upper$(SepSort$(n$,Cod))
	If r$=";"Or r$=""Then Goto FunkTurd
	If r$="ORG"Then FuncORG(n$,Cod):Goto BitterBit
	If r$="LD"Then FuncLD(n$,Cod):Goto BitterBit
	If r$="INC"Then FuncINC(n$,Cod):Goto BitterBit
	If r$="IN"Then FuncIN(n$,Cod):Goto BitterBit
	If r$="OUT"Then FuncOUT(n$,Cod):Goto BitterBit
	If r$="DEC"Then FuncDEC(n$,Cod):Goto BitterBit
	If r$="ADD"Then FuncADD(n$,Cod):Goto BitterBit
	If r$="ADC"Then FuncADC(n$,Cod):Goto BitterBit
	If r$="CP"Then FuncCP(n$,Cod):Goto BitterBit
	If r$="XOR"Then FuncXOR(n$,Cod):Goto BitterBit
	If r$="OR"Then FuncOR(n$,Cod):Goto BitterBit
	If r$="AND"Then FuncAND(n$,Cod):Goto BitterBit
	If r$="SUB"Then FuncSUB(n$,Cod):Goto BitterBit
	If r$="SBC"Then FuncSBC(n$,Cod):Goto BitterBit
	If r$="JR"Then FuncJR(n$,Cod):Goto BitterBit
	If r$="DJNZ"Then FuncDJNZ(n$,Cod):Goto BitterBit
	If r$="RST"Then FuncRST(n$,Cod):Goto BitterBit
	If r$="BIT"Then FuncBIT(n$,Cod):Goto BitterBit
	If r$="SET"Then FuncSET(n$,Cod):Goto BitterBit
	If r$="RES"Then FuncRES(n$,Cod):Goto BitterBit		
	If r$="RLC"Then FuncRLC(n$,Cod):Goto BitterBit
	If r$="RL"Then FuncRL(n$,Cod):Goto BitterBit
	If r$="RRC"Then FuncRRC(n$,Cod):Goto BitterBit
	If r$="RR"Then FuncRR(n$,Cod):Goto BitterBit  
	If r$="SLA"Then FuncSLA(n$,Cod):Goto BitterBit  
	If r$="SRA"Then FuncSRA(n$,Cod):Goto BitterBit
	If r$="SRL"Then FuncSRL(n$,Cod):Goto BitterBit 	
	If r$="EX"Then FuncEX(n$,Cod):Goto BitterBit
	If r$="IM"Then FuncIM(n$,Cod):Goto BitterBit
	If r$="CALL"Then FuncCall(n$,Cod):Goto BitterBit
	If r$="JP"Then FuncJP(n$,Cod):Goto BitterBit
	If r$="RET"Then FuncRET(n$,Cod):Goto BitterBit
	If r$="DAA"Then FuncDAA(n$,Cod):Goto BitterBit
	If r$="CPL"Then FuncCPL(n$,Cod):Goto BitterBit
	If r$="NEG"Then FuncNEG(n$,Cod):Goto BitterBit
	If r$="NOP"Then FuncNOP(n$,Cod):Goto BitterBit
	If r$="HALT"Then FuncHALT(n$,Cod):Goto BitterBit
	If r$="CCF"Then FuncCCF(n$,Cod):Goto BitterBit
	If r$="SCF"Then FuncSCF(n$,Cod):Goto BitterBit
	If r$="EI"Then FuncEI(n$,Cod):Goto BitterBit
	If r$="DI"Then FuncDI(n$,Cod):Goto BitterBit
	If r$="LDIR"Then FuncLDIR(n$,Cod):Goto BitterBit
	If r$="LDI"Then FuncLDI(n$,Cod):Goto BitterBit
	If r$="EXX"Then FuncEXX(n$,Cod):Goto BitterBit
	If r$="LDD"Then FuncLDD(n$,Cod):Goto BitterBit
	If r$="LDDR"Then FuncLDDR(n$,Cod):Goto BitterBit
	If r$="CPI"Then FuncCPI(n$,Cod):Goto BitterBit
	If r$="CPIR"Then FuncCPIR(n$,Cod):Goto BitterBit
	If r$="CPD"Then FuncCPD(n$,Cod):Goto BitterBit
	If r$="CPDR"Then FuncCPDR(n$,Cod):Goto BitterBit
	If r$="RETI"Then FuncRETI(n$,Cod):Goto BitterBit
	If r$="RETN"Then FuncRETN(n$,Cod):Goto BitterBit
	If r$="INI"Then FuncINI(n$,Cod):Goto BitterBit
	If r$="INIR"Then FuncINIR(n$,Cod):Goto BitterBit
	If r$="IND"Then FuncIND(n$,Cod):Goto BitterBit
	If r$="INDR"Then FuncINDR(n$,Cod):Goto BitterBit
	If r$="OUTI"Then FuncOUTI(n$,Cod):Goto BitterBit
	If r$="OTIR"Then FuncOTIR(n$,Cod):Goto BitterBit
	If r$="OUTD"Then FuncOUTD(n$,Cod):Goto BitterBit
	If r$="OTDR"Then FuncOTDR(n$,Cod):Goto BitterBit
	If r$="POP"Then FuncPOP(n$,Cod):Goto BitterBit
	If r$="PUSH"Then FuncPUSH(n$,Cod):Goto BitterBit
	If r$="RLCA"Then FuncRLCA(n$,Cod):Goto BitterBit
	If r$="RLA"Then FuncRLA(n$,Cod):Goto BitterBit
	If r$="RRCA"Then FuncRRCA(n$,Cod):Goto BitterBit
	If r$="RRA"Then FuncRRA(n$,Cod):Goto BitterBit
	If r$="RLD"Then FuncRLD(n$,Cod):Goto BitterBit
	If r$="RRD"Then FuncRRD(n$,Cod):Goto BitterBit
	If r$="DB"Or r$="DEFB" Or r$="DEFM" Or r$="DM" Then FuncDB(n$,Cod,0):Goto BitterBit
	If r$="DW"Or r$="DEFW"Then FuncDW(n$,Cod,0):Goto BitterBit
	If r$="DS"Or r$="DEFS"Then FuncDS(n$,Cod,0):Goto BitterBit

	If Okay=0 Then
		FuncAddLabel(n$,Cod)
		r$=Upper$(SepSort$(n$,Cod))
		If r$<>""Then Goto BlimBlam
		If r$=":"Then
			Cod=Cod+1
			Goto BlimBlam
		EndIf			
	EndIf

.BitterBit
	;**** Multiple commands on line
	If Okay=1 Then
		r$=Upper$(SepSort$(n$,Cod))
		If r$=":"Then
			Cod=Cod+1
			Goto BlimBlam
		EndIf	
	EndIf	
.FunkTurd
Next
	Fin(OrgVer)=PC
	For f=1 To LabCount
		LabRef(f)=0
	Next	

If Failed>=Failed3 Then Stop
If Failed>0 Then
	Failed3=Failed
	Failed=0
	Pass=Pass+1
	Goto LakePlacid
EndIf

OrgVer=OrgVer+1
If OrgVer=2 Then Goto LoopyLoo

;Print Lab$(8)
;Print LabV(8)

;ChangeDir"disk"
;Print CurrentDir$()
;filename$="cpcxfsw.exe -nd make -p assem.bb assem.bin"
;ExecFile(filename$)
;WaitKey()
;DeleteFile CurrentDir$()+"robs.dsk"

Orig=PeekShort(MemoryBank(1),Org(1)+6)
nr=1
Reloc$ = ""
p1=0
For f=Org(1) To Fin(1)
	Wert1=PeekShort(MemoryBank(1),f)
	Wert2=PeekShort(MemoryBank(2),f+258)
	If Wert1+258=Wert2 Then
		Reloc$=Reloc$+Chr$((nr+Orig-1)Mod 256)+Chr$(Int((nr+orig-1)/256))
		p1=p1+1
	EndIf
	nr=nr+1
Next

nr=Fin(1)-Org(1)
fileBank=WriteFile("disk\pass1.sym") 
	WriteBytes MemoryBank(1),fileBank,0,nr
CloseFile fileBank

nr=0
For f=Org(1) To Org(1)+7
	PokeByte MemoryBank(3),nr,PeekByte(MemoryBank(1),f)
	nr=nr+1
Next
PokeShort MemoryBank(3),8,p1
nr=10
For f=Org(1)+10 To Fin(1)
	PokeByte MemoryBank(3),nr,PeekByte(MemoryBank(1),f)
	nr=nr+1
Next
nr=Fin(1)-Org(1)
For f=1 To Len(Reloc$)
	PokeByte MemoryBank(3),nr,Asc(Mid$(Reloc$,f,1))
	nr=nr+1
Next

fileBank=WriteFile("disk\symbos.sym") 
	WriteBytes MemoryBank(3),fileBank,0,nr
CloseFile fileBank
ChangeDir(CDir$+"DISK")

;ee=FileSize("symbos1.dsk")
;fileopen=OpenFile("symbos1.dsk")
;Stop

filename$="cpcxfsw.exe symbos1 -p symbos.sym do.exe"
ExecFile(filename$)
;DeleteFile CurrentDir$()+"robs.dsk"
End


Function FuncAddLabel(s1$,Wrd)
	gt=0
	r$=Upper$(SepSort$(s1$,Cod))
	If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
	For f=1 To LabCount
		If Lab$(f)=r$ Then
			gt=f
			f=LabCount
		EndIf	
	Next
	If gt=0 Then
		LabCount=LabCount+1
		gt=LabCount
	EndIf
	LabRef(gt)=LabRef(gt)
	If LabRef(gt)>1 Then Stop				;*** Label already declared
	Lab$(gt)=r$
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$="EQU"Then
		LabT(gt)=1
		a=PC
		Cod=Cod+1
		Failed2=Failed
		t=GetNumber(s1$,1)
		If Failed2=Failed Then
			LabV(gt)=t
			LabOK(gt)=1
		Else
			LabV(gt)=0
			LabOK(gt)=0
		EndIf
	Else
		LabT(gt)=0
		LabV(gt)=PC
		LabOK(gt)=1
	EndIf
End Function
Function FuncCheckLabel(s1$,Wrd)
	gt=0
	If LabCount>0 Then
		r$=Upper$(SepSort$(s1$,Wrd))
		If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
		For f=1 To LabCount
			If Lab$(f)=r$ Then
				gt=f
				f=LabCount
			EndIf	
		Next
	EndIf
	Return gt
End Function
Function FuncDB(s1$,Wrd,Typ)
.Libble
	Cod=Cod+1
	r$=SepSort$(s1$,Cod)

	If Mid$(r$,1,1)=Chr$(34)Then
		For f=1 To Len(r$)
			p$=Mid$(r$,f,1)
			If p$<>Chr$(34)Then
				PokeByte MemBank,PC,Asc(p$):PC=PC+1
			EndIf
		Next
		Cod=Cod+1
	Else
		t=GetNumber(s1$,Typ)
		If Err=0 Then
			PokeByte MemBank,PC,t:PC=PC+1	
		EndIf
	EndIf

	If Err=0 Then
		r$=SepSort$(s1$,Cod)	
		If r$=","Then Goto Libble
	EndIf	

	Okay=1

End Function
Function FuncDW(s1$,Wrd,Typ)
.Libble2
	Cod=Cod+1
	r$=SepSort$(s1$,Cod)
	t=GetNumber(s1$,1)
	If Err=0 Then
		PokeByte MemBank,PC,t Mod 256:PC=PC+1
		PokeByte MemBank,PC,t/256:PC=PC+1		
	EndIf

	If Err=0 Then
		r$=SepSort$(s1$,Cod)	
		If r$=","Then Goto Libble2
	EndIf	
	Okay=1
End Function
Function FuncDS(s1$,Wrd,Typ)
.Libble3
	Cod=Cod+1
	r$=SepSort$(s1$,Cod)
	t=GetNumber(s1$,1)
	t2=0
	r$=SepSort$(s1$,Cod)
	If r$=","Then
		Cod=Cod+1
		t2=GetNumber(s1$,1)		
	EndIf
	If Err=0 Then
		For n=1 To t
			PokeByte MemBank,PC,t2:PC=PC+1
		Next
	EndIf
	If Err=0 Then
		r$=SepSort$(s1$,Cod)	
		If r$=","Then Goto Libble3
	EndIf	
	Okay=1
End Function
Function FuncORG(s1$,Wrd)
	Cod=Cod+1
	r$=SepSort$(s1$,Cod)
	t=GetNumber(s1$,1)
	If OrgVer=2 Then
		t=t+258
	EndIf
	Okay=1
	PC=t
	Org(OrgVer)=t
End Function
Function GetNumber(s1$,Typ=0)
	;**** Typ 0 = 8bit 1 = 16bit
	Total=0
	Add1=1
	Add2=0
.Lumpy	
	r$=Upper$(SepSort$(s1$,Cod))
	sign=0
	If r$="+"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))		
	EndIf
	If r$="-"Then
		sign=1
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))
	EndIf
	If Mid$(r$,1,1)="#" Or Mid$(r$,1,1)="&" Then
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))
		Tot2=GetHex(r$,Typ,sign)
		Goto Binder
	EndIf
	If Mid$(r$,1,1)="%"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))
		Tot2=GetBinary(r$,Typ,sign)
		Goto Binder
	EndIf
	If Mid$(r$,1,1)>="0" And Mid$(r$,1,1)<="9"Then
		Tot2=GetDecimal(r$,Typ,sign)		
		Goto Binder
	EndIf

	t=FuncCheckLabel(s1$,Cod)
	If t=0 Then
		Failed=Failed+1
		Tot2=0
		Goto Binder
	Else
		If LabOK(t)=1 Then 
			Tot2=LabV(t)
			Goto Binder
		Else
			Failed=Failed+1
			Tot2=0
			Goto Binder
		EndIf	
	EndIf
.Binder
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$="+"Then Add2=1
	If r$="-"Then Add2=2
	If r$="/"Then Add2=3
	If r$="*"Then Add2=4
	If Add1=1 Then Total=Total+Tot2
	If Add1=2 Then Total=Total-Tot2
	If Add1=3 Then Total=Total/Tot2
	If Add1=4 Then Total=Total*Tot2
	If Add2>0 Then
		Add1=Add2
		Add2=0
		Cod=Cod+1
		Goto Lumpy
	EndIf
	Return Total
End Function
Function GetBinary(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		If a$<>"0" And a$<>"1"Then
			err=99
			Failed=1
			Return 0
		EndIf	
		If a$="1"Then
			Tot2=Tot2+Base
		EndIf
		Base=Base*2
	Next

	If re=0 Then   ;**** 8 Bit
		If Tot2<0 Or Tot2>255 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=32768-Tot2
		EndIf	
	EndIf
	Return Tot2
End Function
Function GetHex(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		n=-1
		If a$=>"0" And a$<="9" Then
			n=Asc(a$)-48
		EndIf
		If a$=>"A" And a$<="F"Then
			n=Asc(a$)-55
		EndIf
		If n=-1 Then
			err=99
			Failed=1
			Return 0
		EndIf	
		Tot2=Tot2+(n*Base)
		Base=Base*16
	Next

	If re=0 Then   ;**** 8 Bit
		If Tot2<0 Or Tot2>255 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=32768-Tot2
		EndIf	
	EndIf
	Return Tot2
	
End Function
Function GetDecimal(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		n=-1
		If a$=>"0" And a$<="9" Then
			n=Asc(a$)-48
		Else
			err=99
			Failed=1
			Return 0
		EndIf	
		Tot2=Tot2+(n*Base)
		Base=Base*10
	Next
	If re=0 Then   ;**** 8 Bit
		If Tot2<0 Or Tot2>255 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=65536-Tot2
		EndIf
	EndIf
	Return Tot2	
End Function
Function GetCC(s2$)
	e1=-1
	If s2$="NZ"Then e1=0
	If s2$="Z"Then e1=1
	If s2$="NC" Then e1=2
	If s2$="C"Then e1=3
	If s2$="PO"Then e1=4
	If s2$="PE"Then e1=5
	If s2$="P"Then e1=6
	If s2$="M"Then e1=7
	Return e1
End Function
Function GetQQ(s2$)
	e1=-1
	If s2$="BC"Then e1=0
	If s2$="DE"Then e1=1
	If s2$="HL"Then e1=2
	If s2$="AF"Then e1=3
	Return e1
End Function	
Function FuncADD(s1$,Wrd)
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(s1$,Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	If n1=23 And (n2>=16 And n2<=23) Then				;***** ADD A,r
		PokeByte MemBank,PC,128+(n2-16):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=23 And n2=81 Then				;***** ADD A,N
		PokeByte MemBank,PC,198:PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	EndIf		
	If n1=23 And n2=67 Then								;***** ADD A,(HL)
		PokeByte MemBank,PC,134:PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** ADD A,(IX+n) (IY+n)
		If n2=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,134:PC=PC+1			;x 10 000 110		
		EndIf
		If n2=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,134:PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n2t:PC=PC+1				;data
		Okay=1
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then				;***** ADD HL,ss
		PokeByte MemBank,PC,((n2-2)*16)+9:PC=PC+1		;x 00 ss1 001
		Okay=1
	EndIf	

	If n1=6 And (n2=2 Or n2=3 Or n2=6 Or n2=5) Then				;***** ADD IX,pp
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		b=9
		If n2=3 Then b=b+(1*16)
		If n2=6 Then b=b+(2*16)
		If n2=5 Then b=b+(3*16)
		PokeByte MemBank,PC,b:PC=PC+1			;x 00 pp1 001
		Okay=1
	EndIf
	If n1=7 And (n2=2 Or n2=3 Or n2=7 Or n2=5) Then				;***** ADD IY,rr
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		b=9
		If n2=3 Then b=b+(1*16)
		If n2=7 Then b=b+(2*16)
		If n2=5 Then b=b+(3*16)
		PokeByte MemBank,PC,b:PC=PC+1			;x 00 pp1 001
		Okay=1
	EndIf
End Function
Function FuncADC(s1$,Wrd)
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(s1$,Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	b=1

	If n1=23 And (n2>=16 And n2<=23) Then				;***** ADC A,r
		PokeByte MemBank,PC,128+(n2-16)+(b*8):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=23 And n2=81 Then				;***** ADC A,N
		PokeByte MemBank,PC,198+(b*8):PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	EndIf		
	If n1=23 And n2=67 Then								;***** ADC A,(HL)
		PokeByte MemBank,PC,134+(b*8):PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** ADC A,(IX+n) (IY+n)
		If n2=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,134+(b*8):PC=PC+1			;x 10 000 110		
		EndIf
		If n2=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,134+(b*8):PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n2t:PC=PC+1				;data
		Okay=1
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then				;***** ADC HL,ss
		PokeByte MemBank,PC,237:PC=PC+1				;&ed	
		PokeByte MemBank,PC,((n2-2)*16)+74:PC=PC+1		;x 01 ss1 010
		Okay=1
	EndIf	
End Function
Function FuncSBC(s1$,Wrd)
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(s1$,Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	b=3
	If n1=23 And (n2>=16 And n2<=23) Then				;***** SBC A,r
		PokeByte MemBank,PC,128+(n2-16)+(b*8):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=23 And n2=81 Then				;***** SBC A,N
		PokeByte MemBank,PC,198+(b*8):PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	EndIf		
	If n1=23 And n2=67 Then								;***** SBC A,(HL)
		PokeByte MemBank,PC,134+(b*8):PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** SBC A,(IX+n) (IY+n)
		If n2=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,134+(b*8):PC=PC+1			;x 10 000 110		
		EndIf
		If n2=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,134+(b*8):PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n2t:PC=PC+1				;data
		Okay=1
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then				;***** SBC HL,ss
		PokeByte MemBank,PC,237:PC=PC+1				;&ed	
		PokeByte MemBank,PC,((n2-2)*16)+66:PC=PC+1		;x 01 ss0 010
		Okay=1
	EndIf	
End Function
Function FuncCP(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=7

	If n1>=16 And n1<=23 Then				;***** CP r
		PokeByte MemBank,PC,128+(n1-16)+(b*8):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=81 Then				;***** cp n
		PokeByte MemBank,PC,(b*8)+198:PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		Okay=1
	EndIf		
	If n1=67 Then									;***** cp (HL)
		PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1>=71 And n1<=72 Then					;***** cp (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1				;&dd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1				;&fd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1					;data
		Okay=1
	EndIf
End Function
Function FuncOR(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=6

	If n1>=16 And n1<=23 Then				;***** OR r
		PokeByte MemBank,PC,128+(n1-16)+(b*8):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=81 Then				;***** OR n
		PokeByte MemBank,PC,(b*8)+198:PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		Okay=1
	EndIf		
	If n1=67 Then									;***** OR (HL)
		PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1>=71 And n1<=72 Then					;***** OR (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1				;&dd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1				;&fd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1					;data
		Okay=1
	EndIf
End Function
Function FuncXOR(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=5

	If n1>=16 And n1<=23 Then				;***** XOR r
		PokeByte MemBank,PC,128+(n1-16)+(b*8):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=81 Then				;***** XOR n
		PokeByte MemBank,PC,(b*8)+198:PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		Okay=1
	EndIf		
	If n1=67 Then									;***** XOR (HL)
		PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1>=71 And n1<=72 Then					;***** XOR (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1				;&dd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1				;&fd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1					;data
		Okay=1
	EndIf
End Function
Function FuncAND(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=4

	If n1>=16 And n1<=23 Then				;***** AND r
		PokeByte MemBank,PC,128+(n1-16)+(b*8):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=81 Then				;***** AND n
		PokeByte MemBank,PC,(b*8)+198:PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		Okay=1
	EndIf		
	If n1=67 Then									;***** AND (HL)
		PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1>=71 And n1<=72 Then					;***** AND (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1				;&dd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1				;&fd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1					;data
		Okay=1
	EndIf
End Function
Function FuncSUB(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=2

	If n1>=16 And n1<=23 Then				;***** SUB r
		PokeByte MemBank,PC,128+(n1-16)+(b*8):PC=PC+1			;x 10 000 r		
		Okay=1
	EndIf
	If n1=81 Then				;***** SUB n
		PokeByte MemBank,PC,(b*8)+198:PC=PC+1			;x 11 000 110
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		Okay=1
	EndIf		
	If n1=67 Then									;***** SUB (HL)
		PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110
		Okay=1
	EndIf	
	If n1>=71 And n1<=72 Then					;***** SUB (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1				;&dd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1				;&fd
			PokeByte MemBank,PC,(b*8)+134:PC=PC+1			;x 10 000 110			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1					;data
		Okay=1
	EndIf
End Function
Function FuncSET(s1$,Wrd)
	n1=0
	Cod=Cod+1
	b1=GetNumber(s1$,0)
	If b1<0 Or b1>7 Then
		Err=97
		Return
	EndIf
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		err=97
		Return
	EndIf
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then			;SET b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+64+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	If n1=67 Then						;SET b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b 110
		Okay=1
	EndIf
	If n1=71 Then						;SET b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	If n1=72 Then						;SET b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	Cod=Cod+1
End Function
Function FuncRES(s1$,Wrd)
	n1=0
	Cod=Cod+1
	b1=GetNumber(s1$,0)
	If b1<0 Or b1>7 Then
		Err=97
		Return
	EndIf
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		err=97
		Return
	EndIf
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then			;RES b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	If n1=67 Then						;RES b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+6+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b 110
		Okay=1
	EndIf
	If n1=71 Then						;RES b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+128+6
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	If n1=72 Then						;RES b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+128+6
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	Cod=Cod+1
End Function
Function FuncBIT(s1$,Wrd)
	n1=0
	Cod=Cod+1
	b1=GetNumber(s1$,0)
	If b1<0 Or b1>7 Then
		Err=97
		Return
	EndIf
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		err=97
		Return
	EndIf
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then			;BIT b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+64
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	If n1=67 Then						;BIT b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	If n1=71 Then						;BIT b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	If n1=72 Then						;BIT b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1
	EndIf
	Cod=Cod+1
End Function
Function FuncSRL(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	b=7
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1
	EndIf
End Function
Function FuncSRA(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	b=5
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1
	EndIf
End Function
Function FuncSLA(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	b=4
	n1t=n1/256
	n1=n1 Mod 256
	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1
	EndIf
End Function
Function FuncRR(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	b=3
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1
	EndIf
End Function
Function FuncRRC(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	b=1
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1
	EndIf
End Function
Function FuncRL(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	b=2
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1
	EndIf
End Function
Function FuncRLC(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	b=0
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1
	EndIf
End Function
Function FuncDEC(s1$,Wrd)
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)

	n1t=n1/256
	n1=n1 Mod 256

	If n1=6 Then				;***** DEC IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,43:PC=PC+1			;&2b
		Okay=1
	EndIf
	If n1=7 Then				;***** DEC IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,43:PC=PC+1			;&2b		
		Okay=1
	EndIf
	If n1>=2 And n1<=5 Then				;***** DEC ss
		n2=(n1-2)*16+11
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 ss1 011		
		Okay=1
	EndIf
	If n1=67 Then					;***** DEC (HL)
		PokeByte MemBank,PC,53:PC=PC+1			;x 00 110 101
		Okay=1
	EndIf
	If n1>=16 And n1<=23 Then				;***** DEC r
		n2=(n1-16)*8+5
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 r 101		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** DEC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd		
		EndIf
		PokeByte MemBank,PC,53:PC=PC+1			;x 110101
		PokeByte MemBank,PC,n1t:PC=PC+1			;
		Okay=1
	EndIf
End Function
Function FuncINC(s1$,Wrd) 
	n1=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)

	n1t=n1/256
	n1=n1 Mod 256

	If n1=6 Then				;***** INC IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,35:PC=PC+1			;&23		
		Okay=1
	EndIf
	If n1=7 Then				;***** INC IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,35:PC=PC+1			;&23		
		Okay=1
	EndIf
	If n1>=2 And n1<=5 Then				;***** INC ss
		n2=(n1-2)*16+3
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 ss0 011		
		Okay=1
	EndIf
	If n1=67 Then					;***** INC (HL)
		PokeByte MemBank,PC,52:PC=PC+1			;x 00 110 100
		Okay=1	
	EndIf
	If n1>=16 And n1<=23 Then				;***** INC r
		n2=(n1-16)*8+4
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 r 100		
		Okay=1
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd		
		EndIf
		PokeByte MemBank,PC,52:PC=PC+1			;x 110100
		PokeByte MemBank,PC,n1t:PC=PC+1			;
		Okay=1
	EndIf

End Function
Function FuncIN(s1$,Wrd)
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		Err=97
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(s1$,Cod)

	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n1=23 And n2=80 Then					;* IN a,(n)
		PokeByte MemBank,PC,219:PC=PC+1			;&DB
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	EndIf
	If n1=>16 And n1<=23 And n2=70 Then		; IN r,(C)
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,((n1-16)*8)+64:PC=PC+1			;x 01 r 000
		Okay=1
	EndIf
End Function
Function FuncOUT(s1$,Wrd)
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		Err=97
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(s1$,Cod)

	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n2=23 And n1=80 Then			
		PokeByte MemBank,PC,211:PC=PC+1			;&D3
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Okay=1
	EndIf
	If n2=>16 And n2<=23 And n1=70 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,((n2-16)*8)+65:PC=PC+1			;x 01 r 001
		Okay=1
	EndIf
End Function
Function FuncLD(s1$,Wrd)
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(s1$,Cod)
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then
		Err=97
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(s1$,Cod)

	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	If n2=23 And n1=80 Then 			;**** LD (nn),a
		PokeByte MemBank,PC,50:PC=PC+1	;&32
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;data 1		
		Okay=1
	End If
	If n1=23 And n2=80 Then 			;**** LD a,(nn)
		PokeByte MemBank,PC,58:PC=PC+1	;&3a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1		
		Okay=1
	End If
	If n1=>2 And n1<=5 And n2=81 Then 			;**** LD dd,nn
		PokeByte MemBank,PC,((n1-2)*16)+1:PC=PC+1			;x 00 dd0 001	
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1		
		Okay=1
	End If
	If n1=6 And n2=81 Then 			;**** LD IX,nn
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,33:PC=PC+1			;&21
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1		
		Okay=1
	End If
	If n1=7 And n2=81 Then 			;**** LD IY,nn
		PokeByte MemBank,PC,253:PC=PC+1			;&fd	
		PokeByte MemBank,PC,33:PC=PC+1			;&21
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1		
		Okay=1
	End If	


	If n1>=16 And n1<=23 And n2=81 Then 			;**** LD r,n
		PokeByte MemBank,PC,((n1-16)*8)+6:PC=PC+1			;x 00 r 110	
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	End If
	If n1=67 And n2=81 Then 			;**** LD (HL),n
		PokeByte MemBank,PC,54:PC=PC+1			;&36	
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	End If
	If n1=71 And n2=81 Then 			;**** LD (IX+ ),n
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,54:PC=PC+1			;&36			
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		PokeByte MemBank,PC,n2t:PC=PC+1			;ix+data
		Okay=1
	EndIf
	If n1=72 And n2=81 Then 			;**** LD (IY+ ),n
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,54:PC=PC+1			;&36			
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		PokeByte MemBank,PC,n2t:PC=PC+1			;ix+data
		Okay=1
	EndIf	
	If (n2>=16 And n2<=23) And n1=71 Then 	;**** LD (IX+ ),r
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Okay=1
	EndIf
	If (n2>=16 And n2<=23) And n1=72 Then 	;**** LD (IY+ ),r
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Okay=1
	EndIf
	If (n1>=16 And n1<=23) And n2=71 Then 	;**** LD r,(IX+ )
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		n9=(n1-16)*8+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 101
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	EndIf
	If (n1>=16 And n1<=23) And n2=72 Then 	;**** LD r,(IY+ )
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		n9=(n1-16)*8+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 110
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1
	EndIf

	If (n2>=16 And n2<=23) And n1=67 Then 	;**** LD (HL),r
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		Okay=1
	End If
	If (n1>=16 And n1<=23) And n2=67 Then 	;**** LD r,(HL)
		n9=((n1-16)*8)+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 110
		Okay=1
	End If

	If n1=23 And n2=64 Then			;***** LD A,(BC)
		PokeByte MemBank,PC,10:PC=PC+1			;&0a
		Okay=1
	EndIf
	If n1=64 And n2=23 Then			;***** LD (BC),A
		PokeByte MemBank,PC,2:PC=PC+1			;&02
		Okay=1
	EndIf
	If n1=23 And n2=65 Then			;***** LD A,(DE)
		PokeByte MemBank,PC,26:PC=PC+1			;&1a
		Okay=1
	EndIf
	If n1=65 And n2=23 Then			;***** LD (DE),A
		PokeByte MemBank,PC,18:PC=PC+1			;&12
		Okay=1
	EndIf
	

	If n1=4 And n2=80 Then			;***** LD HL,(nn)
		PokeByte MemBank,PC,42:PC=PC+1			;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh		
		Okay=1
	EndIf
	If n1=2 And n2=80 Then			;***** LD BC,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,75:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh		
		Okay=1
	EndIf
	If n1=3 And n2=80 Then			;***** LD DE,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,91:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh		
		Okay=1
	EndIf
	If n1=5 And n2=80 Then			;***** LD SP,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,123:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh		
		Okay=1
	EndIf	
	If n1=6 And n2=80 Then			;***** LD IX,(nn)
		PokeByte MemBank,PC,221:PC=PC+1				;&ed
		PokeByte MemBank,PC,42:PC=PC+1				;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh		
		Okay=1
	EndIf	
	If n1=7 And n2=80 Then			;***** LD IY,(nn)
		PokeByte MemBank,PC,253:PC=PC+1				;&ed
		PokeByte MemBank,PC,42:PC=PC+1				;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh		
		Okay=1
	EndIf	


	
	If n1=80 And n2=4 Then			;***** LD (nn),HL
		PokeByte MemBank,PC,34:PC=PC+1			;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh		
		Okay=1
	EndIf
	If n1=80 And n2=2 Then			;***** LD (nn),BC
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,67:PC=PC+1				;x 01 dd 00 11
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh		
		Okay=1
	EndIf
	If n1=80 And n2=3 Then			;***** LD (nn),DE
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,83:PC=PC+1				;x 01 dd 00 11		
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh		
		Okay=1
	EndIf
	If n1=80 And n2=5 Then			;***** LD (nn),SP
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,115:PC=PC+1				;x 01 dd 00 11		
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh		
		Okay=1
	EndIf	
	If n1=80 And n2=6 Then			;***** LD (nn),IX
		PokeByte MemBank,PC,221:PC=PC+1				;&dd
		PokeByte MemBank,PC,34:PC=PC+1				;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh		
		Okay=1
	EndIf
	If n1=80 And n2=7 Then			;***** LD (nn),IY
		PokeByte MemBank,PC,253:PC=PC+1				;&fd
		PokeByte MemBank,PC,34:PC=PC+1				;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh		
		Okay=1
	EndIf		
	
	If n1>=16 And n1<=23 And n2=>16 And n2<=23 Then			;***** LD r,r
		r1=((n1-16)*8)+(n2-16)+64
		PokeByte MemBank,PC,r1:PC=PC+1			;x  01 r r
		Okay=1		
	EndIf

	If n1=5 And n2=4 Then 			;***** LD SP,HL
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Okay=1		
	EndIf
	If n1=5 And n2=6 Then 			;***** LD SP,IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Okay=1		
	EndIf
	If n1=5 And n2=7 Then 			;***** LD SP,IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Okay=1		
	EndIf	

	If n1=32 And n2=23 Then			;***** LD R,A
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,79:PC=PC+1			;&4f
		Okay=1		
	EndIf
	If n1=23 And n2=32 Then			;***** LD A,R
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,95:PC=PC+1			;&5f
		Okay=1		
	EndIf
	If n1=33 And n2=23 Then			;***** LD I,A
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,71:PC=PC+1			;&47
		Okay=1		
	EndIf
	If n1=23 And n2=33 Then			;***** LD A,I
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,87:PC=PC+1			;&57
		Okay=1		
	EndIf

End Function

Function GetRegister(s1$,Wrd)
	r$=Upper$(SepSort$(s1$,Cod))
	If r$="AF"Then
		Cod=Cod+1
		Return 1
	EndIf	
	If r$="BC"Then
		Cod=Cod+1
		Return 2
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		Return 3
	EndIf
	If r$="HL"Then
		Cod=Cod+1
		Return 4
	EndIf	
	If r$="SP"Then
		Cod=Cod+1
		Return 5
	EndIf
	If r$="IX"Then
		Cod=Cod+1
		Return 6
	EndIf
	If r$="IY"Then
		Cod=Cod+1
		Return 7
	EndIf

	If r$="B"Then
		Cod=Cod+1
		Return 16
	EndIf
	If r$="C"Then
		Cod=Cod+1
		Return 17
	EndIf
	If r$="D"Then
		Cod=Cod+1
		Return 18
	EndIf	
	If r$="E"Then
		Cod=Cod+1
		Return 19
	EndIf
	If r$="H"Then
		Cod=Cod+1
		Return 20
	EndIf
	If r$="L"Then
		Cod=Cod+1
		Return 21
	EndIf
	If r$="A"Then
		Cod=Cod+1
		Return 23
	EndIf

	If r$="R"Then
		Cod=Cod+1
		Return 32
	EndIf
	If r$="I"Then
		Cod=Cod+1
		Return 33
	EndIf

	If r$="("Then Goto BracketStuff

	b1=GetNumber(s1$,1)
	Return (b1*256)+81
	Okay=1

.BracketStuff
	a=0
	t=0
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$="BC"Then
		Cod=Cod+1
		a=64
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		a=65
	EndIf
	If r$="HL"Then
		Cod=Cod+1
		a=67
	EndIf
	If r$="AF"Then
		Cod=Cod+1
		a=68
	EndIf
	If r$="SP"Then
		Cod=Cod+1
		a=69
	EndIf
	If r$="C"Then
		Cod=Cod+1
		a=70
	EndIf
	If r$="IX"Then
		Cod=Cod+1
		a=71
		r$=Upper$(SepSort$(s1$,Cod))
		If r$="+"Then
			Cod=Cod+1
			t=GetNumber(s1$,Cod)
		EndIf
	EndIf
	If r$="IY"Then
		Cod=Cod+1
		a=72
		r$=Upper$(SepSort$(s1$,Cod))
		If r$="+"Then
			Cod=Cod+1
			t=GetNumber(s1$,Cod)
		EndIf
	EndIf
	If a=0 Then
		t=GetNumber(s1$,Cod)
		a=80
		Okay=1
	EndIf
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>")"Then Stop
	Cod=Cod+1
	Return a+(t*256)
End Function

Function FuncEX(s1$,Wrd)
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$="AF"Then Goto EXAf
	If r$="DE"Then Goto EXDe
	If r$="("Then Goto EXBrack
.EXErr
	Err=97
	Return
.EXAf
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then Goto EXErr
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>"AF"Then Goto EXErr
	PokeByte MemBank,PC,8:PC=PC+1			;&08
	Okay=1
	Cod=Cod+1
	Return
.EXDe
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then Goto EXErr
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>"HL"Then Goto EXErr
	PokeByte MemBank,PC,235:PC=PC+1			;&eb
	Okay=1
	Cod=Cod+1
	Return
.EXBrack
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>"SP"Then Goto EXErr	
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>")"Then Goto EXErr	
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>","Then Goto EXErr		
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	n=0
	If r$="HL"Then
		n=1
		PokeByte MemBank,PC,227:PC=PC+1			;&e3
		Okay=1
		Cod=Cod+1	
	EndIf
	If r$="IX"Then
		n=1
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,227:PC=PC+1			;&e3
		Okay=1
		Cod=Cod+1	
	EndIf
	If r$="IY"Then
		n=1
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,227:PC=PC+1			;&e3
		Okay=1
		Cod=Cod+1	
	EndIf
	If n=0 Then Goto EXErr
End Function
Function FuncPop(s1$,Wrd)
	r$=Upper$(SepSort$(s1$,Wrd+1))	
	h=GetQQ(r$)	
	If h>=0 And h<=3 Then
		h1=193+(h*16)
		PokeByte MemBank,PC,193+(h*16):PC=PC+1			;x11 qq0 001
		Cod=Cod+2
		Okay=1
	EndIf
	If h=-1 Then
		If r$="IX"Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,225:PC=PC+1			;&e1
			Cod=Cod+2
			Okay=1
		EndIf
		If r$="IY"Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,225:PC=PC+1			;&e1
			Cod=Cod+2
			Okay=1
		EndIf	
	EndIf	
End Function
Function FuncIM(s1$,Wrd)
	Cod=Cod+1
	t=GetNumber(s1$,0)
	If t<0 Or t>2 Then
		Err=97
		Return
	EndIf
	If t=0 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,70:PC=PC+1			;&46
		Cod=Cod+1
		Okay=1
	EndIf	
	If t=1 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,86:PC=PC+1			;&56
		Cod=Cod+1
		Okay=1
	EndIf
	If t=2 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,94:PC=PC+1			;&5e
		Cod=Cod+1
		Okay=1
	EndIf	
End Function	
Function FuncPush(s1$,Wrd)
	r$=Upper$(SepSort$(s1$,Wrd+1))	
	h=GetQQ(r$)	
	If h>=0 And h<=3 Then
		h1=197+(h*16)
		PokeByte MemBank,PC,197+(h*16):PC=PC+1			;x11 qq0 101
		Cod=Cod+2
		Okay=1
	EndIf
	If h=-1 Then
		If r$="IX"Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,229:PC=PC+1			;&e5
			Cod=Cod+2
			Okay=1
		EndIf
		If r$="IY"Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,229:PC=PC+1			;&e5
			Cod=Cod+2
			Okay=1
		EndIf	
	EndIf	
End Function
Function FuncCALL(s1$,Wrd)
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=196+(h*8)
		PokeByte MemBank,PC,h1:PC=PC+1			;x11 cc 100		
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))
		If r$<>","Then
			Err=97
			Return
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,205:PC=PC+1			;&cd	
	EndIf
	t=GetNumber(s1$,1)
	t1=t Mod 256
	t2=(t/256)Mod 256
	PokeByte MemBank,PC,t1:PC=PC+1
	PokeByte MemBank,PC,t2:PC=PC+1
	Return
End Function	
Function FuncRST(s1$,Wrd)
	Cod=Cod+1
	b3=Failed
	t=GetNumber(s1$,1)
	b=0
	If t=8 Then b=1
	If t=16 Then b=2
	If t=24 Then b=3
	If t=32 Then b=4
	If t=40 Then b=5
	If t=48 Then b=6
	If t=56 Then b=7
	PokeByte MemBank,PC,(b*8)+199:PC=PC+1
	Okay=1
End Function
Function FuncDJNZ(s1$,Wrd)
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	b3=Failed
	t=GetNumber(s1$,1)	
	If b3=Failed Then
		t=t-pc-2
		If t>128 Or t<-127 Then Stop
	Else
		t=0
	EndIf
	PokeByte MemBank,PC,16:PC=PC+1				
	PokeByte MemBank,PC,t:PC=PC+1
	Okay=1
	Cod=Cod+1
	Return
End Function
Function FuncJR(s1$,Wrd)
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	b=0
	If r$="C"Then b=1
	If r$="NC"Then b=2
	If r$="Z"Then b=3
	If r$="NZ"Then b=4
	If b>0 Then
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))		
		If r$<>","Then
			ERR=97
			Return
		Else
			Cod=Cod+1
			r$=Upper$(SepSort$(s1$,Cod))
		EndIf	
	EndIf
	b3=Failed
	t=GetNumber(s1$,1)	
	If b3=Failed Then
		t=t-pc-2
		If t>128 Or t<-127 Then Stop
	Else
		t=0
	EndIf
	If b=0 Then t1=24				;JR e 	&18
	If b=1 Then t1=56				;JR c,e  &38
	If b=2 Then t1=48				;JR nc,e  &30
	If b=3 Then t1=40				;JR z,e	  &28
	If b=4 Then t1=32   			;jr nz,e  &20
	PokeByte MemBank,PC,t1:PC=PC+1				
	PokeByte MemBank,PC,t:PC=PC+1
	Okay=1
	Cod=Cod+1
	Return
End Function
Function FuncJP(s1$,Wrd)
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$="("Then Goto Jumping2
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=194+(h*8)
		PokeByte MemBank,PC,h1:PC=PC+1			;x11 cc 010		
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))
		If r$<>","Then
			Err=97
			Return
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(s1$,Cod))
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,195:PC=PC+1			;&c3	
	EndIf
	t=GetNumber(s1$,1)
	t1=t Mod 256
	t2=(t/256)Mod 256
	PokeByte MemBank,PC,t1:PC=PC+1
	PokeByte MemBank,PC,t2:PC=PC+1
	Return

.Jumping2
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	n=0
	If r$="HL"Then
		PokeByte MemBank,PC,233:PC=PC+1			;#e9
		n=1			
	EndIf
	If r$="IX"Then
		PokeByte MemBank,PC,221:PC=PC+1			;#dd
		PokeByte MemBank,PC,233:PC=PC+1			;#e9		
		n=1			
	EndIf
	If r$="IY"Then
		PokeByte MemBank,PC,253:PC=PC+1			;#fd
		PokeByte MemBank,PC,233:PC=PC+1			;#e9		
		n=1			
	EndIf
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))
	If r$<>")"Then n=0	
	If n=0 Then
		Err=97
	Else
		Okay=1
		Cod=Cod+1
	EndIf
End Function
Function FuncRET(s1$,Wrd)
	Cod=Cod+1
	r$=Upper$(SepSort$(s1$,Cod))	
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=192+(h*8)
		PokeByte MemBank,PC,192+(h*8):PC=PC+1			;x11 cc 000
		Cod=Cod+1
		Okay=1	
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,201:PC=PC+1			;&c9
		Okay=1		
	EndIf
End Function
Function FuncRLCA(s1$,Wrd)
	PokeByte MemBank,PC,7:PC=PC+1			;&07
	Cod=Cod+1
	Okay=1
End Function
Function FuncRLA(s1$,Wrd)
	PokeByte MemBank,PC,23:PC=PC+1			;&17
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRCA(s1$,Wrd)
	PokeByte MemBank,PC,15:PC=PC+1			;&0f
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRA(s1$,Wrd)
	PokeByte MemBank,PC,31:PC=PC+1			;&1f
	Cod=Cod+1
	Okay=1
End Function
Function FuncRLD(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,111:PC=PC+1			;&6f	
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRD(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,103:PC=PC+1			;&67	
	Cod=Cod+1
	Okay=1
End Function
Function FuncNOP(s1$,Wrd)
	PokeByte MemBank,PC,0:PC=PC+1			;&0
	Cod=Cod+1
	Okay=1
End Function
Function FuncEXX(s1$,Wrd)
	PokeByte MemBank,PC,217:PC=PC+1			;&d9
	Cod=Cod+1
	Okay=1
End Function
Function FuncRETI(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,77:PC=PC+1			;&4d
	Cod=Cod+1
	Okay=1
End Function
Function FuncRETN(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,69:PC=PC+1			;&45
	Cod=Cod+1
	Okay=1
End Function
Function FuncINI(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,162:PC=PC+1			;&a2
	Cod=Cod+1
	Okay=1
End Function
Function FuncINIR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,178:PC=PC+1			;&b2
	Cod=Cod+1
	Okay=1
End Function
Function FuncIND(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,170:PC=PC+1			;&aa
	Cod=Cod+1
	Okay=1
End Function
Function FuncINDR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,186:PC=PC+1			;&ba
	Cod=Cod+1
	Okay=1
End Function
Function FuncOUTI(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,163:PC=PC+1			;&a3
	Cod=Cod+1
	Okay=1
End Function
Function FuncOTIR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,179:PC=PC+1			;&b3
	Cod=Cod+1
	Okay=1
End Function
Function FuncOUTD(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,171:PC=PC+1			;&ab
	Cod=Cod+1
	Okay=1
End Function
Function FuncOTDR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,139:PC=PC+1			;&8b
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDD(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,168:PC=PC+1			;&a8
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDDR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,184:PC=PC+1			;&b8	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPI(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,161:PC=PC+1			;&a1	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPIR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,177:PC=PC+1			;&b1	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPD(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,169:PC=PC+1			;&a9	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPDR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,185:PC=PC+1			;&b9	
	Cod=Cod+1
	Okay=1
End Function
Function FuncHALT(s1$,Wrd)
	PokeByte MemBank,PC,118:PC=PC+1			;&76
	Cod=Cod+1
	Okay=1
End Function
Function FuncCCF(s1$,Wrd)
	PokeByte MemBank,PC,63:PC=PC+1			;&3f
	Cod=Cod+1
	Okay=1
End Function
Function FuncSCF(s1$,Wrd)
	PokeByte MemBank,PC,55:PC=PC+1			;&37
	Cod=Cod+1
	Okay=1
End Function
Function FuncDAA(s1$,Wrd)
	PokeByte MemBank,PC,39:PC=PC+1			;&27
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPL(s1$,Wrd)
	PokeByte MemBank,PC,47:PC=PC+1			;&2f
	Cod=Cod+1
	Okay=1
End Function
Function FuncNEG(s1$,Wrd)
	PokeByte MemBank,PC,251:PC=PC+1			;&ed
	PokeByte MemBank,PC,251:PC=PC+1			;&44	
	Cod=Cod+1
	Okay=1
End Function
Function FuncEI(s1$,Wrd)
	PokeByte MemBank,PC,251:PC=PC+1			;&fb
	Cod=Cod+1
	Okay=1
End Function
Function FuncDI(s1$,Wrd)
	PokeByte MemBank,PC,243:PC=PC+1			;&f3
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDIR(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,176:PC=PC+1			;&b0
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDI(s1$,Wrd)
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,160:PC=PC+1			;&a0
	Cod=Cod+1
	Okay=1
End Function
Function SepSort$(s1$,q10=1)
	q11=0
	For f1=1 To q10
		q12=q11+1
		q11=Instr(s1$,Chr$(200),q12)
		If q11=0 Then
			q12=0
			f1=q10+1
		EndIf	
	Next
	If q12>0 Then
		Return Mid$(s1$,q12,q11-q12)
	Else
		Return ""
	EndIf
End Function

Function Seperate$(s1$,Fail=0)
	s3$=""
	s2$=""
	qo=0
	If Len(s1$)>0 Then
		For f1=1 To Len(s1$)
			s4$=Mid$(s1$,f1,1)
			If s4$=Chr$(34)Then
				If qo=0 Then
					If s3$>"" Then
						s2$=s2$+s3$+Chr$(200)
						s3$=s4$
					EndIf
					qo=1
				Else
					s2$=s2$+s3$+s4$+Chr$(200)
					s3$=""
					qo=0
				EndIf	
			EndIf

			If qo=1 Then
				s3$=s3$+s4$
			Else	
				If s4$=","Or s4$="("Or s4$=")"Or s4$=">"Or s4$="<" Or s4$="=" Or s4$=":"Then
					If s3$=""Then
						s2$=s2$+s4$+Chr$(200)
					Else
						s2$=s2$+s3$+Chr$(200)+s4$+Chr$(200)
						s3$=""
					EndIf
				EndIf
				If s4$="+"Or s4$="-"Or s4$="/"Or s4$="*" Or s4$=";" Or s4$="'"Then
					If s3$=""Then
						s2$=s2$+s4$+Chr$(200)
					Else
						s2$=s2$+s3$+Chr$(200)+s4$+Chr$(200)
						s3$=""
					EndIf
				EndIf
				If s4$="@"Or s4$="%"Or s4$="" Or s4$="^" Then
					If s3$<>""Then
						s2$=s2$+s3$+s4$+Chr$(200)
						s3$=""
					Else
						If Fail=0 Then
						;**** This line become invalid when not real string
							s2$=s2$+s4$+Chr$(200)
						EndIf	
					EndIf
				EndIf
				If s4$=" "Or s4$=Chr$(9)Then
					If s3$<>""Then
						s2$=s2$+s3$+Chr$(200)
						s3$=""
					Else
						If Fail=0 Then
						;**** This line become invalid when not real string
						;	s2$=s2$+Chr$(200)
						EndIf	
					EndIf
				EndIf
				
				If s4$="!"Or s4$="&" Or s4$="?" Or s4$="{"Or s4$="}"Or s4$="["Or s4$="]" Or s4$="~" Or s4$="|" Or s4$="#"Then
					If s3$<>""Then
						s2$=s2$+s3$+s4$+Chr$(200)
						s3$=""
					Else
						If Fail=0 Then
						;**** This line become invalid when not real string
							s2$=s2$+s4$+Chr$(200)
						EndIf	
					EndIf
				EndIf
				If (s4$=>"a" And s4$<="z")Or (s4$>="0" And s4$<="9") Or (s4$>="A" And s4$<="Z")Or s4$="." Or s4$="_"Then
					s3$=s3$+s4$
				EndIf
				If s4$="$"Then
					s3$=s3$+s4$
				EndIf
			EndIf
		Next
	EndIf
	If Len(s3$)>0 Then
		s2$=s2$+s3$+Chr$(200)
	EndIf

	;If Len(s2$)>0 Then
	;	s3$=""
	;	For f=1 To Len(s2$)
	;		s4$=Mid$(s2$,f,1)
	;		Fail=0
	;		If s4$=Chr$(200)Then
	;			If f=1 Then Fail=1
	;			If f>1 And (Mid$(s2$,f-1,1)=" " Or Mid$(s2$,f-1,1)=Chr$(9))Then
	;				If s3$=" "Then
	;					s3$=""
	;				Else
	;					s3$=Left$(s3$,Len(s3$)-1)
	;				EndIf
	;				Fail=1
	;			EndIf	
	;		EndIf
	;		If Fail=0 Then s3$=s3$+s4$
	;	Next
	;	s2$=s3$
	;EndIf
	Return s2$
End Function
