Function Assembler(debug=0)
	
	CompileType=Gu_Val(gTopBarOutput)
	CurrWhile=0
	CodeType=0
	ChangeDir CDir$
	
	;**** Check Lib-Bas
	For f=1 To 1024
		LbUsed(f)=0
		LbName$(f)=""
	Next
	a=1
	LbFound=0
	Filein = OpenFile("sys\quig-lib.asm")
	While Not Eof(Filein) 
		r$=ReadLine$(Filein)
		If Trim(r$)>""Then 
			Lb$(a)=r$
			r$=Trim(r$)
			If Mid(Trim$(r$),1,1)=";"Then
				r$=Trim(Mid$(r$,2))
				If Upper$(Mid$(r$,1,8))="LIBRARY "Then
					r$=Trim(Upper$(Mid$(r$,9)))
					If LbFound>0 Then
						LbEnd(LbFound)=a-1
					EndIf	
					LbFound=LbFound+1
					LbName$(LbFound)=r$
					LbStart(LbFound)=a
				EndIf
			EndIf
			a=a+1
		EndIf	
	Wend
	If LbFound>0 Then LbEnd(LbFound)=a
	CloseFile(Filein)
	
	;AddLibFile()
	
	FileOut = WriteFile("sys\tempcode.asm")
	For f=1 To Lstline
		WriteLine(FileOut,Cd$(f))
	Next
	CloseFile (FileOut)
	LoC=0
	
	Err=0
	AddQuigFunctions()			;* ADD THE STANDARD QUIGS FUNCTION & COMMAND SET
	
	GetDeclares("sys\form.asm")
	GetFunctions("sys\form.asm")	
	glick=1
	
	DoFVars()	
	
	;If Err>0 Then CurrLine=ErrLn:Goto BitterBit2	
	Cod=0
	;**** Clean the Old Stuff
	For g=1 To 3
		For f=0 To 65535
			PokeByte MemoryBank(g),f,0
		Next
	Next
	Failed=0
	OrgVer=1
	UnRef=0
	
	;**** Do A Compile of Code
	a=CompilerAll()
	
	If a Then 
		If Not(DebugMode) Then
			Orig=PeekShort(MemoryBank(1),Org(1)+6)
			nr=1
			Reloc$ = ""
			p1=0
			For f=Org(1) To Fin(1)
				Wert1=PeekShort(MemoryBank(1),f)
				Wert2=PeekShort(MemoryBank(2),f+258)
				If (Wert1+258=Wert2) Then
					Reloc$=Reloc$+Chr$((nr+Orig-1)Mod 256)+Chr$(Int((nr+orig-1)/256))
					p1=p1+1
				EndIf
				nr=nr+1
			Next
			
			nr=Fin(1)-Org(1)
			nr=0
			For f=Org(1) To Org(1)+7
				PokeByte MemoryBank(3),nr,PeekByte(MemoryBank(1),f)
				nr=nr+1
			Next
			PokeShort MemoryBank(3),8,p1
			nr=10
			For f=Org(1)+10 To Fin(1)
				PokeByte MemoryBank(3),nr,PeekByte(MemoryBank(1),f)
				nr=nr+1
			Next
			nr=Fin(1)-Org(1)
			For f=1 To Len(Reloc$)
				PokeByte MemoryBank(3),nr,Asc(Mid$(Reloc$,f,1))
				nr=nr+1
			Next
			;**** Spit out results to \Output
			CompileOutput(nr)
			AddNewLog("Compile Successful")
		Else
			AddNewLog("Test Compile Successful")
		EndIf
	EndIf
	
	
	For f=1 To LabCount
		LabRef(f)=0
		Lab$(f)=""
		LabT(f)=0
		LabV(f)=0
		LabOK(f)=0
	Next
	For f=1 To UnRef
		UnRefLab$(f)=""
		UnRefLin(f)=""
	Next
	ChangeDir CDir$
	Filein = ReadFile("sys\tempcode.asm")
	For f=1 To Lstline
		Cd$(f)=ReadLine$(Filein)
	Next
	CloseFile (Filein)
	
	
End Function


Function CompilerAll()
	;**** Clean the Old Stuff
	For g=1 To 3
		For f=0 To 65535
			PokeByte MemoryBank(g),f,0
		Next
	Next
	Failed=0
	OrgVer=1
	UnRef=0
	
	While OrgVer<3 
		FLine=0
		For f=0 To LabCount
			Lab$(f)="":LabT(f)=0:LabV(f)=0:LabOK(f)=0:LabRef(f)=0
		Next
		LoopNum=0
		LabCount=0
		If OrgVer=1 Then MemBank=MemoryBank(1)
		If OrgVer=2 Then MemBank=MemoryBank(2)
		Readout$=""
		Pass=1:Err=0
		Failed3=65536
		DirectCommand=0
		CurrIf=0:CurrRepeat=0:CurrExit=0
		For f=0 To 255
			For g=0 To 255
				ExitWhere(f,g)=0
			Next
		Next
		.LakePlacid
		
		LibIgnore=0
		If Pass=1 Then
			AddNewLog("Compile Pass 1.... ",0)
		Else	
			AddNewLog("Compile Pass 2.... ",0)
		EndIf
		Gu_Draw():Flip
		
		InFunction=0
		PC=0:PC1=0
		FaF=1
		ForceEndIf=0
		ErrMessage$=""
		DirectStr=0
		LastICond=0
		;**** Process ****
		While FaF<=LoC+LibEnd
		;If ForceEndIf>0 Then BasicForceEndIf():ForceEndIf=0
;			If ForceEndIf>0 Then 
;				QuigEndIf(0)
;				ForceEndIf=0
;			EndIf
;			CurrLine=FaF
			Cod=1
			Answer$=Seperate2$(FaF)
;			gy$=Answer$
			
			Okay=1
			While Okay=1 And Err=0
				Okay=0
				r$=Upper$(SepSort$(Cod))
				If r$=";"Or r$="" Or r$="/"Then Goto FunkTurd
				If r$="VAR"Then Goto FunkTurd
				MC_Line=0
				If Mid$(r$,1,1)<>"."Then
					If CodeType=0 Then
						CompileZ80(r$)
					Else
						For f=1 To VarNo
							If VarNameU$(f)=r$ Then
								Select VarUse(f)
									Case AC_Dir QuigDirective(f):f=VarNo+1
									Case AC_Var QuigLet(f):f=VarNo+1
									Case AC_Sta QuigStatement(f):f=VarNo+1
								End Select
							EndIf
						Next
						If Pass=1 And OrgVer=1 Then
							AddMC ";**** "+Str$(CurrBasL)+" '"+Trim$(Answer$)+"'"
							For l=1 To MC_Line
								DebugLog MC_Text(l)
							Next
							MC_Line=0
						EndIf	
					EndIf
				Else
				;**** Label
					n=FuncAddLabel(Cod)
					If CodeType=0 Then 
						Final$(FLine)=r$
						FLine=FLine+1
					EndIf
				EndIf
			Wend
			If Err=0 Then SetError(101,"Syntax Error '"+r$+"'")
			AddNewLog "**** ERROR **** "+ErrMessage$+" in Line "+Str(CurrBasL)
			CrrLine=CurrBasL
			Return 0
			.FunkTurd
			FaF=FaF+1
		Wend
		
		;**** Process End
		
		h=0
		If OrgVer=1 And Pass=1 Then
			For f=1 To UnRef
				t=0
				For g=1 To LabCount
					If Lab$(g)=UnRefLab$(f)Then
						If LabOK(g)<>0 Then
							t=1
							g=LabCount
						EndIf	
					EndIf
				Next
				If t=0 Then
					AddNewLog("**** "+Cd$(UnRefLin(f)))
					AddNewLog("-"+Str$(f)+"-"+UnRefLab$(f)+"- Undefined Symbol in Line "+Str$(UnRefLin(f)))
					Return 0
				EndIf
			Next
		EndIf
		
		If Pass=1
			rw$="Pass 1 (Success) "+Str$(LoC)+" Lines [Size "+Str$(PC-Org(OrgVer))+" -"
			rw$=rw$+" Data "+Str$(GetRoutineLocation("AppTrnBeg")-GetRoutineLocation("AppDatBeg"))+" -"
			rw$=rw$+" Code "+Str$(GetRoutineLocation("Syb_CodeEnd")-GetRoutineLocation("AppCodBeg"))+" -"
			rw$=rw$+" Trans "+Str$(GetRoutineLocation("AppTrnEnd")-GetRoutineLocation("AppTrnBeg"))+"]"
			AddNewLog(rw$)
		Else	
			AddNewLog("Pass 2 (Success) "+Str$(LoC)+" Lines ["+Str$(PC-Org(OrgVer))+" bytes]")
		EndIf
		Fin(OrgVer)=PC
		For f=1 To LabCount
			LabRef(f)=0
		Next	
		UnRef=0
		If Failed>=Failed3 Then 
			fgr=Failed
			fgr1=Failed3
			Stop
		EndIf	
		If Failed>0 Then
			Failed3=Failed
			Failed=0
			Pass=Pass+1
			Goto LakePlacid
		EndIf
		If DebugMode=1 Then
			OrgVer=2
		EndIf	
		OrgVer=OrgVer+1
	Wend	;If Org is 1 or 2
	Return 1
End Function	


Function CompilerAllx()
	;**** Clean the Old Stuff
	For g=1 To 3
		For f=0 To 65535
			PokeByte MemoryBank(g),f,0
		Next
	Next
	Failed=0
	OrgVer=1
	UnRef=0
	While OrgVer<3 
		FLine=0
		For f=0 To LabCount
			Lab$(f)="":LabT(f)=0:LabV(f)=0:LabOK(f)=0:LabRef(f)=0
		Next
		LoopNum=0
		LabCount=0
		If OrgVer=1 Then MemBank=MemoryBank(1)
		If OrgVer=2 Then MemBank=MemoryBank(2)
		Readout$=""
		Pass=1:Err=0
		Failed3=65536
		DirectCommand=0
		CurrIf=0:CurrRepeat=0:CurrExit=0
		For f=0 To 255
			For g=0 To 255
				ExitWhere(f,g)=0
			Next
		Next
		.LakePlacid
		
		LibIgnore=0
		If Pass=1 Then
			AddNewLog("Compile Pass 1.... ",0)
		Else	
			AddNewLog("Compile Pass 2.... ",0)
		EndIf
		Gu_Draw():Flip
		
		InFunction=0
		PC=0:PC1=0
		FaF=1
		ForceEndIf=0
		ErrMessage$=""
		DirectStr=0
		;**** Process ****
		While FaF<=LoC+LibEnd
		;If ForceEndIf>0 Then BasicForceEndIf():ForceEndIf=0
			If ForceEndIf>0 Then 
				QuigEndIf(0)
				ForceEndIf=0
			EndIf
			CurrLine=FaF
			Cod=1
			Answer$=Seperate2$(FaF)
			gy$=Answer$
			.BlimBlam
			If Err<>0 Then Return 0
			Okay=0
			r$=Upper$(SepSort$(Cod))
			If Mid$(r$,1,10)="SYMBASLINE"Then 
				Cod=Cod+1
				r$=Upper$(SepSort$(Cod))
				
				CurrBasL=GetDecimal(r$,1,0)
				Cod=Cod+1
				r$=Upper$(SepSort$(Cod))
			EndIf
			If r$=";"Or r$="" Or r$="/"Then Goto FunkTurd
			If r$="VAR"Then Goto FunkTurd
			If r$=":"Then
				Cod=Cod+1
				Goto BlimBlam
			EndIf
			
			MC_Line=0
			AddMC ";**** "+Str$(CurrBasL)+" '"+Trim$(Answer$)+"'"
		;SimpleExpression=0
			r9$=Mid$(r$,1,1)
			If r9$<>"."Then 
				
				If CodeType=0 Then
					If Okay=0 Then 
						CompileZ80(r$)
					EndIf	
				Else
					If Okay=0 Then
						For f=1 To VarNo
							If VarNameU$(f)=r$ Then
								Select VarUse(f)
									Case AC_Dir QuigDirective(f):f=VarNo+1
									Case AC_Var QuigLet(f):f=VarNo+1
									Case AC_Sta QuigStatement(f):f=VarNo+1
								End Select
							EndIf
						Next
						If Pass=1 And OrgVer=1 Then
							For l=1 To MC_Line
								DebugLog MC_Text(l)
							Next
							MC_Line=0
						EndIf	
					EndIf
				EndIf
			EndIf	
		;**** Is it a Label
			If Okay=0 Then
				If (Mid$(r9$,1,1)="." And CodeType=1) Or CodeType=0 Then
					n=FuncAddLabel(Cod)
					If CodeType=0 Then 
						Final$(FLine)=r$
						FLine=FLine+1
					EndIf	
					If n=1 Then
						r$=Upper$(SepSort$(Cod))
						If r$<>""Then Goto BlimBlam
						If r$=":"Then
							Cod=Cod+1
							Goto BlimBlam
						EndIf
					EndIf
				EndIf
			EndIf
			.BitterBit
		;**** Multiple commands on line
			If Okay=1 Then
				r$=Upper$(SepSort$(Cod))
				If r$=":" Or r$="THEN" Then
					Cod=Cod+1
					Goto BlimBlam
				EndIf
			;If r$="ELSE" And CodeType=1 And ForceEndIf=1 Then
			;	Goto BlimBlam
			;EndIf
				If DirectCommand=1 Then
					DirectCommand=0
					Goto BlimBlam
				EndIf
			EndIf
			.BitterBit2		
			If Okay=0 Or Err<>0 Then
				If Err<>0 Then
					If Err=10 Then
						AddNewLog(Str$(Okay)+" "+Str$+(CodeType)+"Duplicate Defintion in Line "+Str(CurrBasL)+" - "+Cd$(FaF))
						
						Return 0
						
					EndIf
				;****
				;**** Basic Error Messages ****
				;****
					If Err>40 Then
						AddNewLog "**** ERROR **** "+ErrMessage$+" in Line "+Str(CurrBasL)
					EndIf
				Else
					r$=Upper$(SepSort$(Cod))
					AddNewLog "**** ERROR **** Illegal Operand '"+r$+"' in Line "+Str(CurrBasL)
				EndIf
				CrrLine=CurrBasL
				Return 0
			EndIf
			.FunkTurd
			FaF=FaF+1
		Wend
		
		;**** Process End
		
		h=0
		If OrgVer=1 And Pass=1 Then
			For f=1 To UnRef
				t=0
				For g=1 To LabCount
					If Lab$(g)=UnRefLab$(f)Then
						If LabOK(g)<>0 Then
							t=1
							g=LabCount
						EndIf	
					EndIf
				Next
				If t=0 Then
					AddNewLog("**** "+Cd$(UnRefLin(f)))
					AddNewLog("-"+Str$(f)+"-"+UnRefLab$(f)+"- Undefined Symbol in Line "+Str$(UnRefLin(f)))
					Return 0
				EndIf
			Next
		EndIf
		
		If Pass=1
			rw$="Pass 1 (Success) "+Str$(LoC)+" Lines [Size "+Str$(PC-Org(OrgVer))+" -"
			rw$=rw$+" Data "+Str$(GetRoutineLocation("AppTrnBeg")-GetRoutineLocation("AppDatBeg"))+" -"
			rw$=rw$+" Code "+Str$(GetRoutineLocation("Syb_CodeEnd")-GetRoutineLocation("AppCodBeg"))+" -"
			rw$=rw$+" Trans "+Str$(GetRoutineLocation("AppTrnEnd")-GetRoutineLocation("AppTrnBeg"))+"]"
			AddNewLog(rw$)
		Else	
			AddNewLog("Pass 2 (Success) "+Str$(LoC)+" Lines ["+Str$(PC-Org(OrgVer))+" bytes]")
		EndIf
		Fin(OrgVer)=PC
		For f=1 To LabCount
			LabRef(f)=0
		Next	
		UnRef=0
		If Failed>=Failed3 Then 
			fgr=Failed
			fgr1=Failed3
			Stop
		EndIf	
		If Failed>0 Then
			Failed3=Failed
			Failed=0
			Pass=Pass+1
			Goto LakePlacid
		EndIf
		If DebugMode=1 Then
			OrgVer=2
		EndIf	
		OrgVer=OrgVer+1
	Wend	;If Org is 1 or 2
	Return 1
End Function	

Function CompileOutput(nr)
	
	IncNo=0
	For f=1 To 59
		If GrpInclude(f)=1 Then
			cnum=MakeSheetFile(f,0,0)
			If cnum>0 Then 
				If cnum=999 Then Return
				IncNo=IncNo+1
				If cnum=4 Then IncFile$(IncNo)=GrpFile(f)+".qs1"
				If cnum=16 Then IncFile$(IncNo)=GrpFile(f)+".qs2"
			EndIf
		EndIf
		If GrpInclude2(f)=1 Then 
			cnum=MakeSheetFile(f,0,1)
			If cnum>0 Then 
				If cnum=999 Then Return
				IncNo=IncNo+1
				If cnum=4 Then IncFile$(IncNo)=GrpFile(f)+".qs1"
				If cnum=16 Then IncFile$(IncNo)=GrpFile(f)+".qs2"
			EndIf
		EndIf	
	Next
	
	;**** Output the Final Assembler Listing
	FileOut = WriteFile("sys\listing.asm")
	For f=0 To FLine
		WriteLine(FileOut,Final$(f))
	Next
	CloseFile (FileOut)	
	
	;**** Output Files ****
	ChangeDir(CDir$+"output")
	filebank=WriteFile(ApName$+".exe")
	WriteBytes MemoryBank(3),filebank,0,nr
	CloseFile filebank
	
	
	If CompileType=1 Then
		CopyFile CDir$+"output\"+ApName$+".exe","f:symbos\"+ApName$+".exe"
		CopyFile CDir$+"output\netd-loc.exe","f:symbos\netd-loc.exe"
		For f=1 To IncNo
			CopyFile CDir$+"output\"+IncFile$(f),"f:\symbos\"+IncFile$(f)
		Next
		AddNewLog("File \Output\"+ApName$+".exe created.")
	Else
		e$=Dsk1$
		Filename$=""
		If FileType(e$+".dsk")=1 Then				;File exist
			ee=OpenFile(e$+".dsk")
			If ee=0 Then 
				AddNewLog("**** Primary development DSK in use. Secondary used")
				e$=Dsk2$
			Else
				CloseFile(ee)
			EndIf
		EndIf
		DeleteFile e$+".dsk"
		If CompileType=2 Then
			filename$=filename$+"cpcxfsw.exe -nd "+e$+".dsk -p "+ApName$+".exe"
			For f=1 To IncNo
				filename$=filename$+Chr$(13)+Chr$(10)+"cpcxfsw.exe "+e$+".dsk -p "+IncFile$(f)
			Next
			filename$=filename$+Chr$(13)+Chr$(10)+"cpcxfsw.exe "+e$+".dsk -p netd-loc.exe"
			
			filename$=filename$+Chr$(13)+Chr$(10)+"pause"
			
			ExecFile(filename$)
			AddNewLog("CPC DSK "+Chr$(34)+"\Output\"+e$+".dsk"+Chr$(34)+" created.")
		EndIf
		If CompileType=3 Then
			
			filename$="DSKTOOL A "+e$+".dsk "+ApName$+".exe"
			For f=1 To IncNo
				filename$=filename$+" "+IncFile$(f)
			Next
			filename$=filename$+" nettest.com network.exe netd-loc.exe"
			ExecFile(filename$)
			AddNewLog("MSX DSK "+Chr$(34)+"\Output\"+e$+".dsk"+Chr$(34)+" created.")
		EndIf	
		ChangeDir(CDir$)
	EndIf	
End Function	


Function CompileZ80(r$)
	Select r$
		Case ":" QuigColon(1):Return	
		Case "QUIGS" QuigQuigs(1):Return
		Case "FUNC" QuigFunction(1):LastICond=1:Return
		Case "FUNCTION" QuigFunction(1):LastICond=1:Return
		Case "ENDF" QuigEndFunction(1):Return
		Case "ENDFUNC" QuigEndFunction(1):Return
		Case "QUIGLINE" QuigLine(1):Return		
			
		Case "LD" FuncLD():Return					;New
		Case "DB","DEFB","DEFM","DM" FuncDB(0):Return		;New
		Case "DW","DEFW" FuncDW(0):Return			;New
		Case "DS","DEFS" FuncDS(0):Return			;New
		Case "JR" FuncJR():Return
		Case "JP" FuncJP():Return						;New
		Case "RET" FuncRET():Return						;New				
			
		Case "AND" FuncAND():Return					
		Case "ADD" FuncADD():Return					;New
		Case "ADC" FuncADC():Return		
		Case "BIT" FuncBIT():Return
		Case "CP" FuncCP():Return					;New
		Case "CALL" FuncCALL():Return				;New
		Case "CPL" FuncCPL():Return					;New
		Case "CCF" FuncCCF():Return					;New
		Case "CPI" FuncCPI():Return					;New
		Case "CPIR" FuncCPIR():Return				;New
		Case "CPD" FuncCPD():Return					;New
		Case "CPDR" FuncCPDR():Return				;New
		Case "DEC" FuncDEC():Return
		Case "DJNZ" FuncDJNZ():Return
		Case "DAA" FuncDAA():Return						;New
		Case "DI" FuncDI():Return					;New		
		Case "EXX" FuncEXX():Return						;New
		Case "EX" FuncEX():Return
		Case "EI" FuncEI():Return						;New
		Case "ENDL","ENDLIB","ENDLIBRARY" Cod=Cod+1:Okay=1:Return
		Case "EMPTY" FuncEmpty():Return	
			
		Case "HALT" FuncHALT():Return					;New
		Case "INC" FuncINC():Return 						;New
		Case "IN" FuncIN():Return
		Case "INI" FuncINI():Return						;New
		Case "INIR" FuncINIR():Return					;New
		Case "IND"  FuncIND():Return						;New
		Case "INDR" FuncINDR():Return					;New
		Case "IM" FuncIM():Return
		Case "INCLIB" FuncIncLib():Return	
		Case "LDIR" FuncLDIR():Return					;New
		Case "LDI" FuncLDI():Return						;New
		Case "LDD" FuncLDD():Return						;New
		Case "LDDR" FuncLDDR():Return					;New
		Case "LIBRARY" FuncLibrary():Return
		Case "NEG" FuncNEG():Return						;New
		Case "NOP" FuncNOP():Return						;New
		Case "OUT" FuncOUT():Return
		Case "OR" FuncOR():Return
		Case "POP" FuncPop():Return						;New
		Case "PUSH" FuncPush():Return				;New
		Case "OUTI" FuncOUTI():Return					;New
		Case "OTIR" FuncOTIR():Return					;New
		Case "OUTD" FuncOUTD():Return					;New
		Case "OTDR" FuncOTDR():Return					;New
		Case "RES" FuncRES():Return		
		Case "RLC" FuncRLC():Return
		Case "RL" FuncRL():Return
		Case "RRC" FuncRRC():Return
		Case "RR"  FuncRR():Return
		Case "RLCA"FuncRLCA():Return					;New
		Case "RLA" FuncRLA():Return						;New
		Case "RRCA" FuncRRCA():Return					;New
		Case "RRA" FuncRRA():Return						;New
		Case "RLD" FuncRLD():Return						;New
		Case "RRD" FuncRRD():Return						;New
		Case "RETI" FuncRETI():Return					;New
		Case "RETN" FuncRETN():Return					;New
		Case "RST"FuncRST():Return						;New	
		Case "SUB" FuncSUB():Return						;New
		Case "SBC" FuncSBC():Return
		Case "SET" FuncSET():Return
		Case "SLA" FuncSLA():Return  
		Case "SRA" FuncSRA():Return
		Case "SRL" FuncSRL():Return 	
		Case "SCF" FuncSCF():Return						;New			
		Case "XOR" FuncXOR():Return						;New
		Case "SYMBOS_ORG" FuncORG():Return
	End Select
End Function	
Function FuncIncLib()
	Cod=Cod+1
	k$=Upper$(SepSort$(Cod))
	If k$>"" Then
		k$=Upper$(Trim(k$))
		
		For f=1 To LbFound
			If k$=LbName$(f)Then
				If LbUsed(f)=0 Then	
					For g=LbStart(f) To LbEnd(f)
						LibEnd=LibEnd+1
						Ld$(LibEnd)=Lb$(g)
					Next
					LbUsed(f)=1
				EndIf
				f=LbFound+1
			EndIf	
		Next
		Cod=Cod+1
	EndIf
	Okay=1
	Return 1
End Function
Function AsmPokeByte(a,b)
	PokeByte MemBank,PC,a
	PC=PC+1
End Function
Function Pk1(a,sob$="")
	PokeByte MemoryBank(4),PC1,a
	PokeByte MemoryBank(5),PC1+102,a
	PC1=PC1+1
	If sob$>"" Then 
		Final$(FLine)=sob$
		FLine=FLine+1
	EndIf
End Function
Function Pk1n(sob$)
	PokeByte MemoryBank(4),PC1,0
	PokeByte MemoryBank(5),PC1+102,0
	PC1=PC1+1
End Function
Function Pk2(a,sob$="")
	;PokeByte MemoryBank(4),PC1,a
	;PokeByte MemoryBank(5),PC1+102,a
	PC1=PC1+2
End Function
Function PkBy(p,b,i,alt=0)
	PokeByte MemBank,p,b
	If i>0 Then PC=PC+i
End Function
Function PkSh(p,b,i,alt=0)
	PokeShort MemBank,p,b
	If i>0 Then PC=PC+i
End Function
Function SetError(E4,Er$)
	Err=E4
	ErrMessage=Er$
	Return Err
End Function
Function FuncAddLabel(Wrd)
	gt=0
	r$=Upper$(SepSort$(Cod))
	If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
	r9$=Mid$(r$,1,1)
	If r9$<"A"Or r9$>"Z"Then SetError(101,"Invalid label name"):Return 0
	
	For f=1 To LabCount
		If Lab$(f)=r$ Then
			gt=f
			f=LabCount
		EndIf	
	Next
	If gt=0 Then
		LabCount=LabCount+1
		gt=LabCount
	EndIf
	
	LabRef(gt)=LabRef(gt)+1
	If LabRef(gt)>1 Then SetError(101,"Label "+r$+" declared more than once!"):Return 0				;*** Label already declared
	Lab$(gt)=r$
	Cod=Cod+1
	Okay=1
	r$=Upper$(SepSort$(Cod))
	
	If r$="EQU"Then
		LabT(gt)=1
		a=PC
		Cod=Cod+1
		Failed2=Failed
		t=GetNumber(1)
		If Failed2=Failed Then
			LabV(gt)=t
			LabOK(gt)=1
		Else
			LabV(gt)=0
			LabOK(gt)=0
		EndIf
		Return 1
	EndIf
	If r$="DEFBYTE"Then
		Cod=Cod+1
	EndIf
	LabT(gt)=0
	LabV(gt)=PC
	LabOK(gt)=1
	Return 1
End Function
Function FuncCheckLabel(Wrd)
	;If UnRef=403 Then
	;	tww$=Answer$
	;	Stop
	;	
	;EndIf	
	gt=0
	If LabCount>0 Then
		r$=Upper$(SepSort$(Wrd))
		If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
		For f=1 To LabCount
			If Lab$(f)=r$ Then
				gt=f
				f=LabCount
			EndIf	
		Next
	EndIf
	If gt=0 Then			;**** Just check if Library
		r$=Upper$(SepSort$(Wrd))
		For f=1 To Lib
			If r$=Libr$(f)Then
				LibUsed(f)=1
				f=Lib+1
			EndIf
		Next
	EndIf
	If gt=0 And r$>"" Then
		UnRef=UnRef+1
		UnRefLab$(UnRef)=r$
		UnRefLin(UnRef)=CurrLine
	EndIf
	Return gt
End Function
Function FuncEmpty()
	Okay=1
End Function
Function FuncDB(Typ)
	Dub$="     DB "
.Libble
	Cod=Cod+1
	r$=SepSort$(Cod)
	If Mid$(r$,1,1)=Chr$(34)Then
		dub$=dub$+Chr$(34)
		For f=1 To Len(r$)
			p$=Mid$(r$,f,1)
			If p$<>Chr$(34)Then 
				PkBy(PC,Asc(p$),1)
				Pk1(Asc(p$))
				dub$=dub$+p$
			EndIf	
		Next
		dub$=dub$+Chr$(34)
		Cod=Cod+1
	Else
		t=GetNumber(Typ)
		If Err=0 Then 
			PkBy(PC,t,1)
			Pk1(t)
			dub$=dub$+Str$(t)
		Else	
			SetError(900,"DB used incorrectly")
			Return
		EndIf
	EndIf
	If Err=0 Then
		r$=SepSort$(Cod)	
		If r$=","Then 
			dub$=dub$+","
			Goto Libble
		EndIf
	Else
		SetError(900,"DB used incorrectly")
	EndIf
	Final$(FLine)=dub$
	FLine=FLine+1
	Okay=1
End Function
Function FuncDW(Typ)
	Dub$="     DW "
.Libble2
	Cod=Cod+1
	r$=SepSort$(Cod)
	t=GetNumber(1)
	GetFir$=Reply$
	GetFia1=GetFia
	If Err=0 Then
		PkSh(PC,t,2)
		If GetFia1=0 Then
			dub$=dub$+Str$(t)
			Pk2(t)
		Else
			dub$=dub$+GetFir$
			Pk2(0,GetSec)
		EndIf
	Else
		SetError(900,"DW used incorrectly")
	EndIf
	If Err=0 Then
		r$=SepSort$(Cod)	
		If r$=","Then 
			dub$=dub$+","
			Goto Libble2
		EndIf
	Else	
		SetError(900,"DW used incorrectly")
	EndIf
	Final$(FLine)=dub$
	FLine=FLine+1	
	Okay=1
End Function
Function FuncDS(Typ)
	Dub$="     DS "
	
.Libble3
	Cod=Cod+1
	r$=SepSort$(Cod)
	t=GetNumber(1)
	t2=0
	r$=SepSort$(Cod)
	dub$=dub$+Str$(t)
	If r$=","Then
		Cod=Cod+1
		t2=GetNumber(1)
		dub$=dub$+","+Str$(t2)
	EndIf
	If Err=0 Then
		For n=1 To t
			PkBy(PC,t2,1)
			Pk1(t2)
		Next
	EndIf
	If Err=0 Then
		r$=SepSort$(Cod)	
		If r$=","Then
			dub$=dub$+","
			Goto Libble3
		EndIf	
	EndIf
	Final$(FLine)=dub$
	FLine=FLine+1	
	Okay=1
End Function
Function FuncORG()
	Cod=Cod+1
	r$=SepSort$(Cod)
	t=GetNumber(1)
	If OrgVer=2 Then
		t=t+258
	EndIf
	Okay=1
	PC=t
	PC1=t
	Org(OrgVer)=t
End Function
Function GetRegister(Wrd)
	r$=Upper$(SepSort$(Cod))
	If r$="AF"Then
		Cod=Cod+1
		Return 1
	EndIf	
	If r$="BC"Then
		Cod=Cod+1
		Return 2
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		Return 3
	EndIf
	If r$="HL"Then
		Cod=Cod+1
		Return 4
	EndIf	
	If r$="SP"Then
		Cod=Cod+1
		Return 5
	EndIf
	If r$="IX"Then
		Cod=Cod+1
		Return 6
	EndIf
	If r$="IY"Then
		Cod=Cod+1
		Return 7
	EndIf
	
	If r$="B"Then
		Cod=Cod+1
		Return 16
	EndIf
	If r$="C"Then
		Cod=Cod+1
		Return 17
	EndIf
	If r$="D"Then
		Cod=Cod+1
		Return 18
	EndIf	
	If r$="E"Then
		Cod=Cod+1
		Return 19
	EndIf
	If r$="H"Then
		Cod=Cod+1
		Return 20
	EndIf
	If r$="L"Then
		Cod=Cod+1
		Return 21
	EndIf
	If r$="A"Then
		Cod=Cod+1
		Return 23
	EndIf
	
	If r$="R"Then
		Cod=Cod+1
		Return 32
	EndIf
	If r$="I"Then
		Cod=Cod+1
		Return 33
	EndIf
	
	If r$="("Then Goto BracketStuff
	
	b1=GetNumber(1)
	Return (b1*256)+81
	Okay=1
	
	.BracketStuff
	a=0
	t=0
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="BC"Then
		Cod=Cod+1
		a=64
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		a=65
	EndIf
	If r$="HL"Then
		Cod=Cod+1
		a=67
	EndIf
	If r$="AF"Then
		Cod=Cod+1
		a=68
	EndIf
	If r$="SP"Then
		Cod=Cod+1
		a=69
	EndIf
	If r$="C"Then
		Cod=Cod+1
		a=70
	EndIf
	If r$="IX"Then
		Cod=Cod+1
		a=71
		r$=Upper$(SepSort$(Cod))
		If r$="+"Then
			Cod=Cod+1
			t=GetNumber(0)
		EndIf
	EndIf
	If r$="IY"Then
		Cod=Cod+1
		a=72
		r$=Upper$(SepSort$(Cod))
		If r$="+"Then
			Cod=Cod+1
			t=GetNumber(0)
		EndIf
	EndIf
	If a=0 Then
		t=GetNumber(1)
		a=80
		Okay=1
	EndIf
	r$=Upper$(SepSort$(Cod))
	If r$<>")"Then Stop
	Cod=Cod+1
	Return a+(t*256)
End Function
Function GetNumber(Typ=0)
	;**** Typ 0 = 8bit 1 = 16bit
	Fia=0
	GetFia=0
	Reply$=""
	Total=0
	Total2=0
	Add1=1:Add1_1=1
	Add2=0:Add2_1=0
	.Lumpy
	r$=Upper$(SepSort$(Cod))
	Reply$=Reply$+r$
	sign=0
	If r$="+"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
	EndIf
	If r$="-"Then
		sign=1
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
	EndIf
	If Mid$(r$,1,1)="#" Or Mid$(r$,1,1)="&" Or Mid$(r$,1,1)="$" Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
		Tot2=GetHex(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	If Mid$(r$,1,1)="%"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		Reply$=Reply$+r$
		Tot2=GetBinary(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	If Mid$(r$,1,1)>="0" And Mid$(r$,1,1)<="9"Then
		Tot2=GetDecimal(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	If Mid$(r$,1,1)=Chr$(34)Then
		Tot2=GetNumString(r$,Typ,sign)
		Tot2_1=Tot2
		Goto Binder
	EndIf
	
;	If UnRef=404 Then
;		tww$=r$
;		Stop
;		
;	EndIf	
	
	;t=GetRoutineLocation(r$)
	t=FuncCheckLabel(Cod)
	GetFia=1
	If t=0 Then
		;sfsf=gy$
		Fia=1
		;If Pass=2 Then Stop
		Failed=Failed+1
		Tot2=0
		Tot2_1=0
		Goto Binder
	Else
		If LabOK(t)=1 Then 
			Tot2=LabV(t)
			Tot2_1=Tot2+258
			Goto Binder
		Else
			Failed=Failed+1
			Tot2=0
			Tot2_1=0
			Goto Binder
		EndIf	
	EndIf
.Binder
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="+"Then Add2=1:Reply$=Reply$+r$
	If r$="-"Then Add2=2:Reply$=Reply$+r$
	If r$="/"Then Add2=3:Reply$=Reply$+r$
	If r$="*"Then Add2=4:Reply$=Reply$+r$
	If r$="MOD"Then Add2=5:Reply$=Reply$+r$
	If Add1=1 Then Total=Total+Tot2:Total2=Total2+Tot2_1
	If Add1=2 Then Total=Total-Tot2:Total2=Total2+Tot2_1
	If Add1=3 Then 
		If Tot2<>0 Then
			Total=Total/Tot2
			Total2=Total2/Tot2_1
		Else
			Total=0
			Total2=0
		EndIf
	EndIf	
	If Add1=4 Then Total=Total*Tot2:Total2=Total2*Tot2_1
	If Add1=5 Then Total=Total Mod Tot2:Total2=Total2 Mod Tot2_1
	If Add2>0 Then
		Add1=Add2
		Add2=0
		Cod=Cod+1
		Goto Lumpy
	EndIf
	If Typ=0 Then
		If Total<0 Or Total>255 Then
			Err=97
			ErrMessage$="expecting 8 bit value"
			SecondTotal=0
			Return 0
		EndIf
	EndIf
	If Fia=1 Then Return 0
	SecondTotal=Total2
	Return Total
End Function
Function GetBinary(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		If a$<>"0" And a$<>"1"Then
			ErrMessage$="Binary Error"
			Err=99
			Failed=1
			Return 0
		EndIf	
		If a$="1"Then
			Tot2=Tot2+Base
		EndIf
		Base=Base*2
	Next
	If re=0 Then   ;**** 8 Bit
		;If Tot2<0 Or Tot2>255 Then
		;	Err=98
		;	Failed=1
		;	Return 0
		;EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=96
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=32768-Tot2
		EndIf	
	EndIf
	Return Tot2
End Function
Function GetNumString(r$,re,si)
	r$=Mid$(r$,2)
	dr$=r$
	If Len(r$)>1 Then
		r$=Mid$(r$,1,Len(r$)-1)
	EndIf
	If Len(r$)>1 Then
		
		fr$=r$
		
		Stop
		Err=94
		Return 0
	EndIf
	Return Asc(r$)
End Function
Function GetHex(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		n=-1
		If a$=>"0" And a$<="9" Then
			n=Asc(a$)-48
		EndIf
		If a$=>"A" And a$<="F"Then
			n=Asc(a$)-55
		EndIf
		If n=-1 Then
			Err=99
			Failed=1
			Return 0
		EndIf	
		Tot2=Tot2+(n*Base)
		Base=Base*16
	Next

	If re=0 Then   ;**** 8 Bit
		;If Tot2<0 Or Tot2>255 Then
		;	Err=98
		;	Failed=1
		;	Return 0
		;EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=98
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=32768-Tot2
		EndIf	
	EndIf
	Return Tot2
	
End Function
Function GetDecimal(r$,re,si)
	base=1
	Tot2=0
	For f=Len(r$) To 1 Step -1
		a$=Mid$(r$,f,1)
		n=-1
		If a$=>"0" And a$<="9" Then
			n=Asc(a$)-48
		Else
			ErrMessage$="Decimal Error "+r$
			Err=99
			Failed=1
			Return 0
		EndIf	
		Tot2=Tot2+(n*Base)
		Base=Base*10
	Next
	If re=0 Then   ;**** 8 Bit
		;If Tot2<0 Or Tot2>255 Then
		;	Err=98
		;	Failed=1
		;	Return 0
		;EndIf
		If si=1 Then
			Tot2=256-Tot2
		EndIf
	Else
		If Tot2<0 Or Tot2>65535 Then
			Err=95
			Failed=1
			Return 0
		EndIf
		If si=1 Then
			Tot2=65536-Tot2
		EndIf
	EndIf
	Return Tot2	
End Function
Function GetCC(s2$)
	e1=-1
	If s2$="NZ"Then e1=0
	If s2$="Z"Then e1=1
	If s2$="NC" Then e1=2
	If s2$="C"Then e1=3
	If s2$="PO"Then e1=4
	If s2$="PE"Then e1=5
	If s2$="P"Then e1=6
	If s2$="M"Then e1=7
	Return e1
End Function
Function GetQQ(s2$)
	e1=-1
	If s2$="BC"Then e1=0
	If s2$="DE"Then e1=1
	If s2$="HL"Then e1=2
	If s2$="AF"Then e1=3
	Return e1
End Function	
Function CCRegister$(xc)
	If xc=7 Then Return "M"
	If xc=0 Then Return "NZ"	
	If xc=1 Then Return "Z"	
	If xc=2 Then Return "NC"	
	If xc=3 Then Return "C"
	If xc=4 Then Return "PO"
	If xc=5 Then Return "PE"
	If xc=6 Then Return "P"
End Function
Function RRegister$(xc)
	If xc=7 Then Return "A"
	If xc=0 Then Return "B"	
	If xc=1 Then Return "C"	
	If xc=2 Then Return "D"	
	If xc=3 Then Return "E"
	If xc=4 Then Return "H"
	If xc=5 Then Return "L"
	If xc=6 Then Return "(HL)"
End Function
Function SSRegister$(xc)
	If xc=0 Then Return "BC"
	If xc=1 Then Return "DE"	
	If xc=2 Then Return "HL"	
	If xc=3 Then Return "SP"
End Function
Function QQRegister$(xc)
	If xc=0 Then Return "BC"
	If xc=1 Then Return "DE"	
	If xc=2 Then Return "HL"	
	If xc=3 Then Return "AF"
End Function
Function Str16$(a)
	If a<=32768 Then 
		Return Str$(a)
	Else
		Return "-"+Str$(Abs(65536-a))
	EndIf	
End Function
Function FuncADD()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n1=23 And (n2>=16 And n2<=23) Then				;***** ADD A,r
		PkBy(PC,128+(n2-16),1)
		Pk1(128+(n2-16),"     ADD A,"+RRegister$(n2-16)+"    ;** "+Mid$(Hex$(128+(n2-16)),7,2))
		Okay=1:Return
	EndIf
	If n1=23 And n2=81 Then								;***** ADD A,N
		PkBy(PC,198,1)
		Pk1(198,"     ADD A,"+Str$(n2t)+"    ;** "+Mid$(Hex$(198),7,2)+" "+Mid$(Hex$(n2t),7,2))
		PkBy(PC,n2t,1)
		Pk1(n2t)
		Okay=1:Return
	EndIf		
	If n1=23 And n2=67 Then								;***** ADD A,(HL)
		PkBy(PC,134,1)
		Pk1(134,"     ADD A,(HL)    ;** "+Mid$(Hex$(134),7,2))
		Okay=1:Return
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** ADD A,(IX+n) (IY+n)
		If n2=71 Then
			PkBy(PC,221,1)
			Pk1(221,"     ADD A,(IX+"+Str$(n2t)+")"+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(134),7,2)+" "+Mid$(Hex$(n2t),7,2))
			PkBy(PC,134,1)
			Pk1(134)
		EndIf
		If n2=72 Then
			PkBy(PC,253,1)
			Pk1(253,"     ADD A,(IY+"+Str$(n2t)+")"+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(134),7,2)+" "+Mid$(Hex$(n2t),7,2))
			PkBy(PC,134,1)
			Pk1(134)
		EndIf
		PkBy(PC,n2t,1)
		Pk1(n2t)
		Okay=1:Return
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then					;***** ADD HL,ss
		PkBy(PC,((n2-2)*16)+9,1)
		Pk1(((n2-2)*16)+9,"     ADD HL,"+SSRegister$(n2-2)+"    ;** "+Mid$(Hex$(((n2-2)*16)+9),7,2))
		Okay=1:Return
	EndIf	

	If n1=6 And (n2=2 Or n2=3 Or n2=5 Or n2=6) Then		;***** ADD IX,pp
		PkBy(PC,221,1)
		b=9
		If n2=2 Then b=b+(0*16):wq$="BC"
		If n2=3 Then b=b+(1*16):wq$="DE"
		If n2=5 Then b=b+(3*16):wq$="SP"
		If n2=6 Then b=b+(2*16):wq$="IX"
		Pk1(221,"     ADD IX,"+wq$+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(b),7,2))
		PkBy(PC,b,1)
		Pk1(b)
		Okay=1:Return
	EndIf
	If n1=7 And (n2=2 Or n2=3 Or n2=5 Or n2=7) Then		;***** ADD IY,rr
		PkBy(PC,253,1)
		b=9
		If n2=2 Then b=b+(0*16):wq$="BC"
		If n2=3 Then b=b+(1*16):wq$="DE"
		If n2=5 Then b=b+(3*16):wq$="SP"
		If n2=7 Then b=b+(2*16)	:wq$="IY"
		Pk1(253,"     ADD IY,"+wq$+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(b),7,2))
		PkBy(PC,b,1)
		Okay=1:Return
	EndIf
	SetError(900,"ADD used incorrectly")
	Return
End Function
Function FuncLibrary()
	LibIgnore=1
	Cod=Cod+1
	gt=0
	r$=Upper$(SepSort$(Cod))
	If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
	r9$=Mid$(r$,1,1)
	If r9$<"A"Or r9$>"Z"Then Return 0
	For f=1 To LabCount
		If Lab$(f)=r$ Then
			gt=f
			f=LabCount
		EndIf	
	Next
	If gt=0 Then
		LabCount=LabCount+1
		gt=LabCount
	EndIf
	LabRef(gt)=LabRef(gt)+1
	If LabRef(gt)>1 Then				;*** Label already declared
		Err=10
		Okay=0
		Return 0
	EndIf
	Lab$(gt)=r$
	Cod=Cod+1
	Okay=1
	LabT(gt)=0
	LabV(gt)=PC
	LabOK(gt)=1
	For h=1 To Lib
		If r$=Libr$(h)Then
			If LibUsed(h)<>0 Then
				LibIgnore=0
			EndIf
		EndIf
	Next
	Cod=Cod+1
	Okay=1
	Return 1	
End Function
Function FuncADC()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	b=1
	If n1=23 And (n2>=16 And n2<=23) Then				;***** ADC A,r
		PkBy(PC,128+(n2-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=23 And n2=81 Then				;***** ADC A,N
		PkBy(PC,198+(b*8),1)
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf		
	If n1=23 And n2=67 Then								;***** ADC A,(HL)
		PkBy(PC,134+(b*8),1)
		Okay=1:Return
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** ADC A,(IX+n) (IY+n)
		If n2=71 Then
			PkBy(PC,221,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		If n2=72 Then
			PkBy(PC,253,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then				;***** ADC HL,ss
		PkBy(PC,237,1)
		PkBy(PC,((n2-2)*16)+74,1)
		Okay=1:Return
	EndIf
	Return SetError(900,"ADC used incorrectly")
End Function
Function FuncSBC()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		n2=n1
		n1=23
	Else
		Cod=Cod+1
		n2=GetRegister(Cod)
	EndIf	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	b=3
	If n1=23 And (n2>=16 And n2<=23) Then				;***** SBC A,r
		PkBy(PC,128+(n2-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=23 And n2=81 Then								;***** SBC A,N
		PkBy(PC,198+(b*8),1)
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf		
	If n1=23 And n2=67 Then								;***** SBC A,(HL)
		PkBy(PC,134+(b*8),1)
		Okay=1:Return
	EndIf	
	If n1=23 And (n2>=71 And n2<=72) Then				;***** SBC A,(IX+n) (IY+n)
		If n2=71 Then
			PkBy(PC,221,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		If n2=72 Then
			PkBy(PC,253,1)
			PkBy(PC,134+(b*8),1)
		EndIf
		PkBy(PC,n2t,1)
		Okay=1:Return
	EndIf
	If n1=4 And n2>=2 And n2<=5 Then					;***** SBC HL,ss
		PkBy(PC,237,1)
		PkBy(PC,((n2-2)*16)+66,1)
		Okay=1:Return
	EndIf
	SetError(900,"SBC used incorrectly")
End Function
Function FuncCP()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	GetFir=GetFia
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=7
	If n1>=16 And n1<=23 Then						;***** CP r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Pk1(128+(n1-16)+(b*8),"     CP "+RRegister(n1-16)+"    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))
		Okay=1:Return
	EndIf
	If n1=81 Then									;***** cp n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Pk1((b*8)+198,"     CP "+GetFir$+"    ;** "+Mid$(Hex$((b*8)+198),7,2)+" xx")
		Pk1n(GetFir$)
		Okay=1:Return
	EndIf		
	If n1=67 Then									;***** cp (HL)
		PkBy(PC,(b*8)+134,1)
		Pk1(190,"     CP (HL)    ;** "+Mid$(Hex$(190),7,2))
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then						;***** cp (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(221,"     CP (IX+"+GetFir+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(190),7,2)+" xx")
			Pk1(190)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(253,"     CP (IY+"+GetFir+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(190),7,2)+" xx")
			Pk1(190)
		EndIf
		PkBy(PC,n1t,1)
		Pk1n(GetFir)
		Okay=1:Return
	EndIf
	Return SetError(900,"CP used incorrectly")
End Function
Function FuncOR()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=6
	If n1>=16 And n1<=23 Then					;***** OR r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=81 Then								;***** OR n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Okay=1:Return
	EndIf		
	If n1=67 Then								;***** OR (HL)
		PkBy(PC,(b*8)+134,1)
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then					;***** OR (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		PkBy(PC,n1t,1)
		Okay=1:Return
	EndIf
	SetError(900,"OR used incorrectly")
End Function
Function FuncXOR()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=5
	If n1>=16 And n1<=23 Then					;***** XOR r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Pk1(128+(n1-16)+(b*8),"     XOR "+RRegister(n1-16)+"    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))
		Okay=1:Return
	EndIf
	If n1=81 Then								;***** XOR n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Pk1((b*8)+198,"     XOR "+Reply$+"    ;** "+Mid$(Hex$((b*8)+198),7,2)+" "+Mid$(Hex$(n1t),7,2))
		Pk1(n1t)
		Okay=1:Return
	EndIf		
	If n1=67 Then								;***** XOR (HL)
		PkBy(PC,(b*8)+134,1)
		Pk1((b*8)+134,"     XOR (HL)    ;** "+Mid$(Hex$((b*8)+134),7,2))
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then					;***** XOR (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(221,"     XOR (IX+"+Reply$+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$((b*8)+134),7,2)+" "+Mid$(Hex$(n1t),7,2))
			Pk1((b*8)+134)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(253,"     XOR (IX+"+Reply$+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$((b*8)+134),7,2)+" "+Mid$(Hex$(n1t),7,2))
			Pk1((b*8)+134)
		EndIf
		PkBy(PC,n1t,1)
		Pk1(n1t)
		Okay=1:Return
	EndIf
	SetError(900,"XOR used incorrectly")
End Function
Function FuncAND()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=4
	If n1>=16 And n1<=23 Then					;***** AND r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Okay=1:Return
	EndIf
	If n1=81 Then								;***** AND n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Okay=1:Return 0
	EndIf		
	If n1=67 Then								;***** AND (HL)
		PkBy(PC,(b*8)+134,1)
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then					;***** AND (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
		EndIf
		PkBy(PC,n1t,1)
		Okay=1:Return
	EndIf
	SetError(900,"AND used incorrectly")
End Function
Function FuncSUB()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	b=2
	If n1>=16 And n1<=23 Then						;***** SUB r
		PkBy(PC,128+(n1-16)+(b*8),1)
		Pk1(128+(n1-16)+(b*8),"     SUB "+RRegister$(n1-16)+"    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))
		Okay=1:Return
	EndIf
	If n1=81 Then									;***** SUB n
		PkBy(PC,(b*8)+198,1)
		PkBy(PC,n1t,1)
		Pk1((b*8)+198,"     SUB "+Reply$+"    ;** "+Mid$(Hex$((b*8)+198),7,2)+" "+Mid$(Hex$(n1t),7,2))
		Pk1(n1t)		
		Okay=1:Return
	EndIf		
	If n1=67 Then									;***** SUB (HL)
		PkBy(PC,(b*8)+134,1)
		Pk1((b*8)+134,"     SUB (HL)    ;** "+Mid$(Hex$(128+(n1-16)+(b*8)),7,2))		
		Okay=1:Return
	EndIf	
	If n1>=71 And n1<=72 Then						;***** SUB (IX+n) (IY+n)
		If n1=71 Then
			PkBy(PC,221,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(221,"     SUB ("+Reply$+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$((b*8)+134),7,2))
			Pk1((b*8)+134)
		EndIf
		If n1=72 Then
			PkBy(PC,253,1)
			PkBy(PC,(b*8)+134,1)
			Pk1(253,"     SUB ("+Reply$+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$((b*8)+134),7,2))
			Pk1((b*8)+134)			
		EndIf
		PkBy(PC,n1t,1)
		Pk1(n1t)	
		Okay=1:Return
	EndIf
	SetError(900,"SUB used incorrectly")
End Function
Function FuncSET()
	n1=0
	Cod=Cod+1
	b1=GetNumber(0)
	If b1<0 Or b1>7 Then
		Err=97
		Return
	EndIf
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"SET used incorrectly")
		Return
	EndIf
	Cod=Cod+1
	n1=GetRegister(Cod)
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then			;SET b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+64+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=67 Then						;SET b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b 110
		Okay=1:Return
	EndIf
	If n1=71 Then						;SET b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=72 Then						;SET b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	Cod=Cod+1
	SetError(900,"SET used incorrectly")
End Function
Function FuncRES()
	n1=0
	Cod=Cod+1
	b1=GetNumber(0)
	If b1<0 Or b1>7 Then
		SetError(900,"RES used incorrectly")
		Return
	EndIf
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"RES used incorrectly")
		Return
	EndIf
	Cod=Cod+1
	n1=GetRegister(Cod)
	n1t=n1/256
	n1=n1 Mod 256
	If n1>=16 And n1<=23 Then			;RES b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=67 Then						;RES b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+6+128
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b 110
		Okay=1:Return
	EndIf
	If n1=71 Then						;RES b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+128+6
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=72 Then						;RES b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+128+6
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	Cod=Cod+1
	SetError(900,"RES used incorrectly")
	Return
End Function
Function FuncBIT()
	n1=0
	Cod=Cod+1
	b1=GetNumber(0)
	If b1<0 Or b1>7 Then Return SetError(97,"BIT used incorrectly")
	
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then Return SetError(97,"BIT used incorrectly")
	Cod=Cod+1
	n1=GetRegister(Cod)
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then			;BIT b,r
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(n1-16)+(b1*8)+64
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=67 Then						;BIT b,(HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Okay=1:Return
	EndIf
	If n1=71 Then						;BIT b,(IX+)
		PokeByte MemBank,PC,221:PC=PC+1			;&dd	
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Return 0
	EndIf
	If n1=72 Then						;BIT b,(IY+)
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		PokeByte MemBank,PC,n1t:PC=PC+1			;data		
		b1=(b1*8)+70
		PokeByte MemBank,PC,b1:PC=PC+1			;x 01 b r
		Return 0
	EndIf
	Cod=Cod+1
	Return SetError(900,"BIT used incorrectly")
End Function
Function FuncSRL()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=7
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"SRL used incorrectly")
End Function
Function FuncSRA()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=5
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"SRA used incorrectly")
End Function
Function FuncSLA()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=4
	n1t=n1/256
	n1=n1 Mod 256
	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"SLA used incorrectly")
End Function
Function FuncRR()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=3
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RR used incorrectly")
End Function
Function FuncRRC()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=1
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RRC used incorrectly")
End Function
Function FuncRL()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=2
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RL used incorrectly")
End Function
Function FuncRLC()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	b=0
	n1t=n1/256
	n1=n1 Mod 256

	If n1>=16 And n1<=23 Then				;***** RLC rr
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+(n1-16)
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1=67 Then						;***** RLC (HL)
		PokeByte MemBank,PC,203:PC=PC+1			;&cb
		n2=(b*8)+6
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 b 110		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,203:PC=PC+1			;&cb			
		EndIf
		PokeByte MemBank,PC,n1t:PC=PC+1				;data
		n2=(b*8)+6		
		PokeByte MemBank,PC,n2:PC=PC+1				;x 00 b 110
		Okay=1:Return
	EndIf
	SetError(900,"RLC used incorrectly")
End Function
Function FuncDEC()
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)

	n1t=n1/256
	n1=n1 Mod 256

	If n1=6 Then				;***** DEC IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,43:PC=PC+1			;&2b
		Okay=1:Return
	EndIf
	If n1=7 Then				;***** DEC IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,43:PC=PC+1			;&2b		
		Okay=1:Return
	EndIf
	If n1>=2 And n1<=5 Then				;***** DEC ss
		n2=(n1-2)*16+11
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 ss1 011		
		Okay=1:Return
	EndIf
	If n1=67 Then					;***** DEC (HL)
		PokeByte MemBank,PC,53:PC=PC+1			;x 00 110 101
		Okay=1:Return
	EndIf
	If n1>=16 And n1<=23 Then				;***** DEC r
		n2=(n1-16)*8+5
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 r 101		
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** DEC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd		
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd		
		EndIf
		PokeByte MemBank,PC,53:PC=PC+1			;x 110101
		PokeByte MemBank,PC,n1t:PC=PC+1			;
		Okay=1:Return
	EndIf
	SetError(900,"DEC used incorrectly")
End Function
Function FuncINC() 
	n1=0
	Cod=Cod+1
	n1=GetRegister(Cod)

	n1t=n1/256
	n1=n1 Mod 256

	If n1=6 Then				;***** INC IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,35:PC=PC+1			;&23
		Pk1(221,"     INC IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(35),7,2))
		Pk1(35)
		Okay=1:Return
	EndIf
	If n1=7 Then				;***** INC IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,35:PC=PC+1			;&23
		Pk1(253,"     INC IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(35),7,2))
		Pk1(35)		
		Okay=1:Return
	EndIf
	If n1>=2 And n1<=5 Then				;***** INC ss
		n2=(n1-2)*16+3
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 ss0 011
		Pk1(n2,"     INC "+SSRegister(n1-2)+"    ;** "+Mid$(Hex$(n2),7,2))
		Okay=1:Return
	EndIf
	If n1=67 Then					;***** INC (HL)
		PokeByte MemBank,PC,52:PC=PC+1			;x 00 110 100
		Pk1(52,"     INC (HL)    ;** "+Mid$(Hex$(52),7,2))		
		Okay=1:Return
	EndIf
	If n1>=16 And n1<=23 Then				;***** INC r
		n2=(n1-16)*8+4
		PokeByte MemBank,PC,n2:PC=PC+1			;x 00 r 100
		Pk1(n2,"     INC "+RRegister(n1-16)+"    ;** "+Mid$(Hex$(n2),7,2))
		Okay=1:Return
	EndIf
	If n1>=71 And n1<=72 Then				;***** INC (IX+n) (IY+n)
		If n1=71 Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			Pk1(221,"     INC (IX+"+Str$(n1t)+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(52),7,2)+" "+Mid$(Hex$(n1t),7,2))
		EndIf
		If n1=72 Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			Pk1(253,"     INC (IX+"+Str$(n1t)+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(52),7,2)+" "+Mid$(Hex$(n1t),7,2))
		EndIf
		PokeByte MemBank,PC,52:PC=PC+1			;x 110100
		PokeByte MemBank,PC,n1t:PC=PC+1			;
		Pk1(52)
		Pk1(n1t)
		Okay=1:Return
	EndIf
	SetError(900,"INC used incorrectly")
End Function
Function FuncIN()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"IN used incorrectly")
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(Cod)

	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n1=23 And n2=80 Then					;* IN a,(n)
		PokeByte MemBank,PC,219:PC=PC+1			;&DB
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Okay=1:Return
	EndIf
	If n1=>16 And n1<=23 And n2=70 Then		; IN r,(C)
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,((n1-16)*8)+64:PC=PC+1			;x 01 r 000
		Okay=1:Return
	EndIf
	SetError(900,"IN used incorrectly")
End Function
Function FuncOUT()
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"OUT used incorrectly")
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(Cod)

	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256
	If n2=23 And n1=80 Then			
		PokeByte MemBank,PC,211:PC=PC+1			;&D3
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Okay=1:Return
	EndIf
	If n2=>16 And n2<=23 And n1=70 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,((n2-16)*8)+65:PC=PC+1			;x 01 r 001
		Okay=1:Return
	EndIf
	SetError(900,"OUT used incorrectly")
End Function
Function FuncLD()
	Okay=0
	n1=0
	n2=0
	Cod=Cod+1
	n1=GetRegister(Cod)
	GetFir$=Reply$
	GetFia1=GetFia
	r$=Upper$(SepSort$(Cod))
	If r$<>","Then
		SetError(900,"LD used incorrectly")
		Return
	EndIf	
	Cod=Cod+1
	n2=GetRegister(Cod)
	GetSec$=Reply$
	GetFia2=GetFia
	
	;**** Sort option and numbers
	n1t=n1/256
	n1=n1 Mod 256
	n2t=n2/256
	n2=n2 Mod 256

	If n2=23 And n1=80 Then 			;**** LD (nn),a
		PokeByte MemBank,PC,50:PC=PC+1	;&32
		Pk1(50,"     LD ("+GetFir+"),A    ;** "+Mid$(Hex$(50),7,2)+" LL HH")
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1			;data 1
		
		Pk1(0)
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;data 1		
		Pk1(0)
		Okay=1:Return
	End If
	If n1=23 And n2=80 Then 			;**** LD a,(nn)
		PokeByte MemBank,PC,58:PC=PC+1	;&3a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1	
		If GetFia2=0 Then 
			Pk1(58,"     LD A,("+Str16$(n2t)+")    ;** "+Mid$(Hex$(58),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk2(n2t)
		Else
			Pk1(58,"     LD A,("+GetSec+")    ;** "+Mid$(Hex$(58),7,2)+" LL HH")
			Pk2(n2t,GetSec)
		EndIf
		Okay=1:Return
	End If
	If n1=>2 And n1<=5 And n2=81 Then 			;**** LD dd,nn
		PokeByte MemBank,PC,((n1-2)*16)+1:PC=PC+1			;x 00 dd0 001
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1
		If GetFia2=0 Then 
			Pk1(((n1-2)*16)+1,"     LD "+SSRegister$(n1-2)+","+Str16$(n2t)+"    ;** "+Mid$(Hex$(((n1-2)*16)+1),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk2(n2t)
		Else
			Pk1(((n1-2)*16)+1,"     LD "+SSRegister$(n1-2)+","+GetSec+"    ;** "+Mid$(Hex$(((n1-2)*16)+1),7,2)+" LL HH")
			Pk2(n2t,GetSec)
		EndIf		
		
		Pk1(0)
		Pk1(0)		
		Okay=1:Return
	End If
	If n1=6 And n2=81 Then 			;**** LD IX,nn
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,33:PC=PC+1			;&21
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1
		If GetFia2=0 Then 
			Pk1(221,"     LD IX,"+Str16$(n2t)+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(33),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk1(33)
			Pk2(n2t)
		Else
			Pk1(221,"     LD IX,"+GetSec+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(33),7,2)+" LL HH")
			Pk1(33)
			Pk2(n2t,GetSec)
		EndIf
		Okay=1:Return
	End If
	If n1=7 And n2=81 Then 			;**** LD IY,nn
		PokeByte MemBank,PC,253:PC=PC+1			;&fd	
		PokeByte MemBank,PC,33:PC=PC+1			;&21
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1			;data 1
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;data 1
		If GetFia2=0 Then 
			Pk1(253,"     LD IY,"+Str16$(n2t)+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(33),7,2)+" "+Mid$(Hex$(n2t),7,2)+" "+Mid$(Hex$(n2t),5,2))
			Pk1(33)
			Pk2(n2t)
		Else
			Pk1(253,"     LD IY,"+GetSec+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(33),7,2)+" LL HH")
			Pk1(33)
			Pk2(n2t,GetSec)
		EndIf
		Okay=1:Return
	End If	

	If n1>=16 And n1<=23 And n2=81 Then 			;**** LD r,n
		PokeByte MemBank,PC,((n1-16)*8)+6:PC=PC+1			;x 00 r 110	
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(((n1-16)*8)+6,"     LD "+RRegister(n1-16)+","+GetSec+"    ;** "+Mid$(Hex$(((n1-16)*8)+6),7,2)+" "+" LL")
		Pk1n(GetSec)
		Okay=1:Return
	End If
	If n1=67 And n2=81 Then 			;**** LD (HL),n
		PokeByte MemBank,PC,54:PC=PC+1			;&36	
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(54,"     LD "+RRegister(n1-16)+","+GetSec+"    ;** "+Mid$(Hex$(54),7,2)+" "+" LL")
		Pk1n(GetSec)
		Okay=1:Return
	End If
	If n1=71 And n2=81 Then 			;**** LD (IX+ ),n
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,54:PC=PC+1			;&36			
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		PokeByte MemBank,PC,n2t:PC=PC+1			;ix+data
		Pk1(221,"     LD (IX+"+GetFir+"),"+GetSec+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(54),7,2)+" LL xx")		
		Pk1(54)
		Pk1n(GetFir)
		Pk1n(GetSec)		
		Okay=1:Return
	EndIf
	If n1=72 And n2=81 Then 			;**** LD (IY+ ),n
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,54:PC=PC+1			;&36			
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		PokeByte MemBank,PC,n2t:PC=PC+1			;ix+data
		Pk1(253,"     LD (IY+"+GetFir+"),"+GetSec+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(54),7,2)+" LL xx")	
		Pk1(54)
		Pk1n(GetSec)
		Pk1n(GetFir)		
		Okay=1:Return
	EndIf	
	If (n2>=16 And n2<=23) And n1=71 Then 	;**** LD (IX+ ),r
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Pk1(221,"     LD (IX+"+GetFir+"),"+RRegister(n2-16)+"    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1((n2-16)+112)
		Pk1n(GetFir)
		Okay=1:Return
	EndIf
	If (n2>=16 And n2<=23) And n1=72 Then 	;**** LD (IY+ ),r
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		PokeByte MemBank,PC,n1t:PC=PC+1			;data
		Pk1(253,"     LD (IY+"+GetFir+"),"+RRegister(n2-16)+"    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1((n2-16)+112)
		Pk1n(GetFir)		
		Okay=1:Return
	EndIf
	If (n1>=16 And n1<=23) And n2=71 Then 	;**** LD r,(IX+ )
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		n9=(n1-16)*8+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 101
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(221,"     LD "+RRegister(n1-16)+",(IX+"+GetSec+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1(n9)
		Pk1n(GetSec)		
		Okay=1:Return
	EndIf
	If (n1>=16 And n1<=23) And n2=72 Then 	;**** LD r,(IY+ )
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		n9=(n1-16)*8+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 110
		PokeByte MemBank,PC,n2t:PC=PC+1			;data
		Pk1(253,"     LD "+RRegister(n1-16)+",(IY+"+GetSec+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(n9),7,2)+" LL")			
		Pk1(n9)
		Pk1n(GetSec)		
		Okay=1:Return
	EndIf

	If (n2>=16 And n2<=23) And n1=67 Then 	;**** LD (HL),r
		n9=(n2-16)+112
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 110 r
		Pk1(n9,"     LD (HL),"+RRegister(n2-16)+"    ;** "+Mid$(Hex$(n9),7,2))
		Okay=1:Return
	End If
	If (n1>=16 And n1<=23) And n2=67 Then 	;**** LD r,(HL)
		n9=((n1-16)*8)+70
		PokeByte MemBank,PC,n9:PC=PC+1			;x 01 r 110
		Pk1(n9,"     LD "+RRegister(n1-16)+",(HL)    ;** "+Mid$(Hex$(n9),7,2))
		Okay=1:Return
	End If

	If n1=23 And n2=64 Then			;***** LD A,(BC)
		PokeByte MemBank,PC,10:PC=PC+1			;&0a
		Pk1(10,"     LD A,(BC)    ;** "+Mid$(Hex$(10),7,2))
		Okay=1:Return
	EndIf
	If n1=64 And n2=23 Then			;***** LD (BC),A
		PokeByte MemBank,PC,2:PC=PC+1			;&02
		Pk1(2,"     LD (BC),A    ;** "+Mid$(Hex$(2),7,2))
		Okay=1:Return
	EndIf
	If n1=23 And n2=65 Then			;***** LD A,(DE)
		PokeByte MemBank,PC,26:PC=PC+1			;&1a
		Pk1(26,"     LD A,(DE)    ;** "+Mid$(Hex$(26),7,2))		
		Okay=1:Return
	EndIf
	If n1=65 And n2=23 Then			;***** LD (DE),A
		PokeByte MemBank,PC,18:PC=PC+1			;&12
		Pk1(18,"     LD (DE),A    ;** "+Mid$(Hex$(18),7,2))
		Okay=1:Return
	EndIf
	If n1=4 And n2=80 Then			;***** LD HL,(nn)
		PokeByte MemBank,PC,42:PC=PC+1			;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(42,"     LD HL,("+GetSec+")    ;** "+Mid$(Hex$(42),7,2)+" LL HH")
		Pk2(GetSec$)
		Okay=1:Return
	EndIf
	If n1=2 And n2=80 Then			;***** LD BC,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,75:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh	
		Pk1(237,"     LD BC,("+GetSec+")    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(75),7,2)+" LL HH")
		Pk1(75)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf
	If n1=3 And n2=80 Then			;***** LD DE,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,91:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(237,"     LD DE,("+GetSec+")    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(91),7,2)+" LL HH")
		Pk1(91)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf
	If n1=5 And n2=80 Then			;***** LD SP,(nn)
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,123:PC=PC+1				;x 01 dd 10 11
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(237,"     LD SP,("+GetSec+")    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(123),7,2)+" LL HH")
		Pk1(123)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf	
	If n1=6 And n2=80 Then			;***** LD IX,(nn)
		PokeByte MemBank,PC,221:PC=PC+1				;&ed
		PokeByte MemBank,PC,42:PC=PC+1				;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(221,"     LD IX,("+GetSec+")    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(42),7,2)+" LL HH")
		Pk1(42)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf	
	If n1=7 And n2=80 Then			;***** LD IY,(nn)
		PokeByte MemBank,PC,253:PC=PC+1				;&ed
		PokeByte MemBank,PC,42:PC=PC+1				;&2a
		PokeByte MemBank,PC,n2t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n2t/256:PC=PC+1			;hh
		Pk1(253,"     LD IY,("+GetSec+")    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(42),7,2)+" LL HH")
		Pk1(42)
		Pk2(GetSec$)		
		Okay=1:Return
	EndIf	
	If n1=80 And n2=4 Then			;***** LD (nn),HL
		PokeByte MemBank,PC,34:PC=PC+1			;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(34,"     LD ("+GetFir+"),HL    ;** "+Mid$(Hex$(34),7,2)+" LL HH")
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf
	If n1=80 And n2=2 Then			;***** LD (nn),BC
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,67:PC=PC+1				;x 01 dd 00 11
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh	
		Pk1(237,"     LD ("+GetFir+"),BC    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(67),7,2)+" LL HH")
		Pk1(67)
		Pk2(GetFir$)
		Okay=1:Return
	EndIf
	If n1=80 And n2=3 Then			;***** LD (nn),DE
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,83:PC=PC+1				;x 01 dd 00 11		
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(237,"     LD ("+GetFir+"),DE    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(83),7,2)+" LL HH")
		Pk1(83)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf
	If n1=80 And n2=5 Then			;***** LD (nn),SP
		PokeByte MemBank,PC,237:PC=PC+1				;&ed
		PokeByte MemBank,PC,115:PC=PC+1				;x 01 dd 00 11		
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh	
		Pk1(237,"     LD ("+GetFir+"),SP    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(115),7,2)+" LL HH")
		Pk1(115)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf	
	If n1=80 And n2=6 Then			;***** LD (nn),IX
		PokeByte MemBank,PC,221:PC=PC+1				;&dd
		PokeByte MemBank,PC,34:PC=PC+1				;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(221,"     LD ("+GetFir+"),IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(34),7,2)+" LL HH")
		Pk1(34)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf
	If n1=80 And n2=7 Then			;***** LD (nn),IY
		PokeByte MemBank,PC,253:PC=PC+1				;&fd
		PokeByte MemBank,PC,34:PC=PC+1				;&22
		PokeByte MemBank,PC,n1t Mod 256:PC=PC+1		;ll
		PokeByte MemBank,PC,n1t/256:PC=PC+1			;hh
		Pk1(253,"     LD ("+GetFir+"),IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(34),7,2)+" LL HH")
		Pk1(34)
		Pk2(GetFir$)		
		Okay=1:Return
	EndIf		
	If n1>=16 And n1<=23 And n2=>16 And n2<=23 Then			;***** LD r,r
		r1=((n1-16)*8)+(n2-16)+64
		PokeByte MemBank,PC,r1:PC=PC+1			;x  01 r r
		Pk1(r1,"     LD "+RRegister(n1-16)+","+RRegister(n2-16)+"    ;** "+Mid$(Hex$(r1),7,2))
		Okay=1:Return	
	EndIf

	If n1=5 And n2=4 Then 			;***** LD SP,HL
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Pk1(249,"     LD SP,HL    ;** "+Mid$(Hex$(249),7,2))
		Okay=1:Return	
	EndIf
	If n1=5 And n2=6 Then 			;***** LD SP,IX
		PokeByte MemBank,PC,221:PC=PC+1			;&dd
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Pk1(221,"     LD SP,IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(249),7,2))
		Pk1(249)
		Okay=1:Return	
	EndIf
	If n1=5 And n2=7 Then 			;***** LD SP,IY
		PokeByte MemBank,PC,253:PC=PC+1			;&fd
		PokeByte MemBank,PC,249:PC=PC+1			;&f9
		Pk1(253,"     LD SP,IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(249),7,2))
		Pk1(249)		
		Okay=1:Return		
	EndIf	

	If n1=32 And n2=23 Then			;***** LD R,A
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,79:PC=PC+1			;&4f
		Pk1(237,"     LD R,A    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(79),7,2))
		Pk1(79)
		Okay=1:Return	
	EndIf
	If n1=23 And n2=32 Then			;***** LD A,R
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,95:PC=PC+1			;&5f
		Pk1(237,"     LD A,R    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(95),7,2))
		Pk1(95)		
		Okay=1:Return
	EndIf
	If n1=33 And n2=23 Then			;***** LD I,A
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,71:PC=PC+1			;&47
		Pk1(237,"     LD I,A    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(71),7,2))
		Pk1(71)			
		Okay=1:Return	
	EndIf
	If n1=23 And n2=33 Then			;***** LD A,I
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,87:PC=PC+1			;&57
		Pk1(237,"     LD A,I    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(87),7,2))
		Pk1(87)			
		Okay=1:Return		
	EndIf
	SetError(900,"LD used incorrectly")
End Function
Function FuncEX()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="AF"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>"AF"Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		PokeByte MemBank,PC,8:PC=PC+1			;&08
		Okay=1
		Cod=Cod+1
		Return	
	EndIf
	If r$="DE"Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>"HL"Then
			SetError(900,"EX used incorrectly")
			Return
		EndIf	
		PokeByte MemBank,PC,235:PC=PC+1			;&eb
		Okay=1
		Cod=Cod+1
		Return	
	EndIf
	If r$="("Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>"SP"Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>")"Then
			SetError(900,"EX used incorrectly")
			Return			
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"EX used incorrectly")
			Return
		EndIf	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		n=0
		If r$="HL"Then
			n=1
			PokeByte MemBank,PC,227:PC=PC+1			;&e3
			Okay=1
			Cod=Cod+1
			Return
		EndIf
		If r$="IX"Then
			n=1
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,227:PC=PC+1			;&e3
			Okay=1
			Cod=Cod+1
			Return
		EndIf
		If r$="IY"Then
			n=1
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,227:PC=PC+1			;&e3
			Okay=1
			Cod=Cod+1
			Return
		EndIf
	EndIf	
	SetError(900,"EX used incorrectly")
End Function
Function FuncPop()
	r$=Upper$(SepSort$(Cod+1))	
	h=GetQQ(r$)	
	If h>=0 And h<=3 Then
		h1=193+(h*16)
		PokeByte MemBank,PC,193+(h*16):PC=PC+1			;x11 qq0 001
		Pk1(193+(h*16),"     POP "+QQRegister$(h)+"    ;** "+Mid$(Hex$(193+(h*16)),7,2))
		Cod=Cod+2
		Okay=1:Return
	EndIf
	If h=-1 Then
		If r$="IX"Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,225:PC=PC+1			;&e1
			Pk1(221,"     POP IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(225),7,2))
			Pk1(225)
			Cod=Cod+2
			Okay=1:Return
		EndIf
		If r$="IY"Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,225:PC=PC+1			;&e1
			Pk1(253,"     POP IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(225),7,2))
			Pk1(225)
			Cod=Cod+2
			Okay=1:Return
		EndIf	
	EndIf
	SetError(900,"POP used incorrectly")
End Function
Function FuncIM()
	Cod=Cod+1
	t=GetNumber(0)
	If t<0 Or t>2 Then
		SetError(900,"IM used incorrectly")
		Return
	EndIf
	If t=0 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,70:PC=PC+1			;&46
		Cod=Cod+1
		Okay=1:Return
	EndIf	
	If t=1 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,86:PC=PC+1			;&56
		Cod=Cod+1
		Okay=1:Return
	EndIf
	If t=2 Then
		PokeByte MemBank,PC,237:PC=PC+1			;&ed
		PokeByte MemBank,PC,94:PC=PC+1			;&5e
		Cod=Cod+1
		Okay=1:Return
	EndIf	
End Function	
Function FuncPush()
	r$=Upper$(SepSort$(Cod+1))	
	h=GetQQ(r$)	
	If h>=0 And h<=3 Then
		h1=197+(h*16)
		PokeByte MemBank,PC,197+(h*16):PC=PC+1			;x11 qq0 101
		Pk1(197+(h*16),"     PUSH "+QQRegister$(h)+"    ;** "+Mid$(Hex$(197+(h*16)),7,2))
		Cod=Cod+2
		Okay=1:Return
	EndIf
	If h=-1 Then
		If r$="IX"Then
			PokeByte MemBank,PC,221:PC=PC+1			;&dd
			PokeByte MemBank,PC,229:PC=PC+1			;&e5
			Pk1(221,"     PUSH IX    ;** "+Mid$(Hex$(221),7,2)+" "+Mid$(Hex$(229),7,2))
			Pk1(229)
			Cod=Cod+2
			Okay=1:Return
		EndIf
		If r$="IY"Then
			PokeByte MemBank,PC,253:PC=PC+1			;&fd
			PokeByte MemBank,PC,229:PC=PC+1			;&e5
			Pk1(253,"     PUSH IY    ;** "+Mid$(Hex$(253),7,2)+" "+Mid$(Hex$(229),7,2))
			Pk1(229)
			Cod=Cod+2
			Okay=1:Return
		EndIf	
	EndIf
	SetError(900,"PUSH used incorrectly")
End Function
Function FuncCALL()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=196+(h*8)
		PokeByte MemBank,PC,h1:PC=PC+1			;x11 cc 100	
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"CALL used incorrectly")
			Return
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		t=GetNumber(1)
		Pk1(h1,"     CALL "+CCRegister(h)+","+Reply$+"    ;** "+Mid$(Hex$(h1),7,2)+" LL HH")		
		Okay=1
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,205:PC=PC+1			;&cd
		t=GetNumber(1)
		Pk1(205,"     CALL "+Reply$+"    ;** "+Mid$(Hex$(205),7,2)+" LL HH")	
		Okay=1
	EndIf
	t1=t Mod 256
	t2=(t/256)Mod 256
	PokeByte MemBank,PC,t1:PC=PC+1
	PokeByte MemBank,PC,t2:PC=PC+1
	Pk2(t)
	If Okay<>1 Then SetError(900,"CALL used incorrectly")
End Function
Function FuncRST()
	Cod=Cod+1
	b3=Failed
	t=GetNumber(1)
	b=0
	If t=8 Then b=1:Okay=1
	If t=16 Then b=2:Okay=1
	If t=24 Then b=3:Okay=1
	If t=32 Then b=4:Okay=1
	If t=40 Then b=5:Okay=1
	If t=48 Then b=6:Okay=1
	If t=56 Then b=7:Okay=1
	If Okay=1 Then 
		PokeByte MemBank,PC,(b*8)+199:PC=PC+1
		Pk1((b*8)+199,"     RST "+Str$(t)+"    ;** "+Mid$(Hex$((b*8)+199),7,2))
	Else
		SetError(900,"RST used incorrectly")
	EndIf
End Function
Function FuncDJNZ()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	b3=Failed
	t=GetNumber(1)	
	If b3=Failed Then
		t=t-PC-2
		If t>128 Or t<-127 Then Stop
	Else
		t=0
	EndIf
	PokeByte MemBank,PC,16:PC=PC+1				
	PokeByte MemBank,PC,t:PC=PC+1
	Okay=1
	Return
End Function
Function FuncJR()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	gttt$=r$
	
	b=0
	If r$="C"Then b=1
	If r$="NC"Then b=2
	If r$="Z"Then b=3
	If r$="NZ"Then b=4
	If b>0 Then
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))		
		If r$<>","Then
			SetError(900,"JR used incorrectly")
			Return
		Else
			Cod=Cod+1
			r$=Upper$(SepSort$(Cod))
		EndIf	
	EndIf
	b3=Failed
	t=GetNumber(1)	
	If b3=Failed Then
		t=t-PC-2
		If t>128 Or t<-127 Then 
			SetError(900,"JR outside range "+gttt$+" ")
			Return
		EndIf	
	Else
		t=0
	EndIf
	If b=0 Then t1=24				;JR e 	&18
	If b=1 Then t1=56				;JR c,e  &38
	If b=2 Then t1=48				;JR nc,e  &30
	If b=3 Then t1=40				;JR z,e	  &28
	If b=4 Then t1=32   			;jr nz,e  &20
	PokeByte MemBank,PC,t1:PC=PC+1				
	PokeByte MemBank,PC,t:PC=PC+1
	Okay=1
	Return
End Function
Function FuncJP()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$="("Then Goto Jumping2
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=194+(h*8)
		PokeByte MemBank,PC,h1:PC=PC+1			;x11 cc 010		
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		If r$<>","Then
			SetError(900,"JP used incorrectly")
			Return
		EndIf
		Cod=Cod+1
		r$=Upper$(SepSort$(Cod))
		t=GetNumber(1)
		Pk1(h1,"     JP "+CCRegister(h)+","+Reply$+"    ;** "+Mid$(Hex$(h1),7,2)+" LL HH")			
		Okay=1
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,195:PC=PC+1			;&c3
		t=GetNumber(1)
		Pk1(195,"     JP "+Reply$+"    ;** "+Mid$(Hex$(195),7,2)+" LL HH")
		Okay=1
	EndIf
	If Left$(r$,1)="."Then r$=Mid$(r$,2)
	If Okay=1 Then 
		t1=t Mod 256
		t2=(t/256)Mod 256
		PokeByte MemBank,PC,t1:PC=PC+1
		PokeByte MemBank,PC,t2:PC=PC+1
		Pk2(t,Reply$)
	Else
		SetError(900,"JP used incorrectly")
	EndIf
	Return

.Jumping2
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	n=0
	If r$="HL"Then
		PokeByte MemBank,PC,233:PC=PC+1			;#e9
		n=1			
	EndIf
	If r$="IX"Then
		PokeByte MemBank,PC,221:PC=PC+1			;#dd
		PokeByte MemBank,PC,233:PC=PC+1			;#e9		
		n=1			
	EndIf
	If r$="IY"Then
		PokeByte MemBank,PC,253:PC=PC+1			;#fd
		PokeByte MemBank,PC,233:PC=PC+1			;#e9		
		n=1			
	EndIf
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$<>")"Then n=0	
	If n=0 Then
		SetError(900,"JP used incorrectly")
	Else
		Okay=1
		Cod=Cod+1
	EndIf
End Function
Function FuncRET()
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))	
	h=GetCC(r$)
	If h>=0 And h<=7 Then
		h1=192+(h*8)
		PokeByte MemBank,PC,192+(h*8):PC=PC+1			;x11 cc 000
		Pk1(192+(h*8),"     RET "+CCRegister$(h)+"    ;** "+Mid$(Hex$(192+(h*8)),7,2))
		Cod=Cod+1
		Okay=1:Return
	EndIf
	If h=-1 Then
		PokeByte MemBank,PC,201:PC=PC+1			;&c9
		Pk1(201,"     RET    ;** "+Mid$(Hex$(201),7,2))
		Okay=1:Return	
	EndIf
	SetError(900,"RET used incorrectly")
	Return	
End Function
Function FuncRLCA()
	PokeByte MemBank,PC,7:PC=PC+1			;&07
	Pk1(7,"     RLCA    ;** "+Mid$(Hex$(7),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRLA()
	PokeByte MemBank,PC,23:PC=PC+1			;&17
	Pk1(23,"     RLA    ;** "+Mid$(Hex$(23),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRCA()
	PokeByte MemBank,PC,15:PC=PC+1			;&0f
	Pk1(15,"     RRCA    ;** "+Mid$(Hex$(15),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRA()
	PokeByte MemBank,PC,31:PC=PC+1			;&1f
	Pk1(31,"     RRA    ;** "+Mid$(Hex$(31),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRLD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,111:PC=PC+1			;&6f
	Pk1(237,"     RLD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(111),7,2))
	Pk1(111)
	Cod=Cod+1
	Okay=1
End Function
Function FuncRRD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,103:PC=PC+1			;&67
	Pk1(237,"     RRD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(103),7,2))
	Pk1(103)
	Cod=Cod+1
	Okay=1
End Function
Function FuncNOP()
	PokeByte MemBank,PC,0:PC=PC+1			;&0
	Pk1(0,"     NOP    ;** 00")
	Cod=Cod+1
	Okay=1
End Function
Function FuncEXX()
	PokeByte MemBank,PC,217:PC=PC+1			;&d9
	Pk1(217,"     EXX    ;** "+Mid$(Hex$(217),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncRETI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,77:PC=PC+1			;&4d
	Pk1(237,"     RETI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(77),7,2))
	Pk1(77)
	Cod=Cod+1
	Okay=1
End Function
Function FuncRETN()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,69:PC=PC+1			;&45
	Pk1(237,"     RETN    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(69),7,2))
	Pk1(69)
	Cod=Cod+1
	Okay=1
End Function
Function FuncINI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,162:PC=PC+1			;&a2
	Pk1(237,"     INI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(162),7,2))
	Pk1(162)
	Cod=Cod+1
	Okay=1
End Function
Function FuncINIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,178:PC=PC+1			;&b2
	Pk1(237,"     INIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(178),7,2))
	Pk1(178)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncIND()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,170:PC=PC+1			;&aa
	Pk1(237,"     IND    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(170),7,2))
	Pk1(170)
	Cod=Cod+1
	Okay=1
End Function
Function FuncINDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,186:PC=PC+1			;&ba
	Pk1(237,"     INDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(186),7,2))
	Pk1(186)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOUTI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,163:PC=PC+1			;&a3
	Pk1(237,"     OUTI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(163),7,2))
	Pk1(163)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOTIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,179:PC=PC+1			;&b3
	Pk1(237,"     OTIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(179),7,2))
	Pk1(179)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOUTD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,171:PC=PC+1			;&ab
	Pk1(237,"     OUTD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(171),7,2))
	Pk1(171)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncOTDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,139:PC=PC+1			;&8b
	Pk1(237,"     OTDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(139),7,2))
	Pk1(139)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,168:PC=PC+1			;&a8
	Pk1(237,"     LDD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(168),7,2))
	Pk1(168)
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,184:PC=PC+1			;&b8
	Pk1(237,"     LDDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(184),7,2))
	Pk1(184)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,161:PC=PC+1			;&a1
	Pk1(237,"     CPI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(161),7,2))
	Pk1(161)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,177:PC=PC+1			;&b1	
	Pk1(237,"     CPIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(177),7,2))
	Pk1(177)
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPD()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,169:PC=PC+1			;&a9
	Pk1(237,"     CPD    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(169),7,2))
	Pk1(169)
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPDR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,185:PC=PC+1			;&b9
	Pk1(237,"     CPDR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(185),7,2))
	Pk1(185)	
	Cod=Cod+1
	Okay=1
End Function
Function FuncHALT()
	PokeByte MemBank,PC,118:PC=PC+1			;&76
	Pk1(118,"     HALT    ;** "+Mid$(Hex$(118),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncCCF()
	PokeByte MemBank,PC,63:PC=PC+1			;&3f
	Pk1(63,"     CCF    ;** "+Mid$(Hex$(63),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncSCF()
	PokeByte MemBank,PC,55:PC=PC+1			;&37
	Pk1(55,"     SCF    ;** "+Mid$(Hex$(55),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncDAA()
	PokeByte MemBank,PC,39:PC=PC+1			;&27
	Pk1(39,"     DAA    ;** "+Mid$(Hex$(39),7,2))
	Cod=Cod+1
	Okay=1
End Function
Function FuncCPL()
	PokeByte MemBank,PC,47:PC=PC+1			;&2f
	Pk1(47,"     CPL    ;** "+Mid$(Hex$(47),7,2))	
	Cod=Cod+1
	Okay=1
End Function
Function FuncNEG()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,68:PC=PC+1			;&44
	Pk1(237,"     NEG     ;** ED 44")
	Pk1(68)
	Cod=Cod+1
	Okay=1
End Function
Function FuncEI()
	PokeByte MemBank,PC,251:PC=PC+1			;&fb
	Pk1(251,"     EI     ;** FB")
	Cod=Cod+1
	Okay=1
End Function
Function FuncDI()
	PokeByte MemBank,PC,243:PC=PC+1			;&f3
	Pk1(243,"     DI     ;** F3")
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDIR()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,176:PC=PC+1			;&b0
	Pk1(237,"     LDIR    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(176),7,2))
	Pk1(176)
	Cod=Cod+1
	Okay=1
End Function
Function FuncLDI()
	PokeByte MemBank,PC,237:PC=PC+1			;&ed
	PokeByte MemBank,PC,160:PC=PC+1			;&a0
	Pk1(237,"     LDI    ;** "+Mid$(Hex$(237),7,2)+" "+Mid$(Hex$(160),7,2))
	Pk1(160)	
	Cod=Cod+1
	Okay=1
End Function

Function QuigLet(Var=0)
	LastICond=0
	ResHL=0
	ResDE=0
	VarLocation=GetRoutineLocation(VarName$(Var))
	a=VarType(Var)
	;**** If array then get  
	If a=>Ex_Arr1Int And a<=Ex_Arr2Str Then
		If a=Ex_Arr1Int Or a=Ex_Arr1Byt Or a=Ex_Arr1Str Then 
			Terminator$="="
			JustAddress=1
			b=AddExpression9$(0)
			JustAddress=0
			Terminator$="="
			If b=0 Then SetError(120,"Doh!"):Return
			PByte 229,"PUSH HL ;Store Array Address"
			ResHL=0
			ResDE=0
		EndIf
		If a=Ex_Arr2Byt Then 
			Terminator$="="
			JustAddress=1
			b=AddExpression9$(0)
			JustAddress=0
			MC_Line=MC_Line-2
			PC=PC-3
			Terminator$="="
			If b=0 Then SetError(120,"Doh!"):Return
		EndIf
		If a=Ex_Arr2Int Then 
			Terminator$="="
			b=AddExpression9$(0)
			JustAddress=1
			MC_Line=MC_Line-4
			JustAddress=0
			PC=PC-4
			Terminator$="="
			If b=0 Then SetError(120,"Doh!"):Return
		EndIf
	Else	
		Cod=Cod+1
	EndIf
	;**** Check for Equals
	r$=Upper$(SepSort$(Cod))
	If r$<>"=" Then SetError(101,"Expecting '='"):Return
	;**** Calculate expression
	Cod=Cod+1
	b=AddExpression9$(0)
	If Err<>0 Then Return
	If b=0 Then 
		Err=101:Okay=2					;"=" expected
		ErrMessage="Variable '"+VarName$(Var)+"' used incorrectly"
		Return
	EndIf
	c=PC
	
	;**** Byte Stuff
	If a=Ex_Var8 Then
		AddMC ";**** '"+VarName$(Var)+"'=Expression"
		If b=Ex_Int16
			PByte 125,"LD A,L"
			PByte 50,"LD ("+VarName$(Var)+"),A ;/Copy Result into '"+VarName$(Var)+"'"
			PShort VarLocation,""
		EndIf
	EndIf
	If a=Ex_Arr1Byt Or a=Ex_Arr2Byt Then
		AddMC ";**** '"+VarName$(Var)+"(x)'=Expression"
		If b=Ex_Int16
			PByte 209,"POP DE ;/Array location"
			PByte 235,"EX DE,HL"
			PByte 115,"LD (HL),E"
		EndIf
	EndIf	
	;**** Int Stuff
	If a=Ex_Var16 Then
		AddMC ";**** '"+VarName$(Var)+"%'=Expression"
		If b=Ex_Int16
			PByte 34,"LD ("+VarName$(Var)+"),HL ;/Copy Result into '"+VarName$(Var)+"'"
			PShort VarLocation,""
		EndIf
	EndIf
	If a=Ex_Arr1Int Or a=Ex_Arr2Int Then
		AddMC ";**** '"+VarName$(Var)+"%(x)'=Expression"
		If b=Ex_Int16
			PByte 209,"POP DE ;/Array location"
			PByte 235,"EX DE,HL ;/Swap Result into DE"
			PByte 115,"LD (HL),E ;/Copy Result into '"+VarName$(Var)+"'"
			PByte 35,"INC HL"
			PByte 114,"LD (HL),D"
		EndIf
	EndIf
	;**** String Stuff
	If a=Ex_StrVar Then
		AddMC ";**** '"+VarName$(Var)+"$'=Expression"
		If b=Ex_String Then
			PShort 23533,"LD DE,("+VarName$(Var)+")"
			PShort VarLocation,""
			AddRoutine("Quig_LetString","QUIG.LETSTRING",";/ '"+VarName$(Var)+"'=")
		EndIf
	EndIf
	If a=Ex_Arr1Str Then
		AddMC ";**** '"+VarName$(Var)+"$(x)'=Expression"
		If b=Ex_String Then 
			PByte 209,"POP DE ;/Array location"
			AddRoutine("Quig_LetString","QUIG.LETSTRING",";/ '"+VarName$(Var)+"'=")
		EndIf
	EndIf	
	
	If c=PC Then SetError 120,"Type mismatch" :Return
	Okay=1
End Function

Function QuigDirective(Sta)
	r$=VarNameU$(Sta)
	If r$="{"Then QuigOpenPar(Sta):LastICond=0:Return
	If r$="}"Then QuigClosePar(Sta):Return
	If r$="QUIGLINE" QuigLine(Sta):Return
	LastICond=0
	Select r$
		Case ":" QuigColon(Sta):Return
		Case "FUNC" QuigFunction(Sta):CodeType=1:LastICond=1:Return
		Case "FUNCTION" QuigFunction(Sta):CodeType=1:LastICond=1:Return
		Case "ENDF" QuigEndFunction(Sta):Return
		Case "ENDFUNC" QuigEndFunction(Sta):Return				
		Case "VAR" QuigVar(Sta):Return	
		Case "ASM" QuigZ80(Sta):Return	
		Case "QUIGS" QuigQuigs(Sta):Return
	End Select		
End Function

Function QuigStatement(Sta)
	Special=0
	LastICond=0
	Select VarNameU$(Sta)
		Case "FOR" QuigFor(Sta):LastICond=1:Return
		Case "NEXT"QuigNext(Sta):Return
		Case "IF" QuigIF(Sta):LastICond=1:Return
		Case "ENDIF" QuigEndIf(Sta):Return
		Case "ELSE" QuigElse(Sta):Return
		Case "WHILE" QuigWhile(Sta):LastICond=1:Return
		Case "WEND" QuigWend(Sta):Return
		Case "RETURN" QuigReturn(Sta):Return	
		;Case "REPEAT"
	End Select
	If special=0 Then
		
		
		
		r$=VarInp$(Sta)
		
		r1$=r$
		operands=1
		While Instr(r1$,",",1)
			operands=operands+1
			r1$=Mid$(r1$,Instr(r1$,",",1)+1)
		Wend
		
		Cod=Cod+1
		n$=SepSort(Cod)
		
		ShouldEndBracket=0
		If n$<>"("Then
			Cod=Cod-1
		Else
			ShouldEndBracket=1
		EndIf
		Terminator=""
		c=0
		d=0
		r2$=""
		r3$=""
		e=0
		While r$>""
			ResDE=0
			ResHL=0
			r1$=Mid$(r$,1,1)
			If r1$="@" Or r1$="(" Or r1$="#" Or r1$="%" Or r1$="+" Then
				r$=Mid$(r$,2)
				a=Instr(r$,",")
				If a>0 Then 
					r2$=Mid$(r$,1,a-2)
					r$=Mid(r$,a+1)
				Else
					r2$=Mid$(r$,1,Len(r$)-1)
					r$=""
				EndIf
				
				If r1$="(" Then
					If operands<>2 Then
						PByte 42,"LD HL,("+r2$+")"
						PShort GetRoutineLocation(r2$),""
					Else
						d=1
						e=1
						r3$=r2$
					EndIf	
				EndIf	
				If r1$="@" Or r1$="%" Or r1$="+" Then
					If operands<>2 Then
						PByte 33,"LD HL,"+r2$+""
						PShort GetRoutineLocation(r2$),""
					Else
						d=2
						If r1$="%"Then d=4
						If r1$="+"Then d=5
						e=1
						r3$=r2$
					EndIf	
				EndIf
				If r1$="#"Then
					If operands<>2 Then 
						PByte 33,"LD HL,"+r2$+""
						PShort GetIntNumber(r2$),""
					Else
						d=3
						e=1
						r3$=r2$
					EndIf	
				EndIf 
				If r$>"" And e=0Then
					PByte 229,"PUSH HL ;/x99"
					c=1
				EndIf
				e=0
			Else
				a=Instr(r$,",")
				If a>0 Then 
					r1$=Mid$(r$,1,a-1)
					r$=Mid$(r$,a+1)
				Else
					r1$=r$
					r$=""
				EndIf
				q=0
				Select Right$(r1$,1)
					Case "%" q=Ex_Int16
					Case "#" q=Ex_Float
					Case "$" q=Ex_String	
					Case "^" q=Ex_Int32
					Case "*" q=Ex_Byte	
				End Select
				Cod=Cod+1
				If r$="" And shouldendbracket=1 Then
					Terminator=")"
				EndIf
				b=AddExpression9(0)
				If Err<>0 Then Return
				If b<>q Then SetError(102,"Wrong Input type '"+VarName2$(Sta)+"'"):Return
				If r$>"" Then
					PByte 229,"PUSH HL ;/x98"
					c=1
				EndIf	
			EndIf
		Wend
		Terminator=""
		
		If d=1 Then 
			PShort 23533,"LD DE,("+r3$+")"
			PShort GetRoutineLocation(r3$),""
		EndIf
		If d=2 Then
			PByte 17,"LD DE,"+r3$+""
			PShort GetRoutineLocation(r3$),""
		EndIf
		If d=3 Then
			PByte 17,"LD DE,"+r3$+""
			PShort GetIntNumber(r3$),""
		EndIf
		If d=4 Then
			PByte 34,"LD ("+r3$+"),HL"
			PShort GetRoutineLocation(r3$),""
		EndIf		
		If d=5 Then
			PByte 125,"LD A,L"
			PByte 50,"LD ("+r3$+"),A"
			PShort GetRoutineLocation(r3$),""
		EndIf			
		
		If c=1 Then 
			PByte 209,"POP DE ;/x1"
		EndIf
		If VarRout$(Sta)>"" Then 
			AddRoutine(VarRout$(Sta),VarLib$(Sta),";/CALL '"+VarName2$(Sta)+"'")
		EndIf	
		Okay=1
		Cod=Cod+1
	EndIf	
	
End Function

Function QuigFunction(sta)
	Cod=Cod+1
	CodeType=1
	gt=0
	r$=Upper$(SepSort$(Cod))
	r9$=Mid$(r$,1,1)
	If r9$<"A"Or r9$>"Z"Then SetError 111,"Function name not valid":Return
	If InFunction<>0 Then SetError 101,"Function '"+SepSort$(Cod)+"' cannot exist inside another Function":Return
	
	CStrucCount=CStrucCount+1
	CStrucType(CStrucCount)=1
	CStrucPar(CStrucCount)=0
	InFunction=CStrucCount
	For f=1 To LabCount
		If Lab$(f)=r$ Then
			gt=f
			f=LabCount
		EndIf	
	Next
	If gt=0 Then
		LabCount=LabCount+1
		gt=LabCount
	EndIf
	LabRef(gt)=LabRef(gt)+1
	If LabRef(gt)>1 Then SetError 13,"Function already declared":Return
	
	Lab$(gt)="QFUNC_"+Replace(r$,".","_")
	LabT(gt)=0
	LabOK(gt)=1
	LabV(gt)=PC	
	
	g=0
	For f=1 To VarNo
		If r$=VarNameU$(f)Then 
			g=f
			f=VarNo+1
		EndIf
	Next
	
	;**** Work out Inputs I need
	ReqListCount=0
	r1$=VarInp$(g)
	
	While r1$>""
		a=Instr(r1$,",",1)
		If a>0 Then
			r2$=Mid$(r1$,1,a-1)
			r1$=Mid$(r1$,a+1)
		Else
			r2$=r1$
			r1$=""
		EndIf
		ReqListCount=ReqListCount+1
		ReqListName(ReqListCount)=Mid$(r2$,1,Len(r2$)-1)
	Wend
	
	;**** Imbed inputs into code
	If ReqListCount>2 Then
		PShort 57853,"POP IY ;Get the Return Position"
	EndIf	
	For f=ReqListCount To 1 Step -1
		If f=ReqListCount Then
			PByte 34,"LD ("+ReqListName(f)+"),HL  ;Loads HL into variable"
			PShort GetRoutineLocation(ReqListName(f)),""
		EndIf
		If f=ReqListCount-1 Then
			PShort 21485,"LD ("+ReqListName(f)+"),DE  ;Loads DE into variable"
			PShort GetRoutineLocation(ReqListName(f)),""
		EndIf
		If f<ReqListCount-1 Then
			PByte 193,"POP BC  ;Pops from stack into variable"
			PShort 17389,"LD ("+ReqListName(f)+"),BC  ;"
			PShort GetRoutineLocation(ReqListName(f)),""
		EndIf
	Next
	If ReqListCount>2 Then
		PShort 58877,"PUSH IY ;Restores Exit position"
	EndIf
	
	Select VarOut$(g)
		Case "" CStrucRT(CStrucCount)=Ex_Void
		Case "%" CStrucRT(CStrucCount)=Ex_Int16
		Case "$" CStrucRT(CStrucCount)=Ex_String
		Case "#" CStrucRT(CStrucCount)=Ex_Float
		Case "^" CStrucRT(CStrucCount)=Ex_Int32
		Case "*" CStrucRT(CStrucCount)=Ex_Byte
			
	End Select
	
	.gQuigFunction
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	If r$<>"" And r$<>")"Then Goto gQuigFunction
	If r$=")"Then Cod=Cod+1
	Okay=1
	
End Function	

Function QuigReturn(Sta)
	Cod=Cod+1
	If CStrucCount<1 Then SetError 101,"'Return' when not inside 'Function'" :Return
	If CStrucRT(InFunction)>0 Then
		b=AddExpression9$(0)
		If CStrucRT(InFunction)<>b Then SetError 101,"'Return' type incorrect" :Return
	EndIf
	PByte 201,"RET"
	Okay=1
End Function
Function QuigEndFunction(Sta)
	Cod=Cod+1
	CodeType=1
	If CStrucCount<1 Then Stop ;SetError 101,"'EndF' without corrosponding 'Function'" :Return
	If CStrucType(CStrucCount)<>CStrucFunc Then Stop;SetError 101,"'EndF' doesnt corrospond to 'Function'":Return
	
	If CStrucRT(CStrucCount)>0 Then
		Select CStrucRT(CStrucCount)
				
			Case Ex_Int16
				PByte 33,"LD HL,0  ;Return 0 Value"
				PShort 0,""
			Case Ex_String
				PByte 33,"LD HL,Quig_Null_String  ;"+Str(CStrucRT(CStrucCount))
				PShort GetRoutineLocation("Quig_Null_String"),""
		End Select
	EndIf	
	PByte 201,"RET"
	CStrucRT(CStrucCount)=0
	CStrucCount=CStrucCount-1
	InFunction=0
	Okay=1
End Function
Function QuigVar(Sta)
End Function
Function QuigZ80(Sta)
	Cod=Cod+1
	CodeType=0
	Okay=1
End Function
Function QuigQuigs(Sta)
	Cod=Cod+1
	CodeType=1
	Okay=1
End Function	

Function QuigLine(Sta)
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	CurrBasL=GetDecimal(r$,1,0)
	Cod=Cod+1
	Okay=1
End Function
Function QuigColon(Sta)
	Cod=Cod+1
	r$=Upper$(SepSort$(Cod))
	Okay=1
End Function	
Function QuigOpenPar(Sta)
	If LastICond=0 Then SetError 200,"Unexpected {":Return 0
	CStrucPar(CStrucCount)=1
	Cod=Cod+1
	Okay=1
End Function
Function QuigClosePar(Sta)
	If CStrucCount<1 Then SetError 200,"Unexpected }":Return 0
	If CStrucPar(CStrucCount)<>1 Then SetError 200,"Unexpected }":Return 0
	
	If CStrucType(CStrucCount)=1 Then LastICond=0:QuigEndFunction(Sta):Return
	If CStrucType(CStrucCount)=2 Then LastICond=0:QuigEndIf(Sta):Return
	If CStrucType(CStrucCount)=3 Then LastICond=0:QuigWend(Sta):Return
	If CStrucType(CStrucCount)=5 Then LastICond=0:QuigFor(Sta):Return	
	
End Function
Function QuigFor(sta)
	Cod=Cod+1
	ResHL=0:ResDE=0
	
	CStrucCount=CStrucCount+1
	CStrucType(CStrucCount)=CStrucFor
	CStrucPar(CStrucCount)=0
	
	r$=Upper$(SepSort(Cod))
	g=0
	For f=1 To VarNo
		If VarNameU$(f)=r$ Then 
			;**** Check If Variable Found
			If VarUse(f)=AC_Var Then
				g=f
				f=VarNo+1
			EndIf
		EndIf
	Next
	If g=0 Then SetError 120,"'For' Expects a variable":Return
	If VarType(g)<>Ex_Var16 Then SetError 120,"'For' can only use an INT variable type":Return
	Cod=Cod+1
	r$=Upper$(SepSort(Cod))
	If r$<>"=" Then SetError 120,"'For expecting =":Return 
	Cod=Cod+1
	FCod=Cod
	FPC=PC:FMC_Line=MC_Line
	Terminator="TO"
	b=AddExpression9$()
	If b<>Ex_Int16 Then SetError 120,"'For' type mismatch":Return
	VarLocation=GetRoutineLocation(VarName$(g))
	CStrucVar(CStrucCount)=VarName$(g)
	r$=Upper$(SepSort(Cod))
	If r$<>"TO" Then SetError 120,"'For' expects 'To'":Return
	Cod=Cod+1
	PC=FPC:MC_Line=FMC_Line
	ResHL=0:ResDE=0
	Terminator="STEP"
	b=AddExpression9$()
	If b<>Ex_Int16 Then SetError 120,"'For' type mismatch":Return
	PByte 34,"LD (Whereever),HL ;/Copy Result into static'"+VarName$(g)+"'"
	r$=Upper$(SepSort(Cod))
	CStrucStep(CStrucCount)=1
	If r$="STEP" Then
		Cod=Cod+1
		;**** Check if its a Number
		r$=Upper$(SepSort(Cod))
		a=0
		If r$="-"Then
			Cod=Cod+1
			r$=Upper$(SepSort(Cod))
			a=1
		EndIf	
		Res=IsNumber#(r$)
		If Succeed=True Then
			If a=0 Then
				CStrucStep(CStrucCount)=Int(Res)
			Else
				CStrucStep(CStrucCount)=-Int(Res)
			EndIf	
		Else	
			SetError 120,"Expecting number after 'Step'":Return
		EndIf
	EndIf
	
	;****
	tre=PC
	PShort 0,""
	FCod2=Cod
	Cod=FCod
	Terminator="TO"
	ResHL=0:ResDE=0
	b=AddExpression9$()
	Cod=FCod2
	
	CStrucLoopPC(CStrucCount)=PC
	PByte 34,"LD ("+VarName$(g)+"),HL ;/Loop Repeat Point
	PShort VarLocation,""
	PByte 17,"LD DE,---- ;/Get Start value"
	PCx=PC
	PC=tre
	PShort PCx,""
	PC=PCx
	PShort 0,""
	
	If CStrucStep(CStrucCount)=>0 Then
		AddMC ";*** HL=>DE THEN BRANCH IF FALSE" 
		PByte 124,"LD A,H"
		PByte 170,"XOR D"
		PByte 250,"JP M,"+Str$(Int(PC+10))
		PShort Int(PC+10),""
		PByte 235,"EX DE,HL"
		PShort 21229,"SBC HL,DE"
		PShort 2096,"JR NC,8"
		PByte 195,"JP .EndOfBlock ;/Jump to end of code block"
		CStrucPC(CStrucCount)=PC
		PShort 0,""	
		PShort 31435,"BIT 7,D"
		PByte 194,"JP NZ,EndOfBlock
		CStrucPC1(CStrucCount)=PC
		PShort 0,""
	Else
		AddMC ";*** HL<=DE THEN BRANCH IF FALSE" 
		PByte 124,"LD A,H"
		PByte 170,"XOR D"
		PByte 250,"JP M,"+Str$(Int(PC+9))
		PShort Int(PC+9),""
		PShort 21229,"SBC HL,DE"
		PShort 2096,"JR NC,8"
		PByte 195,"JP .EndOfBlock ;/Jump to end of code block"
		CStrucPC(CStrucCount)=PC
		PShort 0,""			
		PShort 31435,"BIT 7,D"
		PByte 202,"JP Z,EndOfBlock ;/Jump to end of code block"
		CStrucPC1(CStrucCount)=PC
		PShort 0,""
	EndIf
	Okay=1:Return
	
End Function

Function QuigNext(Sta)
	Cod=Cod+1
	If CStrucCount<1 Then SetError 101,"'Next' without corrosponding 'For'" :Return
	If CStrucType(CStrucCount)<>CStrucFor Then SetError 101,"'Next' doesnt corrospond to 'For'":Return
	
	VarLocation=GetRoutineLocation(CStrucVar(CStrucCount))
	PByte 42,"LD HL,("+CStrucVar(CStrucCount)+") ;/"
	PShort varlocation,""
	
	If CStrucStep(CStrucCount)=1 Then PByte 35,"INC HL"
	If CStrucStep(CStrucCount)=-1 Then PByte 43,"DEC HL"
	
	If CStrucStep(CStrucCount)=2 Then 
		PByte 35,"INC HL"
		PByte 35,"INC HL"
	EndIf	
	If CStrucStep(CStrucCount)=-2 Then 
		PByte 43,"DEC HL"
		PByte 43,"DEC HL"	
	EndIf	
	
	PByte 195,"JP NextStart"
	PShort CStrucLoopPC(CStrucCount),""
	
	PCo=PC
	PC=CStrucPC(CStrucCount)
	PShort PCo,""
	PC=CStrucPC1(CStrucCount)
	PShort PCo,""	
	PC=Pco
	
	CStrucCount=CStrucCount-1
	Okay=1
End Function

Function QuigWhile(sta)
	ResDE=0:ResHL=0
	Cod=Cod+1
;	CondJump=1
	
	CStrucCount=CStrucCount+1
	CStrucType(CStrucCount)=CStrucWhile
	CStrucPar(CStrucCount)=0	
	CStrucPC1(CStrucCount)=PC
	b=AddExpression9$(0)
	If Err<>0 Then Return
;	If CondJumpPC>0 Then
;		;CStrucPC(CStrucCount)=CondJumpPC
;		CStrucPC1(CStrucCount)=CondJumpPC1
;		CondJumpPC=0
;		CondJumpPC1=0
;	Else
		AddMC ";* IF branch if condition fails" 
		PByte 124,"LD A,H ;/Branch if HL=0"
		PByte 181,"OR L"
		PByte 202,"JP Z,.EndOfBlock ;/Jump to end of code block"
		CStrucPC(CStrucCount)=PC
		PShort 0,""
;	EndIf
	Okay=1
	
End Function
Function QuigWend(sta)
	Cod=Cod+1
	If CStrucCount<1 Then SetError 101,"'Wend' without corrosponding 'While'" :Return
	If CStrucType(CStrucCount)<>CStrucWhile Then SetError 101,"'Wend' doesnt corrospond to 'While'":Return
	
	PByte 195,"JP WhileStart"
	PShort CStrucPC1(CStrucCount),""
	pco=PC
	PC=CStrucPC(CStrucCount)
	PShort pco,""
	PC=pco
	CStrucCount=CStrucCount-1
	Okay=1
End Function


Function QuigIF(sta)
	ResDE=0:ResHL=0
	Cod=Cod+1
	CondJump=1
	Terminator="THEN"
	b=AddExpression9$(0)
	If Err<>0 Then Return
	CondJump=0
	
	r$=Upper$(SepSort$(Cod))
	If r$="THEN" Then 
		Cod=Cod+1
		If SepSort$(Cod+1)>"" Then ForceEndIf=1
	EndIf
	CStrucCount=CStrucCount+1
	CStrucType(CStrucCount)=CStrucIf
	CStrucPar(CStrucCount)=0
	
	If CondJumpPC>0 Then
		CStrucPC(CStrucCount)=CondJumpPC
		CStrucPC1(CStrucCount)=CondJumpPC1
		CondJumpPC=0
		CondJumpPC1=0
	Else
		AddMC ";* IF branch if condition fails" 
		PByte 124,"LD A,H ;/Branch if HL=0"
		PByte 181,"OR L"
		PByte 202,"JP Z,.EndOfBlock ;/Jump to end of code block"
		CStrucPC(CStrucCount)=PC
		PShort 0,""
	EndIf
	Okay=1
	
End Function
Function QuigElse(Sta)
	Cod=Cod+1
	If CStrucCount<1 Then SetError 101,"'Else' without corrosponding 'If'":Return
	If CStrucType(CStrucCount)<>CStrucIf Then SetError 101,"'Else' doesnt corrospond to 'IF'":Return
	PByte 195,"JP EndOfCondition ;/Jump to End of Else"
	PCp=PC			;Change this later
	PShort 0,""
	PCo=PC
	PC=CStrucPC(CStrucCount)
	CStrucPC(CStrucCount)=PCp
	PShort PCo,""
	PC=PCo
	Okay=1	
End Function
Function QuigEndIf(sta)
	Cod=Cod+1
	If CStrucCount<1 Then SetError 101,"'EndIf' without corrosponding 'If'":Return
	If CStrucType(CStrucCount)<>CStrucIf Then SetError 101,"'EndIf' doesnt corrospond to 'IF'":Return	
	
	PCo=PC
	PC=CStrucPC(CStrucCount)
	PShort PCo,""
	PC=CStrucPC1(CStrucCount)
	If PC>0 Then PShort PCo,""
	CStrucCount=CStrucCount-1
	PC=PCo
	Okay=1
End Function

Function BasicNetTCPServerOpen()
;	Cod=Cod+1
;	d=CommandBracket()
;	AddExpression(Cod,d,2)
;	AddRoutine("SyB_Net_TCP_Server_Open","SYB.NET.TCP.SERVER.OPEN")
;	Okay=1
End Function
Function BasicNetTCPClientOpen()
;	Cod=Cod+1
;	d=CommandBracket()
;	AddExpression(Cod,d,2)
;	r$=Upper$(SepSort$(Cod))
;	If r$<>","Then
;		ErrMessage$="',' expected":Err=120
;		Return
;	EndIf
;	Cod=Cod+1
;	AddExpression(Cod,d,5)
;	r$=Upper$(SepSort$(Cod))
;	If r$<>","Then
;		ErrMessage$="',' expected":Err=120
;		Return
;	EndIf
;	Cod=Cod+1	
;	AddExpression(Cod,d,2)
;	AddRoutine("SyB_Net_TCP_Client_Open","SYB.NET.TCP.CLIENT.OPEN")
;	Okay=1
End Function
Function BasicNetTCPClose()
;	Cod=Cod+1
;	AddRoutine("SyB_Net_TCP_Close","SYB.NET.TCP.CLOSE") 
;	Okay=1
End Function
Function BasicNetTCPSend()
;	Cod=Cod+1
;	d=CommandBracket()
;	AddExpression(Cod,d,5)
;	AddRoutine("SyB_Net_TCP_Send","SYB.NET.TCP.SEND")
;	Okay=1
End Function

Function ConvertFraction$(Res#,IsNeg=0)
	br$=""
	n=0
	Treg=Floor(Res#)
	Keg#=Float(Res#-Treg)
	While Keg#>0 Or n>24
		Keg#=Keg#*2
		Treg=Floor(Keg#)
		Keg#=Float(Keg#-Treg)
		If Treg>0 Then
			Br$=br$+"1"
		Else
			Br$=br$+"0"
		EndIf
		n=n+1
	Wend
	
	br1$=""
	n1=0
	j=1
	Treg=Floor(Res#)
	While Treg>0
		If treg And 1 Then
			Br1$="1"+br1$
		Else
			Br1$="0"+br1$
		EndIf
		Treg=Treg Shr 1
		n1=n1+1
	Wend
	
	
	br$=Mid$(br1$+br$+"000000000000000000000000000000000000",2,31)
	If IsNeg=0 Then 
		br$="0"+br$
	Else
		br$="1"+br$
	EndIf
	n2=128+n1
	br1$=""
	j=1
	While j<=n2
		If (n2 And j)<>0 Then
			Br1$="1"+br1$
		Else
			Br1$="0"+br1$
		EndIf
		j=j Shl 1
	Wend		
	Return Mid$(br$,9,24)+Mid$(br$,1,8)+Right$("00000000"+br1$,8)
End Function

Function AddRoutine(e$,k$="",l$="")
	gt=GetRoutineLocation(e$)
	If gt=0 Then			;**** Just check if Library
		r$=Upper$(e$)
		For f=1 To Lib
			If r$=Libr$(f)Then
				LibUsed(f)=1
			EndIf
		Next
	EndIf
	PByte 205,"CALL "+e$+" "+l$
	PShort gt,""
	
	If k$>"" Then
		k$=Upper$(Trim(k$))
		r4=0
		For f=1 To LbFound
			If k$=LbName$(f)Then
				If LbUsed(f)=0 Then	
					For g=LbStart(f) To LbEnd(f)
						LibEnd=LibEnd+1
						Ld$(LibEnd)=Lb$(g)
					Next
					LbUsed(f)=1
				EndIf
				f=LbFound+1
				r4=1
			EndIf	
		Next
		If r4=0 Then DebugLog k$+" Not found in Library"
	EndIf	
End Function
Function AddJPRoutine(e$,k$="")
	gt=GetRoutineLocation(e$)
	If gt=0 Then			;**** Just check if Library
		r$=Upper$(e$)
		For f=1 To Lib
			If r$=Libr$(f)Then
				LibUsed(f)=1
			EndIf
		Next
	EndIf
	PokeByte MemBank,PC,195:PC=PC+1
	PokeShort MemBank,PC,gt:PC=PC+2
	If k$>"" Then
		k$=Upper$(Trim(k$))
		r4=0
		For f=1 To LbFound
			If k$=LbName$(f)Then
				If LbUsed(f)=0 Then	
					For g=LbStart(f) To LbEnd(f)
						LibEnd=LibEnd+1
						Ld$(LibEnd)=Lb$(g)
					Next
					LbUsed(f)=1
				EndIf
				f=LbFound+1
				r4=1
			EndIf	
		Next
		If r4=0 Then DebugLog k$+" Not found in Library"
	EndIf		
End Function
Function WorkOutByte(Br1$)
	n=0
	j=1
	If Len(Br1$)<>8 Then RuntimeError(g)
	For f=Len(Br1$) To 1 Step -1
		If Mid$(Br1$,f,1)="1" Then n=n+j
		j=j Shl 1
	Next
	Return n
End Function
Function GetRoutineLocation(e$)
	gt=0
	If LabCount>0 Then
		r$=Upper$(e$)
		If Mid$(r$,1,1)="."Then r$=Mid$(r$,2)
		For f=1 To LabCount
			If Lab$(f)=r$ Then
				gt=f
				f=LabCount
			EndIf	
		Next
	EndIf
	If gt=0 Then
		UnRef=UnRef+1
		UnRefLab$(UnRef)=r$
		;If r$=""Then RuntimeError(23)
		UnRefLin(UnRef)=CurrLine
		UnRefPC(UnRef)=PC
	EndIf
	
	If gt=0 Then
		Failed=Failed+1
		Goto Lompin
	Else
		If LabOK(gt)=1 Then 
			gt=LabV(gt)
			Goto Lompin
		Else
			Failed=Failed+1
			Goto Lompin
		EndIf	
	EndIf
.Lompin
	Return gt
End Function
Function IncludeData(Val#,typo)
	If typo=2 Then PokeShort MemBank,PC,Val#:PC=PC+2:Return

	Stop

End Function
Function IsNumber#(Srq$)
	ResultInt=0
	Tot#=0
	Tot2=0
	TotBase=1
	Srq$=Upper$(Srq$)
	If Mid$(Srq$,1,7)="SYSTEM." Then
		az=0
		If Srq$="SYSTEM.MACHINE.CPC464"Then Tot#=0:az=1
		If Srq$="SYSTEM.MACHINE.CPC664"Then Tot#=1:az=1
		If Srq$="SYSTEM.MACHINE.CPC6128"Then Tot#=2:az=1
		If Srq$="SYSTEM.MACHINE.CPC464PLUS"Then Tot#=3:az=1
		If Srq$="SYSTEM.MACHINE.CPC6128PLUS"Then Tot#=4:az=1
		If Srq$="SYSTEM.MACHINE.ENTERPRISE"Then Tot#=7:az=1
		If Srq$="SYSTEM.MACHINE.MSX2"Then Tot#=8:az=1
		If Srq$="SYSTEM.MACHINE.MSX2PLUS"Then Tot#=9:az=1
		If Srq$="SYSTEM.MACHINE.MSXTURBOR"Then Tot#=10:az=1		
		If Srq$="SYSTEM.MACHINE.PCW8XXX"Then Tot#=12:az=1
		If Srq$="SYSTEM.MACHINE.PCW9XXX"Then Tot#=13:az=1
		If az>0 Then 
			Succeed=True
			If UsingSign=1 Then Return -Tot#
			Return Tot#
		EndIf
		Succeed=False
	EndIf
	If Mid$(Srq$,1,18)="CONTROL.EVENT.TYPE" Then
		az=0
		If Srq$="CONTROL.EVENT.TYPE.CONTENT"Then Tot#=14:az=1
		If Srq$="CONTROL.EVENT.TYPE.TOOL"Then Tot#=15:az=1
		If Srq$="CONTROL.EVENT.TYPE.KEY"Then Tot#=16:az=1
		If Srq$="CONTROL.EVENT.TYPE.MOUSELEFTCLICK"Then Tot#=0:az=1
		If Srq$="CONTROL.EVENT.TYPE.MOUSERIGHTCLICK"Then Tot#=1:az=1
		If Srq$="CONTROL.EVENT.TYPE.MOUSELEFTDBLCLICK"Then Tot#=2:az=1
		If Srq$="CONTROL.EVENT.TYPE.MOUSEMIDDLECLICK"Then Tot#=3:az=1
		If Srq$="CONTROL.EVENT.TYPE.MOUSEWHEELMOVE"Then Tot#=8:az=1			
		If az>0 Then 
			Succeed=True
			If UsingSign=1 Then Return -Tot#
			Return Tot#
		EndIf
		Succeed=False		
	EndIf
	If Mid$(Srq$,1,7)="NET.TCP" Then
		az=0
		If Srq$="NET.TCP.OPENING"Then Tot#=1:az=1
		If Srq$="NET.TCP.ESTABLISHED"Then Tot#=2:az=1
		If Srq$="NET.TCP.CLOSEWAIT"Then Tot#=3:az=1
		If Srq$="NET.TCP.CLOSE"Then Tot#=4:az=1
		If az>0 Then
			Succeed=True
			If UsingSign=1 Then Return -Tot#
			Return Tot#
		EndIf
		Succeed=False
	EndIf	
	
	
	
	If Len(Srq$)>0 Then
		For Pil=Len(Srq$)To 1 Step -1
			tg=0
			Srq1$=Mid$(Srq$,Pil,1)
			If Srq1$>="0" And Srq1$<="9"Then
				Tot#=Tot#+((Asc(Srq1$)-48)*TotBase)
				TotBase=TotBase*10
				tg=1
			EndIf
			If Srq1$="."Then
				Tot#=Tot#/TotBase
				TotBase=1
				tg=1
				ResultInt=1
			EndIf
			If tg=0 Then
				Succeed=False
				Return 0
			EndIf
		Next
		Succeed=True
		If UsingSign=1 Then Return -Tot#
		Return Tot#
	EndIf
	Succeed=False
	Return 0
End Function
Function IsQuote$(Srq$)
	Srq$=Trim$(Srq$)
	If Mid$(Srq$,1,1)<>Chr$(34)Then Return"@Sheet filename expected"
	Srq$=Trim$(Mid$(Srq$,2))
	s$=""
	b=1
	.label1
	If Len(s$)>8 Then Return "@Sheet Filename too long"
	c$=Mid$(Srq$,b,1)
	If c$=Chr$(34) Then Goto dffd
	If (Upper$(c$)>="A"And Upper$(c$)<="Z")Or (c$>="0" And c$<="9") Or c$="_"Then 
		s$=s$+c$
		b=b+1
		Goto label1
	EndIf
	Return "@Invalid filename"
	.dffd
	Return s$
End Function
Function IsVariable#(Srq$)
	Srq$=Upper$(Srq$)
	If Len(Srq$)>0 Then
		For f=1 To VarNo
			If Upper$(VarName$(f))=Srq$ Or Upper$(VarName2$(f))=Srq$ Then
				Succeed=True
				Return f
			EndIf
		Next
	EndIf
	Succeed=False
	Return 0
End Function
Function IsLabel#(Srq$)
	Srq$=Upper$(Srq$)
	If Len(Srq$)>0 Then
		For f=1 To LabCount
			If Upper$(Lab$(f))=Srq$ Then
				Succeed=True
				Return f
			EndIf
		Next
	EndIf
	Succeed=False
	Return 0
End Function
Function SepSort$(q10=1)
	If Wrd(q10,0)=0 Then Return ""
	Return Mid$(Answer$,Wrd(q10,0),Wrd(q10,1)-Wrd(q10,0)+1)
End Function
Function Seperate$(t9)
	Goit$=Cd$(t9)
	Doi=0
	;Doing = 1 = Word or Number
	;Doing = 2 = Quotes
	n6=0
	p6=1
	While n6<Len(Goit$)
		n6=n6+1
		j=Asc(Mid$(Goit$,n6,1))
		If j=34 Then
			If Doi<>2 Then
				Wrd(p6,0)=n6
				Doi=2
			Else
				Wrd(p6,1)=n6
				p6=p6+1
				Doi=0
			EndIf	
		EndIf
		If Doi<>2 Then	
			If (j=>97 And j<=122)Or (j>=48 And j<=57) Or (j>=65 And j<=90)Or j=46 Or j=95 Or j=38 Then
				If Doi=0 Then
					Doi=1
					Wrd(p6,0)=n6
				EndIf
			Else
				If Doi=1 Then
					Doi=0
					Wrd(p6,1)=n6-1
					p6=p6+1
				EndIf	
			EndIf
			If doi<>1 Then
				If j=36 Then
					Wrd(p6,0)=n6
					Doi=1
				EndIf
				If (j>36 And j<38) Or (j>38 And j<46) Or (j>=58 And j<=64) Or j=35 Or j=33 Then
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
				If (j>=91 And j<=94)Or (j>=123 And j<=125) Or j=47 Then		
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
			EndIf	
		EndIf
	Wend
	If Doi=1 Then
		Wrd(p6,1)=n6
		p6=p6+1
	EndIf
	If Doi=2 Then
		Goit$=Goit$+Chr$(34)
		Wrd(p6,1)=n6+1
		p6=p6+1
	EndIf
	Wrd(p6,0)=0
	Return Goit$
End Function
Function Seperate2$(t9)
	r=0
	If t9<=CoreEnd Then Goit$=Cd$(t9):r=1
	If t9>CoreEnd+LibEnd Then Goit$=Cd$(t9-LibEnd)
	If t9>CoreEnd And t9<=CoreEnd+LibEnd Then Goit$=Ld$(t9-CoreEnd)
	
	Doi=0
	;Doing = 1 = Word or Number
	;Doing = 2 = Quotes
	n6=0
	p6=1
	While n6<Len(Goit$)
		n6=n6+1
		j=Asc(Mid$(Goit$,n6,1))
		If j=34 Then
			If Doi<>2 Then
				Wrd(p6,0)=n6
				Doi=2
			Else
				Wrd(p6,1)=n6
				p6=p6+1
				Doi=0
			EndIf	
		EndIf
		If Doi<>2 Then	
			If (j=>97 And j<=122)Or (j>=48 And j<=57) Or (j>=65 And j<=90)Or j=46 Or j=95 Or j=38 Then
				If Doi=0 Then
					Doi=1
					Wrd(p6,0)=n6
				EndIf
			Else
				If Doi=1 Then
					Doi=0
					Wrd(p6,1)=n6-1
					p6=p6+1
				EndIf	
			EndIf
			If doi<>1 Then
				If j=36 Then
					Wrd(p6,0)=n6
					Doi=1
				EndIf
				If (j>36 And j<38) Or (j>38 And j<46) Or (j>=58 And j<=64) Or j=35 Or j=33 Then
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
				If (j>=91 And j<=94)Or (j>=123 And j<=125) Or j=47 Then		
					Wrd(p6,0)=n6
					Wrd(p6,1)=n6
					p6=p6+1
					Doi=0
				EndIf
			EndIf	
		EndIf
	Wend
	If Doi=1 Then
		Wrd(p6,1)=n6
		p6=p6+1
	EndIf
	If Doi=2 Then
		Goit$=Goit$+Chr$(34)
		Wrd(p6,1)=n6+1
		p6=p6+1
	EndIf
	Wrd(p6,0)=0
	Wrd(p6+1,0)=0	
	Return Goit$
End Function
Function GetDeclares(ew1$)
	Filein = ReadFile(ew1$)
	LoC=0
	
	IncNo=0
	While Not Eof(Filein) 
		Cd$(LoC+1)=ReadLine$(Filein)
		LoC=LoC+1
		Answer$=Seperate$(LoC)
		Cod=1
		r$=Upper$(SepSort$(Cod))
		
		Select r$
			Case "VAR" DeclareVar2(LoC)
		End Select
		If Err<>0 Then ErrLn=LoC:Return
	Wend
	
	CloseFile (Filein)
	;**** Get the Variable associated to the forms
	
	FileOut = WriteFile(ew1$)
	For k=1 To LoC
		WriteLine(FileOut,Cd$(k))
		
		If Cd$(k)=";**** Define User Graphics ****" Then
			ew$=SpaceIt$(".Sheet_Data4")
			WriteLine(FileOut,ew$)
			WriteLine(FileOut,".Sheet_Data4_WidthByte:     db 2")			
			WriteLine(FileOut,".Sheet_Data4_WidthPixel:    db 1")			
			WriteLine(FileOut,".Sheet_Data4_Height:        db 1")
			WriteLine(FileOut,".Sheet_Data4_DataAddr:      dw Sheet_Data4_Data")
			WriteLine(FileOut,".Sheet_Data4_EncodeAddr:    dw Sheet_Data4_Encode")			
			WriteLine(FileOut,".Sheet_Data4_Size:          dw 1")
			WriteLine(FileOut,".Sheet_Data4_Encode:        db 0")
			WriteLine(FileOut,".Sheet_Data4_Data:          dw 0")				
		EndIf
		
		If Cd$(k)=";**** Define User Variables ****" Then
			For f=1 To VarNo
				
				;**** Store a Normal 16 Bit Variable
				If VarType(f)=11 And VarName$(f)>"" Then
					ew$="."+VarName$(f)+":   dw "+VarInitial(f)
					WriteLine(FileOut,ew$)
				EndIf
				If VarType(f)=12 And VarName$(f)>"" Then
					ew$="."+VarName$(f)+":   dw "+VarInitial(f)
					WriteLine(FileOut,ew$)
				EndIf
				If VarType(f)=13 And VarName$(f)>"" Then
					ew$="."+VarName$(f)+":   db  "+By0+","+By1+","+By2+","+By3+","+Skag+"    ;+VarInitial(f),0"
					WriteLine(FileOut,ew$)
				EndIf
				If VarType(f)=14 And VarName$(f)>"" Then
					ew$="."+VarName$(f)+":   db "+VarInitial(f)
					WriteLine(FileOut,ew$)
				EndIf				
				If VarType(f)=15 And VarName$(f)>""Then
					ew$="."+VarName$(f)+":   dw "+VarName$(f)+"_Data+4"
					VarLink$(f)=VarName$(f)
					WriteLine(FileOut,ew$)
				EndIf
				;**** Store Array of String Pointers ****
				If (VarType(f)=35 Or VarType(f)=45)And VarName$(f)>""Then				
					If VarArray(f,0)=1 Then
						k1=0
						k3=VarArray(f,1)+1
						ew$="."+VarName$(f)+":   dw 0"
					EndIf
					If VarArray(f,0)=2 Then
						k1=VarArray(f,1)
						k3=(VarArray(f,1)+1)*(VarArray(f,2)+1)
						ew$="."+VarName$(f)+":   dw "+(k1+1)*2
					EndIf
					VarLink$(f)=VarName$(f)
					WriteLine(FileOut,ew$)
					k2=0
					Eq$=""
					StrPos=4
					For k1=1 To k3
						ew$="                 dw "+VarName$(f)+"_Data+"+Str$(StrPos)
						StrPos=StrPos+Len(VarText$(f))+5
						WriteLine(FileOut,ew$)
					Next
				EndIf
				;**** Store an single Word Array
				If VarType(f)=31 And VarName$(f)>""Then
					k1=0
					k3=VarArray(f,1)
					ew$="."+VarName$(f)+":   dw "+(k1+1)*2
					WriteLine FileOut,"."+VarName$(f)+":   dw "+Str$(k1*2)
					k2=0
					Eq$=""
					For k1=1 To k3
						eq$=eq$+"0,"
						k2=k2+1
						If k2=>20 Or k1=k3 Then
							ew$="       dw "+Mid$(eq$,1,Len(eq$)-1)
							WriteLine(FileOut,ew$)
							k2=0
							eq$=""
						EndIf
					Next
				EndIf
				;**** Store an Single Byte Array
				If VarType(f)=34 And VarName$(f)>""Then
					k1=0
					k3=VarArray(f,1)
					WriteLine FileOut,"."+VarName$(f)+":   dw "+Str(k3)
					WriteLine FileOut,"."+VarName$(f)+"_data:" 
					k2=0
					Eq$=""
					For k1=1 To k3
						eq$=eq$+"0,"
						k2=k2+1
						If k2=>20 Or k1=k3 Then
							ew$="       db "+Mid$(eq$,1,Len(eq$)-1)
							WriteLine(FileOut,ew$)
							k2=0
							eq$=""
						EndIf
					Next
				EndIf
				;**** Store an single Word Array
				If VarType(f)=41 And VarName$(f)>""Then
					k1=VarArray(f,1)
					k3=(VarArray(f,1))*(VarArray(f,2))
					WriteLine FileOut,"."+VarName$(f)
					ArrayCode(fileout,f,41)
					WriteLine fileout,"."+VarName$(f)+"_data:" 
					k2=0
					Eq$=""
					For k1=1 To k3
						eq$=eq$+"0,"
						k2=k2+1
						If k2=>20 Or k1=k3 Then
							ew$="       dw "+Mid$(eq$,1,Len(eq$)-1)
							WriteLine(FileOut,ew$)
							k2=0
							eq$=""
						EndIf
					Next
				EndIf				
				;**** Store an Double Byte Array 
				If VarType(f)=44 And VarName$(f)>""Then
					k1=VarArray(f,1)
					k3=(VarArray(f,1))*(VarArray(f,2))
					WriteLine FileOut,"."+VarName$(f)
					ArrayCode(fileout,f,44)
					WriteLine fileout,"."+VarName$(f)+"_data:" 
					k2=0
					Eq$=""
					For k1=1 To k3
						eq$=eq$+"0,"
						k2=k2+1
						If k2=>20 Or k1=k3 Then
							ew$="       db "+Mid$(eq$,1,Len(eq$)-1)
							WriteLine(FileOut,ew$)
							k2=0
							eq$=""
						EndIf
					Next
				EndIf			
				;**** Store an Array of Float Variables
				If (VarType(f)=33 Or VarType(f)=43)And VarName$(f)>""Then
					If VarArray(f,0)=1 Then
						k1=0
						k3=VarArray(f,1)+1
					EndIf
					If VarArray(f,0)=2 Then
						k1=VarArray(f,1)
						k3=(VarArray(f,1)+1)*(VarArray(f,2)+1)
					EndIf
					;If Len(VarName$(f))<3 Then RuntimeError(VarName$(f)+" "+VarNo)
					ew$="."+VarName$(f)+":   dw "+(k1+1)*5
					WriteLine(FileOut,ew$)
					k2=0
					Eq$=""
					For k1=1 To k3
						;eq$=eq$+"#2a,#e7,#84,#11,#ac,"
						eq$=eq$+"0,0,0,0,0,"
						k2=k2+1
						If k2=>6 Or k1=k3 Then
							ew$="       db "+Mid$(eq$,1,Len(eq$)-1)
							WriteLine(FileOut,ew$)
							k2=0
							eq$=""
						EndIf
					Next
				EndIf
			Next
			ew$=";Spongebob":WriteLine(FileOut,ew$)
			;**** Some Constants
			VarNo=VarNo+1:VarName$(VarNo)="False":VarType(VarNo)=14								;Byte	
			VarNo=VarNo+1:VarName$(VarNo)="True":VarType(VarNo)=14								;Byte	
			VarNo=VarNo+1:VarName$(VarNo)="PI":VarType(VarNo)=13								;Float
			VarNo=VarNo+1:VarName$(VarNo)="ErrorNum":VarType(VarNo)=11							;Word	
			VarNo=VarNo+1:VarName$(VarNo)="ErrorPC":VarType(VarNo)=11							;Word
			VarNo=VarNo+1:VarName$(VarNo)="Quig_InitDir":VarType(VarNo)=15							;String	
			VarText$(VarNo)=""
			VarLink$(VarNo)=VarName$(VarNo)	
			VarNo=VarNo+1:VarName$(VarNo)="Quig_InitCommand":VarType(VarNo)=15						;String		
			VarText$(VarNo)=""
			VarLink$(VarNo)=VarName$(VarNo)
			
			VarNo=VarNo+1:VarName$(VarNo)="Quig_Dialog_1":VarType(VarNo)=15						;String		
			VarText$(VarNo)=""
			VarLink$(VarNo)=VarName$(VarNo)		
			VarNo=VarNo+1:VarName$(VarNo)="Quig_Dialog_2":VarType(VarNo)=15						;String		
			VarText$(VarNo)=""
			VarLink$(VarNo)=VarName$(VarNo)		
			VarNo=VarNo+1:VarName$(VarNo)="Quig_Dialog_3":VarType(VarNo)=15						;String		
			VarText$(VarNo)=""
			VarLink$(VarNo)=VarName$(VarNo)					
			
			
			For k1=0 To NoOfFrms
				AddFormVar(k1)
			Next
			n=0
			ew$=".SyB_StringTopAddr:      dw SyB_StringTop+4"
			WriteLine(FileOut,ew$)
			
			
			
			ew$=";**** String Data ****
			WriteLine(Fileout,ew$)
			For f=1 To VarNo
				If VarType(f)=15 And VarAvoid(f)=0 Then
					ew$=SpaceIt$("."+VarName$(f)+"_Data")+"dw "+VarLink$(f)+":dw "+Len(VarText$(f)+1)
					If Len(VarText$(f))>0 Then
						ew$=ew$+":db "+Chr$(34)+VarText$(f)+Chr$(34)+",0"
					Else
						ew$=ew$+":db 0"
					EndIf
					WriteLine(FileOut,ew$)
					n=n+Len(VarText$(f))+4
				EndIf
				If (VarType(f)=35 Or VarType(f)=45)And VarAvoid(f)=0 Then
					ew$=SpaceIt$("."+VarName$(f)+"_Data")
					WriteLine(FileOut,ew$)
					If VarArray(f,0)=1 Then
						k1=0
						k3=VarArray(f,1)+1
					EndIf
					If VarArray(f,0)=2 Then
						k1=VarArray(f,1)
						k3=(VarArray(f,1)+1)*(VarArray(f,2)+1)
					EndIf					
					StrPos=2
					For k1=1 To k3
						ew$=SpaceIt$("")
						ew$=Mid$(ew$,2)+" "
						ew$=ew$+"dw "+VarLink$(f)+"+"+Str$(StrPos)+":dw "+Len(VarText$(f)+1)
						If Len(VarText$(f))>0 Then
							ew$=ew$+":db "+Chr$(34)+VarText$(f)+Chr$(34)+",0"
						Else
							ew$=ew$+":db 0 "
						EndIf
						WriteLine(FileOut,ew$)
						StrPos=StrPos+2
						n=n+Len(VarText$(f))+4
					Next
				EndIf
			Next
			
			ew$=".SyB_StringTop:"
			WriteLine fileout,".Quig_String_End_Text:      dw 0"
			WriteLine(FileOut,ew$)			
			
		EndIf
		
	Next
	
	CloseFile(FileOut)
	
End Function

Function ArrayCode(fileout,f,a)
	If a=44 Then 
		as1=VarArray(f,2)
		If as1=1 Or as1=2 Or as1=4 Or as1=8 Or as1=16 Or as1=32 Or as1=64 Or as1=128 Then
			WriteLine fileout,"       ex     de,hl"
			If as1>1 Then WriteLine fileout,"       add    hl,hl   ;*2"
			If as1>2 Then WriteLine fileout,"       add    hl,hl   ;*4"
			If as1>4 Then WriteLine fileout,"       add    hl,hl   ;*8"
			If as1>8 Then WriteLine fileout,"       add    hl,hl   ;*16"		
			If as1>16 Then WriteLine fileout,"       add    hl,hl   ;*32"
			If as1>32 Then WriteLine fileout,"       add    hl,hl   ;*64"		
			If as1>64 Then WriteLine fileout,"       add    hl,hl   ;*128"
			WriteLine fileout,"       ld     bc,"+VarName$(f)+"_data"
			WriteLine fileout,"       add    hl,bc"
			WriteLine fileout,"       add    hl,de"
			WriteLine fileout,"       ret"
		Else
			
		EndIf
	EndIf
	If a=41 Then 
		as1=VarArray(f,2)*2
		If as1=2 Or as1=4 Or as1=8 Or as1=16 Or as1=32 Or as1=64 Or as1=128 Then
			WriteLine fileout,"       ex     de,hl"
			If as1>1 Then WriteLine fileout,"       add    hl,hl   ;*2"
			If as1>2 Then WriteLine fileout,"       add    hl,hl   ;*4"
			If as1>4 Then WriteLine fileout,"       add    hl,hl   ;*8"
			If as1>8 Then WriteLine fileout,"       add    hl,hl   ;*16"		
			If as1>16 Then WriteLine fileout,"       add    hl,hl   ;*32"
			If as1>32 Then WriteLine fileout,"       add    hl,hl   ;*64"		
			If as1>64 Then WriteLine fileout,"       add    hl,hl   ;*128"
			WriteLine fileout,"       ld     bc,"+VarName$(f)+"_data"
			WriteLine fileout,"       add    hl,bc"
			WriteLine fileout,"       add    hl,de"
			WriteLine fileout,"       add    hl,de"			
			WriteLine fileout,"       ret"
		Else
			
		EndIf
	EndIf	
	
End Function

Function DeclareVar2(Loc)
	ArraySize=0
	ArrayCount1=0
	ArrayCount2=0
	VType=0
	VarNo=VarNo+1
	VarArray(VarNo,0)=0:VarArray(VarNo,1)=0:VarArray(VarNo,2)=0:VarInitial(VarNo)=0:VarName$(VarNo)="":VarFunc(VarNo)=0
	Cod=Cod+1
	r$=SepSort$(Cod)
	
	Cod=Cod+1
	r1$=SepSort$(Cod)
	If r1$="(" Or r1$="["Then
		Succeed=False
		Cod=Cod+1
		r1$=SepSort$(Cod)							
		Res=IsNumber#(r1$)
		If Succeed And Res>0 Then
			ArraySize=1
			ArrayCount1=Int(Res)
			;VarArray(VarNo,0)=1
			;VarArray(VarNo,1)=Int(Res)
		Else
			Err=120
			ErrMessage$="Error in Declaring Array '"+r$+"'"
			Return
		EndIf
		Cod=Cod+1
		r1$=SepSort$(Cod)
		If r1$="," Then			;**** Double array
			Succeed=False
			Cod=Cod+1
			r1$=SepSort$(Cod)
			
			Res=IsNumber#(r1$)				
			If Succeed And Res>0 Then
				ArraySize=2
				ArrayCount2=Int(Res)
			Else
				Err=120
				ErrMessage$="Declarion error "+VarName$(VarNo)			
				Return
			EndIf
			Cod=Cod+1
			r1$=SepSort$(Cod)
		EndIf
		If r1$<>")" And r$<>"]" Then
			Err=120
			ErrMessage$="Error in Declaring Array '"+r$+"' ] expected."
			Return
		EndIf
		Cod=Cod+1
		r1$=SepSort$(Cod)
	EndIf	
	If r1$=":"Then 
		Cod=Cod+1
		Select Upper$(SepSort$(Cod))
			Case "INT" VType=Ex_Var16
			Case "BYTE" VType=Ex_Var8
			Case "STRING" VType=Ex_StrVar
			Case "FLOAT" VType=Ex_FloVar
			Case "FILE" VType=Ex_File
			Case "SHEET" VType=Ex_Sheet
			Case "MEMORY" VType=Ex_Memory					
		End Select
		Cod=Cod+1
		r1$=Upper$(SepSort$(Cod))
	EndIf
	
	
	If r1$="=" Then
		Succeed=False
		Cod=Cod+1
		r1$=SepSort$(Cod)
		
		If r1$="["Then 
			SqBrack=1
			Cod=Cod+1
			r1$=SepSort$(Cod)
		EndIf	
			
		;**** Check Its String
		If Mid$(r1$,1,1)=Chr$(34)Then
			Succeed=True
			If VType>0 And VType<>15 Then 
				Err=120
				ErrMessage$=VarName$(VarNo)+" data type is not String"			
				Return
			EndIf
			my$=r1$
			VType=Ex_StrVar
			Cod=Cod+1
			r1$=SepSort$(Cod)
		EndIf
		;**** Check if its a Number
		If Succeed=False Then
			Res=IsNumber#(r1$)
			If Succeed=True Then
				If ResultInt=0 Then
					If VType>0 And (VType<>11 And VType<>14) Then 
						Err=120
						ErrMessage$=VarName$(VarNo)+" data type is not Float"			
						Return
					EndIf
					If VType=14 And (Res<0 Or Res>255) Then 
						Err=120
						ErrMessage$=VarName$(VarNo)+" data type cannot be outside range 0 - 255"			
						Return
					EndIf
					If VType<>14 Then VType=11
					MyNum=Int(Res)
				Else
					If VType>0 And VType<>13 Then 
						Err=120
						ErrMessage$=VarName$(VarNo)+" data type is not Integer"			
						Return
					EndIf
					VType=13
					MyNum=Float(Res)
				EndIf
			EndIf
		EndIf	
		If Succeed=False Then 
			Err=120
			ErrMessage$=VarName$(VarNo)+" was expecting data definition"			
			Return
		EndIf
		Cod=Cod+1
		r1$=Upper$(SepSort$(Cod))		
	EndIf	
	
	
	If ArraySize=1 Then
		VarArray(VarNo,0)=1
		VarArray(VarNo,1)=ArrayCount1:VarArray(VarNo,2)=0
		If VType=Ex_Var16 Then VType=Ex_Arr1Int
		If VType=Ex_Var32 Then VType=Ex_Arr1Int32
		If VType=Ex_Var8 Then VType=Ex_Arr1Byt
		If VType=Ex_FloVar Then VType=Ex_Arr1Flo
		If VType=Ex_StrVar Then VType=Ex_Arr1Str
	EndIf
	If ArraySize=2 Then
		VarArray(VarNo,0)=2
		VarArray(VarNo,1)=ArrayCount1:VarArray(VarNo,2)=ArrayCount2
		If VType=Ex_Var16 Then VType=Ex_Arr2Int
		If VType=Ex_Var32 Then VType=Ex_Arr2Int32
		If VType=Ex_Var8 Then VType=Ex_Arr2Byt
		If VType=Ex_FloVar Then VType=Ex_Arr2Flo
		If VType=Ex_StrVar Then VType=Ex_Arr2Str
	EndIf
	
	Select VType
		Case Ex_Var16 VarAddvar(r$,"var_wrd_",my$,mynum,Ex_Var16)
		Case Ex_Var8 VarAddvar(r$,"var_byt_",my$,mynum,Ex_Var8)	
		Case Ex_FloVar VarAddvar(r$,"var_flo_",my$,mynum,Ex_FloVar)
		Case Ex_StrVar VarAddvar(r$,"var_str_",my$,mynum,Ex_StrVar)	
			
		Case Ex_Arr1Int VarAddvar(r$,"ar1_wrd_",my$,mynum,Ex_Arr1Int)	
		Case Ex_Arr1Byt VarAddvar(r$,"ar1_byt_",my$,mynum,Ex_Arr1Byt)				
		Case Ex_Arr1Flo VarAddvar(r$,"ar1_flo_",my$,mynum,Ex_Arr1Flo)				
		Case Ex_Arr1Str VarAddvar(r$,"ar1_str_",my$,mynum,Ex_Arr1Str)	
			
		Case Ex_Arr2Int VarAddvar(r$,"ar2_wrd_",my$,mynum,Ex_Arr2Int)	
		Case Ex_Arr2Byt VarAddvar(r$,"ar2_byt_",my$,mynum,Ex_Arr2Byt)				
		Case Ex_Arr2Flo VarAddvar(r$,"ar2_flo_",my$,mynum,Ex_Arr2Flo)				
		Case Ex_Arr2Str VarAddvar(r$,"ar2_str_",my$,mynum,Ex_Arr2Str)
			
		Case Ex_File AddVarTfile(r$,"a",0)
		Case Ex_Sheet AddVarSFile(r$,"a",0)
		Case Ex_Memory AddVarMemory(r$,"a",0)	
	End Select
	
End Function

Function AddVarMemory(r$,my$="",mynum=0)
	If my$>"" Then 
		VarAddvar r$+"_status","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_size","var_wrd_",my$,mynum,Ex_Var16:VarNo=VarNo+1
		VarAddvar r$+"_bank","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_addr","var_wrd_",my$,mynum,Ex_Var16:VarNo=VarNo+1
	EndIf
	AddFuncDat r$+"%","@var_byt_"+r$+"_status%","","","Returns memory container "+r$+" ID"	
	AddFuncDat r$+".Create","@var_byt_"+r$+"_status%,Bytes%","QUIG.MEMORY.CREATE","Quig_memory_Create","Create a memory allocation in "+r$+" of a number of bytes"
	AddFuncDat r$+".Free","@var_byt_"+r$+"_status%","QUIG.MEMORY.FREE","Quig_Memory_Free","Clears a memory allocation in "+r$+" so data is no longer taken"
	AddFuncDat r$+".Status%","@var_byt_"+r$+"_status%","QUIG.GET.BYTE","Quig_Get_Byte",""	
	AddFuncDat r$+".Size%","(var_wrd_"+r$+"_size%","","",""
	AddFuncDat r$+".Byte.Get%","@var_byt_"+r$+"_bank%,Position%","QUIG.MEMORY.BYTE.GET","Quig_Memory_Byte_Get","Reads a byte from a given position in memory allocation "+r$
	AddFuncDat r$+".Int.Get%","@var_byt_"+r$+"_bank%,Position%","QUIG.MEMORY.INT.GET","Quig_Memory_Int_Get","Reads an Int from a given position within memory allocation "+r$
	AddFuncDat r$+".String.Get%","@var_byt_"+r$+"_size%,Position%","","",""
	AddFuncDat r$+".Byte.Set","@var_byt_"+r$+"_bank%,Position%,Byte%","QUIG.MEMORY.BYTE.SET","Quig_Memory_Byte_Set","Write a byte to memory allocation "+r$
	AddFuncDat r$+".Int.Set","@var_byt_"+r$+"_bank%,Position%,Data%","QUIG.MEMORY.INT.SET","Quig_Memory_Int_Set","Write an int to memory allocation "+r$+" at position."
	AddFuncDat r$+".String.Set","@var_byt_"+r$+"_bank%,Position%,String$","QUIG.MEMORY.STRING.SET","Quig_Memory_String_Set",""
	
End Function	
Function AddVarTfile(r$,my$="",mynum=0)
	If my$>"" Then 
		VarAddvar r$+"_handle","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_status","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_eof","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
	EndIf
	AddFuncDat r$+"%","(var_byt_"+r$+"_handle%","","","Returns file container "+r$+" ID"	
	AddFuncDat r$+".Open","@var_byt_"+r$+"_handle%,file$","QUIG.FILE.OPEN","Quig_File_Open","Opens an existing file in file container "+r$+". Status 0-Fail/1-Success"
	AddFuncDat r$+".New","@var_byt_"+r$+"_handle%,file$","QUIG.FILE.OPEN","Quig_File_New","Create new file in file container "+r$+". Status 0-Fail/1-Success"	
	AddFuncDat r$+".Close","@var_byt_"+r$+"_handle%","QUIG.FILE.CLOSE","Quig_File_Close",""
	AddFuncDat r$+".WriteString","@var_byt_"+r$+"_handle%,file$","QUIG.FILE.WRITESTRING","Quig_File_WriteString",""
	AddFuncDat r$+".WriteInt","@var_byt_"+r$+"_handle%,int%","QUIG.FILE.WRITEINT","Quig_File_WriteInt",""
	AddFuncDat r$+".WriteByte","@var_byt_"+r$+"_handle%,int%","QUIG.FILE.WRITEINT","Quig_File_WriteByte",""	
	AddFuncDat r$+".Status%","@var_byt_"+r$+"_status%","QUIG.GET.BYTE","Quig_Get_Byte",""
	AddFuncDat r$+".ReadString$","@var_byt_"+r$+"_handle%","QUIG.FILE.READSTRING","Quig_File_ReadString",""
	AddFuncDat r$+".ReadInt%","@var_byt_"+r$+"_handle%","QUIG.FILE.READINT","Quig_File_ReadInt",""
	AddFuncDat r$+".ReadByte%","@var_byt_"+r$+"_handle%","QUIG.FILE.READINT","Quig_File_ReadByte",""	
	AddFuncDat r$+".EOF%","@var_byt_"+r$+"_eof%","QUIG.GET.BYTE","Quig_Get_Byte",""		
End Function
Function AddVarSFile(r$,my$="",mynum=0)
	If my$>"" Then 
		VarAddvar r$+"_status","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_sheet","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_tiles","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_size","var_wrd_",my$,mynum,Ex_Var16:VarNo=VarNo+1
		VarAddvar r$+"_bank","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1
		VarAddvar r$+"_addr","var_wrd_",my$,mynum,Ex_Var16:VarNo=VarNo+1
		VarAddvar r$+"_colourdepth","var_byt_",my$,mynum,Ex_Var8:VarNo=VarNo+1		
	EndIf
	AddFuncDat r$+"%","@var_byt_"+r$+"_status%","","","Returns sheet container "+r$+" ID"		
	AddFuncDat r$+".Load","@var_byt_"+r$+"_status%,SheetFile$","QUIG.SHEETLOAD","Quig_SheetLoad","Loads a Sheet file into "+r$
	AddFuncDat r$+".Free","@var_byt_"+r$+"_status%"," QUIG.SHEETFREE","Quig_SheetFree","Free the memory used by sheet "+r$+" once finished with"
	AddFuncDat r$+".Tiles%","@var_byt_"+r$+"_tiles%","QUIG.GET.BYTE","Quig_Get_Byte","Return number of tiles in "+r$+" sheet container."
	AddFuncDat r$+".Size%","(var_wrd_"+r$+"_size%","","","Return memory size used by "+r$+" sheet container."	
	AddFuncDat r$+".Status%","@var_byt_"+r$+"_status%","QUIG.GET.BYTE","Quig_Get_Byte","Return status of "+r$+" sheet container (0) Empty / (1) In use / >(99) loading Error."
	AddFuncDat r$+".Colour.Depth%","@var_byt_"+r$+"_colourdepth%","QUIG.GET.BYTE","Quig_Get_Byte","Return colour depth of "+r$+" sheet. (0)-4 colour (1)-16 colour."	
End Function
Function VarAddvar(r$,c$,my$,mynum,hol)
	VarName2$(VarNo)=r$
	VarNameU$(VarNo)=Upper$(r$)	
	VarName$(VarNo)=c$+Replace(r$,".","_")
	VarType(VarNo)=hol
	VarUse(VarNo)=3									;This is Const 1:Function, 2=Statement, 3=Variable, 5=Directive
	VarCont(VarNo)=0
	VarText$(VarNo)=Replace(my$,Chr$(34),"")
	VarInitial(VarNo)=mynum
	VarLink$(VarNo)=""
End Function	

Function AddVars()
	VarNo=VarNo+1:VarName$(VarNo)="InitDir":VarType(VarNo)=15							;String	
	VarNo=VarNo+1:VarName$(VarNo)="InitCommand":VarType(VarNo)=15						;String	
End Function

Function GetFunctions(ew1$)
	LoC=0
	FuncNo=0
	;**** Read in the entire Source
	Filein = ReadFile(ew1$)
	While Not Eof(Filein) 
		Cd$(LoC+1)=ReadLine$( Filein )
		LoC=LoC+1
		If Cd$(LoC+1)=";**** Core End"Then 
			CoreEnd=LoC
			LibEnd=0
		End If
;		
		;Check if Function declared
		If Upper$(Trim$(Mid$(Cd$(LoC),1,8)))="FUNCTION" Or Upper$(Trim$(Mid$(Cd$(LoC),1,5)))="FUNC" Then
			Answer$=Seperate$(LoC)
			Cod=1
			r$=Upper$(SepSort$(Cod))
			If r$="FUNCTION" Or r$="FUNC"Then
				DeclareFunction(LoC)
			EndIf			
		EndIf
	Wend 
	CloseFile (Filein)
	
End Function
Function AddFormVar(frm)
	VarNo=VarNo+1:VarName$(VarNo)="Event_Message":VarType(VarNo)=14:VarName2$(VarNo)="Event.Message"							;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_Form_ID":VarType(VarNo)=14:VarName2$(VarNo)="Event.Form"									;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_Type":VarType(VarNo)=14:VarName2$(VarNo)="Event.Type"									;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_UserInput":VarType(VarNo)=14:VarName2$(VarNo)=Nm$+"Event.Input"							;Byte
	VarNo=VarNo+1:VarName$(VarNo)="Event_Key_Ascii":VarType(VarNo)=14:VarName2$(VarNo)=Nm$+"Event.Ascii"							;Byte	
	VarNo=VarNo+1:VarName$(VarNo)="Event_MouseX":VarType(VarNo)=11:VarName2$(VarNo)=Nm$+"Event.Mouse.X"							;Word	
	VarNo=VarNo+1:VarName$(VarNo)="Event_MouseY":VarType(VarNo)=11:VarName2$(VarNo)=Nm$+"Event.Mouse.Y"							;Word	
	VarNo=VarNo+1:VarName$(VarNo)="Event_Control_ID":VarType(VarNo)=11:VarName2$(VarNo)=Nm$+"Event.Control.ID"						;Word		
	
	;**** First Do Form Information
	Nm$=ObSData(frm,1,QNam)
	VarNo=VarNo+1:VarName$(VarNo)=Nm$:VarType(VarNo)=12									;Long
;	AddControlVars(Nm$,"OffsetWidth",Ut_Word)
;	AddControlVars(Nm$,"OffsetHeight",Ut_Word)
;	AddControlVars(Nm$,"ContentWidth",Ut_Word)
;	AddControlVars(Nm$,"ContentHeight",Ut_Word)
;	AddControlVars(Nm$,"MinWidth",Ut_Word)
;	AddControlVars(Nm$,"MinHeight",Ut_Word)
;	AddControlVars(Nm$,"MaxWidth",Ut_Word)
;	AddControlVars(Nm$,"MaxHeight",Ut_Word)
	
;	AddControlDirective(Nm$,"Scroll.Refresh",4001,frm,1)
;	AddControlDirective(Nm$,"Status.Refresh",4002,frm,1)
;	AddControlDirective(Nm$,"Title.Refresh",4003,frm,1)
;	AddControlDirective(Nm$,"Maximize",4004,frm,1)	
;	AddControlDirective(Nm$,"Minimize",4005,frm,1)	
;	AddControlDirective(Nm$,"Restore",4006,frm,1)
	
	
;	AddControlDirective(Nm$,"RefreshArea",4010,frm,1)	
	
	
	
;	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_IconAddr":VarType(VarNo)=11						;Word
;	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_MenuAddr":VarType(VarNo)=11						;Word
;	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ControlWindowAddr":VarType(VarNo)=11			;Word
;	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ControlToolAddr":VarType(VarNo)=11				;Word
;	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_ToolBarHeight":VarType(VarNo)=11				;Word
;	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_MaxHeight":VarType(VarNo)=11					;Word
;	
	AddControlVars(Nm$,"Text",15)
	VarText$(VarNo)=ObSData$(frm,1,QCap):VarLink$(VarNo)=Nm$+"_Text"	
	AddControlVars(Nm$,"Status_Text",15)
	VarText$(VarNo)=ObSData$(frm,1,QStT):VarLink$(VarNo)=Nm$+"_Status_Text"	
	
	For f=1 To 512
		AddFormControl(frm,f)
	Next
	;**** Add Menu Stuff
	If NoOfMn(frm)>1 Then
		VarNo=VarNo+1:VarName$(VarNo)=ObSData(frm,1,QNam)+"_Menu_Entries":VarType(VarNo)=11		;Word
		;RuntimeError(VarName$(VarNo))
		For f=2 To NoOfMn(frm)
			If Mid$(Mn$(frm,f,1),1,1)<>"-"Then
				Nm$=Mn$(frm,f,2)
				If MnT(frm,f)=0 Then
					VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Entries"VarType(VarNo)=11		;Word
				EndIf
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Appearance":VarType(VarNo)=11		;Word	
				VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_Text":VarType(VarNo)=15				;String			
				VarText$(VarNo)=Mn$(frm,f,1)
				VarLink$(VarNo)=Nm$+"_Text"
			EndIf
		Next
	EndIf	
End Function

;***************************



Function AddControlVars(Nm$,What$,VarTypeNo)
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_"+What$:VarType(VarNo)=VarTypeNo
	What$=Replace(What$,"_",".")
	VarName2$(VarNo)=Nm$+"."+What$
End Function
Function AddControlDirective(Nm$,What$,VarTypeNo,frm,f)
	VarNo=VarNo+1:VarName$(VarNo)=Nm$+"_"+What$:VarType(VarNo)=VarTypeNo:VarCont(VarNo)=(frm*256)+f
	VarName2$(VarNo)=Nm$+"."+What$
End Function
Function SpaceIt$(e$)
	If Len(e$)>=32 Then e$=e$+":":Return e$
	If Len(e$)<32 Then e$=Mid$(e$+":                                       ",1,32):Return e$
	
End Function
Function ConvertString$(Thing$)
	hj=0
	For f=1 To Len(Thing$)
		If Mid$(Thing$,f,1)="."Then hj=f
	Next

	;minus=1

	Flt$=""
	Intg$=""
	Skag=128
	;**** Okay there is a decimal point
	If hj>0 Then
		w2#=128
		w1#=Mid$(Thing$,hj)
		w1#=w1#*256
		
		If Minus=1 Then
			w1#=1-w1#
		EndIf
		While w1#>0
			If w1#=>w2# Then
				w1#=w1#-w2#
				Flt$=Flt$+"1"
			Else	
				Flt$=Flt$+"0"
			EndIf
			w2#=w2#/2
		Wend
	EndIf

	If hj>1 Then
		w3=Mid$(Thing$,1,hj)
		Intg$=Bin(w3)
		For f=1 To Len(Intg$)
			nerd$=Mid$(Intg$,f,1)
			If nerd$="1"Then Intg$=Mid$(Intg$,f):Exit
		Next
	EndIf
	If Intg$=""Then	
		For f=1 To Len(Flt$)
			Skag=Skag-1
			nerd$=Mid$(Flt$,f,1)
			If nerd$="1"Then Flt$=Mid$(Flt$,f):Exit	
		Next
	Else
		Skag=Skag+Len(Intg$)
	EndIf

	Over$=Mid$(Mid$(Intg$+Flt$,2)+"00000000000000000000000000000000",1,31)
	By3=Bin2Dec("0"+Mid$(over$,1,7))
	By0=Bin2Dec(Mid$(Over$,8,8))
	By1=Bin2Dec(Mid$(Over$,16,8))
	By2=Bin2Dec(Mid$(Over$,24,8))
	;Print Skag
	;Print Over$
	;Print By3
	;Print By0
	;Print By1
	;Print by2
End Function
Function Bin2Dec(hy$)
	e=1
	g=0
	For f=Len(hy$) To 1 Step -1
		If Mid$(hy$,f,1)="1" Then g=g+e
		e=e*2
	Next
	Return g
End Function

;~IDEal Editor Parameters:
;~F#127#2B1#2C8#2D5#2DA#2DF#2E3#31C#369#38A#3AA#3B6#43A#4B1#4D6#4E6#511#537#543#54B
;~F#555#55F#565#56B#572#5C6#5EF#622#656#683#6A6#6D2#6F5#721#752#783#7AF#7D3#7F7#81A
;~F#83E#862#886#8AA#8D7#90F#92D#94B#AC6#B1D#B3B#B55#B73#B93#C22#C35#C3B#C41#C47#C4D
;~F#C55#C5D#C63#C69#C71#C79#C81#C89#C91#C99#CA1#CA9#CB1#CB9#CC1#CC9#CD1#CD9#CE1#CE9
;~F#CEF#CF5#CFB#D01#D07#D0F#D15#D1B#1029#105D#107D#109C#10A6#10C9#10CF#1125#1138#1145#1152#1156
;~F#1482#1487#14C4
;~B#129E#140B
;~C#Blitz3D