
;***************
;**** Code *****
;***************
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3

.V_App_In_Use			db 	0

.AppPrz:
;**** Open Primary Window ****

		ld		hl,AppTrnEnd+260
		ld		a,h
		ld		(Quig_String_AS_HByte),a		;Set Byte so we can check if string is in String area or String buffer

		ld		a,AppStartForm					;**** Form to Open first
		ld		l,a
		call	Quig_Form_Open					;**** Form Opener
	#IF USETIMER	
		;**** Sets up the Timer Stack ****
		ld		hl,Quig_TimerStack
		ld		a,(AppBnkNum)
		ld		e,7
		call	SyKernel_MTADDT
  		jp      c,SyB_Studio_End
       	ld      (PrgPstSpz+AppCodBeg),a
	#ENDIF
;****************************************
;**** Main Application Control Loop *****
;****************************************
.Quig_Control_Loop:
		ld		a,(V_App_In_Use)
		And		a
		jr		nz,Quig_Control_Loop_1
		rst		#30								;Wait for message
		ld		a,(AppPrzN)		
       	db		#dd:ld l,a
		db		#dd:ld h,-1
 		ld		iy,AppMsgB
		rst		#18
		db		#dd:dec l						;AppMsgB should be populated
		jr		nz,Quig_Control_Loop_2			;No Message so just run Main()code.	
#IF USENET
		ld		a,(Quig_Net_Process)			;Get Process number (Default 255 until set)
		cp		255							
		jr		z,Quig_Control_Loop_99			;=255 Net not initialized so skip
		db 		#dd:cp h
		jp		z,Quig_Net_Event				;IXH = Process number so must be Net Event
.Quig_Control_Loop_99:		
#ENDIF
		ld		a,(AppMsgB+0)					
		or		a
		jp		z,Quig_End
		scf
		cp		MSR_DSK_WCLICK					;**** Click on a Control
		jp		z,Quig_Control_Event
		cp		MSR_DSK_WRESIZ					;**** Resize window ?
		jp		z,Quig_Form_Event_Resize
		cp		MSR_DSK_WSCROL					;**** Scrolled Form ?
		jp		z,Quig_Form_Event_Scroll		
		cp		MSR_DSK_CFOCUS					;**** Focus change ?
		jp		z,Quig_Form_Event_Focus		
.Quig_Control_Loop_2:
		call	qfunc_main
.Quig_Control_Loop_1:
		Xor		a
		ld		(V_App_In_Use),a
		jp		Quig_Control_Loop
		
#IF USENET		
;**** NET EVENTS		
.Quig_Net_Event:
;		INCLIB   QUIG.NET.TCP.FIND.FREE.HANDLE
;		INCLIB   QUIG.NET.TCP.SOCKET.COUNT
        call 	snwmsgo_afbcdehlixiy
		ld		(Quig_Event_Net_Handle),a
		ld		a,l
		ld		(Quig_Event_Net),a
		
		ld		(Quig_Net_Received_Value),bc
		
		ld		a,(Quig_Event_Net)
		cp		2					;tcpestablished
		jp		z,Quig_Found_TCP_Establish
		cp		128
		jp		z,Quig_Found_Data_Received
		cp		3
		jp		z,Quig_Found_Data_Received		
		cp		4
		jp		z,Quig_Found_Data_Received
		
		jp		Quig_Control_Loop_2

.Quig_Found_Data_Received:
		jp		Quig_Net_Event6
		
.Quig_Found_TCP_Establish:
		ld		(Quig_Event_Net_Port),de
		ld		(Quig_Event_Net_IXIY),ix
		ld		(Quig_Event_Net_IXIY+2),iy
.Quig_Net_Event6:		
		call 	QFunc_Net_Event	
.Quig_Net_Event7:
		jp		Quig_Control_Loop_2
		
.Quig_Net_Error:			dw	0
.Quig_Net_Handle:			db	255
.Quig_Net_Process:			db	255

.Quig_Net_TCP_Server:		db	0
.Quig_Net_TCP_Server_Port:	dw	0
.Quig_Net_TCP_Socket:		db 	0
.Quig_Net_TCP_Socket_Max:	db 	0

.Quig_Net_Received_Value:	dw	0
.Quig_Net_Transfered_Value:	dw 	0
.Quig_Net_Send_Wait_Value:	dw 	0

.Quig_Event_Net:			db	0
.Quig_Event_Net_Handle:		db	255
.Quig_Event_Net_Port:		dw	0
.Quig_Event_Net_IXIY:		dw	0,0

#ENDIF
		
;**** Redirect a Clicked on Control Event		
.Quig_Control_Event:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		a,(Event_Type)	 		
 		cp		DSK_ACT_CONTENT
 		jp		z,Quig_Content
 		cp		DSK_ACT_TOOLBAR
 		jp		z,Quig_Tool		
		cp		DSK_ACT_CLOSE
		jp		z,Quig_End
		cp		DSK_ACT_MENU
 		jp		z,Quig_Menu
		cp		DSK_ACT_KEY
		jp		z,Quig_Key		
		jp		Quig_Control_Loop_1
		
;**** Form Event ****
.Quig_Form_Event_Focus
		ld		a,5
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Scroll
		ld		a,4
		jr		Quig_Form_Event_X	
.Quig_Form_Event_Resize
		ld		a,3
.Quig_Form_Event_X:		
		ld		(Quig_Form_Event_X_1+1),a
		call	Quig_FormSearch
		ld		a,e
.Quig_Form_Event_X_1
		ld		c,0								;**** C = 3/4 etc
		call	SyB_Call_Form_Event
		jp		Quig_Control_Loop_1
		
;*********************
;**** Key Control ****
;*********************
.Quig_Key:
		ld		a,(AppMsgB+4)
		and		%10000000
		jp		z,Quig_Content
		jp		Quig_Control_Loop_1

;**********************
;**** Menu Control ****
;**********************
.Quig_Menu:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		hl,(AppMsgB+8)
		Xor		a
		cp		h
		jr		nz,Quig_Call_Set12
		cp		l
		jp		z,Quig_Control_Loop_1
.Quig_Call_Set12
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld		(Quig_Call_Set2+1),hl
.Quig_Call_Set2:
		call	0
		pop		iy
		pop		ix		
		jp		Quig_Control_Loop_1

		
;****************************************
;**** User has clicked on one Tool Control ****
;****************************************		
.Quig_Tool:
		ld		hl,ControWindowDataList+2
		Jr		Quig_Content2
;**** User has clicked on one Control ****
.Quig_Content:
		ld		hl,ControWindowDataList
.Quig_Content2:
		push	hl
		call	Quig_FormSearch
		ld		l,e
		ld		h,0
		add		hl,hl
		add		hl,hl	
		pop		de
		add		hl,de
	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(Event_Control_ID)
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		inc		hl
		inc		hl
		ld		a,(hl)
		cp		43				;CHeck for List Sort
		jp		nz,Quig_Content3
;Do list sort whatever		
		push	hl
		inc		hl
		inc		hl				;Not at ExtData
		ld		a,(hl)
		inc		hl
		ld		h,(hl)
		ld		l,a				;HL=Address of Extended List data
		
		ld		c,(hl)			;BC=Lines
		inc		hl
;		ld		b,(hl)
		inc		hl
		inc		hl
		inc		hl
		ld		e,(hl)			;DE=Location of Data
		inc		hl
		ld		d,(hl)
		inc		hl
		inc		hl
		inc		hl
		ld		b,(hl)			;Number of columns
		ex		de,hl
		;So HL=Addr data;BC Lines
.Quig_List_Stuff_Loop1		
		ld		a,c
		and		a
		jr		z,Quig_List_Stuff_Exit
		dec		c
		inc		hl
		inc		hl
		ld		a,b
.Quig_List_Stuff_Loop2		
		ld		e,(hl)
		inc		hl
		push	hl
		ld		d,(hl)
		dec		hl			;HL=Start of data again
		ex		de,hl
		
		dec		hl
		dec		hl
		dec		hl
		ld		(hl),d
		dec		hl
		ld		(hl),e
		
		pop		hl
		inc		hl
		dec		a
		jr		nz,Quig_List_Stuff_Loop2
		
		jr		Quig_List_Stuff_Loop1
		
.Quig_List_Stuff_Exit		
		pop		hl
.Quig_Content3:		
		ld		de,12
		add		hl,de
		ld		e,(hl)
		inc 	hl
		ld		d,(hl)
		Xor		a
		cp		e
		jp		nz,Quig_Content_Event_1
		cp		d
		jp		nz,Quig_Content_Event_1
		jp		Quig_Control_Loop
.Quig_Content_Event_1:
		Xor		a
		ld		(V_App_In_Use),a
		ld		(Quig_Content_Event_2+1),de
.Quig_Content_Event_2
		call	0		
		jp		Quig_Control_Loop_1	

;****                       ****		
;**** Shut down Application ****
;****                       ****		
.Quig_End:
		call	Quig_FormSearch
		ld		l,e
		call	Quig_Form_Close
		ld		a,(Quig_Form_No)
		and		a
		jp		z,Quig_End_X
		jp		Quig_Control_Loop_1
.Quig_End_X:		
		ld		a,(AppPrzN)
		db		#dd:ld l,a
		ld		a,(SysPrzN)
		db		#dd:ld h,a
		ld		a,(AppCodBeg+PrgPstNum)
		ld		h,a
		ld		l,MSC_SYS_PRGEND
		ld		(AppMsgB),hl
		ld		iy,AppMsgB
		rst		#10
.Quig_End_1
 		rst		#30
		jr		Quig_End_1
	
;****                  ****
;**** HL = Form Number
;****                  ****
.Quig_Form_Open:
		ld		a,l
		call 	Quig_Form_Return
		cp		255								;
		ret		nz								;**** If not clear then Return 
		push	hl
		ld		a,(Quig_Form_No)				;**** A = SymStudio Window Number			
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	Quig_GetWindowEventAddr			;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Window Data
		ld		a,(AppBnkNum)
		inclib 	SYDESKTOP.WINOPN
		call	SyDesktop_WINOPN
		pop		hl
		ret		c								;**** If Carry then hasn't Opened window
		ld		(hl),a							;**** Store Inetrnal number into form list
		ld		a,(Quig_Form_No)				;**** A = SymStudio Window Number
		ld		c,1								;**** C = 1 = Get Open Address
		call	SyB_Call_Form_Event
		Xor		a		
		ret
;****              ****		
;**** Close a Form ****
;****              ****
.Quig_Form_Close:	
		ld		a,l
		call	Quig_Form_Return
		cp		255
		ret		z
		push	hl
		ld 		c,MSC_DSK_WINCLS
        call 	SyDesktop_SendMessage
		pop		hl
		ld		a,255
		ld		(hl),a		
		ld		a,(Quig_Form_No)				;**** A = SymStudio Window Number
		ld		c,2								;**** C = 2 = Get Close Address
		call	SyB_Call_Form_Event
		ret

;**** Get a Internal Window number in a
;IN A = Window
;OUT A = Symbos Window number or #ff
;    HL =  address of Internal window stoe
.Quig_Form_Return
		ld		(Quig_Form_No),a				;**** Store the number of the Internal Window
		ld		hl,Quig_FormIDs					;**** Point to Start of Window List
		ld		e,a								;**** DE = A
		ld		d,0
		add		hl,de							;**** Calc Position
		ld		a,(hl)							;**** Checks if exists
		ret
;****                       ****
;**** Check If Event and Do ****
;****                       ****
;A=Form No C=Event To search
.SyB_Call_Form_Event:
		call	Quig_GetWindowEventAddr
		Xor		a
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		cp		e		
		jr		nz,SyB_Call_Form_Event_2	
		cp		d
		ret		z
.SyB_Call_Form_Event_2	
		ld		(SyB_Call_Form_Event_3+1),de
.SyB_Call_Form_Event_3
		call	0
		ret	
		
;****                                 ****
;**** Get User Form No fro OS Form No ****
;****                                 ****
.Quig_FormSearch:
		ld		a,(Event_Form_ID)
		ld		b,8
		ld		e,0
		ld		hl,Quig_FormIDs	
.Quig_FormSearch_1	
		cp		(hl)
		ret		z
		inc		e
		inc		hl
		djnz	Quig_FormSearch_1
		ret		

;******************************************************************************
;*** Name           System_CallFunction
;*** Input          ((SP+0)) = System manager command
;***                ((SP+1)) = Function ID
;***                AF,BC,DE,HL,IX,IY = Input for the function
;*** Output         AF,BC,DE,HL,IX,IY = Output from the function
;*** Destroyed      -
;*** Description    Calls a function via the system manager. This function is
;***                needed to have access to the file manager.
;******************************************************************************
.SySystem_CallFunction
		ld (AppMsgB+04),bc      ;copy registers into the message buffer
        ld (AppMsgB+06),de
        ld (AppMsgB+08),hl
        ld (AppMsgB+10),ix
        ld (AppMsgB+12),iy
        push af
        pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ld (AppMsgB+00),de      ;module und funktion number
        ld a,e
        ld (SyCallN),a
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #10                 ;send message
.SyCall1 rst #30
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #18                 ;wait for answer
        db #dd:dec l
        jr nz,SyCall1
        ld a,(AppMsgB)
        sub 128
        ld e,a
        ld a,(SyCallN)
        cp e
        jr nz,SyCall1
        ld hl,(AppMsgB+02)      ;get registers out of the message buffer
        push hl
        pop af
        ld bc,(AppMsgB+04)
        ld de,(AppMsgB+06)
        ld hl,(AppMsgB+08)
        ld ix,(AppMsgB+10)
        ld iy,(AppMsgB+12)
        ret
.SyCallN db 0		
		
;**** A = Window 0-7
;**** C = 0 = Data Begin Address
;****     1 = Open Event Address
;****     2 = Close Event Address
;****     3 = Resize Event Address
;****     4 = Main Loop Address
.Quig_GetWindowEventAddr
		add		a				;Times 2
		add		a				;Times 4
		add		a				;Times 8
		add		c				;Event
		add		a				;Times 16 + (Event*2)
		ld		hl,App_Form_List
		ld		e,a
		ld		d,0
		add		hl,de
		ret

.Quig_Form_No:				db	0
.Quig_FormIDs:				db  255,255,255,255,255,255,255,255

.Quig_Directory_Error_Byte:		db	0
.Quig_String_Buffer_Area_Start 	equ AppTrnEnd+260
.Quig_String_Buffer_Top			equ AppTrnEnd+260+AppTrnLen2
.Quig_String_Buffer_StackNo:	dw 0
.Quig_String_Buffer_Pos:		dw AppTrnEnd+260
.Quig_String_Buffer_Stack:		dw AppTrnEnd+260,0,0,0,0,0,0,0,0,0
.Quig_String_AS_HByte:			db 0
.Quig_String_Pos:				dw Quig_String_End_Text+4

		
.ErrorNum:					dw	0
.ErrorPC:					dw	0
.False:						db	0
.True:						db	1
.tcounter					dw	0


#IF USETIMER
.Quig_Timer_Code:
		ld		a,(Quig_Timer_On)
		and		a
		jp		nz,feet1
		rst		#30
		jp		Quig_Timer_Code
.feet1		
		di
.feet	jr		feet	

		
.Quig_Timer_On:				db	0
.Quig_Timer_Count:			dw	0
		
#ENDIF	
#IF USENET



;### SUB ROUTINES #############################################################
.snwmsgi_afbcdehlixiy
        ld (AppMsgB+10),ix   ;store registers to message buffer
        ld (AppMsgB+12),iy
.snwmsgi_afbcdehl
        ld (AppMsgB+04),bc
.snwmsgi_afdehl
        ld (AppMsgB+06),de
.snwmsgi_afhl
        ld (AppMsgB+08),hl
.snwmsgi_af
        push af:pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld a,(hl)               ;set command
        inc hl
        push hl
        ld (AppMsgB+0),a
        ld (snwmsg2+1),a
        ld iy,AppMsgB
        ld a,(AppPrzN)	;ld a,(App_PrcID)
        db #dd:ld l,a
        ld a,(Quig_Net_Process)
        db #dd:ld h,a
        ld (snwmsg1+2),ix
        rst #10                 ;send message
.snwmsg1 ld ix,0                 ;wait for response
        rst #08
        db #dd:dec l
        jr nz,snwmsg1
        ld a,(AppMsgB)
        sub 128
.snwmsg2 cp 0
        ret z
        ld	a,(AppPrzN)			;ld a,(App_PrcID)        ;wrong response code -> re-send and wait for correct one
        db #dd:ld h,a
        ld a,(Quig_Net_Process)
        db #dd:ld l,a
        rst #10
        rst #30
        jr snwmsg1
.snwmsgo_afbcdehlixiy
        ld ix,(AppMsgB+10)   ;get registers from the message buffer
        ld iy,(AppMsgB+12)
        ld de,(AppMsgB+06)
.snwmsgo_afbchl
        ld bc,(AppMsgB+04)
.snwmsgo_afhl
        ld hl,(AppMsgB+02)
        push hl
        pop af
        ld hl,(AppMsgB+08)
        ret
#ENDIF	
	
	